/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CrlCachePrettyPrint;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.CrlPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;

@WebServlet(name="camasterCADisplayCRL", urlPatterns={"/agent/ca/displayCRL"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/agent/ca/displayCRL.template"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="camasterCADisplayCRL"), @WebInitParam(name="resourceID", value="certServer.ca.crl"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr")})
public class DisplayCRL
extends CMSServlet {
    private static final long serialVersionUID = 1152016798229054027L;
    private static final String TPL_FILE = "displayCRL.template";
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ca/displayCRL.template";
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE_1", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String crlIssuingPointId = req.getParameter("crlIssuingPoint");
        this.process(argSet, header, req, resp, crlIssuingPointId, locale[0]);
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, HttpServletRequest req, HttpServletResponse resp, String crlIssuingPointId, Locale locale) {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CRLRepository crlRepository = engine.getCRLRepository();
        CRLIssuingPoint crlIP = null;
        X509CRLImpl crl = null;
        boolean clonedCA = false;
        boolean isCRLCacheEnabled = false;
        String masterHost = null;
        String masterPort = null;
        Vector<String> ipNames = null;
        String ipId = crlIssuingPointId;
        try {
            masterHost = cs.getString("master.ca.agent.host", "");
            masterPort = cs.getString("master.ca.agent.port", "");
            if (masterHost != null && masterHost.length() > 0 && masterPort != null && masterPort.length() > 0) {
                clonedCA = true;
                ipNames = crlRepository.getIssuingPointsNames();
            }
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (clonedCA) {
            if (crlIssuingPointId != null) {
                if (ipNames != null && ipNames.size() > 0) {
                    String ipName;
                    int i;
                    for (i = 0; i < ipNames.size() && !crlIssuingPointId.equals(ipName = (String)ipNames.elementAt(i)); ++i) {
                    }
                    if (i >= ipNames.size()) {
                        crlIssuingPointId = null;
                    }
                } else {
                    crlIssuingPointId = null;
                }
            }
        } else if (crlIssuingPointId != null) {
            Enumeration<CRLIssuingPoint> ips = Collections.enumeration(engine.getCRLIssuingPoints());
            while (ips.hasMoreElements()) {
                CRLIssuingPoint ip = ips.nextElement();
                if (crlIssuingPointId.equals(ip.getId())) {
                    crlIP = ip;
                    isCRLCacheEnabled = ip.isCRLCacheEnabled();
                    break;
                }
                if (ips.hasMoreElements()) continue;
                crlIssuingPointId = null;
            }
        }
        if (crlIssuingPointId == null) {
            header.addStringValue("error", "Request to unspecified or non-existing CRL issuing point: " + CMSTemplate.escapeJavaScriptStringHTML((String)ipId));
            return;
        }
        CRLIssuingPointRecord crlRecord = null;
        String crlDisplayType = req.getParameter("crlDisplayType");
        if (crlDisplayType == null) {
            crlDisplayType = "cachedCRL";
        }
        header.addStringValue("crlDisplayType", crlDisplayType);
        try {
            crlRecord = crlRepository.readCRLIssuingPointRecord(crlIssuingPointId);
        }
        catch (EBaseException e) {
            header.addStringValue("error", e.toString(locale));
            return;
        }
        if (crlRecord == null) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{crlIssuingPointId}));
            header.addStringValue("error", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_NOT_YET_UPDATED", (String[])new String[0])).toString());
            return;
        }
        header.addStringValue("crlIssuingPoint", crlIssuingPointId);
        if (crlDisplayType.equals("deltaCRL")) {
            if (clonedCA) {
                header.addStringValue("crlNumber", crlRecord.getDeltaCRLNumber().toString());
            } else {
                header.addStringValue("crlNumber", crlIP.getDeltaCRLNumber().toString());
            }
        } else if (clonedCA) {
            header.addStringValue("crlNumber", crlRecord.getCRLNumber().toString());
        } else {
            header.addStringValue("crlNumber", crlIP.getCRLNumber().toString());
        }
        long lCRLSize = crlRecord.getCRLSize();
        header.addLongValue("crlSize", lCRLSize);
        if (crlIP != null) {
            header.addStringValue("crlDescription", crlIP.getDescription());
        }
        if (!crlDisplayType.equals("cachedCRL")) {
            byte[] crlbytes = crlRecord.getCRL();
            if (crlbytes == null) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{crlIssuingPointId}));
                header.addStringValue("error", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_NOT_YET_UPDATED", (String[])new String[0])).toString());
                return;
            }
            try {
                crl = crlDisplayType.equals("crlHeader") ? new X509CRLImpl(crlbytes, false) : new X509CRLImpl(crlbytes);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                header.addStringValue("error", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0])).toString());
            }
        }
        if (crl != null || isCRLCacheEnabled && crlDisplayType.equals("cachedCRL")) {
            if (crlDisplayType.equals("entireCRL") || crlDisplayType.equals("cachedCRL")) {
                crlDetails = null;
                crlDetails = crlDisplayType.equals("entireCRL") ? new CrlPrettyPrint(crl) : new CrlCachePrettyPrint(crlIP);
                String pageStart = req.getParameter("pageStart");
                String pageSize = req.getParameter("pageSize");
                if (pageStart != null && pageSize != null) {
                    long lPageStart = 0L;
                    long lPageSize = 0L;
                    try {
                        lPageStart = Long.valueOf(pageStart);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        lPageSize = Long.valueOf(pageSize);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lPageStart < 1L) {
                        lPageStart = 1L;
                    }
                    if (lPageSize < 1L) {
                        lPageSize = 10L;
                    }
                    header.addStringValue("crlPrettyPrint", crlDetails.toString(locale, lCRLSize, lPageStart, lPageSize));
                    header.addLongValue("pageStart", lPageStart);
                    header.addLongValue("pageSize", lPageSize);
                } else {
                    header.addStringValue("crlPrettyPrint", crlDetails.toString(locale));
                }
            } else if (crlDisplayType.equals("crlHeader")) {
                crlDetails = new CrlPrettyPrint(crl);
                header.addStringValue("crlPrettyPrint", crlDetails.toString(locale, lCRLSize, 0L, 0L));
            } else if (crlDisplayType.equals("base64Encoded")) {
                try {
                    byte[] ba = crl.getEncoded();
                    String crlBase64Encoded = Utils.base64encode((byte[])ba, (boolean)true);
                    int length = crlBase64Encoded.length();
                    int i = 0;
                    int j = 0;
                    int n = 1;
                    while (i < length) {
                        ArgBlock rarg;
                        int k = crlBase64Encoded.indexOf(10, i);
                        if (n < 100 && k > -1) {
                            ++n;
                            i = k + 1;
                            if (i < length) continue;
                            rarg = new ArgBlock();
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                            argSet.addRepeatRecord(rarg);
                            continue;
                        }
                        n = 1;
                        rarg = new ArgBlock();
                        if (k > -1) {
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                            j = i = k + 1;
                        } else {
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, length));
                            i = length;
                        }
                        argSet.addRepeatRecord(rarg);
                    }
                }
                catch (CRLException ba) {}
            } else if (crlDisplayType.equals("deltaCRL")) {
                if (clonedCA && crlRecord.getDeltaCRLSize() != null && crlRecord.getDeltaCRLSize() > -1L || crlIP != null && crlIP.isDeltaCRLEnabled()) {
                    byte[] deltaCRLBytes = crlRecord.getDeltaCRL();
                    if (deltaCRLBytes == null) {
                        logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_NO_DELTA_CRL", (Object[])new Object[]{crlIssuingPointId}));
                        header.addStringValue("error", "Delta CRL is not available");
                    } else {
                        X509CRLImpl deltaCRL = null;
                        try {
                            deltaCRL = new X509CRLImpl(deltaCRLBytes);
                        }
                        catch (Exception e) {
                            logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_DECODE_DELTA_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                            header.addStringValue("error", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0])).toString());
                        }
                        if (deltaCRL != null) {
                            BigInteger crlNumber = crlRecord.getCRLNumber();
                            BigInteger deltaNumber = crlRecord.getDeltaCRLNumber();
                            if (clonedCA && crlNumber != null && deltaNumber != null && deltaNumber.compareTo(crlNumber) >= 0 || crlIP != null && crlIP.isThisCurrentDeltaCRL(deltaCRL)) {
                                header.addIntegerValue("deltaCRLSize", deltaCRL.getNumberOfRevokedCertificates());
                                CrlPrettyPrint crlDetails = new CrlPrettyPrint(deltaCRL);
                                header.addStringValue("crlPrettyPrint", crlDetails.toString(locale, 0L, 0L, 0L));
                                try {
                                    byte[] ba = deltaCRL.getEncoded();
                                    String crlBase64Encoded = Utils.base64encode((byte[])ba, (boolean)true);
                                    int length = crlBase64Encoded.length();
                                    int i = 0;
                                    int j = 0;
                                    int n = 1;
                                    while (i < length) {
                                        ArgBlock rarg;
                                        int k = crlBase64Encoded.indexOf(10, i);
                                        if (n < 100 && k > -1) {
                                            ++n;
                                            i = k + 1;
                                            if (i < length) continue;
                                            rarg = new ArgBlock();
                                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                                            argSet.addRepeatRecord(rarg);
                                            continue;
                                        }
                                        n = 1;
                                        rarg = new ArgBlock();
                                        if (k > -1) {
                                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                                            j = i = k + 1;
                                        } else {
                                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, length));
                                            i = length;
                                        }
                                        argSet.addRepeatRecord(rarg);
                                    }
                                }
                                catch (CRLException cRLException) {}
                            } else {
                                header.addStringValue("error", "Current Delta CRL is not available.");
                            }
                        }
                    }
                } else {
                    header.addStringValue("error", "Delta CRL is not enabled for " + crlIssuingPointId + " issuing point");
                }
            }
        } else if (!isCRLCacheEnabled && crlDisplayType.equals("cachedCRL")) {
            header.addStringValue("error", CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_CACHE_IS_NOT_ENABLED", (String[])new String[]{crlIssuingPointId}));
            header.addStringValue("crlPrettyPrint", CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_CACHE_IS_NOT_ENABLED", (String[])new String[]{crlIssuingPointId}));
        } else {
            header.addStringValue("error", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0])).toString());
            header.addStringValue("crlPrettyPrint", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0])).toString());
        }
    }
}

