/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CertUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetCAChain", urlPatterns={"/ee/ca/getCAChain"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/ee/ca/displayCaCert.template"), @WebInitParam(name="ID", value="caGetCAChain"), @WebInitParam(name="resourceID", value="certServer.ee.certchain"), @WebInitParam(name="interface", value="ee")})
public class GetCAChain
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetCAChain.class);
    private static final long serialVersionUID = -8189048155415074581L;
    private static final String TPL_FILE = "displayCaCert.template";
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mFormPath = "/ca/displayCaCert.template";
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        ArgBlock args = cmsReq.getHttpParams();
        String op = null;
        op = args.getValueAsString("op", null);
        if (op == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_OPTIONS_SELECTED", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_OPTIONS_SELECTED", (String[])new String[0]));
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
        AuthzToken authzToken = null;
        if (op.startsWith("download")) {
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "download");
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            this.downloadChain(op, args, httpReq, httpResp, cmsReq);
        } else if (op.startsWith("display")) {
            try {
                authzToken = this.mAuthz.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            this.displayChain(op, args, httpReq, httpResp, cmsReq);
        } else {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_OPTIONS_CA_CHAIN", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_OPTIONS_SELECTED", (String[])new String[0]));
        }
    }

    private void downloadChain(String op, ArgBlock args, HttpServletRequest httpReq, HttpServletResponse httpResp, CMSRequest cmsReq) throws EBaseException {
        byte[] bytes = null;
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        if (GetCAChain.clientIsMSIE((HttpServletRequest)httpReq) && (op.equals("download") || op.equals("downloadBIN"))) {
            X509Certificate[] caCerts = ca.getCACertChain().getChain();
            try {
                bytes = caCerts[0].getEncoded();
            }
            catch (CertificateEncodingException e) {
                cmsReq.setStatus(CMSRequest.ERROR);
                logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_GETTING_CACERT_ENCODED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_GETTING_CA_CERT_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
        CertificateChain certChain = ca.getCACertChain();
        if (certChain == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_CA_CHAIN_EMPTY", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CA_CHAIN_EMPTY", (String[])new String[0]));
        }
        try {
            ByteArrayOutputStream encoded = new ByteArrayOutputStream();
            certChain.encode((OutputStream)encoded, false);
            bytes = encoded.toByteArray();
        }
        catch (IOException e) {
            cmsReq.setStatus(CMSRequest.ERROR);
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_CA_CHAIN_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCODING_CA_CHAIN_ERROR", (String[])new String[0]), (Exception)e);
        }
        String mimeType = null;
        if (op.equals("downloadBIN")) {
            mimeType = "application/octet-stream";
        } else {
            try {
                mimeType = args.getValueAsString("mimeType");
            }
            catch (EBaseException e) {
                mimeType = "application/octet-stream";
            }
        }
        try {
            if (op.equals("downloadBIN")) {
                if (GetCAChain.clientIsMSIE((HttpServletRequest)httpReq)) {
                    httpResp.setHeader("Content-disposition", "attachment; filename=ca.cer");
                } else {
                    httpResp.setHeader("Content-disposition", "attachment; filename=ca.p7c");
                }
            }
            httpResp.setContentType(mimeType);
            httpResp.getOutputStream().write(bytes);
            httpResp.setContentLength(bytes.length);
            httpResp.getOutputStream().flush();
        }
        catch (IOException e) {
            cmsReq.setStatus(CMSRequest.ERROR);
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAYING_CACHAIN_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAYING_CACHAIN_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void displayChain(String op, ArgBlock args, HttpServletRequest httpReq, HttpServletResponse httpResp, CMSRequest cmsReq) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CertificateChain certChain = ca.getCACertChain();
        if (certChain == null) {
            cmsReq.setStatus(CMSRequest.ERROR);
            logger.error(CMS.getLogMessage((String)"CMSGW_CA_CHAIN_NOT_AVAILABLE", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CA_CHAIN_NOT_AVAILABLE", (String[])new String[0]));
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            form = this.getTemplate(this.mFormPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            cmsReq.setError((EBaseException)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String displayFormat = null;
        if (op.equals("displayIND")) {
            displayFormat = "individual";
        } else {
            try {
                displayFormat = args.getValueAsString("displayFormat");
            }
            catch (EBaseException e) {
                displayFormat = "chain";
            }
        }
        header.addStringValue("displayFormat", displayFormat);
        if (displayFormat.equals("chain")) {
            String subjectdn = null;
            byte[] bytes = null;
            try {
                subjectdn = certChain.getFirstCertificate().getSubjectDN().toString();
                ByteArrayOutputStream encoded = new ByteArrayOutputStream();
                certChain.encode((OutputStream)encoded);
                bytes = encoded.toByteArray();
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_CA_CHAIN_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCODING_CA_CHAIN_ERROR", (String[])new String[0]), (Exception)e);
            }
            String chainBase64 = this.getBase64(bytes);
            header.addStringValue("subjectdn", subjectdn);
            header.addStringValue("chainBase64", chainBase64);
        } else {
            try {
                X509Certificate[] certs = certChain.getChain();
                header.addIntegerValue("length", certs.length);
                locale[0] = this.getLocale(httpReq);
                for (int i = 0; i < certs.length; ++i) {
                    byte[] bytes = null;
                    try {
                        bytes = certs[i].getEncoded();
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException("Internal Error");
                    }
                    String subjectdn = certs[i].getSubjectDN().toString();
                    String finger = null;
                    try {
                        finger = CertUtils.getFingerPrints((Certificate)certs[i]);
                    }
                    catch (Exception e) {
                        throw new IOException("Internal Error");
                    }
                    CertPrettyPrint certDetails = new CertPrettyPrint((Certificate)certs[i]);
                    ArgBlock rarg = new ArgBlock();
                    rarg.addStringValue("fingerprints", finger);
                    rarg.addStringValue("subjectdn", subjectdn);
                    rarg.addStringValue("base64", this.getBase64(bytes));
                    rarg.addStringValue("certDetails", certDetails.toString(locale[0]));
                    argSet.addRepeatRecord(rarg);
                }
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAYING_CACHAIN_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAYING_CACHAIN_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
        try {
            ServletOutputStream out = httpResp.getOutputStream();
            httpResp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{"", e.toString()}), (Throwable)e);
            cmsReq.setError((EBaseException)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e));
            cmsReq.setStatus(CMSRequest.ERROR);
        }
    }

    private String getBase64(byte[] certBytes) {
        String certBase64 = Utils.base64encode((byte[])certBytes, (boolean)true);
        return certBase64;
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }
}

