/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cmscore.base.ArgBlock;
import java.security.cert.Certificate;
import java.util.Locale;

class RAReqCompletedFiller
extends ImportCertsTemplateFiller {
    private static final String RA_AGENT_GROUP = "Registration Manager Agents";
    private static final String KRA_AGENT_GROUP = "Data Recovery Manager Agents";

    @Override
    public CMSTemplateParams getTemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) throws Exception {
        Object[] results = (Object[])cmsReq.getResult();
        Object grantError = results[1];
        Certificate[] issuedCerts = (Certificate[])results[0];
        cmsReq.setResult((Object)issuedCerts);
        CMSTemplateParams params = super.getTemplateParams(cmsReq, authority, locale, e);
        if (grantError != null) {
            ArgBlock header = params.getHeader();
            if (grantError instanceof String) {
                header.addStringValue("grantError", (String)grantError);
            } else {
                EBaseException ex = (EBaseException)((Object)grantError);
                header.addStringValue("grantError", ex.toString(locale));
            }
            ArgBlock httpParams = cmsReq.getHttpParams();
            String uid = httpParams.getValueAsString("grantUID", null);
            header.addStringValue("grantUID", uid);
            boolean grantRMAgent = httpParams.getValueAsBoolean("grantRMAgentPrivilege", false);
            boolean grantDRMAgent = httpParams.getValueAsBoolean("grantDRMAgentPrivilege", false);
            Object privilege = null;
            if (grantRMAgent) {
                privilege = RA_AGENT_GROUP;
            }
            if (grantDRMAgent) {
                privilege = privilege != null ? (String)privilege + " and Data Recovery Manager Agents" : KRA_AGENT_GROUP;
            }
            header.addStringValue("grantPrivilege", (String)privilege);
        }
        return params;
    }
}

