/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertificatePair;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossCertPairSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(CrossCertPairSubsystem.class);
    public static final String ID = "CrossCertPair";
    public static final String DN_XCERTS = "cn=crossCerts";
    public static final String LDAP_ATTR_CA_CERT = "caCertificate;binary";
    public static final String LDAP_ATTR_XCERT_PAIR = "crossCertificatePair;binary";
    protected static final String PROP_LDAP = "ldap";
    protected ConfigStore mConfig;
    protected LdapBoundConnFactory mLdapConnFactory = null;
    protected String mBaseDN = null;
    protected CAPublisherProcessor mPublisherProcessor;
    private String mId = "CrossCertPair";

    public String getId() {
        return this.mId;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConfigStore config) throws Exception {
        logger.debug("CrossCertPairSubsystem: initializing");
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        try {
            this.mConfig = config;
            CrossCertPairSubsystem crossCertPairSubsystem = this;
            synchronized (crossCertPairSubsystem) {
                this.mPublisherProcessor = caEngine.getPublisherProcessor();
            }
            LDAPConfig ldapConfig = (LDAPConfig)this.mConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
            if (ldapConfig == null) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_DBS_CONF_ERROR", (Object[])new Object[]{PROP_LDAP}));
                return;
            }
            this.mBaseDN = ldapConfig.getBaseDN();
            this.mLdapConnFactory = new LdapBoundConnFactory("CrossCertPairSubsystem");
            this.mLdapConnFactory.setCMSEngine(this.engine);
            PKISocketConfig socketConfig = cs.getSocketConfig();
            this.mLdapConnFactory.init(socketConfig, ldapConfig, this.engine.getPasswordStore());
        }
        catch (EBaseException e) {
            logger.error("CrossCertPairSubsystem: Unable to initialize subsystem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("CrossCertPairSubsystem: initialization complete");
    }

    public void importCert(byte[] certBytes) throws EBaseException {
        logger.debug("CrossCertPairSubsystem: importCert(byte[])");
        X509Certificate cert = null;
        try {
            cert = this.byteArray2X509Cert(certBytes);
        }
        catch (CertificateException e) {
            throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString());
        }
        this.importCert(cert);
    }

    public synchronized void importCert(Object certObj) throws EBaseException {
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        logger.debug("CrossCertPairSubsystem: in importCert(Object)");
        X509Certificate cert = (X509Certificate)certObj;
        LDAPConnection conn = null;
        try {
            conn = this.getConn();
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, DN_XCERTS, null, false);
            if (res.hasMoreElements()) {
                logger.info("CrossCertPairSubsystem: ldap search found cn=crossCerts");
                LDAPEntry entry = (LDAPEntry)res.nextElement();
                LDAPAttribute caCerts = entry.getAttribute(LDAP_ATTR_CA_CERT);
                LDAPAttribute certPairs = entry.getAttribute(LDAP_ATTR_XCERT_PAIR);
                if (caCerts == null) {
                    logger.debug("CrossCertPairSubsystem: no existing ca certs, just import");
                    this.addCAcert(conn, cert.getEncoded());
                    return;
                }
                Enumeration en = caCerts.getByteValues();
                if (en == null || !en.hasMoreElements()) {
                    logger.debug("CrossCertPairSubsystem: 1st potential xcert");
                    this.addCAcert(conn, cert.getEncoded());
                    logger.debug("CrossCertPairSubsystem: potential cross ca cert added to crossCerts entry successfully");
                    return;
                }
                byte[] val = null;
                boolean match = false;
                while (en.hasMoreElements()) {
                    X509Certificate inCert;
                    val = (byte[])en.nextElement();
                    logger.debug("CrossCertPairSubsystem: val =" + val.length);
                    if (val.length == 0 || !this.arePair(inCert = this.byteArray2X509Cert(val), cert)) continue;
                    logger.debug("CrossCertPairSubsystem: found a pair!");
                    CertificatePair cp = new CertificatePair(inCert, cert);
                    this.addXCertPair(conn, certPairs, cp);
                    this.deleteCAcert(conn, inCert.getEncoded());
                    match = true;
                    break;
                }
                if (!match) {
                    logger.debug("CrossCertPairSubsystem: didn't find a pair!");
                    this.addCAcert(conn, cert.getEncoded());
                    logger.debug("CrossCertPairSubsystem: potential cross ca cert added to crossCerts entry successfully");
                }
            } else {
                logger.info("CrossCertPairSubsystem: ldap search found no cn=crossCerts");
            }
        }
        catch (IOException e) {
            throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString(), (Throwable)e);
        }
        catch (LDAPException e) {
            logger.error("CrossCertPairSubsystem: " + e.getMessage(), (Throwable)e);
            throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString(), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.error("CrossCertPairSubsystem: " + e.getMessage(), (Throwable)e);
            throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString(), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error("CrossCertPairSubsystem: " + e.getMessage(), (Throwable)e);
            throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString(), (Throwable)e);
        }
        finally {
            try {
                this.returnConn(conn);
            }
            catch (ELdapException e) {
                logger.error("CrossCertPairSubsystem: " + e.getMessage(), (Throwable)e);
                throw new EBaseException("CrossCertPairSubsystem: importCert() failed:" + e.toString());
            }
        }
        logger.debug("CrossCertPairSubsystem: importCert(Object) completed");
    }

    protected boolean arePair(X509Certificate cert1, X509Certificate cert2) {
        return cert1.getIssuerDN().equals(cert2.getSubjectDN()) && cert2.getIssuerDN().equals(cert1.getSubjectDN());
    }

    public X509Certificate byteArray2X509Cert(byte[] certBytes) throws CertificateException {
        logger.debug("CrossCertPairSubsystem: in bytearray2X509Cert()");
        ByteArrayInputStream inStream = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        logger.debug("CrossCertPairSubsystem: done bytearray2X509Cert()");
        return cert;
    }

    public synchronized void addXCertPair(LDAPConnection conn, LDAPAttribute certPairs, CertificatePair pair) throws LDAPException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        pair.encode(bos);
        if (CrossCertPairSubsystem.ByteValueExists(certPairs, bos.toByteArray())) {
            logger.debug("CrossCertPairSubsystem: cross cert pair exists in internal db, don't add again");
            return;
        }
        LDAPModificationSet modSet = new LDAPModificationSet();
        modSet.add(0, new LDAPAttribute(LDAP_ATTR_XCERT_PAIR, bos.toByteArray()));
        conn.modify("cn=crossCerts," + this.mBaseDN, modSet);
    }

    public static boolean ByteValueExists(LDAPAttribute attr, byte[] bval) {
        if (attr == null) {
            return false;
        }
        Enumeration vals = attr.getByteValues();
        byte[] val = null;
        while (vals.hasMoreElements()) {
            val = (byte[])vals.nextElement();
            if (val.length == 0 || !CrossCertPairSubsystem.byteArraysAreEqual(val, bval)) continue;
            return true;
        }
        return false;
    }

    public static boolean byteArraysAreEqual(byte[] a, byte[] b) {
        logger.debug("CrossCertPairSubsystem: in byteArraysAreEqual()");
        if (a.length != b.length) {
            logger.debug("CrossCertPairSubsystem: exiting byteArraysAreEqual(): false");
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            logger.debug("CrossCertPairSubsystem: exiting byteArraysAreEqual(): false");
            return false;
        }
        logger.debug("CrossCertPairSubsystem: exiting byteArraysAreEqual(): true");
        return true;
    }

    public synchronized void addCAcert(LDAPConnection conn, byte[] certEnc) throws LDAPException {
        LDAPModificationSet modSet = new LDAPModificationSet();
        modSet.add(0, new LDAPAttribute(LDAP_ATTR_CA_CERT, certEnc));
        conn.modify("cn=crossCerts," + this.mBaseDN, modSet);
    }

    public synchronized void deleteCAcert(LDAPConnection conn, byte[] certEnc) throws LDAPException {
        LDAPModificationSet modSet = new LDAPModificationSet();
        modSet.add(1, new LDAPAttribute(LDAP_ATTR_CA_CERT, certEnc));
        conn.modify("cn=crossCerts," + this.mBaseDN, modSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void publishCertPairs() throws EBaseException {
        LDAPConnection conn = null;
        if (this.mPublisherProcessor == null) return;
        if (!this.mPublisherProcessor.isCertPublishingEnabled()) {
            return;
        }
        try {
            conn = this.getConn();
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, DN_XCERTS, null, false);
            logger.debug("CrossCertPairSubsystem: trying to publish cert pairs, if any");
            if (res == null || !res.hasMoreElements()) {
                logger.debug("CrossCertPairSubsystem: no cross cert pairs to publish");
                return;
            }
            if (!res.hasMoreElements()) return;
            logger.info("CrossCertPairSubsystem: ldap search found cn=crossCerts");
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            LDAPAttribute xcerts = entry.getAttribute(LDAP_ATTR_XCERT_PAIR);
            if (xcerts == null) {
                logger.debug("CrossCertPairSubsystem: no cross cert pairs to publish");
                return;
            }
            Enumeration en = xcerts.getByteValues();
            if (en == null || !en.hasMoreElements()) {
                logger.debug("CrossCertPairSubsystem: publishCertPair found no pairs in internal db");
                return;
            }
            byte[] val = null;
            while (en.hasMoreElements()) {
                val = (byte[])en.nextElement();
                logger.debug("CrossCertPairSubsystem: val =" + val.length);
                if (val.length == 0) continue;
                try {
                    this.mPublisherProcessor.publishXCertPair(val);
                }
                catch (Exception e) {
                    throw new EBaseException("CrossCertPairSubsystem: publishCertPairs() failed:" + e.toString());
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new EBaseException("CrossCertPairSubsystem: publishCertPairs() failed:" + e.toString());
        }
    }

    protected LDAPConnection getConn() throws ELdapException {
        if (this.mLdapConnFactory != null) {
            LDAPConnection conn = this.mLdapConnFactory.getConn();
            if (conn == null) {
                throw new ELdapException("No Ldap Connection Available");
            }
            return conn;
        }
        throw new ELdapException("Ldap Connection Factory is null");
    }

    protected void returnConn(LDAPConnection conn) throws ELdapException {
        if (this.mLdapConnFactory != null) {
            this.mLdapConnFactory.returnConn(conn);
        }
    }

    public void startup() throws EBaseException {
    }

    public synchronized void shutdown() {
        if (this.mLdapConnFactory != null) {
            try {
                this.mLdapConnFactory.reset();
            }
            catch (ELdapException e) {
                logger.warn("CrossCertPairSubsystem shutdown exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }
}

