/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceType;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.tenant.TenantResourceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class TenantConfiguration {
    private Map<ResourceType, Constraint> constraints = new HashMap<ResourceType, Constraint>();

    public TenantConfiguration() {
    }

    public TenantConfiguration(int n, long l) {
        this.limitCpuShares(n);
        this.limitHeap(l);
    }

    public TenantConfiguration(long l) {
        this.limitHeap(l);
    }

    public TenantConfiguration(Iterable<Constraint> iterable) {
        if (iterable != null) {
            for (Constraint constraint : iterable) {
                this.constraints.put(constraint.getResourceType(), constraint);
            }
        }
    }

    public TenantConfiguration limitCpuCfs(int n, int n2) {
        if (!TenantGlobals.isCpuThrottlingEnabled()) {
            throw new UnsupportedOperationException("-XX:+TenantCpuThrottling is not enabled");
        }
        this.constraints.put(TenantResourceType.CPU_CFS, TenantResourceType.CPU_CFS.newConstraint(n, n2));
        return this;
    }

    public TenantConfiguration limitCpuShares(int n) {
        if (!TenantGlobals.isCpuThrottlingEnabled()) {
            System.err.println("WARNING: -XX:+TenantCpuThrottling is disabled!");
        }
        this.constraints.put(TenantResourceType.CPU_SHARES, TenantResourceType.CPU_SHARES.newConstraint(n));
        return this;
    }

    public TenantConfiguration limitCpuSet(String string) {
        if (!TenantGlobals.isCpuThrottlingEnabled()) {
            throw new UnsupportedOperationException("-XX:+TenantCpuThrottling is not enabled");
        }
        this.constraints.put(TenantResourceType.CPUSET_CPUS, TenantResourceType.CPUSET_CPUS.newConstraint(this.parseCpuSetString(string)));
        return this;
    }

    private long[] parseCpuSetString(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return Stream.of(string2.split(",")).flatMapToLong(string -> {
            if (string.contains("-")) {
                List list = Stream.of(string.split("-")).map(Long::parseLong).collect(Collectors.toList());
                return LongStream.range((Long)list.get(0), (Long)list.get(1) + 1L);
            }
            return LongStream.of(Long.parseLong(string));
        }).toArray();
    }

    public TenantConfiguration limitHeap(long l) {
        if (!TenantGlobals.isHeapThrottlingEnabled()) {
            System.err.println("WARNING: -XX:+TenantHeapThrottling not enabled!");
        }
        this.constraints.put(TenantResourceType.HEAP_RETAINED, TenantResourceType.HEAP_RETAINED.newConstraint(l));
        return this;
    }

    Collection<Constraint> getAllConstraints() {
        return this.constraints.values();
    }

    void setConstraint(Constraint constraint) {
        this.constraints.put(constraint.getResourceType(), constraint);
    }

    public long getMaxHeap() {
        if (this.constraints.containsKey(TenantResourceType.HEAP_RETAINED)) {
            return this.constraints.get(TenantResourceType.HEAP_RETAINED).getValues()[0];
        }
        return Runtime.getRuntime().maxMemory();
    }

    public int getMaxCpuPercent() {
        if (this.constraints.containsKey(TenantResourceType.CPU_CFS)) {
            Constraint constraint = this.constraints.get(TenantResourceType.CPU_CFS);
            int n = (int)constraint.getValues()[0];
            int n2 = (int)constraint.getValues()[1];
            if (n > 0 && n2 > 0) {
                return (int)((float)n2 / (float)n * 100.0f);
            }
        }
        return -1;
    }

    public int getCpuShares() {
        if (this.constraints.containsKey(TenantResourceType.CPU_SHARES)) {
            return (int)this.constraints.get(TenantResourceType.CPU_SHARES).getValues()[0];
        }
        return 0;
    }
}

