/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.amd64.BsdAMD64CFrame;
import sun.jvm.hotspot.debugger.bsd.x86.BsdX86CFrame;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

class BsdCDebugger
implements CDebugger {
    private BsdDebugger dbg;

    BsdCDebugger(BsdDebugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        Object[] arr = objs.toArray();
        int mid = -1;
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            LoadObject midVal = (LoadObject)arr[mid];
            long cmp = pc.minus(midVal.getBase());
            if (cmp < 0L) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0L) {
                long size = midVal.getSize();
                if (cmp >= size) {
                    low = mid + 1;
                    continue;
                }
                return (LoadObject)arr[mid];
            }
            return (LoadObject)arr[mid];
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        String cpu = this.dbg.getCPU();
        if (cpu.equals("x86")) {
            X86ThreadContext context = (X86ThreadContext)thread.getContext();
            Address ebp = context.getRegisterAsAddress(6);
            if (ebp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(14);
            if (pc == null) {
                return null;
            }
            return new BsdX86CFrame(this.dbg, ebp, pc);
        }
        if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
            Address rbp = context.getRegisterAsAddress(10);
            if (rbp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(17);
            if (pc == null) {
                return null;
            }
            return new BsdAMD64CFrame(this.dbg, rbp, pc);
        }
        throw new DebuggerException(cpu + " is not yet supported");
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    @Override
    public boolean canDemangle() {
        return false;
    }

    @Override
    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }
}

