#!/usr/bin/python
# vim:fileencoding=utf-8:sw=4:et

# auto-generated by “generate-chinese-variants.py”, do not edit here!
#
# Copyright (c) 2013 Mike FABIAN <mfabian@redhat.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 3.0 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
if sys.version_info < (3, 0, 0):
    reload (sys)
    sys.setdefaultencoding('utf-8')

variants_table = {
    # Meaning of the bits in the values:
    # 1 = 1 << 0       simplified Chinese
    # 2 = 1 << 1       traditional Chinese
    # 3 = (1 | 1 << 1) used both in simplified *and* traditional Chinese
    # 4 = 1 << 2       mixture of simplified and traditional Chinese
    u'〇': 3,
    u'㐽': 1,
    u'㑇': 1,
    u'㑈': 1,
    u'㑔': 1,
    u'㑩': 1,
    u'㑯': 2,
    u'㑳': 2,
    u'㒓': 2,
    u'㓥': 1,
    u'㓨': 2,
    u'㔉': 1,
    u'㖊': 1,
    u'㖞': 1,
    u'㗲': 2,
    u'㘎': 1,
    u'㘚': 2,
    u'㚯': 1,
    u'㛀': 1,
    u'㛟': 1,
    u'㛠': 1,
    u'㛣': 1,
    u'㛤': 1,
    u'㛿': 1,
    u'㜄': 2,
    u'㜏': 2,
    u'㜢': 2,
    u'㜷': 2,
    u'㞞': 2,
    u'㟆': 1,
    u'㟜': 1,
    u'㠏': 2,
    u'㢝': 2,
    u'㤘': 1,
    u'㥮': 2,
    u'㦎': 2,
    u'㧏': 1,
    u'㧐': 1,
    u'㧑': 1,
    u'㧟': 1,
    u'㧰': 1,
    u'㨫': 1,
    u'㩜': 2,
    u'㩳': 2,
    u'㭎': 1,
    u'㭏': 1,
    u'㭣': 1,
    u'㭤': 1,
    u'㭴': 1,
    u'㱩': 1,
    u'㱮': 1,
    u'㲿': 1,
    u'㳔': 1,
    u'㳕': 1,
    u'㳠': 1,
    u'㳡': 1,
    u'㳢': 1,
    u'㳽': 1,
    u'㶉': 1,
    u'㶶': 1,
    u'㶽': 1,
    u'㷿': 2,
    u'㺍': 1,
    u'㺏': 2,
    u'㻅': 1,
    u'㻏': 1,
    u'㻘': 1,
    u'㿧': 2,
    u'䀥': 1,
    u'䀹': 2,
    u'䁖': 1,
    u'䁪': 2,
    u'䁻': 2,
    u'䂵': 1,
    u'䅉': 1,
    u'䅪': 1,
    u'䇲': 1,
    u'䉙': 2,
    u'䉤': 1,
    u'䉬': 2,
    u'䉲': 2,
    u'䊭': 2,
    u'䊷': 2,
    u'䋙': 2,
    u'䋚': 2,
    u'䋻': 2,
    u'䋿': 2,
    u'䌈': 2,
    u'䌋': 2,
    u'䌖': 2,
    u'䌝': 2,
    u'䌟': 2,
    u'䌥': 2,
    u'䌰': 2,
    u'䌶': 1,
    u'䌷': 1,
    u'䌸': 1,
    u'䌹': 1,
    u'䌺': 1,
    u'䌻': 1,
    u'䌼': 1,
    u'䌽': 1,
    u'䌾': 1,
    u'䍀': 1,
    u'䍁': 1,
    u'䓕': 1,
    u'䕳': 2,
    u'䗖': 1,
    u'䗿': 2,
    u'䘛': 1,
    u'䘞': 1,
    u'䙊': 1,
    u'䙌': 1,
    u'䙓': 1,
    u'䙡': 2,
    u'䜀': 2,
    u'䜣': 1,
    u'䜤': 1,
    u'䜥': 1,
    u'䜧': 1,
    u'䜩': 1,
    u'䝙': 1,
    u'䝻': 2,
    u'䝼': 2,
    u'䞈': 2,
    u'䞌': 1,
    u'䞍': 1,
    u'䞎': 1,
    u'䞐': 1,
    u'䟢': 1,
    u'䢀': 1,
    u'䢁': 1,
    u'䢂': 1,
    u'䢨': 2,
    u'䥇': 2,
    u'䥑': 2,
    u'䥩': 2,
    u'䥱': 2,
    u'䥺': 1,
    u'䥽': 1,
    u'䥾': 1,
    u'䥿': 1,
    u'䦀': 1,
    u'䦁': 1,
    u'䦂': 1,
    u'䦃': 1,
    u'䦅': 1,
    u'䦘': 2,
    u'䦛': 2,
    u'䦟': 2,
    u'䦳': 2,
    u'䦶': 1,
    u'䦷': 1,
    u'䧢': 2,
    u'䪏': 2,
    u'䪗': 2,
    u'䪘': 2,
    u'䫴': 2,
    u'䬘': 2,
    u'䬝': 2,
    u'䬞': 2,
    u'䭀': 2,
    u'䭃': 2,
    u'䭪': 1,
    u'䭿': 2,
    u'䮝': 2,
    u'䮞': 2,
    u'䮠': 2,
    u'䮫': 2,
    u'䮳': 2,
    u'䮾': 2,
    u'䯀': 2,
    u'䯃': 1,
    u'䯄': 1,
    u'䯅': 1,
    u'䰾': 2,
    u'䱙': 2,
    u'䱬': 2,
    u'䱰': 2,
    u'䱷': 2,
    u'䱽': 2,
    u'䲁': 2,
    u'䲖': 2,
    u'䲝': 1,
    u'䲞': 1,
    u'䲟': 1,
    u'䲠': 1,
    u'䲡': 1,
    u'䲢': 1,
    u'䲣': 1,
    u'䲤': 1,
    u'䲰': 2,
    u'䴉': 2,
    u'䴓': 1,
    u'䴔': 1,
    u'䴕': 1,
    u'䴖': 1,
    u'䴗': 1,
    u'䴘': 1,
    u'䴙': 1,
    u'䴬': 2,
    u'䴴': 2,
    u'䶮': 1,
    u'万': 1,
    u'与': 1,
    u'丑': 1,
    u'专': 1,
    u'业': 1,
    u'丛': 1,
    u'东': 1,
    u'丝': 1,
    u'丟': 2,
    u'丢': 1,
    u'两': 1,
    u'严': 1,
    u'並': 2,
    u'丧': 1,
    u'个': 1,
    u'丰': 1,
    u'临': 1,
    u'为': 1,
    u'丽': 1,
    u'举': 1,
    u'么': 1,
    u'义': 1,
    u'乌': 1,
    u'乐': 1,
    u'乔': 1,
    u'习': 1,
    u'乡': 1,
    u'书': 1,
    u'买': 1,
    u'乱': 1,
    u'乾': 3,
    u'亂': 2,
    u'争': 1,
    u'于': 1,
    u'亏': 1,
    u'云': 1,
    u'亚': 1,
    u'亞': 2,
    u'产': 1,
    u'亩': 1,
    u'亲': 1,
    u'亵': 1,
    u'亸': 1,
    u'亿': 1,
    u'仅': 1,
    u'仆': 1,
    u'从': 1,
    u'仑': 1,
    u'仓': 1,
    u'仪': 1,
    u'们': 1,
    u'价': 1,
    u'众': 1,
    u'优': 1,
    u'会': 1,
    u'伛': 1,
    u'伞': 1,
    u'伟': 1,
    u'传': 1,
    u'伡': 1,
    u'伣': 1,
    u'伤': 1,
    u'伥': 1,
    u'伦': 1,
    u'伧': 1,
    u'伪': 1,
    u'伫': 1,
    u'佇': 2,
    u'体': 1,
    u'余': 3,
    u'佣': 1,
    u'佥': 1,
    u'併': 2,
    u'來': 2,
    u'侖': 2,
    u'侠': 1,
    u'侣': 1,
    u'侥': 1,
    u'侦': 1,
    u'侧': 1,
    u'侨': 1,
    u'侩': 1,
    u'侪': 1,
    u'侬': 1,
    u'侶': 2,
    u'俁': 2,
    u'係': 2,
    u'俔': 2,
    u'俠': 2,
    u'俣': 1,
    u'俥': 2,
    u'俦': 1,
    u'俨': 1,
    u'俩': 1,
    u'俪': 1,
    u'俫': 1,
    u'俭': 1,
    u'倀': 2,
    u'倆': 2,
    u'倈': 2,
    u'倉': 2,
    u'個': 2,
    u'們': 2,
    u'倫': 2,
    u'倲': 2,
    u'债': 1,
    u'倾': 1,
    u'偉': 2,
    u'偑': 2,
    u'偬': 1,
    u'側': 2,
    u'偵': 2,
    u'偻': 1,
    u'偽': 2,
    u'偾': 1,
    u'偿': 1,
    u'傑': 2,
    u'傖': 2,
    u'傘': 2,
    u'備': 2,
    u'傥': 1,
    u'傧': 1,
    u'储': 1,
    u'傩': 1,
    u'傭': 2,
    u'傯': 2,
    u'傳': 2,
    u'傴': 2,
    u'債': 2,
    u'傷': 2,
    u'傾': 2,
    u'僂': 2,
    u'僅': 2,
    u'僉': 2,
    u'僑': 2,
    u'僕': 2,
    u'僞': 2,
    u'僥': 2,
    u'僨': 2,
    u'價': 2,
    u'儀': 2,
    u'儂': 2,
    u'億': 2,
    u'儈': 2,
    u'儉': 2,
    u'儐': 2,
    u'儔': 2,
    u'儕': 2,
    u'儘': 2,
    u'償': 2,
    u'儣': 2,
    u'優': 2,
    u'儲': 2,
    u'儷': 2,
    u'儸': 2,
    u'儺': 2,
    u'儻': 2,
    u'儼': 2,
    u'儿': 1,
    u'克': 1,
    u'兌': 2,
    u'兑': 1,
    u'兒': 2,
    u'兖': 1,
    u'兗': 2,
    u'党': 1,
    u'內': 2,
    u'兩': 2,
    u'兰': 1,
    u'关': 1,
    u'兴': 1,
    u'兹': 1,
    u'养': 1,
    u'兽': 1,
    u'冁': 1,
    u'内': 1,
    u'冈': 1,
    u'冊': 2,
    u'册': 1,
    u'写': 1,
    u'军': 1,
    u'农': 1,
    u'冪': 2,
    u'冯': 1,
    u'冲': 1,
    u'决': 1,
    u'况': 1,
    u'冻': 1,
    u'净': 1,
    u'准': 1,
    u'凈': 2,
    u'凉': 1,
    u'凍': 2,
    u'减': 1,
    u'凑': 1,
    u'凙': 2,
    u'凛': 1,
    u'凜': 2,
    u'几': 1,
    u'凤': 1,
    u'凫': 1,
    u'凭': 1,
    u'凯': 1,
    u'凱': 2,
    u'击': 1,
    u'凿': 1,
    u'刍': 1,
    u'划': 1,
    u'刘': 1,
    u'则': 1,
    u'刚': 1,
    u'创': 1,
    u'删': 1,
    u'別': 2,
    u'刪': 2,
    u'别': 1,
    u'刬': 1,
    u'刭': 1,
    u'刮': 1,
    u'制': 1,
    u'刹': 1,
    u'刽': 1,
    u'刾': 1,
    u'刿': 1,
    u'剀': 1,
    u'剂': 1,
    u'剄': 2,
    u'則': 2,
    u'剋': 2,
    u'剎': 2,
    u'剐': 1,
    u'剑': 1,
    u'剗': 2,
    u'剛': 2,
    u'剝': 2,
    u'剥': 1,
    u'剧': 1,
    u'剮': 2,
    u'剴': 2,
    u'創': 2,
    u'剾': 2,
    u'劃': 2,
    u'劇': 2,
    u'劉': 2,
    u'劊': 2,
    u'劌': 2,
    u'劍': 2,
    u'劏': 2,
    u'劑': 2,
    u'劚': 2,
    u'劝': 1,
    u'办': 1,
    u'务': 1,
    u'劢': 1,
    u'动': 1,
    u'励': 1,
    u'劲': 1,
    u'劳': 1,
    u'势': 1,
    u'勁': 2,
    u'勋': 1,
    u'動': 2,
    u'務': 2,
    u'勚': 1,
    u'勛': 2,
    u'勝': 2,
    u'勞': 2,
    u'勢': 2,
    u'勩': 2,
    u'勱': 2,
    u'勵': 2,
    u'勸': 2,
    u'勻': 2,
    u'匀': 1,
    u'匦': 1,
    u'匭': 2,
    u'匮': 1,
    u'匯': 2,
    u'匱': 2,
    u'区': 1,
    u'医': 1,
    u'區': 2,
    u'华': 1,
    u'协': 1,
    u'協': 2,
    u'单': 1,
    u'卖': 1,
    u'卢': 1,
    u'卤': 1,
    u'卫': 1,
    u'却': 1,
    u'卻': 2,
    u'厂': 1,
    u'厅': 1,
    u'历': 1,
    u'厉': 1,
    u'压': 1,
    u'厌': 1,
    u'厍': 1,
    u'厐': 1,
    u'厕': 1,
    u'厘': 1,
    u'厙': 2,
    u'厢': 1,
    u'厣': 1,
    u'厦': 1,
    u'厨': 1,
    u'厩': 1,
    u'厭': 2,
    u'厮': 1,
    u'厲': 2,
    u'厴': 2,
    u'县': 1,
    u'叁': 1,
    u'参': 1,
    u'參': 2,
    u'叄': 2,
    u'双': 1,
    u'发': 1,
    u'变': 1,
    u'叙': 1,
    u'叠': 1,
    u'叢': 2,
    u'只': 1,
    u'台': 3,
    u'叶': 1,
    u'号': 1,
    u'叹': 1,
    u'叽': 1,
    u'同': 3,
    u'后': 3,
    u'向': 1,
    u'吒': 2,
    u'吓': 1,
    u'吕': 1,
    u'吗': 1,
    u'吣': 1,
    u'吨': 1,
    u'听': 1,
    u'启': 1,
    u'吳': 2,
    u'吴': 1,
    u'吶': 2,
    u'呂': 2,
    u'呐': 1,
    u'呒': 1,
    u'呓': 1,
    u'呕': 1,
    u'呖': 1,
    u'呗': 1,
    u'员': 1,
    u'呙': 1,
    u'呛': 1,
    u'呜': 1,
    u'咏': 1,
    u'咙': 1,
    u'咛': 1,
    u'咝': 1,
    u'咤': 1,
    u'咸': 1,
    u'咼': 2,
    u'响': 1,
    u'哑': 1,
    u'哒': 1,
    u'哓': 1,
    u'哔': 1,
    u'哕': 1,
    u'哗': 1,
    u'哙': 1,
    u'哜': 1,
    u'哝': 1,
    u'哟': 1,
    u'員': 2,
    u'哯': 2,
    u'唄': 2,
    u'唚': 2,
    u'唛': 1,
    u'唝': 1,
    u'唠': 1,
    u'唡': 1,
    u'唢': 1,
    u'唤': 1,
    u'問': 2,
    u'啞': 2,
    u'啟': 2,
    u'啢': 2,
    u'啧': 1,
    u'啬': 1,
    u'啭': 1,
    u'啮': 1,
    u'啯': 1,
    u'啰': 1,
    u'啴': 1,
    u'啸': 1,
    u'喎': 2,
    u'喚': 2,
    u'喪': 2,
    u'喬': 2,
    u'單': 2,
    u'喲': 2,
    u'喷': 1,
    u'喽': 1,
    u'喾': 1,
    u'嗆': 2,
    u'嗇': 2,
    u'嗊': 2,
    u'嗎': 2,
    u'嗚': 2,
    u'嗩': 2,
    u'嗫': 1,
    u'嗳': 1,
    u'嗶': 2,
    u'嗹': 2,
    u'嘆': 2,
    u'嘍': 2,
    u'嘓': 2,
    u'嘔': 2,
    u'嘖': 2,
    u'嘗': 2,
    u'嘘': 1,
    u'嘜': 2,
    u'嘤': 1,
    u'嘩': 2,
    u'嘮': 2,
    u'嘯': 2,
    u'嘰': 2,
    u'嘱': 1,
    u'嘵': 2,
    u'嘸': 2,
    u'嘽': 2,
    u'噅': 2,
    u'噓': 2,
    u'噚': 2,
    u'噜': 1,
    u'噝': 2,
    u'噠': 2,
    u'噥': 2,
    u'噦': 2,
    u'噯': 2,
    u'噲': 2,
    u'噴': 2,
    u'噸': 2,
    u'噹': 2,
    u'嚀': 2,
    u'嚇': 2,
    u'嚌': 2,
    u'嚕': 2,
    u'嚙': 2,
    u'嚣': 1,
    u'嚦': 2,
    u'嚨': 2,
    u'嚲': 2,
    u'嚳': 2,
    u'嚴': 2,
    u'嚶': 2,
    u'囀': 2,
    u'囁': 2,
    u'囂': 2,
    u'囅': 2,
    u'囈': 2,
    u'囉': 2,
    u'囑': 2,
    u'团': 1,
    u'囪': 2,
    u'园': 1,
    u'困': 1,
    u'囱': 1,
    u'围': 1,
    u'囵': 1,
    u'国': 1,
    u'图': 1,
    u'圆': 1,
    u'圇': 2,
    u'國': 2,
    u'圍': 2,
    u'園': 2,
    u'圓': 2,
    u'圖': 2,
    u'團': 2,
    u'圞': 2,
    u'圣': 1,
    u'圹': 1,
    u'场': 1,
    u'坂': 1,
    u'坏': 1,
    u'块': 1,
    u'坚': 1,
    u'坛': 1,
    u'坜': 1,
    u'坝': 1,
    u'坞': 1,
    u'坟': 1,
    u'坠': 1,
    u'垄': 1,
    u'垅': 1,
    u'垆': 1,
    u'垒': 1,
    u'垦': 1,
    u'垩': 1,
    u'垫': 1,
    u'垭': 1,
    u'垱': 1,
    u'垲': 1,
    u'垴': 1,
    u'垵': 2,
    u'埘': 1,
    u'埙': 1,
    u'埚': 1,
    u'埡': 2,
    u'埯': 1,
    u'埰': 2,
    u'執': 2,
    u'堅': 2,
    u'堊': 2,
    u'堑': 1,
    u'堕': 1,
    u'堖': 2,
    u'堝': 2,
    u'堯': 2,
    u'報': 2,
    u'場': 2,
    u'塊': 2,
    u'塋': 2,
    u'塏': 2,
    u'塒': 2,
    u'塗': 2,
    u'塢': 2,
    u'塤': 2,
    u'塵': 2,
    u'塹': 2,
    u'墊': 2,
    u'墙': 1,
    u'墜': 2,
    u'墮': 2,
    u'墳': 2,
    u'墾': 2,
    u'壇': 2,
    u'壈': 2,
    u'壋': 2,
    u'壓': 2,
    u'壘': 2,
    u'壙': 2,
    u'壚': 2,
    u'壞': 2,
    u'壟': 2,
    u'壠': 2,
    u'壢': 2,
    u'壩': 2,
    u'壮': 1,
    u'壯': 2,
    u'声': 1,
    u'壳': 1,
    u'壶': 1,
    u'壸': 1,
    u'壺': 2,
    u'壼': 2,
    u'壽': 2,
    u'处': 1,
    u'备': 1,
    u'复': 1,
    u'够': 1,
    u'夠': 2,
    u'夢': 2,
    u'头': 1,
    u'夸': 1,
    u'夹': 1,
    u'夺': 1,
    u'夾': 2,
    u'奁': 1,
    u'奂': 1,
    u'奋': 1,
    u'奐': 2,
    u'奖': 1,
    u'奥': 1,
    u'奧': 2,
    u'奩': 2,
    u'奪': 2,
    u'奮': 2,
    u'奸': 1,
    u'奼': 2,
    u'妆': 1,
    u'妇': 1,
    u'妈': 1,
    u'妝': 2,
    u'妩': 1,
    u'妪': 1,
    u'妫': 1,
    u'姍': 2,
    u'姗': 1,
    u'姦': 2,
    u'姹': 1,
    u'娄': 1,
    u'娅': 1,
    u'娆': 1,
    u'娇': 1,
    u'娈': 1,
    u'娛': 2,
    u'娱': 1,
    u'娲': 1,
    u'娴': 1,
    u'婁': 2,
    u'婦': 2,
    u'婭': 2,
    u'婳': 1,
    u'婴': 1,
    u'婵': 1,
    u'婶': 1,
    u'媧': 2,
    u'媪': 1,
    u'媭': 1,
    u'媯': 2,
    u'媰': 2,
    u'媼': 2,
    u'媽': 2,
    u'嫒': 1,
    u'嫔': 1,
    u'嫗': 2,
    u'嫱': 1,
    u'嫵': 2,
    u'嫻': 2,
    u'嫿': 2,
    u'嬃': 2,
    u'嬈': 2,
    u'嬋': 2,
    u'嬌': 2,
    u'嬙': 2,
    u'嬡': 2,
    u'嬤': 2,
    u'嬪': 2,
    u'嬰': 2,
    u'嬷': 1,
    u'嬸': 2,
    u'孋': 2,
    u'孌': 2,
    u'孙': 1,
    u'学': 1,
    u'孪': 1,
    u'孫': 2,
    u'學': 2,
    u'孿': 2,
    u'宁': 1,
    u'宝': 1,
    u'实': 1,
    u'宠': 1,
    u'审': 1,
    u'宪': 1,
    u'宫': 1,
    u'宮': 2,
    u'宽': 1,
    u'宾': 1,
    u'寝': 1,
    u'寢': 2,
    u'實': 2,
    u'寧': 2,
    u'審': 2,
    u'寫': 2,
    u'寬': 2,
    u'寵': 2,
    u'寶': 2,
    u'对': 1,
    u'寻': 1,
    u'导': 1,
    u'寿': 1,
    u'将': 1,
    u'將': 2,
    u'專': 2,
    u'尋': 2,
    u'對': 2,
    u'導': 2,
    u'尔': 1,
    u'尘': 1,
    u'尝': 1,
    u'尧': 1,
    u'尴': 1,
    u'尷': 2,
    u'尸': 1,
    u'尽': 1,
    u'层': 1,
    u'屃': 1,
    u'屆': 2,
    u'屉': 1,
    u'届': 1,
    u'屍': 2,
    u'屓': 2,
    u'屜': 2,
    u'属': 1,
    u'屡': 1,
    u'屢': 2,
    u'層': 2,
    u'屦': 1,
    u'屨': 2,
    u'屩': 2,
    u'屬': 2,
    u'屿': 1,
    u'岁': 1,
    u'岂': 1,
    u'岖': 1,
    u'岗': 1,
    u'岘': 1,
    u'岙': 1,
    u'岚': 1,
    u'岛': 1,
    u'岡': 2,
    u'岭': 1,
    u'岽': 1,
    u'岿': 1,
    u'峄': 1,
    u'峡': 1,
    u'峣': 1,
    u'峤': 1,
    u'峥': 1,
    u'峦': 1,
    u'峴': 2,
    u'島': 2,
    u'峽': 2,
    u'崂': 1,
    u'崃': 1,
    u'崄': 1,
    u'崍': 2,
    u'崗': 2,
    u'崢': 2,
    u'崬': 2,
    u'崭': 1,
    u'嵐': 2,
    u'嵘': 1,
    u'嵚': 1,
    u'嵝': 1,
    u'嵼': 2,
    u'嶁': 2,
    u'嶄': 2,
    u'嶇': 2,
    u'嶔': 2,
    u'嶗': 2,
    u'嶠': 2,
    u'嶢': 2,
    u'嶧': 2,
    u'嶮': 2,
    u'嶴': 2,
    u'嶸': 2,
    u'嶺': 2,
    u'嶼': 2,
    u'巅': 1,
    u'巋': 2,
    u'巒': 2,
    u'巔': 2,
    u'巩': 1,
    u'巯': 1,
    u'巰': 2,
    u'币': 1,
    u'帅': 1,
    u'师': 1,
    u'帏': 1,
    u'帐': 1,
    u'帘': 1,
    u'帜': 1,
    u'帥': 2,
    u'带': 1,
    u'帧': 1,
    u'師': 2,
    u'帮': 1,
    u'帱': 1,
    u'帳': 2,
    u'帶': 2,
    u'帻': 1,
    u'帼': 1,
    u'幀': 2,
    u'幂': 1,
    u'幃': 2,
    u'幗': 2,
    u'幘': 2,
    u'幟': 2,
    u'幣': 2,
    u'幫': 2,
    u'幬': 2,
    u'干': 1,
    u'并': 1,
    u'幹': 2,
    u'幺': 2,
    u'幾': 2,
    u'广': 1,
    u'庄': 1,
    u'庆': 1,
    u'庐': 1,
    u'庑': 1,
    u'库': 1,
    u'应': 1,
    u'庙': 1,
    u'庞': 1,
    u'废': 1,
    u'庫': 2,
    u'廁': 2,
    u'廂': 2,
    u'廄': 2,
    u'廈': 2,
    u'廚': 2,
    u'廝': 2,
    u'廟': 2,
    u'廠': 2,
    u'廡': 2,
    u'廢': 2,
    u'廣': 2,
    u'廩': 2,
    u'廪': 1,
    u'廬': 2,
    u'廳': 2,
    u'开': 1,
    u'异': 1,
    u'弃': 1,
    u'弑': 1,
    u'弒': 2,
    u'张': 1,
    u'弥': 1,
    u'弪': 1,
    u'弯': 1,
    u'弳': 2,
    u'張': 2,
    u'強': 2,
    u'弹': 1,
    u'强': 1,
    u'彈': 2,
    u'彌': 2,
    u'彎': 2,
    u'归': 1,
    u'当': 1,
    u'录': 1,
    u'彙': 2,
    u'彝': 1,
    u'彞': 2,
    u'彟': 1,
    u'彠': 2,
    u'彥': 2,
    u'彦': 1,
    u'彨': 1,
    u'彲': 2,
    u'彻': 1,
    u'征': 3,
    u'径': 1,
    u'後': 2,
    u'徑': 2,
    u'徕': 1,
    u'從': 2,
    u'徠': 2,
    u'御': 1,
    u'復': 2,
    u'徵': 3,
    u'徹': 2,
    u'忆': 1,
    u'忏': 1,
    u'志': 3,
    u'忧': 1,
    u'忾': 1,
    u'怀': 1,
    u'态': 1,
    u'怂': 1,
    u'怃': 1,
    u'怄': 1,
    u'怅': 1,
    u'怆': 1,
    u'怜': 1,
    u'总': 1,
    u'怼': 1,
    u'怿': 1,
    u'恆': 2,
    u'恋': 1,
    u'恒': 1,
    u'恥': 2,
    u'恳': 1,
    u'恶': 1,
    u'恸': 1,
    u'恹': 1,
    u'恺': 1,
    u'恻': 1,
    u'恼': 1,
    u'恽': 1,
    u'悅': 2,
    u'悞': 2,
    u'悦': 1,
    u'悫': 1,
    u'悬': 1,
    u'悭': 1,
    u'悮': 1,
    u'悯': 1,
    u'悵': 2,
    u'悶': 2,
    u'惊': 1,
    u'惡': 2,
    u'惧': 1,
    u'惨': 1,
    u'惩': 1,
    u'惫': 1,
    u'惬': 1,
    u'惭': 1,
    u'惮': 1,
    u'惯': 1,
    u'惱': 2,
    u'惲': 2,
    u'惻': 2,
    u'愛': 2,
    u'愜': 2,
    u'愠': 1,
    u'愤': 1,
    u'愦': 1,
    u'愨': 2,
    u'愴': 2,
    u'愷': 2,
    u'愾': 2,
    u'愿': 3,
    u'慄': 2,
    u'態': 2,
    u'慍': 2,
    u'慑': 1,
    u'慘': 2,
    u'慚': 2,
    u'慟': 2,
    u'慣': 2,
    u'慪': 2,
    u'慫': 2,
    u'慮': 2,
    u'慳': 2,
    u'慶': 2,
    u'憂': 2,
    u'憊': 2,
    u'憐': 2,
    u'憑': 2,
    u'憒': 2,
    u'憚': 2,
    u'憤': 2,
    u'憫': 2,
    u'憮': 2,
    u'憲': 2,
    u'憶': 2,
    u'懀': 2,
    u'懇': 2,
    u'應': 2,
    u'懌': 2,
    u'懍': 2,
    u'懑': 1,
    u'懒': 1,
    u'懔': 1,
    u'懟': 2,
    u'懣': 2,
    u'懨': 2,
    u'懲': 2,
    u'懶': 2,
    u'懷': 2,
    u'懸': 2,
    u'懺': 2,
    u'懼': 2,
    u'懾': 2,
    u'戀': 2,
    u'戆': 1,
    u'戇': 2,
    u'戋': 1,
    u'戏': 1,
    u'戔': 2,
    u'戗': 1,
    u'战': 1,
    u'戧': 2,
    u'戩': 2,
    u'戬': 1,
    u'戯': 1,
    u'戰': 2,
    u'戱': 2,
    u'戲': 2,
    u'戶': 2,
    u'户': 1,
    u'扑': 1,
    u'执': 1,
    u'扩': 1,
    u'扪': 1,
    u'扫': 1,
    u'扬': 1,
    u'扰': 1,
    u'抚': 1,
    u'抛': 1,
    u'抟': 1,
    u'抠': 1,
    u'抡': 1,
    u'抢': 1,
    u'护': 1,
    u'报': 1,
    u'担': 1,
    u'拋': 2,
    u'拟': 1,
    u'拢': 1,
    u'拣': 1,
    u'拥': 1,
    u'拦': 1,
    u'拧': 1,
    u'拨': 1,
    u'择': 1,
    u'挂': 1,
    u'挚': 1,
    u'挛': 1,
    u'挜': 1,
    u'挝': 1,
    u'挞': 1,
    u'挟': 1,
    u'挠': 1,
    u'挡': 1,
    u'挢': 1,
    u'挣': 1,
    u'挤': 1,
    u'挥': 1,
    u'挦': 1,
    u'挩': 2,
    u'挽': 1,
    u'挾': 2,
    u'捝': 1,
    u'捞': 1,
    u'损': 1,
    u'捡': 1,
    u'换': 1,
    u'捣': 1,
    u'捨': 2,
    u'捫': 2,
    u'据': 1,
    u'掃': 2,
    u'掄': 2,
    u'掆': 2,
    u'掗': 2,
    u'掙': 2,
    u'掛': 2,
    u'採': 2,
    u'掳': 1,
    u'掴': 1,
    u'掷': 1,
    u'掸': 1,
    u'掺': 1,
    u'掼': 1,
    u'揀': 2,
    u'揚': 2,
    u'換': 2,
    u'揮': 2,
    u'揽': 1,
    u'揾': 1,
    u'揿': 1,
    u'搀': 1,
    u'搁': 1,
    u'搂': 1,
    u'搅': 1,
    u'損': 2,
    u'搖': 2,
    u'搗': 2,
    u'搵': 2,
    u'搶': 2,
    u'携': 1,
    u'摄': 1,
    u'摅': 1,
    u'摆': 1,
    u'摇': 1,
    u'摈': 1,
    u'摊': 1,
    u'摋': 2,
    u'摑': 2,
    u'摜': 2,
    u'摟': 2,
    u'摯': 2,
    u'摳': 2,
    u'摶': 2,
    u'摻': 2,
    u'撄': 1,
    u'撈': 2,
    u'撏': 2,
    u'撐': 2,
    u'撑': 1,
    u'撓': 2,
    u'撝': 2,
    u'撟': 2,
    u'撣': 2,
    u'撥': 2,
    u'撫': 2,
    u'撲': 2,
    u'撳': 2,
    u'撵': 1,
    u'撷': 1,
    u'撸': 1,
    u'撺': 1,
    u'撻': 2,
    u'撾': 2,
    u'撿': 2,
    u'擁': 2,
    u'擄': 2,
    u'擇': 2,
    u'擊': 2,
    u'擋': 2,
    u'擓': 2,
    u'擔': 2,
    u'據': 2,
    u'擞': 1,
    u'擠': 2,
    u'擣': 2,
    u'擬': 2,
    u'擯': 2,
    u'擰': 2,
    u'擱': 2,
    u'擲': 2,
    u'擴': 2,
    u'擷': 2,
    u'擺': 2,
    u'擻': 2,
    u'擼': 2,
    u'擽': 2,
    u'擾': 2,
    u'攄': 2,
    u'攆': 2,
    u'攏': 2,
    u'攒': 1,
    u'攔': 2,
    u'攖': 2,
    u'攙': 2,
    u'攛': 2,
    u'攜': 2,
    u'攝': 2,
    u'攢': 2,
    u'攣': 2,
    u'攤': 2,
    u'攪': 2,
    u'攬': 2,
    u'敌': 1,
    u'敗': 2,
    u'敘': 2,
    u'敛': 1,
    u'敩': 1,
    u'数': 1,
    u'敵': 2,
    u'數': 2,
    u'斂': 2,
    u'斃': 2,
    u'斅': 2,
    u'斆': 2,
    u'斋': 1,
    u'斓': 1,
    u'斕': 2,
    u'斗': 1,
    u'斩': 1,
    u'斬': 2,
    u'断': 1,
    u'斷': 2,
    u'於': 2,
    u'无': 1,
    u'旧': 1,
    u'时': 1,
    u'旷': 1,
    u'旸': 1,
    u'昙': 1,
    u'昼': 1,
    u'昽': 1,
    u'显': 1,
    u'時': 2,
    u'晉': 2,
    u'晋': 1,
    u'晒': 1,
    u'晓': 1,
    u'晔': 1,
    u'晕': 1,
    u'晖': 1,
    u'晝': 2,
    u'暂': 1,
    u'暈': 2,
    u'暉': 2,
    u'暘': 2,
    u'暢': 2,
    u'暧': 1,
    u'暫': 2,
    u'曄': 2,
    u'曆': 2,
    u'曇': 2,
    u'曉': 2,
    u'曏': 2,
    u'曖': 2,
    u'曠': 2,
    u'曥': 2,
    u'曨': 2,
    u'曬': 2,
    u'書': 2,
    u'會': 2,
    u'朥': 2,
    u'朧': 2,
    u'术': 1,
    u'朴': 1,
    u'机': 1,
    u'杀': 1,
    u'杂': 1,
    u'权': 1,
    u'杆': 1,
    u'条': 1,
    u'来': 1,
    u'杨': 1,
    u'杩': 1,
    u'杰': 3,
    u'東': 2,
    u'杴': 2,
    u'松': 1,
    u'板': 1,
    u'极': 3,
    u'构': 1,
    u'枞': 1,
    u'枢': 1,
    u'枣': 1,
    u'枥': 1,
    u'枧': 1,
    u'枨': 1,
    u'枪': 1,
    u'枫': 1,
    u'枭': 1,
    u'柜': 1,
    u'柠': 1,
    u'柵': 2,
    u'柽': 1,
    u'栀': 1,
    u'栅': 1,
    u'标': 1,
    u'栈': 1,
    u'栉': 1,
    u'栊': 1,
    u'栋': 1,
    u'栌': 1,
    u'栎': 1,
    u'栏': 1,
    u'树': 1,
    u'栖': 1,
    u'栗': 1,
    u'样': 1,
    u'栾': 1,
    u'桠': 1,
    u'桡': 1,
    u'桢': 1,
    u'档': 1,
    u'桤': 1,
    u'桥': 1,
    u'桦': 1,
    u'桧': 1,
    u'桨': 1,
    u'桩': 1,
    u'桪': 1,
    u'桿': 2,
    u'梔': 2,
    u'梘': 2,
    u'條': 2,
    u'梟': 2,
    u'梦': 1,
    u'梲': 2,
    u'梼': 1,
    u'梾': 1,
    u'梿': 1,
    u'检': 1,
    u'棁': 1,
    u'棂': 1,
    u'棄': 2,
    u'棖': 2,
    u'棗': 2,
    u'棟': 2,
    u'棡': 2,
    u'棧': 2,
    u'棲': 2,
    u'棶': 2,
    u'椁': 1,
    u'椏': 2,
    u'椝': 1,
    u'椟': 1,
    u'椠': 1,
    u'椢': 1,
    u'椤': 1,
    u'椫': 1,
    u'椭': 1,
    u'椲': 2,
    u'楊': 2,
    u'楓': 2,
    u'楨': 2,
    u'業': 2,
    u'極': 2,
    u'楼': 1,
    u'榄': 1,
    u'榅': 1,
    u'榇': 1,
    u'榈': 1,
    u'榉': 1,
    u'榪': 2,
    u'榮': 2,
    u'榲': 2,
    u'榿': 2,
    u'構': 2,
    u'槍': 2,
    u'槚': 1,
    u'槛': 1,
    u'槟': 1,
    u'槠': 1,
    u'槤': 2,
    u'槧': 2,
    u'槨': 2,
    u'槳': 2,
    u'槶': 2,
    u'槼': 2,
    u'樁': 2,
    u'樂': 2,
    u'樅': 2,
    u'樓': 2,
    u'標': 2,
    u'樞': 2,
    u'樢': 2,
    u'樣': 2,
    u'横': 1,
    u'樫': 2,
    u'樯': 1,
    u'樱': 1,
    u'樳': 2,
    u'樸': 2,
    u'樹': 2,
    u'樺': 2,
    u'樿': 2,
    u'橈': 2,
    u'橋': 2,
    u'機': 2,
    u'橢': 2,
    u'橥': 1,
    u'橫': 2,
    u'橱': 1,
    u'橹': 1,
    u'橼': 1,
    u'檁': 2,
    u'檉': 2,
    u'檔': 2,
    u'檜': 2,
    u'檟': 2,
    u'檢': 2,
    u'檣': 2,
    u'檩': 1,
    u'檭': 2,
    u'檮': 2,
    u'檯': 2,
    u'檳': 2,
    u'檸': 2,
    u'檻': 2,
    u'櫃': 2,
    u'櫓': 2,
    u'櫚': 2,
    u'櫛': 2,
    u'櫝': 2,
    u'櫞': 2,
    u'櫟': 2,
    u'櫥': 2,
    u'櫧': 2,
    u'櫨': 2,
    u'櫪': 2,
    u'櫫': 2,
    u'櫬': 2,
    u'櫱': 2,
    u'櫳': 2,
    u'櫸': 2,
    u'櫻': 2,
    u'欄': 2,
    u'權': 2,
    u'欍': 2,
    u'欏': 2,
    u'欒': 2,
    u'欓': 2,
    u'欖': 2,
    u'欞': 2,
    u'欢': 1,
    u'欤': 1,
    u'欧': 1,
    u'欽': 2,
    u'歐': 2,
    u'歟': 2,
    u'歡': 2,
    u'歲': 2,
    u'歷': 2,
    u'歸': 2,
    u'歼': 1,
    u'歿': 2,
    u'殁': 1,
    u'殇': 1,
    u'残': 1,
    u'殒': 1,
    u'殓': 1,
    u'殘': 2,
    u'殚': 1,
    u'殞': 2,
    u'殡': 1,
    u'殤': 2,
    u'殨': 2,
    u'殫': 2,
    u'殮': 2,
    u'殯': 2,
    u'殰': 2,
    u'殲': 2,
    u'殴': 1,
    u'殺': 2,
    u'殼': 2,
    u'毀': 2,
    u'毁': 1,
    u'毂': 1,
    u'毆': 2,
    u'毕': 1,
    u'毙': 1,
    u'毡': 1,
    u'毵': 1,
    u'毿': 2,
    u'氂': 2,
    u'氇': 1,
    u'氈': 2,
    u'氌': 2,
    u'气': 1,
    u'氢': 1,
    u'氣': 2,
    u'氩': 1,
    u'氫': 2,
    u'氬': 2,
    u'氲': 1,
    u'氳': 2,
    u'汇': 1,
    u'汉': 1,
    u'汤': 1,
    u'汹': 1,
    u'決': 2,
    u'沈': 1,
    u'沒': 2,
    u'沖': 2,
    u'沟': 1,
    u'没': 1,
    u'沣': 1,
    u'沤': 1,
    u'沥': 1,
    u'沦': 1,
    u'沧': 1,
    u'沨': 1,
    u'沩': 1,
    u'沪': 1,
    u'況': 2,
    u'泞': 1,
    u'注': 1,
    u'泪': 1,
    u'泶': 1,
    u'泷': 1,
    u'泸': 1,
    u'泺': 1,
    u'泻': 1,
    u'泼': 1,
    u'泽': 1,
    u'泾': 1,
    u'洁': 1,
    u'洒': 1,
    u'洶': 2,
    u'洼': 1,
    u'浃': 1,
    u'浅': 1,
    u'浆': 1,
    u'浇': 1,
    u'浈': 1,
    u'浊': 1,
    u'测': 1,
    u'浍': 1,
    u'济': 1,
    u'浏': 1,
    u'浐': 1,
    u'浑': 1,
    u'浒': 1,
    u'浓': 1,
    u'浔': 1,
    u'浕': 1,
    u'浹': 2,
    u'涂': 1,
    u'涇': 2,
    u'涛': 1,
    u'涝': 1,
    u'涞': 1,
    u'涟': 1,
    u'涠': 1,
    u'涡': 1,
    u'涢': 1,
    u'涣': 1,
    u'涤': 1,
    u'润': 1,
    u'涧': 1,
    u'涨': 1,
    u'涩': 1,
    u'涼': 2,
    u'淀': 1,
    u'淚': 2,
    u'淥': 2,
    u'淪': 2,
    u'淵': 2,
    u'淶': 2,
    u'淺': 2,
    u'渊': 1,
    u'渌': 1,
    u'渍': 1,
    u'渎': 1,
    u'渐': 1,
    u'渑': 1,
    u'渔': 1,
    u'渗': 1,
    u'渙': 2,
    u'減': 2,
    u'渢': 2,
    u'渦': 2,
    u'温': 1,
    u'測': 2,
    u'渾': 2,
    u'湊': 2,
    u'湞': 2,
    u'湯': 2,
    u'湾': 1,
    u'湿': 1,
    u'溃': 1,
    u'溅': 1,
    u'溆': 1,
    u'溇': 1,
    u'溈': 2,
    u'準': 2,
    u'溝': 2,
    u'溫': 2,
    u'溳': 2,
    u'滄': 2,
    u'滅': 2,
    u'滌': 2,
    u'滎': 2,
    u'滗': 1,
    u'滚': 1,
    u'滞': 1,
    u'滟': 1,
    u'滠': 1,
    u'满': 1,
    u'滢': 1,
    u'滤': 1,
    u'滥': 1,
    u'滦': 1,
    u'滨': 1,
    u'滩': 1,
    u'滪': 1,
    u'滬': 2,
    u'滯': 2,
    u'滲': 2,
    u'滸': 2,
    u'滻': 2,
    u'滾': 2,
    u'滿': 2,
    u'漁': 2,
    u'漊': 2,
    u'漓': 1,
    u'漚': 2,
    u'漢': 2,
    u'漣': 2,
    u'漤': 1,
    u'漬': 2,
    u'漲': 2,
    u'漵': 2,
    u'漸': 2,
    u'漿': 2,
    u'潁': 2,
    u'潆': 1,
    u'潇': 1,
    u'潋': 1,
    u'潍': 1,
    u'潑': 2,
    u'潔': 2,
    u'潛': 2,
    u'潜': 1,
    u'潤': 2,
    u'潯': 2,
    u'潰': 2,
    u'潴': 1,
    u'潷': 2,
    u'潿': 2,
    u'澀': 2,
    u'澅': 2,
    u'澆': 2,
    u'澇': 2,
    u'澗': 2,
    u'澛': 1,
    u'澜': 1,
    u'澠': 2,
    u'澤': 2,
    u'澦': 2,
    u'澩': 2,
    u'澮': 2,
    u'澱': 2,
    u'澾': 2,
    u'濁': 2,
    u'濃': 2,
    u'濄': 2,
    u'濆': 2,
    u'濑': 1,
    u'濒': 1,
    u'濕': 2,
    u'濘': 2,
    u'濜': 2,
    u'濟': 2,
    u'濤': 2,
    u'濧': 2,
    u'濫': 2,
    u'濰': 2,
    u'濱': 2,
    u'濺': 2,
    u'濼': 2,
    u'濾': 2,
    u'瀂': 2,
    u'瀃': 2,
    u'瀅': 2,
    u'瀆': 2,
    u'瀇': 2,
    u'瀉': 2,
    u'瀋': 2,
    u'瀏': 2,
    u'瀕': 2,
    u'瀘': 2,
    u'瀝': 2,
    u'瀟': 2,
    u'瀠': 2,
    u'瀦': 2,
    u'瀧': 2,
    u'瀨': 2,
    u'瀰': 2,
    u'瀲': 2,
    u'瀾': 2,
    u'灃': 2,
    u'灄': 2,
    u'灏': 1,
    u'灑': 2,
    u'灕': 2,
    u'灘': 2,
    u'灙': 2,
    u'灝': 2,
    u'灠': 2,
    u'灡': 2,
    u'灣': 2,
    u'灤': 2,
    u'灧': 2,
    u'灭': 1,
    u'灯': 1,
    u'灵': 1,
    u'災': 2,
    u'灾': 1,
    u'灿': 1,
    u'炀': 1,
    u'炉': 1,
    u'炜': 1,
    u'炝': 1,
    u'点': 1,
    u'為': 2,
    u'炼': 1,
    u'炽': 1,
    u'烁': 1,
    u'烂': 1,
    u'烃': 1,
    u'烏': 2,
    u'烛': 1,
    u'烟': 1,
    u'烦': 1,
    u'烧': 1,
    u'烨': 1,
    u'烩': 1,
    u'烫': 1,
    u'烬': 1,
    u'热': 1,
    u'烴': 2,
    u'焕': 1,
    u'焖': 1,
    u'焘': 1,
    u'無': 2,
    u'煉': 2,
    u'煒': 2,
    u'煙': 2,
    u'煢': 2,
    u'煥': 2,
    u'煩': 2,
    u'煬': 2,
    u'煱': 2,
    u'煴': 1,
    u'熅': 2,
    u'熉': 2,
    u'熌': 2,
    u'熒': 2,
    u'熓': 2,
    u'熗': 2,
    u'熡': 2,
    u'熱': 2,
    u'熲': 2,
    u'熾': 2,
    u'燁': 2,
    u'燈': 2,
    u'燒': 2,
    u'燙': 2,
    u'燜': 2,
    u'營': 2,
    u'燦': 2,
    u'燭': 2,
    u'燴': 2,
    u'燶': 2,
    u'燼': 2,
    u'燾': 2,
    u'爄': 2,
    u'爍': 2,
    u'爐': 2,
    u'爛': 2,
    u'爭': 2,
    u'爱': 1,
    u'爷': 1,
    u'爺': 2,
    u'爾': 2,
    u'牆': 2,
    u'牍': 1,
    u'牘': 2,
    u'牦': 1,
    u'牵': 1,
    u'牺': 1,
    u'牽': 2,
    u'犊': 1,
    u'犖': 2,
    u'犢': 2,
    u'犧': 2,
    u'状': 1,
    u'犷': 1,
    u'犸': 1,
    u'犹': 1,
    u'狀': 2,
    u'狈': 1,
    u'狝': 1,
    u'狞': 1,
    u'独': 1,
    u'狭': 1,
    u'狮': 1,
    u'狯': 1,
    u'狰': 1,
    u'狱': 1,
    u'狲': 1,
    u'狹': 2,
    u'狽': 2,
    u'猃': 1,
    u'猎': 1,
    u'猕': 1,
    u'猙': 2,
    u'猡': 1,
    u'猪': 1,
    u'猫': 1,
    u'猬': 1,
    u'献': 1,
    u'猶': 2,
    u'猻': 2,
    u'獁': 2,
    u'獄': 2,
    u'獅': 2,
    u'獎': 2,
    u'獨': 2,
    u'獪': 2,
    u'獫': 2,
    u'獭': 1,
    u'獮': 2,
    u'獰': 2,
    u'獱': 2,
    u'獲': 2,
    u'獵': 2,
    u'獷': 2,
    u'獸': 2,
    u'獺': 2,
    u'獻': 2,
    u'獼': 2,
    u'玀': 2,
    u'玁': 2,
    u'玑': 1,
    u'玚': 1,
    u'玛': 1,
    u'玮': 1,
    u'环': 1,
    u'现': 1,
    u'玱': 1,
    u'玺': 1,
    u'珐': 1,
    u'珑': 1,
    u'珰': 1,
    u'珲': 1,
    u'現': 2,
    u'琏': 1,
    u'琐': 1,
    u'琺': 2,
    u'琼': 1,
    u'琿': 2,
    u'瑋': 2,
    u'瑒': 2,
    u'瑣': 2,
    u'瑤': 2,
    u'瑩': 2,
    u'瑪': 2,
    u'瑲': 2,
    u'瑶': 1,
    u'瑷': 1,
    u'瑽': 2,
    u'璉': 2,
    u'璎': 1,
    u'璣': 2,
    u'璦': 2,
    u'璫': 2,
    u'璯': 2,
    u'環': 2,
    u'璽': 2,
    u'瓊': 2,
    u'瓏': 2,
    u'瓒': 1,
    u'瓔': 2,
    u'瓕': 2,
    u'瓚': 2,
    u'瓯': 1,
    u'甌': 2,
    u'產': 2,
    u'电': 1,
    u'画': 1,
    u'畅': 1,
    u'畝': 2,
    u'畢': 2,
    u'畫': 2,
    u'異': 2,
    u'畴': 1,
    u'當': 2,
    u'疇': 2,
    u'疊': 2,
    u'疖': 1,
    u'疗': 1,
    u'疟': 1,
    u'疠': 1,
    u'疡': 1,
    u'疬': 1,
    u'疭': 1,
    u'疮': 1,
    u'疯': 1,
    u'疱': 1,
    u'疴': 1,
    u'症': 1,
    u'痈': 1,
    u'痉': 1,
    u'痒': 1,
    u'痖': 1,
    u'痙': 2,
    u'痨': 1,
    u'痪': 1,
    u'痫': 1,
    u'痾': 2,
    u'瘂': 2,
    u'瘅': 1,
    u'瘆': 1,
    u'瘋': 2,
    u'瘍': 2,
    u'瘓': 2,
    u'瘗': 1,
    u'瘘': 1,
    u'瘞': 2,
    u'瘡': 2,
    u'瘧': 2,
    u'瘪': 1,
    u'瘫': 1,
    u'瘮': 2,
    u'瘲': 2,
    u'瘺': 2,
    u'瘾': 1,
    u'瘿': 1,
    u'療': 2,
    u'癆': 2,
    u'癇': 2,
    u'癉': 2,
    u'癘': 2,
    u'癞': 1,
    u'癟': 2,
    u'癢': 2,
    u'癣': 1,
    u'癤': 2,
    u'癥': 2,
    u'癧': 2,
    u'癩': 2,
    u'癫': 1,
    u'癬': 2,
    u'癭': 2,
    u'癮': 2,
    u'癰': 2,
    u'癱': 2,
    u'癲': 2,
    u'發': 2,
    u'皑': 1,
    u'皚': 2,
    u'皟': 2,
    u'皰': 2,
    u'皱': 1,
    u'皲': 1,
    u'皸': 2,
    u'皺': 2,
    u'盏': 1,
    u'盐': 1,
    u'监': 1,
    u'盖': 1,
    u'盗': 1,
    u'盘': 1,
    u'盜': 2,
    u'盞': 2,
    u'盡': 2,
    u'監': 2,
    u'盤': 2,
    u'盧': 2,
    u'盪': 2,
    u'眍': 1,
    u'眥': 2,
    u'眦': 1,
    u'眬': 1,
    u'眾': 2,
    u'着': 1,
    u'睁': 1,
    u'睍': 2,
    u'睏': 2,
    u'睐': 1,
    u'睑': 1,
    u'睜': 2,
    u'睞': 2,
    u'瞆': 1,
    u'瞒': 1,
    u'瞘': 2,
    u'瞜': 2,
    u'瞞': 2,
    u'瞤': 2,
    u'瞩': 1,
    u'瞶': 2,
    u'瞼': 2,
    u'矓': 2,
    u'矚': 2,
    u'矫': 1,
    u'矯': 2,
    u'矶': 1,
    u'矾': 1,
    u'矿': 1,
    u'砀': 1,
    u'码': 1,
    u'砖': 1,
    u'砗': 1,
    u'砚': 1,
    u'砜': 1,
    u'砺': 1,
    u'砻': 1,
    u'砾': 1,
    u'础': 1,
    u'硁': 1,
    u'硕': 1,
    u'硖': 1,
    u'硗': 1,
    u'硙': 1,
    u'硚': 1,
    u'硜': 2,
    u'硤': 2,
    u'硨': 2,
    u'确': 1,
    u'硯': 2,
    u'硵': 1,
    u'硷': 1,
    u'碍': 1,
    u'碙': 2,
    u'碛': 1,
    u'碜': 1,
    u'碩': 2,
    u'碭': 2,
    u'碸': 2,
    u'確': 2,
    u'碼': 2,
    u'碽': 2,
    u'磑': 2,
    u'磚': 2,
    u'磠': 2,
    u'磣': 2,
    u'磧': 2,
    u'磯': 2,
    u'磽': 2,
    u'礄': 2,
    u'礆': 2,
    u'礎': 2,
    u'礒': 2,
    u'礙': 2,
    u'礦': 2,
    u'礪': 2,
    u'礫': 2,
    u'礬': 2,
    u'礱': 2,
    u'礼': 1,
    u'祃': 1,
    u'祎': 1,
    u'祢': 1,
    u'祯': 1,
    u'祷': 1,
    u'祸': 1,
    u'祿': 2,
    u'禀': 1,
    u'禄': 1,
    u'禅': 1,
    u'禍': 2,
    u'禎': 2,
    u'禕': 2,
    u'禡': 2,
    u'禦': 2,
    u'禪': 2,
    u'禮': 2,
    u'禰': 2,
    u'禱': 2,
    u'离': 1,
    u'禿': 2,
    u'秃': 1,
    u'秆': 1,
    u'秈': 2,
    u'种': 1,
    u'积': 1,
    u'称': 1,
    u'秽': 1,
    u'秾': 1,
    u'稅': 2,
    u'稆': 1,
    u'稈': 2,
    u'税': 1,
    u'稏': 2,
    u'稟': 2,
    u'稣': 1,
    u'種': 2,
    u'稱': 2,
    u'稳': 1,
    u'穀': 2,
    u'穌': 2,
    u'積': 2,
    u'穎': 2,
    u'穑': 1,
    u'穠': 2,
    u'穡': 2,
    u'穢': 2,
    u'穩': 2,
    u'穫': 2,
    u'穭': 2,
    u'穷': 1,
    u'窃': 1,
    u'窍': 1,
    u'窎': 1,
    u'窑': 1,
    u'窜': 1,
    u'窝': 1,
    u'窥': 1,
    u'窦': 1,
    u'窩': 2,
    u'窪': 2,
    u'窭': 1,
    u'窮': 2,
    u'窯': 2,
    u'窵': 2,
    u'窶': 2,
    u'窺': 2,
    u'竄': 2,
    u'竅': 2,
    u'竇': 2,
    u'竊': 2,
    u'竖': 1,
    u'竞': 1,
    u'競': 2,
    u'笃': 1,
    u'笋': 1,
    u'笔': 1,
    u'笕': 1,
    u'笺': 1,
    u'笼': 1,
    u'笾': 1,
    u'筆': 2,
    u'筍': 2,
    u'筑': 1,
    u'筚': 1,
    u'筛': 1,
    u'筜': 1,
    u'筝': 1,
    u'筧': 2,
    u'筴': 2,
    u'筹': 1,
    u'筼': 1,
    u'签': 1,
    u'简': 1,
    u'箋': 2,
    u'箏': 2,
    u'箓': 1,
    u'箦': 1,
    u'箧': 1,
    u'箨': 1,
    u'箩': 1,
    u'箪': 1,
    u'箫': 1,
    u'節': 2,
    u'範': 2,
    u'築': 2,
    u'篋': 2,
    u'篑': 1,
    u'篓': 1,
    u'篔': 2,
    u'篘': 2,
    u'篤': 2,
    u'篩': 2,
    u'篮': 1,
    u'篯': 1,
    u'篱': 1,
    u'篳': 2,
    u'簀': 2,
    u'簍': 2,
    u'簖': 1,
    u'簞': 2,
    u'簡': 2,
    u'簣': 2,
    u'簫': 2,
    u'簹': 2,
    u'簽': 2,
    u'簾': 2,
    u'籁': 1,
    u'籃': 2,
    u'籋': 2,
    u'籌': 2,
    u'籔': 2,
    u'籙': 2,
    u'籛': 2,
    u'籜': 2,
    u'籟': 2,
    u'籠': 2,
    u'籩': 2,
    u'籪': 2,
    u'籬': 2,
    u'籮': 2,
    u'籴': 1,
    u'类': 1,
    u'籼': 1,
    u'粜': 1,
    u'粝': 1,
    u'粤': 1,
    u'粪': 1,
    u'粮': 1,
    u'粵': 2,
    u'糁': 1,
    u'糇': 1,
    u'糝': 2,
    u'糞': 2,
    u'糧': 2,
    u'糲': 2,
    u'糴': 2,
    u'糶': 2,
    u'糹': 2,
    u'系': 3,
    u'糾': 2,
    u'紀': 2,
    u'紂': 2,
    u'約': 2,
    u'紅': 2,
    u'紆': 2,
    u'紇': 2,
    u'紈': 2,
    u'紉': 2,
    u'紋': 2,
    u'納': 2,
    u'紐': 2,
    u'紓': 2,
    u'純': 2,
    u'紕': 2,
    u'紖': 2,
    u'紗': 2,
    u'紘': 2,
    u'紙': 2,
    u'級': 2,
    u'紛': 2,
    u'紜': 2,
    u'紝': 2,
    u'紡': 2,
    u'紧': 1,
    u'紬': 2,
    u'累': 1,
    u'細': 2,
    u'紱': 2,
    u'紲': 2,
    u'紳': 2,
    u'紵': 2,
    u'紹': 2,
    u'紺': 2,
    u'紼': 2,
    u'紿': 2,
    u'絀': 2,
    u'終': 2,
    u'組': 2,
    u'絅': 2,
    u'絆': 2,
    u'絎': 2,
    u'結': 2,
    u'絕': 2,
    u'絛': 2,
    u'絝': 2,
    u'絞': 2,
    u'絡': 2,
    u'絢': 2,
    u'給': 2,
    u'絨': 2,
    u'絰': 2,
    u'統': 2,
    u'絲': 2,
    u'絳': 2,
    u'絷': 1,
    u'絹': 2,
    u'絺': 2,
    u'綀': 2,
    u'綁': 2,
    u'綃': 2,
    u'綆': 2,
    u'綇': 2,
    u'綈': 2,
    u'綌': 2,
    u'綏': 2,
    u'綐': 2,
    u'經': 2,
    u'綜': 2,
    u'綞': 2,
    u'綠': 2,
    u'綢': 2,
    u'綣': 2,
    u'綬': 2,
    u'維': 2,
    u'綯': 2,
    u'綰': 2,
    u'綱': 2,
    u'網': 2,
    u'綴': 2,
    u'綵': 2,
    u'綸': 2,
    u'綹': 2,
    u'綺': 2,
    u'綻': 2,
    u'綽': 2,
    u'綾': 2,
    u'綿': 2,
    u'緄': 2,
    u'緇': 2,
    u'緊': 2,
    u'緋': 2,
    u'緍': 2,
    u'緒': 2,
    u'緓': 2,
    u'緗': 2,
    u'緘': 2,
    u'緙': 2,
    u'線': 2,
    u'緝': 2,
    u'緞': 2,
    u'締': 2,
    u'緡': 2,
    u'緣': 2,
    u'緦': 2,
    u'編': 2,
    u'緩': 2,
    u'緬': 2,
    u'緯': 2,
    u'緰': 2,
    u'緱': 2,
    u'緲': 2,
    u'練': 2,
    u'緶': 2,
    u'緷': 2,
    u'緸': 2,
    u'緹': 2,
    u'緻': 2,
    u'縈': 2,
    u'縉': 2,
    u'縊': 2,
    u'縋': 2,
    u'縎': 2,
    u'縐': 2,
    u'縑': 2,
    u'縕': 2,
    u'縗': 2,
    u'縛': 2,
    u'縝': 2,
    u'縞': 2,
    u'縟': 2,
    u'縣': 2,
    u'縫': 2,
    u'縬': 2,
    u'縭': 2,
    u'縮': 2,
    u'縱': 2,
    u'縲': 2,
    u'縳': 2,
    u'縵': 2,
    u'縶': 2,
    u'縷': 2,
    u'縹': 2,
    u'縺': 2,
    u'總': 2,
    u'績': 2,
    u'繃': 2,
    u'繅': 2,
    u'繆': 2,
    u'繏': 2,
    u'繒': 2,
    u'繓': 2,
    u'織': 2,
    u'繕': 2,
    u'繚': 2,
    u'繞': 2,
    u'繟': 2,
    u'繡': 2,
    u'繢': 2,
    u'繩': 2,
    u'繪': 2,
    u'繫': 2,
    u'繭': 2,
    u'繯': 2,
    u'繰': 2,
    u'繳': 2,
    u'繸': 2,
    u'繹': 2,
    u'繻': 2,
    u'繼': 2,
    u'繽': 2,
    u'繾': 2,
    u'繿': 2,
    u'纁': 2,
    u'纇': 2,
    u'纈': 2,
    u'纊': 2,
    u'續': 2,
    u'纍': 2,
    u'纏': 2,
    u'纓': 2,
    u'纖': 2,
    u'纘': 2,
    u'纜': 2,
    u'纟': 1,
    u'纠': 1,
    u'纡': 1,
    u'红': 1,
    u'纣': 1,
    u'纤': 1,
    u'纥': 1,
    u'约': 1,
    u'级': 1,
    u'纨': 1,
    u'纩': 1,
    u'纪': 1,
    u'纫': 1,
    u'纬': 1,
    u'纭': 1,
    u'纮': 1,
    u'纯': 1,
    u'纰': 1,
    u'纱': 1,
    u'纲': 1,
    u'纳': 1,
    u'纴': 1,
    u'纵': 1,
    u'纶': 1,
    u'纷': 1,
    u'纸': 1,
    u'纹': 1,
    u'纺': 1,
    u'纻': 1,
    u'纼': 1,
    u'纽': 1,
    u'纾': 1,
    u'线': 1,
    u'绀': 1,
    u'绁': 1,
    u'绂': 1,
    u'练': 1,
    u'组': 1,
    u'绅': 1,
    u'细': 1,
    u'织': 1,
    u'终': 1,
    u'绉': 1,
    u'绊': 1,
    u'绋': 1,
    u'绌': 1,
    u'绍': 1,
    u'绎': 1,
    u'经': 1,
    u'绐': 1,
    u'绑': 1,
    u'绒': 1,
    u'结': 1,
    u'绔': 1,
    u'绕': 1,
    u'绖': 1,
    u'绗': 1,
    u'绘': 1,
    u'给': 1,
    u'绚': 1,
    u'绛': 1,
    u'络': 1,
    u'绝': 1,
    u'绞': 1,
    u'统': 1,
    u'绠': 1,
    u'绡': 1,
    u'绢': 1,
    u'绣': 1,
    u'绤': 1,
    u'绥': 1,
    u'绦': 1,
    u'继': 1,
    u'绨': 1,
    u'绩': 1,
    u'绪': 1,
    u'绫': 1,
    u'绬': 1,
    u'续': 1,
    u'绮': 1,
    u'绯': 1,
    u'绰': 1,
    u'绱': 1,
    u'绲': 1,
    u'绳': 1,
    u'维': 1,
    u'绵': 1,
    u'绶': 1,
    u'绷': 1,
    u'绸': 1,
    u'绹': 1,
    u'绺': 1,
    u'绻': 1,
    u'综': 1,
    u'绽': 1,
    u'绾': 1,
    u'绿': 1,
    u'缀': 1,
    u'缁': 1,
    u'缂': 1,
    u'缃': 1,
    u'缄': 1,
    u'缅': 1,
    u'缆': 1,
    u'缇': 1,
    u'缈': 1,
    u'缉': 1,
    u'缊': 1,
    u'缋': 1,
    u'缌': 1,
    u'缍': 1,
    u'缎': 1,
    u'缏': 1,
    u'缑': 1,
    u'缒': 1,
    u'缓': 1,
    u'缔': 1,
    u'缕': 1,
    u'编': 1,
    u'缗': 1,
    u'缘': 1,
    u'缙': 1,
    u'缚': 1,
    u'缛': 1,
    u'缜': 1,
    u'缝': 1,
    u'缞': 1,
    u'缟': 1,
    u'缠': 1,
    u'缡': 1,
    u'缢': 1,
    u'缣': 1,
    u'缤': 1,
    u'缥': 1,
    u'缦': 1,
    u'缧': 1,
    u'缨': 1,
    u'缩': 1,
    u'缪': 1,
    u'缫': 1,
    u'缬': 1,
    u'缭': 1,
    u'缮': 1,
    u'缯': 1,
    u'缰': 1,
    u'缱': 1,
    u'缲': 1,
    u'缳': 1,
    u'缴': 1,
    u'缵': 1,
    u'缽': 2,
    u'罂': 1,
    u'罈': 2,
    u'罌': 2,
    u'网': 1,
    u'罗': 1,
    u'罚': 1,
    u'罢': 1,
    u'罰': 2,
    u'罴': 1,
    u'罵': 2,
    u'罷': 2,
    u'羁': 1,
    u'羅': 2,
    u'羆': 2,
    u'羈': 2,
    u'羋': 2,
    u'羟': 1,
    u'羥': 2,
    u'義': 2,
    u'習': 2,
    u'翘': 1,
    u'翙': 1,
    u'翚': 1,
    u'翬': 2,
    u'翹': 2,
    u'翽': 2,
    u'耢': 1,
    u'耧': 1,
    u'耬': 2,
    u'耮': 2,
    u'耸': 1,
    u'耻': 1,
    u'聂': 1,
    u'聋': 1,
    u'职': 1,
    u'聍': 1,
    u'联': 1,
    u'聖': 2,
    u'聞': 2,
    u'聩': 1,
    u'聪': 1,
    u'聯': 2,
    u'聰': 2,
    u'聲': 2,
    u'聳': 2,
    u'聵': 2,
    u'聶': 2,
    u'職': 2,
    u'聹': 2,
    u'聽': 2,
    u'聾': 2,
    u'肃': 1,
    u'肅': 2,
    u'肠': 1,
    u'肤': 1,
    u'肮': 1,
    u'肴': 1,
    u'肾': 1,
    u'肿': 1,
    u'胀': 1,
    u'胁': 1,
    u'胆': 1,
    u'胜': 1,
    u'胡': 1,
    u'胧': 1,
    u'胨': 1,
    u'胪': 1,
    u'胫': 1,
    u'胶': 1,
    u'脅': 2,
    u'脈': 2,
    u'脉': 1,
    u'脍': 1,
    u'脏': 1,
    u'脐': 1,
    u'脑': 1,
    u'脓': 1,
    u'脔': 1,
    u'脚': 1,
    u'脛': 2,
    u'脥': 2,
    u'脫': 2,
    u'脱': 1,
    u'脶': 1,
    u'脸': 1,
    u'脹': 2,
    u'腊': 1,
    u'腎': 2,
    u'腖': 2,
    u'腘': 1,
    u'腡': 2,
    u'腦': 2,
    u'腪': 2,
    u'腫': 2,
    u'腭': 1,
    u'腳': 2,
    u'腸': 2,
    u'腻': 1,
    u'腼': 1,
    u'腽': 1,
    u'腾': 1,
    u'膃': 2,
    u'膑': 1,
    u'膕': 2,
    u'膚': 2,
    u'膠': 2,
    u'膢': 2,
    u'膩': 2,
    u'膽': 2,
    u'膾': 2,
    u'膿': 2,
    u'臉': 2,
    u'臍': 2,
    u'臏': 2,
    u'臗': 2,
    u'臘': 2,
    u'臚': 2,
    u'臜': 1,
    u'臟': 2,
    u'臠': 2,
    u'臢': 2,
    u'臨': 2,
    u'致': 1,
    u'臺': 2,
    u'舆': 1,
    u'與': 2,
    u'興': 2,
    u'舉': 2,
    u'舊': 2,
    u'舍': 1,
    u'舣': 1,
    u'舰': 1,
    u'舱': 1,
    u'舻': 1,
    u'艙': 2,
    u'艤': 2,
    u'艦': 2,
    u'艫': 2,
    u'艰': 1,
    u'艱': 2,
    u'艳': 1,
    u'艷': 2,
    u'艺': 1,
    u'节': 1,
    u'芈': 1,
    u'芗': 1,
    u'芜': 1,
    u'芦': 1,
    u'芸': 1,
    u'芻': 2,
    u'苁': 1,
    u'苇': 1,
    u'苈': 1,
    u'苋': 1,
    u'苌': 1,
    u'苍': 1,
    u'苎': 1,
    u'苏': 1,
    u'苧': 2,
    u'苹': 1,
    u'范': 1,
    u'茎': 1,
    u'茏': 1,
    u'茑': 1,
    u'茔': 1,
    u'茕': 1,
    u'茧': 1,
    u'茲': 2,
    u'荆': 1,
    u'荊': 2,
    u'荐': 1,
    u'荙': 1,
    u'荚': 1,
    u'荛': 1,
    u'荜': 1,
    u'荝': 1,
    u'荞': 1,
    u'荟': 1,
    u'荠': 1,
    u'荡': 1,
    u'荣': 1,
    u'荤': 1,
    u'荥': 1,
    u'荦': 1,
    u'荧': 1,
    u'荨': 1,
    u'荩': 1,
    u'荪': 1,
    u'荫': 1,
    u'荬': 1,
    u'荭': 1,
    u'荮': 1,
    u'药': 1,
    u'莅': 1,
    u'莊': 2,
    u'莖': 2,
    u'莢': 2,
    u'莧': 2,
    u'莱': 1,
    u'莲': 1,
    u'莳': 1,
    u'莴': 1,
    u'莶': 1,
    u'获': 1,
    u'莸': 1,
    u'莹': 1,
    u'莺': 1,
    u'莼': 1,
    u'華': 2,
    u'萇': 2,
    u'萊': 2,
    u'萝': 1,
    u'萤': 1,
    u'营': 1,
    u'萦': 1,
    u'萧': 1,
    u'萨': 1,
    u'萬': 2,
    u'萴': 2,
    u'萵': 2,
    u'葉': 2,
    u'葒': 2,
    u'著': 3,
    u'葤': 2,
    u'葦': 2,
    u'葱': 1,
    u'葷': 2,
    u'蒇': 1,
    u'蒉': 1,
    u'蒋': 1,
    u'蒌': 1,
    u'蒔': 2,
    u'蒞': 2,
    u'蒼': 2,
    u'蓀': 2,
    u'蓋': 2,
    u'蓝': 1,
    u'蓟': 1,
    u'蓠': 1,
    u'蓣': 1,
    u'蓥': 1,
    u'蓦': 1,
    u'蓮': 2,
    u'蓯': 2,
    u'蓴': 2,
    u'蓽': 2,
    u'蔂': 1,
    u'蔞': 2,
    u'蔣': 2,
    u'蔥': 2,
    u'蔦': 2,
    u'蔭': 2,
    u'蔷': 1,
    u'蔹': 1,
    u'蔺': 1,
    u'蔼': 1,
    u'蕁': 2,
    u'蕆': 2,
    u'蕎': 2,
    u'蕒': 2,
    u'蕓': 2,
    u'蕕': 2,
    u'蕘': 2,
    u'蕢': 2,
    u'蕩': 2,
    u'蕪': 2,
    u'蕭': 2,
    u'蕰': 1,
    u'蕲': 1,
    u'蕴': 1,
    u'蕷': 2,
    u'薀': 2,
    u'薈': 2,
    u'薊': 2,
    u'薌': 2,
    u'薔': 2,
    u'薘': 2,
    u'薟': 2,
    u'薦': 2,
    u'薩': 2,
    u'薮': 1,
    u'薳': 2,
    u'薴': 2,
    u'薺': 2,
    u'藍': 2,
    u'藎': 2,
    u'藓': 1,
    u'藝': 2,
    u'藥': 2,
    u'藪': 2,
    u'藶': 2,
    u'藹': 2,
    u'藺': 2,
    u'蘄': 2,
    u'蘆': 2,
    u'蘇': 2,
    u'蘊': 2,
    u'蘋': 2,
    u'蘖': 1,
    u'蘚': 2,
    u'蘞': 2,
    u'蘢': 2,
    u'蘭': 2,
    u'蘺': 2,
    u'蘿': 2,
    u'虆': 2,
    u'虏': 1,
    u'虑': 1,
    u'處': 2,
    u'虚': 1,
    u'虛': 2,
    u'虜': 2,
    u'號': 2,
    u'虧': 2,
    u'虫': 1,
    u'虬': 1,
    u'虮': 1,
    u'虯': 2,
    u'虽': 1,
    u'虾': 1,
    u'虿': 1,
    u'蚀': 1,
    u'蚁': 1,
    u'蚂': 1,
    u'蚃': 1,
    u'蚕': 1,
    u'蚬': 1,
    u'蛊': 1,
    u'蛎': 1,
    u'蛏': 1,
    u'蛮': 1,
    u'蛰': 1,
    u'蛱': 1,
    u'蛲': 1,
    u'蛳': 1,
    u'蛴': 1,
    u'蛺': 2,
    u'蛻': 2,
    u'蜆': 2,
    u'蜕': 1,
    u'蜗': 1,
    u'蜡': 3,
    u'蝇': 1,
    u'蝈': 1,
    u'蝉': 1,
    u'蝕': 2,
    u'蝟': 2,
    u'蝦': 2,
    u'蝸': 2,
    u'蝼': 1,
    u'蝾': 1,
    u'螀': 1,
    u'螄': 2,
    u'螞': 2,
    u'螢': 2,
    u'螨': 1,
    u'螮': 2,
    u'螻': 2,
    u'螿': 2,
    u'蟄': 2,
    u'蟈': 2,
    u'蟎': 2,
    u'蟏': 1,
    u'蟣': 2,
    u'蟬': 2,
    u'蟯': 2,
    u'蟲': 2,
    u'蟶': 2,
    u'蟻': 2,
    u'蠁': 2,
    u'蠅': 2,
    u'蠆': 2,
    u'蠐': 2,
    u'蠑': 2,
    u'蠟': 2,
    u'蠣': 2,
    u'蠨': 2,
    u'蠱': 2,
    u'蠶': 2,
    u'蠻': 2,
    u'衅': 1,
    u'術': 2,
    u'衔': 1,
    u'衕': 2,
    u'衚': 2,
    u'衛': 2,
    u'衝': 2,
    u'补': 1,
    u'表': 3,
    u'衬': 1,
    u'衮': 1,
    u'袄': 1,
    u'袅': 1,
    u'袆': 1,
    u'袜': 1,
    u'袞': 2,
    u'袭': 1,
    u'袯': 1,
    u'装': 1,
    u'裆': 1,
    u'裈': 1,
    u'裊': 2,
    u'補': 2,
    u'裝': 2,
    u'裡': 2,
    u'裢': 1,
    u'裣': 1,
    u'裤': 1,
    u'裥': 1,
    u'製': 2,
    u'複': 2,
    u'褌': 2,
    u'褘': 2,
    u'褛': 1,
    u'褲': 2,
    u'褳': 2,
    u'褴': 1,
    u'褸': 2,
    u'褻': 2,
    u'襀': 2,
    u'襉': 2,
    u'襏': 2,
    u'襕': 1,
    u'襖': 2,
    u'襝': 2,
    u'襠': 2,
    u'襤': 2,
    u'襪': 2,
    u'襬': 2,
    u'襯': 2,
    u'襲': 2,
    u'襴': 2,
    u'覆': 3,
    u'見': 2,
    u'覎': 2,
    u'規': 2,
    u'覓': 2,
    u'視': 2,
    u'覘': 2,
    u'覡': 2,
    u'覥': 2,
    u'覦': 2,
    u'親': 2,
    u'覬': 2,
    u'覯': 2,
    u'覲': 2,
    u'覷': 2,
    u'覺': 2,
    u'覼': 2,
    u'覽': 2,
    u'覿': 2,
    u'觀': 2,
    u'见': 1,
    u'观': 1,
    u'觃': 1,
    u'规': 1,
    u'觅': 1,
    u'视': 1,
    u'觇': 1,
    u'览': 1,
    u'觉': 1,
    u'觊': 1,
    u'觋': 1,
    u'觌': 1,
    u'觍': 1,
    u'觎': 1,
    u'觏': 1,
    u'觐': 1,
    u'觑': 1,
    u'觞': 1,
    u'触': 1,
    u'觯': 1,
    u'觴': 2,
    u'觶': 2,
    u'觸': 2,
    u'訁': 2,
    u'訂': 2,
    u'訃': 2,
    u'計': 2,
    u'訊': 2,
    u'訌': 2,
    u'討': 2,
    u'訐': 2,
    u'訑': 2,
    u'訒': 2,
    u'訓': 2,
    u'訕': 2,
    u'訖': 2,
    u'託': 2,
    u'記': 2,
    u'訚': 1,
    u'訛': 2,
    u'訝': 2,
    u'訟': 2,
    u'訢': 2,
    u'訣': 2,
    u'訥': 2,
    u'訩': 2,
    u'訪': 2,
    u'設': 2,
    u'許': 2,
    u'訴': 2,
    u'訶': 2,
    u'診': 2,
    u'註': 2,
    u'詀': 2,
    u'詁': 2,
    u'詆': 2,
    u'詎': 2,
    u'詐': 2,
    u'詑': 2,
    u'詒': 2,
    u'詔': 2,
    u'評': 2,
    u'詖': 2,
    u'詗': 2,
    u'詘': 2,
    u'詛': 2,
    u'詞': 2,
    u'詟': 1,
    u'詠': 2,
    u'詡': 2,
    u'詢': 2,
    u'詣': 2,
    u'試': 2,
    u'詩': 2,
    u'詫': 2,
    u'詬': 2,
    u'詭': 2,
    u'詮': 2,
    u'詰': 2,
    u'話': 2,
    u'該': 2,
    u'詳': 2,
    u'詵': 2,
    u'詼': 2,
    u'詿': 2,
    u'誄': 2,
    u'誅': 2,
    u'誆': 2,
    u'誇': 2,
    u'誉': 1,
    u'誊': 1,
    u'誌': 2,
    u'認': 2,
    u'誑': 2,
    u'誒': 2,
    u'誕': 2,
    u'誘': 2,
    u'誚': 2,
    u'語': 2,
    u'誠': 2,
    u'誡': 2,
    u'誣': 2,
    u'誤': 2,
    u'誥': 2,
    u'誦': 2,
    u'誨': 2,
    u'說': 2,
    u'誰': 2,
    u'課': 2,
    u'誶': 2,
    u'誹': 2,
    u'誼': 2,
    u'誾': 2,
    u'調': 2,
    u'諂': 2,
    u'諄': 2,
    u'談': 2,
    u'諉': 2,
    u'請': 2,
    u'諍': 2,
    u'諏': 2,
    u'諑': 2,
    u'諒': 2,
    u'論': 2,
    u'諗': 2,
    u'諛': 2,
    u'諜': 2,
    u'諝': 2,
    u'諞': 2,
    u'諢': 2,
    u'諤': 2,
    u'諦': 2,
    u'諧': 2,
    u'諫': 2,
    u'諭': 2,
    u'諮': 2,
    u'諰': 2,
    u'諱': 2,
    u'諳': 2,
    u'諶': 2,
    u'諷': 2,
    u'諸': 2,
    u'諺': 2,
    u'諼': 2,
    u'諾': 2,
    u'謀': 2,
    u'謁': 2,
    u'謂': 2,
    u'謄': 2,
    u'謅': 2,
    u'謊': 2,
    u'謎': 2,
    u'謏': 2,
    u'謐': 2,
    u'謔': 2,
    u'謖': 2,
    u'謗': 2,
    u'謙': 2,
    u'謚': 2,
    u'講': 2,
    u'謝': 2,
    u'謠': 2,
    u'謨': 2,
    u'謫': 2,
    u'謬': 2,
    u'謳': 2,
    u'謹': 2,
    u'謾': 2,
    u'證': 2,
    u'譊': 2,
    u'譎': 2,
    u'譏': 2,
    u'譖': 2,
    u'識': 2,
    u'譙': 2,
    u'譚': 2,
    u'譜': 2,
    u'譫': 2,
    u'譯': 2,
    u'議': 2,
    u'譴': 2,
    u'護': 2,
    u'譸': 2,
    u'譽': 2,
    u'譾': 2,
    u'讀': 2,
    u'變': 2,
    u'讋': 2,
    u'讌': 2,
    u'讎': 2,
    u'讒': 2,
    u'讓': 2,
    u'讕': 2,
    u'讖': 2,
    u'讜': 2,
    u'讞': 2,
    u'讠': 1,
    u'计': 1,
    u'订': 1,
    u'讣': 1,
    u'认': 1,
    u'讥': 1,
    u'讦': 1,
    u'讧': 1,
    u'讨': 1,
    u'让': 1,
    u'讪': 1,
    u'讫': 1,
    u'讬': 1,
    u'训': 1,
    u'议': 1,
    u'讯': 1,
    u'记': 1,
    u'讱': 1,
    u'讲': 1,
    u'讳': 1,
    u'讴': 1,
    u'讵': 1,
    u'讶': 1,
    u'讷': 1,
    u'许': 1,
    u'讹': 1,
    u'论': 1,
    u'讻': 1,
    u'讼': 1,
    u'讽': 1,
    u'设': 1,
    u'访': 1,
    u'诀': 1,
    u'证': 1,
    u'诂': 1,
    u'诃': 1,
    u'评': 1,
    u'诅': 1,
    u'识': 1,
    u'诇': 1,
    u'诈': 1,
    u'诉': 1,
    u'诊': 1,
    u'诋': 1,
    u'诌': 1,
    u'词': 1,
    u'诎': 1,
    u'诏': 1,
    u'诐': 1,
    u'译': 1,
    u'诒': 1,
    u'诓': 1,
    u'诔': 1,
    u'试': 1,
    u'诖': 1,
    u'诗': 1,
    u'诘': 1,
    u'诙': 1,
    u'诚': 1,
    u'诛': 1,
    u'诜': 1,
    u'话': 1,
    u'诞': 1,
    u'诟': 1,
    u'诠': 1,
    u'诡': 1,
    u'询': 1,
    u'诣': 1,
    u'诤': 1,
    u'该': 1,
    u'详': 1,
    u'诧': 1,
    u'诨': 1,
    u'诩': 1,
    u'诪': 1,
    u'诫': 1,
    u'诬': 1,
    u'语': 1,
    u'诮': 1,
    u'误': 1,
    u'诰': 1,
    u'诱': 1,
    u'诲': 1,
    u'诳': 1,
    u'说': 1,
    u'诵': 1,
    u'诶': 1,
    u'请': 1,
    u'诸': 1,
    u'诹': 1,
    u'诺': 1,
    u'读': 1,
    u'诼': 1,
    u'诽': 1,
    u'课': 1,
    u'诿': 1,
    u'谀': 1,
    u'谁': 1,
    u'谂': 1,
    u'调': 1,
    u'谄': 1,
    u'谅': 1,
    u'谆': 1,
    u'谇': 1,
    u'谈': 1,
    u'谊': 1,
    u'谋': 1,
    u'谌': 1,
    u'谍': 1,
    u'谎': 1,
    u'谏': 1,
    u'谐': 1,
    u'谑': 1,
    u'谒': 1,
    u'谓': 1,
    u'谔': 1,
    u'谕': 1,
    u'谖': 1,
    u'谗': 1,
    u'谘': 1,
    u'谙': 1,
    u'谚': 1,
    u'谛': 1,
    u'谜': 1,
    u'谝': 1,
    u'谞': 1,
    u'谟': 1,
    u'谠': 1,
    u'谡': 1,
    u'谢': 1,
    u'谣': 1,
    u'谤': 1,
    u'谥': 1,
    u'谦': 1,
    u'谧': 1,
    u'谨': 1,
    u'谩': 1,
    u'谪': 1,
    u'谫': 1,
    u'谬': 1,
    u'谭': 1,
    u'谮': 1,
    u'谯': 1,
    u'谰': 1,
    u'谱': 1,
    u'谲': 1,
    u'谳': 1,
    u'谴': 1,
    u'谵': 1,
    u'谶': 1,
    u'谷': 1,
    u'豈': 2,
    u'豎': 2,
    u'豐': 2,
    u'豬': 2,
    u'豮': 1,
    u'豶': 2,
    u'貓': 2,
    u'貙': 2,
    u'貝': 2,
    u'貞': 2,
    u'貟': 2,
    u'負': 2,
    u'財': 2,
    u'貢': 2,
    u'貧': 2,
    u'貨': 2,
    u'販': 2,
    u'貪': 2,
    u'貫': 2,
    u'責': 2,
    u'貯': 2,
    u'貰': 2,
    u'貲': 2,
    u'貳': 2,
    u'貴': 2,
    u'貶': 2,
    u'買': 2,
    u'貸': 2,
    u'貺': 2,
    u'費': 2,
    u'貼': 2,
    u'貽': 2,
    u'貿': 2,
    u'賀': 2,
    u'賁': 2,
    u'賂': 2,
    u'賃': 2,
    u'賄': 2,
    u'賅': 2,
    u'資': 2,
    u'賈': 2,
    u'賊': 2,
    u'賑': 2,
    u'賒': 2,
    u'賓': 2,
    u'賕': 2,
    u'賙': 2,
    u'賚': 2,
    u'賜': 2,
    u'賞': 2,
    u'賟': 2,
    u'賠': 2,
    u'賡': 2,
    u'賢': 2,
    u'賣': 2,
    u'賤': 2,
    u'賦': 2,
    u'賧': 2,
    u'質': 2,
    u'賬': 2,
    u'賭': 2,
    u'賰': 2,
    u'賴': 2,
    u'賵': 2,
    u'賺': 2,
    u'賻': 2,
    u'購': 2,
    u'賽': 2,
    u'賾': 2,
    u'贃': 2,
    u'贄': 2,
    u'贅': 2,
    u'贇': 2,
    u'贈': 2,
    u'贊': 2,
    u'贍': 2,
    u'贏': 2,
    u'贐': 2,
    u'贓': 2,
    u'贔': 2,
    u'贖': 2,
    u'贗': 2,
    u'贛': 2,
    u'贝': 1,
    u'贞': 1,
    u'负': 1,
    u'贠': 1,
    u'贡': 1,
    u'财': 1,
    u'责': 1,
    u'贤': 1,
    u'败': 1,
    u'账': 1,
    u'货': 1,
    u'质': 1,
    u'贩': 1,
    u'贪': 1,
    u'贫': 1,
    u'贬': 1,
    u'购': 1,
    u'贮': 1,
    u'贯': 1,
    u'贰': 1,
    u'贱': 1,
    u'贲': 1,
    u'贳': 1,
    u'贴': 1,
    u'贵': 1,
    u'贶': 1,
    u'贷': 1,
    u'贸': 1,
    u'费': 1,
    u'贺': 1,
    u'贻': 1,
    u'贼': 1,
    u'贽': 1,
    u'贾': 1,
    u'贿': 1,
    u'赀': 1,
    u'赁': 1,
    u'赂': 1,
    u'赃': 1,
    u'资': 1,
    u'赅': 1,
    u'赆': 1,
    u'赇': 1,
    u'赈': 1,
    u'赉': 1,
    u'赊': 1,
    u'赋': 1,
    u'赌': 1,
    u'赍': 1,
    u'赎': 1,
    u'赏': 1,
    u'赐': 1,
    u'赑': 1,
    u'赒': 1,
    u'赓': 1,
    u'赔': 1,
    u'赕': 1,
    u'赖': 1,
    u'赗': 1,
    u'赘': 1,
    u'赙': 1,
    u'赚': 1,
    u'赛': 1,
    u'赜': 1,
    u'赝': 1,
    u'赞': 1,
    u'赟': 1,
    u'赠': 1,
    u'赡': 1,
    u'赢': 1,
    u'赣': 1,
    u'赪': 1,
    u'赬': 2,
    u'赵': 1,
    u'赶': 1,
    u'趋': 1,
    u'趕': 2,
    u'趙': 2,
    u'趨': 2,
    u'趱': 1,
    u'趲': 2,
    u'趸': 1,
    u'跃': 1,
    u'跄': 1,
    u'跞': 1,
    u'跡': 2,
    u'践': 1,
    u'跶': 1,
    u'跷': 1,
    u'跸': 1,
    u'跹': 1,
    u'跻': 1,
    u'踊': 1,
    u'踌': 1,
    u'踐': 2,
    u'踪': 1,
    u'踬': 1,
    u'踯': 1,
    u'踴': 2,
    u'蹌': 2,
    u'蹑': 1,
    u'蹒': 1,
    u'蹕': 2,
    u'蹣': 2,
    u'蹤': 2,
    u'蹰': 1,
    u'蹺': 2,
    u'蹻': 2,
    u'蹿': 1,
    u'躂': 2,
    u'躉': 2,
    u'躊': 2,
    u'躋': 2,
    u'躍': 2,
    u'躎': 2,
    u'躏': 1,
    u'躑': 2,
    u'躒': 2,
    u'躓': 2,
    u'躕': 2,
    u'躚': 2,
    u'躜': 1,
    u'躝': 2,
    u'躡': 2,
    u'躥': 2,
    u'躦': 2,
    u'躪': 2,
    u'躯': 1,
    u'軀': 2,
    u'軉': 2,
    u'車': 2,
    u'軋': 2,
    u'軌': 2,
    u'軍': 2,
    u'軏': 2,
    u'軑': 2,
    u'軒': 2,
    u'軔': 2,
    u'軗': 2,
    u'軛': 2,
    u'軟': 2,
    u'軤': 2,
    u'軨': 2,
    u'軫': 2,
    u'軲': 2,
    u'軸': 2,
    u'軹': 2,
    u'軺': 2,
    u'軻': 2,
    u'軼': 2,
    u'軾': 2,
    u'較': 2,
    u'輄': 2,
    u'輅': 2,
    u'輇': 2,
    u'輈': 2,
    u'載': 2,
    u'輊': 2,
    u'輒': 2,
    u'輓': 2,
    u'輔': 2,
    u'輕': 2,
    u'輗': 2,
    u'輛': 2,
    u'輜': 2,
    u'輝': 2,
    u'輞': 2,
    u'輟': 2,
    u'輥': 2,
    u'輦': 2,
    u'輩': 2,
    u'輪': 2,
    u'輬': 2,
    u'輮': 2,
    u'輯': 2,
    u'輳': 2,
    u'輸': 2,
    u'輻': 2,
    u'輾': 2,
    u'輿': 2,
    u'轀': 2,
    u'轂': 2,
    u'轄': 2,
    u'轅': 2,
    u'轆': 2,
    u'轉': 2,
    u'轍': 2,
    u'轎': 2,
    u'轔': 2,
    u'轟': 2,
    u'轡': 2,
    u'轢': 2,
    u'轣': 2,
    u'轤': 2,
    u'车': 1,
    u'轧': 1,
    u'轨': 1,
    u'轩': 1,
    u'轪': 1,
    u'轫': 1,
    u'转': 1,
    u'轭': 1,
    u'轮': 1,
    u'软': 1,
    u'轰': 1,
    u'轱': 1,
    u'轲': 1,
    u'轳': 1,
    u'轴': 1,
    u'轵': 1,
    u'轶': 1,
    u'轷': 1,
    u'轸': 1,
    u'轹': 1,
    u'轺': 1,
    u'轻': 1,
    u'轼': 1,
    u'载': 1,
    u'轾': 1,
    u'轿': 1,
    u'辀': 1,
    u'辁': 1,
    u'辂': 1,
    u'较': 1,
    u'辄': 1,
    u'辅': 1,
    u'辆': 1,
    u'辇': 1,
    u'辈': 1,
    u'辉': 1,
    u'辊': 1,
    u'辋': 1,
    u'辌': 1,
    u'辍': 1,
    u'辎': 1,
    u'辏': 1,
    u'辐': 1,
    u'辑': 1,
    u'辒': 1,
    u'输': 1,
    u'辔': 1,
    u'辕': 1,
    u'辖': 1,
    u'辗': 1,
    u'辘': 1,
    u'辙': 1,
    u'辚': 1,
    u'辞': 1,
    u'辦': 2,
    u'辩': 1,
    u'辫': 1,
    u'辭': 2,
    u'辮': 2,
    u'辯': 2,
    u'農': 2,
    u'边': 1,
    u'辽': 1,
    u'达': 1,
    u'迁': 1,
    u'过': 1,
    u'迈': 1,
    u'运': 1,
    u'还': 1,
    u'这': 1,
    u'进': 1,
    u'远': 1,
    u'违': 1,
    u'连': 1,
    u'迟': 1,
    u'迩': 1,
    u'迳': 1,
    u'迹': 1,
    u'适': 1,
    u'选': 1,
    u'逊': 1,
    u'递': 1,
    u'逕': 2,
    u'這': 2,
    u'連': 2,
    u'逦': 1,
    u'進': 2,
    u'逻': 1,
    u'運': 2,
    u'過': 2,
    u'達': 2,
    u'違': 2,
    u'遗': 1,
    u'遙': 2,
    u'遜': 2,
    u'遞': 2,
    u'遠': 2,
    u'遥': 1,
    u'適': 2,
    u'遲': 2,
    u'遷': 2,
    u'選': 2,
    u'遺': 2,
    u'遼': 2,
    u'邁': 2,
    u'還': 2,
    u'邇': 2,
    u'邊': 2,
    u'邏': 2,
    u'邐': 2,
    u'邓': 1,
    u'邝': 1,
    u'邬': 1,
    u'邮': 1,
    u'邹': 1,
    u'邺': 1,
    u'邻': 1,
    u'郁': 1,
    u'郏': 1,
    u'郐': 1,
    u'郑': 1,
    u'郓': 1,
    u'郟': 2,
    u'郦': 1,
    u'郧': 1,
    u'郵': 2,
    u'郸': 1,
    u'鄆': 2,
    u'鄉': 2,
    u'鄒': 2,
    u'鄔': 2,
    u'鄖': 2,
    u'鄧': 2,
    u'鄭': 2,
    u'鄰': 2,
    u'鄲': 2,
    u'鄴': 2,
    u'鄶': 2,
    u'鄺': 2,
    u'酂': 1,
    u'酇': 2,
    u'酈': 2,
    u'酝': 1,
    u'酦': 1,
    u'酱': 1,
    u'酽': 1,
    u'酾': 1,
    u'酿': 1,
    u'醜': 2,
    u'醞': 2,
    u'醫': 2,
    u'醬': 2,
    u'醱': 2,
    u'釀': 2,
    u'釁': 2,
    u'釃': 2,
    u'釅': 2,
    u'采': 1,
    u'释': 1,
    u'釋': 2,
    u'里': 1,
    u'釐': 2,
    u'釒': 2,
    u'釓': 2,
    u'釔': 2,
    u'釕': 2,
    u'釗': 2,
    u'釘': 2,
    u'釙': 2,
    u'針': 2,
    u'釣': 2,
    u'釤': 2,
    u'釧': 2,
    u'釩': 2,
    u'釳': 2,
    u'釵': 2,
    u'釷': 2,
    u'釹': 2,
    u'釺': 2,
    u'釾': 2,
    u'鈀': 2,
    u'鈁': 2,
    u'鈃': 2,
    u'鈄': 2,
    u'鈇': 2,
    u'鈈': 2,
    u'鈉': 2,
    u'鈋': 2,
    u'鈍': 2,
    u'鈐': 2,
    u'鈑': 2,
    u'鈒': 2,
    u'鈔': 2,
    u'鈕': 2,
    u'鈞': 2,
    u'鈠': 2,
    u'鈣': 2,
    u'鈥': 2,
    u'鈦': 2,
    u'鈧': 2,
    u'鈮': 2,
    u'鈯': 2,
    u'鈰': 2,
    u'鈲': 2,
    u'鈳': 2,
    u'鈴': 2,
    u'鈷': 2,
    u'鈸': 2,
    u'鈹': 2,
    u'鈺': 2,
    u'鈽': 2,
    u'鈾': 2,
    u'鈿': 2,
    u'鉀': 2,
    u'鉁': 2,
    u'鉅': 2,
    u'鉈': 2,
    u'鉉': 2,
    u'鉋': 2,
    u'鉍': 2,
    u'鉑': 2,
    u'鉕': 2,
    u'鉗': 2,
    u'鉚': 2,
    u'鉛': 2,
    u'鉞': 2,
    u'鉤': 2,
    u'鉦': 2,
    u'鉬': 2,
    u'鉭': 2,
    u'鉴': 1,
    u'鉶': 2,
    u'鉸': 2,
    u'鉺': 2,
    u'鉻': 2,
    u'鉿': 2,
    u'銀': 2,
    u'銃': 2,
    u'銅': 2,
    u'銍': 2,
    u'銑': 2,
    u'銓': 2,
    u'銖': 2,
    u'銘': 2,
    u'銚': 2,
    u'銛': 2,
    u'銜': 2,
    u'銠': 2,
    u'銣': 2,
    u'銥': 2,
    u'銦': 2,
    u'銨': 2,
    u'銩': 2,
    u'銪': 2,
    u'銫': 2,
    u'銬': 2,
    u'銮': 1,
    u'銱': 2,
    u'銳': 2,
    u'銶': 2,
    u'銷': 2,
    u'銻': 2,
    u'銼': 2,
    u'鋁': 2,
    u'鋃': 2,
    u'鋅': 2,
    u'鋇': 2,
    u'鋉': 2,
    u'鋌': 2,
    u'鋏': 2,
    u'鋒': 2,
    u'鋙': 2,
    u'鋝': 2,
    u'鋟': 2,
    u'鋣': 2,
    u'鋤': 2,
    u'鋥': 2,
    u'鋦': 2,
    u'鋨': 2,
    u'鋩': 2,
    u'鋪': 2,
    u'鋮': 2,
    u'鋯': 2,
    u'鋰': 2,
    u'鋱': 2,
    u'鋶': 2,
    u'鋸': 2,
    u'鋼': 2,
    u'錁': 2,
    u'錂': 2,
    u'錄': 2,
    u'錆': 2,
    u'錇': 2,
    u'錈': 2,
    u'錏': 2,
    u'錐': 2,
    u'錒': 2,
    u'錕': 2,
    u'錘': 2,
    u'錙': 2,
    u'錚': 2,
    u'錛': 2,
    u'錟': 2,
    u'錠': 2,
    u'錡': 2,
    u'錢': 2,
    u'錦': 2,
    u'錨': 2,
    u'錩': 2,
    u'錫': 2,
    u'錮': 2,
    u'錯': 2,
    u'錳': 2,
    u'錶': 2,
    u'錸': 2,
    u'錾': 1,
    u'鍀': 2,
    u'鍃': 2,
    u'鍄': 2,
    u'鍆': 2,
    u'鍇': 2,
    u'鍈': 2,
    u'鍋': 2,
    u'鍍': 2,
    u'鍔': 2,
    u'鍘': 2,
    u'鍚': 2,
    u'鍛': 2,
    u'鍠': 2,
    u'鍤': 2,
    u'鍥': 2,
    u'鍩': 2,
    u'鍬': 2,
    u'鍮': 2,
    u'鍰': 2,
    u'鍵': 2,
    u'鍶': 2,
    u'鍺': 2,
    u'鍾': 2,
    u'鎂': 2,
    u'鎄': 2,
    u'鎇': 2,
    u'鎊': 2,
    u'鎔': 2,
    u'鎖': 2,
    u'鎘': 2,
    u'鎛': 2,
    u'鎝': 2,
    u'鎡': 2,
    u'鎢': 2,
    u'鎣': 2,
    u'鎦': 2,
    u'鎧': 2,
    u'鎩': 2,
    u'鎪': 2,
    u'鎬': 2,
    u'鎮': 2,
    u'鎯': 2,
    u'鎰': 2,
    u'鎲': 2,
    u'鎳': 2,
    u'鎵': 2,
    u'鎶': 2,
    u'鎷': 2,
    u'鎿': 2,
    u'鏃': 2,
    u'鏆': 2,
    u'鏇': 2,
    u'鏈': 2,
    u'鏉': 2,
    u'鏌': 2,
    u'鏍': 2,
    u'鏐': 2,
    u'鏑': 2,
    u'鏗': 2,
    u'鏘': 2,
    u'鏜': 2,
    u'鏝': 2,
    u'鏞': 2,
    u'鏟': 2,
    u'鏡': 2,
    u'鏢': 2,
    u'鏤': 2,
    u'鏦': 2,
    u'鏨': 2,
    u'鏰': 2,
    u'鏵': 2,
    u'鏷': 2,
    u'鏹': 2,
    u'鏺': 2,
    u'鏽': 2,
    u'鐃': 2,
    u'鐄': 2,
    u'鐋': 2,
    u'鐍': 2,
    u'鐎': 2,
    u'鐏': 2,
    u'鐐': 2,
    u'鐒': 2,
    u'鐓': 2,
    u'鐔': 2,
    u'鐘': 2,
    u'鐙': 2,
    u'鐠': 2,
    u'鐥': 2,
    u'鐦': 2,
    u'鐧': 2,
    u'鐨': 2,
    u'鐫': 2,
    u'鐮': 2,
    u'鐯': 2,
    u'鐲': 2,
    u'鐳': 2,
    u'鐵': 2,
    u'鐶': 2,
    u'鐸': 2,
    u'鐺': 2,
    u'鐿': 2,
    u'鑄': 2,
    u'鑊': 2,
    u'鑌': 2,
    u'鑒': 2,
    u'鑔': 2,
    u'鑕': 2,
    u'鑞': 2,
    u'鑠': 2,
    u'鑣': 2,
    u'鑥': 2,
    u'鑭': 2,
    u'鑰': 2,
    u'鑱': 2,
    u'鑲': 2,
    u'鑷': 2,
    u'鑹': 2,
    u'鑼': 2,
    u'鑽': 2,
    u'鑾': 2,
    u'鑿': 2,
    u'钁': 2,
    u'钅': 1,
    u'钆': 1,
    u'钇': 1,
    u'针': 1,
    u'钉': 1,
    u'钊': 1,
    u'钋': 1,
    u'钌': 1,
    u'钍': 1,
    u'钎': 1,
    u'钏': 1,
    u'钐': 1,
    u'钑': 1,
    u'钒': 1,
    u'钓': 1,
    u'钔': 1,
    u'钕': 1,
    u'钖': 1,
    u'钗': 1,
    u'钘': 1,
    u'钙': 1,
    u'钚': 1,
    u'钛': 1,
    u'钜': 1,
    u'钝': 1,
    u'钞': 1,
    u'钟': 1,
    u'钠': 1,
    u'钡': 1,
    u'钢': 1,
    u'钣': 1,
    u'钤': 1,
    u'钥': 1,
    u'钦': 1,
    u'钧': 1,
    u'钨': 1,
    u'钩': 1,
    u'钪': 1,
    u'钫': 1,
    u'钬': 1,
    u'钭': 1,
    u'钮': 1,
    u'钯': 1,
    u'钰': 1,
    u'钱': 1,
    u'钲': 1,
    u'钳': 1,
    u'钴': 1,
    u'钵': 1,
    u'钶': 1,
    u'钷': 1,
    u'钸': 1,
    u'钹': 1,
    u'钺': 1,
    u'钻': 1,
    u'钼': 1,
    u'钽': 1,
    u'钾': 1,
    u'钿': 1,
    u'铀': 1,
    u'铁': 1,
    u'铂': 1,
    u'铃': 1,
    u'铄': 1,
    u'铅': 1,
    u'铆': 1,
    u'铇': 1,
    u'铈': 1,
    u'铉': 1,
    u'铊': 1,
    u'铋': 1,
    u'铌': 1,
    u'铍': 1,
    u'铎': 1,
    u'铏': 1,
    u'铐': 1,
    u'铑': 1,
    u'铒': 1,
    u'铓': 1,
    u'铔': 1,
    u'铕': 1,
    u'铖': 1,
    u'铗': 1,
    u'铘': 1,
    u'铙': 1,
    u'铚': 1,
    u'铛': 1,
    u'铜': 1,
    u'铝': 1,
    u'铞': 1,
    u'铟': 1,
    u'铠': 1,
    u'铡': 1,
    u'铢': 1,
    u'铣': 1,
    u'铤': 1,
    u'铥': 1,
    u'铦': 1,
    u'铧': 1,
    u'铨': 1,
    u'铩': 1,
    u'铪': 1,
    u'铫': 1,
    u'铬': 1,
    u'铭': 1,
    u'铮': 1,
    u'铯': 1,
    u'铰': 1,
    u'铱': 1,
    u'铲': 1,
    u'铳': 1,
    u'铴': 1,
    u'铵': 1,
    u'银': 1,
    u'铷': 1,
    u'铸': 1,
    u'铹': 1,
    u'铺': 1,
    u'铻': 1,
    u'铼': 1,
    u'铽': 1,
    u'链': 1,
    u'铿': 1,
    u'销': 1,
    u'锁': 1,
    u'锂': 1,
    u'锃': 1,
    u'锄': 1,
    u'锅': 1,
    u'锆': 1,
    u'锇': 1,
    u'锈': 1,
    u'锉': 1,
    u'锊': 1,
    u'锋': 1,
    u'锌': 1,
    u'锍': 1,
    u'锎': 1,
    u'锏': 1,
    u'锐': 1,
    u'锑': 1,
    u'锒': 1,
    u'锓': 1,
    u'锔': 1,
    u'锕': 1,
    u'锖': 1,
    u'锗': 1,
    u'锘': 1,
    u'错': 1,
    u'锚': 1,
    u'锛': 1,
    u'锜': 1,
    u'锝': 1,
    u'锞': 1,
    u'锟': 1,
    u'锠': 1,
    u'锡': 1,
    u'锢': 1,
    u'锣': 1,
    u'锤': 1,
    u'锥': 1,
    u'锦': 1,
    u'锧': 1,
    u'锨': 1,
    u'锩': 1,
    u'锪': 1,
    u'锫': 1,
    u'锬': 1,
    u'锭': 1,
    u'键': 1,
    u'锯': 1,
    u'锰': 1,
    u'锱': 1,
    u'锲': 1,
    u'锳': 1,
    u'锴': 1,
    u'锵': 1,
    u'锶': 1,
    u'锷': 1,
    u'锸': 1,
    u'锹': 1,
    u'锺': 1,
    u'锻': 1,
    u'锼': 1,
    u'锽': 1,
    u'锾': 1,
    u'锿': 1,
    u'镀': 1,
    u'镁': 1,
    u'镂': 1,
    u'镃': 1,
    u'镄': 1,
    u'镅': 1,
    u'镆': 1,
    u'镇': 1,
    u'镈': 1,
    u'镉': 1,
    u'镊': 1,
    u'镋': 1,
    u'镌': 1,
    u'镍': 1,
    u'镎': 1,
    u'镏': 1,
    u'镐': 1,
    u'镑': 1,
    u'镒': 1,
    u'镓': 1,
    u'镔': 1,
    u'镕': 1,
    u'镖': 1,
    u'镗': 1,
    u'镘': 1,
    u'镙': 1,
    u'镚': 1,
    u'镛': 1,
    u'镜': 1,
    u'镝': 1,
    u'镞': 1,
    u'镟': 1,
    u'镠': 1,
    u'镡': 1,
    u'镢': 1,
    u'镣': 1,
    u'镤': 1,
    u'镥': 1,
    u'镦': 1,
    u'镧': 1,
    u'镨': 1,
    u'镩': 1,
    u'镪': 1,
    u'镫': 1,
    u'镬': 1,
    u'镭': 1,
    u'镮': 1,
    u'镯': 1,
    u'镰': 1,
    u'镱': 1,
    u'镲': 1,
    u'镳': 1,
    u'镴': 1,
    u'镵': 1,
    u'镶': 1,
    u'長': 2,
    u'长': 1,
    u'門': 2,
    u'閂': 2,
    u'閃': 2,
    u'閆': 2,
    u'閈': 2,
    u'閉': 2,
    u'開': 2,
    u'閌': 2,
    u'閍': 2,
    u'閎': 2,
    u'閏': 2,
    u'閐': 2,
    u'閑': 2,
    u'間': 2,
    u'閔': 2,
    u'閘': 2,
    u'閡': 2,
    u'閣': 2,
    u'閥': 2,
    u'閨': 2,
    u'閩': 2,
    u'閫': 2,
    u'閬': 2,
    u'閭': 2,
    u'閱': 2,
    u'閶': 2,
    u'閹': 2,
    u'閻': 2,
    u'閼': 2,
    u'閽': 2,
    u'閾': 2,
    u'閿': 2,
    u'闃': 2,
    u'闆': 2,
    u'闈': 2,
    u'闊': 2,
    u'闋': 2,
    u'闌': 2,
    u'闍': 2,
    u'闐': 2,
    u'闒': 2,
    u'闓': 2,
    u'闔': 2,
    u'闕': 2,
    u'闖': 2,
    u'關': 2,
    u'闞': 2,
    u'闠': 2,
    u'闡': 2,
    u'闤': 2,
    u'闥': 2,
    u'门': 1,
    u'闩': 1,
    u'闪': 1,
    u'闫': 1,
    u'闬': 1,
    u'闭': 1,
    u'问': 1,
    u'闯': 1,
    u'闰': 1,
    u'闱': 1,
    u'闲': 1,
    u'闳': 1,
    u'间': 1,
    u'闵': 1,
    u'闶': 1,
    u'闷': 1,
    u'闸': 1,
    u'闹': 1,
    u'闺': 1,
    u'闻': 1,
    u'闼': 1,
    u'闽': 1,
    u'闾': 1,
    u'闿': 1,
    u'阀': 1,
    u'阁': 1,
    u'阂': 1,
    u'阃': 1,
    u'阄': 1,
    u'阅': 1,
    u'阆': 1,
    u'阇': 1,
    u'阈': 1,
    u'阉': 1,
    u'阊': 1,
    u'阋': 1,
    u'阌': 1,
    u'阍': 1,
    u'阎': 1,
    u'阏': 1,
    u'阐': 1,
    u'阑': 1,
    u'阒': 1,
    u'阓': 1,
    u'阔': 1,
    u'阕': 1,
    u'阖': 1,
    u'阗': 1,
    u'阘': 1,
    u'阙': 1,
    u'阚': 1,
    u'阛': 1,
    u'队': 1,
    u'阪': 2,
    u'阳': 1,
    u'阴': 1,
    u'阵': 1,
    u'阶': 1,
    u'际': 1,
    u'陆': 1,
    u'陇': 1,
    u'陈': 1,
    u'陉': 1,
    u'陕': 1,
    u'陘': 2,
    u'陝': 2,
    u'陣': 2,
    u'陧': 1,
    u'陨': 1,
    u'险': 1,
    u'陰': 2,
    u'陳': 2,
    u'陸': 2,
    u'陽': 2,
    u'隉': 2,
    u'隊': 2,
    u'階': 2,
    u'随': 1,
    u'隐': 1,
    u'隕': 2,
    u'際': 2,
    u'隨': 2,
    u'險': 2,
    u'隱': 2,
    u'隴': 2,
    u'隶': 1,
    u'隸': 2,
    u'隻': 2,
    u'隽': 1,
    u'难': 1,
    u'雋': 2,
    u'雏': 1,
    u'雖': 2,
    u'雙': 2,
    u'雛': 2,
    u'雜': 2,
    u'雞': 2,
    u'雠': 1,
    u'離': 2,
    u'難': 2,
    u'雲': 2,
    u'雳': 1,
    u'電': 2,
    u'雾': 1,
    u'霁': 1,
    u'霡': 1,
    u'霢': 2,
    u'霧': 2,
    u'霭': 1,
    u'霽': 2,
    u'靂': 2,
    u'靄': 2,
    u'靈': 2,
    u'靓': 1,
    u'静': 1,
    u'靚': 2,
    u'靜': 2,
    u'面': 3,
    u'靥': 1,
    u'靦': 2,
    u'靨': 2,
    u'鞀': 2,
    u'鞏': 2,
    u'鞑': 1,
    u'鞒': 1,
    u'鞝': 2,
    u'鞯': 1,
    u'鞽': 2,
    u'韁': 2,
    u'韃': 2,
    u'韉': 2,
    u'韋': 2,
    u'韌': 2,
    u'韍': 2,
    u'韓': 2,
    u'韙': 2,
    u'韜': 2,
    u'韞': 2,
    u'韦': 1,
    u'韧': 1,
    u'韨': 1,
    u'韩': 1,
    u'韪': 1,
    u'韫': 1,
    u'韬': 1,
    u'韵': 1,
    u'韻': 2,
    u'響': 2,
    u'頁': 2,
    u'頂': 2,
    u'頃': 2,
    u'項': 2,
    u'順': 2,
    u'頇': 2,
    u'須': 2,
    u'頊': 2,
    u'頌': 2,
    u'頎': 2,
    u'頏': 2,
    u'預': 2,
    u'頑': 2,
    u'頒': 2,
    u'頓': 2,
    u'頗': 2,
    u'領': 2,
    u'頜': 2,
    u'頡': 2,
    u'頤': 2,
    u'頦': 2,
    u'頭': 2,
    u'頮': 2,
    u'頰': 2,
    u'頲': 2,
    u'頴': 2,
    u'頷': 2,
    u'頸': 2,
    u'頹': 2,
    u'頻': 2,
    u'顃': 2,
    u'顆': 2,
    u'題': 2,
    u'額': 2,
    u'顎': 2,
    u'顏': 2,
    u'顒': 2,
    u'顓': 2,
    u'願': 2,
    u'顙': 2,
    u'顛': 2,
    u'類': 2,
    u'顢': 2,
    u'顥': 2,
    u'顧': 2,
    u'顫': 2,
    u'顬': 2,
    u'顯': 2,
    u'顰': 2,
    u'顱': 2,
    u'顳': 2,
    u'顴': 2,
    u'页': 1,
    u'顶': 1,
    u'顷': 1,
    u'顸': 1,
    u'项': 1,
    u'顺': 1,
    u'须': 1,
    u'顼': 1,
    u'顽': 1,
    u'顾': 1,
    u'顿': 1,
    u'颀': 1,
    u'颁': 1,
    u'颂': 1,
    u'颃': 1,
    u'预': 1,
    u'颅': 1,
    u'领': 1,
    u'颇': 1,
    u'颈': 1,
    u'颉': 1,
    u'颊': 1,
    u'颋': 1,
    u'颌': 1,
    u'颍': 1,
    u'颎': 1,
    u'颏': 1,
    u'颐': 1,
    u'频': 1,
    u'颒': 1,
    u'颓': 1,
    u'颔': 1,
    u'颕': 1,
    u'颖': 1,
    u'颗': 1,
    u'题': 1,
    u'颙': 1,
    u'颚': 1,
    u'颛': 1,
    u'颜': 1,
    u'额': 1,
    u'颞': 1,
    u'颟': 1,
    u'颠': 1,
    u'颡': 1,
    u'颢': 1,
    u'颣': 1,
    u'颤': 1,
    u'颥': 1,
    u'颦': 1,
    u'颧': 1,
    u'風': 2,
    u'颭': 2,
    u'颮': 2,
    u'颯': 2,
    u'颰': 2,
    u'颱': 2,
    u'颳': 2,
    u'颶': 2,
    u'颷': 2,
    u'颸': 2,
    u'颺': 2,
    u'颻': 2,
    u'颼': 2,
    u'颾': 2,
    u'飀': 2,
    u'飄': 2,
    u'飆': 2,
    u'飈': 2,
    u'风': 1,
    u'飏': 1,
    u'飐': 1,
    u'飑': 1,
    u'飒': 1,
    u'飓': 1,
    u'飔': 1,
    u'飕': 1,
    u'飖': 1,
    u'飗': 1,
    u'飘': 1,
    u'飙': 1,
    u'飚': 1,
    u'飛': 2,
    u'飞': 1,
    u'飠': 2,
    u'飢': 2,
    u'飣': 2,
    u'飥': 2,
    u'飨': 1,
    u'飩': 2,
    u'飪': 2,
    u'飫': 2,
    u'飭': 2,
    u'飯': 2,
    u'飲': 2,
    u'飴': 2,
    u'飼': 2,
    u'飽': 2,
    u'飾': 2,
    u'飿': 2,
    u'餃': 2,
    u'餄': 2,
    u'餅': 2,
    u'餉': 2,
    u'養': 2,
    u'餌': 2,
    u'餍': 1,
    u'餎': 2,
    u'餏': 2,
    u'餑': 2,
    u'餒': 2,
    u'餓': 2,
    u'餔': 2,
    u'餕': 2,
    u'餖': 2,
    u'餗': 2,
    u'餘': 2,
    u'餚': 2,
    u'餛': 2,
    u'餜': 2,
    u'餞': 2,
    u'餡': 2,
    u'餦': 2,
    u'館': 2,
    u'餭': 2,
    u'餱': 2,
    u'餳': 2,
    u'餶': 2,
    u'餷': 2,
    u'餸': 2,
    u'餺': 2,
    u'餼': 2,
    u'餾': 2,
    u'餿': 2,
    u'饁': 2,
    u'饃': 2,
    u'饅': 2,
    u'饈': 2,
    u'饉': 2,
    u'饊': 2,
    u'饋': 2,
    u'饌': 2,
    u'饒': 2,
    u'饗': 2,
    u'饘': 2,
    u'饜': 2,
    u'饞': 2,
    u'饢': 2,
    u'饣': 1,
    u'饤': 1,
    u'饥': 1,
    u'饦': 1,
    u'饧': 1,
    u'饨': 1,
    u'饩': 1,
    u'饪': 1,
    u'饫': 1,
    u'饬': 1,
    u'饭': 1,
    u'饮': 1,
    u'饯': 1,
    u'饰': 1,
    u'饱': 1,
    u'饲': 1,
    u'饳': 1,
    u'饴': 1,
    u'饵': 1,
    u'饶': 1,
    u'饷': 1,
    u'饸': 1,
    u'饹': 1,
    u'饺': 1,
    u'饻': 1,
    u'饼': 1,
    u'饽': 1,
    u'饾': 1,
    u'饿': 1,
    u'馀': 1,
    u'馁': 1,
    u'馂': 1,
    u'馃': 1,
    u'馄': 1,
    u'馅': 1,
    u'馆': 1,
    u'馇': 1,
    u'馈': 1,
    u'馉': 1,
    u'馊': 1,
    u'馋': 1,
    u'馌': 1,
    u'馍': 1,
    u'馎': 1,
    u'馏': 1,
    u'馐': 1,
    u'馑': 1,
    u'馒': 1,
    u'馓': 1,
    u'馔': 1,
    u'馕': 1,
    u'馬': 2,
    u'馭': 2,
    u'馮': 2,
    u'馱': 2,
    u'馳': 2,
    u'馴': 2,
    u'馹': 2,
    u'駁': 2,
    u'駃': 2,
    u'駎': 2,
    u'駐': 2,
    u'駑': 2,
    u'駒': 2,
    u'駔': 2,
    u'駕': 2,
    u'駘': 2,
    u'駙': 2,
    u'駚': 2,
    u'駛': 2,
    u'駝': 2,
    u'駟': 2,
    u'駢': 2,
    u'駧': 2,
    u'駩': 2,
    u'駭': 2,
    u'駰': 2,
    u'駱': 2,
    u'駶': 2,
    u'駸': 2,
    u'駻': 2,
    u'駿': 2,
    u'騁': 2,
    u'騂': 2,
    u'騃': 2,
    u'騅': 2,
    u'騌': 2,
    u'騍': 2,
    u'騎': 2,
    u'騏': 2,
    u'騔': 2,
    u'騖': 2,
    u'騙': 2,
    u'騚': 2,
    u'騝': 2,
    u'騟': 2,
    u'騠': 2,
    u'騤': 2,
    u'騧': 2,
    u'騪': 2,
    u'騫': 2,
    u'騭': 2,
    u'騮': 2,
    u'騰': 2,
    u'騶': 2,
    u'騷': 2,
    u'騸': 2,
    u'騾': 2,
    u'驀': 2,
    u'驁': 2,
    u'驂': 2,
    u'驃': 2,
    u'驄': 2,
    u'驅': 2,
    u'驊': 2,
    u'驋': 2,
    u'驌': 2,
    u'驍': 2,
    u'驏': 2,
    u'驕': 2,
    u'驗': 2,
    u'驚': 2,
    u'驛': 2,
    u'驟': 2,
    u'驢': 2,
    u'驤': 2,
    u'驥': 2,
    u'驦': 2,
    u'驪': 2,
    u'驫': 2,
    u'马': 1,
    u'驭': 1,
    u'驮': 1,
    u'驯': 1,
    u'驰': 1,
    u'驱': 1,
    u'驲': 1,
    u'驳': 1,
    u'驴': 1,
    u'驵': 1,
    u'驶': 1,
    u'驷': 1,
    u'驸': 1,
    u'驹': 1,
    u'驺': 1,
    u'驻': 1,
    u'驼': 1,
    u'驽': 1,
    u'驾': 1,
    u'驿': 1,
    u'骀': 1,
    u'骁': 1,
    u'骂': 1,
    u'骃': 1,
    u'骄': 1,
    u'骅': 1,
    u'骆': 1,
    u'骇': 1,
    u'骈': 1,
    u'骉': 1,
    u'骊': 1,
    u'骋': 1,
    u'验': 1,
    u'骍': 1,
    u'骎': 1,
    u'骏': 1,
    u'骐': 1,
    u'骑': 1,
    u'骒': 1,
    u'骓': 1,
    u'骔': 1,
    u'骕': 1,
    u'骖': 1,
    u'骗': 1,
    u'骘': 1,
    u'骙': 1,
    u'骚': 1,
    u'骛': 1,
    u'骜': 1,
    u'骝': 1,
    u'骞': 1,
    u'骟': 1,
    u'骠': 1,
    u'骡': 1,
    u'骢': 1,
    u'骣': 1,
    u'骤': 1,
    u'骥': 1,
    u'骦': 1,
    u'骧': 1,
    u'骯': 2,
    u'髅': 1,
    u'髋': 1,
    u'髌': 1,
    u'髏': 2,
    u'髒': 2,
    u'體': 2,
    u'髕': 2,
    u'髖': 2,
    u'髮': 2,
    u'鬆': 2,
    u'鬍': 2,
    u'鬓': 1,
    u'鬚': 2,
    u'鬢': 2,
    u'鬥': 2,
    u'鬧': 2,
    u'鬩': 2,
    u'鬮': 2,
    u'鬱': 2,
    u'鬶': 1,
    u'鬹': 2,
    u'魇': 1,
    u'魉': 1,
    u'魎': 2,
    u'魘': 2,
    u'魚': 2,
    u'魛': 2,
    u'魟': 2,
    u'魢': 2,
    u'魥': 2,
    u'魨': 2,
    u'魯': 2,
    u'魴': 2,
    u'魷': 2,
    u'魺': 2,
    u'鮁': 2,
    u'鮃': 2,
    u'鮄': 2,
    u'鮊': 2,
    u'鮋': 2,
    u'鮍': 2,
    u'鮐': 2,
    u'鮑': 2,
    u'鮒': 2,
    u'鮓': 2,
    u'鮚': 2,
    u'鮜': 2,
    u'鮞': 2,
    u'鮟': 2,
    u'鮣': 2,
    u'鮦': 2,
    u'鮪': 2,
    u'鮫': 2,
    u'鮭': 2,
    u'鮮': 2,
    u'鮰': 2,
    u'鮳': 2,
    u'鮶': 2,
    u'鮸': 2,
    u'鮺': 2,
    u'鯀': 2,
    u'鯁': 2,
    u'鯄': 2,
    u'鯆': 2,
    u'鯇': 2,
    u'鯉': 2,
    u'鯊': 2,
    u'鯒': 2,
    u'鯔': 2,
    u'鯕': 2,
    u'鯖': 2,
    u'鯗': 2,
    u'鯛': 2,
    u'鯝': 2,
    u'鯡': 2,
    u'鯢': 2,
    u'鯤': 2,
    u'鯧': 2,
    u'鯨': 2,
    u'鯪': 2,
    u'鯫': 2,
    u'鯱': 2,
    u'鯴': 2,
    u'鯶': 2,
    u'鯷': 2,
    u'鯽': 2,
    u'鯿': 2,
    u'鰁': 2,
    u'鰂': 2,
    u'鰃': 2,
    u'鰆': 2,
    u'鰈': 2,
    u'鰉': 2,
    u'鰌': 2,
    u'鰍': 2,
    u'鰏': 2,
    u'鰒': 2,
    u'鰓': 2,
    u'鰜': 2,
    u'鰟': 2,
    u'鰠': 2,
    u'鰣': 2,
    u'鰤': 2,
    u'鰥': 2,
    u'鰧': 2,
    u'鰨': 2,
    u'鰩': 2,
    u'鰭': 2,
    u'鰮': 2,
    u'鰱': 2,
    u'鰲': 2,
    u'鰳': 2,
    u'鰵': 2,
    u'鰷': 2,
    u'鰹': 2,
    u'鰺': 2,
    u'鰻': 2,
    u'鰼': 2,
    u'鰾': 2,
    u'鱂': 2,
    u'鱅': 2,
    u'鱇': 2,
    u'鱈': 2,
    u'鱉': 2,
    u'鱒': 2,
    u'鱔': 2,
    u'鱖': 2,
    u'鱗': 2,
    u'鱘': 2,
    u'鱝': 2,
    u'鱟': 2,
    u'鱠': 2,
    u'鱣': 2,
    u'鱤': 2,
    u'鱧': 2,
    u'鱨': 2,
    u'鱭': 2,
    u'鱮': 2,
    u'鱯': 2,
    u'鱷': 2,
    u'鱸': 2,
    u'鱺': 2,
    u'鱼': 1,
    u'鱽': 1,
    u'鱾': 1,
    u'鱿': 1,
    u'鲀': 1,
    u'鲁': 1,
    u'鲂': 1,
    u'鲃': 1,
    u'鲄': 1,
    u'鲅': 1,
    u'鲆': 1,
    u'鲈': 1,
    u'鲉': 1,
    u'鲊': 1,
    u'鲋': 1,
    u'鲌': 1,
    u'鲍': 1,
    u'鲎': 1,
    u'鲏': 1,
    u'鲐': 1,
    u'鲑': 1,
    u'鲒': 1,
    u'鲓': 1,
    u'鲔': 1,
    u'鲕': 1,
    u'鲖': 1,
    u'鲗': 1,
    u'鲘': 1,
    u'鲙': 1,
    u'鲚': 1,
    u'鲛': 1,
    u'鲜': 1,
    u'鲝': 1,
    u'鲞': 1,
    u'鲟': 1,
    u'鲠': 1,
    u'鲡': 1,
    u'鲢': 1,
    u'鲣': 1,
    u'鲤': 1,
    u'鲥': 1,
    u'鲦': 1,
    u'鲧': 1,
    u'鲨': 1,
    u'鲩': 1,
    u'鲪': 1,
    u'鲫': 1,
    u'鲬': 1,
    u'鲭': 1,
    u'鲮': 1,
    u'鲯': 1,
    u'鲰': 1,
    u'鲱': 1,
    u'鲲': 1,
    u'鲳': 1,
    u'鲴': 1,
    u'鲵': 1,
    u'鲷': 1,
    u'鲸': 1,
    u'鲹': 1,
    u'鲺': 1,
    u'鲻': 1,
    u'鲼': 1,
    u'鲽': 1,
    u'鲾': 1,
    u'鲿': 1,
    u'鳀': 1,
    u'鳁': 1,
    u'鳂': 1,
    u'鳃': 1,
    u'鳄': 1,
    u'鳅': 1,
    u'鳆': 1,
    u'鳇': 1,
    u'鳈': 1,
    u'鳉': 1,
    u'鳊': 1,
    u'鳋': 1,
    u'鳌': 1,
    u'鳍': 1,
    u'鳎': 1,
    u'鳏': 1,
    u'鳐': 1,
    u'鳑': 1,
    u'鳒': 1,
    u'鳓': 1,
    u'鳔': 1,
    u'鳕': 1,
    u'鳖': 1,
    u'鳗': 1,
    u'鳘': 1,
    u'鳙': 1,
    u'鳚': 1,
    u'鳛': 1,
    u'鳜': 1,
    u'鳝': 1,
    u'鳞': 1,
    u'鳟': 1,
    u'鳠': 1,
    u'鳡': 1,
    u'鳢': 1,
    u'鳣': 1,
    u'鳥': 2,
    u'鳧': 2,
    u'鳩': 2,
    u'鳲': 2,
    u'鳳': 2,
    u'鳴': 2,
    u'鳶': 2,
    u'鳷': 2,
    u'鳼': 2,
    u'鳾': 2,
    u'鴃': 2,
    u'鴆': 2,
    u'鴇': 2,
    u'鴉': 2,
    u'鴒': 2,
    u'鴕': 2,
    u'鴗': 2,
    u'鴛': 2,
    u'鴜': 2,
    u'鴝': 2,
    u'鴞': 2,
    u'鴟': 2,
    u'鴣': 2,
    u'鴦': 2,
    u'鴨': 2,
    u'鴯': 2,
    u'鴰': 2,
    u'鴲': 2,
    u'鴴': 2,
    u'鴷': 2,
    u'鴻': 2,
    u'鴿': 2,
    u'鵁': 2,
    u'鵂': 2,
    u'鵃': 2,
    u'鵐': 2,
    u'鵑': 2,
    u'鵒': 2,
    u'鵓': 2,
    u'鵚': 2,
    u'鵜': 2,
    u'鵝': 2,
    u'鵠': 2,
    u'鵡': 2,
    u'鵪': 2,
    u'鵬': 2,
    u'鵮': 2,
    u'鵯': 2,
    u'鵲': 2,
    u'鵷': 2,
    u'鵾': 2,
    u'鶄': 2,
    u'鶇': 2,
    u'鶉': 2,
    u'鶊': 2,
    u'鶒': 2,
    u'鶓': 2,
    u'鶖': 2,
    u'鶗': 2,
    u'鶘': 2,
    u'鶚': 2,
    u'鶡': 2,
    u'鶥': 2,
    u'鶩': 2,
    u'鶪': 2,
    u'鶬': 2,
    u'鶯': 2,
    u'鶲': 2,
    u'鶴': 2,
    u'鶹': 2,
    u'鶺': 2,
    u'鶻': 2,
    u'鶼': 2,
    u'鶿': 2,
    u'鷁': 2,
    u'鷂': 2,
    u'鷈': 2,
    u'鷊': 2,
    u'鷓': 2,
    u'鷔': 2,
    u'鷖': 2,
    u'鷗': 2,
    u'鷙': 2,
    u'鷚': 2,
    u'鷥': 2,
    u'鷦': 2,
    u'鷨': 2,
    u'鷫': 2,
    u'鷯': 2,
    u'鷲': 2,
    u'鷳': 2,
    u'鷸': 2,
    u'鷹': 2,
    u'鷺': 2,
    u'鷽': 2,
    u'鷿': 2,
    u'鸂': 2,
    u'鸇': 2,
    u'鸋': 2,
    u'鸌': 2,
    u'鸏': 2,
    u'鸕': 2,
    u'鸘': 2,
    u'鸚': 2,
    u'鸛': 2,
    u'鸝': 2,
    u'鸞': 2,
    u'鸟': 1,
    u'鸠': 1,
    u'鸡': 1,
    u'鸢': 1,
    u'鸣': 1,
    u'鸤': 1,
    u'鸥': 1,
    u'鸦': 1,
    u'鸧': 1,
    u'鸨': 1,
    u'鸩': 1,
    u'鸪': 1,
    u'鸫': 1,
    u'鸬': 1,
    u'鸭': 1,
    u'鸮': 1,
    u'鸯': 1,
    u'鸰': 1,
    u'鸱': 1,
    u'鸲': 1,
    u'鸳': 1,
    u'鸴': 1,
    u'鸵': 1,
    u'鸶': 1,
    u'鸷': 1,
    u'鸸': 1,
    u'鸹': 1,
    u'鸺': 1,
    u'鸻': 1,
    u'鸼': 1,
    u'鸽': 1,
    u'鸾': 1,
    u'鸿': 1,
    u'鹀': 1,
    u'鹁': 1,
    u'鹂': 1,
    u'鹃': 1,
    u'鹄': 1,
    u'鹅': 1,
    u'鹆': 1,
    u'鹇': 1,
    u'鹈': 1,
    u'鹉': 1,
    u'鹊': 1,
    u'鹋': 1,
    u'鹌': 1,
    u'鹍': 1,
    u'鹎': 1,
    u'鹏': 1,
    u'鹐': 1,
    u'鹑': 1,
    u'鹒': 1,
    u'鹓': 1,
    u'鹔': 1,
    u'鹕': 1,
    u'鹖': 1,
    u'鹗': 1,
    u'鹘': 1,
    u'鹙': 1,
    u'鹚': 1,
    u'鹛': 1,
    u'鹜': 1,
    u'鹝': 1,
    u'鹞': 1,
    u'鹟': 1,
    u'鹠': 1,
    u'鹡': 1,
    u'鹢': 1,
    u'鹣': 1,
    u'鹤': 1,
    u'鹥': 1,
    u'鹦': 1,
    u'鹧': 1,
    u'鹨': 1,
    u'鹩': 1,
    u'鹪': 1,
    u'鹫': 1,
    u'鹬': 1,
    u'鹭': 1,
    u'鹮': 1,
    u'鹯': 1,
    u'鹰': 1,
    u'鹱': 1,
    u'鹲': 1,
    u'鹳': 1,
    u'鹴': 1,
    u'鹵': 2,
    u'鹹': 2,
    u'鹺': 2,
    u'鹼': 2,
    u'鹽': 2,
    u'鹾': 1,
    u'麗': 2,
    u'麥': 2,
    u'麦': 1,
    u'麨': 2,
    u'麩': 2,
    u'麲': 2,
    u'麵': 2,
    u'麸': 1,
    u'麼': 2,
    u'麽': 2,
    u'黃': 2,
    u'黄': 1,
    u'黉': 1,
    u'黌': 2,
    u'點': 2,
    u'黡': 1,
    u'黨': 2,
    u'黩': 1,
    u'黪': 1,
    u'黲': 2,
    u'黶': 2,
    u'黷': 2,
    u'黽': 2,
    u'黾': 1,
    u'黿': 2,
    u'鼉': 2,
    u'鼋': 1,
    u'鼍': 1,
    u'鼗': 1,
    u'鼴': 2,
    u'鼹': 1,
    u'齊': 2,
    u'齋': 2,
    u'齎': 2,
    u'齏': 2,
    u'齐': 1,
    u'齑': 1,
    u'齒': 2,
    u'齔': 2,
    u'齕': 2,
    u'齗': 2,
    u'齙': 2,
    u'齜': 2,
    u'齟': 2,
    u'齠': 2,
    u'齡': 2,
    u'齦': 2,
    u'齪': 2,
    u'齬': 2,
    u'齲': 2,
    u'齶': 2,
    u'齷': 2,
    u'齿': 1,
    u'龀': 1,
    u'龁': 1,
    u'龂': 1,
    u'龃': 1,
    u'龄': 1,
    u'龅': 1,
    u'龆': 1,
    u'龇': 1,
    u'龈': 1,
    u'龉': 1,
    u'龊': 1,
    u'龋': 1,
    u'龌': 1,
    u'龍': 2,
    u'龎': 2,
    u'龐': 2,
    u'龑': 2,
    u'龔': 2,
    u'龕': 2,
    u'龙': 1,
    u'龚': 1,
    u'龛': 1,
    u'龜': 2,
    u'龟': 1,
    u'龭': 2,
    u'龯': 2,
    u'鿁': 2,
    u'鿏': 1,
    u'鿐': 2,
    u'鿒': 2,
    u'鿓': 1,
    u'鿔': 1,
    u'𠆲': 1,
    u'𠆿': 1,
    u'𠉂': 1,
    u'𠉗': 1,
    u'𠌥': 2,
    u'𠏢': 2,
    u'𠚳': 1,
    u'𠛅': 1,
    u'𠛆': 1,
    u'𠞆': 2,
    u'𠠎': 2,
    u'𠯟': 1,
    u'𠯠': 1,
    u'𠲥': 1,
    u'𠴢': 1,
    u'𠵸': 1,
    u'𠵾': 1,
    u'𡄔': 2,
    u'𡄣': 2,
    u'𡅏': 2,
    u'𡋀': 1,
    u'𡋗': 1,
    u'𡑭': 2,
    u'𡒄': 1,
    u'𡓾': 2,
    u'𡝠': 1,
    u'𡞱': 1,
    u'𡞵': 2,
    u'𡠹': 2,
    u'𡢃': 2,
    u'𡭜': 1,
    u'𡭬': 1,
    u'𡮉': 2,
    u'𡮣': 2,
    u'𡶴': 1,
    u'𡾱': 2,
    u'𢋈': 1,
    u'𢘝': 1,
    u'𢘞': 1,
    u'𢙓': 1,
    u'𢛯': 1,
    u'𢣚': 2,
    u'𢣭': 2,
    u'𢫊': 1,
    u'𢫞': 1,
    u'𢫬': 1,
    u'𢬦': 1,
    u'𢭏': 1,
    u'𢶫': 2,
    u'𢷮': 2,
    u'𢹿': 2,
    u'𢽾': 1,
    u'𣆐': 1,
    u'𣍨': 1,
    u'𣍯': 1,
    u'𣍰': 1,
    u'𣎑': 1,
    u'𣐤': 1,
    u'𣑶': 1,
    u'𣗋': 1,
    u'𣘓': 1,
    u'𣘴': 1,
    u'𣘷': 1,
    u'𣙎': 2,
    u'𣝕': 2,
    u'𣞻': 2,
    u'𣠲': 2,
    u'𣭤': 1,
    u'𣯴': 2,
    u'𣶩': 1,
    u'𣶫': 1,
    u'𣸣': 1,
    u'𣺼': 1,
    u'𣺽': 1,
    u'𣽷': 1,
    u'𣾷': 2,
    u'𣿉': 2,
    u'𤁣': 2,
    u'𤆡': 1,
    u'𤇃': 1,
    u'𤇄': 1,
    u'𤈶': 1,
    u'𤈷': 1,
    u'𤊀': 1,
    u'𤋏': 1,
    u'𤒎': 2,
    u'𤞤': 1,
    u'𤠋': 1,
    u'𤦀': 1,
    u'𤪺': 2,
    u'𤫩': 2,
    u'𤳄': 1,
    u'𤳸': 2,
    u'𤶧': 1,
    u'𤸫': 2,
    u'𤽯': 1,
    u'𤾀': 1,
    u'𥅘': 1,
    u'𥅴': 1,
    u'𥆧': 1,
    u'𥇢': 1,
    u'𥌃': 2,
    u'𥐟': 1,
    u'𥐯': 1,
    u'𥐰': 1,
    u'𥐻': 1,
    u'𥕥': 2,
    u'𥖅': 2,
    u'𥢢': 2,
    u'𥧂': 1,
    u'𥨐': 2,
    u'𥬀': 1,
    u'𥬞': 1,
    u'𥬠': 1,
    u'𥭉': 1,
    u'𥮋': 1,
    u'𥮜': 1,
    u'𥱔': 1,
    u'𥵃': 2,
    u'𥵊': 2,
    u'𥸠': 2,
    u'𥹥': 1,
    u'𥺅': 1,
    u'𥺇': 1,
    u'𥼽': 2,
    u'𥽖': 2,
    u'𥿊': 2,
    u'𦂅': 2,
    u'𦃄': 2,
    u'𦈈': 1,
    u'𦈉': 1,
    u'𦈋': 1,
    u'𦈌': 1,
    u'𦈎': 1,
    u'𦈏': 1,
    u'𦈐': 1,
    u'𦈑': 1,
    u'𦈒': 1,
    u'𦈓': 1,
    u'𦈔': 1,
    u'𦈕': 1,
    u'𦈖': 1,
    u'𦈗': 1,
    u'𦈘': 1,
    u'𦈙': 1,
    u'𦈚': 1,
    u'𦈛': 1,
    u'𦈜': 1,
    u'𦈝': 1,
    u'𦈞': 1,
    u'𦈟': 1,
    u'𦈠': 1,
    u'𦈡': 1,
    u'𦛨': 1,
    u'𦝼': 1,
    u'𦟗': 1,
    u'𦢈': 2,
    u'𦣎': 2,
    u'𦨩': 1,
    u'𦪽': 2,
    u'𦰴': 1,
    u'𧉞': 1,
    u'𧒭': 1,
    u'𧔥': 2,
    u'𧜗': 2,
    u'𧜵': 2,
    u'𧝞': 2,
    u'𧠵': 2,
    u'𧩙': 2,
    u'𧮪': 1,
    u'𧳕': 1,
    u'𧳟': 2,
    u'𧵳': 2,
    u'𧶔': 2,
    u'𧶧': 2,
    u'𧹑': 1,
    u'𧹓': 1,
    u'𧹕': 1,
    u'𧹖': 1,
    u'𧹗': 1,
    u'𧿈': 1,
    u'𨀱': 1,
    u'𨁴': 1,
    u'𨂺': 1,
    u'𨄄': 1,
    u'𨄣': 2,
    u'𨅍': 2,
    u'𨅫': 1,
    u'𨅬': 1,
    u'𨇁': 2,
    u'𨇞': 2,
    u'𨈊': 2,
    u'𨈌': 2,
    u'𨉗': 1,
    u'𨊰': 2,
    u'𨊸': 2,
    u'𨊻': 2,
    u'𨋢': 2,
    u'𨎮': 2,
    u'𨏠': 2,
    u'𨏥': 2,
    u'𨐅': 1,
    u'𨐆': 1,
    u'𨐇': 1,
    u'𨐈': 1,
    u'𨐉': 1,
    u'𨐊': 1,
    u'𨑹': 1,
    u'𨤰': 1,
    u'𨤻': 2,
    u'𨥛': 2,
    u'𨦫': 2,
    u'𨧜': 2,
    u'𨧱': 2,
    u'𨫒': 2,
    u'𨮂': 2,
    u'𨯅': 2,
    u'𨰾': 1,
    u'𨰿': 1,
    u'𨱀': 1,
    u'𨱁': 1,
    u'𨱂': 1,
    u'𨱃': 1,
    u'𨱄': 1,
    u'𨱅': 1,
    u'𨱆': 1,
    u'𨱇': 1,
    u'𨱈': 1,
    u'𨱉': 1,
    u'𨱊': 1,
    u'𨱋': 1,
    u'𨱌': 1,
    u'𨱍': 1,
    u'𨱎': 1,
    u'𨱏': 1,
    u'𨱐': 1,
    u'𨱑': 1,
    u'𨱒': 1,
    u'𨱓': 1,
    u'𨱔': 1,
    u'𨱕': 1,
    u'𨱖': 1,
    u'𨳑': 2,
    u'𨳕': 2,
    u'𨴗': 2,
    u'𨵩': 2,
    u'𨵸': 2,
    u'𨶀': 2,
    u'𨶏': 2,
    u'𨶮': 2,
    u'𨶲': 2,
    u'𨷲': 2,
    u'𨷿': 1,
    u'𨸀': 1,
    u'𨸁': 1,
    u'𨸂': 1,
    u'𨸃': 1,
    u'𨸄': 1,
    u'𨸅': 1,
    u'𨸆': 1,
    u'𨸇': 1,
    u'𨸉': 1,
    u'𨸊': 1,
    u'𨸋': 1,
    u'𨸌': 1,
    u'𨸎': 1,
    u'𨸘': 1,
    u'𨸟': 1,
    u'𨽏': 2,
    u'𩎢': 2,
    u'𩏪': 2,
    u'𩏼': 1,
    u'𩏽': 1,
    u'𩏾': 1,
    u'𩏿': 1,
    u'𩐀': 1,
    u'𩓣': 2,
    u'𩖕': 1,
    u'𩖖': 1,
    u'𩖗': 1,
    u'𩗀': 2,
    u'𩘀': 2,
    u'𩘝': 2,
    u'𩘹': 2,
    u'𩘺': 2,
    u'𩙈': 2,
    u'𩙥': 1,
    u'𩙦': 1,
    u'𩙧': 1,
    u'𩙨': 1,
    u'𩙩': 1,
    u'𩙪': 1,
    u'𩙫': 1,
    u'𩙬': 1,
    u'𩙭': 1,
    u'𩙮': 1,
    u'𩙯': 1,
    u'𩙰': 1,
    u'𩚛': 2,
    u'𩚥': 2,
    u'𩚵': 2,
    u'𩛆': 2,
    u'𩛩': 2,
    u'𩜇': 2,
    u'𩜦': 2,
    u'𩜵': 2,
    u'𩝔': 2,
    u'𩞄': 2,
    u'𩞦': 2,
    u'𩞯': 2,
    u'𩟐': 2,
    u'𩟿': 1,
    u'𩠀': 1,
    u'𩠁': 1,
    u'𩠂': 1,
    u'𩠃': 1,
    u'𩠅': 1,
    u'𩠆': 1,
    u'𩠇': 1,
    u'𩠈': 1,
    u'𩠉': 1,
    u'𩠊': 1,
    u'𩠋': 1,
    u'𩠌': 1,
    u'𩠎': 1,
    u'𩠏': 1,
    u'𩠠': 1,
    u'𩠴': 2,
    u'𩡺': 2,
    u'𩢡': 2,
    u'𩢴': 2,
    u'𩢸': 2,
    u'𩢾': 2,
    u'𩣏': 2,
    u'𩣑': 2,
    u'𩣺': 2,
    u'𩤊': 2,
    u'𩤙': 2,
    u'𩤲': 2,
    u'𩤸': 2,
    u'𩥄': 2,
    u'𩥇': 2,
    u'𩥉': 2,
    u'𩥑': 2,
    u'𩧆': 2,
    u'𩧦': 1,
    u'𩧨': 1,
    u'𩧩': 1,
    u'𩧪': 1,
    u'𩧫': 1,
    u'𩧬': 1,
    u'𩧭': 1,
    u'𩧮': 1,
    u'𩧯': 1,
    u'𩧰': 1,
    u'𩧱': 1,
    u'𩧲': 1,
    u'𩧳': 1,
    u'𩧴': 1,
    u'𩧵': 1,
    u'𩧶': 1,
    u'𩧺': 1,
    u'𩧼': 1,
    u'𩧿': 1,
    u'𩨀': 1,
    u'𩨁': 1,
    u'𩨃': 1,
    u'𩨄': 1,
    u'𩨅': 1,
    u'𩨆': 1,
    u'𩨇': 1,
    u'𩨈': 1,
    u'𩨉': 1,
    u'𩨊': 1,
    u'𩨋': 1,
    u'𩨌': 1,
    u'𩨍': 1,
    u'𩨎': 1,
    u'𩨏': 1,
    u'𩨐': 1,
    u'𩬣': 1,
    u'𩬤': 1,
    u'𩭙': 2,
    u'𩯒': 1,
    u'𩯳': 2,
    u'𩰀': 2,
    u'𩲒': 1,
    u'𩳤': 2,
    u'𩵩': 2,
    u'𩵹': 2,
    u'𩶘': 2,
    u'𩶰': 2,
    u'𩶱': 2,
    u'𩷰': 2,
    u'𩸃': 2,
    u'𩸦': 2,
    u'𩽹': 1,
    u'𩽺': 1,
    u'𩽻': 1,
    u'𩽼': 1,
    u'𩽽': 1,
    u'𩽾': 1,
    u'𩽿': 1,
    u'𩾁': 1,
    u'𩾂': 1,
    u'𩾃': 1,
    u'𩾄': 1,
    u'𩾅': 1,
    u'𩾆': 1,
    u'𩾇': 1,
    u'𩾈': 1,
    u'𩾊': 1,
    u'𩾋': 1,
    u'𩾌': 1,
    u'𩿪': 2,
    u'𪀦': 2,
    u'𪀾': 2,
    u'𪁈': 2,
    u'𪁖': 2,
    u'𪂆': 2,
    u'𪃍': 2,
    u'𪃏': 2,
    u'𪄆': 2,
    u'𪄕': 2,
    u'𪇳': 2,
    u'𪉂': 1,
    u'𪉃': 1,
    u'𪉄': 1,
    u'𪉅': 1,
    u'𪉆': 1,
    u'𪉈': 1,
    u'𪉉': 1,
    u'𪉊': 1,
    u'𪉋': 1,
    u'𪉌': 1,
    u'𪉍': 1,
    u'𪉎': 1,
    u'𪉏': 1,
    u'𪉐': 1,
    u'𪉑': 1,
    u'𪉒': 1,
    u'𪉔': 1,
    u'𪉕': 1,
    u'𪋿': 2,
    u'𪎈': 1,
    u'𪎉': 1,
    u'𪎊': 1,
    u'𪎋': 1,
    u'𪎍': 1,
    u'𪔭': 1,
    u'𪔵': 2,
    u'𪘀': 2,
    u'𪘯': 2,
    u'𪚏': 1,
    u'𪚐': 1,
    u'𪞝': 1,
    u'𪡏': 1,
    u'𪢮': 1,
    u'𪨊': 1,
    u'𪨗': 1,
    u'𪻐': 1,
    u'𪾢': 1,
    u'𫁡': 1,
    u'𫂈': 1,
    u'𫄨': 1,
    u'𫄸': 1,
    u'𫌀': 1,
    u'𫌨': 1,
    u'𫍙': 1,
    u'𫍟': 1,
    u'𫍢': 1,
    u'𫍰': 1,
    u'𫍲': 1,
    u'𫏋': 1,
    u'𫐄': 1,
    u'𫐆': 1,
    u'𫐉': 1,
    u'𫐐': 1,
    u'𫐓': 1,
    u'𫓧': 1,
    u'𫓩': 1,
    u'𫔎': 1,
    u'𫖸': 1,
    u'𫗠': 1,
    u'𫗦': 1,
    u'𫗧': 1,
    u'𫗮': 1,
    u'𫗴': 1,
    u'𫘝': 1,
    u'𫘣': 1,
    u'𫘤': 1,
    u'𫘨': 1,
    u'𫚈': 1,
    u'𫚉': 1,
    u'𫚒': 1,
    u'𫚔': 1,
    u'𫚕': 1,
    u'𫚙': 1,
    u'𫛛': 1,
    u'𫛞': 1,
    u'𫛢': 1,
    u'𫛶': 1,
    u'𫛸': 1,
    u'𬢍': 1,
    }

def detect_chinese_category(phrase):
    '''
    New function using Unihan data to guess whether a text is
    simplified Chinese, traditional Chinese, both, or something rare
    like a mixture of exclusively simplified with exclusively traditional
    characters.

    Meaning of the bits in the category value returned by this function:
    1 = 1 << 0       simplified Chinese
    2 = 1 << 1       traditional Chinese
    3 = (1 | 1 << 1) used both in simplified *and* traditional Chinese
    4 = 1 << 2       mixture of simplified and traditional Chinese
    '''
    # make sure that we got a unicode string
    if type(phrase) != type(u''):
        phrase = phrase.decode('utf8')
    if phrase in variants_table:
        # the complete phrase is in variants_table, just return the
        # value found:
        return variants_table[phrase]
    category = 0xFF
    for c in phrase:
        if c in variants_table:
            category &= variants_table[c]
        else:
            # If it is not listed in variants_table, assume it is
            # both simplified and traditional Chinese.
            # It could be something non-Chinese as well then, but
            # if it is non-Chinese, it should also be allowed to
            # occur in any Chinese text and thus classified as
            # both simplified *and* traditional Chinese (the emoji
            # table for example uses many non-Chinese characters)
            category &= (1 | 1 << 1)
    if category == 0:
        # If category is 0 after binary & of the categories of all the
        # characters in the phrase, it means that the phrase contained
        # exclusively simplified *and* exclusively traditional
        # characters at the same time.  For example if the phrase is
        # “乌烏” then “乌” gets category 1 (simplified Chinese)
        # and “烏” gets category 2 (traditional Chinese), the result
        # of the binary & is thus 0. In that case, classify it as
        # category 4 which is for weird, excentric, rare stuff. If the
        # user selects one of the modes “all characters but
        # simplified Chinese first” or “all characters but
        # traditional Chinese first”, phrases with category 4 will be
        # shown but filtered to be shown only at the end of the
        # candidate list.
        category = 1 << 2
    return category
