/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _nbio_6_1_OFFSET_HEADER
#define _nbio_6_1_OFFSET_HEADER



// addressBlock: nbio_pcie_pswuscfg0_cfgdecp
// base address: 0x0
#define cfgPSWUSCFG0_VENDOR_ID                                                                          0x0000
#define cfgPSWUSCFG0_DEVICE_ID                                                                          0x0002
#define cfgPSWUSCFG0_COMMAND                                                                            0x0004
#define cfgPSWUSCFG0_STATUS                                                                             0x0006
#define cfgPSWUSCFG0_REVISION_ID                                                                        0x0008
#define cfgPSWUSCFG0_PROG_INTERFACE                                                                     0x0009
#define cfgPSWUSCFG0_SUB_CLASS                                                                          0x000a
#define cfgPSWUSCFG0_BASE_CLASS                                                                         0x000b
#define cfgPSWUSCFG0_CACHE_LINE                                                                         0x000c
#define cfgPSWUSCFG0_LATENCY                                                                            0x000d
#define cfgPSWUSCFG0_HEADER                                                                             0x000e
#define cfgPSWUSCFG0_BIST                                                                               0x000f
#define cfgPSWUSCFG0_SUB_BUS_NUMBER_LATENCY                                                             0x0018
#define cfgPSWUSCFG0_IO_BASE_LIMIT                                                                      0x001c
#define cfgPSWUSCFG0_SECONDARY_STATUS                                                                   0x001e
#define cfgPSWUSCFG0_MEM_BASE_LIMIT                                                                     0x0020
#define cfgPSWUSCFG0_PREF_BASE_LIMIT                                                                    0x0024
#define cfgPSWUSCFG0_PREF_BASE_UPPER                                                                    0x0028
#define cfgPSWUSCFG0_PREF_LIMIT_UPPER                                                                   0x002c
#define cfgPSWUSCFG0_IO_BASE_LIMIT_HI                                                                   0x0030
#define cfgPSWUSCFG0_CAP_PTR                                                                            0x0034
#define cfgPSWUSCFG0_INTERRUPT_LINE                                                                     0x003c
#define cfgPSWUSCFG0_INTERRUPT_PIN                                                                      0x003d
#define cfgPSWUSCFG0_IRQ_BRIDGE_CNTL                                                                    0x003e
#define cfgEXT_BRIDGE_CNTL                                                                              0x0040
#define cfgPSWUSCFG0_VENDOR_CAP_LIST                                                                    0x0048
#define cfgPSWUSCFG0_ADAPTER_ID_W                                                                       0x004c
#define cfgPSWUSCFG0_PMI_CAP_LIST                                                                       0x0050
#define cfgPSWUSCFG0_PMI_CAP                                                                            0x0052
#define cfgPSWUSCFG0_PMI_STATUS_CNTL                                                                    0x0054
#define cfgPSWUSCFG0_PCIE_CAP_LIST                                                                      0x0058
#define cfgPSWUSCFG0_PCIE_CAP                                                                           0x005a
#define cfgPSWUSCFG0_DEVICE_CAP                                                                         0x005c
#define cfgPSWUSCFG0_DEVICE_CNTL                                                                        0x0060
#define cfgPSWUSCFG0_DEVICE_STATUS                                                                      0x0062
#define cfgPSWUSCFG0_LINK_CAP                                                                           0x0064
#define cfgPSWUSCFG0_LINK_CNTL                                                                          0x0068
#define cfgPSWUSCFG0_LINK_STATUS                                                                        0x006a
#define cfgPSWUSCFG0_DEVICE_CAP2                                                                        0x007c
#define cfgPSWUSCFG0_DEVICE_CNTL2                                                                       0x0080
#define cfgPSWUSCFG0_DEVICE_STATUS2                                                                     0x0082
#define cfgPSWUSCFG0_LINK_CAP2                                                                          0x0084
#define cfgPSWUSCFG0_LINK_CNTL2                                                                         0x0088
#define cfgPSWUSCFG0_LINK_STATUS2                                                                       0x008a
#define cfgPSWUSCFG0_MSI_CAP_LIST                                                                       0x00a0
#define cfgPSWUSCFG0_MSI_MSG_CNTL                                                                       0x00a2
#define cfgPSWUSCFG0_MSI_MSG_ADDR_LO                                                                    0x00a4
#define cfgPSWUSCFG0_MSI_MSG_ADDR_HI                                                                    0x00a8
#define cfgPSWUSCFG0_MSI_MSG_DATA                                                                       0x00a8
#define cfgPSWUSCFG0_MSI_MSG_DATA_64                                                                    0x00ac
#define cfgPSWUSCFG0_SSID_CAP_LIST                                                                      0x00c0
#define cfgPSWUSCFG0_SSID_CAP                                                                           0x00c4
#define cfgMSI_MAP_CAP_LIST                                                                             0x00c8
#define cfgMSI_MAP_CAP                                                                                  0x00ca
#define cfgMSI_MAP_ADDR_LO                                                                              0x00cc
#define cfgMSI_MAP_ADDR_HI                                                                              0x00d0
#define cfgPSWUSCFG0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                                  0x0100
#define cfgPSWUSCFG0_PCIE_VENDOR_SPECIFIC_HDR                                                           0x0104
#define cfgPSWUSCFG0_PCIE_VENDOR_SPECIFIC1                                                              0x0108
#define cfgPSWUSCFG0_PCIE_VENDOR_SPECIFIC2                                                              0x010c
#define cfgPSWUSCFG0_PCIE_VC_ENH_CAP_LIST                                                               0x0110
#define cfgPSWUSCFG0_PCIE_PORT_VC_CAP_REG1                                                              0x0114
#define cfgPSWUSCFG0_PCIE_PORT_VC_CAP_REG2                                                              0x0118
#define cfgPSWUSCFG0_PCIE_PORT_VC_CNTL                                                                  0x011c
#define cfgPSWUSCFG0_PCIE_PORT_VC_STATUS                                                                0x011e
#define cfgPSWUSCFG0_PCIE_VC0_RESOURCE_CAP                                                              0x0120
#define cfgPSWUSCFG0_PCIE_VC0_RESOURCE_CNTL                                                             0x0124
#define cfgPSWUSCFG0_PCIE_VC0_RESOURCE_STATUS                                                           0x012a
#define cfgPSWUSCFG0_PCIE_VC1_RESOURCE_CAP                                                              0x012c
#define cfgPSWUSCFG0_PCIE_VC1_RESOURCE_CNTL                                                             0x0130
#define cfgPSWUSCFG0_PCIE_VC1_RESOURCE_STATUS                                                           0x0136
#define cfgPSWUSCFG0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                                   0x0140
#define cfgPSWUSCFG0_PCIE_DEV_SERIAL_NUM_DW1                                                            0x0144
#define cfgPSWUSCFG0_PCIE_DEV_SERIAL_NUM_DW2                                                            0x0148
#define cfgPSWUSCFG0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                                      0x0150
#define cfgPSWUSCFG0_PCIE_UNCORR_ERR_STATUS                                                             0x0154
#define cfgPSWUSCFG0_PCIE_UNCORR_ERR_MASK                                                               0x0158
#define cfgPSWUSCFG0_PCIE_UNCORR_ERR_SEVERITY                                                           0x015c
#define cfgPSWUSCFG0_PCIE_CORR_ERR_STATUS                                                               0x0160
#define cfgPSWUSCFG0_PCIE_CORR_ERR_MASK                                                                 0x0164
#define cfgPSWUSCFG0_PCIE_ADV_ERR_CAP_CNTL                                                              0x0168
#define cfgPSWUSCFG0_PCIE_HDR_LOG0                                                                      0x016c
#define cfgPSWUSCFG0_PCIE_HDR_LOG1                                                                      0x0170
#define cfgPSWUSCFG0_PCIE_HDR_LOG2                                                                      0x0174
#define cfgPSWUSCFG0_PCIE_HDR_LOG3                                                                      0x0178
#define cfgPSWUSCFG0_PCIE_TLP_PREFIX_LOG0                                                               0x0188
#define cfgPSWUSCFG0_PCIE_TLP_PREFIX_LOG1                                                               0x018c
#define cfgPSWUSCFG0_PCIE_TLP_PREFIX_LOG2                                                               0x0190
#define cfgPSWUSCFG0_PCIE_TLP_PREFIX_LOG3                                                               0x0194
#define cfgPSWUSCFG0_PCIE_SECONDARY_ENH_CAP_LIST                                                        0x0270
#define cfgPSWUSCFG0_PCIE_LINK_CNTL3                                                                    0x0274
#define cfgPSWUSCFG0_PCIE_LANE_ERROR_STATUS                                                             0x0278
#define cfgPSWUSCFG0_PCIE_LANE_0_EQUALIZATION_CNTL                                                      0x027c
#define cfgPSWUSCFG0_PCIE_LANE_1_EQUALIZATION_CNTL                                                      0x027e
#define cfgPSWUSCFG0_PCIE_LANE_2_EQUALIZATION_CNTL                                                      0x0280
#define cfgPSWUSCFG0_PCIE_LANE_3_EQUALIZATION_CNTL                                                      0x0282
#define cfgPSWUSCFG0_PCIE_LANE_4_EQUALIZATION_CNTL                                                      0x0284
#define cfgPSWUSCFG0_PCIE_LANE_5_EQUALIZATION_CNTL                                                      0x0286
#define cfgPSWUSCFG0_PCIE_LANE_6_EQUALIZATION_CNTL                                                      0x0288
#define cfgPSWUSCFG0_PCIE_LANE_7_EQUALIZATION_CNTL                                                      0x028a
#define cfgPSWUSCFG0_PCIE_LANE_8_EQUALIZATION_CNTL                                                      0x028c
#define cfgPSWUSCFG0_PCIE_LANE_9_EQUALIZATION_CNTL                                                      0x028e
#define cfgPSWUSCFG0_PCIE_LANE_10_EQUALIZATION_CNTL                                                     0x0290
#define cfgPSWUSCFG0_PCIE_LANE_11_EQUALIZATION_CNTL                                                     0x0292
#define cfgPSWUSCFG0_PCIE_LANE_12_EQUALIZATION_CNTL                                                     0x0294
#define cfgPSWUSCFG0_PCIE_LANE_13_EQUALIZATION_CNTL                                                     0x0296
#define cfgPSWUSCFG0_PCIE_LANE_14_EQUALIZATION_CNTL                                                     0x0298
#define cfgPSWUSCFG0_PCIE_LANE_15_EQUALIZATION_CNTL                                                     0x029a
#define cfgPSWUSCFG0_PCIE_ACS_ENH_CAP_LIST                                                              0x02a0
#define cfgPSWUSCFG0_PCIE_ACS_CAP                                                                       0x02a4
#define cfgPSWUSCFG0_PCIE_ACS_CNTL                                                                      0x02a6
#define cfgPSWUSCFG0_PCIE_MC_ENH_CAP_LIST                                                               0x02f0
#define cfgPSWUSCFG0_PCIE_MC_CAP                                                                        0x02f4
#define cfgPSWUSCFG0_PCIE_MC_CNTL                                                                       0x02f6
#define cfgPSWUSCFG0_PCIE_MC_ADDR0                                                                      0x02f8
#define cfgPSWUSCFG0_PCIE_MC_ADDR1                                                                      0x02fc
#define cfgPSWUSCFG0_PCIE_MC_RCV0                                                                       0x0300
#define cfgPSWUSCFG0_PCIE_MC_RCV1                                                                       0x0304
#define cfgPSWUSCFG0_PCIE_MC_BLOCK_ALL0                                                                 0x0308
#define cfgPSWUSCFG0_PCIE_MC_BLOCK_ALL1                                                                 0x030c
#define cfgPSWUSCFG0_PCIE_MC_BLOCK_UNTRANSLATED_0                                                       0x0310
#define cfgPSWUSCFG0_PCIE_MC_BLOCK_UNTRANSLATED_1                                                       0x0314
#define cfgPCIE_MC_OVERLAY_BAR0                                                                         0x0318
#define cfgPCIE_MC_OVERLAY_BAR1                                                                         0x031c
#define cfgPSWUSCFG0_PCIE_LTR_ENH_CAP_LIST                                                              0x0320
#define cfgPSWUSCFG0_PCIE_LTR_CAP                                                                       0x0324
#define cfgPSWUSCFG0_PCIE_ARI_ENH_CAP_LIST                                                              0x0328
#define cfgPSWUSCFG0_PCIE_ARI_CAP                                                                       0x032c
#define cfgPSWUSCFG0_PCIE_ARI_CNTL                                                                      0x032e
#define cfgPCIE_L1_PM_SUB_CAP_LIST                                                                      0x0370
#define cfgPCIE_L1_PM_SUB_CAP                                                                           0x0374
#define cfgPCIE_L1_PM_SUB_CNTL                                                                          0x0378
#define cfgPCIE_L1_PM_SUB_CNTL2                                                                         0x037c
#define cfgPCIE_ESM_CAP_LIST                                                                            0x03c4
#define cfgPCIE_ESM_HEADER_1                                                                            0x03c8
#define cfgPCIE_ESM_HEADER_2                                                                            0x03cc
#define cfgPCIE_ESM_STATUS                                                                              0x03ce
#define cfgPCIE_ESM_CTRL                                                                                0x03d0
#define cfgPCIE_ESM_CAP_1                                                                               0x03d4
#define cfgPCIE_ESM_CAP_2                                                                               0x03d8
#define cfgPCIE_ESM_CAP_3                                                                               0x03dc
#define cfgPCIE_ESM_CAP_4                                                                               0x03e0
#define cfgPCIE_ESM_CAP_5                                                                               0x03e4
#define cfgPCIE_ESM_CAP_6                                                                               0x03e8
#define cfgPCIE_ESM_CAP_7                                                                               0x03ec


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_0_VENDOR_ID                                                                0x0000
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_ID                                                                0x0002
#define cfgBIF_CFG_DEV0_EPF0_0_COMMAND                                                                  0x0004
#define cfgBIF_CFG_DEV0_EPF0_0_STATUS                                                                   0x0006
#define cfgBIF_CFG_DEV0_EPF0_0_REVISION_ID                                                              0x0008
#define cfgBIF_CFG_DEV0_EPF0_0_PROG_INTERFACE                                                           0x0009
#define cfgBIF_CFG_DEV0_EPF0_0_SUB_CLASS                                                                0x000a
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_CLASS                                                               0x000b
#define cfgBIF_CFG_DEV0_EPF0_0_CACHE_LINE                                                               0x000c
#define cfgBIF_CFG_DEV0_EPF0_0_LATENCY                                                                  0x000d
#define cfgBIF_CFG_DEV0_EPF0_0_HEADER                                                                   0x000e
#define cfgBIF_CFG_DEV0_EPF0_0_BIST                                                                     0x000f
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_1                                                              0x0010
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_2                                                              0x0014
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_3                                                              0x0018
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_4                                                              0x001c
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_5                                                              0x0020
#define cfgBIF_CFG_DEV0_EPF0_0_BASE_ADDR_6                                                              0x0024
#define cfgBIF_CFG_DEV0_EPF0_0_ADAPTER_ID                                                               0x002c
#define cfgBIF_CFG_DEV0_EPF0_0_ROM_BASE_ADDR                                                            0x0030
#define cfgBIF_CFG_DEV0_EPF0_0_CAP_PTR                                                                  0x0034
#define cfgBIF_CFG_DEV0_EPF0_0_INTERRUPT_LINE                                                           0x003c
#define cfgBIF_CFG_DEV0_EPF0_0_INTERRUPT_PIN                                                            0x003d
#define cfgBIF_CFG_DEV0_EPF0_0_MIN_GRANT                                                                0x003e
#define cfgBIF_CFG_DEV0_EPF0_0_MAX_LATENCY                                                              0x003f
#define cfgBIF_CFG_DEV0_EPF0_0_VENDOR_CAP_LIST                                                          0x0048
#define cfgBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_W                                                             0x004c
#define cfgBIF_CFG_DEV0_EPF0_0_PMI_CAP_LIST                                                             0x0050
#define cfgBIF_CFG_DEV0_EPF0_0_PMI_CAP                                                                  0x0052
#define cfgBIF_CFG_DEV0_EPF0_0_PMI_STATUS_CNTL                                                          0x0054
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_CAP_LIST                                                            0x0064
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_CAP                                                                 0x0066
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_CAP                                                               0x0068
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL                                                              0x006c
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS                                                            0x006e
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_CAP                                                                 0x0070
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_CNTL                                                                0x0074
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_STATUS                                                              0x0076
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_CAP2                                                              0x0088
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL2                                                             0x008c
#define cfgBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS2                                                           0x008e
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_CAP2                                                                0x0090
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_CNTL2                                                               0x0094
#define cfgBIF_CFG_DEV0_EPF0_0_LINK_STATUS2                                                             0x0096
#define cfgBIF_CFG_DEV0_EPF0_0_SLOT_CAP2                                                                0x0098
#define cfgBIF_CFG_DEV0_EPF0_0_SLOT_CNTL2                                                               0x009c
#define cfgBIF_CFG_DEV0_EPF0_0_SLOT_STATUS2                                                             0x009e
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_CAP_LIST                                                             0x00a0
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MSG_CNTL                                                             0x00a2
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_LO                                                          0x00a4
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_HI                                                          0x00a8
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA                                                             0x00a8
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MASK                                                                 0x00ac
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_64                                                          0x00ac
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_MASK_64                                                              0x00b0
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_PENDING                                                              0x00b0
#define cfgBIF_CFG_DEV0_EPF0_0_MSI_PENDING_64                                                           0x00b4
#define cfgBIF_CFG_DEV0_EPF0_0_MSIX_CAP_LIST                                                            0x00c0
#define cfgBIF_CFG_DEV0_EPF0_0_MSIX_MSG_CNTL                                                            0x00c2
#define cfgBIF_CFG_DEV0_EPF0_0_MSIX_TABLE                                                               0x00c4
#define cfgBIF_CFG_DEV0_EPF0_0_MSIX_PBA                                                                 0x00c8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x0100
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x0104
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC1                                                    0x0108
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC2                                                    0x010c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC_ENH_CAP_LIST                                                     0x0110
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG1                                                    0x0114
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG2                                                    0x0118
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CNTL                                                        0x011c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_STATUS                                                      0x011e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CAP                                                    0x0120
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CNTL                                                   0x0124
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_STATUS                                                 0x012a
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CAP                                                    0x012c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CNTL                                                   0x0130
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_STATUS                                                 0x0136
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                         0x0140
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW1                                                  0x0144
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW2                                                  0x0148
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x0150
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_STATUS                                                   0x0154
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_MASK                                                     0x0158
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x015c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_STATUS                                                     0x0160
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_MASK                                                       0x0164
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x0168
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG0                                                            0x016c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG1                                                            0x0170
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG2                                                            0x0174
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG3                                                            0x0178
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG0                                                     0x0188
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG1                                                     0x018c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG2                                                     0x0190
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG3                                                     0x0194
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR_ENH_CAP_LIST                                                    0x0200
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CAP                                                            0x0204
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CNTL                                                           0x0208
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CAP                                                            0x020c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CNTL                                                           0x0210
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CAP                                                            0x0214
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CNTL                                                           0x0218
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CAP                                                            0x021c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CNTL                                                           0x0220
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CAP                                                            0x0224
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CNTL                                                           0x0228
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CAP                                                            0x022c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CNTL                                                           0x0230
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x0240
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x0244
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA                                                     0x0248
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_CAP                                                      0x024c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_ENH_CAP_LIST                                                    0x0250
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CAP                                                             0x0254
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_LATENCY_INDICATOR                                               0x0258
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_STATUS                                                          0x025c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CNTL                                                            0x025e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x0260
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x0261
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x0262
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x0263
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x0264
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x0265
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x0266
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x0267
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x0270
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LINK_CNTL3                                                          0x0274
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_ERROR_STATUS                                                   0x0278
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x027c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x027e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x0280
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x0282
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x0284
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x0286
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x0288
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x028a
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x028c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x028e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x0290
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x0292
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x0294
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x0296
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x0298
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x029a
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ACS_ENH_CAP_LIST                                                    0x02a0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CAP                                                             0x02a4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CNTL                                                            0x02a6
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ATS_ENH_CAP_LIST                                                    0x02b0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CAP                                                             0x02b4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CNTL                                                            0x02b6
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_ENH_CAP_LIST                                               0x02c0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_CNTL                                                       0x02c4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_STATUS                                                     0x02c6
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY                                          0x02c8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC                                             0x02cc
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PASID_ENH_CAP_LIST                                                  0x02d0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CAP                                                           0x02d4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CNTL                                                          0x02d6
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TPH_REQR_ENH_CAP_LIST                                               0x02e0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TPH_REQR_CAP                                                        0x02e4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_TPH_REQR_CNTL                                                       0x02e8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_ENH_CAP_LIST                                                     0x02f0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_CAP                                                              0x02f4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_CNTL                                                             0x02f6
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR0                                                            0x02f8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR1                                                            0x02fc
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV0                                                             0x0300
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV1                                                             0x0304
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL0                                                       0x0308
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL1                                                       0x030c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_0                                             0x0310
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_1                                             0x0314
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LTR_ENH_CAP_LIST                                                    0x0320
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_LTR_CAP                                                             0x0324
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ARI_ENH_CAP_LIST                                                    0x0328
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CAP                                                             0x032c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CNTL                                                            0x032e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_ENH_CAP_LIST                                                  0x0330
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CAP                                                           0x0334
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CONTROL                                                       0x0338
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_STATUS                                                        0x033a
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_INITIAL_VFS                                                   0x033c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_TOTAL_VFS                                                     0x033e
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_NUM_VFS                                                       0x0340
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FUNC_DEP_LINK                                                 0x0342
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FIRST_VF_OFFSET                                               0x0344
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_STRIDE                                                     0x0346
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_DEVICE_ID                                                  0x034a
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                           0x034c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                              0x0350
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_0                                                0x0354
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_1                                                0x0358
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_2                                                0x035c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_3                                                0x0360
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_4                                                0x0364
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_5                                                0x0368
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                               0x036c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                 0x0400
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV                                          0x0404
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW                             0x0408
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE                              0x040c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS                              0x0410
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL                            0x0414
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0                            0x0418
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1                            0x041c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2                            0x0420
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT                                  0x0424
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB                                 0x0428
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS                                  0x042c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB                                   0x0430
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB                                   0x0434
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB                                   0x0438
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB                                   0x043c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB                                   0x0440
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB                                   0x0444
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB                                   0x0448
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB                                   0x044c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB                                   0x0450
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB                                   0x0454
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB                                  0x0458
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB                                  0x045c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB                                  0x0460
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB                                  0x0464
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB                                  0x0468
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB                                  0x046c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0                               0x0470
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1                               0x0474
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2                               0x0478
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3                               0x047c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4                               0x0480
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5                               0x0484
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6                               0x0488
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7                               0x048c
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8                               0x0490
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0                               0x04a0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1                               0x04a4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2                               0x04a8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3                               0x04ac
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4                               0x04b0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5                               0x04b4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6                               0x04b8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7                               0x04bc
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8                               0x04c0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0                               0x04d0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1                               0x04d4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2                               0x04d8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3                               0x04dc
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4                               0x04e0
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5                               0x04e4
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6                               0x04e8
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7                               0x04ec
#define cfgBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8                               0x04f0


// addressBlock: nbio_nbif_bif_cfg_dev0_epf1_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF1_0_VENDOR_ID                                                                0x0000
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_ID                                                                0x0002
#define cfgBIF_CFG_DEV0_EPF1_0_COMMAND                                                                  0x0004
#define cfgBIF_CFG_DEV0_EPF1_0_STATUS                                                                   0x0006
#define cfgBIF_CFG_DEV0_EPF1_0_REVISION_ID                                                              0x0008
#define cfgBIF_CFG_DEV0_EPF1_0_PROG_INTERFACE                                                           0x0009
#define cfgBIF_CFG_DEV0_EPF1_0_SUB_CLASS                                                                0x000a
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_CLASS                                                               0x000b
#define cfgBIF_CFG_DEV0_EPF1_0_CACHE_LINE                                                               0x000c
#define cfgBIF_CFG_DEV0_EPF1_0_LATENCY                                                                  0x000d
#define cfgBIF_CFG_DEV0_EPF1_0_HEADER                                                                   0x000e
#define cfgBIF_CFG_DEV0_EPF1_0_BIST                                                                     0x000f
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_1                                                              0x0010
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_2                                                              0x0014
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_3                                                              0x0018
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_4                                                              0x001c
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_5                                                              0x0020
#define cfgBIF_CFG_DEV0_EPF1_0_BASE_ADDR_6                                                              0x0024
#define cfgBIF_CFG_DEV0_EPF1_0_ADAPTER_ID                                                               0x002c
#define cfgBIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR                                                            0x0030
#define cfgBIF_CFG_DEV0_EPF1_0_CAP_PTR                                                                  0x0034
#define cfgBIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE                                                           0x003c
#define cfgBIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN                                                            0x003d
#define cfgBIF_CFG_DEV0_EPF1_0_MIN_GRANT                                                                0x003e
#define cfgBIF_CFG_DEV0_EPF1_0_MAX_LATENCY                                                              0x003f
#define cfgBIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST                                                          0x0048
#define cfgBIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W                                                             0x004c
#define cfgBIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST                                                             0x0050
#define cfgBIF_CFG_DEV0_EPF1_0_PMI_CAP                                                                  0x0052
#define cfgBIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL                                                          0x0054
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST                                                            0x0064
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_CAP                                                                 0x0066
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_CAP                                                               0x0068
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL                                                              0x006c
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS                                                            0x006e
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_CAP                                                                 0x0070
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_CNTL                                                                0x0074
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_STATUS                                                              0x0076
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_CAP2                                                              0x0088
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2                                                             0x008c
#define cfgBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2                                                           0x008e
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_CAP2                                                                0x0090
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_CNTL2                                                               0x0094
#define cfgBIF_CFG_DEV0_EPF1_0_LINK_STATUS2                                                             0x0096
#define cfgBIF_CFG_DEV0_EPF1_0_SLOT_CAP2                                                                0x0098
#define cfgBIF_CFG_DEV0_EPF1_0_SLOT_CNTL2                                                               0x009c
#define cfgBIF_CFG_DEV0_EPF1_0_SLOT_STATUS2                                                             0x009e
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST                                                             0x00a0
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL                                                             0x00a2
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO                                                          0x00a4
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI                                                          0x00a8
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA                                                             0x00a8
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MASK                                                                 0x00ac
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64                                                          0x00ac
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_MASK_64                                                              0x00b0
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_PENDING                                                              0x00b0
#define cfgBIF_CFG_DEV0_EPF1_0_MSI_PENDING_64                                                           0x00b4
#define cfgBIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST                                                            0x00c0
#define cfgBIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL                                                            0x00c2
#define cfgBIF_CFG_DEV0_EPF1_0_MSIX_TABLE                                                               0x00c4
#define cfgBIF_CFG_DEV0_EPF1_0_MSIX_PBA                                                                 0x00c8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x0100
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x0104
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1                                                    0x0108
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2                                                    0x010c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST                                                     0x0110
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1                                                    0x0114
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2                                                    0x0118
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL                                                        0x011c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_STATUS                                                      0x011e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP                                                    0x0120
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL                                                   0x0124
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS                                                 0x012a
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP                                                    0x012c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL                                                   0x0130
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS                                                 0x0136
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                         0x0140
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1                                                  0x0144
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2                                                  0x0148
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x0150
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS                                                   0x0154
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK                                                     0x0158
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x015c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS                                                     0x0160
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK                                                       0x0164
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x0168
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0                                                            0x016c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1                                                            0x0170
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2                                                            0x0174
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3                                                            0x0178
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0                                                     0x0188
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1                                                     0x018c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2                                                     0x0190
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3                                                     0x0194
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST                                                    0x0200
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP                                                            0x0204
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL                                                           0x0208
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP                                                            0x020c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL                                                           0x0210
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP                                                            0x0214
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL                                                           0x0218
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP                                                            0x021c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL                                                           0x0220
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP                                                            0x0224
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL                                                           0x0228
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP                                                            0x022c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL                                                           0x0230
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x0240
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x0244
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA                                                     0x0248
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP                                                      0x024c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST                                                    0x0250
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP                                                             0x0254
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR                                               0x0258
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS                                                          0x025c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL                                                            0x025e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x0260
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x0261
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x0262
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x0263
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x0264
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x0265
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x0266
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x0267
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x0270
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3                                                          0x0274
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS                                                   0x0278
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x027c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x027e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x0280
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x0282
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x0284
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x0286
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x0288
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x028a
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x028c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x028e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x0290
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x0292
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x0294
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x0296
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x0298
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x029a
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST                                                    0x02a0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP                                                             0x02a4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL                                                            0x02a6
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST                                                    0x02b0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP                                                             0x02b4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL                                                            0x02b6
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST                                               0x02c0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL                                                       0x02c4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS                                                     0x02c6
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY                                          0x02c8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC                                             0x02cc
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST                                                  0x02d0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP                                                           0x02d4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL                                                          0x02d6
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST                                               0x02e0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP                                                        0x02e4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL                                                       0x02e8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST                                                     0x02f0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP                                                              0x02f4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL                                                             0x02f6
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0                                                            0x02f8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1                                                            0x02fc
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0                                                             0x0300
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1                                                             0x0304
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0                                                       0x0308
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1                                                       0x030c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0                                             0x0310
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1                                             0x0314
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST                                                    0x0320
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP                                                             0x0324
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST                                                    0x0328
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP                                                             0x032c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL                                                            0x032e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST                                                  0x0330
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP                                                           0x0334
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL                                                       0x0338
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS                                                        0x033a
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS                                                   0x033c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS                                                     0x033e
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS                                                       0x0340
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK                                                 0x0342
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET                                               0x0344
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE                                                     0x0346
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID                                                  0x034a
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                           0x034c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                              0x0350
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0                                                0x0354
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1                                                0x0358
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2                                                0x035c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3                                                0x0360
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4                                                0x0364
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5                                                0x0368
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                               0x036c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                 0x0400
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV                                          0x0404
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW                             0x0408
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE                              0x040c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS                              0x0410
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL                            0x0414
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0                            0x0418
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1                            0x041c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2                            0x0420
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT                                  0x0424
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB                                 0x0428
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS                                  0x042c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB                                   0x0430
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB                                   0x0434
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB                                   0x0438
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB                                   0x043c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB                                   0x0440
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB                                   0x0444
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB                                   0x0448
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB                                   0x044c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB                                   0x0450
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB                                   0x0454
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB                                  0x0458
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB                                  0x045c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB                                  0x0460
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB                                  0x0464
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB                                  0x0468
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB                                  0x046c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0                               0x0470
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1                               0x0474
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2                               0x0478
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3                               0x047c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4                               0x0480
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5                               0x0484
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6                               0x0488
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7                               0x048c
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8                               0x0490
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0                               0x04a0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1                               0x04a4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2                               0x04a8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3                               0x04ac
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4                               0x04b0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5                               0x04b4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6                               0x04b8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7                               0x04bc
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8                               0x04c0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0                               0x04d0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1                               0x04d4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2                               0x04d8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3                               0x04dc
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4                               0x04e0
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5                               0x04e4
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6                               0x04e8
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7                               0x04ec
#define cfgBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8                               0x04f0


// addressBlock: nbio_nbif_bif_cfg_dev0_swds_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_SWDS0_VENDOR_ID                                                                 0x0000
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_ID                                                                 0x0002
#define cfgBIF_CFG_DEV0_SWDS0_COMMAND                                                                   0x0004
#define cfgBIF_CFG_DEV0_SWDS0_STATUS                                                                    0x0006
#define cfgBIF_CFG_DEV0_SWDS0_REVISION_ID                                                               0x0008
#define cfgBIF_CFG_DEV0_SWDS0_PROG_INTERFACE                                                            0x0009
#define cfgBIF_CFG_DEV0_SWDS0_SUB_CLASS                                                                 0x000a
#define cfgBIF_CFG_DEV0_SWDS0_BASE_CLASS                                                                0x000b
#define cfgBIF_CFG_DEV0_SWDS0_CACHE_LINE                                                                0x000c
#define cfgBIF_CFG_DEV0_SWDS0_LATENCY                                                                   0x000d
#define cfgBIF_CFG_DEV0_SWDS0_HEADER                                                                    0x000e
#define cfgBIF_CFG_DEV0_SWDS0_BIST                                                                      0x000f
#define cfgBIF_CFG_DEV0_SWDS0_BASE_ADDR_1                                                               0x0010
#define cfgBIF_CFG_DEV0_SWDS0_SUB_BUS_NUMBER_LATENCY                                                    0x0018
#define cfgBIF_CFG_DEV0_SWDS0_IO_BASE_LIMIT                                                             0x001c
#define cfgBIF_CFG_DEV0_SWDS0_SECONDARY_STATUS                                                          0x001e
#define cfgBIF_CFG_DEV0_SWDS0_MEM_BASE_LIMIT                                                            0x0020
#define cfgBIF_CFG_DEV0_SWDS0_PREF_BASE_LIMIT                                                           0x0024
#define cfgBIF_CFG_DEV0_SWDS0_PREF_BASE_UPPER                                                           0x0028
#define cfgBIF_CFG_DEV0_SWDS0_PREF_LIMIT_UPPER                                                          0x002c
#define cfgBIF_CFG_DEV0_SWDS0_IO_BASE_LIMIT_HI                                                          0x0030
#define cfgBIF_CFG_DEV0_SWDS0_CAP_PTR                                                                   0x0034
#define cfgBIF_CFG_DEV0_SWDS0_INTERRUPT_LINE                                                            0x003c
#define cfgBIF_CFG_DEV0_SWDS0_INTERRUPT_PIN                                                             0x003d
#define cfgBIF_CFG_DEV0_SWDS0_IRQ_BRIDGE_CNTL                                                           0x003e
#define cfgBIF_CFG_DEV0_SWDS0_PMI_CAP_LIST                                                              0x0050
#define cfgBIF_CFG_DEV0_SWDS0_PMI_CAP                                                                   0x0052
#define cfgBIF_CFG_DEV0_SWDS0_PMI_STATUS_CNTL                                                           0x0054
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_CAP_LIST                                                             0x0058
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_CAP                                                                  0x005a
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_CAP                                                                0x005c
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_CNTL                                                               0x0060
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_STATUS                                                             0x0062
#define cfgBIF_CFG_DEV0_SWDS0_LINK_CAP                                                                  0x0064
#define cfgBIF_CFG_DEV0_SWDS0_LINK_CNTL                                                                 0x0068
#define cfgBIF_CFG_DEV0_SWDS0_LINK_STATUS                                                               0x006a
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_CAP                                                                  0x006c
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_CNTL                                                                 0x0070
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_STATUS                                                               0x0072
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_CAP2                                                               0x007c
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_CNTL2                                                              0x0080
#define cfgBIF_CFG_DEV0_SWDS0_DEVICE_STATUS2                                                            0x0082
#define cfgBIF_CFG_DEV0_SWDS0_LINK_CAP2                                                                 0x0084
#define cfgBIF_CFG_DEV0_SWDS0_LINK_CNTL2                                                                0x0088
#define cfgBIF_CFG_DEV0_SWDS0_LINK_STATUS2                                                              0x008a
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_CAP2                                                                 0x008c
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_CNTL2                                                                0x0090
#define cfgBIF_CFG_DEV0_SWDS0_SLOT_STATUS2                                                              0x0092
#define cfgBIF_CFG_DEV0_SWDS0_MSI_CAP_LIST                                                              0x00a0
#define cfgBIF_CFG_DEV0_SWDS0_MSI_MSG_CNTL                                                              0x00a2
#define cfgBIF_CFG_DEV0_SWDS0_MSI_MSG_ADDR_LO                                                           0x00a4
#define cfgBIF_CFG_DEV0_SWDS0_MSI_MSG_ADDR_HI                                                           0x00a8
#define cfgBIF_CFG_DEV0_SWDS0_MSI_MSG_DATA                                                              0x00a8
#define cfgBIF_CFG_DEV0_SWDS0_MSI_MSG_DATA_64                                                           0x00ac
#define cfgBIF_CFG_DEV0_SWDS0_SSID_CAP_LIST                                                             0x00c0
#define cfgBIF_CFG_DEV0_SWDS0_SSID_CAP                                                                  0x00c4
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                         0x0100
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VENDOR_SPECIFIC_HDR                                                  0x0104
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VENDOR_SPECIFIC1                                                     0x0108
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VENDOR_SPECIFIC2                                                     0x010c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC_ENH_CAP_LIST                                                      0x0110
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_PORT_VC_CAP_REG1                                                     0x0114
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_PORT_VC_CAP_REG2                                                     0x0118
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_PORT_VC_CNTL                                                         0x011c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_PORT_VC_STATUS                                                       0x011e
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC0_RESOURCE_CAP                                                     0x0120
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC0_RESOURCE_CNTL                                                    0x0124
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC0_RESOURCE_STATUS                                                  0x012a
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC1_RESOURCE_CAP                                                     0x012c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC1_RESOURCE_CNTL                                                    0x0130
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_VC1_RESOURCE_STATUS                                                  0x0136
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                          0x0140
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_DEV_SERIAL_NUM_DW1                                                   0x0144
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_DEV_SERIAL_NUM_DW2                                                   0x0148
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                             0x0150
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_UNCORR_ERR_STATUS                                                    0x0154
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_UNCORR_ERR_MASK                                                      0x0158
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_UNCORR_ERR_SEVERITY                                                  0x015c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_CORR_ERR_STATUS                                                      0x0160
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_CORR_ERR_MASK                                                        0x0164
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_ADV_ERR_CAP_CNTL                                                     0x0168
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_HDR_LOG0                                                             0x016c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_HDR_LOG1                                                             0x0170
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_HDR_LOG2                                                             0x0174
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_HDR_LOG3                                                             0x0178
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_TLP_PREFIX_LOG0                                                      0x0188
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_TLP_PREFIX_LOG1                                                      0x018c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_TLP_PREFIX_LOG2                                                      0x0190
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_TLP_PREFIX_LOG3                                                      0x0194
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_SECONDARY_ENH_CAP_LIST                                               0x0270
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LINK_CNTL3                                                           0x0274
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_ERROR_STATUS                                                    0x0278
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_0_EQUALIZATION_CNTL                                             0x027c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_1_EQUALIZATION_CNTL                                             0x027e
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_2_EQUALIZATION_CNTL                                             0x0280
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_3_EQUALIZATION_CNTL                                             0x0282
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_4_EQUALIZATION_CNTL                                             0x0284
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_5_EQUALIZATION_CNTL                                             0x0286
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_6_EQUALIZATION_CNTL                                             0x0288
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_7_EQUALIZATION_CNTL                                             0x028a
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_8_EQUALIZATION_CNTL                                             0x028c
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_9_EQUALIZATION_CNTL                                             0x028e
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_10_EQUALIZATION_CNTL                                            0x0290
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_11_EQUALIZATION_CNTL                                            0x0292
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_12_EQUALIZATION_CNTL                                            0x0294
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_13_EQUALIZATION_CNTL                                            0x0296
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_14_EQUALIZATION_CNTL                                            0x0298
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_LANE_15_EQUALIZATION_CNTL                                            0x029a
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_ACS_ENH_CAP_LIST                                                     0x02a0
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_ACS_CAP                                                              0x02a4
#define cfgBIF_CFG_DEV0_SWDS0_PCIE_ACS_CNTL                                                             0x02a6


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf0_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF0_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf1_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF1_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf2_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF2_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf3_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF3_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf4_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF4_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf5_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF5_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf6_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF6_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf7_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF7_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf8_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF8_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf9_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_VENDOR_ID                                                            0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_ID                                                            0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_COMMAND                                                              0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_STATUS                                                               0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_REVISION_ID                                                          0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PROG_INTERFACE                                                       0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_SUB_CLASS                                                            0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_CLASS                                                           0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_CACHE_LINE                                                           0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LATENCY                                                              0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_HEADER                                                               0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BIST                                                                 0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_1                                                          0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_2                                                          0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_3                                                          0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_4                                                          0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_5                                                          0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_BASE_ADDR_6                                                          0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_ADAPTER_ID                                                           0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_ROM_BASE_ADDR                                                        0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_CAP_PTR                                                              0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_INTERRUPT_LINE                                                       0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_INTERRUPT_PIN                                                        0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_CAP_LIST                                                        0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_CAP                                                             0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_CAP                                                           0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_CNTL                                                          0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_STATUS                                                        0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_CAP                                                             0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_CNTL                                                            0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_STATUS                                                          0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_CAP2                                                          0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_CNTL2                                                         0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_DEVICE_STATUS2                                                       0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_CAP2                                                            0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_CNTL2                                                           0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_LINK_STATUS2                                                         0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_SLOT_CAP2                                                            0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_SLOT_CNTL2                                                           0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_SLOT_STATUS2                                                         0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_CAP_LIST                                                         0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MSG_CNTL                                                         0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MSG_ADDR_LO                                                      0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MSG_ADDR_HI                                                      0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MSG_DATA                                                         0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MASK                                                             0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MSG_DATA_64                                                      0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_MASK_64                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_PENDING                                                          0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSI_PENDING_64                                                       0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSIX_CAP_LIST                                                        0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSIX_MSG_CNTL                                                        0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSIX_TABLE                                                           0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_MSIX_PBA                                                             0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                    0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_VENDOR_SPECIFIC_HDR                                             0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_VENDOR_SPECIFIC1                                                0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_VENDOR_SPECIFIC2                                                0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                        0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_UNCORR_ERR_STATUS                                               0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_UNCORR_ERR_MASK                                                 0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_UNCORR_ERR_SEVERITY                                             0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_CORR_ERR_STATUS                                                 0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_CORR_ERR_MASK                                                   0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ADV_ERR_CAP_CNTL                                                0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_HDR_LOG0                                                        0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_HDR_LOG1                                                        0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_HDR_LOG2                                                        0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_HDR_LOG3                                                        0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_TLP_PREFIX_LOG0                                                 0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_TLP_PREFIX_LOG1                                                 0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_TLP_PREFIX_LOG2                                                 0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_TLP_PREFIX_LOG3                                                 0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ATS_ENH_CAP_LIST                                                0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ATS_CAP                                                         0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ATS_CNTL                                                        0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ARI_ENH_CAP_LIST                                                0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ARI_CAP                                                         0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF9_0_PCIE_ARI_CNTL                                                        0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf10_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF10_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf11_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF11_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf12_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF12_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf13_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF13_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf14_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF14_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_cfg_dev0_epf0_vf15_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_VENDOR_ID                                                           0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_ID                                                           0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_COMMAND                                                             0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_STATUS                                                              0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_REVISION_ID                                                         0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PROG_INTERFACE                                                      0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_SUB_CLASS                                                           0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_CLASS                                                          0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_CACHE_LINE                                                          0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LATENCY                                                             0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_HEADER                                                              0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BIST                                                                0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_1                                                         0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_2                                                         0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_3                                                         0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_4                                                         0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_5                                                         0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_BASE_ADDR_6                                                         0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_ADAPTER_ID                                                          0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_ROM_BASE_ADDR                                                       0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_CAP_PTR                                                             0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_INTERRUPT_LINE                                                      0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_INTERRUPT_PIN                                                       0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_CAP_LIST                                                       0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_CAP                                                            0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_CAP                                                          0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_CNTL                                                         0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_STATUS                                                       0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_CAP                                                            0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_CNTL                                                           0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_STATUS                                                         0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_CAP2                                                         0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_CNTL2                                                        0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_DEVICE_STATUS2                                                      0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_CAP2                                                           0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_CNTL2                                                          0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_LINK_STATUS2                                                        0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_SLOT_CAP2                                                           0x0098
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_SLOT_CNTL2                                                          0x009c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_SLOT_STATUS2                                                        0x009e
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_CAP_LIST                                                        0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MSG_CNTL                                                        0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MSG_ADDR_LO                                                     0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MSG_ADDR_HI                                                     0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MSG_DATA                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MASK                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MSG_DATA_64                                                     0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_MASK_64                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_PENDING                                                         0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSI_PENDING_64                                                      0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSIX_CAP_LIST                                                       0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSIX_MSG_CNTL                                                       0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSIX_TABLE                                                          0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_MSIX_PBA                                                            0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                   0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_VENDOR_SPECIFIC_HDR                                            0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_VENDOR_SPECIFIC1                                               0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_VENDOR_SPECIFIC2                                               0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                       0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_UNCORR_ERR_STATUS                                              0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_UNCORR_ERR_MASK                                                0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_UNCORR_ERR_SEVERITY                                            0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_CORR_ERR_STATUS                                                0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_CORR_ERR_MASK                                                  0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ADV_ERR_CAP_CNTL                                               0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_HDR_LOG0                                                       0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_HDR_LOG1                                                       0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_HDR_LOG2                                                       0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_HDR_LOG3                                                       0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_TLP_PREFIX_LOG0                                                0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_TLP_PREFIX_LOG1                                                0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_TLP_PREFIX_LOG2                                                0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_TLP_PREFIX_LOG3                                                0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ATS_ENH_CAP_LIST                                               0x02b0
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ATS_CAP                                                        0x02b4
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ATS_CNTL                                                       0x02b6
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ARI_ENH_CAP_LIST                                               0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ARI_CAP                                                        0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF15_0_PCIE_ARI_CNTL                                                       0x032e


// addressBlock: nbio_nbif_bif_bx_pf_SYSPFVFDEC[0..767]
// base address: 0x0
#define mmMM_INDEX                                                                                     0x0000
#define mmMM_INDEX_BASE_IDX                                                                            0
#define mmMM_DATA                                                                                      0x0001
#define mmMM_DATA_BASE_IDX                                                                             0
#define mmMM_INDEX_HI                                                                                  0x0006
#define mmMM_INDEX_HI_BASE_IDX                                                                         0


// addressBlock: nbio_nbif_bif_bx_pf_SYSDEC[0..767]
// base address: 0x0
#define mmSYSHUB_INDEX_OVLP                                                                            0x0008
#define mmSYSHUB_INDEX_OVLP_BASE_IDX                                                                   0
#define mmSYSHUB_DATA_OVLP                                                                             0x0009
#define mmSYSHUB_DATA_OVLP_BASE_IDX                                                                    0
#define mmPCIE_INDEX                                                                                   0x000c
#define mmPCIE_INDEX_BASE_IDX                                                                          0
#define mmPCIE_DATA                                                                                    0x000d
#define mmPCIE_DATA_BASE_IDX                                                                           0
#define mmPCIE_INDEX2                                                                                  0x000e
#define mmPCIE_INDEX2_BASE_IDX                                                                         0
#define mmPCIE_DATA2                                                                                   0x000f
#define mmPCIE_DATA2_BASE_IDX                                                                          0
#define mmSBIOS_SCRATCH_0                                                                              0x0034
#define mmSBIOS_SCRATCH_0_BASE_IDX                                                                     1
#define mmSBIOS_SCRATCH_1                                                                              0x0035
#define mmSBIOS_SCRATCH_1_BASE_IDX                                                                     1
#define mmSBIOS_SCRATCH_2                                                                              0x0036
#define mmSBIOS_SCRATCH_2_BASE_IDX                                                                     1
#define mmSBIOS_SCRATCH_3                                                                              0x0037
#define mmSBIOS_SCRATCH_3_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_0                                                                               0x0038
#define mmBIOS_SCRATCH_0_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_1                                                                               0x0039
#define mmBIOS_SCRATCH_1_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_2                                                                               0x003a
#define mmBIOS_SCRATCH_2_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_3                                                                               0x003b
#define mmBIOS_SCRATCH_3_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_4                                                                               0x003c
#define mmBIOS_SCRATCH_4_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_5                                                                               0x003d
#define mmBIOS_SCRATCH_5_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_6                                                                               0x003e
#define mmBIOS_SCRATCH_6_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_7                                                                               0x003f
#define mmBIOS_SCRATCH_7_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_8                                                                               0x0040
#define mmBIOS_SCRATCH_8_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_9                                                                               0x0041
#define mmBIOS_SCRATCH_9_BASE_IDX                                                                      1
#define mmBIOS_SCRATCH_10                                                                              0x0042
#define mmBIOS_SCRATCH_10_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_11                                                                              0x0043
#define mmBIOS_SCRATCH_11_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_12                                                                              0x0044
#define mmBIOS_SCRATCH_12_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_13                                                                              0x0045
#define mmBIOS_SCRATCH_13_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_14                                                                              0x0046
#define mmBIOS_SCRATCH_14_BASE_IDX                                                                     1
#define mmBIOS_SCRATCH_15                                                                              0x0047
#define mmBIOS_SCRATCH_15_BASE_IDX                                                                     1
#define mmBIF_RLC_INTR_CNTL                                                                            0x004c
#define mmBIF_RLC_INTR_CNTL_BASE_IDX                                                                   1
#define mmBIF_VCE_INTR_CNTL                                                                            0x004d
#define mmBIF_VCE_INTR_CNTL_BASE_IDX                                                                   1
#define mmBIF_UVD_INTR_CNTL                                                                            0x004e
#define mmBIF_UVD_INTR_CNTL_BASE_IDX                                                                   1
#define mmGFX_MMIOREG_CAM_ADDR0                                                                        0x006c
#define mmGFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR0                                                                  0x006d
#define mmGFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR1                                                                        0x006e
#define mmGFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR1                                                                  0x006f
#define mmGFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR2                                                                        0x0070
#define mmGFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR2                                                                  0x0071
#define mmGFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR3                                                                        0x0072
#define mmGFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR3                                                                  0x0073
#define mmGFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR4                                                                        0x0074
#define mmGFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR4                                                                  0x0075
#define mmGFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR5                                                                        0x0076
#define mmGFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR5                                                                  0x0077
#define mmGFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR6                                                                        0x0078
#define mmGFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR6                                                                  0x0079
#define mmGFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_ADDR7                                                                        0x007a
#define mmGFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                               1
#define mmGFX_MMIOREG_CAM_REMAP_ADDR7                                                                  0x007b
#define mmGFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                         1
#define mmGFX_MMIOREG_CAM_CNTL                                                                         0x007c
#define mmGFX_MMIOREG_CAM_CNTL_BASE_IDX                                                                1
#define mmGFX_MMIOREG_CAM_ZERO_CPL                                                                     0x007d
#define mmGFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                            1
#define mmGFX_MMIOREG_CAM_ONE_CPL                                                                      0x007e
#define mmGFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                             1
#define mmGFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                             0x007f
#define mmGFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                                    1


// addressBlock: nbio_nbif_syshub_mmreg_ind_syshubdec[32..39]
// base address: 0x20
#define mmSYSHUB_INDEX                                                                                 0x0008
#define mmSYSHUB_INDEX_BASE_IDX                                                                        0
#define mmSYSHUB_DATA                                                                                  0x0009
#define mmSYSHUB_DATA_BASE_IDX                                                                         0


// addressBlock: nbio_nbif_rcc_strap_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmRCC_DEV0_EPF0_STRAP0                                                                         0x000f
#define mmRCC_DEV0_EPF0_STRAP0_BASE_IDX                                                                2


// addressBlock: nbio_nbif_rcc_ep_dev0_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmEP_PCIE_SCRATCH                                                                              0x0023
#define mmEP_PCIE_SCRATCH_BASE_IDX                                                                     2
#define mmEP_PCIE_CNTL                                                                                 0x0025
#define mmEP_PCIE_CNTL_BASE_IDX                                                                        2
#define mmEP_PCIE_INT_CNTL                                                                             0x0026
#define mmEP_PCIE_INT_CNTL_BASE_IDX                                                                    2
#define mmEP_PCIE_INT_STATUS                                                                           0x0027
#define mmEP_PCIE_INT_STATUS_BASE_IDX                                                                  2
#define mmEP_PCIE_RX_CNTL2                                                                             0x0028
#define mmEP_PCIE_RX_CNTL2_BASE_IDX                                                                    2
#define mmEP_PCIE_BUS_CNTL                                                                             0x0029
#define mmEP_PCIE_BUS_CNTL_BASE_IDX                                                                    2
#define mmEP_PCIE_CFG_CNTL                                                                             0x002a
#define mmEP_PCIE_CFG_CNTL_BASE_IDX                                                                    2
#define mmEP_PCIE_TX_LTR_CNTL                                                                          0x002c
#define mmEP_PCIE_TX_LTR_CNTL_BASE_IDX                                                                 2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                                             0x002d
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                                             0x002d
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                                             0x002d
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                                             0x002d
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                                             0x002e
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                                             0x002e
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                                             0x002e
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                                    2
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                                             0x002e
#define mmPCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                                    2
#define mmEP_PCIE_F0_DPA_CAP                                                                           0x0032
#define mmEP_PCIE_F0_DPA_CAP_BASE_IDX                                                                  2
#define mmEP_PCIE_F0_DPA_LATENCY_INDICATOR                                                             0x0033
#define mmEP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                                    2
#define mmEP_PCIE_F0_DPA_CNTL                                                                          0x0033
#define mmEP_PCIE_F0_DPA_CNTL_BASE_IDX                                                                 2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                                             0x0033
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                                             0x0034
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                                             0x0034
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                                             0x0034
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                                             0x0034
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                                             0x0035
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                                             0x0035
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                                    2
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                                             0x0035
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                                    2
#define mmEP_PCIE_PME_CONTROL                                                                          0x0035
#define mmEP_PCIE_PME_CONTROL_BASE_IDX                                                                 2
#define mmEP_PCIEP_RESERVED                                                                            0x0036
#define mmEP_PCIEP_RESERVED_BASE_IDX                                                                   2
#define mmEP_PCIE_TX_CNTL                                                                              0x0038
#define mmEP_PCIE_TX_CNTL_BASE_IDX                                                                     2
#define mmEP_PCIE_TX_REQUESTER_ID                                                                      0x0039
#define mmEP_PCIE_TX_REQUESTER_ID_BASE_IDX                                                             2
#define mmEP_PCIE_ERR_CNTL                                                                             0x003a
#define mmEP_PCIE_ERR_CNTL_BASE_IDX                                                                    2
#define mmEP_PCIE_RX_CNTL                                                                              0x003b
#define mmEP_PCIE_RX_CNTL_BASE_IDX                                                                     2
#define mmEP_PCIE_LC_SPEED_CNTL                                                                        0x003c
#define mmEP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                               2


// addressBlock: nbio_nbif_rcc_dwn_dev0_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmDN_PCIE_RESERVED                                                                             0x0040
#define mmDN_PCIE_RESERVED_BASE_IDX                                                                    2
#define mmDN_PCIE_SCRATCH                                                                              0x0041
#define mmDN_PCIE_SCRATCH_BASE_IDX                                                                     2
#define mmDN_PCIE_CNTL                                                                                 0x0043
#define mmDN_PCIE_CNTL_BASE_IDX                                                                        2
#define mmDN_PCIE_CONFIG_CNTL                                                                          0x0044
#define mmDN_PCIE_CONFIG_CNTL_BASE_IDX                                                                 2
#define mmDN_PCIE_RX_CNTL2                                                                             0x0045
#define mmDN_PCIE_RX_CNTL2_BASE_IDX                                                                    2
#define mmDN_PCIE_BUS_CNTL                                                                             0x0046
#define mmDN_PCIE_BUS_CNTL_BASE_IDX                                                                    2
#define mmDN_PCIE_CFG_CNTL                                                                             0x0047
#define mmDN_PCIE_CFG_CNTL_BASE_IDX                                                                    2


// addressBlock: nbio_nbif_rcc_dwnp_dev0_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmPCIE_ERR_CNTL                                                                                0x004f
#define mmPCIE_ERR_CNTL_BASE_IDX                                                                       2
#define mmPCIE_RX_CNTL                                                                                 0x0050
#define mmPCIE_RX_CNTL_BASE_IDX                                                                        2
#define mmPCIE_LC_SPEED_CNTL                                                                           0x0051
#define mmPCIE_LC_SPEED_CNTL_BASE_IDX                                                                  2
#define mmPCIE_LC_CNTL2                                                                                0x0052
#define mmPCIE_LC_CNTL2_BASE_IDX                                                                       2
#define mmPCIEP_STRAP_MISC                                                                             0x0053
#define mmPCIEP_STRAP_MISC_BASE_IDX                                                                    2
#define mmLTR_MSG_INFO_FROM_EP                                                                         0x0054
#define mmLTR_MSG_INFO_FROM_EP_BASE_IDX                                                                2


// addressBlock: nbio_nbif_rcc_pf_0_BIFPFVFDEC1[13440..14975]
// base address: 0x3480
#define mmRCC_PF_0_0_RCC_ERR_LOG                                                                       0x0085
#define mmRCC_PF_0_0_RCC_ERR_LOG_BASE_IDX                                                              2
#define mmRCC_PF_0_0_RCC_DOORBELL_APER_EN                                                              0x00c0
#define mmRCC_PF_0_0_RCC_DOORBELL_APER_EN_BASE_IDX                                                     2
#define mmRCC_PF_0_0_RCC_CONFIG_MEMSIZE                                                                0x00c3
#define mmRCC_PF_0_0_RCC_CONFIG_MEMSIZE_BASE_IDX                                                       2
#define mmRCC_PF_0_0_RCC_CONFIG_RESERVED                                                               0x00c4
#define mmRCC_PF_0_0_RCC_CONFIG_RESERVED_BASE_IDX                                                      2
#define mmRCC_PF_0_0_RCC_IOV_FUNC_IDENTIFIER                                                           0x00c5
#define mmRCC_PF_0_0_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                                  2


// addressBlock: nbio_nbif_rcc_pf_0_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmRCC_ERR_INT_CNTL                                                                             0x0086
#define mmRCC_ERR_INT_CNTL_BASE_IDX                                                                    2
#define mmRCC_BACO_CNTL_MISC                                                                           0x0087
#define mmRCC_BACO_CNTL_MISC_BASE_IDX                                                                  2
#define mmRCC_RESET_EN                                                                                 0x0088
#define mmRCC_RESET_EN_BASE_IDX                                                                        2
#define mmRCC_VDM_SUPPORT                                                                              0x0089
#define mmRCC_VDM_SUPPORT_BASE_IDX                                                                     2
#define mmRCC_PEER_REG_RANGE0                                                                          0x00be
#define mmRCC_PEER_REG_RANGE0_BASE_IDX                                                                 2
#define mmRCC_PEER_REG_RANGE1                                                                          0x00bf
#define mmRCC_PEER_REG_RANGE1_BASE_IDX                                                                 2
#define mmRCC_BUS_CNTL                                                                                 0x00c1
#define mmRCC_BUS_CNTL_BASE_IDX                                                                        2
#define mmRCC_CONFIG_CNTL                                                                              0x00c2
#define mmRCC_CONFIG_CNTL_BASE_IDX                                                                     2
#define mmRCC_CONFIG_F0_BASE                                                                           0x00c6
#define mmRCC_CONFIG_F0_BASE_BASE_IDX                                                                  2
#define mmRCC_CONFIG_APER_SIZE                                                                         0x00c7
#define mmRCC_CONFIG_APER_SIZE_BASE_IDX                                                                2
#define mmRCC_CONFIG_REG_APER_SIZE                                                                     0x00c8
#define mmRCC_CONFIG_REG_APER_SIZE_BASE_IDX                                                            2
#define mmRCC_XDMA_LO                                                                                  0x00c9
#define mmRCC_XDMA_LO_BASE_IDX                                                                         2
#define mmRCC_XDMA_HI                                                                                  0x00ca
#define mmRCC_XDMA_HI_BASE_IDX                                                                         2
#define mmRCC_FEATURES_CONTROL_MISC                                                                    0x00cb
#define mmRCC_FEATURES_CONTROL_MISC_BASE_IDX                                                           2
#define mmRCC_BUSNUM_CNTL1                                                                             0x00cc
#define mmRCC_BUSNUM_CNTL1_BASE_IDX                                                                    2
#define mmRCC_BUSNUM_LIST0                                                                             0x00cd
#define mmRCC_BUSNUM_LIST0_BASE_IDX                                                                    2
#define mmRCC_BUSNUM_LIST1                                                                             0x00ce
#define mmRCC_BUSNUM_LIST1_BASE_IDX                                                                    2
#define mmRCC_BUSNUM_CNTL2                                                                             0x00cf
#define mmRCC_BUSNUM_CNTL2_BASE_IDX                                                                    2
#define mmRCC_CAPTURE_HOST_BUSNUM                                                                      0x00d0
#define mmRCC_CAPTURE_HOST_BUSNUM_BASE_IDX                                                             2
#define mmRCC_HOST_BUSNUM                                                                              0x00d1
#define mmRCC_HOST_BUSNUM_BASE_IDX                                                                     2
#define mmRCC_PEER0_FB_OFFSET_HI                                                                       0x00d2
#define mmRCC_PEER0_FB_OFFSET_HI_BASE_IDX                                                              2
#define mmRCC_PEER0_FB_OFFSET_LO                                                                       0x00d3
#define mmRCC_PEER0_FB_OFFSET_LO_BASE_IDX                                                              2
#define mmRCC_PEER1_FB_OFFSET_HI                                                                       0x00d4
#define mmRCC_PEER1_FB_OFFSET_HI_BASE_IDX                                                              2
#define mmRCC_PEER1_FB_OFFSET_LO                                                                       0x00d5
#define mmRCC_PEER1_FB_OFFSET_LO_BASE_IDX                                                              2
#define mmRCC_PEER2_FB_OFFSET_HI                                                                       0x00d6
#define mmRCC_PEER2_FB_OFFSET_HI_BASE_IDX                                                              2
#define mmRCC_PEER2_FB_OFFSET_LO                                                                       0x00d7
#define mmRCC_PEER2_FB_OFFSET_LO_BASE_IDX                                                              2
#define mmRCC_PEER3_FB_OFFSET_HI                                                                       0x00d8
#define mmRCC_PEER3_FB_OFFSET_HI_BASE_IDX                                                              2
#define mmRCC_PEER3_FB_OFFSET_LO                                                                       0x00d9
#define mmRCC_PEER3_FB_OFFSET_LO_BASE_IDX                                                              2
#define mmRCC_CMN_LINK_CNTL                                                                            0x00de
#define mmRCC_CMN_LINK_CNTL_BASE_IDX                                                                   2
#define mmRCC_EP_REQUESTERID_RESTORE                                                                   0x00df
#define mmRCC_EP_REQUESTERID_RESTORE_BASE_IDX                                                          2
#define mmRCC_LTR_LSWITCH_CNTL                                                                         0x00e0
#define mmRCC_LTR_LSWITCH_CNTL_BASE_IDX                                                                2
#define mmRCC_MH_ARB_CNTL                                                                              0x00e1
#define mmRCC_MH_ARB_CNTL_BASE_IDX                                                                     2


// addressBlock: nbio_nbif_bif_bx_pf_BIFDEC1[13440..14975]
// base address: 0x3480
#define mmBIF_MM_INDACCESS_CNTL                                                                        0x00e6
#define mmBIF_MM_INDACCESS_CNTL_BASE_IDX                                                               2
#define mmBUS_CNTL                                                                                     0x00e7
#define mmBUS_CNTL_BASE_IDX                                                                            2
#define mmBIF_SCRATCH0                                                                                 0x00e8
#define mmBIF_SCRATCH0_BASE_IDX                                                                        2
#define mmBIF_SCRATCH1                                                                                 0x00e9
#define mmBIF_SCRATCH1_BASE_IDX                                                                        2
#define mmBX_RESET_EN                                                                                  0x00ed
#define mmBX_RESET_EN_BASE_IDX                                                                         2
#define mmMM_CFGREGS_CNTL                                                                              0x00ee
#define mmMM_CFGREGS_CNTL_BASE_IDX                                                                     2
#define mmBX_RESET_CNTL                                                                                0x00f0
#define mmBX_RESET_CNTL_BASE_IDX                                                                       2
#define mmINTERRUPT_CNTL                                                                               0x00f1
#define mmINTERRUPT_CNTL_BASE_IDX                                                                      2
#define mmINTERRUPT_CNTL2                                                                              0x00f2
#define mmINTERRUPT_CNTL2_BASE_IDX                                                                     2
#define mmCLKREQB_PAD_CNTL                                                                             0x00f8
#define mmCLKREQB_PAD_CNTL_BASE_IDX                                                                    2
#define mmBIF_FEATURES_CONTROL_MISC                                                                    0x00fb
#define mmBIF_FEATURES_CONTROL_MISC_BASE_IDX                                                           2
#define mmBIF_DOORBELL_CNTL                                                                            0x00fc
#define mmBIF_DOORBELL_CNTL_BASE_IDX                                                                   2
#define mmBIF_DOORBELL_INT_CNTL                                                                        0x00fd
#define mmBIF_DOORBELL_INT_CNTL_BASE_IDX                                                               2
#define mmBIF_FB_EN                                                                                    0x00ff
#define mmBIF_FB_EN_BASE_IDX                                                                           2
#define mmBIF_BUSY_DELAY_CNTR                                                                          0x0100
#define mmBIF_BUSY_DELAY_CNTR_BASE_IDX                                                                 2
#define mmBIF_MST_TRANS_PENDING_VF                                                                     0x0109
#define mmBIF_MST_TRANS_PENDING_VF_BASE_IDX                                                            2
#define mmBIF_SLV_TRANS_PENDING_VF                                                                     0x010a
#define mmBIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                            2
#define mmBACO_CNTL                                                                                    0x010b
#define mmBACO_CNTL_BASE_IDX                                                                           2
#define mmBIF_BACO_EXIT_TIME0                                                                          0x010c
#define mmBIF_BACO_EXIT_TIME0_BASE_IDX                                                                 2
#define mmBIF_BACO_EXIT_TIMER1                                                                         0x010d
#define mmBIF_BACO_EXIT_TIMER1_BASE_IDX                                                                2
#define mmBIF_BACO_EXIT_TIMER2                                                                         0x010e
#define mmBIF_BACO_EXIT_TIMER2_BASE_IDX                                                                2
#define mmBIF_BACO_EXIT_TIMER3                                                                         0x010f
#define mmBIF_BACO_EXIT_TIMER3_BASE_IDX                                                                2
#define mmBIF_BACO_EXIT_TIMER4                                                                         0x0110
#define mmBIF_BACO_EXIT_TIMER4_BASE_IDX                                                                2
#define mmMEM_TYPE_CNTL                                                                                0x0111
#define mmMEM_TYPE_CNTL_BASE_IDX                                                                       2
#define mmSMU_BIF_VDDGFX_PWR_STATUS                                                                    0x0113
#define mmSMU_BIF_VDDGFX_PWR_STATUS_BASE_IDX                                                           2
#define mmBIF_VDDGFX_GFX0_LOWER                                                                        0x0114
#define mmBIF_VDDGFX_GFX0_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX0_UPPER                                                                        0x0115
#define mmBIF_VDDGFX_GFX0_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX1_LOWER                                                                        0x0116
#define mmBIF_VDDGFX_GFX1_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX1_UPPER                                                                        0x0117
#define mmBIF_VDDGFX_GFX1_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX2_LOWER                                                                        0x0118
#define mmBIF_VDDGFX_GFX2_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX2_UPPER                                                                        0x0119
#define mmBIF_VDDGFX_GFX2_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX3_LOWER                                                                        0x011a
#define mmBIF_VDDGFX_GFX3_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX3_UPPER                                                                        0x011b
#define mmBIF_VDDGFX_GFX3_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX4_LOWER                                                                        0x011c
#define mmBIF_VDDGFX_GFX4_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX4_UPPER                                                                        0x011d
#define mmBIF_VDDGFX_GFX4_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX5_LOWER                                                                        0x011e
#define mmBIF_VDDGFX_GFX5_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_GFX5_UPPER                                                                        0x011f
#define mmBIF_VDDGFX_GFX5_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV1_LOWER                                                                        0x0120
#define mmBIF_VDDGFX_RSV1_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV1_UPPER                                                                        0x0121
#define mmBIF_VDDGFX_RSV1_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV2_LOWER                                                                        0x0122
#define mmBIF_VDDGFX_RSV2_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV2_UPPER                                                                        0x0123
#define mmBIF_VDDGFX_RSV2_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV3_LOWER                                                                        0x0124
#define mmBIF_VDDGFX_RSV3_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV3_UPPER                                                                        0x0125
#define mmBIF_VDDGFX_RSV3_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV4_LOWER                                                                        0x0126
#define mmBIF_VDDGFX_RSV4_LOWER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_RSV4_UPPER                                                                        0x0127
#define mmBIF_VDDGFX_RSV4_UPPER_BASE_IDX                                                               2
#define mmBIF_VDDGFX_FB_CMP                                                                            0x0128
#define mmBIF_VDDGFX_FB_CMP_BASE_IDX                                                                   2
#define mmBIF_DOORBELL_GBLAPER1_LOWER                                                                  0x0129
#define mmBIF_DOORBELL_GBLAPER1_LOWER_BASE_IDX                                                         2
#define mmBIF_DOORBELL_GBLAPER1_UPPER                                                                  0x012a
#define mmBIF_DOORBELL_GBLAPER1_UPPER_BASE_IDX                                                         2
#define mmBIF_DOORBELL_GBLAPER2_LOWER                                                                  0x012b
#define mmBIF_DOORBELL_GBLAPER2_LOWER_BASE_IDX                                                         2
#define mmBIF_DOORBELL_GBLAPER2_UPPER                                                                  0x012c
#define mmBIF_DOORBELL_GBLAPER2_UPPER_BASE_IDX                                                         2
#define mmREMAP_HDP_MEM_FLUSH_CNTL                                                                     0x012d
#define mmREMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                            2
#define mmREMAP_HDP_REG_FLUSH_CNTL                                                                     0x012e
#define mmREMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                            2
#define mmBIF_RB_CNTL                                                                                  0x012f
#define mmBIF_RB_CNTL_BASE_IDX                                                                         2
#define mmBIF_RB_BASE                                                                                  0x0130
#define mmBIF_RB_BASE_BASE_IDX                                                                         2
#define mmBIF_RB_RPTR                                                                                  0x0131
#define mmBIF_RB_RPTR_BASE_IDX                                                                         2
#define mmBIF_RB_WPTR                                                                                  0x0132
#define mmBIF_RB_WPTR_BASE_IDX                                                                         2
#define mmBIF_RB_WPTR_ADDR_HI                                                                          0x0133
#define mmBIF_RB_WPTR_ADDR_HI_BASE_IDX                                                                 2
#define mmBIF_RB_WPTR_ADDR_LO                                                                          0x0134
#define mmBIF_RB_WPTR_ADDR_LO_BASE_IDX                                                                 2
#define mmMAILBOX_INDEX                                                                                0x0135
#define mmMAILBOX_INDEX_BASE_IDX                                                                       2
#define mmBIF_UVD_GPUIOV_CFG_SIZE                                                                      0x0143
#define mmBIF_UVD_GPUIOV_CFG_SIZE_BASE_IDX                                                             2
#define mmBIF_VCE_GPUIOV_CFG_SIZE                                                                      0x0144
#define mmBIF_VCE_GPUIOV_CFG_SIZE_BASE_IDX                                                             2
#define mmBIF_GFX_SDMA_GPUIOV_CFG_SIZE                                                                 0x0145
#define mmBIF_GFX_SDMA_GPUIOV_CFG_SIZE_BASE_IDX                                                        2
#define mmBIF_PERSTB_PAD_CNTL                                                                          0x0148
#define mmBIF_PERSTB_PAD_CNTL_BASE_IDX                                                                 2
#define mmBIF_PX_EN_PAD_CNTL                                                                           0x0149
#define mmBIF_PX_EN_PAD_CNTL_BASE_IDX                                                                  2
#define mmBIF_REFPADKIN_PAD_CNTL                                                                       0x014a
#define mmBIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                              2
#define mmBIF_CLKREQB_PAD_CNTL                                                                         0x014b
#define mmBIF_CLKREQB_PAD_CNTL_BASE_IDX                                                                2


// addressBlock: nbio_nbif_bif_bx_pf_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_PF0_BIF_BME_STATUS                                                                    0x00eb
#define mmBIF_BX_PF0_BIF_BME_STATUS_BASE_IDX                                                           2
#define mmBIF_BX_PF0_BIF_ATOMIC_ERR_LOG                                                                0x00ec
#define mmBIF_BX_PF0_BIF_ATOMIC_ERR_LOG_BASE_IDX                                                       2
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x00f3
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     2
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x00f4
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      2
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x00f5
#define mmBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          2
#define mmBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x00f6
#define mmBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define mmBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x00f7
#define mmBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define mmBIF_BX_PF0_GPU_HDP_FLUSH_REQ                                                                 0x0106
#define mmBIF_BX_PF0_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        2
#define mmBIF_BX_PF0_GPU_HDP_FLUSH_DONE                                                                0x0107
#define mmBIF_BX_PF0_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       2
#define mmBIF_BX_PF0_BIF_TRANS_PENDING                                                                 0x0108
#define mmBIF_BX_PF0_BIF_TRANS_PENDING_BASE_IDX                                                        2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0                                                            0x0136
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1                                                            0x0137
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2                                                            0x0138
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3                                                            0x0139
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0                                                            0x013a
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1                                                            0x013b
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2                                                            0x013c
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3                                                            0x013d
#define mmBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   2
#define mmBIF_BX_PF0_MAILBOX_CONTROL                                                                   0x013e
#define mmBIF_BX_PF0_MAILBOX_CONTROL_BASE_IDX                                                          2
#define mmBIF_BX_PF0_MAILBOX_INT_CNTL                                                                  0x013f
#define mmBIF_BX_PF0_MAILBOX_INT_CNTL_BASE_IDX                                                         2
#define mmBIF_BX_PF0_BIF_VMHV_MAILBOX                                                                  0x0140
#define mmBIF_BX_PF0_BIF_VMHV_MAILBOX_BASE_IDX                                                         2


// addressBlock: nbio_nbif_gdc_GDCDEC[14976..15487]
// base address: 0x3a80
#define mmNGDC_SDP_PORT_CTRL                                                                           0x01c2
#define mmNGDC_SDP_PORT_CTRL_BASE_IDX                                                                  2
#define mmSHUB_REGS_IF_CTL                                                                             0x01c3
#define mmSHUB_REGS_IF_CTL_BASE_IDX                                                                    2
#define mmNGDC_RESERVED_0                                                                              0x01cb
#define mmNGDC_RESERVED_0_BASE_IDX                                                                     2
#define mmNGDC_RESERVED_1                                                                              0x01cc
#define mmNGDC_RESERVED_1_BASE_IDX                                                                     2
#define mmNGDC_SDP_PORT_CTRL_SOCCLK                                                                    0x01cd
#define mmNGDC_SDP_PORT_CTRL_SOCCLK_BASE_IDX                                                           2
#define mmBIF_SDMA0_DOORBELL_RANGE                                                                     0x01d0
#define mmBIF_SDMA0_DOORBELL_RANGE_BASE_IDX                                                            2
#define mmBIF_SDMA1_DOORBELL_RANGE                                                                     0x01d1
#define mmBIF_SDMA1_DOORBELL_RANGE_BASE_IDX                                                            2
#define mmBIF_IH_DOORBELL_RANGE                                                                        0x01d2
#define mmBIF_IH_DOORBELL_RANGE_BASE_IDX                                                               2
#define mmBIF_MMSCH0_DOORBELL_RANGE                                                                    0x01d3
#define mmBIF_MMSCH0_DOORBELL_RANGE_BASE_IDX                                                           2
#define mmBIF_DOORBELL_FENCE_CNTL                                                                      0x01de
#define mmBIF_DOORBELL_FENCE_CNTL_BASE_IDX                                                             2
#define mmS2A_MISC_CNTL                                                                                0x01df
#define mmS2A_MISC_CNTL_BASE_IDX                                                                       2


// addressBlock: nbio_nbif_rcc_pf_0_BIFDEC2
// base address: 0x0
#define mmRCC_PF_0_GFXMSIX_VECT0_ADDR_LO                                                               0x0400
#define mmRCC_PF_0_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT0_ADDR_HI                                                               0x0401
#define mmRCC_PF_0_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT0_MSG_DATA                                                              0x0402
#define mmRCC_PF_0_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                                     3
#define mmRCC_PF_0_GFXMSIX_VECT0_CONTROL                                                               0x0403
#define mmRCC_PF_0_GFXMSIX_VECT0_CONTROL_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT1_ADDR_LO                                                               0x0404
#define mmRCC_PF_0_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT1_ADDR_HI                                                               0x0405
#define mmRCC_PF_0_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT1_MSG_DATA                                                              0x0406
#define mmRCC_PF_0_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                                     3
#define mmRCC_PF_0_GFXMSIX_VECT1_CONTROL                                                               0x0407
#define mmRCC_PF_0_GFXMSIX_VECT1_CONTROL_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT2_ADDR_LO                                                               0x0408
#define mmRCC_PF_0_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT2_ADDR_HI                                                               0x0409
#define mmRCC_PF_0_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_VECT2_MSG_DATA                                                              0x040a
#define mmRCC_PF_0_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                                     3
#define mmRCC_PF_0_GFXMSIX_VECT2_CONTROL                                                               0x040b
#define mmRCC_PF_0_GFXMSIX_VECT2_CONTROL_BASE_IDX                                                      3
#define mmRCC_PF_0_GFXMSIX_PBA                                                                         0x0800
#define mmRCC_PF_0_GFXMSIX_PBA_BASE_IDX                                                                3


// addressBlock: nbio_nbif_bif_bx_pf_SYSPFVFDEC[0..255]
// base address: 0x0
//#define mmBIF_BX_PF_MM_INDEX                                                                           0x0000
//#define mmBIF_BX_PF_MM_DATA                                                                            0x0001
//#define mmBIF_BX_PF_MM_INDEX_HI                                                                        0x0006


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf0_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF0_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF0_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF0_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF0_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF0_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF0_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_rcc_dev0_epf0_vf0_BIFPFVFDEC1
// base address: 0x0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf0_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF0_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF0_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF0_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF0_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf1_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF1_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF1_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF1_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF1_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF1_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF1_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf1_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF1_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF1_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF1_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF1_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf2_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF2_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF2_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF2_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF2_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF2_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF2_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf2_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF2_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF2_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF2_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF2_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf3_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF3_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF3_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF3_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF3_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF3_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF3_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf3_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF3_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF3_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF3_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF3_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf4_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF4_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF4_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF4_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF4_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF4_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF4_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf4_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF4_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF4_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF4_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF4_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf5_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF5_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF5_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF5_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF5_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF5_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF5_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf5_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF5_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF5_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF5_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF5_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf6_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF6_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF6_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF6_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF6_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF6_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF6_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf6_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF6_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF6_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF6_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF6_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf7_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF7_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF7_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF7_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF7_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF7_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF7_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf7_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF7_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF7_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF7_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF7_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf8_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF8_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF8_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF8_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF8_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF8_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF8_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf8_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF8_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF8_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF8_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF8_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF8_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF8_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF8_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF8_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF8_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF8_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF8_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf9_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF9_MM_INDEX                                                                0x0000
#define mmBIF_BX_DEV0_EPF0_VF9_MM_INDEX_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF9_MM_DATA                                                                 0x0001
#define mmBIF_BX_DEV0_EPF0_VF9_MM_DATA_BASE_IDX                                                        0
#define mmBIF_BX_DEV0_EPF0_VF9_MM_INDEX_HI                                                             0x0006
#define mmBIF_BX_DEV0_EPF0_VF9_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf9_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_BME_STATUS                                                          0x00eb
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_BME_STATUS_BASE_IDX                                                 2
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define mmBIF_BX_DEV0_EPF0_VF9_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define mmBIF_BX_DEV0_EPF0_VF9_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define mmBIF_BX_DEV0_EPF0_VF9_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF9_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define mmBIF_BX_DEV0_EPF0_VF9_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define mmBIF_BX_DEV0_EPF0_VF9_GPU_HDP_FLUSH_REQ                                                       0x0106
#define mmBIF_BX_DEV0_EPF0_VF9_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF9_GPU_HDP_FLUSH_DONE                                                      0x0107
#define mmBIF_BX_DEV0_EPF0_VF9_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_TRANS_PENDING                                                       0x0108
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_TRANS_PENDING_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_CONTROL                                                         0x013e
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_CONTROL_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_INT_CNTL                                                        0x013f
#define mmBIF_BX_DEV0_EPF0_VF9_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_VMHV_MAILBOX                                                        0x0140
#define mmBIF_BX_DEV0_EPF0_VF9_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf10_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF10_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF10_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF10_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF10_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF10_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF10_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf10_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF10_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF10_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF10_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF10_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF10_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF10_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF10_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF10_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF10_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF10_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF10_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf11_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF11_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF11_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF11_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF11_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF11_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF11_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf11_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF11_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF11_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF11_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF11_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF11_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF11_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF11_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF11_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF11_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF11_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF11_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf12_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF12_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF12_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF12_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF12_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF12_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF12_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf12_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF12_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF12_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF12_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF12_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF12_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF12_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF12_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF12_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF12_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF12_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF12_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf13_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF13_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF13_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF13_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF13_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF13_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF13_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf13_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF13_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF13_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF13_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF13_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF13_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF13_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF13_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF13_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF13_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF13_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF13_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf14_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF14_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF14_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF14_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF14_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF14_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF14_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf14_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF14_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF14_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF14_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF14_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF14_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF14_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF14_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF14_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF14_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF14_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF14_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf15_SYSPFVFDEC
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF15_MM_INDEX                                                               0x0000
#define mmBIF_BX_DEV0_EPF0_VF15_MM_INDEX_BASE_IDX                                                      0
#define mmBIF_BX_DEV0_EPF0_VF15_MM_DATA                                                                0x0001
#define mmBIF_BX_DEV0_EPF0_VF15_MM_DATA_BASE_IDX                                                       0
#define mmBIF_BX_DEV0_EPF0_VF15_MM_INDEX_HI                                                            0x0006
#define mmBIF_BX_DEV0_EPF0_VF15_MM_INDEX_HI_BASE_IDX                                                   0


// addressBlock: nbio_nbif_bif_bx_dev0_epf0_vf15_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_BME_STATUS                                                         0x00eb
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_BME_STATUS_BASE_IDX                                                2
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_ATOMIC_ERR_LOG                                                     0x00ec
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_ATOMIC_ERR_LOG_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                   0x00f3
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                          2
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                    0x00f4
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                           2
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_CNTL                                        0x00f5
#define mmBIF_BX_DEV0_EPF0_VF15_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                               2
#define mmBIF_BX_DEV0_EPF0_VF15_HDP_REG_COHERENCY_FLUSH_CNTL                                           0x00f6
#define mmBIF_BX_DEV0_EPF0_VF15_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF15_HDP_MEM_COHERENCY_FLUSH_CNTL                                           0x00f7
#define mmBIF_BX_DEV0_EPF0_VF15_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                  2
#define mmBIF_BX_DEV0_EPF0_VF15_GPU_HDP_FLUSH_REQ                                                      0x0106
#define mmBIF_BX_DEV0_EPF0_VF15_GPU_HDP_FLUSH_REQ_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF15_GPU_HDP_FLUSH_DONE                                                     0x0107
#define mmBIF_BX_DEV0_EPF0_VF15_GPU_HDP_FLUSH_DONE_BASE_IDX                                            2
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_TRANS_PENDING                                                      0x0108
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_TRANS_PENDING_BASE_IDX                                             2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW0                                                 0x0136
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW1                                                 0x0137
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW2                                                 0x0138
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW3                                                 0x0139
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW0                                                 0x013a
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW1                                                 0x013b
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW2                                                 0x013c
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW3                                                 0x013d
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                        2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_CONTROL                                                        0x013e
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_CONTROL_BASE_IDX                                               2
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_INT_CNTL                                                       0x013f
#define mmBIF_BX_DEV0_EPF0_VF15_MAILBOX_INT_CNTL_BASE_IDX                                              2
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_VMHV_MAILBOX                                                       0x0140
#define mmBIF_BX_DEV0_EPF0_VF15_BIF_VMHV_MAILBOX_BASE_IDX                                              2


// addressBlock: syshub_mmreg_ind_syshubind
// base address: 0x0
#define ixSYSHUB_MMREG_IND_SYSHUB_DS_CTRL_SOCCLK                                                       0x10000
#define ixSYSHUB_MMREG_IND_SYSHUB_DS_CTRL2_SOCCLK                                                      0x10004
#define ixSYSHUB_MMREG_IND_SYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SOCCLK                                    0x10008
#define ixSYSHUB_MMREG_IND_SYSHUB_BGEN_ENHANCEMENT_IMM_EN_SOCCLK                                       0x1000c
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_SYSHUB_QOS_CNTL                                                0x10010
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW1_SYSHUB_QOS_CNTL                                                0x10014
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL0_CNTL                                                       0x10018
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL1_CNTL                                                       0x1001c
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL2_CNTL                                                       0x10020
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL3_CNTL                                                       0x10024
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL4_CNTL                                                       0x10028
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW0_CL5_CNTL                                                       0x1002c
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW1_CL0_CNTL                                                       0x10030
#define ixSYSHUB_MMREG_IND_DMA_CLK0_SW2_CL0_CNTL                                                       0x10034
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW0_CL0_CNTL                                                       0x10100
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW0_CL1_CNTL                                                       0x10104
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW0_CL2_CNTL                                                       0x10108
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW1_CL0_CNTL                                                       0x1010c
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW1_CL1_CNTL                                                       0x10110
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW1_CL2_CNTL                                                       0x10114
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW1_CL3_CNTL                                                       0x10118
#define ixSYSHUB_MMREG_IND_HST_CLK0_SW1_CL4_CNTL                                                       0x1011c
#define ixSYSHUB_MMREG_IND_SYSHUB_CG_CNTL                                                              0x10300
#define ixSYSHUB_MMREG_IND_SYSHUB_TRANS_IDLE                                                           0x10308
#define ixSYSHUB_MMREG_IND_SYSHUB_HP_TIMER                                                             0x1030c
#define ixSYSHUB_MMREG_IND_SYSHUB_MGCG_CTRL_SOCCLK                                                     0x10310
#define ixSYSHUB_MMREG_IND_SYSHUB_SCRATCH                                                              0x10f00
#define ixSYSHUB_MMREG_IND_SYSHUB_CL_MASK                                                              0x10f04
#define ixSYSHUB_MMREG_IND_SYSHUB_DS_CTRL_SHUBCLK                                                      0x11000
#define ixSYSHUB_MMREG_IND_SYSHUB_DS_CTRL2_SHUBCLK                                                     0x11004
#define ixSYSHUB_MMREG_IND_SYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SHUBCLK                                   0x11008
#define ixSYSHUB_MMREG_IND_SYSHUB_BGEN_ENHANCEMENT_IMM_EN_SHUBCLK                                      0x1100c
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_SYSHUB_QOS_CNTL                                                0x11010
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_SYSHUB_QOS_CNTL                                                0x11014
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_CL0_CNTL                                                       0x11018
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_CL1_CNTL                                                       0x1101c
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_CL2_CNTL                                                       0x11020
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_CL3_CNTL                                                       0x11024
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW0_CL4_CNTL                                                       0x11028
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_CL0_CNTL                                                       0x1102c
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_CL1_CNTL                                                       0x11030
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_CL2_CNTL                                                       0x11034
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_CL3_CNTL                                                       0x11038
#define ixSYSHUB_MMREG_IND_DMA_CLK1_SW1_CL4_CNTL                                                       0x1103c
#define ixSYSHUB_MMREG_IND_SYSHUB_MGCG_CTRL_SHUBCLK                                                    0x11040
#define ixSYSHUB_MMREG_IND_NIC400_0_ASIB_0_FN_MOD                                                      0x20108
#define ixSYSHUB_MMREG_IND_NIC400_0_AMIB_0_FN_MOD_BM_ISS                                               0x30008
#define ixSYSHUB_MMREG_IND_NIC400_0_AMIB_1_FN_MOD_BM_ISS                                               0x31008
#define ixSYSHUB_MMREG_IND_NIC400_0_AMIB_2_FN_MOD_BM_ISS                                               0x32008
#define ixSYSHUB_MMREG_IND_NIC400_1_ASIB_0_FN_MOD                                                      0x40108
#define ixSYSHUB_MMREG_IND_NIC400_1_AMIB_0_FN_MOD                                                      0x50008
#define ixSYSHUB_MMREG_IND_NIC400_1_AMIB_1_FN_MOD                                                      0x51008
#define ixSYSHUB_MMREG_IND_NIC400_1_AMIB_2_FN_MOD                                                      0x52008
#define ixSYSHUB_MMREG_IND_NIC400_1_AMIB_3_FN_MOD                                                      0x53008
#define ixSYSHUB_MMREG_IND_NIC400_1_AMIB_4_FN_MOD                                                      0x54008
#define ixSYSHUB_MMREG_IND_NIC400_2_ASIB_0_FN_MOD                                                      0x60108
#define ixSYSHUB_MMREG_IND_NIC400_2_ASIB_1_FN_MOD                                                      0x61108
#define ixSYSHUB_MMREG_IND_NIC400_2_ASIB_2_FN_MOD                                                      0x62108
#define ixSYSHUB_MMREG_IND_NIC400_2_AMIB_0_FN_MOD_BM_ISS                                               0x70008

#endif
