/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
#ifndef OB_DEFINED_COLLATIONS_H_
#define OB_DEFINED_COLLATIONS_H_

#include "lib/charset/ob_charset.h"
namespace oceanbase
{
namespace common
{
namespace datum_cmp
{
template<ObCollationType coll>
struct SupportedCollection
{
  static const bool defined_ = false;
};

#define DEF_SUPPORT_COLL(cs)                                                                     \
  template <>                                                                                    \
  struct SupportedCollection<cs>                                                                 \
  {                                                                                              \
    static const bool defined_ = true;                                                           \
  };

DEF_SUPPORT_COLL(CS_TYPE_GBK_CHINESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_BIN)
DEF_SUPPORT_COLL(CS_TYPE_BINARY)
DEF_SUPPORT_COLL(CS_TYPE_GBK_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_UNICODE_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_UNICODE_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_CHINESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UJIS_JAPANESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_UJIS_BIN)
DEF_SUPPORT_COLL(CS_TYPE_EUCKR_KOREAN_CI)
DEF_SUPPORT_COLL(CS_TYPE_EUCKR_BIN)
DEF_SUPPORT_COLL(CS_TYPE_CP932_JAPANESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_CP932_BIN)
DEF_SUPPORT_COLL(CS_TYPE_EUCJPMS_JAPANESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_EUCJPMS_BIN)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_GERMAN1_CI)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_SWEDISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_DANISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_GERMAN2_CI)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_BIN)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_GENERAL_CS)
DEF_SUPPORT_COLL(CS_TYPE_LATIN1_SPANISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB2312_CHINESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB2312_BIN)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_BIN)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_PINYIN_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_PINYIN_CS)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_RADICAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_RADICAL_CS)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_STROKE_CI)
DEF_SUPPORT_COLL(CS_TYPE_GB18030_2022_STROKE_CS)
DEF_SUPPORT_COLL(CS_TYPE_ASCII_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_ASCII_BIN)
DEF_SUPPORT_COLL(CS_TYPE_TIS620_THAI_CI)
DEF_SUPPORT_COLL(CS_TYPE_TIS620_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UTF16LE_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16LE_BIN)
DEF_SUPPORT_COLL(CS_TYPE_SJIS_JAPANESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_SJIS_BIN)
DEF_SUPPORT_COLL(CS_TYPE_BIG5_CHINESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_BIG5_BIN)
DEF_SUPPORT_COLL(CS_TYPE_HKSCS_BIN)
DEF_SUPPORT_COLL(CS_TYPE_HKSCS31_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ICELANDIC_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LATVIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ROMANIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SLOVENIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_POLISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ESTONIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SPANISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SWEDISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_TURKISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_CZECH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_DANISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LITHUANIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SLOVAK_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SPANISH2_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ROMAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_PERSIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ESPERANTO_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_HUNGARIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SINHALA_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_GERMAN2_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_CROATIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_UNICODE_520_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_VIETNAMESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_ICELANDIC_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_LATVIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_ROMANIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SLOVENIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_POLISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_ESTONIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SPANISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SWEDISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_TURKISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_CZECH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_DANISH_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_LITHUANIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SLOVAK_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SPANISH2_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_ROMAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_PERSIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_ESPERANTO_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_HUNGARIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_SINHALA_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_GERMAN2_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_CROATIAN_UCA_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_UNICODE_520_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF16_VIETNAMESE_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_DE_PB_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_IS_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LV_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_RO_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SL_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_PL_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ET_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ES_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SV_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_TR_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_CS_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_DA_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LT_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SK_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ES_TRAD_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LA_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_EO_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_HU_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_HR_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_VI_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_DE_PB_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_IS_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LV_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_RO_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SL_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_PL_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ET_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ES_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SV_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_TR_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_CS_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_DA_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LT_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SK_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ES_TRAD_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_LA_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_EO_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_HU_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_HR_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_VI_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_JA_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_JA_0900_AS_CS_KS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_0900_AS_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_RU_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_RU_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_ZH_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_0900_BIN)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_NB_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_NB_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_NN_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_NN_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SR_LATN_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_SR_LATN_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_BS_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_BS_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_BG_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_BG_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_GL_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_GL_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_MN_CYRL_0900_AI_CI)
DEF_SUPPORT_COLL(CS_TYPE_UTF8MB4_MN_CYRL_0900_AS_CS)
DEF_SUPPORT_COLL(CS_TYPE_DEC8_SWEDISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_DEC8_BIN)
DEF_SUPPORT_COLL(CS_TYPE_CP850_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_CP850_BIN)
DEF_SUPPORT_COLL(CS_TYPE_HP8_ENGLISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_HP8_BIN)
DEF_SUPPORT_COLL(CS_TYPE_MACROMAN_GENERAL_CI)
DEF_SUPPORT_COLL(CS_TYPE_MACROMAN_BIN)
DEF_SUPPORT_COLL(CS_TYPE_SWE7_SWEDISH_CI)
DEF_SUPPORT_COLL(CS_TYPE_SWE7_BIN)
} // end datum_cmp
} // end common
} // end oceanbase

#endif//OB_DEFINED_COLLATIONS_H_