/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#include "storage/multi_data_source/ob_mds_table_merge_dag_param.h"

namespace oceanbase
{
namespace storage
{
namespace mds
{
ObMdsTableMergeDagParam::ObMdsTableMergeDagParam()
  : ObTabletMergeDagParam(),
    flush_scn_(share::SCN::invalid_scn()),
    generate_ts_(0),
    mds_construct_sequence_(-1)
{
  // Mds dump should not access mds data to avoid potential dead lock
  // between mds table lock on ObTabletPointer and other mds component
  // inner locks.
  skip_get_tablet_ = true;
}
} // namespace mds
} // namespace storage
} // namespace oceanbase