/**
 * Copyright (c) 2024 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef _OCEANBASE_STORAGE_FTS_DICT_OB_IK_DIC_CPP_
#define _OCEANBASE_STORAGE_FTS_DICT_OB_IK_DIC_CPP_

#include "ob_ik_dic.h"

#include "lib/ob_errno.h"
#include "lib/utility/ob_macro_utils.h"

namespace oceanbase
{
namespace storage
{
ObIKDictLoader::RawDict ObIKDictLoader::dict_text()
{
  static const char *main_dic[] = {
      u8"一一列举",
      u8"一一对应",
      u8"一一道来",
      u8"一丁",
      u8"一丁不识",
      u8"一丁点",
      u8"一丁点儿",
      u8"一七八不",
      u8"一丈",
      u8"一上",
      u8"一上去",
      u8"一上台",
      u8"一上场",
      u8"一上来",
      u8"一下",
      u8"一下下",
      u8"一下儿",
      u8"一下去",
      u8"一下台",
      u8"一下场",
      u8"一下子",
      u8"一下来",
      u8"一不做二不休",
      u8"一不压众",
      u8"一不压众百不随一",
      u8"一不小心",
      u8"一不扭众",
      u8"一不注意",
      u8"一不留神",
      u8"一专多能",
      u8"一世",
      u8"一世之雄",
      u8"一世纪",
      u8"一世英名",
      u8"一世龙门",
      u8"一丘一壑",
      u8"一丘之貉",
      u8"一丙",
      u8"一业",
      u8"一丝",
      u8"一丝一毫",
      u8"一丝不挂",
      u8"一丝不紊",
      u8"一丝不苟",
      u8"一丝丝",
      u8"一丝两气",
      u8"一丝半粟",
      u8"一两",
      u8"一两句话",
      u8"一个",
      u8"一个一个",
      u8"一个个",
      u8"一个中国",
      u8"一个中心",
      u8"一个中心两个基本点",
      u8"一个人",
      u8"一个劲",
      u8"一个劲儿",
      u8"一个又一个",
      u8"一个国家两种制度",
      u8"一个地点",
      u8"一个多月",
      u8"一个好汉三个帮",
      u8"一个字",
      u8"一个巴掌拍不响",
      u8"一个心眼",
      u8"一个心眼儿",
      u8"一个情节",
      u8"一个愿打",
      u8"一个愿挨",
      u8"一个时间",
      u8"一个是",
      u8"一个月",
      u8"一个样",
      u8"一个男孩",
      u8"一个箭步",
      u8"一个舒服",
      u8"一个萝卜一个坑",
      u8"一个词",
      u8"一个都不能少",
      u8"一个重要方面",
      u8"一个鼻孔",
      u8"一个鼻孔出气",
      u8"一中",
      u8"一中一台",
      u8"一中全会",
      u8"一串",
      u8"一串串",
      u8"一串骊珠",
      u8"一丸",
      u8"一举",
      u8"一举一动",
      u8"一举万里",
      u8"一举三反",
      u8"一举两全",
      u8"一举两得",
      u8"一举中标",
      u8"一举之劳",
      u8"一举千里",
      u8"一举多得",
      u8"一举成名",
      u8"一举成名天下知",
      u8"一举手一",
      u8"一举手之劳",
      u8"一久",
      u8"一义",
      u8"一之为甚",
      u8"一之已甚",
      u8"一之谓甚",
      u8"一乐",
      u8"一书",
      u8"一买",
      u8"一买一卖",
      u8"一乱涂地",
      u8"一乾二净",
      u8"一了百了",
      u8"一了百当",
      u8"一事",
      u8"一事不明",
      u8"一事不知",
      u8"一事无成",
      u8"一五一十",
      u8"一些",
      u8"一些些",
      u8"一些人",
      u8"一些半些",
      u8"一些单位",
      u8"一些问题",
      u8"一交",
      u8"一产",
      u8"一亩",
      u8"一亮",
      u8"一亲芳泽",
      u8"一人",
      u8"一人之下",
      u8"一人之下万人之上",
      u8"一人之交",
      u8"一人份",
      u8"一人传虚",
      u8"一人传虚万人传实",
      u8"一人做事一人当",
      u8"一人吃饱全家不饿",
      u8"一人向隅满坐不乐",
      u8"一人善射",
      u8"一人善射百夫决拾",
      u8"一人得道",
      u8"一人得道鸡犬升天",
      u8"一人班",
      u8"一人飞升仙及鸡犬",
      u8"一亿",
      u8"一亿人",
      u8"一亿元",
      u8"一仁",
      u8"一介",
      u8"一介不取",
      u8"一介不苟",
      u8"一介之善",
      u8"一介之士",
      u8"一介之才",
      u8"一介书生",
      u8"一介武夫",
      u8"一仍其旧",
      u8"一仍旧贯",
      u8"一仗",
      u8"一付",
      u8"一代",
      u8"一代不如一代",
      u8"一代人",
      u8"一代代",
      u8"一代宗师",
      u8"一代宗臣",
      u8"一代文宗",
      u8"一代新人",
      u8"一代新人换旧人",
      u8"一代楷模",
      u8"一代英豪",
      u8"一代谈宗",
      u8"一代豪杰",
      u8"一代风流",
      u8"一代鼎臣",
      u8"一以当十",
      u8"一以当百",
      u8"一以贯之",
      u8"一件",
      u8"一件事",
      u8"一任",
      u8"一份",
      u8"一伍",
      u8"一休哥",
      u8"一伙",
      u8"一伙人",
      u8"一伙儿",
      u8"一会",
      u8"一会儿",
      u8"一会儿功夫",
      u8"一传",
      u8"一传十",
      u8"一传十十传百",
      u8"一伸",
      u8"一似",
      u8"一位",
      u8"一位数",
      u8"一住",
      u8"一体",
      u8"一体制",
      u8"一体化",
      u8"一体同心",
      u8"一体式",
      u8"一体机",
      u8"一佛出世",
      u8"一佛出世二佛升天",
      u8"一佛出世二佛涅槃",
      u8"一佛出世二佛涅盘",
      u8"一佛出世二佛生天",
      u8"一例",
      u8"一侧",
      u8"一俊遮百丑",
      u8"一俟",
      u8"一信",
      u8"一倍",
      u8"一倒",
      u8"一倘",
      u8"一倡一和",
      u8"一倡三叹",
      u8"一倡百和",
      u8"一偏",
      u8"一偏之见",
      u8"一偏之论",
      u8"一做",
      u8"一做到",
      u8"一停",
      u8"一傅众咻",
      u8"一元",
      u8"一元一次方程",
      u8"一元函数",
      u8"一元化",
      u8"一元复始",
      u8"一元大武",
      u8"一元方程",
      u8"一元论",
      u8"一元说",
      u8"一元酸",
      u8"一兆",
      u8"一兆元",
      u8"一克",
      u8"一党",
      u8"一党制",
      u8"一党独大",
      u8"一兜",
      u8"一公里",
      u8"一共",
      u8"一共是",
      u8"一关",
      u8"一兵",
      u8"一兵一卒",
      u8"一具",
      u8"一养",
      u8"一内一外",
      u8"一册",
      u8"一再",
      u8"一再嘱咐",
      u8"一再声明",
      u8"一再强调",
      u8"一再表示",
      u8"一再说明",
      u8"一写",
      u8"一写出",
      u8"一写到",
      u8"一军",
      u8"一冲",
      u8"一决胜负",
      u8"一决雌雄",
      u8"一冷",
      u8"一冻",
      u8"一准",
      u8"一凉",
      u8"一出",
      u8"一出去",
      u8"一出场",
      u8"一出戏",
      u8"一出来",
      u8"一击",
      u8"一击必杀",
      u8"一刀",
      u8"一刀两断",
      u8"一刀切",
      u8"一刀斩",
      u8"一分",
      u8"一分一毫",
      u8"一分一秒",
      u8"一分为二",
      u8"一分子",
      u8"一分收获",
      u8"一分耕耘",
      u8"一分耕耘一分收获",
      u8"一分货",
      u8"一分钟",
      u8"一分钱",
      u8"一分钱一",
      u8"一分钱一分货",
      u8"一切",
      u8"一切万物",
      u8"一切从严",
      u8"一切众生",
      u8"一切办法",
      u8"一切就简",
      u8"一切工作",
      u8"一切权利",
      u8"一切正常",
      u8"一切照旧",
      u8"一切都",
      u8"一切都在",
      u8"一切都是",
      u8"一切问题",
      u8"一切顺利",
      u8"一划",
      u8"一列",
      u8"一则",
      u8"一则以喜",
      u8"一则以喜一则以惧",
      u8"一则以忧",
      u8"一则以惧",
      u8"一删而空",
      u8"一别",
      u8"一别多年",
      u8"一到",
      u8"一刷",
      u8"一券",
      u8"一刹",
      u8"一刹那",
      u8"一刻",
      u8"一刻千金",
      u8"一刻钟",
      u8"一剂",
      u8"一削",
      u8"一前",
      u8"一前一后",
      u8"一剑",
      u8"一剑之任",
      u8"一剥",
      u8"一剪梅",
      u8"一副",
      u8"一割",
      u8"一力",
      u8"一力承当",
      u8"一办",
      u8"一加仑",
      u8"一动",
      u8"一动不动",
      u8"一动不如一静",
      u8"一劫",
      u8"一劳久逸",
      u8"一劳永逸",
      u8"一勇之夫",
      u8"一勺",
      u8"一包",
      u8"一包在内",
      u8"一匙",
      u8"一匙之量",
      u8"一匡九合",
      u8"一匡天下",
      u8"一区",
      u8"一十八层地狱",
      u8"一十八般兵器",
      u8"一十八般武艺",
      u8"一千零一夜",
      u8"一半",
      u8"一半儿",
      u8"一半天",
      u8"一卒",
      u8"一卖",
      u8"一卡",
      u8"一卡通",
      u8"一卧不起",
      u8"一卫",
      u8"一卷",
      u8"一厅",
      u8"一压",
      u8"一压下",
      u8"一压到",
      u8"一压在",
      u8"一厘",
      u8"一厢",
      u8"一厢情愿",
      u8"一去",
      u8"一去一来",
      u8"一去不回",
      u8"一去不复",
      u8"一去不复返",
      u8"一去不返",
      u8"一又",
      u8"一叉",
      u8"一友",
      u8"一双",
      u8"一双两好",
      u8"一双双",
      u8"一反其道",
      u8"一反常态",
      u8"一反既往",
      u8"一发",
      u8"一发不可",
      u8"一发不可收拾",
      u8"一发千钧",
      u8"一发破的",
      u8"一发而不可收拾",
      u8"一变",
      u8"一叠",
      u8"一叠叠",
      u8"一口",
      u8"一口一声",
      u8"一口三舌",
      u8"一口两匙",
      u8"一口价",
      u8"一口同声",
      u8"一口同音",
      u8"一口吸尽西江水",
      u8"一口咬定",
      u8"一口气",
      u8"一口泉",
      u8"一口钟",
      u8"一古脑儿",
      u8"一句",
      u8"一句句",
      u8"一句话",
      u8"一只",
      u8"一只手",
      u8"一叫",
      u8"一台",
      u8"一右",
      u8"一叶",
      u8"一叶扁舟",
      u8"一叶报秋",
      u8"一叶知秋",
      u8"一叶荻",
      u8"一叶落知天下秋",
      u8"一叶落而知天下秋",
      u8"一叶蔽目",
      u8"一叶迷山",
      u8"一叶障目",
      u8"一叶障目不见泰山",
      u8"一号",
      u8"一号机",
      u8"一号通",
      u8"一吃",
      u8"一合",
      u8"一吊",
      u8"一同",
      u8"一名",
      u8"一后",
      u8"一吐",
      u8"一吐为快",
      u8"一向",
      u8"一向如此",
      u8"一向是",
      u8"一吓",
      u8"一吞",
      u8"一吟一咏",
      u8"一吟双泪流",
      u8"一吠百声",
      u8"一吨",
      u8"一吨半",
      u8"一听",
      u8"一听之下",
      u8"一吸",
      u8"一吹",
      u8"一吼",
      u8"一告",
      u8"一员",
      u8"一员大将",
      u8"一周",
      u8"一周年",
      u8"一味",
      u8"一呵而就",
      u8"一呼再喏",
      u8"一呼百应",
      u8"一呼百诺",
      u8"一命",
      u8"一命之荣",
      u8"一命呜呼",
      u8"一命归天",
      u8"一命归西",
      u8"一命归阴",
      u8"一命鸣呼",
      u8"一和",
      u8"一咬",
      u8"一品",
      u8"一品堂",
      u8"一品夫人",
      u8"一品白衫",
      u8"一品红",
      u8"一品锅",
      u8"一哄而上",
      u8"一哄而散",
      u8"一哄而起",
      u8"一哭",
      u8"一哭二闹三上吊",
      u8"一唱一和",
      u8"一唱三叹",
      u8"一唱百和",
      u8"一啃",
      u8"一喊",
      u8"一喊出",
      u8"一喊到",
      u8"一喝",
      u8"一喝到",
      u8"一喷一醒",
      u8"一噎止餐",
      u8"一嚬一笑",
      u8"一回",
      u8"一回事",
      u8"一回到",
      u8"一回去",
      u8"一回回",
      u8"一回来",
      u8"一回生",
      u8"一回生二回熟",
      u8"一团",
      u8"一团乱",
      u8"一团乱麻",
      u8"一团和气",
      u8"一团漆黑",
      u8"一团糟",
      u8"一国",
      u8"一国三公",
      u8"一国两制",
      u8"一国之主",
      u8"一国之君",
      u8"一圆",
      u8"一圈",
      u8"一在",
      u8"一地",
      u8"一场",
      u8"一场春梦",
      u8"一场空",
      u8"一场虚惊",
      u8"一坐",
      u8"一坐一起",
      u8"一坐尽倾",
      u8"一坐尽惊",
      u8"一坐皆惊",
      u8"一块",
      u8"一块儿",
      u8"一块块",
      u8"一块石头落了地",
      u8"一块石头落地",
      u8"一块钱",
      u8"一垒",
      u8"一垒手",
      u8"一堂",
      u8"一堂课",
      u8"一堆",
      u8"一堆堆",
      u8"一堵",
      u8"一塌刮子",
      u8"一塌糊涂",
      u8"一塌胡涂",
      u8"一填",
      u8"一墙之隔",
      u8"一墩",
      u8"一壁",
      u8"一声",
      u8"一声不吭",
      u8"一声不响",
      u8"一声令下",
      u8"一声声",
      u8"一声春雷",
      u8"一壶",
      u8"一壶千金",
      u8"一壶水",
      u8"一壶酒",
      u8"一壸千金",
      u8"一处",
      u8"一夔一契",
      u8"一夔已足",
      u8"一夕",
      u8"一夕一朝",
      u8"一夕之间",
      u8"一多",
      u8"一多半",
      u8"一夜",
      u8"一夜之间",
      u8"一夜性",
      u8"一夜情",
      u8"一夜间",
      u8"一夜风流",
      u8"一夥",
      u8"一夥人",
      u8"一夥儿",
      u8"一大",
      u8"一大二公",
      u8"一大半",
      u8"一大口",
      u8"一大块",
      u8"一大堆",
      u8"一大帮",
      u8"一大截",
      u8"一大批",
      u8"一大把",
      u8"一大排",
      u8"一大早",
      u8"一大步",
      u8"一大片",
      u8"一大笔",
      u8"一大笔钱",
      u8"一大群",
      u8"一大跳",
      u8"一天",
      u8"一天一地",
      u8"一天两天",
      u8"一天到晚",
      u8"一天天",
      u8"一天星斗",
      u8"一夫",
      u8"一夫一妻",
      u8"一夫一妻制",
      u8"一夫之勇",
      u8"一夫多妻",
      u8"一夫当关",
      u8"一夫当关万夫莫开",
      u8"一失一得",
      u8"一失足成",
      u8"一失足成千古恨",
      u8"一头",
      u8"一头儿沉",
      u8"一头沉",
      u8"一头热",
      u8"一头雾水",
      u8"一奇",
      u8"一奖",
      u8"一套",
      u8"一套套",
      u8"一女",
      u8"一女一男",
      u8"一奶同胞",
      u8"一好",
      u8"一好百好",
      u8"一如",
      u8"一如往昔",
      u8"一如既往",
      u8"一妇",
      u8"一妻",
      u8"一妻制",
      u8"一妻多夫",
      u8"一子",
      u8"一子一女",
      u8"一子出家七祖升天",
      u8"一子出家七祖昇天",
      u8"一子出家九祖升天",
      u8"一子悟道九族生天",
      u8"一孔",
      u8"一孔不达",
      u8"一孔之见",
      u8"一字",
      u8"一字一句",
      u8"一字一板",
      u8"一字一泪",
      u8"一字一珠",
      u8"一字不差",
      u8"一字不易",
      u8"一字不漏",
      u8"一字不苟",
      u8"一字之差",
      u8"一字之师",
      u8"一字之贬",
      u8"一字值千金",
      u8"一字兼金",
      u8"一字千斤",
      u8"一字千秋",
      u8"一字千金",
      u8"一字千钧",
      u8"一字师",
      u8"一字褒贬",
      u8"一字连城",
      u8"一字长城",
      u8"一字长蛇阵",
      u8"一存",
      u8"一孝",
      u8"一季",
      u8"一季度",
      u8"一孤之腋",
      u8"一守",
      u8"一完善",
      u8"一宗",
      u8"一官半职",
      u8"一定",
      u8"一定不易",
      u8"一定不移",
      u8"一定之规",
      u8"一定量",
      u8"一宝",
      u8"一审",
      u8"一审判决",
      u8"一客",
      u8"一客不烦二主",
      u8"一室",
      u8"一室生春",
      u8"一家",
      u8"一家一户",
      u8"一家一火",
      u8"一家一计",
      u8"一家之主",
      u8"一家之作",
      u8"一家之学",
      u8"一家之言",
      u8"一家之计",
      u8"一家之辞",
      u8"一家亲",
      u8"一家人",
      u8"一家子",
      u8"一家家",
      u8"一家无二",
      u8"一家独大",
      u8"一家眷属",
      u8"一家老小",
      u8"一寒如此",
      u8"一寨",
      u8"一寸",
      u8"一寸丹心",
      u8"一寸光阴一寸金",
      u8"一寸短一寸险",
      u8"一寸赤心",
      u8"一寸长一寸强",
      u8"一对",
      u8"一对一",
      u8"一对对",
      u8"一封",
      u8"一封信",
      u8"一封封",
      u8"一将",
      u8"一将功成万骨枯",
      u8"一尊",
      u8"一小",
      u8"一小包",
      u8"一小块",
      u8"一小堆",
      u8"一小撮",
      u8"一小时",
      u8"一小片",
      u8"一小部分",
      u8"一少",
      u8"一尘不到",
      u8"一尘不染",
      u8"一尘不缁",
      u8"一尘莫沾",
      u8"一尝",
      u8"一就",
      u8"一尸两命",
      u8"一尺",
      u8"一尺水十丈波",
      u8"一尺水翻腾做一丈波",
      u8"一尺水翻腾做百丈波",
      u8"一尾",
      u8"一局",
      u8"一局上半",
      u8"一局下半",
      u8"一屁股",
      u8"一屁股债",
      u8"一层",
      u8"一层层",
      u8"一层楼",
      u8"一届",
      u8"一屏",
      u8"一展",
      u8"一展无垠",
      u8"一展长才",
      u8"一展风采",
      u8"一山",
      u8"一山不容二虎",
      u8"一山不藏二虎",
      u8"一山之隔",
      u8"一山还比一山高",
      u8"一岁",
      u8"一岁一枯",
      u8"一岁三迁",
      u8"一岁九迁",
      u8"一岁再赦",
      u8"一岁载赦",
      u8"一岗双责",
      u8"一左",
      u8"一左一右",
      u8"一差两讹",
      u8"一差二悮",
      u8"一差二误",
      u8"一差二错",
      u8"一差半错",
      u8"一己",
      u8"一己之私",
      u8"一己之见",
      u8"一巴掌",
      u8"一巷",
      u8"一市",
      u8"一帆顺风",
      u8"一帆风顺",
      u8"一师",
      u8"一帖",
      u8"一带",
      u8"一帧",
      u8"一席",
      u8"一席之地",
      u8"一席话",
      u8"一席谈",
      u8"一帮",
      u8"一帮人",
      u8"一幅",
      u8"一幕",
      u8"一幕幕",
      u8"一幢",
      u8"一干",
      u8"一干二净",
      u8"一干人犯",
      u8"一年",
      u8"一年一度",
      u8"一年之计",
      u8"一年之计在于春",
      u8"一年到头",
      u8"一年前",
      u8"一年半载",
      u8"一年四季",
      u8"一年多",
      u8"一年多来",
      u8"一年期",
      u8"一年来",
      u8"一年比一年",
      u8"一年生",
      u8"一年生植",
      u8"一年级",
      u8"一年被蛇咬",
      u8"一年被蛇咬十年怕井绳",
      u8"一年计划",
      u8"一年里",
      u8"一并",
      u8"一并处理",
      u8"一床",
      u8"一床锦被遮盖",
      u8"一序列",
      u8"一应",
      u8"一应俱全",
      u8"一店",
      u8"一府两院",
      u8"一度",
      u8"一座",
      u8"一座皆惊",
      u8"一庹",
      u8"一廉如水",
      u8"一开",
      u8"一开出",
      u8"一开出来",
      u8"一开到",
      u8"一开始",
      u8"一式",
      u8"一式一样",
      u8"一式两份",
      u8"一弘清泉",
      u8"一弛一张",
      u8"一张",
      u8"一张一弛",
      u8"一张一驰",
      u8"一张张",
      u8"一张白纸",
      u8"一弯",
      u8"一弹",
      u8"一弹指",
      u8"一弹指顷",
      u8"一当",
      u8"一彻万融",
      u8"一往",
      u8"一往情深",
      u8"一往无前",
      u8"一往直前",
      u8"一往而深",
      u8"一征",
      u8"一径",
      u8"一律",
      u8"一律平等",
      u8"一得",
      u8"一得之功",
      u8"一得之愚",
      u8"一得之见",
      u8"一得到",
      u8"一德一心",
      u8"一心",
      u8"一心一力",
      u8"一心一德",
      u8"一心一意",
      u8"一心一腹",
      u8"一心一计",
      u8"一心一路",
      u8"一心不乱",
      u8"一心两用",
      u8"一心为公",
      u8"一心同体",
      u8"一心同功",
      u8"一心同归",
      u8"一心向上",
      u8"一心多用",
      u8"一心无二",
      u8"一忍再忍",
      u8"一忙",
      u8"一忠",
      u8"一念",
      u8"一念之差",
      u8"一念之误",
      u8"一念之间",
      u8"一忽",
      u8"一忽儿",
      u8"一忽见",
      u8"一怒",
      u8"一怒之下",
      u8"一怒而去",
      u8"一怔",
      u8"一总",
      u8"一息",
      u8"一息奄奄",
      u8"一息尚存",
      u8"一悲一喜",
      u8"一惊",
      u8"一想",
      u8"一想之下",
      u8"一意",
      u8"一意孤行",
      u8"一愣",
      u8"一成",
      u8"一成一旅",
      u8"一成不变",
      u8"一成不易",
      u8"一战",
      u8"一战之下",
      u8"一截",
      u8"一户",
      u8"一户户",
      u8"一房",
      u8"一房一厅",
      u8"一所",
      u8"一所所",
      u8"一扇",
      u8"一扇门",
      u8"一手",
      u8"一手一脚",
      u8"一手一足",
      u8"一手交货",
      u8"一手交钱",
      u8"一手包办",
      u8"一手托天",
      u8"一手独拍",
      u8"一手独拍虽疾无声",
      u8"一手软，一手硬",
      u8"一手遮天",
      u8"一扎",
      u8"一打",
      u8"一扔",
      u8"一扣",
      u8"一扫",
      u8"一扫光",
      u8"一扫而光",
      u8"一扫而空",
      u8"一扭",
      u8"一扯",
      u8"一批",
      u8"一找",
      u8"一技",
      u8"一技之长",
      u8"一把",
      u8"一把子",
      u8"一把手",
      u8"一把抓",
      u8"一把死拿",
      u8"一把汗",
      u8"一把钥匙开一把锁",
      u8"一抓",
      u8"一抓到底",
      u8"一抔黄土",
      u8"一投手",
      u8"一抖",
      u8"一折",
      u8"一抛",
      u8"一抢而空",
      u8"一报",
      u8"一报到",
      u8"一报还一报",
      u8"一披",
      u8"一抬",
      u8"一抬到",
      u8"一抬头",
      u8"一抱",
      u8"一抷黄土",
      u8"一抹",
      u8"一抹黑",
      u8"一抽",
      u8"一拆",
      u8"一拉",
      u8"一拉之下",
      u8"一拍",
      u8"一拍即合",
      u8"一拍即和",
      u8"一拐",
      u8"一拖",
      u8"一拖二",
      u8"一拖再拖",
      u8"一招",
      u8"一招一式",
      u8"一招半式",
      u8"一招毙命",
      u8"一拜",
      u8"一拜天地",
      u8"一拥而上",
      u8"一拥而入",
      u8"一拨",
      u8"一拨儿",
      u8"一拳",
      u8"一拼",
      u8"一拽",
      u8"一挂",
      u8"一挂之下",
      u8"一指",
      u8"一按",
      u8"一按下",
      u8"一按到",
      u8"一按在",
      u8"一挡",
      u8"一挥",
      u8"一挥九制",
      u8"一挥而就",
      u8"一挥而成",
      u8"一振",
      u8"一挺",
      u8"一挽",
      u8"一捅",
      u8"一捆",
      u8"一捇仆",
      u8"一捋",
      u8"一损俱损",
      u8"一捺",
      u8"一掀",
      u8"一掉",
      u8"一掉头",
      u8"一掊土",
      u8"一掌",
      u8"一排",
      u8"一探",
      u8"一接如旧",
      u8"一推",
      u8"一推两搡",
      u8"一推之下",
      u8"一掷乾坤",
      u8"一掷千金",
      u8"一掷百万",
      u8"一提",
      u8"一提之下",
      u8"一插",
      u8"一揽包收",
      u8"一揽子",
      u8"一揽子计划",
      u8"一搏",
      u8"一搞",
      u8"一搭一档",
      u8"一搭两用",
      u8"一搭二用",
      u8"一摆",
      u8"一摇",
      u8"一摊子",
      u8"一摔",
      u8"一摞",
      u8"一摸",
      u8"一摸之下",
      u8"一撅一拐",
      u8"一撇",
      u8"一撕",
      u8"一播",
      u8"一播出",
      u8"一撮",
      u8"一支",
      u8"一支半节",
      u8"一支花",
      u8"一收",
      u8"一改",
      u8"一改故辙",
      u8"一攻",
      u8"一放",
      u8"一教就会",
      u8"一数",
      u8"一敲",
      u8"一整",
      u8"一整夜",
      u8"一整天",
      u8"一整套",
      u8"一敷",
      u8"一文",
      u8"一文不值",
      u8"一文不名",
      u8"一文如命",
      u8"一文钱",
      u8"一文钱难倒英雄汉",
      u8"一斑",
      u8"一斑半点",
      u8"一斑窥豹",
      u8"一斤",
      u8"一斩",
      u8"一断",
      u8"一新",
      u8"一方",
      u8"一方之任",
      u8"一方平安",
      u8"一方有",
      u8"一方有难",
      u8"一方有难八方支援",
      u8"一方有难，八方支援",
      u8"一方面",
      u8"一旁",
      u8"一旁凉快",
      u8"一旅",
      u8"一族",
      u8"一无",
      u8"一无可取",
      u8"一无所取",
      u8"一无所得",
      u8"一无所恃",
      u8"一无所成",
      u8"一无所有",
      u8"一无所求",
      u8"一无所知",
      u8"一无所能",
      u8"一无所获",
      u8"一无所长",
      u8"一无所闻",
      u8"一无是处",
      u8"一无长物",
      u8"一日",
      u8"一日万几",
      u8"一日万机",
      u8"一日万里",
      u8"一日三复",
      u8"一日三岁",
      u8"一日三月",
      u8"一日三省",
      u8"一日三秋",
      u8"一日三覆",
      u8"一日三餐",
      u8"一日不见",
      u8"一日不见如隔三秋",
      u8"一日为师",
      u8"一日之计",
      u8"一日之计在于晨",
      u8"一日之长",
      u8"一日之雅",
      u8"一日九迁",
      u8"一日份",
      u8"一日千丈",
      u8"一日千里",
      u8"一日夫妻百日恩",
      u8"一日数惊",
      u8"一日游",
      u8"一旦",
      u8"一旦一夕",
      u8"一早",
      u8"一早就",
      u8"一早晨",
      u8"一旬",
      u8"一时",
      u8"一时一事",
      u8"一时一刻",
      u8"一时三刻",
      u8"一时之权",
      u8"一时之秀",
      u8"一时之选",
      u8"一时之间",
      u8"一时伯仲",
      u8"一时冲动",
      u8"一时千载",
      u8"一时半会",
      u8"一时半会儿",
      u8"一时半刻",
      u8"一时半晌",
      u8"一时半霎",
      u8"一时拥有",
      u8"一时无两",
      u8"一时间",
      u8"一明",
      u8"一星",
      u8"一星半点",
      u8"一星期",
      u8"一星级",
      u8"一春",
      u8"一是",
      u8"一是一",
      u8"一是一二是二",
      u8"一昼",
      u8"一昼夜",
      u8"一显身手",
      u8"一晃",
      u8"一晃儿",
      u8"一晃眼",
      u8"一晃而过",
      u8"一晒",
      u8"一晚",
      u8"一晤",
      u8"一晦一明",
      u8"一智",
      u8"一暗",
      u8"一暝不视",
      u8"一暴十寒",
      u8"一曝十寒",
      u8"一曲",
      u8"一曲阳关",
      u8"一月",
      u8"一月份",
      u8"一有",
      u8"一服",
      u8"一服药水",
      u8"一望",
      u8"一望无垠",
      u8"一望无涯",
      u8"一望无边",
      u8"一望无际",
      u8"一望而知",
      u8"一朝",
      u8"一朝一夕",
      u8"一朝之忿",
      u8"一朝之患",
      u8"一朝千里",
      u8"一朝天子",
      u8"一朝天子一朝臣",
      u8"一朝权在手",
      u8"一朝权在手便把令来行",
      u8"一朝被蛇咬",
      u8"一期",
      u8"一期稻作",
      u8"一木难支",
      u8"一本",
      u8"一本万利",
      u8"一本书",
      u8"一本初衷",
      u8"一本正经",
      u8"一本道",
      u8"一朵",
      u8"一朵花",
      u8"一机部",
      u8"一杆",
      u8"一杆子打翻一船人",
      u8"一村",
      u8"一束",
      u8"一束花",
      u8"一杠",
      u8"一条",
      u8"一条心",
      u8"一条条",
      u8"一条线",
      u8"一条藤",
      u8"一条街",
      u8"一条路",
      u8"一条龙",
      u8"一条龙服务",
      u8"一来",
      u8"一来一去",
      u8"一来一往",
      u8"一来二去",
      u8"一来二往",
      u8"一来到",
      u8"一杯",
      u8"一板",
      u8"一板一眼",
      u8"一板三眼",
      u8"一枕南柯",
      u8"一枕槐安",
      u8"一枕邯郸",
      u8"一枕黄梁",
      u8"一枕黄粱",
      u8"一枚",
      u8"一枝",
      u8"一枝一栖",
      u8"一枝一节",
      u8"一枝之栖",
      u8"一枝春",
      u8"一枝梅",
      u8"一枝独秀",
      u8"一枝红杏出墙来",
      u8"一枝花",
      u8"一枝香",
      u8"一枝黄花",
      u8"一枪",
      u8"一架",
      u8"一柄",
      u8"一柜",
      u8"一查",
      u8"一查到底",
      u8"一柱承天",
      u8"一柱擎天",
      u8"一栋",
      u8"一栋栋",
      u8"一栏",
      u8"一树",
      u8"一树了之",
      u8"一树梨花压海棠",
      u8"一树百获",
      u8"一栖两雄",
      u8"一株",
      u8"一样",
      u8"一根",
      u8"一根一板",
      u8"一格",
      u8"一案",
      u8"一桌",
      u8"一档",
      u8"一桩",
      u8"一桶",
      u8"一桶桶",
      u8"一梦华胥",
      u8"一梭",
      u8"一梯",
      u8"一梯次",
      u8"一棉",
      u8"一棍",
      u8"一棍子",
      u8"一棍子打死",
      u8"一棒",
      u8"一棒一条痕",
      u8"一棵",
      u8"一棵树",
      u8"一楼",
      u8"一概",
      u8"一概不理",
      u8"一概不知",
      u8"一概而论",
      u8"一榻横陈",
      u8"一榻糊涂",
      u8"一榻胡涂",
      u8"一槌定音",
      u8"一樘",
      u8"一模一样",
      u8"一模二样",
      u8"一横",
      u8"一次",
      u8"一次不忠百次不用",
      u8"一次函数",
      u8"一次又一次",
      u8"一次性",
      u8"一次方程",
      u8"一次次",
      u8"一次能源",
      u8"一次解决",
      u8"一次通过式燃料循环",
      u8"一款",
      u8"一正",
      u8"一正一负",
      u8"一步",
      u8"一步一个脚印",
      u8"一步一趋",
      u8"一步一鬼",
      u8"一步之遥",
      u8"一步到位",
      u8"一步棋",
      u8"一步步",
      u8"一步法",
      u8"一步法三维偏移",
      u8"一步登天",
      u8"一步舞",
      u8"一死",
      u8"一死一伤",
      u8"一死一生",
      u8"一死了之",
      u8"一段",
      u8"一段时间",
      u8"一段票",
      u8"一段落",
      u8"一段话",
      u8"一段距离",
      u8"一段路",
      u8"一比",
      u8"一毛",
      u8"一毛不拔",
      u8"一毛钱",
      u8"一毫",
      u8"一毫不差",
      u8"一毫不染",
      u8"一毫不苟",
      u8"一毫千里",
      u8"一民",
      u8"一民同俗",
      u8"一气",
      u8"一气之下",
      u8"一气呵成",
      u8"一气浑成",
      u8"一氧",
      u8"一氧化",
      u8"一氧化氮",
      u8"一氧化氮合酶",
      u8"一氧化物",
      u8"一氧化碳",
      u8"一氧化碳中毒",
      u8"一氧化碳助燃剂",
      u8"一氧化铅",
      u8"一水",
      u8"一水之隔",
      u8"一水儿",
      u8"一江",
      u8"一江春水向东流",
      u8"一池",
      u8"一池春水",
      u8"一池秋水",
      u8"一汽",
      u8"一汽大众",
      u8"一沉",
      u8"一泡",
      u8"一波",
      u8"一波万波",
      u8"一波三折",
      u8"一波又起",
      u8"一波才动万波随",
      u8"一波未平",
      u8"一波未平一波又起",
      u8"一泻万里",
      u8"一泻千里",
      u8"一泻百里",
      u8"一泼",
      u8"一洗",
      u8"一洗尘俗",
      u8"一洞",
      u8"一派",
      u8"一派胡言",
      u8"一流",
      u8"一流人才",
      u8"一流大学",
      u8"一浆十饼",
      u8"一测",
      u8"一浪",
      u8"一涂",
      u8"一混",
      u8"一添",
      u8"一清",
      u8"一清二楚",
      u8"一清二白",
      u8"一清如水",
      u8"一清早",
      u8"一渊不两蛟",
      u8"一湖",
      u8"一溜儿",
      u8"一溜歪斜",
      u8"一溜湮",
      u8"一溜烟",
      u8"一溜烟儿",
      u8"一溜风",
      u8"一滑",
      u8"一满意",
      u8"一滩",
      u8"一滴",
      u8"一滴水",
      u8"一潭",
      u8"一潭死水",
      u8"一火",
      u8"一灯大师",
      u8"一炒",
      u8"一炖",
      u8"一炝",
      u8"一炮",
      u8"一炮打响",
      u8"一炮而红",
      u8"一炷香",
      u8"一点",
      u8"一点一滴",
      u8"一点儿",
      u8"一点半点",
      u8"一点灵犀",
      u8"一点点",
      u8"一点红",
      u8"一点钟",
      u8"一烘",
      u8"一烤",
      u8"一烫",
      u8"一热",
      u8"一焖",
      u8"一照",
      u8"一煨",
      u8"一煮",
      u8"一熏一莸",
      u8"一熟",
      u8"一爱",
      u8"一爱上",
      u8"一父",
      u8"一爿",
      u8"一片",
      u8"一片丹心",
      u8"一片冰心",
      u8"一片宫商",
      u8"一片成名",
      u8"一片散沙",
      u8"一片汪洋",
      u8"一片焦土",
      u8"一片片",
      u8"一片生机",
      u8"一片痴心",
      u8"一片空白",
      u8"一片至诚",
      u8"一片苦心",
      u8"一版",
      u8"一牙",
      u8"一牛九锁",
      u8"一牛吼地",
      u8"一牛鸣",
      u8"一牛鸣地",
      u8"一物",
      u8"一物不知",
      u8"一物克一物",
      u8"一物降一物",
      u8"一牵",
      u8"一犬吠形",
      u8"一犬吠形百犬吠声",
      u8"一状",
      u8"一狐之掖",
      u8"一狐之腋",
      u8"一狠二狠",
      u8"一献三售",
      u8"一献三酬",
      u8"一环",
      u8"一环扣一环",
      u8"一环紧扣一环",
      u8"一现",
      u8"一现昙华",
      u8"一班",
      u8"一班一级",
      u8"一班一辈",
      u8"一班人",
      u8"一班人马",
      u8"一班半点",
      u8"一球",
      u8"一琴一鹤",
      u8"一瓢",
      u8"一瓣",
      u8"一瓣心香",
      u8"一瓶",
      u8"一瓶子不满",
      u8"一生",
      u8"一生一世",
      u8"一生一代",
      u8"一生不变",
      u8"一生中",
      u8"一生九死",
      u8"一生何求",
      u8"一生都是命安排",
      u8"一用",
      u8"一用到",
      u8"一甩",
      u8"一甲",
      u8"一甲子",
      u8"一男",
      u8"一男一女",
      u8"一男二女",
      u8"一男半女",
      u8"一画",
      u8"一画开天",
      u8"一番",
      u8"一番滋味",
      u8"一番苦心",
      u8"一番话",
      u8"一病",
      u8"一病不起",
      u8"一瘦",
      u8"一瘸",
      u8"一瘸一拐",
      u8"一登龙门",
      u8"一白遮三丑",
      u8"一白遮百丑",
      u8"一百二十行",
      u8"一百八十度",
      u8"一百分",
      u8"一百单八将",
      u8"一盅",
      u8"一盆",
      u8"一盏",
      u8"一盏灯",
      u8"一盏盏",
      u8"一监督",
      u8"一盒",
      u8"一盒盒",
      u8"一盖",
      u8"一盘",
      u8"一盘散沙",
      u8"一盘棋",
      u8"一盘菜",
      u8"一目",
      u8"一目之士",
      u8"一目了然",
      u8"一目五行",
      u8"一目十行",
      u8"一目数行",
      u8"一盯",
      u8"一直",
      u8"一直以来",
      u8"一直叫",
      u8"一直在",
      u8"一直是",
      u8"一直未果",
      u8"一直都",
      u8"一相情原",
      u8"一相情愿",
      u8"一省",
      u8"一省两地",
      u8"一看",
      u8"一看之下",
      u8"一看再看",
      u8"一看出",
      u8"一看到",
      u8"一眨",
      u8"一眨巴眼",
      u8"一眨眼",
      u8"一眼",
      u8"一眼看穿",
      u8"一着",
      u8"一着不慎",
      u8"一着不慎全盘皆输",
      u8"一着不慎满盘皆输",
      u8"一着被蛇咬三年怕井绳",
      u8"一睡",
      u8"一睹",
      u8"一睹之下",
      u8"一睹芳容",
      u8"一瞄",
      u8"一瞑不视",
      u8"一瞥",
      u8"一瞧",
      u8"一瞧之下",
      u8"一瞬",
      u8"一瞬千里",
      u8"一瞬即逝",
      u8"一瞬而逝",
      u8"一瞬间",
      u8"一瞻丰采",
      u8"一矢双穿",
      u8"一知半见",
      u8"一知半解",
      u8"一知片解",
      u8"一短",
      u8"一矮",
      u8"一石",
      u8"一石两鸟",
      u8"一石二鸟",
      u8"一石多鸟",
      u8"一石激起千层浪",
      u8"一码",
      u8"一码事",
      u8"一码当先",
      u8"一码桌面系统",
      u8"一码汉字输入法",
      u8"一码汉字输入软件",
      u8"一码软件",
      u8"一码领先",
      u8"一砍",
      u8"一砖一瓦",
      u8"一破",
      u8"一砸",
      u8"一碗",
      u8"一碗水端不平",
      u8"一碗水端平",
      u8"一碟",
      u8"一碧万倾",
      u8"一碧万顷",
      u8"一碧千里",
      u8"一碰",
      u8"一磅",
      u8"一磕",
      u8"一礼",
      u8"一神教",
      u8"一神论",
      u8"一票",
      u8"一票人",
      u8"一票人马",
      u8"一票制",
      u8"一票否决",
      u8"一票否决制",
      u8"一票通",
      u8"一禁",
      u8"一秉大公",
      u8"一秉至公",
      u8"一秉虔诚",
      u8"一种",
      u8"一科",
      u8"一秒",
      u8"一秒钟",
      u8"一程",
      u8"一程子",
      u8"一稿",
      u8"一稿多投",
      u8"一穷二白",
      u8"一空",
      u8"一空依傍",
      u8"一窍",
      u8"一窍不通",
      u8"一窝",
      u8"一窝蜂",
      u8"一窝风",
      u8"一窥全豹",
      u8"一竖",
      u8"一站",
      u8"一站式",
      u8"一站站",
      u8"一站通",
      u8"一章",
      u8"一端",
      u8"一竿",
      u8"一竿子",
      u8"一竿子打",
      u8"一笑",
      u8"一笑一颦",
      u8"一笑了事",
      u8"一笑倾城",
      u8"一笑千金",
      u8"一笑百媚",
      u8"一笑置之",
      u8"一笑而过",
      u8"一笔",
      u8"一笔一画",
      u8"一笔不苟",
      u8"一笔划",
      u8"一笔勾断",
      u8"一笔勾销",
      u8"一笔带过",
      u8"一笔抹摋",
      u8"一笔抹杀",
      u8"一笔抹煞",
      u8"一笔钩断",
      u8"一等",
      u8"一等一",
      u8"一等兵",
      u8"一等功",
      u8"一等品",
      u8"一等奖",
      u8"一等舱",
      u8"一筐",
      u8"一筒",
      u8"一筹",
      u8"一筹莫展",
      u8"一签",
      u8"一算",
      u8"一算之下",
      u8"一管",
      u8"一箩",
      u8"一箩筐",
      u8"一箪一瓢",
      u8"一箪食",
      u8"一箭上垛",
      u8"一箭之地",
      u8"一箭之遥",
      u8"一箭双",
      u8"一箭双雕",
      u8"一箭双鵰",
      u8"一箭地",
      u8"一箱",
      u8"一篇",
      u8"一篇篇",
      u8"一篑之功",
      u8"一篓",
      u8"一篓篓",
      u8"一篮",
      u8"一簇",
      u8"一簧两舌",
      u8"一米",
      u8"一米板",
      u8"一米阳光",
      u8"一类",
      u8"一粒",
      u8"一粗一细",
      u8"一糊",
      u8"一系",
      u8"一系列",
      u8"一系列问题",
      u8"一索得男",
      u8"一索成男",
      u8"一紧",
      u8"一红",
      u8"一约",
      u8"一级",
      u8"一级代理",
      u8"一级企业",
      u8"一级准尉",
      u8"一级品",
      u8"一级相变",
      u8"一级简码",
      u8"一级预防",
      u8"一纵身",
      u8"一纸",
      u8"一纸千金",
      u8"一纸空文",
      u8"一线",
      u8"一线之路",
      u8"一线品牌",
      u8"一线天",
      u8"一线希望",
      u8"一线生机",
      u8"一线通",
      u8"一练",
      u8"一组",
      u8"一经",
      u8"一绝",
      u8"一统",
      u8"一统天下",
      u8"一统江湖",
      u8"一绺",
      u8"一缕",
      u8"一缕缕",
      u8"一缘",
      u8"一缘一会",
      u8"一缩",
      u8"一缸",
      u8"一缸水",
      u8"一罐",
      u8"一网",
      u8"一网尽扫",
      u8"一网打尽",
      u8"一罩",
      u8"一群",
      u8"一群人",
      u8"一群群",
      u8"一翻",
      u8"一翻出",
      u8"一翻到",
      u8"一老",
      u8"一者",
      u8"一而二二而一",
      u8"一而二二而三",
      u8"一而再",
      u8"一而再再",
      u8"一而再再而三",
      u8"一联",
      u8"一聚",
      u8"一肉之味",
      u8"一肚子",
      u8"一肚子气",
      u8"一肚子火",
      u8"一股",
      u8"一股劲",
      u8"一股劲儿",
      u8"一股就灵",
      u8"一股脑",
      u8"一股脑儿",
      u8"一肢半节",
      u8"一胎",
      u8"一胎化",
      u8"一胖",
      u8"一脉同气",
      u8"一脉相传",
      u8"一脉相承",
      u8"一脉相通",
      u8"一脉香烟",
      u8"一脚",
      u8"一脚不移",
      u8"一脱",
      u8"一脱二",
      u8"一脸",
      u8"一脸茫然",
      u8"一腔",
      u8"一腔热血",
      u8"一腔热诚",
      u8"一腿",
      u8"一臂",
      u8"一臂之力",
      u8"一至于斯",
      u8"一致",
      u8"一致同意",
      u8"一致地",
      u8"一致性",
      u8"一致意见",
      u8"一致收敛性",
      u8"一致百虑",
      u8"一舀",
      u8"一般",
      u8"一般人",
      u8"一般人我不告诉他",
      u8"一般凯莱代数",
      u8"一般化",
      u8"一般地说",
      u8"一般射影线性群",
      u8"一般将来时",
      u8"一般性",
      u8"一般方程",
      u8"一般无二",
      u8"一般来说",
      u8"一般照明",
      u8"一般现在时",
      u8"一般而言",
      u8"一般般",
      u8"一般见识",
      u8"一般说来",
      u8"一般过去时",
      u8"一船",
      u8"一艇",
      u8"一艘",
      u8"一艘船",
      u8"一色",
      u8"一节",
      u8"一节课",
      u8"一花独放",
      u8"一花独放不是春",
      u8"一花独秀",
      u8"一苇可航",
      u8"一茬",
      u8"一草",
      u8"一草一木",
      u8"一荣俱荣",
      u8"一荤一素",
      u8"一药",
      u8"一营",
      u8"一落千丈",
      u8"一落泻势",
      u8"一薰一莸",
      u8"一虎不河",
      u8"一虎势单",
      u8"一虎难敌众犬",
      u8"一蛇两头",
      u8"一蟹不如一蟹",
      u8"一行",
      u8"一行人",
      u8"一行作吏",
      u8"一行行",
      u8"一街",
      u8"一衣带水",
      u8"一表",
      u8"一表人才",
      u8"一表人材",
      u8"一表人物",
      u8"一表堂堂",
      u8"一表非俗",
      u8"一表非凡",
      u8"一袋",
      u8"一被",
      u8"一装",
      u8"一褱而论",
      u8"一要",
      u8"一要到",
      u8"一见",
      u8"一见了然",
      u8"一见倾心",
      u8"一见如故",
      u8"一见如旧",
      u8"一见钟情",
      u8"一见锺情",
      u8"一见面",
      u8"一视同仁",
      u8"一览",
      u8"一览众山小",
      u8"一览无余",
      u8"一览无遗",
      u8"一览表",
      u8"一觉",
      u8"一觉睡到天亮",
      u8"一角",
      u8"一角钱",
      u8"一觞一咏",
      u8"一触",
      u8"一触即发",
      u8"一触即溃",
      u8"一触即爆",
      u8"一言",
      u8"一言一蔽之",
      u8"一言一行",
      u8"一言不发",
      u8"一言不合",
      u8"一言不和",
      u8"一言两语",
      u8"一言丧邦",
      u8"一言中的",
      u8"一言为定",
      u8"一言九鼎",
      u8"一言以蔽",
      u8"一言以蔽之",
      u8"一言兴邦",
      u8"一言千金",
      u8"一言半句",
      u8"一言半语",
      u8"一言半辞",
      u8"一言堂",
      u8"一言既出",
      u8"一言既出驷马难追",
      u8"一言未发",
      u8"一言而蔽之",
      u8"一言蔽之",
      u8"一言难尽",
      u8"一计",
      u8"一订",
      u8"一议",
      u8"一记",
      u8"一讲",
      u8"一讲出",
      u8"一讲到",
      u8"一词",
      u8"一试",
      u8"一试之下",
      u8"一试身手",
      u8"一诗千改心始安",
      u8"一语",
      u8"一语不发",
      u8"一语不合",
      u8"一语中人",
      u8"一语中的",
      u8"一语双关",
      u8"一语惊人",
      u8"一语惊醒",
      u8"一语成谶",
      u8"一语破的",
      u8"一语道破",
      u8"一语道破天机",
      u8"一误再误",
      u8"一说",
      u8"一说出",
      u8"一说到",
      u8"一说起",
      u8"一诺值千金",
      u8"一诺千金",
      u8"一诺无辞",
      u8"一读",
      u8"一读再读",
      u8"一课",
      u8"一调",
      u8"一调之下",
      u8"一谦四益",
      u8"一谷不升",
      u8"一谷不登",
      u8"一败如水",
      u8"一败涂地",
      u8"一贫",
      u8"一贫如洗",
      u8"一贯",
      u8"一贯下来",
      u8"一贯主张",
      u8"一贯作业",
      u8"一贯作风",
      u8"一贯制",
      u8"一贯性",
      u8"一贯方针",
      u8"一贯道",
      u8"一资半级",
      u8"一赢",
      u8"一走",
      u8"一走了之",
      u8"一起",
      u8"一超",
      u8"一趟",
      u8"一足",
      u8"一跃",
      u8"一跃而起",
      u8"一跃而过",
      u8"一跃龙门",
      u8"一跌",
      u8"一跌不振",
      u8"一跌再跌",
      u8"一跟",
      u8"一跤",
      u8"一跨",
      u8"一路",
      u8"一路上",
      u8"一路人",
      u8"一路发",
      u8"一路平安",
      u8"一路盘升",
      u8"一路神祇",
      u8"一路福星",
      u8"一路货",
      u8"一路货色",
      u8"一路顺车",
      u8"一路顺风",
      u8"一路领先",
      u8"一路风尘",
      u8"一路风清",
      u8"一跳",
      u8"一踏",
      u8"一踢",
      u8"一蹦三跳",
      u8"一蹭",
      u8"一蹲",
      u8"一蹴可几",
      u8"一蹴可及",
      u8"一蹴可成",
      u8"一蹴而及",
      u8"一蹴而就",
      u8"一蹴而得",
      u8"一蹴而成",
      u8"一蹴而易",
      u8"一蹶不兴",
      u8"一蹶不振",
      u8"一蹶不起",
      u8"一身",
      u8"一身两头",
      u8"一身两役",
      u8"一身二任",
      u8"一身五心",
      u8"一身是汗",
      u8"一身是胆",
      u8"一身正气",
      u8"一身清白",
      u8"一身而二任",
      u8"一身轻",
      u8"一身都是胆",
      u8"一躲",
      u8"一躺",
      u8"一车",
      u8"一车子",
      u8"一轨同风",
      u8"一转",
      u8"一转眼",
      u8"一轮",
      u8"一软",
      u8"一轰",
      u8"一轻",
      u8"一较高下",
      u8"一较高低",
      u8"一辆",
      u8"一辆车",
      u8"一辈",
      u8"一辈子",
      u8"一辙",
      u8"一辞同轨",
      u8"一辞莫赞",
      u8"一边",
      u8"一边倒",
      u8"一过",
      u8"一过去",
      u8"一过来",
      u8"一迎一和",
      u8"一近",
      u8"一还一报",
      u8"一进",
      u8"一进到",
      u8"一进去",
      u8"一进来",
      u8"一连",
      u8"一连串",
      u8"一连几天",
      u8"一连气儿",
      u8"一迭",
      u8"一迭连声",
      u8"一迳",
      u8"一退",
      u8"一退六二五",
      u8"一途",
      u8"一通",
      u8"一通百通",
      u8"一通通",
      u8"一逞兽欲",
      u8"一遍",
      u8"一道",
      u8"一道道",
      u8"一遭",
      u8"一遮",
      u8"一遮之下",
      u8"一邱之貉",
      u8"一邻",
      u8"一部",
      u8"一部分",
      u8"一酸",
      u8"一醉解千愁",
      u8"一里",
      u8"一重",
      u8"一重一掩",
      u8"一量",
      u8"一针",
      u8"一针一线",
      u8"一针一缐",
      u8"一针见血",
      u8"一钱",
      u8"一钱不值",
      u8"一钱不名",
      u8"一钱不落虚空地",
      u8"一钱如命",
      u8"一铲",
      u8"一锁",
      u8"一锅",
      u8"一锅煮",
      u8"一锅端",
      u8"一锅粥",
      u8"一错",
      u8"一错再错",
      u8"一锤",
      u8"一锤子买卖",
      u8"一锤定音",
      u8"一锭",
      u8"一键",
      u8"一键必杀",
      u8"一锹",
      u8"一镇",
      u8"一镑",
      u8"一镶",
      u8"一长",
      u8"一长一短",
      u8"一长两短",
      u8"一长串",
      u8"一长二短",
      u8"一长制",
      u8"一长半短",
      u8"一门",
      u8"一门同气",
      u8"一门心思",
      u8"一门忠烈",
      u8"一闪",
      u8"一闪即逝",
      u8"一闪而过",
      u8"一问",
      u8"一问一答",
      u8"一问三不",
      u8"一问三不知",
      u8"一问之下",
      u8"一间",
      u8"一闹",
      u8"一闻千悟",
      u8"一队",
      u8"一防",
      u8"一阳指",
      u8"一阵",
      u8"一阵子",
      u8"一阵阵",
      u8"一阵雨",
      u8"一阵风",
      u8"一阶",
      u8"一阶半级",
      u8"一阶半职",
      u8"一阶效率",
      u8"一阶理论",
      u8"一院",
      u8"一院制",
      u8"一隅",
      u8"一隅三反",
      u8"一隅之地",
      u8"一隅之见",
      u8"一隅之说",
      u8"一隔",
      u8"一集",
      u8"一雕双兔",
      u8"一雨成秋",
      u8"一雷二闪",
      u8"一震",
      u8"一霎",
      u8"一霎时",
      u8"一霎眼",
      u8"一霎那",
      u8"一霎间",
      u8"一露",
      u8"一霸",
      u8"一青",
      u8"一面",
      u8"一面之交",
      u8"一面之款",
      u8"一面之缘",
      u8"一面之识",
      u8"一面之词",
      u8"一面之辞",
      u8"一面之雅",
      u8"一面倒",
      u8"一面儿理",
      u8"一面如旧",
      u8"一面镜子",
      u8"一鞭",
      u8"一鞭一条痕",
      u8"一鞭先著",
      u8"一页",
      u8"一顶",
      u8"一顷",
      u8"一项",
      u8"一顺儿",
      u8"一顾倾城",
      u8"一顾千金",
      u8"一顿",
      u8"一顿饭",
      u8"一领",
      u8"一颗",
      u8"一题",
      u8"一颠一跛",
      u8"一颦一笑",
      u8"一风吹",
      u8"一飞",
      u8"一飞冲天",
      u8"一餐",
      u8"一餐饭",
      u8"一饥两饱",
      u8"一饭一啄",
      u8"一饭三吐哺",
      u8"一饭之德",
      u8"一饭千金",
      u8"一饮一啄",
      u8"一饮而尽",
      u8"一饱",
      u8"一饱口福",
      u8"一饱眼福",
      u8"一馈十起",
      u8"一首",
      u8"一首歌",
      u8"一马",
      u8"一马一鞍",
      u8"一马不备双鞍",
      u8"一马不行百马忧",
      u8"一马平川",
      u8"一马当先",
      u8"一马领先",
      u8"一骑当千",
      u8"一骨碌",
      u8"一高",
      u8"一高二低",
      u8"一鳞一爪",
      u8"一鳞半爪",
      u8"一鳞半甲",
      u8"一鳞片爪",
      u8"一鳞片甲",
      u8"一鸡死一鸡鸣",
      u8"一鸣惊人",
      u8"一麟半爪",
      u8"一麾出守",
      u8"一鼓一板",
      u8"一鼓作气",
      u8"一鼻子",
      u8"一鼻子灰",
      u8"一鼻孔",
      u8"一鼻孔出",
      u8"一鼻孔出气",
      u8"一齐",
      u8"一齐众楚",
      u8"一龙一猪",
      u8"一龙一蛇",
      u8"一龙九种",
      u8"丁一",
      u8"丁一卯二",
      u8"丁一确二",
      u8"丁丁",
      u8"丁丁冬冬",
      u8"丁丁当当",
      u8"丁上",
      u8"丁下",
      u8"丁不三",
      u8"丁不四",
      u8"丁丑",
      u8"丁东",
      u8"丁丹妮",
      u8"丁乃竺",
      u8"丁二烯",
      u8"丁二烯苯乙烯嵌段共聚",
      u8"丁二酮肟",
      u8"丁二酸",
      u8"丁亥",
      u8"丁俊晖",
      u8"丁俊辉",
      u8"丁俨",
      u8"丁光生",
      u8"丁光训",
      u8"丁克",
      u8"丁公凿井",
      u8"丁公藤",
      u8"丁关根",
      u8"丁典",
      u8"丁冬",
      u8"丁勇岱",
      u8"丁勇贷",
      u8"丁勉",
      u8"丁午",
      u8"丁卡",
      u8"丁卯",
      u8"丁同",
      u8"丁嘉丽",
      u8"丁嘉元",
      u8"丁嘉莉",
      u8"丁坚",
      u8"丁坝",
      u8"丁基",
      u8"丁基橡胶",
      u8"丁基胶",
      u8"丁壮",
      u8"丁声树",
      u8"丁大全",
      u8"丁子",
      u8"丁子峻",
      u8"丁字",
      u8"丁字尺",
      u8"丁字形",
      u8"丁字街",
      u8"丁字裤",
      u8"丁字规",
      u8"丁字镐",
      u8"丁家宜",
      u8"丁寅",
      u8"丁小芹",
      u8"丁尼",
      u8"丁岚",
      u8"丁巳",
      u8"丁当",
      u8"丁志成",
      u8"丁志诚",
      u8"丁忧",
      u8"丁怡",
      u8"丁戌",
      u8"丁敏尹",
      u8"丁文琪",
      u8"丁春秋",
      u8"丁是丁",
      u8"丁是丁卯",
      u8"丁是丁卯是卯",
      u8"丁未",
      u8"丁氰橡胶",
      u8"丁汝俊",
      u8"丁汝骏",
      u8"丁海峰",
      u8"丁游",
      u8"丁炔",
      u8"丁点",
      u8"丁点儿",
      u8"丁烯",
      u8"丁烯氧化",
      u8"丁烷",
      u8"丁烷脱氢",
      u8"丁玲",
      u8"丁班",
      u8"丁珰",
      u8"丁申",
      u8"丁男",
      u8"丁癸草",
      u8"丁石孙",
      u8"丁磊",
      u8"丁种",
      u8"丁种维生",
      u8"丁种维生素",
      u8"丁税",
      u8"丁笑宜",
      u8"丁等",
      u8"丁类放大器",
      u8"丁级",
      u8"丁腈橡胶",
      u8"丁艰",
      u8"丁苯橡胶",
      u8"丁菲飞",
      u8"丁薇",
      u8"丁辰",
      u8"丁达夫",
      u8"丁酉",
      u8"丁酮",
      u8"丁酸",
      u8"丁醇",
      u8"丁醛",
      u8"丁铎尔现象",
      u8"丁雨",
      u8"丁零",
      u8"丁零当啷",
      u8"丁零当郎",
      u8"丁青",
      u8"丁青县",
      u8"丁页",
      u8"丁项",
      u8"丁顺隔皮砌式",
      u8"丁香",
      u8"丁香油",
      u8"丁香油酚",
      u8"丁香花",
      u8"七一",
      u8"七一讲话",
      u8"七七",
      u8"七七事变",
      u8"七七八八",
      u8"七上八下",
      u8"七上八落",
      u8"七下",
      u8"七世",
      u8"七世夫妻",
      u8"七个",
      u8"七个人",
      u8"七中",
      u8"七中全会",
      u8"七了八当",
      u8"七事八事",
      u8"七五",
      u8"七五期间",
      u8"七五计划",
      u8"七人",
      u8"七人制",
      u8"七亿",
      u8"七亿人",
      u8"七仙女",
      u8"七代",
      u8"七伽社",
      u8"七位",
      u8"七位数",
      u8"七侠五义",
      u8"七侧向测井",
      u8"七倍",
      u8"七元",
      u8"七八",
      u8"七公",
      u8"七出",
      u8"七分",
      u8"七分裤",
      u8"七分钟",
      u8"七划",
      u8"七区",
      u8"七十二变",
      u8"七十二烈",
      u8"七十二行",
      u8"七十年代",
      u8"七口八嘴",
      u8"七古",
      u8"七台河",
      u8"七台河市",
      u8"七叶一枝花",
      u8"七叶树",
      u8"七号",
      u8"七员",
      u8"七品",
      u8"七哥",
      u8"七喜",
      u8"七嘴八张",
      u8"七嘴八舌",
      u8"七回",
      u8"七团",
      u8"七国",
      u8"七国集团",
      u8"七国首脑",
      u8"七圈",
      u8"七堵",
      u8"七声",
      u8"七夕",
      u8"七夕节",
      u8"七夜怪谈",
      u8"七大",
      u8"七大八小",
      u8"七大洲",
      u8"七天",
      u8"七套",
      u8"七子八婿",
      u8"七孔",
      u8"七孔生烟",
      u8"七宗罪",
      u8"七宝",
      u8"七寸",
      u8"七对",
      u8"七尺",
      u8"七尺之躯",
      u8"七尺之驱",
      u8"七层",
      u8"七层楼",
      u8"七届",
      u8"七届二中全会",
      u8"七巧板",
      u8"七巷",
      u8"七年",
      u8"七年之病",
      u8"七年之病求三年之艾",
      u8"七年之痒",
      u8"七年级",
      u8"七度",
      u8"七座",
      u8"七开八得",
      u8"七弟",
      u8"七张八嘴",
      u8"七弦琴",
      u8"七弯八拐",
      u8"七彩",
      u8"七彩缤纷",
      u8"七彩虹",
      u8"七彩谷",
      u8"七律",
      u8"七情",
      u8"七情六欲",
      u8"七慌八乱",
      u8"七成",
      u8"七手八脚",
      u8"七扭八歪",
      u8"七折",
      u8"七折八扣",
      u8"七担八挪",
      u8"七拉八扯",
      u8"七拐八拐",
      u8"七拱八翘",
      u8"七拳",
      u8"七拼八凑",
      u8"七捞八攘",
      u8"七损八伤",
      u8"七损八益",
      u8"七排",
      u8"七推八阻",
      u8"七搭八扯",
      u8"七搭八搭",
      u8"七擒七纵",
      u8"七支",
      u8"七支八搭",
      u8"七断八续",
      u8"七日",
      u8"七日来复",
      u8"七日香",
      u8"七早八早",
      u8"七旬",
      u8"七时",
      u8"七星",
      u8"七星井",
      u8"七星区",
      u8"七星山",
      u8"七星岩",
      u8"七星拳",
      u8"七星河",
      u8"七星泡",
      u8"七星街",
      u8"七星针",
      u8"七景",
      u8"七月",
      u8"七月份",
      u8"七机部",
      u8"七条",
      u8"七杯",
      u8"七枝",
      u8"七架梁",
      u8"七格",
      u8"七桶",
      u8"七梯次",
      u8"七棱八瓣",
      u8"七楼",
      u8"七横八竖",
      u8"七次",
      u8"七次量衣一次裁",
      u8"七步",
      u8"七步之才",
      u8"七步八叉",
      u8"七步成章",
      u8"七步成诗",
      u8"七歪八扭",
      u8"七死七生",
      u8"七死八活",
      u8"七段",
      u8"七派",
      u8"七湾八扭",
      u8"七湾八拐",
      u8"七满八平",
      u8"七滴",
      u8"七濑美雪",
      u8"七点",
      u8"七点时",
      u8"七点钟",
      u8"七爷",
      u8"七爷八爷",
      u8"七片",
      u8"七狼八狈",
      u8"七生七死",
      u8"七男八婿",
      u8"七疮八孔",
      u8"七病八倒",
      u8"七病八痛",
      u8"七百",
      u8"七百乡",
      u8"七盒",
      u8"七盘",
      u8"七盘菜",
      u8"七相五公",
      u8"七破八补",
      u8"七票",
      u8"七种",
      u8"七秒",
      u8"七秒钟",
      u8"七穿八洞",
      u8"七穿八烂",
      u8"七窍",
      u8"七窍冒火",
      u8"七窍冒烟",
      u8"七窍流血",
      u8"七窍玲珑",
      u8"七窍生烟",
      u8"七窝八代",
      u8"七站",
      u8"七笔",
      u8"七篇",
      u8"七絃琴",
      u8"七级",
      u8"七级浮屠",
      u8"七级风",
      u8"七纵七禽",
      u8"七纵八横",
      u8"七线",
      u8"七绝",
      u8"七美",
      u8"七老八倒",
      u8"七老八十",
      u8"七脚八手",
      u8"七舌八嘴",
      u8"七色",
      u8"七色板",
      u8"七节",
      u8"七节课",
      u8"七行",
      u8"七行俱下",
      u8"七行诗",
      u8"七袋",
      u8"七角",
      u8"七言",
      u8"七言八语",
      u8"七言句",
      u8"七言律诗",
      u8"七言绝句",
      u8"七言诗",
      u8"七贞九烈",
      u8"七足八手",
      u8"七路",
      u8"七辆",
      u8"七辆车",
      u8"七返还丹",
      u8"七通",
      u8"七通一平",
      u8"七邻",
      u8"七郤八手",
      u8"七部",
      u8"七里河区",
      u8"七里香",
      u8"七重",
      u8"七重唱",
      u8"七重奏",
      u8"七长八短",
      u8"七雄",
      u8"七零八散",
      u8"七零八碎",
      u8"七零八落",
      u8"七青八黄",
      u8"七音",
      u8"七题",
      u8"七颠八倒",
      u8"七首八脚",
      u8"七高八低",
      u8"七龙珠",
      u8"万一",
      u8"万一会",
      u8"万一在",
      u8"万一是",
      u8"万一有",
      u8"万万不可",
      u8"万万不能",
      u8"万万千千",
      u8"万万岁",
      u8"万万没有想到",
      u8"万丈",
      u8"万丈光芒",
      u8"万丈深渊",
      u8"万丈红尘",
      u8"万丈高楼",
      u8"万丈高楼平地起",
      u8"万不失一",
      u8"万不得已",
      u8"万不该",
      u8"万世",
      u8"万世一时",
      u8"万世不易",
      u8"万世师表",
      u8"万世无疆",
      u8"万世流芳",
      u8"万乘",
      u8"万乘之国",
      u8"万乘之尊",
      u8"万事",
      u8"万事万物",
      u8"万事不由人计较",
      u8"万事亨通",
      u8"万事俱备",
      u8"万事俱备只欠东风",
      u8"万事兴",
      u8"万事具备",
      u8"万事利",
      u8"万事劝人休瞒昧",
      u8"万事吉",
      u8"万事大吉",
      u8"万事如意",
      u8"万事开头难",
      u8"万事无忧",
      u8"万事皆备",
      u8"万事起头难",
      u8"万事通",
      u8"万人",
      u8"万人之上",
      u8"万人之敌",
      u8"万人传实",
      u8"万人敌",
      u8"万人空巷",
      u8"万人迷",
      u8"万亿",
      u8"万仞高山",
      u8"万代",
      u8"万代千秋",
      u8"万件",
      u8"万份",
      u8"万伏",
      u8"万众",
      u8"万众一心",
      u8"万众所归",
      u8"万众欢腾",
      u8"万众瞩目",
      u8"万位",
      u8"万余",
      u8"万余人",
      u8"万余元",
      u8"万佳",
      u8"万俟",
      u8"万倍",
      u8"万儿八千",
      u8"万元",
      u8"万元以上",
      u8"万元户",
      u8"万全",
      u8"万全之策",
      u8"万全之计",
      u8"万全县",
      u8"万全街",
      u8"万兽之王",
      u8"万分",
      u8"万分之",
      u8"万分危急",
      u8"万分感激",
      u8"万利达",
      u8"万别千差",
      u8"万劫",
      u8"万劫不复",
      u8"万劫不渝",
      u8"万勿",
      u8"万千",
      u8"万千气象",
      u8"万华",
      u8"万华区",
      u8"万华站",
      u8"万博",
      u8"万卷",
      u8"万卷书",
      u8"万卷书屋",
      u8"万卷书库",
      u8"万历",
      u8"万县",
      u8"万县市",
      u8"万双",
      u8"万变",
      u8"万变不离",
      u8"万变不离其宗",
      u8"万口一词",
      u8"万口一谈",
      u8"万口一辞",
      u8"万古",
      u8"万古不变",
      u8"万古千秋",
      u8"万古常青",
      u8"万古愁",
      u8"万古流芳",
      u8"万古留芳",
      u8"万古长存",
      u8"万古长新",
      u8"万古长春",
      u8"万古长青",
      u8"万古霉素",
      u8"万名",
      u8"万向",
      u8"万向节",
      u8"万向轮",
      u8"万吨",
      u8"万吨级",
      u8"万国",
      u8"万国公法",
      u8"万国宫",
      u8"万国权",
      u8"万国邮政联盟",
      u8"万国邮联",
      u8"万国音标",
      u8"万圆",
      u8"万圣节",
      u8"万圭",
      u8"万场",
      u8"万块",
      u8"万埠镇",
      u8"万壑争流",
      u8"万壑千岩",
      u8"万壑松风",
      u8"万处",
      u8"万多元",
      u8"万大平",
      u8"万夫",
      u8"万夫不当",
      u8"万夫不当之勇",
      u8"万夫莫开",
      u8"万夫莫当",
      u8"万夫莫敌",
      u8"万头",
      u8"万头攒动",
      u8"万头窜动",
      u8"万姓",
      u8"万字",
      u8"万字号",
      u8"万学远",
      u8"万宁",
      u8"万宁县",
      u8"万宁市",
      u8"万安",
      u8"万安县",
      u8"万安渡",
      u8"万宝",
      u8"万宝全书",
      u8"万宝路",
      u8"万宝镇",
      u8"万家",
      u8"万家乐",
      u8"万家寨",
      u8"万家灯火",
      u8"万家生佛",
      u8"万家香",
      u8"万寿",
      u8"万寿寺",
      u8"万寿山",
      u8"万寿无疆",
      u8"万寿果",
      u8"万寿菊",
      u8"万山",
      u8"万山特区",
      u8"万岁",
      u8"万岁千秋",
      u8"万岭不思游",
      u8"万峦",
      u8"万州区",
      u8"万年",
      u8"万年历",
      u8"万年县",
      u8"万年无疆",
      u8"万年青",
      u8"万幸",
      u8"万庆澜",
      u8"万应灵丹",
      u8"万应锭",
      u8"万度",
      u8"万德福",
      u8"万德莱",
      u8"万念俱寂",
      u8"万念俱灰",
      u8"万恨千愁",
      u8"万恶",
      u8"万恶之源",
      u8"万恶之首",
      u8"万恶淫为首",
      u8"万户",
      u8"万户侯",
      u8"万户千家",
      u8"万户千门",
      u8"万把",
      u8"万把块",
      u8"万拱",
      u8"万斛泉源",
      u8"万斤",
      u8"万方",
      u8"万方数据",
      u8"万无",
      u8"万无一失",
      u8"万春",
      u8"万有",
      u8"万有引力",
      u8"万有引力定律",
      u8"万有引力常量",
      u8"万有模型",
      u8"万望",
      u8"万机",
      u8"万条",
      u8"万柏林区",
      u8"万桶",
      u8"万梓良",
      u8"万次",
      u8"万步",
      u8"万死",
      u8"万死一生",
      u8"万死不辞",
      u8"万死犹轻",
      u8"万段",
      u8"万民",
      u8"万民涂炭",
      u8"万水千山",
      u8"万泉河",
      u8"万洲号",
      u8"万流景仰",
      u8"万源",
      u8"万源县",
      u8"万灵丹",
      u8"万灵药",
      u8"万点",
      u8"万点大关",
      u8"万物",
      u8"万物之灵",
      u8"万状",
      u8"万用",
      u8"万用刀",
      u8"万用手册",
      u8"万用电表",
      u8"万用表",
      u8"万盛",
      u8"万盛区",
      u8"万盛溪",
      u8"万目睚眦",
      u8"万目睽睽",
      u8"万码",
      u8"万码奔腾",
      u8"万神庙",
      u8"万福",
      u8"万福成",
      u8"万福金安",
      u8"万秀区",
      u8"万种",
      u8"万种风姿",
      u8"万种风情",
      u8"万穗俱寂",
      u8"万端",
      u8"万签插架",
      u8"万箭攒心",
      u8"万箭穿心",
      u8"万箭穿身",
      u8"万箱",
      u8"万籁",
      u8"万籁俱寂",
      u8"万籁无声",
      u8"万米",
      u8"万米长跑",
      u8"万紫千红",
      u8"万紫千红春满园",
      u8"万红千紫",
      u8"万绪千头",
      u8"万绪千端",
      u8"万绮雯",
      u8"万维",
      u8"万维网",
      u8"万维网楼兰",
      u8"万绿丛中",
      u8"万绿丛中一点红",
      u8"万绿园",
      u8"万绿湖",
      u8"万缕千丝",
      u8"万美元",
      u8"万胜",
      u8"万能",
      u8"万能事",
      u8"万能五笔",
      u8"万能工专",
      u8"万能无比",
      u8"万能胶",
      u8"万能表",
      u8"万能论",
      u8"万能选手",
      u8"万能钥匙",
      u8"万能锅",
      u8"万能键",
      u8"万般",
      u8"万般无奈",
      u8"万般皆下品",
      u8"万般皆下品唯有读书高",
      u8"万般都是命",
      u8"万艾可",
      u8"万花争艳",
      u8"万花山",
      u8"万花筒",
      u8"万芳",
      u8"万苦千辛",
      u8"万荣",
      u8"万荣县",
      u8"万虑俱清",
      u8"万行",
      u8"万言",
      u8"万言书",
      u8"万语千言",
      u8"万象",
      u8"万象更新",
      u8"万象森罗",
      u8"万贯",
      u8"万贯家产",
      u8"万贯家私",
      u8"万贯家财",
      u8"万赖俱寂",
      u8"万赖无声",
      u8"万载",
      u8"万载千秋",
      u8"万载县",
      u8"万辆",
      u8"万达",
      u8"万选青钱",
      u8"万通",
      u8"万道",
      u8"万邦",
      u8"万部",
      u8"万里",
      u8"万里一碧",
      u8"万里无云",
      u8"万里晴空",
      u8"万里行",
      u8"万里迢迢",
      u8"万里长城",
      u8"万里长征",
      u8"万里长空",
      u8"万里风",
      u8"万里鹏程",
      u8"万里鹏翼",
      u8"万重",
      u8"万重山",
      u8"万金",
      u8"万金油",
      u8"万钧",
      u8"万钧之力",
      u8"万锭",
      u8"万隆",
      u8"万隆会议",
      u8"万难",
      u8"万难不却",
      u8"万震山",
      u8"万顷",
      u8"万顷琉璃",
      u8"万顷碧波",
      u8"万顺",
      u8"万马",
      u8"万马奔腾",
      u8"万马齐喑",
      u8"丈二和尚",
      u8"丈二和尚摸不着头脑",
      u8"丈二金刚",
      u8"丈二金刚摸不着头脑",
      u8"丈人",
      u8"丈八蛇矛",
      u8"丈夫",
      u8"丈母",
      u8"丈母娘",
      u8"丈量",
      u8"丈量土地",
      u8"丈量法",
      u8"丈量面积",
      u8"三一学院",
      u8"三一律",
      u8"三七二十一",
      u8"三七开",
      u8"三万",
      u8"三万个",
      u8"三万人",
      u8"三万元",
      u8"三万块",
      u8"三万英尺",
      u8"三三两两",
      u8"三三五五",
      u8"三三制",
      u8"三三四四",
      u8"三上",
      u8"三下",
      u8"三下两下",
      u8"三下五除二",
      u8"三不",
      u8"三不拗六",
      u8"三不放过",
      u8"三不朽",
      u8"三不知",
      u8"三不管",
      u8"三专",
      u8"三专制",
      u8"三专生",
      u8"三世",
      u8"三世佛",
      u8"三丙",
      u8"三两",
      u8"三个",
      u8"三个代表",
      u8"三个和尚没水吃",
      u8"三个和尚没水喝",
      u8"三个月",
      u8"三个有利于",
      u8"三个臭皮匠",
      u8"三个臭皮匠赛过诸葛亮",
      u8"三个面向",
      u8"三中",
      u8"三中全会",
      u8"三为主",
      u8"三义",
      u8"三义墓",
      u8"三乙",
      u8"三乙醇胺",
      u8"三九",
      u8"三九天",
      u8"三乱",
      u8"三五成群",
      u8"三井",
      u8"三亚",
      u8"三亚会议",
      u8"三亚市",
      u8"三亚旅游",
      u8"三亚湾",
      u8"三产",
      u8"三亲六故",
      u8"三亲六眷",
      u8"三亲四眷",
      u8"三人",
      u8"三人为众",
      u8"三人份",
      u8"三人成虎",
      u8"三人行",
      u8"三人行必有我师",
      u8"三亿",
      u8"三亿人",
      u8"三亿元",
      u8"三仁",
      u8"三从",
      u8"三从四德",
      u8"三仙湖镇",
      u8"三代",
      u8"三代人",
      u8"三代同堂",
      u8"三令五申",
      u8"三件",
      u8"三件套",
      u8"三任",
      u8"三份",
      u8"三伍",
      u8"三伏",
      u8"三伏天",
      u8"三优",
      u8"三会",
      u8"三会两课",
      u8"三伯",
      u8"三伯母",
      u8"三伯父",
      u8"三位",
      u8"三位一体",
      u8"三位数",
      u8"三体问题",
      u8"三余读书",
      u8"三侠五义",
      u8"三保直街",
      u8"三信",
      u8"三倍",
      u8"三元",
      u8"三元乙丙橡胶",
      u8"三元区",
      u8"三元及第",
      u8"三元里",
      u8"三光",
      u8"三光政策",
      u8"三克",
      u8"三党",
      u8"三八作风",
      u8"三八国际妇女节",
      u8"三八妇女节",
      u8"三八式",
      u8"三八红旗手",
      u8"三八线",
      u8"三八节",
      u8"三公",
      u8"三公九卿",
      u8"三公开",
      u8"三六九等",
      u8"三关",
      u8"三具",
      u8"三兽渡河",
      u8"三写成乌",
      u8"三写易字",
      u8"三军",
      u8"三军总医院",
      u8"三农问题",
      u8"三冬二夏",
      u8"三分",
      u8"三分之一",
      u8"三分之二",
      u8"三分似人七分似鬼",
      u8"三分像人七分似鬼",
      u8"三分像人七分像鬼",
      u8"三分法",
      u8"三分球",
      u8"三分量检波器",
      u8"三分钟",
      u8"三分钟学会",
      u8"三分鼎立",
      u8"三分鼎足",
      u8"三利",
      u8"三制",
      u8"三剑圣",
      u8"三剑客",
      u8"三副",
      u8"三包",
      u8"三化螟",
      u8"三北",
      u8"三北防护林",
      u8"三区",
      u8"三十三天",
      u8"三十六策",
      u8"三十六策走为上策",
      u8"三十六行",
      u8"三十六计",
      u8"三十六计走为上计",
      u8"三十四",
      u8"三十四中",
      u8"三十年河东",
      u8"三十年河东三十年河西",
      u8"三十年河西",
      u8"三十而立",
      u8"三占从二",
      u8"三原",
      u8"三原则",
      u8"三原县",
      u8"三原色",
      u8"三厢车",
      u8"三叉",
      u8"三叉戟",
      u8"三叉神经",
      u8"三叉苦",
      u8"三叉街",
      u8"三叉路口",
      u8"三叉骨",
      u8"三反",
      u8"三反五反",
      u8"三反四覆",
      u8"三叠",
      u8"三叠系",
      u8"三叠纪",
      u8"三叠阳关",
      u8"三口",
      u8"三句",
      u8"三句不离",
      u8"三句不离本行",
      u8"三句话",
      u8"三句话不离本行",
      u8"三只",
      u8"三只手",
      u8"三台八座",
      u8"三台县",
      u8"三台山",
      u8"三台山乡",
      u8"三台村",
      u8"三台联播",
      u8"三叶",
      u8"三叶期",
      u8"三叶草",
      u8"三叶虫",
      u8"三合",
      u8"三合一",
      u8"三合会",
      u8"三合土",
      u8"三合房",
      u8"三合板",
      u8"三合院",
      u8"三同",
      u8"三名",
      u8"三吐三握",
      u8"三向",
      u8"三告投杼",
      u8"三命而俯",
      u8"三和",
      u8"三和土",
      u8"三品",
      u8"三唑仑",
      u8"三回九转",
      u8"三回五次",
      u8"三围",
      u8"三国",
      u8"三国志",
      u8"三国演义",
      u8"三国策",
      u8"三国群英",
      u8"三国群英传",
      u8"三国鼎立",
      u8"三坟五典",
      u8"三垒手",
      u8"三堆",
      u8"三堰",
      u8"三塔",
      u8"三塘",
      u8"三塘乡",
      u8"三声无奈",
      u8"三复",
      u8"三复斯言",
      u8"三复白圭",
      u8"三夏",
      u8"三多",
      u8"三夜",
      u8"三大作风",
      u8"三大块",
      u8"三大差别",
      u8"三大战役",
      u8"三大法宝",
      u8"三天两头",
      u8"三天打鱼",
      u8"三天打鱼两天晒网",
      u8"三太子",
      u8"三夫之对",
      u8"三夫之言",
      u8"三夫成市虎",
      u8"三头",
      u8"三头两日",
      u8"三头两绪",
      u8"三头两面",
      u8"三头八臂",
      u8"三头六臂",
      u8"三头六证",
      u8"三头六面",
      u8"三头对案",
      u8"三头钳",
      u8"三夹板",
      u8"三套",
      u8"三好",
      u8"三好两歉",
      u8"三好两歹",
      u8"三好二怯",
      u8"三好学生",
      u8"三好生",
      u8"三妻四妾",
      u8"三姑",
      u8"三姑六婆",
      u8"三姓",
      u8"三姓家奴",
      u8"三委",
      u8"三婆两嫂",
      u8"三媒六证",
      u8"三子",
      u8"三字",
      u8"三字经",
      u8"三字词",
      u8"三孝",
      u8"三季",
      u8"三季度",
      u8"三季稻",
      u8"三学",
      u8"三官能引发剂",
      u8"三定",
      u8"三宝",
      u8"三审制",
      u8"三客",
      u8"三室两厅",
      u8"三宫六院",
      u8"三宫六院七十二妃",
      u8"三害",
      u8"三家",
      u8"三家村",
      u8"三寸",
      u8"三寸丁",
      u8"三寸不烂",
      u8"三寸不烂之舌",
      u8"三寸之舌",
      u8"三寸半",
      u8"三寸舌",
      u8"三寸金莲",
      u8"三寸鸟",
      u8"三寸鸟七寸嘴",
      u8"三对",
      u8"三对六面",
      u8"三小",
      u8"三小块",
      u8"三小时",
      u8"三小片",
      u8"三尖瓣",
      u8"三尸五鬼",
      u8"三尸暴跳",
      u8"三尸脑神丹",
      u8"三尺",
      u8"三局",
      u8"三局两胜",
      u8"三层",
      u8"三层楼",
      u8"三居室",
      u8"三屉桌",
      u8"三届",
      u8"三山",
      u8"三山五岳",
      u8"三岁",
      u8"三岁时",
      u8"三岔口",
      u8"三岔路",
      u8"三岔路口",
      u8"三岔路村",
      u8"三峡",
      u8"三峡工程",
      u8"三峡游",
      u8"三峰驼",
      u8"三嵌段共聚物",
      u8"三差两错",
      u8"三差五错",
      u8"三巷",
      u8"三师",
      u8"三平二满",
      u8"三年",
      u8"三年不窥圆",
      u8"三年之艾",
      u8"三年五载",
      u8"三年制",
      u8"三年化碧",
      u8"三年有成",
      u8"三年期",
      u8"三年生",
      u8"三年级",
      u8"三年计划",
      u8"三废",
      u8"三度",
      u8"三度空间",
      u8"三座",
      u8"三座大山",
      u8"三座门",
      u8"三建",
      u8"三式",
      u8"三张",
      u8"三张犁",
      u8"三弦",
      u8"三弦乐器",
      u8"三弦琴",
      u8"三强",
      u8"三影塔",
      u8"三徙成国",
      u8"三徙成都",
      u8"三心两意",
      u8"三心二意",
      u8"三志",
      u8"三态",
      u8"三态变化",
      u8"三态缓冲器",
      u8"三态逻辑",
      u8"三怕",
      u8"三思",
      u8"三思而后",
      u8"三思而后行",
      u8"三思而行",
      u8"三性",
      u8"三怨成府",
      u8"三总",
      u8"三总部",
      u8"三愿",
      u8"三成",
      u8"三成新",
      u8"三战",
      u8"三战三北",
      u8"三战两胜",
      u8"三截",
      u8"三户",
      u8"三户亡秦",
      u8"三房",
      u8"三房一厅",
      u8"三房两厅",
      u8"三房二厅",
      u8"三才",
      u8"三才升",
      u8"三打",
      u8"三折其肱",
      u8"三折肱",
      u8"三折肱为良医",
      u8"三拇指",
      u8"三拍",
      u8"三招两式",
      u8"三拳不敌四手",
      u8"三拳两脚",
      u8"三振",
      u8"三振出局",
      u8"三掌",
      u8"三排",
      u8"三接头",
      u8"三推六问",
      u8"三撑峡",
      u8"三支",
      u8"三改一加强",
      u8"三教",
      u8"三教九流",
      u8"三文治",
      u8"三文鱼",
      u8"三斑家蚊",
      u8"三方",
      u8"三方点格",
      u8"三方面",
      u8"三族",
      u8"三无",
      u8"三日",
      u8"三日不见当刮目相看",
      u8"三日份",
      u8"三日打鱼两日晒网",
      u8"三日新妇",
      u8"三旨相公",
      u8"三旬九食",
      u8"三时",
      u8"三明",
      u8"三明市",
      u8"三明治",
      u8"三星",
      u8"三星在天",
      u8"三星在户",
      u8"三星堆",
      u8"三星期",
      u8"三星村",
      u8"三星级",
      u8"三春",
      u8"三春柳",
      u8"三昧",
      u8"三是",
      u8"三晋",
      u8"三晚",
      u8"三智",
      u8"三智五猜",
      u8"三更",
      u8"三更半夜",
      u8"三曹对案",
      u8"三替",
      u8"三月",
      u8"三月不知肉味",
      u8"三月份",
      u8"三朋四友",
      u8"三朝",
      u8"三朝五日",
      u8"三朝元老",
      u8"三期",
      u8"三期贤佞",
      u8"三木",
      u8"三机关一部门",
      u8"三机部",
      u8"三权分立",
      u8"三杠",
      u8"三条",
      u8"三杯",
      u8"三杯通大道",
      u8"三板",
      u8"三板斧",
      u8"三极",
      u8"三极真空",
      u8"三极管",
      u8"三枝",
      u8"三架梁",
      u8"三株",
      u8"三样",
      u8"三根分叉部",
      u8"三格",
      u8"三桅帆船",
      u8"三桥",
      u8"三桥村",
      u8"三桩",
      u8"三棉",
      u8"三棱",
      u8"三棱锥",
      u8"三棱镜",
      u8"三棵",
      u8"三楼",
      u8"三楼住户",
      u8"三榜定案",
      u8"三槐九棘",
      u8"三次",
      u8"三次曲面",
      u8"三次采油",
      u8"三正",
      u8"三步",
      u8"三步两脚",
      u8"三步并作两步",
      u8"三段",
      u8"三段制",
      u8"三段式",
      u8"三段票",
      u8"三段论",
      u8"三段论法",
      u8"三毛",
      u8"三毛七孔",
      u8"三毛流浪记",
      u8"三民",
      u8"三民主义",
      u8"三民路",
      u8"三氧化氮",
      u8"三氧化物",
      u8"三氧化硫",
      u8"三氯乙烯",
      u8"三氯乙烷",
      u8"三氯乙醛",
      u8"三氯化碘",
      u8"三氯化铋",
      u8"三氯甲烷",
      u8"三水",
      u8"三水区",
      u8"三水县",
      u8"三水市",
      u8"三求四告",
      u8"三江",
      u8"三江七泽",
      u8"三江五湖",
      u8"三江侗族自治县",
      u8"三江口",
      u8"三汤两割",
      u8"三汤五割",
      u8"三沐三熏",
      u8"三沐三薰",
      u8"三河",
      u8"三河市",
      u8"三沿",
      u8"三法",
      u8"三波六折",
      u8"三洋",
      u8"三洞桥",
      u8"三流",
      u8"三流九等",
      u8"三浦友和",
      u8"三浴三衅",
      u8"三涂",
      u8"三清四白",
      u8"三清山",
      u8"三清殿",
      u8"三温暖",
      u8"三湖",
      u8"三潭印月",
      u8"三灾八难",
      u8"三灾六难",
      u8"三点",
      u8"三点一线",
      u8"三点式",
      u8"三点水",
      u8"三点钟",
      u8"三热爱",
      u8"三焦",
      u8"三焦俞",
      u8"三熏三沐",
      u8"三熟",
      u8"三熟制",
      u8"三爷",
      u8"三版",
      u8"三牲",
      u8"三牲五鼎",
      u8"三玄",
      u8"三环",
      u8"三环五扣",
      u8"三环路",
      u8"三班",
      u8"三班倒",
      u8"三班六房",
      u8"三班制",
      u8"三瓣",
      u8"三瓦两巷",
      u8"三瓦两舍",
      u8"三生",
      u8"三生有幸",
      u8"三生石",
      u8"三用喷枪",
      u8"三甲",
      u8"三申五令",
      u8"三电极电解池",
      u8"三界",
      u8"三略",
      u8"三番两次",
      u8"三番五次",
      u8"三番四复",
      u8"三番四次",
      u8"三病四痛",
      u8"三白草",
      u8"三百六十行",
      u8"三百瓮齑",
      u8"三皇",
      u8"三皇五帝",
      u8"三皈",
      u8"三盈三虚",
      u8"三盏",
      u8"三盒",
      u8"三盖沟村",
      u8"三相",
      u8"三相点",
      u8"三眼",
      u8"三硝基甲苯",
      u8"三碗",
      u8"三碘季酚胺",
      u8"三磷酸肌醇",
      u8"三礼",
      u8"三禁",
      u8"三秋",
      u8"三种",
      u8"三种记忆系统",
      u8"三科",
      u8"三秒",
      u8"三秒钟",
      u8"三秦",
      u8"三穗",
      u8"三穗县",
      u8"三窝两块",
      u8"三站",
      u8"三章",
      u8"三端网络",
      u8"三竿日上",
      u8"三等",
      u8"三等九格",
      u8"三等九般",
      u8"三等亲",
      u8"三等兵",
      u8"三等分",
      u8"三等功",
      u8"三等品",
      u8"三等奖",
      u8"三等舱",
      u8"三箱",
      u8"三米板",
      u8"三类",
      u8"三类判断",
      u8"三精",
      u8"三系杂种",
      u8"三级",
      u8"三级片",
      u8"三级管",
      u8"三级跳",
      u8"三级跳远",
      u8"三级预防",
      u8"三纲",
      u8"三纲五常",
      u8"三纸无驴",
      u8"三线",
      u8"三线工业",
      u8"三线建设",
      u8"三线放松",
      u8"三结合",
      u8"三统",
      u8"三维",
      u8"三维光栅",
      u8"三维动画",
      u8"三维县",
      u8"三维图",
      u8"三维图程序",
      u8"三维地带性",
      u8"三维地貌模型",
      u8"三维度理论",
      u8"三维模式",
      u8"三维空间",
      u8"三维重建",
      u8"三维集成电路",
      u8"三缄其口",
      u8"三缸",
      u8"三缸单作用泵",
      u8"三缺一",
      u8"三美",
      u8"三翻四复",
      u8"三翻四覆",
      u8"三老",
      u8"三老五更",
      u8"三老四严",
      u8"三老四少",
      u8"三者",
      u8"三联",
      u8"三联书店",
      u8"三联单",
      u8"三联式",
      u8"三联画",
      u8"三聚",
      u8"三聚体",
      u8"三聚磷酸钠",
      u8"三股",
      u8"三胎",
      u8"三胞胎",
      u8"三能",
      u8"三脚",
      u8"三脚两步",
      u8"三脚架",
      u8"三脚架种植体",
      u8"三脚猫",
      u8"三臂卡环",
      u8"三臡八菹",
      u8"三自",
      u8"三自一包",
      u8"三般两样",
      u8"三色",
      u8"三色堇",
      u8"三色版",
      u8"三色笔",
      u8"三色苋",
      u8"三节",
      u8"三节两寿",
      u8"三节课",
      u8"三节鞭",
      u8"三芝",
      u8"三花接骨散",
      u8"三花脸",
      u8"三茶六礼",
      u8"三茶六饭",
      u8"三荣",
      u8"三荤五厌",
      u8"三菱",
      u8"三萜类",
      u8"三落实",
      u8"三薰三沐",
      u8"三藏",
      u8"三藩市",
      u8"三蛇七鼠",
      u8"三衅三浴",
      u8"三行",
      u8"三街",
      u8"三街两市",
      u8"三街六巷",
      u8"三街六市",
      u8"三袋",
      u8"三西",
      u8"三要素",
      u8"三视图",
      u8"三角",
      u8"三角债",
      u8"三角函数",
      u8"三角叶杨",
      u8"三角回归",
      u8"三角地",
      u8"三角型",
      u8"三角墙",
      u8"三角学",
      u8"三角尺",
      u8"三角嵴",
      u8"三角帆",
      u8"三角形",
      u8"三角形接法",
      u8"三角恋",
      u8"三角恋爱",
      u8"三角方程",
      u8"三角旗",
      u8"三角杂化",
      u8"三角村",
      u8"三角板",
      u8"三角枫",
      u8"三角架",
      u8"三角梅",
      u8"三角洲",
      u8"三角测量",
      u8"三角瓶",
      u8"三角皮带",
      u8"三角肌",
      u8"三角裤",
      u8"三角钢琴",
      u8"三角钱",
      u8"三角铁",
      u8"三言两句",
      u8"三言两语",
      u8"三言讹虎",
      u8"三讲",
      u8"三讲两思",
      u8"三讲教育",
      u8"三证",
      u8"三评一考",
      u8"三请四唤",
      u8"三读",
      u8"三读会",
      u8"三读通过",
      u8"三课",
      u8"三谏之义",
      u8"三豕涉河",
      u8"三贞九烈",
      u8"三贞五烈",
      u8"三贤人",
      u8"三贤祠",
      u8"三资",
      u8"三资企业",
      u8"三走",
      u8"三起三落",
      u8"三足鼎立",
      u8"三距交汇",
      u8"三跪九叩",
      u8"三路",
      u8"三路狂奔",
      u8"三轮",
      u8"三轮儿",
      u8"三轮式",
      u8"三轮车",
      u8"三轮车夫",
      u8"三轻",
      u8"三边",
      u8"三边形",
      u8"三达德",
      u8"三迁之教",
      u8"三过其门而不入",
      u8"三连",
      u8"三连冠",
      u8"三连音",
      u8"三迭阳关",
      u8"三通",
      u8"三通一平",
      u8"三通阀",
      u8"三速链轮",
      u8"三遍",
      u8"三邀四请",
      u8"三邻四舍",
      u8"三部",
      u8"三部合唱",
      u8"三部曲",
      u8"三都",
      u8"三都水族自治县",
      u8"三里屯",
      u8"三里河",
      u8"三重",
      u8"三重人",
      u8"三重人格",
      u8"三重唱",
      u8"三重奏",
      u8"三重市",
      u8"三重态",
      u8"三重门",
      u8"三野",
      u8"三金",
      u8"三针",
      u8"三钢",
      u8"三钱",
      u8"三锅",
      u8"三镇",
      u8"三长两短",
      u8"三长制",
      u8"三长四短",
      u8"三门",
      u8"三门县",
      u8"三门四户",
      u8"三门峡",
      u8"三门峡市",
      u8"三间",
      u8"三闾大夫",
      u8"三队",
      u8"三防训练",
      u8"三阳",
      u8"三阳交泰",
      u8"三阳开泰",
      u8"三阳络",
      u8"三阴交",
      u8"三阵",
      u8"三阶",
      u8"三陪",
      u8"三陪女",
      u8"三集",
      u8"三青团",
      u8"三面",
      u8"三面亚当",
      u8"三面体",
      u8"三面夏娃",
      u8"三面红旗",
      u8"三页",
      u8"三项",
      u8"三项基本原则",
      u8"三项式",
      u8"三项教育",
      u8"三项方程",
      u8"三顾",
      u8"三顾之请",
      u8"三顾茅庐",
      u8"三顾茅芦",
      u8"三顾草庐",
      u8"三频",
      u8"三颗",
      u8"三颗针",
      u8"三风",
      u8"三风十愆",
      u8"三餐",
      u8"三餐不继",
      u8"三饥两饱",
      u8"三首六臂",
      u8"三马同槽",
      u8"三高",
      u8"三高农业",
      u8"三魂七魄",
      u8"三魂出窍",
      u8"三鲜",
      u8"三鲜汤",
      u8"三麦",
      u8"上一个",
      u8"上一代",
      u8"上一级",
      u8"上一阶段",
      u8"上万",
      u8"上三路",
      u8"上上下下",
      u8"上上个月",
      u8"上上之策",
      u8"上上大吉",
      u8"上上星期",
      u8"上下",
      u8"上下一心",
      u8"上下一致",
      u8"上下交困",
      u8"上下交征",
      u8"上下交流",
      u8"上下位",
      u8"上下其手",
      u8"上下册",
      u8"上下午",
      u8"上下半场",
      u8"上下同心",
      u8"上下同欲",
      u8"上下同门",
      u8"上下学",
      u8"上下左右",
      u8"上下床",
      u8"上下文",
      u8"上下文切换",
      u8"上下文外关键字",
      u8"上下文效应",
      u8"上下文有关语言",
      u8"上下水",
      u8"上下游",
      u8"上下班",
      u8"上下级",
      u8"上下级一致",
      u8"上下级之间",
      u8"上下结合",
      u8"上下议院",
      u8"上下调整",
      u8"上下跳动",
      u8"上下车",
      u8"上下颠倒",
      u8"上下齐心",
      u8"上不上",
      u8"上不去",
      u8"上不来",
      u8"上不着天",
      u8"上不着天下不着地",
      u8"上不起",
      u8"上世",
      u8"上世纪",
      u8"上个",
      u8"上个世纪",
      u8"上个季度",
      u8"上个星期",
      u8"上个月",
      u8"上中下",
      u8"上中农",
      u8"上中游",
      u8"上举",
      u8"上乘",
      u8"上乘之作",
      u8"上书",
      u8"上了",
      u8"上交",
      u8"上交不谄",
      u8"上交利润",
      u8"上交所",
      u8"上京",
      u8"上人",
      u8"上亿",
      u8"上代",
      u8"上任",
      u8"上会",
      u8"上传",
      u8"上传下载",
      u8"上传下达",
      u8"上传区",
      u8"上传完毕",
      u8"上传者",
      u8"上位",
      u8"上体",
      u8"上佳",
      u8"上例",
      u8"上供",
      u8"上元",
      u8"上元节",
      u8"上光",
      u8"上光机",
      u8"上党",
      u8"上党梆子",
      u8"上关",
      u8"上兵",
      u8"上兵伐谋",
      u8"上册",
      u8"上冒头",
      u8"上农",
      u8"上冲",
      u8"上冻",
      u8"上刀山",
      u8"上刑",
      u8"上划",
      u8"上列",
      u8"上到",
      u8"上前",
      u8"上前去",
      u8"上前来",
      u8"上劲",
      u8"上勤",
      u8"上勤下顺",
      u8"上区",
      u8"上医医国",
      u8"上医院",
      u8"上匾",
      u8"上千",
      u8"上千人",
      u8"上升",
      u8"上升幅度",
      u8"上升时间",
      u8"上升期",
      u8"上升段",
      u8"上升股",
      u8"上升限度",
      u8"上午",
      u8"上半",
      u8"上半叶",
      u8"上半场",
      u8"上半夜",
      u8"上半天",
      u8"上半年",
      u8"上半时",
      u8"上半晌",
      u8"上半期",
      u8"上半身",
      u8"上半部",
      u8"上南落北",
      u8"上卷",
      u8"上压力",
      u8"上厕所",
      u8"上原",
      u8"上去",
      u8"上发条",
      u8"上变",
      u8"上变频",
      u8"上口",
      u8"上古",
      u8"上古史",
      u8"上古时代",
      u8"上台",
      u8"上台演唱",
      u8"上台演奏",
      u8"上台演讲",
      u8"上台阶",
      u8"上叶",
      u8"上司",
      u8"上吊",
      u8"上吊自杀",
      u8"上同调平凡模",
      u8"上同调群",
      u8"上吐下泻",
      u8"上告",
      u8"上告信",
      u8"上周",
      u8"上呼吸道",
      u8"上和下睦",
      u8"上品",
      u8"上唇线",
      u8"上善若水",
      u8"上回",
      u8"上国",
      u8"上国村",
      u8"上图",
      u8"上圈",
      u8"上地",
      u8"上场",
      u8"上场门",
      u8"上坐",
      u8"上坟",
      u8"上坡",
      u8"上坡路",
      u8"上坡道",
      u8"上坪",
      u8"上垒",
      u8"上城区",
      u8"上堂",
      u8"上士",
      u8"上声",
      u8"上夜",
      u8"上大学",
      u8"上天",
      u8"上天入地",
      u8"上天堂",
      u8"上天无路",
      u8"上天无路入地无门",
      u8"上头",
      u8"上奏",
      u8"上套",
      u8"上套儿",
      u8"上好",
      u8"上好下甚",
      u8"上好佳",
      u8"上嫚下暴",
      u8"上季",
      u8"上学",
      u8"上学时",
      u8"上学校",
      u8"上官",
      u8"上官云",
      u8"上官云珠",
      u8"上官婉儿",
      u8"上官毅山",
      u8"上官灵凤",
      u8"上官燕",
      u8"上官虹",
      u8"上官铁生",
      u8"上官鼎",
      u8"上客",
      u8"上家",
      u8"上宾",
      u8"上将",
      u8"上将军官",
      u8"上尉",
      u8"上尉军官",
      u8"上层",
      u8"上层建筑",
      u8"上层社会",
      u8"上层组织",
      u8"上屈",
      u8"上届",
      u8"上屏",
      u8"上属",
      u8"上山",
      u8"上山下乡",
      u8"上山下海",
      u8"上岁数",
      u8"上岗",
      u8"上岗证",
      u8"上岛",
      u8"上岸",
      u8"上岸时",
      u8"上峰",
      u8"上工",
      u8"上巨虚",
      u8"上市",
      u8"上市公司",
      u8"上市户",
      u8"上帐",
      u8"上帖",
      u8"上帝",
      u8"上帝保佑",
      u8"上帝教",
      u8"上席",
      u8"上年",
      u8"上年纪",
      u8"上广电",
      u8"上床",
      u8"上床睡觉",
      u8"上座",
      u8"上座儿",
      u8"上座率",
      u8"上廉",
      u8"上式",
      u8"上弦",
      u8"上弦月",
      u8"上弹",
      u8"上当",
      u8"上当了",
      u8"上当受骗",
      u8"上当学乖",
      u8"上影",
      u8"上影线",
      u8"上得",
      u8"上得起",
      u8"上心",
      u8"上思",
      u8"上思县",
      u8"上情下达",
      u8"上意识",
      u8"上慢下暴",
      u8"上成",
      u8"上战",
      u8"上战场",
      u8"上房",
      u8"上手",
      u8"上托",
      u8"上扬",
      u8"上批",
      u8"上报",
      u8"上报纸",
      u8"上排",
      u8"上接",
      u8"上接第一版",
      u8"上控制限",
      u8"上推下卸",
      u8"上援下推",
      u8"上摊",
      u8"上摸",
      u8"上操",
      u8"上文",
      u8"上方",
      u8"上方不足",
      u8"上方不足下比有余",
      u8"上方剑",
      u8"上方宝剑",
      u8"上方山",
      u8"上旋",
      u8"上无片瓦",
      u8"上无片瓦下无卓锥",
      u8"上无片瓦下无插针之地",
      u8"上无片瓦下无立锥之地",
      u8"上日",
      u8"上旬",
      u8"上昆",
      u8"上明",
      u8"上星期",
      u8"上映",
      u8"上映期间",
      u8"上晃",
      u8"上智",
      u8"上智下愚",
      u8"上替下陵",
      u8"上月",
      u8"上月份",
      u8"上有",
      u8"上有天堂",
      u8"上有所好",
      u8"上有老下有小",
      u8"上朝",
      u8"上期",
      u8"上机",
      u8"上机操作",
      u8"上机时间",
      u8"上杉",
      u8"上李",
      u8"上条",
      u8"上来",
      u8"上来到",
      u8"上杭",
      u8"上杭县",
      u8"上极限函数",
      u8"上林",
      u8"上林县",
      u8"上林苑",
      u8"上标",
      u8"上栏",
      u8"上树",
      u8"上树拔梯",
      u8"上栗县",
      u8"上校",
      u8"上校军官",
      u8"上根大器",
      u8"上格",
      u8"上桅",
      u8"上框",
      u8"上桌",
      u8"上档",
      u8"上档次",
      u8"上梁",
      u8"上梁不正",
      u8"上梁不正下梁歪",
      u8"上梅洲村",
      u8"上楼",
      u8"上楼去",
      u8"上楼去梯",
      u8"上楼来",
      u8"上榜",
      u8"上榜名单",
      u8"上檐",
      u8"上次",
      u8"上款",
      u8"上段",
      u8"上气不接",
      u8"上气不接下气",
      u8"上水",
      u8"上水船",
      u8"上水道",
      u8"上汤",
      u8"上汽",
      u8"上沃尔特",
      u8"上油",
      u8"上流",
      u8"上流人士",
      u8"上流社会",
      u8"上浆",
      u8"上浆翻领",
      u8"上浮",
      u8"上海",
      u8"上海中药医大学",
      u8"上海书店",
      u8"上海交大",
      u8"上海人",
      u8"上海人民出版社",
      u8"上海卷",
      u8"上海古籍出版社",
      u8"上海大众",
      u8"上海市",
      u8"上海市长途电信局",
      u8"上海浦东",
      u8"上海港",
      u8"上海滩",
      u8"上海热线",
      u8"上海街",
      u8"上海话",
      u8"上海铁路局",
      u8"上海铁道大学",
      u8"上涨",
      u8"上涨幅度",
      u8"上涨率",
      u8"上清",
      u8"上渡",
      u8"上港村",
      u8"上游",
      u8"上游工业",
      u8"上游相对渗透率",
      u8"上湖村",
      u8"上溢",
      u8"上溢下漏",
      u8"上溯",
      u8"上滔下骄",
      u8"上漆",
      u8"上漏下湿",
      u8"上演",
      u8"上演税",
      u8"上潮",
      u8"上火",
      u8"上灯",
      u8"上点",
      u8"上烝下报",
      u8"上焦",
      u8"上照",
      u8"上片",
      u8"上片时间",
      u8"上牌",
      u8"上牙膛",
      u8"上犹",
      u8"上犹县",
      u8"上环",
      u8"上班",
      u8"上班族",
      u8"上班时间",
      u8"上班服",
      u8"上甘岭",
      u8"上甘岭区",
      u8"上甲板",
      u8"上画",
      u8"上界",
      u8"上略",
      u8"上瘾",
      u8"上百",
      u8"上百人",
      u8"上皮",
      u8"上皮根鞘",
      u8"上皮珠",
      u8"上皮组织",
      u8"上皮细胞",
      u8"上皮附着",
      u8"上盘",
      u8"上相",
      u8"上真",
      u8"上眼",
      u8"上眼皮",
      u8"上着",
      u8"上知",
      u8"上石",
      u8"上礼",
      u8"上税",
      u8"上穷碧落下黄泉",
      u8"上空",
      u8"上空装",
      u8"上窜下跳",
      u8"上站",
      u8"上章",
      u8"上端",
      u8"上竿掇梯",
      u8"上第",
      u8"上等",
      u8"上等兵",
      u8"上等品",
      u8"上等货",
      u8"上策",
      u8"上签",
      u8"上算",
      u8"上篇",
      u8"上篇上论",
      u8"上篮",
      u8"上篮得分",
      u8"上簇",
      u8"上粪",
      u8"上紧",
      u8"上级",
      u8"上级业务部门",
      u8"上级指示",
      u8"上级检察机关",
      u8"上级检察院",
      u8"上级法院",
      u8"上级菜单",
      u8"上级部门",
      u8"上级院",
      u8"上级领导",
      u8"上纲",
      u8"上纲上线",
      u8"上线",
      u8"上缘",
      u8"上缴",
      u8"上缴利润",
      u8"上缴国库",
      u8"上网",
      u8"上网冲浪",
      u8"上网费",
      u8"上翘",
      u8"上翻门",
      u8"上联",
      u8"上肉",
      u8"上肢",
      u8"上肢骨",
      u8"上肥",
      u8"上胶塞",
      u8"上脘",
      u8"上脸",
      u8"上膘",
      u8"上膛",
      u8"上臂",
      u8"上臂骨",
      u8"上自",
      u8"上至",
      u8"上船",
      u8"上色",
      u8"上节",
      u8"上节育环",
      u8"上苍",
      u8"上茶",
      u8"上药",
      u8"上药膏",
      u8"上菜",
      u8"上蒸下报",
      u8"上蔡",
      u8"上蔡县",
      u8"上藏马村",
      u8"上虞",
      u8"上虞县",
      u8"上虞市",
      u8"上蜡",
      u8"上行",
      u8"上行下效",
      u8"上行下给式",
      u8"上行列车",
      u8"上行波",
      u8"上街",
      u8"上街区",
      u8"上衣",
      u8"上衣翻领",
      u8"上表",
      u8"上装",
      u8"上西天",
      u8"上覆岩层压力",
      u8"上规模",
      u8"上角",
      u8"上解",
      u8"上言",
      u8"上计",
      u8"上议院",
      u8"上访",
      u8"上访事件",
      u8"上访户",
      u8"上访者",
      u8"上证",
      u8"上证所",
      u8"上证指数",
      u8"上证综指",
      u8"上诉",
      u8"上诉书",
      u8"上诉人",
      u8"上诉期",
      u8"上诉状",
      u8"上说",
      u8"上课",
      u8"上课时",
      u8"上课时数",
      u8"上课证",
      u8"上调",
      u8"上调和函数",
      u8"上谄下渎",
      u8"上谕",
      u8"上账",
      u8"上货",
      u8"上起",
      u8"上起来",
      u8"上超",
      u8"上路",
      u8"上蹿下跳",
      u8"上身",
      u8"上车",
      u8"上车时",
      u8"上轨",
      u8"上轨道",
      u8"上载",
      u8"上轿",
      u8"上辈",
      u8"上辈子",
      u8"上边",
      u8"上边带",
      u8"上边缘",
      u8"上边缘算子",
      u8"上达",
      u8"上过",
      u8"上进",
      u8"上进心",
      u8"上述",
      u8"上述事实",
      u8"上述事实清楚",
      u8"上述情况",
      u8"上述犯罪事实清楚",
      u8"上述问题",
      u8"上选",
      u8"上道",
      u8"上邦",
      u8"上部",
      u8"上部驱动装置",
      u8"上酒家",
      u8"上釉",
      u8"上野",
      u8"上野未来",
      u8"上金",
      u8"上金枋",
      u8"上钢",
      u8"上钩",
      u8"上银幕",
      u8"上铺",
      u8"上锁",
      u8"上错",
      u8"上错天堂投错胎",
      u8"上镜",
      u8"上镜头",
      u8"上镜率",
      u8"上门",
      u8"上门去",
      u8"上门服务",
      u8"上门来",
      u8"上闩",
      u8"上闻下达",
      u8"上阙",
      u8"上阵",
      u8"上阵不离父子兵",
      u8"上阵父子兵",
      u8"上限",
      u8"上院",
      u8"上陵下替",
      u8"上集",
      u8"上雨旁风",
      u8"上面",
      u8"上鞋",
      u8"上页",
      u8"上项",
      u8"上颌",
      u8"上颌中切牙牙槽嵴顶点",
      u8"上颌体",
      u8"上颌侧位体层片",
      u8"上颌前突",
      u8"上颌前部截骨术",
      u8"上颌后前体层片",
      u8"上颌后缩",
      u8"上颌牙",
      u8"上颌牙槽座点",
      u8"上颌结节成形术",
      u8"上颌结节注射法",
      u8"上颔骨",
      u8"上颚",
      u8"上颚骨",
      u8"上额",
      u8"上风",
      u8"上飞机",
      u8"上饶",
      u8"上饶县",
      u8"上饶市",
      u8"上馆子",
      u8"上首",
      u8"上香",
      u8"上马",
      u8"上驷",
      u8"上驷之材",
      u8"上髎",
      u8"上高",
      u8"上高县",
      u8"下一",
      u8"下一个",
      u8"下一代",
      u8"下一场",
      u8"下一层",
      u8"下一次",
      u8"下一步",
      u8"下一版",
      u8"下一辈",
      u8"下一阶段",
      u8"下三烂",
      u8"下三路",
      u8"下下",
      u8"下下个月",
      u8"下下之策",
      u8"下下星期",
      u8"下下策",
      u8"下下签",
      u8"下不",
      u8"下不为例",
      u8"下不了台",
      u8"下不去",
      u8"下不来",
      u8"下不来台",
      u8"下不着地",
      u8"下世",
      u8"下世纪初",
      u8"下丘脑",
      u8"下个",
      u8"下个世纪",
      u8"下个季度",
      u8"下个星期",
      u8"下个月",
      u8"下中农",
      u8"下为",
      u8"下乔入幽",
      u8"下乔木入幽谷",
      u8"下乔迁谷",
      u8"下乘",
      u8"下乘之才",
      u8"下九当堤村",
      u8"下九流",
      u8"下乡",
      u8"下书",
      u8"下了",
      u8"下井",
      u8"下井投石",
      u8"下人",
      u8"下代",
      u8"下令",
      u8"下任",
      u8"下任总统",
      u8"下传",
      u8"下位",
      u8"下体",
      u8"下余",
      u8"下作",
      u8"下例",
      u8"下侧",
      u8"下倾",
      u8"下元",
      u8"下光",
      u8"下关",
      u8"下关区",
      u8"下册",
      u8"下冒头",
      u8"下冲",
      u8"下冲断层",
      u8"下决心",
      u8"下凡",
      u8"下出",
      u8"下刀",
      u8"下切侵蚀",
      u8"下划",
      u8"下划线",
      u8"下列",
      u8"下到",
      u8"下剩",
      u8"下力",
      u8"下功夫",
      u8"下劲",
      u8"下勺",
      u8"下区",
      u8"下午",
      u8"下午茶",
      u8"下半",
      u8"下半场",
      u8"下半夜",
      u8"下半天",
      u8"下半年",
      u8"下半旗",
      u8"下半时",
      u8"下半晌",
      u8"下半月",
      u8"下半身",
      u8"下半身文学",
      u8"下单",
      u8"下卷",
      u8"下厂",
      u8"下压",
      u8"下压力",
      u8"下厨",
      u8"下厨房",
      u8"下去",
      u8"下去了",
      u8"下发",
      u8"下发文件",
      u8"下叔村",
      u8"下变频",
      u8"下口",
      u8"下句",
      u8"下句话",
      u8"下召",
      u8"下台",
      u8"下台一鞠躬",
      u8"下台阶",
      u8"下叶",
      u8"下合穴",
      u8"下同",
      u8"下吴村",
      u8"下周",
      u8"下和村",
      u8"下咽",
      u8"下品",
      u8"下唇",
      u8"下唇线",
      u8"下喙",
      u8"下回",
      u8"下回分解",
      u8"下围棋",
      u8"下图",
      u8"下土",
      u8"下在",
      u8"下地",
      u8"下地干活",
      u8"下地无门",
      u8"下场",
      u8"下场比赛",
      u8"下场门",
      u8"下坂走丸",
      u8"下坠",
      u8"下坠球",
      u8"下坡",
      u8"下坡路",
      u8"下垂",
      u8"下城区",
      u8"下基层",
      u8"下堂",
      u8"下堕",
      u8"下塘村",
      u8"下塞上聋",
      u8"下士",
      u8"下处",
      u8"下大力",
      u8"下大力气",
      u8"下大工夫",
      u8"下大本钱",
      u8"下头",
      u8"下女",
      u8"下奶",
      u8"下好",
      u8"下嫁",
      u8"下子",
      u8"下存",
      u8"下季",
      u8"下学",
      u8"下学上达",
      u8"下学时",
      u8"下学期",
      u8"下完",
      u8"下官",
      u8"下定",
      u8"下定义",
      u8"下定决心",
      u8"下家",
      u8"下寨村",
      u8"下小河村",
      u8"下层",
      u8"下层社会",
      u8"下层组织",
      u8"下届",
      u8"下属",
      u8"下属单位",
      u8"下屯乡",
      u8"下山",
      u8"下岗",
      u8"下岗人员",
      u8"下岗女工",
      u8"下岗工人",
      u8"下岗职工",
      u8"下工",
      u8"下工夫",
      u8"下差别阈",
      u8"下巴",
      u8"下巴颊",
      u8"下巴颏",
      u8"下巴颏儿",
      u8"下巴颗",
      u8"下市",
      u8"下帖",
      u8"下帖子",
      u8"下年",
      u8"下年度",
      u8"下床",
      u8"下底",
      u8"下底传中",
      u8"下店",
      u8"下座",
      u8"下式",
      u8"下弦",
      u8"下弦月",
      u8"下影线",
      u8"下得",
      u8"下怀",
      u8"下悬窗",
      u8"下情",
      u8"下情上达",
      u8"下意识",
      u8"下愚",
      u8"下愚不移",
      u8"下成",
      u8"下战书",
      u8"下户",
      u8"下房",
      u8"下手",
      u8"下手尝试",
      u8"下拉",
      u8"下拉框",
      u8"下拉箭头",
      u8"下拉菜单",
      u8"下拜",
      u8"下拨",
      u8"下挫",
      u8"下排",
      u8"下探",
      u8"下接",
      u8"下推",
      u8"下推式存储器",
      u8"下推自动机",
      u8"下推队列",
      u8"下摆",
      u8"下操",
      u8"下放",
      u8"下放干部",
      u8"下放知青",
      u8"下文",
      u8"下料",
      u8"下断语",
      u8"下方",
      u8"下旋",
      u8"下无插针之地",
      u8"下无立锥之地",
      u8"下旬",
      u8"下星期",
      u8"下晚儿",
      u8"下月",
      u8"下有",
      u8"下有苏杭",
      u8"下朝",
      u8"下期",
      u8"下木",
      u8"下机",
      u8"下条子",
      u8"下来",
      u8"下来到",
      u8"下极限",
      u8"下枋",
      u8"下柬",
      u8"下标",
      u8"下树",
      u8"下格",
      u8"下框",
      u8"下档",
      u8"下桥",
      u8"下棋",
      u8"下楼",
      u8"下楼去",
      u8"下楼来",
      u8"下楼梯",
      u8"下榻",
      u8"下榻留宾",
      u8"下欠",
      u8"下次",
      u8"下款",
      u8"下步",
      u8"下段",
      u8"下毒",
      u8"下毒手",
      u8"下比有余",
      u8"下民",
      u8"下气",
      u8"下气怡声",
      u8"下气怡色",
      u8"下水",
      u8"下水典礼",
      u8"下水礼",
      u8"下水船",
      u8"下水道",
      u8"下江",
      u8"下汤镇",
      u8"下沉",
      u8"下河",
      u8"下油",
      u8"下泄",
      u8"下法",
      u8"下注",
      u8"下泻",
      u8"下派",
      u8"下流",
      u8"下流人士",
      u8"下流坯",
      u8"下流无耻",
      u8"下流社会",
      u8"下流话",
      u8"下浮",
      u8"下海",
      u8"下海经商",
      u8"下港",
      u8"下游",
      u8"下游工业",
      u8"下滑",
      u8"下潮",
      u8"下炕",
      u8"下片",
      u8"下片时",
      u8"下片时间",
      u8"下牙",
      u8"下狠心",
      u8"下狱",
      u8"下班",
      u8"下班时间",
      u8"下生",
      u8"下田",
      u8"下甲板",
      u8"下界",
      u8"下略",
      u8"下疳",
      u8"下痢",
      u8"下痿",
      u8"下盘",
      u8"下直",
      u8"下相",
      u8"下相微乳",
      u8"下眼皮",
      u8"下眼睑",
      u8"下着",
      u8"下着雨",
      u8"下着雪",
      u8"下矿",
      u8"下碗",
      u8"下礼",
      u8"下礼拜",
      u8"下种",
      u8"下移",
      u8"下站",
      u8"下章",
      u8"下端",
      u8"下笔",
      u8"下笔千言",
      u8"下笔千言离题万里",
      u8"下笔如有神",
      u8"下笔如神",
      u8"下笔成文",
      u8"下笔成章",
      u8"下笔成篇",
      u8"下笔有神",
      u8"下第",
      u8"下等",
      u8"下等货",
      u8"下策",
      u8"下签",
      u8"下管",
      u8"下箸",
      u8"下篇",
      u8"下级",
      u8"下级单位",
      u8"下级服从上级",
      u8"下级机关",
      u8"下级生",
      u8"下级组织",
      u8"下级职员",
      u8"下级菜单",
      u8"下线",
      u8"下结论",
      u8"下缘",
      u8"下网",
      u8"下联",
      u8"下聘",
      u8"下肉",
      u8"下肚",
      u8"下肢",
      u8"下肢骨",
      u8"下脘",
      u8"下脚",
      u8"下脚料",
      u8"下脚货",
      u8"下脣",
      u8"下腹",
      u8"下腹部",
      u8"下膊",
      u8"下臂护甲",
      u8"下臣",
      u8"下自",
      u8"下自成蹊",
      u8"下至",
      u8"下船",
      u8"下花园",
      u8"下花园区",
      u8"下花桥镇",
      u8"下苦功",
      u8"下苦功夫",
      u8"下药",
      u8"下菜",
      u8"下萨克森州",
      u8"下落",
      u8"下落不明",
      u8"下葬",
      u8"下蛋",
      u8"下行",
      u8"下行列车",
      u8"下行展开法",
      u8"下行测井",
      u8"下表",
      u8"下袅",
      u8"下装",
      u8"下襬",
      u8"下角",
      u8"下议院",
      u8"下设",
      u8"下诏",
      u8"下诹访市",
      u8"下课",
      u8"下课后",
      u8"下课时",
      u8"下课时间",
      u8"下调",
      u8"下调和解",
      u8"下象棋",
      u8"下账",
      u8"下贱",
      u8"下走",
      u8"下起",
      u8"下起来",
      u8"下跌",
      u8"下跌股",
      u8"下跪",
      u8"下蹲",
      u8"下身",
      u8"下车",
      u8"下车之始",
      u8"下车伊始",
      u8"下车作威",
      u8"下车时",
      u8"下车泣罪",
      u8"下载",
      u8"下载不能",
      u8"下载区",
      u8"下载安装",
      u8"下载工具",
      u8"下载方式",
      u8"下载点",
      u8"下载版",
      u8"下载狂",
      u8"下载站",
      u8"下载者",
      u8"下载量",
      u8"下载页",
      u8"下轿",
      u8"下辈",
      u8"下辈子",
      u8"下辖",
      u8"下边",
      u8"下边带",
      u8"下达",
      u8"下达任务",
      u8"下达指示",
      u8"下达通知",
      u8"下过",
      u8"下述",
      u8"下逐客令",
      u8"下遂客令",
      u8"下遣",
      u8"下部",
      u8"下部结构",
      u8"下酒",
      u8"下里巴人",
      u8"下野",
      u8"下钓",
      u8"下钻",
      u8"下铺",
      u8"下锅",
      u8"下键",
      u8"下门",
      u8"下问",
      u8"下阕",
      u8"下阙",
      u8"下阪走丸",
      u8"下附",
      u8"下陆区",
      u8"下降",
      u8"下降时间",
      u8"下降段",
      u8"下限",
      u8"下院",
      u8"下陵上替",
      u8"下陷",
      u8"下集",
      u8"下雨",
      u8"下雨天",
      u8"下雪",
      u8"下雪量",
      u8"下雹",
      u8"下雾",
      u8"下霜",
      u8"下面",
      u8"下页",
      u8"下顿",
      u8"下颌",
      u8"下颌下间隙",
      u8"下颌中切牙切缘点",
      u8"下颌中切牙牙槽嵴顶点",
      u8"下颌位",
      u8"下颌体",
      u8"下颌切迹",
      u8"下颌前突",
      u8"下颌升支侧位体层片",
      u8"下颌升支内侧隆突阻滞麻醉",
      u8"下颌升支切线位投照术",
      u8"下颌后缩",
      u8"下颌息止位",
      u8"下颌支截骨术",
      u8"下颌支支架种植体",
      u8"下颌正中囊肿",
      u8"下颌牙",
      u8"下颌牙槽座点",
      u8"下颌神经阻滞麻醉",
      u8"下颌角点",
      u8"下颌运动",
      u8"下颌运动复制器",
      u8"下颌运动描记仪",
      u8"下颌隆凸",
      u8"下颌骨侧位投照术",
      u8"下颌骨后前位投照术",
      u8"下颌骨颜面发育不全",
      u8"下颌髁突切除术",
      u8"下颔",
      u8"下颚",
      u8"下颚骨",
      u8"下额",
      u8"下风",
      u8"下飞机",
      u8"下饭",
      u8"下馆子",
      u8"下首",
      u8"下马",
      u8"下马冯妇",
      u8"下马威",
      u8"下马村",
      u8"下马看花",
      u8"下马观花",
      u8"下驷",
      u8"下髎",
      u8"下龙湾",
      u8"不一",
      u8"不一会",
      u8"不一会儿",
      u8"不一定",
      u8"不一枚举",
      u8"不一样",
      u8"不一而足",
      u8"不一致",
      u8"不一致性",
      u8"不一般",
      u8"不三不四",
      u8"不上不下",
      u8"不上不落",
      u8"不上去",
      u8"不上来",
      u8"不上网",
      u8"不上道",
      u8"不下",
      u8"不下于",
      u8"不下去",
      u8"不下来",
      u8"不下雨",
      u8"不与",
      u8"不世之业",
      u8"不世之功",
      u8"不世之材",
      u8"不世出",
      u8"不世奇勋",
      u8"不严",
      u8"不中",
      u8"不中不西",
      u8"不中意",
      u8"不中用",
      u8"不丰不俭",
      u8"不丰不杀",
      u8"不丹",
      u8"不为",
      u8"不为五斗米折腰",
      u8"不为人知",
      u8"不为已甚",
      u8"不为所动",
      u8"不为牛后",
      u8"不为瓦全",
      u8"不为过",
      u8"不主故常",
      u8"不举",
      u8"不久",
      u8"不久以后",
      u8"不久前",
      u8"不义",
      u8"不义之财",
      u8"不乏",
      u8"不乏先例",
      u8"不乏其人",
      u8"不乏其例",
      u8"不乐",
      u8"不乐于",
      u8"不乐意",
      u8"不习地土",
      u8"不习惯",
      u8"不习水土",
      u8"不买",
      u8"不买账",
      u8"不乱",
      u8"不了",
      u8"不了不当",
      u8"不了了之",
      u8"不了情",
      u8"不了而了",
      u8"不了解",
      u8"不予",
      u8"不予承认",
      u8"不予理睬",
      u8"不予置评",
      u8"不予考虑",
      u8"不予认定",
      u8"不争",
      u8"不争气",
      u8"不事边幅",
      u8"不二",
      u8"不二价",
      u8"不二法门",
      u8"不亚于",
      u8"不亢不卑",
      u8"不交",
      u8"不亦",
      u8"不亦乐乎",
      u8"不亦善夫",
      u8"不产小麦",
      u8"不产气菌",
      u8"不亮也光",
      u8"不人道",
      u8"不什",
      u8"不仁",
      u8"不仁不义",
      u8"不仁慈",
      u8"不仅",
      u8"不仅仅",
      u8"不仅仅在于",
      u8"不仅仅如此",
      u8"不仅仅是",
      u8"不仅如此",
      u8"不仅是",
      u8"不今不古",
      u8"不介意",
      u8"不从",
      u8"不以",
      u8"不以一眚掩大德",
      u8"不以为奇",
      u8"不以为意",
      u8"不以为然",
      u8"不以为耻",
      u8"不以规矩",
      u8"不以规矩不成方圆",
      u8"不以规矩不能成方圆",
      u8"不以辞害志",
      u8"不伏烧埋",
      u8"不休",
      u8"不会",
      u8"不会不",
      u8"不会儿",
      u8"不会吧",
      u8"不会在",
      u8"不会弄错",
      u8"不会得",
      u8"不会是",
      u8"不会有",
      u8"不会用",
      u8"不会错",
      u8"不传之密",
      u8"不伤",
      u8"不伤和气",
      u8"不伤脾胃",
      u8"不伦不类",
      u8"不似",
      u8"不但",
      u8"不但如此",
      u8"不但是",
      u8"不低",
      u8"不低于",
      u8"不住",
      u8"不体面",
      u8"不体面地",
      u8"不作",
      u8"不作为",
      u8"不作兴",
      u8"不作声",
      u8"不作数",
      u8"不作第二",
      u8"不作第二人想",
      u8"不作美",
      u8"不佞",
      u8"不佳",
      u8"不使",
      u8"不使它",
      u8"不使用武力",
      u8"不依",
      u8"不依不饶",
      u8"不依赖",
      u8"不便",
      u8"不便水土",
      u8"不俗",
      u8"不保",
      u8"不保密",
      u8"不信",
      u8"不信任",
      u8"不信任感",
      u8"不信任投票",
      u8"不信任案",
      u8"不信邪",
      u8"不俭省",
      u8"不修",
      u8"不修小节",
      u8"不修边幅",
      u8"不倒",
      u8"不倒翁",
      u8"不借",
      u8"不倦",
      u8"不值",
      u8"不值一提",
      u8"不值一文",
      u8"不值一看",
      u8"不值一笑",
      u8"不值一钱",
      u8"不值一顾",
      u8"不值一驳",
      u8"不值得",
      u8"不值得一提",
      u8"不值钱",
      u8"不假",
      u8"不假外出",
      u8"不假思索",
      u8"不偏",
      u8"不偏不倚",
      u8"不偏不党",
      u8"不做",
      u8"不做不休",
      u8"不做声",
      u8"不停",
      u8"不停地",
      u8"不停息",
      u8"不停顿",
      u8"不偢不倸",
      u8"不健康",
      u8"不像",
      u8"不像是",
      u8"不像样",
      u8"不像话",
      u8"不僧不俗",
      u8"不允",
      u8"不允许",
      u8"不充分",
      u8"不充足",
      u8"不先",
      u8"不先去",
      u8"不先来",
      u8"不光",
      u8"不光会",
      u8"不光在",
      u8"不光彩",
      u8"不光是",
      u8"不光滑",
      u8"不克",
      u8"不免",
      u8"不免有些",
      u8"不入",
      u8"不入时宜",
      u8"不入流",
      u8"不入虎穴",
      u8"不入虎穴不得虎子",
      u8"不入虎穴焉得虎子",
      u8"不全",
      u8"不全会",
      u8"不全是",
      u8"不公",
      u8"不公平",
      u8"不公平地",
      u8"不公正",
      u8"不共戴天",
      u8"不共戴天之仇",
      u8"不共载天",
      u8"不关",
      u8"不关心",
      u8"不关我事",
      u8"不关痛痒",
      u8"不关紧要",
      u8"不兴",
      u8"不具",
      u8"不具备",
      u8"不具有",
      u8"不典型",
      u8"不兹",
      u8"不再",
      u8"不再出版",
      u8"不再是",
      u8"不冒",
      u8"不冷",
      u8"不冷不热",
      u8"不冻港",
      u8"不准",
      u8"不准备",
      u8"不凉不酸",
      u8"不减",
      u8"不减弱",
      u8"不减当年",
      u8"不凑巧",
      u8"不几天",
      u8"不凡",
      u8"不凭",
      u8"不出",
      u8"不出去",
      u8"不出去玩",
      u8"不出名",
      u8"不出所料",
      u8"不出来",
      u8"不出色",
      u8"不出门",
      u8"不击舟",
      u8"不分",
      u8"不分伯仲",
      u8"不分场合",
      u8"不分开",
      u8"不分彼此",
      u8"不分性别",
      u8"不分昼夜",
      u8"不分玉石",
      u8"不分男女老幼",
      u8"不分畛域",
      u8"不分皂分",
      u8"不分皂白",
      u8"不分胜负",
      u8"不分轩轾",
      u8"不分轻重缓急",
      u8"不分青白",
      u8"不分青红",
      u8"不分青红皂白",
      u8"不分首从",
      u8"不切",
      u8"不切实际",
      u8"不切题",
      u8"不刊之书",
      u8"不刊之典",
      u8"不刊之论",
      u8"不刊之说",
      u8"不划算",
      u8"不列颠",
      u8"不则声",
      u8"不删",
      u8"不利",
      u8"不利于",
      u8"不利因素",
      u8"不利条件",
      u8"不到",
      u8"不到之处",
      u8"不到位",
      u8"不到家",
      u8"不到长城非好汉",
      u8"不到黄河不死心",
      u8"不到黄河心不死",
      u8"不前",
      u8"不前不后",
      u8"不剩",
      u8"不力",
      u8"不加",
      u8"不加分析",
      u8"不加区分",
      u8"不加思索",
      u8"不加渲染",
      u8"不加考虑",
      u8"不务正业",
      u8"不务空名",
      u8"不劣方头",
      u8"不动",
      u8"不动产",
      u8"不动产业",
      u8"不动声色",
      u8"不动情",
      u8"不动摇",
      u8"不动神色",
      u8"不动精子",
      u8"不动配子",
      u8"不努力",
      u8"不劳而得",
      u8"不劳而成",
      u8"不劳而获",
      u8"不勉强",
      u8"不勤而获",
      u8"不包分配",
      u8"不包括",
      u8"不匹配末端",
      u8"不升",
      u8"不升反降",
      u8"不协同",
      u8"不协调",
      u8"不卑不亢",
      u8"不单",
      u8"不单单是",
      u8"不单是",
      u8"不占",
      u8"不卫生",
      u8"不即不离",
      u8"不厌",
      u8"不厌其烦",
      u8"不厌其繁",
      u8"不厌其详",
      u8"不去",
      u8"不及",
      u8"不及之法",
      u8"不及其余",
      u8"不及格",
      u8"不及物",
      u8"不及物动词",
      u8"不友好",
      u8"不反",
      u8"不发",
      u8"不发火",
      u8"不发生",
      u8"不发达",
      u8"不发达国家",
      u8"不发达地区",
      u8"不受",
      u8"不变",
      u8"不变价格",
      u8"不变其文",
      u8"不变性",
      u8"不变量",
      u8"不古不今",
      u8"不另",
      u8"不另行",
      u8"不只",
      u8"不只是",
      u8"不叫",
      u8"不可",
      u8"不可一世",
      u8"不可一日无此君",
      u8"不可不",
      u8"不可为训",
      u8"不可乡迩",
      u8"不可以",
      u8"不可企及",
      u8"不可估量",
      u8"不可信其无",
      u8"不可偏废",
      u8"不可分",
      u8"不可分割",
      u8"不可动摇",
      u8"不可同日而语",
      u8"不可名状",
      u8"不可向迩",
      u8"不可否认",
      u8"不可告人",
      u8"不可多得",
      u8"不可奈何",
      u8"不可定向流形",
      u8"不可对易性",
      u8"不可开交",
      u8"不可思议",
      u8"不可或缺",
      u8"不可抗力",
      u8"不可捉摸",
      u8"不可揆度",
      u8"不可摸捉",
      u8"不可收拾",
      u8"不可救疗",
      u8"不可救药",
      u8"不可救葯",
      u8"不可教",
      u8"不可教训",
      u8"不可数",
      u8"不可旁贷",
      u8"不可枚举",
      u8"不可比",
      u8"不可爱",
      u8"不可理喻",
      u8"不可用",
      u8"不可知",
      u8"不可知论",
      u8"不可磨灭",
      u8"不可究诘",
      u8"不可端倪",
      u8"不可终日",
      u8"不可考",
      u8"不可胜举",
      u8"不可胜数",
      u8"不可胜算",
      u8"不可胜纪",
      u8"不可胜言",
      u8"不可胜记",
      u8"不可胜道",
      u8"不可能",
      u8"不可能事件",
      u8"不可能图形",
      u8"不可能性",
      u8"不可自拔",
      u8"不可行",
      u8"不可补救",
      u8"不可见光",
      u8"不可观测子空间",
      u8"不可视区",
      u8"不可解地",
      u8"不可解性",
      u8"不可触摸",
      u8"不可言传",
      u8"不可言喻",
      u8"不可言宣",
      u8"不可言状",
      u8"不可讳言",
      u8"不可论证",
      u8"不可达基数",
      u8"不可违",
      u8"不可逆加密",
      u8"不可逆波",
      u8"不可逆电极",
      u8"不可逆转",
      u8"不可逆过程",
      u8"不可造次",
      u8"不可逾越",
      u8"不可避免",
      u8"不可重复读",
      u8"不可限量",
      u8"不可靠",
      u8"不可靠性",
      u8"不吃",
      u8"不吃不喝",
      u8"不吃烟火食",
      u8"不吃白不吃",
      u8"不吃羊肉空惹一身膻",
      u8"不合",
      u8"不合乎",
      u8"不合作",
      u8"不合作态度",
      u8"不合宜",
      u8"不合情理",
      u8"不合时令",
      u8"不合时宜",
      u8"不合时尚",
      u8"不合标准",
      u8"不合格",
      u8"不合格率",
      u8"不合格者",
      u8"不合法",
      u8"不合理",
      u8"不合理制度",
      u8"不合理竞争",
      u8"不合算",
      u8"不合规定",
      u8"不合规律",
      u8"不合规格",
      u8"不合调",
      u8"不合身",
      u8"不合适",
      u8"不合逻辑",
      u8"不吉之兆",
      u8"不吊",
      u8"不同",
      u8"不同之处",
      u8"不同于",
      u8"不同凡响",
      u8"不同印本",
      u8"不同寻常",
      u8"不同意",
      u8"不同戴天",
      u8"不同步",
      u8"不同流俗",
      u8"不同点",
      u8"不名一文",
      u8"不名一格",
      u8"不名一钱",
      u8"不名数",
      u8"不名誉",
      u8"不吐",
      u8"不吐不茹",
      u8"不吐骨头",
      u8"不向",
      u8"不吝",
      u8"不吝指教",
      u8"不吝指正",
      u8"不吝珠玉",
      u8"不吝赐教",
      u8"不吝金玉",
      u8"不含",
      u8"不含税",
      u8"不含糊",
      u8"不听",
      u8"不听使唤",
      u8"不听老人言吃亏在眼前",
      u8"不听话",
      u8"不吭",
      u8"不吭一声",
      u8"不吭声",
      u8"不吵",
      u8"不吵不闹",
      u8"不吸收",
      u8"不吻",
      u8"不告而别",
      u8"不告而辞",
      u8"不周",
      u8"不周到",
      u8"不周延",
      u8"不和",
      u8"不和睦",
      u8"不和蔼",
      u8"不和谐",
      u8"不咎既往",
      u8"不咸不淡",
      u8"不响应",
      u8"不哭",
      u8"不哼一声",
      u8"不哼不哈",
      u8"不哼声",
      u8"不啻",
      u8"不啻天渊",
      u8"不善",
      u8"不善于",
      u8"不善言辞",
      u8"不喜勿下",
      u8"不喜欢",
      u8"不回",
      u8"不回答",
      u8"不回话",
      u8"不因",
      u8"不因不由",
      u8"不因人热",
      u8"不团结",
      u8"不图",
      u8"不在",
      u8"不在乎",
      u8"不在了",
      u8"不在于",
      u8"不在其位",
      u8"不在其位不谋其政",
      u8"不在家",
      u8"不在少数",
      u8"不在意",
      u8"不在此列",
      u8"不在此限",
      u8"不在话下",
      u8"不均",
      u8"不均一性",
      u8"不均匀",
      u8"不均匀硫化",
      u8"不坏",
      u8"不坠",
      u8"不堪",
      u8"不堪一击",
      u8"不堪入目",
      u8"不堪入耳",
      u8"不堪其忧",
      u8"不堪回首",
      u8"不堪救药",
      u8"不堪言状",
      u8"不堪设想",
      u8"不堪负担",
      u8"不堪造就",
      u8"不堪重负",
      u8"不堵车",
      u8"不塞下流",
      u8"不塞下流不止不行",
      u8"不塞不流",
      u8"不塞不流不止不行",
      u8"不声不吭",
      u8"不声不响",
      u8"不声不气",
      u8"不壹",
      u8"不壹而三",
      u8"不壹而足",
      u8"不备",
      u8"不复",
      u8"不复位瓣",
      u8"不复堪命",
      u8"不复存在",
      u8"不外",
      u8"不外乎",
      u8"不外借",
      u8"不外是",
      u8"不多",
      u8"不多不少",
      u8"不多久",
      u8"不多于",
      u8"不多会儿",
      u8"不多见",
      u8"不夜城",
      u8"不够",
      u8"不够好",
      u8"不够意思",
      u8"不够格",
      u8"不够用",
      u8"不够看",
      u8"不大",
      u8"不大一样",
      u8"不大不小",
      u8"不大于",
      u8"不大可能",
      u8"不大好",
      u8"不大想",
      u8"不大清楚",
      u8"不太",
      u8"不太会",
      u8"不太可能",
      u8"不太好",
      u8"不太想",
      u8"不太熟悉",
      u8"不太能",
      u8"不失",
      u8"不失为",
      u8"不失众望",
      u8"不失圭撮",
      u8"不失时宜",
      u8"不失时机",
      u8"不失毫厘",
      u8"不失良机",
      u8"不失黍絫",
      u8"不夷不惠",
      u8"不奈",
      u8"不奈之何",
      u8"不奈烦",
      u8"不奏",
      u8"不好",
      u8"不好使",
      u8"不好办",
      u8"不好受",
      u8"不好听",
      u8"不好惹",
      u8"不好意思",
      u8"不好战",
      u8"不好死",
      u8"不好比",
      u8"不好玩",
      u8"不好用",
      u8"不好用救",
      u8"不好看",
      u8"不好说",
      u8"不好谈",
      u8"不好过",
      u8"不如",
      u8"不如归去",
      u8"不如意",
      u8"不如意事常八九",
      u8"不如薄技在身",
      u8"不如说",
      u8"不如说是",
      u8"不妙",
      u8"不妥",
      u8"不妨",
      u8"不妨一试",
      u8"不威严",
      u8"不媿下学",
      u8"不嫁",
      u8"不嫉妒",
      u8"不嫌",
      u8"不孕",
      u8"不孕症",
      u8"不存",
      u8"不存不济",
      u8"不存在",
      u8"不存芥蒂",
      u8"不孚众望",
      u8"不孝",
      u8"不孝之子",
      u8"不孝子",
      u8"不孝有三",
      u8"不学",
      u8"不学无术",
      u8"不学无识",
      u8"不宁",
      u8"不宁唯是",
      u8"不守",
      u8"不守信用",
      u8"不安",
      u8"不安于位",
      u8"不安于室",
      u8"不安份",
      u8"不安全",
      u8"不安其室",
      u8"不安分",
      u8"不安地",
      u8"不安宁",
      u8"不安定因素",
      u8"不完",
      u8"不完全",
      u8"不完全信息",
      u8"不完全统计",
      u8"不完善",
      u8"不完整",
      u8"不定",
      u8"不定人称",
      u8"不定冠词",
      u8"不定式",
      u8"不定形",
      u8"不定期",
      u8"不定根",
      u8"不定积分",
      u8"不定词",
      u8"不定量",
      u8"不宜",
      u8"不宜复印",
      u8"不宜居住",
      u8"不宜深造",
      u8"不实",
      u8"不实之处",
      u8"不实之词",
      u8"不实用",
      u8"不实际",
      u8"不审慎",
      u8"不客气",
      u8"不宣",
      u8"不宣而战",
      u8"不害噪",
      u8"不害羞",
      u8"不容",
      u8"不容乐观",
      u8"不容分说",
      u8"不容分辩",
      u8"不容小视",
      u8"不容忽视",
      u8"不容易",
      u8"不容置喙",
      u8"不容置疑",
      u8"不容置辩",
      u8"不容许",
      u8"不寐",
      u8"不寒而慄",
      u8"不寒而栗",
      u8"不察",
      u8"不对",
      u8"不对劲",
      u8"不对味",
      u8"不对头",
      u8"不对称",
      u8"不对称分离",
      u8"不对称原子",
      u8"不对称合成",
      u8"不对称平衡",
      u8"不对称性",
      u8"不对称标记",
      u8"不对茬",
      u8"不对茬儿",
      u8"不寻常",
      u8"不封",
      u8"不射之射",
      u8"不将",
      u8"不尊敬",
      u8"不小",
      u8"不小于",
      u8"不小心",
      u8"不少",
      u8"不少于",
      u8"不少人",
      u8"不少国家",
      u8"不少地方",
      u8"不少问题",
      u8"不尚空谈",
      u8"不就",
      u8"不就是",
      u8"不尴不尬",
      u8"不尽",
      u8"不尽一致",
      u8"不尽人意",
      u8"不尽合理",
      u8"不尽根",
      u8"不尽然",
      u8"不尽相同",
      u8"不屈",
      u8"不屈不挠",
      u8"不屑",
      u8"不屑一顾",
      u8"不屑于",
      u8"不屑教诲",
      u8"不屑毁誉",
      u8"不属",
      u8"不属于",
      u8"不巧",
      u8"不差",
      u8"不差上下",
      u8"不差什么",
      u8"不差毫厘",
      u8"不差毫发",
      u8"不差累黍",
      u8"不已",
      u8"不帅",
      u8"不带",
      u8"不常",
      u8"不常出现",
      u8"不干",
      u8"不干不净",
      u8"不干涉",
      u8"不干涉主义",
      u8"不干胶",
      u8"不平",
      u8"不平则鸣",
      u8"不平坦",
      u8"不平等",
      u8"不平等条约",
      u8"不平衡",
      u8"不平衡运输问题",
      u8"不平道人",
      u8"不幸",
      u8"不幸中之大幸",
      u8"不幸中的大幸",
      u8"不幸病故",
      u8"不幸福",
      u8"不幸而言中",
      u8"不幸身亡",
      u8"不幸逝世",
      u8"不幸遇害",
      u8"不幸遇难",
      u8"不幸遭遇",
      u8"不应",
      u8"不应得",
      u8"不应期",
      u8"不应该",
      u8"不废江河",
      u8"不廉",
      u8"不延误",
      u8"不开",
      u8"不开玩笑",
      u8"不弃",
      u8"不弃草昧",
      u8"不引",
      u8"不弯曲",
      u8"不弱",
      u8"不强",
      u8"不强不弱",
      u8"不强调",
      u8"不归",
      u8"不归零制",
      u8"不当",
      u8"不当不正",
      u8"不当之处",
      u8"不当人子",
      u8"不当家不知柴米贵",
      u8"不当得利",
      u8"不影响",
      u8"不往",
      u8"不待",
      u8"不待蓍龟",
      u8"不待说",
      u8"不徇私情",
      u8"不很",
      u8"不徐不疾",
      u8"不得",
      u8"不得不",
      u8"不得不尔",
      u8"不得之心",
      u8"不得了",
      u8"不得人心",
      u8"不得体",
      u8"不得公开",
      u8"不得其所",
      u8"不得其死",
      u8"不得其法",
      u8"不得其解",
      u8"不得其门而入",
      u8"不得劲",
      u8"不得善终",
      u8"不得好死",
      u8"不得已",
      u8"不得已地",
      u8"不得已而为之",
      u8"不得已而用之",
      u8"不得开交",
      u8"不得当",
      u8"不得志",
      u8"不得有误",
      u8"不得申诉",
      u8"不得而知",
      u8"不得要领",
      u8"不得违误",
      u8"不得闲",
      u8"不循常轨",
      u8"不循私情",
      u8"不必",
      u8"不必因",
      u8"不必要",
      u8"不忌生冷",
      u8"不忍",
      u8"不忍卒读",
      u8"不忍心",
      u8"不忘",
      u8"不忘故旧",
      u8"不忘本",
      u8"不忘沟壑",
      u8"不忙",
      u8"不忙不暴",
      u8"不忠",
      u8"不忠实",
      u8"不忠实地",
      u8"不忠诚",
      u8"不快",
      u8"不快不慢",
      u8"不忮不求",
      u8"不念",
      u8"不念僧面念佛面",
      u8"不念旧恶",
      u8"不念旧情",
      u8"不忿",
      u8"不怀",
      u8"不怀好意",
      u8"不怀疑",
      u8"不怎么",
      u8"不怎么样",
      u8"不怕",
      u8"不怕困难",
      u8"不怕官",
      u8"不怕官只怕管",
      u8"不怕死",
      u8"不怕没柴烧",
      u8"不怕牺牲",
      u8"不怕苦",
      u8"不怕难",
      u8"不思好歹",
      u8"不思悔改",
      u8"不思进取",
      u8"不急",
      u8"不急不徐",
      u8"不急之务",
      u8"不急于",
      u8"不怨",
      u8"不怪",
      u8"不恤",
      u8"不恤人言",
      u8"不恨",
      u8"不恭",
      u8"不息",
      u8"不恰当地",
      u8"不恶而严",
      u8"不悔改",
      u8"不悦",
      u8"不悱不发",
      u8"不情之请",
      u8"不惑",
      u8"不惑之年",
      u8"不惜",
      u8"不惜一切",
      u8"不惜一切代价",
      u8"不惜一战",
      u8"不惜代价",
      u8"不惜工本",
      u8"不惜成本",
      u8"不惜牺牲",
      u8"不惜重金",
      u8"不惟",
      u8"不惧",
      u8"不惮",
      u8"不惯",
      u8"不想",
      u8"不想想",
      u8"不愁",
      u8"不愁吃",
      u8"不愁没柴烧",
      u8"不愁穿",
      u8"不愉",
      u8"不愉快",
      u8"不意",
      u8"不感",
      u8"不感兴趣",
      u8"不感谢",
      u8"不愤不启",
      u8"不愧",
      u8"不愧下学",
      u8"不愧不作",
      u8"不愧不怍",
      u8"不愧为",
      u8"不愧屋漏",
      u8"不愧是",
      u8"不愿",
      u8"不愿意",
      u8"不慌",
      u8"不慌不乱",
      u8"不慌不忙",
      u8"不慎",
      u8"不慎重",
      u8"不慢",
      u8"不懂",
      u8"不懂事",
      u8"不懂装懂",
      u8"不懂道理",
      u8"不懈",
      u8"不懈努力",
      u8"不懊悔",
      u8"不成",
      u8"不成三瓦",
      u8"不成人子",
      u8"不成体统",
      u8"不成功",
      u8"不成器",
      u8"不成形",
      u8"不成才",
      u8"不成敬意",
      u8"不成文",
      u8"不成文法",
      u8"不成文规",
      u8"不成文规定",
      u8"不成方圆",
      u8"不成材",
      u8"不成比例",
      u8"不成气候",
      u8"不成熟",
      u8"不成立",
      u8"不成认",
      u8"不成话",
      u8"不成钢",
      u8"不成问题",
      u8"不戒",
      u8"不戒和尚",
      u8"不战",
      u8"不战不和",
      u8"不战而屈人之兵",
      u8"不战而胜",
      u8"不战而败",
      u8"不战而退",
      u8"不战自败",
      u8"不才",
      u8"不打",
      u8"不打不成相识",
      u8"不打不相",
      u8"不打不相识",
      u8"不打紧",
      u8"不打自招",
      u8"不托",
      u8"不扣",
      u8"不扬",
      u8"不扶自直",
      u8"不把",
      u8"不抗不卑",
      u8"不折",
      u8"不折不扣",
      u8"不折不挠",
      u8"不护细行",
      u8"不报",
      u8"不抵抗",
      u8"不抽",
      u8"不抽烟者",
      u8"不拔",
      u8"不拔一毛",
      u8"不拔之志",
      u8"不拖",
      u8"不拘",
      u8"不拘一格",
      u8"不拘一格降人才",
      u8"不拘小节",
      u8"不拘形式",
      u8"不拘形迹",
      u8"不拘泥",
      u8"不拘礼节",
      u8"不拘细节",
      u8"不拘细行",
      u8"不择",
      u8"不择手段",
      u8"不择生冷",
      u8"不拿",
      u8"不拿白不拿",
      u8"不拿薪水",
      u8"不挂",
      u8"不按君臣",
      u8"不按牌理",
      u8"不按牌理出牌",
      u8"不挑",
      u8"不挑之祖",
      u8"不挠不屈",
      u8"不挠不折",
      u8"不挡",
      u8"不挡人财路",
      u8"不振",
      u8"不捕",
      u8"不换",
      u8"不掉",
      u8"不接受",
      u8"不推迟",
      u8"不揍",
      u8"不提",
      u8"不提也罢",
      u8"不揣",
      u8"不揣冒昧",
      u8"不揪不採",
      u8"不揪不睬",
      u8"不揪不采",
      u8"不撮药",
      u8"不擅",
      u8"不擅辞令",
      u8"不擒二毛",
      u8"不支",
      u8"不支倒地",
      u8"不支持",
      u8"不收",
      u8"不改",
      u8"不改其",
      u8"不改其乐",
      u8"不攻自破",
      u8"不放",
      u8"不放回抽样",
      u8"不放心",
      u8"不放过",
      u8"不敌",
      u8"不敏",
      u8"不教之教",
      u8"不教而杀",
      u8"不教而诛",
      u8"不敢",
      u8"不敢后人",
      u8"不敢告劳",
      u8"不敢当",
      u8"不敢恭维",
      u8"不敢想像",
      u8"不敢掠美",
      u8"不敢旁骛",
      u8"不敢来啦",
      u8"不敢相信",
      u8"不敢肯定",
      u8"不敢自专",
      u8"不敢苟同",
      u8"不敢越雷池一步",
      u8"不敢越雷池半步",
      u8"不敢造次",
      u8"不敢问来人",
      u8"不敢问津",
      u8"不敢高攀",
      u8"不散",
      u8"不敬",
      u8"不整合",
      u8"不整洁",
      u8"不整齐",
      u8"不敷",
      u8"不文",
      u8"不文不武",
      u8"不文明",
      u8"不文雅",
      u8"不料",
      u8"不断",
      u8"不断丰富",
      u8"不断出现",
      u8"不断创新",
      u8"不断前进",
      u8"不断加强",
      u8"不断发展",
      u8"不断地",
      u8"不断如带",
      u8"不断学习",
      u8"不断完善",
      u8"不断扩大",
      u8"不断提高",
      u8"不断改进",
      u8"不断更新",
      u8"不断涌现",
      u8"不断深入",
      u8"不断耷拉",
      u8"不断进取",
      u8"不断进步",
      u8"不断革命",
      u8"不断革命论",
      u8"不新",
      u8"不新不旧",
      u8"不方便",
      u8"不旋肿",
      u8"不旋踵",
      u8"不无",
      u8"不无关系",
      u8"不无可疑",
      u8"不无可疑之处",
      u8"不无小补",
      u8"不无禁忌",
      u8"不无裨益",
      u8"不无道理",
      u8"不无遗憾",
      u8"不日",
      u8"不日不月",
      u8"不日启程",
      u8"不早",
      u8"不早不晚",
      u8"不早了",
      u8"不时",
      u8"不时之需",
      u8"不明",
      u8"不明不暗",
      u8"不明不白",
      u8"不明事里",
      u8"不明底蕴",
      u8"不明显",
      u8"不明智",
      u8"不明朗",
      u8"不明白",
      u8"不明真相",
      u8"不明确",
      u8"不明说",
      u8"不明飞行物",
      u8"不易",
      u8"不易一字",
      u8"不易之典",
      u8"不易之论",
      u8"不易感动",
      u8"不易控制",
      u8"不易而论",
      u8"不是",
      u8"不是东西",
      u8"不是之处",
      u8"不是冤家不聚头",
      u8"不是叫",
      u8"不是吗",
      u8"不是吧",
      u8"不是味",
      u8"不是味儿",
      u8"不是太好",
      u8"不是故意",
      u8"不是时候",
      u8"不是说",
      u8"不显",
      u8"不显山不露水",
      u8"不晓",
      u8"不晓世务",
      u8"不晓得",
      u8"不晚",
      u8"不景气",
      u8"不智",
      u8"不智之举",
      u8"不暇",
      u8"不暇顾及",
      u8"不更事",
      u8"不曾",
      u8"不曾在",
      u8"不曾有",
      u8"不曾有过",
      u8"不替",
      u8"不服",
      u8"不服从",
      u8"不服气",
      u8"不服水土",
      u8"不服输",
      u8"不期",
      u8"不期修古",
      u8"不期然",
      u8"不期然而然",
      u8"不期而会",
      u8"不期而同",
      u8"不期而然",
      u8"不期而至",
      u8"不期而遇",
      u8"不朽",
      u8"不朽名作",
      u8"不杀",
      u8"不杀不足以平民愤",
      u8"不材",
      u8"不来",
      u8"不来往",
      u8"不来梅",
      u8"不来电",
      u8"不松",
      u8"不极化电极",
      u8"不枉",
      u8"不果",
      u8"不果断",
      u8"不染一尘",
      u8"不查",
      u8"不栉进士",
      u8"不根",
      u8"不根之论",
      u8"不根之谈",
      u8"不桃之祖",
      u8"不检",
      u8"不模头",
      u8"不次之位",
      u8"不次之迁",
      u8"不欢而散",
      u8"不欲",
      u8"不欺屋漏",
      u8"不欺暗室",
      u8"不欺闇室",
      u8"不止",
      u8"不止一次",
      u8"不止不行",
      u8"不止是",
      u8"不正",
      u8"不正之风",
      u8"不正常",
      u8"不正当",
      u8"不正当关系",
      u8"不正当地",
      u8"不正当手段",
      u8"不正当竞争",
      u8"不正当竞争法",
      u8"不正派",
      u8"不正直",
      u8"不正确",
      u8"不正经",
      u8"不此之图",
      u8"不步人脚",
      u8"不武装",
      u8"不死",
      u8"不死不活",
      u8"不死心",
      u8"不死鸟",
      u8"不比",
      u8"不毛",
      u8"不毛之地",
      u8"不民主",
      u8"不气",
      u8"不求",
      u8"不求上进",
      u8"不求人",
      u8"不求利",
      u8"不求名",
      u8"不求名利",
      u8"不求有功",
      u8"不求有功但求无过",
      u8"不求甚解",
      u8"不求闻达",
      u8"不治",
      u8"不治之症",
      u8"不治而死",
      u8"不泄气",
      u8"不法",
      u8"不法之徒",
      u8"不法侵害",
      u8"不法分子",
      u8"不法古不修今",
      u8"不法常可",
      u8"不法行为",
      u8"不注意",
      u8"不洁",
      u8"不洗",
      u8"不流",
      u8"不流行",
      u8"不浅",
      u8"不测",
      u8"不测之忧",
      u8"不测之祸",
      u8"不测之罪",
      u8"不测风云",
      u8"不济",
      u8"不济事",
      u8"不涂",
      u8"不消",
      u8"不消一会儿",
      u8"不消化",
      u8"不消说",
      u8"不涨",
      u8"不涨反跌",
      u8"不涩",
      u8"不涩不苦",
      u8"不淑",
      u8"不深",
      u8"不清",
      u8"不清不楚",
      u8"不清不白",
      u8"不清楚",
      u8"不清洁",
      u8"不渝",
      u8"不温不火",
      u8"不温暖",
      u8"不溯既往性",
      u8"不溶混合",
      u8"不滑稽",
      u8"不满",
      u8"不满情绪",
      u8"不满意",
      u8"不满者",
      u8"不满足",
      u8"不漏",
      u8"不漏水",
      u8"不潮湿",
      u8"不灭",
      u8"不灭定律",
      u8"不灵",
      u8"不灵巧",
      u8"不灵敏",
      u8"不点",
      u8"不点儿",
      u8"不烦",
      u8"不烦恼",
      u8"不热",
      u8"不然",
      u8"不熟",
      u8"不熟悉",
      u8"不熟练",
      u8"不爱",
      u8"不爱交际",
      u8"不爱国",
      u8"不爽",
      u8"不爽快",
      u8"不爽毫发",
      u8"不爽累黍",
      u8"不牧之地",
      u8"不特",
      u8"不犯",
      u8"不犹豫",
      u8"不狂",
      u8"不独",
      u8"不独有偶",
      u8"不猧不魀",
      u8"不玩",
      u8"不现实",
      u8"不理",
      u8"不理不睬",
      u8"不理我",
      u8"不理解",
      u8"不甘",
      u8"不甘后人",
      u8"不甘寂寞",
      u8"不甘心",
      u8"不甘沉沦",
      u8"不甘示弱",
      u8"不甘落后",
      u8"不甘雌伏",
      u8"不甚",
      u8"不甚了了",
      u8"不甚了解",
      u8"不甚明朗",
      u8"不甜",
      u8"不生不灭",
      u8"不用",
      u8"不用拼音",
      u8"不用浪费",
      u8"不用白不用",
      u8"不用说",
      u8"不用谢",
      u8"不用选字",
      u8"不由",
      u8"不由分说",
      u8"不由得",
      u8"不由自主",
      u8"不男不女",
      u8"不畅",
      u8"不畏",
      u8"不畏强敌",
      u8"不畏强暴",
      u8"不畏强权",
      u8"不畏惧",
      u8"不畏艰险",
      u8"不畏艰难",
      u8"不留",
      u8"不留余地",
      u8"不留后路",
      u8"不留心",
      u8"不留情",
      u8"不留情面",
      u8"不疲倦",
      u8"不疲劳",
      u8"不疾不徐",
      u8"不痛",
      u8"不痛不痒",
      u8"不痴不聋",
      u8"不登大雅",
      u8"不登大雅之堂",
      u8"不白",
      u8"不白之冤",
      u8"不直一文",
      u8"不直一钱",
      u8"不相",
      u8"不相上下",
      u8"不相为谋",
      u8"不相信",
      u8"不相关",
      u8"不相同",
      u8"不相容",
      u8"不相容原理",
      u8"不相容性",
      u8"不相干",
      u8"不相干成象",
      u8"不相往来",
      u8"不相称",
      u8"不相称地",
      u8"不相等",
      u8"不相等地",
      u8"不相适应",
      u8"不相问闻",
      u8"不相闻问",
      u8"不省人事",
      u8"不看",
      u8"不看僧面看佛面",
      u8"不真",
      u8"不真不假",
      u8"不真实",
      u8"不真诚",
      u8"不眠不休",
      u8"不眠之夜",
      u8"不着",
      u8"不着急",
      u8"不着疼热",
      u8"不着痕迹",
      u8"不着边际",
      u8"不着陆",
      u8"不着陆飞行",
      u8"不睬",
      u8"不瞅不睬",
      u8"不瞒您说",
      u8"不瞽不聋",
      u8"不矜不伐",
      u8"不矜细行",
      u8"不知",
      u8"不知丁董",
      u8"不知下落",
      u8"不知不觉",
      u8"不知世务",
      u8"不知为不",
      u8"不知为不知",
      u8"不知为什么",
      u8"不知人间有羞耻事",
      u8"不知今夕何夕",
      u8"不知其二",
      u8"不知其可",
      u8"不知其所以然",
      u8"不知凡几",
      u8"不知分寸",
      u8"不知利害",
      u8"不知去向",
      u8"不知名",
      u8"不知天高地厚",
      u8"不知头脑",
      u8"不知好人",
      u8"不知好人心",
      u8"不知好歹",
      u8"不知寝食",
      u8"不知就里",
      u8"不知廉耻",
      u8"不知悔改",
      u8"不知情",
      u8"不知情地",
      u8"不知所云",
      u8"不知所以",
      u8"不知所出",
      u8"不知所厝",
      u8"不知所可",
      u8"不知所指",
      u8"不知所措",
      u8"不知所终",
      u8"不知所言",
      u8"不知所谓",
      u8"不知所适",
      u8"不知所错",
      u8"不知有汉",
      u8"不知有汉何论魏晋",
      u8"不知死活",
      u8"不知深浅",
      u8"不知火舞",
      u8"不知甘苦",
      u8"不知疲倦",
      u8"不知疼痒",
      u8"不知痛痒",
      u8"不知真假",
      u8"不知端倪",
      u8"不知纪极",
      u8"不知羞耻",
      u8"不知者不罪",
      u8"不知者无罪",
      u8"不知肉味",
      u8"不知自爱",
      u8"不知自量",
      u8"不知薡蕫",
      u8"不知觉",
      u8"不知起倒",
      u8"不知足",
      u8"不知轻重",
      u8"不知进取",
      u8"不知进退",
      u8"不知道",
      u8"不知颠倒",
      u8"不知高下",
      u8"不知高低",
      u8"不知鹿死谁手",
      u8"不短",
      u8"不破不立",
      u8"不确切",
      u8"不确定",
      u8"不确定度关系",
      u8"不确定性",
      u8"不确定间距",
      u8"不确实",
      u8"不碍",
      u8"不碰",
      u8"不磨损",
      u8"不磷不缁",
      u8"不礼貌",
      u8"不祥",
      u8"不祥之兆",
      u8"不祧之宗",
      u8"不祧之祖",
      u8"不禁",
      u8"不禁不由",
      u8"不禁意",
      u8"不离",
      u8"不科学",
      u8"不称职",
      u8"不移",
      u8"不稂不秀",
      u8"不稂不莠",
      u8"不稳",
      u8"不稳固",
      u8"不稳定",
      u8"不稳定地",
      u8"不稳定常数",
      u8"不稳定平衡",
      u8"不稳定性",
      u8"不稳平衡",
      u8"不稼不穑",
      u8"不穿",
      u8"不立文字",
      u8"不立案理由通知书",
      u8"不竭",
      u8"不端",
      u8"不笑",
      u8"不符",
      u8"不符合",
      u8"不符合条件者",
      u8"不符逻辑",
      u8"不笨",
      u8"不第",
      u8"不等",
      u8"不等于",
      u8"不等价交换",
      u8"不等号",
      u8"不等式",
      u8"不等方程",
      u8"不等边",
      u8"不等边三角形",
      u8"不等量",
      u8"不答复",
      u8"不简单",
      u8"不箕",
      u8"不算",
      u8"不算什么",
      u8"不算数",
      u8"不管",
      u8"不管一二",
      u8"不管三七",
      u8"不管三七二十一",
      u8"不管不顾",
      u8"不管事",
      u8"不管什么",
      u8"不管它",
      u8"不管怎么",
      u8"不管怎么说",
      u8"不管怎样",
      u8"不管是",
      u8"不管是谁",
      u8"不管用",
      u8"不管部长",
      u8"不管风吹浪打",
      u8"不粗不细",
      u8"不粘锅",
      u8"不精确",
      u8"不精确地",
      u8"不精确性",
      u8"不紧不慢",
      u8"不紧不离",
      u8"不累",
      u8"不繁",
      u8"不约",
      u8"不约而同",
      u8"不纯",
      u8"不经",
      u8"不经一事",
      u8"不经一事不长一智",
      u8"不经世故",
      u8"不经之语",
      u8"不经之说",
      u8"不经之谈",
      u8"不经事",
      u8"不经意",
      u8"不经济",
      u8"不结之缘",
      u8"不结果实",
      u8"不结盟",
      u8"不结盟国",
      u8"不结盟国家",
      u8"不结盟运动",
      u8"不给",
      u8"不给予",
      u8"不给你看",
      u8"不绝",
      u8"不绝于耳",
      u8"不绝如发",
      u8"不绝如带",
      u8"不绝如线",
      u8"不绝如缕",
      u8"不绝若线",
      u8"不缝",
      u8"不缩",
      u8"不缩水",
      u8"不缺",
      u8"不置",
      u8"不置一词",
      u8"不置可否",
      u8"不置褒贬",
      u8"不羁",
      u8"不羁之才",
      u8"不羁之民",
      u8"不美观",
      u8"不羞当面",
      u8"不習水土",
      u8"不翼而飞",
      u8"不老",
      u8"不老少",
      u8"不老泉",
      u8"不老练",
      u8"不老草",
      u8"不考",
      u8"不耐",
      u8"不耐其烦",
      u8"不耐心",
      u8"不耐烦",
      u8"不耻",
      u8"不耻下问",
      u8"不耻最后",
      u8"不联会",
      u8"不联会基因",
      u8"不肖",
      u8"不肖子孙",
      u8"不肥不瘦",
      u8"不肯",
      u8"不肯到",
      u8"不肯去",
      u8"不肯来",
      u8"不育",
      u8"不育症",
      u8"不胜",
      u8"不胜举",
      u8"不胜任",
      u8"不胜其任",
      u8"不胜其扰",
      u8"不胜其烦",
      u8"不胜其苦",
      u8"不胜唏嘘",
      u8"不胜感激",
      u8"不胜杯杓",
      u8"不胜枚举",
      u8"不胜桮杓",
      u8"不胜负荷",
      u8"不胜酒力",
      u8"不胫而走",
      u8"不能",
      u8"不能上演",
      u8"不能不",
      u8"不能不睬",
      u8"不能不说",
      u8"不能偿还",
      u8"不能允许",
      u8"不能分解",
      u8"不能到达",
      u8"不能医治",
      u8"不能取消",
      u8"不能变更",
      u8"不能同意",
      u8"不能够",
      u8"不能实现",
      u8"不能实行",
      u8"不能容忍",
      u8"不能已于言",
      u8"不能平静",
      u8"不能废除",
      u8"不能引开",
      u8"不能引用",
      u8"不能忘怀",
      u8"不能成方圆",
      u8"不能成立",
      u8"不能抑制",
      u8"不能按",
      u8"不能根除",
      u8"不能治愈",
      u8"不能涂抹",
      u8"不能混合",
      u8"不能溶解",
      u8"不能生存",
      u8"不能登大雅之堂",
      u8"不能看",
      u8"不能移去",
      u8"不能缓和",
      u8"不能自制",
      u8"不能自己",
      u8"不能自已",
      u8"不能自拔",
      u8"不能解决",
      u8"不能解救",
      u8"不能言传",
      u8"不能证实",
      u8"不能说",
      u8"不能说话",
      u8"不能读",
      u8"不能赞一词",
      u8"不能赞一辞",
      u8"不能超过",
      u8"不能越雷池一步",
      u8"不能转让",
      u8"不能适应",
      u8"不能逃避",
      u8"不能通过",
      u8"不脩边幅",
      u8"不脱",
      u8"不腆之仪",
      u8"不臣之心",
      u8"不自",
      u8"不自主",
      u8"不自在",
      u8"不自满假",
      u8"不自然",
      u8"不自由",
      u8"不自由毋宁死",
      u8"不自禁",
      u8"不自觉",
      u8"不自重",
      u8"不自量",
      u8"不自量力",
      u8"不臭",
      u8"不至于",
      u8"不致",
      u8"不致于",
      u8"不致命",
      u8"不舍",
      u8"不舍昼夜",
      u8"不舒服",
      u8"不舞之鹤",
      u8"不良",
      u8"不良习惯",
      u8"不良习气",
      u8"不良份子",
      u8"不良信息",
      u8"不良倾向",
      u8"不良分子",
      u8"不良反应",
      u8"不良后果",
      u8"不良嗜好",
      u8"不良导体",
      u8"不良少年",
      u8"不良影响",
      u8"不良情绪",
      u8"不良现象",
      u8"不良行为",
      u8"不良贷款",
      u8"不良资产",
      u8"不良青少年",
      u8"不良风气",
      u8"不花",
      u8"不苟",
      u8"不苟言笑",
      u8"不若",
      u8"不苦",
      u8"不茶不饭",
      u8"不药而愈",
      u8"不菲",
      u8"不落",
      u8"不落人后",
      u8"不落俗套",
      u8"不落窠臼",
      u8"不落边际",
      u8"不蔓不支",
      u8"不蔓不枝",
      u8"不薄",
      u8"不虔诚",
      u8"不虚",
      u8"不虚此行",
      u8"不虞",
      u8"不虞之誉",
      u8"不虞匮乏",
      u8"不行",
      u8"不行了",
      u8"不衫不履",
      u8"不衰",
      u8"不被",
      u8"不装",
      u8"不要",
      u8"不要南郭",
      u8"不要命",
      u8"不要紧",
      u8"不要脸",
      u8"不要钱",
      u8"不见",
      u8"不见不散",
      u8"不见了",
      u8"不见人下来",
      u8"不见天日",
      u8"不见得",
      u8"不见森林",
      u8"不见棺材不下泪",
      u8"不见棺材不掉泪",
      u8"不见棺材不落泪",
      u8"不见泰山",
      u8"不见经付",
      u8"不见经传",
      u8"不见踪影",
      u8"不规则",
      u8"不规则三角网格",
      u8"不规则显性",
      u8"不规则牙本质",
      u8"不觉",
      u8"不觉得",
      u8"不觉技痒",
      u8"不解",
      u8"不解之仇",
      u8"不解之缘",
      u8"不解之谜",
      u8"不解事",
      u8"不解风情",
      u8"不言",
      u8"不言不语",
      u8"不言而信",
      u8"不言而喻",
      u8"不言而明",
      u8"不言而谕",
      u8"不言自明",
      u8"不计",
      u8"不计个人得失",
      u8"不计其数",
      u8"不计前嫌",
      u8"不计后果",
      u8"不计得失",
      u8"不计成本",
      u8"不计报酬",
      u8"不计较",
      u8"不认",
      u8"不认为",
      u8"不认帐",
      u8"不认识",
      u8"不认账",
      u8"不让",
      u8"不让人",
      u8"不让步者",
      u8"不让进入",
      u8"不让须眉",
      u8"不记前仇",
      u8"不记名投",
      u8"不记名投票",
      u8"不记得",
      u8"不讲",
      u8"不讲情面",
      u8"不讲方法",
      u8"不讲条件",
      u8"不讲理",
      u8"不讲道理",
      u8"不讳",
      u8"不讳之朝",
      u8"不讳之路",
      u8"不讳之门",
      u8"不许",
      u8"不许动",
      u8"不许失败",
      u8"不许百姓点灯",
      u8"不论",
      u8"不论什么",
      u8"不论如何",
      u8"不论怎么",
      u8"不论怎样",
      u8"不论是",
      u8"不论是谁",
      u8"不设防",
      u8"不识",
      u8"不识一丁",
      u8"不识不知",
      u8"不识东家",
      u8"不识之无",
      u8"不识人间有羞耻事",
      u8"不识大体",
      u8"不识好人心",
      u8"不识好歹",
      u8"不识局面",
      u8"不识庐山真面目",
      u8"不识抬举",
      u8"不识时务",
      u8"不识时变",
      u8"不识泰山",
      u8"不识货",
      u8"不识起倒",
      u8"不识闲儿",
      u8"不识阵势",
      u8"不识马肝",
      u8"不识高低",
      u8"不诉",
      u8"不诚实",
      u8"不该",
      u8"不该得",
      u8"不详",
      u8"不误",
      u8"不说",
      u8"不说出",
      u8"不说话",
      u8"不请",
      u8"不请自来",
      u8"不读",
      u8"不调",
      u8"不调和",
      u8"不谈",
      u8"不谋",
      u8"不谋其政",
      u8"不谋其职",
      u8"不谋同辞",
      u8"不谋私利",
      u8"不谋而合",
      u8"不谋而同",
      u8"不谐和",
      u8"不谓",
      u8"不谙",
      u8"不谦虚",
      u8"不谨慎",
      u8"不象",
      u8"不象样",
      u8"不象话",
      u8"不豫",
      u8"不贝",
      u8"不贞",
      u8"不贞洁",
      u8"不负",
      u8"不负众托",
      u8"不负众望",
      u8"不负使命",
      u8"不负所托",
      u8"不负责任",
      u8"不败",
      u8"不败之地",
      u8"不贪为宝",
      u8"不贰",
      u8"不贰之臣",
      u8"不贰过",
      u8"不贵",
      u8"不费",
      u8"不费之惠",
      u8"不费力气",
      u8"不费吹灰之力",
      u8"不费周折",
      u8"不赀",
      u8"不赏之功",
      u8"不赖",
      u8"不赞一词",
      u8"不赞同",
      u8"不赞成",
      u8"不走过场",
      u8"不起作用",
      u8"不起眼",
      u8"不起眼儿",
      u8"不起诉决定书",
      u8"不越雷池",
      u8"不越雷池一步",
      u8"不越雷池半步",
      u8"不足",
      u8"不足与谋",
      u8"不足为凭",
      u8"不足为外",
      u8"不足为外人道",
      u8"不足为奇",
      u8"不足为怪",
      u8"不足为意",
      u8"不足为据",
      u8"不足为法",
      u8"不足为虑",
      u8"不足为训",
      u8"不足之处",
      u8"不足介意",
      u8"不足以",
      u8"不足以平民愤",
      u8"不足取",
      u8"不足挂齿",
      u8"不足称道",
      u8"不足轻重",
      u8"不足道",
      u8"不足道也",
      u8"不足齿数",
      u8"不跌",
      u8"不跌反涨",
      u8"不跑",
      u8"不跟",
      u8"不跟人",
      u8"不跳",
      u8"不蹬大雅",
      u8"不轨",
      u8"不轨之徒",
      u8"不轻",
      u8"不轻不重",
      u8"不轻然诺",
      u8"不辍",
      u8"不输",
      u8"不输给",
      u8"不辞",
      u8"不辞劳苦",
      u8"不辞而别",
      u8"不辞辛劳",
      u8"不辞辛苦",
      u8"不辟斧钺",
      u8"不辨是非",
      u8"不辨真伪",
      u8"不辨菽粟",
      u8"不辨菽麦",
      u8"不辩菽麦",
      u8"不辱使命",
      u8"不迁之庙",
      u8"不过",
      u8"不过关",
      u8"不过去",
      u8"不过如此",
      u8"不过尔尔",
      u8"不过意",
      u8"不过是",
      u8"不过来",
      u8"不过问",
      u8"不近",
      u8"不近人情",
      u8"不近情理",
      u8"不近道理",
      u8"不还",
      u8"不进",
      u8"不进不退",
      u8"不进则退",
      u8"不进去",
      u8"不进反退",
      u8"不进来",
      u8"不远",
      u8"不远万里",
      u8"不远千里",
      u8"不远千里而来",
      u8"不远处",
      u8"不违农时",
      u8"不连接",
      u8"不连续区带电泳",
      u8"不连续变异",
      u8"不连续复制",
      u8"不连续梯度",
      u8"不连贯",
      u8"不迟",
      u8"不迭",
      u8"不追",
      u8"不追既往",
      u8"不退",
      u8"不退反进",
      u8"不退赃",
      u8"不送",
      u8"不适",
      u8"不适中",
      u8"不适合",
      u8"不适宜",
      u8"不适应",
      u8"不适当",
      u8"不适感",
      u8"不逃",
      u8"不逊",
      u8"不逊于",
      u8"不透",
      u8"不透光",
      u8"不透性",
      u8"不透明",
      u8"不透明性",
      u8"不透明缩微复制品",
      u8"不透气",
      u8"不透水",
      u8"不通",
      u8"不通人情",
      u8"不通水火",
      u8"不通过",
      u8"不逞",
      u8"不逞之徒",
      u8"不速之客",
      u8"不遂",
      u8"不遂意",
      u8"不遇",
      u8"不遑",
      u8"不遑启处",
      u8"不遑宁处",
      u8"不遑宁息",
      u8"不遑暇食",
      u8"不遑枚举",
      u8"不道德",
      u8"不遗",
      u8"不遗余力",
      u8"不遗寸长",
      u8"不遗巨细",
      u8"不避",
      u8"不避斧钺",
      u8"不避水火",
      u8"不避汤火",
      u8"不避艰险",
      u8"不避风险",
      u8"不那么",
      u8"不郎不秀",
      u8"不配",
      u8"不配套",
      u8"不酸",
      u8"不酸不甜",
      u8"不酸不苦",
      u8"不酸不辣",
      u8"不醉",
      u8"不醒",
      u8"不重",
      u8"不重性",
      u8"不重要",
      u8"不量力",
      u8"不钓",
      u8"不锈",
      u8"不锈钢",
      u8"不锈钢丝",
      u8"不锈钢板",
      u8"不锈钢管",
      u8"不锈钢网",
      u8"不错",
      u8"不错呀",
      u8"不长",
      u8"不长一智",
      u8"不长不短",
      u8"不长进",
      u8"不问",
      u8"不问不闻",
      u8"不问前因后果",
      u8"不问是非曲直",
      u8"不问皂白",
      u8"不问青红皂白",
      u8"不间不界",
      u8"不间断",
      u8"不间断电源",
      u8"不闻不问",
      u8"不防",
      u8"不阴不阳",
      u8"不附带任何条件",
      u8"不降",
      u8"不降反升",
      u8"不限",
      u8"不限于",
      u8"不限在",
      u8"不陷于",
      u8"不随",
      u8"不随以止",
      u8"不随意",
      u8"不随意肌",
      u8"不随意运动",
      u8"不难",
      u8"不难想像",
      u8"不难想象",
      u8"不难猜测",
      u8"不难理解",
      u8"不难看出",
      u8"不难设想",
      u8"不雅",
      u8"不雅致",
      u8"不雅观",
      u8"不需",
      u8"不需要",
      u8"不露",
      u8"不露圭角",
      u8"不露声色",
      u8"不露形色",
      u8"不露痕迹",
      u8"不露神色",
      u8"不露锋芒",
      u8"不露锋铓",
      u8"不静",
      u8"不靠",
      u8"不韪",
      u8"不顺",
      u8"不顺利",
      u8"不顺心",
      u8"不顺服",
      u8"不顺遂",
      u8"不须",
      u8"不顾",
      u8"不顾一切",
      u8"不顾前后",
      u8"不顾后果",
      u8"不顾大局",
      u8"不顾死活",
      u8"不预则废",
      u8"不领",
      u8"不领情",
      u8"不食",
      u8"不食之地",
      u8"不食人间烟火",
      u8"不食周粟",
      u8"不食烟火",
      u8"不食马肝",
      u8"不饥不寒",
      u8"不饮盗泉",
      u8"不饱和",
      u8"不饱和聚酯",
      u8"不饿",
      u8"不驯服",
      u8"不骄不躁",
      u8"不骄不馁",
      u8"不骑",
      u8"不骗你",
      u8"不高",
      u8"不高不低",
      u8"不高不矮",
      u8"不高于",
      u8"不高兴",
      u8"不高兴地",
      u8"不鸣则已",
      u8"不黏",
      u8"不齐",
      u8"不齿",
      u8"不齿于人",
      u8"不龟手药",
      u8"与上年同期相比",
      u8"与与",
      u8"与世俯仰",
      u8"与世偃仰",
      u8"与世推移",
      u8"与世无争",
      u8"与世沉浮",
      u8"与世浮沉",
      u8"与世长辞",
      u8"与世隔绝",
      u8"与世隔膜",
      u8"与人",
      u8"与人为善",
      u8"与人方便",
      u8"与人方便自己方便",
      u8"与人无争",
      u8"与众不同",
      u8"与众同乐",
      u8"与会",
      u8"与会人士",
      u8"与会代表",
      u8"与会同志",
      u8"与会国",
      u8"与会者",
      u8"与你何干",
      u8"与你同在",
      u8"与党中央保持高度一致",
      u8"与共",
      u8"与其",
      u8"与其说",
      u8"与其说是",
      u8"与去年相比",
      u8"与受同科",
      u8"与君",
      u8"与否",
      u8"与国",
      u8"与她",
      u8"与子偕老",
      u8"与它",
      u8"与己无关",
      u8"与市场调节相结合",
      u8"与总",
      u8"与我",
      u8"与我何干",
      u8"与我无关",
      u8"与或堆栈寄存器",
      u8"与或门",
      u8"与日",
      u8"与日俱增",
      u8"与日而增",
      u8"与时俱进",
      u8"与时偕行",
      u8"与时推移",
      u8"与时消息",
      u8"与格",
      u8"与此",
      u8"与此一道",
      u8"与此同时",
      u8"与此无关",
      u8"与此有关",
      u8"与此相关",
      u8"与此相反",
      u8"与民争利",
      u8"与民同乐",
      u8"与民更始",
      u8"与民除害",
      u8"与水化合",
      u8"与物无忤",
      u8"与物无竞",
      u8"与狐谋皮",
      u8"与狼共舞",
      u8"与生俱来",
      u8"与虎添翼",
      u8"与虎谋皮",
      u8"与谁",
      u8"与赛",
      u8"与门",
      u8"与闻",
      u8"与非门",
      u8"与鬼为邻",
      u8"丐养",
      u8"丐帮",
      u8"丑丑",
      u8"丑丫头",
      u8"丑事",
      u8"丑事传千里",
      u8"丑人",
      u8"丑人多作怪",
      u8"丑八怪",
      u8"丑剧",
      u8"丑化",
      u8"丑名",
      u8"丑声四溢",
      u8"丑声远播",
      u8"丑女",
      u8"丑妇竞簪花",
      u8"丑妹",
      u8"丑婆子",
      u8"丑媳妇总得见公婆",
      u8"丑小鸭",
      u8"丑态",
      u8"丑态毕露",
      u8"丑态百出",
      u8"丑怪",
      u8"丑恶",
      u8"丑恶嘴脸",
      u8"丑恶报文",
      u8"丑旦",
      u8"丑时",
      u8"丑星",
      u8"丑样",
      u8"丑死",
      u8"丑牛",
      u8"丑男",
      u8"丑相",
      u8"丑类",
      u8"丑类恶物",
      u8"丑脸",
      u8"丑脸汉子",
      u8"丑行",
      u8"丑角",
      u8"丑诋",
      u8"丑话",
      u8"丑语",
      u8"丑闻",
      u8"丑陋",
      u8"专一",
      u8"专一不移",
      u8"专一性",
      u8"专上",
      u8"专上程度",
      u8"专业",
      u8"专业乡",
      u8"专业书籍",
      u8"专业人员",
      u8"专业人士",
      u8"专业人才",
      u8"专业公司",
      u8"专业分工",
      u8"专业化",
      u8"专业名词",
      u8"专业培训",
      u8"专业学位",
      u8"专业学校",
      u8"专业对口",
      u8"专业展",
      u8"专业性",
      u8"专业户",
      u8"专业技术",
      u8"专业技术人员",
      u8"专业技术人员业",
      u8"专业技能",
      u8"专业教育",
      u8"专业本科",
      u8"专业术语",
      u8"专业村",
      u8"专业版",
      u8"专业班",
      u8"专业知识",
      u8"专业科目",
      u8"专业精神",
      u8"专业级",
      u8"专业组",
      u8"专业组织",
      u8"专业翻译",
      u8"专业英语",
      u8"专业训练",
      u8"专业词库",
      u8"专业课",
      u8"专业课程",
      u8"专业银行",
      u8"专业队",
      u8"专业队伍",
      u8"专业音响",
      u8"专为",
      u8"专书",
      u8"专事",
      u8"专于",
      u8"专人",
      u8"专任",
      u8"专任教师",
      u8"专使",
      u8"专供",
      u8"专修",
      u8"专修班",
      u8"专修科",
      u8"专修科目",
      u8"专储粮",
      u8"专函",
      u8"专刊",
      u8"专列",
      u8"专利",
      u8"专利事务所",
      u8"专利产品",
      u8"专利公报",
      u8"专利制度",
      u8"专利发明",
      u8"专利号",
      u8"专利品",
      u8"专利审查",
      u8"专利局",
      u8"专利技术",
      u8"专利权",
      u8"专利权人",
      u8"专利法",
      u8"专利申请",
      u8"专利税",
      u8"专利者",
      u8"专利证书",
      u8"专利费",
      u8"专制",
      u8"专制主义",
      u8"专制制度",
      u8"专制型父母",
      u8"专制政体",
      u8"专制政府",
      u8"专制政治",
      u8"专制权",
      u8"专制起来",
      u8"专力",
      u8"专区",
      u8"专升本",
      u8"专卖",
      u8"专卖局",
      u8"专卖店",
      u8"专卖权",
      u8"专卖柜",
      u8"专卖网",
      u8"专发",
      u8"专史",
      u8"专号",
      u8"专司",
      u8"专名",
      u8"专名号",
      u8"专向",
      u8"专员",
      u8"专员公署",
      u8"专命",
      u8"专唱",
      u8"专在",
      u8"专场",
      u8"专士",
      u8"专委会",
      u8"专守",
      u8"专宠",
      u8"专家",
      u8"专家委员会",
      u8"专家学者",
      u8"专家库",
      u8"专家建议",
      u8"专家教授",
      u8"专家系统",
      u8"专家系统工具",
      u8"专家级",
      u8"专家组",
      u8"专家论证",
      u8"专家门诊",
      u8"专属",
      u8"专属经济",
      u8"专属经济区",
      u8"专差",
      u8"专席",
      u8"专干",
      u8"专库",
      u8"专座",
      u8"专往",
      u8"专征",
      u8"专心",
      u8"专心一志",
      u8"专心一意",
      u8"专心向公",
      u8"专心致志",
      u8"专心诚意",
      u8"专恣",
      u8"专情",
      u8"专户",
      u8"专才",
      u8"专打",
      u8"专找",
      u8"专报",
      u8"专拜",
      u8"专拣",
      u8"专指",
      u8"专控",
      u8"专摆",
      u8"专擅",
      u8"专收",
      u8"专攻",
      u8"专政",
      u8"专政对象",
      u8"专政机关",
      u8"专教",
      u8"专文",
      u8"专断",
      u8"专有",
      u8"专有名词",
      u8"专有权",
      u8"专有物",
      u8"专机",
      u8"专杀",
      u8"专权",
      u8"专权恣肆",
      u8"专来",
      u8"专柜",
      u8"专柜小姐",
      u8"专栏",
      u8"专栏作家",
      u8"专校",
      u8"专案",
      u8"专案处理",
      u8"专案小组",
      u8"专案工作",
      u8"专案组",
      u8"专横",
      u8"专横跋扈",
      u8"专欲难成",
      u8"专款",
      u8"专款专用",
      u8"专此",
      u8"专治",
      u8"专注",
      u8"专版",
      u8"专用",
      u8"专用办公楼",
      u8"专用发票",
      u8"专用名词",
      u8"专用品",
      u8"专用地图",
      u8"专用基金",
      u8"专用工具",
      u8"专用汽车",
      u8"专用版",
      u8"专用章",
      u8"专用箱",
      u8"专用纸",
      u8"专用线",
      u8"专用线路",
      u8"专用网",
      u8"专用肥",
      u8"专用设备",
      u8"专用设备厂",
      u8"专用词",
      u8"专用贴",
      u8"专用车",
      u8"专用车辆",
      u8"专用道",
      u8"专用集成电路",
      u8"专电",
      u8"专看",
      u8"专着",
      u8"专科",
      u8"专科专业",
      u8"专科医生",
      u8"专科医院",
      u8"专科学校",
      u8"专科学校建筑",
      u8"专科学院",
      u8"专科毕业",
      u8"专科生",
      u8"专科门诊",
      u8"专租",
      u8"专程",
      u8"专程到",
      u8"专程前往",
      u8"专程去",
      u8"专程来",
      u8"专稿",
      u8"专管",
      u8"专管员",
      u8"专类花园",
      u8"专精",
      u8"专精于",
      u8"专线",
      u8"专线接入",
      u8"专线电话",
      u8"专线车",
      u8"专经",
      u8"专署",
      u8"专美",
      u8"专美于前",
      u8"专而精",
      u8"专职",
      u8"专职人员",
      u8"专职干部",
      u8"专营",
      u8"专营店",
      u8"专营权",
      u8"专著",
      u8"专要",
      u8"专讯",
      u8"专论",
      u8"专设",
      u8"专访",
      u8"专诚",
      u8"专责",
      u8"专车",
      u8"专车接送",
      u8"专辑",
      u8"专辑名称",
      u8"专辑语言",
      u8"专送",
      u8"专递",
      u8"专销",
      u8"专长",
      u8"专门",
      u8"专门人才",
      u8"专门人民",
      u8"专门人民法院",
      u8"专门从事",
      u8"专门利人",
      u8"专门化",
      u8"专门室内系统",
      u8"专门家",
      u8"专门工作",
      u8"专门店",
      u8"专门性",
      u8"专门技术",
      u8"专门术语",
      u8"专门机构",
      u8"专门班子",
      u8"专门知识",
      u8"专门研究",
      u8"专门组",
      u8"专门词汇",
      u8"专门调查",
      u8"专集",
      u8"专项",
      u8"专项合同",
      u8"专项基金",
      u8"专项斗争",
      u8"专项经费",
      u8"专项规划",
      u8"专项资金",
      u8"专题",
      u8"专题会议",
      u8"专题制图仪",
      u8"专题剧场",
      u8"专题地图",
      u8"专题地图学",
      u8"专题地图集",
      u8"专题学习",
      u8"专题技术",
      u8"专题报告",
      u8"专题报道",
      u8"专题片",
      u8"专题研究",
      u8"专题研讨",
      u8"专题组",
      u8"专题讨论",
      u8"专题讲座",
      u8"专题论文",
      u8"专题评测",
      u8"专馆",
      u8"且不",
      u8"且不说",
      u8"且为",
      u8"且住",
      u8"且住为佳",
      u8"且听",
      u8"且慢",
      u8"且有",
      u8"且末",
      u8"且末县",
      u8"且末城",
      u8"且看",
      u8"且经",
      u8"且莫",
      u8"且说",
      u8"且食蛤蜊",
      u8"丕业",
      u8"丕变",
      u8"丕显",
      u8"世上",
      u8"世上新人撵旧人",
      u8"世上无直人",
      u8"世上无难事",
      u8"世上无难事只怕有心人",
      u8"世世",
      u8"世世代代",
      u8"世乒赛",
      u8"世事",
      u8"世事变迁",
      u8"世事多变",
      u8"世事如棋局局新",
      u8"世事难料",
      u8"世交",
      u8"世亲",
      u8"世人",
      u8"世仇",
      u8"世代",
      u8"世代书香",
      u8"世代交替",
      u8"世代相传",
      u8"世代相沿",
      u8"世传",
      u8"世伪知贤",
      u8"世伯",
      u8"世侄",
      u8"世俗",
      u8"世俗主义",
      u8"世俗之见",
      u8"世俗化",
      u8"世俗性",
      u8"世俗社会",
      u8"世兄",
      u8"世务",
      u8"世医",
      u8"世博会",
      u8"世博园",
      u8"世叔",
      u8"世变",
      u8"世嘉",
      u8"世处",
      u8"世外",
      u8"世外桃源",
      u8"世妇会",
      u8"世子",
      u8"世宗",
      u8"世家",
      u8"世家子弟",
      u8"世尊",
      u8"世尘",
      u8"世局",
      u8"世局多变",
      u8"世居",
      u8"世异时移",
      u8"世弊",
      u8"世弟",
      u8"世德",
      u8"世态",
      u8"世态人情",
      u8"世态炎凉",
      u8"世情",
      u8"世扰俗乱",
      u8"世掌丝纶",
      u8"世故",
      u8"世敌",
      u8"世新",
      u8"世族",
      u8"世昌",
      u8"世易时移",
      u8"世殊事异",
      u8"世济其美",
      u8"世界",
      u8"世界一统",
      u8"世界上",
      u8"世界主义",
      u8"世界之最",
      u8"世界五百强",
      u8"世界人",
      u8"世界人民",
      u8"世界先进水平",
      u8"世界关贸总协定",
      u8"世界军事",
      u8"世界冠军",
      u8"世界劳工组织",
      u8"世界华人",
      u8"世界博览",
      u8"世界卫生",
      u8"世界卫生组织",
      u8"世界历史",
      u8"世界史",
      u8"世界各国",
      u8"世界各地",
      u8"世界名牌",
      u8"世界名著",
      u8"世界员",
      u8"世界和平",
      u8"世界围棋",
      u8"世界地图",
      u8"世界地图集",
      u8"世界地方自治联盟",
      u8"世界地理",
      u8"世界坐标",
      u8"世界大同",
      u8"世界大国",
      u8"世界大学生运动会",
      u8"世界大战",
      u8"世界大赛",
      u8"世界奇观",
      u8"世界屋脊",
      u8"世界市场",
      u8"世界广论",
      u8"世界形势",
      u8"世界性",
      u8"世界报",
      u8"世界排名",
      u8"世界政治",
      u8"世界文化",
      u8"世界文学",
      u8"世界文明",
      u8"世界新专",
      u8"世界新格局",
      u8"世界新闻",
      u8"世界新闻专科学校",
      u8"世界日报",
      u8"世界时",
      u8"世界时钟",
      u8"世界末日",
      u8"世界杯",
      u8"世界杯赛",
      u8"世界气象组织",
      u8"世界水平",
      u8"世界潮流",
      u8"世界知识",
      u8"世界秩序",
      u8"世界第一",
      u8"世界管",
      u8"世界级",
      u8"世界纪录",
      u8"世界经济",
      u8"世界经济危机",
      u8"世界舞台",
      u8"世界范围",
      u8"世界观",
      u8"世界语",
      u8"世界货币",
      u8"世界贸易",
      u8"世界贸易中心",
      u8"世界贸易大楼",
      u8"世界贸易组织",
      u8"世界足坛",
      u8"世界足球",
      u8"世界退伍军人联盟",
      u8"世界通",
      u8"世界遗产",
      u8"世界钟",
      u8"世界银行",
      u8"世界锦标赛",
      u8"世界闻名",
      u8"世界霸权",
      u8"世界领先",
      u8"世界领先地位",
      u8"世界风",
      u8"世盟",
      u8"世系",
      u8"世纪",
      u8"世纪东方",
      u8"世纪之交",
      u8"世纪互联",
      u8"世纪初",
      u8"世纪坛",
      u8"世纪末",
      u8"世纪永联",
      u8"世纪版",
      u8"世纪绝症",
      u8"世纪金辉",
      u8"世纪钟",
      u8"世臣",
      u8"世行",
      u8"世袭",
      u8"世袭领地",
      u8"世说",
      u8"世说新语",
      u8"世谊",
      u8"世贸",
      u8"世贸中心",
      u8"世贸大楼",
      u8"世贸组织",
      u8"世运",
      u8"世运会",
      u8"世道",
      u8"世道人心",
      u8"世道人情",
      u8"世锦赛",
      u8"世间",
      u8"世间若要人情好",
      u8"世青赛",
      u8"世面",
      u8"世风",
      u8"世风不古",
      u8"世风日下",
      u8"世风浇薄",
      u8"丘东",
      u8"丘八",
      u8"丘力居",
      u8"丘北",
      u8"丘北县",
      u8"丘县",
      u8"丘吉尔",
      u8"丘坟",
      u8"丘墓",
      u8"丘墟",
      u8"丘壑",
      u8"丘处机",
      u8"丘山之功",
      u8"丘岗",
      u8"丘比特",
      u8"丘疹",
      u8"丘箭",
      u8"丘脑",
      u8"丘陵",
      u8"丘陵区",
      u8"丘陵地",
      u8"丘陵地区",
      u8"丘陵地带",
      u8"丘陵地形",
      u8"丙丁",
      u8"丙丁酚",
      u8"丙丑",
      u8"丙二醇",
      u8"丙二醛",
      u8"丙亥",
      u8"丙午",
      u8"丙卯",
      u8"丙咪唑",
      u8"丙国",
      u8"丙型肝炎",
      u8"丙基",
      u8"丙子",
      u8"丙寅",
      u8"丙巳",
      u8"丙戌",
      u8"丙方",
      u8"丙未",
      u8"丙村",
      u8"丙校",
      u8"丙氨酸",
      u8"丙氨酸转氨酶",
      u8"丙炔",
      u8"丙烯",
      u8"丙烯歧化",
      u8"丙烯气相法聚合",
      u8"丙烯氨解氧化流化床反应器",
      u8"丙烯水合",
      u8"丙烯画",
      u8"丙烯腈",
      u8"丙烯腈苯乙烯树脂",
      u8"丙烯酮",
      u8"丙烯酰胺",
      u8"丙烯酸",
      u8"丙烯酸酯",
      u8"丙烯酸酯化",
      u8"丙烯酸酯基托",
      u8"丙烯酸酯填塞",
      u8"丙烯酸酯夹板",
      u8"丙烯酸酯牙",
      u8"丙烯酸酯甲冠",
      u8"丙烯酸酯磨钻",
      u8"丙烯酸酯类聚合物",
      u8"丙烯醇",
      u8"丙烯醛",
      u8"丙烯醛树脂",
      u8"丙烷",
      u8"丙烷气",
      u8"丙烷脱沥青",
      u8"丙璜舒",
      u8"丙甲甘肽",
      u8"丙申",
      u8"丙磺舒",
      u8"丙种",
      u8"丙种射线",
      u8"丙稀",
      u8"丙稀酸",
      u8"丙等",
      u8"丙等体位",
      u8"丙类放大器",
      u8"丙级",
      u8"丙纶",
      u8"丙线",
      u8"丙肝",
      u8"丙辰",
      u8"丙酉",
      u8"丙酮",
      u8"丙酮酸",
      u8"丙酸",
      u8"丙醇",
      u8"丙醛",
      u8"丙项",
      u8"业业兢兢",
      u8"业业矜矜",
      u8"业主",
      u8"业主大会",
      u8"业主权益",
      u8"业主论坛",
      u8"业举",
      u8"业余",
      u8"业余人员",
      u8"业余大学",
      u8"业余教育",
      u8"业余时间",
      u8"业余比赛",
      u8"业余活动",
      u8"业余爱好",
      u8"业余爱好者",
      u8"业余生活",
      u8"业余组",
      u8"业余赛",
      u8"业余选手",
      u8"业内",
      u8"业内人士",
      u8"业别",
      u8"业务",
      u8"业务主管",
      u8"业务人员",
      u8"业务员",
      u8"业务培训",
      u8"业务学习",
      u8"业务局",
      u8"业务性",
      u8"业务收入",
      u8"业务楼",
      u8"业务水平",
      u8"业务流程",
      u8"业务知识",
      u8"业务科",
      u8"业务精",
      u8"业务素质",
      u8"业务经理",
      u8"业务经营许可证",
      u8"业务联系",
      u8"业务范围",
      u8"业务费",
      u8"业务部",
      u8"业务部门",
      u8"业务量",
      u8"业务量描述词",
      u8"业协会",
      u8"业大",
      u8"业委会",
      u8"业峻鸿绩",
      u8"业己",
      u8"业已",
      u8"业师",
      u8"业态",
      u8"业户",
      u8"业扩",
      u8"业报",
      u8"业界",
      u8"业界事件",
      u8"业精于勤",
      u8"业精于勤荒于嬉",
      u8"业经",
      u8"业绩",
      u8"业绩考核",
      u8"业者",
      u8"业迹",
      u8"业障",
      u8"丛不弃",
      u8"丛丛",
      u8"丛中",
      u8"丛书",
      u8"丛刊",
      u8"丛刻",
      u8"丛台区",
      u8"丛密",
      u8"丛山",
      u8"丛山峻岭",
      u8"丛式井口",
      u8"丛木",
      u8"丛杂",
      u8"丛林",
      u8"丛林区",
      u8"丛林地",
      u8"丛林地带",
      u8"丛林战",
      u8"丛植",
      u8"丛状型成釉细胞瘤",
      u8"丛珊",
      u8"丛生",
      u8"丛聚",
      u8"丛脞",
      u8"丛莽",
      u8"丛葬",
      u8"丛谈",
      u8"丛轻折轴",
      u8"丛雀渊鱼",
      u8"丛集",
      u8"丛鹏飞",
      u8"东一句西",
      u8"东一句西一句",
      u8"东丈",
      u8"东三环",
      u8"东三省",
      u8"东上",
      u8"东不压桥",
      u8"东不拉",
      u8"东东",
      u8"东中西部",
      u8"东丰",
      u8"东丰县",
      u8"东临",
      u8"东为",
      u8"东主",
      u8"东丽区",
      u8"东乌珠穆沁旗",
      u8"东乡",
      u8"东乡县",
      u8"东乡族",
      u8"东乡族自治县",
      u8"东二环",
      u8"东五环",
      u8"东亚",
      u8"东亚区",
      u8"东亚各国",
      u8"东亚国家",
      u8"东交民巷",
      u8"东京",
      u8"东京人",
      u8"东京国际",
      u8"东京大学",
      u8"东京市",
      u8"东京湾",
      u8"东京爱乐交响乐团",
      u8"东京爱情故事",
      u8"东京都",
      u8"东京银行",
      u8"东亭",
      u8"东佃",
      u8"东侧",
      u8"东便门",
      u8"东信",
      u8"东倒西歪",
      u8"东偷西摸",
      u8"东元",
      u8"东光",
      u8"东光县",
      u8"东兔西乌",
      u8"东六环",
      u8"东兰县",
      u8"东关",
      u8"东兴",
      u8"东兴区",
      u8"东兴市",
      u8"东冲西决",
      u8"东冲西撞",
      u8"东冲西突",
      u8"东到",
      u8"东加",
      u8"东加王国",
      u8"东劳西燕",
      u8"东势",
      u8"东势厝",
      u8"东北",
      u8"东北三省",
      u8"东北九省",
      u8"东北二人转",
      u8"东北亚",
      u8"东北人",
      u8"东北军",
      u8"东北区",
      u8"东北向",
      u8"东北地区",
      u8"东北地方",
      u8"东北大学",
      u8"东北师大",
      u8"东北师范大学",
      u8"东北方",
      u8"东北方向",
      u8"东北站",
      u8"东北网",
      u8"东北老",
      u8"东北菜",
      u8"东北虎",
      u8"东北角",
      u8"东北话",
      u8"东北财经",
      u8"东北边",
      u8"东北郊",
      u8"东北部",
      u8"东北面",
      u8"东北风",
      u8"东区",
      u8"东区人",
      u8"东升",
      u8"东半",
      u8"东半球",
      u8"东半边",
      u8"东华",
      u8"东华门",
      u8"东单",
      u8"东南",
      u8"东南之宝",
      u8"东南之秀",
      u8"东南之美",
      u8"东南亚",
      u8"东南亚国",
      u8"东南亚国家",
      u8"东南亚国家联盟",
      u8"东南亚虎",
      u8"东南区",
      u8"东南半壁",
      u8"东南向",
      u8"东南地区",
      u8"东南大学",
      u8"东南岸",
      u8"东南工专",
      u8"东南工业",
      u8"东南工业专科学校",
      u8"东南方",
      u8"东南欧",
      u8"东南汽车",
      u8"东南竹箭",
      u8"东南西北",
      u8"东南西北中",
      u8"东南角",
      u8"东南边",
      u8"东南造船厂",
      u8"东南部",
      u8"东南雀飞",
      u8"东南面",
      u8"东南风",
      u8"东印度",
      u8"东印度公司",
      u8"东印度群",
      u8"东印度群岛",
      u8"东厂",
      u8"东厢",
      u8"东去",
      u8"东县",
      u8"东台",
      u8"东台县",
      u8"东台市",
      u8"东史郎",
      u8"东向",
      u8"东向而望不见西墙",
      u8"东吴",
      u8"东吴大学",
      u8"东吴招亲",
      u8"东周",
      u8"东周刊",
      u8"东周时",
      u8"东周时代",
      u8"东周时期",
      u8"东四",
      u8"东四十条",
      u8"东四环",
      u8"东园",
      u8"东圃镇",
      u8"东土",
      u8"东坑乡",
      u8"东坑镇",
      u8"东坡",
      u8"东坡区",
      u8"东坡肉",
      u8"东城",
      u8"东城区",
      u8"东域",
      u8"东墙",
      u8"东墙处子",
      u8"东壁余光",
      u8"东声西击",
      u8"东大",
      u8"东大桥",
      u8"东大街",
      u8"东大路",
      u8"东央西告",
      u8"东央西浼",
      u8"东头",
      u8"东夷",
      u8"东奔西撞",
      u8"东奔西窜",
      u8"东奔西走",
      u8"东奔西跑",
      u8"东奔西逃",
      u8"东孚",
      u8"东学党",
      u8"东宁",
      u8"东宁县",
      u8"东安",
      u8"东安区",
      u8"东安县",
      u8"东宋镇",
      u8"东完西缺",
      u8"东宝",
      u8"东宝区",
      u8"东宫",
      u8"东宫太子",
      u8"东家",
      u8"东家效颦",
      u8"东家西舍",
      u8"东富",
      u8"东寺",
      u8"东寻西觅",
      u8"东尼",
      u8"东山",
      u8"东山之志",
      u8"东山乡",
      u8"东山再起",
      u8"东山区",
      u8"东山县",
      u8"东山复起",
      u8"东山岛",
      u8"东山高卧",
      u8"东岛",
      u8"东岳",
      u8"东岳庙",
      u8"东岳泰山",
      u8"东岸",
      u8"东峻",
      u8"东川",
      u8"东川区",
      u8"东川市",
      u8"东川路",
      u8"东差西误",
      u8"东巴",
      u8"东巴文",
      u8"东巴文化",
      u8"东市",
      u8"东市区",
      u8"东市朝衣",
      u8"东帝汶",
      u8"东干久",
      u8"东平",
      u8"东平县",
      u8"东平湖",
      u8"东平路",
      u8"东床",
      u8"东床之选",
      u8"东床佳婿",
      u8"东床坦腹",
      u8"东床姣婿",
      u8"东床娇婿",
      u8"东床娇客",
      u8"东床快婿",
      u8"东床择对",
      u8"东引",
      u8"东张西张",
      u8"东张西望",
      u8"东张西觑",
      u8"东征",
      u8"东征西怨",
      u8"东征西讨",
      u8"东徙西迁",
      u8"东德",
      u8"东怒西怨",
      u8"东怨西怒",
      u8"东成西就",
      u8"东扬西荡",
      u8"东扭西捏",
      u8"东扯西拉",
      u8"东扯西拽",
      u8"东扶西倒",
      u8"东抄西袭",
      u8"东投西窜",
      u8"东抹西涂",
      u8"东拉西扯",
      u8"东拦西阻",
      u8"东拼西凑",
      u8"东指",
      u8"东挦西扯",
      u8"东挦西撦",
      u8"东挨西撞",
      u8"东挪西借",
      u8"东挪西凑",
      u8"东挪西撮",
      u8"东捞西摸",
      u8"东捱西问",
      u8"东捻军",
      u8"东接",
      u8"东掩西遮",
      u8"东搜西罗",
      u8"东摇西摆",
      u8"东撙西节",
      u8"东播西流",
      u8"东支西吾",
      u8"东敲西敲",
      u8"东敲西逼",
      u8"东斯拉沃尼亚",
      u8"东新路",
      u8"东方",
      u8"东方不亮西方亮",
      u8"东方不败",
      u8"东方中学",
      u8"东方之珠",
      u8"东方人",
      u8"东方仗助",
      u8"东方光驱魔术师",
      u8"东方军事",
      u8"东方千骑",
      u8"东方发白",
      u8"东方国家",
      u8"东方城",
      u8"东方夜谭",
      u8"东方女性",
      u8"东方学",
      u8"东方将白",
      u8"东方工专",
      u8"东方市",
      u8"东方影都",
      u8"东方快车",
      u8"东方文化",
      u8"东方日报",
      u8"东方时空",
      u8"东方明珠",
      u8"东方朔",
      u8"东方未曙",
      u8"东方歌舞团",
      u8"东方玉",
      u8"东方红",
      u8"东方红一号",
      u8"东方红三号",
      u8"东方红二号甲",
      u8"东方网景",
      u8"东方美女",
      u8"东方艺术",
      u8"东方财经",
      u8"东方路",
      u8"东方通信",
      u8"东方闻樱",
      u8"东方黎族自治县",
      u8"东方龙",
      u8"东施",
      u8"东施效颦",
      u8"东昌区",
      u8"东昌府区",
      u8"东昌路",
      u8"东明",
      u8"东明县",
      u8"东明路",
      u8"东映",
      u8"东晋",
      u8"东晋时",
      u8"东晋时代",
      u8"东晋时期",
      u8"东曦既驾",
      u8"东有",
      u8"东望西观",
      u8"东来",
      u8"东来西去",
      u8"东来顺",
      u8"东林党",
      u8"东林寺",
      u8"东柏坡",
      u8"东柏林",
      u8"东桥",
      u8"东森",
      u8"东横西倒",
      u8"东欧",
      u8"东欧各国",
      u8"东欧国家",
      u8"东欧平原",
      u8"东正教",
      u8"东段",
      u8"东汉",
      u8"东汉人",
      u8"东汉时",
      u8"东汉时代",
      u8"东汉时期",
      u8"东江",
      u8"东江镇",
      u8"东汽",
      u8"东汽一中",
      u8"东沙",
      u8"东沙群岛",
      u8"东沟",
      u8"东沟县",
      u8"东河",
      u8"东河区",
      u8"东河塘",
      u8"东洋",
      u8"东洋兰",
      u8"东洋刀",
      u8"东洋味",
      u8"东洋大海",
      u8"东洋界",
      u8"东洋车",
      u8"东洲区",
      u8"东流",
      u8"东流西上",
      u8"东流西窜",
      u8"东流西落",
      u8"东海",
      u8"东海县",
      u8"东海大学",
      u8"东海岸",
      u8"东海广场",
      u8"东海扬尘",
      u8"东海捞针",
      u8"东海水晶",
      u8"东海电脑",
      u8"东海电脑股份有限公司",
      u8"东海路",
      u8"东海逝波",
      u8"东海道",
      u8"东海郡",
      u8"东海鲸波",
      u8"东涂西抹",
      u8"东渐",
      u8"东渡",
      u8"东渡路",
      u8"东港",
      u8"东港区",
      u8"东港市",
      u8"东游",
      u8"东游西逛",
      u8"东游记",
      u8"东湖",
      u8"东湖区",
      u8"东湖国小",
      u8"东湖路",
      u8"东源",
      u8"东源县",
      u8"东滚西爬",
      u8"东滩",
      u8"东滩矿",
      u8"东瀛",
      u8"东爱",
      u8"东猎西渔",
      u8"东猜西揣",
      u8"东猜西疑",
      u8"东环路",
      u8"东瓜",
      u8"东瓦窑",
      u8"东盟",
      u8"东盟国家",
      u8"东直门",
      u8"东看西看",
      u8"东睃西望",
      u8"东瞧西望",
      u8"东瞧西瞧",
      u8"东石",
      u8"东砍西斫",
      u8"东碰西撞",
      u8"东磁",
      u8"东磕西撞",
      u8"东移",
      u8"东穿西撞",
      u8"东突",
      u8"东突厥",
      u8"东突厥斯坦",
      u8"东窗事发",
      u8"东窗事犯",
      u8"东窗消息",
      u8"东窗计",
      u8"东站",
      u8"东端",
      u8"东笋",
      u8"东箭南金",
      u8"东线",
      u8"东经",
      u8"东罗马帝国",
      u8"东羲既驾",
      u8"东翁",
      u8"东耶路撒冷",
      u8"东聊",
      u8"东联",
      u8"东胜",
      u8"东胜区",
      u8"东胜市",
      u8"东胡",
      u8"东至",
      u8"东至县",
      u8"东航",
      u8"东芝",
      u8"东荡西除",
      u8"东荡西驰",
      u8"东莞",
      u8"东莞市",
      u8"东莱",
      u8"东莱街",
      u8"东营",
      u8"东营区",
      u8"东营市",
      u8"东萨摩亚",
      u8"东藏西躲",
      u8"东行",
      u8"东街",
      u8"东街口",
      u8"东补西凑",
      u8"东西",
      u8"东西南北",
      u8"东西南北中",
      u8"东西南北人",
      u8"东西南北客",
      u8"东西南朔",
      u8"东西向",
      u8"东西方",
      u8"东西方关系",
      u8"东西易面",
      u8"东西欧",
      u8"东西湖",
      u8"东西湖区",
      u8"东西部",
      u8"东观之殃",
      u8"东观续史",
      u8"东观西望",
      u8"东角",
      u8"东讨西伐",
      u8"东讨西征",
      u8"东诓西骗",
      u8"东谈西说",
      u8"东购",
      u8"东走西撞",
      u8"东走西顾",
      u8"东趋西步",
      u8"东跑西颠",
      u8"东路",
      u8"东踅西倒",
      u8"东躲西藏",
      u8"东躲西跑",
      u8"东辛房",
      u8"东边",
      u8"东边日头西边雨",
      u8"东辽",
      u8"东辽县",
      u8"东迁西徙",
      u8"东进",
      u8"东逃西散",
      u8"东逃西窜",
      u8"东道",
      u8"东道主",
      u8"东道主人",
      u8"东道之谊",
      u8"东道国",
      u8"东遮西掩",
      u8"东邦",
      u8"东邪",
      u8"东邪西毒",
      u8"东邻西舍",
      u8"东郊",
      u8"东部",
      u8"东部地区",
      u8"东郭",
      u8"东郭先生",
      u8"东都",
      u8"东野巴人",
      u8"东野败驾",
      u8"东量西折",
      u8"东钱湖",
      u8"东门",
      u8"东门国小",
      u8"东门外",
      u8"东门屿",
      u8"东门市场",
      u8"东门礁",
      u8"东门路",
      u8"东门逐兔",
      u8"东门黄犬",
      u8"东闪西挪",
      u8"东闪西躲",
      u8"东闯西走",
      u8"东闯西踱",
      u8"东阳",
      u8"东阳县",
      u8"东阳市",
      u8"东阳镇",
      u8"东阿",
      u8"东阿县",
      u8"东陵",
      u8"东陵区",
      u8"东隅已逝",
      u8"东隅已逝桑榆非晚",
      u8"东零西散",
      u8"东零西碎",
      u8"东零西落",
      u8"东非",
      u8"东非共同市场",
      u8"东非各国",
      u8"东非国家",
      u8"东面",
      u8"东顺城街",
      u8"东风",
      u8"东风人",
      u8"东风人面",
      u8"东风入律",
      u8"东风公司",
      u8"东风剧场",
      u8"东风化雨",
      u8"东风区",
      u8"东风压倒西风",
      u8"东风吹马耳",
      u8"东风呢个网",
      u8"东风宽带网",
      u8"东风射马耳",
      u8"东风忘",
      u8"东风悦达",
      u8"东风教育",
      u8"东风教育王",
      u8"东风汽车",
      u8"东风汽车公司",
      u8"东风浩荡",
      u8"东风游戏基地",
      u8"东风游戏论坛",
      u8"东风热线",
      u8"东风电信",
      u8"东风电视台",
      u8"东风破",
      u8"东风论坛",
      u8"东风路",
      u8"东风过耳",
      u8"东风通信",
      u8"东风雪铁龙",
      u8"东风音乐基地",
      u8"东风马耳",
      u8"东飘西徙",
      u8"东飘西泊",
      u8"东飘西荡",
      u8"东食西宿",
      u8"东驰西击",
      u8"东驰西撞",
      u8"东驰西骋",
      u8"东魏",
      u8"东鳞西爪",
      u8"东鸣西应",
      u8"东鹏",
      u8"丝丝",
      u8"丝丝入扣",
      u8"丝丝缕缕",
      u8"丝光",
      u8"丝光处理",
      u8"丝光棉",
      u8"丝兰",
      u8"丝包线",
      u8"丝印",
      u8"丝印机",
      u8"丝厂",
      u8"丝发之功",
      u8"丝图腾",
      u8"丝巾",
      u8"丝布",
      u8"丝帕",
      u8"丝带",
      u8"丝弦",
      u8"丝恩发怨",
      u8"丝扣粘结剂",
      u8"丝挂子",
      u8"丝料",
      u8"丝束",
      u8"丝杠",
      u8"丝来线去",
      u8"丝板",
      u8"丝极",
      u8"丝棉",
      u8"丝毫",
      u8"丝毫不",
      u8"丝毫不少",
      u8"丝毫不差",
      u8"丝毫不爽",
      u8"丝毫无损",
      u8"丝氨酸",
      u8"丝状",
      u8"丝瓜",
      u8"丝瓜布",
      u8"丝瓜络",
      u8"丝瓜藤",
      u8"丝竹",
      u8"丝竹空",
      u8"丝竹管弦",
      u8"丝米",
      u8"丝糕",
      u8"丝素",
      u8"丝线",
      u8"丝织",
      u8"丝织厂",
      u8"丝织品",
      u8"丝织版",
      u8"丝织物",
      u8"丝绒",
      u8"丝绒布",
      u8"丝结",
      u8"丝绘",
      u8"丝绢",
      u8"丝绳",
      u8"丝绵",
      u8"丝绵被",
      u8"丝绸",
      u8"丝绸之路",
      u8"丝绸厂宿舍",
      u8"丝绸品",
      u8"丝绸服装",
      u8"丝绸版",
      u8"丝绸面料",
      u8"丝缕",
      u8"丝网",
      u8"丝胶",
      u8"丝苏氨酸蛋白酶",
      u8"丝萝",
      u8"丝虫",
      u8"丝虫病",
      u8"丝蝇",
      u8"丝衣",
      u8"丝袜",
      u8"丝袜图",
      u8"丝袜美女",
      u8"丝袜美腿",
      u8"丝裂原",
      u8"丝裂原活化蛋白激酶",
      u8"丝裂霉素",
      u8"丝质",
      u8"丝质体",
      u8"丝路",
      u8"丝路之旅",
      u8"丝都",
      u8"丝锥",
      u8"丞相",
      u8"丟不起那人",
      u8"丟了",
      u8"丟档",
      u8"丟車保帅",
      u8"丢三忘四",
      u8"丢三落四",
      u8"丢上",
      u8"丢上去",
      u8"丢上来",
      u8"丢下",
      u8"丢下不管",
      u8"丢下去",
      u8"丢下来",
      u8"丢下耙儿弄扫帚",
      u8"丢丑",
      u8"丢乌纱帽",
      u8"丢了",
      u8"丢了棒",
      u8"丢了西瓜捡芝麻",
      u8"丢人",
      u8"丢人现眼",
      u8"丢份儿",
      u8"丢入",
      u8"丢分",
      u8"丢到",
      u8"丢卒保车",
      u8"丢却",
      u8"丢去",
      u8"丢在",
      u8"丢在脑后",
      u8"丢失",
      u8"丢帧",
      u8"丢开",
      u8"丢弃",
      u8"丢得",
      u8"丢手",
      u8"丢手不管",
      u8"丢掉",
      u8"丢掷",
      u8"丢盔卸甲",
      u8"丢盔弃甲",
      u8"丢盔抛甲",
      u8"丢眼色",
      u8"丢给",
      u8"丢置",
      u8"丢置不管",
      u8"丢脸",
      u8"丢词",
      u8"丢起",
      u8"丢起来",
      u8"丢钱",
      u8"丢面",
      u8"丢面子",
      u8"丢魂丢魄",
      u8"丢魂丧胆",
      u8"丢魂失魄",
      u8"丢魂落魄",
      u8"两万",
      u8"两万个",
      u8"两万五千里长征",
      u8"两万人",
      u8"两万元",
      u8"两万块",
      u8"两三",
      u8"两下",
      u8"两下子",
      u8"两不找",
      u8"两不相干",
      u8"两不误",
      u8"两世为人",
      u8"两两",
      u8"两两三三",
      u8"两个",
      u8"两个中国",
      u8"两个人",
      u8"两个凡是",
      u8"两个基本点",
      u8"两个字",
      u8"两个文明",
      u8"两个文明建设",
      u8"两个方面",
      u8"两个月",
      u8"两个转变",
      u8"两亲",
      u8"两亲性",
      u8"两人",
      u8"两人份",
      u8"两人常和对策",
      u8"两亿",
      u8"两亿人",
      u8"两亿元",
      u8"两代",
      u8"两代人",
      u8"两仪",
      u8"两件",
      u8"两件事",
      u8"两件套",
      u8"两任",
      u8"两份",
      u8"两伊",
      u8"两会",
      u8"两位",
      u8"两位数",
      u8"两侧",
      u8"两便",
      u8"两倍",
      u8"两元",
      u8"两克",
      u8"两党",
      u8"两党关系",
      u8"两党制",
      u8"两全",
      u8"两全其美",
      u8"两公司",
      u8"两公开",
      u8"两关",
      u8"两具",
      u8"两册",
      u8"两军",
      u8"两军人马",
      u8"两刀",
      u8"两分",
      u8"两分法",
      u8"两分钟",
      u8"两则",
      u8"两利",
      u8"两制",
      u8"两剂",
      u8"两包",
      u8"两匹马",
      u8"两千",
      u8"两千个",
      u8"两千人",
      u8"两千元",
      u8"两千块",
      u8"两半",
      u8"两半球",
      u8"两卷",
      u8"两厅",
      u8"两厢",
      u8"两厢情愿",
      u8"两厢版",
      u8"两厢车",
      u8"两双",
      u8"两口",
      u8"两口儿",
      u8"两口子",
      u8"两口气",
      u8"两句",
      u8"两句诗",
      u8"两句话",
      u8"两只",
      u8"两只手",
      u8"两只鱼",
      u8"两可",
      u8"两可之间",
      u8"两可离子",
      u8"两台",
      u8"两叶",
      u8"两叶掩目",
      u8"两号",
      u8"两名",
      u8"两员",
      u8"两周",
      u8"两周年",
      u8"两回",
      u8"两回事",
      u8"两国",
      u8"两国之间",
      u8"两国人民",
      u8"两国关系",
      u8"两国政府",
      u8"两国论",
      u8"两国间",
      u8"两圆",
      u8"两圈",
      u8"两地",
      u8"两地分居",
      u8"两地相思",
      u8"两场",
      u8"两块",
      u8"两块钱",
      u8"两基",
      u8"两堆",
      u8"两声",
      u8"两壶",
      u8"两处茫茫皆不见",
      u8"两夜",
      u8"两大",
      u8"两大块",
      u8"两大洲",
      u8"两大片",
      u8"两大类",
      u8"两大阵营",
      u8"两天",
      u8"两天晒网",
      u8"两头",
      u8"两头三绪",
      u8"两头三面",
      u8"两头不到岸",
      u8"两头为难",
      u8"两头和番",
      u8"两头小中间大",
      u8"两头尖",
      u8"两头白面",
      u8"两头空",
      u8"两头落空",
      u8"两头蛇",
      u8"两头跑",
      u8"两套",
      u8"两女",
      u8"两女一男",
      u8"两女两男",
      u8"两姐妹",
      u8"两委",
      u8"两姨亲",
      u8"两字词",
      u8"两季",
      u8"两宋时代",
      u8"两审",
      u8"两审终审",
      u8"两审终审制",
      u8"两客",
      u8"两害相权",
      u8"两害相权取其轻",
      u8"两家",
      u8"两家人",
      u8"两对",
      u8"两对半",
      u8"两封",
      u8"两封信",
      u8"两小无猜",
      u8"两小时",
      u8"两尾",
      u8"两局",
      u8"两层",
      u8"两层楼",
      u8"两居室",
      u8"两届",
      u8"两岁",
      u8"两岁半",
      u8"两岸",
      u8"两岸三地",
      u8"两岸人民",
      u8"两岸关系",
      u8"两岸猿声啼不住",
      u8"两岸通航",
      u8"两市",
      u8"两师",
      u8"两席",
      u8"两幕间",
      u8"两年",
      u8"两年制",
      u8"两年来",
      u8"两年生",
      u8"两广",
      u8"两广总督",
      u8"两度",
      u8"两座",
      u8"两式",
      u8"两张",
      u8"两张床",
      u8"两张牌",
      u8"两张皮",
      u8"两弹",
      u8"两弹一星",
      u8"两当县",
      u8"两得其便",
      u8"两德",
      u8"两忘",
      u8"两性",
      u8"两性之间",
      u8"两性人",
      u8"两性关系",
      u8"两性现象",
      u8"两性生殖",
      u8"两性生活",
      u8"两性用品",
      u8"两性知识",
      u8"两性离子",
      u8"两性空间",
      u8"两性胶体",
      u8"两性花",
      u8"两性融合",
      u8"两性话题",
      u8"两性间",
      u8"两性霉素",
      u8"两情相悦",
      u8"两情若是长久时",
      u8"两情遣眷",
      u8"两意三心",
      u8"两成",
      u8"两截",
      u8"两截式",
      u8"两户",
      u8"两房",
      u8"两房一厅",
      u8"两房两厅",
      u8"两扇",
      u8"两扇门",
      u8"两手",
      u8"两手俱利",
      u8"两手抓",
      u8"两手掌",
      u8"两手硬",
      u8"两手空空",
      u8"两手都要硬",
      u8"两打",
      u8"两批",
      u8"两把",
      u8"两把刷子",
      u8"两抵",
      u8"两拍",
      u8"两招",
      u8"两拨",
      u8"两拳",
      u8"两排",
      u8"两支",
      u8"两方",
      u8"两方面",
      u8"两旁",
      u8"两无",
      u8"两日",
      u8"两日份",
      u8"两日游",
      u8"两晋",
      u8"两晋时代",
      u8"两晚",
      u8"两月",
      u8"两期",
      u8"两本",
      u8"两本书",
      u8"两朵",
      u8"两朵花",
      u8"两机",
      u8"两权分离",
      u8"两权分立",
      u8"两杆",
      u8"两杠",
      u8"两条",
      u8"两条线",
      u8"两条腿",
      u8"两条腿走",
      u8"两条腿走路",
      u8"两条船",
      u8"两条路",
      u8"两条路线",
      u8"两条道路",
      u8"两杯",
      u8"两板",
      u8"两极",
      u8"两极分化",
      u8"两极化",
      u8"两极管",
      u8"两枚",
      u8"两枝",
      u8"两枪",
      u8"两架",
      u8"两栋",
      u8"两栖",
      u8"两栖作战",
      u8"两栖动物",
      u8"两栖植物",
      u8"两栖登陆",
      u8"两栖类",
      u8"两栖纲",
      u8"两栖舰",
      u8"两栖部队",
      u8"两样",
      u8"两根",
      u8"两格",
      u8"两档",
      u8"两桶",
      u8"两梯",
      u8"两梯次",
      u8"两棵",
      u8"两棵树",
      u8"两次",
      u8"两次三番",
      u8"两次曝光",
      u8"两次运球",
      u8"两款",
      u8"两步",
      u8"两步走",
      u8"两段",
      u8"两段制",
      u8"两段式",
      u8"两段票",
      u8"两毛",
      u8"两汉",
      u8"两江",
      u8"两河",
      u8"两河镇",
      u8"两法",
      u8"两派",
      u8"两派人马",
      u8"两浙",
      u8"两淮",
      u8"两清",
      u8"两湖",
      u8"两湖总督",
      u8"两湖盆地",
      u8"两湾城",
      u8"两滴",
      u8"两潘",
      u8"两点",
      u8"两点水",
      u8"两点论",
      u8"两点钟",
      u8"两点阈",
      u8"两片",
      u8"两版",
      u8"两班",
      u8"两班制",
      u8"两瓣",
      u8"两瓶",
      u8"两用",
      u8"两用人才",
      u8"两用人材",
      u8"两用品",
      u8"两用型",
      u8"两用机",
      u8"两用衫",
      u8"两男",
      u8"两男一女",
      u8"两男两女",
      u8"两百",
      u8"两百个",
      u8"两百人",
      u8"两百元",
      u8"两百块",
      u8"两盅",
      u8"两相",
      u8"两相宜",
      u8"两相情原",
      u8"两相情愿",
      u8"两相系统",
      u8"两省",
      u8"两省区",
      u8"两眼",
      u8"两眼发呆",
      u8"两眼发直",
      u8"两睡",
      u8"两瞽相扶",
      u8"两码",
      u8"两码事",
      u8"两码子",
      u8"两码见字",
      u8"两碗",
      u8"两碗饭",
      u8"两票",
      u8"两种",
      u8"两种人",
      u8"两种信号系统学说",
      u8"两种制度",
      u8"两种记忆说",
      u8"两科",
      u8"两秒",
      u8"两秒钟",
      u8"两税",
      u8"两立",
      u8"两端",
      u8"两笔",
      u8"两筒",
      u8"两箱",
      u8"两篇",
      u8"两类",
      u8"两粒",
      u8"两粒装",
      u8"两粤",
      u8"两粤总督",
      u8"两级",
      u8"两组",
      u8"两缸",
      u8"两翼",
      u8"两翼刮刀钻头",
      u8"两者",
      u8"两者之间",
      u8"两者缺一不可",
      u8"两者都",
      u8"两耳",
      u8"两耳不闻窗外事",
      u8"两耳塞豆",
      u8"两联",
      u8"两联式",
      u8"两肋",
      u8"两肋插刀",
      u8"两肩",
      u8"两肩荷口",
      u8"两胎",
      u8"两胜",
      u8"两脚",
      u8"两脚一蹬",
      u8"两脚书橱",
      u8"两脚居间",
      u8"两脚规",
      u8"两脚野狐",
      u8"两腮",
      u8"两腿",
      u8"两臂",
      u8"两般三样",
      u8"两船",
      u8"两节",
      u8"两节课",
      u8"两虎相争",
      u8"两虎相斗",
      u8"两虎相斗必有一伤",
      u8"两行",
      u8"两袈",
      u8"两袋",
      u8"两袖",
      u8"两袖清风",
      u8"两角",
      u8"两讫",
      u8"两记",
      u8"两课",
      u8"两豆塞耳",
      u8"两败俱伤",
      u8"两败具伤",
      u8"两起",
      u8"两跑楼梯",
      u8"两路",
      u8"两路横队",
      u8"两路纵队",
      u8"两轮",
      u8"两辆",
      u8"两辆车",
      u8"两边",
      u8"两边倒",
      u8"两边讨好",
      u8"两连",
      u8"两连胜",
      u8"两连败",
      u8"两通",
      u8"两造",
      u8"两遍",
      u8"两道",
      u8"两道三科",
      u8"两道菜",
      u8"两部",
      u8"两部分",
      u8"两部委",
      u8"两部戏",
      u8"两部鼓吹",
      u8"两重",
      u8"两重天",
      u8"两重性",
      u8"两重意义",
      u8"两钱",
      u8"两锅",
      u8"两键",
      u8"两门课",
      u8"两间",
      u8"两间房",
      u8"两队",
      u8"两阶",
      u8"两院",
      u8"两院制",
      u8"两难",
      u8"两雄不并立",
      u8"两集",
      u8"两霸",
      u8"两面",
      u8"两面三刀",
      u8"两面二舌",
      u8"两面人",
      u8"两面作战",
      u8"两面倒",
      u8"两面光",
      u8"两面夹攻",
      u8"两面性",
      u8"两面手法",
      u8"两面派",
      u8"两面讨好",
      u8"两面针",
      u8"两页",
      u8"两项",
      u8"两颊",
      u8"两颗",
      u8"两颗心",
      u8"两题",
      u8"两首",
      u8"两首歌",
      u8"两高一优",
      u8"两鬃苍苍",
      u8"两鬓",
      u8"两鬓如霜",
      u8"两鼠斗穴",
      u8"严三星",
      u8"严丝合缝",
      u8"严严",
      u8"严严实实",
      u8"严严密密",
      u8"严严格格",
      u8"严于",
      u8"严于律己",
      u8"严于律已",
      u8"严令",
      u8"严令禁止",
      u8"严以律己",
      u8"严以律己宽以待人",
      u8"严以自律",
      u8"严修",
      u8"严冬",
      u8"严刑",
      u8"严刑峻制",
      u8"严刑峻法",
      u8"严刑峻罚",
      u8"严刑拷打",
      u8"严办",
      u8"严加",
      u8"严加惩处",
      u8"严加戒备",
      u8"严加管教",
      u8"严加防范",
      u8"严厉",
      u8"严厉打击",
      u8"严厉批评",
      u8"严厉查处",
      u8"严命",
      u8"严处",
      u8"严复",
      u8"严妈妈",
      u8"严守",
      u8"严守一",
      u8"严守中立",
      u8"严守纪律",
      u8"严实",
      u8"严家岗",
      u8"严家淦",
      u8"严家饿隶",
      u8"严宽",
      u8"严密",
      u8"严密性",
      u8"严密性试验",
      u8"严密掌握",
      u8"严密控制",
      u8"严寒",
      u8"严寒季节",
      u8"严寒酷暑",
      u8"严察",
      u8"严峻",
      u8"严峻地",
      u8"严峻形势",
      u8"严峻考验",
      u8"严嵩",
      u8"严师",
      u8"严师出高徒",
      u8"严律",
      u8"严惩",
      u8"严惩不怠",
      u8"严惩不贷",
      u8"严惩凶手",
      u8"严打",
      u8"严打斗争",
      u8"严把",
      u8"严抓",
      u8"严控",
      u8"严政",
      u8"严整",
      u8"严斥",
      u8"严明",
      u8"严明法纪",
      u8"严晓群",
      u8"严晓频",
      u8"严查",
      u8"严格",
      u8"严格主义",
      u8"严格凸",
      u8"严格双曲性",
      u8"严格地",
      u8"严格执法",
      u8"严格执行",
      u8"严格把关",
      u8"严格控制",
      u8"严格教育",
      u8"严格来说",
      u8"严格监督",
      u8"严格管理",
      u8"严格纪律",
      u8"严格考核",
      u8"严格要求",
      u8"严格训练",
      u8"严格误差限",
      u8"严格说来",
      u8"严格遵守",
      u8"严正",
      u8"严正声明",
      u8"严气正性",
      u8"严汉青",
      u8"严治",
      u8"严法",
      u8"严法峻刑",
      u8"严父",
      u8"严父慈母",
      u8"严禁",
      u8"严禁吸烟",
      u8"严禁烟火",
      u8"严竣",
      u8"严管",
      u8"严紧",
      u8"严纲",
      u8"严细",
      u8"严肃",
      u8"严肃处理",
      u8"严肃性",
      u8"严肃查处",
      u8"严肃认真",
      u8"严胜",
      u8"严苛",
      u8"严要求",
      u8"严词",
      u8"严词拒绝",
      u8"严谨",
      u8"严谨性",
      u8"严责",
      u8"严辞",
      u8"严酷",
      u8"严酷性",
      u8"严重",
      u8"严重不足",
      u8"严重事故",
      u8"严重危害",
      u8"严重后果",
      u8"严重困难",
      u8"严重地",
      u8"严重威胁",
      u8"严重局面",
      u8"严重影响",
      u8"严重性",
      u8"严重情况",
      u8"严重损失",
      u8"严重破坏",
      u8"严重错误",
      u8"严重问题",
      u8"严防",
      u8"严防死守",
      u8"严防豪雨",
      u8"严阵",
      u8"严阵以待",
      u8"严陈以待",
      u8"严霜",
      u8"严顺开",
      u8"严颜",
      u8"丧主",
      u8"丧乱",
      u8"丧事",
      u8"丧亡",
      u8"丧亲之痛",
      u8"丧假",
      u8"丧偶",
      u8"丧偶之痛",
      u8"丧命",
      u8"丧天害理",
      u8"丧夫",
      u8"丧夫之痛",
      u8"丧失",
      u8"丧失了",
      u8"丧失殆尽",
      u8"丧失理智",
      u8"丧失者",
      u8"丧失能力",
      u8"丧妻",
      u8"丧妻之痛",
      u8"丧家",
      u8"丧家之犬",
      u8"丧家之狗",
      u8"丧家狗",
      u8"丧尸",
      u8"丧尽天良",
      u8"丧居",
      u8"丧师辱国",
      u8"丧心病狂",
      u8"丧志",
      u8"丧手",
      u8"丧明之痛",
      u8"丧服",
      u8"丧权辱国",
      u8"丧母",
      u8"丧母之痛",
      u8"丧气",
      u8"丧气话",
      u8"丧父",
      u8"丧父之痛",
      u8"丧生",
      u8"丧生者",
      u8"丧礼",
      u8"丧胆",
      u8"丧胆亡魂",
      u8"丧胆游魂",
      u8"丧胆销魂",
      u8"丧葬",
      u8"丧葬费",
      u8"丧身",
      u8"丧身失节",
      u8"丧钟",
      u8"丧门",
      u8"丧门星",
      u8"丧门神",
      u8"丧门鬼",
      u8"丧魂失魄",
      u8"丧魂落魄",
      u8"个个",
      u8"个中",
      u8"个中三味",
      u8"个中之味",
      u8"个中内情",
      u8"个中妙趣",
      u8"个中滋味",
      u8"个人",
      u8"个人专辑",
      u8"个人主义",
      u8"个人主页",
      u8"个人住房",
      u8"个人保险",
      u8"个人信息",
      u8"个人信用",
      u8"个人修养",
      u8"个人倾向性",
      u8"个人党性",
      u8"个人全能",
      u8"个人兴趣",
      u8"个人冠军",
      u8"个人利益",
      u8"个人制做",
      u8"个人努力",
      u8"个人化",
      u8"个人卫生",
      u8"个人头像",
      u8"个人崇拜",
      u8"个人帐户",
      u8"个人得失",
      u8"个人思想",
      u8"个人性",
      u8"个人感觉",
      u8"个人成分",
      u8"个人成长",
      u8"个人所得",
      u8"个人所得税",
      u8"个人承包",
      u8"个人收入",
      u8"个人收入调节税",
      u8"个人文件夹",
      u8"个人文集",
      u8"个人日记",
      u8"个人档案",
      u8"个人消费",
      u8"个人演唱会",
      u8"个人爱好",
      u8"个人版",
      u8"个人特长",
      u8"个人独资",
      u8"个人用品",
      u8"个人用户",
      u8"个人电脑",
      u8"个人相册",
      u8"个人空间",
      u8"个人简介",
      u8"个人简历",
      u8"个人经历",
      u8"个人能力",
      u8"个人自传",
      u8"个人艺术",
      u8"个人行为",
      u8"个人见解",
      u8"个人观点",
      u8"个人计算机",
      u8"个人认为",
      u8"个人词库",
      u8"个人词汇",
      u8"个人说明",
      u8"个人财产",
      u8"个人账户",
      u8"个人资料",
      u8"个人赛",
      u8"个人身份",
      u8"个人问题",
      u8"个人隐私",
      u8"个人风格",
      u8"个位",
      u8"个位数",
      u8"个体",
      u8"个体劳动",
      u8"个体劳动者",
      u8"个体化",
      u8"个体发育",
      u8"个体变元",
      u8"个体工商户",
      u8"个体差异",
      u8"个体户",
      u8"个体所有",
      u8"个体所有制",
      u8"个体手工",
      u8"个体手工业",
      u8"个体承包",
      u8"个体经济",
      u8"个体经营",
      u8"个体经营者",
      u8"个体老板",
      u8"个体营运户",
      u8"个例",
      u8"个儿",
      u8"个别",
      u8"个别人",
      u8"个别命令",
      u8"个别地",
      u8"个别差异",
      u8"个别性",
      u8"个别情况",
      u8"个别托盘",
      u8"个别指导",
      u8"个别教学",
      u8"个别测验",
      u8"个别现象",
      u8"个别生产",
      u8"个别生产价格",
      u8"个别谈话",
      u8"个别辅导",
      u8"个协",
      u8"个唱",
      u8"个大",
      u8"个头",
      u8"个头儿",
      u8"个子",
      u8"个字",
      u8"个字元",
      u8"个字符",
      u8"个展",
      u8"个度",
      u8"个性",
      u8"个性化",
      u8"个性头像",
      u8"个性标记",
      u8"个性特征",
      u8"个性特点",
      u8"个把",
      u8"个把月",
      u8"个数",
      u8"个旧",
      u8"个旧市",
      u8"个月",
      u8"个案",
      u8"个案研究",
      u8"个案纪录",
      u8"个私",
      u8"个税法",
      u8"个股",
      u8"个贷",
      u8"个里",
      u8"丫丫",
      u8"丫丫币",
      u8"丫头",
      u8"丫头帮",
      u8"丫嬛",
      u8"丫子",
      u8"丫杈",
      u8"丫环",
      u8"丫鬟",
      u8"中一",
      u8"中三",
      u8"中上",
      u8"中上层",
      u8"中上游",
      u8"中上程度",
      u8"中上等",
      u8"中上级",
      u8"中上阶层",
      u8"中上阶级",
      u8"中下",
      u8"中下层",
      u8"中下旬",
      u8"中下游",
      u8"中下祸根",
      u8"中下程度",
      u8"中下等",
      u8"中下级",
      u8"中下阶层",
      u8"中下阶级",
      u8"中不溜",
      u8"中不溜儿",
      u8"中不边界",
      u8"中专",
      u8"中专处",
      u8"中专学校",
      u8"中专文化",
      u8"中专班",
      u8"中专生",
      u8"中世",
      u8"中世纪",
      u8"中东",
      u8"中东国家",
      u8"中东地区",
      u8"中东战争",
      u8"中东欧",
      u8"中东问题",
      u8"中举",
      u8"中义",
      u8"中义关系",
      u8"中乐",
      u8"中书令",
      u8"中书省",
      u8"中了",
      u8"中了铅毒",
      u8"中二",
      u8"中云",
      u8"中井贵一",
      u8"中亚",
      u8"中亚国家",
      u8"中亚地区",
      u8"中产",
      u8"中产者",
      u8"中产阶级",
      u8"中亭街",
      u8"中人",
      u8"中人网",
      u8"中介",
      u8"中介人",
      u8"中介代理",
      u8"中介子",
      u8"中介方",
      u8"中介机构",
      u8"中介现象",
      u8"中介组织",
      u8"中介费",
      u8"中仑",
      u8"中仑站",
      u8"中代",
      u8"中价",
      u8"中伏",
      u8"中休",
      u8"中会",
      u8"中伤",
      u8"中位值",
      u8"中位数",
      u8"中位沼泽",
      u8"中低",
      u8"中低产田",
      u8"中低层",
      u8"中低收入",
      u8"中低收入者",
      u8"中低档",
      u8"中低级",
      u8"中体",
      u8"中体网",
      u8"中使",
      u8"中俄",
      u8"中俄关系",
      u8"中俄军演",
      u8"中俄友好条约",
      u8"中保",
      u8"中信",
      u8"中信实业银行",
      u8"中值",
      u8"中储",
      u8"中允",
      u8"中元",
      u8"中元节",
      u8"中共",
      u8"中共一大",
      u8"中共七大",
      u8"中共三大",
      u8"中共中央",
      u8"中共中央办公厅",
      u8"中共中央国务院",
      u8"中共中央总书记",
      u8"中共中央政治局",
      u8"中共中央政治局委员",
      u8"中共中央政治局常委",
      u8"中共二大",
      u8"中共党史",
      u8"中共党员",
      u8"中共军队",
      u8"中共广东",
      u8"中共政府",
      u8"中共福建省委",
      u8"中关村",
      u8"中关村在线",
      u8"中兴",
      u8"中兴大业",
      u8"中兴大学",
      u8"中兴小学",
      u8"中兴新村",
      u8"中兴法商",
      u8"中兴法商学院",
      u8"中兴路",
      u8"中册",
      u8"中冓之言",
      u8"中军",
      u8"中军帐",
      u8"中农",
      u8"中准价",
      u8"中凯",
      u8"中凯文化",
      u8"中出",
      u8"中分",
      u8"中切",
      u8"中到大雪",
      u8"中剖定理",
      u8"中副",
      u8"中办",
      u8"中办发",
      u8"中办国办",
      u8"中加",
      u8"中北",
      u8"中北大学",
      u8"中北欧",
      u8"中北美",
      u8"中北路",
      u8"中北部",
      u8"中北部地区",
      u8"中北非",
      u8"中区",
      u8"中医",
      u8"中医中药",
      u8"中医医院",
      u8"中医学",
      u8"中医学院",
      u8"中医师",
      u8"中医理论",
      u8"中医界",
      u8"中医疗法",
      u8"中医肿瘤",
      u8"中医药",
      u8"中医药局",
      u8"中医药管理局",
      u8"中医院",
      u8"中午",
      u8"中午饭",
      u8"中华",
      u8"中华书局",
      u8"中华书库",
      u8"中华人民",
      u8"中华人民共和国",
      u8"中华人民共和国主席",
      u8"中华人民共和国副主席",
      u8"中华人民共和国城市规划法",
      u8"中华人民共和国森林法",
      u8"中华人民共和国自然保护区条例",
      u8"中华儿女",
      u8"中华全国",
      u8"中华全国台湾同胞联谊会",
      u8"中华全国妇女联合会",
      u8"中华全国工商联合会",
      u8"中华全国归国华侨联合会",
      u8"中华全国总工会",
      u8"中华全国新闻",
      u8"中华全国新闻工作者协会",
      u8"中华医专",
      u8"中华医学会",
      u8"中华商场",
      u8"中华大字典",
      u8"中华大家庭",
      u8"中华字典",
      u8"中华学习机",
      u8"中华小姐",
      u8"中华工专",
      u8"中华工业",
      u8"中华工业专科学校",
      u8"中华工商",
      u8"中华开放",
      u8"中华开放医院",
      u8"中华总工会",
      u8"中华情",
      u8"中华文化",
      u8"中华文明",
      u8"中华日报",
      u8"中华民国",
      u8"中华民族",
      u8"中华民谣",
      u8"中华烟",
      u8"中华电信",
      u8"中华电视",
      u8"中华电视台",
      u8"中华神差",
      u8"中华经济",
      u8"中华经济研究院",
      u8"中华网",
      u8"中华美食",
      u8"中华英才网",
      u8"中华街",
      u8"中华路",
      u8"中华车",
      u8"中华轩",
      u8"中华轿车",
      u8"中华邮",
      u8"中华门",
      u8"中华队",
      u8"中华革命",
      u8"中华革命党",
      u8"中华魂",
      u8"中华鲟",
      u8"中南",
      u8"中南亚",
      u8"中南半岛",
      u8"中南工业大学",
      u8"中南林",
      u8"中南欧",
      u8"中南海",
      u8"中南美",
      u8"中南美洲",
      u8"中南财经政法大学",
      u8"中南部",
      u8"中南部地区",
      u8"中南非",
      u8"中卫",
      u8"中卫县",
      u8"中卫市",
      u8"中印",
      u8"中印关系",
      u8"中印国界",
      u8"中厅",
      u8"中厚板",
      u8"中原",
      u8"中原区",
      u8"中原地区",
      u8"中原大学",
      u8"中原标准时间",
      u8"中原逐鹿",
      u8"中去",
      u8"中县",
      u8"中友",
      u8"中发",
      u8"中叔皇",
      u8"中叙",
      u8"中古",
      u8"中古世纪",
      u8"中古史",
      u8"中古品",
      u8"中古时代",
      u8"中古车",
      u8"中台医专",
      u8"中台湾",
      u8"中台湾地区",
      u8"中叶",
      u8"中号",
      u8"中后期",
      u8"中含有",
      u8"中听",
      u8"中和",
      u8"中和作用",
      u8"中和剂",
      u8"中和力",
      u8"中和市",
      u8"中和突变",
      u8"中和表位",
      u8"中和西乡",
      u8"中唐",
      u8"中唐时期",
      u8"中唱",
      u8"中商网",
      u8"中固",
      u8"中国",
      u8"中国万网",
      u8"中国下载",
      u8"中国专利",
      u8"中国专利号",
      u8"中国专利和技术转让公司",
      u8"中国专利局",
      u8"中国专利申请号",
      u8"中国东方航空",
      u8"中国丝绸公司",
      u8"中国中医研究院",
      u8"中国之最",
      u8"中国书店",
      u8"中国书画",
      u8"中国交通银行",
      u8"中国产品",
      u8"中国京剧",
      u8"中国人",
      u8"中国人寿保险",
      u8"中国人民",
      u8"中国人民保险公司",
      u8"中国人民外交协会",
      u8"中国人民大学",
      u8"中国人民对外友好协会",
      u8"中国人民政治协商会议",
      u8"中国人民武装警察部队",
      u8"中国人民解放军",
      u8"中国人民银行",
      u8"中国人民银行行长",
      u8"中国企业",
      u8"中国传媒",
      u8"中国传统",
      u8"中国佛教",
      u8"中国作协",
      u8"中国作家",
      u8"中国作家协会",
      u8"中国保险监督管理委员会",
      u8"中国光大银行",
      u8"中国公民",
      u8"中国共产主义青年团",
      u8"中国共产主义青年团中央委",
      u8"中国共产主义青年团中央委员会",
      u8"中国共产党",
      u8"中国共产党中央委员会",
      u8"中国兵器工业总公司",
      u8"中国内地",
      u8"中国军力",
      u8"中国军方",
      u8"中国军队",
      u8"中国农业",
      u8"中国农业银行",
      u8"中国农工民主党",
      u8"中国农村",
      u8"中国农村发展研究中心",
      u8"中国农民",
      u8"中国农民银行",
      u8"中国农科院",
      u8"中国农行",
      u8"中国出口",
      u8"中国列车控制系统",
      u8"中国力量",
      u8"中国功夫",
      u8"中国包装总公司",
      u8"中国化",
      u8"中国化工",
      u8"中国北京",
      u8"中国北方",
      u8"中国医学",
      u8"中国医科大学",
      u8"中国医药",
      u8"中国医药学院",
      u8"中国医药市场",
      u8"中国南方",
      u8"中国南瓜",
      u8"中国印",
      u8"中国历代",
      u8"中国历史",
      u8"中国古",
      u8"中国古代",
      u8"中国古代园林",
      u8"中国古典园林",
      u8"中国台湾",
      u8"中国史",
      u8"中国史纲",
      u8"中国同盟",
      u8"中国同盟会",
      u8"中国名牌",
      u8"中国吧",
      u8"中国商业",
      u8"中国商业银行",
      u8"中国商人",
      u8"中国商会",
      u8"中国商银",
      u8"中国围棋",
      u8"中国国情",
      u8"中国国歌",
      u8"中国国民",
      u8"中国国民党",
      u8"中国国民党革命委员会",
      u8"中国国防",
      u8"中国国际",
      u8"中国国际信托投资公司",
      u8"中国国际广播电台",
      u8"中国国际民间艺术节",
      u8"中国国际贸易仲裁委员会",
      u8"中国国际贸易促进委员",
      u8"中国国际贸易促进委员会",
      u8"中国国际高新技术成果交易会",
      u8"中国地产",
      u8"中国地图",
      u8"中国地质",
      u8"中国城",
      u8"中国城市科学研究会",
      u8"中国塑料",
      u8"中国外交",
      u8"中国外运福建鼓山储运公司",
      u8"中国大百科全书",
      u8"中国大陆",
      u8"中国大黄页",
      u8"中国奥委会",
      u8"中国女子",
      u8"中国女排",
      u8"中国女足",
      u8"中国妇女",
      u8"中国娃",
      u8"中国娃娃",
      u8"中国字",
      u8"中国学",
      u8"中国学生",
      u8"中国学生网",
      u8"中国宁波",
      u8"中国家电",
      u8"中国富豪",
      u8"中国寻书网",
      u8"中国少年",
      u8"中国少年先锋队",
      u8"中国少年队",
      u8"中国崛起",
      u8"中国工人",
      u8"中国工农红军",
      u8"中国工商",
      u8"中国工商专科学校",
      u8"中国工商银行",
      u8"中国工程院",
      u8"中国市场",
      u8"中国年",
      u8"中国幼教",
      u8"中国广东",
      u8"中国广播",
      u8"中国广播公司",
      u8"中国建材",
      u8"中国建筑",
      u8"中国建筑学会",
      u8"中国建筑工程总公司",
      u8"中国建设银行",
      u8"中国式",
      u8"中国当代",
      u8"中国心",
      u8"中国性",
      u8"中国戏剧",
      u8"中国戏剧出版社",
      u8"中国戏曲",
      u8"中国战区",
      u8"中国投资银行",
      u8"中国护士",
      u8"中国政府",
      u8"中国教育",
      u8"中国文化",
      u8"中国文化大学",
      u8"中国文化学院",
      u8"中国文字改革委员会",
      u8"中国文学",
      u8"中国文学艺术界联合会",
      u8"中国文联",
      u8"中国文艺",
      u8"中国文艺学会",
      u8"中国旅游",
      u8"中国日报",
      u8"中国时报",
      u8"中国有色金属工业总公司",
      u8"中国林业",
      u8"中国标准技术开发公司",
      u8"中国核工业总公司",
      u8"中国概念股",
      u8"中国模具",
      u8"中国武术",
      u8"中国民主促进会",
      u8"中国民主同盟",
      u8"中国民主建国会",
      u8"中国民俗",
      u8"中国民歌",
      u8"中国民用航空局",
      u8"中国民用航空总局",
      u8"中国民航",
      u8"中国民间",
      u8"中国水利",
      u8"中国江苏",
      u8"中国汽车",
      u8"中国汽车工业公司",
      u8"中国汽车工业总公司",
      u8"中国汽车工业联合会",
      u8"中国法律大典",
      u8"中国浙江",
      u8"中国海",
      u8"中国海专",
      u8"中国海事",
      u8"中国海事专科学校",
      u8"中国海关",
      u8"中国海军",
      u8"中国海洋",
      u8"中国海洋石油总公司",
      u8"中国消费者协会",
      u8"中国游",
      u8"中国游客",
      u8"中国潜艇",
      u8"中国烟草",
      u8"中国烟草总公司",
      u8"中国热",
      u8"中国煤炭",
      u8"中国物理学会",
      u8"中国特色",
      u8"中国特色社会主义",
      u8"中国特色社会主义理论",
      u8"中国电",
      u8"中国电信",
      u8"中国电力",
      u8"中国电影",
      u8"中国电视",
      u8"中国电视公司",
      u8"中国男篮",
      u8"中国画",
      u8"中国画展",
      u8"中国石油",
      u8"中国石油公司",
      u8"中国石油化工总公司",
      u8"中国石油天然气总公司",
      u8"中国矿业",
      u8"中国社会",
      u8"中国社会科学院",
      u8"中国社会科学院语言研究所",
      u8"中国福利会",
      u8"中国科协",
      u8"中国科学技术协会",
      u8"中国科学技术大学",
      u8"中国科学技术馆",
      u8"中国科学院",
      u8"中国科技大学",
      u8"中国科技馆",
      u8"中国移",
      u8"中国移动",
      u8"中国空军",
      u8"中国站长",
      u8"中国篮球",
      u8"中国红十字会",
      u8"中国红十字会总会",
      u8"中国红十字总会",
      u8"中国纺织总会",
      u8"中国经济",
      u8"中国经济时报",
      u8"中国经贸",
      u8"中国结",
      u8"中国统配煤矿总公司",
      u8"中国缘",
      u8"中国网",
      u8"中国网民",
      u8"中国美术",
      u8"中国翻译",
      u8"中国联合通信",
      u8"中国联通",
      u8"中国能源",
      u8"中国致公党",
      u8"中国航天",
      u8"中国航空",
      u8"中国船舶",
      u8"中国船舶工业总公司",
      u8"中国艺术",
      u8"中国节",
      u8"中国芯",
      u8"中国花卉",
      u8"中国茶",
      u8"中国菜",
      u8"中国西部",
      u8"中国证券",
      u8"中国证监会",
      u8"中国话",
      u8"中国象棋",
      u8"中国货",
      u8"中国贫富",
      u8"中国足协",
      u8"中国足球",
      u8"中国近代",
      u8"中国选手",
      u8"中国通",
      u8"中国通史",
      u8"中国邮政",
      u8"中国金卫网",
      u8"中国金药网",
      u8"中国金融",
      u8"中国钢铁",
      u8"中国铁路通信信号集团公司",
      u8"中国银联",
      u8"中国银行",
      u8"中国长城",
      u8"中国队",
      u8"中国陆军",
      u8"中国青年",
      u8"中国青年党",
      u8"中国青年反共救国团",
      u8"中国青年报",
      u8"中国革命",
      u8"中国革命史",
      u8"中国鞋",
      u8"中国音乐",
      u8"中国领土",
      u8"中国风景园林学会",
      u8"中国食品",
      u8"中国饲料",
      u8"中国馆",
      u8"中国驴",
      u8"中国高校",
      u8"中国龙",
      u8"中图法",
      u8"中圈",
      u8"中圈套",
      u8"中土",
      u8"中场",
      u8"中坚",
      u8"中坚份子",
      u8"中坚力量",
      u8"中坜",
      u8"中坜人",
      u8"中坜地区",
      u8"中坜市",
      u8"中垂线",
      u8"中型",
      u8"中型企业",
      u8"中型公车",
      u8"中型机",
      u8"中型车",
      u8"中垦",
      u8"中城",
      u8"中堂",
      u8"中士",
      u8"中夏",
      u8"中外",
      u8"中外代",
      u8"中外关系",
      u8"中外历史",
      u8"中外古今",
      u8"中外合作",
      u8"中外合作经营",
      u8"中外合璧",
      u8"中外合资",
      u8"中外合资企业",
      u8"中外合资经营",
      u8"中外合资经营企业",
      u8"中外文",
      u8"中外杂志",
      u8"中外比",
      u8"中外观众",
      u8"中外记者",
      u8"中外运",
      u8"中外驰名",
      u8"中大",
      u8"中大型",
      u8"中大奖",
      u8"中天",
      u8"中天恒",
      u8"中天门",
      u8"中央",
      u8"中央主席",
      u8"中央书记处",
      u8"中央人民广播电台",
      u8"中央人民政府",
      u8"中央信托",
      u8"中央信托局",
      u8"中央党校",
      u8"中央党部",
      u8"中央全会",
      u8"中央公园",
      u8"中央军",
      u8"中央军事委员会",
      u8"中央军委",
      u8"中央军委主席",
      u8"中央军委副主席",
      u8"中央军委委员",
      u8"中央办公厅",
      u8"中央台",
      u8"中央各部委",
      u8"中央团校",
      u8"中央国家机关",
      u8"中央图书",
      u8"中央图书馆",
      u8"中央处",
      u8"中央处理",
      u8"中央处理器",
      u8"中央处理器模型",
      u8"中央大学",
      u8"中央委员",
      u8"中央委员会",
      u8"中央宣传部",
      u8"中央对外联络处",
      u8"中央对外联络部",
      u8"中央尖",
      u8"中央山脉",
      u8"中央常委",
      u8"中央情报",
      u8"中央情报局",
      u8"中央戏剧",
      u8"中央控制台",
      u8"中央控制室",
      u8"中央政府",
      u8"中央政治局",
      u8"中央政治局委员",
      u8"中央政治局常委",
      u8"中央文件",
      u8"中央文献",
      u8"中央新村",
      u8"中央日报",
      u8"中央机关",
      u8"中央标准",
      u8"中央标准局",
      u8"中央民族",
      u8"中央气象台",
      u8"中央电大",
      u8"中央电视台",
      u8"中央研究",
      u8"中央研究院",
      u8"中央社",
      u8"中央税",
      u8"中央空调",
      u8"中央窝",
      u8"中央精神",
      u8"中央级",
      u8"中央纪委",
      u8"中央纪律检查委员会",
      u8"中央组织部",
      u8"中央细胞",
      u8"中央经线",
      u8"中央统战部",
      u8"中央美院",
      u8"中央视觉",
      u8"中央警官",
      u8"中央警官学校",
      u8"中央认为",
      u8"中央财政",
      u8"中央财经",
      u8"中央财经大学",
      u8"中央通讯",
      u8"中央通讯社",
      u8"中央酒店",
      u8"中央银行",
      u8"中央集权",
      u8"中央面",
      u8"中央革命",
      u8"中央革命根据地",
      u8"中央音乐",
      u8"中央音乐学院",
      u8"中央顾问委员会",
      u8"中央预算",
      u8"中央领导",
      u8"中央领导同志",
      u8"中头",
      u8"中奖",
      u8"中奖号码",
      u8"中奖率",
      u8"中奖者",
      u8"中套",
      u8"中委",
      u8"中子",
      u8"中子嬗变掺杂",
      u8"中子寿命测井",
      u8"中子弹",
      u8"中子态",
      u8"中子星",
      u8"中子活化分析",
      u8"中子流",
      u8"中子湿度测量仪",
      u8"中子源",
      u8"中子通量",
      u8"中学",
      u8"中学化学",
      u8"中学历史",
      u8"中学教师",
      u8"中学数学",
      u8"中学校园",
      u8"中学校长",
      u8"中学毕业",
      u8"中学毕业生",
      u8"中学毕业证书",
      u8"中学物理",
      u8"中学生",
      u8"中学生物",
      u8"中学老师",
      u8"中学英语",
      u8"中学西用",
      u8"中学语文",
      u8"中学阶段",
      u8"中宁",
      u8"中宁县",
      u8"中安网",
      u8"中宣部",
      u8"中富",
      u8"中导",
      u8"中封",
      u8"中将",
      u8"中将汤",
      u8"中尉",
      u8"中尉军官",
      u8"中小",
      u8"中小企业",
      u8"中小企业银行",
      u8"中小型",
      u8"中小型机",
      u8"中小城市",
      u8"中小学",
      u8"中小学教研",
      u8"中小学校",
      u8"中小学生",
      u8"中小板",
      u8"中小银行",
      u8"中少社",
      u8"中就",
      u8"中局",
      u8"中层",
      u8"中层干部",
      u8"中层次",
      u8"中层阶级",
      u8"中层领导干部",
      u8"中居正广",
      u8"中山",
      u8"中山北路",
      u8"中山区",
      u8"中山医",
      u8"中山医学",
      u8"中山医学院",
      u8"中山医科大学",
      u8"中山南路",
      u8"中山堂",
      u8"中山大学",
      u8"中山大道",
      u8"中山市",
      u8"中山服",
      u8"中山楼",
      u8"中山狼",
      u8"中山秀征",
      u8"中山站",
      u8"中山网",
      u8"中山美穗",
      u8"中山舰",
      u8"中山装",
      u8"中山路",
      u8"中山门",
      u8"中山陵",
      u8"中岛",
      u8"中岛美雪",
      u8"中岳",
      u8"中川",
      u8"中州",
      u8"中州工专",
      u8"中州韵",
      u8"中巴",
      u8"中巴关系",
      u8"中巴车",
      u8"中市区",
      u8"中师",
      u8"中师文化",
      u8"中常",
      u8"中常会",
      u8"中常委",
      u8"中幔",
      u8"中幡",
      u8"中平",
      u8"中年",
      u8"中年人",
      u8"中年夫妇",
      u8"中年妇女",
      u8"中年期",
      u8"中年武师",
      u8"中年男人",
      u8"中年男子",
      u8"中年级",
      u8"中广",
      u8"中广公司",
      u8"中广网",
      u8"中府",
      u8"中度",
      u8"中度锓",
      u8"中度颱风",
      u8"中庭",
      u8"中庸",
      u8"中庸之道",
      u8"中庸思想",
      u8"中式",
      u8"中式服装",
      u8"中式盐",
      u8"中弹",
      u8"中彩",
      u8"中彩网",
      u8"中影",
      u8"中微子",
      u8"中德",
      u8"中德关系",
      u8"中心",
      u8"中心主任",
      u8"中心人物",
      u8"中心代数",
      u8"中心任务",
      u8"中心体",
      u8"中心体肌动蛋白",
      u8"中心体连丝",
      u8"中心内容",
      u8"中心列",
      u8"中心动词",
      u8"中心区",
      u8"中心区位",
      u8"中心区位电子专业词汇",
      u8"中心医院",
      u8"中心原子",
      u8"中心商业区",
      u8"中心地带",
      u8"中心地段",
      u8"中心地理论",
      u8"中心城市",
      u8"中心对称",
      u8"中心小学",
      u8"中心工作",
      u8"中心广场",
      u8"中心店",
      u8"中心思想",
      u8"中心摇摇",
      u8"中心是悼",
      u8"中心校",
      u8"中心法",
      u8"中心法则",
      u8"中心注水",
      u8"中心点",
      u8"中心环节",
      u8"中心球",
      u8"中心盲",
      u8"中心矩",
      u8"中心社",
      u8"中心粒",
      u8"中心线",
      u8"中心组",
      u8"中心自同构",
      u8"中心角",
      u8"中心论",
      u8"中心诊所",
      u8"中心词",
      u8"中心词驱动短语结构语法",
      u8"中心语",
      u8"中心质",
      u8"中性",
      u8"中性人",
      u8"中性化",
      u8"中性区",
      u8"中性名词",
      u8"中性平衡",
      u8"中性染料",
      u8"中性溶剂",
      u8"中性滤光片",
      u8"中性盐",
      u8"中性碱基",
      u8"中性笔",
      u8"中性线",
      u8"中性蛋白酶",
      u8"中悬折叠门",
      u8"中情",
      u8"中情局",
      u8"中意",
      u8"中戏",
      u8"中成药",
      u8"中所",
      u8"中找到",
      u8"中技",
      u8"中报",
      u8"中拇指",
      u8"中招",
      u8"中拮",
      u8"中拳",
      u8"中指",
      u8"中捷",
      u8"中排",
      u8"中控台",
      u8"中控室",
      u8"中控锁",
      u8"中提",
      u8"中提琴",
      u8"中提琴手",
      u8"中支",
      u8"中放",
      u8"中数检验法",
      u8"中文",
      u8"中文之家",
      u8"中文之星",
      u8"中文书",
      u8"中文书库",
      u8"中文信息",
      u8"中文包",
      u8"中文化",
      u8"中文台",
      u8"中文名",
      u8"中文名称",
      u8"中文字",
      u8"中文字体",
      u8"中文字幕",
      u8"中文实名",
      u8"中文平台",
      u8"中文搜索",
      u8"中文数字",
      u8"中文机",
      u8"中文标点",
      u8"中文歌曲",
      u8"中文歌词",
      u8"中文版",
      u8"中文电脑",
      u8"中文系",
      u8"中文系统",
      u8"中文网",
      u8"中文网址",
      u8"中文网站",
      u8"中文翻译",
      u8"中文舞曲",
      u8"中文论坛",
      u8"中文词库素材",
      u8"中文语料库",
      u8"中文输入法",
      u8"中文邮",
      u8"中文键盘",
      u8"中断",
      u8"中断信号互连网络",
      u8"中断向量",
      u8"中断寄存器",
      u8"中断点",
      u8"中断请求",
      u8"中断过程",
      u8"中新",
      u8"中新社",
      u8"中新网",
      u8"中方",
      u8"中方县",
      u8"中旅",
      u8"中日",
      u8"中日关系",
      u8"中日合作",
      u8"中日外交关系",
      u8"中日战争",
      u8"中日文化交流",
      u8"中日甲午",
      u8"中日甲午战争",
      u8"中日词典",
      u8"中日韩",
      u8"中旬",
      u8"中时晚报",
      u8"中星微",
      u8"中晚期",
      u8"中晚期作品",
      u8"中景",
      u8"中暑",
      u8"中曾",
      u8"中最",
      u8"中有",
      u8"中服",
      u8"中朝",
      u8"中期",
      u8"中期基因",
      u8"中期贷款",
      u8"中杏",
      u8"中材",
      u8"中村",
      u8"中村克己",
      u8"中条山",
      u8"中杰",
      u8"中板",
      u8"中极",
      u8"中果皮",
      u8"中枢",
      u8"中枢化学感受器",
      u8"中枢神经",
      u8"中枢神经系统",
      u8"中枢神经系统障碍",
      u8"中枢系统",
      u8"中枢论",
      u8"中枪",
      u8"中柱",
      u8"中柱原",
      u8"中柱鞘",
      u8"中标",
      u8"中栏",
      u8"中校",
      u8"中核总",
      u8"中格",
      u8"中桅",
      u8"中档",
      u8"中档车",
      u8"中桥",
      u8"中楷",
      u8"中楼",
      u8"中横框",
      u8"中欧",
      u8"中欧国家",
      u8"中欧地区",
      u8"中止",
      u8"中止执行",
      u8"中止犯罪",
      u8"中正",
      u8"中正厅",
      u8"中正国中",
      u8"中正国小",
      u8"中正无私",
      u8"中正机场",
      u8"中正理工",
      u8"中正理工学院",
      u8"中正路",
      u8"中段",
      u8"中毒",
      u8"中毒事件",
      u8"中毒已深",
      u8"中毒性",
      u8"中毒性精神病",
      u8"中毒者",
      u8"中比",
      u8"中比关系",
      u8"中气",
      u8"中气不足",
      u8"中汇",
      u8"中江",
      u8"中江县",
      u8"中江村",
      u8"中沙",
      u8"中沙群岛",
      u8"中沙镇",
      u8"中河失舟",
      u8"中河失舟一壶千金",
      u8"中油",
      u8"中油网",
      u8"中泉",
      u8"中法",
      u8"中法关系",
      u8"中法战争",
      u8"中法网",
      u8"中法词典",
      u8"中波",
      u8"中波段",
      u8"中波长",
      u8"中注",
      u8"中注协",
      u8"中泰",
      u8"中泰关系",
      u8"中洲",
      u8"中派",
      u8"中流",
      u8"中流一壶",
      u8"中流一壸",
      u8"中流击楫",
      u8"中流失舟一壶千金",
      u8"中流底柱",
      u8"中流砥柱",
      u8"中海",
      u8"中海油",
      u8"中消协",
      u8"中渎",
      u8"中渚",
      u8"中温动物",
      u8"中港",
      u8"中港台",
      u8"中港城",
      u8"中港溪",
      u8"中游",
      u8"中游网",
      u8"中演",
      u8"中火",
      u8"中灶",
      u8"中点",
      u8"中点站",
      u8"中焦",
      u8"中煤网",
      u8"中牟",
      u8"中牟县",
      u8"中特网",
      u8"中环",
      u8"中班",
      u8"中生",
      u8"中生代",
      u8"中生植物",
      u8"中用",
      u8"中田",
      u8"中田英寿",
      u8"中电投",
      u8"中电联",
      u8"中男",
      u8"中甸",
      u8"中甸县",
      u8"中界岭",
      u8"中百",
      u8"中的菜",
      u8"中盘",
      u8"中盘商",
      u8"中盘股",
      u8"中直",
      u8"中直人",
      u8"中直工委",
      u8"中直机关",
      u8"中省",
      u8"中省地",
      u8"中看",
      u8"中看不中吃",
      u8"中看不中听",
      u8"中看不中用",
      u8"中着丝",
      u8"中知",
      u8"中短",
      u8"中短期",
      u8"中短波",
      u8"中石化",
      u8"中石器时代",
      u8"中石没矢",
      u8"中石油",
      u8"中研院",
      u8"中硬地层",
      u8"中碳钢",
      u8"中秋",
      u8"中秋佳节",
      u8"中秋月",
      u8"中秋月饼",
      u8"中秋节",
      u8"中科",
      u8"中科大",
      u8"中科委",
      u8"中科院",
      u8"中科院物质结构所",
      u8"中移动",
      u8"中程",
      u8"中程导弹",
      u8"中程计划",
      u8"中程飞弹",
      u8"中稻",
      u8"中空",
      u8"中空板",
      u8"中空玻璃",
      u8"中立",
      u8"中立不倚",
      u8"中立主义",
      u8"中立区",
      u8"中立国",
      u8"中立国家",
      u8"中立地区",
      u8"中立地带",
      u8"中立政策",
      u8"中立法",
      u8"中立派",
      u8"中站",
      u8"中站区",
      u8"中等",
      u8"中等专业",
      u8"中等专业学校",
      u8"中等专业教育",
      u8"中等城市",
      u8"中等学校",
      u8"中等教育",
      u8"中等水平",
      u8"中等生",
      u8"中等职业",
      u8"中等舱",
      u8"中策",
      u8"中签",
      u8"中签号",
      u8"中签率",
      u8"中箭",
      u8"中箭落马",
      u8"中篇",
      u8"中篇小说",
      u8"中粗",
      u8"中纤板",
      u8"中级",
      u8"中级人民",
      u8"中级人民法院",
      u8"中级会计",
      u8"中级品",
      u8"中级工",
      u8"中级法院",
      u8"中级班",
      u8"中级职称",
      u8"中级车",
      u8"中级轿车",
      u8"中纪委",
      u8"中纬",
      u8"中纬度",
      u8"中纺",
      u8"中纽",
      u8"中纽关系",
      u8"中线",
      u8"中线发球",
      u8"中组部",
      u8"中经",
      u8"中经网",
      u8"中统",
      u8"中继",
      u8"中继器",
      u8"中继站",
      u8"中继线",
      u8"中继者",
      u8"中缀",
      u8"中缝",
      u8"中缝大核",
      u8"中缝核",
      u8"中网",
      u8"中置",
      u8"中置同轴",
      u8"中美",
      u8"中美关系",
      u8"中美合作",
      u8"中美外交关系",
      u8"中美州",
      u8"中美洲",
      u8"中美洲共同市场",
      u8"中老年",
      u8"中老年人",
      u8"中考",
      u8"中考题",
      u8"中耕",
      u8"中耕培土机",
      u8"中耳",
      u8"中耳炎",
      u8"中职",
      u8"中联",
      u8"中联部",
      u8"中肯",
      u8"中胚层",
      u8"中胚质层",
      u8"中胡",
      u8"中能电子衍射",
      u8"中能队",
      u8"中脑",
      u8"中脘",
      u8"中腹",
      u8"中腹之战",
      u8"中膂俞",
      u8"中航",
      u8"中航技",
      u8"中航油",
      u8"中苏",
      u8"中苏关系",
      u8"中苑",
      u8"中英",
      u8"中英两国",
      u8"中英关系",
      u8"中英对照",
      u8"中英文",
      u8"中英混合式园林",
      u8"中英联合声明",
      u8"中英街",
      u8"中英词典",
      u8"中草药",
      u8"中药",
      u8"中药厂",
      u8"中药学",
      u8"中药店",
      u8"中药房",
      u8"中药方",
      u8"中药材",
      u8"中药药理学",
      u8"中药铺",
      u8"中药饮片",
      u8"中菜",
      u8"中菲",
      u8"中营",
      u8"中落",
      u8"中葡",
      u8"中葯",
      u8"中融通",
      u8"中行",
      u8"中表",
      u8"中被",
      u8"中装",
      u8"中裤",
      u8"中西",
      u8"中西亚",
      u8"中西关系",
      u8"中西医",
      u8"中西医结合",
      u8"中西合壁",
      u8"中西合并",
      u8"中西合璧",
      u8"中西和璧",
      u8"中西思想",
      u8"中西文",
      u8"中西文化",
      u8"中西文终端",
      u8"中西方",
      u8"中西药",
      u8"中西词典",
      u8"中西部",
      u8"中西餐",
      u8"中观",
      u8"中规中矩",
      u8"中规模集成电路",
      u8"中视",
      u8"中视公司",
      u8"中觉",
      u8"中计",
      u8"中讯",
      u8"中讲",
      u8"中论",
      u8"中证报",
      u8"中证网",
      u8"中词",
      u8"中译",
      u8"中译本",
      u8"中译英",
      u8"中试",
      u8"中试厂",
      u8"中谷",
      u8"中财网",
      u8"中资",
      u8"中资企业",
      u8"中资源",
      u8"中资股",
      u8"中资银行",
      u8"中超杯",
      u8"中超联赛",
      u8"中越",
      u8"中越关系",
      u8"中越国界",
      u8"中距离",
      u8"中距离赛跑",
      u8"中跟",
      u8"中路",
      u8"中路梆子",
      u8"中转",
      u8"中转服务器",
      u8"中转站",
      u8"中轴",
      u8"中轴线",
      u8"中辍",
      u8"中辰",
      u8"中近东",
      u8"中进",
      u8"中远",
      u8"中远队",
      u8"中选",
      u8"中选优",
      u8"中选会",
      u8"中途",
      u8"中途下车",
      u8"中途岛",
      u8"中途站",
      u8"中途辍学",
      u8"中通外直",
      u8"中速",
      u8"中道",
      u8"中道而废",
      u8"中邦队",
      u8"中邪",
      u8"中郎",
      u8"中郎将",
      u8"中部",
      u8"中部地区",
      u8"中部地方",
      u8"中部肋骨",
      u8"中都",
      u8"中都之战",
      u8"中醒",
      u8"中量",
      u8"中量级",
      u8"中钢",
      u8"中铁",
      u8"中银",
      u8"中铺",
      u8"中锋",
      u8"中键",
      u8"中长",
      u8"中长大衣",
      u8"中长期",
      u8"中长波",
      u8"中长跑",
      u8"中长距离",
      u8"中长途",
      u8"中长铁路",
      u8"中门",
      u8"中间",
      u8"中间业务",
      u8"中间人",
      u8"中间代码",
      u8"中间件",
      u8"中间体",
      u8"中间叶促皮质样肽",
      u8"中间商",
      u8"中间型大麦",
      u8"中间基原油",
      u8"中间层",
      u8"中间性",
      u8"中间性格",
      u8"中间方",
      u8"中间桥基",
      u8"中间派",
      u8"中间牙骨质",
      u8"中间状态",
      u8"中间环节",
      u8"中间神经元",
      u8"中间种植体",
      u8"中间级",
      u8"中间线",
      u8"中间色",
      u8"中间色律",
      u8"中间视觉",
      u8"中间设备",
      u8"中间语",
      u8"中队",
      u8"中队长",
      u8"中阮",
      u8"中阳",
      u8"中阳县",
      u8"中院",
      u8"中隔",
      u8"中集",
      u8"中雨",
      u8"中雪",
      u8"中青年",
      u8"中青报",
      u8"中青网",
      u8"中青队",
      u8"中非",
      u8"中非共和国",
      u8"中非关税经济同盟",
      u8"中非国家",
      u8"中非地区",
      u8"中革军委",
      u8"中靶",
      u8"中韩",
      u8"中韩关系",
      u8"中韩词典",
      u8"中韩镇",
      u8"中音",
      u8"中音部",
      u8"中韶",
      u8"中顾委",
      u8"中频",
      u8"中频抑制比",
      u8"中频放大器",
      u8"中风",
      u8"中风病",
      u8"中餐",
      u8"中餐厅",
      u8"中餐馆",
      u8"中饭",
      u8"中饭时",
      u8"中饱",
      u8"中饱私囊",
      u8"中馈乏人",
      u8"中馈犹虚",
      u8"中马",
      u8"中高",
      u8"中高层",
      u8"中高档",
      u8"中高级",
      u8"中高音",
      u8"中魁",
      u8"中魔",
      u8"中鸿网",
      u8"中黄",
      u8"中齿",
      u8"中龄林",
      u8"丰业",
      u8"丰乐",
      u8"丰乐镇",
      u8"丰乳",
      u8"丰乳肥臀",
      u8"丰产",
      u8"丰产林",
      u8"丰产田",
      u8"丰亨豫大",
      u8"丰功",
      u8"丰功伟业",
      u8"丰功伟绩",
      u8"丰功传绩",
      u8"丰功厚利",
      u8"丰功大业",
      u8"丰功懿德",
      u8"丰功盛烈",
      u8"丰功硕德",
      u8"丰功茂德",
      u8"丰华",
      u8"丰南",
      u8"丰南区",
      u8"丰南县",
      u8"丰厚",
      u8"丰原",
      u8"丰原市",
      u8"丰县",
      u8"丰取刻与",
      u8"丰台",
      u8"丰台区",
      u8"丰城",
      u8"丰城市",
      u8"丰墙峭址",
      u8"丰墙峭阯",
      u8"丰墙硗下",
      u8"丰壤",
      u8"丰姿",
      u8"丰姿冶丽",
      u8"丰姿绰约",
      u8"丰子恺",
      u8"丰宁",
      u8"丰宁县",
      u8"丰宁满族自治县",
      u8"丰实",
      u8"丰容靓饰",
      u8"丰富",
      u8"丰富充裕",
      u8"丰富化",
      u8"丰富可逆层",
      u8"丰富含义",
      u8"丰富多彩",
      u8"丰富多采",
      u8"丰富性",
      u8"丰富除子",
      u8"丰屋之戒",
      u8"丰屋之祸",
      u8"丰屋之过",
      u8"丰屋延灾",
      u8"丰屋生灾",
      u8"丰屋蔀家",
      u8"丰岛",
      u8"丰川悦司",
      u8"丰年",
      u8"丰年玉荒年谷",
      u8"丰年祭",
      u8"丰年稔岁",
      u8"丰年虫",
      u8"丰度翩翩",
      u8"丰收",
      u8"丰收在忘",
      u8"丰收在望",
      u8"丰收年",
      u8"丰收期",
      u8"丰标不凡",
      u8"丰沛",
      u8"丰泰",
      u8"丰泽区",
      u8"丰泽园",
      u8"丰润",
      u8"丰润区",
      u8"丰润县",
      u8"丰满",
      u8"丰满区",
      u8"丰满度",
      u8"丰滨",
      u8"丰田",
      u8"丰田佳美",
      u8"丰田悦司",
      u8"丰田杯",
      u8"丰登",
      u8"丰盈",
      u8"丰盛",
      u8"丰瞻",
      u8"丰硕",
      u8"丰硕成果",
      u8"丰碑",
      u8"丰神异彩",
      u8"丰神绰约",
      u8"丰稔",
      u8"丰筋多力",
      u8"丰美",
      u8"丰羽",
      u8"丰肌弱骨",
      u8"丰肌秀骨",
      u8"丰胸",
      u8"丰胸丸",
      u8"丰腴",
      u8"丰臣秀吉",
      u8"丰茂",
      u8"丰草",
      u8"丰草长林",
      u8"丰衣足食",
      u8"丰裕",
      u8"丰赡",
      u8"丰足",
      u8"丰都",
      u8"丰都县",
      u8"丰采",
      u8"丰镇",
      u8"丰镇市",
      u8"丰隆",
      u8"丰韵",
      u8"丰顺",
      u8"丰顺县",
      u8"丰饶",
      u8"丰饶丰足",
      u8"串上",
      u8"串上去",
      u8"串上来",
      u8"串串",
      u8"串串香",
      u8"串亲戚",
      u8"串亲访友",
      u8"串休",
      u8"串会",
      u8"串供",
      u8"串出来",
      u8"串列",
      u8"串口",
      u8"串口卡",
      u8"串口线",
      u8"串台",
      u8"串号",
      u8"串味",
      u8"串味儿",
      u8"串城",
      u8"串家走巷",
      u8"串家走户",
      u8"串岗",
      u8"串并口",
      u8"串并联",
      u8"串并转换器",
      u8"串成",
      u8"串户",
      u8"串换",
      u8"串接",
      u8"串改",
      u8"串气",
      u8"串流",
      u8"串游",
      u8"串演",
      u8"串烧版",
      u8"串珠",
      u8"串线",
      u8"串绕电动机",
      u8"串联",
      u8"串联体",
      u8"串联共振",
      u8"串联式",
      u8"串联探针",
      u8"串联端接",
      u8"串联词",
      u8"串联酶",
      u8"串联重复序列",
      u8"串联阻尼",
      u8"串行",
      u8"串行化",
      u8"串行口",
      u8"串街",
      u8"串讲",
      u8"串讲班",
      u8"串话",
      u8"串起",
      u8"串连",
      u8"串通",
      u8"串通一气",
      u8"串铃",
      u8"串门",
      u8"串门子",
      u8"串音",
      u8"串骗",
      u8"临上轿现扎耳朵眼儿",
      u8"临临界温度",
      u8"临了",
      u8"临事而惧",
      u8"临产",
      u8"临产前",
      u8"临产时",
      u8"临人",
      u8"临兵斗者皆阵列在前",
      u8"临刑",
      u8"临利",
      u8"临别",
      u8"临别依依",
      u8"临别时",
      u8"临别赠言",
      u8"临别赠语",
      u8"临到",
      u8"临危",
      u8"临危不惧",
      u8"临危不挠",
      u8"临危不顾",
      u8"临危受命",
      u8"临危授命",
      u8"临危时",
      u8"临危致命",
      u8"临去",
      u8"临去秋波",
      u8"临县",
      u8"临场",
      u8"临场发挥",
      u8"临场感",
      u8"临场经验",
      u8"临城",
      u8"临城县",
      u8"临夏",
      u8"临夏县",
      u8"临夏回族自治州",
      u8"临夏州",
      u8"临夏市",
      u8"临头",
      u8"临安",
      u8"临安县",
      u8"临安市",
      u8"临客",
      u8"临崖勒马",
      u8"临川",
      u8"临川区",
      u8"临川市",
      u8"临川羡鱼",
      u8"临帖",
      u8"临幸",
      u8"临床",
      u8"临床冠",
      u8"临床医学",
      u8"临床学",
      u8"临床实践",
      u8"临床实验",
      u8"临床心理学",
      u8"临床意义",
      u8"临床教学",
      u8"临床法",
      u8"临床经验",
      u8"临床药理",
      u8"临床表现",
      u8"临床试验",
      u8"临建",
      u8"临快",
      u8"临战",
      u8"临战状态",
      u8"临拼",
      u8"临摹",
      u8"临敌卖阵",
      u8"临敌易将",
      u8"临文不讳",
      u8"临时",
      u8"临时代办",
      u8"临时准备",
      u8"临时动议",
      u8"临时工",
      u8"临时性",
      u8"临时抱佛",
      u8"临时抱佛脚",
      u8"临时政府",
      u8"临时文件",
      u8"临时文件夹",
      u8"临时演员",
      u8"临时许可",
      u8"临时费用",
      u8"临月",
      u8"临朐",
      u8"临朐县",
      u8"临朝",
      u8"临期",
      u8"临末",
      u8"临机",
      u8"临机应变",
      u8"临村",
      u8"临桂",
      u8"临桂县",
      u8"临检",
      u8"临武",
      u8"临武县",
      u8"临死",
      u8"临死前",
      u8"临死时",
      u8"临水",
      u8"临水登山",
      u8"临江",
      u8"临江仙",
      u8"临江会",
      u8"临江市",
      u8"临江楼",
      u8"临池",
      u8"临池学书",
      u8"临汾",
      u8"临汾市",
      u8"临汾路",
      u8"临沂",
      u8"临沂市",
      u8"临沐",
      u8"临沐县",
      u8"临沧",
      u8"临沧县",
      u8"临沧市",
      u8"临沭",
      u8"临沭县",
      u8"临河",
      u8"临河区",
      u8"临河地区",
      u8"临河市",
      u8"临河羡鱼",
      u8"临泉",
      u8"临泉县",
      u8"临泽",
      u8"临泽县",
      u8"临洮",
      u8"临洮县",
      u8"临济",
      u8"临海",
      u8"临海地区",
      u8"临海市",
      u8"临淄区",
      u8"临深履薄",
      u8"临清",
      u8"临清市",
      u8"临渊",
      u8"临渊履薄",
      u8"临渊羡鱼",
      u8"临渭区",
      u8"临渴掘井",
      u8"临渴气井",
      u8"临渴穿井",
      u8"临湖",
      u8"临湖地区",
      u8"临湖轩",
      u8"临湘",
      u8"临湘县",
      u8"临湘市",
      u8"临溪",
      u8"临漳",
      u8"临漳县",
      u8"临潭",
      u8"临潭县",
      u8"临潼",
      u8"临潼区",
      u8"临潼县",
      u8"临潼斗宝",
      u8"临澧",
      u8"临澧县",
      u8"临猗",
      u8"临猗县",
      u8"临画",
      u8"临界",
      u8"临界乳光",
      u8"临界体积",
      u8"临界值",
      u8"临界功率",
      u8"临界半径",
      u8"临界压",
      u8"临界压力",
      u8"临界参量",
      u8"临界态",
      u8"临界指数",
      u8"临界日长",
      u8"临界暗期",
      u8"临界期",
      u8"临界杀菌浓度",
      u8"临界波长",
      u8"临界温度",
      u8"临界溶氧浓度",
      u8"临界点",
      u8"临界点干燥法",
      u8"临界物质",
      u8"临界状态",
      u8"临界现象",
      u8"临界盐度",
      u8"临界胶束浓度",
      u8"临界角",
      u8"临界距离",
      u8"临界边",
      u8"临界通路测试产生法",
      u8"临界阻尼",
      u8"临界阻尼电阻",
      u8"临界频率",
      u8"临盆",
      u8"临盆时",
      u8"临眺",
      u8"临着",
      u8"临睡",
      u8"临睡前",
      u8"临睡时",
      u8"临立会",
      u8"临管会",
      u8"临终",
      u8"临终关怀",
      u8"临终前",
      u8"临终时",
      u8"临翔区",
      u8"临考",
      u8"临蓐",
      u8"临行",
      u8"临街",
      u8"临街面",
      u8"临西",
      u8"临西县",
      u8"临视",
      u8"临证指南",
      u8"临财不苟",
      u8"临走",
      u8"临走前",
      u8"临走时",
      u8"临近",
      u8"临近联想",
      u8"临邑",
      u8"临邑县",
      u8"临门",
      u8"临门一脚",
      u8"临阵",
      u8"临阵磨刀",
      u8"临阵磨枪",
      u8"临阵磨枪不快也亮",
      u8"临阵脱逃",
      u8"临阵逃脱",
      u8"临难",
      u8"临难不恐",
      u8"临难不惧",
      u8"临难不避",
      u8"临难无慑",
      u8"临难苟免",
      u8"临难铸兵",
      u8"临震",
      u8"临靠",
      u8"临靠着",
      u8"临颍县",
      u8"临颖",
      u8"临颖县",
      u8"临风",
      u8"临风对月",
      u8"临高",
      u8"临高县",
      u8"丸剂",
      u8"丸子",
      u8"丸散膏丹",
      u8"丸泥封关",
      u8"丸药",
      u8"丸药盒",
      u8"丸髻",
      u8"丹下",
      u8"丹东",
      u8"丹东市",
      u8"丹东港",
      u8"丹丸",
      u8"丹丹",
      u8"丹之所藏者赤",
      u8"丹书白马",
      u8"丹书铁契",
      u8"丹佛",
      u8"丹佛儿童发展筛选测验",
      u8"丹佛斯",
      u8"丹凤",
      u8"丹凤县",
      u8"丹凤朝阳",
      u8"丹凤眼",
      u8"丹剧",
      u8"丹参",
      u8"丹参滴丸",
      u8"丹参酮",
      u8"丹妮丝",
      u8"丹妮尔",
      u8"丹寨",
      u8"丹寨县",
      u8"丹尼尔",
      u8"丹尼尔斯",
      u8"丹尼斯",
      u8"丹巴",
      u8"丹巴县",
      u8"丹徒",
      u8"丹徒区",
      u8"丹徒县",
      u8"丹心",
      u8"丹心如故",
      u8"丹心照",
      u8"丹心碧血",
      u8"丹忱",
      u8"丹方",
      u8"丹枫",
      u8"丹桂",
      u8"丹棱",
      u8"丹棱县",
      u8"丹毒",
      u8"丹江",
      u8"丹江口",
      u8"丹江口市",
      u8"丹泽尔",
      u8"丹溪心法",
      u8"丹漆随梦",
      u8"丹田",
      u8"丹田功",
      u8"丹皮尔",
      u8"丹砂",
      u8"丹粒",
      u8"丹红",
      u8"丹红素",
      u8"丹红色",
      u8"丹纳",
      u8"丹绒不碌港",
      u8"丹聂耳电池",
      u8"丹荔",
      u8"丹药",
      u8"丹诏",
      u8"丹铅甲乙",
      u8"丹阳",
      u8"丹阳市",
      u8"丹霞",
      u8"丹霞地貌",
      u8"丹霞山",
      u8"丹青",
      u8"丹青不渝",
      u8"丹青图",
      u8"丹青妙手",
      u8"丹青生",
      u8"丹青难写是精神",
      u8"丹顶鹤",
      u8"丹顿",
      u8"丹麦",
      u8"丹麦人",
      u8"丹麦语",
      u8"丹麦队",
      u8"丹黄甲乙",
      u8"为丛驱雀",
      u8"为主",
      u8"为之一振",
      u8"为之一新",
      u8"为之动容",
      u8"为了",
      u8"为人",
      u8"为人处世",
      u8"为人处事",
      u8"为人师表",
      u8"为人忠厚",
      u8"为人所用",
      u8"为人所知",
      u8"为人正派",
      u8"为人正直",
      u8"为人注意",
      u8"为人说项",
      u8"为什么",
      u8"为仁不富",
      u8"为今之计",
      u8"为伊消得人憔悴",
      u8"为伍",
      u8"为何",
      u8"为先",
      u8"为准",
      u8"为副",
      u8"为名",
      u8"为啥",
      u8"为善不欲人知",
      u8"为善最乐",
      u8"为国为民",
      u8"为国争光",
      u8"为国出力",
      u8"为国分忧",
      u8"为国增光",
      u8"为国捐躯",
      u8"为国捐驱",
      u8"为国牺牲",
      u8"为好成歉",
      u8"为学之道",
      u8"为官",
      u8"为害",
      u8"为富不仁",
      u8"为小失大",
      u8"为山止篑",
      u8"为师",
      u8"为德不卒",
      u8"为德不终",
      u8"为恶",
      u8"为恶不悛",
      u8"为患",
      u8"为您服务",
      u8"为情所伤",
      u8"为情所困",
      u8"为我所用",
      u8"为所欲为",
      u8"为政",
      u8"为政不廉",
      u8"为政者",
      u8"为数不多",
      u8"为数不少",
      u8"为数众多",
      u8"为数甚微",
      u8"为时",
      u8"为时不晚",
      u8"为时不远",
      u8"为时尚早",
      u8"为时已晚",
      u8"为时晚矣",
      u8"为时未晚",
      u8"为时过早",
      u8"为期",
      u8"为期不远",
      u8"为止",
      u8"为此",
      u8"为民",
      u8"为民前锋",
      u8"为民喉舌",
      u8"为民服务",
      u8"为民父母",
      u8"为民请命",
      u8"为民造福",
      u8"为民除害",
      u8"为法自弊",
      u8"为渊驱鱼",
      u8"为渊驱鱼为丛驱爵",
      u8"为渊驱鱼为丛驱雀",
      u8"为甚么",
      u8"为生",
      u8"为由",
      u8"为着",
      u8"为虎作伥",
      u8"为虎傅翼",
      u8"为虎添翼",
      u8"为虺弗摧",
      u8"为虺弗摧为蛇若何",
      u8"为蛇添足",
      u8"为蛇画足",
      u8"为蛇若何",
      u8"为裘为箕",
      u8"为辅",
      u8"为重",
      u8"为难",
      u8"为非作恶",
      u8"为非作歹",
      u8"为首",
      u8"为鬼为蜮",
      u8"主一无适",
      u8"主上",
      u8"主业",
      u8"主中桅",
      u8"主义",
      u8"主义哲学",
      u8"主义教育",
      u8"主义理论",
      u8"主义精神",
      u8"主义者",
      u8"主事",
      u8"主事者",
      u8"主产",
      u8"主产区",
      u8"主产省",
      u8"主人",
      u8"主人公",
      u8"主人家",
      u8"主人翁",
      u8"主人翁精神",
      u8"主仆",
      u8"主仆关系",
      u8"主从",
      u8"主从关系",
      u8"主从复制",
      u8"主从触发器",
      u8"主从计算机",
      u8"主件",
      u8"主任",
      u8"主任医师",
      u8"主任医生",
      u8"主任委员",
      u8"主任科员",
      u8"主伐",
      u8"主会场",
      u8"主位",
      u8"主体",
      u8"主体体系结构",
      u8"主体作用",
      u8"主体信号",
      u8"主体工程",
      u8"主体性",
      u8"主体派",
      u8"主体群落",
      u8"主体观",
      u8"主体资格",
      u8"主体际性",
      u8"主使",
      u8"主使人",
      u8"主使者",
      u8"主供",
      u8"主修",
      u8"主修科目",
      u8"主债务",
      u8"主值",
      u8"主儿",
      u8"主光轴",
      u8"主公",
      u8"主减速",
      u8"主凶",
      u8"主刀",
      u8"主刑",
      u8"主创",
      u8"主创者",
      u8"主副食",
      u8"主副食品",
      u8"主力",
      u8"主力军",
      u8"主力庄家",
      u8"主力球员",
      u8"主力舰",
      u8"主力部队",
      u8"主力阵容",
      u8"主办",
      u8"主办人",
      u8"主办单位",
      u8"主办员",
      u8"主办国",
      u8"主办方",
      u8"主办权",
      u8"主办检察官",
      u8"主办者",
      u8"主动",
      u8"主动免疫",
      u8"主动出击",
      u8"主动威胁",
      u8"主动性",
      u8"主动攻击",
      u8"主动权",
      u8"主动精神",
      u8"主动脉",
      u8"主动脉弓",
      u8"主动脉瓣关闭不全",
      u8"主动脉瓣狭窄",
      u8"主动脉瘤",
      u8"主动轴",
      u8"主动进攻",
      u8"主单位",
      u8"主卧室",
      u8"主厨",
      u8"主叉同态",
      u8"主反射器",
      u8"主发动机喷嘴",
      u8"主句",
      u8"主叫",
      u8"主台",
      u8"主合同",
      u8"主名",
      u8"主和",
      u8"主和派",
      u8"主唱",
      u8"主因",
      u8"主圣臣直",
      u8"主圣臣良",
      u8"主场",
      u8"主场优势",
      u8"主坝",
      u8"主城",
      u8"主城区",
      u8"主基督",
      u8"主墙",
      u8"主声道",
      u8"主外",
      u8"主奏",
      u8"主妇",
      u8"主委",
      u8"主婚",
      u8"主婚人",
      u8"主子",
      u8"主存",
      u8"主存储器",
      u8"主守自盗",
      u8"主官",
      u8"主审",
      u8"主审官",
      u8"主客",
      u8"主客场",
      u8"主客场制",
      u8"主客观",
      u8"主客颠倒",
      u8"主宰",
      u8"主宰世界",
      u8"主宰权",
      u8"主宰者",
      u8"主家",
      u8"主宾",
      u8"主宾席",
      u8"主宾络合物",
      u8"主导",
      u8"主导产业",
      u8"主导产品",
      u8"主导作用",
      u8"主导力量",
      u8"主导地位",
      u8"主导工业",
      u8"主导意见",
      u8"主导权",
      u8"主将",
      u8"主少国疑",
      u8"主峰",
      u8"主币",
      u8"主帅",
      u8"主帆",
      u8"主席",
      u8"主席令",
      u8"主席台",
      u8"主席团",
      u8"主席国",
      u8"主席职位",
      u8"主干",
      u8"主干渠",
      u8"主干线",
      u8"主干网",
      u8"主干课程",
      u8"主干路",
      u8"主干道",
      u8"主平面",
      u8"主库",
      u8"主应力",
      u8"主开关",
      u8"主张",
      u8"主弦律",
      u8"主心骨",
      u8"主忧臣辱",
      u8"主情造意",
      u8"主意",
      u8"主戏",
      u8"主战",
      u8"主战场",
      u8"主战派",
      u8"主打产品",
      u8"主承销",
      u8"主把",
      u8"主抓",
      u8"主报",
      u8"主持",
      u8"主持人",
      u8"主持会议",
      u8"主持公道",
      u8"主持工作",
      u8"主持正义",
      u8"主持稿",
      u8"主持词",
      u8"主掌",
      u8"主控",
      u8"主控台",
      u8"主控室",
      u8"主控板",
      u8"主推",
      u8"主播台",
      u8"主攻",
      u8"主攻手",
      u8"主政",
      u8"主政者",
      u8"主效基因抗病性",
      u8"主教",
      u8"主教堂",
      u8"主教练",
      u8"主文",
      u8"主文谲谏",
      u8"主料",
      u8"主旋律",
      u8"主族",
      u8"主日学",
      u8"主旨",
      u8"主星",
      u8"主景",
      u8"主机",
      u8"主机名",
      u8"主机房",
      u8"主机操作系统",
      u8"主机板",
      u8"主机系列",
      u8"主杀",
      u8"主权",
      u8"主权国",
      u8"主权国家",
      u8"主权在民",
      u8"主板",
      u8"主板驱动",
      u8"主极大",
      u8"主枝",
      u8"主枢纽",
      u8"主架",
      u8"主根",
      u8"主格",
      u8"主桅",
      u8"主档",
      u8"主桥",
      u8"主桥基",
      u8"主桥墩",
      u8"主楼",
      u8"主槽",
      u8"主模型",
      u8"主模式",
      u8"主次",
      u8"主次颠倒",
      u8"主殿",
      u8"主母",
      u8"主沉浮",
      u8"主河道",
      u8"主油箱",
      u8"主治",
      u8"主治医师",
      u8"主治医生",
      u8"主治大夫",
      u8"主波长",
      u8"主流",
      u8"主流产品",
      u8"主流派",
      u8"主流程",
      u8"主流线",
      u8"主渠道",
      u8"主滚筒",
      u8"主滤子",
      u8"主演",
      u8"主潮",
      u8"主炮",
      u8"主点",
      u8"主焦点",
      u8"主焦煤",
      u8"主父",
      u8"主牌",
      u8"主犯",
      u8"主球场",
      u8"主理",
      u8"主理想整环",
      u8"主瓣",
      u8"主甲板",
      u8"主监",
      u8"主盘",
      u8"主目录",
      u8"主着陆",
      u8"主矢量",
      u8"主矩",
      u8"主碑",
      u8"主祭",
      u8"主祭人",
      u8"主祷文",
      u8"主科",
      u8"主程序",
      u8"主稿",
      u8"主穹顶",
      u8"主笔",
      u8"主管",
      u8"主管人",
      u8"主管人员",
      u8"主管护",
      u8"主管机关",
      u8"主管机构",
      u8"主管部门",
      u8"主粮",
      u8"主纤维",
      u8"主线",
      u8"主组",
      u8"主结晶",
      u8"主编",
      u8"主罚",
      u8"主罪",
      u8"主群",
      u8"主群组",
      u8"主考",
      u8"主考人",
      u8"主考官",
      u8"主耶稣",
      u8"主脉",
      u8"主脉力",
      u8"主脑",
      u8"主脑人",
      u8"主航道",
      u8"主色调",
      u8"主茎",
      u8"主菜",
      u8"主营",
      u8"主营业务",
      u8"主表",
      u8"主裁",
      u8"主裁判",
      u8"主要",
      u8"主要产品",
      u8"主要任务",
      u8"主要依据",
      u8"主要内容",
      u8"主要功能",
      u8"主要原因",
      u8"主要原料",
      u8"主要参数",
      u8"主要因素",
      u8"主要性",
      u8"主要性能",
      u8"主要成分",
      u8"主要指",
      u8"主要有",
      u8"主要演员",
      u8"主要特征",
      u8"主要特点",
      u8"主要用途",
      u8"主要症状",
      u8"主要目",
      u8"主要矛盾",
      u8"主要组织相容性复合体",
      u8"主要组织相容性复合体抗原",
      u8"主要职责",
      u8"主要货币",
      u8"主要靠",
      u8"主要领导",
      u8"主见",
      u8"主观",
      u8"主观主义",
      u8"主观努力",
      u8"主观原因",
      u8"主观唯心",
      u8"主观唯心主义",
      u8"主观因素",
      u8"主观性",
      u8"主观武断",
      u8"主观能动",
      u8"主观能动性",
      u8"主观臆断",
      u8"主观臆测",
      u8"主观视点",
      u8"主观轮廓",
      u8"主观题",
      u8"主视",
      u8"主视图",
      u8"主视射击",
      u8"主视点",
      u8"主角",
      u8"主计",
      u8"主计处",
      u8"主计室",
      u8"主计长",
      u8"主记",
      u8"主记忆体",
      u8"主讲",
      u8"主讲人",
      u8"主设备",
      u8"主诉",
      u8"主诉检察官",
      u8"主词",
      u8"主试",
      u8"主试官",
      u8"主语",
      u8"主课",
      u8"主调",
      u8"主谋",
      u8"主谋者",
      u8"主谓",
      u8"主谓句",
      u8"主谓结构",
      u8"主路",
      u8"主路线",
      u8"主转动惯量",
      u8"主轴",
      u8"主轴电机",
      u8"主辩",
      u8"主辱臣死",
      u8"主进",
      u8"主送",
      u8"主部",
      u8"主重音",
      u8"主钢缆",
      u8"主钩",
      u8"主键",
      u8"主长",
      u8"主队",
      u8"主阵地",
      u8"主除子",
      u8"主震",
      u8"主面",
      u8"主音",
      u8"主音箱",
      u8"主音量",
      u8"主页",
      u8"主项",
      u8"主顾",
      u8"主频",
      u8"主题",
      u8"主题乐园",
      u8"主题公园",
      u8"主题医院",
      u8"主题卡",
      u8"主题思想",
      u8"主题性",
      u8"主题曲",
      u8"主题标引",
      u8"主题歌",
      u8"主题法",
      u8"主题深刻",
      u8"主题目录",
      u8"主题索引",
      u8"主题统觉测验",
      u8"主题词",
      u8"主题词表",
      u8"主题鲜明",
      u8"主食",
      u8"主食加工间",
      u8"主食品",
      u8"主食库",
      u8"主骨架",
      u8"丽丝胺罗丹明",
      u8"丽人",
      u8"丽人行",
      u8"丽句清词",
      u8"丽句清辞",
      u8"丽台",
      u8"丽园路",
      u8"丽婴房",
      u8"丽山",
      u8"丽影",
      u8"丽日",
      u8"丽日中天",
      u8"丽春院",
      u8"丽景嘉园",
      u8"丽服",
      u8"丽水",
      u8"丽水市",
      u8"丽江",
      u8"丽江县",
      u8"丽江市",
      u8"丽江纳西族自治县",
      u8"丽群",
      u8"丽而不媚",
      u8"丽色",
      u8"丽莉",
      u8"丽藻",
      u8"丽藻春葩",
      u8"丽贝卡",
      u8"丽质",
      u8"丽质天姿",
      u8"丽质天生",
      u8"丽都",
      u8"丽靡",
      u8"丽音",
      u8"丽风",
      u8"举一反三",
      u8"举一废百",
      u8"举不胜举",
      u8"举世",
      u8"举世公认",
      u8"举世文明",
      u8"举世无匹",
      u8"举世无双",
      u8"举世无敌",
      u8"举世混浊",
      u8"举世皆知",
      u8"举世瞩目",
      u8"举世罕见",
      u8"举世闻名",
      u8"举个",
      u8"举为",
      u8"举了",
      u8"举事",
      u8"举人",
      u8"举例",
      u8"举例发凡",
      u8"举例来说",
      u8"举例说明",
      u8"举借",
      u8"举债",
      u8"举全国之兵",
      u8"举兵",
      u8"举其一端",
      u8"举凡",
      u8"举出",
      u8"举出来",
      u8"举办",
      u8"举办地",
      u8"举办活动",
      u8"举动",
      u8"举十知九",
      u8"举升机",
      u8"举发",
      u8"举哀",
      u8"举善荐贤",
      u8"举国",
      u8"举国一致",
      u8"举国上下",
      u8"举国之力",
      u8"举国体制",
      u8"举国欢庆",
      u8"举国欢腾",
      u8"举国若狂",
      u8"举头",
      u8"举头三尺有神明",
      u8"举好",
      u8"举如鸿毛",
      u8"举如鸿毛取如拾遗",
      u8"举子",
      u8"举家",
      u8"举手",
      u8"举手之劳",
      u8"举手加额",
      u8"举手发言",
      u8"举手投足",
      u8"举手敬礼",
      u8"举手相庆",
      u8"举手礼",
      u8"举手表决",
      u8"举手赞成",
      u8"举报",
      u8"举报中心",
      u8"举报书",
      u8"举报人",
      u8"举报信",
      u8"举报电话",
      u8"举报箱",
      u8"举报线索",
      u8"举报者",
      u8"举抬",
      u8"举措",
      u8"举措不当",
      u8"举措失当",
      u8"举旗",
      u8"举无遗策",
      u8"举有",
      u8"举杯",
      u8"举杯畅饮",
      u8"举杯邀",
      u8"举枉措直",
      u8"举析",
      u8"举枪",
      u8"举架",
      u8"举案齐眉",
      u8"举棋不定",
      u8"举棋若定",
      u8"举止",
      u8"举止不凡",
      u8"举止大方",
      u8"举止失措",
      u8"举止娴雅",
      u8"举止文雅",
      u8"举止端庄",
      u8"举止自若",
      u8"举止行为",
      u8"举止言谈",
      u8"举止轻浮",
      u8"举步",
      u8"举步为艰",
      u8"举步生风",
      u8"举步维艰",
      u8"举火",
      u8"举烛",
      u8"举用",
      u8"举目",
      u8"举目千里",
      u8"举目可见",
      u8"举目四望",
      u8"举目无亲",
      u8"举目远眺",
      u8"举直",
      u8"举直措枉",
      u8"举直错枉",
      u8"举着",
      u8"举箸",
      u8"举组",
      u8"举荐",
      u8"举行",
      u8"举行仪式",
      u8"举行会谈",
      u8"举行宴会",
      u8"举行座谈",
      u8"举要",
      u8"举要删芜",
      u8"举证",
      u8"举证责任",
      u8"举证责任倒置",
      u8"举贤",
      u8"举贤任能",
      u8"举贤使能",
      u8"举贤荐能",
      u8"举起",
      u8"举起手来",
      u8"举起来",
      u8"举足",
      u8"举足轻重",
      u8"举轻若重",
      u8"举过",
      u8"举过去",
      u8"举过来",
      u8"举进士",
      u8"举重",
      u8"举重若轻",
      u8"举重选手",
      u8"举重队",
      u8"举错",
      u8"举高",
      u8"举鼎",
      u8"举鼎拔山",
      u8"举鼎绝膑",
      u8"乃东",
      u8"乃东县",
      u8"乃兄",
      u8"乃公",
      u8"乃堆拉",
      u8"乃尔",
      u8"乃就",
      u8"乃弟",
      u8"乃心王室",
      u8"乃我困汝",
      u8"乃文乃武",
      u8"乃是",
      u8"乃曰",
      u8"乃武乃文",
      u8"乃父",
      u8"乃祖",
      u8"乃翁",
      u8"乃能",
      u8"乃至",
      u8"乃至于",
      u8"乃蛮",
      u8"乃见",
      u8"乃需",
      u8"久久",
      u8"久久不忘",
      u8"久之",
      u8"久了",
      u8"久仰",
      u8"久仰大名",
      u8"久保田",
      u8"久候",
      u8"久假不归",
      u8"久别",
      u8"久别胜新婚",
      u8"久别重逢",
      u8"久历风尘",
      u8"久后",
      u8"久坐",
      u8"久存",
      u8"久安长治",
      u8"久安长浴",
      u8"久居",
      u8"久居人下",
      u8"久已",
      u8"久归道山",
      u8"久怀慕蔺",
      u8"久悬不决",
      u8"久惯牢成",
      u8"久惯老诚",
      u8"久慕",
      u8"久战沙场",
      u8"久拉登",
      u8"久拖",
      u8"久拖不决",
      u8"久拖不办",
      u8"久攻不下",
      u8"久旱",
      u8"久旱不雨",
      u8"久旱逢甘",
      u8"久旱逢甘雨",
      u8"久旱逢甘霖",
      u8"久暂",
      u8"久未联系",
      u8"久束湿薪",
      u8"久治",
      u8"久治不愈",
      u8"久治县",
      u8"久浸",
      u8"久游网",
      u8"久演不衰",
      u8"久炼成钢",
      u8"久留",
      u8"久病",
      u8"久病入络",
      u8"久病在床",
      u8"久病床前无孝子",
      u8"久病必瘀",
      u8"久病必虚",
      u8"久病成医",
      u8"久病成良",
      u8"久病成良医",
      u8"久病无孝子",
      u8"久盼",
      u8"久等",
      u8"久经",
      u8"久经世故",
      u8"久经沙场",
      u8"久经考验",
      u8"久经锻炼",
      u8"久经风霜",
      u8"久而久之",
      u8"久蛰思动",
      u8"久要不忘",
      u8"久负盛名",
      u8"久跪",
      u8"久远",
      u8"久违",
      u8"久长",
      u8"久间",
      u8"久闻",
      u8"久闻不知其臭",
      u8"久闻大名",
      u8"久雨",
      u8"久雨成灾",
      u8"么么唱唱",
      u8"么儿",
      u8"么喝",
      u8"么妹",
      u8"么子",
      u8"么弟",
      u8"么爷",
      u8"义万富翁",
      u8"义不反顾",
      u8"义不取容",
      u8"义不容辞",
      u8"义不生财",
      u8"义不辞难",
      u8"义举",
      u8"义乌",
      u8"义乌县",
      u8"义乌市",
      u8"义仆",
      u8"义仓",
      u8"义侠",
      u8"义债累累",
      u8"义兄",
      u8"义军",
      u8"义冢",
      u8"义决",
      u8"义利",
      u8"义利观",
      u8"义务",
      u8"义务人",
      u8"义务兵",
      u8"义务兵役制",
      u8"义务劳动",
      u8"义务工",
      u8"义务役",
      u8"义务性",
      u8"义务教育",
      u8"义务服务",
      u8"义务法",
      u8"义务献工",
      u8"义务献血",
      u8"义勇",
      u8"义勇兵",
      u8"义勇军",
      u8"义勇军进行曲",
      u8"义卖",
      u8"义卖会",
      u8"义卖场",
      u8"义县",
      u8"义和团",
      u8"义和团运动",
      u8"义和庄",
      u8"义和拳",
      u8"义国",
      u8"义国人",
      u8"义塾",
      u8"义士",
      u8"义大利",
      u8"义大利人",
      u8"义大利式",
      u8"义大利文",
      u8"义大利王",
      u8"义大利王国",
      u8"义女",
      u8"义妈",
      u8"义子",
      u8"义学",
      u8"义工",
      u8"义工联",
      u8"义师",
      u8"义庄",
      u8"义弟",
      u8"义形于色",
      u8"义律",
      u8"义愤",
      u8"义愤填胸",
      u8"义愤填膺",
      u8"义战",
      u8"义捐",
      u8"义断恩绝",
      u8"义方之训",
      u8"义旗",
      u8"义无反顾",
      u8"义无旋踵",
      u8"义无返顾",
      u8"义正严词",
      u8"义正词严",
      u8"义正辞严",
      u8"义正辞约",
      u8"义母",
      u8"义民",
      u8"义气",
      u8"义气相投",
      u8"义气风发",
      u8"义法",
      u8"义浆仁粟",
      u8"义海恩山",
      u8"义演",
      u8"义父",
      u8"义犬",
      u8"义理",
      u8"义生",
      u8"义田",
      u8"义结金兰",
      u8"义美",
      u8"义肢",
      u8"义胆忠肝",
      u8"义节",
      u8"义蕴",
      u8"义薄云天",
      u8"义行",
      u8"义警",
      u8"义诊",
      u8"义赛",
      u8"义足",
      u8"义部",
      u8"义重恩深",
      u8"义险固守",
      u8"义项",
      u8"义颌",
      u8"义风",
      u8"义马",
      u8"义马市",
      u8"义齿",
      u8"义齿吸附作用",
      u8"义齿型盒",
      u8"义齿填塞",
      u8"义齿性口炎",
      u8"义齿性口腔痛",
      u8"义齿承托区",
      u8"义齿热处理",
      u8"义齿粘附剂三级字",
      u8"义齿边缘",
      u8"之一",
      u8"之三",
      u8"之上",
      u8"之下",
      u8"之世",
      u8"之中",
      u8"之为",
      u8"之主",
      u8"之举",
      u8"之久",
      u8"之义",
      u8"之乎者也",
      u8"之乐",
      u8"之乡",
      u8"之书",
      u8"之乱",
      u8"之争",
      u8"之事",
      u8"之二",
      u8"之于",
      u8"之于法",
      u8"之交",
      u8"之人",
      u8"之低",
      u8"之余",
      u8"之作",
      u8"之便",
      u8"之光",
      u8"之兵",
      u8"之内",
      u8"之冠",
      u8"之冤",
      u8"之刃",
      u8"之分",
      u8"之列",
      u8"之初",
      u8"之利",
      u8"之别",
      u8"之前",
      u8"之剑",
      u8"之力",
      u8"之功",
      u8"之劳",
      u8"之势",
      u8"之又",
      u8"之友",
      u8"之变",
      u8"之右",
      u8"之名",
      u8"之后",
      u8"之味",
      u8"之和",
      u8"之哉",
      u8"之喜",
      u8"之国",
      u8"之在",
      u8"之地",
      u8"之城",
      u8"之墓",
      u8"之声",
      u8"之处",
      u8"之复",
      u8"之外",
      u8"之多",
      u8"之夜",
      u8"之大",
      u8"之女",
      u8"之妙",
      u8"之始",
      u8"之嫌",
      u8"之子",
      u8"之字形",
      u8"之字路",
      u8"之学",
      u8"之宝",
      u8"之实",
      u8"之害",
      u8"之家",
      u8"之屋",
      u8"之岛",
      u8"之左",
      u8"之巨",
      u8"之差",
      u8"之年",
      u8"之影",
      u8"之徒",
      u8"之心",
      u8"之忧",
      u8"之怨",
      u8"之恋",
      u8"之恩",
      u8"之情",
      u8"之想",
      u8"之意",
      u8"之感",
      u8"之愤",
      u8"之慢",
      u8"之我见",
      u8"之战",
      u8"之所以",
      u8"之手",
      u8"之才",
      u8"之扰",
      u8"之故",
      u8"之旁",
      u8"之旅",
      u8"之无",
      u8"之日",
      u8"之日起",
      u8"之时",
      u8"之星",
      u8"之春",
      u8"之最",
      u8"之有",
      u8"之本",
      u8"之极",
      u8"之梦",
      u8"之森",
      u8"之欢",
      u8"之欲",
      u8"之歌",
      u8"之死",
      u8"之死不渝",
      u8"之死靡二",
      u8"之死靡他",
      u8"之死靡它",
      u8"之母",
      u8"之比",
      u8"之水",
      u8"之江",
      u8"之法",
      u8"之流",
      u8"之源",
      u8"之火",
      u8"之灾",
      u8"之爱",
      u8"之父",
      u8"之狼",
      u8"之玉",
      u8"之王",
      u8"之珠",
      u8"之理",
      u8"之用",
      u8"之症",
      u8"之神",
      u8"之秋",
      u8"之称",
      u8"之窗",
      u8"之类",
      u8"之约",
      u8"之罪",
      u8"之而后快",
      u8"之能",
      u8"之能事",
      u8"之腹",
      u8"之至",
      u8"之致",
      u8"之舞",
      u8"之苦",
      u8"之蛙",
      u8"之行",
      u8"之见",
      u8"之规定",
      u8"之言",
      u8"之计",
      u8"之论",
      u8"之证",
      u8"之词",
      u8"之误",
      u8"之说",
      u8"之请",
      u8"之谈",
      u8"之谜",
      u8"之路",
      u8"之身",
      u8"之躯",
      u8"之辈",
      u8"之过",
      u8"之道",
      u8"之遥",
      u8"之都",
      u8"之醒",
      u8"之长",
      u8"之门",
      u8"之闲",
      u8"之间",
      u8"之际",
      u8"之隔",
      u8"之难",
      u8"之需",
      u8"之面",
      u8"之音",
      u8"之风",
      u8"之馀",
      u8"之首",
      u8"之高",
      u8"之龙",
      u8"乌七八糟",
      u8"乌丘",
      u8"乌丝",
      u8"乌丸",
      u8"乌之雌雄",
      u8"乌云",
      u8"乌云其木格",
      u8"乌云压顶",
      u8"乌云密布",
      u8"乌亮",
      u8"乌什",
      u8"乌什县",
      u8"乌仑古湖",
      u8"乌伊岭区",
      u8"乌克兰",
      u8"乌克兰人",
      u8"乌克兰队",
      u8"乌兰",
      u8"乌兰县",
      u8"乌兰察布",
      u8"乌兰察布市",
      u8"乌兰察布盟",
      u8"乌兰巴托",
      u8"乌兰浩特",
      u8"乌兰浩特市",
      u8"乌兰牧骑",
      u8"乌兰韦伯天线",
      u8"乌共",
      u8"乌兹别克",
      u8"乌兹别克斯坦",
      u8"乌卢布列夫斯基",
      u8"乌发",
      u8"乌合",
      u8"乌合之众",
      u8"乌呼",
      u8"乌咀乡",
      u8"乌塌菜",
      u8"乌天黑地",
      u8"乌头",
      u8"乌头白马生角",
      u8"乌头马角",
      u8"乌孜别克",
      u8"乌孜别克族",
      u8"乌审旗",
      u8"乌尔",
      u8"乌尔姆",
      u8"乌尔禾区",
      u8"乌局",
      u8"乌山",
      u8"乌山头",
      u8"乌巾",
      u8"乌市",
      u8"乌帽红裙",
      u8"乌干达",
      u8"乌当区",
      u8"乌德勒",
      u8"乌恰",
      u8"乌恰县",
      u8"乌托邦",
      u8"乌托邦主",
      u8"乌托邦主义",
      u8"乌拉",
      u8"乌拉圭",
      u8"乌拉圭人",
      u8"乌拉坦",
      u8"乌拉尔",
      u8"乌拉尔山脉",
      u8"乌拉山",
      u8"乌拉特",
      u8"乌拉特中旗",
      u8"乌拉特前旗",
      u8"乌拉特后旗",
      u8"乌拉草",
      u8"乌斯塔夏",
      u8"乌斯怀亚",
      u8"乌日",
      u8"乌日娜",
      u8"乌旺阿普",
      u8"乌有",
      u8"乌有先生",
      u8"乌木",
      u8"乌木剑",
      u8"乌来",
      u8"乌来乡",
      u8"乌枣",
      u8"乌桓",
      u8"乌桕",
      u8"乌梁海",
      u8"乌梁海人",
      u8"乌梅",
      u8"乌梅汁",
      u8"乌梅酒",
      u8"乌梢蛇",
      u8"乌檀",
      u8"乌氏粘度计",
      u8"乌江",
      u8"乌池",
      u8"乌沈沈",
      u8"乌沉沉",
      u8"乌沙村",
      u8"乌油油",
      u8"乌洽会",
      u8"乌浩特",
      u8"乌海",
      u8"乌海市",
      u8"乌涂",
      u8"乌溜溜",
      u8"乌滋别克",
      u8"乌烟瘴气",
      u8"乌焉成马",
      u8"乌焦巴弓",
      u8"乌珠穆沁旗",
      u8"乌白马角",
      u8"乌盟",
      u8"乌石乡",
      u8"乌礁湾",
      u8"乌篷",
      u8"乌篷船",
      u8"乌纱",
      u8"乌纱帽",
      u8"乌老大",
      u8"乌脚病",
      u8"乌苏",
      u8"乌苏县",
      u8"乌苏市",
      u8"乌苏里",
      u8"乌苏里江",
      u8"乌药",
      u8"乌蒙山",
      u8"乌蓝",
      u8"乌蛤",
      u8"乌衣之游",
      u8"乌衣子弟",
      u8"乌衣巷",
      u8"乌衣门第",
      u8"乌豆",
      u8"乌贼",
      u8"乌贼骨",
      u8"乌踆兔走",
      u8"乌达",
      u8"乌达区",
      u8"乌金",
      u8"乌镇",
      u8"乌集之交",
      u8"乌集之众",
      u8"乌雷松算子",
      u8"乌青",
      u8"乌面鹄形",
      u8"乌鞘岭",
      u8"乌韭",
      u8"乌飞免走",
      u8"乌飞兔走",
      u8"乌饭树",
      u8"乌马河区",
      u8"乌骨鸡",
      u8"乌鱼",
      u8"乌鱼子",
      u8"乌鱼蛋",
      u8"乌鲁木齐",
      u8"乌鲁木齐县",
      u8"乌鲁木齐市",
      u8"乌鲁木齐铁路局",
      u8"乌鲳",
      u8"乌鳢",
      u8"乌鸟私情",
      u8"乌鸡",
      u8"乌鸡汤",
      u8"乌鸦",
      u8"乌鸦嘴",
      u8"乌黑",
      u8"乌黑亮丽",
      u8"乌黑黑",
      u8"乌龙",
      u8"乌龙球",
      u8"乌龙茶",
      u8"乌龙院",
      u8"乌龙驹",
      u8"乌龟",
      u8"乌龟壳",
      u8"乌龟王八",
      u8"乌龟王八蛋",
      u8"乍一听",
      u8"乍一看",
      u8"乍冷",
      u8"乍冷乍热",
      u8"乍听",
      u8"乍听之下",
      u8"乍富",
      u8"乍寒乍热",
      u8"乍往乍来",
      u8"乍得",
      u8"乍暖",
      u8"乍暖乍寒",
      u8"乍暖还寒",
      u8"乍毛变色",
      u8"乍浦",
      u8"乍热",
      u8"乍热乍冷",
      u8"乍然",
      u8"乍现",
      u8"乍看",
      u8"乍看之下",
      u8"乍看来",
      u8"乍见",
      u8"乍读",
      u8"乍读之下",
      u8"乍雨乍晴",
      u8"乎呼",
      u8"乎噜",
      u8"乏人问津",
      u8"乏力",
      u8"乏力感",
      u8"乏味",
      u8"乏善",
      u8"乏善可陈",
      u8"乏困",
      u8"乏指",
      u8"乏术",
      u8"乏汽",
      u8"乏煤",
      u8"乏色",
      u8"乏话",
      u8"乏货",
      u8"乏顿",
      u8"乐不可支",
      u8"乐不可极",
      u8"乐不可言",
      u8"乐不思蜀",
      u8"乐不极盘",
      u8"乐业",
      u8"乐业县",
      u8"乐业安居",
      u8"乐东黎族自治县",
      u8"乐之路",
      u8"乐乐",
      u8"乐了",
      u8"乐事",
      u8"乐事劝功",
      u8"乐于",
      u8"乐于助人",
      u8"乐亭",
      u8"乐亭县",
      u8"乐亿阳",
      u8"乐从",
      u8"乐以忘忧",
      u8"乐儿",
      u8"乐凯",
      u8"乐利",
      u8"乐到",
      u8"乐华",
      u8"乐厚",
      u8"乐友网",
      u8"乐受",
      u8"乐句",
      u8"乐吧",
      u8"乐呵呵",
      u8"乐命",
      u8"乐和",
      u8"乐善",
      u8"乐善不倦",
      u8"乐善好义",
      u8"乐善好施",
      u8"乐喜金星",
      u8"乐嗟苦咄",
      u8"乐器",
      u8"乐器厂",
      u8"乐器网",
      u8"乐器行",
      u8"乐团",
      u8"乐园",
      u8"乐土",
      u8"乐圣",
      u8"乐在其中",
      u8"乐坊",
      u8"乐坏了",
      u8"乐坛",
      u8"乐基儿",
      u8"乐境",
      u8"乐声",
      u8"乐天",
      u8"乐天任命",
      u8"乐天安命",
      u8"乐天派",
      u8"乐天知命",
      u8"乐子",
      u8"乐安",
      u8"乐安县",
      u8"乐安居",
      u8"乐官",
      u8"乐尽哀生",
      u8"乐尽悲来",
      u8"乐山",
      u8"乐山乐水",
      u8"乐山市",
      u8"乐山爱水",
      u8"乐工",
      u8"乐师",
      u8"乐平",
      u8"乐平市",
      u8"乐府",
      u8"乐府诗",
      u8"乐彩网",
      u8"乐往哀来",
      u8"乐律",
      u8"乐得",
      u8"乐心",
      u8"乐悠悠",
      u8"乐意",
      u8"乐意于",
      u8"乐意效劳",
      u8"乐感",
      u8"乐成人美",
      u8"乐户",
      u8"乐手",
      u8"乐捐",
      u8"乐捐箱",
      u8"乐捐运动",
      u8"乐新厌旧",
      u8"乐施",
      u8"乐无忧",
      u8"乐昌",
      u8"乐昌之镜",
      u8"乐昌分镜",
      u8"乐昌县",
      u8"乐昌市",
      u8"乐昌破镜",
      u8"乐曲",
      u8"乐曲声",
      u8"乐极则忧",
      u8"乐极则悲",
      u8"乐极哀来",
      u8"乐极悲来",
      u8"乐极悲生",
      u8"乐极生哀",
      u8"乐极生悲",
      u8"乐果",
      u8"乐歌",
      u8"乐此不倦",
      u8"乐此不彼",
      u8"乐此不疲",
      u8"乐死",
      u8"乐段",
      u8"乐毅",
      u8"乐池",
      u8"乐清",
      u8"乐清县",
      u8"乐清市",
      u8"乐滋滋",
      u8"乐满地",
      u8"乐珈彤",
      u8"乐理",
      u8"乐百氏",
      u8"乐百氏杯",
      u8"乐着",
      u8"乐神",
      u8"乐祸幸灾",
      u8"乐章",
      u8"乐群",
      u8"乐翻天",
      u8"乐者",
      u8"乐而不厌",
      u8"乐而不淫",
      u8"乐而不荒",
      u8"乐而忘形",
      u8"乐而忘忧",
      u8"乐而忘死",
      u8"乐而忘返",
      u8"乐育",
      u8"乐育人才",
      u8"乐腾",
      u8"乐至",
      u8"乐至县",
      u8"乐舞",
      u8"乐融融",
      u8"乐行忧违",
      u8"乐行者",
      u8"乐见",
      u8"乐观",
      u8"乐观主义",
      u8"乐观主义者",
      u8"乐记",
      u8"乐论",
      u8"乐评家",
      u8"乐调",
      u8"乐谱",
      u8"乐谱架",
      u8"乐趣",
      u8"乐趣园",
      u8"乐趣横生",
      u8"乐趣网",
      u8"乐进",
      u8"乐迷",
      u8"乐退安贫",
      u8"乐透型",
      u8"乐透彩",
      u8"乐透网",
      u8"乐道",
      u8"乐道好古",
      u8"乐道安命",
      u8"乐道安贫",
      u8"乐道忘饥",
      u8"乐道遗荣",
      u8"乐邦",
      u8"乐都县",
      u8"乐闻",
      u8"乐队",
      u8"乐陵",
      u8"乐陵县",
      u8"乐陵市",
      u8"乐陶陶",
      u8"乐障",
      u8"乐音",
      u8"乐颠颠",
      u8"乒乒",
      u8"乒乒乓乓",
      u8"乒乓",
      u8"乒乓外交",
      u8"乒乓室",
      u8"乒乓球",
      u8"乒乓球台",
      u8"乒乓球拍",
      u8"乒乓球桌",
      u8"乒乓球赛",
      u8"乒乓球队",
      u8"乒乓网",
      u8"乒协",
      u8"乒坛",
      u8"乓乓",
      u8"乔丹",
      u8"乔乔",
      u8"乔伊斯",
      u8"乔其纱",
      u8"乔冠华",
      u8"乔卢奥",
      u8"乔口区",
      u8"乔国老",
      u8"乔奇",
      u8"乔奎",
      u8"乔妆",
      u8"乔妆打扮",
      u8"乔妆改扮",
      u8"乔姆斯基层次结构",
      u8"乔宏",
      u8"乔家大院",
      u8"乔寨主",
      u8"乔峰",
      u8"乔布",
      u8"乔布斯",
      u8"乔庄",
      u8"乔庄村",
      u8"乔戈里",
      u8"乔扮",
      u8"乔文假醋",
      u8"乔木",
      u8"乔杰立",
      u8"乔松之寿",
      u8"乔治",
      u8"乔治亚",
      u8"乔治亚州",
      u8"乔治华盛",
      u8"乔治华盛顿",
      u8"乔治敦",
      u8"乔治王岛",
      u8"乔然山",
      u8"乔石",
      u8"乔福",
      u8"乔科尔",
      u8"乔老爷",
      u8"乔脑",
      u8"乔致庸",
      u8"乔装",
      u8"乔装打扮",
      u8"乔装改扮",
      u8"乔迁",
      u8"乔迁之喜",
      u8"乔迁盛宴",
      u8"乔龙画虎",
      u8"乖乖",
      u8"乖乖仔",
      u8"乖乖女",
      u8"乖乖狗",
      u8"乖乖虎",
      u8"乖僻",
      u8"乖僻邪谬",
      u8"乖到",
      u8"乖唇蜜舌",
      u8"乖嘴蜜舌",
      u8"乖孩子",
      u8"乖宝宝",
      u8"乖巧",
      u8"乖异",
      u8"乖张",
      u8"乖得",
      u8"乖戾",
      u8"乖舛",
      u8"乖觉",
      u8"乖谬",
      u8"乖蹇",
      u8"乖违",
      u8"乖隔",
      u8"乖顺",
      u8"乘上",
      u8"乘专机",
      u8"乘了",
      u8"乘云行泥",
      u8"乘人之危",
      u8"乘以",
      u8"乘伪行诈",
      u8"乘便",
      u8"乘兴",
      u8"乘兴而去",
      u8"乘兴而往",
      u8"乘兴而往败兴而归",
      u8"乘兴而来",
      u8"乘兴而来败兴而归",
      u8"乘其不备",
      u8"乘其不意",
      u8"乘具",
      u8"乘凉",
      u8"乘利席胜",
      u8"乘到",
      u8"乘务",
      u8"乘务员",
      u8"乘务警",
      u8"乘势",
      u8"乘势使气",
      u8"乘号",
      u8"乘同余方法",
      u8"乘员",
      u8"乘商寄存器",
      u8"乘在",
      u8"乘坐",
      u8"乘坚策肥",
      u8"乘客",
      u8"乘客单",
      u8"乘客电梯",
      u8"乘幂",
      u8"乘座",
      u8"乘得",
      u8"乘快艇",
      u8"乘性二次型",
      u8"乘性同余",
      u8"乘性约化",
      u8"乘敌不备",
      u8"乘数",
      u8"乘数词头",
      u8"乘方",
      u8"乘时乘势",
      u8"乘晕宁",
      u8"乘机",
      u8"乘机打劫",
      u8"乘机而入",
      u8"乘法",
      u8"乘法器",
      u8"乘法表",
      u8"乘火车",
      u8"乘热打铁",
      u8"乘用车",
      u8"乘着",
      u8"乘积",
      u8"乘积检波器",
      u8"乘空",
      u8"乘筏",
      u8"乘肥衣轻",
      u8"乘胜",
      u8"乘胜前进",
      u8"乘胜追击",
      u8"乘胜逐北",
      u8"乘舆播越",
      u8"乘船",
      u8"乘虚",
      u8"乘虚而入",
      u8"乘虚蹈隙",
      u8"乘虚迭出",
      u8"乘警",
      u8"乘起",
      u8"乘起来",
      u8"乘车",
      u8"乘车戴笠",
      u8"乘轻驱肥",
      u8"乘轿",
      u8"乘过",
      u8"乘过去",
      u8"乘过来",
      u8"乘间",
      u8"乘间伺隙",
      u8"乘间投隙",
      u8"乘间抵隙",
      u8"乘除",
      u8"乘险抵巇",
      u8"乘隙",
      u8"乘隙捣虚",
      u8"乘隙而入",
      u8"乘顺水船",
      u8"乘风",
      u8"乘风兴浪",
      u8"乘风扬土",
      u8"乘风扬帆",
      u8"乘风破浪",
      u8"乘风转舵",
      u8"乘飞机",
      u8"乘马",
      u8"乘高决水",
      u8"乘鸾跨凤",
      u8"乘龙佳婿",
      u8"乘龙快婿",
      u8"乘龙配凤",
      u8"乙丑",
      u8"乙丙橡胶",
      u8"乙二胺",
      u8"乙二醇",
      u8"乙二醇单乙醚",
      u8"乙亥",
      u8"乙内酰胺",
      u8"乙午",
      u8"乙卯",
      u8"乙地",
      u8"乙型",
      u8"乙型肝炎",
      u8"乙基",
      u8"乙子",
      u8"乙存",
      u8"乙寅",
      u8"乙巳",
      u8"乙戌",
      u8"乙方",
      u8"乙未",
      u8"乙炔",
      u8"乙炔类聚合物",
      u8"乙烯",
      u8"乙烯基",
      u8"乙烯基醚",
      u8"乙烯氧化",
      u8"乙烯氧氯化",
      u8"乙烯精馏塔",
      u8"乙烯高压法聚合",
      u8"乙烷",
      u8"乙状结肠",
      u8"乙班",
      u8"乙申",
      u8"乙种",
      u8"乙种射线",
      u8"乙种粒子",
      u8"乙种维生",
      u8"乙种维生素",
      u8"乙等",
      u8"乙类",
      u8"乙类放大器",
      u8"乙级",
      u8"乙级队",
      u8"乙肝",
      u8"乙肝患者",
      u8"乙肝疫苗",
      u8"乙肝病毒",
      u8"乙胺",
      u8"乙脑",
      u8"乙苯",
      u8"乙辰",
      u8"乙酉",
      u8"乙酰",
      u8"乙酰化",
      u8"乙酰基",
      u8"乙酰羧甲基酯",
      u8"乙酰胆碱",
      u8"乙酸",
      u8"乙酸乙酯",
      u8"乙酸酐",
      u8"乙酸铵",
      u8"乙醇",
      u8"乙醇汽油",
      u8"乙醇溶液",
      u8"乙醇胺",
      u8"乙醚",
      u8"乙醛",
      u8"乙醛酸",
      u8"乜乜斜斜",
      u8"乜嘢",
      u8"乜斜",
      u8"乜斜缠帐",
      u8"乜水",
      u8"九一八",
      u8"九一八事",
      u8"九一八事变",
      u8"九三军人",
      u8"九三学社",
      u8"九世",
      u8"九世之仇",
      u8"九世纪",
      u8"九中全会",
      u8"九九乘法",
      u8"九九乘法表",
      u8"九九八十一",
      u8"九九归一",
      u8"九九归原",
      u8"九九歌",
      u8"九九表",
      u8"九九重阳",
      u8"九五",
      u8"九五之尊",
      u8"九五至尊",
      u8"九仞一篑",
      u8"九位数",
      u8"九儒十丐",
      u8"九关虎豹",
      u8"九冬会",
      u8"九分新",
      u8"九分熟",
      u8"九十其仪",
      u8"九千岁",
      u8"九华山",
      u8"九卿",
      u8"九原",
      u8"九原可作",
      u8"九变十化",
      u8"九台",
      u8"九台县",
      u8"九台市",
      u8"九合一匡",
      u8"九员",
      u8"九命怪猫",
      u8"九品",
      u8"九品中正",
      u8"九回肠断",
      u8"九圆",
      u8"九圈",
      u8"九垓八埏",
      u8"九城",
      u8"九大行星",
      u8"九天",
      u8"九天之外",
      u8"九天九地",
      u8"九天仙女",
      u8"九天揽月",
      u8"九天音乐",
      u8"九天音乐网",
      u8"九头狮子草",
      u8"九头鸟",
      u8"九孔",
      u8"九宗七祖",
      u8"九宫",
      u8"九宫山",
      u8"九宫格",
      u8"九宫格儿",
      u8"九宫键",
      u8"九宵",
      u8"九宵云",
      u8"九宵云外",
      u8"九寨沟",
      u8"九寨沟县",
      u8"九尾狐",
      u8"九峰山",
      u8"九嶷山",
      u8"九州",
      u8"九州四海",
      u8"九州岛",
      u8"九年义务教育",
      u8"九年之储",
      u8"九年之蓄",
      u8"九年制",
      u8"九弦琴",
      u8"九归",
      u8"九成新",
      u8"九所",
      u8"九把刀",
      u8"九故十亲",
      u8"九族文化村",
      u8"九旬",
      u8"九曲回肠",
      u8"九曲堂",
      u8"九曲桥",
      u8"九月",
      u8"九月九",
      u8"九朝古都",
      u8"九朽一罢",
      u8"九架梁",
      u8"九柳",
      u8"九格",
      u8"九死一生",
      u8"九死不悔",
      u8"九死未悔",
      u8"九死生",
      u8"九段",
      u8"九江",
      u8"九江八河",
      u8"九江县",
      u8"九江市",
      u8"九江路",
      u8"九江镇",
      u8"九泉",
      u8"九泉之下",
      u8"九洲",
      u8"九洲四海",
      u8"九派",
      u8"九流",
      u8"九流三教",
      u8"九流人物",
      u8"九流十家",
      u8"九流宾客",
      u8"九流百家",
      u8"九点半",
      u8"九点整",
      u8"九点钟",
      u8"九炼成钢",
      u8"九烈三贞",
      u8"九牛一毛",
      u8"九牛一毫",
      u8"九牛二虎",
      u8"九牛二虎之力",
      u8"九牛拉不转",
      u8"九牧王",
      u8"九班",
      u8"九瓶",
      u8"九皋",
      u8"九窍",
      u8"九章",
      u8"九章算术",
      u8"九臂钹",
      u8"九色鹿",
      u8"九节菖蒲",
      u8"九蒸三熯",
      u8"九行八业",
      u8"九街",
      u8"九衢三市",
      u8"九角",
      u8"九角形",
      u8"九课",
      u8"九转功成",
      u8"九转还魂丹",
      u8"九运",
      u8"九运会",
      u8"九连宝灯",
      u8"九通",
      u8"九部",
      u8"九里区",
      u8"九里山",
      u8"九里山乡",
      u8"九里香",
      u8"九重",
      u8"九重葛",
      u8"九重霄",
      u8"九针",
      u8"九间大殿",
      u8"九间朝殿",
      u8"九阍虎豹",
      u8"九阳",
      u8"九阴真经",
      u8"九难",
      u8"九集",
      u8"九零年",
      u8"九霄",
      u8"九霄云外",
      u8"九颗",
      u8"九首歌",
      u8"九香虫",
      u8"九鼎",
      u8"九鼎一丝",
      u8"九鼎不足为重",
      u8"九鼎大吕",
      u8"九龙",
      u8"九龙区",
      u8"九龙半岛",
      u8"九龙县",
      u8"九龙坡区",
      u8"九龙城",
      u8"九龙塘",
      u8"九龙壁",
      u8"九龙山",
      u8"九龙湖",
      u8"九龙湾",
      u8"乞丐",
      u8"乞乞缩缩",
      u8"乞儿",
      u8"乞儿乘车",
      u8"乞儿马医",
      u8"乞力马扎罗山",
      u8"乞命",
      u8"乞和",
      u8"乞哀告怜",
      u8"乞巧",
      u8"乞怜",
      u8"乞怜摇尾",
      u8"乞恕",
      u8"乞悯告怜",
      u8"乞援",
      u8"乞求",
      u8"乞求育嗣行为",
      u8"乞浆得酒",
      u8"乞灵",
      u8"乞爱者",
      u8"乞穷俭相",
      u8"乞粮",
      u8"乞讨",
      u8"乞讨者",
      u8"乞贷",
      u8"乞降",
      u8"乞食",
      u8"也好",
      u8"也就",
      u8"也就是说",
      u8"也才",
      u8"也无",
      u8"也无晴",
      u8"也是",
      u8"也有",
      u8"也没有",
      u8"也罢",
      u8"也行",
      u8"也要",
      u8"也许",
      u8"也门",
      u8"习与性成",
      u8"习习",
      u8"习于",
      u8"习以为常",
      u8"习以成俗",
      u8"习以成性",
      u8"习以成风",
      u8"习仲勋",
      u8"习作",
      u8"习作簿",
      u8"习俗",
      u8"习俗移性",
      u8"习军",
      u8"习好",
      u8"习字",
      u8"习字帖",
      u8"习字本",
      u8"习字课",
      u8"习定",
      u8"习尚",
      u8"习得行为",
      u8"习性",
      u8"习性学",
      u8"习惯",
      u8"习惯上",
      u8"习惯了就好了",
      u8"习惯于",
      u8"习惯势力",
      u8"习惯化",
      u8"习惯地",
      u8"习惯性",
      u8"习惯性流产",
      u8"习惯成自然",
      u8"习惯法",
      u8"习惯用法",
      u8"习惯用语",
      u8"习惯自然",
      u8"习拳",
      u8"习故安常",
      u8"习文",
      u8"习服",
      u8"习染",
      u8"习武",
      u8"习气",
      u8"习水",
      u8"习水县",
      u8"习焉不察",
      u8"习用",
      u8"习用语",
      u8"习相远",
      u8"习练",
      u8"习而不察",
      u8"习艺",
      u8"习艺所",
      u8"习见",
      u8"习语",
      u8"习谚",
      u8"习近平",
      u8"习非",
      u8"习非成是",
      u8"习非胜是",
      u8"习题",
      u8"习题课",
      u8"习题集",
      u8"乡丁",
      u8"乡下",
      u8"乡下人",
      u8"乡下佬",
      u8"乡下城",
      u8"乡下老儿",
      u8"乡乡",
      u8"乡乡镇镇",
      u8"乡书难寄",
      u8"乡事会",
      u8"乡井",
      u8"乡亲",
      u8"乡亲们",
      u8"乡人",
      u8"乡企",
      u8"乡企局",
      u8"乡会",
      u8"乡佬",
      u8"乡俗",
      u8"乡党",
      u8"乡党委",
      u8"乡公所",
      u8"乡关",
      u8"乡利倍义",
      u8"乡办",
      u8"乡办企业",
      u8"乡勇",
      u8"乡原",
      u8"乡友",
      u8"乡名",
      u8"乡味",
      u8"乡土",
      u8"乡土味",
      u8"乡土建筑",
      u8"乡土文学",
      u8"乡土气",
      u8"乡土气息",
      u8"乡土艺术",
      u8"乡土观念",
      u8"乡土风味",
      u8"乡城",
      u8"乡城县",
      u8"乡塾",
      u8"乡壁虚造",
      u8"乡宁",
      u8"乡宁县",
      u8"乡宦",
      u8"乡居",
      u8"乡巴佬",
      u8"乡干部",
      u8"乡心",
      u8"乡思",
      u8"乡情",
      u8"乡愁",
      u8"乡愿",
      u8"乡政府",
      u8"乡曲",
      u8"乡村",
      u8"乡村人口",
      u8"乡村化",
      u8"乡村地理学",
      u8"乡村干部",
      u8"乡村服",
      u8"乡村生活模式",
      u8"乡村规划",
      u8"乡村都市化",
      u8"乡村音乐",
      u8"乡校",
      u8"乡民",
      u8"乡民代表",
      u8"乡民代表会",
      u8"乡气",
      u8"乡级",
      u8"乡绅",
      u8"乡规民约",
      u8"乡试",
      u8"乡谈",
      u8"乡谊",
      u8"乡贤",
      u8"乡运会",
      u8"乡邮",
      u8"乡邻",
      u8"乡里",
      u8"乡里乡亲",
      u8"乡野",
      u8"乡镇",
      u8"乡镇代表",
      u8"乡镇企业",
      u8"乡镇企业局",
      u8"乡镇党委",
      u8"乡镇干部",
      u8"乡镇政府",
      u8"乡镇民代",
      u8"乡镇民代表",
      u8"乡镇经济",
      u8"乡镇财政",
      u8"乡镇长",
      u8"乡长",
      u8"乡间",
      u8"乡间别墅",
      u8"乡音",
      u8"乡音未改鬓毛衰",
      u8"乡鸽不通",
      u8"书上",
      u8"书上门",
      u8"书不尽",
      u8"书不尽意",
      u8"书不尽言",
      u8"书不释手",
      u8"书丛",
      u8"书中",
      u8"书之后",
      u8"书亭",
      u8"书价",
      u8"书会",
      u8"书体",
      u8"书信",
      u8"书信体",
      u8"书信往来",
      u8"书信往返",
      u8"书信来往",
      u8"书信集",
      u8"书僮",
      u8"书内",
      u8"书册",
      u8"书写",
      u8"书写台",
      u8"书写器",
      u8"书写困难",
      u8"书写方向",
      u8"书写纸",
      u8"书写能力",
      u8"书函",
      u8"书刊",
      u8"书刊号",
      u8"书刊市场",
      u8"书刊杂志",
      u8"书到用时方恨少",
      u8"书剑恩仇录",
      u8"书剑飘零",
      u8"书包",
      u8"书包带",
      u8"书匠",
      u8"书协",
      u8"书单",
      u8"书卡",
      u8"书卷",
      u8"书卷气",
      u8"书友会",
      u8"书口",
      u8"书号",
      u8"书同文",
      u8"书同文车同轨",
      u8"书名",
      u8"书名卡",
      u8"书名号",
      u8"书名目录",
      u8"书名索引",
      u8"书名页",
      u8"书后",
      u8"书吏",
      u8"书启",
      u8"书呆",
      u8"书呆子",
      u8"书品",
      u8"书商",
      u8"书囊无底",
      u8"书圣",
      u8"书场",
      u8"书坊",
      u8"书坛",
      u8"书城",
      u8"书堆",
      u8"书塾",
      u8"书声",
      u8"书声琅琅",
      u8"书夹",
      u8"书契",
      u8"书套",
      u8"书学",
      u8"书家",
      u8"书富五车",
      u8"书局",
      u8"书屋",
      u8"书展",
      u8"书市",
      u8"书库",
      u8"书店",
      u8"书店价",
      u8"书店名称",
      u8"书归正传",
      u8"书录",
      u8"书形",
      u8"书影",
      u8"书我买",
      u8"书房",
      u8"书扉",
      u8"书报",
      u8"书报亭",
      u8"书报刊",
      u8"书报摊",
      u8"书报杂志",
      u8"书报滩",
      u8"书报费",
      u8"书摊",
      u8"书摘",
      u8"书斋",
      u8"书明",
      u8"书本",
      u8"书本上",
      u8"书本式目录",
      u8"书本知识",
      u8"书本费",
      u8"书札",
      u8"书机",
      u8"书林",
      u8"书架",
      u8"书架上",
      u8"书架箱",
      u8"书柜",
      u8"书标",
      u8"书案",
      u8"书桌",
      u8"书桌上",
      u8"书桌下",
      u8"书档",
      u8"书楼",
      u8"书橱",
      u8"书款",
      u8"书法",
      u8"书法作品",
      u8"书法史",
      u8"书法家",
      u8"书法展",
      u8"书法报",
      u8"书法网",
      u8"书法艺术",
      u8"书法课",
      u8"书法集",
      u8"书海",
      u8"书牍",
      u8"书物",
      u8"书状",
      u8"书生",
      u8"书生之见",
      u8"书生本色",
      u8"书生气",
      u8"书用",
      u8"书画",
      u8"书画作品",
      u8"书画卯酉",
      u8"书画名家",
      u8"书画家",
      u8"书画展",
      u8"书画界",
      u8"书画社",
      u8"书画网",
      u8"书画艺术",
      u8"书画院",
      u8"书画集",
      u8"书痴",
      u8"书皮",
      u8"书目",
      u8"书目工作",
      u8"书眉",
      u8"书社",
      u8"书稿",
      u8"书空咄咄",
      u8"书立",
      u8"书童",
      u8"书符咒水",
      u8"书签",
      u8"书简",
      u8"书箧",
      u8"书箱",
      u8"书籍",
      u8"书籍装帧",
      u8"书籍费",
      u8"书系",
      u8"书经",
      u8"书缺有间",
      u8"书缺简脱",
      u8"书翰",
      u8"书肆",
      u8"书背",
      u8"书脊",
      u8"书艺文",
      u8"书荒",
      u8"书虫",
      u8"书虫子",
      u8"书蠹",
      u8"书袋",
      u8"书讯",
      u8"书记",
      u8"书记员",
      u8"书记处",
      u8"书记处书记",
      u8"书记官",
      u8"书记长",
      u8"书论",
      u8"书证",
      u8"书评",
      u8"书评人",
      u8"书评请",
      u8"书读五车",
      u8"书账",
      u8"书贩",
      u8"书费",
      u8"书迷",
      u8"书通二酉",
      u8"书道",
      u8"书里",
      u8"书钉",
      u8"书铺",
      u8"书院",
      u8"书集",
      u8"书面",
      u8"书面上",
      u8"书面发言",
      u8"书面声明",
      u8"书面形式",
      u8"书面报告",
      u8"书面材料",
      u8"书面言语",
      u8"书面语",
      u8"书面语言",
      u8"书面资料",
      u8"书面通知",
      u8"书页",
      u8"书馆",
      u8"书馆儿",
      u8"书香",
      u8"书香世家",
      u8"书香人家",
      u8"书香园",
      u8"书香社会",
      u8"书香门户",
      u8"书香门第",
      u8"书龄",
      u8"乩童",
      u8"买一",
      u8"买一送一",
      u8"买上告下",
      u8"买上嘱下",
      u8"买下",
      u8"买下来",
      u8"买不到",
      u8"买不起",
      u8"买东买西",
      u8"买东西",
      u8"买个",
      u8"买主",
      u8"买书",
      u8"买买",
      u8"买了",
      u8"买些",
      u8"买价",
      u8"买光",
      u8"买入",
      u8"买入价",
      u8"买关节",
      u8"买到",
      u8"买办",
      u8"买办资本",
      u8"买办阶级",
      u8"买单",
      u8"买卖",
      u8"买卖业",
      u8"买卖人",
      u8"买卖双方",
      u8"买卖合同",
      u8"买卖婚姻",
      u8"买卖成",
      u8"买卖方",
      u8"买卖网",
      u8"买卖通",
      u8"买去",
      u8"买受人",
      u8"买回",
      u8"买回去",
      u8"买回来",
      u8"买壳",
      u8"买好",
      u8"买它",
      u8"买定",
      u8"买定离手",
      u8"买客",
      u8"买家",
      u8"买家没有卖家精",
      u8"买帐",
      u8"买张",
      u8"买得",
      u8"买得起",
      u8"买成",
      u8"买户",
      u8"买房",
      u8"买房人",
      u8"买房子",
      u8"买手",
      u8"买手机",
      u8"买担心",
      u8"买断",
      u8"买断式",
      u8"买方",
      u8"买方市场",
      u8"买春",
      u8"买来",
      u8"买来买去",
      u8"买椟还珠",
      u8"买气",
      u8"买淫",
      u8"买点",
      u8"买爵贩官",
      u8"买牛卖剑",
      u8"买牛息戈",
      u8"买犁卖剑",
      u8"买犊卖刀",
      u8"买王得羊",
      u8"买田阳羡",
      u8"买盘",
      u8"买着",
      u8"买碟",
      u8"买票",
      u8"买空",
      u8"买空卖空",
      u8"买笑寻欢",
      u8"买笑迎欢",
      u8"买笑追欢",
      u8"买米",
      u8"买给",
      u8"买者",
      u8"买臣覆水",
      u8"买药",
      u8"买菜",
      u8"买菜求益",
      u8"买账",
      u8"买货",
      u8"买贱卖贵",
      u8"买走",
      u8"买起",
      u8"买起来",
      u8"买超",
      u8"买路钱",
      u8"买车",
      u8"买辆",
      u8"买过",
      u8"买进",
      u8"买通",
      u8"买醉",
      u8"买铁思金",
      u8"买静求安",
      u8"买面子",
      u8"买鞋",
      u8"买饭",
      u8"买马",
      u8"买马招兵",
      u8"买马招军",
      u8"乱七八糟",
      u8"乱世",
      u8"乱世之音",
      u8"乱世佳人",
      u8"乱世儿女",
      u8"乱世凶年",
      u8"乱世出英雄",
      u8"乱世用重典",
      u8"乱世英雄",
      u8"乱丝",
      u8"乱丢",
      u8"乱丢垃圾",
      u8"乱丢纸屑",
      u8"乱乎",
      u8"乱乱哄哄",
      u8"乱乱纷纷",
      u8"乱乱腾腾",
      u8"乱乱轰轰",
      u8"乱了套",
      u8"乱了手脚",
      u8"乱了阵脚",
      u8"乱事",
      u8"乱交",
      u8"乱伦",
      u8"乱估",
      u8"乱作一团",
      u8"乱作胡为",
      u8"乱倒",
      u8"乱倒垃圾",
      u8"乱做",
      u8"乱免",
      u8"乱党",
      u8"乱兵",
      u8"乱写",
      u8"乱军",
      u8"乱冲",
      u8"乱切",
      u8"乱删",
      u8"乱到",
      u8"乱刺",
      u8"乱加",
      u8"乱加干涉",
      u8"乱动",
      u8"乱占",
      u8"乱占耕地",
      u8"乱发",
      u8"乱叫",
      u8"乱吃",
      u8"乱吵",
      u8"乱吼",
      u8"乱吼乱叫",
      u8"乱咬",
      u8"乱哄哄",
      u8"乱喊",
      u8"乱喊乱叫",
      u8"乱喝",
      u8"乱国",
      u8"乱图",
      u8"乱坟岗",
      u8"乱坠天花",
      u8"乱堆",
      u8"乱头粗服",
      u8"乱套",
      u8"乱子",
      u8"乱射",
      u8"乱局",
      u8"乱序",
      u8"乱序提交",
      u8"乱开",
      u8"乱弄",
      u8"乱弹",
      u8"乱弹琴",
      u8"乱征",
      u8"乱得",
      u8"乱性",
      u8"乱想",
      u8"乱成",
      u8"乱成一团",
      u8"乱扑扑",
      u8"乱扒",
      u8"乱打",
      u8"乱扔",
      u8"乱扣帽子",
      u8"乱扯",
      u8"乱抄",
      u8"乱拥",
      u8"乱挤",
      u8"乱掉",
      u8"乱推",
      u8"乱提",
      u8"乱搞",
      u8"乱摊",
      u8"乱摊子",
      u8"乱摊派",
      u8"乱摸",
      u8"乱撞",
      u8"乱支",
      u8"乱收",
      u8"乱收费",
      u8"乱改",
      u8"乱放",
      u8"乱数",
      u8"乱杂",
      u8"乱来",
      u8"乱来乱去",
      u8"乱民",
      u8"乱泥",
      u8"乱流",
      u8"乱涂",
      u8"乱涂乱画",
      u8"乱涨",
      u8"乱涨价",
      u8"乱源",
      u8"乱滚",
      u8"乱点鸳鸯",
      u8"乱点鸳鸯谱",
      u8"乱烘烘",
      u8"乱猜",
      u8"乱猜瞎疑",
      u8"乱琼碎玉",
      u8"乱生",
      u8"乱用",
      u8"乱画",
      u8"乱盖",
      u8"乱相",
      u8"乱真",
      u8"乱真谱带",
      u8"乱石",
      u8"乱石山村",
      u8"乱码",
      u8"乱码转换",
      u8"乱砍",
      u8"乱砍乱伐",
      u8"乱砍滥伐",
      u8"乱神",
      u8"乱离",
      u8"乱穿",
      u8"乱窜",
      u8"乱答",
      u8"乱箭",
      u8"乱箭攒心",
      u8"乱糟",
      u8"乱糟糟",
      u8"乱纪",
      u8"乱纷纷",
      u8"乱罚款",
      u8"乱腾",
      u8"乱腾腾",
      u8"乱臣",
      u8"乱臣贼子",
      u8"乱舞",
      u8"乱花",
      u8"乱花钱",
      u8"乱葬",
      u8"乱葬岗",
      u8"乱葬岗子",
      u8"乱蓬蓬",
      u8"乱行",
      u8"乱视",
      u8"乱记",
      u8"乱讲",
      u8"乱设",
      u8"乱试",
      u8"乱语胡言",
      u8"乱说",
      u8"乱说一通",
      u8"乱说乱动",
      u8"乱说话",
      u8"乱调",
      u8"乱象",
      u8"乱账",
      u8"乱购",
      u8"乱贼",
      u8"乱走",
      u8"乱起来",
      u8"乱跑",
      u8"乱跑乱跳",
      u8"乱蹦",
      u8"乱蹦乱跳",
      u8"乱转",
      u8"乱辱骂",
      u8"乱运",
      u8"乱送",
      u8"乱逛",
      u8"乱邦",
      u8"乱采",
      u8"乱锯",
      u8"乱闯",
      u8"乱闹",
      u8"乱飞",
      u8"乱首垢面",
      u8"乱马",
      u8"乱骂",
      u8"乱骑",
      u8"乱鸦",
      u8"乱麻",
      u8"乱麻麻",
      u8"乳中",
      u8"乳交",
      u8"乳儿",
      u8"乳光",
      u8"乳制品",
      u8"乳剂",
      u8"乳化",
      u8"乳化剂",
      u8"乳化型液压液",
      u8"乳化塔",
      u8"乳化机",
      u8"乳化油",
      u8"乳化油输送泵",
      u8"乳化液",
      u8"乳名",
      u8"乳品",
      u8"乳品业",
      u8"乳品厂",
      u8"乳声乳气",
      u8"乳夜",
      u8"乳头",
      u8"乳头状",
      u8"乳头状囊腺瘤",
      u8"乳头状囊腺癌",
      u8"乳头状增生",
      u8"乳头状涎腺瘤",
      u8"乳头肌",
      u8"乳娘",
      u8"乳山",
      u8"乳山县",
      u8"乳山市",
      u8"乳峰",
      u8"乳房",
      u8"乳房状",
      u8"乳晕",
      u8"乳根",
      u8"乳母",
      u8"乳比重计",
      u8"乳汁",
      u8"乳汁状",
      u8"乳沟",
      u8"乳油",
      u8"乳浊剂",
      u8"乳浊液",
      u8"乳液",
      u8"乳液聚合",
      u8"乳清粉",
      u8"乳源",
      u8"乳源瑶族自治县",
      u8"乳燕",
      u8"乳燕营巢",
      u8"乳牙",
      u8"乳牙列",
      u8"乳牙早失",
      u8"乳牙残余",
      u8"乳牙滞留",
      u8"乳牛",
      u8"乳犊不怕虎",
      u8"乳状",
      u8"乳状液",
      u8"乳状液分层",
      u8"乳状物",
      u8"乳猪",
      u8"乳疾灵",
      u8"乳癌",
      u8"乳白",
      u8"乳白色",
      u8"乳突炎",
      u8"乳类",
      u8"乳粉",
      u8"乳粥",
      u8"乳糖",
      u8"乳糖操纵子",
      u8"乳糖酶",
      u8"乳糜",
      u8"乳糜管",
      u8"乳紫色",
      u8"乳线",
      u8"乳罩",
      u8"乳胶",
      u8"乳胶制品",
      u8"乳胶手套",
      u8"乳胶漆",
      u8"乳胶版",
      u8"乳脂",
      u8"乳脂状",
      u8"乳脂糖",
      u8"乳脂酸",
      u8"乳腐",
      u8"乳腺",
      u8"乳腺炎",
      u8"乳腺病",
      u8"乳腺瘤",
      u8"乳腺癌",
      u8"乳臭",
      u8"乳臭未乾",
      u8"乳臭未干",
      u8"乳臭未除",
      u8"乳草",
      u8"乳虎",
      u8"乳虎啸",
      u8"乳质",
      u8"乳透",
      u8"乳酒",
      u8"乳酪",
      u8"乳酶",
      u8"乳酸",
      u8"乳酸杆菌",
      u8"乳酸盐",
      u8"乳酸菌",
      u8"乳酸钙",
      u8"乳酸饮料",
      u8"乳钵",
      u8"乳间股脚",
      u8"乳饼",
      u8"乳香",
      u8"乳香树",
      u8"乳香脂",
      u8"乳鸽",
      u8"乳黄",
      u8"乳齿",
      u8"乾上",
      u8"乾丝",
      u8"乾个",
      u8"乾个够",
      u8"乾乾",
      u8"乾乾净净",
      u8"乾乾翼翼",
      u8"乾了",
      u8"乾井",
      u8"乾亲",
      u8"乾儿子",
      u8"乾冰",
      u8"乾冷",
      u8"乾净",
      u8"乾净俐落",
      u8"乾凉",
      u8"乾县",
      u8"乾呕",
      u8"乾咳",
      u8"乾哥",
      u8"乾哥哥",
      u8"乾唱",
      u8"乾嘉",
      u8"乾嚎",
      u8"乾地",
      u8"乾坤",
      u8"乾坤袋",
      u8"乾女儿",
      u8"乾妈",
      u8"乾妹",
      u8"乾妹妹",
      u8"乾姊",
      u8"乾姊姊",
      u8"乾娘",
      u8"乾季",
      u8"乾宅",
      u8"乾安",
      u8"乾安县",
      u8"乾巴巴",
      u8"乾弟",
      u8"乾弟弟",
      u8"乾得",
      u8"乾性",
      u8"乾性皮肤",
      u8"乾打雷",
      u8"乾掉",
      u8"乾旱",
      u8"乾旱地区",
      u8"乾材",
      u8"乾杯",
      u8"乾果",
      u8"乾枯",
      u8"乾柴",
      u8"乾柴烈火",
      u8"乾池",
      u8"乾沟",
      u8"乾洗",
      u8"乾洗店",
      u8"乾涸",
      u8"乾渴",
      u8"乾热",
      u8"乾燥",
      u8"乾燥剂",
      u8"乾燥器",
      u8"乾燥机",
      u8"乾燥箱",
      u8"乾爸",
      u8"乾爸爸",
      u8"乾爹",
      u8"乾爽",
      u8"乾片",
      u8"乾田",
      u8"乾电池",
      u8"乾瘦",
      u8"乾瘪",
      u8"乾瘪瘪",
      u8"乾癣",
      u8"乾眼病",
      u8"乾着急",
      u8"乾瞪眼",
      u8"乾礼",
      u8"乾端坤倪",
      u8"乾笑",
      u8"乾等",
      u8"乾粉",
      u8"乾粮",
      u8"乾肉片",
      u8"乾股",
      u8"乾脆",
      u8"乾草",
      u8"乾草叉",
      u8"乾草堆",
      u8"乾草机",
      u8"乾菜",
      u8"乾薪",
      u8"乾裂",
      u8"乾贝",
      u8"乾躁",
      u8"乾造",
      u8"乾酪",
      u8"乾闼婆",
      u8"乾隆",
      u8"乾隆帝",
      u8"乾隆年间",
      u8"乾隆皇帝",
      u8"乾雷",
      u8"乾饭",
      u8"乾馏",
      u8"乾馏法",
      u8"乾鲜",
      u8"了不可见",
      u8"了不得",
      u8"了不相涉",
      u8"了不起",
      u8"了不长进",
      u8"了了",
      u8"了了可见",
      u8"了了吧",
      u8"了事",
      u8"了债",
      u8"了却",
      u8"了吗",
      u8"了吧",
      u8"了呀",
      u8"了哥王",
      u8"了啦",
      u8"了嘛",
      u8"了如",
      u8"了如指掌",
      u8"了局",
      u8"了帐",
      u8"了当",
      u8"了得",
      u8"了悟",
      u8"了愿",
      u8"了断",
      u8"了无",
      u8"了无惧色",
      u8"了无生趣",
      u8"了无痕迹",
      u8"了暧昧",
      u8"了望",
      u8"了望台",
      u8"了望塔",
      u8"了望所",
      u8"了案",
      u8"了此残生",
      u8"了清",
      u8"了点",
      u8"了然",
      u8"了然于心",
      u8"了然于胸",
      u8"了然无闻",
      u8"了结",
      u8"了若指掌",
      u8"了草",
      u8"了解",
      u8"了账",
      u8"了身脱命",
      u8"了身达命",
      u8"予人",
      u8"予人口实",
      u8"予付",
      u8"予以",
      u8"予以安排",
      u8"予以强调",
      u8"予以注册",
      u8"予以考虑",
      u8"予以重创",
      u8"予及",
      u8"予取予夺",
      u8"予取予携",
      u8"予取予求",
      u8"予夺生杀",
      u8"予智予雄",
      u8"予期",
      u8"予齿去角",
      u8"争上游",
      u8"争了",
      u8"争产",
      u8"争价",
      u8"争优",
      u8"争作",
      u8"争做",
      u8"争先",
      u8"争先发言",
      u8"争先后",
      u8"争先恐后",
      u8"争光",
      u8"争光奖",
      u8"争光荣",
      u8"争冠",
      u8"争出",
      u8"争分夺妙",
      u8"争分夺秒",
      u8"争创",
      u8"争利",
      u8"争利益",
      u8"争前恐后",
      u8"争办",
      u8"争功",
      u8"争功劳",
      u8"争功诿过",
      u8"争取",
      u8"争取公众理解",
      u8"争取到",
      u8"争取和平",
      u8"争取时间",
      u8"争口气",
      u8"争吃",
      u8"争名",
      u8"争名于朝争利于市",
      u8"争名利",
      u8"争名夺利",
      u8"争名竞利",
      u8"争名谋位",
      u8"争吵",
      u8"争吵不休",
      u8"争嘴",
      u8"争多论少",
      u8"争天抗俗",
      u8"争夺",
      u8"争夺战",
      u8"争奇斗妍",
      u8"争奇斗艳",
      u8"争妍斗丽",
      u8"争妍斗胜",
      u8"争妍斗艳",
      u8"争宠",
      u8"争强",
      u8"争强好胜",
      u8"争强斗狠",
      u8"争强显胜",
      u8"争当",
      u8"争得",
      u8"争战",
      u8"争执",
      u8"争执不下",
      u8"争执性",
      u8"争抢",
      u8"争持",
      u8"争持不下",
      u8"争搏",
      u8"争收",
      u8"争斗",
      u8"争斗不休",
      u8"争斤论两",
      u8"争权",
      u8"争权力",
      u8"争权夺利",
      u8"争权攘利",
      u8"争气",
      u8"争求",
      u8"争点",
      u8"争猫丢牛",
      u8"争用时间间隔",
      u8"争相",
      u8"争相抢购",
      u8"争相罗致",
      u8"争着",
      u8"争短论长",
      u8"争端",
      u8"争胜",
      u8"争胜好强",
      u8"争胜行为",
      u8"争脸",
      u8"争艳",
      u8"争芳斗妍",
      u8"争芳斗艳",
      u8"争荣夸耀",
      u8"争衡",
      u8"争议",
      u8"争议地区",
      u8"争议性",
      u8"争议榜",
      u8"争论",
      u8"争论不休",
      u8"争论点",
      u8"争论者",
      u8"争讼",
      u8"争讼不已",
      u8"争购",
      u8"争起",
      u8"争辨",
      u8"争辩",
      u8"争过",
      u8"争逐",
      u8"争锋",
      u8"争锋吃醋",
      u8"争长",
      u8"争长竞短",
      u8"争长论短",
      u8"争闹",
      u8"争雄",
      u8"争雄记",
      u8"争霸",
      u8"争霸战",
      u8"争霸赛",
      u8"争风吃醋",
      u8"争鲜斗艳",
      u8"争鸡失羊",
      u8"争鸣",
      u8"事不为不成",
      u8"事不关己",
      u8"事不关己高高挂起",
      u8"事不宜迟",
      u8"事不师古",
      u8"事不有余",
      u8"事不过三",
      u8"事与原违",
      u8"事与心违",
      u8"事与愿违",
      u8"事业",
      u8"事业兴旺",
      u8"事业单位",
      u8"事业型",
      u8"事业家",
      u8"事业年度",
      u8"事业心",
      u8"事业性",
      u8"事业成功",
      u8"事业有成",
      u8"事业费",
      u8"事业部",
      u8"事业部制",
      u8"事主",
      u8"事久见人心",
      u8"事事",
      u8"事事如意",
      u8"事事物物",
      u8"事事躬亲",
      u8"事亲至孝",
      u8"事以密成",
      u8"事件",
      u8"事件依赖性",
      u8"事件定义语言",
      u8"事件检测器",
      u8"事件相关电位",
      u8"事件真相",
      u8"事件簿",
      u8"事件调查",
      u8"事件间隔",
      u8"事件队列",
      u8"事体",
      u8"事例",
      u8"事倍功半",
      u8"事假",
      u8"事儿",
      u8"事先",
      u8"事关",
      u8"事关全局",
      u8"事关大局",
      u8"事关重大",
      u8"事典",
      u8"事出不意",
      u8"事出无奈",
      u8"事出有因",
      u8"事出肘腋",
      u8"事到临头",
      u8"事到如今",
      u8"事前",
      u8"事前事后",
      u8"事功",
      u8"事务",
      u8"事务主义",
      u8"事务员",
      u8"事务处",
      u8"事务处理",
      u8"事务处理系统",
      u8"事务官",
      u8"事务局",
      u8"事务性",
      u8"事务所",
      u8"事务故障",
      u8"事务管理",
      u8"事务繁多",
      u8"事务署",
      u8"事务股",
      u8"事务部",
      u8"事务部长",
      u8"事务长",
      u8"事势",
      u8"事半功倍",
      u8"事半功百",
      u8"事危累卵",
      u8"事发",
      u8"事变",
      u8"事后",
      u8"事后诸葛",
      u8"事后诸葛亮",
      u8"事在人为",
      u8"事在必行",
      u8"事在萧墙",
      u8"事宜",
      u8"事实",
      u8"事实上",
      u8"事实上承认",
      u8"事实与理由",
      u8"事实如此",
      u8"事实性",
      u8"事实标准",
      u8"事实根据",
      u8"事实清楚",
      u8"事实真相",
      u8"事实真象",
      u8"事实确凿",
      u8"事实简述",
      u8"事实胜于",
      u8"事实胜于雄辩",
      u8"事实证明",
      u8"事实陈述",
      u8"事宽则圆",
      u8"事宽即圆",
      u8"事已如此",
      u8"事已至此",
      u8"事往日迁",
      u8"事必躬亲",
      u8"事态",
      u8"事态严重",
      u8"事急无君子",
      u8"事情",
      u8"事成之后",
      u8"事捷功倍",
      u8"事故",
      u8"事故保险",
      u8"事故倾向",
      u8"事故学",
      u8"事故现场",
      u8"事故责任",
      u8"事故隐患",
      u8"事无三不成",
      u8"事无二成",
      u8"事无大小",
      u8"事无巨细",
      u8"事无常师",
      u8"事有必至",
      u8"事有必至理有固然",
      u8"事机",
      u8"事权",
      u8"事核言直",
      u8"事檎",
      u8"事母至孝",
      u8"事毕",
      u8"事火咒龙",
      u8"事物",
      u8"事物本质",
      u8"事理",
      u8"事生肘腋",
      u8"事由",
      u8"事略",
      u8"事相",
      u8"事竟成",
      u8"事端",
      u8"事缓则圆",
      u8"事败",
      u8"事败垂成",
      u8"事过境迁",
      u8"事过情迁",
      u8"事过景迁",
      u8"事迹",
      u8"事迹报告",
      u8"事迹材料",
      u8"事隔",
      u8"事隔多年",
      u8"事非得已",
      u8"事项",
      u8"事预则立",
      u8"事齐事楚",
      u8"二一添作五",
      u8"二丁",
      u8"二丁挂",
      u8"二七",
      u8"二七区",
      u8"二七大罢工",
      u8"二七路",
      u8"二万",
      u8"二万个",
      u8"二万五千",
      u8"二万五千里长征",
      u8"二万人",
      u8"二万元",
      u8"二万块",
      u8"二三",
      u8"二三其德",
      u8"二三其意",
      u8"二三君子",
      u8"二上",
      u8"二下",
      u8"二不休",
      u8"二专",
      u8"二专制",
      u8"二世",
      u8"二个",
      u8"二个人",
      u8"二个月",
      u8"二中",
      u8"二中全会",
      u8"二义性",
      u8"二乎",
      u8"二乘幂",
      u8"二乙二醇",
      u8"二乙基焦碳酸乙酯",
      u8"二乙烯苯",
      u8"二乙胺基",
      u8"二二",
      u8"二二八",
      u8"二二八事变",
      u8"二二得四",
      u8"二二拍子",
      u8"二五一十",
      u8"二五仔",
      u8"二五眼",
      u8"二产",
      u8"二人",
      u8"二人世界",
      u8"二人份",
      u8"二人台",
      u8"二人同心",
      u8"二人同心其利断金",
      u8"二人组",
      u8"二人转",
      u8"二亿",
      u8"二亿人",
      u8"二亿元",
      u8"二付",
      u8"二代",
      u8"二代证",
      u8"二件套",
      u8"二价",
      u8"二任",
      u8"二份",
      u8"二伍",
      u8"二伏",
      u8"二传",
      u8"二传手",
      u8"二伯",
      u8"二伯母",
      u8"二伯父",
      u8"二位",
      u8"二位数",
      u8"二体问题",
      u8"二佛涅槃",
      u8"二信",
      u8"二倍",
      u8"二倍体",
      u8"二倍性",
      u8"二值时间序列",
      u8"二儿子",
      u8"二元",
      u8"二元关系",
      u8"二元化",
      u8"二元方程式",
      u8"二元论",
      u8"二元酸",
      u8"二党制",
      u8"二八",
      u8"二八佳人",
      u8"二八十六",
      u8"二八年华",
      u8"二关",
      u8"二具",
      u8"二冲程",
      u8"二冲程发动机",
      u8"二分",
      u8"二分基因组",
      u8"二分明月",
      u8"二分法",
      u8"二分线",
      u8"二分钟",
      u8"二分院",
      u8"二分音符",
      u8"二划",
      u8"二列相关",
      u8"二则",
      u8"二副",
      u8"二动",
      u8"二化螟",
      u8"二区",
      u8"二十",
      u8"二十一",
      u8"二十一世纪",
      u8"二十一中",
      u8"二十一时",
      u8"二十一条",
      u8"二十七",
      u8"二十七中",
      u8"二十万",
      u8"二十三",
      u8"二十三中",
      u8"二十三时",
      u8"二十世纪",
      u8"二十世纪九十年代",
      u8"二十中",
      u8"二十九",
      u8"二十九中",
      u8"二十二",
      u8"二十二中",
      u8"二十二时",
      u8"二十五",
      u8"二十五中",
      u8"二十五史",
      u8"二十八",
      u8"二十八中",
      u8"二十八宿",
      u8"二十六",
      u8"二十六中",
      u8"二十四",
      u8"二十四中",
      u8"二十四史",
      u8"二十四孝",
      u8"二十四小",
      u8"二十四小时",
      u8"二十四时",
      u8"二十四节气",
      u8"二十国委员会",
      u8"二十天",
      u8"二十年",
      u8"二十年代",
      u8"二十时",
      u8"二十面体物相",
      u8"二千",
      u8"二千万",
      u8"二千个",
      u8"二千人",
      u8"二千元",
      u8"二千块",
      u8"二千石",
      u8"二半",
      u8"二卵双生",
      u8"二卵生",
      u8"二叉",
      u8"二叉判定图",
      u8"二叉排序树",
      u8"二叉树",
      u8"二叔",
      u8"二叔叔",
      u8"二变量",
      u8"二叠",
      u8"二叠纪",
      u8"二口网络",
      u8"二句",
      u8"二句话",
      u8"二台",
      u8"二台子乡",
      u8"二号",
      u8"二号分机",
      u8"二号机",
      u8"二号桥",
      u8"二号楼",
      u8"二号线",
      u8"二合一",
      u8"二名",
      u8"二向色性",
      u8"二员",
      u8"二周目",
      u8"二哥",
      u8"二回",
      u8"二回熟",
      u8"二圆",
      u8"二地主",
      u8"二块",
      u8"二块钱",
      u8"二坚为灾",
      u8"二垒",
      u8"二垒手",
      u8"二堂哥",
      u8"二堂妹",
      u8"二堂姊",
      u8"二堂姊夫",
      u8"二堂嫂",
      u8"二堂弟",
      u8"二声",
      u8"二夜",
      u8"二大",
      u8"二天",
      u8"二天晒网",
      u8"二头肌",
      u8"二奖",
      u8"二女",
      u8"二女一男",
      u8"二女二男",
      u8"二女儿",
      u8"二奶",
      u8"二妈",
      u8"二妹",
      u8"二妹夫",
      u8"二姊",
      u8"二姊夫",
      u8"二姐",
      u8"二姑",
      u8"二姑丈",
      u8"二姑妈",
      u8"二姑母",
      u8"二姓为好",
      u8"二姓之好",
      u8"二姨",
      u8"二姨妈",
      u8"二娘",
      u8"二婚",
      u8"二婶",
      u8"二婶婆",
      u8"二嫂",
      u8"二子",
      u8"二子一女",
      u8"二子二女",
      u8"二字词",
      u8"二季",
      u8"二季度",
      u8"二审",
      u8"二少爷",
      u8"二尖瓣",
      u8"二尖瓣关闭不全",
      u8"二尖瓣狭窄",
      u8"二局",
      u8"二局上半",
      u8"二局下半",
      u8"二层",
      u8"二层台高度",
      u8"二居室",
      u8"二届",
      u8"二届国代",
      u8"二届国代选举",
      u8"二巯基丙",
      u8"二巯基丙醇",
      u8"二幅",
      u8"二年",
      u8"二年制",
      u8"二年生",
      u8"二年生作物",
      u8"二年生蔬菜作物",
      u8"二年级",
      u8"二年计划",
      u8"二度",
      u8"二度春",
      u8"二度梅",
      u8"二异丙基氟磷酸",
      u8"二式",
      u8"二弟",
      u8"二弦",
      u8"二当家",
      u8"二形人",
      u8"二律背反",
      u8"二心",
      u8"二心三意",
      u8"二心两意",
      u8"二态二氢",
      u8"二恶英",
      u8"二惠竞爽",
      u8"二意",
      u8"二意性",
      u8"二愣子",
      u8"二战",
      u8"二战名将",
      u8"二战时期",
      u8"二房",
      u8"二房东",
      u8"二手",
      u8"二手书",
      u8"二手买卖",
      u8"二手交易",
      u8"二手仪器",
      u8"二手市场",
      u8"二手店",
      u8"二手房",
      u8"二手房屋",
      u8"二手手机",
      u8"二手机床",
      u8"二手楼",
      u8"二手烟",
      u8"二手物品",
      u8"二手电脑",
      u8"二手票",
      u8"二手空调",
      u8"二手网",
      u8"二手设备",
      u8"二手货",
      u8"二手车",
      u8"二手轿车",
      u8"二手钢琴",
      u8"二批",
      u8"二把",
      u8"二把刀",
      u8"二把手",
      u8"二拇指",
      u8"二择",
      u8"二指",
      u8"二斤",
      u8"二无",
      u8"二日",
      u8"二日份",
      u8"二日游",
      u8"二星级",
      u8"二是",
      u8"二是二",
      u8"二晚",
      u8"二月",
      u8"二月份",
      u8"二月河",
      u8"二期",
      u8"二期工程",
      u8"二期愈合前庭成形术",
      u8"二期稻作",
      u8"二条",
      u8"二来",
      u8"二杯",
      u8"二板",
      u8"二板股票",
      u8"二极",
      u8"二极体",
      u8"二极真空",
      u8"二极管",
      u8"二极管晶体管逻辑",
      u8"二极管电极",
      u8"二林",
      u8"二枚",
      u8"二栋",
      u8"二样",
      u8"二根分叉部",
      u8"二桃杀三士",
      u8"二档",
      u8"二桶",
      u8"二棱大麦",
      u8"二楼",
      u8"二楼住户",
      u8"二次",
      u8"二次互反律",
      u8"二次元",
      u8"二次场电位差",
      u8"二次型性能指标",
      u8"二次域",
      u8"二次大战",
      u8"二次开发",
      u8"二次收费",
      u8"二次方",
      u8"二次方程",
      u8"二次曲线",
      u8"二次曲面",
      u8"二次污染",
      u8"二次污染物",
      u8"二次生油",
      u8"二次电子",
      u8"二次破碎",
      u8"二次编码",
      u8"二次能源",
      u8"二次超曲面",
      u8"二次革命",
      u8"二步",
      u8"二段",
      u8"二段制",
      u8"二段式",
      u8"二段票",
      u8"二段跳",
      u8"二氢丙酮磷酸",
      u8"二氢乳清酸",
      u8"二氢乳清酸酶",
      u8"二氢叶酸",
      u8"二氢叶酸还原酶",
      u8"二氢吡啶",
      u8"二氢尿嘧啶",
      u8"二氢尿嘧啶环",
      u8"二氢尿嘧啶臂",
      u8"二氢尿苷",
      u8"二氢生物蝶呤",
      u8"二氢硫辛酸",
      u8"二氢苊",
      u8"二氢蝶啶",
      u8"二氢蝶啶还原酶",
      u8"二氧",
      u8"二氧化",
      u8"二氧化三碳",
      u8"二氧化氮",
      u8"二氧化氯",
      u8"二氧化物",
      u8"二氧化矽",
      u8"二氧化硅",
      u8"二氧化硅乳胶抛光",
      u8"二氧化硫",
      u8"二氧化碳",
      u8"二氧化碳灭火器",
      u8"二氧化碳驱",
      u8"二氧化铅",
      u8"二氧化锆",
      u8"二氧化锰",
      u8"二氧杂环己烷",
      u8"二氨基庚二酸",
      u8"二氨基联苯胺",
      u8"二氮芴",
      u8"二氯乙烷",
      u8"二氯二甲硅烷",
      u8"二氯化锰",
      u8"二氯甲烷",
      u8"二氯苯",
      u8"二氯荧光黄",
      u8"二水",
      u8"二汽",
      u8"二泉映月",
      u8"二流",
      u8"二流人才",
      u8"二流子",
      u8"二流角色",
      u8"二满三平",
      u8"二滩",
      u8"二滴",
      u8"二炮",
      u8"二点",
      u8"二点透视",
      u8"二点钟",
      u8"二烷基甘氨酸",
      u8"二爷",
      u8"二爹",
      u8"二版",
      u8"二环",
      u8"二环己基碳二亚胺",
      u8"二环路",
      u8"二班",
      u8"二班制",
      u8"二用",
      u8"二甲",
      u8"二甲双胍",
      u8"二甲基",
      u8"二甲基亚砜",
      u8"二甲基吡啶",
      u8"二甲基氨基偶氮苯",
      u8"二甲基甲",
      u8"二甲基甲酰胺",
      u8"二甲氧三苯甲基",
      u8"二甲烯丙基焦磷酸",
      u8"二甲胺",
      u8"二甲胺基",
      u8"二甲苯",
      u8"二甲苯基",
      u8"二甲酚橙",
      u8"二甲酸",
      u8"二甲醚",
      u8"二男",
      u8"二男一女",
      u8"二男二女",
      u8"二百",
      u8"二百万",
      u8"二百个",
      u8"二百二",
      u8"二百五",
      u8"二百人",
      u8"二百元",
      u8"二百块",
      u8"二百海里海洋权",
      u8"二皮脸",
      u8"二硅化物",
      u8"二硝基氟苯",
      u8"二硝基苯",
      u8"二硝基苯酚",
      u8"二硫化物",
      u8"二硫化碳",
      u8"二硫化钼",
      u8"二硫化铁",
      u8"二硫基丙",
      u8"二硫苏糖醇",
      u8"二硫赤藓糖醇",
      u8"二硫键",
      u8"二碗",
      u8"二碘水杨酸锂",
      u8"二碳化钙",
      u8"二磷酸",
      u8"二磷酸甘油酸支路",
      u8"二磷酸肌醇磷脂",
      u8"二种",
      u8"二科",
      u8"二秒",
      u8"二秒钟",
      u8"二竖为虐",
      u8"二童一马",
      u8"二端",
      u8"二端网络",
      u8"二笔",
      u8"二笼",
      u8"二等",
      u8"二等亲",
      u8"二等兵",
      u8"二等功",
      u8"二等品",
      u8"二等奖",
      u8"二等舱",
      u8"二筒",
      u8"二簧",
      u8"二类",
      u8"二粒",
      u8"二级",
      u8"二级企业",
      u8"二级准尉",
      u8"二级同位素效应",
      u8"二级图谱",
      u8"二级域名",
      u8"二级强化",
      u8"二级标准",
      u8"二级相变",
      u8"二级简码",
      u8"二级缓存",
      u8"二级风",
      u8"二级高速缓存",
      u8"二线",
      u8"二维",
      u8"二维两相渗流",
      u8"二维制图系统",
      u8"二维地震",
      u8"二维电泳",
      u8"二维码",
      u8"二绿",
      u8"二缶钟惑",
      u8"二缶锺惑",
      u8"二羟胆钙化醇",
      u8"二羟苯丙氨酸",
      u8"二羟苯基乙胺",
      u8"二羧基纤维素",
      u8"二羧酸",
      u8"二老",
      u8"二老板",
      u8"二者",
      u8"二者不可兼得",
      u8"二者不可得兼",
      u8"二者之间",
      u8"二者必居其一",
      u8"二联",
      u8"二联体",
      u8"二联单",
      u8"二联式",
      u8"二聚体",
      u8"二聚化",
      u8"二聚化辅因子",
      u8"二股",
      u8"二肽",
      u8"二肽酶",
      u8"二胡",
      u8"二胡曲",
      u8"二舅",
      u8"二舅妈",
      u8"二舅母",
      u8"二艘",
      u8"二色性",
      u8"二色视觉",
      u8"二节棍",
      u8"二花脸",
      u8"二苯卡巴腙",
      u8"二苯基唑",
      u8"二苯甲基胺树脂",
      u8"二苯胺磺酸钠",
      u8"二苯胺蓝",
      u8"二虎相斗",
      u8"二虎相斗必有一伤",
      u8"二行程",
      u8"二街",
      u8"二表哥",
      u8"二表妹",
      u8"二表姊",
      u8"二表姊夫",
      u8"二表嫂",
      u8"二表弟",
      u8"二袋",
      u8"二裂舌",
      u8"二话",
      u8"二话不说",
      u8"二话没说",
      u8"二课",
      u8"二象性",
      u8"二路",
      u8"二路纵队",
      u8"二踢脚",
      u8"二轮",
      u8"二轮影院",
      u8"二轮电影",
      u8"二轮马车",
      u8"二轻",
      u8"二轻局",
      u8"二边",
      u8"二过一",
      u8"二进",
      u8"二进位",
      u8"二进位制",
      u8"二进删除信道",
      u8"二进制",
      u8"二进制位",
      u8"二进制数字",
      u8"二进制码",
      u8"二进宫",
      u8"二进数群",
      u8"二连",
      u8"二连浩特",
      u8"二连浩特市",
      u8"二通",
      u8"二遍",
      u8"二道区",
      u8"二道江区",
      u8"二道贩子",
      u8"二郎",
      u8"二郎山",
      u8"二郎庙",
      u8"二郎神",
      u8"二郎腿",
      u8"二部",
      u8"二部制",
      u8"二部合唱",
      u8"二部曲",
      u8"二部曲式",
      u8"二里",
      u8"二里庄",
      u8"二重",
      u8"二重人格",
      u8"二重唱",
      u8"二重奏",
      u8"二重性",
      u8"二重接",
      u8"二重根",
      u8"二重点",
      u8"二重积分",
      u8"二重级数",
      u8"二钱",
      u8"二锅头",
      u8"二门",
      u8"二间",
      u8"二阶",
      u8"二阶充分条件",
      u8"二阶加托微分",
      u8"二阶参数连续",
      u8"二阶堂",
      u8"二阶堂红丸",
      u8"二阶约化密度矩阵",
      u8"二陈汤",
      u8"二难",
      u8"二集",
      u8"二青洞",
      u8"二面角",
      u8"二页",
      u8"二顶",
      u8"二项分布",
      u8"二项式",
      u8"二首",
      u8"二首歌",
      u8"二马路",
      u8"二黄",
      u8"二龙",
      u8"二龙山",
      u8"二龙戏珠",
      u8"于一身",
      u8"于七",
      u8"于万亭",
      u8"于事无补",
      u8"于于",
      u8"于人豪",
      u8"于今",
      u8"于今为烈",
      u8"于今犹烈",
      u8"于伟",
      u8"于余曲折",
      u8"于光豪",
      u8"于光远",
      u8"于八",
      u8"于右任",
      u8"于吉",
      u8"于呼哀哉",
      u8"于夫罗",
      u8"于好",
      u8"于嫂",
      u8"于安思危",
      u8"于家为国",
      u8"于家务",
      u8"于小伟",
      u8"于小慧",
      u8"于左",
      u8"于己于人",
      u8"于归",
      u8"于彦平",
      u8"于心",
      u8"于心不忍",
      u8"于心不甘",
      u8"于心何忍",
      u8"于心无愧",
      u8"于思",
      u8"于慧",
      u8"于我",
      u8"于斯",
      u8"于是",
      u8"于是之",
      u8"于是乎",
      u8"于是就",
      u8"于月仙",
      u8"于林庄村",
      u8"于根伟",
      u8"于此",
      u8"于永波",
      u8"于江",
      u8"于法无据",
      u8"于洋",
      u8"于洪区",
      u8"于涛",
      u8"于焉",
      u8"于玲范",
      u8"于田",
      u8"于田县",
      u8"于禁",
      u8"于管家",
      u8"于纯绵",
      u8"于芷蔚",
      u8"于荣光",
      u8"于莉",
      u8"于蓝",
      u8"于诠",
      u8"于谦",
      u8"于连",
      u8"于都",
      u8"于都县",
      u8"于阗",
      u8"于飞",
      u8"于飞之乐",
      u8"亏了",
      u8"亏产",
      u8"亏到",
      u8"亏困",
      u8"亏在",
      u8"亏失",
      u8"亏少",
      u8"亏待",
      u8"亏得",
      u8"亏心",
      u8"亏心事",
      u8"亏心短行",
      u8"亏折",
      u8"亏损",
      u8"亏损企业",
      u8"亏损率",
      u8"亏损累累",
      u8"亏损面",
      u8"亏损额",
      u8"亏掉",
      u8"亏本",
      u8"亏本生意",
      u8"亏格",
      u8"亏欠",
      u8"亏死",
      u8"亏盈",
      u8"亏短",
      u8"亏秤",
      u8"亏空",
      u8"亏空公款",
      u8"亏累",
      u8"亏缺",
      u8"亏耗",
      u8"亏蚀",
      u8"亏负",
      u8"亏量",
      u8"云中",
      u8"云中仙鹤",
      u8"云中子",
      u8"云中白鹤",
      u8"云中鹤",
      u8"云云",
      u8"云交雨合",
      u8"云从龙",
      u8"云佛山",
      u8"云兴月性",
      u8"云兴霞蔚",
      u8"云冈",
      u8"云冈石佛",
      u8"云冈石窟",
      u8"云净天空",
      u8"云南",
      u8"云南人",
      u8"云南大学",
      u8"云南府",
      u8"云南新闻",
      u8"云南旅游",
      u8"云南日报",
      u8"云南昆明",
      u8"云南白药",
      u8"云南省",
      u8"云南菜",
      u8"云卷云舒",
      u8"云县",
      u8"云台山",
      u8"云合响应",
      u8"云合景从",
      u8"云合雾集",
      u8"云吞",
      u8"云吞面",
      u8"云和",
      u8"云和县",
      u8"云和山",
      u8"云和月",
      u8"云团",
      u8"云图",
      u8"云块",
      u8"云城区",
      u8"云堦月地",
      u8"云天",
      u8"云天化",
      u8"云天空",
      u8"云天雾地",
      u8"云天高谊",
      u8"云头",
      u8"云奔雨骤",
      u8"云安",
      u8"云安县",
      u8"云官威仪",
      u8"云实根",
      u8"云室",
      u8"云容月貌",
      u8"云尔",
      u8"云尤雨殢",
      u8"云层",
      u8"云居寺",
      u8"云屯席卷",
      u8"云屯星聚",
      u8"云屯森立",
      u8"云屯蚁聚",
      u8"云屯雨集",
      u8"云屯雾散",
      u8"云屯雾集",
      u8"云屯飙散",
      u8"云屯鸟散",
      u8"云山",
      u8"云山文稿",
      u8"云山雾罩",
      u8"云岛主",
      u8"云岩区",
      u8"云岭",
      u8"云峰山",
      u8"云崖",
      u8"云布雨施",
      u8"云布雨润",
      u8"云开日出",
      u8"云开见天",
      u8"云开见日",
      u8"云开雾散",
      u8"云开雾释",
      u8"云强盗",
      u8"云彩",
      u8"云影",
      u8"云心水性",
      u8"云心鹤眼",
      u8"云悲海思",
      u8"云情雨意",
      u8"云愁雨怨",
      u8"云愁雾惨",
      u8"云扰幅裂",
      u8"云收雨散",
      u8"云散",
      u8"云散风流",
      u8"云斯顿",
      u8"云昏",
      u8"云景",
      u8"云朝雨暮",
      u8"云期雨信",
      u8"云期雨约",
      u8"云朵",
      u8"云杉",
      u8"云杉坪",
      u8"云板",
      u8"云林",
      u8"云林人",
      u8"云林县",
      u8"云林工专",
      u8"云树之思",
      u8"云树遥隔",
      u8"云栖",
      u8"云梢",
      u8"云梦",
      u8"云梦县",
      u8"云梦山",
      u8"云梦闲情",
      u8"云梯",
      u8"云次鳞集",
      u8"云母",
      u8"云母片",
      u8"云母石",
      u8"云母粉",
      u8"云气",
      u8"云水洞",
      u8"云汉",
      u8"云河",
      u8"云泥之别",
      u8"云泥之差",
      u8"云泥异路",
      u8"云泥殊路",
      u8"云浮",
      u8"云浮县",
      u8"云浮市",
      u8"云海",
      u8"云消雨散",
      u8"云消雾散",
      u8"云涌",
      u8"云涌风飞",
      u8"云涌飙发",
      u8"云涛",
      u8"云淡",
      u8"云淡风轻",
      u8"云游",
      u8"云游四方",
      u8"云溪区",
      u8"云烟",
      u8"云烟氤氲",
      u8"云烟过眼",
      u8"云片糕",
      u8"云状",
      u8"云玲",
      u8"云石",
      u8"云程万里",
      u8"云程发轫",
      u8"云窗月帐",
      u8"云窗月户",
      u8"云窗雾槛",
      u8"云窗雾阁",
      u8"云窗霞户",
      u8"云端",
      u8"云篦",
      u8"云系",
      u8"云素梅",
      u8"云罗天网",
      u8"云翳",
      u8"云翻雨覆",
      u8"云脚",
      u8"云舒霞卷",
      u8"云航",
      u8"云英",
      u8"云蒙山",
      u8"云蒸雾集",
      u8"云蒸霞蔚",
      u8"云蒸龙变",
      u8"云行雨施",
      u8"云行雨洽",
      u8"云表",
      u8"云西新村",
      u8"云谲波诡",
      u8"云豆",
      u8"云豹",
      u8"云贵",
      u8"云贵川",
      u8"云贵高原",
      u8"云起雪飞",
      u8"云起龙襄",
      u8"云起龙骧",
      u8"云趋鹜赴",
      u8"云过天空",
      u8"云迷雾罩",
      u8"云迷雾锁",
      u8"云遮雾障",
      u8"云里雾里",
      u8"云量",
      u8"云锣",
      u8"云锦",
      u8"云锦天章",
      u8"云门",
      u8"云门舞集",
      u8"云间城",
      u8"云阳",
      u8"云阳县",
      u8"云阶月地",
      u8"云际",
      u8"云雀",
      u8"云集",
      u8"云集响应",
      u8"云集景从",
      u8"云集景附",
      u8"云集雾散",
      u8"云雨",
      u8"云雨巫山",
      u8"云雾",
      u8"云雾茶",
      u8"云雾迷蒙",
      u8"云霄",
      u8"云霄县",
      u8"云霄阁",
      u8"云霄飞车",
      u8"云霓",
      u8"云霓之望",
      u8"云霞",
      u8"云霭",
      u8"云顶",
      u8"云顶岩",
      u8"云须",
      u8"云飞扬",
      u8"云飞泥沉",
      u8"云飞烟灭",
      u8"云飞雨散",
      u8"云髻",
      u8"云鬓",
      u8"云鬟",
      u8"云鬟雾鬓",
      u8"云鹤",
      u8"云麾勋章",
      u8"云龙",
      u8"云龙井蛙",
      u8"云龙区",
      u8"云龙县",
      u8"云龙山",
      u8"云龙风虎",
      u8"互不",
      u8"互不侵犯",
      u8"互不侵犯条约",
      u8"互不干涉",
      u8"互不干涉内政",
      u8"互不相让",
      u8"互与",
      u8"互为",
      u8"互为因果",
      u8"互为奥援",
      u8"互为条件",
      u8"互为补充",
      u8"互为表里",
      u8"互争",
      u8"互争雄长",
      u8"互于",
      u8"互交",
      u8"互享",
      u8"互以",
      u8"互传",
      u8"互保",
      u8"互信",
      u8"互信互谅",
      u8"互信互重",
      u8"互信息",
      u8"互信无猜",
      u8"互借",
      u8"互养共栖",
      u8"互利",
      u8"互利互惠",
      u8"互利共栖",
      u8"互利性",
      u8"互制",
      u8"互剥痛疮",
      u8"互加",
      u8"互动",
      u8"互动关系",
      u8"互动式",
      u8"互动性",
      u8"互动论",
      u8"互助",
      u8"互助会",
      u8"互助友爱",
      u8"互助合作",
      u8"互助土族自治县",
      u8"互助组",
      u8"互助金",
      u8"互勉",
      u8"互勉互励",
      u8"互反性",
      u8"互发",
      u8"互变异构",
      u8"互变异构化",
      u8"互变霉素",
      u8"互向",
      u8"互唱",
      u8"互喊",
      u8"互填",
      u8"互学",
      u8"互定",
      u8"互市",
      u8"互帮",
      u8"互帮互利",
      u8"互帮互助",
      u8"互帮互学",
      u8"互异",
      u8"互引相",
      u8"互得",
      u8"互怜",
      u8"互惠",
      u8"互惠互利",
      u8"互惠协定",
      u8"互惠待遇",
      u8"互惠条约",
      u8"互感",
      u8"互感器",
      u8"互感应",
      u8"互感系数",
      u8"互成",
      u8"互打",
      u8"互指",
      u8"互换",
      u8"互换位置法",
      u8"互换原理",
      u8"互换性",
      u8"互换行",
      u8"互推",
      u8"互搏",
      u8"互救",
      u8"互教互学",
      u8"互敬",
      u8"互敬互爱",
      u8"互斥",
      u8"互无",
      u8"互易",
      u8"互易定理",
      u8"互易网络",
      u8"互替",
      u8"互有",
      u8"互有权",
      u8"互有胜负",
      u8"互有输赢",
      u8"互殴",
      u8"互派",
      u8"互派大使",
      u8"互济",
      u8"互济会",
      u8"互添",
      u8"互溶",
      u8"互溶剂",
      u8"互溶性",
      u8"互激点过程",
      u8"互点",
      u8"互爱",
      u8"互生",
      u8"互生叶",
      u8"互用",
      u8"互相",
      u8"互相促进",
      u8"互相关心",
      u8"互相关照",
      u8"互相冲突",
      u8"互相切磋",
      u8"互相制约",
      u8"互相合作",
      u8"互相学习",
      u8"互相帮助",
      u8"互相承认",
      u8"互相推诿",
      u8"互相支持",
      u8"互相攻击",
      u8"互相标榜",
      u8"互相榜样",
      u8"互相残杀",
      u8"互相照顾",
      u8"互相爱护",
      u8"互相理解",
      u8"互相监督",
      u8"互相盘绕",
      u8"互相矛盾",
      u8"互相联系",
      u8"互相转化",
      u8"互相配合",
      u8"互相间",
      u8"互祝",
      u8"互竞长短",
      u8"互答",
      u8"互罚",
      u8"互联",
      u8"互联互通",
      u8"互联影库",
      u8"互联星空",
      u8"互联网",
      u8"互联网电脑",
      u8"互联网络",
      u8"互聘",
      u8"互致问候",
      u8"互补",
      u8"互补几何规划",
      u8"互补原理",
      u8"互补式",
      u8"互补性",
      u8"互补晶体管逻辑",
      u8"互补色",
      u8"互补色立体显示",
      u8"互见",
      u8"互让",
      u8"互设",
      u8"互访",
      u8"互证",
      u8"互评",
      u8"互诉",
      u8"互译",
      u8"互调",
      u8"互调伏安法",
      u8"互谅",
      u8"互谅互让",
      u8"互谋",
      u8"互谋其利",
      u8"互质",
      u8"互质数",
      u8"互赠",
      u8"互转",
      u8"互连",
      u8"互连网",
      u8"互选",
      u8"互递",
      u8"互通",
      u8"互通信息",
      u8"互通声气",
      u8"互通式",
      u8"互通性",
      u8"互通情况",
      u8"互通情报",
      u8"互通有无",
      u8"互道",
      u8"互道珍重",
      u8"互锁",
      u8"互问",
      u8"互闹",
      u8"五一",
      u8"五一劳动",
      u8"五一劳动奖章",
      u8"五一劳动奖章获得者",
      u8"五一劳动节",
      u8"五一国际劳动节",
      u8"五一广场",
      u8"五一文",
      u8"五一节",
      u8"五一路",
      u8"五丁",
      u8"五七干校",
      u8"五不准",
      u8"五专",
      u8"五专生",
      u8"五世其昌",
      u8"五世同堂",
      u8"五丙",
      u8"五两",
      u8"五个一工程",
      u8"五个好",
      u8"五中",
      u8"五中全会",
      u8"五串",
      u8"五乙",
      u8"五五分帐",
      u8"五五波",
      u8"五五草案",
      u8"五亲六眷",
      u8"五人制",
      u8"五代",
      u8"五代十国",
      u8"五代史",
      u8"五代同堂",
      u8"五件套",
      u8"五伦",
      u8"五位一体",
      u8"五位数",
      u8"五体投地",
      u8"五体投诚",
      u8"五侯七贵",
      u8"五侯蜡烛",
      u8"五保",
      u8"五保户",
      u8"五倍子",
      u8"五倍子虫",
      u8"五假",
      u8"五光十色",
      u8"五党",
      u8"五关",
      u8"五典三坟",
      u8"五内",
      u8"五内俱崩",
      u8"五内俱焚",
      u8"五内如焚",
      u8"五冬六夏",
      u8"五出戏",
      u8"五刀",
      u8"五分制",
      u8"五分裤",
      u8"五刑",
      u8"五力",
      u8"五加",
      u8"五加皮",
      u8"五劳七伤",
      u8"五匙",
      u8"五十年一遇",
      u8"五十步笑百步",
      u8"五十铃",
      u8"五卅惨案",
      u8"五卅运动",
      u8"五华",
      u8"五华区",
      u8"五华县",
      u8"五华山",
      u8"五原",
      u8"五原县",
      u8"五反",
      u8"五反运动",
      u8"五发",
      u8"五口之家",
      u8"五古",
      u8"五台",
      u8"五台县",
      u8"五台山",
      u8"五叶",
      u8"五叶饰",
      u8"五号线",
      u8"五合一",
      u8"五合六聚",
      u8"五合板",
      u8"五味",
      u8"五味俱全",
      u8"五味子",
      u8"五味斋",
      u8"五味杂陈",
      u8"五味瓶",
      u8"五商",
      u8"五四",
      u8"五四式",
      u8"五四时代",
      u8"五四路",
      u8"五四运动",
      u8"五四青年节",
      u8"五圆",
      u8"五坪",
      u8"五堰",
      u8"五堵",
      u8"五塘镇",
      u8"五壮士",
      u8"五声",
      u8"五声道",
      u8"五处",
      u8"五大",
      u8"五大三粗",
      u8"五大州",
      u8"五大洲",
      u8"五大湖",
      u8"五大类",
      u8"五大连池",
      u8"五大连池市",
      u8"五天",
      u8"五好",
      u8"五好检察院",
      u8"五子",
      u8"五子棋",
      u8"五子登科",
      u8"五孔桥",
      u8"五字",
      u8"五季",
      u8"五官",
      u8"五官科",
      u8"五官端正",
      u8"五客",
      u8"五家渠",
      u8"五家渠市",
      u8"五寨",
      u8"五寨县",
      u8"五封",
      u8"五小",
      u8"五小时",
      u8"五尺之僮",
      u8"五尺之童",
      u8"五尺竖子",
      u8"五尺童子",
      u8"五岭",
      u8"五岳",
      u8"五峰",
      u8"五峰土家族自治县",
      u8"五巷",
      u8"五师",
      u8"五帝",
      u8"五席",
      u8"五常",
      u8"五常县",
      u8"五常市",
      u8"五年制",
      u8"五年期",
      u8"五年级",
      u8"五年计划",
      u8"五床",
      u8"五度",
      u8"五度五关",
      u8"五建",
      u8"五式",
      u8"五弟",
      u8"五弦琴",
      u8"五彩",
      u8"五彩夺目",
      u8"五彩斑斓",
      u8"五彩池",
      u8"五彩洒金",
      u8"五彩石",
      u8"五彩祥云",
      u8"五彩纷呈",
      u8"五彩纸屑",
      u8"五彩缤纷",
      u8"五律",
      u8"五心六意",
      u8"五急六受且难受",
      u8"五感",
      u8"五成新",
      u8"五成谱",
      u8"五戒",
      u8"五截",
      u8"五户",
      u8"五打",
      u8"五抢六夺",
      u8"五报",
      u8"五招",
      u8"五拳",
      u8"五指",
      u8"五指山",
      u8"五指山区",
      u8"五指山市",
      u8"五指毛桃",
      u8"五文",
      u8"五文钱",
      u8"五斗",
      u8"五斗折腰",
      u8"五斗柜",
      u8"五斗橱",
      u8"五方",
      u8"五方杂厝",
      u8"五方杂处",
      u8"五日一石",
      u8"五日京兆",
      u8"五日份",
      u8"五日游",
      u8"五星",
      u8"五星上将",
      u8"五星旗",
      u8"五星村",
      u8"五星红旗",
      u8"五星级",
      u8"五显岗",
      u8"五晚",
      u8"五更",
      u8"五更天",
      u8"五月",
      u8"五月份",
      u8"五月天",
      u8"五月披裘",
      u8"五月粜新谷",
      u8"五月节",
      u8"五月花",
      u8"五月雪",
      u8"五月飞霜",
      u8"五服",
      u8"五朔节",
      u8"五期",
      u8"五权",
      u8"五权分立",
      u8"五权宪法",
      u8"五板",
      u8"五枝",
      u8"五枢",
      u8"五栋",
      u8"五格",
      u8"五档",
      u8"五梏",
      u8"五棓子",
      u8"五棵松",
      u8"五榖",
      u8"五榖丰收",
      u8"五樂崾",
      u8"五次犯规",
      u8"五欲",
      u8"五步成诗",
      u8"五步曲",
      u8"五步蛇",
      u8"五毒",
      u8"五毒俱全",
      u8"五毛",
      u8"五毛钱",
      u8"五河",
      u8"五河县",
      u8"五洞",
      u8"五洲",
      u8"五洲四海",
      u8"五海村",
      u8"五湖",
      u8"五湖四海",
      u8"五灵脂",
      u8"五点法注水",
      u8"五点钟",
      u8"五爱",
      u8"五爷",
      u8"五版",
      u8"五牛",
      u8"五牛队",
      u8"五环",
      u8"五环旗",
      u8"五环路",
      u8"五班",
      u8"五甲",
      u8"五申三令",
      u8"五男二女",
      u8"五百年前是一家",
      u8"五百强",
      u8"五眼",
      u8"五短",
      u8"五短身材",
      u8"五石六鹢",
      u8"五码",
      u8"五碗",
      u8"五福",
      u8"五福临门",
      u8"五福娃",
      u8"五禽戏",
      u8"五科",
      u8"五积六受",
      u8"五笔",
      u8"五笔划",
      u8"五笔加加",
      u8"五笔型",
      u8"五笔字",
      u8"五笔字型",
      u8"五笔桥",
      u8"五笔画",
      u8"五笔输入法",
      u8"五符",
      u8"五等奖",
      u8"五筒",
      u8"五箱",
      u8"五米",
      u8"五类分子",
      u8"五粮液",
      u8"五素",
      u8"五素县",
      u8"五线",
      u8"五线谱",
      u8"五经",
      u8"五经扫地",
      u8"五绝",
      u8"五统一",
      u8"五罐",
      u8"五羊",
      u8"五羖大夫",
      u8"五老峰",
      u8"五联",
      u8"五股",
      u8"五股乡",
      u8"五胎",
      u8"五胞胎",
      u8"五胡",
      u8"五胡之乱",
      u8"五胡乱华",
      u8"五胡十六",
      u8"五胡十六国",
      u8"五脊六兽",
      u8"五脏",
      u8"五脏俱全",
      u8"五脏六腑",
      u8"五自",
      u8"五船",
      u8"五色",
      u8"五色土",
      u8"五色旗",
      u8"五色无主",
      u8"五色相宣",
      u8"五色缤纷",
      u8"五节",
      u8"五节课",
      u8"五花八门",
      u8"五花大绑",
      u8"五花杀马",
      u8"五花海",
      u8"五花肉",
      u8"五花马",
      u8"五荒",
      u8"五荤",
      u8"五莲",
      u8"五莲县",
      u8"五莲山",
      u8"五营",
      u8"五营区",
      u8"五蕴",
      u8"五蕴皆空",
      u8"五藏六府",
      u8"五虎",
      u8"五虎上将",
      u8"五虎将",
      u8"五虚六耗",
      u8"五行",
      u8"五行俱下",
      u8"五行八作",
      u8"五行字",
      u8"五行并下",
      u8"五行生克",
      u8"五行阵",
      u8"五街",
      u8"五衰",
      u8"五袋",
      u8"五规范",
      u8"五角",
      u8"五角六张",
      u8"五角场",
      u8"五角大厦",
      u8"五角大楼",
      u8"五角形",
      u8"五角星",
      u8"五角枫",
      u8"五角钱",
      u8"五言律诗",
      u8"五言绝句",
      u8"五言诗",
      u8"五言长城",
      u8"五讲四美",
      u8"五讲四美三热爱",
      u8"五课",
      u8"五谷",
      u8"五谷不分",
      u8"五谷不升",
      u8"五谷丰熟",
      u8"五谷丰登",
      u8"五谷杂粮",
      u8"五起",
      u8"五路纵队",
      u8"五车腹笥",
      u8"五轮真弓",
      u8"五轻",
      u8"五辆",
      u8"五辆车",
      u8"五输穴",
      u8"五边",
      u8"五边形",
      u8"五连冠",
      u8"五迷三道",
      u8"五通",
      u8"五通桥区",
      u8"五道",
      u8"五道口",
      u8"五部",
      u8"五部委",
      u8"五部曲",
      u8"五里亭",
      u8"五里冲",
      u8"五里店",
      u8"五里桥",
      u8"五里桥乡",
      u8"五里河",
      u8"五里雾",
      u8"五里雾中",
      u8"五重奏",
      u8"五金",
      u8"五金交电",
      u8"五金产品",
      u8"五金件",
      u8"五金制品",
      u8"五金厂",
      u8"五金塑料",
      u8"五金工具",
      u8"五金工艺",
      u8"五金店",
      u8"五金建材",
      u8"五金机械",
      u8"五金材料",
      u8"五金模具",
      u8"五金网",
      u8"五金行业",
      u8"五金装饰",
      u8"五金配件",
      u8"五钱",
      u8"五铢",
      u8"五铢钱",
      u8"五间",
      u8"五间坊",
      u8"五间坊村",
      u8"五院",
      u8"五陵年少",
      u8"五陵英少",
      u8"五陵豪气",
      u8"五雀六燕",
      u8"五集",
      u8"五零二落",
      u8"五零四散",
      u8"五雷轰顶",
      u8"五霸",
      u8"五面",
      u8"五面体",
      u8"五音",
      u8"五音不全",
      u8"五音六律",
      u8"五页",
      u8"五顶",
      u8"五项",
      u8"五项原则",
      u8"五颗",
      u8"五颗星",
      u8"五题",
      u8"五颜六色",
      u8"五风十雨",
      u8"五餐",
      u8"五餐饭",
      u8"五香",
      u8"五香十味",
      u8"五香粉",
      u8"五香豆",
      u8"五马",
      u8"五马分尸",
      u8"五鬼闹判",
      u8"五黄六月",
      u8"五鼎万钟",
      u8"五龙",
      u8"五龙潭",
      u8"井上",
      u8"井下",
      u8"井下声波电视测井",
      u8"井下安全阀",
      u8"井下流量计",
      u8"井下测量",
      u8"井下电子压力计",
      u8"井下磁力仪",
      u8"井下轴流涡轮泵",
      u8"井下配产器",
      u8"井下配水嘴",
      u8"井中月",
      u8"井中求火",
      u8"井中视星",
      u8"井井有序",
      u8"井井有方",
      u8"井井有条",
      u8"井井有法",
      u8"井井有绪",
      u8"井位",
      u8"井位标",
      u8"井佐",
      u8"井冈",
      u8"井冈山",
      u8"井冈山下后",
      u8"井冈山市",
      u8"井出",
      u8"井口",
      u8"井口帽",
      u8"井口时间校正",
      u8"井口模块",
      u8"井口连接器",
      u8"井台",
      u8"井喷",
      u8"井喷式",
      u8"井场",
      u8"井坂",
      u8"井型计数器",
      u8"井壁",
      u8"井壁取心",
      u8"井壁污染",
      u8"井岗山",
      u8"井岸镇",
      u8"井巷",
      u8"井干式构架",
      u8"井底",
      u8"井底之蛙",
      u8"井底定向接头",
      u8"井底捞月",
      u8"井底虾蟆",
      u8"井底蛙",
      u8"井底蛤蟆",
      u8"井底鸣蛙",
      u8"井径",
      u8"井控模拟器",
      u8"井斜平面图",
      u8"井斜测量",
      u8"井村",
      u8"井架",
      u8"井架下底尺寸",
      u8"井架公称高度",
      u8"井架安装车",
      u8"井水",
      u8"井水不犯河水",
      u8"井沿",
      u8"井渫不食",
      u8"井渫莫食",
      u8"井灌",
      u8"井然",
      u8"井然有序",
      u8"井然有条",
      u8"井田",
      u8"井田制",
      u8"井田制度",
      u8"井盐",
      u8"井盖",
      u8"井眼",
      u8"井眼条件",
      u8"井研",
      u8"井研县",
      u8"井筒",
      u8"井管拘墟",
      u8"井组动态分析",
      u8"井绳",
      u8"井网密度",
      u8"井臼",
      u8"井臼亲操",
      u8"井蛙",
      u8"井蛙之见",
      u8"井蛙观天",
      u8"井蛙醯鸡",
      u8"井边",
      u8"井道",
      u8"井间示踪剂测试",
      u8"井队",
      u8"井陉",
      u8"井陉县",
      u8"井陉矿区",
      u8"亘古",
      u8"亘古不灭",
      u8"亘古亘今",
      u8"亘古奇闻",
      u8"亘古新闻",
      u8"亘古未有",
      u8"亘古通今",
      u8"亚丁",
      u8"亚世",
      u8"亚世达",
      u8"亚东",
      u8"亚东关系",
      u8"亚东关系协会",
      u8"亚东县",
      u8"亚东工专",
      u8"亚东工业",
      u8"亚东工业专科学校",
      u8"亚之杰",
      u8"亚乔木",
      u8"亚于",
      u8"亚优杯",
      u8"亚伟",
      u8"亚伦",
      u8"亚伯",
      u8"亚伯拉罕",
      u8"亚俱杯",
      u8"亚健康",
      u8"亚光",
      u8"亚克力",
      u8"亚典波罗",
      u8"亚军",
      u8"亚军奖",
      u8"亚军奖牌",
      u8"亚冠赛",
      u8"亚冬会",
      u8"亚凯迪严市",
      u8"亚利安人",
      u8"亚利桑纳州",
      u8"亚利桑那",
      u8"亚利桑那州",
      u8"亚力克",
      u8"亚力山大",
      u8"亚加力",
      u8"亚协国家",
      u8"亚博卢",
      u8"亚历克",
      u8"亚历克斯",
      u8"亚历山大",
      u8"亚历山大帝国",
      u8"亚原子",
      u8"亚原子性",
      u8"亚圣",
      u8"亚圣孟子",
      u8"亚型",
      u8"亚基",
      u8"亚声速",
      u8"亚太",
      u8"亚太二号",
      u8"亚太地区",
      u8"亚太经合",
      u8"亚太经济",
      u8"亚太经社会",
      u8"亚姐",
      u8"亚寒带",
      u8"亚尔乡",
      u8"亚布力",
      u8"亚平宁",
      u8"亚当",
      u8"亚当史密",
      u8"亚当史密斯",
      u8"亚当夏娃",
      u8"亚当斯",
      u8"亚得里亚",
      u8"亚得里亚海",
      u8"亚心",
      u8"亚急性",
      u8"亚急性甲状腺炎",
      u8"亚拉伯湾",
      u8"亚拉巴马",
      u8"亚拉巴马州",
      u8"亚排联",
      u8"亚文化",
      u8"亚斯",
      u8"亚松森",
      u8"亚欧",
      u8"亚欧大陆",
      u8"亚欧大陆桥",
      u8"亚毫米波",
      u8"亚氯",
      u8"亚油酸",
      u8"亚泰",
      u8"亚泰队",
      u8"亚洲",
      u8"亚洲一号",
      u8"亚洲人",
      u8"亚洲信托",
      u8"亚洲公主",
      u8"亚洲区",
      u8"亚洲及远东经济委员会",
      u8"亚洲司",
      u8"亚洲各国",
      u8"亚洲商业",
      u8"亚洲国家",
      u8"亚洲地区",
      u8"亚洲太平洋地区",
      u8"亚洲小姐",
      u8"亚洲明星",
      u8"亚洲杯",
      u8"亚洲杯赛",
      u8"亚洲版",
      u8"亚洲电视",
      u8"亚洲纪录",
      u8"亚洲记录",
      u8"亚洲象",
      u8"亚洲金融危机",
      u8"亚热",
      u8"亚热带",
      u8"亚热带地区",
      u8"亚热带气候",
      u8"亚特兰",
      u8"亚特兰大",
      u8"亚特兰帝斯",
      u8"亚犬",
      u8"亚理斯多德",
      u8"亚瑟",
      u8"亚瑟王",
      u8"亚的斯亚贝巴",
      u8"亚盟",
      u8"亚砜",
      u8"亚砷酸牙髓失活剂",
      u8"亚砷酸盐",
      u8"亚硝化螺菌",
      u8"亚硝胺",
      u8"亚硝酸",
      u8"亚硝酸盐",
      u8"亚硝酸钠",
      u8"亚硫酐",
      u8"亚硫酸",
      u8"亚硫酸盐",
      u8"亚硫酸钠",
      u8"亚磷酸",
      u8"亚磷酸盐",
      u8"亚种",
      u8"亚稳平衡",
      u8"亚稳态",
      u8"亚稳相",
      u8"亚稳离子",
      u8"亚纲",
      u8"亚细亚",
      u8"亚细亚洲",
      u8"亚细亚生",
      u8"亚细亚生产方式",
      u8"亚美",
      u8"亚美利加",
      u8"亚美利加洲",
      u8"亚美尼亚",
      u8"亚美尼亚人",
      u8"亚美尼亚共和国",
      u8"亚群",
      u8"亚联",
      u8"亚肩叠背",
      u8"亚肩迭背",
      u8"亚胺",
      u8"亚艺节",
      u8"亚莉丝",
      u8"亚行",
      u8"亚裔",
      u8"亚视",
      u8"亚记联",
      u8"亚诺金",
      u8"亚赛",
      u8"亚足联",
      u8"亚运",
      u8"亚运会",
      u8"亚运意识",
      u8"亚运村",
      u8"亚运选手",
      u8"亚里士",
      u8"亚里士多德",
      u8"亚里士多德错觉",
      u8"亚里斯多德",
      u8"亚铁",
      u8"亚铁磁性",
      u8"亚铅",
      u8"亚铜",
      u8"亚银",
      u8"亚锦赛",
      u8"亚雪带",
      u8"亚青赛",
      u8"亚非",
      u8"亚非会议",
      u8"亚非拉",
      u8"亚音速",
      u8"亚音频",
      u8"亚马孙河",
      u8"亚马逊",
      u8"亚马逊族",
      u8"亚马逊河",
      u8"亚马逊盆地",
      u8"亚高山",
      u8"亚鹏",
      u8"亚麻",
      u8"亚麻子",
      u8"亚麻布",
      u8"亚麻棉",
      u8"亚麻油",
      u8"亚麻色",
      u8"亚麻酸",
      u8"亚齐",
      u8"亚龙",
      u8"亚龙湾",
      u8"些个",
      u8"些些",
      u8"些儿",
      u8"些小",
      u8"些少",
      u8"些微",
      u8"些许",
      u8"些须",
      u8"亟待",
      u8"亟待解决",
      u8"亟欲",
      u8"亟疾苛察",
      u8"亟盼",
      u8"亟需",
      u8"亟须",
      u8"亡不待夕",
      u8"亡不旋跬",
      u8"亡不旋踵",
      u8"亡了",
      u8"亡佚",
      u8"亡兄",
      u8"亡党",
      u8"亡党亡国",
      u8"亡友",
      u8"亡可奈何",
      u8"亡命",
      u8"亡命之徒",
      u8"亡命天涯",
      u8"亡命徒",
      u8"亡国",
      u8"亡国之器",
      u8"亡国之声",
      u8"亡国之社",
      u8"亡国之音",
      u8"亡国大夫",
      u8"亡国奴",
      u8"亡国灭种",
      u8"亡国破家",
      u8"亡国论",
      u8"亡国论者",
      u8"亡夫",
      u8"亡失",
      u8"亡妹",
      u8"亡戟得矛",
      u8"亡故",
      u8"亡母",
      u8"亡灵",
      u8"亡灵族",
      u8"亡父",
      u8"亡猿灾木",
      u8"亡猿祸木",
      u8"亡矢遗镞",
      u8"亡秦三户",
      u8"亡羊之叹",
      u8"亡羊得牛",
      u8"亡羊补牢",
      u8"亡者",
      u8"亡魂",
      u8"亡魂丧胆",
      u8"亡魂丧魄",
      u8"亡魂失魄",
      u8"亢奋",
      u8"亢心憍气",
      u8"亢旱",
      u8"亢极之悔",
      u8"亢直",
      u8"亢进",
      u8"亢进症",
      u8"亢阳",
      u8"亢音高唱",
      u8"交上",
      u8"交上去",
      u8"交上来",
      u8"交下",
      u8"交下去",
      u8"交下来",
      u8"交与",
      u8"交个",
      u8"交了",
      u8"交于",
      u8"交互",
      u8"交互作用",
      u8"交互式",
      u8"交互式协议",
      u8"交互式布图系统",
      u8"交互式批处理",
      u8"交互式查找",
      u8"交互式证明",
      u8"交互式通信",
      u8"交互性",
      u8"交互支抗",
      u8"交互故障",
      u8"交互规划",
      u8"交互运作",
      u8"交互进行",
      u8"交互错误",
      u8"交井",
      u8"交些",
      u8"交交",
      u8"交人",
      u8"交付",
      u8"交付使用",
      u8"交付给",
      u8"交代",
      u8"交代任务",
      u8"交代作用",
      u8"交代罪行",
      u8"交代问题",
      u8"交件",
      u8"交会",
      u8"交会图技术",
      u8"交会处",
      u8"交会法",
      u8"交会点",
      u8"交会穴",
      u8"交住",
      u8"交保",
      u8"交入",
      u8"交公",
      u8"交关",
      u8"交兵",
      u8"交出",
      u8"交出去",
      u8"交出来",
      u8"交到",
      u8"交割",
      u8"交割单",
      u8"交割日",
      u8"交割股",
      u8"交办",
      u8"交加",
      u8"交卷",
      u8"交卸",
      u8"交叉",
      u8"交叉亲和免疫电泳",
      u8"交叉共轭",
      u8"交叉分组",
      u8"交叉双臂",
      u8"交叉口",
      u8"交叉处",
      u8"交叉存储器",
      u8"交叉学科",
      u8"交叉射击",
      u8"交叉开关",
      u8"交叉性",
      u8"交叉效度分析",
      u8"交叉有致",
      u8"交叉杂交",
      u8"交叉极化",
      u8"交叉渡线",
      u8"交叉点",
      u8"交叉犁耕",
      u8"交叉着",
      u8"交叉磷酸化",
      u8"交叉科学",
      u8"交叉竞争",
      u8"交叉端化",
      u8"交叉耦合",
      u8"交叉调制",
      u8"交叉调节",
      u8"交叉迁移",
      u8"交叉链接文件",
      u8"交友",
      u8"交友不慎",
      u8"交友网",
      u8"交变电场",
      u8"交叠",
      u8"交口",
      u8"交口县",
      u8"交口同声",
      u8"交口称誉",
      u8"交口称赞",
      u8"交口赞誉",
      u8"交合",
      u8"交响",
      u8"交响乐",
      u8"交响乐厅",
      u8"交响乐团",
      u8"交响乐章",
      u8"交响乐队",
      u8"交响协奏曲",
      u8"交响曲",
      u8"交响组曲",
      u8"交响诗",
      u8"交响音乐",
      u8"交响音乐会",
      u8"交售",
      u8"交回",
      u8"交回去",
      u8"交回来",
      u8"交困",
      u8"交城",
      u8"交城县",
      u8"交大",
      u8"交头互耳",
      u8"交头接耳",
      u8"交好",
      u8"交媾",
      u8"交学费",
      u8"交完",
      u8"交对",
      u8"交尾",
      u8"交尾季节",
      u8"交巡警",
      u8"交工",
      u8"交差",
      u8"交差了事",
      u8"交帐",
      u8"交并",
      u8"交底",
      u8"交往",
      u8"交往氮尿苷",
      u8"交往甚密",
      u8"交待",
      u8"交心",
      u8"交恶",
      u8"交情",
      u8"交感",
      u8"交感神经",
      u8"交感神经系统",
      u8"交战",
      u8"交战国",
      u8"交战图",
      u8"交战状态",
      u8"交房",
      u8"交手",
      u8"交托",
      u8"交投",
      u8"交拜",
      u8"交换",
      u8"交换代数",
      u8"交换价值",
      u8"交换台",
      u8"交换器",
      u8"交换图表",
      u8"交换子",
      u8"交换巴拿赫代数",
      u8"交换式",
      u8"交换律",
      u8"交换性盐基",
      u8"交换意见",
      u8"交换所",
      u8"交换排列",
      u8"交换机",
      u8"交换李群",
      u8"交换条件",
      u8"交换法",
      u8"交换电流",
      u8"交换网",
      u8"交换能",
      u8"交换量",
      u8"交接",
      u8"交接仪式",
      u8"交接处",
      u8"交接点",
      u8"交接班",
      u8"交接班制",
      u8"交无穷分配",
      u8"交易",
      u8"交易中心",
      u8"交易价格",
      u8"交易会",
      u8"交易员",
      u8"交易品",
      u8"交易商",
      u8"交易市场",
      u8"交易师",
      u8"交易平台",
      u8"交易成本",
      u8"交易所",
      u8"交易方式",
      u8"交易日",
      u8"交易法",
      u8"交易税",
      u8"交易类型",
      u8"交易系统",
      u8"交易网",
      u8"交易规则",
      u8"交易过程",
      u8"交易量",
      u8"交易额",
      u8"交映",
      u8"交替",
      u8"交替共聚合",
      u8"交替方向隐格式",
      u8"交替法",
      u8"交朋友",
      u8"交朋结友",
      u8"交权",
      u8"交来",
      u8"交杯",
      u8"交杯酒",
      u8"交梨火枣",
      u8"交椅",
      u8"交欢",
      u8"交款",
      u8"交汇",
      u8"交汇点",
      u8"交沙霉素",
      u8"交活",
      u8"交流",
      u8"交流中心",
      u8"交流会",
      u8"交流体会",
      u8"交流信息",
      u8"交流学习",
      u8"交流工作经验",
      u8"交流干扰",
      u8"交流平台",
      u8"交流心得",
      u8"交流思想",
      u8"交流活动",
      u8"交流电",
      u8"交流电力",
      u8"交流电力机车",
      u8"交流电法",
      u8"交流电源",
      u8"交流电路",
      u8"交流经验",
      u8"交流腐蚀",
      u8"交流计时电位法",
      u8"交流阻抗法",
      u8"交浅言深",
      u8"交涉",
      u8"交淡",
      u8"交淡若水",
      u8"交清",
      u8"交游",
      u8"交游广阔",
      u8"交溃",
      u8"交火",
      u8"交点",
      u8"交班",
      u8"交用",
      u8"交由",
      u8"交电",
      u8"交界",
      u8"交界处",
      u8"交界面",
      u8"交瘁",
      u8"交白卷",
      u8"交直流",
      u8"交相",
      u8"交相辉映",
      u8"交租",
      u8"交租金",
      u8"交移",
      u8"交税",
      u8"交稿",
      u8"交管",
      u8"交管局",
      u8"交管部门",
      u8"交粮",
      u8"交纳",
      u8"交织",
      u8"交织成",
      u8"交织着",
      u8"交结",
      u8"交给",
      u8"交联",
      u8"交联凝胶",
      u8"交联剂",
      u8"交联基",
      u8"交联密度",
      u8"交联指数",
      u8"交联网络",
      u8"交联聚合物",
      u8"交能易作",
      u8"交臂",
      u8"交臂历指",
      u8"交臂失之",
      u8"交臂相失",
      u8"交融",
      u8"交行",
      u8"交角",
      u8"交角券",
      u8"交詈聚唾",
      u8"交警",
      u8"交警大队",
      u8"交警支队",
      u8"交警车管所",
      u8"交警部门",
      u8"交警队",
      u8"交谈",
      u8"交谈服务",
      u8"交谈起来",
      u8"交谊",
      u8"交谊会",
      u8"交谊厅",
      u8"交谊舞",
      u8"交账",
      u8"交货",
      u8"交货付现",
      u8"交货值",
      u8"交货单",
      u8"交货期",
      u8"交货港",
      u8"交费",
      u8"交费用",
      u8"交足",
      u8"交趾",
      u8"交辉",
      u8"交辉相映",
      u8"交过",
      u8"交过去",
      u8"交过来",
      u8"交运",
      u8"交还",
      u8"交还给",
      u8"交进",
      u8"交迫",
      u8"交送",
      u8"交通",
      u8"交通不便",
      u8"交通中枢",
      u8"交通事故",
      u8"交通信号",
      u8"交通卡",
      u8"交通厅",
      u8"交通台",
      u8"交通史",
      u8"交通员",
      u8"交通图",
      u8"交通地图",
      u8"交通地理学",
      u8"交通堵塞",
      u8"交通壕",
      u8"交通处",
      u8"交通大学",
      u8"交通学院",
      u8"交通安全",
      u8"交通局",
      u8"交通岗",
      u8"交通岛",
      u8"交通工具",
      u8"交通干道",
      u8"交通广播",
      u8"交通建筑",
      u8"交通方式划分",
      u8"交通条件",
      u8"交通枢纽",
      u8"交通标志",
      u8"交通民警",
      u8"交通法",
      u8"交通法庭",
      u8"交通法规",
      u8"交通渠化",
      u8"交通灯",
      u8"交通状况",
      u8"交通秩序",
      u8"交通站",
      u8"交通管制",
      u8"交通管理",
      u8"交通系统",
      u8"交通线",
      u8"交通线路",
      u8"交通网",
      u8"交通肇事",
      u8"交通要道",
      u8"交通规则",
      u8"交通警",
      u8"交通警察",
      u8"交通设备",
      u8"交通设施",
      u8"交通费",
      u8"交通路线",
      u8"交通车",
      u8"交通运输",
      u8"交通运输业",
      u8"交通部",
      u8"交通部部长",
      u8"交通部长",
      u8"交通部门",
      u8"交通量",
      u8"交通银行",
      u8"交通阻塞",
      u8"交道",
      u8"交道口",
      u8"交邮",
      u8"交配",
      u8"交配季节",
      u8"交钱",
      u8"交锋",
      u8"交错",
      u8"交错代数",
      u8"交错切口",
      u8"交错化子",
      u8"交错法",
      u8"交际",
      u8"交际圈",
      u8"交际处长",
      u8"交际性",
      u8"交际舞",
      u8"交际花",
      u8"交际费",
      u8"交际赛",
      u8"交集",
      u8"交颈并头",
      u8"交风",
      u8"交验",
      u8"交齐",
      u8"亥姆霍兹双层",
      u8"亥姆霍兹方程",
      u8"亥姆霍兹线圈",
      u8"亥姆霍茨视觉说",
      u8"亥姆霍茨错觉",
      u8"亥时",
      u8"亥猪",
      u8"亥豕相望",
      u8"亥豕鲁鱼",
      u8"亦不",
      u8"亦不例外",
      u8"亦不得",
      u8"亦且",
      u8"亦会",
      u8"亦佳",
      u8"亦即",
      u8"亦友",
      u8"亦可",
      u8"亦可覆舟",
      u8"亦同",
      u8"亦喜亦忧",
      u8"亦因",
      u8"亦在",
      u8"亦复如是",
      u8"亦对",
      u8"亦对于",
      u8"亦将",
      u8"亦就",
      u8"亦属",
      u8"亦工亦农",
      u8"亦庄亦谐",
      u8"亦应",
      u8"亦应如此",
      u8"亦当",
      u8"亦得",
      u8"亦必",
      u8"亦或",
      u8"亦按",
      u8"亦无",
      u8"亦无不可",
      u8"亦是",
      u8"亦有",
      u8"亦正亦邪",
      u8"亦步亦趋",
      u8"亦比",
      u8"亦然",
      u8"亦称",
      u8"亦经",
      u8"亦能覆舟",
      u8"亦舒",
      u8"亦被",
      u8"亦要",
      u8"亦趋亦步",
      u8"亦还",
      u8"亦需",
      u8"亦需要",
      u8"亦非",
      u8"亦非台",
      u8"亦须",
      u8"产业",
      u8"产业信息部",
      u8"产业军",
      u8"产业化",
      u8"产业化工程",
      u8"产业协会",
      u8"产业后备",
      u8"产业后备军",
      u8"产业园",
      u8"产业基地",
      u8"产业工人",
      u8"产业布局",
      u8"产业带",
      u8"产业性",
      u8"产业政策",
      u8"产业界",
      u8"产业结构",
      u8"产业群",
      u8"产业群体",
      u8"产业资本",
      u8"产业部",
      u8"产业链",
      u8"产业革命",
      u8"产中",
      u8"产乳",
      u8"产乳汁",
      u8"产于",
      u8"产从",
      u8"产仔",
      u8"产供销",
      u8"产值",
      u8"产假",
      u8"产儿",
      u8"产出",
      u8"产出率",
      u8"产前",
      u8"产前检查",
      u8"产前诊断",
      u8"产加销",
      u8"产区",
      u8"产卵",
      u8"产卵器",
      u8"产卵场",
      u8"产卵期",
      u8"产卵洄游",
      u8"产后",
      u8"产后检查",
      u8"产品",
      u8"产品世界",
      u8"产品产量",
      u8"产品代理",
      u8"产品价格",
      u8"产品信息",
      u8"产品出口",
      u8"产品包装",
      u8"产品化",
      u8"产品升级",
      u8"产品合格率",
      u8"产品名",
      u8"产品名称",
      u8"产品品种",
      u8"产品品质",
      u8"产品商情",
      u8"产品图片",
      u8"产品型号",
      u8"产品展销",
      u8"产品库",
      u8"产品应用",
      u8"产品成本",
      u8"产品报价",
      u8"产品推介",
      u8"产品描述",
      u8"产品数量",
      u8"产品更新换代",
      u8"产品检验",
      u8"产品目录",
      u8"产品税",
      u8"产品策划",
      u8"产品简介",
      u8"产品类别",
      u8"产品线",
      u8"产品组合",
      u8"产品结构",
      u8"产品编号",
      u8"产品规格",
      u8"产品认证",
      u8"产品设计",
      u8"产品质量",
      u8"产品资料",
      u8"产品销售",
      u8"产地",
      u8"产地证",
      u8"产地证明",
      u8"产妇",
      u8"产婆",
      u8"产子",
      u8"产学研",
      u8"产宝石",
      u8"产床",
      u8"产房",
      u8"产期",
      u8"产权",
      u8"产权交易",
      u8"产权制度",
      u8"产权局",
      u8"产权证",
      u8"产权酒店",
      u8"产毒青霉病毒",
      u8"产气肠杆菌",
      u8"产气荚膜羧菌素",
      u8"产气菌",
      u8"产氢菌",
      u8"产水量",
      u8"产沙率",
      u8"产沙量",
      u8"产油",
      u8"产油国",
      u8"产油量",
      u8"产流",
      u8"产物",
      u8"产物保险",
      u8"产状",
      u8"产生",
      u8"产生中",
      u8"产生于",
      u8"产生共鸣",
      u8"产生出",
      u8"产生分歧",
      u8"产生器",
      u8"产生式语言知识",
      u8"产生影响",
      u8"产生矛盾",
      u8"产生算符",
      u8"产生纠纷",
      u8"产生误会",
      u8"产生误解",
      u8"产甲烷",
      u8"产甲烷菌",
      u8"产界",
      u8"产科",
      u8"产科医生",
      u8"产科医院",
      u8"产科病人",
      u8"产科病房",
      u8"产程",
      u8"产米",
      u8"产米地",
      u8"产粮",
      u8"产粮区",
      u8"产经新闻",
      u8"产能",
      u8"产自",
      u8"产色细菌",
      u8"产茶",
      u8"产茶地",
      u8"产莲区",
      u8"产蛋率",
      u8"产蛋鸡",
      u8"产褥",
      u8"产褥期",
      u8"产褥热",
      u8"产道",
      u8"产量",
      u8"产量指数递减",
      u8"产量模式",
      u8"产量比",
      u8"产钳",
      u8"产销",
      u8"产销一元化",
      u8"产销两旺",
      u8"产销合一",
      u8"产销合同",
      u8"产销地",
      u8"产销率",
      u8"产销者",
      u8"产销量",
      u8"产门",
      u8"产院",
      u8"产险",
      u8"产雌孤雌生殖",
      u8"产额",
      u8"亨利",
      u8"亨利四世",
      u8"亨嘉之会",
      u8"亨得利",
      u8"亨德利",
      u8"亨德尔",
      u8"亨特",
      u8"亨通",
      u8"亩产",
      u8"亩产值",
      u8"亩产量",
      u8"亩数",
      u8"享之千金",
      u8"享乐",
      u8"享乐主义",
      u8"享利洛生",
      u8"享受",
      u8"享受到",
      u8"享受在后",
      u8"享受性",
      u8"享国",
      u8"享寿",
      u8"享尽",
      u8"享帚自珍",
      u8"享年",
      u8"享有",
      u8"享有声誉",
      u8"享有盛名",
      u8"享有盛誉",
      u8"享服",
      u8"享清福",
      u8"享用",
      u8"享福",
      u8"享誉",
      u8"享誉中外",
      u8"京东",
      u8"京东方",
      u8"京丰",
      u8"京九",
      u8"京九线",
      u8"京九铁路",
      u8"京二胡",
      u8"京兆",
      u8"京兆画眉",
      u8"京兆眉妩",
      u8"京剧",
      u8"京剧团",
      u8"京剧学",
      u8"京剧界",
      u8"京剧迷",
      u8"京剧院",
      u8"京剧院团",
      u8"京包线",
      u8"京华",
      u8"京华春梦",
      u8"京口",
      u8"京口区",
      u8"京叭",
      u8"京味",
      u8"京哈",
      u8"京哈线",
      u8"京城",
      u8"京大戟",
      u8"京官",
      u8"京客隆",
      u8"京山",
      u8"京山县",
      u8"京山市",
      u8"京山线",
      u8"京师",
      u8"京师人",
      u8"京广",
      u8"京广桥",
      u8"京广线",
      u8"京广铁路",
      u8"京府",
      u8"京戏",
      u8"京户",
      u8"京房",
      u8"京报",
      u8"京报网",
      u8"京政发",
      u8"京族",
      u8"京本政树",
      u8"京杭",
      u8"京杭大运河",
      u8"京棉",
      u8"京求",
      u8"京汉铁路",
      u8"京沪",
      u8"京沪线",
      u8"京油子",
      u8"京津",
      u8"京津冀",
      u8"京津唐",
      u8"京津塘",
      u8"京派",
      u8"京海",
      u8"京片子",
      u8"京珠",
      u8"京瓷",
      u8"京瓷振华",
      u8"京畿",
      u8"京畿道",
      u8"京白",
      u8"京白梨",
      u8"京福高速",
      u8"京秦线",
      u8"京胡",
      u8"京腔",
      u8"京药监",
      u8"京菜",
      u8"京西",
      u8"京话",
      u8"京调",
      u8"京谷",
      u8"京郊",
      u8"京都",
      u8"京都府",
      u8"京野琴美",
      u8"京门",
      u8"京韵",
      u8"京韵大鼓",
      u8"京顺路",
      u8"京骨",
      u8"亭亭",
      u8"亭亭玉立",
      u8"亭午",
      u8"亭台",
      u8"亭台楼榭",
      u8"亭台楼阁",
      u8"亭子",
      u8"亭子间",
      u8"亭桥",
      u8"亭榭画廊",
      u8"亭湖区",
      u8"亭里",
      u8"亭长",
      u8"亮丑",
      u8"亮丽",
      u8"亮了",
      u8"亮亮的",
      u8"亮儿",
      u8"亮光",
      u8"亮光光",
      u8"亮光漆",
      u8"亮出",
      u8"亮分",
      u8"亮到",
      u8"亮堂",
      u8"亮堂堂",
      u8"亮子",
      u8"亮家伙",
      u8"亮底",
      u8"亮度",
      u8"亮度对比",
      u8"亮度计",
      u8"亮抑蛋白酶肽",
      u8"亮晃晃",
      u8"亮晶晶",
      u8"亮暗比",
      u8"亮氨酸",
      u8"亮氨酸拉链",
      u8"亮泽",
      u8"亮点",
      u8"亮片",
      u8"亮牌",
      u8"亮相",
      u8"亮眼人",
      u8"亮着",
      u8"亮票",
      u8"亮红灯",
      u8"亮线",
      u8"亮绿",
      u8"亮色",
      u8"亮节",
      u8"亮节高风",
      u8"亮话",
      u8"亮起",
      u8"亮铮铮",
      u8"亮银色",
      u8"亮锃锃",
      u8"亮闪闪",
      u8"亲丁",
      u8"亲上做亲",
      u8"亲上加亲",
      u8"亲上成亲",
      u8"亲不亲",
      u8"亲临",
      u8"亲临一线",
      u8"亲临其境",
      u8"亲临指导",
      u8"亲临现场",
      u8"亲了",
      u8"亲事",
      u8"亲交",
      u8"亲亲",
      u8"亲亲热热",
      u8"亲亲爱爱",
      u8"亲亲百家人",
      u8"亲人",
      u8"亲人或",
      u8"亲仁善邻",
      u8"亲代",
      u8"亲任",
      u8"亲信",
      u8"亲儿子",
      u8"亲兄妹",
      u8"亲兄弟",
      u8"亲兄弟明",
      u8"亲兄弟明算帐",
      u8"亲兄弟明算账",
      u8"亲兵",
      u8"亲冒矢石",
      u8"亲切",
      u8"亲切友好",
      u8"亲切感",
      u8"亲切服务",
      u8"亲华人士",
      u8"亲历",
      u8"亲历其境",
      u8"亲历者",
      u8"亲历记",
      u8"亲友",
      u8"亲友们",
      u8"亲友团",
      u8"亲口",
      u8"亲口答应",
      u8"亲口说",
      u8"亲合力",
      u8"亲启",
      u8"亲吻",
      u8"亲呢",
      u8"亲和",
      u8"亲和力",
      u8"亲和层析",
      u8"亲和性",
      u8"亲和柱",
      u8"亲哥哥",
      u8"亲善",
      u8"亲善大使",
      u8"亲善访问",
      u8"亲嘴",
      u8"亲处",
      u8"亲多",
      u8"亲夫",
      u8"亲如一家",
      u8"亲如兄弟",
      u8"亲如家人",
      u8"亲如手足",
      u8"亲如骨肉",
      u8"亲妈",
      u8"亲姆",
      u8"亲姊妹",
      u8"亲姊姊",
      u8"亲姐妹",
      u8"亲姐姐",
      u8"亲威",
      u8"亲娘",
      u8"亲子",
      u8"亲子关系",
      u8"亲子园",
      u8"亲子活动",
      u8"亲子装",
      u8"亲家",
      u8"亲家公",
      u8"亲家庭",
      u8"亲家母",
      u8"亲家翁",
      u8"亲密",
      u8"亲密关系",
      u8"亲密合作",
      u8"亲密性",
      u8"亲密无间",
      u8"亲展",
      u8"亲属",
      u8"亲属关系",
      u8"亲属制度",
      u8"亲属称谓",
      u8"亲师",
      u8"亲弟兄",
      u8"亲当矢石",
      u8"亲往",
      u8"亲征",
      u8"亲情",
      u8"亲戚",
      u8"亲戚关系",
      u8"亲戚家",
      u8"亲戚朋友",
      u8"亲手",
      u8"亲手做",
      u8"亲抚",
      u8"亲授",
      u8"亲操井臼",
      u8"亲收",
      u8"亲政",
      u8"亲故",
      u8"亲族",
      u8"亲日",
      u8"亲日派",
      u8"亲昵",
      u8"亲昵性",
      u8"亲朋",
      u8"亲朋好友",
      u8"亲本",
      u8"亲权",
      u8"亲核反应",
      u8"亲母",
      u8"亲民党",
      u8"亲水性",
      u8"亲洽",
      u8"亲潮",
      u8"亲热",
      u8"亲热戏",
      u8"亲爱",
      u8"亲爱的",
      u8"亲爱精诚",
      u8"亲父",
      u8"亲爹",
      u8"亲率",
      u8"亲王",
      u8"亲生",
      u8"亲生儿",
      u8"亲生女",
      u8"亲生女儿",
      u8"亲生子女",
      u8"亲生父母",
      u8"亲生骨肉",
      u8"亲电取代",
      u8"亲电重排",
      u8"亲疏",
      u8"亲疏贵贱",
      u8"亲痛仇快",
      u8"亲眷",
      u8"亲眼",
      u8"亲眼所见",
      u8"亲眼目睹",
      u8"亲眼看到",
      u8"亲眼看见",
      u8"亲眼见到",
      u8"亲着",
      u8"亲睦",
      u8"亲睹",
      u8"亲知",
      u8"亲离众叛",
      u8"亲笔",
      u8"亲笔信",
      u8"亲笔写",
      u8"亲笔文件",
      u8"亲笔签名",
      u8"亲缘",
      u8"亲者痛",
      u8"亲耳",
      u8"亲耳所闻",
      u8"亲聆",
      u8"亲职",
      u8"亲职教育",
      u8"亲脂性",
      u8"亲脸",
      u8"亲自",
      u8"亲自出马",
      u8"亲自动手",
      u8"亲自参加",
      u8"亲英派",
      u8"亲见",
      u8"亲贤人远",
      u8"亲贤人远小人",
      u8"亲贤远佞",
      u8"亲贵",
      u8"亲赴",
      u8"亲身",
      u8"亲身经历",
      u8"亲身经验",
      u8"亲迎",
      u8"亲近",
      u8"亲近感",
      u8"亲逾手足",
      u8"亲闻",
      u8"亲随",
      u8"亲驾",
      u8"亲骨肉",
      u8"亳县",
      u8"亳州",
      u8"亳州市",
      u8"亵渎",
      u8"亵渎神明",
      u8"亵玩",
      u8"亵臣",
      u8"亵衣",
      u8"亹亹不倦",
      u8"人一己百",
      u8"人丁",
      u8"人丁兴旺",
      u8"人丁旺盛",
      u8"人上人",
      u8"人上有人",
      u8"人下",
      u8"人不为己",
      u8"人不为己天诛地灭",
      u8"人不可貌",
      u8"人不可貌相",
      u8"人不犯我我不犯人",
      u8"人不知",
      u8"人不知鬼",
      u8"人不知鬼不觉",
      u8"人不聊生",
      u8"人不自安",
      u8"人不风流枉少年",
      u8"人与人之间",
      u8"人与狗",
      u8"人与自然",
      u8"人与车",
      u8"人世",
      u8"人世沧桑",
      u8"人世间",
      u8"人丛",
      u8"人中",
      u8"人中之龙",
      u8"人中狮子",
      u8"人中豪杰",
      u8"人中骐骥",
      u8"人中龙虎",
      u8"人为",
      u8"人为万物",
      u8"人为万物之灵",
      u8"人为刀俎",
      u8"人为刀俎我为鱼肉",
      u8"人为因素",
      u8"人为地",
      u8"人为失误",
      u8"人为财死",
      u8"人为财死鸟为食亡",
      u8"人主",
      u8"人之初",
      u8"人之将死",
      u8"人之将死其言也善",
      u8"人之常情",
      u8"人之长情",
      u8"人事",
      u8"人事不省",
      u8"人事不知",
      u8"人事不醒",
      u8"人事主管",
      u8"人事代理",
      u8"人事代谢",
      u8"人事全非",
      u8"人事关系",
      u8"人事制度",
      u8"人事厅",
      u8"人事变动",
      u8"人事司",
      u8"人事处",
      u8"人事安排",
      u8"人事室",
      u8"人事局",
      u8"人事工作",
      u8"人事心理学",
      u8"人事权",
      u8"人事档案",
      u8"人事监察",
      u8"人事科",
      u8"人事管理",
      u8"人事管理学",
      u8"人事网",
      u8"人事行政",
      u8"人事部",
      u8"人事部部长",
      u8"人事部门",
      u8"人云",
      u8"人云亦云",
      u8"人亡家破",
      u8"人亡政息",
      u8"人亡物在",
      u8"人亡邦瘁",
      u8"人人",
      u8"人人为师",
      u8"人人为我",
      u8"人人乐",
      u8"人人喊打",
      u8"人人平等",
      u8"人人得而",
      u8"人人得而诛之",
      u8"人人有则",
      u8"人人有责",
      u8"人人爱",
      u8"人人皆知",
      u8"人人自危",
      u8"人人过关",
      u8"人代",
      u8"人代会",
      u8"人代大会",
      u8"人以群分",
      u8"人们",
      u8"人们认为",
      u8"人仰马翻",
      u8"人众",
      u8"人众胜天",
      u8"人伦",
      u8"人伦关系",
      u8"人体",
      u8"人体上",
      u8"人体内",
      u8"人体写真板",
      u8"人体器官",
      u8"人体实验",
      u8"人体工学",
      u8"人体彩绘",
      u8"人体摄影",
      u8"人体模型",
      u8"人体模特",
      u8"人体测量学",
      u8"人体漫游",
      u8"人体炸弹",
      u8"人体热感觉",
      u8"人体生理",
      u8"人体科学",
      u8"人体素描",
      u8"人体维修站",
      u8"人体美",
      u8"人体舒适",
      u8"人体艺术",
      u8"人保",
      u8"人偶",
      u8"人像",
      u8"人像卡",
      u8"人像画",
      u8"人像靶",
      u8"人儿",
      u8"人公里",
      u8"人兽交",
      u8"人到中年",
      u8"人前",
      u8"人前人后",
      u8"人剥削人",
      u8"人力",
      u8"人力不足",
      u8"人力物力",
      u8"人力资本",
      u8"人力资源",
      u8"人力资源网",
      u8"人力资源部",
      u8"人力车",
      u8"人化",
      u8"人千人万",
      u8"人单势孤",
      u8"人厨子",
      u8"人去",
      u8"人去楼空",
      u8"人参",
      u8"人参果",
      u8"人参精",
      u8"人参芦",
      u8"人参酒",
      u8"人取我与",
      u8"人口",
      u8"人口不足",
      u8"人口众多",
      u8"人口信息系统",
      u8"人口减少",
      u8"人口出生率",
      u8"人口分布",
      u8"人口分析",
      u8"人口动态登记",
      u8"人口占",
      u8"人口危机",
      u8"人口压力",
      u8"人口地理",
      u8"人口地理学",
      u8"人口基数",
      u8"人口增加",
      u8"人口增殖",
      u8"人口增长",
      u8"人口增长率",
      u8"人口委员会",
      u8"人口学",
      u8"人口学家",
      u8"人口密度",
      u8"人口平衡",
      u8"人口年轻化",
      u8"人口年龄金字塔",
      u8"人口总出生率",
      u8"人口总数",
      u8"人口总死亡率",
      u8"人口战略",
      u8"人口报",
      u8"人口政策",
      u8"人口数",
      u8"人口数量",
      u8"人口断层",
      u8"人口普查",
      u8"人口构成",
      u8"人口比例",
      u8"人口爆炸",
      u8"人口理论",
      u8"人口百岁图",
      u8"人口研究",
      u8"人口社会学",
      u8"人口稠密",
      u8"人口素质",
      u8"人口组成",
      u8"人口经济学",
      u8"人口结构",
      u8"人口统计",
      u8"人口老化",
      u8"人口自然增长",
      u8"人口规划",
      u8"人口论",
      u8"人口负增长",
      u8"人口质量",
      u8"人口贩子",
      u8"人口资料",
      u8"人口迁移",
      u8"人口过剩",
      u8"人口过密",
      u8"人口问题",
      u8"人口零增长",
      u8"人口零点增长",
      u8"人口预测",
      u8"人叫",
      u8"人叫声",
      u8"人吃人",
      u8"人各有志",
      u8"人同此心",
      u8"人同此心心同此理",
      u8"人名",
      u8"人名册",
      u8"人名医院",
      u8"人名录",
      u8"人后",
      u8"人吗",
      u8"人君",
      u8"人员",
      u8"人员不足",
      u8"人员伤亡",
      u8"人员名单",
      u8"人员培训",
      u8"人员构成",
      u8"人员测评",
      u8"人员素质",
      u8"人员编制",
      u8"人员选拔",
      u8"人员配备",
      u8"人呢",
      u8"人味",
      u8"人味儿",
      u8"人命",
      u8"人命关天",
      u8"人命危浅",
      u8"人命官司",
      u8"人和",
      u8"人和事",
      u8"人品",
      u8"人品出众",
      u8"人品问题",
      u8"人商",
      u8"人善被人欺",
      u8"人喊马嘶",
      u8"人因工效学",
      u8"人困马乏",
      u8"人在",
      u8"人在何处",
      u8"人在何方",
      u8"人在旅途",
      u8"人在江湖",
      u8"人地",
      u8"人地关系",
      u8"人地生疏",
      u8"人均",
      u8"人均产值",
      u8"人均可支配",
      u8"人均指标",
      u8"人均收入",
      u8"人均纯收入",
      u8"人堆",
      u8"人墙",
      u8"人士",
      u8"人声",
      u8"人声吵杂",
      u8"人声嘈杂",
      u8"人声鼎沸",
      u8"人外有人",
      u8"人多",
      u8"人多力量大",
      u8"人多势众",
      u8"人多口杂",
      u8"人多嘴杂",
      u8"人多地少",
      u8"人多怪少",
      u8"人多手杂",
      u8"人多阙少",
      u8"人大",
      u8"人大主任",
      u8"人大代表",
      u8"人大会堂",
      u8"人大会议",
      u8"人大常委会",
      u8"人大网",
      u8"人天",
      u8"人太紧则无智",
      u8"人夫",
      u8"人头",
      u8"人头攒动",
      u8"人头猪脑",
      u8"人头畜鸣",
      u8"人头税",
      u8"人头费",
      u8"人头马",
      u8"人头骨",
      u8"人妖",
      u8"人子",
      u8"人字",
      u8"人字拖",
      u8"人字架",
      u8"人存政举",
      u8"人学",
      u8"人定",
      u8"人定胜天",
      u8"人家",
      u8"人家说",
      u8"人寰",
      u8"人寿",
      u8"人寿保险",
      u8"人寿年丰",
      u8"人小",
      u8"人小气大",
      u8"人小鬼大",
      u8"人少",
      u8"人少好喝汤",
      u8"人尽其才",
      u8"人尽其材",
      u8"人尽可夫",
      u8"人尽皆知",
      u8"人居",
      u8"人居奖",
      u8"人山人海",
      u8"人工",
      u8"人工免疫",
      u8"人工关节",
      u8"人工制品",
      u8"人工化",
      u8"人工受孕",
      u8"人工合成",
      u8"人工呼吸",
      u8"人工地貌",
      u8"人工基",
      u8"人工孵化",
      u8"人工岛",
      u8"人工工资",
      u8"人工干预",
      u8"人工录入",
      u8"人工心脏",
      u8"人工成本",
      u8"人工授粉",
      u8"人工授精",
      u8"人工效率",
      u8"人工整理",
      u8"人工智慧",
      u8"人工智能",
      u8"人工智能技术",
      u8"人工林",
      u8"人工模拟",
      u8"人工气候室",
      u8"人工流产",
      u8"人工混响",
      u8"人工港",
      u8"人工湖",
      u8"人工牙",
      u8"人工牙列",
      u8"人工甘味",
      u8"人工生命",
      u8"人工繁殖",
      u8"人工费",
      u8"人工降雨",
      u8"人差方程",
      u8"人己一视",
      u8"人师",
      u8"人平",
      u8"人年",
      u8"人弃我取",
      u8"人强胜天",
      u8"人强马壮",
      u8"人形",
      u8"人形师",
      u8"人影",
      u8"人影儿",
      u8"人微望轻",
      u8"人微权轻",
      u8"人微言贱",
      u8"人微言轻",
      u8"人心",
      u8"人心不古",
      u8"人心不同",
      u8"人心不足蛇吞象",
      u8"人心丧尽",
      u8"人心叵测",
      u8"人心向背",
      u8"人心大快",
      u8"人心如面",
      u8"人心归向",
      u8"人心思汉",
      u8"人心思治",
      u8"人心悦诚服",
      u8"人心惟危",
      u8"人心惶惶",
      u8"人心所向",
      u8"人心所归",
      u8"人心果",
      u8"人心果李",
      u8"人心浮动",
      u8"人心涣散",
      u8"人心皇皇",
      u8"人心莫测",
      u8"人心隔肚皮",
      u8"人心难测",
      u8"人心齐",
      u8"人心齐泰山移",
      u8"人怕出名猪怕壮",
      u8"人急偎亲",
      u8"人急智生",
      u8"人急计生",
      u8"人性",
      u8"人性化",
      u8"人性尊严",
      u8"人性本善",
      u8"人性本恶",
      u8"人性论",
      u8"人怨天怒",
      u8"人怨神怒",
      u8"人情",
      u8"人情世态",
      u8"人情世故",
      u8"人情事故",
      u8"人情债",
      u8"人情冷暖",
      u8"人情味",
      u8"人情恟恟",
      u8"人情案",
      u8"人情汹汹",
      u8"人情电",
      u8"人意",
      u8"人愧",
      u8"人愿",
      u8"人我",
      u8"人我不分",
      u8"人我是非",
      u8"人所共知",
      u8"人所共见",
      u8"人手",
      u8"人手一册",
      u8"人手不足",
      u8"人才",
      u8"人才中介",
      u8"人才交流",
      u8"人才交流中心",
      u8"人才出众",
      u8"人才培养",
      u8"人才外流",
      u8"人才学",
      u8"人才市场",
      u8"人才库",
      u8"人才思想",
      u8"人才流动",
      u8"人才流失",
      u8"人才济济",
      u8"人才热线",
      u8"人才经济学",
      u8"人才网",
      u8"人才观",
      u8"人才资源",
      u8"人才辈出",
      u8"人才队伍",
      u8"人才难得",
      u8"人才需求",
      u8"人托人",
      u8"人教版",
      u8"人教社",
      u8"人数",
      u8"人文",
      u8"人文主义",
      u8"人文地理",
      u8"人文地理学",
      u8"人文大学",
      u8"人文奥运",
      u8"人文学",
      u8"人文学科",
      u8"人文学院",
      u8"人文景观",
      u8"人文涵养",
      u8"人文环境",
      u8"人文科学",
      u8"人文精神",
      u8"人文荟萃",
      u8"人斩",
      u8"人无信不立",
      u8"人无千日",
      u8"人无完人",
      u8"人无远虑",
      u8"人无远虑必有近忧",
      u8"人日",
      u8"人时",
      u8"人是衣妆",
      u8"人月",
      u8"人有千算",
      u8"人有旦夕",
      u8"人有旦夕祸福",
      u8"人有脸树有皮",
      u8"人望",
      u8"人本",
      u8"人本主义",
      u8"人本主义地理学",
      u8"人本主义心理治疗",
      u8"人机",
      u8"人机一体",
      u8"人机交互",
      u8"人机交互联作解释",
      u8"人机功能分配",
      u8"人机对话",
      u8"人机环境",
      u8"人机环境系统",
      u8"人机界面",
      u8"人机系统评价",
      u8"人权",
      u8"人权主义",
      u8"人权会",
      u8"人权委员会",
      u8"人权学",
      u8"人权宣言",
      u8"人权思想",
      u8"人权意识",
      u8"人权法",
      u8"人权观",
      u8"人权记录",
      u8"人材",
      u8"人材出众",
      u8"人材外流",
      u8"人来人往",
      u8"人来客去",
      u8"人来客往",
      u8"人来疯",
      u8"人杰",
      u8"人杰地灵",
      u8"人极",
      u8"人极计生",
      u8"人样",
      u8"人格",
      u8"人格保证",
      u8"人格健全",
      u8"人格分裂",
      u8"人格化",
      u8"人格尊严",
      u8"人格心理学",
      u8"人格担保",
      u8"人格教育",
      u8"人格权",
      u8"人格特质",
      u8"人格理论",
      u8"人格类型",
      u8"人格结构",
      u8"人格解体",
      u8"人格障碍",
      u8"人格魅力",
      u8"人梯",
      u8"人模人样",
      u8"人模狗样",
      u8"人模狗样儿",
      u8"人次",
      u8"人欢马叫",
      u8"人欲",
      u8"人欲横流",
      u8"人武",
      u8"人武惟扬",
      u8"人武部",
      u8"人死不能复生",
      u8"人死留名",
      u8"人母",
      u8"人比人",
      u8"人比怪多",
      u8"人氏",
      u8"人民",
      u8"人民之声",
      u8"人民代表",
      u8"人民代表大会",
      u8"人民保险",
      u8"人民党",
      u8"人民公仆",
      u8"人民公园",
      u8"人民公社",
      u8"人民共和国",
      u8"人民内部",
      u8"人民内部矛盾",
      u8"人民军",
      u8"人民军队",
      u8"人民出版",
      u8"人民出版社",
      u8"人民利益",
      u8"人民医院",
      u8"人民商场",
      u8"人民团体",
      u8"人民城郭",
      u8"人民大众",
      u8"人民大会",
      u8"人民大会堂",
      u8"人民大学",
      u8"人民委员",
      u8"人民子弟兵",
      u8"人民富足",
      u8"人民币",
      u8"人民广播电台",
      u8"人民性",
      u8"人民意志",
      u8"人民战争",
      u8"人民报",
      u8"人民政协",
      u8"人民政府",
      u8"人民政权党",
      u8"人民教师",
      u8"人民文学",
      u8"人民日",
      u8"人民日报",
      u8"人民日报社",
      u8"人民检察院",
      u8"人民武装",
      u8"人民武装部",
      u8"人民民主",
      u8"人民民主专政",
      u8"人民法庭",
      u8"人民法院",
      u8"人民满意",
      u8"人民生活",
      u8"人民生活水平",
      u8"人民网",
      u8"人民群众",
      u8"人民英雄",
      u8"人民英雄纪念碑",
      u8"人民解放军",
      u8"人民警察",
      u8"人民调解",
      u8"人民起义",
      u8"人民路",
      u8"人民邮电",
      u8"人民银行",
      u8"人民阵线",
      u8"人民陪审员",
      u8"人气",
      u8"人气值",
      u8"人气指标",
      u8"人气旺盛",
      u8"人治",
      u8"人流",
      u8"人流量",
      u8"人浪",
      u8"人浮于世",
      u8"人浮于事",
      u8"人浮于食",
      u8"人海",
      u8"人海战术",
      u8"人海茫茫",
      u8"人涉卬否",
      u8"人淡如菊",
      u8"人渣",
      u8"人溺己溺",
      u8"人满",
      u8"人满为患",
      u8"人满之患",
      u8"人潮",
      u8"人潮如涌",
      u8"人烟",
      u8"人烟凑集",
      u8"人烟浩穰",
      u8"人烟稀少",
      u8"人烟稠密",
      u8"人物",
      u8"人物传记",
      u8"人物史",
      u8"人物周刊",
      u8"人物图片",
      u8"人物奖",
      u8"人物属性",
      u8"人物形象",
      u8"人物志",
      u8"人物性格",
      u8"人物描写",
      u8"人物画",
      u8"人物肖像",
      u8"人物造型",
      u8"人犯",
      u8"人猿",
      u8"人猿泰山",
      u8"人琴两亡",
      u8"人琴俱亡",
      u8"人琴俱逝",
      u8"人瑞",
      u8"人生",
      u8"人生七十",
      u8"人生七十古来稀",
      u8"人生价值",
      u8"人生似鸟同林宿",
      u8"人生何处不相逢",
      u8"人生哲学",
      u8"人生哲理",
      u8"人生在世",
      u8"人生在世不称意",
      u8"人生地不熟",
      u8"人生大事",
      u8"人生如寄",
      u8"人生如朝",
      u8"人生如朝露",
      u8"人生如梦",
      u8"人生如白驹过隙",
      u8"人生态度",
      u8"人生意义",
      u8"人生旅途",
      u8"人生朝露",
      u8"人生权",
      u8"人生目标",
      u8"人生能有几回搏",
      u8"人生若寄",
      u8"人生若朝霞",
      u8"人生观",
      u8"人生路",
      u8"人生路不熟",
      u8"人生道路",
      u8"人生面不熟",
      u8"人界篇",
      u8"人畜",
      u8"人百其身",
      u8"人皆有之",
      u8"人皮",
      u8"人神共嫉",
      u8"人神共愤",
      u8"人神共鉴",
      u8"人神同嫉",
      u8"人祸",
      u8"人离乡贱",
      u8"人种",
      u8"人种地理学",
      u8"人种学",
      u8"人称",
      u8"人称代名词",
      u8"人稠物穰",
      u8"人穷志不穷",
      u8"人穷志短",
      u8"人穷智短",
      u8"人算不如",
      u8"人类",
      u8"人类单疱疹病毒",
      u8"人类史",
      u8"人类史上",
      u8"人类地理学",
      u8"人类基因",
      u8"人类基因组",
      u8"人类基因组计划",
      u8"人类学",
      u8"人类学家",
      u8"人类工程学",
      u8"人类文化学",
      u8"人类文明",
      u8"人类生态学",
      u8"人类生物气象学",
      u8"人类社会",
      u8"人类补完计划",
      u8"人粪尿",
      u8"人精",
      u8"人约黄昏",
      u8"人绒毛膜促性腺激素",
      u8"人给家足",
      u8"人缘",
      u8"人缘儿",
      u8"人缝",
      u8"人群",
      u8"人群中",
      u8"人老",
      u8"人老心不老",
      u8"人老珠黄",
      u8"人老眼花",
      u8"人而无信",
      u8"人而无信不知其可",
      u8"人耳",
      u8"人肉",
      u8"人肉市场",
      u8"人胎素",
      u8"人脉",
      u8"人脉关系",
      u8"人脑",
      u8"人脸",
      u8"人臣",
      u8"人自为战",
      u8"人自为政",
      u8"人艺",
      u8"人荒马乱",
      u8"人莫予毒",
      u8"人血白蛋白",
      u8"人行",
      u8"人行天桥",
      u8"人行横道",
      u8"人行路",
      u8"人行道",
      u8"人要衣装",
      u8"人见",
      u8"人见人爱",
      u8"人言",
      u8"人言利博",
      u8"人言可畏",
      u8"人言啧啧",
      u8"人言籍籍",
      u8"人言藉藉",
      u8"人论",
      u8"人设",
      u8"人证",
      u8"人证物证",
      u8"人证物证俱在",
      u8"人话",
      u8"人语",
      u8"人语马嘶",
      u8"人谋不臧",
      u8"人豪",
      u8"人财两旺",
      u8"人财两空",
      u8"人财物",
      u8"人质",
      u8"人质事件",
      u8"人质危机",
      u8"人贩",
      u8"人贩子",
      u8"人贫智短",
      u8"人贵有自知之明",
      u8"人赃俱获",
      u8"人赃并获",
      u8"人走灯灭",
      u8"人走茶凉",
      u8"人足家给",
      u8"人身",
      u8"人身事故",
      u8"人身依附",
      u8"人身保护",
      u8"人身保险",
      u8"人身安全",
      u8"人身攻击",
      u8"人身权",
      u8"人身权利",
      u8"人身自由",
      u8"人身险",
      u8"人迎",
      u8"人迹",
      u8"人迹罕到",
      u8"人迹罕至",
      u8"人选",
      u8"人造",
      u8"人造丝",
      u8"人造云母",
      u8"人造冠",
      u8"人造冰",
      u8"人造卫星",
      u8"人造地球",
      u8"人造地球卫星",
      u8"人造奶油",
      u8"人造板",
      u8"人造棉",
      u8"人造橡皮",
      u8"人造橡胶",
      u8"人造毛",
      u8"人造毛皮",
      u8"人造皮",
      u8"人造石",
      u8"人造石油",
      u8"人造磁铁",
      u8"人造纤维",
      u8"人造美女",
      u8"人造肉",
      u8"人造肥料",
      u8"人造花",
      u8"人造草坪",
      u8"人造行星",
      u8"人造雨",
      u8"人造革",
      u8"人造黄油",
      u8"人逢喜事",
      u8"人逢喜事精神爽",
      u8"人道",
      u8"人道主义",
      u8"人道主义者",
      u8"人道精神",
      u8"人部",
      u8"人间",
      u8"人间仙境",
      u8"人间喜剧",
      u8"人间地狱",
      u8"人间天上",
      u8"人间天堂",
      u8"人间正道",
      u8"人间烟火",
      u8"人间能得几回闻",
      u8"人间蒸发",
      u8"人间重晚晴",
      u8"人间难得一知己",
      u8"人防",
      u8"人防办",
      u8"人阵",
      u8"人际",
      u8"人际交往",
      u8"人际关系",
      u8"人际吸引理论",
      u8"人际排斥",
      u8"人际服务",
      u8"人际沟通",
      u8"人际消息",
      u8"人际艺术",
      u8"人非土木",
      u8"人非圣贤",
      u8"人非圣贤孰能无过",
      u8"人非木石",
      u8"人非物是",
      u8"人非草木",
      u8"人面",
      u8"人面临",
      u8"人面像",
      u8"人面兽心",
      u8"人面桃花",
      u8"人面桃花相映红",
      u8"人面狗心",
      u8"人饥己饥",
      u8"人马",
      u8"人马宫",
      u8"人马座",
      u8"人高马大",
      u8"人鬼",
      u8"人鬼不分",
      u8"人鱼",
      u8"人鱼公主",
      u8"人龙",
      u8"亻尔",
      u8"亻至刂",
      u8"亿万",
      u8"亿万人民",
      u8"亿万家财",
      u8"亿万富翁",
      u8"亿万富豪",
      u8"亿万斯年",
      u8"亿万群众",
      u8"亿亩",
      u8"亿元",
      u8"亿兆",
      u8"亿兆一心",
      u8"亿利",
      u8"亿吨",
      u8"亿吨级",
      u8"亿唐",
      u8"亿多元",
      u8"亿多吨",
      u8"亿客隆",
      u8"亿斤",
      u8"亿测",
      u8"亿网行",
      u8"亿载金城",
      u8"亿辛万苦",
      u8"亿邮网",
      u8"什不闲儿",
      u8"什么",
      u8"什么世道",
      u8"什么东西",
      u8"什么事",
      u8"什么事情",
      u8"什么人",
      u8"什么关系",
      u8"什么区别",
      u8"什么原因",
      u8"什么名字",
      u8"什么地方",
      u8"什么情况",
      u8"什么意思",
      u8"什么时候",
      u8"什么时间",
      u8"什么样",
      u8"什么游戏",
      u8"什么用",
      u8"什么的",
      u8"什么问题",
      u8"什件",
      u8"什件儿",
      u8"什伍东西",
      u8"什克洛夫斯基",
      u8"什刹海",
      u8"什叶",
      u8"什叶派",
      u8"什围伍攻",
      u8"什物",
      u8"什科夫",
      u8"什维克",
      u8"什袭以藏",
      u8"什袭珍藏",
      u8"什袭而藏",
      u8"什邡",
      u8"什邡县",
      u8"什邡市",
      u8"什锦",
      u8"什锦炒面",
      u8"什锦糖",
      u8"什锦菜",
      u8"什锦锉",
      u8"什锦陷",
      u8"什锦面",
      u8"仁丹",
      u8"仁义",
      u8"仁义之兵",
      u8"仁义之师",
      u8"仁义君子",
      u8"仁义礼智信",
      u8"仁义道德",
      u8"仁人",
      u8"仁人义士",
      u8"仁人君子",
      u8"仁人志士",
      u8"仁以恤民",
      u8"仁信",
      u8"仁兄",
      u8"仁化",
      u8"仁化县",
      u8"仁医",
      u8"仁厚",
      u8"仁同一视",
      u8"仁君",
      u8"仁和",
      u8"仁和区",
      u8"仁子",
      u8"仁孝",
      u8"仁学",
      u8"仁宗",
      u8"仁寿",
      u8"仁寿县",
      u8"仁寿街",
      u8"仁川",
      u8"仁布",
      u8"仁布县",
      u8"仁弟",
      u8"仁德",
      u8"仁心",
      u8"仁心仁术",
      u8"仁心仁闻",
      u8"仁怀",
      u8"仁怀县",
      u8"仁怀市",
      u8"仁慈",
      u8"仁慈地",
      u8"仁慈心",
      u8"仁政",
      u8"仁昌",
      u8"仁术",
      u8"仁果",
      u8"仁柔寡断",
      u8"仁武",
      u8"仁民爱物",
      u8"仁波切",
      u8"仁浆义粟",
      u8"仁爱",
      u8"仁爱为接",
      u8"仁爱为接物之本",
      u8"仁爱之心",
      u8"仁爱医院",
      u8"仁爱国中",
      u8"仁爱国小",
      u8"仁爱路",
      u8"仁者",
      u8"仁者乐山",
      u8"仁者无敌",
      u8"仁者能仁",
      u8"仁者见仁",
      u8"仁者见仁智者见智",
      u8"仁至义尽",
      u8"仁言利博",
      u8"仁言利溥",
      u8"仄仄",
      u8"仄声",
      u8"仄韵",
      u8"仅为",
      u8"仅举",
      u8"仅于",
      u8"仅仅",
      u8"仅仅只是",
      u8"仅仅如此",
      u8"仅仅是",
      u8"仅仅有",
      u8"仅从",
      u8"仅代表",
      u8"仅以",
      u8"仅以身免",
      u8"仅供",
      u8"仅供参考",
      u8"仅凭",
      u8"仅剩",
      u8"仅占",
      u8"仅及",
      u8"仅只",
      u8"仅可",
      u8"仅在",
      u8"仅够",
      u8"仅存",
      u8"仅容旋马",
      u8"仅对",
      u8"仅就",
      u8"仅把",
      u8"仅指",
      u8"仅据",
      u8"仅是",
      u8"仅有",
      u8"仅次于",
      u8"仅此",
      u8"仅此一次",
      u8"仅此而已",
      u8"仅用",
      u8"仅管",
      u8"仅能",
      u8"仅见",
      u8"仅识之无",
      u8"仅足",
      u8"仅限",
      u8"仅限于",
      u8"仅靠",
      u8"仆人",
      u8"仆仆亟拜",
      u8"仆仆道途",
      u8"仆仆风尘",
      u8"仆从",
      u8"仆倒",
      u8"仆其",
      u8"仆参",
      u8"仆妇",
      u8"仆役",
      u8"仆隶",
      u8"仇云波",
      u8"仇人",
      u8"仇人相见",
      u8"仇人相见分外明白",
      u8"仇人相见分外眼明",
      u8"仇人相见分外眼睁",
      u8"仇人相见分外眼红",
      u8"仇人见面分外眼红",
      u8"仇家",
      u8"仇怨",
      u8"仇恨",
      u8"仇恶",
      u8"仇敌",
      u8"仇晓光",
      u8"仇杀",
      u8"仇松年",
      u8"仇者快",
      u8"仇视",
      u8"仇遇",
      u8"仇隙",
      u8"仇雪批复",
      u8"今不如昔",
      u8"今世",
      u8"今人",
      u8"今何在",
      u8"今儿",
      u8"今儿个",
      u8"今冬",
      u8"今冬明春",
      u8"今华",
      u8"今古传奇",
      u8"今古奇观",
      u8"今古奇闻",
      u8"今名",
      u8"今后",
      u8"今后任务",
      u8"今后工作",
      u8"今周",
      u8"今夏",
      u8"今夕",
      u8"今夕何夕",
      u8"今夜",
      u8"今天",
      u8"今天上午",
      u8"今天下午",
      u8"今天会",
      u8"今天在",
      u8"今天天气",
      u8"今天是",
      u8"今天有",
      u8"今天能",
      u8"今天非",
      u8"今宵",
      u8"今岁",
      u8"今年",
      u8"今年以来",
      u8"今年内",
      u8"今年冬天",
      u8"今年初",
      u8"今年夏天",
      u8"今年头",
      u8"今年年初",
      u8"今年年底",
      u8"今年底",
      u8"今年春节",
      u8"今年过年",
      u8"今愁古恨",
      u8"今文",
      u8"今文学",
      u8"今文经学",
      u8"今日",
      u8"今日世界",
      u8"今日事",
      u8"今日报价",
      u8"今日有酒今日醉",
      u8"今日毕",
      u8"今日热点",
      u8"今日焦点",
      u8"今日要闻",
      u8"今日说法",
      u8"今时不同往日",
      u8"今明",
      u8"今明两天",
      u8"今明两年",
      u8"今昔",
      u8"今昔之感",
      u8"今昔对比",
      u8"今春",
      u8"今是",
      u8"今是昔非",
      u8"今是昨非",
      u8"今晚",
      u8"今晚上",
      u8"今晚报",
      u8"今晨",
      u8"今景宗久",
      u8"今月古月",
      u8"今朝",
      u8"今朝有酒",
      u8"今朝有酒今朝醉",
      u8"今期",
      u8"今来古往",
      u8"今次",
      u8"今欣",
      u8"今生",
      u8"今生今世",
      u8"今生缘",
      u8"今番",
      u8"今秋",
      u8"今胜如昔",
      u8"今艺",
      u8"今草",
      u8"今蝉蜕壳",
      u8"今视网",
      u8"今译",
      u8"今起",
      u8"今雨新知",
      u8"今非夕比",
      u8"今非昔比",
      u8"今音",
      u8"今题网",
      u8"介乎",
      u8"介于",
      u8"介休",
      u8"介休县",
      u8"介休市",
      u8"介入",
      u8"介召",
      u8"介在",
      u8"介壳",
      u8"介子",
      u8"介导",
      u8"介寿",
      u8"介怀",
      u8"介意",
      u8"介杆",
      u8"介电常数",
      u8"介电强度",
      u8"介电效应",
      u8"介系词",
      u8"介绍",
      u8"介绍书",
      u8"介绍人",
      u8"介绍信",
      u8"介绍出来",
      u8"介绍性",
      u8"介绍所",
      u8"介绍费",
      u8"介胄",
      u8"介虫",
      u8"介词",
      u8"介质",
      u8"介质击穿",
      u8"介质天线",
      u8"介质弛豫",
      u8"介质波导",
      u8"介质隔离",
      u8"介面",
      u8"介面卡",
      u8"介音",
      u8"仍不",
      u8"仍与",
      u8"仍以",
      u8"仍会",
      u8"仍停留",
      u8"仍到",
      u8"仍去",
      u8"仍可",
      u8"仍在",
      u8"仍将",
      u8"仍应",
      u8"仍按",
      u8"仍旧",
      u8"仍旧会",
      u8"仍旧在",
      u8"仍旧是",
      u8"仍旧有",
      u8"仍是",
      u8"仍有",
      u8"仍未",
      u8"仍来",
      u8"仍然",
      u8"仍然会",
      u8"仍然在",
      u8"仍然是",
      u8"仍照",
      u8"仍用",
      u8"仍由",
      u8"仍称",
      u8"仍系",
      u8"仍能",
      u8"仍要",
      u8"仍陋袭简",
      u8"仍需",
      u8"仍须",
      u8"仍须努力",
      u8"从一",
      u8"从一而终",
      u8"从上",
      u8"从上到下",
      u8"从上向下",
      u8"从下",
      u8"从下到上",
      u8"从下向上",
      u8"从不",
      u8"从不中",
      u8"从不在",
      u8"从不敢",
      u8"从不间断",
      u8"从业",
      u8"从业人员",
      u8"从业员",
      u8"从业者",
      u8"从东向西",
      u8"从东方升起",
      u8"从严",
      u8"从严办理",
      u8"从严处理",
      u8"从严治党",
      u8"从严治检",
      u8"从中",
      u8"从中作梗",
      u8"从中取利",
      u8"从中央到地方",
      u8"从中渔利",
      u8"从书",
      u8"从事",
      u8"从事于",
      u8"从事贸易",
      u8"从五开始",
      u8"从井救人",
      u8"从今",
      u8"从今以后",
      u8"从今天",
      u8"从今天开始",
      u8"从今天起",
      u8"从今年起",
      u8"从今开始",
      u8"从今往后",
      u8"从从容容",
      u8"从令如流",
      u8"从价税",
      u8"从众",
      u8"从优",
      u8"从优办理",
      u8"从低",
      u8"从何",
      u8"从何下手",
      u8"从何寻",
      u8"从何而来",
      u8"从何说起",
      u8"从俗",
      u8"从俗就简",
      u8"从俗浮沉",
      u8"从债",
      u8"从兄",
      u8"从兄弟",
      u8"从先",
      u8"从公",
      u8"从其所好",
      u8"从军",
      u8"从军报国",
      u8"从军行",
      u8"从军记",
      u8"从刑",
      u8"从到",
      u8"从前",
      u8"从前人",
      u8"从动",
      u8"从化",
      u8"从化县",
      u8"从化市",
      u8"从北向南",
      u8"从医",
      u8"从南到北",
      u8"从即日起",
      u8"从古以来",
      u8"从古到今",
      u8"从古至今",
      u8"从句",
      u8"从右到左",
      u8"从各个方面",
      u8"从命",
      u8"从商",
      u8"从善如流",
      u8"从善如登",
      u8"从善如登从恶如崩",
      u8"从善若流",
      u8"从堂兄弟",
      u8"从堂姐妹",
      u8"从壁上观",
      u8"从外到里",
      u8"从外向内",
      u8"从大处着眼",
      u8"从大局出发",
      u8"从天而下",
      u8"从天而降",
      u8"从头",
      u8"从头做起",
      u8"从头再来",
      u8"从头到尾",
      u8"从头到脚",
      u8"从头合成",
      u8"从头开始",
      u8"从头彻尾",
      u8"从头来",
      u8"从头来起",
      u8"从头测序",
      u8"从头至尾",
      u8"从头说起",
      u8"从头越",
      u8"从始至终",
      u8"从娃娃抓起",
      u8"从子",
      u8"从实",
      u8"从实招来",
      u8"从实际出发",
      u8"从实际情况出发",
      u8"从容",
      u8"从容不迫",
      u8"从容就义",
      u8"从容应对",
      u8"从容自如",
      u8"从容自若",
      u8"从宽",
      u8"从宽办理",
      u8"从宽发落",
      u8"从宽处理",
      u8"从小",
      u8"从小到大",
      u8"从小到老",
      u8"从小处着手",
      u8"从小就",
      u8"从属",
      u8"从属于",
      u8"从属关系",
      u8"从属性",
      u8"从属景观",
      u8"从工作出发",
      u8"从左到右",
      u8"从左往右",
      u8"从师",
      u8"从征",
      u8"从心所欲",
      u8"从快",
      u8"从总体上",
      u8"从恶如崩",
      u8"从恶是崩",
      u8"从恶若崩",
      u8"从戎",
      u8"从我做起",
      u8"从打",
      u8"从技术上",
      u8"从政",
      u8"从教",
      u8"从新",
      u8"从旁",
      u8"从旁协助",
      u8"从旁观看",
      u8"从无",
      u8"从无到有",
      u8"从早",
      u8"从早到晚",
      u8"从明年起",
      u8"从有到无",
      u8"从未",
      u8"从未在",
      u8"从未有",
      u8"从未有过",
      u8"从未能",
      u8"从未见过",
      u8"从权",
      u8"从来",
      u8"从来不",
      u8"从来如此",
      u8"从来未",
      u8"从来未有",
      u8"从来没",
      u8"从来没有",
      u8"从来没有过",
      u8"从某种意义上",
      u8"从某种程度上",
      u8"从根本上",
      u8"从此",
      u8"从此以后",
      u8"从母",
      u8"从江",
      u8"从江县",
      u8"从没",
      u8"从没有",
      u8"从流忘反",
      u8"从父",
      u8"从犯",
      u8"从现在做起",
      u8"从现在开始",
      u8"从现在起",
      u8"从生到死",
      u8"从略",
      u8"从盘",
      u8"从简",
      u8"从紧",
      u8"从缓",
      u8"从缺",
      u8"从群众中来",
      u8"从而",
      u8"从自己做起",
      u8"从良",
      u8"从艺",
      u8"从葬",
      u8"从表面上看",
      u8"从西向东",
      u8"从警",
      u8"从谏如流",
      u8"从起",
      u8"从轮",
      u8"从轻",
      u8"从轻发落",
      u8"从轻处理",
      u8"从这",
      u8"从这一点",
      u8"从这个意义上",
      u8"从这个角度上",
      u8"从这以后",
      u8"从这时起",
      u8"从速",
      u8"从那",
      u8"从那之后",
      u8"从那以后",
      u8"从那时起",
      u8"从里到外",
      u8"从里向外",
      u8"从重",
      u8"从重从快",
      u8"从重处理",
      u8"从长商议",
      u8"从长计议",
      u8"从长计较",
      u8"从长远来看",
      u8"从长远看",
      u8"从难从严",
      u8"从零开始",
      u8"从革命利益出发",
      u8"从领导做起",
      u8"从风",
      u8"从风而服",
      u8"从风而靡",
      u8"从高",
      u8"仑背",
      u8"仓促",
      u8"仓促从事",
      u8"仓促应战",
      u8"仓促间",
      u8"仓储",
      u8"仓储业",
      u8"仓储式",
      u8"仓储笼",
      u8"仓卒",
      u8"仓卒主人",
      u8"仓卒之际",
      u8"仓单",
      u8"仓容",
      u8"仓山",
      u8"仓山区",
      u8"仓州",
      u8"仓库",
      u8"仓库业",
      u8"仓库管理员",
      u8"仓库货架",
      u8"仓廒",
      u8"仓廪",
      u8"仓廪充实",
      u8"仓惶",
      u8"仓房",
      u8"仓木麻衣",
      u8"仓海桑田",
      u8"仓满库盈",
      u8"仓猝",
      u8"仓田保昭",
      u8"仓皇",
      u8"仓皇出逃",
      u8"仓皇失措",
      u8"仓皇无措",
      u8"仓盈粮丰",
      u8"仓管员",
      u8"仓管处",
      u8"仓颉",
      u8"仓颉输入",
      u8"仓颉输入法",
      u8"仓鼠",
      u8"仔仔",
      u8"仔仔细细",
      u8"仔密",
      u8"仔服",
      u8"仔母牛",
      u8"仔猪",
      u8"仔畜",
      u8"仔禽",
      u8"仔细",
      u8"仔细分析",
      u8"仔细听",
      u8"仔细听讲",
      u8"仔细想",
      u8"仔细搜索",
      u8"仔细检查",
      u8"仔细看",
      u8"仔细观察",
      u8"仔细观看",
      u8"仔细观赏",
      u8"仔细认真",
      u8"仔细阅读",
      u8"仔肩",
      u8"仔鱼",
      u8"仔鸡",
      u8"仕奇",
      u8"仕女",
      u8"仕女图",
      u8"仕女画",
      u8"仕官",
      u8"仕宦",
      u8"仕进",
      u8"仕途",
      u8"他乡",
      u8"他乡人",
      u8"他乡异县",
      u8"他乡故知",
      u8"他乡遇故知",
      u8"他人",
      u8"他们",
      u8"他俩",
      u8"他因",
      u8"他国",
      u8"他处",
      u8"他妈的",
      u8"他家",
      u8"他山之石",
      u8"他山之石可以攻玉",
      u8"他山攻错",
      u8"他山石",
      u8"他律",
      u8"他指",
      u8"他方",
      u8"他日",
      u8"他用",
      u8"他项权证",
      u8"仗义",
      u8"仗义执言",
      u8"仗义疏财",
      u8"仗助",
      u8"仗势",
      u8"仗势凌人",
      u8"仗势欺人",
      u8"仗恃",
      u8"仗持",
      u8"仗持着",
      u8"仗气使酒",
      u8"仗着",
      u8"仗胆",
      u8"仗马寒蝉",
      u8"付上",
      u8"付下",
      u8"付下去",
      u8"付与",
      u8"付丙",
      u8"付之一叹",
      u8"付之一炬",
      u8"付之一笑",
      u8"付之丙丁",
      u8"付之东流",
      u8"付之度外",
      u8"付之梨枣",
      u8"付之流水",
      u8"付了",
      u8"付予",
      u8"付交",
      u8"付产",
      u8"付价",
      u8"付凯",
      u8"付凯家",
      u8"付出",
      u8"付出代价",
      u8"付出劳动",
      u8"付出总有回报",
      u8"付到",
      u8"付印",
      u8"付去",
      u8"付在",
      u8"付好",
      u8"付完即止",
      u8"付定金",
      u8"付帐",
      u8"付强",
      u8"付彪",
      u8"付得",
      u8"付息",
      u8"付托",
      u8"付托重任",
      u8"付掉",
      u8"付排",
      u8"付方",
      u8"付晶",
      u8"付有",
      u8"付来",
      u8"付梓",
      u8"付款",
      u8"付款人",
      u8"付款单",
      u8"付款处",
      u8"付款日",
      u8"付款条件",
      u8"付汇",
      u8"付汇联",
      u8"付清",
      u8"付点",
      u8"付现",
      u8"付现金",
      u8"付琼",
      u8"付瑞成",
      u8"付瑞灿",
      u8"付着",
      u8"付给",
      u8"付艺伟",
      u8"付讫",
      u8"付诸",
      u8"付诸一炬",
      u8"付诸一笑",
      u8"付诸东流",
      u8"付诸实施",
      u8"付诸实行",
      u8"付诸实践",
      u8"付诸洪乔",
      u8"付诸流水",
      u8"付诸行动",
      u8"付账",
      u8"付费",
      u8"付费者",
      u8"付起",
      u8"付足",
      u8"付过",
      u8"付还",
      u8"付邮",
      u8"付酬",
      u8"付酬制度",
      u8"付钱",
      u8"仙丹",
      u8"仙乐",
      u8"仙乡",
      u8"仙人",
      u8"仙人指路",
      u8"仙人掌",
      u8"仙人掌果",
      u8"仙人桥",
      u8"仙人洞",
      u8"仙人球",
      u8"仙人跳",
      u8"仙人鞭",
      u8"仙仙琼阁",
      u8"仙侣",
      u8"仙儿",
      u8"仙凡道",
      u8"仙剑",
      u8"仙剑三",
      u8"仙剑奇",
      u8"仙剑奇侠传",
      u8"仙台",
      u8"仙台病毒",
      u8"仙后座",
      u8"仙境",
      u8"仙女",
      u8"仙女下凡",
      u8"仙女们",
      u8"仙女山",
      u8"仙女座",
      u8"仙女湖",
      u8"仙妮蕾德",
      u8"仙姑",
      u8"仙姿佚貌",
      u8"仙姿玉色",
      u8"仙姿玉貌",
      u8"仙姿玉质",
      u8"仙子",
      u8"仙客来",
      u8"仙家",
      u8"仙尼亚",
      u8"仙居",
      u8"仙居县",
      u8"仙山",
      u8"仙山楼阁",
      u8"仙山琼客",
      u8"仙山琼阁",
      u8"仙岩",
      u8"仙岳",
      u8"仙师",
      u8"仙府",
      u8"仙术",
      u8"仙果",
      u8"仙桃",
      u8"仙桃市",
      u8"仙桃草",
      u8"仙水",
      u8"仙液琼浆",
      u8"仙游",
      u8"仙游县",
      u8"仙湖",
      u8"仙灵脾",
      u8"仙王座",
      u8"仙界",
      u8"仙童",
      u8"仙翁",
      u8"仙花",
      u8"仙茅",
      u8"仙草",
      u8"仙药",
      u8"仙踪",
      u8"仙逝",
      u8"仙道彰",
      u8"仙都",
      u8"仙阁里",
      u8"仙霞路",
      u8"仙露明珠",
      u8"仙风道格",
      u8"仙风道气",
      u8"仙风道骨",
      u8"仙魔录",
      u8"仙鹤",
      u8"仙鹤草",
      u8"仟克",
      u8"仟村",
      u8"仟胞",
      u8"仡佬",
      u8"仡佬族",
      u8"代与",
      u8"代为",
      u8"代为说项",
      u8"代主席",
      u8"代之以",
      u8"代书",
      u8"代书事务所",
      u8"代乳粉",
      u8"代交",
      u8"代人",
      u8"代人受过",
      u8"代人捉刀",
      u8"代人说项",
      u8"代付款",
      u8"代代",
      u8"代代传",
      u8"代代相传",
      u8"代代相承",
      u8"代代红",
      u8"代件",
      u8"代价",
      u8"代位",
      u8"代位权",
      u8"代位继承",
      u8"代偿",
      u8"代入",
      u8"代入消元法",
      u8"代写",
      u8"代出",
      u8"代办",
      u8"代办处",
      u8"代办所",
      u8"代办点",
      u8"代办费",
      u8"代加工",
      u8"代劳",
      u8"代卫留成",
      u8"代县",
      u8"代县长",
      u8"代发",
      u8"代取",
      u8"代号",
      u8"代名",
      u8"代名词",
      u8"代售",
      u8"代售处",
      u8"代售点",
      u8"代唱",
      u8"代唱者",
      u8"代型",
      u8"代垫",
      u8"代培",
      u8"代培生",
      u8"代夫",
      u8"代子",
      u8"代孕网",
      u8"代工",
      u8"代工厂",
      u8"代币",
      u8"代币券",
      u8"代市长",
      u8"代序",
      u8"代庖",
      u8"代建制",
      u8"代录",
      u8"代征",
      u8"代总理",
      u8"代总统",
      u8"代打",
      u8"代打者",
      u8"代扣代缴",
      u8"代拆代行",
      u8"代换",
      u8"代换品",
      u8"代换性质",
      u8"代收",
      u8"代收款",
      u8"代数",
      u8"代数和",
      u8"代数学",
      u8"代数式",
      u8"代数数域",
      u8"代数整数环",
      u8"代数方程",
      u8"代数根",
      u8"代数闭域",
      u8"代数集",
      u8"代替",
      u8"代替人",
      u8"代替品",
      u8"代查",
      u8"代步",
      u8"代步车",
      u8"代母",
      u8"代沟",
      u8"代演",
      u8"代点",
      u8"代父",
      u8"代理",
      u8"代理中心",
      u8"代理人",
      u8"代理会",
      u8"代理制",
      u8"代理商",
      u8"代理地",
      u8"代理处",
      u8"代理官",
      u8"代理店",
      u8"代理律师",
      u8"代理服务器",
      u8"代理权",
      u8"代理行",
      u8"代理词",
      u8"代理费",
      u8"代理配送制",
      u8"代用",
      u8"代用品",
      u8"代电",
      u8"代省长",
      u8"代码",
      u8"代码扩充",
      u8"代码移动",
      u8"代码证",
      u8"代码转换器",
      u8"代租",
      u8"代称",
      u8"代笔",
      u8"代签",
      u8"代签人",
      u8"代管",
      u8"代管人",
      u8"代罪羔羊",
      u8"代耕",
      u8"代聊",
      u8"代职",
      u8"代脉",
      u8"代行",
      u8"代表",
      u8"代表人",
      u8"代表人物",
      u8"代表会",
      u8"代表会议",
      u8"代表作",
      u8"代表团",
      u8"代表团成员",
      u8"代表处",
      u8"代表大会",
      u8"代表性",
      u8"代表权",
      u8"代表队",
      u8"代表院",
      u8"代言",
      u8"代言人",
      u8"代订",
      u8"代议",
      u8"代议制",
      u8"代议政治",
      u8"代词",
      u8"代课",
      u8"代课老师",
      u8"代谢",
      u8"代谢作用",
      u8"代谢共栖",
      u8"代谢区室",
      u8"代谢工程",
      u8"代谢期",
      u8"代谢物",
      u8"代谢率",
      u8"代谢能",
      u8"代购",
      u8"代赭石",
      u8"代越庖俎",
      u8"代跑",
      u8"代跑员",
      u8"代跑者",
      u8"代部长",
      u8"代金",
      u8"代金券",
      u8"代销",
      u8"代销商",
      u8"代销店",
      u8"代销点",
      u8"代际",
      u8"代顿",
      u8"代领",
      u8"代马依风",
      u8"代马望北",
      u8"令不虚行",
      u8"令严",
      u8"令亲",
      u8"令人",
      u8"令人不安",
      u8"令人作呕",
      u8"令人信服",
      u8"令人兴奋",
      u8"令人切齿",
      u8"令人厌倦",
      u8"令人厌恶",
      u8"令人发指",
      u8"令人叹服",
      u8"令人吃惊",
      u8"令人同情",
      u8"令人咋舌",
      u8"令人喷饭",
      u8"令人困倦",
      u8"令人困惑",
      u8"令人堪忧",
      u8"令人寒心",
      u8"令人尊敬",
      u8"令人心寒",
      u8"令人心悸",
      u8"令人心醉",
      u8"令人忧伤",
      u8"令人恐怖",
      u8"令人恶心",
      u8"令人恼火",
      u8"令人惊叹",
      u8"令人惊骇",
      u8"令人感动",
      u8"令人担忧",
      u8"令人振奋",
      u8"令人捧腹",
      u8"令人敬畏",
      u8"令人昏眩",
      u8"令人欣慰",
      u8"令人气恼",
      u8"令人气愤",
      u8"令人气结",
      u8"令人注目",
      u8"令人深思",
      u8"令人满意",
      u8"令人激动",
      u8"令人烦恼",
      u8"令人焦虑",
      u8"令人生厌",
      u8"令人生畏",
      u8"令人疲倦",
      u8"令人瞠目",
      u8"令人瞩目",
      u8"令人神往",
      u8"令人窒息",
      u8"令人羡慕",
      u8"令人莫测",
      u8"令人讨厌",
      u8"令人费解",
      u8"令人起敬",
      u8"令人遗憾",
      u8"令人钦佩",
      u8"令人难以置信",
      u8"令人难忘",
      u8"令人震惊",
      u8"令人高兴",
      u8"令人鼓舞",
      u8"令人齿冷",
      u8"令他",
      u8"令你",
      u8"令兄",
      u8"令其",
      u8"令出如山",
      u8"令原之戚",
      u8"令友",
      u8"令叔",
      u8"令名",
      u8"令坦",
      u8"令堂",
      u8"令她",
      u8"令妹",
      u8"令姊",
      u8"令媛",
      u8"令嫒",
      u8"令孙",
      u8"令尊",
      u8"令尊大人",
      u8"令岳",
      u8"令师",
      u8"令弟",
      u8"令徒",
      u8"令您",
      u8"令慈",
      u8"令我",
      u8"令旗",
      u8"令望",
      u8"令正",
      u8"令爱",
      u8"令牌",
      u8"令牌环",
      u8"令状",
      u8"令狐",
      u8"令狐冲",
      u8"令狐绝",
      u8"令瑗",
      u8"令甥",
      u8"令祖",
      u8"令箭",
      u8"令箭荷花",
      u8"令节",
      u8"令行",
      u8"令行如流",
      u8"令行禁止",
      u8"令誉",
      u8"令郎",
      u8"令郞",
      u8"令酒",
      u8"令闻",
      u8"以一儆百",
      u8"以一击十",
      u8"以一奉百",
      u8"以一当十",
      u8"以一持万",
      u8"以一知万",
      u8"以一警百",
      u8"以上",
      u8"以上几个方面",
      u8"以上学历",
      u8"以上干部",
      u8"以上者",
      u8"以下",
      u8"以下内容",
      u8"以下几点",
      u8"以下犯上",
      u8"以不变应",
      u8"以不变应万变",
      u8"以不济可",
      u8"以东",
      u8"以丰补歉",
      u8"以为",
      u8"以为会",
      u8"以为后图",
      u8"以为在",
      u8"以为是",
      u8"以久",
      u8"以义割恩",
      u8"以义断恩",
      u8"以书为御",
      u8"以事业为重",
      u8"以事实为依据",
      u8"以事实为根据",
      u8"以于",
      u8"以产定销",
      u8"以人为本",
      u8"以人为鉴",
      u8"以人为镜",
      u8"以人废言",
      u8"以人择官",
      u8"以众暴寡",
      u8"以优吃劣",
      u8"以伪乱真",
      u8"以佚待劳",
      u8"以作",
      u8"以使",
      u8"以例说明",
      u8"以供",
      u8"以便",
      u8"以候",
      u8"以候通知",
      u8"以假乱真",
      u8"以假充真",
      u8"以假谬真",
      u8"以偏概全",
      u8"以儆效尤",
      u8"以免",
      u8"以党举官",
      u8"以公有制为基础",
      u8"以公灭私",
      u8"以其",
      u8"以其人之道",
      u8"以其人之道还治其人之身",
      u8"以其人之道，还治其人之身",
      u8"以其昏昏",
      u8"以其昏昏使人昭昭",
      u8"以其真正形式付款",
      u8"以养伤身",
      u8"以内",
      u8"以军",
      u8"以农立国",
      u8"以冠补履",
      u8"以冰止蝇",
      u8"以冰致蝇",
      u8"以刑去刑",
      u8"以刑止刑",
      u8"以刑致刑",
      u8"以利",
      u8"以利于",
      u8"以利再战",
      u8"以利累形",
      u8"以前",
      u8"以前年度",
      u8"以力服人",
      u8"以功补过",
      u8"以功覆过",
      u8"以功赎罪",
      u8"以劣充优",
      u8"以劣胜优",
      u8"以势压人",
      u8"以勤补拙",
      u8"以北",
      u8"以升量石",
      u8"以半击倍",
      u8"以南",
      u8"以博欢心",
      u8"以卵击石",
      u8"以卵投石",
      u8"以卵敌石",
      u8"以厂为家",
      u8"以及",
      u8"以及人之老",
      u8"以及对",
      u8"以叔援嫂",
      u8"以口问心",
      u8"以古为鉴",
      u8"以古为镜",
      u8"以古况今",
      u8"以古制今",
      u8"以古喻今",
      u8"以古方今",
      u8"以古非今",
      u8"以史为鉴",
      u8"以右",
      u8"以后",
      u8"以后见",
      u8"以后鬼",
      u8"以售其奸",
      u8"以商养文",
      u8"以噎废飡",
      u8"以噎废餐",
      u8"以土地换和平",
      u8"以壮行色",
      u8"以备",
      u8"以备不时",
      u8"以备不时之需",
      u8"以外",
      u8"以多胜少",
      u8"以夜继日",
      u8"以夜继昼",
      u8"以夜继朝",
      u8"以夜续昼",
      u8"以大局为重",
      u8"以大恶细",
      u8"以天下为己任",
      u8"以太",
      u8"以太网",
      u8"以太网卡",
      u8"以太风",
      u8"以失败而告终",
      u8"以夷伐夷",
      u8"以夷制夷",
      u8"以夷攻夷",
      u8"以夷治夷",
      u8"以子之矛",
      u8"以学愈愚",
      u8"以守为攻",
      u8"以定",
      u8"以实物付款",
      u8"以宫笑角",
      u8"以容取人",
      u8"以寡击众",
      u8"以寡敌众",
      u8"以对",
      u8"以小人之心",
      u8"以小人之心度君子之腹",
      u8"以小见大",
      u8"以少胜多",
      u8"以屈求伸",
      u8"以岗定薪",
      u8"以工代干",
      u8"以工代赈",
      u8"以工补农",
      u8"以左",
      u8"以己之心度人之心",
      u8"以己之心度人之腹",
      u8"以己度人",
      u8"以已度人",
      u8"以弱制强",
      u8"以弱胜强",
      u8"以强凌弱",
      u8"以强胜弱",
      u8"以往",
      u8"以往鉴来",
      u8"以待",
      u8"以微知着",
      u8"以微知著",
      u8"以德取人",
      u8"以德报德",
      u8"以德报怨",
      u8"以德服人",
      u8"以德育人",
      u8"以德追祸",
      u8"以心传心",
      u8"以心问心",
      u8"以忍为阍",
      u8"以快先睹",
      u8"以怨报德",
      u8"以恶报恶",
      u8"以情",
      u8"以情感人",
      u8"以意为之",
      u8"以意逆志",
      u8"以慎为键",
      u8"以戈舂黍",
      u8"以成败论英雄",
      u8"以我",
      u8"以战养战",
      u8"以战去战",
      u8"以手加额",
      u8"以执代审",
      u8"以拖待变",
      u8"以指挠沸",
      u8"以指测河",
      u8"以提高经济效益为中心",
      u8"以攻为守",
      u8"以政代企",
      u8"以故",
      u8"以文乱法",
      u8"以文会友",
      u8"以文害辞",
      u8"以方",
      u8"以日为年",
      u8"以日继夜",
      u8"以旧换新",
      u8"以旧翻新",
      u8"以是",
      u8"以晚",
      u8"以智取胜",
      u8"以暴制暴",
      u8"以暴易暴",
      u8"以暴治暴",
      u8"以月",
      u8"以期",
      u8"以杀去杀",
      u8"以杀止杀",
      u8"以权代法",
      u8"以权谋私",
      u8"以权达变",
      u8"以来",
      u8"以柔克刚",
      u8"以柔制刚",
      u8"以桃代李",
      u8"以案释法",
      u8"以次",
      u8"以次充好",
      u8"以正视听",
      u8"以此",
      u8"以此为准",
      u8"以此为基础",
      u8"以此为戒",
      u8"以此为根据",
      u8"以此为由",
      u8"以此为荣",
      u8"以此为证",
      u8"以此为限",
      u8"以此来",
      u8"以此类推",
      u8"以毁为罚",
      u8"以毒攻毒",
      u8"以毛相马",
      u8"以水投水",
      u8"以水投石",
      u8"以水救水",
      u8"以水洗血",
      u8"以水济水",
      u8"以求",
      u8"以求一逞",
      u8"以汤止沸",
      u8"以汤沃沸",
      u8"以汤沃雪",
      u8"以沫相濡",
      u8"以法",
      u8"以法为教",
      u8"以法律为准绳",
      u8"以法治税",
      u8"以泪洗面",
      u8"以泽量尸",
      u8"以渴服马",
      u8"以火去蛾",
      u8"以火救火",
      u8"以火止沸",
      u8"以点带面",
      u8"以煎止燔",
      u8"以父之名",
      u8"以牙还牙",
      u8"以狸至鼠",
      u8"以狸致鼠、以冰致绳",
      u8"以狸饵鼠",
      u8"以玉抵乌",
      u8"以玉抵鹊",
      u8"以珠弹雀",
      u8"以理服人",
      u8"以疏间亲",
      u8"以疑决疑",
      u8"以白为黑",
      u8"以白诋青",
      u8"以直报怨",
      u8"以直抱怨",
      u8"以眼还眼",
      u8"以眼还眼以牙还牙",
      u8"以瞽引瞽",
      u8"以石投卵",
      u8"以石投水",
      u8"以碫投卵",
      u8"以示",
      u8"以示公允",
      u8"以示公平",
      u8"以礼相待",
      u8"以私害公",
      u8"以私废公",
      u8"以税代利",
      u8"以筌为鱼",
      u8"以策",
      u8"以策安全",
      u8"以筦窥天",
      u8"以简御繁",
      u8"以简驭繁",
      u8"以管窥天",
      u8"以管窥豹",
      u8"以索续组",
      u8"以紫为朱",
      u8"以紫乱朱",
      u8"以终天年",
      u8"以经济建设为中心",
      u8"以绝后患",
      u8"以网",
      u8"以罚代刑",
      u8"以羊易牛",
      u8"以老卖老",
      u8"以耳为目",
      u8"以耳代目",
      u8"以职谋私",
      u8"以肉去蚁",
      u8"以肉啖虎",
      u8"以肉喂虎",
      u8"以肉餧虎",
      u8"以肉驱蝇",
      u8"以胜利而告终",
      u8"以胶投漆",
      u8"以至",
      u8"以至于",
      u8"以致",
      u8"以致于",
      u8"以色列",
      u8"以色列人",
      u8"以色谋财",
      u8"以苦为乐",
      u8"以苦为荣",
      u8"以荷析薪",
      u8"以莛叩钟",
      u8"以莛扣钟",
      u8"以莛撞钟",
      u8"以蚓投鱼",
      u8"以螳当车",
      u8"以蠡测海",
      u8"以血偿血",
      u8"以血洗血",
      u8"以血还血",
      u8"以西",
      u8"以见一斑",
      u8"以观后效",
      u8"以规为瑱",
      u8"以言为讳",
      u8"以言举人",
      u8"以言代法",
      u8"以言取人",
      u8"以言废人",
      u8"以言徇物",
      u8"以誉为赏",
      u8"以誉进能",
      u8"以计代战",
      u8"以讹传讹",
      u8"以讹化讹",
      u8"以词定字",
      u8"以词害意",
      u8"以诚待人",
      u8"以诚相待",
      u8"以诚相见",
      u8"以话引话",
      u8"以误传误",
      u8"以貌取人",
      u8"以貍至鼠",
      u8"以货易货",
      u8"以贷还贷",
      u8"以资",
      u8"以资抵债",
      u8"以资抵贷",
      u8"以资鼓励",
      u8"以身",
      u8"以身作则",
      u8"以身报国",
      u8"以身殉国",
      u8"以身殉职",
      u8"以身相许",
      u8"以身许国",
      u8"以身试法",
      u8"以身试险",
      u8"以辞取人",
      u8"以辞害意",
      u8"以迅雷不及掩耳之势",
      u8"以近",
      u8"以还",
      u8"以进为退",
      u8"以进养出",
      u8"以远",
      u8"以退为进",
      u8"以逸击劳",
      u8"以逸待劳",
      u8"以避",
      u8"以邮戳日期为准",
      u8"以邻为壑",
      u8"以郄视文",
      u8"以酒解酲",
      u8"以铢称镒",
      u8"以铢程镒",
      u8"以销定产",
      u8"以锥刺地",
      u8"以锥飡壸",
      u8"以锥餐壶",
      u8"以键",
      u8"以镒称铢",
      u8"以闻其声",
      u8"以防",
      u8"以防万一",
      u8"以防不测",
      u8"以降",
      u8"以飨",
      u8"以飨读者",
      u8"以马内利",
      u8"以骨去蚁",
      u8"以鱼驱蝇",
      u8"以鹿为马",
      u8"以黑为白",
      u8"仪仗",
      u8"仪仗队",
      u8"仪刑",
      u8"仪制",
      u8"仪化",
      u8"仪和",
      u8"仪器",
      u8"仪器仪表",
      u8"仪器仪表厂",
      u8"仪器厂",
      u8"仪器接口",
      u8"仪器网",
      u8"仪器设备",
      u8"仪型",
      u8"仪容",
      u8"仪容俊秀",
      u8"仪容检查",
      u8"仪巴达特",
      u8"仪式",
      u8"仪征",
      u8"仪征市",
      u8"仪态",
      u8"仪态万千",
      u8"仪态万方",
      u8"仪清",
      u8"仪琳",
      u8"仪礼",
      u8"仪节",
      u8"仪表",
      u8"仪表仪器",
      u8"仪表出众",
      u8"仪表厂",
      u8"仪表堂堂",
      u8"仪表板",
      u8"仪表盘",
      u8"仪表网",
      u8"仪表舱",
      u8"仪表阀门",
      u8"仪表非凡",
      u8"仪观",
      u8"仪轨",
      u8"仪队",
      u8"仪陇",
      u8"仪陇县",
      u8"仪静体闲",
      u8"仫佬族",
      u8"仰不愧天",
      u8"仰之弥高",
      u8"仰事俛畜",
      u8"仰事俯畜",
      u8"仰事俯育",
      u8"仰人眉睫",
      u8"仰人鼻息",
      u8"仰仗",
      u8"仰仗着",
      u8"仰光",
      u8"仰八叉",
      u8"仰冲",
      u8"仰卧",
      u8"仰卧位",
      u8"仰卧起坐",
      u8"仰取俯拾",
      u8"仰天",
      u8"仰天一望",
      u8"仰天大笑",
      u8"仰天湖",
      u8"仰天长叹",
      u8"仰天长啸",
      u8"仰头",
      u8"仰头一看",
      u8"仰屋着书",
      u8"仰屋窃叹",
      u8"仰屋著书",
      u8"仰式",
      u8"仰德大道",
      u8"仰慕",
      u8"仰慕者",
      u8"仰承",
      u8"仰拾俯取",
      u8"仰望",
      u8"仰止",
      u8"仰泳",
      u8"仰看",
      u8"仰看着",
      u8"仰着",
      u8"仰给",
      u8"仰脖",
      u8"仰观",
      u8"仰观俯察",
      u8"仰视",
      u8"仰角",
      u8"仰赖",
      u8"仰赖着",
      u8"仰起",
      u8"仰躺着",
      u8"仰靠",
      u8"仰靠着",
      u8"仰面",
      u8"仰面唾天",
      u8"仰面朝天",
      u8"仰韶",
      u8"仰韶文化",
      u8"仰首",
      u8"仰首伸眉",
      u8"仰高",
      u8"仲丁醇",
      u8"仲介",
      u8"仲介公司",
      u8"仲代达矢",
      u8"仲伯",
      u8"仲伯难分",
      u8"仲兄",
      u8"仲冬",
      u8"仲吕",
      u8"仲唾液蛋白",
      u8"仲夏",
      u8"仲夏夜",
      u8"仲夏夜之梦",
      u8"仲孙",
      u8"仲家",
      u8"仲尼",
      u8"仲巴",
      u8"仲巴县",
      u8"仲弟",
      u8"仲星火",
      u8"仲春",
      u8"仲氢",
      u8"仲秋",
      u8"仲裁",
      u8"仲裁书",
      u8"仲裁人",
      u8"仲裁员",
      u8"仲裁委",
      u8"仲裁委员会",
      u8"仲裁庭",
      u8"仲裁方",
      u8"仲裁条款",
      u8"仲裁法",
      u8"仲裁者",
      u8"仲间",
      u8"仲间由纪惠",
      u8"仳向",
      u8"仳离",
      u8"仵作",
      u8"件事",
      u8"件头",
      u8"件套",
      u8"件数",
      u8"件次",
      u8"价互变异构",
      u8"价位",
      u8"价低",
      u8"价值",
      u8"价值体系",
      u8"价值千金",
      u8"价值学",
      u8"价值尺度",
      u8"价值形式",
      u8"价值观",
      u8"价值观念",
      u8"价值规律",
      u8"价值论",
      u8"价值连城",
      u8"价值量",
      u8"价值链",
      u8"价内",
      u8"价单",
      u8"价增一顾",
      u8"价外",
      u8"价差",
      u8"价带",
      u8"价廉",
      u8"价廉物美",
      u8"价态起伏",
      u8"价标",
      u8"价格",
      u8"价格上涨",
      u8"价格下降",
      u8"价格不菲",
      u8"价格优势",
      u8"价格低廉",
      u8"价格体系",
      u8"价格便宜",
      u8"价格公道",
      u8"价格冻结",
      u8"价格合理",
      u8"价格战",
      u8"价格指数",
      u8"价格控制",
      u8"价格改革",
      u8"价格政策",
      u8"价格昂贵",
      u8"价格比",
      u8"价格法",
      u8"价格研究中心",
      u8"价格竞争",
      u8"价格管理",
      u8"价格网",
      u8"价格行情",
      u8"价格表",
      u8"价款",
      u8"价率",
      u8"价电子",
      u8"价目",
      u8"价目单",
      u8"价目表",
      u8"价码",
      u8"价码儿",
      u8"价等连城",
      u8"价费字",
      u8"价轻字",
      u8"价重字",
      u8"价金",
      u8"价钱",
      u8"价钱便宜量又足",
      u8"价额",
      u8"价高",
      u8"任一",
      u8"任丘",
      u8"任丘人",
      u8"任丘市",
      u8"任为",
      u8"任事",
      u8"任人",
      u8"任人为贤",
      u8"任人唯亲",
      u8"任人唯贤",
      u8"任人宰割",
      u8"任人惟亲",
      u8"任人摆布",
      u8"任从",
      u8"任伟",
      u8"任何",
      u8"任何一方",
      u8"任何东西",
      u8"任何事",
      u8"任何事情",
      u8"任何事物",
      u8"任何人",
      u8"任何借口",
      u8"任何关系",
      u8"任何原因",
      u8"任何地方",
      u8"任何情况",
      u8"任何时候",
      u8"任何时刻",
      u8"任何条件",
      u8"任何理由",
      u8"任何迹象",
      u8"任何问题",
      u8"任你",
      u8"任你拿",
      u8"任你挑",
      u8"任你玩",
      u8"任你选",
      u8"任你邮",
      u8"任侠",
      u8"任便",
      u8"任兄",
      u8"任克礼",
      u8"任免",
      u8"任免权",
      u8"任其",
      u8"任其发展",
      u8"任其自流",
      u8"任其自然",
      u8"任内",
      u8"任凭",
      u8"任凭风浪起",
      u8"任凭风浪起稳坐钓鱼船",
      u8"任务",
      u8"任务书",
      u8"任务分析",
      u8"任务分配",
      u8"任务在身",
      u8"任务栏",
      u8"任务模型",
      u8"任务管理程序",
      u8"任务艰巨",
      u8"任务说明",
      u8"任务重",
      u8"任务量",
      u8"任劳任怨",
      u8"任县",
      u8"任命",
      u8"任命书",
      u8"任命权",
      u8"任命状",
      u8"任命者",
      u8"任城区",
      u8"任天堂",
      u8"任家萱",
      u8"任建新",
      u8"任弼时",
      u8"任志刚",
      u8"任性",
      u8"任怨任劳",
      u8"任情",
      u8"任情率性",
      u8"任意",
      u8"任意单元法",
      u8"任意多边形",
      u8"任意子",
      u8"任意球",
      u8"任意键",
      u8"任意键应答",
      u8"任我",
      u8"任我游",
      u8"任我行",
      u8"任所",
      u8"任教",
      u8"任教于",
      u8"任教授",
      u8"任教者",
      u8"任有",
      u8"任期",
      u8"任期内",
      u8"任期制",
      u8"任期目标制",
      u8"任期目标责任制",
      u8"任民峰",
      u8"任气",
      u8"任汝芬",
      u8"任泉",
      u8"任泽芝",
      u8"任满",
      u8"任用",
      u8"任用干部",
      u8"任由",
      u8"任由摆布",
      u8"任盈盈",
      u8"任程伟",
      u8"任组长",
      u8"任职",
      u8"任职期间",
      u8"任脉",
      u8"任课",
      u8"任课教师",
      u8"任课老师",
      u8"任贤使能",
      u8"任贤齐",
      u8"任达不拘",
      u8"任达华",
      u8"任选",
      u8"任通武",
      u8"任重才轻",
      u8"任重而道远",
      u8"任重至远",
      u8"任重道悠",
      u8"任重道远",
      u8"任长霞",
      u8"任长风",
      u8"任飞燕",
      u8"份上",
      u8"份儿",
      u8"份儿饭",
      u8"份内份外",
      u8"份地",
      u8"份子",
      u8"份数",
      u8"份量",
      u8"份额",
      u8"份额油",
      u8"份饭",
      u8"仿佛",
      u8"仿冒",
      u8"仿冒品",
      u8"仿制",
      u8"仿制品",
      u8"仿制者",
      u8"仿办",
      u8"仿单",
      u8"仿古",
      u8"仿古砖",
      u8"仿字",
      u8"仿宋",
      u8"仿宋体",
      u8"仿射坐标",
      u8"仿射坐标环",
      u8"仿射概形",
      u8"仿射群",
      u8"仿射超平面",
      u8"仿建",
      u8"仿徨失措",
      u8"仿效",
      u8"仿照",
      u8"仿玛瑙",
      u8"仿生",
      u8"仿生学",
      u8"仿画",
      u8"仿皮",
      u8"仿盛大",
      u8"仿真",
      u8"仿真器",
      u8"仿真度",
      u8"仿真技术",
      u8"仿真枪",
      u8"仿真植物",
      u8"仿真线",
      u8"仿真花",
      u8"仿章",
      u8"仿红木",
      u8"仿纸",
      u8"仿绢",
      u8"仿羊绒",
      u8"仿行",
      u8"仿造",
      u8"仿造品",
      u8"企业",
      u8"企业主",
      u8"企业事业",
      u8"企业亏损",
      u8"企业会员",
      u8"企业会计",
      u8"企业伦理",
      u8"企业信息",
      u8"企业信息化",
      u8"企业信用",
      u8"企业信箱",
      u8"企业倒闭",
      u8"企业债券",
      u8"企业内部",
      u8"企业制度",
      u8"企业动态",
      u8"企业化",
      u8"企业单位",
      u8"企业博客",
      u8"企业发展",
      u8"企业名单",
      u8"企业名称",
      u8"企业基金",
      u8"企业处",
      u8"企业宗旨",
      u8"企业宣传",
      u8"企业家",
      u8"企业局",
      u8"企业库",
      u8"企业录",
      u8"企业形象",
      u8"企业性质",
      u8"企业战略",
      u8"企业所",
      u8"企业承包",
      u8"企业改革",
      u8"企业文化",
      u8"企业法",
      u8"企业法人",
      u8"企业版",
      u8"企业界",
      u8"企业目录",
      u8"企业破产",
      u8"企业社",
      u8"企业竞争力",
      u8"企业简介",
      u8"企业管理",
      u8"企业管理系",
      u8"企业管理者",
      u8"企业管理费",
      u8"企业类型",
      u8"企业精神",
      u8"企业级",
      u8"企业经济",
      u8"企业经营",
      u8"企业经营承包制",
      u8"企业经营者",
      u8"企业网",
      u8"企业职工",
      u8"企业自主权",
      u8"企业行",
      u8"企业规模",
      u8"企业财务",
      u8"企业资料",
      u8"企业资质",
      u8"企业过程再工程",
      u8"企业邮局",
      u8"企业邮箱",
      u8"企业间",
      u8"企业集团",
      u8"企业顾问",
      u8"企事业",
      u8"企事业单位",
      u8"企仰",
      u8"企信通",
      u8"企划",
      u8"企划书",
      u8"企划人",
      u8"企划厅",
      u8"企划案",
      u8"企划组织",
      u8"企划部",
      u8"企及",
      u8"企口接",
      u8"企口板",
      u8"企图",
      u8"企图心",
      u8"企待",
      u8"企慕",
      u8"企望",
      u8"企机",
      u8"企求",
      u8"企盼",
      u8"企祷",
      u8"企管",
      u8"企管科",
      u8"企管系",
      u8"企管网",
      u8"企足矮首",
      u8"企足而待",
      u8"企踵可待",
      u8"企鹅",
      u8"企鹅村",
      u8"企鹅牌",
      u8"企鹅肉",
      u8"伈伈睍睍",
      u8"伈黄鹉侨",
      u8"伉俪",
      u8"伉俪之情",
      u8"伉俪情深",
      u8"伊万诺夫",
      u8"伊万诺维奇",
      u8"伊东",
      u8"伊东市",
      u8"伊东美",
      u8"伊丽莎白",
      u8"伊丽莎白二世",
      u8"伊于胡底",
      u8"伊人",
      u8"伊代尔群",
      u8"伊何底止",
      u8"伊克昭盟",
      u8"伊兰特",
      u8"伊凡诺夫",
      u8"伊利",
      u8"伊利亚",
      u8"伊利亚特",
      u8"伊利哇拉",
      u8"伊利斯",
      u8"伊利石",
      u8"伊利诺伊",
      u8"伊利诺伊州",
      u8"伊利运河",
      u8"伊力诺",
      u8"伊勒",
      u8"伊博",
      u8"伊吹",
      u8"伊吾",
      u8"伊吾县",
      u8"伊哈桑",
      u8"伊图里河",
      u8"伊塞尔",
      u8"伊壁鸠鲁",
      u8"伊士曼",
      u8"伊妹",
      u8"伊妹儿",
      u8"伊始",
      u8"伊宁",
      u8"伊宁县",
      u8"伊宁市",
      u8"伊尔汉",
      u8"伊尔汗",
      u8"伊川",
      u8"伊川县",
      u8"伊布拉",
      u8"伊底帕斯",
      u8"伊底帕斯情结",
      u8"伊循",
      u8"伊戈尔",
      u8"伊拉克",
      u8"伊拉克人",
      u8"伊拉姆",
      u8"伊拉迭埃尔",
      u8"伊敏",
      u8"伊文",
      u8"伊文斯",
      u8"伊斯兰",
      u8"伊斯兰原教旨主义",
      u8"伊斯兰堡",
      u8"伊斯兰建筑",
      u8"伊斯兰式",
      u8"伊斯兰教",
      u8"伊斯坦堡",
      u8"伊斯坦布尔",
      u8"伊斯曼曼彻斯特爱乐乐团",
      u8"伊斯特伍德",
      u8"伊方",
      u8"伊春",
      u8"伊春区",
      u8"伊春市",
      u8"伊普斯",
      u8"伊普斯维奇",
      u8"伊曼",
      u8"伊曼纽尔",
      u8"伊朗",
      u8"伊朗人",
      u8"伊朗核",
      u8"伊朗队",
      u8"伊朗高原",
      u8"伊林",
      u8"伊格尔",
      u8"伊格尔顿",
      u8"伊格纳",
      u8"伊比利",
      u8"伊比利半",
      u8"伊比利半岛",
      u8"伊比比奥",
      u8"伊泰莲娜",
      u8"伊洛克",
      u8"伊犁",
      u8"伊犁哈萨克自治州",
      u8"伊犁州",
      u8"伊犁河",
      u8"伊瑟尔",
      u8"伊甸乐园",
      u8"伊甸园",
      u8"伊盟",
      u8"伊籍",
      u8"伊索",
      u8"伊红",
      u8"伊美姬",
      u8"伊美姬网",
      u8"伊美尔",
      u8"伊能静",
      u8"伊莉莎",
      u8"伊莉莎白",
      u8"伊莎贝尔",
      u8"伊莫拉",
      u8"伊莱克斯",
      u8"伊萨",
      u8"伊萨克",
      u8"伊蒂哈德",
      u8"伊藤公式",
      u8"伊藤润二",
      u8"伊藤过程",
      u8"伊蚊",
      u8"伊豆",
      u8"伊贝母",
      u8"伊通",
      u8"伊通满族自治县",
      u8"伊都锦",
      u8"伊里奇",
      u8"伊金霍洛旗",
      u8"伍万",
      u8"伍仁",
      u8"伍佰",
      u8"伍元",
      u8"伍卫国",
      u8"伍员山",
      u8"伍咏薇",
      u8"伍子胥",
      u8"伍宇娟",
      u8"伍家岗区",
      u8"伍尔夫",
      u8"伍廷芳",
      u8"伍德合金",
      u8"伍思凯",
      u8"伍总",
      u8"伍拾",
      u8"伍绍祖",
      u8"伍蠡甫",
      u8"伍顿",
      u8"伎两",
      u8"伎俩",
      u8"伏下",
      u8"伏下去",
      u8"伏下来",
      u8"伏低做小",
      u8"伏侏",
      u8"伏倒",
      u8"伏兔",
      u8"伏兵",
      u8"伏击",
      u8"伏击圈",
      u8"伏击战",
      u8"伏到",
      u8"伏卧",
      u8"伏在",
      u8"伏地",
      u8"伏地圣人",
      u8"伏地挺身",
      u8"伏天",
      u8"伏妖",
      u8"伏季",
      u8"伏季休渔",
      u8"伏安",
      u8"伏安图",
      u8"伏安特性曲线",
      u8"伏安表",
      u8"伏安计",
      u8"伏尔加",
      u8"伏尔加格勒",
      u8"伏尔加河",
      u8"伏尔塔瓦河",
      u8"伏尔泰",
      u8"伏尔甘",
      u8"伏尸遍野",
      u8"伏帖",
      u8"伏惟",
      u8"伏日",
      u8"伏旱",
      u8"伏明霞",
      u8"伏暑",
      u8"伏案",
      u8"伏案写作",
      u8"伏汛",
      u8"伏法",
      u8"伏法受诛",
      u8"伏波山",
      u8"伏流",
      u8"伏牛",
      u8"伏牛山",
      u8"伏特",
      u8"伏特加",
      u8"伏特加酒",
      u8"伏特计",
      u8"伏生",
      u8"伏着",
      u8"伏笔",
      u8"伏罪",
      u8"伏羲",
      u8"伏羲氏",
      u8"伏而咶天",
      u8"伏虎",
      u8"伏虎寺",
      u8"伏虎降龙",
      u8"伏袭",
      u8"伏诛",
      u8"伏贴",
      u8"伏身",
      u8"伏辨",
      u8"伏辩",
      u8"伏首",
      u8"伏首称臣",
      u8"伏首贴耳",
      u8"伏魔录",
      u8"伏龙凤雏",
      u8"伏龙肝",
      u8"伐冰之家",
      u8"伐功矜能",
      u8"伐区",
      u8"伐善",
      u8"伐异党同",
      u8"伐性之斧",
      u8"伐木",
      u8"伐木业",
      u8"伐木区",
      u8"伐木场",
      u8"伐木工人",
      u8"伐木者",
      u8"伐柯",
      u8"伐树",
      u8"伐毛换髓",
      u8"伐毛洗髓",
      u8"伐罪吊人",
      u8"伐罪吊民",
      u8"休业",
      u8"休业式",
      u8"休书",
      u8"休休有容",
      u8"休会",
      u8"休会期",
      u8"休会期间",
      u8"休假",
      u8"休假日",
      u8"休克",
      u8"休克尔分子轨道法",
      u8"休兵",
      u8"休兵罢战",
      u8"休养",
      u8"休养城市",
      u8"休养所",
      u8"休养生息",
      u8"休养院",
      u8"休刊",
      u8"休到",
      u8"休博会",
      u8"休士顿",
      u8"休声美誉",
      u8"休姆",
      u8"休学",
      u8"休学在家",
      u8"休宁",
      u8"休宁县",
      u8"休工",
      u8"休市",
      u8"休庭",
      u8"休得",
      u8"休怪",
      u8"休息",
      u8"休息厅",
      u8"休息室",
      u8"休息日",
      u8"休息时间",
      u8"休息袋",
      u8"休想",
      u8"休憩",
      u8"休战",
      u8"休戚",
      u8"休戚与共",
      u8"休戚相关",
      u8"休整",
      u8"休斯敦",
      u8"休斯顿",
      u8"休明盛世",
      u8"休止",
      u8"休止符",
      u8"休渔",
      u8"休火山",
      u8"休牛归马",
      u8"休牛放马",
      u8"休牛散马",
      u8"休班",
      u8"休眠",
      u8"休眠期",
      u8"休眠火山",
      u8"休眠芽",
      u8"休耕",
      u8"休耕地",
      u8"休要",
      u8"休课",
      u8"休谟",
      u8"休闲",
      u8"休闲包",
      u8"休闲吧",
      u8"休闲地",
      u8"休闲形态",
      u8"休闲服",
      u8"休闲椅",
      u8"休闲活动",
      u8"休闲游",
      u8"休闲类",
      u8"休闲装",
      u8"休闲裤",
      u8"休闲鞋",
      u8"众乡亲",
      u8"众人",
      u8"众人国士",
      u8"众人广坐",
      u8"众人拾柴火焰高",
      u8"众人皆知",
      u8"众人皆醉",
      u8"众人皆醉我独醒",
      u8"众人皆醉而我独醒",
      u8"众位",
      u8"众体",
      u8"众军",
      u8"众则难摧",
      u8"众判亲离",
      u8"众叛亲离",
      u8"众口",
      u8"众口一声",
      u8"众口一词",
      u8"众口一辞",
      u8"众口交传",
      u8"众口交詈",
      u8"众口交赞",
      u8"众口同声",
      u8"众口嗷嗷",
      u8"众口如一",
      u8"众口烁金",
      u8"众口熏天",
      u8"众口相传",
      u8"众口纷纭",
      u8"众口铄金",
      u8"众口销金",
      u8"众口难调",
      u8"众啄同音",
      u8"众喣山动",
      u8"众喣漂山",
      u8"众喣飘山",
      u8"众多",
      u8"众多人",
      u8"众多人口",
      u8"众多非一",
      u8"众好众恶",
      u8"众好必察",
      u8"众妙",
      u8"众学生",
      u8"众寡",
      u8"众寡不敌",
      u8"众寡势殊",
      u8"众寡悬殊",
      u8"众寡悬绝",
      u8"众将士",
      u8"众少成多",
      u8"众川赴海",
      u8"众心如城",
      u8"众心成城",
      u8"众志成城",
      u8"众怒",
      u8"众怒难任",
      u8"众怒难息",
      u8"众怒难犯",
      u8"众怨之的",
      u8"众恶必察",
      u8"众所共知",
      u8"众所周知",
      u8"众所曙目",
      u8"众所瞩目",
      u8"众擎易举",
      u8"众数",
      u8"众星",
      u8"众星拱北",
      u8"众星拱月",
      u8"众星拱极",
      u8"众星捧月",
      u8"众星攒月",
      u8"众星环极",
      u8"众智",
      u8"众望",
      u8"众望所归",
      u8"众望所盼",
      u8"众望攸归",
      u8"众楚群咻",
      u8"众毁销骨",
      u8"众毛攒裘",
      u8"众毛飞骨",
      u8"众流归海",
      u8"众犬吠声",
      u8"众生",
      u8"众生像",
      u8"众生相",
      u8"众目",
      u8"众目共睹",
      u8"众目共视",
      u8"众目具瞻",
      u8"众目四望",
      u8"众目昭彰",
      u8"众目照彰",
      u8"众目睽睽",
      u8"众目睽睽之下",
      u8"众盲摸象",
      u8"众矢之地",
      u8"众矢之的",
      u8"众虎同心",
      u8"众街坊",
      u8"众议",
      u8"众议员",
      u8"众议成林",
      u8"众议院",
      u8"众说",
      u8"众说不一",
      u8"众说纷揉",
      u8"众说纷纭",
      u8"众谋佥用",
      u8"众醉独醒",
      u8"众采众说",
      u8"众院",
      u8"众难群疑",
      u8"众难群移",
      u8"众鸟蔽日",
      u8"优于",
      u8"优会价",
      u8"优伶",
      u8"优先",
      u8"优先化",
      u8"优先发展",
      u8"优先方法",
      u8"优先权",
      u8"优先照顾",
      u8"优先级",
      u8"优先级作业",
      u8"优先级控制",
      u8"优先级选择",
      u8"优先股",
      u8"优先购买",
      u8"优先选择",
      u8"优利欧",
      u8"优劣",
      u8"优劣势",
      u8"优势",
      u8"优势互补",
      u8"优势产业",
      u8"优势种群",
      u8"优化",
      u8"优化大师",
      u8"优化组合",
      u8"优化经济结构",
      u8"优化结构",
      u8"优厚",
      u8"优哉",
      u8"优哉游哉",
      u8"优妮姿",
      u8"优孟衣冠",
      u8"优容",
      u8"优尼科",
      u8"优异",
      u8"优异性",
      u8"优异成绩",
      u8"优弧",
      u8"优待",
      u8"优待券",
      u8"优待票",
      u8"优待证",
      u8"优待金",
      u8"优惠",
      u8"优惠价",
      u8"优惠价格",
      u8"优惠供应",
      u8"优惠关税",
      u8"优惠券",
      u8"优惠卡",
      u8"优惠卷",
      u8"优惠待遇",
      u8"优惠政策",
      u8"优惠机票",
      u8"优惠权",
      u8"优惠条件",
      u8"优惠活动",
      u8"优惠证",
      u8"优惠酬宾",
      u8"优抚",
      u8"优抚对象",
      u8"优抚工作",
      u8"优抚金",
      u8"优昙一现",
      u8"优材生",
      u8"优柔",
      u8"优柔厌饫",
      u8"优柔寡断",
      u8"优柔餍饫",
      u8"优流",
      u8"优渥",
      u8"优游",
      u8"优游不断",
      u8"优游卒岁",
      u8"优游岁月",
      u8"优游涵泳",
      u8"优游自在",
      u8"优游自如",
      u8"优游自得",
      u8"优游自若",
      u8"优游自适",
      u8"优点",
      u8"优生",
      u8"优生优育",
      u8"优生学",
      u8"优生法",
      u8"优百特",
      u8"优盘",
      u8"优礼有加",
      u8"优秀",
      u8"优秀人才",
      u8"优秀企业",
      u8"优秀作品",
      u8"优秀作家",
      u8"优秀儿女",
      u8"优秀党员",
      u8"优秀分子",
      u8"优秀员工",
      u8"优秀品格",
      u8"优秀品质",
      u8"优秀团员",
      u8"优秀奖",
      u8"优秀学生",
      u8"优秀干部",
      u8"优秀成果",
      u8"优秀教师",
      u8"优秀论文",
      u8"优秀青年",
      u8"优种",
      u8"优等",
      u8"优等品",
      u8"优等奖",
      u8"优等生",
      u8"优絮",
      u8"优级",
      u8"优缺点",
      u8"优美",
      u8"优美加",
      u8"优美环境",
      u8"优者",
      u8"优育",
      u8"优胜",
      u8"优胜劣汰",
      u8"优胜劣败",
      u8"优胜奖",
      u8"优胜者",
      u8"优胜者杯",
      u8"优胜队",
      u8"优良",
      u8"优良传统",
      u8"优良作风",
      u8"优良单株",
      u8"优良品种",
      u8"优良场次率",
      u8"优良性",
      u8"优良率",
      u8"优虎降龙",
      u8"优裕",
      u8"优贤扬历",
      u8"优贤飏历",
      u8"优质",
      u8"优质产品",
      u8"优质优价",
      u8"优质服务",
      u8"优质棉",
      u8"优质稻",
      u8"优质课",
      u8"优质钢",
      u8"优越",
      u8"优越性",
      u8"优越感",
      u8"优选",
      u8"优选法",
      u8"优遇",
      u8"优酪乳",
      u8"优酸乳",
      u8"优钢",
      u8"优闲",
      u8"优降糖",
      u8"优雅",
      u8"优雅兰",
      u8"优雅风度",
      u8"优龙凤雏",
      u8"伙伴",
      u8"伙伴关系",
      u8"伙伴国",
      u8"伙同",
      u8"伙同他人",
      u8"伙夫",
      u8"伙子",
      u8"伙房",
      u8"伙犯",
      u8"伙计",
      u8"伙食",
      u8"伙食费",
      u8"会上",
      u8"会上会下",
      u8"会上去",
      u8"会上来",
      u8"会下",
      u8"会下去",
      u8"会下来",
      u8"会不会",
      u8"会与",
      u8"会东",
      u8"会东县",
      u8"会个",
      u8"会中",
      u8"会为",
      u8"会了",
      u8"会于",
      u8"会付",
      u8"会众",
      u8"会会",
      u8"会使",
      u8"会做",
      u8"会做人",
      u8"会停",
      u8"会儿",
      u8"会元",
      u8"会党",
      u8"会关",
      u8"会典",
      u8"会写",
      u8"会出",
      u8"会出去",
      u8"会出来",
      u8"会分",
      u8"会刊",
      u8"会到",
      u8"会前",
      u8"会剿",
      u8"会办",
      u8"会加",
      u8"会务",
      u8"会务费",
      u8"会动",
      u8"会升",
      u8"会占",
      u8"会卡",
      u8"会厅",
      u8"会厌",
      u8"会厌软骨",
      u8"会去",
      u8"会友",
      u8"会发",
      u8"会受",
      u8"会叫",
      u8"会合",
      u8"会合处",
      u8"会合点",
      u8"会同",
      u8"会同县",
      u8"会后",
      u8"会听",
      u8"会员",
      u8"会员中心",
      u8"会员价",
      u8"会员制",
      u8"会员区",
      u8"会员单位",
      u8"会员卡",
      u8"会员号",
      u8"会员名",
      u8"会员名单",
      u8"会员团",
      u8"会员国",
      u8"会员大会",
      u8"会员帐号",
      u8"会员版",
      u8"会员证",
      u8"会员资料",
      u8"会哭的孩子有奶吃",
      u8"会唱",
      u8"会商",
      u8"会在",
      u8"会地",
      u8"会场",
      u8"会址",
      u8"会坏",
      u8"会堂",
      u8"会填",
      u8"会够",
      u8"会头",
      u8"会头银",
      u8"会好",
      u8"会子",
      u8"会存",
      u8"会宁县",
      u8"会宗",
      u8"会审",
      u8"会客",
      u8"会客厅",
      u8"会客室",
      u8"会家不忙",
      u8"会对",
      u8"会将",
      u8"会少离多",
      u8"会尽",
      u8"会展",
      u8"会展业",
      u8"会展中心",
      u8"会展网",
      u8"会师",
      u8"会帐",
      u8"会干",
      u8"会庆",
      u8"会底银",
      u8"会引起",
      u8"会弹",
      u8"会当",
      u8"会当凌绝顶",
      u8"会得",
      u8"会徽",
      u8"会心",
      u8"会心一笑",
      u8"会心微笑",
      u8"会恨",
      u8"会想",
      u8"会意",
      u8"会意字",
      u8"会成",
      u8"会战",
      u8"会所",
      u8"会打",
      u8"会扣",
      u8"会把",
      u8"会报",
      u8"会抬",
      u8"会拜",
      u8"会指",
      u8"会挑",
      u8"会掉",
      u8"会搞",
      u8"会播",
      u8"会操",
      u8"会收",
      u8"会改",
      u8"会教",
      u8"会旗",
      u8"会时常",
      u8"会昌",
      u8"会昌县",
      u8"会是",
      u8"会是在",
      u8"会晤",
      u8"会有",
      u8"会服",
      u8"会期",
      u8"会来",
      u8"会标",
      u8"会款",
      u8"会歌",
      u8"会比",
      u8"会水",
      u8"会泽",
      u8"会泽县",
      u8"会派",
      u8"会海",
      u8"会混",
      u8"会演",
      u8"会点",
      u8"会玩",
      u8"会理",
      u8"会理县",
      u8"会生",
      u8"会用",
      u8"会由",
      u8"会画",
      u8"会盟",
      u8"会看",
      u8"会着",
      u8"会社",
      u8"会种",
      u8"会稿",
      u8"会站",
      u8"会章",
      u8"会签",
      u8"会管",
      u8"会籍",
      u8"会红",
      u8"会约",
      u8"会经",
      u8"会给",
      u8"会编",
      u8"会考",
      u8"会者不忙",
      u8"会者不难",
      u8"会聚",
      u8"会聚波",
      u8"会聚透镜",
      u8"会脚",
      u8"会萃",
      u8"会被",
      u8"会要",
      u8"会见",
      u8"会见者",
      u8"会规",
      u8"会计",
      u8"会计专业",
      u8"会计人",
      u8"会计人员",
      u8"会计代理",
      u8"会计信息",
      u8"会计公司",
      u8"会计准则",
      u8"会计凭证",
      u8"会计分录",
      u8"会计制度",
      u8"会计员",
      u8"会计学",
      u8"会计学院",
      u8"会计室",
      u8"会计工作",
      u8"会计师",
      u8"会计年度",
      u8"会计报告",
      u8"会计报表",
      u8"会计核算",
      u8"会计法",
      u8"会计科目",
      u8"会计簿",
      u8"会计簿册",
      u8"会计系",
      u8"会计统计",
      u8"会计网",
      u8"会计职称",
      u8"会计论文",
      u8"会计证",
      u8"会计账",
      u8"会计部",
      u8"会议",
      u8"会议中心",
      u8"会议主席团",
      u8"会议主题",
      u8"会议内容",
      u8"会议决定",
      u8"会议厅",
      u8"会议台",
      u8"会议室",
      u8"会议局",
      u8"会议展览",
      u8"会议录",
      u8"会议性",
      u8"会议期间",
      u8"会议桌",
      u8"会议电话",
      u8"会议礼品",
      u8"会议精神",
      u8"会议系统",
      u8"会议纪要",
      u8"会议认为",
      u8"会议议程",
      u8"会议记录",
      u8"会议记要",
      u8"会议设备",
      u8"会议费",
      u8"会议资料",
      u8"会讲",
      u8"会诊",
      u8"会试",
      u8"会话",
      u8"会话室",
      u8"会话层",
      u8"会话式",
      u8"会说",
      u8"会说会写",
      u8"会调",
      u8"会谈",
      u8"会谈纪要",
      u8"会谈记要",
      u8"会账",
      u8"会费",
      u8"会费额",
      u8"会车",
      u8"会选",
      u8"会通",
      u8"会逢其适",
      u8"会道能说",
      u8"会钞",
      u8"会钱",
      u8"会银",
      u8"会错意",
      u8"会长",
      u8"会阳",
      u8"会阴",
      u8"会阴部",
      u8"会附",
      u8"会集",
      u8"会面",
      u8"会面处",
      u8"会风",
      u8"会餐",
      u8"会馆",
      u8"会首",
      u8"会齐",
      u8"伛偻",
      u8"伛偻病",
      u8"伞兵",
      u8"伞兵部队",
      u8"伞具",
      u8"伞包",
      u8"伞套",
      u8"伞式流量计",
      u8"伞形",
      u8"伞形反射天线",
      u8"伞形天线",
      u8"伞投",
      u8"伞架",
      u8"伞柄",
      u8"伞状",
      u8"伞盖",
      u8"伞索",
      u8"伞罩",
      u8"伞菌",
      u8"伞衣",
      u8"伞降",
      u8"伞面",
      u8"伞齿轮",
      u8"伟业",
      u8"伟人",
      u8"伟力",
      u8"伟哥",
      u8"伟大",
      u8"伟大事业",
      u8"伟大光荣",
      u8"伟大工程",
      u8"伟大意义",
      u8"伟大成就",
      u8"伟大旗帜",
      u8"伟大祖国",
      u8"伟大胜利",
      u8"伟大领袖",
      u8"伟岸",
      u8"伟康",
      u8"伟晶岩",
      u8"伟绩",
      u8"伟绩丰功",
      u8"伟航",
      u8"伟论",
      u8"传上",
      u8"传上去",
      u8"传上来",
      u8"传下",
      u8"传下去",
      u8"传下来",
      u8"传不到",
      u8"传世",
      u8"传中",
      u8"传中球",
      u8"传为",
      u8"传为佳话",
      u8"传为笑柄",
      u8"传为笑谈",
      u8"传为美谈",
      u8"传主",
      u8"传之其人",
      u8"传习",
      u8"传习录",
      u8"传书",
      u8"传书鸽",
      u8"传人",
      u8"传代",
      u8"传代培养",
      u8"传令",
      u8"传令兵",
      u8"传传",
      u8"传位",
      u8"传信",
      u8"传信鸽",
      u8"传入",
      u8"传入神经",
      u8"传出",
      u8"传出去",
      u8"传出来",
      u8"传到",
      u8"传制权",
      u8"传功",
      u8"传功长老",
      u8"传动",
      u8"传动件",
      u8"传动力",
      u8"传动带",
      u8"传动比",
      u8"传动系统",
      u8"传动装置",
      u8"传动轴",
      u8"传动链",
      u8"传单",
      u8"传去",
      u8"传号",
      u8"传名",
      u8"传告",
      u8"传呼",
      u8"传呼台",
      u8"传呼机",
      u8"传呼电话",
      u8"传唤",
      u8"传唱",
      u8"传回",
      u8"传国",
      u8"传圭袭组",
      u8"传声",
      u8"传声器",
      u8"传声筒",
      u8"传奇",
      u8"传奇一生",
      u8"传奇三",
      u8"传奇世界",
      u8"传奇中",
      u8"传奇人物",
      u8"传奇幻想",
      u8"传奇式",
      u8"传奇性",
      u8"传奇色彩",
      u8"传奇论坛",
      u8"传媒",
      u8"传媒业",
      u8"传媒人",
      u8"传媒大学",
      u8"传媒界",
      u8"传媒网",
      u8"传子",
      u8"传宗",
      u8"传宗接代",
      u8"传审",
      u8"传家",
      u8"传家之宝",
      u8"传家宝",
      u8"传对",
      u8"传导",
      u8"传导体",
      u8"传导冷却",
      u8"传导性",
      u8"传导率",
      u8"传导电流",
      u8"传布",
      u8"传帮带",
      u8"传开",
      u8"传得",
      u8"传情",
      u8"传感",
      u8"传感器",
      u8"传戒",
      u8"传扬",
      u8"传承",
      u8"传承文明",
      u8"传承者",
      u8"传抄",
      u8"传报",
      u8"传捷报",
      u8"传授",
      u8"传授法",
      u8"传授给",
      u8"传接球",
      u8"传播",
      u8"传播价值",
      u8"传播发展期",
      u8"传播声音",
      u8"传播媒介",
      u8"传播媒体",
      u8"传播学",
      u8"传播学系",
      u8"传播学院",
      u8"传播常数",
      u8"传播常量",
      u8"传播效应",
      u8"传播界",
      u8"传播给",
      u8"传播网",
      u8"传播者",
      u8"传播速度",
      u8"传教",
      u8"传教士",
      u8"传旨",
      u8"传曼特",
      u8"传本",
      u8"传来",
      u8"传来传去",
      u8"传杯弄盏",
      u8"传杯换盏",
      u8"传柄移藉",
      u8"传染",
      u8"传染性",
      u8"传染扩散",
      u8"传染期",
      u8"传染源",
      u8"传染病",
      u8"传染科",
      u8"传染给",
      u8"传标",
      u8"传檄而定",
      u8"传毒",
      u8"传热",
      u8"传热介质油装载泵",
      u8"传热学",
      u8"传热性",
      u8"传热系数",
      u8"传爵袭紫",
      u8"传球",
      u8"传球法",
      u8"传电",
      u8"传略",
      u8"传看",
      u8"传真",
      u8"传真号码",
      u8"传真机",
      u8"传真照片",
      u8"传真电报",
      u8"传真电话",
      u8"传真纸",
      u8"传着",
      u8"传神",
      u8"传神阿堵",
      u8"传票",
      u8"传种",
      u8"传种接代",
      u8"传粉",
      u8"传经",
      u8"传经授道",
      u8"传经送宝",
      u8"传给",
      u8"传统",
      u8"传统习俗",
      u8"传统产业",
      u8"传统化",
      u8"传统医学",
      u8"传统友谊",
      u8"传统名称",
      u8"传统园林建筑",
      u8"传统型",
      u8"传统媒体",
      u8"传统工艺",
      u8"传统市场",
      u8"传统式",
      u8"传统性",
      u8"传统戏",
      u8"传统教育",
      u8"传统文化",
      u8"传统服装",
      u8"传统武术",
      u8"传统相机",
      u8"传统美德",
      u8"传统节日",
      u8"传统节目",
      u8"传统观念",
      u8"传绯闻",
      u8"传美版",
      u8"传能线密度",
      u8"传自",
      u8"传艺",
      u8"传衣钵",
      u8"传观",
      u8"传言",
      u8"传讯",
      u8"传记",
      u8"传记小说",
      u8"传记文学",
      u8"传记片",
      u8"传讹",
      u8"传译",
      u8"传译出",
      u8"传话",
      u8"传说",
      u8"传说中",
      u8"传说人物",
      u8"传诵",
      u8"传诵一时",
      u8"传诵不已",
      u8"传谕",
      u8"传谣",
      u8"传质",
      u8"传质阻力",
      u8"传赞",
      u8"传起",
      u8"传起来",
      u8"传输",
      u8"传输器",
      u8"传输媒体",
      u8"传输率",
      u8"传输码",
      u8"传输线",
      u8"传输网",
      u8"传输通路延迟",
      u8"传达",
      u8"传达出来",
      u8"传达处",
      u8"传达室",
      u8"传达物",
      u8"传过",
      u8"传过去",
      u8"传过来",
      u8"传述",
      u8"传送",
      u8"传送器",
      u8"传送带",
      u8"传送机",
      u8"传送点",
      u8"传送率",
      u8"传送门",
      u8"传递",
      u8"传递信息",
      u8"传递函数",
      u8"传递函数依赖",
      u8"传递函数矩阵",
      u8"传递性",
      u8"传递情报",
      u8"传递窗",
      u8"传递细胞",
      u8"传递集",
      u8"传遍",
      u8"传遍全国",
      u8"传道",
      u8"传道受业",
      u8"传道士",
      u8"传道授业",
      u8"传销",
      u8"传销价",
      u8"传销员",
      u8"传销商",
      u8"传销商品",
      u8"传销案",
      u8"传问",
      u8"传闻",
      u8"传闻不如亲见",
      u8"传闻中",
      u8"传闻失实",
      u8"传闻失真",
      u8"传闻异辞",
      u8"传阅",
      u8"传音入密",
      u8"传颂",
      u8"传颂一时",
      u8"传颂千古",
      u8"传风扇火",
      u8"传风搧火",
      u8"传魂",
      u8"传龟袭紫",
      u8"伢子",
      u8"伤了",
      u8"伤亡",
      u8"伤亡事故",
      u8"伤亡人数",
      u8"伤亡惨重",
      u8"伤亡者",
      u8"伤人",
      u8"伤人案",
      u8"伤俘",
      u8"伤元气",
      u8"伤兵",
      u8"伤其十指不如断其一指",
      u8"伤别离",
      u8"伤到",
      u8"伤力",
      u8"伤势",
      u8"伤化败俗",
      u8"伤口",
      u8"伤口发炎",
      u8"伤号",
      u8"伤员",
      u8"伤在",
      u8"伤型",
      u8"伤处",
      u8"伤天害理",
      u8"伤害",
      u8"伤害事故",
      u8"伤害到",
      u8"伤害力",
      u8"伤害性",
      u8"伤害罪",
      u8"伤寒",
      u8"伤寒杆菌",
      u8"伤寒病",
      u8"伤寒论",
      u8"伤弓之鸟",
      u8"伤得",
      u8"伤心",
      u8"伤心事",
      u8"伤心人",
      u8"伤心惨目",
      u8"伤心欲绝",
      u8"伤心疾首",
      u8"伤心落泪",
      u8"伤心蒿目",
      u8"伤心雨",
      u8"伤怀",
      u8"伤性情",
      u8"伤患",
      u8"伤患人数",
      u8"伤悲",
      u8"伤悼",
      u8"伤情",
      u8"伤愈",
      u8"伤感",
      u8"伤感情",
      u8"伤损",
      u8"伤教败俗",
      u8"伤春悲秋",
      u8"伤来伤去",
      u8"伤残",
      u8"伤残人",
      u8"伤残人员",
      u8"伤气",
      u8"伤湿膏",
      u8"伤生",
      u8"伤疤",
      u8"伤病",
      u8"伤病员",
      u8"伤痕",
      u8"伤痕累累",
      u8"伤痛",
      u8"伤眼",
      u8"伤着",
      u8"伤神",
      u8"伤离别",
      u8"伤科",
      u8"伤筋动骨",
      u8"伤者",
      u8"伤耗",
      u8"伤肺",
      u8"伤肾",
      u8"伤胃",
      u8"伤脑筋",
      u8"伤自尊",
      u8"伤自尊了",
      u8"伤言扎语",
      u8"伤财",
      u8"伤身",
      u8"伤过",
      u8"伤透",
      u8"伤逝",
      u8"伤错",
      u8"伤风",
      u8"伤风克",
      u8"伤风感冒",
      u8"伤风败俗",
      u8"伤风败化",
      u8"伥鬼",
      u8"伦勃朗",
      u8"伦台",
      u8"伦墩大学",
      u8"伦巴",
      u8"伦常",
      u8"伦敦",
      u8"伦敦大学",
      u8"伦敦桥",
      u8"伦敦爱乐乐团",
      u8"伦敦股票市场",
      u8"伦次",
      u8"伦比",
      u8"伦永亮",
      u8"伦理",
      u8"伦理学",
      u8"伦理学史",
      u8"伦理学家",
      u8"伦理思想",
      u8"伦理片",
      u8"伦理道德",
      u8"伦琴",
      u8"伦琴射线",
      u8"伦纪",
      u8"伦纳德",
      u8"伦道夫",
      u8"伦飞",
      u8"伧俗",
      u8"伧父",
      u8"伪书",
      u8"伪作",
      u8"伪供",
      u8"伪军",
      u8"伪力",
      u8"伪劣",
      u8"伪劣产品",
      u8"伪劣商品",
      u8"伪名",
      u8"伪君子",
      u8"伪命",
      u8"伪品",
      u8"伪善",
      u8"伪善性",
      u8"伪善者",
      u8"伪学",
      u8"伪学者",
      u8"伪币",
      u8"伪彩",
      u8"伪托",
      u8"伪报",
      u8"伪指令",
      u8"伪政府",
      u8"伪政权",
      u8"伪本",
      u8"伪满",
      u8"伪满州国",
      u8"伪满政府",
      u8"伪玩家",
      u8"伪科学",
      u8"伪称",
      u8"伪经",
      u8"伪药",
      u8"伪补格",
      u8"伪装",
      u8"伪装做",
      u8"伪装品",
      u8"伪装成",
      u8"伪装物",
      u8"伪装网",
      u8"伪装者",
      u8"伪言",
      u8"伪誓",
      u8"伪证",
      u8"伪证人",
      u8"伪证罪",
      u8"伪谬",
      u8"伪足",
      u8"伪造",
      u8"伪造品",
      u8"伪造文书",
      u8"伪造检测",
      u8"伪造罪",
      u8"伪造者",
      u8"伪造证件",
      u8"伪造证据",
      u8"伪钞",
      u8"伪预解式",
      u8"伪饰",
      u8"伫候",
      u8"伫列",
      u8"伫立",
      u8"伫足",
      u8"伯乐",
      u8"伯乐一顾",
      u8"伯乐相马",
      u8"伯仲",
      u8"伯仲之间",
      u8"伯仲叔季",
      u8"伯伯",
      u8"伯俞泣杖",
      u8"伯克",
      u8"伯克利",
      u8"伯公",
      u8"伯兹瓦纳",
      u8"伯利",
      u8"伯利兹",
      u8"伯利恒",
      u8"伯努利分布",
      u8"伯努利方程",
      u8"伯努利盘",
      u8"伯劳",
      u8"伯劳飞燕",
      u8"伯劳鸟",
      u8"伯埙仲篪",
      u8"伯基特淋巴瘤",
      u8"伯婆",
      u8"伯尔",
      u8"伯尔尼",
      u8"伯德",
      u8"伯恩",
      u8"伯恩斯",
      u8"伯恩斯坦",
      u8"伯恩施坦",
      u8"伯斯",
      u8"伯明罕",
      u8"伯明翰",
      u8"伯根地",
      u8"伯格斯矢量",
      u8"伯格曼度量",
      u8"伯格曼算子",
      u8"伯歌季舞",
      u8"伯母",
      u8"伯爵",
      u8"伯爵夫人",
      u8"伯爵爵位",
      u8"伯父",
      u8"伯父母",
      u8"伯牙",
      u8"伯特利",
      u8"伯玉知非",
      u8"伯祖",
      u8"伯祖母",
      u8"伯纳乌",
      u8"伯纳德",
      u8"伯罗奔尼撒",
      u8"伯道无儿",
      u8"伯里兹",
      u8"估产",
      u8"估价",
      u8"估价人",
      u8"估价单",
      u8"估价发票",
      u8"估价师",
      u8"估价表",
      u8"估价鉴定",
      u8"估估",
      u8"估分",
      u8"估到",
      u8"估单",
      u8"估堆儿",
      u8"估成",
      u8"估摸",
      u8"估斤算两",
      u8"估测",
      u8"估税员",
      u8"估算",
      u8"估衣",
      u8"估计",
      u8"估计不足",
      u8"估计值",
      u8"估计者",
      u8"估计量",
      u8"估评",
      u8"估量",
      u8"伴你",
      u8"伴侣",
      u8"伴侣伴蛋白",
      u8"伴侣蛋白",
      u8"伴侣蛋白质",
      u8"伴偶",
      u8"伴儿",
      u8"伴刀豆球蛋白",
      u8"伴同",
      u8"伴君如伴虎",
      u8"伴唱",
      u8"伴唱机",
      u8"伴唱版",
      u8"伴奏",
      u8"伴奏带",
      u8"伴奏网",
      u8"伴奏者",
      u8"伴娘",
      u8"伴我",
      u8"伴我行",
      u8"伴我飞",
      u8"伴时宰相",
      u8"伴星",
      u8"伴有",
      u8"伴游",
      u8"伴热输送",
      u8"伴生",
      u8"伴生树",
      u8"伴白蛋白",
      u8"伴舞",
      u8"伴舞乐队",
      u8"伴读",
      u8"伴送",
      u8"伴郎",
      u8"伴随",
      u8"伴随李代数",
      u8"伴随模型",
      u8"伴随物",
      u8"伴随着",
      u8"伴随线性映射",
      u8"伴靓",
      u8"伴音",
      u8"伴食",
      u8"伴食中书",
      u8"伴食宰相",
      u8"伶人",
      u8"伶仃",
      u8"伶仃孤苦",
      u8"伶仃洋",
      u8"伶俐",
      u8"伶俐乖巧",
      u8"伶俜",
      u8"伶牙俐齿",
      u8"伶牙利爪",
      u8"伶牙利齿",
      u8"伸上",
      u8"伸上去",
      u8"伸上来",
      u8"伸下",
      u8"伸下去",
      u8"伸下来",
      u8"伸伸",
      u8"伸伸手",
      u8"伸伸脚",
      u8"伸入",
      u8"伸冤",
      u8"伸冤理枉",
      u8"伸出",
      u8"伸出去",
      u8"伸出手",
      u8"伸出来",
      u8"伸到",
      u8"伸去",
      u8"伸及",
      u8"伸向",
      u8"伸回",
      u8"伸回去",
      u8"伸回来",
      u8"伸在",
      u8"伸头",
      u8"伸头探脑",
      u8"伸头缩颈",
      u8"伸屈",
      u8"伸展",
      u8"伸展不了",
      u8"伸展出",
      u8"伸展出去",
      u8"伸展到",
      u8"伸展台",
      u8"伸展操",
      u8"伸平",
      u8"伸延",
      u8"伸开",
      u8"伸张",
      u8"伸张正义",
      u8"伸懒腰",
      u8"伸手",
      u8"伸手不打笑脸人",
      u8"伸手不见",
      u8"伸手不见五指",
      u8"伸手不见十指",
      u8"伸手派",
      u8"伸曲",
      u8"伸来",
      u8"伸来伸去",
      u8"伸港",
      u8"伸畅",
      u8"伸直",
      u8"伸直长度",
      u8"伸着",
      u8"伸筋草",
      u8"伸缩",
      u8"伸缩器",
      u8"伸缩尺",
      u8"伸缩尼龙",
      u8"伸缩式",
      u8"伸缩性",
      u8"伸缩缝",
      u8"伸缩自如",
      u8"伸缩门",
      u8"伸脚",
      u8"伸腰",
      u8"伸腿",
      u8"伸舌头",
      u8"伸诉",
      u8"伸起",
      u8"伸起来",
      u8"伸过",
      u8"伸过去",
      u8"伸过来",
      u8"伸进",
      u8"伸进去",
      u8"伸进来",
      u8"伸钩索铁",
      u8"伸长",
      u8"伸长率",
      u8"伺侯",
      u8"伺候",
      u8"伺奉",
      u8"伺察",
      u8"伺服",
      u8"伺服器",
      u8"伺服放大器",
      u8"伺服机构",
      u8"伺服系统",
      u8"伺服道录写器",
      u8"伺机",
      u8"伺机作案",
      u8"伺机报复",
      u8"伺机而动",
      u8"伺瑕导蠙",
      u8"伺瑕导隙",
      u8"伺瑕抵蠙",
      u8"伺瑕抵隙",
      u8"伺隙",
      u8"似乎",
      u8"似乎是",
      u8"似仙非仙",
      u8"似动知觉",
      u8"似可",
      u8"似地",
      u8"似懂非懂",
      u8"似旧",
      u8"似是",
      u8"似是而非",
      u8"似曾",
      u8"似曾相识",
      u8"似有",
      u8"似有如无",
      u8"似有若无",
      u8"似水",
      u8"似水如鱼",
      u8"似水流年",
      u8"似漆如胶",
      u8"似火",
      u8"似的",
      u8"似真似假",
      u8"似神非神",
      u8"似笑非笑",
      u8"似箭在弦",
      u8"似能",
      u8"似角",
      u8"似醉如痴",
      u8"似钢",
      u8"似锦",
      u8"似非而是",
      u8"似马一样",
      u8"伽利略",
      u8"伽利略不变性",
      u8"伽利略变换",
      u8"伽利略相对性原理",
      u8"伽师",
      u8"伽师县",
      u8"伽楠香",
      u8"伽玛刀",
      u8"伽罗瓦对应",
      u8"伽罗瓦论",
      u8"伽蓝",
      u8"伽马射线",
      u8"佃农",
      u8"佃妇",
      u8"佃客",
      u8"佃户",
      u8"佃权",
      u8"佃租",
      u8"佃粮",
      u8"但丁",
      u8"但不",
      u8"但也",
      u8"但书",
      u8"但亏",
      u8"但仍然",
      u8"但从",
      u8"但他",
      u8"但他却",
      u8"但会",
      u8"但其与",
      u8"但凡",
      u8"但凭",
      u8"但却",
      u8"但原告",
      u8"但又",
      u8"但可",
      u8"但可以",
      u8"但因",
      u8"但在",
      u8"但她",
      u8"但子",
      u8"但字根难记",
      u8"但它",
      u8"但对",
      u8"但应",
      u8"但愿",
      u8"但愿人长久",
      u8"但愿如此",
      u8"但我",
      u8"但无",
      u8"但是",
      u8"但是在",
      u8"但是她",
      u8"但是有",
      u8"但有",
      u8"但未",
      u8"但毕竟",
      u8"但求",
      u8"但求无过",
      u8"但现在",
      u8"但由于",
      u8"但能",
      u8"但至少",
      u8"但行好事",
      u8"但要",
      u8"但见",
      u8"但说无妨",
      u8"但这次",
      u8"但那次",
      u8"但重码多",
      u8"但随着",
      u8"但须",
      u8"但马",
      u8"位不期骄",
      u8"位于",
      u8"位于下面",
      u8"位会员",
      u8"位似中心",
      u8"位似变换",
      u8"位元",
      u8"位列",
      u8"位力定理",
      u8"位力系数",
      u8"位势",
      u8"位势论",
      u8"位卑未敢忘忧国",
      u8"位卑言高",
      u8"位图",
      u8"位图文件",
      u8"位在",
      u8"位址",
      u8"位址栏",
      u8"位处",
      u8"位子",
      u8"位密度",
      u8"位尊",
      u8"位尊望重",
      u8"位居",
      u8"位居要津",
      u8"位差",
      u8"位形坐标",
      u8"位形积分",
      u8"位形空间",
      u8"位数",
      u8"位极人臣",
      u8"位标",
      u8"位次",
      u8"位相",
      u8"位码",
      u8"位移",
      u8"位移共振",
      u8"位移电流",
      u8"位移试剂",
      u8"位纤",
      u8"位线",
      u8"位置",
      u8"位置服务",
      u8"位置灯",
      u8"位置矢量",
      u8"位能",
      u8"位色",
      u8"低三下四",
      u8"低下",
      u8"低下去",
      u8"低下头",
      u8"低下头去",
      u8"低下头来",
      u8"低下来",
      u8"低不就",
      u8"低买",
      u8"低买高卖",
      u8"低了",
      u8"低于",
      u8"低于正常",
      u8"低云",
      u8"低产",
      u8"低产期",
      u8"低产田",
      u8"低产量",
      u8"低人",
      u8"低人一等",
      u8"低价",
      u8"低价买进",
      u8"低价位",
      u8"低价卖出",
      u8"低价商品",
      u8"低价股",
      u8"低价高报",
      u8"低估",
      u8"低位",
      u8"低位沼泽",
      u8"低位牙",
      u8"低俗",
      u8"低俗小说",
      u8"低保",
      u8"低保户",
      u8"低保真",
      u8"低保金",
      u8"低值易耗",
      u8"低值易耗品",
      u8"低做",
      u8"低共熔点",
      u8"低共熔物",
      u8"低凹",
      u8"低分",
      u8"低分子烃",
      u8"低分辨率",
      u8"低利",
      u8"低利率",
      u8"低到",
      u8"低剂量",
      u8"低功耗",
      u8"低劣",
      u8"低劣性",
      u8"低压",
      u8"低压凝析油罐",
      u8"低压报警器",
      u8"低压槽",
      u8"低压气净化器",
      u8"低压火炬",
      u8"低压电器",
      u8"低压电器设备",
      u8"低压等离子体淀积",
      u8"低压配电",
      u8"低压钠灯",
      u8"低合金",
      u8"低合金钢",
      u8"低吟",
      u8"低吟浅唱",
      u8"低品质",
      u8"低哑",
      u8"低唱",
      u8"低唱浅斟",
      u8"低唱浅酌",
      u8"低噪声",
      u8"低噪声放大器",
      u8"低噪音",
      u8"低回",
      u8"低回不已",
      u8"低地",
      u8"低坝",
      u8"低垂",
      u8"低声",
      u8"低声下气",
      u8"低声哑气",
      u8"低声悄语",
      u8"低声波",
      u8"低声细语",
      u8"低声诉说",
      u8"低处",
      u8"低头",
      u8"低头不见抬头见",
      u8"低头不语",
      u8"低头丧气",
      u8"低头哈腰",
      u8"低头搭脑",
      u8"低头碎步",
      u8"低头耷脑",
      u8"低姿势",
      u8"低姿态",
      u8"低密度",
      u8"低层",
      u8"低层次",
      u8"低峰",
      u8"低工资",
      u8"低常儿童",
      u8"低平",
      u8"低年",
      u8"低年级",
      u8"低幼",
      u8"低度",
      u8"低度酒",
      u8"低廉",
      u8"低徊",
      u8"低得",
      u8"低微",
      u8"低心下意",
      u8"低息",
      u8"低息贷款",
      u8"低情曲意",
      u8"低成本",
      u8"低截滤波器",
      u8"低手",
      u8"低损耗",
      u8"低收入",
      u8"低收入者",
      u8"低收益",
      u8"低放废物",
      u8"低效",
      u8"低效率",
      u8"低效益",
      u8"低效能",
      u8"低柔",
      u8"低栏",
      u8"低栏赛",
      u8"低格",
      u8"低档",
      u8"低档车",
      u8"低段",
      u8"低毒",
      u8"低气压",
      u8"低氧",
      u8"低氧习服",
      u8"低水位体系域",
      u8"低水平",
      u8"低污染",
      u8"低沈",
      u8"低沉",
      u8"低油耗",
      u8"低洼",
      u8"低洼地",
      u8"低洼地区",
      u8"低浅",
      u8"低浓度",
      u8"低消耗",
      u8"低温",
      u8"低温冰箱",
      u8"低温学",
      u8"低温实验法",
      u8"低温干燥",
      u8"低温恒温器",
      u8"低温晶体学",
      u8"低温气候",
      u8"低温泵",
      u8"低温浓缩",
      u8"低温特报",
      u8"低温生物学",
      u8"低温计",
      u8"低温防护剂",
      u8"低温防护手套",
      u8"低湿",
      u8"低潮",
      u8"低潮期",
      u8"低点",
      u8"低烧",
      u8"低热",
      u8"低热量",
      u8"低版",
      u8"低版本",
      u8"低电压",
      u8"低电压正电源射极耦合逻辑",
      u8"低电平",
      u8"低电量",
      u8"低相",
      u8"低眉",
      u8"低眉垂眼",
      u8"低眉折腰",
      u8"低眉顺眼",
      u8"低着",
      u8"低着头",
      u8"低矮",
      u8"低码率",
      u8"低碳钢",
      u8"低穹",
      u8"低空",
      u8"低空飞行",
      u8"低端",
      u8"低等",
      u8"低等动物",
      u8"低等植物",
      u8"低等生物",
      u8"低粘度",
      u8"低糖",
      u8"低级",
      u8"低级格式化",
      u8"低级语言",
      u8"低级趣味",
      u8"低纬度",
      u8"低缓",
      u8"低耗",
      u8"低耗电",
      u8"低聚甲醛",
      u8"低聚糖",
      u8"低胸",
      u8"低胸装",
      u8"低能",
      u8"低能儿",
      u8"低能电子衍射",
      u8"低能离子散射",
      u8"低能者",
      u8"低能耗",
      u8"低脂肪",
      u8"低腰",
      u8"低腰裤",
      u8"低荡",
      u8"低落",
      u8"低薪",
      u8"低蛋白",
      u8"低血压",
      u8"低血糖",
      u8"低血糖症",
      u8"低语",
      u8"低调",
      u8"低谷",
      u8"低质量",
      u8"低贱",
      u8"低资费",
      u8"低辐射",
      u8"低迷",
      u8"低迷不振",
      u8"低迷区",
      u8"低通滤波器",
      u8"低速",
      u8"低造浆粘土",
      u8"低酚棉",
      u8"低钠血症",
      u8"低钾血症",
      u8"低阶",
      u8"低阶语言",
      u8"低陷",
      u8"低音",
      u8"低音单簧管",
      u8"低音大管",
      u8"低音弦",
      u8"低音提琴",
      u8"低音炮",
      u8"低音管",
      u8"低音部",
      u8"低音长号",
      u8"低频",
      u8"低频放大器",
      u8"低频词",
      u8"低飞",
      u8"低飞球",
      u8"低首",
      u8"低首下心",
      u8"低首下气",
      u8"低高型",
      u8"低龄",
      u8"低龄化",
      u8"住上",
      u8"住下",
      u8"住下去",
      u8"住下来",
      u8"住个",
      u8"住乐",
      u8"住了",
      u8"住交会",
      u8"住到",
      u8"住勤",
      u8"住博会",
      u8"住友",
      u8"住口",
      u8"住嘴",
      u8"住在",
      u8"住在一起",
      u8"住地",
      u8"住址",
      u8"住处",
      u8"住外",
      u8"住宅",
      u8"住宅产业",
      u8"住宅区",
      u8"住宅和",
      u8"住宅小区",
      u8"住宅布局",
      u8"住宅建筑企划委员会",
      u8"住宅建设",
      u8"住宅房",
      u8"住宅楼",
      u8"住家",
      u8"住宿",
      u8"住宿服务",
      u8"住宿楼",
      u8"住宿生",
      u8"住宿费",
      u8"住寺",
      u8"住居",
      u8"住屋",
      u8"住店",
      u8"住得",
      u8"住惯",
      u8"住户",
      u8"住房",
      u8"住房价格",
      u8"住房供给",
      u8"住房条件",
      u8"住房补贴",
      u8"住房贷款",
      u8"住房问题",
      u8"住房难",
      u8"住房面积",
      u8"住所",
      u8"住所地",
      u8"住手",
      u8"住持",
      u8"住有",
      u8"住校",
      u8"住校生",
      u8"住民",
      u8"住用",
      u8"住留",
      u8"住着",
      u8"住者",
      u8"住诊",
      u8"住读",
      u8"住读生",
      u8"住起",
      u8"住起来",
      u8"住足",
      u8"住进",
      u8"住院",
      u8"住院医师",
      u8"住院医生",
      u8"住院处",
      u8"住院手续",
      u8"住院治疗",
      u8"住院病人",
      u8"住院费",
      u8"住院费用",
      u8"住院部",
      u8"佐丹奴",
      u8"佐伯",
      u8"佐佐木",
      u8"佐使",
      u8"佐剂",
      u8"佐料",
      u8"佐治亚",
      u8"佐治亚州",
      u8"佐治亚理工学院",
      u8"佐治华盛顿",
      u8"佐理",
      u8"佐理员",
      u8"佐细胞",
      u8"佐罗",
      u8"佐藤",
      u8"佐藤浩市",
      u8"佐藤蓝子",
      u8"佐藤超函数",
      u8"佐证",
      u8"佐酒",
      u8"佐野",
      u8"佐雍得尝",
      u8"佐餐",
      u8"佐饔得尝",
      u8"佑助",
      u8"佑庇",
      u8"佑德",
      u8"佑护",
      u8"体专",
      u8"体会",
      u8"体会出",
      u8"体会到",
      u8"体位",
      u8"体位法",
      u8"体体面面",
      u8"体例",
      u8"体全息图",
      u8"体内",
      u8"体内平衡",
      u8"体内诱变",
      u8"体制",
      u8"体制性",
      u8"体制改革",
      u8"体力",
      u8"体力不支",
      u8"体力值",
      u8"体力劳动",
      u8"体力活",
      u8"体力过人",
      u8"体协",
      u8"体博会",
      u8"体味",
      u8"体国经野",
      u8"体坛",
      u8"体坛人士",
      u8"体坛周报",
      u8"体型",
      u8"体壁",
      u8"体外",
      u8"体外受精",
      u8"体外循环",
      u8"体外诱变",
      u8"体大思精",
      u8"体天格物",
      u8"体委",
      u8"体宽",
      u8"体察",
      u8"体察下情",
      u8"体察出",
      u8"体察到",
      u8"体察民情",
      u8"体尝",
      u8"体工队",
      u8"体己",
      u8"体已",
      u8"体式",
      u8"体弱",
      u8"体弱多病",
      u8"体弱者",
      u8"体形",
      u8"体彩",
      u8"体彩网",
      u8"体征",
      u8"体循环",
      u8"体念",
      u8"体态",
      u8"体态语",
      u8"体态轻盈",
      u8"体性",
      u8"体总",
      u8"体总网",
      u8"体恤",
      u8"体恤入微",
      u8"体恤衫",
      u8"体息",
      u8"体悉",
      u8"体悟",
      u8"体惜",
      u8"体操",
      u8"体操台",
      u8"体操器械",
      u8"体操房",
      u8"体操比赛",
      u8"体操课",
      u8"体操赛",
      u8"体操选手",
      u8"体操队",
      u8"体改",
      u8"体改办",
      u8"体改委",
      u8"体无完皮",
      u8"体无完肤",
      u8"体查",
      u8"体校",
      u8"体格",
      u8"体格健壮",
      u8"体格检查",
      u8"体检",
      u8"体检中心",
      u8"体检工作",
      u8"体检标准",
      u8"体检表",
      u8"体气渐衰",
      u8"体法",
      u8"体液",
      u8"体温",
      u8"体温节律",
      u8"体温表",
      u8"体温计",
      u8"体热",
      u8"体物缘情",
      u8"体现",
      u8"体现出",
      u8"体现在",
      u8"体现者",
      u8"体用",
      u8"体癣",
      u8"体矩阵",
      u8"体积",
      u8"体积小",
      u8"体积计",
      u8"体突变",
      u8"体系",
      u8"体系化",
      u8"体系结构",
      u8"体素构造表示",
      u8"体细胞",
      u8"体细胞杂交",
      u8"体统",
      u8"体罚",
      u8"体肤",
      u8"体肤之亲",
      u8"体育",
      u8"体育专科",
      u8"体育专科学校",
      u8"体育中心",
      u8"体育事业",
      u8"体育产业",
      u8"体育人物",
      u8"体育会",
      u8"体育健儿",
      u8"体育台",
      u8"体育史",
      u8"体育器材",
      u8"体育场",
      u8"体育场地",
      u8"体育场馆",
      u8"体育学院",
      u8"体育局",
      u8"体育彩票",
      u8"体育心理学",
      u8"体育总局",
      u8"体育报",
      u8"体育教师",
      u8"体育新闻",
      u8"体育明星",
      u8"体育比赛",
      u8"体育法",
      u8"体育活动",
      u8"体育爱好者",
      u8"体育片",
      u8"体育版",
      u8"体育用品",
      u8"体育用品业",
      u8"体育界",
      u8"体育竞争",
      u8"体育竞技",
      u8"体育竞赛",
      u8"体育类",
      u8"体育精神",
      u8"体育系",
      u8"体育组",
      u8"体育网",
      u8"体育老师",
      u8"体育考试",
      u8"体育节",
      u8"体育节目",
      u8"体育训练",
      u8"体育讯",
      u8"体育论文",
      u8"体育设施",
      u8"体育课",
      u8"体育赛事",
      u8"体育运动",
      u8"体育运动区",
      u8"体育运动委员会",
      u8"体育选手",
      u8"体育道德",
      u8"体育部",
      u8"体育锻炼",
      u8"体育院校",
      u8"体育项目",
      u8"体育频道",
      u8"体育馆",
      u8"体胀系数",
      u8"体能",
      u8"体能测验",
      u8"体能训练",
      u8"体腔",
      u8"体膨胀",
      u8"体臭",
      u8"体臭味",
      u8"体节",
      u8"体范",
      u8"体虱",
      u8"体表",
      u8"体裁",
      u8"体裁形式",
      u8"体要",
      u8"体规画圆",
      u8"体视",
      u8"体视学",
      u8"体觉",
      u8"体认",
      u8"体认出",
      u8"体认到",
      u8"体词",
      u8"体谅",
      u8"体貌",
      u8"体貌特征",
      u8"体质",
      u8"体贴",
      u8"体贴人",
      u8"体贴入妙",
      u8"体贴入微",
      u8"体酶类",
      u8"体重",
      u8"体重减轻",
      u8"体重增加",
      u8"体重表",
      u8"体重计",
      u8"体量",
      u8"体长",
      u8"体院",
      u8"体面",
      u8"体面地",
      u8"体面扫地",
      u8"体面起来",
      u8"体香",
      u8"体验",
      u8"体验出",
      u8"体验到",
      u8"体验式",
      u8"体验版",
      u8"体验生活",
      u8"体高",
      u8"体魄",
      u8"何三七",
      u8"何不",
      u8"何中华",
      u8"何为",
      u8"何乐不为",
      u8"何乐而不为",
      u8"何也",
      u8"何事",
      u8"何人",
      u8"何人之手",
      u8"何仙姑",
      u8"何以",
      u8"何以堪",
      u8"何以自处",
      u8"何以见得",
      u8"何仪",
      u8"何伟",
      u8"何依静",
      u8"何俐恩",
      u8"何先生",
      u8"何光暐",
      u8"何其",
      u8"何其毒也",
      u8"何其相似",
      u8"何其相似乃尔",
      u8"何其糊涂",
      u8"何其芳",
      u8"何冰",
      u8"何况",
      u8"何况是",
      u8"何勇",
      u8"何厚铧",
      u8"何原因",
      u8"何去何从",
      u8"何启南",
      u8"何啻",
      u8"何嘉文",
      u8"何国",
      u8"何在",
      u8"何地",
      u8"何堪",
      u8"何处",
      u8"何处去",
      u8"何处寻",
      u8"何太冲",
      u8"何太后",
      u8"何奇不有",
      u8"何如",
      u8"何如云",
      u8"何妨",
      u8"何婉盈",
      u8"何宗道",
      u8"何宝生",
      u8"何家劲",
      u8"何家驹",
      u8"何尝",
      u8"何尝不可",
      u8"何干",
      u8"何年",
      u8"何年何月",
      u8"何年何月何日",
      u8"何庆魁",
      u8"何应钦",
      u8"何当",
      u8"何德何能",
      u8"何必",
      u8"何必如此",
      u8"何必当初",
      u8"何志军",
      u8"何志平",
      u8"何思豪",
      u8"何患",
      u8"何患无词",
      u8"何患无辞",
      u8"何惕守",
      u8"何惧",
      u8"何愁",
      u8"何意",
      u8"何所不为",
      u8"何所不有",
      u8"何所不至",
      u8"何承天",
      u8"何政军",
      u8"何故",
      u8"何方",
      u8"何方神圣",
      u8"何日",
      u8"何时",
      u8"何时休",
      u8"何时何地",
      u8"何时能",
      u8"何晏",
      u8"何晴",
      u8"何曾",
      u8"何月",
      u8"何月何日",
      u8"何望海",
      u8"何来",
      u8"何样",
      u8"何椿霖",
      u8"何止",
      u8"何氏凤仙",
      u8"何洁",
      u8"何润东",
      u8"何燕",
      u8"何物",
      u8"何独",
      u8"何琳",
      u8"何瑞荣",
      u8"何用",
      u8"何祚麻",
      u8"何秋萍",
      u8"何种",
      u8"何种地步",
      u8"何等",
      u8"何红药",
      u8"何绍基",
      u8"何罪之有",
      u8"何美婷",
      u8"何美细",
      u8"何美萍",
      u8"何美钿",
      u8"何羲",
      u8"何耀珊",
      u8"何者",
      u8"何能",
      u8"何腾蛟",
      u8"何至于",
      u8"何至于此",
      u8"何苗",
      u8"何若",
      u8"何苦",
      u8"何苦乃尔",
      u8"何苦来哉",
      u8"何莉莉",
      u8"何解",
      u8"何许",
      u8"何许人",
      u8"何许人也",
      u8"何论魏晋",
      u8"何谈",
      u8"何谓",
      u8"何赛飞",
      u8"何超仪",
      u8"何超明",
      u8"何足",
      u8"何足为奇",
      u8"何足介意",
      u8"何足挂齿",
      u8"何足轻重",
      u8"何足道",
      u8"何足道哉",
      u8"何进",
      u8"何铁手",
      u8"何错之有",
      u8"何队",
      u8"何难",
      u8"何难之有",
      u8"何雨",
      u8"何需",
      u8"何静",
      u8"何音",
      u8"何韵诗",
      u8"何须",
      u8"何首乌",
      u8"何香凝",
      u8"何鲁丽",
      u8"何麟",
      u8"佘太君",
      u8"佘祥林",
      u8"佘诗曼",
      u8"佘靖",
      u8"余下",
      u8"余下来",
      u8"余业遗烈",
      u8"余东风",
      u8"余事",
      u8"余事后叙",
      u8"余人",
      u8"余人彦",
      u8"余代数同态",
      u8"余值",
      u8"余元",
      u8"余兆兴",
      u8"余光",
      u8"余光中",
      u8"余光分人",
      u8"余党",
      u8"余兴",
      u8"余兴节目",
      u8"余函数",
      u8"余切",
      u8"余切向量",
      u8"余利",
      u8"余剩",
      u8"余割",
      u8"余力",
      u8"余勇可嘉",
      u8"余勇可贾",
      u8"余味",
      u8"余味回甘",
      u8"余味无穷",
      u8"余响绕梁",
      u8"余因子",
      u8"余地",
      u8"余址",
      u8"余声三日",
      u8"余外",
      u8"余天",
      u8"余头",
      u8"余妙绕梁",
      u8"余姚",
      u8"余姚市",
      u8"余威",
      u8"余婆婆",
      u8"余子碌碌",
      u8"余存",
      u8"余孽",
      u8"余安安",
      u8"余家",
      u8"余家村",
      u8"余巾",
      u8"余干",
      u8"余干县",
      u8"余年",
      u8"余庆",
      u8"余庆县",
      u8"余式定理",
      u8"余弦",
      u8"余弦公式",
      u8"余弦定理",
      u8"余怒未消",
      u8"余悸",
      u8"余悸犹存",
      u8"余情",
      u8"余情未了",
      u8"余振东",
      u8"余摆线聚焦质谱仪",
      u8"余数",
      u8"余文乐",
      u8"余料",
      u8"余日",
      u8"余晖",
      u8"余暇",
      u8"余暇生活空间",
      u8"余杭",
      u8"余杭区",
      u8"余杭县",
      u8"余杭镇",
      u8"余杯冷炙",
      u8"余桃",
      u8"余桃啖君",
      u8"余桃市",
      u8"余模",
      u8"余款",
      u8"余正二次型",
      u8"余步",
      u8"余毒",
      u8"余氯",
      u8"余永定",
      u8"余江",
      u8"余江县",
      u8"余沧海",
      u8"余法向导数",
      u8"余波",
      u8"余波未停",
      u8"余波未平",
      u8"余波荡漾",
      u8"余泽",
      u8"余温",
      u8"余火未熄",
      u8"余烬",
      u8"余烬复燃",
      u8"余热",
      u8"余犯",
      u8"余生",
      u8"余电",
      u8"余留",
      u8"余种",
      u8"余类推",
      u8"余粮",
      u8"余粮收集",
      u8"余粮收集制",
      u8"余纬度",
      u8"余纯顺",
      u8"余维数",
      u8"余缺",
      u8"余者",
      u8"余脉",
      u8"余腥残秽",
      u8"余膏剩馥",
      u8"余荫",
      u8"余蓄",
      u8"余裕",
      u8"余角",
      u8"余言",
      u8"余诗曼",
      u8"余误差函数分布",
      u8"余辉",
      u8"余量",
      u8"余钱",
      u8"余闲",
      u8"余震",
      u8"余震不断",
      u8"余霞成绮",
      u8"余霞散绮",
      u8"余露成绮",
      u8"余音",
      u8"余音嫋嫋",
      u8"余音犹在",
      u8"余音绕梁",
      u8"余音缭绕",
      u8"余音袅绕",
      u8"余音袅袅",
      u8"余韵",
      u8"余韵流风",
      u8"余项",
      u8"余额",
      u8"余风",
      u8"余风遗文",
      u8"余食赘行",
      u8"余香",
      u8"余香满口",
      u8"余鱼同",
      u8"佚事",
      u8"佚名",
      u8"佚失",
      u8"佚文",
      u8"佛事",
      u8"佛佗",
      u8"佛像",
      u8"佛像卡",
      u8"佛光",
      u8"佛光寺",
      u8"佛光山",
      u8"佛兰克林",
      u8"佛典",
      u8"佛冈",
      u8"佛冈县",
      u8"佛力",
      u8"佛劳伦斯",
      u8"佛劳伦斯人",
      u8"佛协",
      u8"佛口蛇心",
      u8"佛号",
      u8"佛国",
      u8"佛图澄",
      u8"佛土",
      u8"佛坪",
      u8"佛坪县",
      u8"佛堂",
      u8"佛塔",
      u8"佛头",
      u8"佛头加秽",
      u8"佛头着粪",
      u8"佛头著粪",
      u8"佛如",
      u8"佛学",
      u8"佛学界",
      u8"佛学院",
      u8"佛宝",
      u8"佛家",
      u8"佛家弟子",
      u8"佛家语",
      u8"佛寺",
      u8"佛山",
      u8"佛山人",
      u8"佛山市",
      u8"佛得角",
      u8"佛心",
      u8"佛心蛇口",
      u8"佛性",
      u8"佛性禅心",
      u8"佛手",
      u8"佛手柑",
      u8"佛手瓜",
      u8"佛拉明戈",
      u8"佛拉芒",
      u8"佛提树",
      u8"佛教",
      u8"佛教徒",
      u8"佛教文化",
      u8"佛教界",
      u8"佛教论坛",
      u8"佛是金妆",
      u8"佛是金妆人是衣妆",
      u8"佛是金装人是衣装",
      u8"佛殿",
      u8"佛法",
      u8"佛法徒",
      u8"佛法无边",
      u8"佛波醇",
      u8"佛洛伊德",
      u8"佛洛依德",
      u8"佛洛依德派",
      u8"佛湾",
      u8"佛灯",
      u8"佛爷",
      u8"佛牙",
      u8"佛珠",
      u8"佛甲草",
      u8"佛眼佛心",
      u8"佛眼相看",
      u8"佛祖",
      u8"佛经",
      u8"佛罗伦",
      u8"佛罗伦萨",
      u8"佛罗多",
      u8"佛罗棱萨",
      u8"佛罗里",
      u8"佛罗里达",
      u8"佛罗里达州",
      u8"佛老",
      u8"佛肚竹",
      u8"佛蒙特",
      u8"佛蒙特州",
      u8"佛要金装",
      u8"佛诞",
      u8"佛语",
      u8"佛跳墙",
      u8"佛释",
      u8"佛门",
      u8"佛门弟子",
      u8"佛陀",
      u8"佛青",
      u8"佛骨",
      u8"佛高一尺魔高一丈",
      u8"佛龛",
      u8"作业",
      u8"作业区",
      u8"作业吃水",
      u8"作业员",
      u8"作业录入",
      u8"作业成绩",
      u8"作业指导书",
      u8"作业本",
      u8"作业条件",
      u8"作业簿",
      u8"作业系统",
      u8"作业负担",
      u8"作业题",
      u8"作东",
      u8"作为",
      u8"作为党",
      u8"作为基础",
      u8"作主",
      u8"作乐",
      u8"作乱",
      u8"作了",
      u8"作事",
      u8"作事不时",
      u8"作些",
      u8"作人",
      u8"作代会",
      u8"作件",
      u8"作价",
      u8"作伐",
      u8"作伥",
      u8"作伪",
      u8"作伪者",
      u8"作伪证",
      u8"作伪证者",
      u8"作伴",
      u8"作何",
      u8"作何解释",
      u8"作作有芒",
      u8"作俑",
      u8"作保",
      u8"作保证",
      u8"作假",
      u8"作兴",
      u8"作准",
      u8"作出",
      u8"作出了",
      u8"作出公断",
      u8"作出决定",
      u8"作出努力",
      u8"作出反应",
      u8"作出姿态",
      u8"作出指示",
      u8"作出来",
      u8"作出规定",
      u8"作出评价",
      u8"作出贡献",
      u8"作别",
      u8"作到",
      u8"作功",
      u8"作势",
      u8"作协",
      u8"作古",
      u8"作古正经",
      u8"作呕",
      u8"作和",
      u8"作品",
      u8"作品名称",
      u8"作品展",
      u8"作品展览",
      u8"作品版权",
      u8"作品简介",
      u8"作品选",
      u8"作品集",
      u8"作响",
      u8"作善降祥",
      u8"作困兽斗",
      u8"作图",
      u8"作图器",
      u8"作坊",
      u8"作坊式",
      u8"作壁上观",
      u8"作声",
      u8"作多",
      u8"作奸犯科",
      u8"作好",
      u8"作好作歹",
      u8"作如是观",
      u8"作威作福",
      u8"作嫁",
      u8"作嫁衣裳",
      u8"作孽",
      u8"作宅",
      u8"作官",
      u8"作客",
      u8"作家",
      u8"作家出版社",
      u8"作家列表",
      u8"作家协会",
      u8"作家网",
      u8"作家群",
      u8"作对",
      u8"作小服低",
      u8"作崇",
      u8"作工",
      u8"作庄",
      u8"作序",
      u8"作序言",
      u8"作废",
      u8"作弄",
      u8"作弊",
      u8"作弊器",
      u8"作弊码",
      u8"作弊者",
      u8"作态",
      u8"作怒",
      u8"作怪",
      u8"作息",
      u8"作息制度",
      u8"作息时间",
      u8"作息时间表",
      u8"作恶",
      u8"作恶多端",
      u8"作戏",
      u8"作成",
      u8"作战",
      u8"作战方案",
      u8"作战服",
      u8"作战经验",
      u8"作手脚",
      u8"作揖",
      u8"作操",
      u8"作数",
      u8"作文",
      u8"作文法",
      u8"作文簿",
      u8"作文网",
      u8"作文课",
      u8"作文选",
      u8"作文集",
      u8"作文题",
      u8"作文题目",
      u8"作斗争",
      u8"作料",
      u8"作曲",
      u8"作曲家",
      u8"作月子",
      u8"作案",
      u8"作案人",
      u8"作案分子",
      u8"作案动机",
      u8"作案嫌疑",
      u8"作案工具",
      u8"作案时间",
      u8"作案现场",
      u8"作梗",
      u8"作梦",
      u8"作梦也没想到",
      u8"作槽",
      u8"作歹",
      u8"作死",
      u8"作殊死战",
      u8"作比较",
      u8"作法",
      u8"作法自弊",
      u8"作法自毙",
      u8"作活",
      u8"作派",
      u8"作浪兴风",
      u8"作滴答声",
      u8"作爱",
      u8"作物",
      u8"作物布局",
      u8"作物栽培",
      u8"作物气候适应性",
      u8"作物气象",
      u8"作物生理学",
      u8"作物科学",
      u8"作物组合",
      u8"作物育种学",
      u8"作物起源",
      u8"作甚",
      u8"作生意",
      u8"作用",
      u8"作用于",
      u8"作用力",
      u8"作用点",
      u8"作用量",
      u8"作画",
      u8"作痛",
      u8"作登乡",
      u8"作礼拜",
      u8"作祟",
      u8"作福作威",
      u8"作秀",
      u8"作笔记",
      u8"作答",
      u8"作罢",
      u8"作美",
      u8"作者",
      u8"作者姓名",
      u8"作者简介",
      u8"作育人材",
      u8"作脸",
      u8"作舍道旁",
      u8"作舍道边",
      u8"作船",
      u8"作色",
      u8"作艺",
      u8"作茧自缚",
      u8"作裁判",
      u8"作言造语",
      u8"作记号",
      u8"作证",
      u8"作词",
      u8"作词家",
      u8"作诗",
      u8"作贡献",
      u8"作账",
      u8"作贱",
      u8"作贱自己",
      u8"作贼",
      u8"作贼心虚",
      u8"作赔",
      u8"作践",
      u8"作辍无常",
      u8"作过",
      u8"作金石声",
      u8"作陪",
      u8"作难",
      u8"作风",
      u8"作风严谨",
      u8"作风修养",
      u8"作风正派",
      u8"作风民主",
      u8"作风浮夸",
      u8"作风粗暴",
      u8"作风纪律",
      u8"作风过硬",
      u8"作风霸道",
      u8"作饭",
      u8"作鬼",
      u8"作鬼脸",
      u8"作鸟兽散",
      u8"佝偻",
      u8"佝偻病",
      u8"佝瘘病",
      u8"佞人",
      u8"佞佛",
      u8"佞口",
      u8"佞笑",
      u8"佞臣",
      u8"佟湘玉",
      u8"你一言",
      u8"你一言我一语",
      u8"你中有我",
      u8"你争我夺",
      u8"你们",
      u8"你俩",
      u8"你哥",
      u8"你哥哥",
      u8"你唱我和",
      u8"你夺我争",
      u8"你好",
      u8"你好坏",
      u8"你妈",
      u8"你家",
      u8"你弟",
      u8"你想",
      u8"你我",
      u8"你我他",
      u8"你报",
      u8"你推我让",
      u8"你来我往",
      u8"你死我活",
      u8"你爹",
      u8"你追我赶",
      u8"佣中佼佼",
      u8"佣书",
      u8"佣人",
      u8"佣仆",
      u8"佣兵",
      u8"佣兵团",
      u8"佣奴",
      u8"佣工",
      u8"佣懒",
      u8"佣耕",
      u8"佣金",
      u8"佣金制",
      u8"佣钱",
      u8"佤族",
      u8"佧佤族",
      u8"佩佩",
      u8"佩兰",
      u8"佩内洛普",
      u8"佩刀",
      u8"佩剑",
      u8"佩巾",
      u8"佩带",
      u8"佩带在",
      u8"佩带着",
      u8"佩德罗",
      u8"佩思",
      u8"佩恩",
      u8"佩戴",
      u8"佩戴桂冠",
      u8"佩挂",
      u8"佩服",
      u8"佩服之致",
      u8"佩服得五体投地",
      u8"佩枪",
      u8"佩特",
      u8"佩玉",
      u8"佩环",
      u8"佩着",
      u8"佩紫怀黄",
      u8"佩花",
      u8"佩诺",
      u8"佩迪",
      u8"佩雷拉",
      u8"佩韦佩弦",
      u8"佩饰",
      u8"佩鲁甲",
      u8"佯伪",
      u8"佯动",
      u8"佯嗔",
      u8"佯改",
      u8"佯攻",
      u8"佯死",
      u8"佯狂",
      u8"佯称",
      u8"佯笑",
      u8"佯细",
      u8"佯装",
      u8"佯装不知",
      u8"佯言",
      u8"佯谬",
      u8"佯轮诈败",
      u8"佯输诈败",
      u8"佯降",
      u8"佯风诈冒",
      u8"佰草集",
      u8"佳丽",
      u8"佳乐水",
      u8"佳人",
      u8"佳人才子",
      u8"佳人薄命",
      u8"佳作",
      u8"佳作奖",
      u8"佳佳",
      u8"佳佳工作室",
      u8"佳佳影院",
      u8"佳佳艾",
      u8"佳侣",
      u8"佳偶",
      u8"佳偶天成",
      u8"佳儿佳妇",
      u8"佳兵不祥",
      u8"佳冬",
      u8"佳利",
      u8"佳县",
      u8"佳句",
      u8"佳品",
      u8"佳园",
      u8"佳城",
      u8"佳境",
      u8"佳士得",
      u8"佳妙",
      u8"佳婿",
      u8"佳客",
      u8"佳宾",
      u8"佳日",
      u8"佳旺",
      u8"佳景",
      u8"佳期",
      u8"佳期已近",
      u8"佳木斯",
      u8"佳木斯市",
      u8"佳木斯港",
      u8"佳构",
      u8"佳洁士",
      u8"佳的美",
      u8"佳篇",
      u8"佳约",
      u8"佳绩",
      u8"佳美",
      u8"佳肴",
      u8"佳肴珍馐",
      u8"佳肴美酒",
      u8"佳能",
      u8"佳节",
      u8"佳茗",
      u8"佳讯",
      u8"佳评",
      u8"佳评如潮",
      u8"佳话",
      u8"佳貌",
      u8"佳软",
      u8"佳软中国",
      u8"佳运",
      u8"佳酝",
      u8"佳酿",
      u8"佳里",
      u8"佳闻",
      u8"佳音",
      u8"佳音频传",
      u8"佶屈聱牙",
      u8"佹形僪状",
      u8"佹得佹失",
      u8"佻巧",
      u8"佻薄",
      u8"佻身飞镞",
      u8"佻达",
      u8"佼佼",
      u8"佼佼者",
      u8"佼容",
      u8"佼貌",
      u8"佾生",
      u8"佾舞",
      u8"佾舞生",
      u8"使不得",
      u8"使乖弄巧",
      u8"使人昭昭",
      u8"使令",
      u8"使其",
      u8"使出",
      u8"使功不如使过",
      u8"使劲",
      u8"使劲儿",
      u8"使劲顶",
      u8"使君",
      u8"使君子",
      u8"使命",
      u8"使命感",
      u8"使唤",
      u8"使嘴使舌",
      u8"使团",
      u8"使坏",
      u8"使坐",
      u8"使女",
      u8"使役",
      u8"使徒",
      u8"使得",
      u8"使心作倖",
      u8"使心作幸",
      u8"使心别气",
      u8"使心用倖",
      u8"使心用幸",
      u8"使心用腹",
      u8"使性傍气",
      u8"使性子",
      u8"使性掼气",
      u8"使性谤气",
      u8"使愚使过",
      u8"使手机",
      u8"使料所及",
      u8"使智使勇",
      u8"使然",
      u8"使用",
      u8"使用不当",
      u8"使用价值",
      u8"使用寿命",
      u8"使用性能",
      u8"使用情况",
      u8"使用手册",
      u8"使用手记",
      u8"使用报告",
      u8"使用指南",
      u8"使用方便",
      u8"使用方法",
      u8"使用时间",
      u8"使用暴力",
      u8"使用期",
      u8"使用期费用",
      u8"使用权",
      u8"使用法",
      u8"使用版",
      u8"使用率",
      u8"使用税",
      u8"使用者",
      u8"使用自己电脑",
      u8"使用范围",
      u8"使用证",
      u8"使用说明",
      u8"使用费",
      u8"使用过程中",
      u8"使用量",
      u8"使用限制权",
      u8"使用面积",
      u8"使眼色",
      u8"使羊将狼",
      u8"使者",
      u8"使臂使指",
      u8"使臂指使",
      u8"使臣",
      u8"使舵",
      u8"使节",
      u8"使节团",
      u8"使蚊负山",
      u8"使贤任能",
      u8"使贪使愚",
      u8"使酒骂坐",
      u8"使酒骂座",
      u8"使领馆",
      u8"使馆",
      u8"使馆区",
      u8"侃侃",
      u8"侃侃而言",
      u8"侃侃而谈",
      u8"侃侃訚訚",
      u8"侃侃谔谔",
      u8"侃大山",
      u8"侃山",
      u8"侃快",
      u8"侃直",
      u8"侄儿",
      u8"侄外孙",
      u8"侄女",
      u8"侄女婿",
      u8"侄妇",
      u8"侄婿",
      u8"侄媳",
      u8"侄媳妇",
      u8"侄子",
      u8"侄孙",
      u8"侄孙女",
      u8"侈丽闳衍",
      u8"侈人观听",
      u8"侈侈不休",
      u8"侈恩席宠",
      u8"侈纵偷苟",
      u8"侈衣美食",
      u8"侈言",
      u8"侈谈",
      u8"侈谈和平",
      u8"侈靡",
      u8"侉子",
      u8"例举",
      u8"例会",
      u8"例假",
      u8"例假日",
      u8"例假日除外",
      u8"例句",
      u8"例外",
      u8"例外情况",
      u8"例外若尔当代数",
      u8"例如",
      u8"例如说",
      u8"例如说是",
      u8"例子",
      u8"例数",
      u8"例文",
      u8"例案",
      u8"例牌",
      u8"例直禁简",
      u8"例示",
      u8"例程",
      u8"例行",
      u8"例行公事",
      u8"例行决策",
      u8"例行工作",
      u8"例行差事",
      u8"例行程序",
      u8"例规",
      u8"例言",
      u8"例证",
      u8"例语",
      u8"例题",
      u8"侍中",
      u8"侍仆",
      u8"侍从",
      u8"侍从官",
      u8"侍从长",
      u8"侍侯",
      u8"侍候",
      u8"侍养",
      u8"侍剑",
      u8"侍卫",
      u8"侍卫长",
      u8"侍奉",
      u8"侍女",
      u8"侍妾",
      u8"侍应",
      u8"侍应生",
      u8"侍弄",
      u8"侍执巾节",
      u8"侍立",
      u8"侍童",
      u8"侍者",
      u8"侍郎",
      u8"侍魂",
      u8"侏儒",
      u8"侏儒一节",
      u8"侏儒型菌落",
      u8"侏儒症",
      u8"侏儒观戏",
      u8"侏罗世",
      u8"侏罗系",
      u8"侏罗纪",
      u8"侔色揣称",
      u8"侗乡",
      u8"侗寨",
      u8"侗族",
      u8"供不应求",
      u8"供事",
      u8"供产销",
      u8"供人",
      u8"供住",
      u8"供体",
      u8"供佛",
      u8"供养",
      u8"供养父母",
      u8"供出",
      u8"供制",
      u8"供办",
      u8"供品",
      u8"供售",
      u8"供在",
      u8"供堂",
      u8"供大于求",
      u8"供奉",
      u8"供应",
      u8"供应价格",
      u8"供应司",
      u8"供应品",
      u8"供应商",
      u8"供应器",
      u8"供应国",
      u8"供应地",
      u8"供应处",
      u8"供应方",
      u8"供应点",
      u8"供应科",
      u8"供应站",
      u8"供应者",
      u8"供应量",
      u8"供应链",
      u8"供房",
      u8"供招",
      u8"供排水",
      u8"供料",
      u8"供暖",
      u8"供暖系统",
      u8"供暖费",
      u8"供果",
      u8"供案",
      u8"供桌",
      u8"供楼",
      u8"供气",
      u8"供气站",
      u8"供氢裂化",
      u8"供水",
      u8"供水干管",
      u8"供水管",
      u8"供水系统",
      u8"供水量",
      u8"供求",
      u8"供求信息",
      u8"供求关系",
      u8"供求失调",
      u8"供求平衡",
      u8"供求律",
      u8"供求矛盾",
      u8"供求网",
      u8"供油",
      u8"供油泵",
      u8"供热",
      u8"供状",
      u8"供用电",
      u8"供电",
      u8"供电局",
      u8"供电所",
      u8"供电站",
      u8"供电系统",
      u8"供神",
      u8"供种",
      u8"供称",
      u8"供稿",
      u8"供粮",
      u8"供给",
      u8"供给制",
      u8"供给燃料",
      u8"供给者",
      u8"供给量",
      u8"供职",
      u8"供膳宿",
      u8"供认",
      u8"供认不讳",
      u8"供词",
      u8"供说",
      u8"供货",
      u8"供货商",
      u8"供货期",
      u8"供货渠道",
      u8"供货量",
      u8"供过于求",
      u8"供述",
      u8"供述动机",
      u8"供配电",
      u8"供销",
      u8"供销业",
      u8"供销中心",
      u8"供销合作",
      u8"供销合作社",
      u8"供销合同",
      u8"供销员",
      u8"供销商",
      u8"供销社",
      u8"供销科",
      u8"供销系统",
      u8"供销部门",
      u8"供需",
      u8"供需双方",
      u8"供需失调",
      u8"供需平衡",
      u8"供需矛盾",
      u8"供需见面",
      u8"供餐",
      u8"侜张为幻",
      u8"依丱附木",
      u8"依丽莎白",
      u8"依人",
      u8"依人作嫁",
      u8"依人篱下",
      u8"依从",
      u8"依从关系",
      u8"依从性",
      u8"依仗",
      u8"依例",
      u8"依侍",
      u8"依依",
      u8"依依不舍",
      u8"依依恋恋",
      u8"依依惜别",
      u8"依偎",
      u8"依傍",
      u8"依傍在",
      u8"依允",
      u8"依兰",
      u8"依兰县",
      u8"依兰特",
      u8"依其",
      u8"依凭",
      u8"依利诺",
      u8"依利达",
      u8"依多金",
      u8"依头缕当",
      u8"依头顺尾",
      u8"依妹儿",
      u8"依存",
      u8"依存关系",
      u8"依存度",
      u8"依存性",
      u8"依存链",
      u8"依安",
      u8"依安县",
      u8"依山傍水",
      u8"依序",
      u8"依序是",
      u8"依归",
      u8"依律",
      u8"依循",
      u8"依循着",
      u8"依心像意",
      u8"依恋",
      u8"依我",
      u8"依我来看",
      u8"依我看",
      u8"依我看来",
      u8"依托",
      u8"依据",
      u8"依据事实",
      u8"依旧",
      u8"依旧会",
      u8"依旧在",
      u8"依旧是",
      u8"依星",
      u8"依本画葫芦",
      u8"依杖",
      u8"依柳辛",
      u8"依样",
      u8"依样画葫",
      u8"依样画葫芦",
      u8"依样葫芦",
      u8"依次",
      u8"依次为",
      u8"依次是",
      u8"依此",
      u8"依此类推",
      u8"依法",
      u8"依法严办",
      u8"依法严惩",
      u8"依法公正判决",
      u8"依法公正处理",
      u8"依法制裁",
      u8"依法办事",
      u8"依法办案",
      u8"依法办理",
      u8"依法取缔",
      u8"依法处理",
      u8"依法惩治",
      u8"依法打击",
      u8"依法执法",
      u8"依法查处",
      u8"依法治国",
      u8"依法治理",
      u8"依法炮制",
      u8"依法砲制",
      u8"依法罢免",
      u8"依法行事",
      u8"依法行政",
      u8"依法追究",
      u8"依法追究刑事责任",
      u8"依法逮捕",
      u8"依流平进",
      u8"依滢",
      u8"依然",
      u8"依然如故",
      u8"依然故我",
      u8"依然是",
      u8"依照",
      u8"依照着",
      u8"依物",
      u8"依率",
      u8"依稀",
      u8"依稀可见",
      u8"依稀记得",
      u8"依约",
      u8"依纪",
      u8"依经傍注",
      u8"依维斯",
      u8"依翠偎红",
      u8"依老卖老",
      u8"依草附木",
      u8"依葫芦画瓢",
      u8"依规蹈矩",
      u8"依赖",
      u8"依赖于",
      u8"依赖图",
      u8"依赖型人格障碍",
      u8"依赖度",
      u8"依赖思想",
      u8"依赖性",
      u8"依赖成性",
      u8"依赖症",
      u8"依赖边",
      u8"依达乡",
      u8"依违不决",
      u8"依违两可",
      u8"依通",
      u8"依通县",
      u8"依那普利",
      u8"依门傍户",
      u8"依门卖笑",
      u8"依阿取容",
      u8"依附",
      u8"依附于",
      u8"依附在",
      u8"依随",
      u8"依靠",
      u8"依靠人民",
      u8"依靠在",
      u8"依靠着",
      u8"依靠群众",
      u8"依靠职工",
      u8"依靠集体",
      u8"依顺",
      u8"依顺着",
      u8"侠义",
      u8"侠义精神",
      u8"侠义道",
      u8"侠之大",
      u8"侠之大者",
      u8"侠侣",
      u8"侠士",
      u8"侠女",
      u8"侠客",
      u8"侠客岛",
      u8"侠客游",
      u8"侠客狂花",
      u8"侠客行",
      u8"侠心",
      u8"侠气",
      u8"侠溪",
      u8"侠白",
      u8"侠盗",
      u8"侠肝义胆",
      u8"侠行",
      u8"侠辣",
      u8"侠风",
      u8"侠骨",
      u8"侣伴",
      u8"侥幸",
      u8"侥幸取胜",
      u8"侥幸心理",
      u8"侥幸获胜",
      u8"侦候",
      u8"侦办",
      u8"侦办案件",
      u8"侦听",
      u8"侦听台",
      u8"侦听员",
      u8"侦听器",
      u8"侦察",
      u8"侦察兵",
      u8"侦察员",
      u8"侦察地形",
      u8"侦察排",
      u8"侦察机",
      u8"侦察车",
      u8"侦察连",
      u8"侦探",
      u8"侦探团",
      u8"侦探小说",
      u8"侦探所",
      u8"侦探片",
      u8"侦探社",
      u8"侦探网",
      u8"侦控",
      u8"侦控措施",
      u8"侦查",
      u8"侦查人员",
      u8"侦查员",
      u8"侦查权",
      u8"侦查案件",
      u8"侦查监督",
      u8"侦查终结",
      u8"侦检",
      u8"侦毒",
      u8"侦测",
      u8"侦测器",
      u8"侦测码",
      u8"侦破",
      u8"侦破小说",
      u8"侦破案件",
      u8"侦结",
      u8"侦结率",
      u8"侦缉",
      u8"侦缉队",
      u8"侦获",
      u8"侦讯",
      u8"侦问",
      u8"侦防",
      u8"侦骑",
      u8"侧冲",
      u8"侧击",
      u8"侧刀",
      u8"侧卧",
      u8"侧卧位",
      u8"侧卧法",
      u8"侧厅",
      u8"侧压力",
      u8"侧压系数",
      u8"侧反射",
      u8"侧台",
      u8"侧后",
      u8"侧向",
      u8"侧向侵蚀",
      u8"侧向反射声",
      u8"侧向泄油井",
      u8"侧向滑动瓣",
      u8"侧向运移",
      u8"侧向配位",
      u8"侧向髁导斜度",
      u8"侧向髁道斜度",
      u8"侧基反应",
      u8"侧堡",
      u8"侧壁",
      u8"侧天窗",
      u8"侧室",
      u8"侧影",
      u8"侧支索",
      u8"侧方",
      u8"侧方关系",
      u8"侧方压缩",
      u8"侧方平衡",
      u8"侧方运动",
      u8"侧旁",
      u8"侧枝",
      u8"侧柏",
      u8"侧柏叶",
      u8"侧柱",
      u8"侧根",
      u8"侧泳",
      u8"侧目",
      u8"侧目而视",
      u8"侧睡",
      u8"侧空翻",
      u8"侧笔",
      u8"侧线",
      u8"侧翼",
      u8"侧翼区",
      u8"侧翼序列",
      u8"侧耳",
      u8"侧耳细听",
      u8"侧脑室",
      u8"侧腹",
      u8"侧舷炮",
      u8"侧芽",
      u8"侧蚀力",
      u8"侧视",
      u8"侧视图",
      u8"侧视圈",
      u8"侧记",
      u8"侧貌描记器",
      u8"侧足而立",
      u8"侧身",
      u8"侧身而卧",
      u8"侧边",
      u8"侧近",
      u8"侧部",
      u8"侧重",
      u8"侧重于",
      u8"侧重点",
      u8"侧门",
      u8"侧闻",
      u8"侧面",
      u8"侧面偏重",
      u8"侧面图",
      u8"侧面影象",
      u8"侧面性",
      u8"侧面采光",
      u8"侨乡",
      u8"侨光商专",
      u8"侨办",
      u8"侨务",
      u8"侨务办公室",
      u8"侨务委员",
      u8"侨务委员会",
      u8"侨务工作",
      u8"侨商",
      u8"侨团",
      u8"侨委会",
      u8"侨居",
      u8"侨居国",
      u8"侨居地",
      u8"侨居海外",
      u8"侨属",
      u8"侨情",
      u8"侨报",
      u8"侨校",
      u8"侨民",
      u8"侨汇",
      u8"侨汇券",
      u8"侨生",
      u8"侨界",
      u8"侨眷",
      u8"侨社",
      u8"侨联",
      u8"侨胞",
      u8"侨资",
      u8"侨陵",
      u8"侨领",
      u8"侪辈",
      u8"侭多侭少",
      u8"侮弄",
      u8"侮慢",
      u8"侮蔑",
      u8"侮辱",
      u8"侮辱性",
      u8"侮辱猥亵",
      u8"侮骂",
      u8"侯人英",
      u8"侯佩岑",
      u8"侯勇",
      u8"侯国",
      u8"侯天来",
      u8"侯宝林",
      u8"侯府",
      u8"侯方",
      u8"侯明杰",
      u8"侯服玉食",
      u8"侯湘婷",
      u8"侯爵",
      u8"侯爵地位",
      u8"侯爵夫人",
      u8"侯爷",
      u8"侯继林",
      u8"侯耀华",
      u8"侯补",
      u8"侯赛因",
      u8"侯跃华",
      u8"侯车",
      u8"侯选",
      u8"侯通海",
      u8"侯长荣",
      u8"侯门",
      u8"侯门似海",
      u8"侯门如海",
      u8"侯门深似海",
      u8"侯飞文",
      u8"侯马",
      u8"侯马市",
      u8"侯鸟",
      u8"侯龙涛",
      u8"侵伐",
      u8"侵入",
      u8"侵入体",
      u8"侵入校正",
      u8"侵入直径",
      u8"侵凌",
      u8"侵华",
      u8"侵华日军",
      u8"侵占",
      u8"侵占到",
      u8"侵占罪",
      u8"侵吞",
      u8"侵吞公款",
      u8"侵夺",
      u8"侵害",
      u8"侵害人",
      u8"侵害到",
      u8"侵并",
      u8"侵扰",
      u8"侵扰到",
      u8"侵晓",
      u8"侵晨",
      u8"侵权",
      u8"侵权人",
      u8"侵权案",
      u8"侵权渎职",
      u8"侵权行为",
      u8"侵染",
      u8"侵染源",
      u8"侵犯",
      u8"侵犯到",
      u8"侵略",
      u8"侵略军",
      u8"侵略国",
      u8"侵略性",
      u8"侵略成性",
      u8"侵略战争",
      u8"侵略扩张",
      u8"侵略者",
      u8"侵蚀",
      u8"侵蚀作用",
      u8"侵蚀到",
      u8"侵蚀土壤",
      u8"侵蚀基准面",
      u8"侵蚀循环",
      u8"侵蚀性",
      u8"侵蚀面",
      u8"侵袭",
      u8"侵袭到",
      u8"侵越",
      u8"便中",
      u8"便了",
      u8"便于",
      u8"便于工作",
      u8"便于管理",
      u8"便于解决",
      u8"便会",
      u8"便函",
      u8"便利",
      u8"便利商店",
      u8"便利店",
      u8"便利形",
      u8"便利性",
      u8"便去",
      u8"便可",
      u8"便名",
      u8"便在",
      u8"便士",
      u8"便壶",
      u8"便学",
      u8"便宜",
      u8"便宜从事",
      u8"便宜施行",
      u8"便宜行事",
      u8"便宜货",
      u8"便宴",
      u8"便尿",
      u8"便帽",
      u8"便应",
      u8"便当",
      u8"便当盒",
      u8"便成仁",
      u8"便所",
      u8"便打",
      u8"便把",
      u8"便把令来行",
      u8"便捷",
      u8"便携",
      u8"便携包",
      u8"便携式",
      u8"便携性",
      u8"便携机",
      u8"便无权",
      u8"便是",
      u8"便有",
      u8"便服",
      u8"便条",
      u8"便条儿",
      u8"便条纸",
      u8"便桥",
      u8"便桶",
      u8"便步",
      u8"便步走",
      u8"便民",
      u8"便民店",
      u8"便民措施",
      u8"便民服务",
      u8"便民网",
      u8"便池",
      u8"便溺",
      u8"便盆",
      u8"便知",
      u8"便秘",
      u8"便笺",
      u8"便笺本",
      u8"便签",
      u8"便给",
      u8"便能",
      u8"便药",
      u8"便菜",
      u8"便血",
      u8"便衣",
      u8"便衣人员",
      u8"便衣侦探",
      u8"便衣警察",
      u8"便衣队",
      u8"便装",
      u8"便要",
      u8"便览",
      u8"便路",
      u8"便车",
      u8"便辞巧说",
      u8"便辟",
      u8"便道",
      u8"便酌",
      u8"便门",
      u8"便鞋",
      u8"便餐",
      u8"便饭",
      u8"促产",
      u8"促使",
      u8"促凝剂",
      u8"促凝血酶原激酶",
      u8"促凝血酶原激酶原",
      u8"促分裂原",
      u8"促动",
      u8"促卵受精素",
      u8"促卵受精膜形态发生素",
      u8"促卵泡激素",
      u8"促发展",
      u8"促性腺激",
      u8"促性腺激素",
      u8"促性腺素",
      u8"促性腺素释放素",
      u8"促成",
      u8"促排卵",
      u8"促智药",
      u8"促炎细胞因子",
      u8"促狭",
      u8"促生产",
      u8"促甲状腺素",
      u8"促甲状腺素调节素",
      u8"促甲状腺素释放素",
      u8"促细胞分裂剂",
      u8"促肾上腺皮质素",
      u8"促肾上腺皮质素释放因子",
      u8"促肾上腺皮质素释放激素",
      u8"促肾上腺皮质素释放素",
      u8"促肾上腺皮质素释放素结合蛋白",
      u8"促胃动素",
      u8"促脉",
      u8"促膝",
      u8"促膝交谈",
      u8"促膝谈心",
      u8"促膝长谈",
      u8"促请",
      u8"促进",
      u8"促进会",
      u8"促进作用",
      u8"促进剂",
      u8"促进性",
      u8"促进改革",
      u8"促进法",
      u8"促进派",
      u8"促进生产",
      u8"促退",
      u8"促销",
      u8"促销价",
      u8"促销员",
      u8"促销品",
      u8"促销服",
      u8"促黄体素",
      u8"促黄体素释放素",
      u8"促黑素抑制素",
      u8"促黑素释放素",
      u8"俄亥俄",
      u8"俄亥俄州",
      u8"俄人",
      u8"俄何焼戈",
      u8"俄克拉何马",
      u8"俄克拉何马州",
      u8"俄克拉荷",
      u8"俄克拉荷马州",
      u8"俄共",
      u8"俄军",
      u8"俄军方",
      u8"俄勒冈",
      u8"俄勒冈州",
      u8"俄勒岗",
      u8"俄喀河",
      u8"俄国",
      u8"俄国人",
      u8"俄国共产",
      u8"俄国共产党",
      u8"俄国话",
      u8"俄城",
      u8"俄外长",
      u8"俄央行",
      u8"俄帝",
      u8"俄式",
      u8"俄总统",
      u8"俄文",
      u8"俄文版",
      u8"俄文系",
      u8"俄文组",
      u8"俄方",
      u8"俄歇电子能谱学",
      u8"俄海军",
      u8"俄狄浦斯",
      u8"俄皇",
      u8"俄空军",
      u8"俄罗斯",
      u8"俄罗斯人",
      u8"俄罗斯共",
      u8"俄罗斯共和国",
      u8"俄罗斯娃",
      u8"俄罗斯平",
      u8"俄罗斯平原",
      u8"俄罗斯总统",
      u8"俄罗斯方块",
      u8"俄罗斯族",
      u8"俄罗斯联邦",
      u8"俄罗斯队",
      u8"俄而",
      u8"俄联邦",
      u8"俄语",
      u8"俄语系",
      u8"俄语组",
      u8"俄通社",
      u8"俄顷",
      u8"俊伟",
      u8"俊俏",
      u8"俊儿",
      u8"俊儿们",
      u8"俊发飘逸",
      u8"俊彦",
      u8"俊朗",
      u8"俊材",
      u8"俊杰",
      u8"俊杰廉悍",
      u8"俊爽",
      u8"俊男",
      u8"俊男靓女",
      u8"俊秀",
      u8"俊美",
      u8"俊逸",
      u8"俊雅",
      u8"俊马",
      u8"俎上之肉",
      u8"俎上肉",
      u8"俎樽折冲",
      u8"俏丽",
      u8"俏丽短发",
      u8"俏似",
      u8"俏佳人",
      u8"俏俏",
      u8"俏唇",
      u8"俏夕阳",
      u8"俏头",
      u8"俏女",
      u8"俏娇娃",
      u8"俏成俏败",
      u8"俏房客",
      u8"俏江南",
      u8"俏生生",
      u8"俏皮",
      u8"俏皮话",
      u8"俏神贯注",
      u8"俏货",
      u8"俏销",
      u8"俏鬼",
      u8"俏黄蓉",
      u8"俐落",
      u8"俐齿伶牙",
      u8"俑坑",
      u8"俗下文字",
      u8"俗不可医",
      u8"俗不可待",
      u8"俗不可耐",
      u8"俗不堪耐",
      u8"俗业",
      u8"俗乐",
      u8"俗事",
      u8"俗人",
      u8"俗体",
      u8"俗体字",
      u8"俗例",
      u8"俗务",
      u8"俗务缠身",
      u8"俗化",
      u8"俗名",
      u8"俗士",
      u8"俗套",
      u8"俗子",
      u8"俗字",
      u8"俗学",
      u8"俗家",
      u8"俗家子弟",
      u8"俗尚",
      u8"俗念",
      u8"俗态",
      u8"俗文学",
      u8"俗曲",
      u8"俗气",
      u8"俗物",
      u8"俗琐",
      u8"俗称",
      u8"俗缘",
      u8"俗艳",
      u8"俗论",
      u8"俗话",
      u8"俗话说",
      u8"俗话说得好",
      u8"俗语",
      u8"俗语说",
      u8"俗谚",
      u8"俗谚口碑",
      u8"俗谛",
      u8"俘敌",
      u8"俘获",
      u8"俘虏",
      u8"俘虏营",
      u8"俘越二极管",
      u8"俚俗",
      u8"俚医",
      u8"俚曲",
      u8"俚歌",
      u8"俚言",
      u8"俚语",
      u8"俚谚",
      u8"俛拾仰取",
      u8"俛拾地芥",
      u8"俛首帖耳",
      u8"保一方平安",
      u8"保不住",
      u8"保不定",
      u8"保不齐",
      u8"保丽龙",
      u8"保举",
      u8"保久",
      u8"保久乳",
      u8"保产",
      u8"保产供料",
      u8"保亭黎族苗族自治县",
      u8"保人",
      u8"保价",
      u8"保价信",
      u8"保住",
      u8"保佑",
      u8"保供",
      u8"保修",
      u8"保修包换",
      u8"保修单",
      u8"保修卡",
      u8"保修期",
      u8"保值",
      u8"保值储蓄",
      u8"保健",
      u8"保健专家",
      u8"保健产品",
      u8"保健作用",
      u8"保健员",
      u8"保健品",
      u8"保健型",
      u8"保健室",
      u8"保健所",
      u8"保健操",
      u8"保健枕",
      u8"保健球",
      u8"保健用品",
      u8"保健知识",
      u8"保健站",
      u8"保健箱",
      u8"保健网",
      u8"保健茶",
      u8"保健药",
      u8"保健费",
      u8"保健酒",
      u8"保健院",
      u8"保健食品",
      u8"保健饮料",
      u8"保兑信用证",
      u8"保全",
      u8"保全人员",
      u8"保全公司",
      u8"保全申请",
      u8"保全盛誉",
      u8"保全费",
      u8"保养",
      u8"保养品",
      u8"保养工",
      u8"保养站",
      u8"保养费",
      u8"保养部",
      u8"保养间",
      u8"保军转民",
      u8"保准",
      u8"保利",
      u8"保剑峰",
      u8"保剑锋",
      u8"保加利亚",
      u8"保单",
      u8"保卫",
      u8"保卫人员",
      u8"保卫和平",
      u8"保卫国家",
      u8"保卫国家主权和民族资源",
      u8"保卫处",
      u8"保卫工作",
      u8"保卫战",
      u8"保卫政权",
      u8"保卫祖国",
      u8"保卫科",
      u8"保卫组",
      u8"保卫者",
      u8"保命",
      u8"保命田",
      u8"保和殿",
      u8"保固",
      u8"保固期",
      u8"保国乡",
      u8"保国卫民",
      u8"保国安民",
      u8"保土",
      u8"保坪乡",
      u8"保境息民",
      u8"保墒",
      u8"保外",
      u8"保外就医",
      u8"保外执行",
      u8"保姆",
      u8"保婴",
      u8"保媒",
      u8"保存",
      u8"保存为",
      u8"保存实力",
      u8"保存文档",
      u8"保存期",
      u8"保存着",
      u8"保存起来",
      u8"保守",
      u8"保守主义",
      u8"保守党",
      u8"保守党人",
      u8"保守党政府",
      u8"保守力",
      u8"保守势力",
      u8"保守序列",
      u8"保守思想",
      u8"保守性聚焦",
      u8"保守政府",
      u8"保守机密",
      u8"保守派",
      u8"保守疗法",
      u8"保守系",
      u8"保守重组",
      u8"保安",
      u8"保安人员",
      u8"保安厅",
      u8"保安员",
      u8"保安器",
      u8"保安大队",
      u8"保安族",
      u8"保安服",
      u8"保安林",
      u8"保安警察",
      u8"保安队",
      u8"保定",
      u8"保定市",
      u8"保家",
      u8"保家卫国",
      u8"保密",
      u8"保密体制",
      u8"保密制度",
      u8"保密守则",
      u8"保密局",
      u8"保密工作",
      u8"保密性",
      u8"保密法",
      u8"保密观念",
      u8"保密锁",
      u8"保密防谍",
      u8"保尔",
      u8"保山",
      u8"保山市",
      u8"保平安",
      u8"保序映射",
      u8"保底",
      u8"保康",
      u8"保康县",
      u8"保径钻头",
      u8"保得住",
      u8"保德",
      u8"保德信",
      u8"保德县",
      u8"保息",
      u8"保护",
      u8"保护主义",
      u8"保护主义者",
      u8"保护人",
      u8"保护人民",
      u8"保护价",
      u8"保护伞",
      u8"保护关税",
      u8"保护剂",
      u8"保护区",
      u8"保护卡",
      u8"保护器",
      u8"保护国",
      u8"保护地",
      u8"保护套",
      u8"保护好",
      u8"保护层",
      u8"保护性",
      u8"保护意识",
      u8"保护措施",
      u8"保护期",
      u8"保护林",
      u8"保护模式",
      u8"保护法",
      u8"保护消费者杯",
      u8"保护热箱法",
      u8"保护率",
      u8"保护环",
      u8"保护环境",
      u8"保护神",
      u8"保护网",
      u8"保护者",
      u8"保护膜",
      u8"保护色",
      u8"保护装置",
      u8"保护视力",
      u8"保护费",
      u8"保护金",
      u8"保护防爆灯具",
      u8"保护鸟",
      u8"保持",
      u8"保持一致",
      u8"保持中立",
      u8"保持原状",
      u8"保持在",
      u8"保持性复述",
      u8"保持晚节",
      u8"保持有",
      u8"保持架",
      u8"保持沉默",
      u8"保持清洁",
      u8"保持着",
      u8"保持稳定",
      u8"保持系",
      u8"保持者",
      u8"保持联系",
      u8"保持警惕",
      u8"保持身材",
      u8"保持高度一致",
      u8"保时捷",
      u8"保暖",
      u8"保暖性",
      u8"保暖房",
      u8"保暖棚",
      u8"保有",
      u8"保有量",
      u8"保本",
      u8"保正",
      u8"保残守缺",
      u8"保母车",
      u8"保民",
      u8"保民卫国",
      u8"保水剂",
      u8"保法止",
      u8"保泰持盈",
      u8"保洁",
      u8"保洁员",
      u8"保洁箱",
      u8"保温",
      u8"保温套",
      u8"保温层",
      u8"保温材料",
      u8"保温杯",
      u8"保温板",
      u8"保温桶",
      u8"保温瓶",
      u8"保温管",
      u8"保温箱",
      u8"保湿",
      u8"保湿霜",
      u8"保溼",
      u8"保状",
      u8"保用",
      u8"保用期间",
      u8"保用期限",
      u8"保甲",
      u8"保甲法",
      u8"保留",
      u8"保留住",
      u8"保留体积",
      u8"保留余地",
      u8"保留剧目",
      u8"保留图书",
      u8"保留在",
      u8"保留地",
      u8"保留意见",
      u8"保留条款",
      u8"保留盈余",
      u8"保留着",
      u8"保留空间",
      u8"保留节目",
      u8"保留页选项",
      u8"保留项目",
      u8"保皇",
      u8"保皇党",
      u8"保皇派",
      u8"保盈持泰",
      u8"保监会",
      u8"保监局",
      u8"保真",
      u8"保真度",
      u8"保票",
      u8"保福乡",
      u8"保福村",
      u8"保秘",
      u8"保积函子",
      u8"保税",
      u8"保税仓库",
      u8"保税区",
      u8"保管",
      u8"保管人",
      u8"保管员",
      u8"保管室",
      u8"保管箱",
      u8"保管费",
      u8"保级",
      u8"保级战",
      u8"保结",
      u8"保罗",
      u8"保罗三世",
      u8"保育",
      u8"保育员",
      u8"保育院",
      u8"保胎",
      u8"保苗",
      u8"保荐",
      u8"保荐人",
      u8"保莱塔",
      u8"保藏",
      u8"保藏品",
      u8"保藏秣草",
      u8"保警",
      u8"保证",
      u8"保证书",
      u8"保证人",
      u8"保证价格",
      u8"保证体系",
      u8"保证供应",
      u8"保证供给",
      u8"保证其",
      u8"保证期",
      u8"保证质量",
      u8"保证金",
      u8"保证需要",
      u8"保质",
      u8"保质保量",
      u8"保质期",
      u8"保费",
      u8"保赦",
      u8"保身",
      u8"保送",
      u8"保送入学",
      u8"保送生",
      u8"保释",
      u8"保释人",
      u8"保释金",
      u8"保重",
      u8"保量",
      u8"保金",
      u8"保钓",
      u8"保钓运动",
      u8"保镖",
      u8"保长",
      u8"保防",
      u8"保防工作",
      u8"保防教育",
      u8"保险",
      u8"保险业",
      u8"保险业务",
      u8"保险丝",
      u8"保险产品",
      u8"保险人",
      u8"保险代理",
      u8"保险信封",
      u8"保险公司",
      u8"保险刀",
      u8"保险制度",
      u8"保险单",
      u8"保险单一般规定",
      u8"保险单满期",
      u8"保险号",
      u8"保险合同",
      u8"保险商",
      u8"保险套",
      u8"保险学",
      u8"保险客户",
      u8"保险局",
      u8"保险市场",
      u8"保险带",
      u8"保险库",
      u8"保险总额",
      u8"保险期",
      u8"保险期限",
      u8"保险机构",
      u8"保险杆",
      u8"保险杠",
      u8"保险条例",
      u8"保险条款",
      u8"保险柜",
      u8"保险法",
      u8"保险灯",
      u8"保险盒",
      u8"保险管",
      u8"保险箱",
      u8"保险类别",
      u8"保险粉",
      u8"保险经纪",
      u8"保险网",
      u8"保险罩",
      u8"保险行业",
      u8"保险装置",
      u8"保险责任终止",
      u8"保险费",
      u8"保险费率",
      u8"保险费用",
      u8"保险资金",
      u8"保险金",
      u8"保险金额",
      u8"保险门",
      u8"保障",
      u8"保障人权",
      u8"保障体系",
      u8"保障制度",
      u8"保障局",
      u8"保障机制",
      u8"保障系统",
      u8"保障线",
      u8"保障部",
      u8"保障金",
      u8"保靖",
      u8"保靖县",
      u8"保马法",
      u8"保驾",
      u8"保驾护航",
      u8"保鲜",
      u8"保鲜剂",
      u8"保鲜库",
      u8"保鲜期",
      u8"保鲜盒",
      u8"保鲜纸",
      u8"保鲜膜",
      u8"保鲜袋",
      u8"保龄球",
      u8"保龄球场",
      u8"保龄球热",
      u8"保龄球赛",
      u8"保龄球道",
      u8"保龄球馆",
      u8"俞允",
      u8"俞募配穴",
      u8"俞小凡",
      u8"俞岱岩",
      u8"俞府",
      u8"俞晓松",
      u8"俞朝奉",
      u8"俞正声",
      u8"俞穴",
      u8"俞连舟",
      u8"俞静",
      u8"俞飞鸿",
      u8"俟机",
      u8"俟河之清",
      u8"信上",
      u8"信不信",
      u8"信不信由你",
      u8"信不过",
      u8"信个",
      u8"信中",
      u8"信丰",
      u8"信丰县",
      u8"信义",
      u8"信义为立",
      u8"信义为立业之本",
      u8"信义值千金",
      u8"信义千金",
      u8"信义国中",
      u8"信义国小",
      u8"信义计划",
      u8"信义计划区",
      u8"信义路",
      u8"信乐团",
      u8"信产部",
      u8"信从",
      u8"信以为真",
      u8"信仰",
      u8"信仰主义",
      u8"信仰危机",
      u8"信仰者",
      u8"信仰自由",
      u8"信件",
      u8"信任",
      u8"信任他人",
      u8"信任别人",
      u8"信任危机",
      u8"信任感",
      u8"信任投票",
      u8"信任案",
      u8"信任票",
      u8"信佛",
      u8"信佛教",
      u8"信使",
      u8"信元划界",
      u8"信内",
      u8"信函",
      u8"信到",
      u8"信包",
      u8"信区",
      u8"信区管理员",
      u8"信及豚鱼",
      u8"信口",
      u8"信口吹",
      u8"信口开合",
      u8"信口开呵",
      u8"信口开喝",
      u8"信口开河",
      u8"信口胡言",
      u8"信口胡说",
      u8"信口雌黄",
      u8"信史",
      u8"信号",
      u8"信号兵",
      u8"信号台",
      u8"信号器",
      u8"信号噪声分配",
      u8"信号工",
      u8"信号工区",
      u8"信号平均累加器",
      u8"信号弹",
      u8"信号强度",
      u8"信号摆幅",
      u8"信号施工",
      u8"信号旗",
      u8"信号机",
      u8"信号机房",
      u8"信号枪",
      u8"信号检测理论",
      u8"信号楼",
      u8"信号流图",
      u8"信号源",
      u8"信号源阻抗",
      u8"信号灯",
      u8"信号电缆",
      u8"信号系统",
      u8"信号线",
      u8"信号肽",
      u8"信号转导",
      u8"信号量",
      u8"信噪比",
      u8"信增",
      u8"信士",
      u8"信天游",
      u8"信天翁",
      u8"信奉",
      u8"信奉宗教",
      u8"信奉异教",
      u8"信女",
      u8"信守",
      u8"信守不弃",
      u8"信守不渝",
      u8"信守合同",
      u8"信守诺言",
      u8"信宜",
      u8"信宜县",
      u8"信宜市",
      u8"信实",
      u8"信封",
      u8"信封袋",
      u8"信州区",
      u8"信差",
      u8"信度",
      u8"信徒",
      u8"信得",
      u8"信得过",
      u8"信徙",
      u8"信德",
      u8"信德省",
      u8"信心",
      u8"信心倍增",
      u8"信心十足",
      u8"信心危机",
      u8"信心百倍",
      u8"信念",
      u8"信念修正",
      u8"信息",
      u8"信息业",
      u8"信息中心",
      u8"信息产业",
      u8"信息产业厅",
      u8"信息产业局",
      u8"信息产业部",
      u8"信息产业部部长",
      u8"信息估计",
      u8"信息内容",
      u8"信息冗余",
      u8"信息冗余检验",
      u8"信息分公司",
      u8"信息加工",
      u8"信息加工理论",
      u8"信息化",
      u8"信息化发展",
      u8"信息压缩",
      u8"信息反馈",
      u8"信息台",
      u8"信息司",
      u8"信息员",
      u8"信息处理",
      u8"信息处理系统",
      u8"信息处理语言",
      u8"信息学",
      u8"信息家电",
      u8"信息就是生活",
      u8"信息就是财富",
      u8"信息库",
      u8"信息廊",
      u8"信息性",
      u8"信息战",
      u8"信息技术",
      u8"信息提取",
      u8"信息时代",
      u8"信息时报",
      u8"信息比价",
      u8"信息沟通",
      u8"信息流",
      u8"信息流向控制",
      u8"信息测度",
      u8"信息港",
      u8"信息源",
      u8"信息率",
      u8"信息社会",
      u8"信息科学",
      u8"信息管理",
      u8"信息箱",
      u8"信息系统",
      u8"信息组",
      u8"信息经济",
      u8"信息网",
      u8"信息网络",
      u8"信息论",
      u8"信息费",
      u8"信息资源",
      u8"信息资讯",
      u8"信息超负荷",
      u8"信息部",
      u8"信息量",
      u8"信息隐蔽",
      u8"信息高速公路",
      u8"信我",
      u8"信手",
      u8"信手拈来",
      u8"信托",
      u8"信托业",
      u8"信托公司",
      u8"信托局",
      u8"信托投资",
      u8"信托投资公司",
      u8"信托投资理事会",
      u8"信托法",
      u8"信托贸易",
      u8"信报箱",
      u8"信报箱群",
      u8"信报讯",
      u8"信据",
      u8"信教",
      u8"信教者",
      u8"信文",
      u8"信服",
      u8"信望",
      u8"信札",
      u8"信条",
      u8"信标",
      u8"信步",
      u8"信步漫游",
      u8"信步而行",
      u8"信步闲游",
      u8"信汇",
      u8"信江",
      u8"信源",
      u8"信物",
      u8"信用",
      u8"信用制度",
      u8"信用卡",
      u8"信用原则",
      u8"信用可靠",
      u8"信用合作",
      u8"信用合作社",
      u8"信用度",
      u8"信用放款",
      u8"信用状",
      u8"信用社",
      u8"信用等级",
      u8"信用联社",
      u8"信用证",
      u8"信用调查",
      u8"信用贷款",
      u8"信用风险",
      u8"信皮",
      u8"信皮儿",
      u8"信石",
      u8"信社",
      u8"信稿",
      u8"信笔",
      u8"信笔拈来",
      u8"信笔涂鸦",
      u8"信笔直书",
      u8"信笺",
      u8"信筒",
      u8"信简",
      u8"信管",
      u8"信箱",
      u8"信箱号码",
      u8"信箱地址",
      u8"信纸",
      u8"信纸信封",
      u8"信而好古",
      u8"信而有征",
      u8"信而有证",
      u8"信耐",
      u8"信自己",
      u8"信言不美",
      u8"信誉",
      u8"信誉卓着",
      u8"信誉度",
      u8"信誉第一",
      u8"信誉至上",
      u8"信誓旦旦",
      u8"信访",
      u8"信访件",
      u8"信访办",
      u8"信访局",
      u8"信访工作",
      u8"信访部门",
      u8"信诊",
      u8"信贷",
      u8"信贷业务",
      u8"信贷员",
      u8"信贷处",
      u8"信贷政策",
      u8"信贷科",
      u8"信贷管理",
      u8"信贷资金",
      u8"信贷风险",
      u8"信赏",
      u8"信赏必罚",
      u8"信赖",
      u8"信赖感",
      u8"信达",
      u8"信通捷",
      u8"信道",
      u8"信道容量",
      u8"信道编码",
      u8"信邪",
      u8"信里",
      u8"信长",
      u8"信长的野望",
      u8"信阳",
      u8"信阳县",
      u8"信阳市",
      u8"信风",
      u8"信风带",
      u8"信马由缰",
      u8"信鸟",
      u8"信鸽",
      u8"信鸽网",
      u8"俨乎其然",
      u8"俨如",
      u8"俨然",
      u8"俨然是",
      u8"俨若",
      u8"俩人",
      u8"俩月",
      u8"俩眼",
      u8"俪人",
      u8"俪句",
      u8"俪影",
      u8"俪辞",
      u8"俭不中礼",
      u8"俭以养廉",
      u8"俭以养德",
      u8"俭可养廉",
      u8"俭存奢失",
      u8"俭岁",
      u8"俭故能广",
      u8"俭明",
      u8"俭朴",
      u8"俭汤",
      u8"俭汤乡",
      u8"俭用",
      u8"俭省",
      u8"俭约",
      u8"俭腹高谈",
      u8"修业",
      u8"修业年限",
      u8"修业期满",
      u8"修习",
      u8"修书",
      u8"修仙",
      u8"修修",
      u8"修修改改",
      u8"修修补补",
      u8"修养",
      u8"修养成",
      u8"修函",
      u8"修到",
      u8"修剪",
      u8"修史",
      u8"修堤",
      u8"修士",
      u8"修复",
      u8"修复一新",
      u8"修复前外科学",
      u8"修复器",
      u8"修复性牙本质",
      u8"修复者",
      u8"修复过程",
      u8"修女",
      u8"修好",
      u8"修学",
      u8"修宗迪",
      u8"修定",
      u8"修己",
      u8"修庆",
      u8"修建",
      u8"修建设计",
      u8"修得",
      u8"修心养性",
      u8"修憩",
      u8"修成",
      u8"修房",
      u8"修护",
      u8"修护液",
      u8"修护站",
      u8"修护队",
      u8"修护露",
      u8"修持",
      u8"修指甲",
      u8"修撰",
      u8"修改",
      u8"修改后",
      u8"修改器",
      u8"修改工作",
      u8"修改意见",
      u8"修改文章",
      u8"修改权",
      u8"修改版",
      u8"修改稿",
      u8"修改草案",
      u8"修整",
      u8"修文",
      u8"修文偃武",
      u8"修文县",
      u8"修旧利废",
      u8"修旧起废",
      u8"修明",
      u8"修枝",
      u8"修枝剪",
      u8"修桥",
      u8"修桥补路",
      u8"修桥铺路",
      u8"修正",
      u8"修正主义",
      u8"修正单纯形法",
      u8"修正图",
      u8"修正案",
      u8"修正液",
      u8"修正版",
      u8"修正率",
      u8"修正稿",
      u8"修武",
      u8"修武县",
      u8"修水",
      u8"修水利",
      u8"修水县",
      u8"修治",
      u8"修浚",
      u8"修炼",
      u8"修炼法",
      u8"修理",
      u8"修理业",
      u8"修理包",
      u8"修理匠",
      u8"修理厂",
      u8"修理工",
      u8"修理店",
      u8"修理点",
      u8"修理站",
      u8"修理者",
      u8"修理行业",
      u8"修理费",
      u8"修理起来",
      u8"修理部",
      u8"修理铺",
      u8"修真养性",
      u8"修真界",
      u8"修真者",
      u8"修短",
      u8"修短随化",
      u8"修竹",
      u8"修筑",
      u8"修筑公路",
      u8"修筑工事",
      u8"修筑工程",
      u8"修筑道路",
      u8"修纂",
      u8"修编",
      u8"修缮",
      u8"修缮一新",
      u8"修缮费",
      u8"修罗",
      u8"修罗场",
      u8"修胡刀",
      u8"修脚",
      u8"修脚师",
      u8"修脸",
      u8"修船",
      u8"修葺",
      u8"修葺一新",
      u8"修行",
      u8"修行在个人",
      u8"修行录",
      u8"修行者",
      u8"修补",
      u8"修补剂",
      u8"修补术",
      u8"修补者",
      u8"修订",
      u8"修订本",
      u8"修订版",
      u8"修订稿",
      u8"修订者",
      u8"修词学",
      u8"修读",
      u8"修课",
      u8"修起",
      u8"修起来",
      u8"修路",
      u8"修蹄",
      u8"修身",
      u8"修身养性",
      u8"修身洁行",
      u8"修身砺德",
      u8"修身齐家",
      u8"修车",
      u8"修车点",
      u8"修车铺",
      u8"修辞",
      u8"修辞学",
      u8"修辞学家",
      u8"修辞手法",
      u8"修辞格",
      u8"修辞癖",
      u8"修辞立诚",
      u8"修边机",
      u8"修造",
      u8"修造厂",
      u8"修道",
      u8"修道人",
      u8"修道士",
      u8"修道院",
      u8"修配",
      u8"修配业",
      u8"修配厂",
      u8"修铁路",
      u8"修长",
      u8"修面",
      u8"修鞋",
      u8"修鞋店",
      u8"修鞋摊",
      u8"修饰",
      u8"修饰句",
      u8"修饰字",
      u8"修饰符",
      u8"修饰词",
      u8"修饰语",
      u8"修饰边幅",
      u8"修鳞养爪",
      u8"修齐",
      u8"修齐治平",
      u8"俯下",
      u8"俯下去",
      u8"俯仰",
      u8"俯仰之间",
      u8"俯仰唯唯",
      u8"俯仰异观",
      u8"俯仰无愧",
      u8"俯仰由人",
      u8"俯仰随人",
      u8"俯伏",
      u8"俯允",
      u8"俯冲",
      u8"俯冲点",
      u8"俯冲角",
      u8"俯卧",
      u8"俯卧撑",
      u8"俯头",
      u8"俯姿",
      u8"俯察",
      u8"俯射",
      u8"俯射角",
      u8"俯就",
      u8"俯念",
      u8"俯拍",
      u8"俯拾",
      u8"俯拾仰取",
      u8"俯拾即是",
      u8"俯拾地芥",
      u8"俯拾皆是",
      u8"俯曲",
      u8"俯泳",
      u8"俯看",
      u8"俯瞰",
      u8"俯视",
      u8"俯视图",
      u8"俯视景观",
      u8"俯角",
      u8"俯贻",
      u8"俯身",
      u8"俯首",
      u8"俯首下心",
      u8"俯首听命",
      u8"俯首就擒",
      u8"俯首就缚",
      u8"俯首就范",
      u8"俯首帖耳",
      u8"俯首弭耳",
      u8"俯首戢耳",
      u8"俯首甘为孺子牛",
      u8"俯首称臣",
      u8"俯首认罪",
      u8"俯首认错",
      u8"俯首贴耳",
      u8"俱乐部",
      u8"俱乐部杯",
      u8"俱佳",
      u8"俱全",
      u8"俱发",
      u8"俱在",
      u8"俱备",
      u8"俱往",
      u8"俱往矣",
      u8"俱收并蓄",
      u8"俱明宝树王",
      u8"俳优",
      u8"俳句",
      u8"俳谐",
      u8"俸恤",
      u8"俸禄",
      u8"俸给",
      u8"俸褖",
      u8"俸钱",
      u8"俺也来",
      u8"俺们",
      u8"俺家",
      u8"俺村",
      u8"俾众周知",
      u8"俾使",
      u8"俾倪",
      u8"俾夜作昼",
      u8"俾斯麦",
      u8"俾昼作夜",
      u8"俾有所悟",
      u8"俾能",
      u8"俾资挹注",
      u8"俾路支",
      u8"俾路支省",
      u8"俾面",
      u8"倍于",
      u8"倍低音",
      u8"倍偿",
      u8"倍儿",
      u8"倍加",
      u8"倍加福",
      u8"倍半萜",
      u8"倍受",
      u8"倍受尊敬",
      u8"倍受欢迎",
      u8"倍受青睐",
      u8"倍受鼓舞",
      u8"倍可亲",
      u8"倍增",
      u8"倍增器",
      u8"倍增学",
      u8"倍大提琴",
      u8"倍律",
      u8"倍感",
      u8"倍捻机",
      u8"倍数",
      u8"倍日并行",
      u8"倍特",
      u8"倍率",
      u8"倍生",
      u8"倍称",
      u8"倍藏艰辛",
      u8"倍觉",
      u8"倍谢",
      u8"倍赏千惠子",
      u8"倍赏必罚",
      u8"倍速",
      u8"倍道兼行",
      u8"倍道兼进",
      u8"倍道而行",
      u8"倍道而进",
      u8"倍频",
      u8"倍频器",
      u8"倍频程",
      u8"倍频链",
      u8"倏地",
      u8"倏地点",
      u8"倏尔",
      u8"倏忽",
      u8"倏忽之间",
      u8"倏然",
      u8"倒三七",
      u8"倒三颠四",
      u8"倒上",
      u8"倒上去",
      u8"倒上来",
      u8"倒下",
      u8"倒下去",
      u8"倒下来",
      u8"倒不会",
      u8"倒不如",
      u8"倒不如说是",
      u8"倒不少见",
      u8"倒不开",
      u8"倒不是",
      u8"倒为",
      u8"倒也",
      u8"倒也不",
      u8"倒也不会",
      u8"倒也不是",
      u8"倒也罢了",
      u8"倒买",
      u8"倒买倒卖",
      u8"倒了",
      u8"倒仓",
      u8"倒伏",
      u8"倒休",
      u8"倒会",
      u8"倒倒",
      u8"倒像",
      u8"倒儿爷",
      u8"倒入",
      u8"倒八",
      u8"倒八字",
      u8"倒八眉",
      u8"倒写",
      u8"倒冠落佩",
      u8"倒冠落珮",
      u8"倒凤颠鸾",
      u8"倒凹区",
      u8"倒出",
      u8"倒出去",
      u8"倒出来",
      u8"倒到",
      u8"倒刺",
      u8"倒剪",
      u8"倒包",
      u8"倒卖",
      u8"倒卧",
      u8"倒卵形",
      u8"倒去",
      u8"倒反",
      u8"倒叙",
      u8"倒叙法",
      u8"倒句",
      u8"倒台",
      u8"倒吃",
      u8"倒吃甘蔗",
      u8"倒向",
      u8"倒向天线",
      u8"倒吸",
      u8"倒味口",
      u8"倒嗓",
      u8"倒嗓子",
      u8"倒嚼",
      u8"倒回",
      u8"倒回去",
      u8"倒回来",
      u8"倒因为果",
      u8"倒圆角",
      u8"倒在",
      u8"倒地",
      u8"倒地不起",
      u8"倒坍",
      u8"倒垂",
      u8"倒塌",
      u8"倒大霉",
      u8"倒头",
      u8"倒好",
      u8"倒屣相迎",
      u8"倒履相迎",
      u8"倒山倾海",
      u8"倒峡泻河",
      u8"倒帐",
      u8"倒带",
      u8"倒带机",
      u8"倒床",
      u8"倒廪倾囷",
      u8"倒彩",
      u8"倒影",
      u8"倒影池",
      u8"倒得",
      u8"倒念",
      u8"倒悬",
      u8"倒悬之急",
      u8"倒悬之苦",
      u8"倒想",
      u8"倒戈",
      u8"倒戈卸甲",
      u8"倒戈相向",
      u8"倒戢干戈",
      u8"倒手",
      u8"倒打一瓦",
      u8"倒打一耙",
      u8"倒扣",
      u8"倒扣草",
      u8"倒执手版",
      u8"倒找",
      u8"倒把",
      u8"倒折",
      u8"倒拉",
      u8"倒拉一把",
      u8"倒持干戈",
      u8"倒持戈矛",
      u8"倒持手板",
      u8"倒持泰阿",
      u8"倒挂",
      u8"倒挂金钟",
      u8"倒挂金钩",
      u8"倒换",
      u8"倒掉",
      u8"倒排",
      u8"倒推",
      u8"倒插",
      u8"倒插笔",
      u8"倒插门",
      u8"倒摄干扰",
      u8"倒摄抑制",
      u8"倒放",
      u8"倒数",
      u8"倒数第",
      u8"倒料",
      u8"倒时差",
      u8"倒易律",
      u8"倒易蒙特卡罗方法",
      u8"倒映",
      u8"倒映在",
      u8"倒春寒",
      u8"倒是",
      u8"倒替",
      u8"倒来",
      u8"倒来倒去",
      u8"倒杯",
      u8"倒杯水",
      u8"倒杯茶",
      u8"倒果为因",
      u8"倒栽葱",
      u8"倒梯形",
      u8"倒楣",
      u8"倒楣鬼",
      u8"倒槽式拱",
      u8"倒毁",
      u8"倒毙",
      u8"倒水",
      u8"倒汇",
      u8"倒油",
      u8"倒流",
      u8"倒海翻江",
      u8"倒满",
      u8"倒灌",
      u8"倒灶",
      u8"倒焊",
      u8"倒爷",
      u8"倒班",
      u8"倒睫",
      u8"倒票",
      u8"倒空",
      u8"倒立",
      u8"倒算",
      u8"倒箧倾囊",
      u8"倒箧倾筐",
      u8"倒粪",
      u8"倒给",
      u8"倒绷孩儿",
      u8"倒置",
      u8"倒置地貌",
      u8"倒置干戈",
      u8"倒置显微镜",
      u8"倒置阻生",
      u8"倒翁",
      u8"倒胃",
      u8"倒胃口",
      u8"倒背",
      u8"倒背如流",
      u8"倒腾",
      u8"倒苦水",
      u8"倒茬",
      u8"倒茶",
      u8"倒萨",
      u8"倒行",
      u8"倒行逆施",
      u8"倒街卧巷",
      u8"倒装",
      u8"倒装句",
      u8"倒装法",
      u8"倒装钻具",
      u8"倒裳索领",
      u8"倒要",
      u8"倒角",
      u8"倒角机",
      u8"倒计",
      u8"倒计时",
      u8"倒计时牌",
      u8"倒计时钟",
      u8"倒记时",
      u8"倒象棱镜",
      u8"倒账",
      u8"倒贴",
      u8"倒赔",
      u8"倒走",
      u8"倒起",
      u8"倒起来",
      u8"倒车",
      u8"倒车档",
      u8"倒车灯",
      u8"倒车镜",
      u8"倒转",
      u8"倒转电场凝胶电泳",
      u8"倒轮闸",
      u8"倒载干戈",
      u8"倒过",
      u8"倒过儿",
      u8"倒过去",
      u8"倒过来",
      u8"倒运",
      u8"倒还",
      u8"倒进",
      u8"倒进去",
      u8"倒进来",
      u8"倒退",
      u8"倒钩卡环",
      u8"倒锁",
      u8"倒错",
      u8"倒锥钻",
      u8"倒闭",
      u8"倒闭年",
      u8"倒阁",
      u8"倒霉",
      u8"倒霉事",
      u8"倒霉熊",
      u8"倒霉蛋",
      u8"倒霉鬼",
      u8"倔劲",
      u8"倔头倔脑",
      u8"倔头强脑",
      u8"倔强",
      u8"倔强倨傲",
      u8"倔强地",
      u8"倔犟",
      u8"倘不",
      u8"倘不如此",
      u8"倘佯",
      u8"倘使",
      u8"倘或",
      u8"倘有",
      u8"倘未",
      u8"倘来之物",
      u8"倘然",
      u8"倘能",
      u8"倘若",
      u8"倘若会",
      u8"倘若在",
      u8"倘若是",
      u8"倘若有",
      u8"倘若能",
      u8"候俊杰",
      u8"候光",
      u8"候冠群",
      u8"候命",
      u8"候场",
      u8"候复",
      u8"候审",
      u8"候客室",
      u8"候教",
      u8"候机",
      u8"候机厅",
      u8"候机室",
      u8"候机楼",
      u8"候温",
      u8"候爵",
      u8"候缺",
      u8"候耀华",
      u8"候耀文",
      u8"候船",
      u8"候船室",
      u8"候补",
      u8"候补中央委员",
      u8"候补人",
      u8"候补人员",
      u8"候补委员",
      u8"候补者",
      u8"候补键",
      u8"候补队员",
      u8"候诊",
      u8"候诊室",
      u8"候车",
      u8"候车亭",
      u8"候车厅",
      u8"候车室",
      u8"候车站",
      u8"候选",
      u8"候选人",
      u8"候选国",
      u8"候选框",
      u8"候选者",
      u8"候选词",
      u8"候销",
      u8"候风地动仪",
      u8"候马",
      u8"候马市",
      u8"候驾",
      u8"候鱼",
      u8"候鸟",
      u8"倚人庐下",
      u8"倚仗",
      u8"倚偎",
      u8"倚傍",
      u8"倚傍门户",
      u8"倚势凌人",
      u8"倚坐",
      u8"倚墙而立",
      u8"倚多为胜",
      u8"倚天",
      u8"倚天剑",
      u8"倚天屠龙记",
      u8"倚天拔地",
      u8"倚姣作媚",
      u8"倚官仗势",
      u8"倚官挟势",
      u8"倚山傍水",
      u8"倚强凌弱",
      u8"倚恃",
      u8"倚方位速度",
      u8"倚望",
      u8"倚栏",
      u8"倚玉偎香",
      u8"倚立",
      u8"倚翠偎红",
      u8"倚老卖老",
      u8"倚草附木",
      u8"倚装待发",
      u8"倚财仗势",
      u8"倚赖",
      u8"倚赖心",
      u8"倚赖性",
      u8"倚赖成性",
      u8"倚重",
      u8"倚门",
      u8"倚门倚闾",
      u8"倚门傍户",
      u8"倚门卖俏",
      u8"倚门卖笑",
      u8"倚门献笑",
      u8"倚门窥户",
      u8"倚闾望切",
      u8"倚靠",
      u8"倚靠在",
      u8"倚靠着",
      u8"倚音",
      u8"倚马七纸",
      u8"倚马千言",
      u8"倚马可待",
      u8"倜傥",
      u8"倜傥不羁",
      u8"倜傥不群",
      u8"借东风",
      u8"借东风丧偶案犯护",
      u8"借个",
      u8"借个火",
      u8"借书",
      u8"借书单",
      u8"借书处",
      u8"借书留真",
      u8"借书证",
      u8"借了",
      u8"借交报仇",
      u8"借人",
      u8"借代",
      u8"借以",
      u8"借位",
      u8"借住",
      u8"借余",
      u8"借作",
      u8"借你",
      u8"借借",
      u8"借借看",
      u8"借债",
      u8"借债人",
      u8"借债度日",
      u8"借光",
      u8"借入",
      u8"借入款",
      u8"借公行私",
      u8"借兵",
      u8"借减",
      u8"借出",
      u8"借出去",
      u8"借出来",
      u8"借出物",
      u8"借刀杀人",
      u8"借到",
      u8"借剑杀人",
      u8"借力顺推",
      u8"借助",
      u8"借助于",
      u8"借势",
      u8"借去",
      u8"借取",
      u8"借口",
      u8"借古借今",
      u8"借古喻今",
      u8"借古讽今",
      u8"借听于聋",
      u8"借唱",
      u8"借喻",
      u8"借回",
      u8"借回去",
      u8"借回来",
      u8"借地",
      u8"借坐",
      u8"借坡下驴",
      u8"借垫",
      u8"借增",
      u8"借壳上市",
      u8"借好",
      u8"借完",
      u8"借宝地",
      u8"借客报仇",
      u8"借宿",
      u8"借宿一夜",
      u8"借宿一晚",
      u8"借尸还阳",
      u8"借尸还魂",
      u8"借差",
      u8"借帐",
      u8"借弹",
      u8"借得",
      u8"借我",
      u8"借托",
      u8"借抄",
      u8"借抽",
      u8"借招",
      u8"借据",
      u8"借支",
      u8"借放",
      u8"借故",
      u8"借方",
      u8"借方余额",
      u8"借方差额",
      u8"借景抒情",
      u8"借景生情",
      u8"借有",
      u8"借期",
      u8"借机",
      u8"借机报复",
      u8"借条",
      u8"借来",
      u8"借来借去",
      u8"借款",
      u8"借款人",
      u8"借款单",
      u8"借此",
      u8"借此机会",
      u8"借水推船",
      u8"借水行舟",
      u8"借满",
      u8"借火",
      u8"借点",
      u8"借球",
      u8"借用",
      u8"借用还",
      u8"借看",
      u8"借看一下",
      u8"借着",
      u8"借穿",
      u8"借端",
      u8"借端生事",
      u8"借端肇事",
      u8"借箸代筹",
      u8"借箸代谋",
      u8"借篷使风",
      u8"借约",
      u8"借给",
      u8"借腹怀胎",
      u8"借腹生子",
      u8"借自",
      u8"借花献佛",
      u8"借让",
      u8"借记卡",
      u8"借词",
      u8"借读",
      u8"借读生",
      u8"借读费",
      u8"借调",
      u8"借账",
      u8"借贷",
      u8"借贷无门",
      u8"借贷资本",
      u8"借走",
      u8"借身报仇",
      u8"借车",
      u8"借过",
      u8"借过一下",
      u8"借还",
      u8"借道",
      u8"借酒",
      u8"借酒浇愁",
      u8"借酒消愁",
      u8"借酒装疯",
      u8"借重",
      u8"借鉴",
      u8"借钱",
      u8"借镜",
      u8"借镜观形",
      u8"借问",
      u8"借阅",
      u8"借阅室",
      u8"借面吊丧",
      u8"借领",
      u8"借题",
      u8"借题发挥",
      u8"借风使船",
      u8"借鸡生蛋",
      u8"倡乱",
      u8"倡仪",
      u8"倡优",
      u8"倡导",
      u8"倡导者",
      u8"倡廉",
      u8"倡情冶思",
      u8"倡条冶叶",
      u8"倡狂",
      u8"倡而不和",
      u8"倡言",
      u8"倡议",
      u8"倡议书",
      u8"倡议权",
      u8"倡议者",
      u8"倡首",
      u8"倥侗",
      u8"倦乏",
      u8"倦勤",
      u8"倦容",
      u8"倦尾赤色",
      u8"倦态",
      u8"倦怠",
      u8"倦怠感",
      u8"倦意",
      u8"倦意顿消",
      u8"倦感",
      u8"倦游",
      u8"倦色",
      u8"倦鸟归巢",
      u8"倦鸟投林",
      u8"倦鸟知归",
      u8"倦鸟知返",
      u8"倦鸟知还",
      u8"倨傲",
      u8"倨傲不恭",
      u8"倩人捉刀",
      u8"倩倩",
      u8"倩况",
      u8"倩女",
      u8"倩女幽魂",
      u8"倩女离魂",
      u8"倩影",
      u8"倪不大",
      u8"倪不小",
      u8"倪匡",
      u8"倪嗣冲",
      u8"倪平",
      u8"倪林惠",
      u8"倪浩",
      u8"倪淑君",
      u8"倪萍",
      u8"倪虹洁",
      u8"倭奴",
      u8"倭寇",
      u8"倭寇船",
      u8"倭瓜",
      u8"债主",
      u8"债利",
      u8"债券",
      u8"债券市场",
      u8"债务",
      u8"债务人",
      u8"债务国",
      u8"债务纠纷",
      u8"债务额",
      u8"债台",
      u8"债台高筑",
      u8"债多不愁",
      u8"债市",
      u8"债息",
      u8"债户",
      u8"债有主",
      u8"债权",
      u8"债权人",
      u8"债权债务",
      u8"债权团",
      u8"债权国",
      u8"债款",
      u8"债转股",
      u8"债额",
      u8"值不值",
      u8"值不值得",
      u8"值了",
      u8"值勤",
      u8"值勤者",
      u8"值千金",
      u8"值参",
      u8"值域",
      u8"值夜",
      u8"值夜班",
      u8"值守",
      u8"值完",
      u8"值当",
      u8"值得",
      u8"值得一提",
      u8"值得一提的是",
      u8"值得一看",
      u8"值得主义",
      u8"值得出力",
      u8"值得反思",
      u8"值得尊敬",
      u8"值得尊重",
      u8"值得崇拜",
      u8"值得引用",
      u8"值得注意",
      u8"值得注视",
      u8"值得称赞",
      u8"值得称颂",
      u8"值得纪念",
      u8"值得羡慕",
      u8"值指示剂",
      u8"值日",
      u8"值日官",
      u8"值日生",
      u8"值日表",
      u8"值早班",
      u8"值星",
      u8"值星官",
      u8"值星班长",
      u8"值晚班",
      u8"值更",
      u8"值此",
      u8"值班",
      u8"值班人",
      u8"值班人员",
      u8"值班员",
      u8"值班室",
      u8"值班船",
      u8"值遇",
      u8"值钱",
      u8"倾下",
      u8"倾下去",
      u8"倾下来",
      u8"倾于",
      u8"倾侧",
      u8"倾倒",
      u8"倾倒垃圾",
      u8"倾入",
      u8"倾其所有",
      u8"倾出",
      u8"倾刻",
      u8"倾刻之间",
      u8"倾力",
      u8"倾动",
      u8"倾化",
      u8"倾危",
      u8"倾卸",
      u8"倾吐",
      u8"倾吐衷情",
      u8"倾向",
      u8"倾向于",
      u8"倾向性",
      u8"倾向滑动断层",
      u8"倾向艺术",
      u8"倾听",
      u8"倾听意见",
      u8"倾囊",
      u8"倾囊相助",
      u8"倾囊相授",
      u8"倾囊而出",
      u8"倾国",
      u8"倾国倾城",
      u8"倾城",
      u8"倾城倾国",
      u8"倾城而出",
      u8"倾塌",
      u8"倾复",
      u8"倾天",
      u8"倾宵",
      u8"倾家",
      u8"倾家破产",
      u8"倾家竭产",
      u8"倾家荡产",
      u8"倾家败产",
      u8"倾尽全力",
      u8"倾巢",
      u8"倾巢出动",
      u8"倾巢来犯",
      u8"倾巢而出",
      u8"倾度",
      u8"倾心",
      u8"倾心吐意",
      u8"倾心吐胆",
      u8"倾心尽力",
      u8"倾情",
      u8"倾慕",
      u8"倾抱写诚",
      u8"倾摇懈弛",
      u8"倾斜",
      u8"倾斜仪",
      u8"倾斜地",
      u8"倾斜度",
      u8"倾斜式修井机",
      u8"倾斜政策",
      u8"倾斜角",
      u8"倾斜距离",
      u8"倾斜面",
      u8"倾析",
      u8"倾柯卫足",
      u8"倾泄",
      u8"倾注",
      u8"倾注全力",
      u8"倾泻",
      u8"倾盆",
      u8"倾盆大雨",
      u8"倾盖",
      u8"倾盖如故",
      u8"倾筐倒庋",
      u8"倾筐倒箧",
      u8"倾箱倒柜",
      u8"倾箱倒箧",
      u8"倾羡",
      u8"倾耳",
      u8"倾耳注目",
      u8"倾耳细听",
      u8"倾耳而出",
      u8"倾耳而听",
      u8"倾肝沥胆",
      u8"倾肠倒肚",
      u8"倾肠倒腹",
      u8"倾船",
      u8"倾覆",
      u8"倾覆力臂",
      u8"倾角",
      u8"倾诉",
      u8"倾诉人",
      u8"倾诉者",
      u8"倾诉衷情",
      u8"倾诉衷曲",
      u8"倾谈",
      u8"倾轧",
      u8"倾销",
      u8"倾销价",
      u8"倾销差价",
      u8"倾销幅度",
      u8"倾销法",
      u8"倾销税",
      u8"倾陷",
      u8"倾颓",
      u8"偃兵修文",
      u8"偃卧",
      u8"偃师",
      u8"偃师县",
      u8"偃师市",
      u8"偃旗仆鼓",
      u8"偃旗卧鼓",
      u8"偃旗息鼓",
      u8"偃月",
      u8"偃松",
      u8"偃武休兵",
      u8"偃武修文",
      u8"偃武兴文",
      u8"偃武崇文",
      u8"偃武息戈",
      u8"偃武櫜兵",
      u8"偃武行文",
      u8"偃武觌文",
      u8"偃甲息兵",
      u8"偃革为轩",
      u8"偃革倒戈",
      u8"偃革尚文",
      u8"偃鼠饮河",
      u8"假不对称碳",
      u8"假东方不败",
      u8"假两性畸形",
      u8"假人",
      u8"假人假义",
      u8"假人辞色",
      u8"假仁假义",
      u8"假仁假意",
      u8"假仁纵敌",
      u8"假令",
      u8"假以时日",
      u8"假以辞色",
      u8"假传",
      u8"假传圣旨",
      u8"假作",
      u8"假作真时真亦假",
      u8"假使",
      u8"假使会",
      u8"假使在",
      u8"假使有",
      u8"假使能",
      u8"假使说",
      u8"假信号",
      u8"假借",
      u8"假借名义",
      u8"假借法",
      u8"假充",
      u8"假公济私",
      u8"假公营私",
      u8"假关节形成",
      u8"假冒",
      u8"假冒伪劣",
      u8"假冒伪劣品",
      u8"假冒着",
      u8"假冒者",
      u8"假分数",
      u8"假列",
      u8"假力于人",
      u8"假劣",
      u8"假动作",
      u8"假单",
      u8"假发",
      u8"假发票",
      u8"假台口",
      u8"假合同",
      u8"假名",
      u8"假名假姓",
      u8"假名字",
      u8"假名托姓",
      u8"假名牌",
      u8"假哭",
      u8"假哭者",
      u8"假喀斯特",
      u8"假嗓子",
      u8"假图",
      u8"假基因",
      u8"假塑性",
      u8"假大空",
      u8"假如",
      u8"假如会",
      u8"假如是",
      u8"假如有",
      u8"假如能",
      u8"假如说",
      u8"假如非诉讼和",
      u8"假娘",
      u8"假孕",
      u8"假学历",
      u8"假定",
      u8"假定性",
      u8"假定是",
      u8"假定有",
      u8"假定说",
      u8"假寐",
      u8"假小子",
      u8"假尼姑",
      u8"假尿苷",
      u8"假山",
      u8"假峰",
      u8"假币",
      u8"假带",
      u8"假座",
      u8"假彩票",
      u8"假彩色",
      u8"假彩色合成",
      u8"假得",
      u8"假性",
      u8"假性幻觉",
      u8"假性甲状旁腺机能减退症",
      u8"假性痴呆",
      u8"假性近视",
      u8"假恶丑",
      u8"假情假意",
      u8"假惜",
      u8"假想",
      u8"假想敌",
      u8"假惺惺",
      u8"假意",
      u8"假慈悲",
      u8"假戏真做",
      u8"假戏真唱",
      u8"假手",
      u8"假手于人",
      u8"假手他人",
      u8"假托",
      u8"假扣押",
      u8"假执行",
      u8"假扮",
      u8"假扮作",
      u8"假报",
      u8"假拟结构",
      u8"假按揭",
      u8"假摔",
      u8"假撇清",
      u8"假文凭",
      u8"假新闻",
      u8"假旋转",
      u8"假日",
      u8"假日办",
      u8"假日活动",
      u8"假日酒店",
      u8"假显性",
      u8"假期",
      u8"假期作业",
      u8"假条",
      u8"假果",
      u8"假根",
      u8"假案",
      u8"假植",
      u8"假模假式",
      u8"假正经",
      u8"假死",
      u8"假泪",
      u8"假洋鬼子",
      u8"假消息",
      u8"假牌",
      u8"假牙",
      u8"假牙齿",
      u8"假珠宝",
      u8"假球",
      u8"假用",
      u8"假画",
      u8"假病毒",
      u8"假痴不癫",
      u8"假痴假呆",
      u8"假皮",
      u8"假相",
      u8"假眉三道",
      u8"假眼",
      u8"假睡",
      u8"假睫毛",
      u8"假票",
      u8"假种",
      u8"假笑",
      u8"假结",
      u8"假结婚",
      u8"假缎",
      u8"假肢",
      u8"假色",
      u8"假若",
      u8"假若会",
      u8"假若在",
      u8"假若是",
      u8"假若有",
      u8"假若能",
      u8"假药",
      u8"假药案",
      u8"假虎张威",
      u8"假装",
      u8"假装会",
      u8"假装在",
      u8"假装地",
      u8"假装是",
      u8"假装有",
      u8"假装神圣",
      u8"假装能",
      u8"假角蛋白",
      u8"假言",
      u8"假言判断",
      u8"假誉驰声",
      u8"假警察",
      u8"假设",
      u8"假设会",
      u8"假设在",
      u8"假设是",
      u8"假设有",
      u8"假设检验",
      u8"假设检验说",
      u8"假设能",
      u8"假设说",
      u8"假证",
      u8"假话",
      u8"假说",
      u8"假象",
      u8"假象牙",
      u8"假负载",
      u8"假账",
      u8"假货",
      u8"假贷",
      u8"假足",
      u8"假退役",
      u8"假送",
      u8"假途灭虢",
      u8"假造",
      u8"假造文件",
      u8"假道",
      u8"假道学",
      u8"假道灭虢",
      u8"假酒",
      u8"假释",
      u8"假释官",
      u8"假释期间",
      u8"假释犯",
      u8"假钞",
      u8"假钱",
      u8"假锁",
      u8"假门",
      u8"假门假事",
      u8"假门假氏",
      u8"假面",
      u8"假面具",
      u8"假面舞",
      u8"假面舞会",
      u8"假领",
      u8"假髻",
      u8"假鱼",
      u8"假齿",
      u8"偌大",
      u8"偎乾就湿",
      u8"偎依",
      u8"偎倚",
      u8"偎傍",
      u8"偎干就湿",
      u8"偎慵堕懒",
      u8"偎抱",
      u8"偎着",
      u8"偎红倚翠",
      u8"偎贴",
      u8"偎近",
      u8"偏三向四",
      u8"偏上",
      u8"偏上去",
      u8"偏上来",
      u8"偏下",
      u8"偏不",
      u8"偏不凑巧",
      u8"偏东",
      u8"偏东北",
      u8"偏东南",
      u8"偏乡僻壤",
      u8"偏了",
      u8"偏于",
      u8"偏会",
      u8"偏低",
      u8"偏侧凸颌",
      u8"偏侧化",
      u8"偏信",
      u8"偏信则暗",
      u8"偏倒",
      u8"偏倚",
      u8"偏偏",
      u8"偏僻",
      u8"偏僻地区",
      u8"偏光",
      u8"偏光片",
      u8"偏光镜",
      u8"偏关",
      u8"偏关县",
      u8"偏到",
      u8"偏劳",
      u8"偏北",
      u8"偏北风",
      u8"偏南",
      u8"偏南风",
      u8"偏历",
      u8"偏压",
      u8"偏去",
      u8"偏口鱼",
      u8"偏右",
      u8"偏后",
      u8"偏向",
      u8"偏向虎山行",
      u8"偏向角",
      u8"偏听",
      u8"偏听偏信",
      u8"偏听偏言",
      u8"偏听则暗",
      u8"偏回",
      u8"偏回去",
      u8"偏回归系数",
      u8"偏回来",
      u8"偏在",
      u8"偏处",
      u8"偏处一隅",
      u8"偏外",
      u8"偏多",
      u8"偏大",
      u8"偏失",
      u8"偏头",
      u8"偏头疼",
      u8"偏头痛",
      u8"偏好",
      u8"偏守",
      u8"偏安",
      u8"偏安一隅",
      u8"偏宜",
      u8"偏室",
      u8"偏宽",
      u8"偏射",
      u8"偏将",
      u8"偏小",
      u8"偏少",
      u8"偏峰",
      u8"偏左",
      u8"偏巧",
      u8"偏差",
      u8"偏己",
      u8"偏巷",
      u8"偏店",
      u8"偏废",
      u8"偏得",
      u8"偏微分",
      u8"偏微分方程",
      u8"偏德",
      u8"偏心",
      u8"偏心器",
      u8"偏心圆",
      u8"偏心眼",
      u8"偏心眼儿",
      u8"偏心短节",
      u8"偏心轮",
      u8"偏心配水器",
      u8"偏房",
      u8"偏执",
      u8"偏执狂",
      u8"偏护",
      u8"偏护着",
      u8"偏振",
      u8"偏振光",
      u8"偏振度",
      u8"偏振片",
      u8"偏振镜",
      u8"偏掉",
      u8"偏摩尔量",
      u8"偏斜",
      u8"偏方",
      u8"偏旁",
      u8"偏旁部首",
      u8"偏是",
      u8"偏暗",
      u8"偏有",
      u8"偏来",
      u8"偏来偏去",
      u8"偏松",
      u8"偏析",
      u8"偏枯",
      u8"偏正",
      u8"偏正结构",
      u8"偏歪",
      u8"偏殿",
      u8"偏流",
      u8"偏激",
      u8"偏爱",
      u8"偏狂",
      u8"偏狭",
      u8"偏疼",
      u8"偏瘦",
      u8"偏瘫",
      u8"偏相关",
      u8"偏着",
      u8"偏短",
      u8"偏码",
      u8"偏磷酸",
      u8"偏离",
      u8"偏离正轨",
      u8"偏私",
      u8"偏科",
      u8"偏移",
      u8"偏移不足",
      u8"偏移校正剖面",
      u8"偏移电压",
      u8"偏移量",
      u8"偏窄",
      u8"偏紧",
      u8"偏紫",
      u8"偏累",
      u8"偏细",
      u8"偏置",
      u8"偏胖",
      u8"偏至",
      u8"偏航",
      u8"偏色",
      u8"偏苯三甲酸三辛酯",
      u8"偏蓝",
      u8"偏蚀",
      u8"偏衫",
      u8"偏袒",
      u8"偏西",
      u8"偏西北",
      u8"偏西南",
      u8"偏要",
      u8"偏见",
      u8"偏角",
      u8"偏转",
      u8"偏转板",
      u8"偏转线圈",
      u8"偏轻",
      u8"偏辞",
      u8"偏远",
      u8"偏远地区",
      u8"偏重",
      u8"偏重于",
      u8"偏重在",
      u8"偏重钻铤",
      u8"偏锋",
      u8"偏长",
      u8"偏门",
      u8"偏靠",
      u8"偏靠在",
      u8"偏顾",
      u8"偏顾着",
      u8"偏颇",
      u8"偏题",
      u8"偏食",
      u8"偏饭",
      u8"偏高",
      u8"偏黄",
      u8"偕同",
      u8"偕生之疾",
      u8"偕老",
      u8"偕行",
      u8"做一个",
      u8"做一天和尚撞一天钟",
      u8"做一套",
      u8"做一日和尚撞一天钟",
      u8"做一日和尚撞一日钟",
      u8"做上",
      u8"做下来",
      u8"做不到",
      u8"做不来",
      u8"做东",
      u8"做个",
      u8"做为",
      u8"做主",
      u8"做习题",
      u8"做买卖",
      u8"做了",
      u8"做事",
      u8"做事情",
      u8"做些",
      u8"做亲",
      u8"做人",
      u8"做人做世",
      u8"做人家",
      u8"做人情",
      u8"做人流",
      u8"做人要厚道",
      u8"做什么",
      u8"做伴",
      u8"做作",
      u8"做作业",
      u8"做作业时",
      u8"做你",
      u8"做保",
      u8"做假",
      u8"做假账",
      u8"做做",
      u8"做做事",
      u8"做准备",
      u8"做出",
      u8"做出公正判决",
      u8"做出来",
      u8"做刚做柔",
      u8"做到",
      u8"做功",
      u8"做卖买",
      u8"做台",
      u8"做呕",
      u8"做回",
      u8"做圈套",
      u8"做在",
      u8"做声",
      u8"做大",
      u8"做好",
      u8"做好事",
      u8"做好人",
      u8"做好做恶",
      u8"做好做歹",
      u8"做好哦爱你",
      u8"做媒",
      u8"做媚眼",
      u8"做学问",
      u8"做完",
      u8"做完作业",
      u8"做官",
      u8"做客",
      u8"做对",
      u8"做寿",
      u8"做小",
      u8"做小伏低",
      u8"做工",
      u8"做广告",
      u8"做庄",
      u8"做张做势",
      u8"做张做智",
      u8"做张做致",
      u8"做得",
      u8"做得到",
      u8"做得好",
      u8"做得来",
      u8"做戏",
      u8"做成",
      u8"做成花环",
      u8"做手",
      u8"做手势",
      u8"做手术",
      u8"做手脚",
      u8"做掉",
      u8"做操",
      u8"做文章",
      u8"做案",
      u8"做梦",
      u8"做比",
      u8"做法",
      u8"做活",
      u8"做活儿",
      u8"做派",
      u8"做满月",
      u8"做点事",
      u8"做爱",
      u8"做爱做",
      u8"做爱图",
      u8"做爱时",
      u8"做爱片",
      u8"做爱网",
      u8"做牌",
      u8"做牛做马",
      u8"做生意",
      u8"做生日",
      u8"做生活",
      u8"做眉做眼",
      u8"做着",
      u8"做礼拜",
      u8"做神做鬼",
      u8"做秀",
      u8"做种",
      u8"做答",
      u8"做给",
      u8"做股票",
      u8"做脸",
      u8"做菜",
      u8"做表",
      u8"做表面文章",
      u8"做试验",
      u8"做诗",
      u8"做账",
      u8"做贼",
      u8"做贼心虚",
      u8"做起",
      u8"做起来",
      u8"做过",
      u8"做针线",
      u8"做错",
      u8"做错事",
      u8"做零工",
      u8"做题",
      u8"做饭",
      u8"做饭吃",
      u8"做鬼",
      u8"做鬼也风流",
      u8"做鬼做神",
      u8"做鬼脸",
      u8"停上",
      u8"停上去",
      u8"停上来",
      u8"停下",
      u8"停下去",
      u8"停下来",
      u8"停不下",
      u8"停不下来",
      u8"停不住",
      u8"停业",
      u8"停业处份",
      u8"停业整顿",
      u8"停了",
      u8"停云落月",
      u8"停产",
      u8"停付",
      u8"停会",
      u8"停住",
      u8"停停",
      u8"停停当当",
      u8"停停看",
      u8"停刊",
      u8"停刊处分",
      u8"停到",
      u8"停制",
      u8"停办",
      u8"停匀",
      u8"停发",
      u8"停售",
      u8"停在",
      u8"停好",
      u8"停妥",
      u8"停妻再娶",
      u8"停学",
      u8"停完",
      u8"停尸",
      u8"停尸房",
      u8"停尸间",
      u8"停工",
      u8"停工处分",
      u8"停工待料",
      u8"停建",
      u8"停开",
      u8"停当",
      u8"停征",
      u8"停得",
      u8"停徵",
      u8"停息",
      u8"停战",
      u8"停战协定",
      u8"停战和约",
      u8"停手",
      u8"停拨",
      u8"停掉",
      u8"停摆",
      u8"停播",
      u8"停放",
      u8"停放在",
      u8"停显",
      u8"停有",
      u8"停机",
      u8"停机场",
      u8"停机坪",
      u8"停机库",
      u8"停机问题",
      u8"停来停去",
      u8"停板",
      u8"停歇",
      u8"停止",
      u8"停止下来",
      u8"停止使用",
      u8"停止工作",
      u8"停止流动法",
      u8"停步",
      u8"停水",
      u8"停水通知",
      u8"停泊",
      u8"停泊费",
      u8"停滞",
      u8"停滞不前",
      u8"停滞不前庭院",
      u8"停火",
      u8"停火协办",
      u8"停火协定",
      u8"停火协议",
      u8"停灵",
      u8"停用",
      u8"停电",
      u8"停电通知",
      u8"停留",
      u8"停留在",
      u8"停留时间",
      u8"停留长智",
      u8"停着",
      u8"停站",
      u8"停笔",
      u8"停约",
      u8"停线",
      u8"停经",
      u8"停经期",
      u8"停经片",
      u8"停缴",
      u8"停置",
      u8"停职",
      u8"停职反省",
      u8"停职检查",
      u8"停航",
      u8"停船",
      u8"停船靠岸",
      u8"停药",
      u8"停薪",
      u8"停薪留职",
      u8"停表",
      u8"停训",
      u8"停诊",
      u8"停话",
      u8"停课",
      u8"停赛",
      u8"停蹄",
      u8"停车",
      u8"停车位",
      u8"停车场",
      u8"停车处",
      u8"停车库",
      u8"停车换乘",
      u8"停车楼",
      u8"停车灯",
      u8"停车费",
      u8"停车难",
      u8"停转",
      u8"停载",
      u8"停辛伫苦",
      u8"停辛贮苦",
      u8"停过",
      u8"停过去",
      u8"停过来",
      u8"停进",
      u8"停进去",
      u8"停进来",
      u8"停错",
      u8"停闭",
      u8"停靠",
      u8"停靠在",
      u8"停靠站",
      u8"停顿",
      u8"停顿下来",
      u8"停飞",
      u8"停食",
      u8"停驶",
      u8"停驻",
      u8"健与美",
      u8"健体",
      u8"健健康康",
      u8"健儿",
      u8"健全",
      u8"健全人格",
      u8"健全制度",
      u8"健全性",
      u8"健全法制",
      u8"健力宝",
      u8"健在",
      u8"健在者",
      u8"健壮",
      u8"健壮如牛",
      u8"健壮性",
      u8"健存",
      u8"健将",
      u8"健康",
      u8"健康作品",
      u8"健康发展",
      u8"健康器",
      u8"健康心理",
      u8"健康情况",
      u8"健康成长",
      u8"健康报",
      u8"健康检查",
      u8"健康歌",
      u8"健康活泼",
      u8"健康状况",
      u8"健康秤",
      u8"健康网",
      u8"健康美",
      u8"健康证",
      u8"健康长寿",
      u8"健康险",
      u8"健忘",
      u8"健忘症",
      u8"健忘者",
      u8"健慰器",
      u8"健教",
      u8"健旺",
      u8"健智牌",
      u8"健朗",
      u8"健次郎",
      u8"健步",
      u8"健步如飞",
      u8"健民",
      u8"健硕",
      u8"健立",
      u8"健美",
      u8"健美先生",
      u8"健美小姐",
      u8"健美操",
      u8"健美活动",
      u8"健美裤",
      u8"健美运动",
      u8"健胃",
      u8"健脑",
      u8"健脾",
      u8"健脾开胃",
      u8"健脾胃",
      u8"健行",
      u8"健行工专",
      u8"健行队",
      u8"健谈",
      u8"健身",
      u8"健身卡",
      u8"健身器",
      u8"健身器材",
      u8"健身房",
      u8"健身操",
      u8"健身椅",
      u8"健身活动",
      u8"健身球",
      u8"健身车",
      u8"健身运动",
      u8"健骨生",
      u8"偭规越矩",
      u8"偭规错矩",
      u8"偶一",
      u8"偶一为之",
      u8"偶也来",
      u8"偶人",
      u8"偶们",
      u8"偶像",
      u8"偶像人物",
      u8"偶像剧",
      u8"偶像化",
      u8"偶像崇拜",
      u8"偶函数",
      u8"偶发",
      u8"偶发事件",
      u8"偶发性",
      u8"偶变投隙",
      u8"偶合",
      u8"偶合器",
      u8"偶姻",
      u8"偶尔",
      u8"偶性",
      u8"偶感",
      u8"偶或",
      u8"偶提",
      u8"偶数",
      u8"偶数号",
      u8"偶数按摩",
      u8"偶数排",
      u8"偶数班",
      u8"偶有",
      u8"偶极亲质子溶剂",
      u8"偶极子",
      u8"偶极子反射率",
      u8"偶极子天线",
      u8"偶极矩",
      u8"偶极非质子溶剂",
      u8"偶氮",
      u8"偶氮化物",
      u8"偶氮染料",
      u8"偶氮染色法",
      u8"偶氮胂",
      u8"偶然",
      u8"偶然中断",
      u8"偶然之间",
      u8"偶然变异",
      u8"偶然地",
      u8"偶然学习",
      u8"偶然性",
      u8"偶然误差",
      u8"偶然间",
      u8"偶犯",
      u8"偶笔",
      u8"偶而",
      u8"偶而为之",
      u8"偶联",
      u8"偶联剂",
      u8"偶联磷酸化",
      u8"偶联聚合",
      u8"偶见",
      u8"偶记",
      u8"偶语",
      u8"偶象",
      u8"偶起",
      u8"偶蹄目",
      u8"偶逢",
      u8"偶遇",
      u8"偷上",
      u8"偷上去",
      u8"偷上来",
      u8"偷下",
      u8"偷下去",
      u8"偷下来",
      u8"偷东摸西",
      u8"偷东西",
      u8"偷书",
      u8"偷了",
      u8"偷人",
      u8"偷作",
      u8"偷做",
      u8"偷停",
      u8"偷偷",
      u8"偷偷地",
      u8"偷偷插入",
      u8"偷偷摸摸",
      u8"偷光",
      u8"偷入",
      u8"偷凉",
      u8"偷出",
      u8"偷出去",
      u8"偷出来",
      u8"偷到",
      u8"偷办",
      u8"偷功夫",
      u8"偷加",
      u8"偷包",
      u8"偷去",
      u8"偷发",
      u8"偷取",
      u8"偷取者",
      u8"偷叫",
      u8"偷吃",
      u8"偷合取容",
      u8"偷合苟从",
      u8"偷合苟容",
      u8"偷听",
      u8"偷吸",
      u8"偷售",
      u8"偷喝",
      u8"偷嘴",
      u8"偷回",
      u8"偷回去",
      u8"偷回来",
      u8"偷垒",
      u8"偷填",
      u8"偷声细气",
      u8"偷天换日",
      u8"偷夹",
      u8"偷奸取巧",
      u8"偷奸耍滑",
      u8"偷媚取容",
      u8"偷存",
      u8"偷学",
      u8"偷安",
      u8"偷安旦夕",
      u8"偷宰",
      u8"偷寄",
      u8"偷寒送暖",
      u8"偷尝禁果",
      u8"偷工",
      u8"偷工减料",
      u8"偷巧",
      u8"偷师",
      u8"偷带",
      u8"偷开",
      u8"偷开到",
      u8"偷开去",
      u8"偷开来",
      u8"偷录",
      u8"偷得",
      u8"偷得浮生",
      u8"偷得浮生半日闲",
      u8"偷心",
      u8"偷情",
      u8"偷情盗爱",
      u8"偷懒",
      u8"偷打",
      u8"偷抄",
      u8"偷抗税案",
      u8"偷报",
      u8"偷抱",
      u8"偷拍",
      u8"偷拍图",
      u8"偷拍某",
      u8"偷拍照",
      u8"偷拍网",
      u8"偷拿",
      u8"偷换",
      u8"偷换概念",
      u8"偷搞",
      u8"偷搬",
      u8"偷摸",
      u8"偷收",
      u8"偷教",
      u8"偷数",
      u8"偷来",
      u8"偷来偷去",
      u8"偷架",
      u8"偷梁换柱",
      u8"偷樑换柱",
      u8"偷欢",
      u8"偷水",
      u8"偷油",
      u8"偷法",
      u8"偷泡",
      u8"偷洗",
      u8"偷渡",
      u8"偷渡客",
      u8"偷渡案",
      u8"偷渡者",
      u8"偷渡过境",
      u8"偷溜",
      u8"偷溜走",
      u8"偷漏",
      u8"偷漏税",
      u8"偷炒",
      u8"偷牛盗马",
      u8"偷狗戏鸡",
      u8"偷猎",
      u8"偷猎者",
      u8"偷球",
      u8"偷生",
      u8"偷电",
      u8"偷盗",
      u8"偷看",
      u8"偷眼",
      u8"偷着",
      u8"偷着乐",
      u8"偷着哭",
      u8"偷睡",
      u8"偷砍",
      u8"偷种",
      u8"偷税",
      u8"偷税案",
      u8"偷税漏税",
      u8"偷税罪",
      u8"偷税额",
      u8"偷空",
      u8"偷窃",
      u8"偷窃狂",
      u8"偷窃罪",
      u8"偷窃行为",
      u8"偷窥",
      u8"偷窥图",
      u8"偷窥女",
      u8"偷窥狂",
      u8"偷窥网",
      u8"偷窥者",
      u8"偷笑",
      u8"偷腥",
      u8"偷花",
      u8"偷花贼",
      u8"偷营",
      u8"偷营劫寨",
      u8"偷袭",
      u8"偷讲",
      u8"偷请",
      u8"偷读",
      u8"偷课",
      u8"偷调",
      u8"偷走",
      u8"偷起",
      u8"偷起来",
      u8"偷越",
      u8"偷跑",
      u8"偷跳",
      u8"偷车",
      u8"偷车贼",
      u8"偷载",
      u8"偷过",
      u8"偷过去",
      u8"偷过来",
      u8"偷运",
      u8"偷逃",
      u8"偷逃税",
      u8"偷采",
      u8"偷钱",
      u8"偷铁",
      u8"偷闲",
      u8"偷闲躲静",
      u8"偷领",
      u8"偷食禁果",
      u8"偷香盗玉者",
      u8"偷香窃玉",
      u8"偷骑",
      u8"偷鸡不成蚀把米",
      u8"偷鸡不着",
      u8"偷鸡不着蚀把米",
      u8"偷鸡摸狗",
      u8"偷鸡盗狗",
      u8"偺们",
      u8"偿付",
      u8"偿付能力",
      u8"偿债",
      u8"偿债基金",
      u8"偿其大欲",
      u8"偿命",
      u8"偿回",
      u8"偿回去",
      u8"偿回来",
      u8"偿愿",
      u8"偿清",
      u8"偿还",
      u8"偿还债务",
      u8"偿还日",
      u8"偿还期",
      u8"偿还血债",
      u8"傀儡",
      u8"傀儡戏",
      u8"傀儡政府",
      u8"傀儡政权",
      u8"傀奇",
      u8"傀异",
      u8"傀标",
      u8"傅体",
      u8"傅作义",
      u8"傅佩嘉",
      u8"傅全有",
      u8"傅利叶",
      u8"傅勇凡",
      u8"傅园",
      u8"傅天颖",
      u8"傅娟",
      u8"傅学诚",
      u8"傅彩",
      u8"傅彪",
      u8"傅志寰",
      u8"傅思归",
      u8"傅抱石",
      u8"傅斌",
      u8"傅斯年",
      u8"傅明宪",
      u8"傅晓宇",
      u8"傅杰",
      u8"傅科摆",
      u8"傅立叶",
      u8"傅粉",
      u8"傅粉何郎",
      u8"傅粉施朱",
      u8"傅羽佳",
      u8"傅艺伟",
      u8"傅莉丽",
      u8"傅里叶光学",
      u8"傅里叶变换",
      u8"傅里叶定律",
      u8"傅里叶空间",
      u8"傅里叶系数",
      u8"傅铁山",
      u8"傅青主女科",
      u8"傈僳",
      u8"傈僳族",
      u8"傍亮儿",
      u8"傍人依户",
      u8"傍人篱壁",
      u8"傍人篱落",
      u8"傍人门户",
      u8"傍偟",
      u8"傍午",
      u8"傍徨",
      u8"傍晚",
      u8"傍晚时候",
      u8"傍水",
      u8"傍系",
      u8"傍花随柳",
      u8"傍若无人",
      u8"傍观冷眼",
      u8"傍观者审当局者迷",
      u8"傍观者清",
      u8"傍轴条件",
      u8"傍轴近似",
      u8"傍边",
      u8"傍边儿",
      u8"傍靠",
      u8"傍黑",
      u8"傍黑儿",
      u8"傢俬",
      u8"傣乡",
      u8"傣历",
      u8"傣味",
      u8"傣族",
      u8"傥来之物",
      u8"傧相",
      u8"储位",
      u8"储供",
      u8"储值卡",
      u8"储君",
      u8"储备",
      u8"储备品",
      u8"储备基金",
      u8"储备库",
      u8"储备棉",
      u8"储备物资",
      u8"储备粮",
      u8"储备量",
      u8"储备金",
      u8"储存",
      u8"储存区",
      u8"储存卡",
      u8"储存器",
      u8"储存处",
      u8"储存室",
      u8"储存库",
      u8"储存罐",
      u8"储存起来",
      u8"储存量",
      u8"储层地质学",
      u8"储户",
      u8"储放",
      u8"储放槽",
      u8"储智博",
      u8"储气库",
      u8"储气罐",
      u8"储水",
      u8"储水柜",
      u8"储水量",
      u8"储油",
      u8"储油区",
      u8"储油平台",
      u8"储油构造",
      u8"储油罐",
      u8"储油量",
      u8"储波",
      u8"储灰场",
      u8"储物箱",
      u8"储电量",
      u8"储积",
      u8"储粮",
      u8"储精蓄税",
      u8"储罐",
      u8"储蓄",
      u8"储蓄卡",
      u8"储蓄员",
      u8"储蓄存款",
      u8"储蓄所",
      u8"储蓄机构",
      u8"储蓄率",
      u8"储蓄金",
      u8"储蓄银行",
      u8"储蓄额",
      u8"储藏",
      u8"储藏室",
      u8"储藏库",
      u8"储藏所",
      u8"储藏柜",
      u8"储藏量",
      u8"储藏间",
      u8"储装",
      u8"储训",
      u8"储训人才",
      u8"储训干部",
      u8"储贷",
      u8"储起来",
      u8"储运",
      u8"储运部",
      u8"储量",
      u8"储金",
      u8"储金会",
      u8"储金池",
      u8"储集岩",
      u8"傩神",
      u8"傫如丧狗",
      u8"催乳素",
      u8"催产",
      u8"催产素",
      u8"催产药",
      u8"催人奋进",
      u8"催人泪下",
      u8"催人老",
      u8"催促",
      u8"催债",
      u8"催健",
      u8"催办",
      u8"催化",
      u8"催化亚基",
      u8"催化作用",
      u8"催化剂",
      u8"催化反应",
      u8"催化器",
      u8"催化性抗体",
      u8"催化机理",
      u8"催化核心",
      u8"催化比色法",
      u8"催化氢化",
      u8"催化氢波",
      u8"催化活性",
      u8"催化荧光法",
      u8"催化蒸馏",
      u8"催化裂化",
      u8"催化选择性",
      u8"催化部位",
      u8"催化重整",
      u8"催发",
      u8"催吐",
      u8"催吐剂",
      u8"催告",
      u8"催命",
      u8"催命鬼",
      u8"催奶",
      u8"催奶剂",
      u8"催干剂",
      u8"催征",
      u8"催情",
      u8"催情剂",
      u8"催情粉",
      u8"催情药",
      u8"催收",
      u8"催林",
      u8"催款",
      u8"催款函",
      u8"催残",
      u8"催毁",
      u8"催毁性",
      u8"催泪",
      u8"催泪剂",
      u8"催泪弹",
      u8"催泪物",
      u8"催泪瓦斯",
      u8"催涎剂",
      u8"催熟",
      u8"催片",
      u8"催生",
      u8"催生作用",
      u8"催生出",
      u8"催眠",
      u8"催眠地",
      u8"催眠恍惚状态",
      u8"催眠曲",
      u8"催眠术",
      u8"催眠疗法",
      u8"催眠药",
      u8"催租",
      u8"催粮",
      u8"催缴",
      u8"催缴资本",
      u8"催肥",
      u8"催花量",
      u8"催芽",
      u8"催讨",
      u8"催账单",
      u8"催赶",
      u8"催赶着",
      u8"催还",
      u8"催还通知",
      u8"催逼",
      u8"催青",
      u8"傲不可长",
      u8"傲世",
      u8"傲世轻物",
      u8"傲人",
      u8"傲剑",
      u8"傲头傲脑",
      u8"傲岸",
      u8"傲岸不群",
      u8"傲性",
      u8"傲慢",
      u8"傲慢不逊",
      u8"傲慢与偏见",
      u8"傲慢少礼",
      u8"傲慢无礼",
      u8"傲气",
      u8"傲气凌人",
      u8"傲然",
      u8"傲然屹立",
      u8"傲然挺立",
      u8"傲然自得",
      u8"傲物",
      u8"傲睨一世",
      u8"傲睨一切",
      u8"傲睨万物",
      u8"傲睨得志",
      u8"傲睨自若",
      u8"傲神传",
      u8"傲视",
      u8"傲视一切",
      u8"傲视群伦",
      u8"傲视群芳",
      u8"傲视群雄",
      u8"傲贤慢士",
      u8"傲起来",
      u8"傲雪凌霜",
      u8"傲雪欺霜",
      u8"傲霜凌雪",
      u8"傲霜斗雪",
      u8"傲骨",
      u8"傲骨凌人",
      u8"傲骨嶙峋",
      u8"傲骨嶙嶙",
      u8"傻不拉唧",
      u8"傻丫头",
      u8"傻乎乎",
      u8"傻乐",
      u8"傻了",
      u8"傻事",
      u8"傻人",
      u8"傻人自有傻福",
      u8"傻傻",
      u8"傻傻忽忽",
      u8"傻儿巴叽",
      u8"傻冒",
      u8"傻劲",
      u8"傻劲儿",
      u8"傻呵呵",
      u8"傻大姐",
      u8"傻大黑粗",
      u8"傻头傻脑",
      u8"傻女",
      u8"傻子",
      u8"傻小子",
      u8"傻屄",
      u8"傻帽",
      u8"傻帽儿",
      u8"傻干",
      u8"傻强",
      u8"傻憨",
      u8"傻气",
      u8"傻狗",
      u8"傻瓜",
      u8"傻瓜化",
      u8"傻瓜式",
      u8"傻瓜机",
      u8"傻瓜版",
      u8"傻瓜相机",
      u8"傻瓜蛋",
      u8"傻眼",
      u8"傻笑",
      u8"傻等",
      u8"傻脱",
      u8"傻蛋",
      u8"傻话",
      u8"傻里傻气",
      u8"傻高",
      u8"僇辱",
      u8"像不像",
      u8"像个",
      u8"像他",
      u8"像似",
      u8"像你",
      u8"像册",
      u8"像前",
      u8"像图",
      u8"像圈",
      u8"像在",
      u8"像她",
      u8"像差",
      u8"像形夺名",
      u8"像心像意",
      u8"像心如意",
      u8"像心称意",
      u8"像心适意",
      u8"像您",
      u8"像我",
      u8"像是",
      u8"像样",
      u8"像样儿",
      u8"像模像样",
      u8"像煞有介",
      u8"像煞有介事",
      u8"像爬虫",
      u8"像片",
      u8"像白云像清风",
      u8"像章",
      u8"像素",
      u8"像素数",
      u8"像素点",
      u8"像胶",
      u8"像被",
      u8"像要",
      u8"像话",
      u8"像貌",
      u8"像距",
      u8"僚佐",
      u8"僚友",
      u8"僚属",
      u8"僚机",
      u8"僧人",
      u8"僧众",
      u8"僧伽",
      u8"僧伽罗",
      u8"僧侣",
      u8"僧侣主义",
      u8"僧俗",
      u8"僧堂",
      u8"僧多粥少",
      u8"僧孺",
      u8"僧寺",
      u8"僧尼",
      u8"僧帽",
      u8"僧徒",
      u8"僧服",
      u8"僧格林沁",
      u8"僧肇",
      u8"僧衣",
      u8"僧袍",
      u8"僧院",
      u8"僧面",
      u8"僧鞋",
      u8"僭取",
      u8"僭号",
      u8"僭赏滥刑",
      u8"僭越",
      u8"僮仆",
      u8"僳僳族",
      u8"僵住",
      u8"僵冷",
      u8"僵冻",
      u8"僵化",
      u8"僵卧",
      u8"僵固",
      u8"僵尸",
      u8"僵尸洞",
      u8"僵局",
      u8"僵持",
      u8"僵持不下",
      u8"僵掉",
      u8"僵李代桃",
      u8"僵桃代李",
      u8"僵死",
      u8"僵滞",
      u8"僵直",
      u8"僵硬",
      u8"僵硬不变",
      u8"僵立",
      u8"僵蚕",
      u8"僻典",
      u8"僻壤",
      u8"僻处一隅",
      u8"僻字",
      u8"僻字涩句",
      u8"僻巷",
      u8"僻异怪诡",
      u8"僻远",
      u8"僻道",
      u8"僻陋",
      u8"僻静",
      u8"儋县",
      u8"儋州",
      u8"儋州市",
      u8"儋石之储",
      u8"儒医",
      u8"儒商",
      u8"儒墨",
      u8"儒士",
      u8"儒学",
      u8"儒学家",
      u8"儒家",
      u8"儒家思想",
      u8"儒家文化",
      u8"儒将",
      u8"儒教",
      u8"儒术",
      u8"儒林",
      u8"儒林外史",
      u8"儒生",
      u8"儒略历",
      u8"儒者",
      u8"儒艮",
      u8"儒道",
      u8"儒门事亲",
      u8"儒雅",
      u8"儒雅风流",
      u8"儗不于伦",
      u8"儗非其伦",
      u8"儿化",
      u8"儿大不由娘",
      u8"儿女",
      u8"儿女之债",
      u8"儿女之命",
      u8"儿女之情",
      u8"儿女亲家",
      u8"儿女债",
      u8"儿女心肠",
      u8"儿女情长",
      u8"儿女成群",
      u8"儿女成行",
      u8"儿媳",
      u8"儿媳妇",
      u8"儿媳妇儿",
      u8"儿子",
      u8"儿子般",
      u8"儿子身份",
      u8"儿孙",
      u8"儿孙满堂",
      u8"儿孙自有",
      u8"儿孙自有儿孙福",
      u8"儿少",
      u8"儿戏",
      u8"儿时",
      u8"儿歌",
      u8"儿男",
      u8"儿皇帝",
      u8"儿科",
      u8"儿科医生",
      u8"儿科医院",
      u8"儿科学",
      u8"儿童",
      u8"儿童不宜",
      u8"儿童乐园",
      u8"儿童公园",
      u8"儿童剧",
      u8"儿童医院",
      u8"儿童口腔医学",
      u8"儿童口腔正畸学",
      u8"儿童哮喘",
      u8"儿童团",
      u8"儿童图书",
      u8"儿童图书馆",
      u8"儿童床",
      u8"儿童座椅",
      u8"儿童心理",
      u8"儿童心理学",
      u8"儿童房",
      u8"儿童教育",
      u8"儿童文学",
      u8"儿童文学家",
      u8"儿童智力",
      u8"儿童服装",
      u8"儿童期",
      u8"儿童村",
      u8"儿童活动",
      u8"儿童活动区",
      u8"儿童灯笼短裤",
      u8"儿童片",
      u8"儿童玩具",
      u8"儿童用品",
      u8"儿童画",
      u8"儿童票",
      u8"儿童笑话",
      u8"儿童精神病",
      u8"儿童网",
      u8"儿童节",
      u8"儿童节目",
      u8"儿童英语",
      u8"儿童诗",
      u8"儿童读物",
      u8"儿童音乐",
      u8"儿茶",
      u8"儿茶素",
      u8"儿茶酚",
      u8"儿茶酚胺",
      u8"儿茶酚胺类激素",
      u8"儿茶酚胺能受体",
      u8"儿行千里母担忧",
      u8"儿郎",
      u8"儿马",
      u8"兀傲",
      u8"兀然",
      u8"兀突",
      u8"兀立",
      u8"兀自",
      u8"兀鹫",
      u8"兀鹰",
      u8"允从",
      u8"允准",
      u8"允可",
      u8"允当",
      u8"允执其中",
      u8"允执厥中",
      u8"允承",
      u8"允文允武",
      u8"允武",
      u8"允许",
      u8"允许日摄入量",
      u8"允许浓度",
      u8"允许温差",
      u8"允诺",
      u8"元世祖",
      u8"元义方",
      u8"元书纸",
      u8"元亨利",
      u8"元人",
      u8"元代",
      u8"元代人",
      u8"元件",
      u8"元件厂",
      u8"元件库",
      u8"元任",
      u8"元伤",
      u8"元元",
      u8"元元之民",
      u8"元元旦",
      u8"元元本本",
      u8"元兄",
      u8"元凳",
      u8"元凶",
      u8"元初",
      u8"元功",
      u8"元勋",
      u8"元华",
      u8"元反应",
      u8"元古",
      u8"元古界",
      u8"元史",
      u8"元嘉",
      u8"元器件",
      u8"元地理学",
      u8"元坝区",
      u8"元培",
      u8"元夜",
      u8"元太祖",
      u8"元女",
      u8"元奸巨恶",
      u8"元好问",
      u8"元始",
      u8"元子",
      u8"元字符",
      u8"元宝",
      u8"元宝区",
      u8"元宝山区",
      u8"元宝枫",
      u8"元宝草",
      u8"元宵",
      u8"元宵夜",
      u8"元宵节",
      u8"元山",
      u8"元帅",
      u8"元帝",
      u8"元年",
      u8"元广波",
      u8"元彪",
      u8"元彬",
      u8"元恶",
      u8"元恶大奸",
      u8"元恶大憝",
      u8"元恶大憨",
      u8"元悲",
      u8"元戎",
      u8"元戎启行",
      u8"元斌",
      u8"元方季方",
      u8"元日",
      u8"元旦",
      u8"元旦假期",
      u8"元旦晚会",
      u8"元旦节",
      u8"元明",
      u8"元明两代",
      u8"元明粉",
      u8"元晟溱",
      u8"元曲",
      u8"元月",
      u8"元月份",
      u8"元朔",
      u8"元朗",
      u8"元朝",
      u8"元朝人",
      u8"元本",
      u8"元杂剧",
      u8"元柳",
      u8"元桌",
      u8"元氏",
      u8"元氏县",
      u8"元气",
      u8"元气大伤",
      u8"元气大衰",
      u8"元江",
      u8"元江哈尼族彝族傣族自治县",
      u8"元澄道人",
      u8"元煤",
      u8"元狩",
      u8"元珠笔",
      u8"元由",
      u8"元痛",
      u8"元祖",
      u8"元神祭",
      u8"元稹",
      u8"元素",
      u8"元素主义",
      u8"元素周期",
      u8"元素周期律",
      u8"元素对比",
      u8"元素符号",
      u8"元素靶",
      u8"元组",
      u8"元组关系演算",
      u8"元经秘旨",
      u8"元老",
      u8"元老派",
      u8"元老级",
      u8"元老院",
      u8"元臣",
      u8"元色",
      u8"元规则",
      u8"元认知",
      u8"元语言",
      u8"元谋",
      u8"元谋人",
      u8"元谋县",
      u8"元谋猿人",
      u8"元逻辑",
      u8"元配",
      u8"元针",
      u8"元钉",
      u8"元门",
      u8"元阳",
      u8"元阳县",
      u8"元雅",
      u8"元霄",
      u8"元霄节",
      u8"元青花",
      u8"元音",
      u8"元首",
      u8"元首级",
      u8"元鱼",
      u8"元麦",
      u8"元龙豪气",
      u8"元龙高卧",
      u8"兄友弟恭",
      u8"兄台",
      u8"兄妹",
      u8"兄妹俩",
      u8"兄妹情",
      u8"兄姐",
      u8"兄嫂",
      u8"兄弟",
      u8"兄弟两人",
      u8"兄弟二人",
      u8"兄弟们",
      u8"兄弟俩",
      u8"兄弟党",
      u8"兄弟姐妹",
      u8"兄弟怡怡",
      u8"兄弟杯",
      u8"兄弟民族",
      u8"兄弟般",
      u8"兄弟连",
      u8"兄弟阋于墙",
      u8"兄弟阋于墙外御其侮",
      u8"兄弟阋墙",
      u8"兄死弟及",
      u8"兄终弟及",
      u8"兄肥弟瘦",
      u8"兄贵",
      u8"兄长",
      u8"充任",
      u8"充仿",
      u8"充作",
      u8"充值",
      u8"充值卡",
      u8"充假",
      u8"充充",
      u8"充充气",
      u8"充公",
      u8"充其量",
      u8"充内行",
      u8"充军",
      u8"充分",
      u8"充分体现",
      u8"充分准备",
      u8"充分利用",
      u8"充分反映",
      u8"充分发展",
      u8"充分发扬",
      u8"充分发挥",
      u8"充分地",
      u8"充分就业",
      u8"充分条件",
      u8"充分考虑",
      u8"充分肯定",
      u8"充分行使",
      u8"充分认识",
      u8"充分证明",
      u8"充分说明",
      u8"充分调动",
      u8"充分运用",
      u8"充到",
      u8"充塞",
      u8"充塞着",
      u8"充填",
      u8"充填剂",
      u8"充填器",
      u8"充填工具",
      u8"充填机",
      u8"充天塞地",
      u8"充好",
      u8"充实",
      u8"充当",
      u8"充当人质",
      u8"充当先锋",
      u8"充放电",
      u8"充数",
      u8"充斥",
      u8"充斥市面",
      u8"充栋汗牛",
      u8"充栋盈车",
      u8"充气",
      u8"充气卡通",
      u8"充气吹胀",
      u8"充气差异电池",
      u8"充气床",
      u8"充气式",
      u8"充气机",
      u8"充气泵",
      u8"充气袋",
      u8"充水",
      u8"充沛",
      u8"充油丁苯橡胶",
      u8"充溢",
      u8"充满",
      u8"充满了",
      u8"充满侵略性",
      u8"充满信心",
      u8"充满希望",
      u8"充满活力",
      u8"充满热情",
      u8"充满生机",
      u8"充满着",
      u8"充满著",
      u8"充电",
      u8"充电器",
      u8"充电式",
      u8"充电机",
      u8"充电电池",
      u8"充电电流",
      u8"充电站",
      u8"充畅",
      u8"充盈",
      u8"充盛",
      u8"充磁",
      u8"充箱盈架",
      u8"充类至尽",
      u8"充耳不闻",
      u8"充耳无闻",
      u8"充腹",
      u8"充血",
      u8"充血性",
      u8"充裕",
      u8"充要",
      u8"充要条件",
      u8"充足",
      u8"充足率",
      u8"充门面",
      u8"充闾之庆",
      u8"充阔",
      u8"充阔气",
      u8"充饥",
      u8"充饥画饼",
      u8"兆位",
      u8"兆周",
      u8"兆头",
      u8"兆惠",
      u8"兆欧",
      u8"兆欧表",
      u8"兆欧计",
      u8"兆比特",
      u8"兆瓦",
      u8"兆示",
      u8"兆赫",
      u8"兆赫兹",
      u8"兆载永劫",
      u8"先上",
      u8"先上去",
      u8"先上来",
      u8"先下",
      u8"先下去",
      u8"先下手",
      u8"先下手为强",
      u8"先下来",
      u8"先世",
      u8"先严",
      u8"先为",
      u8"先了",
      u8"先了一步",
      u8"先予",
      u8"先予执行",
      u8"先于",
      u8"先交",
      u8"先享受后付款",
      u8"先享后付",
      u8"先人",
      u8"先人后己",
      u8"先人后已",
      u8"先人着鞭",
      u8"先从",
      u8"先付",
      u8"先令",
      u8"先以",
      u8"先会",
      u8"先住",
      u8"先例",
      u8"先倒",
      u8"先借",
      u8"先兄",
      u8"先兆",
      u8"先入为主",
      u8"先入之见",
      u8"先公",
      u8"先公后私",
      u8"先写",
      u8"先农坛",
      u8"先决",
      u8"先决条件",
      u8"先决问题",
      u8"先减",
      u8"先出",
      u8"先出去",
      u8"先出来",
      u8"先出法",
      u8"先刊",
      u8"先列",
      u8"先别",
      u8"先到",
      u8"先前",
      u8"先剪",
      u8"先务之急",
      u8"先包",
      u8"先占",
      u8"先去",
      u8"先发",
      u8"先发制人",
      u8"先取",
      u8"先史时代",
      u8"先号后庆",
      u8"先号后笑",
      u8"先吃",
      u8"先同",
      u8"先后",
      u8"先后座",
      u8"先后顺序",
      u8"先向",
      u8"先君",
      u8"先听",
      u8"先吸",
      u8"先哭",
      u8"先哲",
      u8"先唱",
      u8"先喝",
      u8"先嚐",
      u8"先回",
      u8"先回到",
      u8"先回去",
      u8"先回来",
      u8"先土后洋",
      u8"先圣",
      u8"先圣先师",
      u8"先在",
      u8"先声",
      u8"先声后实",
      u8"先声夺人",
      u8"先天",
      u8"先天下之忧而忧",
      u8"先天不足",
      u8"先天属性",
      u8"先天性",
      u8"先天性口角小窝",
      u8"先天性涎腺缺失",
      u8"先天性牙龈瘤",
      u8"先天理论",
      u8"先天释放机制",
      u8"先夫",
      u8"先头",
      u8"先头部队",
      u8"先套",
      u8"先奸后杀",
      u8"先妣",
      u8"先存",
      u8"先守",
      u8"先守后攻",
      u8"先宰",
      u8"先容",
      u8"先寄",
      u8"先寇布",
      u8"先富",
      u8"先富起来",
      u8"先导",
      u8"先导性",
      u8"先将",
      u8"先小人后",
      u8"先小人后君子",
      u8"先尝",
      u8"先尝后买",
      u8"先就",
      u8"先师",
      u8"先帝",
      u8"先带",
      u8"先应",
      u8"先府君",
      u8"先延",
      u8"先开",
      u8"先往",
      u8"先征",
      u8"先得",
      u8"先得我心",
      u8"先忧后乐",
      u8"先悉必具",
      u8"先想",
      u8"先意希旨",
      u8"先意承志",
      u8"先意承指",
      u8"先意承旨",
      u8"先意承颜",
      u8"先慈",
      u8"先我着鞭",
      u8"先战",
      u8"先戴",
      u8"先手",
      u8"先手棋",
      u8"先打",
      u8"先找",
      u8"先把",
      u8"先抓",
      u8"先报",
      u8"先抱",
      u8"先抽",
      u8"先拍",
      u8"先拔头筹",
      u8"先按",
      u8"先挑",
      u8"先捡",
      u8"先排",
      u8"先接",
      u8"先提",
      u8"先攻后守",
      u8"先救",
      u8"先教办",
      u8"先敷",
      u8"先斩后奏",
      u8"先斩后闻",
      u8"先断",
      u8"先断后闻",
      u8"先是",
      u8"先有",
      u8"先服",
      u8"先期",
      u8"先期到达",
      u8"先期砾石充填筛管",
      u8"先机",
      u8"先来",
      u8"先来先上",
      u8"先来先下",
      u8"先来后上",
      u8"先来后下",
      u8"先来后到",
      u8"先查",
      u8"先歉",
      u8"先母",
      u8"先民",
      u8"先河",
      u8"先河后海",
      u8"先泡",
      u8"先洗",
      u8"先派",
      u8"先测",
      u8"先演",
      u8"先点",
      u8"先烈",
      u8"先照",
      u8"先父",
      u8"先猜",
      u8"先王",
      u8"先生",
      u8"先生们",
      u8"先用",
      u8"先由",
      u8"先皇",
      u8"先盛后衰",
      u8"先看",
      u8"先睹",
      u8"先睹为快",
      u8"先知",
      u8"先知先觉",
      u8"先知后觉",
      u8"先砍",
      u8"先礼后兵",
      u8"先祖",
      u8"先科",
      u8"先秦",
      u8"先秦散文",
      u8"先秦文学",
      u8"先秦时代",
      u8"先站",
      u8"先端",
      u8"先笑后号",
      u8"先签",
      u8"先纳",
      u8"先给",
      u8"先缝",
      u8"先考",
      u8"先聊",
      u8"先能",
      u8"先自隗始",
      u8"先花后果",
      u8"先苦后甘",
      u8"先苦后甜",
      u8"先行",
      u8"先行一步",
      u8"先行判决",
      u8"先行后闻",
      u8"先行官",
      u8"先行指令站",
      u8"先行算法",
      u8"先行者",
      u8"先裁",
      u8"先要",
      u8"先见",
      u8"先见之明",
      u8"先觉",
      u8"先觉先知",
      u8"先讨",
      u8"先让",
      u8"先让人",
      u8"先记",
      u8"先讲",
      u8"先说",
      u8"先请",
      u8"先读",
      u8"先调",
      u8"先谈",
      u8"先谴队",
      u8"先贤",
      u8"先赢后输",
      u8"先走一步",
      u8"先起来",
      u8"先跑",
      u8"先跳",
      u8"先踩",
      u8"先载",
      u8"先辈",
      u8"先辈遗训",
      u8"先达",
      u8"先过",
      u8"先过去",
      u8"先过来",
      u8"先进",
      u8"先进个人",
      u8"先进事迹",
      u8"先进人物",
      u8"先进先出",
      u8"先进典型",
      u8"先进分子",
      u8"先进单位",
      u8"先进去",
      u8"先进县",
      u8"先进后出",
      u8"先进国家",
      u8"先进岗",
      u8"先进工作者",
      u8"先进思想",
      u8"先进性",
      u8"先进技术",
      u8"先进文化",
      u8"先进方法",
      u8"先进村",
      u8"先进来",
      u8"先进校",
      u8"先进武器",
      u8"先进水平",
      u8"先进生产者",
      u8"先进经验",
      u8"先进设备",
      u8"先进集体",
      u8"先进青年",
      u8"先逛",
      u8"先遣",
      u8"先遣部队",
      u8"先遣队",
      u8"先采",
      u8"先量",
      u8"先钓",
      u8"先销",
      u8"先锋",
      u8"先锋岗",
      u8"先锋模范作用",
      u8"先锋派",
      u8"先锋网",
      u8"先锋论坛",
      u8"先锋队",
      u8"先锋队组织",
      u8"先锋霉素",
      u8"先降",
      u8"先难后获",
      u8"先驰得点",
      u8"先驱",
      u8"先驱报",
      u8"先驱新党",
      u8"先驱者",
      u8"先驱蝼蚁",
      u8"先验",
      u8"先验概率",
      u8"先验论",
      u8"先验论者",
      u8"光上",
      u8"光下",
      u8"光与影",
      u8"光临",
      u8"光临惠顾",
      u8"光临指导",
      u8"光乎乎",
      u8"光了",
      u8"光交联",
      u8"光亮",
      u8"光亮亮",
      u8"光亮剂",
      u8"光亮度",
      u8"光以太",
      u8"光会",
      u8"光体",
      u8"光催化",
      u8"光催化剂",
      u8"光光",
      u8"光光亮亮",
      u8"光光明明",
      u8"光光滑滑",
      u8"光光荣荣",
      u8"光具组",
      u8"光养生物",
      u8"光刻",
      u8"光刻机",
      u8"光刻胶",
      u8"光前启后",
      u8"光前绝后",
      u8"光前裕后",
      u8"光化",
      u8"光化作用",
      u8"光化学",
      u8"光化学过程",
      u8"光华",
      u8"光华夺目",
      u8"光华路",
      u8"光卤石",
      u8"光压",
      u8"光去",
      u8"光反射",
      u8"光反应",
      u8"光受",
      u8"光变态反应",
      u8"光可鉴人",
      u8"光吃",
      u8"光合",
      u8"光合产物",
      u8"光合作用",
      u8"光合强度",
      u8"光合有效辐射",
      u8"光合磷酸化",
      u8"光同化",
      u8"光向",
      u8"光听",
      u8"光吸收",
      u8"光周期",
      u8"光周期现象",
      u8"光呼吸",
      u8"光和",
      u8"光和热",
      u8"光唱",
      u8"光唸",
      u8"光喝",
      u8"光四射",
      u8"光固化",
      u8"光固化复合树脂",
      u8"光固化树脂",
      u8"光固化装置",
      u8"光圈",
      u8"光圈值",
      u8"光在",
      u8"光坦",
      u8"光声光谱学",
      u8"光声拉曼谱学",
      u8"光复",
      u8"光复会",
      u8"光复国土",
      u8"光复国小",
      u8"光复旧物",
      u8"光复活",
      u8"光复节",
      u8"光复路",
      u8"光大",
      u8"光大起来",
      u8"光大银行",
      u8"光天化日",
      u8"光天化日之下",
      u8"光头",
      u8"光头党",
      u8"光子",
      u8"光存储",
      u8"光孝寺",
      u8"光学",
      u8"光学仪器",
      u8"光学图像",
      u8"光学图象处理",
      u8"光学家",
      u8"光学投影曝光法",
      u8"光学断层显微术",
      u8"光学材料",
      u8"光学比较器",
      u8"光学测角计",
      u8"光学玻璃",
      u8"光学系统",
      u8"光学薄膜",
      u8"光学设备",
      u8"光学试验室",
      u8"光学镜片",
      u8"光守",
      u8"光宗",
      u8"光宗耀祖",
      u8"光宠",
      u8"光密介质",
      u8"光密度",
      u8"光密度分析",
      u8"光密度计",
      u8"光导元件",
      u8"光导管",
      u8"光导纤维",
      u8"光屁股",
      u8"光山",
      u8"光山县",
      u8"光州",
      u8"光巴",
      u8"光带",
      u8"光年",
      u8"光度",
      u8"光度学",
      u8"光度法",
      u8"光度表",
      u8"光度计",
      u8"光异构化",
      u8"光强",
      u8"光彩",
      u8"光彩四射",
      u8"光彩夺目",
      u8"光彩溢目",
      u8"光彩炫目",
      u8"光彩照人",
      u8"光彩熠熠",
      u8"光彩耀目",
      u8"光彩耀眼",
      u8"光彩起来",
      u8"光彩陆离",
      u8"光彩霁月",
      u8"光影",
      u8"光得",
      u8"光心",
      u8"光念",
      u8"光怪",
      u8"光怪陆离",
      u8"光想",
      u8"光感受器",
      u8"光慈姑",
      u8"光手",
      u8"光扫描器",
      u8"光拴",
      u8"光排照",
      u8"光掺杂",
      u8"光收",
      u8"光敏",
      u8"光敏剂",
      u8"光敏化",
      u8"光敏感性",
      u8"光数",
      u8"光斑",
      u8"光明",
      u8"光明之路",
      u8"光明前途",
      u8"光明大道",
      u8"光明日报",
      u8"光明正大",
      u8"光明港",
      u8"光明磊落",
      u8"光明网",
      u8"光明面",
      u8"光明顶",
      u8"光是",
      u8"光是在",
      u8"光晕",
      u8"光景",
      u8"光有",
      u8"光机所",
      u8"光机电",
      u8"光杆",
      u8"光杆儿",
      u8"光杆司令",
      u8"光束",
      u8"光杠杆",
      u8"光来",
      u8"光板",
      u8"光板儿",
      u8"光枝勾",
      u8"光枪",
      u8"光柱",
      u8"光栅",
      u8"光栅尺",
      u8"光栅扫描",
      u8"光标",
      u8"光标跟随",
      u8"光标键",
      u8"光核桃",
      u8"光棍",
      u8"光棍儿",
      u8"光棍汉",
      u8"光棍节",
      u8"光武",
      u8"光武帝",
      u8"光气",
      u8"光氧化",
      u8"光污染",
      u8"光油油",
      u8"光泉",
      u8"光波",
      u8"光波炉",
      u8"光波长",
      u8"光泽",
      u8"光泽县",
      u8"光泽度",
      u8"光泽感",
      u8"光泽精",
      u8"光洁",
      u8"光洁度",
      u8"光洋",
      u8"光活化",
      u8"光涌",
      u8"光润",
      u8"光源",
      u8"光源显色性",
      u8"光溜",
      u8"光溜溜",
      u8"光滑",
      u8"光滑性",
      u8"光滑明亮",
      u8"光滑滑",
      u8"光滑簇",
      u8"光滑髓针",
      u8"光漂白",
      u8"光激电离",
      u8"光火",
      u8"光灿",
      u8"光灿夺目",
      u8"光灿灿",
      u8"光热",
      u8"光焰",
      u8"光焰万丈",
      u8"光照",
      u8"光照处理",
      u8"光照度",
      u8"光照强度",
      u8"光照气候系数",
      u8"光照阶段",
      u8"光物理",
      u8"光猜",
      u8"光环",
      u8"光生物学",
      u8"光用",
      u8"光电",
      u8"光电二极管",
      u8"光电位",
      u8"光电倍增管",
      u8"光电催化",
      u8"光电子",
      u8"光电子能谱",
      u8"光电子能谱学",
      u8"光电导效应",
      u8"光电开关",
      u8"光电感烟探测器",
      u8"光电效应",
      u8"光电晶体管",
      u8"光电比色计",
      u8"光电池",
      u8"光电流",
      u8"光电直读光谱计",
      u8"光电管",
      u8"光电钟",
      u8"光电阅读器",
      u8"光电鼠",
      u8"光电鼠标",
      u8"光疗",
      u8"光盘",
      u8"光盘启动",
      u8"光盘库",
      u8"光盘机",
      u8"光盘片",
      u8"光盘版",
      u8"光盘驱动器",
      u8"光着",
      u8"光着头",
      u8"光碎片化",
      u8"光碟",
      u8"光碟世界",
      u8"光碟塔",
      u8"光碟机",
      u8"光碟网",
      u8"光碟读头",
      u8"光神霉素",
      u8"光秃",
      u8"光秃秃",
      u8"光程",
      u8"光端机",
      u8"光笔",
      u8"光符阅读机",
      u8"光系统",
      u8"光緒",
      u8"光纤",
      u8"光纤卡",
      u8"光纤等浮电缆",
      u8"光纤网",
      u8"光纤网络",
      u8"光纤通信",
      u8"光线",
      u8"光线枪",
      u8"光绪",
      u8"光绪帝",
      u8"光绪年间",
      u8"光绪皇帝",
      u8"光缆",
      u8"光网",
      u8"光耀",
      u8"光考",
      u8"光能",
      u8"光能利用率",
      u8"光脆性",
      u8"光脚",
      u8"光膀子",
      u8"光致发光",
      u8"光致变色",
      u8"光致氧化还原",
      u8"光致溶血",
      u8"光致聚合",
      u8"光良",
      u8"光色",
      u8"光色素",
      u8"光艳",
      u8"光艳动人",
      u8"光芒",
      u8"光芒万丈",
      u8"光芒四射",
      u8"光荣",
      u8"光荣义务",
      u8"光荣任务",
      u8"光荣传统",
      u8"光荣席",
      u8"光荣感",
      u8"光荣榜",
      u8"光荣牌",
      u8"光荣牺牲",
      u8"光荣称号",
      u8"光荣花",
      u8"光荣革命",
      u8"光蛋",
      u8"光蝶",
      u8"光行差",
      u8"光补偿点",
      u8"光表",
      u8"光裸",
      u8"光要",
      u8"光视效率",
      u8"光视蛋白",
      u8"光解",
      u8"光解作用",
      u8"光解离",
      u8"光解酶",
      u8"光触媒",
      u8"光记录介质",
      u8"光诱导",
      u8"光说",
      u8"光说不做",
      u8"光说不练",
      u8"光读",
      u8"光谱",
      u8"光谱仪",
      u8"光谱信息",
      u8"光谱分析",
      u8"光谱半定量分析",
      u8"光谱学",
      u8"光谱干扰",
      u8"光谱法",
      u8"光谱测量",
      u8"光谱电化学",
      u8"光谱线",
      u8"光谱色",
      u8"光谷",
      u8"光赤",
      u8"光路图",
      u8"光身汉",
      u8"光车骏马",
      u8"光轮",
      u8"光轴",
      u8"光辉",
      u8"光辉业绩",
      u8"光辉夺目",
      u8"光辉灿烂",
      u8"光辉耀眼",
      u8"光辐射",
      u8"光输",
      u8"光达",
      u8"光过",
      u8"光运动",
      u8"光还原",
      u8"光送",
      u8"光送不卖",
      u8"光通",
      u8"光通信",
      u8"光通量",
      u8"光速",
      u8"光速不变原理",
      u8"光采",
      u8"光重排",
      u8"光量子",
      u8"光锥",
      u8"光闪闪",
      u8"光阑",
      u8"光阴",
      u8"光阴似箭",
      u8"光阴如箭",
      u8"光阴荏苒",
      u8"光降解",
      u8"光降解聚合物",
      u8"光靠",
      u8"光面",
      u8"光顾",
      u8"光预解离",
      u8"光风霁月",
      u8"光风霏月",
      u8"光饼",
      u8"光驱",
      u8"光驱线",
      u8"光鲜",
      u8"光鲜亮丽",
      u8"光黄素",
      u8"克丁克卯",
      u8"克丘亚",
      u8"克东",
      u8"克东县",
      u8"克丝钳子",
      u8"克丽丝",
      u8"克丽缇娜",
      u8"克什克腾旗",
      u8"克什米尔",
      u8"克仑特罗",
      u8"克伐怨欲",
      u8"克传弓冶",
      u8"克伦",
      u8"克伦威尔",
      u8"克俭",
      u8"克俭克勤",
      u8"克兰西",
      u8"克分子",
      u8"克分子浓度",
      u8"克利",
      u8"克利夫",
      u8"克利夫兰",
      u8"克利斯",
      u8"克利福洛",
      u8"克制",
      u8"克制不住",
      u8"克制性",
      u8"克努森效应",
      u8"克劳",
      u8"克劳修斯不等式",
      u8"克劳修斯等式",
      u8"克劳奇",
      u8"克劳德",
      u8"克劳斯",
      u8"克劳琛",
      u8"克勤",
      u8"克勤克俭",
      u8"克卢斯特曼和",
      u8"克原子",
      u8"克嗣良裘",
      u8"克复",
      u8"克嫩",
      u8"克子",
      u8"克孜勒苏",
      u8"克孜勒苏柯尔克孜",
      u8"克孜勒苏柯尔克孜自治州",
      u8"克孜尔",
      u8"克孜族",
      u8"克尔",
      u8"克尔凯郭尔",
      u8"克尔曼",
      u8"克尔盒",
      u8"克尽",
      u8"克尽厥职",
      u8"克尽夫道",
      u8"克尽妇道",
      u8"克尽职守",
      u8"克山",
      u8"克山县",
      u8"克山病",
      u8"克己",
      u8"克己复礼",
      u8"克己奉公",
      u8"克己慎行",
      u8"克已复礼",
      u8"克已奉公",
      u8"克强",
      u8"克当量",
      u8"克恭克顺",
      u8"克扣",
      u8"克拉",
      u8"克拉克",
      u8"克拉克现象",
      u8"克拉别克",
      u8"克拉夫",
      u8"克拉拉",
      u8"克拉拉细胞",
      u8"克拉斯",
      u8"克拉斯诺亚尔斯克",
      u8"克拉特基图",
      u8"克拉玛依",
      u8"克拉玛依区",
      u8"克拉玛依市",
      u8"克拉科夫",
      u8"克拉贝龙方程",
      u8"克拉通",
      u8"克拉马依",
      u8"克敌",
      u8"克敌制胜",
      u8"克数",
      u8"克族",
      u8"克日",
      u8"克星",
      u8"克服",
      u8"克服困难",
      u8"克服缺点",
      u8"克朗",
      u8"克期",
      u8"克来德曼",
      u8"克林斯曼",
      u8"克林特",
      u8"克林顿",
      u8"克格勃",
      u8"克死",
      u8"克氏符号",
      u8"克汀病",
      u8"克洛尼埃斯罗斯",
      u8"克洛德",
      u8"克洛斯",
      u8"克洛泽",
      u8"克爱克威",
      u8"克瑞斯",
      u8"克瑞格",
      u8"克纳普",
      u8"克绍箕裘",
      u8"克罗地亚",
      u8"克罗埃西亚",
      u8"克罗埃西亚共和国",
      u8"克罗夫",
      u8"克罗德",
      u8"克罗扎矫治器",
      u8"克罗斯",
      u8"克罗米",
      u8"克罗蒂亚",
      u8"克罗齐",
      u8"克肩一心",
      u8"克苦耐劳",
      u8"克药",
      u8"克莉丝",
      u8"克莉丝蒂",
      u8"克莉斯",
      u8"克莱",
      u8"克莱儿",
      u8"克莱夫",
      u8"克莱尔",
      u8"克莱德",
      u8"克莱德曼",
      u8"克莱斯",
      u8"克莱斯勒",
      u8"克莱格",
      u8"克莱顿",
      u8"克莱默",
      u8"克薄",
      u8"克虏伯",
      u8"克诺普溶液",
      u8"克逮克容",
      u8"克郎",
      u8"克郎球",
      u8"克里",
      u8"克里克",
      u8"克里夫",
      u8"克里夫兰",
      u8"克里奥",
      u8"克里姆林",
      u8"克里姆林宫",
      u8"克里岛",
      u8"克里希",
      u8"克里斯",
      u8"克里斯丹",
      u8"克里斯坦森现象",
      u8"克里斯蒂",
      u8"克里木",
      u8"克里特",
      u8"克里特克",
      u8"克里特克里岛",
      u8"克里特岛",
      u8"克里米亚",
      u8"克里米亚半岛",
      u8"克里米亚战争",
      u8"克里纳",
      u8"克隆",
      u8"克隆人",
      u8"克隆位点",
      u8"克隆化基因",
      u8"克隆变异",
      u8"克隆变异体",
      u8"克隆多样性",
      u8"克隆扩充",
      u8"克隆技术",
      u8"克隆版",
      u8"克隆牛",
      u8"克隆率",
      u8"克隆病",
      u8"克隆繁殖",
      u8"克隆缺失",
      u8"克隆羊",
      u8"克隆选择",
      u8"克隆选择学说",
      u8"克难",
      u8"克难街",
      u8"克雅",
      u8"克雅氏症",
      u8"克雷伯",
      u8"克雷伯杆菌",
      u8"克雷斯波",
      u8"克雷格",
      u8"克食",
      u8"克鲁",
      u8"克鲁克斯",
      u8"克鲁兹",
      u8"克鲁姆",
      u8"克鲁尼",
      u8"克鲁斯",
      u8"克鲁格",
      u8"克鲁维酵母菌属",
      u8"免不了",
      u8"免不得",
      u8"免与",
      u8"免为其难",
      u8"免了",
      u8"免予",
      u8"免于",
      u8"免交",
      u8"免俗",
      u8"免修",
      u8"免冠",
      u8"免冠照",
      u8"免刑",
      u8"免去",
      u8"免受",
      u8"免复",
      u8"免官",
      u8"免定",
      u8"免开尊口",
      u8"免强",
      u8"免役",
      u8"免征",
      u8"免得",
      u8"免怀之岁",
      u8"免战牌",
      u8"免扰",
      u8"免报",
      u8"免抵退",
      u8"免持",
      u8"免掉",
      u8"免提",
      u8"免提通话",
      u8"免收",
      u8"免料",
      u8"免检",
      u8"免死状",
      u8"免洗",
      u8"免洗餐具",
      u8"免激活",
      u8"免用",
      u8"免疫",
      u8"免疫优势",
      u8"免疫传感器",
      u8"免疫佐剂",
      u8"免疫共凝集",
      u8"免疫共凝集素",
      u8"免疫刺激",
      u8"免疫刺激剂",
      u8"免疫力",
      u8"免疫化学",
      u8"免疫化学发光",
      u8"免疫化学发光分析",
      u8"免疫印",
      u8"免疫原",
      u8"免疫原性",
      u8"免疫反应性",
      u8"免疫反应性蛋白",
      u8"免疫发光",
      u8"免疫吸附",
      u8"免疫吸附剂",
      u8"免疫固定",
      u8"免疫增强",
      u8"免疫增强剂",
      u8"免疫学",
      u8"免疫定位",
      u8"免疫性",
      u8"免疫扩散",
      u8"免疫抑制",
      u8"免疫抑制剂",
      u8"免疫抗体",
      u8"免疫捕捉",
      u8"免疫放射",
      u8"免疫放射分析",
      u8"免疫斑点",
      u8"免疫染色",
      u8"免疫检测",
      u8"免疫毒素",
      u8"免疫沉淀",
      u8"免疫沉淀物",
      u8"免疫沉淀素",
      u8"免疫治疗",
      u8"免疫测定",
      u8"免疫球蛋白",
      u8"免疫生物学",
      u8"免疫电泳",
      u8"免疫电镜术",
      u8"免疫病",
      u8"免疫病理",
      u8"免疫病理学",
      u8"免疫监视",
      u8"免疫筛选",
      u8"免疫粘附素",
      u8"免疫系统",
      u8"免疫组化",
      u8"免疫组织化学",
      u8"免疫细胞化学",
      u8"免疫缺损",
      u8"免疫耐受",
      u8"免疫耗竭",
      u8"免疫能力",
      u8"免疫脂质体",
      u8"免疫荧光",
      u8"免疫药物学",
      u8"免疫血清",
      u8"免疫诊断",
      u8"免疫调制剂",
      u8"免疫调制蛋白",
      u8"免疫调节",
      u8"免疫调节剂",
      u8"免疫选择",
      u8"免疫针",
      u8"免疫铁蛋白技术",
      u8"免疫预防",
      u8"免礼",
      u8"免票",
      u8"免票入场",
      u8"免税",
      u8"免税单",
      u8"免税品",
      u8"免税商店",
      u8"免税店",
      u8"免税车",
      u8"免纳",
      u8"免罚",
      u8"免罪",
      u8"免职",
      u8"免蜡",
      u8"免订",
      u8"免证",
      u8"免诉权",
      u8"免试",
      u8"免试生",
      u8"免课",
      u8"免调",
      u8"免谈",
      u8"免责",
      u8"免责权",
      u8"免贴",
      u8"免费",
      u8"免费中文",
      u8"免费书",
      u8"免费信箱",
      u8"免费入场",
      u8"免费刷",
      u8"免费动画",
      u8"免费参观",
      u8"免费发",
      u8"免费同志",
      u8"免费听",
      u8"免费大餐",
      u8"免费小说",
      u8"免费影视",
      u8"免费影院",
      u8"免费性",
      u8"免费成人",
      u8"免费手机",
      u8"免费打",
      u8"免费搭车",
      u8"免费模板",
      u8"免费漫画",
      u8"免费激情",
      u8"免费片",
      u8"免费版",
      u8"免费电",
      u8"免费电影",
      u8"免费相册",
      u8"免费网",
      u8"免费色",
      u8"免费视听",
      u8"免费视频",
      u8"免费论文",
      u8"免费资源",
      u8"免费赠品",
      u8"免费软件",
      u8"免费送",
      u8"免费邮件",
      u8"免费邮箱",
      u8"免费音乐",
      u8"免蹈覆辙",
      u8"免还",
      u8"免进",
      u8"免遭",
      u8"免遭物议",
      u8"免除",
      u8"免除混乱",
      u8"免验",
      u8"免验证",
      u8"免骚扰",
      u8"兑付",
      u8"兑制",
      u8"兑卦",
      u8"兑取",
      u8"兑坊",
      u8"兑奖",
      u8"兑帐",
      u8"兑换",
      u8"兑换券",
      u8"兑换处",
      u8"兑换率",
      u8"兑款",
      u8"兑现",
      u8"兑端",
      u8"兑领",
      u8"兔丝燕麦",
      u8"兔仔",
      u8"兔儿",
      u8"兔儿爷",
      u8"兔八哥",
      u8"兔唇",
      u8"兔头麞脑",
      u8"兔女郎",
      u8"兔妹妹",
      u8"兔子",
      u8"兔子不吃窝边草",
      u8"兔子尾巴长不了",
      u8"兔崽子",
      u8"兔年",
      u8"兔死凫举",
      u8"兔死狐悲",
      u8"兔死狗烹",
      u8"兔毛",
      u8"兔毫",
      u8"兔皮",
      u8"兔肉",
      u8"兔脚",
      u8"兔脣",
      u8"兔脱",
      u8"兔葵燕麦",
      u8"兔角牛翼",
      u8"兔角龟毛",
      u8"兔走乌飞",
      u8"兔走鹘落",
      u8"兔起乌沉",
      u8"兔起凫举",
      u8"兔起鹘落",
      u8"兖州",
      u8"兖州县",
      u8"兖州市",
      u8"兖矿",
      u8"党中央",
      u8"党主席",
      u8"党义",
      u8"党争",
      u8"党人",
      u8"党代会",
      u8"党代表",
      u8"党代表大会",
      u8"党八股",
      u8"党内",
      u8"党内人士",
      u8"党内外",
      u8"党内斗争",
      u8"党军",
      u8"党刊",
      u8"党办",
      u8"党务",
      u8"党务工作",
      u8"党卫军",
      u8"党卫队",
      u8"党参",
      u8"党友",
      u8"党史",
      u8"党同伐异",
      u8"党同妒异",
      u8"党名",
      u8"党员",
      u8"党员个人",
      u8"党员大会",
      u8"党员干部",
      u8"党员意识",
      u8"党员秤",
      u8"党员素质",
      u8"党员证",
      u8"党员队伍",
      u8"党和人民",
      u8"党和国家",
      u8"党和国家领导人",
      u8"党和政府",
      u8"党团",
      u8"党团员",
      u8"党团活动",
      u8"党团组织",
      u8"党国",
      u8"党国元老",
      u8"党坚势盛",
      u8"党外",
      u8"党外人士",
      u8"党委",
      u8"党委书记",
      u8"党委会",
      u8"党委制",
      u8"党委委员",
      u8"党委政府",
      u8"党小组",
      u8"党小组长",
      u8"党工",
      u8"党工委",
      u8"党建",
      u8"党建网",
      u8"党徒",
      u8"党徽",
      u8"党心",
      u8"党性",
      u8"党性修养",
      u8"党性原则",
      u8"党总支",
      u8"党恶佑奸",
      u8"党执政",
      u8"党报",
      u8"党支部",
      u8"党支部书记",
      u8"党政",
      u8"党政不分",
      u8"党政军",
      u8"党政军民",
      u8"党政军民学",
      u8"党政工",
      u8"党政干部",
      u8"党政机关",
      u8"党政纪",
      u8"党政群",
      u8"党政部门",
      u8"党政领导",
      u8"党政领导干部",
      u8"党政领导机关",
      u8"党旗",
      u8"党晋阳",
      u8"党校",
      u8"党格",
      u8"党棍",
      u8"党歌",
      u8"党法",
      u8"党派",
      u8"党的基本",
      u8"党的基本路线",
      u8"党的建设",
      u8"党的性质",
      u8"党的政策",
      u8"党的方针",
      u8"党的纪律",
      u8"党的纲领",
      u8"党的路线",
      u8"党的路线方针政策",
      u8"党的领导",
      u8"党票",
      u8"党祸",
      u8"党禁",
      u8"党章",
      u8"党籍",
      u8"党纪",
      u8"党纪国法",
      u8"党纪处分",
      u8"党纪政纪",
      u8"党纲",
      u8"党组",
      u8"党组书记",
      u8"党组会",
      u8"党组织",
      u8"党群",
      u8"党群关系",
      u8"党群干群",
      u8"党羽",
      u8"党职",
      u8"党营",
      u8"党规",
      u8"党言",
      u8"党证",
      u8"党课",
      u8"党豺为虐",
      u8"党费",
      u8"党邪丑正",
      u8"党邪陷正",
      u8"党部",
      u8"党锢",
      u8"党阀",
      u8"党际",
      u8"党鞭",
      u8"党领导",
      u8"党风",
      u8"党风不正",
      u8"党风好转",
      u8"党风廉政",
      u8"党风廉政建设",
      u8"党风建设",
      u8"党首",
      u8"党魁",
      u8"党魂",
      u8"党龄",
      u8"兜住",
      u8"兜儿",
      u8"兜兜",
      u8"兜兜裤儿",
      u8"兜兜风",
      u8"兜兰",
      u8"兜剿",
      u8"兜售",
      u8"兜圈",
      u8"兜圈子",
      u8"兜头盖脸",
      u8"兜子",
      u8"兜帽",
      u8"兜底",
      u8"兜抄",
      u8"兜捕",
      u8"兜揽",
      u8"兜揽生意",
      u8"兜游",
      u8"兜率",
      u8"兜率天",
      u8"兜生意",
      u8"兜着",
      u8"兜着走",
      u8"兜翻",
      u8"兜老底",
      u8"兜肚",
      u8"兜肚连肠",
      u8"兜里",
      u8"兜鍪",
      u8"兜销",
      u8"兜风",
      u8"兢兢业业",
      u8"兢兢乾乾",
      u8"兢兢干干",
      u8"兢兢战战",
      u8"兢兢翼翼",
      u8"入不敷出",
      u8"入不敷支",
      u8"入世",
      u8"入世未深",
      u8"入主",
      u8"入主中原",
      u8"入主出奴",
      u8"入乡问俗",
      u8"入乡随乡",
      u8"入乡随俗",
      u8"入了",
      u8"入云龙",
      u8"入五",
      u8"入井望天",
      u8"入产",
      u8"入仓",
      u8"入伍",
      u8"入伍通知",
      u8"入伍须知",
      u8"入伏",
      u8"入伙",
      u8"入会",
      u8"入会者",
      u8"入会费",
      u8"入住",
      u8"入住率",
      u8"入侵",
      u8"入侵者",
      u8"入党",
      u8"入关",
      u8"入内",
      u8"入册",
      u8"入冬",
      u8"入出境",
      u8"入列",
      u8"入厕",
      u8"入厨",
      u8"入口",
      u8"入口处",
      u8"入口税",
      u8"入口站",
      u8"入口通道",
      u8"入吾彀中",
      u8"入味",
      u8"入团",
      u8"入围",
      u8"入国问俗",
      u8"入国问禁",
      u8"入土",
      u8"入土为安",
      u8"入圣超凡",
      u8"入地无门",
      u8"入场",
      u8"入场券",
      u8"入场式",
      u8"入场证",
      u8"入场费",
      u8"入坞",
      u8"入城",
      u8"入境",
      u8"入境处",
      u8"入境手续",
      u8"入境案",
      u8"入境游",
      u8"入境签证",
      u8"入境者",
      u8"入境证",
      u8"入境问俗",
      u8"入境问禁",
      u8"入境随俗",
      u8"入声",
      u8"入夏",
      u8"入夜",
      u8"入夜后",
      u8"入夥",
      u8"入套",
      u8"入孝出弟",
      u8"入孝出悌",
      u8"入学",
      u8"入学年龄",
      u8"入学校",
      u8"入学率",
      u8"入学考试",
      u8"入官",
      u8"入定",
      u8"入宝山而空回",
      u8"入室",
      u8"入室升堂",
      u8"入室弟子",
      u8"入室操戈",
      u8"入室昇堂",
      u8"入寇",
      u8"入寐",
      u8"入射",
      u8"入射光",
      u8"入射光瞳",
      u8"入射波",
      u8"入射点",
      u8"入射窗",
      u8"入射线",
      u8"入射角",
      u8"入市",
      u8"入帐",
      u8"入席",
      u8"入幕之宾",
      u8"入库",
      u8"入店",
      u8"入座",
      u8"入彀",
      u8"入役",
      u8"入微",
      u8"入怀",
      u8"入情入理",
      u8"入户",
      u8"入户门",
      u8"入手",
      u8"入托",
      u8"入教",
      u8"入文出武",
      u8"入时",
      u8"入春",
      u8"入暮",
      u8"入木三分",
      u8"入村",
      u8"入档",
      u8"入梅",
      u8"入梦",
      u8"入棺",
      u8"入款",
      u8"入死出生",
      u8"入殓",
      u8"入气室",
      u8"入水",
      u8"入水管",
      u8"入流",
      u8"入海",
      u8"入海口",
      u8"入海流",
      u8"入海算沙",
      u8"入渗",
      u8"入港",
      u8"入港税",
      u8"入火赴汤",
      u8"入狱",
      u8"入球",
      u8"入球数",
      u8"入理",
      u8"入理切情",
      u8"入画",
      u8"入监",
      u8"入盟",
      u8"入直",
      u8"入眠",
      u8"入眼",
      u8"入睡",
      u8"入社",
      u8"入神",
      u8"入禀",
      u8"入秋",
      u8"入窖",
      u8"入竟问禁",
      u8"入籍",
      u8"入级检验",
      u8"入编",
      u8"入网",
      u8"入网费",
      u8"入耳",
      u8"入耳式",
      u8"入股",
      u8"入药",
      u8"入营",
      u8"入行",
      u8"入贡",
      u8"入账",
      u8"入货",
      u8"入赘",
      u8"入超",
      u8"入超国",
      u8"入迷",
      u8"入选",
      u8"入选为",
      u8"入道",
      u8"入邦问俗",
      u8"入邪",
      u8"入铁主簿",
      u8"入锅",
      u8"入门",
      u8"入门教程",
      u8"入门篇",
      u8"入门级",
      u8"入门问讳",
      u8"入阁",
      u8"入阁登坛",
      u8"入队",
      u8"入院",
      u8"入静",
      u8"入骨",
      u8"入骨相思",
      u8"入魔",
      u8"全三册",
      u8"全三卷",
      u8"全下",
      u8"全不",
      u8"全不会",
      u8"全不变子群",
      u8"全不是",
      u8"全不知",
      u8"全不能",
      u8"全不连通图",
      u8"全世界",
      u8"全世界人民",
      u8"全中国",
      u8"全中国人民",
      u8"全中文",
      u8"全为",
      u8"全乎",
      u8"全乡",
      u8"全书",
      u8"全乾",
      u8"全人",
      u8"全人类",
      u8"全仗绿叶扶持",
      u8"全价",
      u8"全份",
      u8"全休",
      u8"全优",
      u8"全会",
      u8"全会精神",
      u8"全传",
      u8"全体",
      u8"全体一致",
      u8"全体人员",
      u8"全体人民",
      u8"全体会议",
      u8"全体出席",
      u8"全体利益",
      u8"全体同仁",
      u8"全体同学",
      u8"全体学生",
      u8"全体官兵",
      u8"全体师生",
      u8"全体干警",
      u8"全体成员",
      u8"全信",
      u8"全信书不如无书",
      u8"全信息对策",
      u8"全倒",
      u8"全值",
      u8"全像",
      u8"全光烈",
      u8"全免",
      u8"全免费",
      u8"全党",
      u8"全党全军",
      u8"全党全军全国",
      u8"全党全军和全国",
      u8"全党全国",
      u8"全党全国人民",
      u8"全党全国全军",
      u8"全党同志",
      u8"全党外",
      u8"全兴",
      u8"全兴队",
      u8"全内置",
      u8"全军",
      u8"全军尽墨",
      u8"全军覆没",
      u8"全军覆灭",
      u8"全冠",
      u8"全冠清",
      u8"全减器",
      u8"全凭",
      u8"全出",
      u8"全出去",
      u8"全出来",
      u8"全分歧扩张",
      u8"全分音符",
      u8"全到",
      u8"全剧",
      u8"全副",
      u8"全副武装",
      u8"全副精力",
      u8"全力",
      u8"全力以赴",
      u8"全力支持",
      u8"全功尽弃",
      u8"全功略",
      u8"全功能",
      u8"全加器",
      u8"全劳动力",
      u8"全勋",
      u8"全勤",
      u8"全勤奖",
      u8"全勤奖金",
      u8"全包价",
      u8"全区",
      u8"全南",
      u8"全南县",
      u8"全厂",
      u8"全厚瓣",
      u8"全去",
      u8"全县",
      u8"全双工",
      u8"全反射",
      u8"全受全归",
      u8"全口义齿",
      u8"全口义齿修复学",
      u8"全台",
      u8"全台湾",
      u8"全同粒子",
      u8"全名",
      u8"全名单",
      u8"全名是",
      u8"全向",
      u8"全向天线",
      u8"全向式无线电航空信标",
      u8"全员",
      u8"全员劳动合同制",
      u8"全员劳动生产率",
      u8"全员承包",
      u8"全员聘用",
      u8"全员聘用合同制",
      u8"全周",
      u8"全唐诗",
      u8"全四册",
      u8"全四卷",
      u8"全因",
      u8"全团",
      u8"全固态",
      u8"全国",
      u8"全国一盘棋",
      u8"全国三八红旗手",
      u8"全国上下",
      u8"全国上下一盘棋",
      u8"全国五一劳动奖章",
      u8"全国人",
      u8"全国人大",
      u8"全国人大代表",
      u8"全国人大内务司法委员会",
      u8"全国人大华侨委员会",
      u8"全国人大外事委员会",
      u8"全国人大常委会",
      u8"全国人大常委会副委员长",
      u8"全国人大常委会委员长",
      u8"全国人大民族委员会",
      u8"全国人大法律委员会",
      u8"全国人大财政经济委员会",
      u8"全国人民",
      u8"全国人民代表大会",
      u8"全国代表大会",
      u8"全国会计",
      u8"全国公安",
      u8"全国冠军",
      u8"全国劳动模范",
      u8"全国劳模",
      u8"全国十佳",
      u8"全国卷",
      u8"全国各地",
      u8"全国各族人民",
      u8"全国同胞",
      u8"全国妇女联合会",
      u8"全国妇联",
      u8"全国委员会",
      u8"全国工商业联合会",
      u8"全国工商联",
      u8"全国性",
      u8"全国总工会",
      u8"全国政协",
      u8"全国政协主席",
      u8"全国政协副主席",
      u8"全国纪录",
      u8"全国联网",
      u8"全国范围",
      u8"全国记录",
      u8"全国运动",
      u8"全国运动会",
      u8"全国重点",
      u8"全国铁路",
      u8"全国青",
      u8"全国高校",
      u8"全地区",
      u8"全场",
      u8"全场欢呼",
      u8"全垒打",
      u8"全城",
      u8"全域",
      u8"全境",
      u8"全外置",
      u8"全多孔型填充剂",
      u8"全天",
      u8"全天候",
      u8"全天性",
      u8"全套",
      u8"全套教材",
      u8"全套设备",
      u8"全好",
      u8"全始全终",
      u8"全委",
      u8"全委会",
      u8"全宇宙",
      u8"全宋词",
      u8"全家",
      u8"全家乐",
      u8"全家人",
      u8"全家电",
      u8"全家福",
      u8"全家老小",
      u8"全密封",
      u8"全对",
      u8"全对数",
      u8"全寿命费用",
      u8"全封闭",
      u8"全封闭式",
      u8"全局",
      u8"全局变量",
      u8"全局存储器",
      u8"全局性",
      u8"全局查询优化",
      u8"全局知识",
      u8"全局观念",
      u8"全屏",
      u8"全屏幕",
      u8"全屏播放",
      u8"全州",
      u8"全州县",
      u8"全市",
      u8"全师",
      u8"全师官兵",
      u8"全干扰",
      u8"全年",
      u8"全年候",
      u8"全年收入",
      u8"全年雨量",
      u8"全年龄",
      u8"全度妍",
      u8"全开",
      u8"全异",
      u8"全强盗",
      u8"全归",
      u8"全当",
      u8"全形",
      u8"全彩",
      u8"全彩屏",
      u8"全心",
      u8"全心全意",
      u8"全心全意为人民服务",
      u8"全心投入",
      u8"全总",
      u8"全息",
      u8"全息图",
      u8"全息存储器",
      u8"全息术",
      u8"全息照相",
      u8"全息疗法",
      u8"全意",
      u8"全慧彬",
      u8"全或无",
      u8"全或无学习",
      u8"全或无定律",
      u8"全所",
      u8"全所同仁",
      u8"全手动",
      u8"全手工",
      u8"全才",
      u8"全打",
      u8"全托",
      u8"全拼",
      u8"全拼形",
      u8"全拼形导码",
      u8"全拼形导码计算机汉字输入方法",
      u8"全拼输入法",
      u8"全接触",
      u8"全揭密",
      u8"全收录",
      u8"全攻",
      u8"全攻略",
      u8"全散",
      u8"全数",
      u8"全文",
      u8"全文如下",
      u8"全文完",
      u8"全文索引",
      u8"全文逛逛",
      u8"全新",
      u8"全方位",
      u8"全方面",
      u8"全无",
      u8"全无心肝",
      u8"全无是处",
      u8"全日",
      u8"全日制",
      u8"全日制托儿所",
      u8"全日空",
      u8"全明星",
      u8"全明星赛",
      u8"全是",
      u8"全是真话",
      u8"全景",
      u8"全景图",
      u8"全景式",
      u8"全景电影",
      u8"全景电影院",
      u8"全景网",
      u8"全景网络",
      u8"全智全能",
      u8"全智能",
      u8"全智贤",
      u8"全曲",
      u8"全月",
      u8"全有",
      u8"全木质",
      u8"全本",
      u8"全权",
      u8"全权代表",
      u8"全权处理",
      u8"全权大使",
      u8"全权负责",
      u8"全材",
      u8"全村",
      u8"全村人",
      u8"全校",
      u8"全校同学",
      u8"全校学生",
      u8"全校师生",
      u8"全根",
      u8"全案",
      u8"全椒",
      u8"全椒县",
      u8"全款",
      u8"全武将",
      u8"全歼",
      u8"全段",
      u8"全毛",
      u8"全毛料",
      u8"全民",
      u8"全民企业",
      u8"全民公决",
      u8"全民动手",
      u8"全民忌惮",
      u8"全民性",
      u8"全民所有",
      u8"全民所有制",
      u8"全民投票",
      u8"全民政治",
      u8"全民教育",
      u8"全民族",
      u8"全民皆兵",
      u8"全民运动",
      u8"全流通",
      u8"全消",
      u8"全消耗型燃烧器",
      u8"全液压",
      u8"全港",
      u8"全灭",
      u8"全热换热器",
      u8"全然",
      u8"全然不同",
      u8"全然不知",
      u8"全然不觉",
      u8"全然不解",
      u8"全然不顾",
      u8"全片",
      u8"全班",
      u8"全班人马",
      u8"全班同学",
      u8"全班学生",
      u8"全球",
      u8"全球中文",
      u8"全球化",
      u8"全球华人",
      u8"全球华语",
      u8"全球卫星",
      u8"全球卫星定位系统",
      u8"全球呼",
      u8"全球商务",
      u8"全球定位系统",
      u8"全球性",
      u8"全球性海面升降",
      u8"全球战略",
      u8"全球排名",
      u8"全球气候变暖",
      u8"全球电信",
      u8"全球经济",
      u8"全球股市",
      u8"全球通",
      u8"全球通预付费",
      u8"全璧归赵",
      u8"全生育期",
      u8"全由",
      u8"全留",
      u8"全略微分重叠法",
      u8"全盔",
      u8"全盘",
      u8"全盘否定",
      u8"全盘托出",
      u8"全盘接受",
      u8"全盘皆活",
      u8"全盘皆输",
      u8"全盘考虑",
      u8"全盘西化",
      u8"全盛",
      u8"全盛时期",
      u8"全盛期",
      u8"全盟",
      u8"全相联映射",
      u8"全相联高速缓存",
      u8"全省",
      u8"全省各地",
      u8"全看",
      u8"全真",
      u8"全真教",
      u8"全真道",
      u8"全瞎",
      u8"全知全能",
      u8"全知天下事",
      u8"全矿",
      u8"全码",
      u8"全社",
      u8"全社会",
      u8"全神",
      u8"全神倾注",
      u8"全神关注",
      u8"全神贯注",
      u8"全票",
      u8"全票价",
      u8"全福",
      u8"全称",
      u8"全程",
      u8"全程参加",
      u8"全程无",
      u8"全稿",
      u8"全空间",
      u8"全立交",
      u8"全站",
      u8"全站仪",
      u8"全等",
      u8"全等变换",
      u8"全等变换群",
      u8"全等号",
      u8"全等形",
      u8"全篇",
      u8"全篇文章",
      u8"全系列",
      u8"全系统",
      u8"全纪录",
      u8"全纯包",
      u8"全线",
      u8"全线产品",
      u8"全线作战",
      u8"全线出击",
      u8"全线崩溃",
      u8"全线贯通",
      u8"全线进攻",
      u8"全线通车",
      u8"全组",
      u8"全细胞式",
      u8"全网",
      u8"全美",
      u8"全美国",
      u8"全美达",
      u8"全考",
      u8"全职",
      u8"全聚德",
      u8"全胜",
      u8"全胜记录",
      u8"全能",
      u8"全能全智",
      u8"全能冠军",
      u8"全能型",
      u8"全能性",
      u8"全能王",
      u8"全能运动",
      u8"全能运动员",
      u8"全能量系统",
      u8"全脂",
      u8"全脂奶粉",
      u8"全脱产",
      u8"全脱机",
      u8"全自动",
      u8"全般",
      u8"全般支援",
      u8"全色",
      u8"全色片",
      u8"全色盲者",
      u8"全苗",
      u8"全英文",
      u8"全蚀",
      u8"全蝎",
      u8"全行",
      u8"全衡",
      u8"全裸",
      u8"全裸体",
      u8"全裸图",
      u8"全裸照",
      u8"全要",
      u8"全角",
      u8"全角字",
      u8"全记录",
      u8"全译本",
      u8"全豹",
      u8"全貌",
      u8"全责",
      u8"全资",
      u8"全距离",
      u8"全路",
      u8"全路通信信号研究设计院",
      u8"全身",
      u8"全身上下",
      u8"全身像",
      u8"全身心",
      u8"全身性",
      u8"全身检查",
      u8"全身而退",
      u8"全身远害",
      u8"全车",
      u8"全输",
      u8"全过",
      u8"全过程",
      u8"全运会",
      u8"全选",
      u8"全透明",
      u8"全通网络",
      u8"全逝去",
      u8"全速",
      u8"全速前进",
      u8"全速行进",
      u8"全速进行",
      u8"全部",
      u8"全部会",
      u8"全部保险费",
      u8"全部内容",
      u8"全部是",
      u8"全部有",
      u8"全部歌手",
      u8"全部歌曲",
      u8"全部都",
      u8"全部都是",
      u8"全都",
      u8"全都会",
      u8"全都是",
      u8"全都有",
      u8"全酶",
      u8"全金发",
      u8"全金属",
      u8"全错",
      u8"全镇",
      u8"全长",
      u8"全长约",
      u8"全队",
      u8"全防",
      u8"全阴天天空",
      u8"全院",
      u8"全院干警",
      u8"全险",
      u8"全集",
      u8"全靠",
      u8"全面",
      u8"全面发展",
      u8"全面完成",
      u8"全面实施",
      u8"全面实现",
      u8"全面性",
      u8"全面战争",
      u8"全面推广",
      u8"全面推行",
      u8"全面提高",
      u8"全面禁止",
      u8"全面禁止和彻底销毁核武器",
      u8"全面继承",
      u8"全面落实",
      u8"全面规划",
      u8"全面解决",
      u8"全面质量管理",
      u8"全面进步",
      u8"全面进行",
      u8"全面铺开",
      u8"全音",
      u8"全音符",
      u8"全项",
      u8"全顺",
      u8"全颌种植体",
      u8"全频",
      u8"全频段",
      u8"全额",
      u8"全额奖学金",
      u8"全额奖金",
      u8"全食",
      u8"全馆",
      u8"全麻",
      u8"八一",
      u8"八一七中路",
      u8"八一七北路",
      u8"八一七南路",
      u8"八一七路",
      u8"八一南昌起义",
      u8"八一建军节",
      u8"八一镇",
      u8"八一队",
      u8"八七水灾",
      u8"八万",
      u8"八万四千",
      u8"八下",
      u8"八世",
      u8"八世纪",
      u8"八两",
      u8"八个",
      u8"八中",
      u8"八中全会",
      u8"八九",
      u8"八九不离十",
      u8"八九个",
      u8"八九岁",
      u8"八九年",
      u8"八五",
      u8"八五折",
      u8"八五攻关计划",
      u8"八五攻关项目",
      u8"八五期间",
      u8"八五规划",
      u8"八五计划",
      u8"八亿",
      u8"八仙",
      u8"八仙桌",
      u8"八仙洞",
      u8"八仙花",
      u8"八仙过海",
      u8"八仙过海各显其能",
      u8"八仙过海各显神通",
      u8"八份",
      u8"八会穴",
      u8"八位",
      u8"八位位组",
      u8"八位字节",
      u8"八位数",
      u8"八佰伴",
      u8"八克",
      u8"八八六十四",
      u8"八公山上",
      u8"八公山上草木皆兵",
      u8"八公山区",
      u8"八关",
      u8"八具",
      u8"八分",
      u8"八分九裂",
      u8"八分斋",
      u8"八分熟",
      u8"八分钟",
      u8"八分音符",
      u8"八分饱",
      u8"八包",
      u8"八区",
      u8"八十",
      u8"八十一",
      u8"八十七",
      u8"八十万",
      u8"八十三",
      u8"八十九",
      u8"八十二",
      u8"八十五",
      u8"八十八",
      u8"八十六",
      u8"八十四",
      u8"八十岁学鼓手",
      u8"八十年代",
      u8"八千",
      u8"八千万",
      u8"八千里路云和月",
      u8"八卦",
      u8"八卦丹",
      u8"八卦图",
      u8"八卦山",
      u8"八卦岭",
      u8"八卦拳",
      u8"八卦掌",
      u8"八卦教",
      u8"八卦新闻",
      u8"八卦阵",
      u8"八厂",
      u8"八厘麻",
      u8"八句",
      u8"八只",
      u8"八台",
      u8"八号",
      u8"八号分机",
      u8"八周",
      u8"八周年",
      u8"八哥",
      u8"八哥儿",
      u8"八喜",
      u8"八国",
      u8"八国联军",
      u8"八圈",
      u8"八场",
      u8"八块",
      u8"八块钱",
      u8"八堵",
      u8"八夜",
      u8"八大",
      u8"八大山人",
      u8"八大胡同",
      u8"八大菜系",
      u8"八天",
      u8"八字",
      u8"八字宪法",
      u8"八字打开",
      u8"八字步",
      u8"八字没一撇",
      u8"八字没见一撇",
      u8"八字眉",
      u8"八字胡",
      u8"八字脚",
      u8"八字贴",
      u8"八字贴儿",
      u8"八字还没有一撇",
      u8"八季",
      u8"八宝",
      u8"八宝山",
      u8"八宝箱",
      u8"八宝粥",
      u8"八宝菜",
      u8"八宝饭",
      u8"八客",
      u8"八家",
      u8"八宿",
      u8"八宿县",
      u8"八封",
      u8"八小",
      u8"八小时",
      u8"八小时工作制",
      u8"八尺",
      u8"八局",
      u8"八层",
      u8"八层楼",
      u8"八届",
      u8"八岁",
      u8"八岁时",
      u8"八带鱼",
      u8"八席",
      u8"八平柴",
      u8"八年",
      u8"八年级",
      u8"八府巡按",
      u8"八度",
      u8"八廓街",
      u8"八开",
      u8"八开本",
      u8"八张",
      u8"八强",
      u8"八强战",
      u8"八强赛",
      u8"八德",
      u8"八思巴",
      u8"八成",
      u8"八成新",
      u8"八戒",
      u8"八截",
      u8"八户",
      u8"八扇",
      u8"八打",
      u8"八折",
      u8"八抬大轿",
      u8"八拐",
      u8"八拜",
      u8"八拜之交",
      u8"八拳",
      u8"八拿马",
      u8"八拿马运河",
      u8"八掌溪",
      u8"八支",
      u8"八斗之才",
      u8"八斗子",
      u8"八斗才",
      u8"八斤",
      u8"八斤重",
      u8"八方",
      u8"八方之外",
      u8"八方呼应",
      u8"八方客",
      u8"八方支持",
      u8"八方支援",
      u8"八方来客",
      u8"八方资源",
      u8"八方风雨",
      u8"八旗",
      u8"八旗子弟",
      u8"八日",
      u8"八日上午",
      u8"八日下午",
      u8"八日晚上",
      u8"八日游",
      u8"八旬",
      u8"八时",
      u8"八晚",
      u8"八景",
      u8"八月",
      u8"八月份",
      u8"八月八",
      u8"八月节",
      u8"八期",
      u8"八木佑",
      u8"八木天线",
      u8"八朵",
      u8"八条",
      u8"八杯酒",
      u8"八极拳",
      u8"八枝",
      u8"八格",
      u8"八桂",
      u8"八桶",
      u8"八棵",
      u8"八楼",
      u8"八次",
      u8"八歌",
      u8"八步",
      u8"八步区",
      u8"八段",
      u8"八段锦",
      u8"八渡",
      u8"八点",
      u8"八点党",
      u8"八点半",
      u8"八点档",
      u8"八点钟",
      u8"八爷",
      u8"八版",
      u8"八王坟",
      u8"八珍",
      u8"八珍玉食",
      u8"八班",
      u8"八百",
      u8"八百万",
      u8"八百壮士",
      u8"八百孤寒",
      u8"八百当",
      u8"八盒",
      u8"八目妖",
      u8"八目鳗",
      u8"八碗",
      u8"八神",
      u8"八神庵",
      u8"八科",
      u8"八秒",
      u8"八秒钟",
      u8"八稚女",
      u8"八窗玲珑",
      u8"八站",
      u8"八章",
      u8"八竿子打不着",
      u8"八筒",
      u8"八类",
      u8"八粒",
      u8"八级",
      u8"八级工资制",
      u8"八纮同轨",
      u8"八线",
      u8"八罐",
      u8"八股",
      u8"八股文",
      u8"八脚",
      u8"八节",
      u8"八花九裂",
      u8"八荒",
      u8"八荒之外",
      u8"八荣八",
      u8"八荣八耻",
      u8"八营",
      u8"八行书",
      u8"八街",
      u8"八街九陌",
      u8"八角",
      u8"八角亭",
      u8"八角形",
      u8"八角枫",
      u8"八角茴香",
      u8"八角茴香油",
      u8"八角街",
      u8"八角钱",
      u8"八课",
      u8"八路",
      u8"八路军",
      u8"八辈子",
      u8"八边",
      u8"八边形",
      u8"八达岭",
      u8"八达通",
      u8"八运",
      u8"八运会",
      u8"八进位",
      u8"八进制",
      u8"八连",
      u8"八通",
      u8"八通关",
      u8"八通网",
      u8"八遍",
      u8"八道江区",
      u8"八邪",
      u8"八部",
      u8"八酒杯",
      u8"八里",
      u8"八里乡",
      u8"八里庄",
      u8"八里沟",
      u8"八钱",
      u8"八门",
      u8"八闽",
      u8"八阵图",
      u8"八难三灾",
      u8"八集",
      u8"八面",
      u8"八面光",
      u8"八面受敌",
      u8"八面圆通",
      u8"八面威风",
      u8"八面张罗",
      u8"八面来风",
      u8"八面玲珑",
      u8"八面莹澈",
      u8"八面见光",
      u8"八面锋",
      u8"八面风",
      u8"八面驶风",
      u8"八音",
      u8"八音匣子",
      u8"八音盒",
      u8"八音节",
      u8"八音迭奏",
      u8"八音遏密",
      u8"八页",
      u8"八项注意",
      u8"八颗",
      u8"八风",
      u8"八首",
      u8"八首歌",
      u8"八骏图",
      u8"公丈",
      u8"公两",
      u8"公主",
      u8"公主坟",
      u8"公主岭",
      u8"公主岭市",
      u8"公举",
      u8"公义",
      u8"公之于世",
      u8"公之于众",
      u8"公买公卖",
      u8"公了",
      u8"公事",
      u8"公事公办",
      u8"公事包",
      u8"公事房",
      u8"公交",
      u8"公交公司",
      u8"公交化",
      u8"公交查询",
      u8"公交站",
      u8"公交站点",
      u8"公交线路",
      u8"公交网",
      u8"公交路线",
      u8"公交车",
      u8"公交车站",
      u8"公产",
      u8"公亩",
      u8"公人",
      u8"公仆",
      u8"公价",
      u8"公份",
      u8"公休",
      u8"公休日",
      u8"公众",
      u8"公众形象",
      u8"公众股",
      u8"公会",
      u8"公伤",
      u8"公伯峡",
      u8"公余",
      u8"公余之暇",
      u8"公使",
      u8"公使团",
      u8"公使衔",
      u8"公使馆",
      u8"公例",
      u8"公侯",
      u8"公侯伯子男",
      u8"公侯将相",
      u8"公侯将相宁有种乎",
      u8"公侯肚里好撑船",
      u8"公保",
      u8"公保大楼",
      u8"公信力",
      u8"公信度",
      u8"公修公德婆修婆德",
      u8"公倍数",
      u8"公债",
      u8"公债券",
      u8"公假",
      u8"公允",
      u8"公元",
      u8"公元前",
      u8"公克",
      u8"公兔",
      u8"公公",
      u8"公公平平",
      u8"公公正正",
      u8"公公诉",
      u8"公共",
      u8"公共事业",
      u8"公共事务",
      u8"公共交通",
      u8"公共信道",
      u8"公共关系",
      u8"公共利益",
      u8"公共卫生",
      u8"公共卫生口腔医学",
      u8"公共厕所",
      u8"公共场合",
      u8"公共场所",
      u8"公共娱乐场所",
      u8"公共安全",
      u8"公共对象模型",
      u8"公共广播",
      u8"公共建筑",
      u8"公共开支",
      u8"公共性",
      u8"公共成分",
      u8"公共接地点",
      u8"公共政策",
      u8"公共汽车",
      u8"公共汽车站",
      u8"公共活动室",
      u8"公共电视",
      u8"公共电话",
      u8"公共租界",
      u8"公共秩序",
      u8"公共积累",
      u8"公共绿地",
      u8"公共绿地指标",
      u8"公共英语",
      u8"公共行政",
      u8"公共设施",
      u8"公共课",
      u8"公共财产",
      u8"公共财政",
      u8"公共责任",
      u8"公共资料处",
      u8"公共资源",
      u8"公共道德",
      u8"公共部门",
      u8"公共频道",
      u8"公关",
      u8"公关先生",
      u8"公关员",
      u8"公关小姐",
      u8"公关活动",
      u8"公关礼仪",
      u8"公关能力",
      u8"公关部",
      u8"公决",
      u8"公冶",
      u8"公冶乾",
      u8"公出",
      u8"公函",
      u8"公分",
      u8"公分子",
      u8"公分母",
      u8"公切线",
      u8"公刘",
      u8"公判",
      u8"公判大会",
      u8"公制",
      u8"公制化",
      u8"公办",
      u8"公务",
      u8"公务人员",
      u8"公务员",
      u8"公务员惩",
      u8"公务员惩戒委员",
      u8"公务员法",
      u8"公务在身",
      u8"公务机",
      u8"公务活动",
      u8"公务用车",
      u8"公务缠身",
      u8"公务网",
      u8"公务舱",
      u8"公务车",
      u8"公勺",
      u8"公升",
      u8"公卖",
      u8"公卖局",
      u8"公卿",
      u8"公历",
      u8"公厕",
      u8"公厘",
      u8"公司",
      u8"公司业绩",
      u8"公司企业",
      u8"公司传真",
      u8"公司债",
      u8"公司债券",
      u8"公司债务",
      u8"公司党委",
      u8"公司公告",
      u8"公司内部",
      u8"公司出品",
      u8"公司制",
      u8"公司名",
      u8"公司名录",
      u8"公司名称",
      u8"公司员工",
      u8"公司地址",
      u8"公司库",
      u8"公司律师",
      u8"公司性质",
      u8"公司总裁",
      u8"公司总部",
      u8"公司概况",
      u8"公司法",
      u8"公司法人",
      u8"公司法律",
      u8"公司版权",
      u8"公司章程",
      u8"公司简介",
      u8"公司老总",
      u8"公司老板",
      u8"公司股东",
      u8"公司股票",
      u8"公司财务",
      u8"公吨",
      u8"公听会",
      u8"公听并观",
      u8"公告",
      u8"公告价格",
      u8"公告地价",
      u8"公告栏",
      u8"公告牌",
      u8"公告费",
      u8"公告送达",
      u8"公器私用",
      u8"公因式",
      u8"公因数",
      u8"公园",
      u8"公园形式",
      u8"公园类型",
      u8"公园路",
      u8"公园道路",
      u8"公国",
      u8"公地",
      u8"公垂线",
      u8"公堂",
      u8"公墓",
      u8"公奴",
      u8"公娼",
      u8"公婆",
      u8"公子",
      u8"公子哥",
      u8"公子哥儿",
      u8"公子王孙",
      u8"公孙",
      u8"公孙尼子",
      u8"公孙止",
      u8"公孙绿萼",
      u8"公孙龙",
      u8"公安",
      u8"公安交通",
      u8"公安人员",
      u8"公安分局",
      u8"公安厅",
      u8"公安县",
      u8"公安处",
      u8"公安大学",
      u8"公安局",
      u8"公安局长",
      u8"公安工作",
      u8"公安干警",
      u8"公安战士",
      u8"公安战线",
      u8"公安机关",
      u8"公安段",
      u8"公安民警",
      u8"公安法",
      u8"公安派",
      u8"公安消防",
      u8"公安系统",
      u8"公安网",
      u8"公安部",
      u8"公安部部长",
      u8"公安部长",
      u8"公安部门",
      u8"公安部队",
      u8"公安队伍",
      u8"公安院校",
      u8"公定",
      u8"公定价",
      u8"公定价格",
      u8"公审",
      u8"公害",
      u8"公害病",
      u8"公家",
      u8"公家机关",
      u8"公家机构",
      u8"公寓",
      u8"公寓化",
      u8"公寓床",
      u8"公寓式住宅",
      u8"公寓楼",
      u8"公寸",
      u8"公尔忘私",
      u8"公尺",
      u8"公尺见方",
      u8"公屋",
      u8"公差",
      u8"公差费",
      u8"公布",
      u8"公布于",
      u8"公布于世",
      u8"公布出来",
      u8"公布栏",
      u8"公帐",
      u8"公帑",
      u8"公干",
      u8"公平",
      u8"公平交易",
      u8"公平信实",
      u8"公平化",
      u8"公平合理",
      u8"公平性",
      u8"公平无私",
      u8"公平正义",
      u8"公平理论",
      u8"公平秤",
      u8"公平竞争",
      u8"公平网",
      u8"公库",
      u8"公开",
      u8"公开信",
      u8"公开出来",
      u8"公开化",
      u8"公开场合",
      u8"公开墙",
      u8"公开处理",
      u8"公开审判",
      u8"公开审理",
      u8"公开密钥",
      u8"公开市场",
      u8"公开性",
      u8"公开批评",
      u8"公开招标",
      u8"公开挑衅",
      u8"公开栏",
      u8"公开监督",
      u8"公开竞选",
      u8"公开课",
      u8"公开赛",
      u8"公开选拔",
      u8"公式",
      u8"公式主义",
      u8"公式化",
      u8"公引",
      u8"公役",
      u8"公德",
      u8"公德心",
      u8"公心",
      u8"公忠体国",
      u8"公意",
      u8"公愤",
      u8"公房",
      u8"公所",
      u8"公才公望",
      u8"公投",
      u8"公投法",
      u8"公报",
      u8"公报私仇",
      u8"公报私雠",
      u8"公担",
      u8"公拆",
      u8"公推",
      u8"公摊面积",
      u8"公撮",
      u8"公敌",
      u8"公教",
      u8"公教人员",
      u8"公文",
      u8"公文书",
      u8"公文信",
      u8"公文包",
      u8"公文旅行",
      u8"公文箱",
      u8"公文纸",
      u8"公文网",
      u8"公文袋",
      u8"公斗",
      u8"公斤",
      u8"公断",
      u8"公方",
      u8"公方代表",
      u8"公族",
      u8"公明党",
      u8"公明正大",
      u8"公明镇",
      u8"公映",
      u8"公是公非",
      u8"公有",
      u8"公有住房",
      u8"公有制",
      u8"公有化",
      u8"公有土地",
      u8"公权",
      u8"公权力",
      u8"公案",
      u8"公检法",
      u8"公检法司",
      u8"公款",
      u8"公款吃喝",
      u8"公款消费",
      u8"公正",
      u8"公正不阿",
      u8"公正司法",
      u8"公正地",
      u8"公正处理",
      u8"公正廉明",
      u8"公正廉洁",
      u8"公正性",
      u8"公正执法",
      u8"公正无私",
      u8"公比",
      u8"公毫",
      u8"公民",
      u8"公民投票",
      u8"公民权",
      u8"公民权利",
      u8"公民科",
      u8"公民自由",
      u8"公民课",
      u8"公民道德",
      u8"公汽",
      u8"公法",
      u8"公派",
      u8"公派留学",
      u8"公测",
      u8"公测版",
      u8"公海",
      u8"公海海底海床和平利用特别委员会",
      u8"公海自由",
      u8"公演",
      u8"公然",
      u8"公然侮辱",
      u8"公然反对",
      u8"公然反抗",
      u8"公爵",
      u8"公爵夫人",
      u8"公爹",
      u8"公牍",
      u8"公牛",
      u8"公牛队",
      u8"公物",
      u8"公狗",
      u8"公狮",
      u8"公狼",
      u8"公猪",
      u8"公猫",
      u8"公理",
      u8"公理化",
      u8"公理化理论",
      u8"公理复杂性",
      u8"公理学",
      u8"公用",
      u8"公用事业",
      u8"公用企业",
      u8"公用信息",
      u8"公用局",
      u8"公用权",
      u8"公用电话",
      u8"公用电话亭",
      u8"公用程式",
      u8"公用设施",
      u8"公畜",
      u8"公益",
      u8"公益事业",
      u8"公益广告",
      u8"公益性",
      u8"公益林",
      u8"公益活动",
      u8"公益行",
      u8"公益金",
      u8"公石",
      u8"公示",
      u8"公示制",
      u8"公示栏",
      u8"公社",
      u8"公社化",
      u8"公祭",
      u8"公私",
      u8"公私不分",
      u8"公私两便",
      u8"公私两利",
      u8"公私两济",
      u8"公私交困",
      u8"公私交迫",
      u8"公私兼顾",
      u8"公私分明",
      u8"公私合营",
      u8"公秉",
      u8"公积金",
      u8"公称",
      u8"公立",
      u8"公立医院",
      u8"公立学校",
      u8"公章",
      u8"公筷",
      u8"公筷母匙",
      u8"公粮",
      u8"公约",
      u8"公约国",
      u8"公约数",
      u8"公网",
      u8"公署",
      u8"公羊",
      u8"公羊传",
      u8"公老虎",
      u8"公而",
      u8"公而忘私",
      u8"公耠",
      u8"公职",
      u8"公职人员",
      u8"公股",
      u8"公营",
      u8"公营事业",
      u8"公营企业",
      u8"公虎",
      u8"公蚁",
      u8"公蚊子",
      u8"公规密谏",
      u8"公认",
      u8"公认为",
      u8"公认是",
      u8"公议",
      u8"公论",
      u8"公设",
      u8"公设辩护",
      u8"公设辩护人",
      u8"公证",
      u8"公证书",
      u8"公证人",
      u8"公证会",
      u8"公证员",
      u8"公证处",
      u8"公证机关",
      u8"公证法",
      u8"公证结婚",
      u8"公证费",
      u8"公诉",
      u8"公诉书",
      u8"公诉人",
      u8"公诉方",
      u8"公话",
      u8"公说公有",
      u8"公说公有理",
      u8"公说公有理婆说婆有理",
      u8"公诸于世",
      u8"公诸于众",
      u8"公诸同好",
      u8"公象",
      u8"公财",
      u8"公费",
      u8"公费医疗",
      u8"公费旅游",
      u8"公费生",
      u8"公费留学",
      u8"公贿",
      u8"公路",
      u8"公路交通",
      u8"公路局",
      u8"公路工程",
      u8"公路建设",
      u8"公路桥",
      u8"公路沿线",
      u8"公路法",
      u8"公路绿化",
      u8"公路网",
      u8"公路运输",
      u8"公车",
      u8"公车上",
      u8"公车处",
      u8"公车票",
      u8"公车私用",
      u8"公车站",
      u8"公车管理",
      u8"公车管理处",
      u8"公转",
      u8"公输",
      u8"公选",
      u8"公道",
      u8"公道合理",
      u8"公道自在人心",
      u8"公道话",
      u8"公里",
      u8"公里处",
      u8"公里数",
      u8"公里跑",
      u8"公钱",
      u8"公锥",
      u8"公门",
      u8"公门桃李",
      u8"公顷",
      u8"公项",
      u8"公馆",
      u8"公马",
      u8"公驴",
      u8"公鸡",
      u8"公鹅",
      u8"公鹿",
      u8"公鼠",
      u8"六一",
      u8"六一儿童节",
      u8"六一国际儿童节",
      u8"六一路",
      u8"六七",
      u8"六七米",
      u8"六万",
      u8"六万个",
      u8"六万人",
      u8"六万元",
      u8"六万块",
      u8"六三制",
      u8"六下",
      u8"六世",
      u8"六世纪",
      u8"六两",
      u8"六个",
      u8"六个人",
      u8"六个月",
      u8"六中",
      u8"六中全会",
      u8"六串",
      u8"六书",
      u8"六五",
      u8"六亲",
      u8"六亲不认",
      u8"六亲无靠",
      u8"六人",
      u8"六人份",
      u8"六人行",
      u8"六亿",
      u8"六亿人",
      u8"六亿元",
      u8"六仙桌",
      u8"六任",
      u8"六份",
      u8"六位",
      u8"六位数",
      u8"六信",
      u8"六元金码",
      u8"六六六",
      u8"六具",
      u8"六军",
      u8"六出",
      u8"六出纷飞",
      u8"六出花",
      u8"六刀",
      u8"六分",
      u8"六分之一",
      u8"六分仪",
      u8"六分钟",
      u8"六划",
      u8"六区",
      u8"六十",
      u8"六十一",
      u8"六十七",
      u8"六十万",
      u8"六十三",
      u8"六十九",
      u8"六十二",
      u8"六十五",
      u8"六十八",
      u8"六十六",
      u8"六十四",
      u8"六十大寿",
      u8"六十年代",
      u8"六十花甲子",
      u8"六千",
      u8"六千万",
      u8"六千个",
      u8"六千人",
      u8"六千元",
      u8"六千块",
      u8"六厂",
      u8"六发",
      u8"六口",
      u8"六口之家",
      u8"六句",
      u8"六句话",
      u8"六只",
      u8"六只手",
      u8"六号",
      u8"六号楼",
      u8"六合",
      u8"六合一",
      u8"六合之内",
      u8"六合区",
      u8"六合县",
      u8"六合彩",
      u8"六合拳",
      u8"六合源",
      u8"六合皇",
      u8"六合网",
      u8"六合采",
      u8"六名",
      u8"六周",
      u8"六周年",
      u8"六味地黄丸",
      u8"六和",
      u8"六和塔",
      u8"六和彩",
      u8"六哥",
      u8"六四",
      u8"六回",
      u8"六国",
      u8"六国论",
      u8"六场",
      u8"六块",
      u8"六块钱",
      u8"六堰",
      u8"六堵",
      u8"六声",
      u8"六壶",
      u8"六壶酒",
      u8"六处",
      u8"六大",
      u8"六大块",
      u8"六大片",
      u8"六大类",
      u8"六妹",
      u8"六季",
      u8"六安",
      u8"六安县",
      u8"六安市",
      u8"六害",
      u8"六家",
      u8"六小",
      u8"六小时",
      u8"六小龄童",
      u8"六尘不染",
      u8"六尺之孤",
      u8"六尺之讬",
      u8"六尺之驱",
      u8"六尾",
      u8"六局",
      u8"六局上半",
      u8"六局下半",
      u8"六届",
      u8"六岁",
      u8"六岁时",
      u8"六巷",
      u8"六师",
      u8"六年",
      u8"六年制",
      u8"六年级",
      u8"六库镇",
      u8"六度",
      u8"六弄",
      u8"六式",
      u8"六弟",
      u8"六张",
      u8"六张犁",
      u8"六弦琴",
      u8"六成",
      u8"六成新",
      u8"六截",
      u8"六户",
      u8"六房",
      u8"六手",
      u8"六折",
      u8"六指儿",
      u8"六排",
      u8"六支",
      u8"六斤",
      u8"六斤重",
      u8"六方会谈",
      u8"六方晶系",
      u8"六方钻杆",
      u8"六日",
      u8"六日游",
      u8"六日电",
      u8"六旬",
      u8"六时",
      u8"六星期",
      u8"六星级",
      u8"六晚",
      u8"六曲",
      u8"六月",
      u8"六月份",
      u8"六月天",
      u8"六月雪",
      u8"六月飞霜",
      u8"六朝",
      u8"六朝金粉",
      u8"六期",
      u8"六本木",
      u8"六条",
      u8"六枚",
      u8"六枝",
      u8"六枝特区",
      u8"六栋",
      u8"六栏",
      u8"六株",
      u8"六根",
      u8"六根清净",
      u8"六根清静",
      u8"六格",
      u8"六桶",
      u8"六梯",
      u8"六梯次",
      u8"六棵",
      u8"六楼",
      u8"六次",
      u8"六欲",
      u8"六步",
      u8"六段",
      u8"六法",
      u8"六法全书",
      u8"六洞",
      u8"六派",
      u8"六滴",
      u8"六点",
      u8"六点半",
      u8"六点钟",
      u8"六爷",
      u8"六爻",
      u8"六版",
      u8"六环路",
      u8"六班",
      u8"六瓣",
      u8"六甲",
      u8"六畜",
      u8"六畜不安",
      u8"六畜兴旺",
      u8"六百",
      u8"六百万",
      u8"六百个",
      u8"六百人",
      u8"六百元",
      u8"六百块",
      u8"六盘山",
      u8"六盘水",
      u8"六盘水市",
      u8"六碗",
      u8"六礼",
      u8"六祖",
      u8"六神",
      u8"六神不安",
      u8"六神丸",
      u8"六神无主",
      u8"六种",
      u8"六科",
      u8"六章",
      u8"六等奖",
      u8"六筒",
      u8"六箱",
      u8"六篓",
      u8"六篮",
      u8"六类",
      u8"六粒",
      u8"六粒装",
      u8"六级",
      u8"六级风",
      u8"六线",
      u8"六线谱",
      u8"六经",
      u8"六耳不同谋",
      u8"六联",
      u8"六脚",
      u8"六腑",
      u8"六臂三头",
      u8"六船",
      u8"六艺",
      u8"六节",
      u8"六节诗",
      u8"六节课",
      u8"六营",
      u8"六街",
      u8"六街三市",
      u8"六街三陌",
      u8"六西格玛",
      u8"六角",
      u8"六角亭",
      u8"六角形",
      u8"六角网",
      u8"六言诗",
      u8"六课",
      u8"六起",
      u8"六趣轮回",
      u8"六路",
      u8"六路横队",
      u8"六路纵队",
      u8"六轻",
      u8"六辆",
      u8"六边",
      u8"六边形",
      u8"六连",
      u8"六连冠",
      u8"六通",
      u8"六通四辟",
      u8"六通四达",
      u8"六遍",
      u8"六道",
      u8"六道菜",
      u8"六道轮回",
      u8"六部",
      u8"六里桥",
      u8"六重唱",
      u8"六钱",
      u8"六锅",
      u8"六镇",
      u8"六问三推",
      u8"六阶",
      u8"六陆",
      u8"六集",
      u8"六面",
      u8"六面体",
      u8"六韬",
      u8"六韬三略",
      u8"六项",
      u8"六颗",
      u8"六题",
      u8"六首",
      u8"六首歌",
      u8"六马仰秣",
      u8"六龄童",
      u8"六龟",
      u8"兮兮",
      u8"兰亭",
      u8"兰亭序",
      u8"兰亭集序",
      u8"兰伯特",
      u8"兰兰",
      u8"兰剑",
      u8"兰博基尼",
      u8"兰卡威",
      u8"兰友瓜戚",
      u8"兰古瑞萨",
      u8"兰因絮果",
      u8"兰圃",
      u8"兰坪",
      u8"兰坪白族普米族自治县",
      u8"兰多夫",
      u8"兰天野",
      u8"兰宝",
      u8"兰宝石",
      u8"兰室",
      u8"兰山区",
      u8"兰屿",
      u8"兰州",
      u8"兰州交通大学",
      u8"兰州军区",
      u8"兰州大学",
      u8"兰州市",
      u8"兰州铁路局",
      u8"兰州铁道学院",
      u8"兰形棘心",
      u8"兰彻斯特方程",
      u8"兰德",
      u8"兰德尔",
      u8"兰德斯",
      u8"兰心蕙性",
      u8"兰房",
      u8"兰摧玉折",
      u8"兰斯",
      u8"兰斯洛",
      u8"兰新铁路",
      u8"兰板",
      u8"兰桂",
      u8"兰桂坊",
      u8"兰桂齐芳",
      u8"兰桨",
      u8"兰洽会",
      u8"兰溪",
      u8"兰溪市",
      u8"兰熏桂馥",
      u8"兰特",
      u8"兰生",
      u8"兰盆会",
      u8"兰科",
      u8"兰考",
      u8"兰考县",
      u8"兰色姆",
      u8"兰艾同焚",
      u8"兰艾难分",
      u8"兰芝常生",
      u8"兰花",
      u8"兰花指",
      u8"兰花网",
      u8"兰花苕子",
      u8"兰花草",
      u8"兰芷",
      u8"兰芷之室",
      u8"兰若",
      u8"兰草",
      u8"兰薰桂馥",
      u8"兰西",
      u8"兰西县",
      u8"兰谱",
      u8"兰质熏心",
      u8"兰质蕙心",
      u8"兰质薰心",
      u8"兰迪斯",
      u8"兰阳",
      u8"兰阳溪",
      u8"兰陵王",
      u8"兰飞",
      u8"兰鸟",
      u8"兰麝",
      u8"共上",
      u8"共上站",
      u8"共下",
      u8"共业",
      u8"共为",
      u8"共为唇齿",
      u8"共主",
      u8"共乐",
      u8"共买",
      u8"共事",
      u8"共亏",
      u8"共产",
      u8"共产主义",
      u8"共产主义世界观",
      u8"共产主义思想",
      u8"共产主义战士",
      u8"共产主义社会",
      u8"共产主义者",
      u8"共产主义运动",
      u8"共产主义道德",
      u8"共产主义青年团",
      u8"共产党",
      u8"共产党人",
      u8"共产党员",
      u8"共产党宣言",
      u8"共产制",
      u8"共产国际",
      u8"共亨",
      u8"共享",
      u8"共享主义",
      u8"共享器",
      u8"共享性",
      u8"共享版",
      u8"共享税",
      u8"共享虚拟区",
      u8"共享资源",
      u8"共享软件",
      u8"共享高速缓存",
      u8"共从",
      u8"共价",
      u8"共价半径",
      u8"共价层析",
      u8"共价配位键",
      u8"共价键",
      u8"共价闭",
      u8"共传递",
      u8"共促",
      u8"共保",
      u8"共免疫沉淀",
      u8"共党",
      u8"共养",
      u8"共军",
      u8"共凝集",
      u8"共凝集素",
      u8"共凝集补体吸收",
      u8"共出",
      u8"共出动",
      u8"共切",
      u8"共创",
      u8"共办",
      u8"共勉",
      u8"共匪",
      u8"共印",
      u8"共去",
      u8"共反射点道集",
      u8"共发射极",
      u8"共取",
      u8"共变微分",
      u8"共变指标",
      u8"共叙",
      u8"共吃",
      u8"共合体",
      u8"共同",
      u8"共同之处",
      u8"共同任务",
      u8"共同体",
      u8"共同利益",
      u8"共同刺激",
      u8"共同前进",
      u8"共同努力",
      u8"共同发展",
      u8"共同受体",
      u8"共同商定",
      u8"共同声明",
      u8"共同奋斗",
      u8"共同完成",
      u8"共同富裕",
      u8"共同富裕论",
      u8"共同市场",
      u8"共同开发",
      u8"共同性",
      u8"共同愿望",
      u8"共同提高",
      u8"共同条令",
      u8"共同海损",
      u8"共同点",
      u8"共同爱好",
      u8"共同犯罪",
      u8"共同理想",
      u8"共同生活",
      u8"共同研究",
      u8"共同社",
      u8"共同纲领",
      u8"共同致富",
      u8"共同行动",
      u8"共同表位",
      u8"共同要素说",
      u8"共同识别",
      u8"共同话题",
      u8"共同语",
      u8"共同语言",
      u8"共同财产",
      u8"共同进步",
      u8"共吸附",
      u8"共呼吸",
      u8"共命运",
      u8"共和",
      u8"共和党",
      u8"共和党人",
      u8"共和军",
      u8"共和制",
      u8"共和县",
      u8"共和国",
      u8"共和国宫",
      u8"共和政体",
      u8"共和派",
      u8"共唱",
      u8"共商",
      u8"共商国事",
      u8"共商国是",
      u8"共商大计",
      u8"共固化作用",
      u8"共图",
      u8"共图国事",
      u8"共圆",
      u8"共在",
      u8"共基极",
      u8"共处",
      u8"共处一室",
      u8"共夺",
      u8"共妻",
      u8"共存",
      u8"共存亡",
      u8"共存水饱和度",
      u8"共学",
      u8"共守",
      u8"共对",
      u8"共尾性",
      u8"共居",
      u8"共属",
      u8"共帽化",
      u8"共庆",
      u8"共度",
      u8"共建",
      u8"共建文明",
      u8"共建点",
      u8"共开",
      u8"共引发剂",
      u8"共形天线",
      u8"共形溶液",
      u8"共形阵天线",
      u8"共得",
      u8"共忆",
      u8"共性",
      u8"共总",
      u8"共患难",
      u8"共患难了",
      u8"共感",
      u8"共感染",
      u8"共扩散",
      u8"共抑制",
      u8"共抵",
      u8"共拜",
      u8"共持",
      u8"共振",
      u8"共振吸收",
      u8"共振器",
      u8"共振态",
      u8"共振效应",
      u8"共振板",
      u8"共振波模",
      u8"共振荧光",
      u8"共振频率",
      u8"共挽鹿车",
      u8"共推",
      u8"共摆",
      u8"共收",
      u8"共收录",
      u8"共收缴",
      u8"共效",
      u8"共时",
      u8"共显性",
      u8"共曼凝",
      u8"共有",
      u8"共有区",
      u8"共有基序",
      u8"共来",
      u8"共极化",
      u8"共析",
      u8"共析钢",
      u8"共枝别干",
      u8"共栖",
      u8"共模抑制比",
      u8"共欣赏",
      u8"共歉",
      u8"共沉淀",
      u8"共沉降",
      u8"共测",
      u8"共济会",
      u8"共济失调",
      u8"共济网",
      u8"共浴",
      u8"共渡难关",
      u8"共溅射",
      u8"共点力",
      u8"共点力系",
      u8"共焦点",
      u8"共犯",
      u8"共犯论处",
      u8"共生",
      u8"共生光合生物",
      u8"共生同源基因",
      u8"共生死",
      u8"共生生物",
      u8"共生矿",
      u8"共生藻",
      u8"共用",
      u8"共登",
      u8"共相",
      u8"共睡",
      u8"共睡一床",
      u8"共睹",
      u8"共研",
      u8"共祝",
      u8"共称",
      u8"共端",
      u8"共管",
      u8"共约",
      u8"共纯化",
      u8"共纺",
      u8"共线",
      u8"共线性",
      u8"共给",
      u8"共翻译分泌",
      u8"共翻译切割",
      u8"共翻译整合",
      u8"共翻译糖基化",
      u8"共翻译转移",
      u8"共翻译转运",
      u8"共聚",
      u8"共聚一堂",
      u8"共聚反应",
      u8"共聚合",
      u8"共聚物",
      u8"共聚集体",
      u8"共背",
      u8"共舞",
      u8"共苦",
      u8"共荣互利",
      u8"共荣圈",
      u8"共获",
      u8"共蒸发",
      u8"共表达",
      u8"共襄感举",
      u8"共襄盛举",
      u8"共要",
      u8"共计",
      u8"共计价格",
      u8"共议",
      u8"共设",
      u8"共识",
      u8"共诊",
      u8"共话",
      u8"共语",
      u8"共诱导",
      u8"共请",
      u8"共谋",
      u8"共谋国事",
      u8"共质",
      u8"共质体",
      u8"共贯同条",
      u8"共费",
      u8"共贺",
      u8"共赚",
      u8"共赴",
      u8"共赴国难",
      u8"共转",
      u8"共转化",
      u8"共转变",
      u8"共转导",
      u8"共转录物",
      u8"共转染",
      u8"共轭",
      u8"共轭体系",
      u8"共轭像",
      u8"共轭光线",
      u8"共轭双键",
      u8"共轭复数",
      u8"共轭点",
      u8"共轭物",
      u8"共轭碱机理",
      u8"共轭角",
      u8"共轭象",
      u8"共轭轴",
      u8"共轭酸",
      u8"共轭酸碱对",
      u8"共轴",
      u8"共轴管",
      u8"共载",
      u8"共输",
      u8"共达",
      u8"共运",
      u8"共进",
      u8"共进会",
      u8"共进午餐",
      u8"共进退",
      u8"共通",
      u8"共通性",
      u8"共通点",
      u8"共邀",
      u8"共铺",
      u8"共降",
      u8"共需",
      u8"共青",
      u8"共青团",
      u8"共青团中央",
      u8"共青团员",
      u8"共青团组织",
      u8"共青城",
      u8"共面",
      u8"共面力",
      u8"共面力系",
      u8"共餐",
      u8"共骑",
      u8"共鸣",
      u8"共鸣器",
      u8"共鸣板",
      u8"共鸣点",
      u8"共鸣管",
      u8"关上",
      u8"关上灯",
      u8"关上门",
      u8"关下",
      u8"关不上",
      u8"关不了",
      u8"关不住",
      u8"关不料",
      u8"关东",
      u8"关东军",
      u8"关东出相",
      u8"关东出相关西出将",
      u8"关东地区",
      u8"关东煮",
      u8"关东糖",
      u8"关个",
      u8"关中",
      u8"关中地区",
      u8"关丽仪",
      u8"关乃忻",
      u8"关之琳",
      u8"关乎",
      u8"关书",
      u8"关了",
      u8"关了机",
      u8"关了灯",
      u8"关了门",
      u8"关于",
      u8"关于度量",
      u8"关于性",
      u8"关云长",
      u8"关井钻杆压力",
      u8"关亡",
      u8"关人",
      u8"关伟伦",
      u8"关住",
      u8"关停",
      u8"关停令",
      u8"关停并转",
      u8"关元",
      u8"关元俞",
      u8"关入",
      u8"关公",
      u8"关公面前耍大刀",
      u8"关关",
      u8"关兴",
      u8"关内",
      u8"关冲",
      u8"关出",
      u8"关刀",
      u8"关切",
      u8"关到",
      u8"关劳",
      u8"关华",
      u8"关协",
      u8"关卡",
      u8"关卡基因",
      u8"关卡税",
      u8"关厢",
      u8"关反",
      u8"关口",
      u8"关合",
      u8"关名",
      u8"关员",
      u8"关咏荷",
      u8"关回",
      u8"关回去",
      u8"关在",
      u8"关外",
      u8"关头",
      u8"关好",
      u8"关子",
      u8"关子岭",
      u8"关安基",
      u8"关宏达",
      u8"关定",
      u8"关宝慧",
      u8"关山",
      u8"关山万里",
      u8"关山月",
      u8"关山超递",
      u8"关山迢递",
      u8"关山重重",
      u8"关山阻隔",
      u8"关岛",
      u8"关岭布依族苗族自治县",
      u8"关工委",
      u8"关帝庙",
      u8"关平",
      u8"关底",
      u8"关庙",
      u8"关张",
      u8"关彝",
      u8"关得",
      u8"关德兴",
      u8"关德辉",
      u8"关心",
      u8"关心伟",
      u8"关心体贴",
      u8"关心国家大事",
      u8"关心妍",
      u8"关心民瘼",
      u8"关心群众",
      u8"关心集体",
      u8"关念",
      u8"关怀",
      u8"关怀备至",
      u8"关怀面",
      u8"关情脉脉",
      u8"关我",
      u8"关押",
      u8"关押情况",
      u8"关掉",
      u8"关断",
      u8"关於",
      u8"关明梅",
      u8"关有",
      u8"关木通",
      u8"关本",
      u8"关机",
      u8"关机器",
      u8"关机时",
      u8"关机闹钟",
      u8"关来关去",
      u8"关栈",
      u8"关楼",
      u8"关死",
      u8"关毅",
      u8"关氏",
      u8"关水",
      u8"关汉卿",
      u8"关法",
      u8"关注",
      u8"关注点",
      u8"关津",
      u8"关海山",
      u8"关涉",
      u8"关淑仪",
      u8"关淑怡",
      u8"关渡",
      u8"关渡庙",
      u8"关满",
      u8"关灯",
      u8"关照",
      u8"关爱",
      u8"关牧村",
      u8"关白附",
      u8"关着",
      u8"关碍",
      u8"关礼杰",
      u8"关禁闭",
      u8"关秀娟",
      u8"关秀媚",
      u8"关税",
      u8"关税区",
      u8"关税合作理事会",
      u8"关税同盟",
      u8"关税壁垒",
      u8"关窗",
      u8"关窗户",
      u8"关系",
      u8"关系不大",
      u8"关系人",
      u8"关系代名词",
      u8"关系企业",
      u8"关系到",
      u8"关系史",
      u8"关系妄想",
      u8"关系学",
      u8"关系密切",
      u8"关系式",
      u8"关系恶化",
      u8"关系户",
      u8"关系暧昧",
      u8"关系正常",
      u8"关系正常化",
      u8"关系着",
      u8"关系系统",
      u8"关系紧张",
      u8"关系网",
      u8"关系融洽",
      u8"关系词",
      u8"关系逻辑",
      u8"关索",
      u8"关紧",
      u8"关统",
      u8"关羽",
      u8"关联",
      u8"关联处理机",
      u8"关联失效",
      u8"关联度",
      u8"关联性",
      u8"关联方",
      u8"关联氨基酸",
      u8"关联系数",
      u8"关联系统",
      u8"关联能",
      u8"关联词",
      u8"关节",
      u8"关节炎",
      u8"关节点",
      u8"关节痛",
      u8"关节盘",
      u8"关节窝",
      u8"关节结节",
      u8"关节轴承",
      u8"关节镜",
      u8"关芝琳",
      u8"关菁",
      u8"关西",
      u8"关西出将",
      u8"关西地区",
      u8"关说",
      u8"关贸",
      u8"关贸总协定",
      u8"关起",
      u8"关起来",
      u8"关起门来",
      u8"关过",
      u8"关进",
      u8"关进去",
      u8"关进来",
      u8"关连",
      u8"关连性",
      u8"关铝",
      u8"关键",
      u8"关键人物",
      u8"关键作用",
      u8"关键因素",
      u8"关键在于",
      u8"关键字",
      u8"关键帧",
      u8"关键性",
      u8"关键所在",
      u8"关键技术",
      u8"关键时刻",
      u8"关键时期",
      u8"关键是",
      u8"关键期",
      u8"关键步骤",
      u8"关键环节",
      u8"关键球",
      u8"关键码",
      u8"关键设备",
      u8"关键词",
      u8"关键词识记法",
      u8"关键部位",
      u8"关键问题",
      u8"关长",
      u8"关长林",
      u8"关门",
      u8"关门主义",
      u8"关门养虎",
      u8"关门养虎虎大伤人",
      u8"关门大吉",
      u8"关门打狗",
      u8"关门捉贼",
      u8"关门歇业",
      u8"关门落闩",
      u8"关门闭窗",
      u8"关闭",
      u8"关闭不全",
      u8"关闭程序",
      u8"关闭系统",
      u8"关闸",
      u8"关防",
      u8"关隘",
      u8"关雎",
      u8"关顺田",
      u8"关顾",
      u8"兴业",
      u8"兴业县",
      u8"兴业电",
      u8"兴中会",
      u8"兴举",
      u8"兴义",
      u8"兴义市",
      u8"兴之所至",
      u8"兴云布雨",
      u8"兴云致雨",
      u8"兴亡",
      u8"兴亡史",
      u8"兴亡祸福",
      u8"兴亡继绝",
      u8"兴仁",
      u8"兴仁县",
      u8"兴会",
      u8"兴会淋漓",
      u8"兴修",
      u8"兴修水利",
      u8"兴元星辰",
      u8"兴兵",
      u8"兴兵动众",
      u8"兴农",
      u8"兴农网",
      u8"兴冲冲",
      u8"兴凯湖",
      u8"兴利除弊",
      u8"兴办",
      u8"兴办事业",
      u8"兴匆匆",
      u8"兴化",
      u8"兴化县",
      u8"兴化市",
      u8"兴化戏",
      u8"兴华",
      u8"兴华路",
      u8"兴南",
      u8"兴县",
      u8"兴发",
      u8"兴发街",
      u8"兴叹",
      u8"兴味",
      u8"兴味盎然",
      u8"兴味索然",
      u8"兴和",
      u8"兴和县",
      u8"兴国",
      u8"兴国县",
      u8"兴国安邦",
      u8"兴城",
      u8"兴城县",
      u8"兴城市",
      u8"兴复",
      u8"兴复不浅",
      u8"兴头",
      u8"兴头上",
      u8"兴头很大",
      u8"兴奋",
      u8"兴奋不已",
      u8"兴奋剂",
      u8"兴奋地",
      u8"兴奋异常",
      u8"兴奋性",
      u8"兴奋性氨基酸",
      u8"兴奋性突触后电位",
      u8"兴奋点",
      u8"兴如嚼蜡",
      u8"兴妖作乱",
      u8"兴妖作孽",
      u8"兴妖作怪",
      u8"兴学",
      u8"兴宁",
      u8"兴宁区",
      u8"兴宁县",
      u8"兴宁市",
      u8"兴安",
      u8"兴安区",
      u8"兴安县",
      u8"兴安岭",
      u8"兴安盟",
      u8"兴安省",
      u8"兴家立业",
      u8"兴宾区",
      u8"兴富",
      u8"兴尽而返",
      u8"兴山",
      u8"兴山区",
      u8"兴山县",
      u8"兴工",
      u8"兴师",
      u8"兴师动众",
      u8"兴师问罪",
      u8"兴平",
      u8"兴平县",
      u8"兴平市",
      u8"兴庆区",
      u8"兴废",
      u8"兴废存之",
      u8"兴废继绝",
      u8"兴建",
      u8"兴建中",
      u8"兴微继绝",
      u8"兴德",
      u8"兴文",
      u8"兴文匽武",
      u8"兴文县",
      u8"兴旺",
      u8"兴旺发达",
      u8"兴旺繁荣",
      u8"兴替",
      u8"兴林",
      u8"兴桑养蚕",
      u8"兴海",
      u8"兴海县",
      u8"兴涛",
      u8"兴灭",
      u8"兴灭继绝",
      u8"兴盛",
      u8"兴筑",
      u8"兴绿原",
      u8"兴致",
      u8"兴致勃勃",
      u8"兴致淋漓",
      u8"兴致索然",
      u8"兴芳",
      u8"兴落",
      u8"兴衰",
      u8"兴衰史",
      u8"兴衰成败",
      u8"兴衰起伏",
      u8"兴观群怨",
      u8"兴许",
      u8"兴讹造讪",
      u8"兴讼",
      u8"兴词构讼",
      u8"兴象",
      u8"兴起",
      u8"兴起来",
      u8"兴趣",
      u8"兴趣不大",
      u8"兴趣十足",
      u8"兴趣小组",
      u8"兴趣正浓",
      u8"兴趣测验",
      u8"兴趣浓厚",
      u8"兴趣爱好",
      u8"兴趣盎然",
      u8"兴趣缺失",
      u8"兴趣缺缺",
      u8"兴邦",
      u8"兴邦立国",
      u8"兴隆",
      u8"兴隆县",
      u8"兴隆台区",
      u8"兴隆村",
      u8"兴隆路",
      u8"兴革",
      u8"兴风作浪",
      u8"兴高彩烈",
      u8"兴高采烈",
      u8"兵丁",
      u8"兵不厌权",
      u8"兵不厌诈",
      u8"兵不接刃",
      u8"兵不污刃",
      u8"兵不由将",
      u8"兵不血刃",
      u8"兵不雪刃",
      u8"兵临城下",
      u8"兵书",
      u8"兵乱",
      u8"兵事",
      u8"兵佳绮",
      u8"兵兵",
      u8"兵凶战危",
      u8"兵出无名",
      u8"兵刃",
      u8"兵刃相接",
      u8"兵分",
      u8"兵分二路",
      u8"兵制",
      u8"兵力",
      u8"兵劲城固",
      u8"兵勇",
      u8"兵卒",
      u8"兵变",
      u8"兵员",
      u8"兵味",
      u8"兵哥",
      u8"兵哥哥",
      u8"兵器",
      u8"兵器工业",
      u8"兵器库",
      u8"兵器谱",
      u8"兵团",
      u8"兵圣",
      u8"兵在其颈",
      u8"兵在精而不在多",
      u8"兵士",
      u8"兵备",
      u8"兵多将广",
      u8"兵多者败",
      u8"兵学",
      u8"兵家",
      u8"兵家必争",
      u8"兵家必争之地",
      u8"兵富难战",
      u8"兵将",
      u8"兵工",
      u8"兵工厂",
      u8"兵工署",
      u8"兵差",
      u8"兵库县",
      u8"兵强则灭",
      u8"兵强将勇",
      u8"兵强马壮",
      u8"兵役",
      u8"兵役制",
      u8"兵役制度",
      u8"兵役法",
      u8"兵役节",
      u8"兵微将寡",
      u8"兵患",
      u8"兵慌马乱",
      u8"兵戈",
      u8"兵戈扰攘",
      u8"兵戎",
      u8"兵戎相见",
      u8"兵拏祸结",
      u8"兵挫地削",
      u8"兵操",
      u8"兵数",
      u8"兵无常势",
      u8"兵无常形",
      u8"兵无血刃",
      u8"兵未血刃",
      u8"兵权",
      u8"兵来将挡",
      u8"兵来将挡水来土掩",
      u8"兵来将挡水来土淹",
      u8"兵来将敌水来土堰",
      u8"兵来将迎水来土堰",
      u8"兵殷",
      u8"兵油子",
      u8"兵法",
      u8"兵法云",
      u8"兵源",
      u8"兵火",
      u8"兵灾",
      u8"兵燹",
      u8"兵甲",
      u8"兵略",
      u8"兵疲意阻",
      u8"兵痞",
      u8"兵祸",
      u8"兵种",
      u8"兵科",
      u8"兵站",
      u8"兵符",
      u8"兵籍",
      u8"兵籍卡",
      u8"兵籍号码",
      u8"兵籍表",
      u8"兵粮",
      u8"兵舰",
      u8"兵船",
      u8"兵荒马乱",
      u8"兵营",
      u8"兵营区",
      u8"兵藏武库马入华山",
      u8"兵蜂",
      u8"兵行诡道",
      u8"兵谏",
      u8"兵谏亭",
      u8"兵豆",
      u8"兵败如山倒",
      u8"兵败将亡",
      u8"兵贵先声",
      u8"兵贵神速",
      u8"兵车",
      u8"兵车之会",
      u8"兵车行",
      u8"兵连祸接",
      u8"兵连祸结",
      u8"兵部",
      u8"兵销革偃",
      u8"兵闻拙速",
      u8"兵阵",
      u8"兵革互兴",
      u8"兵革满道",
      u8"兵饷",
      u8"兵马",
      u8"兵马不动粮草先行",
      u8"兵马俑",
      u8"兵马未动",
      u8"兵马未动粮草先行",
      u8"兵骄将傲",
      u8"其一",
      u8"其一据",
      u8"其三",
      u8"其下",
      u8"其中",
      u8"其中之一",
      u8"其中奇",
      u8"其中市",
      u8"其中有",
      u8"其中正",
      u8"其中非",
      u8"其为",
      u8"其主要",
      u8"其乐不穷",
      u8"其乐无穷",
      u8"其乐融融",
      u8"其乐陶陶",
      u8"其事",
      u8"其二",
      u8"其人",
      u8"其他",
      u8"其他产品",
      u8"其他人",
      u8"其他同学",
      u8"其他国家",
      u8"其他地区",
      u8"其他地方",
      u8"其他城市",
      u8"其他应计",
      u8"其他应计负债",
      u8"其他支出",
      u8"其他用户",
      u8"其他词汇",
      u8"其他费用",
      u8"其他软件",
      u8"其他配件",
      u8"其余",
      u8"其余不问",
      u8"其余部分",
      u8"其先",
      u8"其内",
      u8"其利断金",
      u8"其势凶凶",
      u8"其势汹汹",
      u8"其名",
      u8"其后",
      u8"其味无穷",
      u8"其善不赏",
      u8"其四",
      u8"其外",
      u8"其它",
      u8"其它窗口",
      u8"其实",
      u8"其实不然",
      u8"其实在",
      u8"其实是",
      u8"其实有",
      u8"其实质",
      u8"其实难副",
      u8"其害",
      u8"其家",
      u8"其属下",
      u8"其应如响",
      u8"其应若响",
      u8"其志可嘉",
      u8"其怪自败",
      u8"其恶必罚",
      u8"其情可悯",
      u8"其意",
      u8"其意自现",
      u8"其所",
      u8"其文",
      u8"其时",
      u8"其本质",
      u8"其次",
      u8"其次是",
      u8"其母",
      u8"其父",
      u8"其父亲",
      u8"其生",
      u8"其管辖",
      u8"其美",
      u8"其行为已触犯",
      u8"其言",
      u8"其言也善",
      u8"其计不售",
      u8"其貌不扬",
      u8"其身正",
      u8"其身正不令则行",
      u8"其道亡繇",
      u8"其道无由",
      u8"其里",
      u8"其间",
      u8"具体",
      u8"具体任务",
      u8"具体位置",
      u8"具体做法",
      u8"具体内容",
      u8"具体分析",
      u8"具体办法",
      u8"具体劳动",
      u8"具体化",
      u8"具体化起",
      u8"具体化起来",
      u8"具体地址",
      u8"具体地说",
      u8"具体型号",
      u8"具体安排",
      u8"具体工作",
      u8"具体思维",
      u8"具体性",
      u8"具体情况",
      u8"具体意见",
      u8"具体指导",
      u8"具体措施",
      u8"具体操作",
      u8"具体方法",
      u8"具体条件",
      u8"具体来说",
      u8"具体步骤",
      u8"具体物",
      u8"具体而微",
      u8"具体表",
      u8"具体表现",
      u8"具体要求",
      u8"具体规定",
      u8"具体说来",
      u8"具体问题",
      u8"具体问题具体分析",
      u8"具佳",
      u8"具保",
      u8"具像",
      u8"具名",
      u8"具备",
      u8"具备条件",
      u8"具定",
      u8"具情",
      u8"具报",
      u8"具文",
      u8"具有",
      u8"具有专长",
      u8"具有中国特色社会主义",
      u8"具有国际先进水平",
      u8"具有活力",
      u8"具有特征",
      u8"具有生气",
      u8"具本承",
      u8"具结",
      u8"具结书",
      u8"具结悔过",
      u8"具象",
      u8"具象化系",
      u8"典业",
      u8"典出人",
      u8"典则俊雅",
      u8"典卖",
      u8"典型",
      u8"典型人物",
      u8"典型值",
      u8"典型化",
      u8"典型复单李代数",
      u8"典型性",
      u8"典型示范",
      u8"典型群",
      u8"典型调查",
      u8"典型过程",
      u8"典妻鬻子",
      u8"典当",
      u8"典当业",
      u8"典当行",
      u8"典押",
      u8"典故",
      u8"典狱",
      u8"典狱官",
      u8"典狱长",
      u8"典礼",
      u8"典章",
      u8"典章制度",
      u8"典章文物",
      u8"典籍",
      u8"典范",
      u8"典范态射",
      u8"典范赋值",
      u8"典藉",
      u8"典藏",
      u8"典藏本",
      u8"典藏版",
      u8"典试",
      u8"典试委员",
      u8"典试委员会",
      u8"典谟训诰",
      u8"典身卖命",
      u8"典鉴",
      u8"典雅",
      u8"典雅无华",
      u8"兹事体大",
      u8"兹将",
      u8"兹有",
      u8"兹洛夫",
      u8"兹罗提",
      u8"养上",
      u8"养下来",
      u8"养不起",
      u8"养乐多",
      u8"养了",
      u8"养亲",
      u8"养人",
      u8"养伤",
      u8"养儿代老积谷防饥",
      u8"养儿备老",
      u8"养儿待老积谷防饥",
      u8"养儿防老",
      u8"养儿防老积谷防饥",
      u8"养兔场",
      u8"养兵",
      u8"养兵之道",
      u8"养兵千日",
      u8"养兵千日用兵一时",
      u8"养兵千日用在一朝",
      u8"养养",
      u8"养军千日",
      u8"养军千日用军一时",
      u8"养军千日用在一时",
      u8"养军千日用在一朝",
      u8"养分",
      u8"养呢",
      u8"养地",
      u8"养地作物",
      u8"养大",
      u8"养女",
      u8"养女不教如养猪",
      u8"养女杳然",
      u8"养威蓄锐",
      u8"养媳",
      u8"养媳妇",
      u8"养子",
      u8"养子防老积谷防饥",
      u8"养家",
      u8"养家活口",
      u8"养家糊口",
      u8"养家费",
      u8"养尊处优",
      u8"养廉",
      u8"养得",
      u8"养心",
      u8"养心殿",
      u8"养志",
      u8"养性",
      u8"养息",
      u8"养成",
      u8"养成教育",
      u8"养成类",
      u8"养我",
      u8"养护",
      u8"养护中心",
      u8"养护段",
      u8"养护费",
      u8"养料",
      u8"养晦",
      u8"养晦韬光",
      u8"养殖",
      u8"养殖业",
      u8"养殖厂",
      u8"养殖场",
      u8"养殖户",
      u8"养殖池",
      u8"养殖网",
      u8"养殖面积",
      u8"养母",
      u8"养气",
      u8"养汉",
      u8"养活",
      u8"养父",
      u8"养父母",
      u8"养牛",
      u8"养牛业",
      u8"养牛场",
      u8"养狐",
      u8"养狐场",
      u8"养猪",
      u8"养猪业",
      u8"养猪人",
      u8"养猪厂",
      u8"养猪场",
      u8"养猪户",
      u8"养猪村",
      u8"养猫",
      u8"养珠",
      u8"养生",
      u8"养生丧死",
      u8"养生之道",
      u8"养生堂",
      u8"养生茶",
      u8"养生送死",
      u8"养生送终",
      u8"养病",
      u8"养痈成患",
      u8"养痈贴患",
      u8"养痈贻患",
      u8"养痈遗患",
      u8"养痛畜疽",
      u8"养痛贻害",
      u8"养目镜",
      u8"养眼",
      u8"养着",
      u8"养神",
      u8"养禽",
      u8"养精畜锐",
      u8"养精蓄锐",
      u8"养老",
      u8"养老保险",
      u8"养老保险金",
      u8"养老送终",
      u8"养老金",
      u8"养老院",
      u8"养老险",
      u8"养而不教",
      u8"养肥",
      u8"养育",
      u8"养育之恩",
      u8"养育恩",
      u8"养育院",
      u8"养胃",
      u8"养胖",
      u8"养花",
      u8"养虎",
      u8"养虎为患",
      u8"养虎伤身",
      u8"养虎反被虎咬",
      u8"养虎留患",
      u8"养虎自啮",
      u8"养虎自残",
      u8"养虎自毙",
      u8"养虎自贻灾",
      u8"养虎自遗患",
      u8"养虎自齧",
      u8"养虎贻患",
      u8"养虎遗患",
      u8"养虎饴患",
      u8"养虫室",
      u8"养虫工厂",
      u8"养虺成蛇",
      u8"养蚕",
      u8"养蚕户",
      u8"养蜂",
      u8"养蜂业",
      u8"养蜂场",
      u8"养蟹",
      u8"养血",
      u8"养贤纳士",
      u8"养起",
      u8"养起来",
      u8"养路",
      u8"养路工",
      u8"养路费",
      u8"养身",
      u8"养身之道",
      u8"养车",
      u8"养锐蓄威",
      u8"养音九皋",
      u8"养颜",
      u8"养马岛",
      u8"养鱼",
      u8"养鱼业",
      u8"养鱼场",
      u8"养鱼池",
      u8"养鳗",
      u8"养鸟",
      u8"养鸡",
      u8"养鸡业",
      u8"养鸡场",
      u8"养鸡户",
      u8"养鸡房",
      u8"养鸭",
      u8"养鸭人家",
      u8"养鸭户",
      u8"养鹰飏去",
      u8"兼之",
      u8"兼了",
      u8"兼人之勇",
      u8"兼任",
      u8"兼任教师",
      u8"兼优",
      u8"兼修",
      u8"兼具",
      u8"兼办",
      u8"兼包并容",
      u8"兼包并畜",
      u8"兼及",
      u8"兼取",
      u8"兼听",
      u8"兼听则明",
      u8"兼听则明偏信则暗",
      u8"兼售",
      u8"兼善",
      u8"兼善天下",
      u8"兼备",
      u8"兼学",
      u8"兼官重绂",
      u8"兼容",
      u8"兼容并包",
      u8"兼容并蓄",
      u8"兼容性",
      u8"兼容机",
      u8"兼容问题",
      u8"兼差",
      u8"兼并",
      u8"兼并案",
      u8"兼并热",
      u8"兼并额",
      u8"兼弱攻昧",
      u8"兼得",
      u8"兼性厌氧菌",
      u8"兼性离子",
      u8"兼性营养",
      u8"兼收",
      u8"兼收博采",
      u8"兼收并录",
      u8"兼收并畜",
      u8"兼收并蓄",
      u8"兼收并采",
      u8"兼施",
      u8"兼旬",
      u8"兼有",
      u8"兼朱重紫",
      u8"兼权尚计",
      u8"兼权熟计",
      u8"兼毫",
      u8"兼爱",
      u8"兼爱无私",
      u8"兼理",
      u8"兼用",
      u8"兼祧",
      u8"兼程",
      u8"兼程前进",
      u8"兼程并进",
      u8"兼筹并顾",
      u8"兼管",
      u8"兼类",
      u8"兼而有之",
      u8"兼职",
      u8"兼职教师",
      u8"兼职网",
      u8"兼营",
      u8"兼营农业",
      u8"兼葭倚玉",
      u8"兼葭秋水",
      u8"兼行",
      u8"兼览博照",
      u8"兼语",
      u8"兼课",
      u8"兼通",
      u8"兼顾",
      u8"兽人",
      u8"兽人族",
      u8"兽兵",
      u8"兽力",
      u8"兽力车",
      u8"兽化",
      u8"兽医",
      u8"兽医学",
      u8"兽医局",
      u8"兽医站",
      u8"兽医系",
      u8"兽医院",
      u8"兽困则噬",
      u8"兽圈",
      u8"兽媒花",
      u8"兽心",
      u8"兽心人面",
      u8"兽性",
      u8"兽性大发",
      u8"兽栏",
      u8"兽槛",
      u8"兽欲",
      u8"兽王",
      u8"兽环",
      u8"兽皮",
      u8"兽穴",
      u8"兽穷则啮",
      u8"兽穷则齧",
      u8"兽窝",
      u8"兽类",
      u8"兽群",
      u8"兽聚鸟散",
      u8"兽脂",
      u8"兽药",
      u8"兽药厂",
      u8"兽行",
      u8"兽迒鸟迹",
      u8"兽骨",
      u8"冀东",
      u8"冀中",
      u8"冀其成长",
      u8"冀北空群",
      u8"冀南",
      u8"冀南区",
      u8"冀县",
      u8"冀图",
      u8"冀州",
      u8"冀州市",
      u8"冀晋",
      u8"冀望",
      u8"冀求",
      u8"冀蒙采纳",
      u8"冀西",
      u8"冀馆陶",
      u8"冀魏县",
      u8"冀鲁豫",
      u8"冁然而笑",
      u8"内三元",
      u8"内丘",
      u8"内丘县",
      u8"内中",
      u8"内丹",
      u8"内主",
      u8"内举不避亲",
      u8"内乘",
      u8"内乡",
      u8"内乡县",
      u8"内乱",
      u8"内乱外患",
      u8"内乱罪",
      u8"内争",
      u8"内亘",
      u8"内亲",
      u8"内人",
      u8"内传",
      u8"内伤",
      u8"内伤发热",
      u8"内估计",
      u8"内伸",
      u8"内体",
      u8"内体小泡",
      u8"内侄",
      u8"内侄女",
      u8"内侍",
      u8"内侧",
      u8"内侧前脑束",
      u8"内侧膝状体核",
      u8"内侵",
      u8"内修外攘",
      u8"内债",
      u8"内倾",
      u8"内偏",
      u8"内像素",
      u8"内兄",
      u8"内克拉通盆地",
      u8"内公切线",
      u8"内六角",
      u8"内六角扳手",
      u8"内共生",
      u8"内关",
      u8"内典",
      u8"内出",
      u8"内出血",
      u8"内分",
      u8"内分泌",
      u8"内分泌失调",
      u8"内分泌学",
      u8"内分泌系统",
      u8"内分泌细胞",
      u8"内分泌腺",
      u8"内切圆",
      u8"内切壳多糖酶",
      u8"内切核糖核酸酶",
      u8"内切核酸酶",
      u8"内切糖苷酶",
      u8"内切葡聚糖酶",
      u8"内切蛋白酶",
      u8"内切蛋白酶解",
      u8"内制",
      u8"内力",
      u8"内功",
      u8"内务",
      u8"内务府",
      u8"内务条令",
      u8"内务柜",
      u8"内务部",
      u8"内助",
      u8"内助之贤",
      u8"内勤",
      u8"内勤人员",
      u8"内包",
      u8"内化",
      u8"内半缩醛",
      u8"内华达",
      u8"内华达州",
      u8"内卡钳",
      u8"内卷",
      u8"内厅",
      u8"内参",
      u8"内反射谱学",
      u8"内变",
      u8"内史",
      u8"内司委",
      u8"内向",
      u8"内向人格者",
      u8"内向型",
      u8"内向电流",
      u8"内含",
      u8"内含子",
      u8"内吸杀虫剂",
      u8"内啡肽",
      u8"内囊",
      u8"内因",
      u8"内园",
      u8"内固醇",
      u8"内圆",
      u8"内圆外方",
      u8"内圈",
      u8"内圣外王",
      u8"内在",
      u8"内在化",
      u8"内在性",
      u8"内在激励",
      u8"内在美",
      u8"内在联系",
      u8"内在论",
      u8"内地",
      u8"内地人",
      u8"内地工业",
      u8"内地版",
      u8"内地税",
      u8"内场",
      u8"内坜",
      u8"内城",
      u8"内埔",
      u8"内塔尼亚胡",
      u8"内墙",
      u8"内墙漆",
      u8"内墙砖",
      u8"内壁",
      u8"内处理",
      u8"内外",
      u8"内外交困",
      u8"内外勾结",
      u8"内外呼应",
      u8"内外墙",
      u8"内外夹击",
      u8"内外夹功",
      u8"内外夹攻",
      u8"内外并重",
      u8"内外援",
      u8"内外有别",
      u8"内外生菌根",
      u8"内外线",
      u8"内外资",
      u8"内外跤困",
      u8"内外部",
      u8"内外销",
      u8"内奸",
      u8"内妹",
      u8"内嫂",
      u8"内子",
      u8"内存",
      u8"内存不足",
      u8"内存价格",
      u8"内存保护",
      u8"内存储器",
      u8"内存分配覆盖",
      u8"内存卡",
      u8"内存地址",
      u8"内存大小",
      u8"内存容量",
      u8"内存整理",
      u8"内存条",
      u8"内存空间",
      u8"内孙",
      u8"内学",
      u8"内宅",
      u8"内定",
      u8"内审",
      u8"内审员",
      u8"内室",
      u8"内容",
      u8"内容丰富",
      u8"内容健康",
      u8"内容分析",
      u8"内容和形式",
      u8"内容外",
      u8"内容大体相同",
      u8"内容提要",
      u8"内容摘要",
      u8"内容效度",
      u8"内容栏",
      u8"内容梗概",
      u8"内容空洞",
      u8"内容简介",
      u8"内容管理",
      u8"内宾",
      u8"内寄生",
      u8"内对口器",
      u8"内射分解",
      u8"内尔松",
      u8"内层",
      u8"内层轨道",
      u8"内屋",
      u8"内岳",
      u8"内峻外和",
      u8"内嵌",
      u8"内嵌字幕",
      u8"内嵌式",
      u8"内币",
      u8"内布拉",
      u8"内幕",
      u8"内幕消息",
      u8"内幕重重",
      u8"内平",
      u8"内应",
      u8"内应力",
      u8"内府",
      u8"内庭",
      u8"内廷",
      u8"内建",
      u8"内建函数",
      u8"内建势",
      u8"内建式",
      u8"内建诊断电路",
      u8"内引外联",
      u8"内引线焊接",
      u8"内弟",
      u8"内张力",
      u8"内弦",
      u8"内当家",
      u8"内录",
      u8"内录机",
      u8"内影像",
      u8"内径",
      u8"内微分算子",
      u8"内心",
      u8"内心世界",
      u8"内心深处",
      u8"内心独白",
      u8"内心话",
      u8"内心里",
      u8"内忧",
      u8"内忧外侮",
      u8"内忧外患",
      u8"内思",
      u8"内急",
      u8"内患",
      u8"内情",
      u8"内情不详",
      u8"内感受器",
      u8"内战",
      u8"内戮",
      u8"内扣",
      u8"内招",
      u8"内挂版",
      u8"内掌柜",
      u8"内控",
      u8"内插",
      u8"内插法",
      u8"内摩擦",
      u8"内收蛋白",
      u8"内放",
      u8"内政",
      u8"内政外交",
      u8"内政府",
      u8"内政部",
      u8"内政部长",
      u8"内文",
      u8"内斗",
      u8"内斜",
      u8"内斜嵴",
      u8"内斜视",
      u8"内斯堡",
      u8"内斯库",
      u8"内斯特",
      u8"内旋转",
      u8"内昆线",
      u8"内明",
      u8"内景",
      u8"内有",
      u8"内有效",
      u8"内服",
      u8"内服药",
      u8"内果皮",
      u8"内柔",
      u8"内柔外刚",
      u8"内查外调",
      u8"内柱",
      u8"内标",
      u8"内核",
      u8"内核模块",
      u8"内格夫",
      u8"内格罗",
      u8"内梯透镜",
      u8"内棺",
      u8"内模",
      u8"内模共振",
      u8"内毒素",
      u8"内江",
      u8"内江市",
      u8"内江街",
      u8"内河",
      u8"内河航运",
      u8"内河运输",
      u8"内沿",
      u8"内波纹管隔热管",
      u8"内流",
      u8"内流区域",
      u8"内流河",
      u8"内测",
      u8"内测号",
      u8"内海",
      u8"内海地区",
      u8"内涂层油管",
      u8"内涂层钻杆",
      u8"内消旋化合物",
      u8"内涝",
      u8"内涵",
      u8"内涵式",
      u8"内港",
      u8"内湖",
      u8"内湖区",
      u8"内湖国中",
      u8"内湖国小",
      u8"内源",
      u8"内源性",
      u8"内热",
      u8"内热阻",
      u8"内焰",
      u8"内燃",
      u8"内燃器",
      u8"内燃机",
      u8"内燃机车",
      u8"内犯",
      u8"内环",
      u8"内环境",
      u8"内环线",
      u8"内环路",
      u8"内瓤",
      u8"内生孢子",
      u8"内生植物",
      u8"内生菌根",
      u8"内电路",
      u8"内电阻",
      u8"内画",
      u8"内画鼻烟壶",
      u8"内疚",
      u8"内疚感",
      u8"内痔",
      u8"内皮",
      u8"内皮唾",
      u8"内皮层",
      u8"内皮素",
      u8"内皮细胞",
      u8"内盐",
      u8"内盗",
      u8"内盛",
      u8"内省",
      u8"内省不疚",
      u8"内省法",
      u8"内眷",
      u8"内眼角",
      u8"内码",
      u8"内码转换",
      u8"内磺肽",
      u8"内神通外鬼",
      u8"内禀方程",
      u8"内禀能垒",
      u8"内禀角动量",
      u8"内秀",
      u8"内科",
      u8"内科主任",
      u8"内科医生",
      u8"内科学",
      u8"内科手术",
      u8"内科病人",
      u8"内科病房",
      u8"内积",
      u8"内窥镜",
      u8"内篇",
      u8"内紧外松",
      u8"内线",
      u8"内线交易",
      u8"内经",
      u8"内维尔",
      u8"内网",
      u8"内网资源",
      u8"内罗华",
      u8"内罗毕",
      u8"内置",
      u8"内置在",
      u8"内置式",
      u8"内翻性导管乳头状瘤",
      u8"内耗",
      u8"内耳",
      u8"内联",
      u8"内联升",
      u8"内联外引",
      u8"内联系",
      u8"内联蛋白",
      u8"内聚力",
      u8"内聚性",
      u8"内肽酶",
      u8"内胆",
      u8"内胎",
      u8"内能",
      u8"内脂",
      u8"内脏",
      u8"内脏器官",
      u8"内膜",
      u8"内膜系统",
      u8"内膜编织袋",
      u8"内膝体",
      u8"内臣",
      u8"内至",
      u8"内舱",
      u8"内营力",
      u8"内蒙",
      u8"内蒙古",
      u8"内蒙古自",
      u8"内蒙古自治区",
      u8"内蕴",
      u8"内藏",
      u8"内融合",
      u8"内螺纹",
      u8"内行",
      u8"内行人",
      u8"内行星",
      u8"内行话",
      u8"内衣",
      u8"内衣厂",
      u8"内衣展",
      u8"内衣店",
      u8"内衣模特",
      u8"内衣秀",
      u8"内衣网",
      u8"内衣裤",
      u8"内表面换热系数",
      u8"内衬",
      u8"内装",
      u8"内裙",
      u8"内裤",
      u8"内视反听",
      u8"内角",
      u8"内角球",
      u8"内讧",
      u8"内设",
      u8"内证",
      u8"内话",
      u8"内详",
      u8"内调",
      u8"内质",
      u8"内质体",
      u8"内质网",
      u8"内贸",
      u8"内贸局",
      u8"内贸部",
      u8"内贼",
      u8"内贾德",
      u8"内资",
      u8"内资股",
      u8"内转",
      u8"内转换",
      u8"内转载",
      u8"内边",
      u8"内迁",
      u8"内过渡元素",
      u8"内道",
      u8"内部",
      u8"内部事务",
      u8"内部人员",
      u8"内部会计",
      u8"内部刊物",
      u8"内部化",
      u8"内部单位",
      u8"内部发展理论",
      u8"内部噪声",
      u8"内部寄存器",
      u8"内部活动",
      u8"内部测试",
      u8"内部消息",
      u8"内部监督",
      u8"内部矛盾",
      u8"内部空间",
      u8"内部管理",
      u8"内部结构",
      u8"内部网",
      u8"内部联系",
      u8"内部联网",
      u8"内部自分泌",
      u8"内部表征",
      u8"内部表象",
      u8"内部言语",
      u8"内部资料",
      u8"内酯",
      u8"内酰胺",
      u8"内釉上皮",
      u8"内里",
      u8"内里费",
      u8"内野",
      u8"内野区",
      u8"内野手",
      u8"内量子效率",
      u8"内铺",
      u8"内销",
      u8"内销品",
      u8"内销货",
      u8"内错角",
      u8"内门",
      u8"内阁",
      u8"内阁会议",
      u8"内阁制",
      u8"内阁大臣",
      u8"内阁总理",
      u8"内防",
      u8"内阻",
      u8"内陆",
      u8"内陆国",
      u8"内陆地区",
      u8"内陆河",
      u8"内陆海",
      u8"内陆湖",
      u8"内降",
      u8"内院",
      u8"内陷",
      u8"内隐记忆",
      u8"内隔",
      u8"内障",
      u8"内难",
      u8"内需",
      u8"内面",
      u8"内页",
      u8"内项",
      u8"内顾之忧",
      u8"内颖",
      u8"内食",
      u8"内饰件",
      u8"内骨骼",
      u8"内鬼",
      u8"内黄",
      u8"内黄县",
      u8"内龙模型",
      u8"内龙骨",
      u8"冈山",
      u8"冈山镇",
      u8"冈峦",
      u8"冈峦起伏",
      u8"冈崎片段",
      u8"冈底斯",
      u8"冈底斯冈",
      u8"冈底斯冈石",
      u8"冈比亚",
      u8"冈琦",
      u8"冈田",
      u8"冈石",
      u8"冈萨雷斯",
      u8"冈陵",
      u8"冈陵起伏",
      u8"冉冉",
      u8"冉冉上升",
      u8"冉冉不绝",
      u8"冉冉升起",
      u8"册亨",
      u8"册亨县",
      u8"册叶",
      u8"册子",
      u8"册封",
      u8"册数",
      u8"册文",
      u8"册立",
      u8"册页",
      u8"再一",
      u8"再一次",
      u8"再三",
      u8"再三再四",
      u8"再上",
      u8"再上去",
      u8"再上来",
      u8"再下",
      u8"再下去",
      u8"再下来",
      u8"再不",
      u8"再不其然",
      u8"再不到",
      u8"再不去",
      u8"再不是",
      u8"再不来",
      u8"再不然",
      u8"再不能",
      u8"再与",
      u8"再世",
      u8"再为",
      u8"再也",
      u8"再也不",
      u8"再也不会",
      u8"再也不是",
      u8"再也不肯",
      u8"再也不能",
      u8"再也没有",
      u8"再于",
      u8"再交",
      u8"再从",
      u8"再以",
      u8"再会",
      u8"再传",
      u8"再低",
      u8"再作冯妇",
      u8"再作道理",
      u8"再依",
      u8"再侵染",
      u8"再侵染源",
      u8"再保险",
      u8"再倒",
      u8"再借",
      u8"再借不难",
      u8"再假定",
      u8"再做",
      u8"再做冯妇",
      u8"再做道理",
      u8"再像",
      u8"再入",
      u8"再其次",
      u8"再再",
      u8"再写",
      u8"再凭",
      u8"再出",
      u8"再出去",
      u8"再出来",
      u8"再分",
      u8"再分配",
      u8"再则",
      u8"再创",
      u8"再创新高",
      u8"再创造",
      u8"再利用",
      u8"再别",
      u8"再别康桥",
      u8"再到",
      u8"再制品",
      u8"再制盐",
      u8"再刻",
      u8"再剪",
      u8"再割",
      u8"再办",
      u8"再加",
      u8"再加上",
      u8"再加之",
      u8"再压",
      u8"再压缩",
      u8"再去",
      u8"再发",
      u8"再取",
      u8"再向",
      u8"再听",
      u8"再咬",
      u8"再唱",
      u8"再回",
      u8"再回到",
      u8"再回去",
      u8"再回来",
      u8"再回首",
      u8"再在",
      u8"再多",
      u8"再大",
      u8"再好",
      u8"再好不过",
      u8"再好也不过",
      u8"再好没有",
      u8"再如",
      u8"再娶",
      u8"再婚",
      u8"再婚者",
      u8"再嫁",
      u8"再嫁夫人",
      u8"再孕妇",
      u8"再学",
      u8"再定",
      u8"再实之根必伤",
      u8"再审",
      u8"再审申请书",
      u8"再寄",
      u8"再将",
      u8"再就业",
      u8"再就业率",
      u8"再就是",
      u8"再工程",
      u8"再帖",
      u8"再带",
      u8"再平",
      u8"再度",
      u8"再延",
      u8"再往",
      u8"再循环",
      u8"再忙",
      u8"再快",
      u8"再想",
      u8"再慢",
      u8"再打",
      u8"再找",
      u8"再把",
      u8"再押",
      u8"再拉",
      u8"再拜",
      u8"再按",
      u8"再挤",
      u8"再捡",
      u8"再接",
      u8"再接再励",
      u8"再接再历",
      u8"再接再厉",
      u8"再接再砺",
      u8"再搬",
      u8"再摇",
      u8"再放",
      u8"再教育",
      u8"再断言",
      u8"再无",
      u8"再有",
      u8"再杀",
      u8"再来",
      u8"再来一个",
      u8"再查",
      u8"再植",
      u8"再次",
      u8"再次出现",
      u8"再次发生",
      u8"再没",
      u8"再没有",
      u8"再测信度",
      u8"再混",
      u8"再混合物",
      u8"再满",
      u8"再演",
      u8"再煎",
      u8"再燃",
      u8"再版",
      u8"再版书",
      u8"再犯",
      u8"再现",
      u8"再现部",
      u8"再生",
      u8"再生之恩",
      u8"再生产",
      u8"再生侠",
      u8"再生制动",
      u8"再生接收机",
      u8"再生父母",
      u8"再生纸",
      u8"再生缘",
      u8"再生胶",
      u8"再生能源",
      u8"再生资源",
      u8"再生障碍性贫血",
      u8"再用",
      u8"再由",
      u8"再看",
      u8"再种",
      u8"再租",
      u8"再移",
      u8"再立",
      u8"再立新功",
      u8"再笑",
      u8"再等",
      u8"再答",
      u8"再经",
      u8"再结晶",
      u8"再续",
      u8"再者",
      u8"再者说",
      u8"再而三",
      u8"再聊",
      u8"再聚合",
      u8"再肯定",
      u8"再获",
      u8"再融资",
      u8"再行",
      u8"再补",
      u8"再衰三涸",
      u8"再衰三竭",
      u8"再被",
      u8"再要",
      u8"再见",
      u8"再见面",
      u8"再触",
      u8"再认",
      u8"再认广度",
      u8"再讨",
      u8"再让",
      u8"再议",
      u8"再记",
      u8"再讲",
      u8"再试",
      u8"再试一下",
      u8"再试一次",
      u8"再说",
      u8"再说下去",
      u8"再请",
      u8"再读",
      u8"再调整",
      u8"再谈",
      u8"再谢",
      u8"再败",
      u8"再贴现",
      u8"再赌",
      u8"再赔",
      u8"再赢",
      u8"再走",
      u8"再起",
      u8"再起来",
      u8"再起波澜",
      u8"再跟",
      u8"再过",
      u8"再过去",
      u8"再过来",
      u8"再运",
      u8"再运行",
      u8"再进",
      u8"再进去",
      u8"再进来",
      u8"再远",
      u8"再逃",
      u8"再选",
      u8"再造",
      u8"再造之恩",
      u8"再造想象",
      u8"再造术",
      u8"再遇",
      u8"再那里呢",
      u8"再配",
      u8"再醮",
      u8"再问",
      u8"再防雨",
      u8"再降",
      u8"再陪",
      u8"再障",
      u8"再骑",
      u8"再高",
      u8"冒上",
      u8"冒上去",
      u8"冒上来",
      u8"冒了",
      u8"冒假",
      u8"冒傻气",
      u8"冒充",
      u8"冒充货",
      u8"冒冒",
      u8"冒冒失失",
      u8"冒冒险",
      u8"冒出",
      u8"冒出来",
      u8"冒功",
      u8"冒升",
      u8"冒口",
      u8"冒号",
      u8"冒名",
      u8"冒名接脚",
      u8"冒名顶替",
      u8"冒名顶替者",
      u8"冒地斜棱柱体",
      u8"冒大不韪",
      u8"冒天下之大不韪",
      u8"冒失",
      u8"冒失鬼",
      u8"冒头",
      u8"冒尖",
      u8"冒尖户",
      u8"冒往",
      u8"冒得",
      u8"冒昧",
      u8"冒死",
      u8"冒气",
      u8"冒汗",
      u8"冒泡",
      u8"冒渎",
      u8"冒火",
      u8"冒烟",
      u8"冒然",
      u8"冒牌",
      u8"冒牌货",
      u8"冒犯",
      u8"冒犯之处",
      u8"冒用",
      u8"冒着",
      u8"冒着危险",
      u8"冒称",
      u8"冒血",
      u8"冒认",
      u8"冒贷",
      u8"冒贷案",
      u8"冒起",
      u8"冒起来",
      u8"冒进",
      u8"冒里冒失",
      u8"冒险",
      u8"冒险主义",
      u8"冒险家",
      u8"冒险岛",
      u8"冒险性",
      u8"冒险游戏",
      u8"冒险犯难",
      u8"冒险王",
      u8"冒险篇",
      u8"冒险类",
      u8"冒险者",
      u8"冒险蛮干",
      u8"冒险记",
      u8"冒雨",
      u8"冒雪",
      u8"冒顶",
      u8"冒领",
      u8"冒风险",
      u8"冕宁",
      u8"冕宁县",
      u8"冕旒",
      u8"冕服",
      u8"冕牌玻璃",
      u8"冗位",
      u8"冗余",
      u8"冗余参数",
      u8"冗余度",
      u8"冗余技术",
      u8"冗务",
      u8"冗员",
      u8"冗官",
      u8"冗数",
      u8"冗杂",
      u8"冗笔",
      u8"冗繁",
      u8"冗职",
      u8"冗肿",
      u8"冗言",
      u8"冗词",
      u8"冗词赘句",
      u8"冗语",
      u8"冗费",
      u8"冗赘",
      u8"冗长",
      u8"写上",
      u8"写上去",
      u8"写上来",
      u8"写下",
      u8"写下去",
      u8"写下来",
      u8"写东西",
      u8"写个",
      u8"写书",
      u8"写了",
      u8"写些",
      u8"写他",
      u8"写作",
      u8"写作学",
      u8"写作家",
      u8"写作技巧",
      u8"写作提纲",
      u8"写作文",
      u8"写作方法",
      u8"写作水平",
      u8"写作班",
      u8"写作知识",
      u8"写作网",
      u8"写作能力",
      u8"写保护",
      u8"写信",
      u8"写信人",
      u8"写信给",
      u8"写做",
      u8"写入",
      u8"写全",
      u8"写写",
      u8"写写字",
      u8"写出",
      u8"写出去",
      u8"写出来",
      u8"写到",
      u8"写卡器",
      u8"写去",
      u8"写回",
      u8"写回去",
      u8"写回来",
      u8"写在",
      u8"写在下方",
      u8"写好",
      u8"写字",
      u8"写字台",
      u8"写字板",
      u8"写字枱",
      u8"写字楼",
      u8"写字间",
      u8"写完",
      u8"写实",
      u8"写实主义",
      u8"写实派",
      u8"写实片",
      u8"写封信",
      u8"写就",
      u8"写序言",
      u8"写得",
      u8"写意",
      u8"写意画",
      u8"写成",
      u8"写成标志",
      u8"写手",
      u8"写数据线",
      u8"写文章",
      u8"写日记",
      u8"写明",
      u8"写景",
      u8"写景文",
      u8"写有",
      u8"写本",
      u8"写来",
      u8"写来写去",
      u8"写歌",
      u8"写毛笔字",
      u8"写法",
      u8"写清",
      u8"写点",
      u8"写照",
      u8"写照啊",
      u8"写生",
      u8"写生画",
      u8"写盘",
      u8"写真",
      u8"写真机",
      u8"写真照",
      u8"写真片",
      u8"写真级",
      u8"写真网",
      u8"写真集",
      u8"写真馆",
      u8"写着",
      u8"写稿",
      u8"写稿人",
      u8"写篇",
      u8"写给",
      u8"写访问",
      u8"写诗",
      u8"写账",
      u8"写起",
      u8"写起来",
      u8"写过",
      u8"写过信",
      u8"写过去",
      u8"写过来",
      u8"写进",
      u8"写进去",
      u8"写进来",
      u8"写道",
      u8"写错",
      u8"写错字",
      u8"军不血刃",
      u8"军中",
      u8"军中无戏言",
      u8"军临城下",
      u8"军乐",
      u8"军乐团",
      u8"军乐队",
      u8"军书",
      u8"军事",
      u8"军事上",
      u8"军事优势",
      u8"军事体育",
      u8"军事冲突",
      u8"军事力量",
      u8"军事动态",
      u8"军事化",
      u8"军事区",
      u8"军事医学",
      u8"军事合作",
      u8"军事同盟",
      u8"军事图片",
      u8"军事地理",
      u8"军事基地",
      u8"军事天地",
      u8"军事委员",
      u8"军事委员会",
      u8"军事学",
      u8"军事学校",
      u8"军事学院",
      u8"军事实力",
      u8"军事家",
      u8"军事小说",
      u8"军事工业",
      u8"军事志",
      u8"军事思想",
      u8"军事情报",
      u8"军事战略",
      u8"军事手段",
      u8"军事技术",
      u8"军事挑衅",
      u8"军事援助",
      u8"军事政变",
      u8"军事新闻",
      u8"军事机关",
      u8"军事机密",
      u8"军事法庭",
      u8"军事法院",
      u8"军事演习",
      u8"军事理论",
      u8"军事目标",
      u8"军事科学",
      u8"军事科学院",
      u8"军事管制",
      u8"军事素质",
      u8"军事网",
      u8"军事行动",
      u8"军事装备",
      u8"军事计划",
      u8"军事训练",
      u8"军事论坛",
      u8"军事设施",
      u8"军事路线",
      u8"军事运输",
      u8"军事部长",
      u8"军事院校",
      u8"军事顾问",
      u8"军人",
      u8"军人专政",
      u8"军人家庭",
      u8"军代处",
      u8"军代表",
      u8"军令",
      u8"军令如山",
      u8"军令状",
      u8"军令部",
      u8"军伍",
      u8"军体",
      u8"军体拳",
      u8"军公教",
      u8"军公教子",
      u8"军公教子女",
      u8"军兵种",
      u8"军内",
      u8"军刀",
      u8"军分区",
      u8"军列",
      u8"军制",
      u8"军制史",
      u8"军制学",
      u8"军力",
      u8"军办",
      u8"军功",
      u8"军功章",
      u8"军务",
      u8"军务院",
      u8"军区",
      u8"军区某",
      u8"军医",
      u8"军医大",
      u8"军医大学",
      u8"军医学院",
      u8"军医治",
      u8"军口",
      u8"军史",
      u8"军史馆",
      u8"军号",
      u8"军命",
      u8"军品",
      u8"军品店",
      u8"军售",
      u8"军器",
      u8"军团",
      u8"军团菌",
      u8"军团菌属",
      u8"军团长",
      u8"军国",
      u8"军国主义",
      u8"军国主义者",
      u8"军国大事",
      u8"军地",
      u8"军地两用人材",
      u8"军垦",
      u8"军士",
      u8"军士长",
      u8"军备",
      u8"军备品",
      u8"军备竞赛",
      u8"军大衣",
      u8"军委",
      u8"军委主席",
      u8"军委各总部",
      u8"军姿",
      u8"军威",
      u8"军婚",
      u8"军嫂",
      u8"军字号",
      u8"军官",
      u8"军官团",
      u8"军官学校",
      u8"军官证",
      u8"军容",
      u8"军容严整",
      u8"军容风纪",
      u8"军属",
      u8"军屯",
      u8"军屯村",
      u8"军工",
      u8"军工企业",
      u8"军工厂",
      u8"军工路",
      u8"军师",
      u8"军师职",
      u8"军帐",
      u8"军帖",
      u8"军帽",
      u8"军律",
      u8"军徽",
      u8"军心",
      u8"军心涣散",
      u8"军总",
      u8"军情",
      u8"军户",
      u8"军控",
      u8"军援",
      u8"军操",
      u8"军政",
      u8"军政人员",
      u8"军政大学",
      u8"军政府",
      u8"军政当局",
      u8"军政时期",
      u8"军政权",
      u8"军方",
      u8"军旅",
      u8"军旗",
      u8"军旗装",
      u8"军服",
      u8"军机",
      u8"军机处",
      u8"军机大臣",
      u8"军权",
      u8"军校",
      u8"军校生",
      u8"军械",
      u8"军械员",
      u8"军械士",
      u8"军械处",
      u8"军械库",
      u8"军棋",
      u8"军歌",
      u8"军毯",
      u8"军民",
      u8"军民一家",
      u8"军民一致",
      u8"军民共建",
      u8"军民共建点",
      u8"军民关系",
      u8"军民合作",
      u8"军民品",
      u8"军民团结",
      u8"军民结合",
      u8"军民联欢",
      u8"军民联防",
      u8"军民鱼水深情",
      u8"军油",
      u8"军法",
      u8"军法从事",
      u8"军法官",
      u8"军法审判",
      u8"军港",
      u8"军火",
      u8"军火交易",
      u8"军火商",
      u8"军火库",
      u8"军火贩子",
      u8"军烈属",
      u8"军犬",
      u8"军用",
      u8"军用品",
      u8"军用机",
      u8"军用机场",
      u8"军用桥",
      u8"军用物资",
      u8"军用犬",
      u8"军用电话",
      u8"军用车",
      u8"军用车辆",
      u8"军用飞机",
      u8"军界",
      u8"军略",
      u8"军眷",
      u8"军礼",
      u8"军神",
      u8"军种",
      u8"军管",
      u8"军管会",
      u8"军管区",
      u8"军籍",
      u8"军粮",
      u8"军纪",
      u8"军统",
      u8"军统局",
      u8"军职",
      u8"军职人员",
      u8"军舰",
      u8"军舰鸟",
      u8"军船",
      u8"军艺",
      u8"军营",
      u8"军营区",
      u8"军衔",
      u8"军衔制",
      u8"军衣",
      u8"军装",
      u8"军规",
      u8"军警",
      u8"军警民",
      u8"军警靴",
      u8"军训",
      u8"军训教官",
      u8"军训课",
      u8"军语",
      u8"军调部",
      u8"军谘府",
      u8"军购案",
      u8"军费",
      u8"军费开支",
      u8"军资",
      u8"军路",
      u8"军车",
      u8"军转",
      u8"军转办",
      u8"军转民",
      u8"军邮",
      u8"军部",
      u8"军长",
      u8"军闻社",
      u8"军阀",
      u8"军阀主义",
      u8"军阀作风",
      u8"军阀割据",
      u8"军阀统治",
      u8"军队",
      u8"军队干部",
      u8"军队建设",
      u8"军队院校",
      u8"军阶",
      u8"军需",
      u8"军需品",
      u8"军需官",
      u8"军需补给",
      u8"军靴",
      u8"军鞋",
      u8"军风",
      u8"军风纪",
      u8"军饷",
      u8"军马",
      u8"军魂",
      u8"军鸽",
      u8"军鼓",
      u8"军龄",
      u8"农一师",
      u8"农专",
      u8"农业",
      u8"农业专科",
      u8"农业专科学校",
      u8"农业中学",
      u8"农业丰收",
      u8"农业为基础",
      u8"农业产业",
      u8"农业人口",
      u8"农业信息系统",
      u8"农业党",
      u8"农业再上新台阶",
      u8"农业凋零",
      u8"农业劳动",
      u8"农业化",
      u8"农业化学",
      u8"农业区",
      u8"农业区位论",
      u8"农业区划",
      u8"农业半机械化",
      u8"农业厅",
      u8"农业发展银行",
      u8"农业合作",
      u8"农业合作化",
      u8"农业品",
      u8"农业国",
      u8"农业土壤",
      u8"农业土壤学",
      u8"农业土壤水分特性",
      u8"农业地域类型",
      u8"农业地带",
      u8"农业地理",
      u8"农业地理学",
      u8"农业大学",
      u8"农业学大",
      u8"农业学大寨",
      u8"农业学校",
      u8"农业小气候",
      u8"农业局",
      u8"农业工人",
      u8"农业工程",
      u8"农业布局",
      u8"农业总产",
      u8"农业总产值",
      u8"农业户口",
      u8"农业技术",
      u8"农业技术推广",
      u8"农业投入",
      u8"农业改革",
      u8"农业政策",
      u8"农业机器",
      u8"农业机器系统",
      u8"农业机械",
      u8"农业机械化",
      u8"农业机械化规划",
      u8"农业村镇",
      u8"农业植物学",
      u8"农业气候",
      u8"农业气候区划",
      u8"农业气候志",
      u8"农业气候相似原理",
      u8"农业气候评价",
      u8"农业气候调查",
      u8"农业气象学",
      u8"农业气象年报",
      u8"农业气象情报",
      u8"农业气象旬报",
      u8"农业气象模拟",
      u8"农业气象站",
      u8"农业法",
      u8"农业环境保护",
      u8"农业现代化",
      u8"农业生产",
      u8"农业生产合作社",
      u8"农业生产建筑",
      u8"农业生产资料",
      u8"农业生态技术",
      u8"农业生态系统",
      u8"农业生物环境工程",
      u8"农业用地",
      u8"农业电气化",
      u8"农业知识",
      u8"农业社",
      u8"农业社会",
      u8"农业科学",
      u8"农业科技",
      u8"农业科研",
      u8"农业税",
      u8"农业系统工程",
      u8"农业系统模型",
      u8"农业经济",
      u8"农业统计学",
      u8"农业网",
      u8"农业职业",
      u8"农业职业学校",
      u8"农业装备",
      u8"农业试验",
      u8"农业贷款",
      u8"农业资本",
      u8"农业资本家",
      u8"农业遥感",
      u8"农业部",
      u8"农业部部长",
      u8"农业部长",
      u8"农业部门",
      u8"农业银行",
      u8"农业院校",
      u8"农业集体",
      u8"农业集体化",
      u8"农中",
      u8"农丰",
      u8"农丰里",
      u8"农乡",
      u8"农事",
      u8"农二师",
      u8"农交会",
      u8"农产",
      u8"农产品",
      u8"农产品产量",
      u8"农产品收",
      u8"农产品收购",
      u8"农产品收购价格",
      u8"农产品经纪人",
      u8"农产物",
      u8"农产量",
      u8"农人",
      u8"农仓",
      u8"农会",
      u8"农作",
      u8"农作曲",
      u8"农作机",
      u8"农作物",
      u8"农信社",
      u8"农具",
      u8"农具厂",
      u8"农函大",
      u8"农副",
      u8"农副业",
      u8"农副产品",
      u8"农办",
      u8"农务",
      u8"农化",
      u8"农化系",
      u8"农区",
      u8"农协",
      u8"农博会",
      u8"农博网",
      u8"农历",
      u8"农历年",
      u8"农友",
      u8"农发行",
      u8"农口",
      u8"农吉利",
      u8"农吉利总碱",
      u8"农器",
      u8"农园",
      u8"农地",
      u8"农地重划",
      u8"农场",
      u8"农场主",
      u8"农场农村",
      u8"农场地",
      u8"农场管理",
      u8"农垦",
      u8"农垦局",
      u8"农垦工作",
      u8"农垦经济",
      u8"农垦部",
      u8"农复会",
      u8"农大",
      u8"农夫",
      u8"农奴",
      u8"农奴主",
      u8"农奴制",
      u8"农奴制度",
      u8"农奴阶级",
      u8"农妇",
      u8"农委",
      u8"农委会",
      u8"农学",
      u8"农学会",
      u8"农学家",
      u8"农学系",
      u8"农学院",
      u8"农安",
      u8"农安县",
      u8"农官",
      u8"农家",
      u8"农家乐",
      u8"农家品种",
      u8"农家女",
      u8"农家娃",
      u8"农家子弟",
      u8"农家宝",
      u8"农家肥",
      u8"农家肥料",
      u8"农家菜",
      u8"农家院",
      u8"农家饭",
      u8"农展馆",
      u8"农工",
      u8"农工党",
      u8"农工商",
      u8"农工委",
      u8"农工民主党",
      u8"农工职业",
      u8"农工职业学校",
      u8"农工贸",
      u8"农工部",
      u8"农庄",
      u8"农忙",
      u8"农忙时节",
      u8"农户",
      u8"农技",
      u8"农技协",
      u8"农技员",
      u8"农技团",
      u8"农技站",
      u8"农政",
      u8"农救会",
      u8"农时",
      u8"农机",
      u8"农机具",
      u8"农机化",
      u8"农机厂",
      u8"农机员",
      u8"农机局",
      u8"农机手",
      u8"农机更新",
      u8"农机站",
      u8"农机系",
      u8"农机配件",
      u8"农杆氨酸",
      u8"农杆糖酯",
      u8"农杆素",
      u8"农杆菌感染",
      u8"农杆菌素",
      u8"农杆鸟氨酸",
      u8"农村",
      u8"农村人口",
      u8"农村人民",
      u8"农村人民公社",
      u8"农村信用",
      u8"农村信用合作社",
      u8"农村信用社",
      u8"农村党员",
      u8"农村公社",
      u8"农村公路",
      u8"农村包围城市",
      u8"农村化",
      u8"农村卫生",
      u8"农村发展研究中心",
      u8"农村土地",
      u8"农村地区",
      u8"农村基层",
      u8"农村妇女",
      u8"农村孩子",
      u8"农村居民",
      u8"农村工作",
      u8"农村市场",
      u8"农村干部",
      u8"农村建设",
      u8"农村户口",
      u8"农村改革",
      u8"农村政策",
      u8"农村教师",
      u8"农村教育",
      u8"农村片",
      u8"农村环境",
      u8"农村生活",
      u8"农村用电",
      u8"农村税费",
      u8"农村经济",
      u8"农村调查",
      u8"农村金融",
      u8"农村面貌",
      u8"农林",
      u8"农林厅",
      u8"农林厅长",
      u8"农林局",
      u8"农林牧",
      u8"农林牧副",
      u8"农林牧副渔",
      u8"农林牧渔",
      u8"农林部",
      u8"农校",
      u8"农桑",
      u8"农械",
      u8"农民",
      u8"农民之友",
      u8"农民企业家",
      u8"农民党",
      u8"农民协会",
      u8"农民工",
      u8"农民战争",
      u8"农民房",
      u8"农民技术员",
      u8"农民收入",
      u8"农民日报",
      u8"农民画",
      u8"农民群众",
      u8"农民负担",
      u8"农民起义",
      u8"农民运动会",
      u8"农民银行",
      u8"农民阶级",
      u8"农民革命",
      u8"农水",
      u8"农活",
      u8"农渠",
      u8"农牧",
      u8"农牧业",
      u8"农牧区",
      u8"农牧厅",
      u8"农牧场",
      u8"农牧局",
      u8"农牧林",
      u8"农牧民",
      u8"农牧渔业",
      u8"农牧渔业部",
      u8"农牧结合",
      u8"农用",
      u8"农用地",
      u8"农用智能仪表",
      u8"农用物资",
      u8"农用车",
      u8"农田",
      u8"农田基本",
      u8"农田基本建设",
      u8"农田小气",
      u8"农田小气候",
      u8"农田水利",
      u8"农田灌溉",
      u8"农田生态系统",
      u8"农电",
      u8"农电局",
      u8"农电工",
      u8"农电站",
      u8"农畜",
      u8"农畜产品",
      u8"农神",
      u8"农科",
      u8"农科大",
      u8"农科所",
      u8"农科技术",
      u8"农科教",
      u8"农科院",
      u8"农税",
      u8"农经",
      u8"农经站",
      u8"农经系",
      u8"农经网",
      u8"农耕",
      u8"农耕机",
      u8"农耕社会",
      u8"农耕队",
      u8"农胞",
      u8"农膜",
      u8"农舍",
      u8"农艺",
      u8"农艺学",
      u8"农艺师",
      u8"农艺系",
      u8"农艺馆",
      u8"农药",
      u8"农药厂",
      u8"农药商",
      u8"农药污染",
      u8"农行",
      u8"农试所",
      u8"农话",
      u8"农谚",
      u8"农负",
      u8"农贷",
      u8"农贸",
      u8"农贸市场",
      u8"农资",
      u8"农转非",
      u8"农运",
      u8"农运会",
      u8"农闲",
      u8"农隙",
      u8"农鞋",
      u8"农高会",
      u8"冠上加冠",
      u8"冠上履下",
      u8"冠丰华",
      u8"冠亚",
      u8"冠亚军",
      u8"冠亚军决赛",
      u8"冠以",
      u8"冠内固位",
      u8"冠内固位体",
      u8"冠冕",
      u8"冠冕堂皇",
      u8"冠军",
      u8"冠军杯",
      u8"冠军级",
      u8"冠军联赛",
      u8"冠军赛",
      u8"冠军足球",
      u8"冠县",
      u8"冠名",
      u8"冠名权",
      u8"冠名者",
      u8"冠向复位瓣",
      u8"冠周炎",
      u8"冠城队",
      u8"冠外固位",
      u8"冠多发乱",
      u8"冠子",
      u8"冠履",
      u8"冠履倒易",
      u8"冠履倒置",
      u8"冠屦倒施",
      u8"冠山戴粒",
      u8"冠帽",
      u8"冠心病",
      u8"冠振海",
      u8"冠接",
      u8"冠桥学",
      u8"冠毛",
      u8"冠状",
      u8"冠状动脉",
      u8"冠状沟",
      u8"冠状病毒",
      u8"冠玉",
      u8"冠王",
      u8"冠生园",
      u8"冠瘿",
      u8"冠瘿氨基酸",
      u8"冠瘿瘤",
      u8"冠盖",
      u8"冠盖云集",
      u8"冠盖如云",
      u8"冠盖相望",
      u8"冠礼",
      u8"冠绝",
      u8"冠绝一时",
      u8"冠绝群芳",
      u8"冠群",
      u8"冠蛋白",
      u8"冠袍带履",
      u8"冠词",
      u8"冠醚",
      u8"冠鸡",
      u8"冢中枯骨",
      u8"冢木已拱",
      u8"冤亲",
      u8"冤仇",
      u8"冤假",
      u8"冤假错案",
      u8"冤冤相报",
      u8"冤冤相报何时了",
      u8"冤各有头债各有主",
      u8"冤呀",
      u8"冤大头",
      u8"冤天冤地",
      u8"冤天屈地",
      u8"冤头",
      u8"冤孽",
      u8"冤家",
      u8"冤家债主",
      u8"冤家宜解不宜结",
      u8"冤家对头",
      u8"冤家路狭",
      u8"冤家路窄",
      u8"冤屈",
      u8"冤恨",
      u8"冤情",
      u8"冤有头",
      u8"冤有头债",
      u8"冤有头债有主",
      u8"冤枉",
      u8"冤枉路",
      u8"冤枉钱",
      u8"冤案",
      u8"冤死",
      u8"冤气",
      u8"冤沉海底",
      u8"冤狱",
      u8"冤苦",
      u8"冤钱",
      u8"冤雠",
      u8"冤鬼",
      u8"冤鬼路",
      u8"冤魂",
      u8"冥冥",
      u8"冥冥中",
      u8"冥冥之中",
      u8"冥器",
      u8"冥夜",
      u8"冥婚",
      u8"冥寿",
      u8"冥府",
      u8"冥思",
      u8"冥思若索",
      u8"冥思苦想",
      u8"冥思苦索",
      u8"冥想",
      u8"冥报",
      u8"冥昭瞢闇",
      u8"冥晦",
      u8"冥暗",
      u8"冥河",
      u8"冥漠之乡",
      u8"冥漠之都",
      u8"冥王",
      u8"冥王星",
      u8"冥王篇",
      u8"冥纸",
      u8"冥行擿埴",
      u8"冥行盲索",
      u8"冥衣",
      u8"冥诞",
      u8"冥钞",
      u8"冥钱",
      u8"冥顽",
      u8"冥顽不化",
      u8"冥顽不灵",
      u8"冬不拉",
      u8"冬令",
      u8"冬令救济",
      u8"冬令营",
      u8"冬作物",
      u8"冬候鸟",
      u8"冬储",
      u8"冬冬",
      u8"冬凌草",
      u8"冬化",
      u8"冬去春来",
      u8"冬园",
      u8"冬夏",
      u8"冬夜",
      u8"冬天",
      u8"冬奥",
      u8"冬奥会",
      u8"冬季",
      u8"冬季世界",
      u8"冬季世界运动会",
      u8"冬季两项",
      u8"冬季奥运会",
      u8"冬季运动",
      u8"冬季运动会",
      u8"冬学",
      u8"冬宫",
      u8"冬寒",
      u8"冬寒抱冰",
      u8"冬寒抱冰夏热握火",
      u8"冬小麦",
      u8"冬常服",
      u8"冬扇夏炉",
      u8"冬播",
      u8"冬日",
      u8"冬日可爱",
      u8"冬日夏云",
      u8"冬暖",
      u8"冬暖夏凉",
      u8"冬暖式",
      u8"冬月",
      u8"冬柴",
      u8"冬梅",
      u8"冬汛",
      u8"冬油菜",
      u8"冬泳",
      u8"冬温夏清",
      u8"冬湿寒冷气候",
      u8"冬灌",
      u8"冬炼",
      u8"冬烘",
      u8"冬烘先生",
      u8"冬烘头脑",
      u8"冬瓜",
      u8"冬瓜子",
      u8"冬瓜汤",
      u8"冬瓜皮",
      u8"冬瓜茶",
      u8"冬眠",
      u8"冬眠期",
      u8"冬笋",
      u8"冬箑夏裘",
      u8"冬粉",
      u8"冬耕",
      u8"冬肥",
      u8"冬至",
      u8"冬至点",
      u8"冬至线",
      u8"冬节",
      u8"冬荫功",
      u8"冬菇",
      u8"冬菜",
      u8"冬葱",
      u8"冬葵",
      u8"冬葵子",
      u8"冬葵果",
      u8"冬藏",
      u8"冬虫夏草",
      u8"冬虫草",
      u8"冬行春令",
      u8"冬衣",
      u8"冬装",
      u8"冬裘夏葛",
      u8"冬训",
      u8"冬运",
      u8"冬运会",
      u8"冬闲",
      u8"冬防",
      u8"冬阴功",
      u8"冬雨",
      u8"冬雪",
      u8"冬雷震",
      u8"冬雾",
      u8"冬青",
      u8"冬青树",
      u8"冬风",
      u8"冬麦",
      u8"冬麦区",
      u8"冯不摧",
      u8"冯不破",
      u8"冯两努",
      u8"冯光荣",
      u8"冯友兰",
      u8"冯吉",
      u8"冯同知",
      u8"冯唐头白",
      u8"冯唐已老",
      u8"冯唐易老",
      u8"冯唐白首",
      u8"冯国",
      u8"冯国庆",
      u8"冯国强",
      u8"冯国璋",
      u8"冯坦",
      u8"冯妇",
      u8"冯威",
      u8"冯媛甄",
      u8"冯宝宝",
      u8"冯家俊",
      u8"冯家妹",
      u8"冯小刚",
      u8"冯巩",
      u8"冯德伦",
      u8"冯德培",
      u8"冯恃其众",
      u8"冯恩鹤",
      u8"冯振武",
      u8"冯文敏",
      u8"冯春哲",
      u8"冯晓泉",
      u8"冯格庄村",
      u8"冯格庄镇",
      u8"冯梦龙",
      u8"冯氏",
      u8"冯河暴虎",
      u8"冯淬帆",
      u8"冯潇霆",
      u8"冯爱慈",
      u8"冯特",
      u8"冯玉祥",
      u8"冯生弹铗",
      u8"冯福生",
      u8"冯粹发财",
      u8"冯粹帆",
      u8"冯素波",
      u8"冯虚御风",
      u8"冯衡",
      u8"冯辉",
      u8"冯辽",
      u8"冯远征",
      u8"冯锡范",
      u8"冯阿三",
      u8"冯难敌",
      u8"冯雪峰",
      u8"冯雷",
      u8"冯驩弹铗",
      u8"冯骥才",
      u8"冯默风",
      u8"冰上",
      u8"冰上表演",
      u8"冰上运动",
      u8"冰下河道",
      u8"冰乙酸",
      u8"冰了",
      u8"冰人",
      u8"冰任",
      u8"冰其淋",
      u8"冰冰",
      u8"冰冰冷冷",
      u8"冰冰凉",
      u8"冰冰凉凉",
      u8"冰冷",
      u8"冰冻",
      u8"冰冻三尺",
      u8"冰冻三尺非一日之寒",
      u8"冰冻期",
      u8"冰冻胚胎转移",
      u8"冰冻蚀刻",
      u8"冰冻食品",
      u8"冰凉",
      u8"冰凉花",
      u8"冰凌",
      u8"冰凝器",
      u8"冰刀",
      u8"冰刀鞋",
      u8"冰分凝",
      u8"冰剑",
      u8"冰厂",
      u8"冰原",
      u8"冰台",
      u8"冰咆哮",
      u8"冰场",
      u8"冰块",
      u8"冰坛",
      u8"冰坨",
      u8"冰城",
      u8"冰塔",
      u8"冰壑",
      u8"冰壶玉尺",
      u8"冰壶秋月",
      u8"冰壸秋月",
      u8"冰天雪地",
      u8"冰天雪窑",
      u8"冰天雪窖",
      u8"冰好",
      u8"冰姿玉骨",
      u8"冰孔",
      u8"冰室",
      u8"冰室京介",
      u8"冰容偏覆",
      u8"冰寒",
      u8"冰寒于水",
      u8"冰封",
      u8"冰封王座",
      u8"冰封雪冻",
      u8"冰封雪飘",
      u8"冰层",
      u8"冰屑",
      u8"冰山",
      u8"冰山一角",
      u8"冰山易倒",
      u8"冰山结构",
      u8"冰山美人",
      u8"冰山难靠",
      u8"冰岛",
      u8"冰峰",
      u8"冰川",
      u8"冰川作用",
      u8"冰川化",
      u8"冰川变化",
      u8"冰川地质学",
      u8"冰川学",
      u8"冰川带",
      u8"冰川期",
      u8"冰川河流",
      u8"冰川物质平衡",
      u8"冰川补给",
      u8"冰川退缩",
      u8"冰川隙",
      u8"冰床",
      u8"冰库",
      u8"冰店",
      u8"冰心",
      u8"冰心一片",
      u8"冰态水",
      u8"冰成",
      u8"冰挂",
      u8"冰排",
      u8"冰擦痕",
      u8"冰散瓦解",
      u8"冰斗",
      u8"冰斗冰川",
      u8"冰斧",
      u8"冰景",
      u8"冰晶",
      u8"冰晶石",
      u8"冰暴",
      u8"冰期",
      u8"冰期后",
      u8"冰枕",
      u8"冰柜",
      u8"冰柱",
      u8"冰柱雪车",
      u8"冰棍",
      u8"冰棍儿",
      u8"冰棒",
      u8"冰楔",
      u8"冰橇",
      u8"冰橙子",
      u8"冰毒",
      u8"冰毒案",
      u8"冰水",
      u8"冰水儿",
      u8"冰河",
      u8"冰河作用",
      u8"冰河时期",
      u8"冰河期",
      u8"冰河纪",
      u8"冰河解冻",
      u8"冰洁渊清",
      u8"冰洁玉清",
      u8"冰洲石",
      u8"冰浴",
      u8"冰海",
      u8"冰消云散",
      u8"冰消冻解",
      u8"冰消瓦解",
      u8"冰消雪释",
      u8"冰消雾散",
      u8"冰淇淋",
      u8"冰淇淋机",
      u8"冰清水冷",
      u8"冰清玉洁",
      u8"冰清玉润",
      u8"冰清玉粹",
      u8"冰激凌",
      u8"冰激淋",
      u8"冰灯",
      u8"冰炭",
      u8"冰炭不同器",
      u8"冰炭不同炉",
      u8"冰炭不投",
      u8"冰炭不相容",
      u8"冰炭不言",
      u8"冰炭不言冷热自明",
      u8"冰炭消溶",
      u8"冰点",
      u8"冰点价",
      u8"冰熊",
      u8"冰片",
      u8"冰牛奶",
      u8"冰球",
      u8"冰球场",
      u8"冰球界",
      u8"冰球队",
      u8"冰球馆",
      u8"冰瓶",
      u8"冰盏儿",
      u8"冰盖",
      u8"冰盖层",
      u8"冰砖",
      u8"冰碛物",
      u8"冰碴",
      u8"冰碴儿",
      u8"冰窖",
      u8"冰窟",
      u8"冰箱",
      u8"冰箱门",
      u8"冰粒",
      u8"冰糕",
      u8"冰糖",
      u8"冰糖水",
      u8"冰糖葫芦",
      u8"冰红茶",
      u8"冰缘",
      u8"冰罅",
      u8"冰美人",
      u8"冰肌",
      u8"冰肌玉骨",
      u8"冰肌雪肠",
      u8"冰胶结",
      u8"冰脊",
      u8"冰舌",
      u8"冰船",
      u8"冰芯",
      u8"冰花",
      u8"冰花土",
      u8"冰茶",
      u8"冰蚀湖",
      u8"冰蟾",
      u8"冰袋",
      u8"冰解云散",
      u8"冰解冻释",
      u8"冰解壤分",
      u8"冰解的破",
      u8"冰起",
      u8"冰起来",
      u8"冰轮",
      u8"冰过",
      u8"冰透镜体",
      u8"冰醋酸",
      u8"冰释",
      u8"冰释理顺",
      u8"冰铜",
      u8"冰销叶散",
      u8"冰锥",
      u8"冰镇",
      u8"冰镐",
      u8"冰镩",
      u8"冰隙",
      u8"冰雕",
      u8"冰雨",
      u8"冰雪",
      u8"冰雪严寒",
      u8"冰雪传奇",
      u8"冰雪儿",
      u8"冰雪消融",
      u8"冰雪界",
      u8"冰雪聪明",
      u8"冰雪节",
      u8"冰雪遍地",
      u8"冰雹",
      u8"冰雾",
      u8"冰霜",
      u8"冰面",
      u8"冰鞋",
      u8"冰风暴",
      u8"冰风谷",
      u8"冰魂素魄",
      u8"冰魂雪魄",
      u8"冰龙",
      u8"冲上",
      u8"冲上去",
      u8"冲上来",
      u8"冲下",
      u8"冲下去",
      u8"冲下来",
      u8"冲了",
      u8"冲云破雾",
      u8"冲任",
      u8"冲任失调",
      u8"冲倒",
      u8"冲值卡",
      u8"冲克",
      u8"冲入",
      u8"冲关",
      u8"冲冠一怒为红颜",
      u8"冲冠发怒",
      u8"冲冠怒发",
      u8"冲冠眦裂",
      u8"冲冲",
      u8"冲冲水",
      u8"冲决",
      u8"冲决堤防",
      u8"冲凉",
      u8"冲出",
      u8"冲出亚洲",
      u8"冲出去",
      u8"冲出来",
      u8"冲出重围",
      u8"冲击",
      u8"冲击力",
      u8"冲击摆",
      u8"冲击波",
      u8"冲击波前",
      u8"冲击疗法",
      u8"冲击钻",
      u8"冲击韧性",
      u8"冲到",
      u8"冲刷",
      u8"冲刺",
      u8"冲刺班",
      u8"冲剂",
      u8"冲力",
      u8"冲动",
      u8"冲劲",
      u8"冲劲儿",
      u8"冲劲十足",
      u8"冲印",
      u8"冲印店",
      u8"冲压",
      u8"冲压件",
      u8"冲压机",
      u8"冲去",
      u8"冲口",
      u8"冲口而出",
      u8"冲古寺",
      u8"冲向",
      u8"冲和",
      u8"冲喜",
      u8"冲在",
      u8"冲地",
      u8"冲坏",
      u8"冲坚毁锐",
      u8"冲垮",
      u8"冲塌",
      u8"冲天",
      u8"冲天炉",
      u8"冲天炮",
      u8"冲子",
      u8"冲孔",
      u8"冲孔网",
      u8"冲州撞府",
      u8"冲州过府",
      u8"冲帐",
      u8"冲床",
      u8"冲床工",
      u8"冲开",
      u8"冲开水",
      u8"冲扩",
      u8"冲抵",
      u8"冲掉",
      u8"冲撞",
      u8"冲撞力",
      u8"冲散",
      u8"冲昏",
      u8"冲昏头脑",
      u8"冲曹",
      u8"冲服",
      u8"冲杀",
      u8"冲来",
      u8"冲来冲去",
      u8"冲桩",
      u8"冲桩管线",
      u8"冲模",
      u8"冲毁",
      u8"冲水",
      u8"冲沟",
      u8"冲泡",
      u8"冲泡式",
      u8"冲洗",
      u8"冲洗器",
      u8"冲洗照片",
      u8"冲洗阀",
      u8"冲浪",
      u8"冲浪板",
      u8"冲浪网",
      u8"冲浪者",
      u8"冲消",
      u8"冲淡",
      u8"冲澡",
      u8"冲激",
      u8"冲激函数",
      u8"冲激响应",
      u8"冲片机",
      u8"冲犯",
      u8"冲盹儿",
      u8"冲着",
      u8"冲砂",
      u8"冲破",
      u8"冲积",
      u8"冲积土",
      u8"冲积堤",
      u8"冲积层",
      u8"冲积平原",
      u8"冲积成",
      u8"冲积扇",
      u8"冲积物",
      u8"冲积锥",
      u8"冲程",
      u8"冲突",
      u8"冲突地区",
      u8"冲突性",
      u8"冲突法",
      u8"冲突消解",
      u8"冲级",
      u8"冲线",
      u8"冲绳",
      u8"冲绳县",
      u8"冲绳岛",
      u8"冲翼艇",
      u8"冲脉",
      u8"冲茶",
      u8"冲荡",
      u8"冲虚",
      u8"冲虚道长",
      u8"冲蚀",
      u8"冲襟",
      u8"冲要",
      u8"冲账",
      u8"冲走",
      u8"冲起",
      u8"冲起来",
      u8"冲车",
      u8"冲过",
      u8"冲过去",
      u8"冲过来",
      u8"冲进",
      u8"冲进去",
      u8"冲进来",
      u8"冲退",
      u8"冲量",
      u8"冲销",
      u8"冲锋",
      u8"冲锋号",
      u8"冲锋在前",
      u8"冲锋枪",
      u8"冲锋衣",
      u8"冲锋裤",
      u8"冲锋队",
      u8"冲锋陷坚",
      u8"冲锋陷锐",
      u8"冲锋陷阵",
      u8"冲阳",
      u8"冲顶",
      u8"冲风冒寒",
      u8"冲风冒雨",
      u8"冲风破浪",
      u8"冲鼻",
      u8"决一死战",
      u8"决一胜负",
      u8"决一雄雌",
      u8"决一雌雄",
      u8"决不",
      u8"决不会",
      u8"决不允许",
      u8"决不再",
      u8"决不反悔",
      u8"决不可",
      u8"决不在",
      u8"决不宽贷",
      u8"决不待时",
      u8"决不是",
      u8"决不罢休",
      u8"决不能",
      u8"决不食言",
      u8"决了食言",
      u8"决出",
      u8"决出名次",
      u8"决别",
      u8"决口",
      u8"决命争首",
      u8"决堤",
      u8"决定",
      u8"决定书",
      u8"决定作用",
      u8"决定因素",
      u8"决定性",
      u8"决定政策",
      u8"决定权",
      u8"决定簇",
      u8"决定系数",
      u8"决定论",
      u8"决定论原则",
      u8"决心",
      u8"决心书",
      u8"决心很大",
      u8"决心要",
      u8"决志",
      u8"决意",
      u8"决战",
      u8"决择",
      u8"决斗",
      u8"决斗者",
      u8"决断",
      u8"决断力",
      u8"决断如流",
      u8"决无",
      u8"决无异言",
      u8"决无此事",
      u8"决明子",
      u8"决死",
      u8"决死队",
      u8"决没有",
      u8"决然",
      u8"决疣溃痈",
      u8"决窍",
      u8"决策",
      u8"决策人",
      u8"决策依据",
      u8"决策函数",
      u8"决策分析",
      u8"决策单位",
      u8"决策学",
      u8"决策层",
      u8"决策当局",
      u8"决策控制",
      u8"决策机构",
      u8"决策树",
      u8"决策程序",
      u8"决策空间",
      u8"决策者",
      u8"决策表",
      u8"决策问题",
      u8"决算",
      u8"决算书",
      u8"决算法",
      u8"决算表",
      u8"决绝",
      u8"决置",
      u8"决美",
      u8"决而不行",
      u8"决胜",
      u8"决胜于千里之外",
      u8"决胜千里",
      u8"决胜千里之外",
      u8"决胜局",
      u8"决胜庙堂",
      u8"决胜盘",
      u8"决胜负",
      u8"决裂",
      u8"决计",
      u8"决议",
      u8"决议书",
      u8"决议文",
      u8"决议案",
      u8"决赛",
      u8"决赛圈",
      u8"决赛权",
      u8"决选",
      u8"决速步",
      u8"决雌雄",
      u8"决非",
      u8"决非偶然",
      u8"况且",
      u8"况味",
      u8"冶叶倡条",
      u8"冶容",
      u8"冶容诲淫",
      u8"冶工",
      u8"冶游",
      u8"冶炼",
      u8"冶炼业",
      u8"冶炼厂",
      u8"冶炼炉",
      u8"冶炼车间",
      u8"冶练",
      u8"冶艳",
      u8"冶金",
      u8"冶金业",
      u8"冶金学",
      u8"冶金学家",
      u8"冶金工业",
      u8"冶金工业部",
      u8"冶金矿产",
      u8"冶金部",
      u8"冶铁",
      u8"冶铸",
      u8"冶锻",
      u8"冷丁",
      u8"冷下来",
      u8"冷不丁",
      u8"冷不冷",
      u8"冷不防",
      u8"冷丝丝",
      u8"冷作",
      u8"冷傲",
      u8"冷僻",
      u8"冷光",
      u8"冷光源",
      u8"冷光片",
      u8"冷兵器",
      u8"冷冰冰",
      u8"冷冲压",
      u8"冷冲模",
      u8"冷冷",
      u8"冷冷冰冰",
      u8"冷冷淡淡",
      u8"冷冷清清",
      u8"冷冷静静",
      u8"冷冻",
      u8"冷冻切片术",
      u8"冷冻剂",
      u8"冷冻厂",
      u8"冷冻固定",
      u8"冷冻室",
      u8"冷冻干燥",
      u8"冷冻库",
      u8"冷冻机",
      u8"冷冻柜",
      u8"冷冻电",
      u8"冷冻管",
      u8"冷冻箱",
      u8"冷冻货",
      u8"冷冻超薄切片术",
      u8"冷冻间",
      u8"冷凄凄",
      u8"冷凝",
      u8"冷凝剂",
      u8"冷凝器",
      u8"冷凝控制",
      u8"冷凝水",
      u8"冷凝液罐",
      u8"冷凝点",
      u8"冷凝物",
      u8"冷加工",
      u8"冷动",
      u8"冷却",
      u8"冷却剂",
      u8"冷却器",
      u8"冷却塔",
      u8"冷却套管",
      u8"冷却旋管",
      u8"冷却水",
      u8"冷却水循环",
      u8"冷却水浴",
      u8"冷却液",
      u8"冷却空气",
      u8"冷却管",
      u8"冷却系统",
      u8"冷启动",
      u8"冷嘲",
      u8"冷嘲热讽",
      u8"冷嘲热骂",
      u8"冷噤",
      u8"冷圈",
      u8"冷圈学",
      u8"冷场",
      u8"冷壁反应器",
      u8"冷处理",
      u8"冷夏",
      u8"冷天",
      u8"冷媒",
      u8"冷子管",
      u8"冷字",
      u8"冷室",
      u8"冷宫",
      u8"冷害",
      u8"冷寂",
      u8"冷寒星",
      u8"冷寞",
      u8"冷山",
      u8"冷峭",
      u8"冷峻",
      u8"冷工作业",
      u8"冷巴",
      u8"冷巷",
      u8"冷布",
      u8"冷干机",
      u8"冷床",
      u8"冷库",
      u8"冷开水",
      u8"冷得",
      u8"冷心冷面",
      u8"冷思考",
      u8"冷感症",
      u8"冷战",
      u8"冷挤压",
      u8"冷敏",
      u8"冷敷",
      u8"冷敷法",
      u8"冷无风",
      u8"冷星云",
      u8"冷暖",
      u8"冷暖人间",
      u8"冷暖空气",
      u8"冷暖空调",
      u8"冷暖自如",
      u8"冷暖自知",
      u8"冷暴力",
      u8"冷杉",
      u8"冷杉木",
      u8"冷板凳",
      u8"冷枪",
      u8"冷柜",
      u8"冷森森",
      u8"冷气",
      u8"冷气团",
      u8"冷气机",
      u8"冷气设备",
      u8"冷水",
      u8"冷水冷面",
      u8"冷水器",
      u8"冷水域",
      u8"冷水性",
      u8"冷水机",
      u8"冷水机组",
      u8"冷水江",
      u8"冷水江市",
      u8"冷水浇头",
      u8"冷水浇背",
      u8"冷水浴",
      u8"冷水滩",
      u8"冷水滩区",
      u8"冷水滩市",
      u8"冷水澡",
      u8"冷水烫猪",
      u8"冷汗",
      u8"冷汗直流",
      u8"冷泉",
      u8"冷流",
      u8"冷浸",
      u8"冷涡",
      u8"冷涩",
      u8"冷淡",
      u8"冷清",
      u8"冷清清",
      u8"冷湖",
      u8"冷溲溲",
      u8"冷漠",
      u8"冷激",
      u8"冷激蛋白质",
      u8"冷灰爆豆",
      u8"冷点",
      u8"冷烫",
      u8"冷烫精",
      u8"冷热",
      u8"冷热板",
      u8"冷热水",
      u8"冷热病",
      u8"冷热箱",
      u8"冷热自明",
      u8"冷焊",
      u8"冷球蛋白",
      u8"冷疗法",
      u8"冷盘",
      u8"冷眉冷眼",
      u8"冷眼",
      u8"冷眼旁观",
      u8"冷眼相待",
      u8"冷眼相觑",
      u8"冷眼静看",
      u8"冷科",
      u8"冷空气",
      u8"冷窗冻壁",
      u8"冷笑",
      u8"冷箭",
      u8"冷缩",
      u8"冷美人",
      u8"冷脸",
      u8"冷腌法",
      u8"冷色",
      u8"冷色调",
      u8"冷艳",
      u8"冷若",
      u8"冷若冰霜",
      u8"冷荤",
      u8"冷菜",
      u8"冷落",
      u8"冷落慢待",
      u8"冷藏",
      u8"冷藏器",
      u8"冷藏室",
      u8"冷藏库",
      u8"冷藏柜",
      u8"冷藏法",
      u8"冷藏箱",
      u8"冷藏车",
      u8"冷血",
      u8"冷血动物",
      u8"冷言冷语",
      u8"冷言热语",
      u8"冷言讽语",
      u8"冷话",
      u8"冷语",
      u8"冷语冰人",
      u8"冷谈",
      u8"冷谦",
      u8"冷货",
      u8"冷轧",
      u8"冷轧卷",
      u8"冷轧带",
      u8"冷轧机",
      u8"冷轧板",
      u8"冷适应突变",
      u8"冷适应突变体",
      u8"冷遇",
      u8"冷酷",
      u8"冷酷无情",
      u8"冷铸",
      u8"冷锅里爆豆",
      u8"冷锋",
      u8"冷门",
      u8"冷门课",
      u8"冷门货",
      u8"冷阴极",
      u8"冷雨夜",
      u8"冷雨晓晓",
      u8"冷霜",
      u8"冷静",
      u8"冷静下来",
      u8"冷静王",
      u8"冷静静",
      u8"冷面",
      u8"冷面寒铁",
      u8"冷面馆",
      u8"冷颤",
      u8"冷风",
      u8"冷风吹",
      u8"冷风机",
      u8"冷飕飕",
      u8"冷食",
      u8"冷食部",
      u8"冷餐",
      u8"冷饮",
      u8"冷饮店",
      u8"冷饮部",
      u8"冻伤",
      u8"冻住",
      u8"冻僵",
      u8"冻儿",
      u8"冻冰",
      u8"冻凝点",
      u8"冻到",
      u8"冻原",
      u8"冻原地带",
      u8"冻啤酒",
      u8"冻土",
      u8"冻土动力学",
      u8"冻土学",
      u8"冻土层",
      u8"冻土相分析",
      u8"冻土进化",
      u8"冻土退化",
      u8"冻坏",
      u8"冻害",
      u8"冻干机",
      u8"冻干粉",
      u8"冻库",
      u8"冻得",
      u8"冻成",
      u8"冻拔",
      u8"冻死",
      u8"冻洁",
      u8"冻浦鱼惊",
      u8"冻港",
      u8"冻猪肉",
      u8"冻疮",
      u8"冻硬",
      u8"冻糕",
      u8"冻结",
      u8"冻结层中水",
      u8"冻结成",
      u8"冻结指数",
      u8"冻结标记",
      u8"冻结深度",
      u8"冻结资产",
      u8"冻结资金",
      u8"冻肉",
      u8"冻胀",
      u8"冻胀力",
      u8"冻胶型调剖剂",
      u8"冻融循环",
      u8"冻裂",
      u8"冻解冰释",
      u8"冻豆腐",
      u8"冻过",
      u8"冻雨",
      u8"冻顶",
      u8"冻顶乌龙",
      u8"冻顶乌龙茶",
      u8"冻饿",
      u8"冻馁",
      u8"冼星海",
      u8"冽泉",
      u8"净亏损",
      u8"净产值",
      u8"净价",
      u8"净余",
      u8"净值",
      u8"净光合",
      u8"净利",
      u8"净利润",
      u8"净剩",
      u8"净化",
      u8"净化剂",
      u8"净化器",
      u8"净化水",
      u8"净化水缓冲罐",
      u8"净化环境",
      u8"净化系统",
      u8"净原子布居",
      u8"净口",
      u8"净含量",
      u8"净土",
      u8"净土宗",
      u8"净增",
      u8"净室",
      u8"净宽",
      u8"净尽",
      u8"净差",
      u8"净得",
      u8"净心",
      u8"净手",
      u8"净损",
      u8"净支",
      u8"净收入",
      u8"净数",
      u8"净是",
      u8"净月潭",
      u8"净本",
      u8"净桶",
      u8"净气",
      u8"净水",
      u8"净水剂",
      u8"净水厂",
      u8"净水器",
      u8"净水机",
      u8"净洗剂",
      u8"净济",
      u8"净清",
      u8"净瓶",
      u8"净盘将军",
      u8"净空",
      u8"净素",
      u8"净胜球",
      u8"净菜",
      u8"净菜社",
      u8"净角",
      u8"净资产",
      u8"净资产收益率",
      u8"净赚",
      u8"净赚额",
      u8"净赢",
      u8"净身",
      u8"净车价",
      u8"净重",
      u8"净重量",
      u8"净销",
      u8"净额",
      u8"净高",
      u8"凄入肝脾",
      u8"凄冷",
      u8"凄凄",
      u8"凄凄凉凉",
      u8"凄凄切切",
      u8"凄凄惨惨",
      u8"凄凉",
      u8"凄凉身",
      u8"凄切",
      u8"凄切动人",
      u8"凄历",
      u8"凄厉",
      u8"凄呖",
      u8"凄咽",
      u8"凄唱",
      u8"凄婉",
      u8"凄怆",
      u8"凄怨",
      u8"凄恻",
      u8"凄惘",
      u8"凄惨",
      u8"凄惶",
      u8"凄戾",
      u8"凄楚",
      u8"凄沧",
      u8"凄清",
      u8"凄然",
      u8"凄然泪下",
      u8"凄神寒骨",
      u8"凄绝",
      u8"凄美",
      u8"凄艳",
      u8"凄苍",
      u8"凄苦",
      u8"凄迷",
      u8"凄迷不振",
      u8"凄酸",
      u8"凄风",
      u8"凄风冷雨",
      u8"凄风寒雨",
      u8"凄风楚雨",
      u8"凄风苦雨",
      u8"准一级反应",
      u8"准予",
      u8"准予上映",
      u8"准会",
      u8"准位",
      u8"准保",
      u8"准信",
      u8"准信儿",
      u8"准假",
      u8"准儿",
      u8"准入",
      u8"准入关",
      u8"准入制",
      u8"准入条件",
      u8"准其",
      u8"准军事",
      u8"准决赛",
      u8"准分子",
      u8"准分子激光",
      u8"准则",
      u8"准则象牙塔",
      u8"准单向",
      u8"准周期性",
      u8"准噶尔",
      u8"准噶尔盆地",
      u8"准备",
      u8"准备不周",
      u8"准备充分",
      u8"准备后事",
      u8"准备好",
      u8"准备就绪",
      u8"准备工作",
      u8"准备时间",
      u8"准备活动",
      u8"准备用",
      u8"准备考",
      u8"准备金",
      u8"准外消旋体",
      u8"准头",
      u8"准奏",
      u8"准妈咪",
      u8"准妈妈",
      u8"准定",
      u8"准宾语",
      u8"准对称",
      u8"准对称性",
      u8"准将",
      u8"准尉",
      u8"准平原",
      u8"准度",
      u8"准建证",
      u8"准心",
      u8"准性生殖",
      u8"准据",
      u8"准收",
      u8"准新娘",
      u8"准新郎",
      u8"准时",
      u8"准时出席",
      u8"准时到达",
      u8"准星",
      u8"准是",
      u8"准格尔",
      u8"准格尔旗",
      u8"准港姐",
      u8"准滤光片",
      u8"准点",
      u8"准照",
      u8"准现房",
      u8"准生证",
      u8"准直光束",
      u8"准确",
      u8"准确度",
      u8"准确性",
      u8"准确无误",
      u8"准确率",
      u8"准种",
      u8"准稳态",
      u8"准系统",
      u8"准素分解",
      u8"准素子模",
      u8"准素环",
      u8"准线",
      u8"准经典近似",
      u8"准绳",
      u8"准考证",
      u8"准能",
      u8"准许",
      u8"准话",
      u8"准谱",
      u8"准谱儿",
      u8"准轨",
      u8"准连续区",
      u8"准静态过程",
      u8"凉丝丝",
      u8"凉了",
      u8"凉了半截",
      u8"凉亭",
      u8"凉伞",
      u8"凉冰冰",
      u8"凉凉",
      u8"凉凉快快",
      u8"凉凉爽爽",
      u8"凉到",
      u8"凉台",
      u8"凉嗖嗖",
      u8"凉城",
      u8"凉城县",
      u8"凉如水",
      u8"凉山",
      u8"凉山州",
      u8"凉山彝族自治州",
      u8"凉州",
      u8"凉州区",
      u8"凉席",
      u8"凉帽",
      u8"凉开水",
      u8"凉快",
      u8"凉意",
      u8"凉拌",
      u8"凉拌菜",
      u8"凉拌面",
      u8"凉棚",
      u8"凉椅",
      u8"凉气",
      u8"凉水",
      u8"凉水塔",
      u8"凉水池",
      u8"凉水河",
      u8"凉水澡",
      u8"凉津津",
      u8"凉浸浸",
      u8"凉溲溲",
      u8"凉爽",
      u8"凉爽呢",
      u8"凉瓶",
      u8"凉白开",
      u8"凉碟",
      u8"凉簌簌",
      u8"凉粉",
      u8"凉粉条",
      u8"凉糕",
      u8"凉苏苏",
      u8"凉茶",
      u8"凉茶铺",
      u8"凉药",
      u8"凉菜",
      u8"凉血动物",
      u8"凉面",
      u8"凉鞋",
      u8"凉风",
      u8"凉风习习",
      u8"凉风阵阵",
      u8"凉飕飕",
      u8"凋亡",
      u8"凋敝",
      u8"凋枯",
      u8"凋残",
      u8"凋萎",
      u8"凋落",
      u8"凋谢",
      u8"凋败",
      u8"凋逝",
      u8"凋零",
      u8"凌上虐下",
      u8"凌乱",
      u8"凌乱不堪",
      u8"凌云",
      u8"凌云之志",
      u8"凌云凤",
      u8"凌云县",
      u8"凌云壮志",
      u8"凌云志",
      u8"凌人",
      u8"凌侮",
      u8"凌厉",
      u8"凌厉攻势",
      u8"凌夷",
      u8"凌宗英",
      u8"凌弱暴寡",
      u8"凌晨",
      u8"凌晨时分",
      u8"凌杂",
      u8"凌杂米盐",
      u8"凌气逼人",
      u8"凌汛",
      u8"凌河",
      u8"凌河区",
      u8"凌波",
      u8"凌波丽",
      u8"凌波仙子",
      u8"凌海",
      u8"凌海市",
      u8"凌淑芬",
      u8"凌源",
      u8"凌源县",
      u8"凌源市",
      u8"凌空",
      u8"凌空飞行",
      u8"凌空高飞",
      u8"凌绝顶",
      u8"凌虐",
      u8"凌贵兴",
      u8"凌轹",
      u8"凌辱",
      u8"凌迟",
      u8"凌退思",
      u8"凌锥",
      u8"凌霄",
      u8"凌霄之志",
      u8"凌霄花",
      u8"凌霄飞车",
      u8"凌霜华",
      u8"凌驾",
      u8"凌驾于",
      u8"凌驾在",
      u8"减下",
      u8"减个",
      u8"减为",
      u8"减了",
      u8"减亏",
      u8"减产",
      u8"减人",
      u8"减人增效",
      u8"减价",
      u8"减价出售",
      u8"减价时间",
      u8"减份",
      u8"减低",
      u8"减借",
      u8"减债",
      u8"减值",
      u8"减免",
      u8"减免税",
      u8"减免额",
      u8"减分",
      u8"减刑",
      u8"减利",
      u8"减到",
      u8"减削",
      u8"减化",
      u8"减半",
      u8"减压",
      u8"减压器",
      u8"减压塔",
      u8"减压氧化",
      u8"减压水槽",
      u8"减压渣油",
      u8"减压蒸馏",
      u8"减压阀",
      u8"减压馏程",
      u8"减去",
      u8"减反射膜",
      u8"减号",
      u8"减员",
      u8"减员增效",
      u8"减声器",
      u8"减好",
      u8"减对",
      u8"减寿",
      u8"减小",
      u8"减少",
      u8"减师半德",
      u8"减幅",
      u8"减年",
      u8"减并",
      u8"减弱",
      u8"减弱到",
      u8"减征",
      u8"减得",
      u8"减息",
      u8"减慢",
      u8"减拨",
      u8"减按",
      u8"减振器",
      u8"减损",
      u8"减掉",
      u8"减支",
      u8"减收",
      u8"减收增支",
      u8"减数",
      u8"减数分裂",
      u8"减数分裂后",
      u8"减方",
      u8"减日",
      u8"减时线",
      u8"减毒株",
      u8"减毒活疫苗",
      u8"减毒疫苗",
      u8"减水剂",
      u8"减法",
      u8"减法器",
      u8"减消",
      u8"减灾",
      u8"减班",
      u8"减省",
      u8"减省得",
      u8"减租",
      u8"减租减息",
      u8"减税",
      u8"减税法",
      u8"减笔字",
      u8"减算",
      u8"减粘裂化",
      u8"减纳",
      u8"减缓",
      u8"减缓放慢",
      u8"减缩",
      u8"减缩到",
      u8"减肥",
      u8"减肥乐",
      u8"减肥操",
      u8"减肥法",
      u8"减肥网",
      u8"减肥茶",
      u8"减肥药",
      u8"减肥餐",
      u8"减胖",
      u8"减至",
      u8"减色",
      u8"减色性",
      u8"减色法",
      u8"减薪",
      u8"减让",
      u8"减课",
      u8"减负",
      u8"减负办",
      u8"减轻",
      u8"减轻债务负担",
      u8"减轻处分",
      u8"减轻法",
      u8"减轻负担",
      u8"减退",
      u8"减退症",
      u8"减速",
      u8"减速剂",
      u8"减速器",
      u8"减速带",
      u8"减速慢行",
      u8"减速时间",
      u8"减速期",
      u8"减速机",
      u8"减速板",
      u8"减速比",
      u8"减速运动",
      u8"减速顶",
      u8"减速马达",
      u8"减量",
      u8"减量化",
      u8"减金",
      u8"减阻剂",
      u8"减除",
      u8"减震",
      u8"减震器",
      u8"减食",
      u8"凑上",
      u8"凑上去",
      u8"凑上来",
      u8"凑不出来",
      u8"凑个",
      u8"凑乱",
      u8"凑了",
      u8"凑份子",
      u8"凑兴",
      u8"凑凑",
      u8"凑出",
      u8"凑到",
      u8"凑合",
      u8"凑合着",
      u8"凑和",
      u8"凑在一起",
      u8"凑够",
      u8"凑对",
      u8"凑巧",
      u8"凑得",
      u8"凑成",
      u8"凑手",
      u8"凑拢",
      u8"凑搭",
      u8"凑数",
      u8"凑热闹",
      u8"凑趣",
      u8"凑趣儿",
      u8"凑足",
      u8"凑近",
      u8"凑钱",
      u8"凑集",
      u8"凑齐",
      u8"凛冽",
      u8"凛凛",
      u8"凛厉",
      u8"凛如霜雪",
      u8"凛然",
      u8"凛然正气",
      u8"凛若冰霜",
      u8"凛若秋霜",
      u8"凛遵",
      u8"凝为",
      u8"凝乳",
      u8"凝冻",
      u8"凝华",
      u8"凝合",
      u8"凝合力",
      u8"凝固",
      u8"凝固剂",
      u8"凝固性",
      u8"凝固时间",
      u8"凝固汽油",
      u8"凝固点",
      u8"凝固酶因子",
      u8"凝定",
      u8"凝寒",
      u8"凝思",
      u8"凝思须臾",
      u8"凝想",
      u8"凝成",
      u8"凝望",
      u8"凝析气",
      u8"凝析气油比",
      u8"凝止",
      u8"凝汽器",
      u8"凝注",
      u8"凝滞",
      u8"凝灰岩",
      u8"凝炼",
      u8"凝目",
      u8"凝眸",
      u8"凝瞩不转",
      u8"凝神",
      u8"凝神静听",
      u8"凝练",
      u8"凝结",
      u8"凝结为",
      u8"凝结剂",
      u8"凝结力",
      u8"凝结器",
      u8"凝结尾流",
      u8"凝结核",
      u8"凝结水",
      u8"凝结点",
      u8"凝缩",
      u8"凝聚",
      u8"凝聚剂",
      u8"凝聚力",
      u8"凝聚态",
      u8"凝聚性",
      u8"凝聚染色质",
      u8"凝聚系统",
      u8"凝胶",
      u8"凝胶体",
      u8"凝胶灌制",
      u8"凝胶电泳",
      u8"凝脂",
      u8"凝脂点漆",
      u8"凝血",
      u8"凝血剂",
      u8"凝血因子",
      u8"凝血烷",
      u8"凝血级联系统",
      u8"凝血调节蛋白",
      u8"凝血酶",
      u8"凝血酶原",
      u8"凝视",
      u8"凝视着",
      u8"凝视者",
      u8"凝重",
      u8"凝铸",
      u8"凝集",
      u8"凝集力",
      u8"凝集反应",
      u8"凝集素",
      u8"几丁质",
      u8"几万",
      u8"几万个",
      u8"几万人",
      u8"几万元",
      u8"几万块",
      u8"几下",
      u8"几下子",
      u8"几不欲生",
      u8"几世",
      u8"几世纪",
      u8"几丝",
      u8"几两",
      u8"几个",
      u8"几个人",
      u8"几个字",
      u8"几个月",
      u8"几个问题",
      u8"几乎",
      u8"几乎不",
      u8"几乎在",
      u8"几乎是",
      u8"几乎没有",
      u8"几于",
      u8"几亩",
      u8"几人",
      u8"几人份",
      u8"几亿",
      u8"几付",
      u8"几代",
      u8"几代人",
      u8"几令",
      u8"几件",
      u8"几件事",
      u8"几任",
      u8"几份",
      u8"几伍",
      u8"几会",
      u8"几位",
      u8"几位数",
      u8"几何",
      u8"几何亏格",
      u8"几何体",
      u8"几何单纯复形",
      u8"几何图形",
      u8"几何均数",
      u8"几何学",
      u8"几何学家",
      u8"几何平均",
      u8"几何平均数",
      u8"几何异构",
      u8"几何级数",
      u8"几倍",
      u8"几儿",
      u8"几元",
      u8"几兆",
      u8"几克",
      u8"几党",
      u8"几关",
      u8"几具",
      u8"几内亚",
      u8"几内亚比绍",
      u8"几内亚湾",
      u8"几册",
      u8"几几",
      u8"几几乎乎",
      u8"几出",
      u8"几刀",
      u8"几分",
      u8"几分收获",
      u8"几分耕耘",
      u8"几分钟",
      u8"几划",
      u8"几列",
      u8"几副",
      u8"几动",
      u8"几匹",
      u8"几匹马",
      u8"几区",
      u8"几十",
      u8"几十个",
      u8"几十人",
      u8"几十倍",
      u8"几十年",
      u8"几十年如一日",
      u8"几十年来",
      u8"几千",
      u8"几千个",
      u8"几千人",
      u8"几千元",
      u8"几千块",
      u8"几千家",
      u8"几千年",
      u8"几历",
      u8"几发",
      u8"几口",
      u8"几句",
      u8"几句话",
      u8"几只",
      u8"几只羊",
      u8"几台",
      u8"几号",
      u8"几号楼",
      u8"几名",
      u8"几员",
      u8"几周",
      u8"几回",
      u8"几因",
      u8"几团",
      u8"几国",
      u8"几圆",
      u8"几圈",
      u8"几场",
      u8"几块",
      u8"几块钱",
      u8"几垒",
      u8"几声",
      u8"几壶",
      u8"几处",
      u8"几多",
      u8"几夜",
      u8"几大",
      u8"几大块",
      u8"几大片",
      u8"几大类",
      u8"几天",
      u8"几天几夜",
      u8"几天后",
      u8"几天来",
      u8"几头",
      u8"几套",
      u8"几好",
      u8"几孔",
      u8"几字",
      u8"几季",
      u8"几客",
      u8"几室",
      u8"几家",
      u8"几家愁",
      u8"几家欢乐",
      u8"几家欢乐几家愁",
      u8"几寸",
      u8"几封",
      u8"几封信",
      u8"几小时",
      u8"几尼",
      u8"几尾",
      u8"几局",
      u8"几层",
      u8"几层楼",
      u8"几届",
      u8"几岁",
      u8"几巷",
      u8"几师",
      u8"几希",
      u8"几幅",
      u8"几年",
      u8"几年前",
      u8"几年如一日",
      u8"几年来",
      u8"几年生",
      u8"几年级",
      u8"几床",
      u8"几度",
      u8"几座",
      u8"几开",
      u8"几弄",
      u8"几张",
      u8"几弹",
      u8"几微",
      u8"几成",
      u8"几成新",
      u8"几截",
      u8"几户",
      u8"几所",
      u8"几手",
      u8"几打",
      u8"几批",
      u8"几把",
      u8"几招",
      u8"几拳",
      u8"几支",
      u8"几文钱",
      u8"几斤",
      u8"几斤几两",
      u8"几方面",
      u8"几旅",
      u8"几无二致",
      u8"几日",
      u8"几日份",
      u8"几时",
      u8"几时休",
      u8"几易其稿",
      u8"几星",
      u8"几星期",
      u8"几晚",
      u8"几曾",
      u8"几月",
      u8"几月份",
      u8"几期",
      u8"几本",
      u8"几本书",
      u8"几朵",
      u8"几杆",
      u8"几条",
      u8"几杯酒",
      u8"几板",
      u8"几枚",
      u8"几枝",
      u8"几枪",
      u8"几架",
      u8"几栋",
      u8"几株",
      u8"几样",
      u8"几根",
      u8"几格",
      u8"几案",
      u8"几档",
      u8"几桶",
      u8"几梯次",
      u8"几棵",
      u8"几楼",
      u8"几次",
      u8"几次三番",
      u8"几欲",
      u8"几步",
      u8"几段",
      u8"几比",
      u8"几比几",
      u8"几毛",
      u8"几毛钱",
      u8"几洞",
      u8"几滴",
      u8"几滴水",
      u8"几炷香",
      u8"几点",
      u8"几点钟",
      u8"几片",
      u8"几版",
      u8"几率",
      u8"几率比",
      u8"几环",
      u8"几班",
      u8"几瓶",
      u8"几画",
      u8"几番",
      u8"几百",
      u8"几百万",
      u8"几百个",
      u8"几百人",
      u8"几百元",
      u8"几百名",
      u8"几百块",
      u8"几百年",
      u8"几盏",
      u8"几盒",
      u8"几盒装",
      u8"几眼",
      u8"几碗",
      u8"几碗饭",
      u8"几票",
      u8"几种",
      u8"几科",
      u8"几秒",
      u8"几秒钟",
      u8"几稀",
      u8"几窝",
      u8"几站",
      u8"几章",
      u8"几竿",
      u8"几笔",
      u8"几笼",
      u8"几筒",
      u8"几箱",
      u8"几篇",
      u8"几米",
      u8"几米远",
      u8"几类",
      u8"几粒",
      u8"几级",
      u8"几线",
      u8"几组",
      u8"几经",
      u8"几经反复",
      u8"几经周折",
      u8"几经考虑",
      u8"几维鸟",
      u8"几缕",
      u8"几罐",
      u8"几群",
      u8"几股",
      u8"几胎",
      u8"几能",
      u8"几脚",
      u8"几至",
      u8"几节",
      u8"几节课",
      u8"几行",
      u8"几行字",
      u8"几街",
      u8"几袈",
      u8"几袋",
      u8"几角",
      u8"几角形",
      u8"几许",
      u8"几课",
      u8"几起",
      u8"几起几落",
      u8"几趟",
      u8"几趟路",
      u8"几路",
      u8"几车",
      u8"几转",
      u8"几辆",
      u8"几辆车",
      u8"几近",
      u8"几近于",
      u8"几通",
      u8"几遍",
      u8"几道",
      u8"几道菜",
      u8"几部",
      u8"几部戏",
      u8"几针",
      u8"几钿",
      u8"几门",
      u8"几间",
      u8"几队",
      u8"几集",
      u8"几页",
      u8"几顶",
      u8"几项",
      u8"几颗",
      u8"几题",
      u8"几首",
      u8"几首歌",
      u8"凡与",
      u8"凡世",
      u8"凡为",
      u8"凡事",
      u8"凡事起头难",
      u8"凡事预则立",
      u8"凡事预则立不预则废",
      u8"凡于",
      u8"凡人",
      u8"凡人不可貌相",
      u8"凡例",
      u8"凡俗",
      u8"凡偶近器",
      u8"凡响",
      u8"凡因",
      u8"凡圣",
      u8"凡在",
      u8"凡士林",
      u8"凡夫",
      u8"凡夫俗子",
      u8"凡夫肉眼",
      u8"凡尔",
      u8"凡尔丁",
      u8"凡尔纳",
      u8"凡尔赛",
      u8"凡尔赛宫",
      u8"凡尘",
      u8"凡属",
      u8"凡应",
      u8"凡庸",
      u8"凡心",
      u8"凡才浅识",
      u8"凡指",
      u8"凡无",
      u8"凡是",
      u8"凡有",
      u8"凡未",
      u8"凡本网",
      u8"凡桃俗李",
      u8"凡此",
      u8"凡此种种",
      u8"凡民",
      u8"凡没",
      u8"凡由",
      u8"凡百",
      u8"凡百一新",
      u8"凡立丁呢",
      u8"凡立司",
      u8"凡胎浊体",
      u8"凡胎浊骨",
      u8"凡胎肉眼",
      u8"凡能",
      u8"凡蒂冈",
      u8"凡要",
      u8"凡赫辛",
      u8"凡间",
      u8"凡需",
      u8"凡须",
      u8"凡高",
      u8"凤一鸣",
      u8"凤七",
      u8"凤之声",
      u8"凤仙",
      u8"凤仙花",
      u8"凤仪",
      u8"凤仪亭",
      u8"凤仪兽舞",
      u8"凤儿",
      u8"凤冈",
      u8"凤冈县",
      u8"凤冠",
      u8"凤冠霞帔",
      u8"凤凰",
      u8"凤凰于飞",
      u8"凤凰卫视",
      u8"凤凰县",
      u8"凤凰古城",
      u8"凤凰台",
      u8"凤凰在笯",
      u8"凤凰山",
      u8"凤凰岭",
      u8"凤凰木",
      u8"凤凰来仪",
      u8"凤凰树",
      u8"凤凰池",
      u8"凤凰社",
      u8"凤凰竹",
      u8"凤凰网",
      u8"凤凰脚",
      u8"凤凰花",
      u8"凤凰花开",
      u8"凤凰血",
      u8"凤凰衣",
      u8"凤凰誓",
      u8"凤北新村片",
      u8"凤南天",
      u8"凤县",
      u8"凤友鸾交",
      u8"凤友鸾谐",
      u8"凤只鸾孤",
      u8"凤台",
      u8"凤台县",
      u8"凤叹虎视",
      u8"凤合",
      u8"凤合县",
      u8"凤吟鸾吹",
      u8"凤城",
      u8"凤城市",
      u8"凤城满族自治县",
      u8"凤姐",
      u8"凤姐儿",
      u8"凤子龙孙",
      u8"凤尾",
      u8"凤尾松",
      u8"凤尾竹",
      u8"凤尾草",
      u8"凤尾菇",
      u8"凤尾蘑",
      u8"凤尾鱼",
      u8"凤山",
      u8"凤山县",
      u8"凤山市",
      u8"凤山溪",
      u8"凤庆",
      u8"凤庆县",
      u8"凤引九雏",
      u8"凤愁鸾怨",
      u8"凤枭同巢",
      u8"凤梧",
      u8"凤梧乡",
      u8"凤梨",
      u8"凤梨汁",
      u8"凤楼龙阙",
      u8"凤歌鸾舞",
      u8"凤毛济美",
      u8"凤毛鸡胆",
      u8"凤毛麋角",
      u8"凤毛麟角",
      u8"凤毛龙甲",
      u8"凤求凰",
      u8"凤泉区",
      u8"凤泊鸾漂",
      u8"凤泊鸾飘",
      u8"凤湖村民住宅",
      u8"凤爪",
      u8"凤狂龙躁",
      u8"凤皇于蜚",
      u8"凤眼",
      u8"凤眼兰",
      u8"凤眼莲",
      u8"凤管鸾笙",
      u8"凤箫龙管",
      u8"凤翔",
      u8"凤翔县",
      u8"凤翔路",
      u8"凤翥鸾回",
      u8"凤翥鸾翔",
      u8"凤翥鹏翔",
      u8"凤翥龙翔",
      u8"凤翥龙蟠",
      u8"凤翥龙骧",
      u8"凤臆龙鬐",
      u8"凤舞香罗",
      u8"凤舞龙蟠",
      u8"凤舞龙飞",
      u8"凤艳阁",
      u8"凤藻",
      u8"凤蝶",
      u8"凤表龙姿",
      u8"凤起路",
      u8"凤辇",
      u8"凤采鸾章",
      u8"凤钗",
      u8"凤阁龙楼",
      u8"凤阳",
      u8"凤阳县",
      u8"凤阳花鼓",
      u8"凤阳路",
      u8"凤附龙攀",
      u8"凤雏",
      u8"凤雏麟子",
      u8"凤靡鸾吪",
      u8"凤飞飞",
      u8"凤食鸾栖",
      u8"凤驾",
      u8"凤骨龙姿",
      u8"凤髓龙肝",
      u8"凤鸣朝阳",
      u8"凤鸣轩",
      u8"凤鸣鹤唳",
      u8"凤鸣麟出",
      u8"凫居雁聚",
      u8"凫水",
      u8"凫短鹤长",
      u8"凫胫鹤膝",
      u8"凫趋雀跃",
      u8"凫鹤从方",
      u8"凭什么",
      u8"凭仗",
      u8"凭以",
      u8"凭你",
      u8"凭你是谁",
      u8"凭依",
      u8"凭信",
      u8"凭借",
      u8"凭几之诏",
      u8"凭几据杖",
      u8"凭券",
      u8"凭单",
      u8"凭单日记",
      u8"凭单日记帐",
      u8"凭吊",
      u8"凭坚",
      u8"凭城借一",
      u8"凭处方",
      u8"凭恃",
      u8"凭感觉",
      u8"凭据",
      u8"凭栏",
      u8"凭栏处",
      u8"凭栏远眺",
      u8"凭此",
      u8"凭照",
      u8"凭甚么",
      u8"凭白无故",
      u8"凭直觉",
      u8"凭眺",
      u8"凭着",
      u8"凭祥",
      u8"凭祥市",
      u8"凭票",
      u8"凭票供应",
      u8"凭票入场",
      u8"凭空",
      u8"凭空出现",
      u8"凭空妄断",
      u8"凭空想像",
      u8"凭空想象",
      u8"凭空捏造",
      u8"凭空猜测",
      u8"凭空臆造",
      u8"凭肉眼",
      u8"凭良心",
      u8"凭良心讲",
      u8"凭良心说",
      u8"凭藉",
      u8"凭藉着",
      u8"凭虚公子",
      u8"凭虚御风",
      u8"凭证",
      u8"凭证入场",
      u8"凭证式",
      u8"凭轼旁观",
      u8"凭轼结辙",
      u8"凭险",
      u8"凭靠",
      u8"凭靠着",
      u8"凯乐",
      u8"凯别兴",
      u8"凯地",
      u8"凯塞琳",
      u8"凯奇",
      u8"凯子",
      u8"凯尔特",
      u8"凯尔特人",
      u8"凯山",
      u8"凯恩斯",
      u8"凯撒",
      u8"凯撒公司",
      u8"凯旋",
      u8"凯旋归来",
      u8"凯旋路",
      u8"凯旋门",
      u8"凯歌",
      u8"凯氏",
      u8"凯氏定氮",
      u8"凯氏带",
      u8"凯特",
      u8"凯瑟琳",
      u8"凯神网",
      u8"凯美瑞",
      u8"凯茜",
      u8"凯莉",
      u8"凯迪拉克",
      u8"凯里",
      u8"凯里市",
      u8"凯门鳄",
      u8"凰凤",
      u8"凰牙",
      u8"凰裰",
      u8"凳子",
      u8"凶事",
      u8"凶信",
      u8"凶兆",
      u8"凶具",
      u8"凶凶",
      u8"凶凶恶恶",
      u8"凶凶狠狠",
      u8"凶吉难卜",
      u8"凶喘肤汗",
      u8"凶器",
      u8"凶多吉少",
      u8"凶嫌",
      u8"凶宅",
      u8"凶岁",
      u8"凶巴巴",
      u8"凶年",
      u8"凶年饥岁",
      u8"凶徒",
      u8"凶得",
      u8"凶得狠",
      u8"凶恶",
      u8"凶悍",
      u8"凶手",
      u8"凶暴",
      u8"凶服",
      u8"凶杀",
      u8"凶杀案",
      u8"凶案",
      u8"凶横",
      u8"凶死",
      u8"凶残",
      u8"凶气",
      u8"凶焰",
      u8"凶煞",
      u8"凶犯",
      u8"凶狂",
      u8"凶狠",
      u8"凶狠残暴",
      u8"凶猛",
      u8"凶猛地",
      u8"凶相",
      u8"凶相毕露",
      u8"凶神",
      u8"凶神恶煞",
      u8"凶神附体",
      u8"凶终隙未",
      u8"凶终隙末",
      u8"凶耗",
      u8"凶起来",
      u8"凶险",
      u8"凶顽",
      u8"凸凹",
      u8"凸凹性",
      u8"凸出",
      u8"凸出去",
      u8"凸出成",
      u8"凸出来",
      u8"凸出舞台",
      u8"凸出蛋白",
      u8"凸函数",
      u8"凸合作对策",
      u8"凸嘴",
      u8"凸多边形",
      u8"凸多面锥",
      u8"凸岸坝",
      u8"凸度",
      u8"凸显",
      u8"凸显出",
      u8"凸板印刷",
      u8"凸版",
      u8"凸版印刷",
      u8"凸状",
      u8"凸状物",
      u8"凸环",
      u8"凸现",
      u8"凸着",
      u8"凸砖层",
      u8"凸窗",
      u8"凸纹",
      u8"凸纹饰物",
      u8"凸缘",
      u8"凸角",
      u8"凸起",
      u8"凸起来",
      u8"凸起碱基",
      u8"凸轮",
      u8"凸轮轴",
      u8"凸边",
      u8"凸边角",
      u8"凸透",
      u8"凸透镜",
      u8"凸镜",
      u8"凸面",
      u8"凸面镜",
      u8"凸颌畸形",
      u8"凹下",
      u8"凹下去",
      u8"凹下来",
      u8"凹凸",
      u8"凹凸不平",
      u8"凹凸感",
      u8"凹凸棒",
      u8"凹凸镜",
      u8"凹凹",
      u8"凹凹凸凸",
      u8"凹印机",
      u8"凹口",
      u8"凹地",
      u8"凹坑",
      u8"凹处",
      u8"凹字",
      u8"凹度",
      u8"凹形",
      u8"凹槽",
      u8"凹槽铁轨",
      u8"凹沟",
      u8"凹洞",
      u8"凹洼",
      u8"凹版",
      u8"凹玻片",
      u8"凹痕",
      u8"凹角",
      u8"凹进",
      u8"凹透",
      u8"凹透镜",
      u8"凹镜",
      u8"凹陷",
      u8"凹陷处",
      u8"凹面",
      u8"凹面镜",
      u8"出一头地",
      u8"出上",
      u8"出下",
      u8"出不去",
      u8"出不来",
      u8"出不起",
      u8"出丑",
      u8"出丑扬疾",
      u8"出丑放乖",
      u8"出世",
      u8"出世作",
      u8"出世离群",
      u8"出世超凡",
      u8"出丧",
      u8"出个",
      u8"出个价",
      u8"出主意",
      u8"出之以诚",
      u8"出乎",
      u8"出乎反乎",
      u8"出乎意外",
      u8"出乎意料",
      u8"出乎意料之外",
      u8"出乎意表",
      u8"出乎预料",
      u8"出乖弄丑",
      u8"出乖露丑",
      u8"出书",
      u8"出乱子",
      u8"出了",
      u8"出了名",
      u8"出了门",
      u8"出事",
      u8"出事地点",
      u8"出于",
      u8"出于公心",
      u8"出于意外",
      u8"出于意表",
      u8"出于无奈",
      u8"出云入泥",
      u8"出亡",
      u8"出产",
      u8"出产地",
      u8"出人",
      u8"出人命",
      u8"出人头地",
      u8"出人意外",
      u8"出人意料",
      u8"出人意表",
      u8"出人望外",
      u8"出仕",
      u8"出以公心",
      u8"出价",
      u8"出任",
      u8"出份子",
      u8"出伏",
      u8"出众",
      u8"出位",
      u8"出何典记",
      u8"出何经典",
      u8"出使",
      u8"出借",
      u8"出借书",
      u8"出入",
      u8"出入人罪",
      u8"出入口",
      u8"出入境",
      u8"出入境检验检疫局",
      u8"出入将相",
      u8"出入无间",
      u8"出入生死",
      u8"出入神鬼",
      u8"出入证",
      u8"出公差",
      u8"出公忘私",
      u8"出关",
      u8"出兵",
      u8"出其不备",
      u8"出其不意",
      u8"出其不意掩其不备",
      u8"出其不意攻其不备",
      u8"出其不意攻其无备",
      u8"出其不虞",
      u8"出具",
      u8"出典",
      u8"出内之吝",
      u8"出军",
      u8"出冷汗",
      u8"出冷门",
      u8"出凡入胜",
      u8"出出",
      u8"出出入入",
      u8"出出律律",
      u8"出出气",
      u8"出出进进",
      u8"出击",
      u8"出刀",
      u8"出刊",
      u8"出列",
      u8"出到",
      u8"出力",
      u8"出力不讨好",
      u8"出动",
      u8"出勤",
      u8"出勤率",
      u8"出包",
      u8"出千",
      u8"出卖",
      u8"出卖人",
      u8"出卖方",
      u8"出卖灵魂",
      u8"出厂",
      u8"出厂价",
      u8"出厂价格",
      u8"出厂日期",
      u8"出去",
      u8"出去时",
      u8"出去玩",
      u8"出双入对",
      u8"出发",
      u8"出发地",
      u8"出发点",
      u8"出口",
      u8"出口产品",
      u8"出口产品基地",
      u8"出口伤人",
      u8"出口值",
      u8"出口儿",
      u8"出口入耳",
      u8"出口创汇",
      u8"出口创汇率",
      u8"出口加工区",
      u8"出口区",
      u8"出口商",
      u8"出口商品",
      u8"出口国",
      u8"出口型",
      u8"出口基地理论",
      u8"出口处",
      u8"出口导向型",
      u8"出口成章",
      u8"出口气",
      u8"出口税",
      u8"出口货",
      u8"出口贸易",
      u8"出口转内销",
      u8"出口部",
      u8"出口配额",
      u8"出口量",
      u8"出口额",
      u8"出台",
      u8"出号",
      u8"出名",
      u8"出名门",
      u8"出品",
      u8"出品人",
      u8"出品商",
      u8"出品地",
      u8"出售",
      u8"出售一空",
      u8"出售摊",
      u8"出唱片",
      u8"出国",
      u8"出国人员",
      u8"出国前",
      u8"出国时",
      u8"出国梦",
      u8"出国深造",
      u8"出国游",
      u8"出国考察",
      u8"出国者",
      u8"出国访问",
      u8"出圈",
      u8"出圈儿",
      u8"出土",
      u8"出土文物",
      u8"出圣入神",
      u8"出在",
      u8"出场",
      u8"出场费",
      u8"出埃及记",
      u8"出城",
      u8"出塞",
      u8"出塞曲",
      u8"出境",
      u8"出境游",
      u8"出境签证",
      u8"出境许可证",
      u8"出境证",
      u8"出境部",
      u8"出声",
      u8"出声思维",
      u8"出声语言",
      u8"出处",
      u8"出处殊涂",
      u8"出处殊途",
      u8"出处语默",
      u8"出处进退",
      u8"出外",
      u8"出外人",
      u8"出外景",
      u8"出头",
      u8"出头之日",
      u8"出头天",
      u8"出头椽子先烂",
      u8"出头露面",
      u8"出头鸟",
      u8"出夷入险",
      u8"出奇",
      u8"出奇不穷",
      u8"出奇划策",
      u8"出奇制胜",
      u8"出奇取胜",
      u8"出奇无穷",
      u8"出奇致胜",
      u8"出奔",
      u8"出奴入主",
      u8"出奶",
      u8"出好",
      u8"出如脱兔",
      u8"出嫁",
      u8"出字",
      u8"出家",
      u8"出家人",
      u8"出将入相",
      u8"出尔反尔",
      u8"出尖",
      u8"出尘",
      u8"出尘不染",
      u8"出尘子",
      u8"出尘脱俗",
      u8"出局",
      u8"出山",
      u8"出山泉水",
      u8"出山济世",
      u8"出岔",
      u8"出岔子",
      u8"出巡",
      u8"出工",
      u8"出工不出力",
      u8"出差",
      u8"出差费",
      u8"出差错",
      u8"出师",
      u8"出师不利",
      u8"出师无名",
      u8"出师有名",
      u8"出师表",
      u8"出帐",
      u8"出帐期",
      u8"出席",
      u8"出席人",
      u8"出席会议",
      u8"出席率",
      u8"出席观看",
      u8"出幽升高",
      u8"出幽迁乔",
      u8"出库",
      u8"出庭",
      u8"出庭作证",
      u8"出庭应讯",
      u8"出弦度",
      u8"出彩",
      u8"出征",
      u8"出徒",
      u8"出得",
      u8"出恭",
      u8"出息",
      u8"出成果",
      u8"出战",
      u8"出手",
      u8"出手不凡",
      u8"出手即是精品",
      u8"出手得卢",
      u8"出报",
      u8"出招",
      u8"出招表",
      u8"出拳",
      u8"出掌",
      u8"出摊",
      u8"出操",
      u8"出操课",
      u8"出敌不意",
      u8"出敌意外",
      u8"出文",
      u8"出文入武",
      u8"出新",
      u8"出新招",
      u8"出新规",
      u8"出月",
      u8"出有",
      u8"出有入无",
      u8"出来",
      u8"出来时",
      u8"出栏",
      u8"出栏数",
      u8"出栏率",
      u8"出树",
      u8"出校",
      u8"出格",
      u8"出榜",
      u8"出次数",
      u8"出此",
      u8"出此下策",
      u8"出死入生",
      u8"出死力",
      u8"出死断亡",
      u8"出殡",
      u8"出殡日",
      u8"出毛病",
      u8"出气",
      u8"出气口",
      u8"出气筒",
      u8"出水",
      u8"出水口",
      u8"出水才看两腿泥",
      u8"出水管",
      u8"出水芙蓉",
      u8"出水量",
      u8"出汗",
      u8"出江",
      u8"出污泥而不染",
      u8"出没",
      u8"出没不定",
      u8"出没不常",
      u8"出没无常",
      u8"出油",
      u8"出油率",
      u8"出油管导向喇叭口",
      u8"出洋",
      u8"出洋相",
      u8"出洞",
      u8"出活",
      u8"出浅入深",
      u8"出浴",
      u8"出海",
      u8"出海口",
      u8"出海打鱼",
      u8"出海捕鱼",
      u8"出淤泥而",
      u8"出淤泥而不染",
      u8"出清",
      u8"出港",
      u8"出港证",
      u8"出游",
      u8"出溜",
      u8"出漏子",
      u8"出演",
      u8"出炉",
      u8"出点",
      u8"出点子",
      u8"出版",
      u8"出版业",
      u8"出版业务",
      u8"出版事业",
      u8"出版公司",
      u8"出版前编目",
      u8"出版单位",
      u8"出版发行",
      u8"出版商",
      u8"出版地缺",
      u8"出版家",
      u8"出版局",
      u8"出版所",
      u8"出版日",
      u8"出版日期",
      u8"出版期缺",
      u8"出版法",
      u8"出版物",
      u8"出版界",
      u8"出版社",
      u8"出版社不详",
      u8"出版社丛集",
      u8"出版社书目",
      u8"出版社清样",
      u8"出版社目录",
      u8"出版社目录卡",
      u8"出版社装祯",
      u8"出版署",
      u8"出版者",
      u8"出版部门",
      u8"出版项",
      u8"出牌",
      u8"出狱",
      u8"出猎",
      u8"出现",
      u8"出现分歧",
      u8"出现在",
      u8"出现场",
      u8"出现异常",
      u8"出现意外",
      u8"出现电势谱学",
      u8"出现问题",
      u8"出球",
      u8"出生",
      u8"出生于",
      u8"出生人数",
      u8"出生入死",
      u8"出生创伤",
      u8"出生地",
      u8"出生地点",
      u8"出生年月",
      u8"出生日期",
      u8"出生率",
      u8"出生纸",
      u8"出生证",
      u8"出生证明",
      u8"出生高峰",
      u8"出界",
      u8"出疹子",
      u8"出盘",
      u8"出省",
      u8"出砂层",
      u8"出示",
      u8"出示证件",
      u8"出社会",
      u8"出神",
      u8"出神入化",
      u8"出神入定",
      u8"出离",
      u8"出科",
      u8"出租",
      u8"出租人",
      u8"出租屋",
      u8"出租店",
      u8"出租房",
      u8"出租方",
      u8"出租汽车",
      u8"出租率",
      u8"出租车",
      u8"出稿",
      u8"出窑",
      u8"出站",
      u8"出笼",
      u8"出类拔萃",
      u8"出粪口",
      u8"出糗",
      u8"出纰漏",
      u8"出纳",
      u8"出纳台",
      u8"出纳员",
      u8"出纳处",
      u8"出纳科",
      u8"出纳系统",
      u8"出纳组",
      u8"出线",
      u8"出线权",
      u8"出给",
      u8"出继",
      u8"出缺",
      u8"出群拔萃",
      u8"出老千",
      u8"出脓",
      u8"出脱",
      u8"出自",
      u8"出自于",
      u8"出自内心",
      u8"出自意外",
      u8"出舆入辇",
      u8"出航",
      u8"出色",
      u8"出色完成",
      u8"出芽",
      u8"出芽法",
      u8"出苗",
      u8"出苗率",
      u8"出落",
      u8"出虚汗",
      u8"出血",
      u8"出血性",
      u8"出血性疾病",
      u8"出血指数",
      u8"出血点",
      u8"出血热",
      u8"出血病",
      u8"出行",
      u8"出行分布",
      u8"出行生成",
      u8"出行者",
      u8"出街",
      u8"出言",
      u8"出言不逊",
      u8"出言吐气",
      u8"出言吐词",
      u8"出言吐语",
      u8"出言成章",
      u8"出言无状",
      u8"出言有章",
      u8"出警",
      u8"出警率",
      u8"出让",
      u8"出让金",
      u8"出访",
      u8"出诊",
      u8"出词吐气",
      u8"出语成章",
      u8"出调",
      u8"出谋划策",
      u8"出谋献策",
      u8"出谋画策",
      u8"出谷迁乔",
      u8"出账",
      u8"出货",
      u8"出货单",
      u8"出货量",
      u8"出费",
      u8"出资",
      u8"出资人",
      u8"出资者",
      u8"出资额",
      u8"出赛",
      u8"出走",
      u8"出起",
      u8"出起来",
      u8"出超",
      u8"出超国",
      u8"出超额",
      u8"出路",
      u8"出身",
      u8"出身高贵",
      u8"出车",
      u8"出车祸",
      u8"出轨",
      u8"出轨行为",
      u8"出过",
      u8"出迎",
      u8"出运",
      u8"出进",
      u8"出远门",
      u8"出逃",
      u8"出道",
      u8"出道时",
      u8"出量",
      u8"出钱",
      u8"出钱出力",
      u8"出铁",
      u8"出锅",
      u8"出锋头",
      u8"出错",
      u8"出错中断",
      u8"出错率",
      u8"出镜率",
      u8"出门",
      u8"出门合辙",
      u8"出门在外",
      u8"出门如宾",
      u8"出门应辙",
      u8"出门时",
      u8"出问题",
      u8"出阁",
      u8"出阵",
      u8"出陈易新",
      u8"出院",
      u8"出险",
      u8"出难题",
      u8"出震继离",
      u8"出面",
      u8"出鞘",
      u8"出韵",
      u8"出项",
      u8"出题",
      u8"出题词",
      u8"出风口",
      u8"出风头",
      u8"出饭",
      u8"出首",
      u8"出马",
      u8"出马上场",
      u8"出马上阵",
      u8"出鬼",
      u8"出鬼入神",
      u8"出齐",
      u8"击中",
      u8"击中要害",
      u8"击伤",
      u8"击倒",
      u8"击其不意",
      u8"击其惰归",
      u8"击出",
      u8"击剌",
      u8"击剑",
      u8"击剑场地",
      u8"击剑队",
      u8"击发",
      u8"击向",
      u8"击坠王",
      u8"击垒",
      u8"击垮",
      u8"击壤鼓腹",
      u8"击天抓地",
      u8"击弦古钢琴",
      u8"击弦机",
      u8"击打",
      u8"击打噪声",
      u8"击打式打印机",
      u8"击掌",
      u8"击排冒没",
      u8"击搏挽裂",
      u8"击撞",
      u8"击昏",
      u8"击杀",
      u8"击板",
      u8"击楫中流",
      u8"击槌",
      u8"击毁",
      u8"击毂摩肩",
      u8"击毙",
      u8"击水",
      u8"击沈",
      u8"击沉",
      u8"击溃",
      u8"击爆",
      u8"击玉敲金",
      u8"击球",
      u8"击球手",
      u8"击电奔星",
      u8"击石弹丝",
      u8"击破",
      u8"击碎",
      u8"击碎唾壶",
      u8"击穿",
      u8"击穿场强",
      u8"击筑",
      u8"击筑悲歌",
      u8"击缶",
      u8"击节",
      u8"击节叹赏",
      u8"击节称赏",
      u8"击落",
      u8"击败",
      u8"击退",
      u8"击钟陈鼎",
      u8"击钟鼎食",
      u8"击钵催诗",
      u8"击错",
      u8"击锣",
      u8"击键",
      u8"击鞭锤镫",
      u8"击鼓",
      u8"击鼓作乐",
      u8"击鼓鸣冤",
      u8"击鼓鸣金",
      u8"函令",
      u8"函件",
      u8"函养",
      u8"函告",
      u8"函商",
      u8"函复",
      u8"函大",
      u8"函寄",
      u8"函括",
      u8"函授",
      u8"函授大学",
      u8"函授学校",
      u8"函授教育",
      u8"函授班",
      u8"函授生",
      u8"函授站",
      u8"函授课",
      u8"函授部",
      u8"函数",
      u8"函数库",
      u8"函梏关",
      u8"函洞",
      u8"函电",
      u8"函盖乾坤",
      u8"函盖充周",
      u8"函矢相攻",
      u8"函索",
      u8"函聘",
      u8"函蕴",
      u8"函调",
      u8"函谷关",
      u8"函购",
      u8"函购量",
      u8"函送",
      u8"函馆",
      u8"凿井",
      u8"凿井机",
      u8"凿冰",
      u8"凿出",
      u8"凿出去",
      u8"凿出来",
      u8"凿凿",
      u8"凿凿可据",
      u8"凿凿有据",
      u8"凿印",
      u8"凿在",
      u8"凿坏以遁",
      u8"凿坏而遁",
      u8"凿坯而遁",
      u8"凿壁偷光",
      u8"凿壁谈婚",
      u8"凿子",
      u8"凿孔",
      u8"凿孔机",
      u8"凿定",
      u8"凿山",
      u8"凿岩",
      u8"凿岩机",
      u8"凿川",
      u8"凿开",
      u8"凿成",
      u8"凿枘",
      u8"凿枘相应",
      u8"凿柱取书",
      u8"凿楹纳书",
      u8"凿沉",
      u8"凿洞",
      u8"凿状切牙",
      u8"凿穴",
      u8"凿空",
      u8"凿空之论",
      u8"凿空取办",
      u8"凿空投隙",
      u8"凿穿",
      u8"凿船",
      u8"凿进",
      u8"凿进去",
      u8"凿进来",
      u8"凿隧入井",
      u8"凿饮耕食",
      u8"凿骨捣髓",
      u8"凿龟数策",
      u8"刀下",
      u8"刀下留人",
      u8"刀下留情",
      u8"刀不刃血",
      u8"刀伤",
      u8"刀俎",
      u8"刀俎余生",
      u8"刀俎鱼肉",
      u8"刀儿",
      u8"刀光",
      u8"刀光剑影",
      u8"刀光血影",
      u8"刀兵",
      u8"刀兵刀叉",
      u8"刀具",
      u8"刀具厂",
      u8"刀具耐用",
      u8"刀刀",
      u8"刀刀见血",
      u8"刀刃",
      u8"刀切斧砍",
      u8"刀刮水洗",
      u8"刀刻",
      u8"刀削",
      u8"刀削面",
      u8"刀剌",
      u8"刀剑",
      u8"刀剑封魔录",
      u8"刀剑笑",
      u8"刀割",
      u8"刀匠",
      u8"刀叉",
      u8"刀口",
      u8"刀口尺",
      u8"刀口浪尖",
      u8"刀头",
      u8"刀头之蜜",
      u8"刀头剑首",
      u8"刀头燕尾",
      u8"刀头舔蜜",
      u8"刀子",
      u8"刀子嘴",
      u8"刀客",
      u8"刀尖",
      u8"刀山",
      u8"刀山剑林",
      u8"刀山剑树",
      u8"刀山火海",
      u8"刀币",
      u8"刀形天线",
      u8"刀把",
      u8"刀把儿",
      u8"刀把子",
      u8"刀数",
      u8"刀斧手",
      u8"刀术",
      u8"刀枪",
      u8"刀枪不入",
      u8"刀枪入库",
      u8"刀枪剑戟",
      u8"刀架",
      u8"刀柄",
      u8"刀械",
      u8"刀棍",
      u8"刀棍齐加",
      u8"刀法",
      u8"刀片",
      u8"刀片式",
      u8"刀疤",
      u8"刀痕",
      u8"刀白凤",
      u8"刀笔",
      u8"刀笔春秋",
      u8"刀箭",
      u8"刀耕火种",
      u8"刀耕火耘",
      u8"刀耕火耨",
      u8"刀背",
      u8"刀螂",
      u8"刀豆",
      u8"刀豆氨酸",
      u8"刀身",
      u8"刀过竹解",
      u8"刀铡",
      u8"刀锋",
      u8"刀锋冷",
      u8"刀锋战士",
      u8"刀锯",
      u8"刀锯斧钺",
      u8"刀面",
      u8"刀鞘",
      u8"刀马旦",
      u8"刀魂",
      u8"刁天决地",
      u8"刁悍",
      u8"刁斗",
      u8"刁斗森严",
      u8"刁横",
      u8"刁民",
      u8"刁滑",
      u8"刁滑奸诈",
      u8"刁猾",
      u8"刁蛮",
      u8"刁诈",
      u8"刁钻",
      u8"刁钻促搯",
      u8"刁钻促狭",
      u8"刁钻刻薄",
      u8"刁钻古怪",
      u8"刁难",
      u8"刁顽",
      u8"刁顽不化",
      u8"刃儿",
      u8"刃具",
      u8"刃口",
      u8"刃树剑山",
      u8"刃片",
      u8"刃脊",
      u8"刃角",
      u8"刃迎缕解",
      u8"刃量具",
      u8"刃量具厂",
      u8"刃锋",
      u8"分一杯",
      u8"分一杯羹",
      u8"分三别两",
      u8"分三步",
      u8"分不出",
      u8"分不开",
      u8"分不清",
      u8"分不清楚",
      u8"分业",
      u8"分业制",
      u8"分丝析缕",
      u8"分个",
      u8"分中心",
      u8"分为",
      u8"分为两叉",
      u8"分久必合",
      u8"分久必合合久必分",
      u8"分之",
      u8"分之一",
      u8"分书",
      u8"分了",
      u8"分享",
      u8"分付",
      u8"分以上",
      u8"分以下",
      u8"分众传媒",
      u8"分会",
      u8"分会场",
      u8"分体",
      u8"分体式",
      u8"分体式空调器",
      u8"分作",
      u8"分保",
      u8"分信",
      u8"分值",
      u8"分做",
      u8"分光",
      u8"分光仪",
      u8"分光光度法",
      u8"分光光度计",
      u8"分光计",
      u8"分光蹈影",
      u8"分光镜",
      u8"分克",
      u8"分党",
      u8"分公司",
      u8"分兵",
      u8"分兵把口",
      u8"分兵把守",
      u8"分内",
      u8"分内之事",
      u8"分内事",
      u8"分内分外",
      u8"分册",
      u8"分出",
      u8"分出去",
      u8"分出层次",
      u8"分出来",
      u8"分分",
      u8"分分秒秒",
      u8"分分钟需要你",
      u8"分切机",
      u8"分划格",
      u8"分列",
      u8"分列为",
      u8"分列式",
      u8"分则",
      u8"分利",
      u8"分别",
      u8"分别为",
      u8"分别出",
      u8"分别安",
      u8"分别开",
      u8"分别部居",
      u8"分别门户",
      u8"分到",
      u8"分剧",
      u8"分割",
      u8"分割为",
      u8"分割器",
      u8"分割线",
      u8"分割肉",
      u8"分割部分",
      u8"分力",
      u8"分劳赴功",
      u8"分匀",
      u8"分包",
      u8"分化",
      u8"分化中心",
      u8"分化成",
      u8"分化抗原",
      u8"分化时",
      u8"分化瓦解",
      u8"分区",
      u8"分区一般照明",
      u8"分区制",
      u8"分区蛋白",
      u8"分区表",
      u8"分区规划",
      u8"分区赛",
      u8"分升",
      u8"分半信度",
      u8"分占",
      u8"分卷",
      u8"分卷压缩",
      u8"分卷压缩包",
      u8"分厂",
      u8"分压力",
      u8"分厘卡",
      u8"分厘毫丝",
      u8"分原因死亡率",
      u8"分去",
      u8"分县",
      u8"分叉",
      u8"分发",
      u8"分发者",
      u8"分句",
      u8"分号",
      u8"分吃",
      u8"分合",
      u8"分唱",
      u8"分团委",
      u8"分国",
      u8"分圆单位",
      u8"分圆多项式",
      u8"分在",
      u8"分地",
      u8"分场",
      u8"分块",
      u8"分块对角矩阵",
      u8"分外",
      u8"分外夺目",
      u8"分外妖娆",
      u8"分外眼红",
      u8"分头",
      u8"分头办理",
      u8"分头去",
      u8"分头来",
      u8"分奏",
      u8"分好",
      u8"分委会",
      u8"分娩",
      u8"分娩台",
      u8"分子",
      u8"分子人类学",
      u8"分子光谱",
      u8"分子力",
      u8"分子反应动力学",
      u8"分子尾",
      u8"分子式",
      u8"分子振荡器",
      u8"分子晶体",
      u8"分子混沌拟设",
      u8"分子热",
      u8"分子物理学",
      u8"分子生物",
      u8"分子生物学",
      u8"分子电流",
      u8"分子病",
      u8"分子碎片法",
      u8"分子磁矩",
      u8"分子离子",
      u8"分子积分",
      u8"分子筛",
      u8"分子结构",
      u8"分子论",
      u8"分子轨道能级",
      u8"分子运动",
      u8"分子运动论",
      u8"分子量",
      u8"分子间作用力",
      u8"分子间缩合",
      u8"分季",
      u8"分守",
      u8"分守要津",
      u8"分宜",
      u8"分宜县",
      u8"分宵达曙",
      u8"分家",
      u8"分家析产",
      u8"分寄",
      u8"分寸",
      u8"分寸之末",
      u8"分寸已乱",
      u8"分对",
      u8"分封",
      u8"分封制",
      u8"分尸",
      u8"分尸案",
      u8"分局",
      u8"分局长",
      u8"分层",
      u8"分层抽样",
      u8"分层设色法",
      u8"分层负责",
      u8"分居",
      u8"分居异爨",
      u8"分屏",
      u8"分属",
      u8"分岐",
      u8"分岔",
      u8"分岔系数",
      u8"分岗",
      u8"分崩离兮",
      u8"分崩离析",
      u8"分工",
      u8"分工会",
      u8"分工协作",
      u8"分工合作",
      u8"分工负责",
      u8"分布",
      u8"分布力",
      u8"分布区",
      u8"分布区中心",
      u8"分布区型",
      u8"分布区间断",
      u8"分布参数网络",
      u8"分布参数集成电路",
      u8"分布图",
      u8"分布式",
      u8"分布式人工智能",
      u8"分布式多媒体",
      u8"分布式排序算法",
      u8"分布式控制",
      u8"分布式数据库",
      u8"分布式程序设计",
      u8"分布式计算机",
      u8"分布电容",
      u8"分布等待图",
      u8"分布负载",
      u8"分帐",
      u8"分带",
      u8"分床",
      u8"分床同梦",
      u8"分床而眠",
      u8"分床而睡",
      u8"分库",
      u8"分店",
      u8"分度",
      u8"分度器",
      u8"分度头",
      u8"分度规",
      u8"分庭",
      u8"分庭亢礼",
      u8"分庭伉礼",
      u8"分庭抗礼",
      u8"分开",
      u8"分开离合器",
      u8"分式",
      u8"分式域",
      u8"分式方程",
      u8"分张",
      u8"分当",
      u8"分录",
      u8"分形共气",
      u8"分形同气",
      u8"分得",
      u8"分得出",
      u8"分得到",
      u8"分得清",
      u8"分心",
      u8"分心挂腹",
      u8"分忧",
      u8"分忧解愁",
      u8"分性别年龄死亡率",
      u8"分情况语句",
      u8"分情破爱",
      u8"分成",
      u8"分成二份",
      u8"分成等级",
      u8"分我杯羹",
      u8"分截",
      u8"分户帐",
      u8"分房",
      u8"分房减口",
      u8"分手",
      u8"分手时",
      u8"分批",
      u8"分批交货",
      u8"分批再循环培养",
      u8"分批分期",
      u8"分批发酵",
      u8"分批培养",
      u8"分批培养物",
      u8"分批工艺",
      u8"分批抽提",
      u8"分批提取",
      u8"分批操作",
      u8"分批法",
      u8"分批消化器",
      u8"分批试验法",
      u8"分批过滤",
      u8"分批进行",
      u8"分担",
      u8"分拆函数",
      u8"分拣",
      u8"分拨",
      u8"分持",
      u8"分指",
      u8"分指数",
      u8"分排",
      u8"分插",
      u8"分摊",
      u8"分支",
      u8"分支机关",
      u8"分支机构",
      u8"分支限界搜索",
      u8"分散",
      u8"分散主义",
      u8"分散介质",
      u8"分散剂",
      u8"分散力",
      u8"分散化",
      u8"分散地",
      u8"分散城市",
      u8"分散学习",
      u8"分散度",
      u8"分散开来",
      u8"分散式处理",
      u8"分散性",
      u8"分散机",
      u8"分散染料",
      u8"分散片",
      u8"分散相",
      u8"分散系统",
      u8"分散聚合",
      u8"分散酶",
      u8"分数",
      u8"分数指数",
      u8"分数次导数",
      u8"分数线",
      u8"分文",
      u8"分文不值",
      u8"分文不取",
      u8"分文不名",
      u8"分文不收",
      u8"分文不直",
      u8"分文未取",
      u8"分斤拨两",
      u8"分斤掰两",
      u8"分日线",
      u8"分时",
      u8"分时动态分配程序",
      u8"分时图",
      u8"分时地址缓冲器",
      u8"分时就绪方式",
      u8"分时控制任务",
      u8"分时操作系统",
      u8"分时系统",
      u8"分时走势图",
      u8"分明",
      u8"分星劈两",
      u8"分星拨两",
      u8"分星擘两",
      u8"分晓",
      u8"分朋引类",
      u8"分期",
      u8"分期付款",
      u8"分期付款购买",
      u8"分期偿付",
      u8"分期分批",
      u8"分期清偿",
      u8"分机",
      u8"分机号",
      u8"分权",
      u8"分条机",
      u8"分条析理",
      u8"分来",
      u8"分来分去",
      u8"分析",
      u8"分析仪",
      u8"分析仪器",
      u8"分析会",
      u8"分析出来",
      u8"分析判断",
      u8"分析化学",
      u8"分析员",
      u8"分析和综",
      u8"分析和综合",
      u8"分析器",
      u8"分析天平",
      u8"分析家",
      u8"分析属性",
      u8"分析师",
      u8"分析性心理治疗",
      u8"分析情况",
      u8"分析攻击",
      u8"分析树",
      u8"分析案情",
      u8"分析法",
      u8"分析画像",
      u8"分析研究",
      u8"分析线",
      u8"分析语",
      u8"分析课文",
      u8"分析阶段",
      u8"分析题",
      u8"分枝",
      u8"分枝杆菌",
      u8"分枝杆菌素",
      u8"分枝菌素",
      u8"分枝菌酸",
      u8"分枝进化",
      u8"分架",
      u8"分栏",
      u8"分校",
      u8"分格",
      u8"分桃",
      u8"分档",
      u8"分次",
      u8"分次施肥",
      u8"分次理想",
      u8"分款",
      u8"分步",
      u8"分步法",
      u8"分步重复系统",
      u8"分歧",
      u8"分段",
      u8"分段印模",
      u8"分段截骨术",
      u8"分段收票",
      u8"分段法",
      u8"分段策略",
      u8"分段运输",
      u8"分段进行",
      u8"分母",
      u8"分毫",
      u8"分毫不值",
      u8"分毫不取",
      u8"分毫不差",
      u8"分毫不爽",
      u8"分毫无爽",
      u8"分毫析厘",
      u8"分水",
      u8"分水器",
      u8"分水岭",
      u8"分水线",
      u8"分水闸",
      u8"分油",
      u8"分治",
      u8"分泌",
      u8"分泌乳汁",
      u8"分泌物",
      u8"分泌管",
      u8"分泌系统",
      u8"分泌素",
      u8"分泌腺",
      u8"分泌自噬",
      u8"分泌量",
      u8"分法",
      u8"分洪",
      u8"分洪河道",
      u8"分洪道",
      u8"分洪闸",
      u8"分派",
      u8"分派任务",
      u8"分流",
      u8"分流制排水系统",
      u8"分流器",
      u8"分流方程",
      u8"分流港",
      u8"分浅缘悭",
      u8"分浅缘薄",
      u8"分润",
      u8"分清",
      u8"分清敌我",
      u8"分清是非",
      u8"分灶",
      u8"分点",
      u8"分烟析产",
      u8"分烟析生",
      u8"分爨",
      u8"分片",
      u8"分片包干",
      u8"分片模式",
      u8"分牌",
      u8"分牙器",
      u8"分牙术",
      u8"分班",
      u8"分班考试",
      u8"分理",
      u8"分理处",
      u8"分甘共苦",
      u8"分甘同苦",
      u8"分甘绝少",
      u8"分生",
      u8"分生孢子",
      u8"分生组织",
      u8"分用",
      u8"分由",
      u8"分电器",
      u8"分界",
      u8"分界点",
      u8"分界线",
      u8"分病毒",
      u8"分登",
      u8"分相",
      u8"分省",
      u8"分社",
      u8"分神",
      u8"分离",
      u8"分离出来",
      u8"分离剂",
      u8"分离单元",
      u8"分离器",
      u8"分离式",
      u8"分离态射",
      u8"分离性",
      u8"分离性公理",
      u8"分离机",
      u8"分离法",
      u8"分离点",
      u8"分离综合征",
      u8"分离舱",
      u8"分种",
      u8"分科",
      u8"分秒",
      u8"分秒不差",
      u8"分秒必争",
      u8"分租",
      u8"分税制",
      u8"分立",
      u8"分立式",
      u8"分立电路",
      u8"分站",
      u8"分站赛",
      u8"分章",
      u8"分章析句",
      u8"分等",
      u8"分等级",
      u8"分管",
      u8"分管领导",
      u8"分箱",
      u8"分篮",
      u8"分米",
      u8"分米波",
      u8"分类",
      u8"分类人员",
      u8"分类单位",
      u8"分类卡",
      u8"分类号",
      u8"分类学",
      u8"分类帐",
      u8"分类广告",
      u8"分类排列",
      u8"分类整理",
      u8"分类机",
      u8"分类法",
      u8"分类目录",
      u8"分类知觉",
      u8"分类程序",
      u8"分类空间",
      u8"分类管理",
      u8"分类箱",
      u8"分类索引",
      u8"分类者",
      u8"分类账",
      u8"分粒器",
      u8"分系统",
      u8"分红",
      u8"分红险",
      u8"分级",
      u8"分级分离",
      u8"分级分类",
      u8"分级制",
      u8"分级制度",
      u8"分级机",
      u8"分级淬火",
      u8"分级网",
      u8"分级设计法",
      u8"分线",
      u8"分线盒",
      u8"分线盘",
      u8"分线规",
      u8"分组",
      u8"分组会",
      u8"分组活动",
      u8"分组码",
      u8"分组讨论",
      u8"分组赛",
      u8"分给",
      u8"分维",
      u8"分网",
      u8"分置",
      u8"分署",
      u8"分群",
      u8"分而治之",
      u8"分肥",
      u8"分至",
      u8"分至点",
      u8"分色",
      u8"分色片",
      u8"分色镜",
      u8"分节",
      u8"分节歌",
      u8"分花拂柳",
      u8"分花约柳",
      u8"分茅列土",
      u8"分茅胙土",
      u8"分茅裂土",
      u8"分茅赐土",
      u8"分茅锡土",
      u8"分获",
      u8"分菜",
      u8"分葱",
      u8"分蘖",
      u8"分蘖力",
      u8"分蘖期",
      u8"分蘖节",
      u8"分行",
      u8"分被",
      u8"分裂",
      u8"分裂为",
      u8"分裂主义",
      u8"分裂因子组",
      u8"分裂型人格障碍",
      u8"分裂性",
      u8"分裂李代数",
      u8"分裂法",
      u8"分裂症",
      u8"分裂细胞",
      u8"分装",
      u8"分规",
      u8"分角器",
      u8"分解",
      u8"分解为",
      u8"分解代谢",
      u8"分解力",
      u8"分解器",
      u8"分解成",
      u8"分解掉",
      u8"分解者",
      u8"分解表",
      u8"分设",
      u8"分词",
      u8"分词器",
      u8"分词构句",
      u8"分说",
      u8"分课",
      u8"分贝",
      u8"分账",
      u8"分贫振穷",
      u8"分赃",
      u8"分赃不均",
      u8"分赛区",
      u8"分走",
      u8"分赴",
      u8"分起",
      u8"分起来",
      u8"分路",
      u8"分路扬镳",
      u8"分身",
      u8"分身乏术",
      u8"分身减口",
      u8"分身无术",
      u8"分身术",
      u8"分车",
      u8"分车带绿化",
      u8"分载",
      u8"分辨",
      u8"分辨力",
      u8"分辨善恶",
      u8"分辨时间",
      u8"分辨是非",
      u8"分辨本领",
      u8"分辨率",
      u8"分辨真假",
      u8"分辩",
      u8"分辩率",
      u8"分边",
      u8"分过",
      u8"分过去",
      u8"分过来",
      u8"分运",
      u8"分进",
      u8"分进合击",
      u8"分送",
      u8"分选",
      u8"分途",
      u8"分速度",
      u8"分道",
      u8"分道扬镖",
      u8"分道扬镳",
      u8"分遣队",
      u8"分部",
      u8"分配",
      u8"分配不公",
      u8"分配任务",
      u8"分配关系",
      u8"分配利润",
      u8"分配制度",
      u8"分配原则",
      u8"分配器",
      u8"分配奖品",
      u8"分配工作",
      u8"分配律",
      u8"分配性注意",
      u8"分配情况",
      u8"分配权",
      u8"分配格",
      u8"分配比例",
      u8"分配水平",
      u8"分配率",
      u8"分配程序",
      u8"分配给",
      u8"分配阀",
      u8"分野",
      u8"分量",
      u8"分金",
      u8"分金宴",
      u8"分金掰两",
      u8"分针",
      u8"分钗劈凤",
      u8"分钗断带",
      u8"分钗破镜",
      u8"分钟",
      u8"分钟时段",
      u8"分钱",
      u8"分销",
      u8"分销商",
      u8"分销店",
      u8"分镜头",
      u8"分长",
      u8"分门",
      u8"分门别户",
      u8"分门别类",
      u8"分队",
      u8"分队长",
      u8"分阴",
      u8"分阶段",
      u8"分际",
      u8"分院",
      u8"分隔",
      u8"分隔符",
      u8"分隔线",
      u8"分集",
      u8"分鞋破镜",
      u8"分页",
      u8"分领",
      u8"分频",
      u8"分频器",
      u8"分风劈流",
      u8"分飞",
      u8"分飞燕",
      u8"分食",
      u8"分餐",
      u8"分餐制",
      u8"分饰",
      u8"分饰两角",
      u8"分馆",
      u8"分馏",
      u8"分馏器",
      u8"分馏塔",
      u8"分馏法",
      u8"分香卖履",
      u8"分驾",
      u8"分龄",
      u8"切上",
      u8"切上去",
      u8"切上来",
      u8"切下",
      u8"切下去",
      u8"切下来",
      u8"切不",
      u8"切不可",
      u8"切丝",
      u8"切个",
      u8"切中",
      u8"切中时弊",
      u8"切中时病",
      u8"切中肯綮",
      u8"切中要害",
      u8"切事",
      u8"切入",
      u8"切入口",
      u8"切入点",
      u8"切出",
      u8"切出去",
      u8"切出来",
      u8"切分",
      u8"切分音",
      u8"切切",
      u8"切切在心",
      u8"切切实实",
      u8"切切此布",
      u8"切切私语",
      u8"切到",
      u8"切削",
      u8"切削力",
      u8"切削性能",
      u8"切削机",
      u8"切削油",
      u8"切削液",
      u8"切削用量",
      u8"切削角",
      u8"切削速度",
      u8"切削面",
      u8"切割",
      u8"切割刀",
      u8"切割器",
      u8"切割成",
      u8"切割机",
      u8"切割片",
      u8"切勿",
      u8"切厚",
      u8"切去",
      u8"切变",
      u8"切变结构",
      u8"切口",
      u8"切叶机",
      u8"切合",
      u8"切合实际",
      u8"切合需要",
      u8"切向加速度",
      u8"切向应力",
      u8"切圆",
      u8"切块",
      u8"切宜",
      u8"切实",
      u8"切实做好",
      u8"切实加强",
      u8"切实可行",
      u8"切实地",
      u8"切实增强",
      u8"切实有力",
      u8"切实有效",
      u8"切实落实",
      u8"切实际",
      u8"切导",
      u8"切导斜度",
      u8"切导盘",
      u8"切导针",
      u8"切尔西",
      u8"切尔西队",
      u8"切尔诺贝利",
      u8"切屑",
      u8"切开",
      u8"切开术",
      u8"切当",
      u8"切忌",
      u8"切成",
      u8"切换",
      u8"切换器",
      u8"切换键",
      u8"切掉",
      u8"切断",
      u8"切断机",
      u8"切断阀",
      u8"切时",
      u8"切望",
      u8"切树倒根",
      u8"切比雪夫加速法",
      u8"切比雪夫半径",
      u8"切比雪夫滤波器",
      u8"切汇",
      u8"切点",
      u8"切片",
      u8"切片机",
      u8"切片检查",
      u8"切牙",
      u8"切理会心",
      u8"切理厌心",
      u8"切理餍心",
      u8"切瑳琢磨",
      u8"切直",
      u8"切盼",
      u8"切碎",
      u8"切磋",
      u8"切磋琢磨",
      u8"切端支托",
      u8"切端沟",
      u8"切粒机",
      u8"切糕",
      u8"切纸",
      u8"切纸刀",
      u8"切纸机",
      u8"切线",
      u8"切细",
      u8"切结",
      u8"切缘",
      u8"切缘结节",
      u8"切肉",
      u8"切肉刀",
      u8"切肤",
      u8"切肤之痛",
      u8"切脉",
      u8"切腹",
      u8"切腹自杀",
      u8"切花",
      u8"切莫",
      u8"切菜",
      u8"切菜刀",
      u8"切菜机",
      u8"切菜板",
      u8"切要",
      u8"切角",
      u8"切记",
      u8"切诊",
      u8"切诺基",
      u8"切起",
      u8"切起来",
      u8"切身",
      u8"切身体会",
      u8"切身利益",
      u8"切身得益",
      u8"切身感受",
      u8"切身经验",
      u8"切边",
      u8"切过",
      u8"切过去",
      u8"切过来",
      u8"切近",
      u8"切近的当",
      u8"切进",
      u8"切进去",
      u8"切进来",
      u8"切送",
      u8"切道",
      u8"切道斜度",
      u8"切错",
      u8"切锥",
      u8"切除",
      u8"切除性牙周膜新附着术",
      u8"切除术",
      u8"切面",
      u8"切音",
      u8"切题",
      u8"切骨之仇",
      u8"切齐",
      u8"切齿",
      u8"切齿拊心",
      u8"切齿痛心",
      u8"切齿痛恨",
      u8"切齿腐心",
      u8"刈包",
      u8"刈稻",
      u8"刈草",
      u8"刈草机",
      u8"刈除",
      u8"刊了",
      u8"刊些",
      u8"刊出",
      u8"刊出来",
      u8"刊到",
      u8"刊印",
      u8"刊发",
      u8"刊号",
      u8"刊名",
      u8"刊后语",
      u8"刊在",
      u8"刊头",
      u8"刊布",
      u8"刊心刻骨",
      u8"刊授",
      u8"刊授大学",
      u8"刊本",
      u8"刊正",
      u8"刊物",
      u8"刊用",
      u8"刊登",
      u8"刊着",
      u8"刊行",
      u8"刊误",
      u8"刊误表",
      u8"刊谬补缺",
      u8"刊起",
      u8"刊载",
      u8"刊过",
      u8"刊错",
      u8"刊首语",
      u8"刍狗",
      u8"刍秣",
      u8"刍粮",
      u8"刍草",
      u8"刍荛",
      u8"刍荛之见",
      u8"刍荛之言",
      u8"刍言",
      u8"刍议",
      u8"刎颈",
      u8"刎颈之交",
      u8"刑书",
      u8"刑事",
      u8"刑事侦察",
      u8"刑事侦缉档案",
      u8"刑事判决",
      u8"刑事判决书",
      u8"刑事处分",
      u8"刑事拘留",
      u8"刑事案",
      u8"刑事案件",
      u8"刑事法",
      u8"刑事法庭",
      u8"刑事法律",
      u8"刑事犯",
      u8"刑事犯罪",
      u8"刑事犯罪分子",
      u8"刑事申诉案件",
      u8"刑事科学",
      u8"刑事管辖",
      u8"刑事管辖权",
      u8"刑事警察",
      u8"刑事诉讼",
      u8"刑事诉讼法",
      u8"刑事责任",
      u8"刑事赔偿",
      u8"刑事追究",
      u8"刑事附带民事诉讼",
      u8"刑于之化",
      u8"刑余之人",
      u8"刑侦",
      u8"刑侦局",
      u8"刑侦队",
      u8"刑具",
      u8"刑典",
      u8"刑吉田",
      u8"刑名",
      u8"刑场",
      u8"刑天争神",
      u8"刑庭",
      u8"刑律",
      u8"刑戮",
      u8"刑房",
      u8"刑拘",
      u8"刑措不用",
      u8"刑期",
      u8"刑期无刑",
      u8"刑案",
      u8"刑法",
      u8"刑法典",
      u8"刑法学",
      u8"刑法学家",
      u8"刑法志",
      u8"刑满释放",
      u8"刑种",
      u8"刑罚",
      u8"刑罚威慑力",
      u8"刑罚学",
      u8"刑警",
      u8"刑警大队",
      u8"刑警支队",
      u8"刑警队",
      u8"刑讯",
      u8"刑讯逼供",
      u8"刑诉法",
      u8"刑责",
      u8"刑辱",
      u8"刑道栄",
      u8"刑部",
      u8"刑部侍郎",
      u8"刑释解教",
      u8"刑鼎",
      u8"划一",
      u8"划一不二",
      u8"划上",
      u8"划下",
      u8"划不来",
      u8"划为",
      u8"划了",
      u8"划付",
      u8"划价",
      u8"划伤",
      u8"划入",
      u8"划具",
      u8"划出",
      u8"划出界限",
      u8"划分",
      u8"划分界线",
      u8"划分算法",
      u8"划划",
      u8"划到",
      u8"划动",
      u8"划去",
      u8"划回",
      u8"划在",
      u8"划地",
      u8"划地为牢",
      u8"划地自限",
      u8"划奖",
      u8"划子",
      u8"划定",
      u8"划帐",
      u8"划开",
      u8"划归",
      u8"划得来",
      u8"划成",
      u8"划手",
      u8"划拉",
      u8"划拨",
      u8"划拨帐号",
      u8"划拳",
      u8"划掉",
      u8"划时代",
      u8"划来划去",
      u8"划框框",
      u8"划桨",
      u8"划款",
      u8"划段",
      u8"划水",
      u8"划法",
      u8"划清",
      u8"划清界线",
      u8"划清界限",
      u8"划片",
      u8"划界",
      u8"划痕",
      u8"划的来",
      u8"划着",
      u8"划着走",
      u8"划破",
      u8"划等号",
      u8"划策",
      u8"划算",
      u8"划粉",
      u8"划粥割齑",
      u8"划线",
      u8"划线支票",
      u8"划船",
      u8"划艇",
      u8"划艇座板",
      u8"划行",
      u8"划走",
      u8"划起",
      u8"划起来",
      u8"划足",
      u8"划转",
      u8"划过",
      u8"划过去",
      u8"划过来",
      u8"划进",
      u8"划进去",
      u8"划进来",
      u8"刖趾适履",
      u8"刖趾适屦",
      u8"列一警百",
      u8"列上",
      u8"列上去",
      u8"列上来",
      u8"列为",
      u8"列举",
      u8"列举如下",
      u8"列举如右",
      u8"列了",
      u8"列于",
      u8"列伊",
      u8"列传",
      u8"列位",
      u8"列作",
      u8"列侯",
      u8"列克斯",
      u8"列克谢",
      u8"列入",
      u8"列兵",
      u8"列出",
      u8"列出来",
      u8"列到",
      u8"列功覆过",
      u8"列印",
      u8"列印机",
      u8"列名",
      u8"列国",
      u8"列国志",
      u8"列土分茅",
      u8"列土封疆",
      u8"列块",
      u8"列增",
      u8"列夫",
      u8"列奥纳多",
      u8"列女",
      u8"列子",
      u8"列宁",
      u8"列宁主义",
      u8"列宁全集",
      u8"列宁格勒",
      u8"列宁选集",
      u8"列宗",
      u8"列岛",
      u8"列席",
      u8"列席代表",
      u8"列席会议",
      u8"列式",
      u8"列强",
      u8"列当",
      u8"列恩",
      u8"列成",
      u8"列报",
      u8"列支",
      u8"列支敦士登",
      u8"列斯联",
      u8"列方程",
      u8"列日",
      u8"列明",
      u8"列星",
      u8"列有",
      u8"列柱围廊式",
      u8"列梅兹算法",
      u8"列甯格勒",
      u8"列确",
      u8"列示",
      u8"列祖",
      u8"列祖列宗",
      u8"列管",
      u8"列管式",
      u8"列管流氓",
      u8"列维",
      u8"列编",
      u8"列缺",
      u8"列表",
      u8"列表机",
      u8"列表框",
      u8"列计",
      u8"列记",
      u8"列译码",
      u8"列译码器",
      u8"列调",
      u8"列账",
      u8"列车",
      u8"列车信息",
      u8"列车员",
      u8"列车时",
      u8"列车时刻",
      u8"列车时刻表",
      u8"列车票价",
      u8"列车管理信息系统",
      u8"列车自动控制系统",
      u8"列车自动防护系统",
      u8"列车自动驾驶系统",
      u8"列车表",
      u8"列车车次",
      u8"列车长",
      u8"列那",
      u8"列队",
      u8"列队欢迎",
      u8"列队行进",
      u8"列项",
      u8"列风淫雨",
      u8"列鼎而食",
      u8"刘一",
      u8"刘一舟",
      u8"刘丹",
      u8"刘丽英",
      u8"刘义庆",
      u8"刘之余",
      u8"刘之冰",
      u8"刘乘风",
      u8"刘云山",
      u8"刘亚楼",
      u8"刘亚津",
      u8"刘亚洲",
      u8"刘亦婷",
      u8"刘仁",
      u8"刘以达",
      u8"刘仪伟",
      u8"刘仲藜",
      u8"刘伟",
      u8"刘伟仁",
      u8"刘伟强",
      u8"刘伯承",
      u8"刘伯温",
      u8"刘体纯",
      u8"刘佩琦",
      u8"刘佩琪",
      u8"刘佳",
      u8"刘俊哲",
      u8"刘元鹤",
      u8"刘兆铭",
      u8"刘先生",
      u8"刘公岛",
      u8"刘其兵",
      u8"刘冠雄",
      u8"刘利民",
      u8"刘剑锋",
      u8"刘劭希",
      u8"刘劲",
      u8"刘勇",
      u8"刘勇以后",
      u8"刘勰",
      u8"刘华强",
      u8"刘华清",
      u8"刘华秋",
      u8"刘向",
      u8"刘品言",
      u8"刘嘉玲",
      u8"刘国光",
      u8"刘国强",
      u8"刘坤一",
      u8"刘培生",
      u8"刘基",
      u8"刘墉",
      u8"刘处玄",
      u8"刘备",
      u8"刘备借荆州",
      u8"刘复之",
      u8"刘大为",
      u8"刘大妈",
      u8"刘天华",
      u8"刘天池",
      u8"刘女士",
      u8"刘姥姥",
      u8"刘姥姥进大观园",
      u8"刘威",
      u8"刘子枫",
      u8"刘孜",
      u8"刘季云",
      u8"刘守斌",
      u8"刘安",
      u8"刘安东",
      u8"刘宋",
      u8"刘宗敏",
      u8"刘宝华",
      u8"刘家仁",
      u8"刘家圪瘩",
      u8"刘家峡",
      u8"刘家良",
      u8"刘家辉",
      u8"刘寄奴",
      u8"刘小姐",
      u8"刘小宁",
      u8"刘小峰",
      u8"刘小枫",
      u8"刘小锋",
      u8"刘少君",
      u8"刘少奇",
      u8"刘峙",
      u8"刘峰岩",
      u8"刘师培",
      u8"刘庄",
      u8"刘庄村",
      u8"刘庆生",
      u8"刘延东",
      u8"刘建军",
      u8"刘建明",
      u8"刘建生",
      u8"刘德凯",
      u8"刘德华",
      u8"刘徽",
      u8"刘心悠",
      u8"刘心武",
      u8"刘志丹",
      u8"刘志军",
      u8"刘志刚",
      u8"刘志华",
      u8"刘志坚",
      u8"刘志强",
      u8"刘志荣",
      u8"刘忠德",
      u8"刘念友",
      u8"刘怀正",
      u8"刘恒林",
      u8"刘恺威",
      u8"刘慈欣",
      u8"刘承俊",
      u8"刘招华",
      u8"刘振亚",
      u8"刘振华",
      u8"刘敖",
      u8"刘文彩",
      u8"刘文正",
      u8"刘文治",
      u8"刘文波",
      u8"刘斌",
      u8"刘斐",
      u8"刘新民",
      u8"刘方仁",
      u8"刘於义",
      u8"刘昆",
      u8"刘昌伟",
      u8"刘明康",
      u8"刘明祖",
      u8"刘易斯",
      u8"刘春明",
      u8"刘春晓",
      u8"刘晏",
      u8"刘晓庆",
      u8"刘晓波",
      u8"刘晓烨",
      u8"刘晓贞",
      u8"刘智泰",
      u8"刘松仁",
      u8"刘枫",
      u8"刘桥",
      u8"刘欢",
      u8"刘欣",
      u8"刘正风",
      u8"刘毅答诏",
      u8"刘毓滨",
      u8"刘水泉",
      u8"刘永清",
      u8"刘永生",
      u8"刘汉元",
      u8"刘汉强",
      u8"刘江",
      u8"刘江涛",
      u8"刘沁",
      u8"刘泽民",
      u8"刘洁",
      u8"刘洵",
      u8"刘海",
      u8"刘海儿",
      u8"刘海峰",
      u8"刘海洋",
      u8"刘海粟",
      u8"刘海若",
      u8"刘涛",
      u8"刘淇",
      u8"刘淑仪",
      u8"刘渊",
      u8"刘湘",
      u8"刘澜涛",
      u8"刘炳森",
      u8"刘爱玲",
      u8"刘玄",
      u8"刘玄处",
      u8"刘玉玲",
      u8"刘玉翠",
      u8"刘琨",
      u8"刘琳",
      u8"刘琼",
      u8"刘瑛姑",
      u8"刘瑞琪",
      u8"刘白羽",
      u8"刘禅",
      u8"刘福通",
      u8"刘禹锡",
      u8"刘秀",
      u8"刘积斌",
      u8"刘竹庄",
      u8"刘索拉",
      u8"刘统勋",
      u8"刘维尔定理",
      u8"刘维尔方程",
      u8"刘罗锅",
      u8"刘美君",
      u8"刘美娟",
      u8"刘老师",
      u8"刘老根",
      u8"刘耕宏",
      u8"刘聪",
      u8"刘胡兰",
      u8"刘艺",
      u8"刘芊蒂",
      u8"刘芳亮",
      u8"刘芹",
      u8"刘若英",
      u8"刘莉莉",
      u8"刘菁",
      u8"刘蓓",
      u8"刘薇",
      u8"刘薇薇",
      u8"刘虹桦",
      u8"刘表",
      u8"刘裕",
      u8"刘诗昆",
      u8"刘语杰",
      u8"刘邦",
      u8"刘郎前度",
      u8"刘金兰",
      u8"刘金山",
      u8"刘銮雄",
      u8"刘铭传",
      u8"刘锡明",
      u8"刘锡田",
      u8"刘锡荣",
      u8"刘锦玲",
      u8"刘长乐",
      u8"刘长卿",
      u8"刘雅丽",
      u8"刘雪华",
      u8"刘震",
      u8"刘青云",
      u8"刘青山",
      u8"刘项",
      u8"刘领路",
      u8"刘鹤真",
      u8"则不",
      u8"则为",
      u8"则从",
      u8"则以",
      u8"则会",
      u8"则例",
      u8"则又",
      u8"则取",
      u8"则可",
      u8"则否",
      u8"则在",
      u8"则声",
      u8"则声明",
      u8"则天",
      u8"则安之",
      u8"则将",
      u8"则已",
      u8"则应",
      u8"则指",
      u8"则按",
      u8"则无",
      u8"则是",
      u8"则曰",
      u8"则有",
      u8"则没",
      u8"则甚",
      u8"则用",
      u8"则由",
      u8"则能",
      u8"则要",
      u8"则要求",
      u8"则还",
      u8"则需",
      u8"刚中柔外",
      u8"刚为",
      u8"刚乾",
      u8"刚从",
      u8"刚会",
      u8"刚估",
      u8"刚体",
      u8"刚体自由运动",
      u8"刚使",
      u8"刚健",
      u8"刚关",
      u8"刚内方外",
      u8"刚出",
      u8"刚出去",
      u8"刚出来",
      u8"刚出狱",
      u8"刚出生",
      u8"刚出道",
      u8"刚刚",
      u8"刚刚在",
      u8"刚刚好",
      u8"刚刚开始",
      u8"刚刚是",
      u8"刚到",
      u8"刚办",
      u8"刚加",
      u8"刚劲",
      u8"刚劲有力",
      u8"刚勇",
      u8"刚化原理",
      u8"刚印",
      u8"刚去",
      u8"刚取",
      u8"刚回",
      u8"刚回到",
      u8"刚回去",
      u8"刚回来",
      u8"刚在",
      u8"刚够",
      u8"刚夹",
      u8"刚好",
      u8"刚好在",
      u8"刚好是",
      u8"刚娶",
      u8"刚嫁",
      u8"刚完",
      u8"刚定",
      u8"刚察",
      u8"刚察县",
      u8"刚就",
      u8"刚巧",
      u8"刚度",
      u8"刚开始",
      u8"刚强",
      u8"刚性",
      u8"刚性杆",
      u8"刚性链",
      u8"刚性防水屋面",
      u8"刚愎",
      u8"刚愎自用",
      u8"刚成",
      u8"刚成立",
      u8"刚戾自用",
      u8"刚才",
      u8"刚才在",
      u8"刚才是",
      u8"刚扣",
      u8"刚抢",
      u8"刚抬",
      u8"刚搬",
      u8"刚撕",
      u8"刚晶",
      u8"刚来",
      u8"刚来时",
      u8"刚板硬正",
      u8"刚果",
      u8"刚果共和国",
      u8"刚果惊魂",
      u8"刚果民主共和国",
      u8"刚果河",
      u8"刚果红",
      u8"刚架",
      u8"刚柔",
      u8"刚柔并济",
      u8"刚柔相济",
      u8"刚正",
      u8"刚正不阿",
      u8"刚死",
      u8"刚毅",
      u8"刚毅不屈",
      u8"刚毅木纳",
      u8"刚毅木讷",
      u8"刚毛",
      u8"刚溼",
      u8"刚满",
      u8"刚灌",
      u8"刚烈",
      u8"刚烧",
      u8"刚玉",
      u8"刚玩",
      u8"刚盛",
      u8"刚直",
      u8"刚直不阿",
      u8"刚相",
      u8"刚石",
      u8"刚硬",
      u8"刚肠嫉恶",
      u8"刚背",
      u8"刚蒸",
      u8"刚补",
      u8"刚被",
      u8"刚要",
      u8"刚订",
      u8"刚试",
      u8"刚读",
      u8"刚贴",
      u8"刚赐",
      u8"刚赢",
      u8"刚走",
      u8"刚赶",
      u8"刚跑",
      u8"刚过",
      u8"刚过去",
      u8"刚过来",
      u8"刚醒",
      u8"刚铺",
      u8"刚锯",
      u8"刚镀",
      u8"刚雇",
      u8"刚颁",
      u8"刚领",
      u8"刚风",
      u8"创一流",
      u8"创下",
      u8"创世",
      u8"创世神",
      u8"创世纪",
      u8"创业",
      u8"创业史",
      u8"创业垂统",
      u8"创业基金",
      u8"创业家",
      u8"创业板",
      u8"创业楷模",
      u8"创业精神",
      u8"创业维艰",
      u8"创业网",
      u8"创业者",
      u8"创业项目",
      u8"创举",
      u8"创产值",
      u8"创价",
      u8"创优",
      u8"创优质服务",
      u8"创伤",
      u8"创伤外科",
      u8"创伤性",
      u8"创伤性口炎",
      u8"创作",
      u8"创作人",
      u8"创作力",
      u8"创作实践",
      u8"创作室",
      u8"创作家",
      u8"创作才能",
      u8"创作技巧",
      u8"创作方法",
      u8"创作界",
      u8"创作经验",
      u8"创作者",
      u8"创作自由",
      u8"创佳",
      u8"创例",
      u8"创先争优",
      u8"创出",
      u8"创刊",
      u8"创刊号",
      u8"创刊词",
      u8"创利",
      u8"创利税",
      u8"创制",
      u8"创制权",
      u8"创剧痛深",
      u8"创办",
      u8"创办人",
      u8"创办者",
      u8"创办资本",
      u8"创化",
      u8"创历史最高水平",
      u8"创历史最高纪录",
      u8"创历史最高记录",
      u8"创口",
      u8"创名牌",
      u8"创始",
      u8"创始人",
      u8"创始者",
      u8"创安",
      u8"创安小区",
      u8"创巨痛仍",
      u8"创巨痛深",
      u8"创建",
      u8"创建人",
      u8"创建快捷方式",
      u8"创建活动",
      u8"创建者",
      u8"创建表格",
      u8"创意",
      u8"创意作品",
      u8"创意曲",
      u8"创意设计",
      u8"创意造言",
      u8"创收",
      u8"创效",
      u8"创新",
      u8"创新作品",
      u8"创新奖",
      u8"创新纪录",
      u8"创新高",
      u8"创术",
      u8"创校",
      u8"创汇",
      u8"创汇率",
      u8"创汇额",
      u8"创演",
      u8"创牌子",
      u8"创生",
      u8"创生科技",
      u8"创痍未寥",
      u8"创痍满目",
      u8"创痕",
      u8"创痛",
      u8"创立",
      u8"创立人",
      u8"创立出",
      u8"创立者",
      u8"创纪录",
      u8"创维",
      u8"创编",
      u8"创见",
      u8"创记录",
      u8"创设",
      u8"创说",
      u8"创通",
      u8"创造",
      u8"创造人",
      u8"创造出",
      u8"创造力",
      u8"创造发明",
      u8"创造学",
      u8"创造性",
      u8"创造性劳动",
      u8"创造性地",
      u8"创造性思维",
      u8"创造成",
      u8"创造才能",
      u8"创造条件",
      u8"创造物",
      u8"创造精神",
      u8"创造者",
      u8"创造财富",
      u8"创钜痛仍",
      u8"创钜痛深",
      u8"创面",
      u8"初一",
      u8"初一学生",
      u8"初一级",
      u8"初一英语",
      u8"初七",
      u8"初三",
      u8"初三化学",
      u8"初三级",
      u8"初上",
      u8"初中",
      u8"初中化学",
      u8"初中历史",
      u8"初中文化",
      u8"初中版",
      u8"初中生",
      u8"初中生物",
      u8"初中级",
      u8"初中英语",
      u8"初中试卷",
      u8"初中语文",
      u8"初中部",
      u8"初为人",
      u8"初九",
      u8"初乳",
      u8"初乳激肽",
      u8"初二",
      u8"初二级",
      u8"初亏",
      u8"初五",
      u8"初交",
      u8"初产妇",
      u8"初任",
      u8"初任检察官",
      u8"初伏",
      u8"初会",
      u8"初会乍练",
      u8"初传",
      u8"初体验",
      u8"初侵染",
      u8"初值",
      u8"初值问题",
      u8"初八",
      u8"初六",
      u8"初具",
      u8"初具规模",
      u8"初写黄庭",
      u8"初冬",
      u8"初出",
      u8"初出茅庐",
      u8"初出茅芦",
      u8"初刊",
      u8"初创",
      u8"初到",
      u8"初加工",
      u8"初十",
      u8"初印",
      u8"初印模",
      u8"初叶",
      u8"初号机",
      u8"初启程序",
      u8"初吻",
      u8"初唐",
      u8"初四",
      u8"初基",
      u8"初夏",
      u8"初夜",
      u8"初夜权",
      u8"初始",
      u8"初始值",
      u8"初始化",
      u8"初始密码",
      u8"初始条件",
      u8"初始模型",
      u8"初始段",
      u8"初始流形",
      u8"初始程序装入",
      u8"初始装入",
      u8"初婚",
      u8"初学",
      u8"初学人员",
      u8"初学者",
      u8"初定",
      u8"初审",
      u8"初小",
      u8"初小文化",
      u8"初年",
      u8"初度",
      u8"初建",
      u8"初开",
      u8"初开始",
      u8"初征",
      u8"初心",
      u8"初恋",
      u8"初恋女友",
      u8"初恋情人",
      u8"初愿",
      u8"初战",
      u8"初战告捷",
      u8"初掌",
      u8"初探",
      u8"初日",
      u8"初旬",
      u8"初时",
      u8"初春",
      u8"初春时节",
      u8"初显",
      u8"初晓",
      u8"初晴",
      u8"初更",
      u8"初月",
      u8"初期",
      u8"初期保险费",
      u8"初来乍到",
      u8"初来者",
      u8"初校样",
      u8"初样",
      u8"初检",
      u8"初模型",
      u8"初次",
      u8"初次免疫反应",
      u8"初次应答",
      u8"初次见面",
      u8"初步",
      u8"初步判断",
      u8"初步成效",
      u8"初步查明",
      u8"初步统计",
      u8"初步编目",
      u8"初步解决",
      u8"初步设计",
      u8"初步阶段",
      u8"初段",
      u8"初民",
      u8"初演",
      u8"初潮",
      u8"初版",
      u8"初版书",
      u8"初犯",
      u8"初献",
      u8"初现",
      u8"初生",
      u8"初生之犊",
      u8"初生之犊不怕虎",
      u8"初生之犊不惧虎",
      u8"初生之犊不畏虎",
      u8"初生壁",
      u8"初生态",
      u8"初生牛犊",
      u8"初生牛犊不怕虎",
      u8"初生牛犊不畏虎",
      u8"初生犊",
      u8"初生生长",
      u8"初生细胞壁",
      u8"初相遇",
      u8"初祖",
      u8"初秋",
      u8"初稿",
      u8"初等",
      u8"初等交换群",
      u8"初等变换",
      u8"初等子模型",
      u8"初等教育",
      u8"初等数学",
      u8"初等矩阵",
      u8"初级",
      u8"初级中学",
      u8"初级产品",
      u8"初级卵母细胞",
      u8"初级小学",
      u8"初级性比",
      u8"初级成分",
      u8"初级教程",
      u8"初级溶酶体",
      u8"初级班",
      u8"初级社",
      u8"初级精母细胞",
      u8"初级线圈",
      u8"初级职称",
      u8"初级苷",
      u8"初级读本",
      u8"初级转录物",
      u8"初级辐射器",
      u8"初级输出",
      u8"初级错误",
      u8"初级阶段",
      u8"初级阶段论",
      u8"初级阶级",
      u8"初绽",
      u8"初缩",
      u8"初聊",
      u8"初航",
      u8"初芽",
      u8"初血",
      u8"初衷",
      u8"初装",
      u8"初装费",
      u8"初见",
      u8"初见成效",
      u8"初见端倪",
      u8"初记",
      u8"初访",
      u8"初评",
      u8"初识",
      u8"初诊",
      u8"初试",
      u8"初试啼声",
      u8"初试锋芒",
      u8"初赛",
      u8"初选",
      u8"初速",
      u8"初速度",
      u8"初逢",
      u8"初长成",
      u8"初阶",
      u8"初雪",
      u8"初露",
      u8"初露头角",
      u8"初露锋芒",
      u8"初高中",
      u8"删了",
      u8"删些",
      u8"删减",
      u8"删减成",
      u8"删削",
      u8"删剪",
      u8"删华就素",
      u8"删去",
      u8"删字",
      u8"删帖",
      u8"删成",
      u8"删掉",
      u8"删改",
      u8"删档",
      u8"删汰",
      u8"删略",
      u8"删繁就简",
      u8"删节",
      u8"删节号",
      u8"删节本",
      u8"删节版",
      u8"删补",
      u8"删词",
      u8"删除",
      u8"删除异常",
      u8"删除程序",
      u8"判下",
      u8"判下去",
      u8"判下来",
      u8"判为",
      u8"判乱",
      u8"判令",
      u8"判例",
      u8"判例汇编",
      u8"判军",
      u8"判决",
      u8"判决书",
      u8"判决额",
      u8"判分",
      u8"判刑",
      u8"判别",
      u8"判别函数",
      u8"判别分析",
      u8"判别式",
      u8"判匪",
      u8"判卷",
      u8"判变",
      u8"判处",
      u8"判处刑罚",
      u8"判处死刑",
      u8"判官",
      u8"判官笔",
      u8"判定",
      u8"判徒",
      u8"判成",
      u8"判据",
      u8"判断",
      u8"判断力",
      u8"判断力批判",
      u8"判断句",
      u8"判断是非",
      u8"判断能力",
      u8"判断裁决",
      u8"判断题",
      u8"判明",
      u8"判明是非",
      u8"判案",
      u8"判死罪",
      u8"判然不同",
      u8"判离",
      u8"判罚",
      u8"判罪",
      u8"判若",
      u8"判若两人",
      u8"判若云泥",
      u8"判若天渊",
      u8"判若水火",
      u8"判若鸿沟",
      u8"判词",
      u8"判读",
      u8"判读标志",
      u8"判起",
      u8"判起来",
      u8"刨冰",
      u8"刨冰机",
      u8"刨出来",
      u8"刨刀",
      u8"刨削",
      u8"刨土",
      u8"刨地",
      u8"刨坑",
      u8"刨子",
      u8"刨工",
      u8"刨床",
      u8"刨成",
      u8"刨树搜根",
      u8"刨根",
      u8"刨根儿",
      u8"刨根究底",
      u8"刨根问底",
      u8"刨花",
      u8"刨花板",
      u8"刨除",
      u8"利上滚利",
      u8"利不亏义",
      u8"利与弊",
      u8"利为民",
      u8"利于",
      u8"利亚克",
      u8"利亚姆",
      u8"利亚州",
      u8"利亚斯",
      u8"利亚纳",
      u8"利人",
      u8"利人利己",
      u8"利他",
      u8"利他主义",
      u8"利他行为",
      u8"利令志惛",
      u8"利令智昏",
      u8"利伯维尔",
      u8"利便",
      u8"利傍倚刀",
      u8"利兹",
      u8"利兹联",
      u8"利养",
      u8"利出一孔",
      u8"利刀",
      u8"利刃",
      u8"利剑",
      u8"利勒哈默尔",
      u8"利口",
      u8"利口捷给",
      u8"利口酒",
      u8"利君沙",
      u8"利喙赡辞",
      u8"利嘴",
      u8"利器",
      u8"利国",
      u8"利国乡",
      u8"利国利民",
      u8"利国益民",
      u8"利国福民",
      u8"利在当代",
      u8"利多",
      u8"利多于弊",
      u8"利多卡因",
      u8"利多弊少",
      u8"利多消息",
      u8"利大于弊",
      u8"利奥塔德",
      u8"利奥波德",
      u8"利好",
      u8"利子",
      u8"利它素",
      u8"利害",
      u8"利害关系",
      u8"利害冲突",
      u8"利害得失",
      u8"利害悠关",
      u8"利害攸关",
      u8"利害相关",
      u8"利家",
      u8"利家与松",
      u8"利导",
      u8"利小便",
      u8"利尔达",
      u8"利尿",
      u8"利尿剂",
      u8"利尿药",
      u8"利尿钠激素",
      u8"利川",
      u8"利川市",
      u8"利差",
      u8"利己",
      u8"利己主义",
      u8"利己利人",
      u8"利己损人",
      u8"利市",
      u8"利市三倍",
      u8"利库德",
      u8"利庭扫穴",
      u8"利弊",
      u8"利弊得失",
      u8"利得",
      u8"利息",
      u8"利息支出",
      u8"利息收入",
      u8"利息率",
      u8"利息税",
      u8"利息费用",
      u8"利息额",
      u8"利惹名牵",
      u8"利改税",
      u8"利斯塔",
      u8"利时及物",
      u8"利昂",
      u8"利是",
      u8"利普顿",
      u8"利智",
      u8"利权",
      u8"利析秋毫",
      u8"利根",
      u8"利欲",
      u8"利欲熏心",
      u8"利欲薰心",
      u8"利比亚",
      u8"利比里亚",
      u8"利民",
      u8"利水",
      u8"利水渗湿",
      u8"利沃依德",
      u8"利津",
      u8"利津县",
      u8"利派",
      u8"利润",
      u8"利润分配",
      u8"利润总额",
      u8"利润率",
      u8"利润留成",
      u8"利润表",
      u8"利深祸速",
      u8"利港镇",
      u8"利源",
      u8"利滚利",
      u8"利灾乐祸",
      u8"利爪",
      u8"利牙",
      u8"利物浦",
      u8"利物浦港",
      u8"利物浦队",
      u8"利率",
      u8"利率政策",
      u8"利率表",
      u8"利玛窦",
      u8"利生",
      u8"利用",
      u8"利用价值",
      u8"利用厚生",
      u8"利用外资",
      u8"利用工作之便",
      u8"利用率",
      u8"利用系数",
      u8"利用职务之便",
      u8"利用职权",
      u8"利用高科技手段",
      u8"利益",
      u8"利益一致",
      u8"利益冲突",
      u8"利益均沾",
      u8"利益观",
      u8"利益输送",
      u8"利益集团",
      u8"利益驱动",
      u8"利禄",
      u8"利福平",
      u8"利税",
      u8"利税分流",
      u8"利空",
      u8"利空消息",
      u8"利索",
      u8"利纳雷斯",
      u8"利维坦",
      u8"利绾名牵",
      u8"利群岛",
      u8"利落",
      u8"利血平",
      u8"利诱",
      u8"利车",
      u8"利辛",
      u8"利辛县",
      u8"利达",
      u8"利迪链菌素",
      u8"利迪霉素",
      u8"利通区",
      u8"利金",
      u8"利钝",
      u8"利钱",
      u8"利锁名缰",
      u8"利隆圭",
      u8"利雅得",
      u8"利雅德",
      u8"利马",
      u8"利马窦",
      u8"利齐切夫",
      u8"利齿",
      u8"利齿伶牙",
      u8"利齿能牙",
      u8"别上",
      u8"别上去",
      u8"别上来",
      u8"别下",
      u8"别下去",
      u8"别下来",
      u8"别业",
      u8"别个",
      u8"别为",
      u8"别乡",
      u8"别了",
      u8"别人",
      u8"别人家",
      u8"别人找",
      u8"别介",
      u8"别介意",
      u8"别从",
      u8"别以为",
      u8"别价",
      u8"别传",
      u8"别住",
      u8"别体",
      u8"别作一眼",
      u8"别作良图",
      u8"别使",
      u8"别倒",
      u8"别做声",
      u8"别傻",
      u8"别傻了",
      u8"别像",
      u8"别克",
      u8"别克君威",
      u8"别党",
      u8"别关",
      u8"别具",
      u8"别具一格",
      u8"别具匠心",
      u8"别具只眼",
      u8"别具心肠",
      u8"别具慧眼",
      u8"别具手眼",
      u8"别具特色",
      u8"别具肺肠",
      u8"别具风采",
      u8"别再",
      u8"别出",
      u8"别出去",
      u8"别出心裁",
      u8"别出手眼",
      u8"别出新意",
      u8"别出新裁",
      u8"别出机杼",
      u8"别出来",
      u8"别创一格",
      u8"别别扭扭",
      u8"别到",
      u8"别刻",
      u8"别办",
      u8"别加",
      u8"别动",
      u8"别动队",
      u8"别区",
      u8"别去",
      u8"别去了",
      u8"别县",
      u8"别又",
      u8"别受",
      u8"别句",
      u8"别只",
      u8"别叫",
      u8"别史",
      u8"别号",
      u8"别名",
      u8"别后",
      u8"别向",
      u8"别吓",
      u8"别吓人",
      u8"别吓唬",
      u8"别吵",
      u8"别哭",
      u8"别善恶",
      u8"别喝了",
      u8"别嘌呤醇",
      u8"别嘌呤醇核苷酸",
      u8"别嘴",
      u8"别国",
      u8"别在",
      u8"别墅",
      u8"别墅区",
      u8"别墅式",
      u8"别墅网",
      u8"别墅设计",
      u8"别处",
      u8"别套",
      u8"别妇抛雏",
      u8"别妻离子",
      u8"别字",
      u8"别守",
      u8"别安",
      u8"别宗",
      u8"别室",
      u8"别家",
      u8"别寄",
      u8"别对",
      u8"别将",
      u8"别局",
      u8"别居异财",
      u8"别巷",
      u8"别师",
      u8"别康桥",
      u8"别开",
      u8"别开一格",
      u8"别开生面",
      u8"别开蹊径",
      u8"别弹",
      u8"别当",
      u8"别当真",
      u8"别得",
      u8"别忘了",
      u8"别忘记",
      u8"别忙",
      u8"别念",
      u8"别怕",
      u8"别急",
      u8"别怪",
      u8"别恋",
      u8"别情",
      u8"别情依依",
      u8"别想",
      u8"别成",
      u8"别打我",
      u8"别扭",
      u8"别找我",
      u8"别把",
      u8"别抱琵琶",
      u8"别拍",
      u8"别拔",
      u8"别拗",
      u8"别拿",
      u8"别挤",
      u8"别排",
      u8"别揍",
      u8"别描头",
      u8"别提",
      u8"别揽瓷器活",
      u8"别搞",
      u8"别搬",
      u8"别支",
      u8"别收",
      u8"别教",
      u8"别数",
      u8"别斯兰",
      u8"别族",
      u8"别无",
      u8"别无二致",
      u8"别无他法",
      u8"别无他物",
      u8"别无其他",
      u8"别无出路",
      u8"别无分号",
      u8"别无分店",
      u8"别无所求",
      u8"别无良策",
      u8"别无选择",
      u8"别无长物",
      u8"别是",
      u8"别替",
      u8"别有",
      u8"别有人间",
      u8"别有天地",
      u8"别有心肝",
      u8"别有心肠",
      u8"别有情趣",
      u8"别有所指",
      u8"别有洞天",
      u8"别有滋味",
      u8"别有用心",
      u8"别有用意",
      u8"别有肺肠",
      u8"别有见地",
      u8"别有风味",
      u8"别有风趣",
      u8"别本",
      u8"别杀",
      u8"别束",
      u8"别来",
      u8"别来无恙",
      u8"别来无羔",
      u8"别构作用",
      u8"别构剂",
      u8"别构性",
      u8"别构抑制",
      u8"别构抑制剂",
      u8"别构效应",
      u8"别构活化",
      u8"别构激活",
      u8"别构蛋白",
      u8"别构调节",
      u8"别构转换",
      u8"别构部位",
      u8"别构配体",
      u8"别构酶",
      u8"别林斯基",
      u8"别枝",
      u8"别架",
      u8"别栋",
      u8"别树一帜",
      u8"别树一旗",
      u8"别树一格",
      u8"别校",
      u8"别样",
      u8"别样红",
      u8"别棵",
      u8"别气",
      u8"别派",
      u8"别猜",
      u8"别王",
      u8"别现",
      u8"别班",
      u8"别理",
      u8"别生",
      u8"别生枝节",
      u8"别生气",
      u8"别用",
      u8"别由",
      u8"别的",
      u8"别相",
      u8"别省",
      u8"别看",
      u8"别着",
      u8"别着急",
      u8"别睡了",
      u8"别离",
      u8"别种",
      u8"别科",
      u8"别称",
      u8"别笑",
      u8"别答",
      u8"别管",
      u8"别箱",
      u8"别籍异居",
      u8"别籍异财",
      u8"别类分门",
      u8"别线",
      u8"别组",
      u8"别给",
      u8"别绪",
      u8"别罐",
      u8"别置一喙",
      u8"别老是",
      u8"别胡说",
      u8"别脚",
      u8"别致",
      u8"别藻蓝素",
      u8"别藻蓝蛋白",
      u8"别被",
      u8"别讨",
      u8"别让",
      u8"别记",
      u8"别讲",
      u8"别论",
      u8"别试",
      u8"别误会",
      u8"别说",
      u8"别说出",
      u8"别说到",
      u8"别说起",
      u8"别请",
      u8"别课",
      u8"别谈",
      u8"别谦虚",
      u8"别财异居",
      u8"别赏",
      u8"别走",
      u8"别起",
      u8"别起来",
      u8"别趣",
      u8"别趴下",
      u8"别跑",
      u8"别跟我",
      u8"别踢",
      u8"别转",
      u8"别输",
      u8"别过",
      u8"别过去",
      u8"别过来",
      u8"别连科",
      u8"别逃",
      u8"别里别扭",
      u8"别针",
      u8"别错过",
      u8"别问",
      u8"别闹",
      u8"别队",
      u8"别院",
      u8"别难过",
      u8"别集",
      u8"别项",
      u8"别颗",
      u8"别题",
      u8"别风淮雨",
      u8"别饶风致",
      u8"别饶风趣",
      u8"别馆",
      u8"别首",
      u8"别骑",
      u8"别鹤孤鸾",
      u8"别鹤离鸾",
      u8"刬恶锄奸",
      u8"刬旧谋新",
      u8"刬草除根",
      u8"刮下",
      u8"刮下去",
      u8"刮下来",
      u8"刮了",
      u8"刮伤",
      u8"刮倒",
      u8"刮刀",
      u8"刮刮卡",
      u8"刮刮叫",
      u8"刮刮杂杂",
      u8"刮到",
      u8"刮削",
      u8"刮匙",
      u8"刮去",
      u8"刮取",
      u8"刮在",
      u8"刮地皮",
      u8"刮垢",
      u8"刮垢磨光",
      u8"刮垢磨痕",
      u8"刮好",
      u8"刮宫",
      u8"刮开",
      u8"刮得",
      u8"刮打",
      u8"刮掉",
      u8"刮搭板儿",
      u8"刮来刮去",
      u8"刮棒",
      u8"刮油",
      u8"刮治",
      u8"刮痕",
      u8"刮痧",
      u8"刮皮",
      u8"刮目相待",
      u8"刮目相看",
      u8"刮目相见",
      u8"刮着",
      u8"刮研",
      u8"刮破",
      u8"刮空",
      u8"刮粪机",
      u8"刮肠洗胃",
      u8"刮胡刀",
      u8"刮胡子",
      u8"刮脸",
      u8"刮脸刀",
      u8"刮脸皮",
      u8"刮腻子",
      u8"刮舌",
      u8"刮蜡器",
      u8"刮蜡片",
      u8"刮走",
      u8"刮起",
      u8"刮起来",
      u8"刮过",
      u8"刮过去",
      u8"刮过来",
      u8"刮野扫地",
      u8"刮铲",
      u8"刮面",
      u8"刮须",
      u8"刮风",
      u8"刮风下雨",
      u8"刮骨",
      u8"刮骨刀",
      u8"刮骨去毒",
      u8"刮骨抽筋",
      u8"刮鼻子",
      u8"到上",
      u8"到临",
      u8"到了",
      u8"到京",
      u8"到今天为止",
      u8"到他",
      u8"到任",
      u8"到会",
      u8"到会者",
      u8"到位",
      u8"到位这里喇嘛",
      u8"到你",
      u8"到到",
      u8"到发场",
      u8"到哪儿",
      u8"到哪去",
      u8"到哪里",
      u8"到地上躲在",
      u8"到场",
      u8"到场人员",
      u8"到埠",
      u8"到处",
      u8"到处是",
      u8"到处跑",
      u8"到处都",
      u8"到外",
      u8"到头",
      u8"到头来",
      u8"到她",
      u8"到家",
      u8"到尾",
      u8"到岸",
      u8"到岸价",
      u8"到帐",
      u8"到底",
      u8"到底会",
      u8"到底在",
      u8"到底是",
      u8"到底有",
      u8"到庭",
      u8"到得",
      u8"到我",
      u8"到手",
      u8"到抵",
      u8"到时",
      u8"到时候",
      u8"到最后",
      u8"到期",
      u8"到期日",
      u8"到本世纪末",
      u8"到来",
      u8"到来之际",
      u8"到来撒",
      u8"到极点",
      u8"到校",
      u8"到案",
      u8"到次",
      u8"到此",
      u8"到此一游",
      u8"到此为止",
      u8"到此结束",
      u8"到死",
      u8"到点",
      u8"到现在",
      u8"到现在为止",
      u8"到目前为止",
      u8"到站",
      u8"到群众中去",
      u8"到老",
      u8"到职",
      u8"到职人员",
      u8"到访",
      u8"到货",
      u8"到达",
      u8"到达场",
      u8"到达某",
      u8"到达港",
      u8"到达站",
      u8"到过",
      u8"到那时",
      u8"到里",
      u8"到顶",
      u8"到齐",
      u8"刳形去皮",
      u8"刳心雕肾",
      u8"刳精呕血",
      u8"刳精鉥心",
      u8"刳肝沥胆",
      u8"刳胎杀夭",
      u8"刳胎焚夭",
      u8"刳脂剔膏",
      u8"制丸机",
      u8"制为",
      u8"制件",
      u8"制伏",
      u8"制住",
      u8"制作",
      u8"制作业",
      u8"制作人",
      u8"制作人员",
      u8"制作厂",
      u8"制作器",
      u8"制作所",
      u8"制作方法",
      u8"制作组",
      u8"制作者",
      u8"制假",
      u8"制假者",
      u8"制做",
      u8"制做发布",
      u8"制做群",
      u8"制冰",
      u8"制冰机",
      u8"制冷",
      u8"制冷剂",
      u8"制冷机",
      u8"制冷系统",
      u8"制冷量",
      u8"制刷厂",
      u8"制剂",
      u8"制剂室",
      u8"制动",
      u8"制动功率",
      u8"制动启动盘",
      u8"制动器",
      u8"制动液",
      u8"制动缸",
      u8"制动闸",
      u8"制动阀",
      u8"制单",
      u8"制博会",
      u8"制卡商",
      u8"制印",
      u8"制发",
      u8"制取",
      u8"制品",
      u8"制品厂",
      u8"制哪个呢",
      u8"制售",
      u8"制图",
      u8"制图人",
      u8"制图员",
      u8"制图学",
      u8"制图室",
      u8"制图师",
      u8"制图样",
      u8"制图精度",
      u8"制图者",
      u8"制备",
      u8"制定",
      u8"制定出来",
      u8"制定政策",
      u8"制定方案",
      u8"制定者",
      u8"制宪",
      u8"制宪会议",
      u8"制导",
      u8"制导技术",
      u8"制导武器",
      u8"制导系统",
      u8"制币",
      u8"制度",
      u8"制度化",
      u8"制度改革",
      u8"制式",
      u8"制式教练",
      u8"制成",
      u8"制成品",
      u8"制报",
      u8"制敌机先",
      u8"制服",
      u8"制服呢",
      u8"制材",
      u8"制止",
      u8"制止动乱",
      u8"制毒",
      u8"制氧机",
      u8"制氮机",
      u8"制法",
      u8"制浆",
      u8"制海权",
      u8"制热",
      u8"制热量",
      u8"制片",
      u8"制片人",
      u8"制片厂",
      u8"制片商",
      u8"制片方",
      u8"制版",
      u8"制版工艺",
      u8"制版术",
      u8"制版机",
      u8"制盐",
      u8"制盐人",
      u8"制砂机",
      u8"制砖机",
      u8"制礼作乐",
      u8"制种",
      u8"制程",
      u8"制空权",
      u8"制笔厂",
      u8"制粉",
      u8"制粒机",
      u8"制糖",
      u8"制糖业",
      u8"制糖厂",
      u8"制约",
      u8"制约力",
      u8"制约逻辑",
      u8"制纸",
      u8"制胜",
      u8"制胜之道",
      u8"制胜因素",
      u8"制胜球",
      u8"制艺",
      u8"制药",
      u8"制药业",
      u8"制药厂",
      u8"制药学",
      u8"制药机械",
      u8"制衡",
      u8"制衡作用",
      u8"制衣",
      u8"制衣厂",
      u8"制表",
      u8"制表机",
      u8"制表符",
      u8"制表键",
      u8"制袋机",
      u8"制裁",
      u8"制裁者",
      u8"制规",
      u8"制订",
      u8"制贩",
      u8"制造",
      u8"制造业",
      u8"制造业者",
      u8"制造事端",
      u8"制造人",
      u8"制造出",
      u8"制造出来",
      u8"制造厂",
      u8"制造厂商",
      u8"制造品",
      u8"制造商",
      u8"制造器",
      u8"制造场",
      u8"制造家",
      u8"制造局",
      u8"制造悬念",
      u8"制造成",
      u8"制造术",
      u8"制造矛盾",
      u8"制造纠纷",
      u8"制造者",
      u8"制造舆论",
      u8"制造费用",
      u8"制酸剂",
      u8"制酸性",
      u8"制醣",
      u8"制钉机",
      u8"制钱",
      u8"制锌版术",
      u8"制霉菌素",
      u8"制面",
      u8"制革",
      u8"制革厂",
      u8"制革工厂",
      u8"制鞋",
      u8"制鞋业",
      u8"制鞋厂",
      u8"制音器",
      u8"制高点",
      u8"制黄",
      u8"制黄贩黄",
      u8"刷上",
      u8"刷上去",
      u8"刷上来",
      u8"刷下",
      u8"刷下去",
      u8"刷下来",
      u8"刷写",
      u8"刷刷",
      u8"刷刷声",
      u8"刷刷牙",
      u8"刷卡",
      u8"刷卡器",
      u8"刷卡机",
      u8"刷去",
      u8"刷墙",
      u8"刷子",
      u8"刷屏",
      u8"刷拉",
      u8"刷拉拉",
      u8"刷掉",
      u8"刷新",
      u8"刷新周期",
      u8"刷新测试",
      u8"刷新率",
      u8"刷新纪录",
      u8"刷新记录",
      u8"刷来",
      u8"刷来刷去",
      u8"刷毛",
      u8"刷油漆",
      u8"刷洗",
      u8"刷浆",
      u8"刷漆",
      u8"刷牙",
      u8"刷牙漱口",
      u8"刷白",
      u8"刷着",
      u8"刷耻",
      u8"刷装备",
      u8"刷起",
      u8"刷起来",
      u8"刷钱",
      u8"刷麸",
      u8"券别",
      u8"券商",
      u8"券式",
      u8"券桥乡",
      u8"券种",
      u8"券面",
      u8"刹住",
      u8"刹带",
      u8"刹时",
      u8"刹时间",
      u8"刹海",
      u8"刹车",
      u8"刹车声",
      u8"刹车油",
      u8"刹车灯",
      u8"刹车片",
      u8"刹车盘",
      u8"刹车踏板",
      u8"刹那",
      u8"刹那之间",
      u8"刹那间",
      u8"刹闸",
      u8"刹风整纪",
      u8"刺上",
      u8"刺上化下",
      u8"刺上去",
      u8"刺上来",
      u8"刺下",
      u8"刺下去",
      u8"刺下来",
      u8"刺丝",
      u8"刺中",
      u8"刺五加",
      u8"刺人",
      u8"刺伤",
      u8"刺儿",
      u8"刺儿头",
      u8"刺入",
      u8"刺出",
      u8"刺出去",
      u8"刺出来",
      u8"刺刀",
      u8"刺刀见红",
      u8"刺到",
      u8"刺刺",
      u8"刺刺不休",
      u8"刺参",
      u8"刺史",
      u8"刺啦",
      u8"刺头",
      u8"刺孔",
      u8"刺字",
      u8"刺客",
      u8"刺客列传",
      u8"刺山柑",
      u8"刺开",
      u8"刺心切骨",
      u8"刺心刻骨",
      u8"刺心裂肝",
      u8"刺戳",
      u8"刺扎",
      u8"刺探",
      u8"刺探出",
      u8"刺有",
      u8"刺杀",
      u8"刺杀位",
      u8"刺杀出局",
      u8"刺果番荔枝",
      u8"刺柏",
      u8"刺桐",
      u8"刺梨",
      u8"刺棒",
      u8"刺棱",
      u8"刺槐",
      u8"刺死",
      u8"刺毛",
      u8"刺毛虫",
      u8"刺毛辊",
      u8"刺溜",
      u8"刺激",
      u8"刺激作用",
      u8"刺激剂",
      u8"刺激子",
      u8"刺激性",
      u8"刺激扩散",
      u8"刺激法",
      u8"刺激物",
      u8"刺激素",
      u8"刺激维度",
      u8"刺激阈限",
      u8"刺猬",
      u8"刺猬皮",
      u8"刺疼",
      u8"刺痒",
      u8"刺痛",
      u8"刺痛性",
      u8"刺痛感",
      u8"刺目",
      u8"刺眼",
      u8"刺着",
      u8"刺破",
      u8"刺秦",
      u8"刺秦王",
      u8"刺穿",
      u8"刺细胞",
      u8"刺绣",
      u8"刺绣品",
      u8"刺绣工",
      u8"刺网",
      u8"刺者",
      u8"刺耳",
      u8"刺股",
      u8"刺股悬梁",
      u8"刺股读书",
      u8"刺花",
      u8"刺花样",
      u8"刺菜蓟",
      u8"刺蒺藜",
      u8"刺虎持鹬",
      u8"刺透",
      u8"刺配",
      u8"刺酮属生物碱",
      u8"刺酮碱",
      u8"刺针",
      u8"刺青",
      u8"刺骨",
      u8"刺鼠",
      u8"刺鼻",
      u8"刻上",
      u8"刻上去",
      u8"刻上来",
      u8"刻下",
      u8"刻下去",
      u8"刻下来",
      u8"刻不容松",
      u8"刻不容缓",
      u8"刻不待时",
      u8"刻丝",
      u8"刻个",
      u8"刻了",
      u8"刻于",
      u8"刻作",
      u8"刻其",
      u8"刻写",
      u8"刻出",
      u8"刻刀",
      u8"刻划",
      u8"刻划入微",
      u8"刻划出",
      u8"刻到",
      u8"刻制",
      u8"刻印",
      u8"刻即",
      u8"刻图章",
      u8"刻在",
      u8"刻字",
      u8"刻字机",
      u8"刻工",
      u8"刻度",
      u8"刻度井",
      u8"刻度尺",
      u8"刻度盘",
      u8"刻录",
      u8"刻录成",
      u8"刻录机",
      u8"刻录盘",
      u8"刻录碟",
      u8"刻得",
      u8"刻意",
      u8"刻意模仿",
      u8"刻意求工",
      u8"刻意求精",
      u8"刻意经营",
      u8"刻意追求",
      u8"刻成",
      u8"刻掉",
      u8"刻有",
      u8"刻木为吏",
      u8"刻木为鹄",
      u8"刻本",
      u8"刻板",
      u8"刻款",
      u8"刻毒",
      u8"刻版",
      u8"刻版印刷",
      u8"刻画",
      u8"刻画入微",
      u8"刻画出",
      u8"刻画无盐",
      u8"刻画来",
      u8"刻画脸谱",
      u8"刻痕",
      u8"刻盘",
      u8"刻着",
      u8"刻碟",
      u8"刻章琢句",
      u8"刻纸",
      u8"刻翠裁红",
      u8"刻肌刻骨",
      u8"刻舟求剑",
      u8"刻苦",
      u8"刻苦耐劳",
      u8"刻苦自励",
      u8"刻苦钻研",
      u8"刻薄",
      u8"刻薄寡思",
      u8"刻薄寡恩",
      u8"刻薄话",
      u8"刻蚀",
      u8"刻蚀地貌",
      u8"刻蜡纸",
      u8"刻起",
      u8"刻起来",
      u8"刻足",
      u8"刻足适屦",
      u8"刻过",
      u8"刻过去",
      u8"刻过来",
      u8"刻钟",
      u8"刻雾裁风",
      u8"刻面联合体",
      u8"刻骨",
      u8"刻骨仇恨",
      u8"刻骨崩心",
      u8"刻骨相思",
      u8"刻骨铭心",
      u8"刻骨镂心",
      u8"刻鹄成鹜",
      u8"刻鹄类鹜",
      u8"刽子手",
      u8"刿心刳肺",
      u8"刿心刳腹",
      u8"刿心怵目",
      u8"刿心鉥肾",
      u8"刿目怵心",
      u8"刿目鉥心",
      u8"刿鉥心腑",
      u8"刿鉥肝肾",
      u8"剀切",
      u8"剁岚",
      u8"剁岚县",
      u8"剁成",
      u8"剁碎",
      u8"剁肉",
      u8"剂型",
      u8"剂子",
      u8"剂量",
      u8"剂量学",
      u8"剂量效应",
      u8"剂量测定",
      u8"剂量率",
      u8"剂量计",
      u8"剃了",
      u8"剃光头",
      u8"剃刀",
      u8"剃刀鲸",
      u8"剃发",
      u8"剃发为尼",
      u8"剃头",
      u8"剃头刀",
      u8"剃头发",
      u8"剃度",
      u8"剃得",
      u8"剃毛器",
      u8"剃泪",
      u8"剃着",
      u8"剃面",
      u8"剃须",
      u8"剃须刀",
      u8"削了",
      u8"削价",
      u8"削低",
      u8"削光",
      u8"削减",
      u8"削减到",
      u8"削减成",
      u8"削刮",
      u8"削削",
      u8"削去",
      u8"削发",
      u8"削发为僧",
      u8"削发为尼",
      u8"削发披缁",
      u8"削壁",
      u8"削尖",
      u8"削尖脑袋",
      u8"削峰平谷",
      u8"削平",
      u8"削弱",
      u8"削成",
      u8"削掉",
      u8"削断",
      u8"削方为圆",
      u8"削木为吏",
      u8"削来削去",
      u8"削株掘根",
      u8"削波",
      u8"削波器",
      u8"削球",
      u8"削球手",
      u8"削皮",
      u8"削皮刀",
      u8"削着",
      u8"削短",
      u8"削职",
      u8"削职为民",
      u8"削苹果",
      u8"削草除根",
      u8"削薄",
      u8"削足就履",
      u8"削足适履",
      u8"削趾适屦",
      u8"削过",
      u8"削铁如泥",
      u8"削铁无声",
      u8"削铅笔",
      u8"削铅笔机",
      u8"削销笔",
      u8"削除",
      u8"削面",
      u8"剌激",
      u8"剌穿",
      u8"剌膊",
      u8"剌鼻",
      u8"前一刻",
      u8"前一天",
      u8"前一晚",
      u8"前一段",
      u8"前一段时间",
      u8"前一种",
      u8"前三位",
      u8"前三合村",
      u8"前三名",
      u8"前三天",
      u8"前三季",
      u8"前三强",
      u8"前三步",
      u8"前三甲",
      u8"前三章",
      u8"前不久",
      u8"前不巴村",
      u8"前不巴村后不巴店",
      u8"前不巴村后不着店",
      u8"前不着村后不着店",
      u8"前不见古人",
      u8"前不见古人后不见来者",
      u8"前世",
      u8"前两天",
      u8"前两节",
      u8"前个",
      u8"前为",
      u8"前事",
      u8"前事不忘",
      u8"前事不忘后事之师",
      u8"前事不忘，后事之师",
      u8"前五强",
      u8"前些",
      u8"前些天",
      u8"前些年",
      u8"前些时候",
      u8"前些时日",
      u8"前人",
      u8"前人失脚",
      u8"前人失脚后人把滑",
      u8"前人栽树",
      u8"前人栽树后人乘凉",
      u8"前人种树",
      u8"前人种树后人乘凉",
      u8"前仆后偃",
      u8"前仆后继",
      u8"前仆后踣",
      u8"前仇",
      u8"前代",
      u8"前仰后合",
      u8"前件",
      u8"前任",
      u8"前传",
      u8"前伸关系",
      u8"前伸平衡",
      u8"前伸运动",
      u8"前伸髁导斜度",
      u8"前作",
      u8"前例",
      u8"前信号灯",
      u8"前俯后仰",
      u8"前倒",
      u8"前倨后卑",
      u8"前倨后恭",
      u8"前倾",
      u8"前兆",
      u8"前先",
      u8"前军",
      u8"前几天",
      u8"前几年",
      u8"前几日",
      u8"前几次",
      u8"前列",
      u8"前列康",
      u8"前列环素",
      u8"前列腺",
      u8"前列腺炎",
      u8"前列腺病",
      u8"前列腺癌",
      u8"前列腺素",
      u8"前前后后",
      u8"前功尽废",
      u8"前功尽弃",
      u8"前功尽灭",
      u8"前功皆弃",
      u8"前十名",
      u8"前十强",
      u8"前十款",
      u8"前十页",
      u8"前半",
      u8"前半场",
      u8"前半夜",
      u8"前半天",
      u8"前半晌",
      u8"前半期",
      u8"前半段",
      u8"前半生",
      u8"前半部",
      u8"前卫",
      u8"前卫片",
      u8"前卫者",
      u8"前危后则",
      u8"前厂",
      u8"前厅",
      u8"前去",
      u8"前叉",
      u8"前发",
      u8"前叙",
      u8"前古未有",
      u8"前古未闻",
      u8"前句",
      u8"前台",
      u8"前台分区",
      u8"前台操作方式",
      u8"前台调度程序",
      u8"前史",
      u8"前叶",
      u8"前合后仰",
      u8"前后",
      u8"前后一致",
      u8"前后任",
      u8"前后夹攻",
      u8"前后左右",
      u8"前后文",
      u8"前后相悖",
      u8"前后相随",
      u8"前后矛盾",
      u8"前后脚",
      u8"前后脚儿",
      u8"前向串扰",
      u8"前向掩蔽",
      u8"前呼后应",
      u8"前呼后拥",
      u8"前哨",
      u8"前哨战",
      u8"前哨站",
      u8"前哨阵地",
      u8"前因",
      u8"前因后果",
      u8"前园",
      u8"前场",
      u8"前埔",
      u8"前堂",
      u8"前夕",
      u8"前夜",
      u8"前大灯",
      u8"前天",
      u8"前夫",
      u8"前头",
      u8"前奏",
      u8"前奏曲",
      u8"前套",
      u8"前女友",
      u8"前妻",
      u8"前委",
      u8"前嫌",
      u8"前宋村",
      u8"前定",
      u8"前导",
      u8"前尘",
      u8"前尘影事",
      u8"前尘往事",
      u8"前屋",
      u8"前山",
      u8"前巷",
      u8"前帖",
      u8"前年",
      u8"前序",
      u8"前度刘郎",
      u8"前座",
      u8"前庭",
      u8"前庭悬鱼",
      u8"前庭成形术",
      u8"前庭沟扩展术",
      u8"前庭盾",
      u8"前弓",
      u8"前弓区",
      u8"前往",
      u8"前徒倒戈",
      u8"前怕狼",
      u8"前怕狼后怕虎",
      u8"前怕龙后怕虎",
      u8"前思后想",
      u8"前总理",
      u8"前总统",
      u8"前情",
      u8"前情摘要",
      u8"前愆",
      u8"前意识",
      u8"前戏",
      u8"前房",
      u8"前所",
      u8"前所未有",
      u8"前所未见",
      u8"前所未闻",
      u8"前扑后继",
      u8"前扑后起",
      u8"前指",
      u8"前挽后推",
      u8"前排",
      u8"前排观众",
      u8"前提",
      u8"前提下",
      u8"前提条件",
      u8"前支索",
      u8"前政府",
      u8"前敌",
      u8"前文",
      u8"前方",
      u8"前旗",
      u8"前无古人",
      u8"前无古人后无来者",
      u8"前日",
      u8"前晌",
      u8"前晚",
      u8"前景",
      u8"前景色",
      u8"前有",
      u8"前朝",
      u8"前期",
      u8"前期工作",
      u8"前期损益",
      u8"前期牙本质",
      u8"前期白斑",
      u8"前期量子论",
      u8"前末端基效应",
      u8"前机",
      u8"前束词",
      u8"前条",
      u8"前来",
      u8"前松后紧",
      u8"前栋",
      u8"前桅",
      u8"前桥",
      u8"前楼",
      u8"前次",
      u8"前款",
      u8"前歌后舞",
      u8"前此",
      u8"前步",
      u8"前段",
      u8"前段时间",
      u8"前殿",
      u8"前汉",
      u8"前沿",
      u8"前沿性",
      u8"前沿技术",
      u8"前沿轨道",
      u8"前沿阵地",
      u8"前浪",
      u8"前清",
      u8"前清后欠",
      u8"前滚",
      u8"前滚翻",
      u8"前灯",
      u8"前爪",
      u8"前牙",
      u8"前生",
      u8"前田",
      u8"前田亘辉",
      u8"前田知惠",
      u8"前男友",
      u8"前目后凡",
      u8"前瞻",
      u8"前瞻后顾",
      u8"前瞻性",
      u8"前短后长",
      u8"前磨牙",
      u8"前科",
      u8"前秦",
      u8"前积反射结构",
      u8"前程",
      u8"前程万里",
      u8"前程似锦",
      u8"前程远大",
      u8"前程锦绣",
      u8"前窗",
      u8"前站",
      u8"前童村",
      u8"前端",
      u8"前紧后松",
      u8"前线",
      u8"前缀",
      u8"前缘",
      u8"前缘走廊",
      u8"前置",
      u8"前置式游梁抽油机",
      u8"前置放大器",
      u8"前置条件",
      u8"前置柱",
      u8"前置程序",
      u8"前置词",
      u8"前翼子板",
      u8"前者",
      u8"前肢",
      u8"前胡",
      u8"前胸",
      u8"前胸袋",
      u8"前脑",
      u8"前脚",
      u8"前腰",
      u8"前腿",
      u8"前臂",
      u8"前臂骨",
      u8"前臼齿",
      u8"前舱",
      u8"前苇塘",
      u8"前苏联",
      u8"前茅",
      u8"前藏",
      u8"前行",
      u8"前街后巷",
      u8"前襟",
      u8"前襟后裾",
      u8"前覆后戒",
      u8"前言",
      u8"前言不对",
      u8"前言不对后语",
      u8"前言不搭后语",
      u8"前言往行",
      u8"前识",
      u8"前话",
      u8"前谷",
      u8"前负荷",
      u8"前贤",
      u8"前赴后继",
      u8"前跋后疐",
      u8"前路",
      u8"前踱",
      u8"前蹄",
      u8"前身",
      u8"前车",
      u8"前车之覆",
      u8"前车之鉴",
      u8"前车可鉴",
      u8"前转",
      u8"前轮",
      u8"前轮驱动",
      u8"前轴",
      u8"前轻后重法",
      u8"前辈",
      u8"前辐照",
      u8"前辙可鉴",
      u8"前边",
      u8"前运思阶段",
      u8"前进",
      u8"前进不懈",
      u8"前进区",
      u8"前进接触角",
      u8"前进方向",
      u8"前进波",
      u8"前进观察",
      u8"前述",
      u8"前途",
      u8"前途广阔",
      u8"前途无亮",
      u8"前途无量",
      u8"前途渺茫",
      u8"前途远大",
      u8"前遮后拥",
      u8"前邵村",
      u8"前部",
      u8"前部船舱",
      u8"前郭",
      u8"前郭尔罗斯",
      u8"前郭尔罗斯蒙古族自治县",
      u8"前重后轻",
      u8"前锋",
      u8"前锋线",
      u8"前镇",
      u8"前门",
      u8"前门去虎后门进狼",
      u8"前门拒狼",
      u8"前门拒虎",
      u8"前门拒虎后门进狼",
      u8"前闸",
      u8"前院",
      u8"前面",
      u8"前面板",
      u8"前顶",
      u8"前项",
      u8"前领导人",
      u8"前额",
      u8"前额叶皮层",
      u8"前首相",
      u8"前驱",
      u8"前齿",
      u8"剑下",
      u8"剑侠",
      u8"剑侠传",
      u8"剑侠情缘",
      u8"剑光",
      u8"剑兰",
      u8"剑兰花",
      u8"剑冢",
      u8"剑剌",
      u8"剑南春",
      u8"剑及履及",
      u8"剑及屦及",
      u8"剑叶",
      u8"剑名",
      u8"剑圣",
      u8"剑士",
      u8"剑头",
      u8"剑头一吷",
      u8"剑宗",
      u8"剑客",
      u8"剑尖",
      u8"剑尾",
      u8"剑峰",
      u8"剑川",
      u8"剑川县",
      u8"剑形",
      u8"剑心",
      u8"剑态箫心",
      u8"剑戟森森",
      u8"剑拔弩张",
      u8"剑持",
      u8"剑持勇",
      u8"剑术",
      u8"剑柄",
      u8"剑树刀山",
      u8"剑桥",
      u8"剑桥大学",
      u8"剑气",
      u8"剑气箫心",
      u8"剑河",
      u8"剑河县",
      u8"剑法",
      u8"剑湖山",
      u8"剑潭",
      u8"剑王",
      u8"剑眉",
      u8"剑眉一剔",
      u8"剑羚",
      u8"剑胆琴心",
      u8"剑背",
      u8"剑舞",
      u8"剑诀",
      u8"剑迹",
      u8"剑道",
      u8"剑门关",
      u8"剑阁",
      u8"剑阁县",
      u8"剑陈",
      u8"剑靶",
      u8"剑鞘",
      u8"剑首一吷",
      u8"剑魔",
      u8"剑鱼",
      u8"剑麻",
      u8"剑齿虎",
      u8"剑齿象",
      u8"剔了",
      u8"剔光",
      u8"剔出",
      u8"剔去",
      u8"剔庄货",
      u8"剔开",
      u8"剔得",
      u8"剔抽禿刷",
      u8"剔抽秃揣",
      u8"剔掉",
      u8"剔牙",
      u8"剔着",
      u8"剔红",
      u8"剔蝎撩蜂",
      u8"剔选",
      u8"剔透",
      u8"剔透玲珑",
      u8"剔除",
      u8"剖决如流",
      u8"剖宫产",
      u8"剖幽析微",
      u8"剖开",
      u8"剖心坼肝",
      u8"剖心析肝",
      u8"剖心析胆",
      u8"剖心泣血",
      u8"剖成",
      u8"剖析",
      u8"剖析入微",
      u8"剖析肝胆",
      u8"剖毫析芒",
      u8"剖玄析微",
      u8"剖白",
      u8"剖示",
      u8"剖示图",
      u8"剖肝沥胆",
      u8"剖肝泣血",
      u8"剖腹",
      u8"剖腹产",
      u8"剖腹生产",
      u8"剖腹自杀",
      u8"剖腹藏珠",
      u8"剖蚌得珠",
      u8"剖蚌求珠",
      u8"剖视",
      u8"剖视图",
      u8"剖解",
      u8"剖释",
      u8"剖面",
      u8"剖面图",
      u8"剖面形式",
      u8"剖面法",
      u8"剗恶锄奸",
      u8"剗旧谋新",
      u8"剗草除根",
      u8"剜肉做疮",
      u8"剜肉医疮",
      u8"剜肉成疮",
      u8"剜肉生疮",
      u8"剜肉补疮",
      u8"剜除",
      u8"剡溪",
      u8"剥下",
      u8"剥光",
      u8"剥削",
      u8"剥削制度",
      u8"剥削者",
      u8"剥削阶级",
      u8"剥剥啄啄",
      u8"剥去",
      u8"剥壳",
      u8"剥夺",
      u8"剥夺公权",
      u8"剥夺政治权利",
      u8"剥夺政治权利终身",
      u8"剥夺权利",
      u8"剥夺走",
      u8"剥床及肤",
      u8"剥开",
      u8"剥弃",
      u8"剥得",
      u8"剥掉",
      u8"剥极则复",
      u8"剥极将复",
      u8"剥极必复",
      u8"剥皮",
      u8"剥皮抽筋",
      u8"剥皮机",
      u8"剥离",
      u8"剥离强度",
      u8"剥离技术",
      u8"剥离机",
      u8"剥线机",
      u8"剥肤之痛",
      u8"剥肤及髓",
      u8"剥肤椎髓",
      u8"剥脱",
      u8"剥脱性毒素",
      u8"剥脱性龈炎",
      u8"剥花生",
      u8"剥茧",
      u8"剥茧抽丝",
      u8"剥落",
      u8"剥蚀",
      u8"剥蚀面",
      u8"剥除",
      u8"剧中",
      u8"剧中人",
      u8"剧作",
      u8"剧作家",
      u8"剧作者",
      u8"剧减",
      u8"剧力万钧",
      u8"剧务",
      u8"剧务员",
      u8"剧动",
      u8"剧协",
      u8"剧变",
      u8"剧名",
      u8"剧团",
      u8"剧场",
      u8"剧场版",
      u8"剧坛",
      u8"剧增",
      u8"剧展",
      u8"剧情",
      u8"剧情片",
      u8"剧情简介",
      u8"剧挫",
      u8"剧曲",
      u8"剧本",
      u8"剧本创作",
      u8"剧本小说",
      u8"剧校",
      u8"剧毒",
      u8"剧烈",
      u8"剧烈地",
      u8"剧烈性",
      u8"剧烈运动",
      u8"剧照",
      u8"剧痛",
      u8"剧目",
      u8"剧种",
      u8"剧组",
      u8"剧终",
      u8"剧艺",
      u8"剧评",
      u8"剧评人",
      u8"剧跌",
      u8"剧里",
      u8"剧院",
      u8"剧集",
      u8"剧雪",
      u8"剩下",
      u8"剩个",
      u8"剩了",
      u8"剩佘",
      u8"剩余",
      u8"剩余产品",
      u8"剩余价值",
      u8"剩余价值率",
      u8"剩余偏移",
      u8"剩余劳力",
      u8"剩余劳动",
      u8"剩余劳动力",
      u8"剩余时间",
      u8"剩余标准差",
      u8"剩余次数",
      u8"剩余物",
      u8"剩余物资",
      u8"剩余静校正",
      u8"剩山残水",
      u8"剩得",
      u8"剩料",
      u8"剩水残山",
      u8"剩磁",
      u8"剩肉",
      u8"剩菜",
      u8"剩菜残羹",
      u8"剩过",
      u8"剩酒",
      u8"剩钱",
      u8"剩饭",
      u8"剩饭剩菜",
      u8"剩馀",
      u8"剩馥残膏",
      u8"剪下",
      u8"剪下去",
      u8"剪下来",
      u8"剪不断理还乱",
      u8"剪个",
      u8"剪了",
      u8"剪作",
      u8"剪出",
      u8"剪刀",
      u8"剪刀差",
      u8"剪刀式楼梯",
      u8"剪刀手",
      u8"剪切",
      u8"剪切力",
      u8"剪切应力",
      u8"剪切机",
      u8"剪切板",
      u8"剪切模量",
      u8"剪切角",
      u8"剪到",
      u8"剪剪",
      u8"剪力",
      u8"剪力墙",
      u8"剪去",
      u8"剪反",
      u8"剪发",
      u8"剪发披缁",
      u8"剪发杜门",
      u8"剪发被褐",
      u8"剪取",
      u8"剪头发",
      u8"剪子",
      u8"剪字",
      u8"剪对",
      u8"剪床",
      u8"剪应力",
      u8"剪应变",
      u8"剪开",
      u8"剪彩",
      u8"剪彩仪式",
      u8"剪影",
      u8"剪径",
      u8"剪得",
      u8"剪恶除奸",
      u8"剪成",
      u8"剪截",
      u8"剪报",
      u8"剪指甲",
      u8"剪掉",
      u8"剪接",
      u8"剪接体",
      u8"剪接受体",
      u8"剪接室",
      u8"剪接法",
      u8"剪断",
      u8"剪板机",
      u8"剪枝",
      u8"剪树",
      u8"剪毛",
      u8"剪毛机",
      u8"剪法",
      u8"剪灭",
      u8"剪点",
      u8"剪烛西窗",
      u8"剪片",
      u8"剪着",
      u8"剪短",
      u8"剪票",
      u8"剪票员",
      u8"剪秋萝",
      u8"剪纸",
      u8"剪纸作品",
      u8"剪纸片",
      u8"剪纸片儿",
      u8"剪线",
      u8"剪羊毛",
      u8"剪羊毛机",
      u8"剪草",
      u8"剪草机",
      u8"剪草除根",
      u8"剪裁",
      u8"剪裁法",
      u8"剪贴",
      u8"剪贴出",
      u8"剪贴板",
      u8"剪贴画",
      u8"剪贴簿",
      u8"剪起",
      u8"剪起来",
      u8"剪辑",
      u8"剪辑法",
      u8"剪辑版",
      u8"剪过",
      u8"剪过去",
      u8"剪过来",
      u8"剪除",
      u8"剪须和药",
      u8"剪齐",
      u8"副业",
      u8"副业产品",
      u8"副业生产",
      u8"副中心",
      u8"副主任",
      u8"副主任医师",
      u8"副主任委员",
      u8"副主席",
      u8"副主教",
      u8"副主编",
      u8"副乡长",
      u8"副书记",
      u8"副井",
      u8"副产",
      u8"副产品",
      u8"副产物",
      u8"副代理人",
      u8"副代表",
      u8"副价",
      u8"副会长",
      u8"副伤寒",
      u8"副体",
      u8"副作用",
      u8"副刀豆氨酸",
      u8"副刊",
      u8"副券",
      u8"副区长",
      u8"副博士",
      u8"副厂长",
      u8"副厅",
      u8"副厅级",
      u8"副厅长",
      u8"副县级",
      u8"副县长",
      u8"副参谋长",
      u8"副反射器",
      u8"副反应",
      u8"副反应系数",
      u8"副台长",
      u8"副司令",
      u8"副司令员",
      u8"副司长",
      u8"副品",
      u8"副团长",
      u8"副基",
      u8"副处",
      u8"副处级",
      u8"副处长",
      u8"副外长",
      u8"副大队长",
      u8"副委员长",
      u8"副学士",
      u8"副官",
      u8"副官处长",
      u8"副审",
      u8"副寺",
      u8"副将",
      u8"副局级",
      u8"副局长",
      u8"副州长",
      u8"副市长",
      u8"副座",
      u8"副庭长",
      u8"副性征",
      u8"副总",
      u8"副总参谋长",
      u8"副总司令",
      u8"副总工程师",
      u8"副总干事",
      u8"副总理",
      u8"副总经理",
      u8"副总统",
      u8"副总编",
      u8"副总裁",
      u8"副所长",
      u8"副手",
      u8"副把",
      u8"副政委",
      u8"副教授",
      u8"副景",
      u8"副本",
      u8"副机",
      u8"副染色体",
      u8"副染色质",
      u8"副标准燃料",
      u8"副标题",
      u8"副校长",
      u8"副核",
      u8"副根",
      u8"副案",
      u8"副检察长",
      u8"副歌",
      u8"副油箱",
      u8"副炮",
      u8"副热带",
      u8"副热带气候",
      u8"副牌",
      u8"副王",
      u8"副现象论",
      u8"副班长",
      u8"副球蛋白",
      u8"副理",
      u8"副理事长",
      u8"副瓣",
      u8"副甲状线",
      u8"副相",
      u8"副省级",
      u8"副省长",
      u8"副睾",
      u8"副矿长",
      u8"副研究员",
      u8"副社长",
      u8"副神经",
      u8"副科",
      u8"副科级",
      u8"副科长",
      u8"副秘书长",
      u8"副程式",
      u8"副突变",
      u8"副粘病毒",
      u8"副线",
      u8"副线圈",
      u8"副组长",
      u8"副经理",
      u8"副署",
      u8"副翼",
      u8"副职",
      u8"副肌球蛋白",
      u8"副肾",
      u8"副董",
      u8"副董事长",
      u8"副蛋白",
      u8"副行长",
      u8"副议长",
      u8"副讯道",
      u8"副词",
      u8"副词片语",
      u8"副跨",
      u8"副轴",
      u8"副部级",
      u8"副部长",
      u8"副酪蛋白",
      u8"副镇长",
      u8"副长",
      u8"副队长",
      u8"副院长",
      u8"副项",
      u8"副领队",
      u8"副题",
      u8"副食",
      u8"副食品",
      u8"副食店",
      u8"副馆长",
      u8"副驾驶",
      u8"副驾驶员",
      u8"副高",
      u8"割上",
      u8"割下",
      u8"割下去",
      u8"割下来",
      u8"割了",
      u8"割伤",
      u8"割作",
      u8"割入",
      u8"割出",
      u8"割刀",
      u8"割切",
      u8"割到",
      u8"割剥元元",
      u8"割剩",
      u8"割包",
      u8"割包皮",
      u8"割去",
      u8"割取",
      u8"割喉岛",
      u8"割回",
      u8"割回去",
      u8"割回来",
      u8"割在",
      u8"割地",
      u8"割地求和",
      u8"割地称臣",
      u8"割地赔款",
      u8"割好",
      u8"割完",
      u8"割尾巴",
      u8"割席",
      u8"割席分坐",
      u8"割席绝交",
      u8"割开",
      u8"割弃",
      u8"割得",
      u8"割恩断义",
      u8"割成",
      u8"割手",
      u8"割捆机",
      u8"割据",
      u8"割据一方",
      u8"割掉",
      u8"割接法",
      u8"割断",
      u8"割晒机",
      u8"割机",
      u8"割来",
      u8"割来割去",
      u8"割法",
      u8"割漆",
      u8"割爱",
      u8"割着",
      u8"割破",
      u8"割碎",
      u8"割礼",
      u8"割离",
      u8"割禾",
      u8"割稻",
      u8"割稻机",
      u8"割管器",
      u8"割线",
      u8"割绒",
      u8"割给",
      u8"割肉",
      u8"割肉补疮",
      u8"割肉饲虎",
      u8"割肚牵肠",
      u8"割股之心",
      u8"割股疗亲",
      u8"割胶",
      u8"割腕",
      u8"割腕自杀",
      u8"割臂之盟",
      u8"割臂盟公",
      u8"割舍",
      u8"割舍不下",
      u8"割草",
      u8"割草机",
      u8"割补阻碍",
      u8"割裂",
      u8"割襟之盟",
      u8"割让",
      u8"割让土地",
      u8"割走",
      u8"割起",
      u8"割起来",
      u8"割过",
      u8"割过去",
      u8"割过来",
      u8"割进",
      u8"割进去",
      u8"割进来",
      u8"割铣解卡法",
      u8"割除",
      u8"割须弃袍",
      u8"割骨疗亲",
      u8"割鸡焉用牛刀",
      u8"割麦",
      u8"剸繁决剧",
      u8"剸繁治剧",
      u8"剽劫",
      u8"剽取",
      u8"剽悍",
      u8"剽掠",
      u8"剽窃",
      u8"剽窃者",
      u8"剽袭",
      u8"剿丝",
      u8"剿共",
      u8"剿匪",
      u8"剿匪抗战",
      u8"剿匪时期",
      u8"剿平",
      u8"剿抚兼施",
      u8"剿捕",
      u8"剿敌",
      u8"剿杀",
      u8"剿灭",
      u8"剿获",
      u8"剿袭",
      u8"剿除",
      u8"劄记",
      u8"劈倒",
      u8"劈刀",
      u8"劈到",
      u8"劈刺",
      u8"劈刺训练",
      u8"劈削",
      u8"劈劈",
      u8"劈劈啪啪",
      u8"劈劈看",
      u8"劈叉",
      u8"劈哩啪啦",
      u8"劈啪",
      u8"劈天盖地",
      u8"劈头",
      u8"劈头盖脑",
      u8"劈头盖脸",
      u8"劈山",
      u8"劈山凿水",
      u8"劈开",
      u8"劈形终端",
      u8"劈形膜",
      u8"劈成",
      u8"劈手",
      u8"劈掌",
      u8"劈杀",
      u8"劈材",
      u8"劈柴",
      u8"劈波斩浪",
      u8"劈胸",
      u8"劈脸",
      u8"劈荆斩棘",
      u8"劈裂",
      u8"劈里啪啦",
      u8"劈锥曲面",
      u8"劈面",
      u8"劈风斩浪",
      u8"劚山觅玉",
      u8"劚玉如泥",
      u8"力不从心",
      u8"力不胜任",
      u8"力不能及",
      u8"力不能支",
      u8"力不自胜",
      u8"力主",
      u8"力争",
      u8"力争上游",
      u8"力人",
      u8"力作",
      u8"力使",
      u8"力促",
      u8"力保",
      u8"力倍功半",
      u8"力偶",
      u8"力偶矩",
      u8"力偶系",
      u8"力克",
      u8"力克斯",
      u8"力击",
      u8"力劝",
      u8"力反馈",
      u8"力可拔山",
      u8"力回馈",
      u8"力图",
      u8"力图振作",
      u8"力图自强",
      u8"力场",
      u8"力均势敌",
      u8"力士",
      u8"力士乐",
      u8"力壮身强",
      u8"力多边形",
      u8"力大无比",
      u8"力大无穷",
      u8"力天",
      u8"力夫特",
      u8"力孤势危",
      u8"力学",
      u8"力学不倦",
      u8"力学性能",
      u8"力学笃行",
      u8"力学系统",
      u8"力守",
      u8"力小任重",
      u8"力尽",
      u8"力尽盘疲",
      u8"力尽神危",
      u8"力尽筋疲",
      u8"力屈计穷",
      u8"力巴",
      u8"力帆队",
      u8"力常数",
      u8"力度",
      u8"力役",
      u8"力心",
      u8"力戒",
      u8"力战",
      u8"力所不及",
      u8"力所不逮",
      u8"力所未逮",
      u8"力所能及",
      u8"力抓",
      u8"力护",
      u8"力拒",
      u8"力拔山兮",
      u8"力拼",
      u8"力拼众敌",
      u8"力持",
      u8"力挫",
      u8"力挫群雄",
      u8"力挽狂澜",
      u8"力排",
      u8"力排众议",
      u8"力推",
      u8"力攻",
      u8"力敌势均",
      u8"力敌千钧",
      u8"力斗",
      u8"力有未逮",
      u8"力殚财竭",
      u8"力比多",
      u8"力气",
      u8"力气活",
      u8"力求",
      u8"力求上进",
      u8"力济九区",
      u8"力点",
      u8"力率",
      u8"力疾",
      u8"力疾从公",
      u8"力矩",
      u8"力矩电机",
      u8"力穷势孤",
      u8"力竭",
      u8"力竭声嘶",
      u8"力系",
      u8"力能",
      u8"力能扛鼎",
      u8"力臂",
      u8"力荐",
      u8"力薄才疏",
      u8"力螺旋",
      u8"力行",
      u8"力证",
      u8"力距",
      u8"力迫关系",
      u8"力退",
      u8"力退众敌",
      u8"力透纸背",
      u8"力道",
      u8"力避",
      u8"力量",
      u8"力量之源",
      u8"力量对比",
      u8"力量强大",
      u8"力量悬殊",
      u8"力量薄弱",
      u8"力量雄厚",
      u8"力钱",
      u8"力阻",
      u8"力陈",
      u8"劝世歌",
      u8"劝业",
      u8"劝业场",
      u8"劝住",
      u8"劝你",
      u8"劝其",
      u8"劝农",
      u8"劝出",
      u8"劝出去",
      u8"劝出来",
      u8"劝到",
      u8"劝劝",
      u8"劝勉",
      u8"劝募",
      u8"劝募者",
      u8"劝化",
      u8"劝君",
      u8"劝君惜取少年时",
      u8"劝君更尽一杯酒",
      u8"劝君莫惜金缕衣",
      u8"劝告",
      u8"劝和",
      u8"劝善",
      u8"劝善惩恶",
      u8"劝善戒恶",
      u8"劝善黜恶",
      u8"劝回",
      u8"劝回去",
      u8"劝回来",
      u8"劝学",
      u8"劝学篇",
      u8"劝导",
      u8"劝开",
      u8"劝慰",
      u8"劝戒",
      u8"劝捐",
      u8"劝架",
      u8"劝止",
      u8"劝百讽一",
      u8"劝解",
      u8"劝解者",
      u8"劝诫",
      u8"劝诱",
      u8"劝说",
      u8"劝说者",
      u8"劝谏",
      u8"劝起",
      u8"劝起来",
      u8"劝过",
      u8"劝进",
      u8"劝退",
      u8"劝酒",
      u8"劝阻",
      u8"劝阻无效",
      u8"劝降",
      u8"劝驾",
      u8"办不到",
      u8"办不完",
      u8"办不成",
      u8"办了",
      u8"办事",
      u8"办事不牢",
      u8"办事不荦",
      u8"办事员",
      u8"办事处",
      u8"办事房",
      u8"办事效率",
      u8"办事机构",
      u8"办企业",
      u8"办伙",
      u8"办公",
      u8"办公事务处理",
      u8"办公会",
      u8"办公会议",
      u8"办公厅",
      u8"办公台",
      u8"办公处",
      u8"办公大楼",
      u8"办公室",
      u8"办公室自动化",
      u8"办公建筑",
      u8"办公房",
      u8"办公时间",
      u8"办公服务部",
      u8"办公枱",
      u8"办公桌",
      u8"办公椅",
      u8"办公楼",
      u8"办公流程",
      u8"办公用品",
      u8"办公用房",
      u8"办公网",
      u8"办公自动化",
      u8"办公设备",
      u8"办公费",
      u8"办几件实事",
      u8"办刊",
      u8"办到",
      u8"办厂",
      u8"办发",
      u8"办后事",
      u8"办喜事",
      u8"办处",
      u8"办好",
      u8"办好事",
      u8"办妥",
      u8"办嫁妆",
      u8"办学",
      u8"办学不力",
      u8"办学条件",
      u8"办完",
      u8"办实事",
      u8"办得",
      u8"办得到",
      u8"办得好",
      u8"办得更好",
      u8"办成",
      u8"办手续",
      u8"办报",
      u8"办报人",
      u8"办校",
      u8"办案",
      u8"办案文明",
      u8"办案费",
      u8"办毕",
      u8"办水",
      u8"办水热",
      u8"办法",
      u8"办班",
      u8"办理",
      u8"办理开户手续",
      u8"办理手续",
      u8"办税",
      u8"办稿",
      u8"办站",
      u8"办结",
      u8"办罪",
      u8"办置",
      u8"办证",
      u8"办证费",
      u8"办货",
      u8"办起",
      u8"功一美二",
      u8"功不可没",
      u8"功业",
      u8"功亏",
      u8"功亏一篑",
      u8"功令",
      u8"功其一点",
      u8"功利",
      u8"功利主义",
      u8"功利性",
      u8"功到自然成",
      u8"功力",
      u8"功力者",
      u8"功劳",
      u8"功劳木",
      u8"功劳簿",
      u8"功勋",
      u8"功勋卓著",
      u8"功勋彪炳",
      u8"功参造化",
      u8"功名",
      u8"功名利禄",
      u8"功名富贵",
      u8"功垒",
      u8"功大于过",
      u8"功夫",
      u8"功夫不负有心人",
      u8"功夫片",
      u8"功夫片儿",
      u8"功夫茶",
      u8"功夫过硬",
      u8"功学社",
      u8"功常德钜",
      u8"功底",
      u8"功德",
      u8"功德圆满",
      u8"功德无量",
      u8"功德林",
      u8"功德碑",
      u8"功心为止",
      u8"功成不居",
      u8"功成名就",
      u8"功成名就者",
      u8"功成名遂",
      u8"功成引退",
      u8"功成弗居",
      u8"功成行满",
      u8"功成身退",
      u8"功成骨枯",
      u8"功放",
      u8"功放机",
      u8"功放板",
      u8"功放管",
      u8"功效",
      u8"功服",
      u8"功架",
      u8"功标青史",
      u8"功法",
      u8"功率",
      u8"功率分配器",
      u8"功率反射率",
      u8"功率因数",
      u8"功率因数补偿",
      u8"功率密度",
      u8"功率展宽",
      u8"功率放大",
      u8"功率放大器",
      u8"功率管",
      u8"功率表",
      u8"功率透射率",
      u8"功用",
      u8"功盖天下",
      u8"功盖天地",
      u8"功绩",
      u8"功罪",
      u8"功考食淡",
      u8"功耗",
      u8"功能",
      u8"功能上",
      u8"功能主治",
      u8"功能分析",
      u8"功能印模",
      u8"功能叶",
      u8"功能块",
      u8"功能型",
      u8"功能域",
      u8"功能定位",
      u8"功能强大",
      u8"功能性",
      u8"功能性矫治器",
      u8"功能性解决",
      u8"功能性颈清扫术",
      u8"功能柱",
      u8"功能模块",
      u8"功能空间一览表",
      u8"功能表",
      u8"功能设计",
      u8"功能选单",
      u8"功能键",
      u8"功能键号",
      u8"功能障碍",
      u8"功臣",
      u8"功若丘山",
      u8"功薄蝉翼",
      u8"功课",
      u8"功课表",
      u8"功败垂成",
      u8"功过",
      u8"功过相抵",
      u8"功遂身退",
      u8"功首罪魁",
      u8"功高",
      u8"功高不赏",
      u8"功高望重",
      u8"功高盖世",
      u8"功高盖主",
      u8"功高震主",
      u8"加一点",
      u8"加上",
      u8"加上去",
      u8"加上条纹",
      u8"加上来",
      u8"加上衬垫",
      u8"加下",
      u8"加下去",
      u8"加下来",
      u8"加个",
      u8"加为",
      u8"加为好友",
      u8"加之",
      u8"加了",
      u8"加于",
      u8"加些",
      u8"加产",
      u8"加亮",
      u8"加人",
      u8"加人一等",
      u8"加仑",
      u8"加仑量",
      u8"加付",
      u8"加以",
      u8"加以克服",
      u8"加以分析",
      u8"加以改进",
      u8"加以解决",
      u8"加价",
      u8"加价热潮",
      u8"加伦",
      u8"加伦河",
      u8"加你",
      u8"加佳",
      u8"加倍",
      u8"加倍努力",
      u8"加值",
      u8"加元",
      u8"加入",
      u8"加入到",
      u8"加入成员",
      u8"加入收藏",
      u8"加入者",
      u8"加入药物",
      u8"加入门派",
      u8"加内特",
      u8"加冕",
      u8"加冕典礼",
      u8"加冕礼",
      u8"加写",
      u8"加农炮",
      u8"加减",
      u8"加减乘除",
      u8"加减器",
      u8"加减法",
      u8"加减法非",
      u8"加出",
      u8"加分",
      u8"加分法",
      u8"加刑",
      u8"加利略",
      u8"加利福尼",
      u8"加利福尼亚",
      u8"加利福尼亚州",
      u8"加利纳",
      u8"加利西亚",
      u8"加到",
      u8"加前缀",
      u8"加剧",
      u8"加剪",
      u8"加力",
      u8"加力燃烧",
      u8"加力燃烧室",
      u8"加加",
      u8"加加减减",
      u8"加加在线",
      u8"加加林",
      u8"加加酱油",
      u8"加劲",
      u8"加勒比",
      u8"加勒比海",
      u8"加勒比海群岛",
      u8"加区",
      u8"加升",
      u8"加印",
      u8"加卷",
      u8"加压",
      u8"加压催产素",
      u8"加压法",
      u8"加压素",
      u8"加压舱",
      u8"加压釜",
      u8"加厚",
      u8"加厚型",
      u8"加发",
      u8"加号",
      u8"加合物",
      u8"加合离子",
      u8"加味",
      u8"加哩粉",
      u8"加回",
      u8"加回去",
      u8"加回来",
      u8"加固",
      u8"加固作用",
      u8"加国",
      u8"加在",
      u8"加在一起",
      u8"加场",
      u8"加场赛",
      u8"加垫",
      u8"加塞",
      u8"加塞儿",
      u8"加填",
      u8"加增",
      u8"加多",
      u8"加多少",
      u8"加够",
      u8"加大",
      u8"加大力度",
      u8"加太兰",
      u8"加太基",
      u8"加套",
      u8"加好",
      u8"加守",
      u8"加完",
      u8"加官",
      u8"加官晋爵",
      u8"加官晋级",
      u8"加官进爵",
      u8"加官进禄",
      u8"加定",
      u8"加害",
      u8"加害于",
      u8"加宽",
      u8"加宽函数",
      u8"加寄",
      u8"加密",
      u8"加密井",
      u8"加密传输",
      u8"加密协议",
      u8"加密器",
      u8"加密狗",
      u8"加密算法",
      u8"加密锁",
      u8"加富尔",
      u8"加对",
      u8"加封",
      u8"加尔各答",
      u8"加尔各达",
      u8"加尔文",
      u8"加尼",
      u8"加尼福尼",
      u8"加尼福尼亚",
      u8"加尾",
      u8"加州",
      u8"加州人",
      u8"加州大学",
      u8"加州红",
      u8"加工",
      u8"加工业",
      u8"加工余量",
      u8"加工出口",
      u8"加工出口区",
      u8"加工区",
      u8"加工厂",
      u8"加工品",
      u8"加工场",
      u8"加工型",
      u8"加工工业",
      u8"加工成本",
      u8"加工款",
      u8"加工水平",
      u8"加工硬化",
      u8"加工能力",
      u8"加工蛋白酶",
      u8"加工订货",
      u8"加工费",
      u8"加工资",
      u8"加布",
      u8"加带",
      u8"加帽",
      u8"加帽位点",
      u8"加帽酶",
      u8"加座",
      u8"加开",
      u8"加开班次",
      u8"加强",
      u8"加强于",
      u8"加强免疫",
      u8"加强力量",
      u8"加强团结",
      u8"加强型",
      u8"加强对",
      u8"加强指导",
      u8"加强教育",
      u8"加强法",
      u8"加强版",
      u8"加强监督",
      u8"加强研究",
      u8"加强筋",
      u8"加强管理",
      u8"加强纪律",
      u8"加强锻炼",
      u8"加强防卫",
      u8"加强领导",
      u8"加当",
      u8"加彭",
      u8"加征",
      u8"加得",
      u8"加德士",
      u8"加德满都",
      u8"加德纳",
      u8"加快",
      u8"加快步伐",
      u8"加快脚步",
      u8"加快调整",
      u8"加快进度",
      u8"加快进程",
      u8"加快速度",
      u8"加急",
      u8"加急电报",
      u8"加性效应",
      u8"加性遗传方差",
      u8"加总",
      u8"加息",
      u8"加意",
      u8"加成",
      u8"加成化合物",
      u8"加成反应",
      u8"加成收费",
      u8"加成聚合",
      u8"加成聚合物",
      u8"加成计费",
      u8"加我",
      u8"加打",
      u8"加把",
      u8"加把劲",
      u8"加护",
      u8"加报",
      u8"加拈",
      u8"加拉",
      u8"加拉加斯",
      u8"加拨",
      u8"加拿大",
      u8"加拿大人",
      u8"加拿大元",
      u8"加拿大队",
      u8"加持",
      u8"加持良治",
      u8"加挂",
      u8"加挂车厢",
      u8"加按",
      u8"加捻",
      u8"加排",
      u8"加提",
      u8"加提成",
      u8"加播",
      u8"加收",
      u8"加数",
      u8"加敷",
      u8"加料",
      u8"加料处理",
      u8"加料酒",
      u8"加斯科因",
      u8"加时赛",
      u8"加映",
      u8"加有",
      u8"加朗派",
      u8"加权",
      u8"加权不等式",
      u8"加权同步距离",
      u8"加权平均值",
      u8"加权平均数",
      u8"加权指数",
      u8"加来",
      u8"加来加去",
      u8"加杯",
      u8"加杯水",
      u8"加枝添叶",
      u8"加查",
      u8"加查县",
      u8"加标签",
      u8"加样槽",
      u8"加格达奇",
      u8"加格达齐",
      u8"加框",
      u8"加档",
      u8"加气仪",
      u8"加氢",
      u8"加氢甲酰基化",
      u8"加氢精制",
      u8"加氢脱烷基催化剂",
      u8"加氢补充精制",
      u8"加氢裂化",
      u8"加氢裂化催化剂",
      u8"加氧酶",
      u8"加氯",
      u8"加氯处理",
      u8"加水",
      u8"加水煮",
      u8"加汁",
      u8"加沙",
      u8"加沙城",
      u8"加油",
      u8"加油加醋",
      u8"加油卡",
      u8"加油器",
      u8"加油战",
      u8"加油打气",
      u8"加油机",
      u8"加油泵",
      u8"加油添酱",
      u8"加油添醋",
      u8"加油站",
      u8"加油车",
      u8"加油阀",
      u8"加法",
      u8"加法器",
      u8"加法消去律",
      u8"加法结合律",
      u8"加注",
      u8"加注机",
      u8"加泰罗",
      u8"加泰隆",
      u8"加泼",
      u8"加洗",
      u8"加洗照片",
      u8"加洛斯",
      u8"加洲旅馆",
      u8"加派",
      u8"加涂",
      u8"加涨",
      u8"加深",
      u8"加深了解",
      u8"加深处理",
      u8"加添",
      u8"加温",
      u8"加温法",
      u8"加湿器",
      u8"加湿机",
      u8"加满",
      u8"加演",
      u8"加点",
      u8"加点油",
      u8"加热",
      u8"加热合成氧化技术",
      u8"加热器",
      u8"加热棒",
      u8"加热法",
      u8"加热炉",
      u8"加热盘管",
      u8"加热管",
      u8"加热输送",
      u8"加煎",
      u8"加特纳",
      u8"加玛",
      u8"加班",
      u8"加班加点",
      u8"加班津贴",
      u8"加班费",
      u8"加班车",
      u8"加生",
      u8"加登",
      u8"加的夫",
      u8"加盐",
      u8"加盐加醋",
      u8"加盖",
      u8"加盖楼顶",
      u8"加盟",
      u8"加盟共和国",
      u8"加盟商",
      u8"加盟店",
      u8"加盟网",
      u8"加盟费",
      u8"加码",
      u8"加砖添瓦",
      u8"加硝",
      u8"加硝处理",
      u8"加碘",
      u8"加碘处理",
      u8"加碘盐",
      u8"加租",
      u8"加积作用",
      u8"加税",
      u8"加穿",
      u8"加等",
      u8"加筋土挡墙",
      u8"加筑",
      u8"加箍",
      u8"加算",
      u8"加粗",
      u8"加精",
      u8"加精选",
      u8"加糖",
      u8"加索尔",
      u8"加紧",
      u8"加紧努力",
      u8"加紧练习",
      u8"加紧脚步",
      u8"加紧训练",
      u8"加纳",
      u8"加纳队",
      u8"加线",
      u8"加练",
      u8"加组",
      u8"加给",
      u8"加缝",
      u8"加缪",
      u8"加罚",
      u8"加考",
      u8"加考科目",
      u8"加聚反应",
      u8"加膝坠泉",
      u8"加膝坠渊",
      u8"加色",
      u8"加色剂",
      u8"加色合成",
      u8"加色处理",
      u8"加色法",
      u8"加色混合",
      u8"加菜",
      u8"加菜金",
      u8"加菲猫",
      u8"加萨走廊",
      u8"加蓬",
      u8"加薪",
      u8"加藤",
      u8"加藤爱",
      u8"加蜜",
      u8"加血",
      u8"加行",
      u8"加补",
      u8"加衬垫",
      u8"加被",
      u8"加装",
      u8"加装在",
      u8"加西亚",
      u8"加解密",
      u8"加计",
      u8"加订",
      u8"加训",
      u8"加设",
      u8"加词",
      u8"加试",
      u8"加说",
      u8"加诸",
      u8"加课",
      u8"加调",
      u8"加贺",
      u8"加赛",
      u8"加赛一场",
      u8"加赠",
      u8"加起来",
      u8"加足",
      u8"加足马力",
      u8"加车",
      u8"加轮",
      u8"加载",
      u8"加载点",
      u8"加达默尔",
      u8"加过",
      u8"加过去",
      u8"加过来",
      u8"加进",
      u8"加进去",
      u8"加进来",
      u8"加送",
      u8"加选",
      u8"加选法",
      u8"加速",
      u8"加速上扬",
      u8"加速卡",
      u8"加速器",
      u8"加速室",
      u8"加速度",
      u8"加速度计",
      u8"加速泵",
      u8"加速流动法",
      u8"加速电容",
      u8"加速老化试验",
      u8"加速运动",
      u8"加速进行",
      u8"加造",
      u8"加那利群岛",
      u8"加酒",
      u8"加酸",
      u8"加酸处理",
      u8"加醋",
      u8"加里",
      u8"加里宁",
      u8"加里森",
      u8"加里波第",
      u8"加重",
      u8"加重比例",
      u8"加重计分",
      u8"加重负担",
      u8"加钱",
      u8"加锁",
      u8"加锁王",
      u8"加错",
      u8"加长",
      u8"加长喷嘴钻头",
      u8"加长型",
      u8"加长版",
      u8"加长车",
      u8"加队",
      u8"加附",
      u8"加飞",
      u8"加餐",
      u8"加香机",
      u8"加高",
      u8"加鲁法",
      u8"务使",
      u8"务农",
      u8"务农人家",
      u8"务头",
      u8"务实",
      u8"务实去等",
      u8"务实精神",
      u8"务川",
      u8"务川仡佬族苗族自治县",
      u8"务工",
      u8"务工人员",
      u8"务工地",
      u8"务工者",
      u8"务工青年",
      u8"务当",
      u8"务必",
      u8"务期",
      u8"务本",
      u8"务本力穑",
      u8"务本抑末",
      u8"务正",
      u8"务求",
      u8"务虚",
      u8"务要",
      u8"务请",
      u8"务须",
      u8"劣于",
      u8"劣势",
      u8"劣品",
      u8"劣地",
      u8"劣弧",
      u8"劣性",
      u8"劣株",
      u8"劣根",
      u8"劣根性",
      u8"劣种",
      u8"劣等",
      u8"劣等品",
      u8"劣等性",
      u8"劣等生",
      u8"劣等货",
      u8"劣绅",
      u8"劣货",
      u8"劣质",
      u8"劣质品",
      u8"劣质奶粉",
      u8"劣迹",
      u8"劣迹昭彰",
      u8"劣迹昭着",
      u8"劣迹昭著",
      u8"劣酒",
      u8"劣马",
      u8"动一动",
      u8"动上",
      u8"动不动",
      u8"动不失时",
      u8"动中窾要",
      u8"动之以情",
      u8"动乱",
      u8"动乱不安",
      u8"动了",
      u8"动了动",
      u8"动了心",
      u8"动产",
      u8"动人",
      u8"动人心弦",
      u8"动人心肺",
      u8"动人心魄",
      u8"动令",
      u8"动作",
      u8"动作与时间研究",
      u8"动作光谱",
      u8"动作性",
      u8"动作感觉",
      u8"动作游戏",
      u8"动作灵活性",
      u8"动作片",
      u8"动作电位",
      u8"动作示范",
      u8"动作类",
      u8"动作练习曲线",
      u8"动作速度",
      u8"动作键",
      u8"动兵",
      u8"动刀",
      u8"动刀动枪",
      u8"动刑",
      u8"动到",
      u8"动力",
      u8"动力仪",
      u8"动力伞",
      u8"动力区",
      u8"动力厂",
      u8"动力反应堆",
      u8"动力吸振器",
      u8"动力地貌学",
      u8"动力学",
      u8"动力学光度学",
      u8"动力学方程",
      u8"动力学盐效应",
      u8"动力学链长",
      u8"动力定位半潜式钻井船",
      u8"动力定位模拟控制器",
      u8"动力工程",
      u8"动力心理学",
      u8"动力机",
      u8"动力机冷却系统",
      u8"动力机械",
      u8"动力源",
      u8"动力火车",
      u8"动力电池",
      u8"动力站",
      u8"动力粘度系数",
      u8"动力系统",
      u8"动力蛋白",
      u8"动力蛋白激活蛋白",
      u8"动力蛋白臂",
      u8"动力装置",
      u8"动力设备",
      u8"动力车",
      u8"动力软管卷盘",
      u8"动动",
      u8"动动手",
      u8"动动看",
      u8"动动脑",
      u8"动压",
      u8"动口",
      u8"动口不动手",
      u8"动合子",
      u8"动名词",
      u8"动向",
      u8"动向不明",
      u8"动听",
      u8"动员",
      u8"动员令",
      u8"动员会",
      u8"动员大会",
      u8"动员戡乱",
      u8"动员戡乱时期",
      u8"动员群众",
      u8"动嘴",
      u8"动因",
      u8"动土",
      u8"动地",
      u8"动地惊天",
      u8"动如参商",
      u8"动如脱兔",
      u8"动容",
      u8"动宾",
      u8"动工",
      u8"动干戈",
      u8"动平衡",
      u8"动弹",
      u8"动弹不得",
      u8"动彻",
      u8"动得",
      u8"动心",
      u8"动心忍性",
      u8"动心忍情",
      u8"动心怵目",
      u8"动心骇目",
      u8"动态",
      u8"动态内存",
      u8"动态分配",
      u8"动态图",
      u8"动态地",
      u8"动态地图",
      u8"动态地址转换",
      u8"动态域名",
      u8"动态平衡",
      u8"动态扭斜",
      u8"动态控制",
      u8"动态效果",
      u8"动态显示",
      u8"动态桌面",
      u8"动态滤波器",
      u8"动态漫游",
      u8"动态码率",
      u8"动态网",
      u8"动态裂缝尺寸",
      u8"动态规划法",
      u8"动态规划算法",
      u8"动态质谱仪",
      u8"动态重定位",
      u8"动态链接库文件",
      u8"动态错误",
      u8"动态随机存取存储器",
      u8"动怒",
      u8"动情",
      u8"动情周期",
      u8"动情处",
      u8"动情期",
      u8"动感",
      u8"动感单车",
      u8"动感地带",
      u8"动感情",
      u8"动感论坛",
      u8"动感超人",
      u8"动手",
      u8"动手做",
      u8"动手动脚",
      u8"动手术",
      u8"动手脚",
      u8"动摇",
      u8"动摇不稳",
      u8"动摩擦力",
      u8"动撼",
      u8"动景运动",
      u8"动机",
      u8"动机性选择",
      u8"动机性遗忘",
      u8"动机本能说",
      u8"动机训练",
      u8"动来动去",
      u8"动枪",
      u8"动检",
      u8"动植物",
      u8"动植物检疫",
      u8"动武",
      u8"动气",
      u8"动滑轮",
      u8"动滤失量",
      u8"动漫",
      u8"动漫人",
      u8"动漫卡通",
      u8"动漫堂",
      u8"动漫展",
      u8"动漫画",
      u8"动漫网",
      u8"动火",
      u8"动物",
      u8"动物下体",
      u8"动物交往",
      u8"动物传布",
      u8"动物体",
      u8"动物保健",
      u8"动物力学",
      u8"动物化学",
      u8"动物化石",
      u8"动物区系",
      u8"动物医院",
      u8"动物园",
      u8"动物图片",
      u8"动物地理学",
      u8"动物学",
      u8"动物学家",
      u8"动物工具使用",
      u8"动物心理学",
      u8"动物志学",
      u8"动物性",
      u8"动物性饲料",
      u8"动物早期经验",
      u8"动物模型",
      u8"动物毒素",
      u8"动物求偶行为",
      u8"动物油",
      u8"动物界",
      u8"动物纤维",
      u8"动物细胞",
      u8"动物细胞系",
      u8"动物群",
      u8"动物群落",
      u8"动物解剖",
      u8"动状词",
      u8"动理学",
      u8"动生电动势",
      u8"动用",
      u8"动用储量",
      u8"动电分离技术",
      u8"动电学",
      u8"动电超滤分析",
      u8"动画",
      u8"动画人物",
      u8"动画图",
      u8"动画图片",
      u8"动画城",
      u8"动画影片",
      u8"动画教程",
      u8"动画文件",
      u8"动画片",
      u8"动画片儿",
      u8"动画版",
      u8"动画电影",
      u8"动画短片",
      u8"动画素材",
      u8"动画网",
      u8"动画设计",
      u8"动真格",
      u8"动真格的",
      u8"动稳性力臂",
      u8"动窝",
      u8"动笔",
      u8"动粗",
      u8"动线地图",
      u8"动肝火",
      u8"动能",
      u8"动能定理",
      u8"动脉",
      u8"动脉夹",
      u8"动脉弓",
      u8"动脉炎",
      u8"动脉瘤",
      u8"动脉硬化",
      u8"动脉粥样硬化",
      u8"动脉血",
      u8"动脑",
      u8"动脑子",
      u8"动脑筋",
      u8"动脚",
      u8"动荡",
      u8"动荡不安",
      u8"动荡不定",
      u8"动蛋白",
      u8"动蛹",
      u8"动觉",
      u8"动觉计",
      u8"动议",
      u8"动词",
      u8"动词化",
      u8"动词变化",
      u8"动质",
      u8"动质体",
      u8"动起",
      u8"动起来",
      u8"动身",
      u8"动身前往",
      u8"动轮",
      u8"动轮轴",
      u8"动辄",
      u8"动辄得咎",
      u8"动迁",
      u8"动迁户",
      u8"动迁房",
      u8"动过",
      u8"动过心",
      u8"动过手脚",
      u8"动配合",
      u8"动量",
      u8"动量守恒定律",
      u8"动量定理",
      u8"动量流密度",
      u8"动量矩",
      u8"动量表象",
      u8"动问",
      u8"动静",
      u8"动静有常",
      u8"动静脉",
      u8"动魄惊心",
      u8"助于",
      u8"助产",
      u8"助产士",
      u8"助产婆",
      u8"助人",
      u8"助人下石",
      u8"助人为乐",
      u8"助人为快",
      u8"助人为快乐之本",
      u8"助人行为",
      u8"助你",
      u8"助兴",
      u8"助养",
      u8"助养金",
      u8"助凝剂",
      u8"助剂",
      u8"助剂厂",
      u8"助力",
      u8"助力器",
      u8"助力器械",
      u8"助力车",
      u8"助动词",
      u8"助动车",
      u8"助听器",
      u8"助困",
      u8"助天为虐",
      u8"助威",
      u8"助威团",
      u8"助威声",
      u8"助学",
      u8"助学金",
      u8"助工",
      u8"助您",
      u8"助我",
      u8"助我张目",
      u8"助战",
      u8"助手",
      u8"助推",
      u8"助推器",
      u8"助攻",
      u8"助教",
      u8"助散",
      u8"助桀为虐",
      u8"助检员",
      u8"助残",
      u8"助残日",
      u8"助消化",
      u8"助滤剂",
      u8"助焊剂",
      u8"助燃",
      u8"助燃剂",
      u8"助理",
      u8"助理员",
      u8"助理工程师",
      u8"助理检察员",
      u8"助理级",
      u8"助益",
      u8"助研",
      u8"助纣为虐",
      u8"助细胞",
      u8"助老",
      u8"助耕",
      u8"助色团",
      u8"助虐",
      u8"助记",
      u8"助记符",
      u8"助词",
      u8"助语",
      u8"助跑",
      u8"助辩",
      u8"助边输财",
      u8"助选",
      u8"助选员",
      u8"助选团",
      u8"助长",
      u8"助长声势",
      u8"助间型霉素",
      u8"助阵",
      u8"助飞器",
      u8"助饷",
      u8"努佩",
      u8"努儿海",
      u8"努力",
      u8"努力下去",
      u8"努力争取",
      u8"努力以赴",
      u8"努力做到",
      u8"努力创造",
      u8"努力地",
      u8"努力奋斗",
      u8"努力学习",
      u8"努力完成",
      u8"努力实现",
      u8"努力工作",
      u8"努力提高",
      u8"努努嘴",
      u8"努劲儿",
      u8"努嘴",
      u8"努嘴儿",
      u8"努尔哈赤",
      u8"努得",
      u8"努比亚",
      u8"努瓦克肖",
      u8"努瓦克肖特",
      u8"努目",
      u8"努着",
      u8"努着嘴",
      u8"努起",
      u8"努起嘴",
      u8"努起嘴来",
      u8"劫争",
      u8"劫匪",
      u8"劫去",
      u8"劫后余生",
      u8"劫夺",
      u8"劫富济贫",
      u8"劫寨",
      u8"劫得",
      u8"劫持",
      u8"劫持人质",
      u8"劫持犯",
      u8"劫持者",
      u8"劫掠",
      u8"劫掠一空",
      u8"劫数",
      u8"劫数难逃",
      u8"劫机",
      u8"劫机犯",
      u8"劫机者",
      u8"劫波",
      u8"劫牢",
      u8"劫狱",
      u8"劫监",
      u8"劫盗",
      u8"劫簸",
      u8"劫船",
      u8"劫色",
      u8"劫获",
      u8"劫营",
      u8"劫走",
      u8"劫车",
      u8"劫运",
      u8"劫道",
      u8"劫难",
      u8"劬劳",
      u8"劬劳之恩",
      u8"劬劳顾复",
      u8"励人",
      u8"励兵秣马",
      u8"励志",
      u8"励志书",
      u8"励志竭精",
      u8"励磁机",
      u8"励粗图治",
      u8"励精图志",
      u8"励精图治",
      u8"励精图进",
      u8"励精更始",
      u8"励精求治",
      u8"励行",
      u8"劲健",
      u8"劲儿",
      u8"劲力",
      u8"劲升",
      u8"劲吹",
      u8"劲地",
      u8"劲头",
      u8"劲头十足",
      u8"劲射",
      u8"劲度系数",
      u8"劲往一处使",
      u8"劲敌",
      u8"劲旅",
      u8"劲松",
      u8"劲歌",
      u8"劲歌热舞",
      u8"劲直",
      u8"劲舞",
      u8"劲舞团",
      u8"劲草",
      u8"劲道",
      u8"劲酒",
      u8"劲雷",
      u8"劲风",
      u8"劲骨丰肌",
      u8"劳乏",
      u8"劳人费马",
      u8"劳什子",
      u8"劳伤",
      u8"劳伦斯",
      u8"劳作",
      u8"劳作室",
      u8"劳作课",
      u8"劳保",
      u8"劳保单",
      u8"劳保局",
      u8"劳保用品",
      u8"劳保鞋",
      u8"劳倦",
      u8"劳做",
      u8"劳军",
      u8"劳军团",
      u8"劳力",
      u8"劳力士",
      u8"劳力士表",
      u8"劳力密集工业",
      u8"劳务",
      u8"劳务中介",
      u8"劳务工",
      u8"劳务市场",
      u8"劳务所",
      u8"劳务费",
      u8"劳务输出",
      u8"劳动",
      u8"劳动产品",
      u8"劳动人事",
      u8"劳动人口",
      u8"劳动人民",
      u8"劳动价值论",
      u8"劳动保护",
      u8"劳动保护用品",
      u8"劳动保险",
      u8"劳动保险所",
      u8"劳动党",
      u8"劳动力",
      u8"劳动化",
      u8"劳动卫生",
      u8"劳动厅",
      u8"劳动合同",
      u8"劳动和社会保障部",
      u8"劳动和社会保障部部长",
      u8"劳动地域分工",
      u8"劳动基准",
      u8"劳动基准法",
      u8"劳动定员",
      u8"劳动定额",
      u8"劳动密集型",
      u8"劳动对象",
      u8"劳动就业",
      u8"劳动局",
      u8"劳动工具",
      u8"劳动工分",
      u8"劳动工资",
      u8"劳动工资制度",
      u8"劳动市场",
      u8"劳动布",
      u8"劳动强度",
      u8"劳动心理学",
      u8"劳动态度",
      u8"劳动成果",
      u8"劳动所得",
      u8"劳动手段",
      u8"劳动报酬",
      u8"劳动收入",
      u8"劳动改造",
      u8"劳动效率",
      u8"劳动教养",
      u8"劳动教育",
      u8"劳动新闻",
      u8"劳动日",
      u8"劳动时间",
      u8"劳动服",
      u8"劳动服务公司",
      u8"劳动权",
      u8"劳动条件",
      u8"劳动模范",
      u8"劳动法",
      u8"劳动生产",
      u8"劳动生产力",
      u8"劳动生产率",
      u8"劳动竞赛",
      u8"劳动管理",
      u8"劳动纪律",
      u8"劳动组合",
      u8"劳动群众",
      u8"劳动者",
      u8"劳动能力",
      u8"劳动致富",
      u8"劳动节",
      u8"劳动英雄",
      u8"劳动课",
      u8"劳动资料",
      u8"劳动路",
      u8"劳动过程",
      u8"劳动部",
      u8"劳动部门",
      u8"劳动量",
      u8"劳动锻炼",
      u8"劳动防护",
      u8"劳动阶级",
      u8"劳发",
      u8"劳命伤财",
      u8"劳埃德",
      u8"劳培科",
      u8"劳基法",
      u8"劳太监",
      u8"劳委会",
      u8"劳宫",
      u8"劳尔",
      u8"劳工",
      u8"劳工保险",
      u8"劳工保险局",
      u8"劳工处",
      u8"劳工局",
      u8"劳工市场",
      u8"劳工法",
      u8"劳工神圣",
      u8"劳工证",
      u8"劳工部",
      u8"劳工阶层",
      u8"劳工阶级",
      u8"劳师",
      u8"劳师动众",
      u8"劳师糜饷",
      u8"劳师袭远",
      u8"劳形",
      u8"劳形苦心",
      u8"劳役",
      u8"劳役地租",
      u8"劳德诺",
      u8"劳心",
      u8"劳心焦思",
      u8"劳心者治",
      u8"劳心者治人",
      u8"劳心苦思",
      u8"劳思逸淫",
      u8"劳总",
      u8"劳拉",
      u8"劳损",
      u8"劳支",
      u8"劳改",
      u8"劳改犯",
      u8"劳改营",
      u8"劳改队",
      u8"劳教",
      u8"劳教所",
      u8"劳斯莱斯",
      u8"劳方",
      u8"劳服",
      u8"劳模",
      u8"劳步",
      u8"劳民",
      u8"劳民伤财",
      u8"劳民动众",
      u8"劳民费财",
      u8"劳烦",
      u8"劳燕分飞",
      u8"劳瘁",
      u8"劳碌",
      u8"劳碌命",
      u8"劳神",
      u8"劳科所",
      u8"劳科院",
      u8"劳筋苦骨",
      u8"劳累",
      u8"劳累过度",
      u8"劳经系",
      u8"劳绩",
      u8"劳而无功",
      u8"劳而无获",
      u8"劳苦",
      u8"劳苦功高",
      u8"劳苦大众",
      u8"劳贺",
      u8"劳资",
      u8"劳资关系",
      u8"劳资双方",
      u8"劳资政",
      u8"劳资科",
      u8"劳资纠纷",
      u8"劳身焦思",
      u8"劳逊",
      u8"劳逸",
      u8"劳逸不均",
      u8"劳逸结合",
      u8"劳部发",
      u8"劳金",
      u8"劳顿",
      u8"劳驾",
      u8"势不两存",
      u8"势不两立",
      u8"势不可当",
      u8"势不可挡",
      u8"势不可遏",
      u8"势不并立",
      u8"势之所趋",
      u8"势倾天下",
      u8"势倾朝野",
      u8"势函数",
      u8"势利",
      u8"势利之交",
      u8"势利小人",
      u8"势利眼",
      u8"势力",
      u8"势力值",
      u8"势力范围",
      u8"势单力薄",
      u8"势合形离",
      u8"势在必得",
      u8"势在必行",
      u8"势在必进",
      u8"势均力敌",
      u8"势垒穿透",
      u8"势垒高度",
      u8"势头",
      u8"势如冰炭",
      u8"势如劈竹",
      u8"势如水火",
      u8"势如破竹",
      u8"势如累卵",
      u8"势孤力薄",
      u8"势将",
      u8"势必",
      u8"势必会",
      u8"势必在",
      u8"势必牵动",
      u8"势必能",
      u8"势态",
      u8"势成骑虎",
      u8"势所必然",
      u8"势所难免",
      u8"势派",
      u8"势焰",
      u8"势焰熏天",
      u8"势电解质",
      u8"势穷力屈",
      u8"势穷力敌",
      u8"势穷力竭",
      u8"势穷力蹙",
      u8"势能",
      u8"势至",
      u8"势若脱兔",
      u8"势要",
      u8"势越二极管",
      u8"势阱",
      u8"势高益危",
      u8"勃兴",
      u8"勃列日涅",
      u8"勃列日涅夫",
      u8"勃利",
      u8"勃利县",
      u8"勃利市",
      u8"勃勃",
      u8"勃勃生机",
      u8"勃发",
      u8"勃发生机",
      u8"勃拉姆斯",
      u8"勃朗",
      u8"勃朗宁",
      u8"勃朗特",
      u8"勃然",
      u8"勃然变色",
      u8"勃然大怒",
      u8"勃然失色",
      u8"勃然奋励",
      u8"勃然而起",
      u8"勃谿",
      u8"勃起",
      u8"勃郎宁",
      u8"勃长期",
      u8"勇为",
      u8"勇于",
      u8"勇于创新",
      u8"勇于开拓",
      u8"勇于批评",
      u8"勇于探索",
      u8"勇于认错",
      u8"勇于进取",
      u8"勇健",
      u8"勇冠三军",
      u8"勇决",
      u8"勇力",
      u8"勇动多怨",
      u8"勇勇敢敢",
      u8"勇士",
      u8"勇士队",
      u8"勇夫",
      u8"勇夫悍卒",
      u8"勇夺",
      u8"勇将",
      u8"勇往",
      u8"勇往直前",
      u8"勇悍",
      u8"勇挑",
      u8"勇挑重担",
      u8"勇探实录",
      u8"勇救",
      u8"勇敢",
      u8"勇敢善战",
      u8"勇敢地",
      u8"勇敢无畏",
      u8"勇敢沉着",
      u8"勇敢的人",
      u8"勇敢者",
      u8"勇斗",
      u8"勇斗歹徒",
      u8"勇武",
      u8"勇毅",
      u8"勇气",
      u8"勇气十足",
      u8"勇气可嘉",
      u8"勇气号",
      u8"勇猛",
      u8"勇猛善战",
      u8"勇猛果敢",
      u8"勇猛直前",
      u8"勇猛精进",
      u8"勇猛过人",
      u8"勇男蠢妇",
      u8"勇者",
      u8"勇者不惧",
      u8"勇者斗恶龙",
      u8"勇者胜",
      u8"勇而无谋",
      u8"勇退",
      u8"勇锐",
      u8"勉为",
      u8"勉为其难",
      u8"勉力",
      u8"勉励",
      u8"勉勉强强",
      u8"勉县",
      u8"勉强",
      u8"勋业",
      u8"勋伯格",
      u8"勋努达美",
      u8"勋劳",
      u8"勋勉",
      u8"勋爵",
      u8"勋章",
      u8"勋绩",
      u8"勐海",
      u8"勐海县",
      u8"勐腊",
      u8"勐腊县",
      u8"勒令",
      u8"勒住",
      u8"勒克斯",
      u8"勒兵",
      u8"勒夏特列原理",
      u8"勒夫波",
      u8"勒头",
      u8"勒布朗",
      u8"勒抑",
      u8"勒梅尔",
      u8"勒死",
      u8"勒法夫瑞",
      u8"勒派",
      u8"勒石",
      u8"勒碑",
      u8"勒索",
      u8"勒索案",
      u8"勒索钱财",
      u8"勒紧",
      u8"勒紧裤带",
      u8"勒绳",
      u8"勒腰",
      u8"勒让德变换",
      u8"勒诈",
      u8"勒诺特尔式园林",
      u8"勒贝格测度",
      u8"勒贝格积分",
      u8"勒赎",
      u8"勒逼",
      u8"勒那海",
      u8"勒马",
      u8"勗勉",
      u8"勘乱",
      u8"勘定",
      u8"勘察",
      u8"勘察者",
      u8"勘探",
      u8"勘探员",
      u8"勘探局",
      u8"勘探工程",
      u8"勘探成本",
      u8"勘探者",
      u8"勘探队",
      u8"勘查",
      u8"勘查业",
      u8"勘校",
      u8"勘正",
      u8"勘测",
      u8"勘测员",
      u8"勘测局",
      u8"勘测队",
      u8"勘灾",
      u8"勘订",
      u8"勘误",
      u8"勘误表",
      u8"勘验",
      u8"募兵",
      u8"募兵制",
      u8"募化",
      u8"募得",
      u8"募捐",
      u8"募捐箱",
      u8"募款",
      u8"募用",
      u8"募穴",
      u8"募股",
      u8"募集",
      u8"勤于",
      u8"勤于思考",
      u8"勤仆",
      u8"勤以补拙",
      u8"勤俭",
      u8"勤俭为服",
      u8"勤俭为服务之本",
      u8"勤俭办一切事业",
      u8"勤俭务实",
      u8"勤俭建国",
      u8"勤俭持家",
      u8"勤俭朴实",
      u8"勤俭节约",
      u8"勤前教育",
      u8"勤力",
      u8"勤加练习",
      u8"勤务",
      u8"勤务兵",
      u8"勤务员",
      u8"勤务训练",
      u8"勤劳",
      u8"勤劳努力",
      u8"勤劳勇敢",
      u8"勤劳致富",
      u8"勤勉",
      u8"勤勉不倦",
      u8"勤勤恳恳",
      u8"勤奋",
      u8"勤奋努力",
      u8"勤奋好学",
      u8"勤奋学习",
      u8"勤奋工作",
      u8"勤学",
      u8"勤学好问",
      u8"勤学苦练",
      u8"勤工俭学",
      u8"勤工助学",
      u8"勤快",
      u8"勤恳",
      u8"勤政",
      u8"勤政廉政",
      u8"勤政殿",
      u8"勤有功嬉",
      u8"勤有功嬉无益",
      u8"勤朴",
      u8"勤杂",
      u8"勤杂人员",
      u8"勤杂工",
      u8"勤洗勤换",
      u8"勤洗手",
      u8"勤王",
      u8"勤益工专",
      u8"勤练",
      u8"勤耕",
      u8"勤能补拙",
      u8"勤苦",
      u8"勤读",
      u8"勤谨",
      u8"勺儿",
      u8"勺子",
      u8"勺水一脔",
      u8"勺状软骨",
      u8"勾三搭四",
      u8"勾上",
      u8"勾下",
      u8"勾中",
      u8"勾了",
      u8"勾人",
      u8"勾住",
      u8"勾佬",
      u8"勾兑",
      u8"勾出",
      u8"勾勒",
      u8"勾勾",
      u8"勾勾搭搭",
      u8"勾去",
      u8"勾取",
      u8"勾号",
      u8"勾在",
      u8"勾峰",
      u8"勾引",
      u8"勾当",
      u8"勾心斗角",
      u8"勾掉",
      u8"勾描",
      u8"勾搭",
      u8"勾来勾去",
      u8"勾栏",
      u8"勾消",
      u8"勾球",
      u8"勾画",
      u8"勾画出",
      u8"勾留",
      u8"勾线",
      u8"勾结",
      u8"勾绘",
      u8"勾股定理",
      u8"勾股形",
      u8"勾肩搭背",
      u8"勾脸",
      u8"勾芡",
      u8"勾花网",
      u8"勾走",
      u8"勾起",
      u8"勾践",
      u8"勾践剑",
      u8"勾过",
      u8"勾过去",
      u8"勾过来",
      u8"勾连",
      u8"勾通",
      u8"勾针",
      u8"勾销",
      u8"勾阑",
      u8"勾除",
      u8"勾魂",
      u8"勾魂战地",
      u8"勾魂摄魄",
      u8"勿下",
      u8"勿以善小而不为",
      u8"勿以恶小而为之",
      u8"勿动",
      u8"勿因善小而不为",
      u8"勿失良机",
      u8"勿如",
      u8"勿宁说",
      u8"勿庸置疑",
      u8"勿庸赘言",
      u8"勿忘",
      u8"勿忘在莒",
      u8"勿忘我",
      u8"勿念",
      u8"勿怠勿忘",
      u8"勿扰",
      u8"勿施于人",
      u8"勿枉勿纵",
      u8"勿药",
      u8"勿药有喜",
      u8"勿要",
      u8"勿言",
      u8"勿谓言之不预",
      u8"勿谓言之不预也",
      u8"勿近",
      u8"勿进",
      u8"勿需",
      u8"匀停",
      u8"匀兑",
      u8"匀净",
      u8"匀出",
      u8"匀出来",
      u8"匀匀",
      u8"匀变速直线运动",
      u8"匀和",
      u8"匀实",
      u8"匀摊",
      u8"匀整",
      u8"匀染",
      u8"匀浆",
      u8"匀溜",
      u8"匀称",
      u8"匀红点翠",
      u8"匀细",
      u8"匀脂抹粉",
      u8"匀脸",
      u8"匀调",
      u8"匀速",
      u8"匀速圆周",
      u8"匀速圆周运动",
      u8"匀速直线",
      u8"匀速直线运动",
      u8"匀速转动",
      u8"匀速运动",
      u8"包上",
      u8"包上去",
      u8"包上来",
      u8"包上牌",
      u8"包下",
      u8"包下去",
      u8"包下来",
      u8"包不同",
      u8"包举",
      u8"包乘",
      u8"包乘制",
      u8"包乘组",
      u8"包书皮",
      u8"包书皮纸",
      u8"包了",
      u8"包二奶",
      u8"包产",
      u8"包产到户",
      u8"包伙",
      u8"包伤",
      u8"包住",
      u8"包修",
      u8"包公",
      u8"包准",
      u8"包办",
      u8"包办代替",
      u8"包办婚姻",
      u8"包包",
      u8"包医",
      u8"包厢",
      u8"包去",
      u8"包叙定",
      u8"包吃",
      u8"包吃包住",
      u8"包吃包穿",
      u8"包合",
      u8"包合作用",
      u8"包君",
      u8"包君满意",
      u8"包含",
      u8"包含着",
      u8"包商",
      u8"包囊",
      u8"包囊化作用",
      u8"包围",
      u8"包围住",
      u8"包围圈",
      u8"包围着",
      u8"包围网",
      u8"包围起来",
      u8"包圆",
      u8"包圆儿",
      u8"包在",
      u8"包场",
      u8"包埋",
      u8"包埋剂",
      u8"包埋材模型",
      u8"包夜",
      u8"包天",
      u8"包头",
      u8"包头市",
      u8"包夹",
      u8"包好",
      u8"包子",
      u8"包子铺",
      u8"包子馅",
      u8"包孕",
      u8"包容",
      u8"包容心",
      u8"包容性",
      u8"包容百川",
      u8"包小松",
      u8"包层",
      u8"包工",
      u8"包工包料",
      u8"包工头",
      u8"包工队",
      u8"包干",
      u8"包干儿",
      u8"包干到户",
      u8"包干制",
      u8"包干区",
      u8"包干性",
      u8"包干负责",
      u8"包年",
      u8"包庇",
      u8"包庇罪",
      u8"包式终端",
      u8"包心菜",
      u8"包惜弱",
      u8"包成",
      u8"包户",
      u8"包房",
      u8"包扎",
      u8"包扎法",
      u8"包扎着",
      u8"包打",
      u8"包打听",
      u8"包打天下",
      u8"包扶",
      u8"包抄",
      u8"包括",
      u8"包拯",
      u8"包换",
      u8"包探",
      u8"包揽",
      u8"包揽生意",
      u8"包揽词讼",
      u8"包摄",
      u8"包教",
      u8"包教包会",
      u8"包曼",
      u8"包月",
      u8"包月仅",
      u8"包月制",
      u8"包月卡",
      u8"包月费",
      u8"包机",
      u8"包机去",
      u8"包机来",
      u8"包村",
      u8"包梏",
      u8"包河区",
      u8"包法利",
      u8"包涵",
      u8"包牌价",
      u8"包特菌属",
      u8"包玉刚",
      u8"包皮",
      u8"包皮炎",
      u8"包着",
      u8"包票",
      u8"包租",
      u8"包租公",
      u8"包租婆",
      u8"包管",
      u8"包箱",
      u8"包米",
      u8"包紧",
      u8"包给",
      u8"包络",
      u8"包络检波",
      u8"包络线",
      u8"包罗",
      u8"包罗万有",
      u8"包罗万象",
      u8"包羞忍耻",
      u8"包羞忍辱",
      u8"包而不办",
      u8"包背装",
      u8"包脚",
      u8"包膜",
      u8"包膜抗原",
      u8"包膜突起",
      u8"包膜糖蛋白",
      u8"包膜蛋白",
      u8"包船",
      u8"包船去",
      u8"包船来",
      u8"包茎",
      u8"包菜",
      u8"包蕴",
      u8"包藏",
      u8"包藏奸心",
      u8"包藏祸心",
      u8"包衣",
      u8"包袋",
      u8"包袋厂",
      u8"包被",
      u8"包被抗原",
      u8"包袱",
      u8"包袱井",
      u8"包袱底儿",
      u8"包装",
      u8"包装业",
      u8"包装厂",
      u8"包装品",
      u8"包装容器",
      u8"包装工人",
      u8"包装带",
      u8"包装机",
      u8"包装材料",
      u8"包装桶",
      u8"包装法",
      u8"包装物",
      u8"包装率",
      u8"包装盒",
      u8"包装箱",
      u8"包装纸",
      u8"包装网",
      u8"包装者",
      u8"包装袋",
      u8"包装费",
      u8"包裹",
      u8"包裹单",
      u8"包谷",
      u8"包豪斯",
      u8"包购包销",
      u8"包赔",
      u8"包走",
      u8"包起",
      u8"包起来",
      u8"包身",
      u8"包身契",
      u8"包身工",
      u8"包车",
      u8"包车去",
      u8"包车来",
      u8"包车费",
      u8"包转发",
      u8"包退",
      u8"包金",
      u8"包钢",
      u8"包银",
      u8"包销",
      u8"包销商",
      u8"包门套",
      u8"包间",
      u8"包青天",
      u8"包饭",
      u8"匆促",
      u8"匆促之间",
      u8"匆促间",
      u8"匆匆",
      u8"匆匆一看",
      u8"匆匆忙忙",
      u8"匆卒",
      u8"匆忙",
      u8"匆忙之间",
      u8"匆忙间",
      u8"匆猝",
      u8"匆遽",
      u8"匈奴",
      u8"匈奴人",
      u8"匈奴血",
      u8"匈牙利",
      u8"匈牙利人",
      u8"匈牙利国家交响乐团",
      u8"匈牙利大",
      u8"匈牙利大平原",
      u8"匈牙利语",
      u8"匈牙利队",
      u8"匍伏",
      u8"匍匐",
      u8"匍匐之救",
      u8"匍匐前进",
      u8"匍匐型花生",
      u8"匍匐茎",
      u8"匍匐运动",
      u8"匏瓜空悬",
      u8"匐伏",
      u8"匐匍",
      u8"匕首",
      u8"匕鬯不惊",
      u8"匕鬯无惊",
      u8"化为",
      u8"化为乌有",
      u8"化为己有",
      u8"化为泡影",
      u8"化为灰烬",
      u8"化了",
      u8"化作",
      u8"化作春泥更护花",
      u8"化做",
      u8"化入",
      u8"化公为私",
      u8"化冻",
      u8"化出",
      u8"化分",
      u8"化募",
      u8"化及豚鱼",
      u8"化合",
      u8"化合价",
      u8"化合反应",
      u8"化合态",
      u8"化合性",
      u8"化合物",
      u8"化合量",
      u8"化名",
      u8"化境",
      u8"化处",
      u8"化外",
      u8"化外之民",
      u8"化妆",
      u8"化妆包",
      u8"化妆台",
      u8"化妆品",
      u8"化妆室",
      u8"化妆师",
      u8"化妆柜",
      u8"化妆棉",
      u8"化妆水",
      u8"化妆盒",
      u8"化妆箱",
      u8"化妆舞会",
      u8"化妆袋",
      u8"化妆镜",
      u8"化妆间",
      u8"化子",
      u8"化学",
      u8"化学交联",
      u8"化学作用",
      u8"化学修饰",
      u8"化学偶联",
      u8"化学偶联假说",
      u8"化学元素",
      u8"化学全同",
      u8"化学公司",
      u8"化学共沉淀工艺",
      u8"化学农药",
      u8"化学分子",
      u8"化学分析",
      u8"化学分析电子能电子能谱谱学",
      u8"化学剂",
      u8"化学剂注入组块",
      u8"化学剥蚀",
      u8"化学势",
      u8"化学原料",
      u8"化学反应",
      u8"化学反应产物",
      u8"化学反应式",
      u8"化学反应性",
      u8"化学反应速度",
      u8"化学发光",
      u8"化学发光免疫测定",
      u8"化学发光分析",
      u8"化学发光指示剂",
      u8"化学变化",
      u8"化学合成",
      u8"化学名",
      u8"化学品",
      u8"化学地理学",
      u8"化学堵水",
      u8"化学奖",
      u8"化学家",
      u8"化学工业",
      u8"化学工业部",
      u8"化学工厂",
      u8"化学工程",
      u8"化学平衡",
      u8"化学平衡常量",
      u8"化学建材",
      u8"化学式",
      u8"化学引诱物",
      u8"化学当量",
      u8"化学性",
      u8"化学性质",
      u8"化学感受",
      u8"化学感受器",
      u8"化学感觉",
      u8"化学成分",
      u8"化学战",
      u8"化学战争",
      u8"化学战剂",
      u8"化学抛光",
      u8"化学教案",
      u8"化学方程",
      u8"化学方程式",
      u8"化学机械抛光",
      u8"化学机理",
      u8"化学材料",
      u8"化学武器",
      u8"化学气相输运",
      u8"化学治疗",
      u8"化学活化",
      u8"化学液相淀积",
      u8"化学清蜡",
      u8"化学溶蚀",
      u8"化学物理学",
      u8"化学物质",
      u8"化学电池",
      u8"化学界",
      u8"化学示踪剂",
      u8"化学系",
      u8"化学纤维",
      u8"化学纯",
      u8"化学网",
      u8"化学肥料",
      u8"化学能",
      u8"化学脱盐",
      u8"化学药品",
      u8"化学计量浓度",
      u8"化学试剂",
      u8"化学试题",
      u8"化学诱变",
      u8"化学诱变剂",
      u8"化学课",
      u8"化学课件",
      u8"化学迁移",
      u8"化学通风橱",
      u8"化学键",
      u8"化学键合相",
      u8"化学镀",
      u8"化学防护手套",
      u8"化学防治",
      u8"化学降解",
      u8"化学题",
      u8"化学风化作用",
      u8"化害为利",
      u8"化州",
      u8"化州县",
      u8"化州市",
      u8"化工",
      u8"化工业",
      u8"化工产品",
      u8"化工企业",
      u8"化工公司",
      u8"化工厂",
      u8"化工原料",
      u8"化工填料",
      u8"化工大学",
      u8"化工学院",
      u8"化工局",
      u8"化工市场",
      u8"化工机械",
      u8"化工染料",
      u8"化工泵",
      u8"化工用品",
      u8"化工类",
      u8"化工系",
      u8"化工网",
      u8"化工行业",
      u8"化工设备",
      u8"化工部",
      u8"化工集团",
      u8"化干戈为",
      u8"化干戈为玉帛",
      u8"化开",
      u8"化形",
      u8"化德",
      u8"化德县",
      u8"化性",
      u8"化性起伪",
      u8"化悲痛为力量",
      u8"化感素",
      u8"化成",
      u8"化成灰",
      u8"化敌为友",
      u8"化整为零",
      u8"化斋",
      u8"化日光天",
      u8"化时",
      u8"化枭为鸠",
      u8"化武",
      u8"化民成俗",
      u8"化民易俗",
      u8"化氢",
      u8"化氨",
      u8"化氮",
      u8"化汞",
      u8"化油器",
      u8"化物所",
      u8"化物酶",
      u8"化生",
      u8"化生存",
      u8"化用",
      u8"化疗",
      u8"化疗剂",
      u8"化疗敏",
      u8"化痰",
      u8"化痰止咳",
      u8"化痰药",
      u8"化石",
      u8"化石林",
      u8"化石群",
      u8"化硅",
      u8"化硫",
      u8"化碘",
      u8"化碳",
      u8"化磷",
      u8"化简",
      u8"化粪池",
      u8"化繁为简",
      u8"化纤",
      u8"化纤制",
      u8"化纤厂",
      u8"化纤工业",
      u8"化纤布",
      u8"化纤面料",
      u8"化缘",
      u8"化羽",
      u8"化肥",
      u8"化肥厂",
      u8"化育",
      u8"化脓",
      u8"化脓性",
      u8"化脓性腮腺炎",
      u8"化腐为奇",
      u8"化腐成奇",
      u8"化腐朽为",
      u8"化腐朽为神奇",
      u8"化若偃草",
      u8"化药厂",
      u8"化蝶",
      u8"化蝶飞",
      u8"化被万方",
      u8"化装",
      u8"化装品",
      u8"化装室",
      u8"化装师",
      u8"化装舞会",
      u8"化解",
      u8"化解矛盾",
      u8"化费",
      u8"化身",
      u8"化身为",
      u8"化钙",
      u8"化钠",
      u8"化钡",
      u8"化钱",
      u8"化钾",
      u8"化铁",
      u8"化铁炉",
      u8"化铅",
      u8"化铋",
      u8"化铜",
      u8"化铝",
      u8"化铯",
      u8"化锂",
      u8"化锰",
      u8"化镁",
      u8"化除",
      u8"化险为夷",
      u8"化隆县",
      u8"化隆回族自治县",
      u8"化雨",
      u8"化雨春风",
      u8"化零为志",
      u8"化零为整",
      u8"化食",
      u8"化饮",
      u8"化验",
      u8"化验单",
      u8"化验员",
      u8"化验品",
      u8"化验室",
      u8"化鸱为凤",
      u8"化龙巷",
      u8"北一",
      u8"北一女",
      u8"北三环",
      u8"北三面",
      u8"北上",
      u8"北上列车",
      u8"北乡",
      u8"北二环",
      u8"北二路",
      u8"北五环",
      u8"北亚",
      u8"北交大",
      u8"北京",
      u8"北京东方",
      u8"北京中医药大学",
      u8"北京交通大学",
      u8"北京人",
      u8"北京人民广播电台",
      u8"北京公交",
      u8"北京军区",
      u8"北京分行",
      u8"北京医科大学",
      u8"北京华",
      u8"北京吉普",
      u8"北京商务印书馆",
      u8"北京商场",
      u8"北京国际图书博览会",
      u8"北京地区",
      u8"北京地铁",
      u8"北京城",
      u8"北京大",
      u8"北京大学",
      u8"北京大学出版社",
      u8"北京奥运",
      u8"北京宾馆",
      u8"北京小吃",
      u8"北京局",
      u8"北京工业大学",
      u8"北京市",
      u8"北京市区",
      u8"北京市委",
      u8"北京市新方世纪科技有限公司",
      u8"北京市民",
      u8"北京师范大学",
      u8"北京房",
      u8"北京房产",
      u8"北京旅游",
      u8"北京日报",
      u8"北京时间",
      u8"北京晚报",
      u8"北京服装",
      u8"北京机票",
      u8"北京某",
      u8"北京烤鸭",
      u8"北京犬",
      u8"北京狗",
      u8"北京猿人",
      u8"北京现代",
      u8"北京理工",
      u8"北京电视台",
      u8"北京石油",
      u8"北京站",
      u8"北京网",
      u8"北京翻译",
      u8"北京自考",
      u8"北京航天",
      u8"北京街头",
      u8"北京西",
      u8"北京西站",
      u8"北京警方",
      u8"北京话",
      u8"北京路",
      u8"北京邮电",
      u8"北京郊区",
      u8"北京酒吧",
      u8"北京铁路局",
      u8"北京青年报",
      u8"北京音乐厅",
      u8"北京高校",
      u8"北京鸭",
      u8"北京黑马",
      u8"北人",
      u8"北从",
      u8"北仑区",
      u8"北仑河口",
      u8"北仑港",
      u8"北伐",
      u8"北伐军",
      u8"北伐战争",
      u8"北体大",
      u8"北侧",
      u8"北信源",
      u8"北六环",
      u8"北关区",
      u8"北军",
      u8"北冰洋",
      u8"北凉",
      u8"北势溪",
      u8"北区",
      u8"北医",
      u8"北医大",
      u8"北半球",
      u8"北半部",
      u8"北南",
      u8"北卡罗",
      u8"北卡罗来",
      u8"北卡罗来州",
      u8"北卡罗来纳",
      u8"北卡罗来纳州",
      u8"北去",
      u8"北县",
      u8"北县人",
      u8"北叟失马",
      u8"北周",
      u8"北商",
      u8"北四环",
      u8"北回",
      u8"北回归线",
      u8"北回铁路",
      u8"北园春",
      u8"北园路",
      u8"北固山",
      u8"北国",
      u8"北国之春",
      u8"北国网",
      u8"北国风光",
      u8"北图",
      u8"北地",
      u8"北城",
      u8"北埔",
      u8"北塔区",
      u8"北塘区",
      u8"北外",
      u8"北外滩",
      u8"北大",
      u8"北大中文论坛",
      u8"北大仓",
      u8"北大学生",
      u8"北大清华",
      u8"北大荒",
      u8"北大营",
      u8"北大街",
      u8"北大西洋",
      u8"北大西洋公约组织",
      u8"北大附中",
      u8"北太平",
      u8"北太平庄",
      u8"北头",
      u8"北妹",
      u8"北姑",
      u8"北威州",
      u8"北宁",
      u8"北宁市",
      u8"北宁铁路",
      u8"北安",
      u8"北安市",
      u8"北安路",
      u8"北宋",
      u8"北宜",
      u8"北宜公路",
      u8"北宜高速公路",
      u8"北宫婴儿",
      u8"北寒带",
      u8"北屯",
      u8"北山",
      u8"北山酒精",
      u8"北山酒经",
      u8"北岛",
      u8"北岳",
      u8"北岳区",
      u8"北岸",
      u8"北川",
      u8"北川县",
      u8"北川羌族自治县",
      u8"北工大",
      u8"北市",
      u8"北市人",
      u8"北市区",
      u8"北市商",
      u8"北师",
      u8"北师专",
      u8"北师大",
      u8"北平",
      u8"北平人",
      u8"北平市",
      u8"北平话",
      u8"北广场",
      u8"北彊",
      u8"北影",
      u8"北影厂",
      u8"北戴河",
      u8"北戴河区",
      u8"北房",
      u8"北投",
      u8"北投区",
      u8"北援",
      u8"北支",
      u8"北教场",
      u8"北斗",
      u8"北斗七星",
      u8"北斗之尊",
      u8"北斗星",
      u8"北斗神拳",
      u8"北新",
      u8"北新桥",
      u8"北方",
      u8"北方交大",
      u8"北方交通",
      u8"北方人",
      u8"北方四岛",
      u8"北方地区",
      u8"北方工业",
      u8"北方方言",
      u8"北方网",
      u8"北方话",
      u8"北方邦",
      u8"北方领土",
      u8"北普陀",
      u8"北曲",
      u8"北朝",
      u8"北朝南",
      u8"北朝鲜",
      u8"北杜味拿",
      u8"北杜味拿河",
      u8"北条司",
      u8"北来",
      u8"北极",
      u8"北极光",
      u8"北极冰",
      u8"北极区",
      u8"北极圈",
      u8"北极带",
      u8"北极星",
      u8"北极村",
      u8"北极洲",
      u8"北极海",
      u8"北极点",
      u8"北极熊",
      u8"北极狐",
      u8"北极雪",
      u8"北林区",
      u8"北校区",
      u8"北楼",
      u8"北横",
      u8"北横公路",
      u8"北欧",
      u8"北欧国家",
      u8"北段",
      u8"北汉",
      u8"北江",
      u8"北江区",
      u8"北江里",
      u8"北汽",
      u8"北沙参",
      u8"北河",
      u8"北河乡",
      u8"北注协",
      u8"北洋",
      u8"北洋军",
      u8"北洋军阀",
      u8"北洋大学",
      u8"北洋武备",
      u8"北洋武备学堂",
      u8"北流",
      u8"北流市",
      u8"北海",
      u8"北海岸",
      u8"北海市",
      u8"北海旅游",
      u8"北海港",
      u8"北海道",
      u8"北海道人",
      u8"北温带",
      u8"北港",
      u8"北港人",
      u8"北港溪",
      u8"北港镇",
      u8"北湖",
      u8"北湖区",
      u8"北滨",
      u8"北滨公路",
      u8"北爱",
      u8"北爱党",
      u8"北爱尔兰",
      u8"北爱尔兰省",
      u8"北环路",
      u8"北理工",
      u8"北瓜",
      u8"北电",
      u8"北界城",
      u8"北疆",
      u8"北碚区",
      u8"北票",
      u8"北票市",
      u8"北科大",
      u8"北空",
      u8"北窗高卧",
      u8"北站",
      u8"北端",
      u8"北竿",
      u8"北竿岛",
      u8"北约",
      u8"北约组织",
      u8"北纬",
      u8"北纬度",
      u8"北线",
      u8"北缘",
      u8"北美",
      u8"北美华人",
      u8"北美洲",
      u8"北美版",
      u8"北美票房",
      u8"北能",
      u8"北至",
      u8"北航",
      u8"北苑",
      u8"北苑路",
      u8"北街",
      u8"北角",
      u8"北豆根",
      u8"北货",
      u8"北赤道洋",
      u8"北赤道洋流",
      u8"北起",
      u8"北越",
      u8"北越军",
      u8"北路",
      u8"北路甲",
      u8"北辕适楚",
      u8"北辕适粤",
      u8"北辙南辕",
      u8"北辰",
      u8"北辰区",
      u8"北辰星拱",
      u8"北边",
      u8"北达科他",
      u8"北达科他州",
      u8"北运河",
      u8"北道主人",
      u8"北道区",
      u8"北郊",
      u8"北部",
      u8"北部地区",
      u8"北部湾",
      u8"北郭先生",
      u8"北鄙之声",
      u8"北鄙之音",
      u8"北里",
      u8"北野武",
      u8"北钢",
      u8"北镇",
      u8"北镇县",
      u8"北门",
      u8"北门一带",
      u8"北门之寄",
      u8"北门之管",
      u8"北门南牙",
      u8"北门管钥",
      u8"北门锁钥",
      u8"北陵",
      u8"北青报",
      u8"北青网",
      u8"北非",
      u8"北非国家",
      u8"北面",
      u8"北面称臣",
      u8"北韩",
      u8"北风",
      u8"北风之恋",
      u8"北风吹",
      u8"北马里亚纳群岛",
      u8"北高加索",
      u8"北魏",
      u8"北麓",
      u8"北齐",
      u8"北齐书",
      u8"北龙",
      u8"匙子",
      u8"匝地",
      u8"匝数",
      u8"匝月",
      u8"匝道",
      u8"匟床",
      u8"匠人",
      u8"匠心",
      u8"匠心独具",
      u8"匠心独妙",
      u8"匠心独运",
      u8"匠气",
      u8"匠石运金",
      u8"匠门弃材",
      u8"匡乱反正",
      u8"匡俗济时",
      u8"匡其不逮",
      u8"匡助",
      u8"匡国济时",
      u8"匡复",
      u8"匡扶",
      u8"匡救",
      u8"匡救弥缝",
      u8"匡时济世",
      u8"匡时济俗",
      u8"匡正",
      u8"匡济",
      u8"匡算",
      u8"匡红艳",
      u8"匡衡凿壁",
      u8"匡谬",
      u8"匡谬正俗",
      u8"匡鼎解颐",
      u8"匣剑帷灯",
      u8"匣子",
      u8"匣子枪",
      u8"匣式",
      u8"匣里龙吟",
      u8"匣钵",
      u8"匪人",
      u8"匪伊朝夕",
      u8"匪伪",
      u8"匪党",
      u8"匪共",
      u8"匪兵",
      u8"匪军",
      u8"匪匪翼翼",
      u8"匪区",
      u8"匪史",
      u8"匪夷匪惠",
      u8"匪夷所思",
      u8"匪巢",
      u8"匪帮",
      u8"匪干",
      u8"匪徒",
      u8"匪患",
      u8"匪情",
      u8"匪懈",
      u8"匪方",
      u8"匪朝伊夕",
      u8"匪特",
      u8"匪盗",
      u8"匪石之心",
      u8"匪石匪席",
      u8"匪祸",
      u8"匪穴",
      u8"匪窝",
      u8"匪窟",
      u8"匪类",
      u8"匪话",
      u8"匪谍",
      u8"匪货",
      u8"匪躬之节",
      u8"匪酋",
      u8"匪里匪气",
      u8"匪首",
      u8"匮乏",
      u8"匮竭",
      u8"匮缺",
      u8"匹亚",
      u8"匹兹堡",
      u8"匹兹堡交响乐团",
      u8"匹夫",
      u8"匹夫不可夺志",
      u8"匹夫之勇",
      u8"匹夫之谅",
      u8"匹夫匹妇",
      u8"匹夫小谅",
      u8"匹夫怀璧",
      u8"匹夫无罪",
      u8"匹夫无罪怀璧其罪",
      u8"匹夫有责",
      u8"匹夫沟渎",
      u8"匹妇沟渠",
      u8"匹带",
      u8"匹敌",
      u8"匹练",
      u8"匹萨",
      u8"匹萨饼",
      u8"匹配",
      u8"匹配段",
      u8"匹配滤波器",
      u8"匹配组设计",
      u8"匹配终端",
      u8"匹马一麾",
      u8"匹马单枪",
      u8"匹马只轮",
      u8"匹马当先",
      u8"区乡",
      u8"区书",
      u8"区产",
      u8"区位",
      u8"区位三角形",
      u8"区位商",
      u8"区位因子",
      u8"区位理论",
      u8"区位码",
      u8"区位系数",
      u8"区位记录",
      u8"区党委",
      u8"区公所",
      u8"区内",
      u8"区内外",
      u8"区凯玲",
      u8"区分",
      u8"区分值",
      u8"区分序列",
      u8"区分效度",
      u8"区分法",
      u8"区分符",
      u8"区分能力倾向测验",
      u8"区划",
      u8"区划图",
      u8"区别",
      u8"区别不同情况",
      u8"区别对待",
      u8"区别性",
      u8"区别情况",
      u8"区别词",
      u8"区别轻重缓急",
      u8"区区",
      u8"区区之众",
      u8"区区小事",
      u8"区区此心",
      u8"区县",
      u8"区号",
      u8"区块",
      u8"区域",
      u8"区域专一性",
      u8"区域代理",
      u8"区域估计",
      u8"区域内",
      u8"区域分异",
      u8"区域分析",
      u8"区域化",
      u8"区域历史地理",
      u8"区域合作",
      u8"区域地图集",
      u8"区域地理学",
      u8"区域地震地层学",
      u8"区域场校正",
      u8"区域开发",
      u8"区域性",
      u8"区域性脑血流",
      u8"区域描述",
      u8"区域气候",
      u8"区域环境",
      u8"区域科学",
      u8"区域系统",
      u8"区域经济",
      u8"区域经济地理学",
      u8"区域经济学",
      u8"区域经理",
      u8"区域规划",
      u8"区域评价",
      u8"区域试验",
      u8"区域间",
      u8"区外",
      u8"区委",
      u8"区委书记",
      u8"区宇一清",
      u8"区局",
      u8"区属",
      u8"区市",
      u8"区庄",
      u8"区情",
      u8"区政",
      u8"区政府",
      u8"区旗",
      u8"区星",
      u8"区有",
      u8"区标",
      u8"区楚良",
      u8"区段",
      u8"区法院",
      u8"区淑贞",
      u8"区瑞强",
      u8"区直",
      u8"区码",
      u8"区级",
      u8"区运",
      u8"区运会",
      u8"区里",
      u8"区长",
      u8"区间",
      u8"区间车",
      u8"区闻陬见",
      u8"区际",
      u8"区院",
      u8"区隔",
      u8"医不好",
      u8"医书",
      u8"医事",
      u8"医事职业",
      u8"医事职业学校",
      u8"医保",
      u8"医保卡",
      u8"医典",
      u8"医务",
      u8"医务人员",
      u8"医务兵",
      u8"医务室",
      u8"医务工作者",
      u8"医务所",
      u8"医务部主任",
      u8"医卫界",
      u8"医卫组",
      u8"医嘱",
      u8"医圣",
      u8"医坛",
      u8"医士",
      u8"医大",
      u8"医好",
      u8"医学",
      u8"医学上",
      u8"医学专业",
      u8"医学专家",
      u8"医学中心",
      u8"医学书店",
      u8"医学书籍",
      u8"医学会",
      u8"医学博士",
      u8"医学史",
      u8"医学地理学",
      u8"医学士",
      u8"医学奖",
      u8"医学家",
      u8"医学工程",
      u8"医学影像",
      u8"医学心理学",
      u8"医学教育",
      u8"医学整形",
      u8"医学期刊",
      u8"医学杂志",
      u8"医学生",
      u8"医学界",
      u8"医学知识",
      u8"医学类",
      u8"医学系",
      u8"医学纲目",
      u8"医学网",
      u8"医学美容",
      u8"医学衷中参西录",
      u8"医学观察",
      u8"医学论坛",
      u8"医学论文",
      u8"医学部",
      u8"医学院",
      u8"医学院校",
      u8"医宗金鉴",
      u8"医官",
      u8"医家",
      u8"医师",
      u8"医师公会",
      u8"医师法",
      u8"医师资格",
      u8"医德",
      u8"医心无悔",
      u8"医患",
      u8"医技",
      u8"医护",
      u8"医护人员",
      u8"医护兵",
      u8"医方",
      u8"医时救弊",
      u8"医术",
      u8"医林改错",
      u8"医案",
      u8"医治",
      u8"医治创伤",
      u8"医治无效",
      u8"医源性",
      u8"医王",
      u8"医理",
      u8"医生",
      u8"医用",
      u8"医界",
      u8"医疗",
      u8"医疗事故",
      u8"医疗保健",
      u8"医疗保险",
      u8"医疗保障",
      u8"医疗卫生",
      u8"医疗器械",
      u8"医疗广告",
      u8"医疗所",
      u8"医疗期",
      u8"医疗机构",
      u8"医疗用具",
      u8"医疗界",
      u8"医疗站",
      u8"医疗系统",
      u8"医疗纠纷",
      u8"医疗网",
      u8"医疗费",
      u8"医疗队",
      u8"医疗险",
      u8"医病",
      u8"医科",
      u8"医科大",
      u8"医科大学",
      u8"医科院",
      u8"医管局",
      u8"医者",
      u8"医药",
      u8"医药产业",
      u8"医药代理",
      u8"医药企业",
      u8"医药保健",
      u8"医药公司",
      u8"医药包装",
      u8"医药卫生",
      u8"医药原料",
      u8"医药品",
      u8"医药学",
      u8"医药工业",
      u8"医药瓶",
      u8"医药管理局",
      u8"医药箱",
      u8"医药网",
      u8"医药罔效",
      u8"医药行业",
      u8"医药费",
      u8"医药集团",
      u8"医葯",
      u8"医述",
      u8"医道",
      u8"医道高明",
      u8"医错",
      u8"医院",
      u8"医院地址",
      u8"医院船",
      u8"医院软件",
      u8"医院院长",
      u8"医风",
      u8"医馆",
      u8"医马论典",
      u8"医魂",
      u8"匾文",
      u8"匾牌",
      u8"匾额",
      u8"匿伏",
      u8"匿名",
      u8"匿名下载",
      u8"匿名举报",
      u8"匿名信",
      u8"匿名服务器",
      u8"匿名登录",
      u8"匿名账号",
      u8"匿影藏形",
      u8"匿情",
      u8"匿户",
      u8"匿报",
      u8"匿料",
      u8"匿瑕含垢",
      u8"匿藏",
      u8"匿迹",
      u8"匿迹消声",
      u8"匿迹潜形",
      u8"匿迹销声",
      u8"匿迹隐形",
      u8"十一",
      u8"十一万",
      u8"十一个",
      u8"十一中",
      u8"十一五",
      u8"十一人",
      u8"十一元",
      u8"十一分",
      u8"十一号",
      u8"十一国庆节",
      u8"十一块",
      u8"十一大",
      u8"十一天",
      u8"十一届",
      u8"十一届三中全会",
      u8"十一岁",
      u8"十一年",
      u8"十一日",
      u8"十一时",
      u8"十一月",
      u8"十一月份",
      u8"十一楼",
      u8"十一点",
      u8"十一郎",
      u8"十七",
      u8"十七世纪",
      u8"十七个",
      u8"十七中",
      u8"十七人",
      u8"十七元",
      u8"十七冶",
      u8"十七分",
      u8"十七号",
      u8"十七块",
      u8"十七天",
      u8"十七岁",
      u8"十七日",
      u8"十七时",
      u8"十七章",
      u8"十七路军",
      u8"十万",
      u8"十万个",
      u8"十万人",
      u8"十万元",
      u8"十万八千里",
      u8"十万分",
      u8"十万块",
      u8"十万火急",
      u8"十万火速",
      u8"十丈",
      u8"十三",
      u8"十三个",
      u8"十三中",
      u8"十三人",
      u8"十三元",
      u8"十三分",
      u8"十三号",
      u8"十三块",
      u8"十三大",
      u8"十三天",
      u8"十三太保",
      u8"十三姨",
      u8"十三岁",
      u8"十三幺",
      u8"十三日",
      u8"十三时",
      u8"十三点",
      u8"十三经",
      u8"十三辙",
      u8"十三陵",
      u8"十下",
      u8"十不当一",
      u8"十不得一",
      u8"十不闲儿",
      u8"十世单传",
      u8"十世纪",
      u8"十两",
      u8"十个",
      u8"十个人",
      u8"十个月",
      u8"十中",
      u8"十中全会",
      u8"十串",
      u8"十之八九",
      u8"十九",
      u8"十九世纪",
      u8"十九个",
      u8"十九中",
      u8"十九人",
      u8"十九元",
      u8"十九分",
      u8"十九号",
      u8"十九块",
      u8"十九天",
      u8"十九岁",
      u8"十九年",
      u8"十九日",
      u8"十九时",
      u8"十九楼",
      u8"十二",
      u8"十二万分",
      u8"十二个",
      u8"十二中",
      u8"十二人",
      u8"十二元",
      u8"十二分",
      u8"十二卷",
      u8"十二号",
      u8"十二块",
      u8"十二大",
      u8"十二天",
      u8"十二宫",
      u8"十二属",
      u8"十二属相",
      u8"十二岁",
      u8"十二平均",
      u8"十二年",
      u8"十二律",
      u8"十二指肠",
      u8"十二日",
      u8"十二时",
      u8"十二月",
      u8"十二月份",
      u8"十二楼",
      u8"十二点",
      u8"十二生肖",
      u8"十二用",
      u8"十二皮部",
      u8"十二码球",
      u8"十二章",
      u8"十二经别",
      u8"十二经筋",
      u8"十二经脉",
      u8"十二金牌",
      u8"十二金钗",
      u8"十二钗",
      u8"十五",
      u8"十五世纪",
      u8"十五个",
      u8"十五中",
      u8"十五人",
      u8"十五元",
      u8"十五分",
      u8"十五号",
      u8"十五块",
      u8"十五大",
      u8"十五大精神",
      u8"十五天",
      u8"十五小",
      u8"十五届",
      u8"十五岁",
      u8"十五年",
      u8"十五日",
      u8"十五时",
      u8"十五章",
      u8"十五络",
      u8"十亲九故",
      u8"十亲九眷",
      u8"十人",
      u8"十人九慕",
      u8"十人份",
      u8"十亿",
      u8"十付",
      u8"十代",
      u8"十令",
      u8"十件",
      u8"十件事",
      u8"十任",
      u8"十份",
      u8"十传百",
      u8"十位",
      u8"十位数",
      u8"十佳",
      u8"十佳评选",
      u8"十信",
      u8"十倍",
      u8"十元",
      u8"十兆",
      u8"十光五色",
      u8"十克",
      u8"十克拉",
      u8"十全",
      u8"十全十美",
      u8"十全大补",
      u8"十全街",
      u8"十八",
      u8"十八世纪",
      u8"十八个",
      u8"十八中",
      u8"十八人",
      u8"十八元",
      u8"十八分",
      u8"十八变",
      u8"十八号",
      u8"十八块",
      u8"十八天",
      u8"十八姑娘",
      u8"十八姑娘一朵花",
      u8"十八层地",
      u8"十八层地狱",
      u8"十八岁",
      u8"十八式",
      u8"十八弯",
      u8"十八怪",
      u8"十八掌",
      u8"十八摸",
      u8"十八斗",
      u8"十八日",
      u8"十八时",
      u8"十八款",
      u8"十八盘",
      u8"十八相送",
      u8"十八禁",
      u8"十八罗汉",
      u8"十八般",
      u8"十八般兵器",
      u8"十八般武艺",
      u8"十公克",
      u8"十公分",
      u8"十公升",
      u8"十公尺",
      u8"十公斤",
      u8"十公里",
      u8"十六",
      u8"十六世纪",
      u8"十六个",
      u8"十六中",
      u8"十六人",
      u8"十六位",
      u8"十六元",
      u8"十六分",
      u8"十六分音",
      u8"十六号",
      u8"十六和弦",
      u8"十六块",
      u8"十六大",
      u8"十六天",
      u8"十六字诀",
      u8"十六岁",
      u8"十六开",
      u8"十六强",
      u8"十六日",
      u8"十六时",
      u8"十六烷值",
      u8"十六种人格因素问卷",
      u8"十六进位",
      u8"十六进制",
      u8"十关",
      u8"十具",
      u8"十册",
      u8"十军",
      u8"十冬腊月",
      u8"十几",
      u8"十几个",
      u8"十几人",
      u8"十几元",
      u8"十几分",
      u8"十几号",
      u8"十几块",
      u8"十几天",
      u8"十几岁",
      u8"十几年",
      u8"十几年来",
      u8"十几次",
      u8"十出",
      u8"十出戏",
      u8"十分",
      u8"十分之",
      u8"十分之一",
      u8"十分关心",
      u8"十分困难",
      u8"十分复杂",
      u8"十分多谢",
      u8"十分宝贵",
      u8"十分寮",
      u8"十分必要",
      u8"十分想念",
      u8"十分明确",
      u8"十分注意",
      u8"十分满意",
      u8"十分激烈",
      u8"十分爱",
      u8"十分相似",
      u8"十分艰巨",
      u8"十分迅速",
      u8"十分重要",
      u8"十分重视",
      u8"十分钟",
      u8"十分高兴",
      u8"十划",
      u8"十则",
      u8"十副",
      u8"十加仑",
      u8"十包",
      u8"十包装",
      u8"十匙",
      u8"十区",
      u8"十十五五",
      u8"十升",
      u8"十卷",
      u8"十发",
      u8"十发十中",
      u8"十变五化",
      u8"十口",
      u8"十口相传",
      u8"十句",
      u8"十句话",
      u8"十只",
      u8"十台",
      u8"十叶",
      u8"十号",
      u8"十名",
      u8"十员",
      u8"十周",
      u8"十周年",
      u8"十四",
      u8"十四个",
      u8"十四中",
      u8"十四人",
      u8"十四元",
      u8"十四分",
      u8"十四号",
      u8"十四块",
      u8"十四大",
      u8"十四天",
      u8"十四届",
      u8"十四岁",
      u8"十四日",
      u8"十四时",
      u8"十四行",
      u8"十四行诗",
      u8"十回",
      u8"十团",
      u8"十围五攻",
      u8"十国",
      u8"十国集团",
      u8"十圆",
      u8"十圈",
      u8"十场",
      u8"十块",
      u8"十块钱",
      u8"十坪",
      u8"十堂",
      u8"十堂课",
      u8"十堰",
      u8"十堰信息港",
      u8"十堰大学",
      u8"十堰市",
      u8"十堰广电报",
      u8"十堰教育信息网",
      u8"十堰电信",
      u8"十堰电话",
      u8"十堰网盟",
      u8"十处",
      u8"十多",
      u8"十多个",
      u8"十多人",
      u8"十多元",
      u8"十多分",
      u8"十多号",
      u8"十多块",
      u8"十多天",
      u8"十多岁",
      u8"十多年",
      u8"十多次",
      u8"十夜",
      u8"十大",
      u8"十大元帅",
      u8"十大功劳叶",
      u8"十大块",
      u8"十大建设",
      u8"十大类",
      u8"十天",
      u8"十天份",
      u8"十夫桡椎",
      u8"十夫楺椎",
      u8"十头",
      u8"十奖",
      u8"十妹",
      u8"十姊妹",
      u8"十字",
      u8"十字军",
      u8"十字军东",
      u8"十字头",
      u8"十字形",
      u8"十字排列装置",
      u8"十字支撑",
      u8"十字星",
      u8"十字架",
      u8"十字架形",
      u8"十字线",
      u8"十字绣",
      u8"十字花",
      u8"十字花科",
      u8"十字街",
      u8"十字街口",
      u8"十字街头",
      u8"十字路",
      u8"十字路口",
      u8"十字路口党",
      u8"十字路头",
      u8"十字键",
      u8"十字镐",
      u8"十客",
      u8"十宣",
      u8"十室九匮",
      u8"十室九空",
      u8"十室容贤",
      u8"十家",
      u8"十寒一暴",
      u8"十封",
      u8"十封信",
      u8"十小时",
      u8"十尺",
      u8"十局",
      u8"十层",
      u8"十层楼",
      u8"十届",
      u8"十岁",
      u8"十岁时",
      u8"十巷",
      u8"十帧",
      u8"十常八九",
      u8"十幅",
      u8"十幢",
      u8"十平方",
      u8"十年",
      u8"十年一剑",
      u8"十年九不遇",
      u8"十年九旱",
      u8"十年代",
      u8"十年内乱",
      u8"十年前",
      u8"十年动乱",
      u8"十年后",
      u8"十年如一日",
      u8"十年寒窗",
      u8"十年怕井绳",
      u8"十年教训",
      u8"十年树木",
      u8"十年树木百年树人",
      u8"十年树木，百年树人",
      u8"十年浩劫",
      u8"十年生聚",
      u8"十年生聚十年教训",
      u8"十年磨一剑",
      u8"十年磨剑",
      u8"十年窗下",
      u8"十年规划",
      u8"十年读书",
      u8"十年间",
      u8"十年难得一见",
      u8"十床",
      u8"十度",
      u8"十座",
      u8"十张",
      u8"十强",
      u8"十强县",
      u8"十强赛",
      u8"十恶",
      u8"十恶不赦",
      u8"十恶五逆",
      u8"十成",
      u8"十成九稳",
      u8"十成把握",
      u8"十戒",
      u8"十战十胜",
      u8"十手争指",
      u8"十手所指",
      u8"十打",
      u8"十拏九稳",
      u8"十拳",
      u8"十拷九棒",
      u8"十拿九稳",
      u8"十指",
      u8"十指关",
      u8"十指如椎",
      u8"十指有长短",
      u8"十指连心",
      u8"十捉九着",
      u8"十排",
      u8"十支",
      u8"十斤",
      u8"十方",
      u8"十日",
      u8"十日一水",
      u8"十日一水五日一石",
      u8"十日之饮",
      u8"十日份",
      u8"十日并出",
      u8"十日游",
      u8"十日谈",
      u8"十时",
      u8"十星期",
      u8"十星级",
      u8"十晚",
      u8"十景",
      u8"十曲",
      u8"十月",
      u8"十月一",
      u8"十月份",
      u8"十月十日",
      u8"十月革命",
      u8"十月革命节",
      u8"十有八九",
      u8"十期",
      u8"十朵",
      u8"十朵花",
      u8"十束",
      u8"十条",
      u8"十来",
      u8"十来个",
      u8"十来分",
      u8"十来天",
      u8"十杯",
      u8"十杯水",
      u8"十杯酒",
      u8"十枚",
      u8"十枝",
      u8"十枪",
      u8"十架",
      u8"十栋",
      u8"十株",
      u8"十样",
      u8"十样锦",
      u8"十格",
      u8"十框",
      u8"十档",
      u8"十桶",
      u8"十棵",
      u8"十楼",
      u8"十次",
      u8"十次革命",
      u8"十步",
      u8"十步之内",
      u8"十步芳草",
      u8"十步香草",
      u8"十步香车",
      u8"十死一生",
      u8"十死不问",
      u8"十死九活",
      u8"十段",
      u8"十段变速",
      u8"十泡",
      u8"十洞",
      u8"十派",
      u8"十浆五馈",
      u8"十渡",
      u8"十滴",
      u8"十滴水",
      u8"十炮",
      u8"十点",
      u8"十点钟",
      u8"十爷",
      u8"十片",
      u8"十片装",
      u8"十版",
      u8"十班",
      u8"十瓶",
      u8"十瓶装",
      u8"十瓶酒",
      u8"十生九死",
      u8"十甲",
      u8"十男",
      u8"十番乐",
      u8"十番锣鼓",
      u8"十病九痛",
      u8"十盏",
      u8"十盒",
      u8"十目所视",
      u8"十目所视十手所指",
      u8"十眠九坐",
      u8"十碗",
      u8"十种",
      u8"十科",
      u8"十秒",
      u8"十秒钟",
      u8"十立方",
      u8"十站",
      u8"十章",
      u8"十筐",
      u8"十筒",
      u8"十箱",
      u8"十篇",
      u8"十米",
      u8"十米九糠",
      u8"十类",
      u8"十粒",
      u8"十级",
      u8"十线",
      u8"十组",
      u8"十罐",
      u8"十羊九牧",
      u8"十美图",
      u8"十股",
      u8"十船",
      u8"十色",
      u8"十节",
      u8"十节课",
      u8"十营",
      u8"十行",
      u8"十行俱下",
      u8"十行字",
      u8"十行纸",
      u8"十街",
      u8"十袋",
      u8"十角",
      u8"十角形",
      u8"十诫",
      u8"十课",
      u8"十赌九骗",
      u8"十起",
      u8"十趟",
      u8"十足",
      u8"十足把握",
      u8"十足虫",
      u8"十路",
      u8"十车",
      u8"十转九空",
      u8"十轮",
      u8"十载",
      u8"十载寒窗",
      u8"十辆",
      u8"十辆车",
      u8"十边",
      u8"十边形",
      u8"十运会",
      u8"十进位",
      u8"十进位制",
      u8"十进位码",
      u8"十进值",
      u8"十进制",
      u8"十进制数字",
      u8"十进法",
      u8"十进管",
      u8"十连",
      u8"十连技",
      u8"十通",
      u8"十遍",
      u8"十道",
      u8"十道菜",
      u8"十邻",
      u8"十部",
      u8"十里",
      u8"十里堡",
      u8"十里洋场",
      u8"十里铺",
      u8"十里长亭",
      u8"十里香",
      u8"十重",
      u8"十针",
      u8"十钱",
      u8"十锅",
      u8"十间",
      u8"十集",
      u8"十雨五风",
      u8"十面",
      u8"十面体",
      u8"十面埋伏",
      u8"十页",
      u8"十顶",
      u8"十项",
      u8"十项全能",
      u8"十项运动",
      u8"十颗",
      u8"十题",
      u8"十风五雨",
      u8"十首",
      u8"十首歌",
      u8"十魔九难",
      u8"十鼠同穴",
      u8"千万",
      u8"千万买邻",
      u8"千万元",
      u8"千万别",
      u8"千万富翁",
      u8"千丈",
      u8"千不该",
      u8"千与千寻",
      u8"千世修来共枕眠",
      u8"千丝万缕",
      u8"千个",
      u8"千乘万骑",
      u8"千了万当",
      u8"千了百了",
      u8"千了百当",
      u8"千亩",
      u8"千人",
      u8"千人一面",
      u8"千人在线",
      u8"千人所指",
      u8"千亿",
      u8"千仇万恨",
      u8"千仓万箱",
      u8"千仞无枝",
      u8"千伏",
      u8"千伏安",
      u8"千伶百俐",
      u8"千余",
      u8"千余元",
      u8"千佛山",
      u8"千佛洞",
      u8"千依万顺",
      u8"千依百顺",
      u8"千倍",
      u8"千儿八百",
      u8"千元",
      u8"千元级",
      u8"千兆",
      u8"千克",
      u8"千兵万马",
      u8"千军万马",
      u8"千军易得一将难求",
      u8"千刀万剁",
      u8"千刀万剐",
      u8"千分",
      u8"千分之",
      u8"千分之一",
      u8"千分制",
      u8"千分号",
      u8"千分尺",
      u8"千分数",
      u8"千分率",
      u8"千分表",
      u8"千千",
      u8"千千万",
      u8"千千万万",
      u8"千千结",
      u8"千千阙歌",
      u8"千升",
      u8"千卡",
      u8"千变万化",
      u8"千变万状",
      u8"千变万轸",
      u8"千古",
      u8"千古一律",
      u8"千古一时",
      u8"千古一辙",
      u8"千古不变",
      u8"千古不朽",
      u8"千古不灭",
      u8"千古不磨",
      u8"千古不解之谜",
      u8"千古兴亡",
      u8"千古奇闻",
      u8"千古独步",
      u8"千古绝唱",
      u8"千古绝调",
      u8"千古罪人",
      u8"千古遗恨",
      u8"千古风范",
      u8"千古骂名",
      u8"千叮万嘱",
      u8"千吨",
      u8"千吨当量",
      u8"千周",
      u8"千呼万唤",
      u8"千回万转",
      u8"千回百折",
      u8"千回百转",
      u8"千多元",
      u8"千夫",
      u8"千夫所指",
      u8"千夫指",
      u8"千夫诺诺不如一士谔谔",
      u8"千头万序",
      u8"千头万绪",
      u8"千奇百怪",
      u8"千姿万态",
      u8"千姿百态",
      u8"千娇百媚",
      u8"千孔百疮",
      u8"千字",
      u8"千字文",
      u8"千宗易",
      u8"千家",
      u8"千家万户",
      u8"千家峒",
      u8"千家诗",
      u8"千寻",
      u8"千层浪",
      u8"千居里",
      u8"千山万壑",
      u8"千山万水",
      u8"千山区",
      u8"千岁",
      u8"千岁一时",
      u8"千岁爷",
      u8"千岁鹤归",
      u8"千岛湖",
      u8"千岛群岛",
      u8"千岩万壑",
      u8"千岩竞秀",
      u8"千峰万壑",
      u8"千峰百嶂",
      u8"千差万别",
      u8"千差万错",
      u8"千帆竞发",
      u8"千年",
      u8"千年一律",
      u8"千年健",
      u8"千年怪兽",
      u8"千年泪",
      u8"千年湖",
      u8"千年等一回",
      u8"千年老二",
      u8"千年虫",
      u8"千度",
      u8"千张",
      u8"千形万状",
      u8"千态万状",
      u8"千思万想",
      u8"千思万虑",
      u8"千恩万谢",
      u8"千惠子",
      u8"千愁",
      u8"千愁万恨",
      u8"千愁万绪",
      u8"千户",
      u8"千户所",
      u8"千手堂",
      u8"千推万阻",
      u8"千斤",
      u8"千斤重担",
      u8"千斤顶",
      u8"千方万计",
      u8"千方百计",
      u8"千日",
      u8"千日打柴一日烧",
      u8"千日斫柴一日烧",
      u8"千日红",
      u8"千明勋",
      u8"千机变",
      u8"千村万户",
      u8"千村万落",
      u8"千条",
      u8"千条万端",
      u8"千条万绪",
      u8"千条万缕",
      u8"千杯",
      u8"千杯万盏",
      u8"千杯不醉",
      u8"千枚岩",
      u8"千棰打锣一棰定声",
      u8"千次",
      u8"千步",
      u8"千水万山",
      u8"千汇万状",
      u8"千沟万壑",
      u8"千灾百难",
      u8"千状万态",
      u8"千状万端",
      u8"千王之王",
      u8"千瓦",
      u8"千瓦小时",
      u8"千瓦时",
      u8"千生万劫",
      u8"千生万死",
      u8"千疮百孔",
      u8"千疮百痍",
      u8"千百",
      u8"千百万",
      u8"千百回",
      u8"千百年",
      u8"千百年来",
      u8"千百种",
      u8"千盏菊",
      u8"千真万真",
      u8"千真万确",
      u8"千磨百折",
      u8"千禧",
      u8"千禧年",
      u8"千禧新歌榜",
      u8"千禧条",
      u8"千禧龙",
      u8"千秋",
      u8"千秋万世",
      u8"千秋万事",
      u8"千秋万代",
      u8"千秋万古",
      u8"千秋万岁",
      u8"千秋人物",
      u8"千秋伟业",
      u8"千秋功罪",
      u8"千秋功过",
      u8"千秋大业",
      u8"千秋永垂",
      u8"千秋雪",
      u8"千穗谷",
      u8"千立方米",
      u8"千章万句",
      u8"千端万绪",
      u8"千篇一律",
      u8"千米",
      u8"千粒重",
      u8"千红万紫",
      u8"千纸鹤",
      u8"千绪万端",
      u8"千羊之皮不如一狐之腋",
      u8"千虑一失",
      u8"千虑一得",
      u8"千行",
      u8"千补百衲",
      u8"千言",
      u8"千言万语",
      u8"千言万说",
      u8"千语万言",
      u8"千赫",
      u8"千载",
      u8"千载一会",
      u8"千载一合",
      u8"千载一圣",
      u8"千载一弹",
      u8"千载一日",
      u8"千载一时",
      u8"千载一逢",
      u8"千载一遇",
      u8"千载不变",
      u8"千载奇遇",
      u8"千载难逢",
      u8"千载难遇",
      u8"千辛万苦",
      u8"千部一腔",
      u8"千部一腔千人一面",
      u8"千里",
      u8"千里一曲",
      u8"千里不同风",
      u8"千里不同风百里不同俗",
      u8"千里之任",
      u8"千里之堤",
      u8"千里之堤毁于蚁穴",
      u8"千里之堤溃于蚁穴",
      u8"千里之志",
      u8"千里之行",
      u8"千里之行始于足下",
      u8"千里之足",
      u8"千里光",
      u8"千里冰封",
      u8"千里同风",
      u8"千里命驾",
      u8"千里始于足下",
      u8"千里姻缘一线牵",
      u8"千里姻缘使线牵",
      u8"千里寄鹅毛",
      u8"千里无烟",
      u8"千里犹面",
      u8"千里目",
      u8"千里眼",
      u8"千里神交",
      u8"千里结言",
      u8"千里花",
      u8"千里莼羹",
      u8"千里走单骑",
      u8"千里路",
      u8"千里达",
      u8"千里迢迢",
      u8"千里送鹅毛",
      u8"千里镜",
      u8"千里餽粮士有饥色",
      u8"千里香",
      u8"千里马",
      u8"千里驹",
      u8"千里骏骨",
      u8"千里鹅毛",
      u8"千野",
      u8"千金",
      u8"千金一刻",
      u8"千金一壸",
      u8"千金一掷",
      u8"千金一瓠",
      u8"千金一笑",
      u8"千金一诺",
      u8"千金之子",
      u8"千金之家",
      u8"千金之裘非一狐之腋",
      u8"千金之躯",
      u8"千金买笑",
      u8"千金子",
      u8"千金子藤",
      u8"千金小姐",
      u8"千金市骨",
      u8"千金弊帚",
      u8"千金敝帚",
      u8"千金散尽还复来",
      u8"千金方",
      u8"千金用兵百金求间",
      u8"千钧",
      u8"千钧一发",
      u8"千钧为轻",
      u8"千钧重负",
      u8"千锤打锣一锤定音",
      u8"千锤百炼",
      u8"千锤百链",
      u8"千门",
      u8"千门万户",
      u8"千门八将",
      u8"千闻不如一见",
      u8"千阳",
      u8"千阳县",
      u8"千随百顺",
      u8"千难万苦",
      u8"千难万险",
      u8"千难万难",
      u8"千面人",
      u8"千页群岛",
      u8"千骄百媚",
      u8"千鸟",
      u8"千龄万代",
      u8"千龙",
      u8"千龙网",
      u8"升上",
      u8"升上去",
      u8"升上来",
      u8"升为",
      u8"升了",
      u8"升仙",
      u8"升任",
      u8"升值",
      u8"升入",
      u8"升出",
      u8"升出来",
      u8"升到",
      u8"升力",
      u8"升势",
      u8"升势受阻",
      u8"升升",
      u8"升华",
      u8"升华作用",
      u8"升华热",
      u8"升压",
      u8"升压高电平时钟发生器",
      u8"升号",
      u8"升回",
      u8"升回去",
      u8"升回来",
      u8"升国旗",
      u8"升在",
      u8"升堂",
      u8"升堂入室",
      u8"升堂拜母",
      u8"升天",
      u8"升好",
      u8"升学",
      u8"升学主义",
      u8"升学压力",
      u8"升学率",
      u8"升学考试",
      u8"升官",
      u8"升官发财",
      u8"升官进爵",
      u8"升山采珠",
      u8"升帆",
      u8"升帐",
      u8"升幂",
      u8"升幂级数",
      u8"升幅",
      u8"升平",
      u8"升序",
      u8"升座",
      u8"升得",
      u8"升成",
      u8"升技",
      u8"升挡",
      u8"升斗",
      u8"升斗小民",
      u8"升旗",
      u8"升旗仪式",
      u8"升旗典礼",
      u8"升来",
      u8"升来升去",
      u8"升格",
      u8"升档",
      u8"升水",
      u8"升汞",
      u8"升沉",
      u8"升沉补偿器",
      u8"升沉补偿装置",
      u8"升涨",
      u8"升清降浊",
      u8"升温",
      u8"升温快",
      u8"升火",
      u8"升点",
      u8"升班",
      u8"升班考试",
      u8"升班马",
      u8"升空",
      u8"升等",
      u8"升等考试",
      u8"升级",
      u8"升级到",
      u8"升级包",
      u8"升级库",
      u8"升级快",
      u8"升级成",
      u8"升级换代",
      u8"升级档",
      u8"升级版",
      u8"升结肠",
      u8"升职",
      u8"升腾",
      u8"升至",
      u8"升药",
      u8"升调",
      u8"升贴",
      u8"升起",
      u8"升起来",
      u8"升迁",
      u8"升迁制度",
      u8"升迁管道",
      u8"升过",
      u8"升速",
      u8"升阶",
      u8"升降",
      u8"升降口",
      u8"升降台",
      u8"升降器",
      u8"升降式",
      u8"升降机",
      u8"升降条件",
      u8"升降梯",
      u8"升降级",
      u8"升降舵",
      u8"升降记号",
      u8"升降车",
      u8"升限",
      u8"升顶",
      u8"升高",
      u8"升麻",
      u8"升龙",
      u8"午休",
      u8"午前",
      u8"午后",
      u8"午夜",
      u8"午夜凶铃",
      u8"午夜惊魂",
      u8"午安",
      u8"午宴",
      u8"午市",
      u8"午时",
      u8"午时茶",
      u8"午炮",
      u8"午眠",
      u8"午睡",
      u8"午膳",
      u8"午觉",
      u8"午门",
      u8"午间",
      u8"午餐",
      u8"午餐会",
      u8"午餐时间",
      u8"午餐肉",
      u8"午餐费",
      u8"午饭",
      u8"午饭时间",
      u8"午马",
      u8"半三不四",
      u8"半上半下",
      u8"半上落下",
      u8"半下",
      u8"半世",
      u8"半世纪",
      u8"半丝半缕",
      u8"半两",
      u8"半个",
      u8"半个世纪",
      u8"半个多世纪",
      u8"半个月",
      u8"半中腰",
      u8"半买半送",
      u8"半乳甘露聚糖",
      u8"半乳糖",
      u8"半乳糖脑苷脂",
      u8"半乳聚糖",
      u8"半交换期",
      u8"半亿",
      u8"半仙",
      u8"半价",
      u8"半价优待",
      u8"半价票",
      u8"半份",
      u8"半休",
      u8"半位点",
      u8"半低不高",
      u8"半侧",
      u8"半信不信",
      u8"半信半疑",
      u8"半倒",
      u8"半停产",
      u8"半儿",
      u8"半元音",
      u8"半公开",
      u8"半兽",
      u8"半兽人",
      u8"半农半牧区",
      u8"半冬性",
      u8"半决赛",
      u8"半决赛权",
      u8"半分",
      u8"半分钟",
      u8"半切牙术",
      u8"半制品",
      u8"半功率点",
      u8"半劳动力",
      u8"半包",
      u8"半包围",
      u8"半半拉拉",
      u8"半半路路",
      u8"半单元",
      u8"半单簇",
      u8"半双工",
      u8"半句",
      u8"半句话",
      u8"半只",
      u8"半合成沸石裂化催化剂",
      u8"半吊子",
      u8"半同胞交配",
      u8"半吐半露",
      u8"半吞半吐",
      u8"半响",
      u8"半喂入水稻联合收割机",
      u8"半固定桥",
      u8"半固定桥连接体",
      u8"半固定沙丘",
      u8"半圆",
      u8"半圆形",
      u8"半圆形壁龛",
      u8"半圆规",
      u8"半圈",
      u8"半场",
      u8"半坡",
      u8"半坪",
      u8"半壁",
      u8"半壁山河",
      u8"半壁江山",
      u8"半壁河山",
      u8"半夏",
      u8"半夏蛋白",
      u8"半夜",
      u8"半夜三更",
      u8"半夜敲门心不惊",
      u8"半夜里",
      u8"半大",
      u8"半大不小",
      u8"半天",
      u8"半天空",
      u8"半失业",
      u8"半头",
      u8"半子",
      u8"半完满环",
      u8"半官方",
      u8"半定制集成电路",
      u8"半家",
      u8"半寄生物",
      u8"半导体",
      u8"半导体激光器",
      u8"半封建",
      u8"半封建半",
      u8"半封建半殖民地",
      u8"半小时",
      u8"半局",
      u8"半山",
      u8"半山腰",
      u8"半岁",
      u8"半岛",
      u8"半岛园",
      u8"半岛网",
      u8"半工半续",
      u8"半工半读",
      u8"半常绿植物",
      u8"半干旱",
      u8"半年",
      u8"半年份",
      u8"半年刊",
      u8"半年度",
      u8"半年报",
      u8"半年线",
      u8"半开",
      u8"半开放式棚",
      u8"半开门儿",
      u8"半张",
      u8"半弯",
      u8"半影",
      u8"半径",
      u8"半径大小",
      u8"半微量分析",
      u8"半悬挂式农具",
      u8"半成品",
      u8"半截",
      u8"半截入土",
      u8"半截子",
      u8"半截面罩",
      u8"半打",
      u8"半抗原",
      u8"半折",
      u8"半拉",
      u8"半拉子",
      u8"半拍",
      u8"半挂车",
      u8"半推",
      u8"半推半就",
      u8"半支",
      u8"半支莲",
      u8"半政府",
      u8"半数",
      u8"半数以上",
      u8"半数以下",
      u8"半数耐受极限",
      u8"半数致死量",
      u8"半文不值",
      u8"半文不白",
      u8"半文半白",
      u8"半文盲",
      u8"半斤",
      u8"半斤八两",
      u8"半斤八面",
      u8"半新",
      u8"半新不旧",
      u8"半新半旧",
      u8"半旗",
      u8"半无产阶级",
      u8"半无限斜线逼近",
      u8"半日",
      u8"半日制",
      u8"半日闲",
      u8"半旧",
      u8"半时",
      u8"半时半刻",
      u8"半明半暗",
      u8"半晌",
      u8"半月",
      u8"半月刊",
      u8"半月弯刀",
      u8"半月形",
      u8"半月板",
      u8"半月谈",
      u8"半本",
      u8"半本原环",
      u8"半机械化",
      u8"半条",
      u8"半条命",
      u8"半板",
      u8"半枝",
      u8"半架",
      u8"半栋",
      u8"半桶水",
      u8"半梦半醒",
      u8"半棵",
      u8"半正规算子",
      u8"半步",
      u8"半死",
      u8"半死不活",
      u8"半死半生",
      u8"半死辣活",
      u8"半殖民地",
      u8"半殖民地半封建",
      u8"半波整流",
      u8"半波整流器",
      u8"半波片",
      u8"半波电位",
      u8"半流体",
      u8"半涂而废",
      u8"半涂而罢",
      u8"半深海相",
      u8"半湿润",
      u8"半满",
      u8"半潜式多用工作船",
      u8"半点",
      u8"半点不由人",
      u8"半点儿",
      u8"半点钟",
      u8"半熟",
      u8"半环扁尾蛇毒素",
      u8"半球",
      u8"半球型",
      u8"半球形",
      u8"半球形穹顶",
      u8"半球盘",
      u8"半璧江山",
      u8"半瓶",
      u8"半瓶子晃荡",
      u8"半瓶醋",
      u8"半生",
      u8"半生不熟",
      u8"半生半熟",
      u8"半生尝胆",
      u8"半甲",
      u8"半甲基化",
      u8"半疑半信",
      u8"半痴不颠",
      u8"半白",
      u8"半百",
      u8"半盔",
      u8"半直积",
      u8"半真",
      u8"半真半假",
      u8"半睡半醒",
      u8"半睡眠状",
      u8"半睡眠状态",
      u8"半码",
      u8"半票",
      u8"半票价",
      u8"半私营",
      u8"半秒",
      u8"半秒钟",
      u8"半程",
      u8"半空",
      u8"半空中",
      u8"半章",
      u8"半筹不纳",
      u8"半筹莫展",
      u8"半箱",
      u8"半粒",
      u8"半精密支托",
      u8"半精装",
      u8"半索动物",
      u8"半级",
      u8"半线性偏微分方程",
      u8"半线性同构",
      u8"半经",
      u8"半统靴",
      u8"半缩酮",
      u8"半老头",
      u8"半老徐娘",
      u8"半耐寒植物",
      u8"半耐寒蔬菜",
      u8"半胱天冬氨酸蛋白酶",
      u8"半胱氨酸",
      u8"半胱磺酸",
      u8"半胱胺",
      u8"半胶束",
      u8"半脱产",
      u8"半腰",
      u8"半自养",
      u8"半自动",
      u8"半自动化",
      u8"半自动闭塞",
      u8"半自给",
      u8"半舌切除术",
      u8"半色调图像",
      u8"半节",
      u8"半节网络",
      u8"半节课",
      u8"半衰期",
      u8"半袋",
      u8"半裸",
      u8"半角",
      u8"半解一知",
      u8"半解剖式牙",
      u8"半课",
      u8"半路",
      u8"半路上",
      u8"半路修行",
      u8"半路出家",
      u8"半蹲",
      u8"半身",
      u8"半身不摄",
      u8"半身不遂",
      u8"半身像",
      u8"半身照",
      u8"半身裙",
      u8"半车",
      u8"半载",
      u8"半辈子",
      u8"半边",
      u8"半边人",
      u8"半边天",
      u8"半边莲",
      u8"半连续聚合",
      u8"半透明",
      u8"半透明体",
      u8"半透明复制品",
      u8"半途",
      u8"半途上",
      u8"半途而",
      u8"半途而废",
      u8"半途而癈",
      u8"半通道",
      u8"半道",
      u8"半道儿",
      u8"半遮半掩",
      u8"半遮面",
      u8"半部",
      u8"半部论语",
      u8"半部论语治天下",
      u8"半酣",
      u8"半醒半睡",
      u8"半里",
      u8"半长裤",
      u8"半门",
      u8"半间不界",
      u8"半间半界",
      u8"半队",
      u8"半集",
      u8"半露柱",
      u8"半青半黄",
      u8"半面",
      u8"半面不忘",
      u8"半面之交",
      u8"半面之旧",
      u8"半音",
      u8"半音阶",
      u8"半页",
      u8"半颗",
      u8"半饥半饱",
      u8"半饱",
      u8"半饱半饿",
      u8"半饷",
      u8"半首",
      u8"华不再扬",
      u8"华东",
      u8"华东区",
      u8"华东地区",
      u8"华东师大",
      u8"华东师范",
      u8"华东师范大学",
      u8"华东政法",
      u8"华东旅游",
      u8"华东理工",
      u8"华严",
      u8"华严宗",
      u8"华严寺",
      u8"华严经",
      u8"华中",
      u8"华中地区",
      u8"华中师大",
      u8"华中科技",
      u8"华丰",
      u8"华为",
      u8"华为技术",
      u8"华丽",
      u8"华云龙",
      u8"华交会",
      u8"华亭",
      u8"华亭县",
      u8"华亭鹤唳",
      u8"华人",
      u8"华人乐队",
      u8"华人华侨",
      u8"华人社区",
      u8"华人网",
      u8"华人论坛",
      u8"华以",
      u8"华以刚",
      u8"华伯斯基",
      u8"华体网",
      u8"华佗",
      u8"华侨",
      u8"华侨之乡",
      u8"华侨塑料厂",
      u8"华侨大学",
      u8"华侨委员会",
      u8"华侨投资公司",
      u8"华侨联会",
      u8"华侨银行",
      u8"华储",
      u8"华储网",
      u8"华光",
      u8"华兴",
      u8"华兴会",
      u8"华兹华斯",
      u8"华冈",
      u8"华冈艺术",
      u8"华冈艺术学校",
      u8"华军",
      u8"华军软",
      u8"华军软件园",
      u8"华冠丽服",
      u8"华凌",
      u8"华北",
      u8"华北区",
      u8"华北地区",
      u8"华北平原",
      u8"华北电",
      u8"华北电力",
      u8"华北石油",
      u8"华南",
      u8"华南区",
      u8"华南地区",
      u8"华南城",
      u8"华南师大",
      u8"华南师范大学",
      u8"华南理工",
      u8"华南理工大学",
      u8"华南虎",
      u8"华南银行",
      u8"华原朋美",
      u8"华厦",
      u8"华县",
      u8"华发",
      u8"华商",
      u8"华商报",
      u8"华商网",
      u8"华国",
      u8"华国锋",
      u8"华坪",
      u8"华坪县",
      u8"华城",
      u8"华埠",
      u8"华埠镇",
      u8"华堂",
      u8"华声",
      u8"华声报",
      u8"华夏",
      u8"华夏儿女",
      u8"华夏大地",
      u8"华夏工专",
      u8"华夏工业",
      u8"华夏工业专科学校",
      u8"华夏文化",
      u8"华夏民族",
      u8"华夏证券",
      u8"华夏银行",
      u8"华夏鳗",
      u8"华大基因",
      u8"华天",
      u8"华夷",
      u8"华宁",
      u8"华宁县",
      u8"华安",
      u8"华安县",
      u8"华宝",
      u8"华实业",
      u8"华容",
      u8"华容区",
      u8"华容县",
      u8"华容道",
      u8"华封三祝",
      u8"华封三视",
      u8"华尔兹",
      u8"华尔兹舞",
      u8"华尔滋",
      u8"华尔特",
      u8"华尔街",
      u8"华尔街股市",
      u8"华尾丘墟",
      u8"华尾山丘",
      u8"华屋",
      u8"华屋丘墟",
      u8"华屋山丘",
      u8"华屋秋墟",
      u8"华山",
      u8"华山医院",
      u8"华山参",
      u8"华山派",
      u8"华山论剑",
      u8"华山路",
      u8"华岗",
      u8"华工",
      u8"华师一",
      u8"华师大",
      u8"华年",
      u8"华广",
      u8"华府",
      u8"华建敏",
      u8"华开",
      u8"华强",
      u8"华强北",
      u8"华彩",
      u8"华彩网",
      u8"华德",
      u8"华意",
      u8"华成龙",
      u8"华拱",
      u8"华支睾吸虫",
      u8"华文",
      u8"华新",
      u8"华新村",
      u8"华族",
      u8"华旗",
      u8"华明",
      u8"华星",
      u8"华星秋月",
      u8"华晨",
      u8"华林",
      u8"华林路",
      u8"华核",
      u8"华格纳",
      u8"华欣",
      u8"华歆",
      u8"华歌尔",
      u8"华殿",
      u8"华氏",
      u8"华氏度",
      u8"华氏温度",
      u8"华氏温度计",
      u8"华氏温标",
      u8"华江",
      u8"华江国中",
      u8"华江国小",
      u8"华池县",
      u8"华沙",
      u8"华沙公约",
      u8"华泰",
      u8"华津",
      u8"华润",
      u8"华清池",
      u8"华源",
      u8"华澳",
      u8"华灯",
      u8"华灯初上",
      u8"华烛",
      u8"华版",
      u8"华玉",
      u8"华瑞",
      u8"华生",
      u8"华盖",
      u8"华盛顿",
      u8"华盛顿州",
      u8"华盛顿邮",
      u8"华盛顿邮报",
      u8"华石镇",
      u8"华硕",
      u8"华福",
      u8"华科技",
      u8"华立",
      u8"华章",
      u8"华章锦绣",
      u8"华筝",
      u8"华约",
      u8"华约组织",
      u8"华纳",
      u8"华罗庚",
      u8"华美",
      u8"华美达",
      u8"华翰",
      u8"华而不媚",
      u8"华而不实",
      u8"华联",
      u8"华胄",
      u8"华能",
      u8"华腾",
      u8"华腾联合",
      u8"华航",
      u8"华英",
      u8"华英雄",
      u8"华茂",
      u8"华荣",
      u8"华药",
      u8"华莱士",
      u8"华莱士瓜",
      u8"华莱士线",
      u8"华莹市",
      u8"华蓥",
      u8"华蓥山",
      u8"华蓥市",
      u8"华虹",
      u8"华表",
      u8"华表奖",
      u8"华裔",
      u8"华西",
      u8"华西村",
      u8"华西街",
      u8"华西里耶夫",
      u8"华观",
      u8"华视",
      u8"华视公司",
      u8"华视网",
      u8"华诚",
      u8"华诞",
      u8"华语",
      u8"华语学校",
      u8"华语音乐",
      u8"华贵",
      u8"华赫艮",
      u8"华辞",
      u8"华达呢",
      u8"华远",
      u8"华通",
      u8"华都",
      u8"华里",
      u8"华铜",
      u8"华银",
      u8"华阳",
      u8"华阳国志",
      u8"华阳路",
      u8"华阴",
      u8"华阴县",
      u8"华阴市",
      u8"华陀",
      u8"华陀在世",
      u8"华陵",
      u8"华隆",
      u8"华雄",
      u8"华饰",
      u8"华龄",
      u8"华龙",
      u8"华龙区",
      u8"华龙网",
      u8"协从",
      u8"协从犯",
      u8"协会",
      u8"协会主席",
      u8"协会会员",
      u8"协会会长",
      u8"协会理事",
      u8"协作",
      u8"协作关系",
      u8"协作区",
      u8"协作单位",
      u8"协作组",
      u8"协作网",
      u8"协作者",
      u8"协力",
      u8"协力同心",
      u8"协力车",
      u8"协力齐心",
      u8"协办",
      u8"协办人",
      u8"协办员",
      u8"协办者",
      u8"协助",
      u8"协助人",
      u8"协助执行",
      u8"协助者",
      u8"协合",
      u8"协同",
      u8"协同作战",
      u8"协同动作",
      u8"协同学",
      u8"协同效应",
      u8"协同程序",
      u8"协同通信",
      u8"协和",
      u8"协和医院",
      u8"协商",
      u8"协商一致",
      u8"协商会",
      u8"协商会议",
      u8"协商者",
      u8"协奏",
      u8"协奏曲",
      u8"协定",
      u8"协律",
      u8"协心同力",
      u8"协心戮力",
      u8"协方差",
      u8"协方差分析",
      u8"协查",
      u8"协查通报",
      u8"协洽",
      u8"协济",
      u8"协理",
      u8"协理员",
      u8"协私罔上",
      u8"协税",
      u8"协约",
      u8"协约国",
      u8"协统",
      u8"协议",
      u8"协议书",
      u8"协议价",
      u8"协议对他",
      u8"协议映射",
      u8"协议赡养",
      u8"协调",
      u8"协调一致",
      u8"协调会",
      u8"协调会议",
      u8"协调公式",
      u8"协调发展",
      u8"协调员",
      u8"协调委员会",
      u8"协调官",
      u8"协调系统",
      u8"协调部",
      u8"协进会",
      u8"协迫",
      u8"协防",
      u8"协防部",
      u8"卑下",
      u8"卑不足道",
      u8"卑之无甚高论",
      u8"卑亲属",
      u8"卑以自牧",
      u8"卑俗",
      u8"卑劣",
      u8"卑劣地",
      u8"卑劣性",
      u8"卑劣手段",
      u8"卑卑不足道",
      u8"卑南",
      u8"卑南溪",
      u8"卑宫菲食",
      u8"卑尊",
      u8"卑微",
      u8"卑怯",
      u8"卑斯山",
      u8"卑污",
      u8"卑湿",
      u8"卑琐",
      u8"卑礼厚币",
      u8"卑职",
      u8"卑词厚礼",
      u8"卑谄足恭",
      u8"卑贱",
      u8"卑身屈体",
      u8"卑身贱体",
      u8"卑躬屈膝",
      u8"卑躬屈节",
      u8"卑辞",
      u8"卑辞厚币",
      u8"卑辞厚礼",
      u8"卑辞重币",
      u8"卑鄙",
      u8"卑鄙无耻",
      u8"卑鄙龌龊",
      u8"卑陋",
      u8"卑陋龌龊",
      u8"卒业",
      u8"卒于",
      u8"卒子",
      u8"卒岁",
      u8"卓不凡",
      u8"卓乎不群",
      u8"卓依婷",
      u8"卓兰",
      u8"卓别林",
      u8"卓午",
      u8"卓天雄",
      u8"卓奥友峰",
      u8"卓尔不群",
      u8"卓尔独行",
      u8"卓尼",
      u8"卓尼县",
      u8"卓异",
      u8"卓文君",
      u8"卓有",
      u8"卓有成就",
      u8"卓有成效",
      u8"卓有远见",
      u8"卓溪",
      u8"卓然",
      u8"卓然有成",
      u8"卓着",
      u8"卓立",
      u8"卓立鸡群",
      u8"卓绝",
      u8"卓而不群",
      u8"卓荦不羁",
      u8"卓荦英姿",
      u8"卓荦超伦",
      u8"卓著",
      u8"卓著威名",
      u8"卓行",
      u8"卓见",
      u8"卓识",
      u8"卓识远见",
      u8"卓资",
      u8"卓资县",
      u8"卓越",
      u8"卓越价",
      u8"卓越性",
      u8"卓越贡献",
      u8"卓里",
      u8"单一",
      u8"单一体",
      u8"单一刺激法",
      u8"单一化",
      u8"单一培养",
      u8"单一性",
      u8"单一材料",
      u8"单一编址空间",
      u8"单丁",
      u8"单三部曲式",
      u8"单丝",
      u8"单丝不成线",
      u8"单丝不线",
      u8"单个",
      u8"单个儿",
      u8"单个地址",
      u8"单义",
      u8"单买",
      u8"单事件锁定",
      u8"单于",
      u8"单井卫星采油树",
      u8"单井控制储量",
      u8"单井设计",
      u8"单交",
      u8"单交种",
      u8"单产",
      u8"单亲",
      u8"单亲家庭",
      u8"单亲遗传",
      u8"单人",
      u8"单人床",
      u8"单人房",
      u8"单人旁",
      u8"单人游戏",
      u8"单人滑",
      u8"单人独马",
      u8"单人舞",
      u8"单人间",
      u8"单从",
      u8"单仰萍",
      u8"单价",
      u8"单任务",
      u8"单传",
      u8"单伯山",
      u8"单位",
      u8"单位价格",
      u8"单位冲激函数",
      u8"单位制",
      u8"单位名",
      u8"单位名单",
      u8"单位名称",
      u8"单位向量",
      u8"单位地址",
      u8"单位工程",
      u8"单位态射",
      u8"单位成本",
      u8"单位根",
      u8"单位理想",
      u8"单位矩阵",
      u8"单位负责人",
      u8"单位阶跃函数",
      u8"单位面积",
      u8"单位面积产量",
      u8"单位预算",
      u8"单位领导",
      u8"单体",
      u8"单体单元",
      u8"单体性",
      u8"单作",
      u8"单侧平衡",
      u8"单侧约束",
      u8"单倍体",
      u8"单倍性",
      u8"单倍核",
      u8"单值分支",
      u8"单值化定理",
      u8"单储系数",
      u8"单元",
      u8"单元体",
      u8"单元刚度矩阵",
      u8"单元尺寸",
      u8"单元性",
      u8"单元房",
      u8"单元景观",
      u8"单元格",
      u8"单元楼",
      u8"单元测试",
      u8"单元环涡流",
      u8"单元码",
      u8"单光子发射计算机化断层显象",
      u8"单克隆",
      u8"单克隆抗体",
      u8"单克隆抗体标记",
      u8"单兵",
      u8"单兵孤城",
      u8"单兵攻击",
      u8"单养",
      u8"单凭",
      u8"单击",
      u8"单击右键",
      u8"单击左键",
      u8"单刀",
      u8"单刀球",
      u8"单刀直入",
      u8"单刀赴会",
      u8"单分体",
      u8"单分子共轭碱消除",
      u8"单分子反应",
      u8"单分子吸附",
      u8"单分子层",
      u8"单切线",
      u8"单列",
      u8"单列直插封装",
      u8"单列直插式内存组件",
      u8"单则易折",
      u8"单则易折众则难摧",
      u8"单利",
      u8"单加氧酶",
      u8"单动道岔",
      u8"单单",
      u8"单单会",
      u8"单单在",
      u8"单单是",
      u8"单单有",
      u8"单单能",
      u8"单卖",
      u8"单卡",
      u8"单卵双生",
      u8"单县",
      u8"单双面",
      u8"单反",
      u8"单反相机",
      u8"单叔山",
      u8"单变量系统",
      u8"单口",
      u8"单口相声",
      u8"单句",
      u8"单另",
      u8"单只",
      u8"单台服务系统",
      u8"单号",
      u8"单名",
      u8"单名数",
      u8"单向",
      u8"单向性",
      u8"单向收费",
      u8"单向栈自动机",
      u8"单向行驶",
      u8"单向转运",
      u8"单向通车",
      u8"单向阀",
      u8"单周期函数",
      u8"单因素方差分析",
      u8"单在",
      u8"单基因杂种",
      u8"单声道",
      u8"单姓",
      u8"单子",
      u8"单子叶植物",
      u8"单孑独立",
      u8"单孔",
      u8"单孔目",
      u8"单字",
      u8"单字表",
      u8"单字长精度",
      u8"单季",
      u8"单季山",
      u8"单季稻",
      u8"单宁",
      u8"单宁酸",
      u8"单寒",
      u8"单对单",
      u8"单小山",
      u8"单就",
      u8"单尾检验",
      u8"单层",
      u8"单层式",
      u8"单层次",
      u8"单层细胞",
      u8"单峰",
      u8"单峰函数",
      u8"单峰驼",
      u8"单峰骆驼",
      u8"单工槽",
      u8"单帮",
      u8"单幅",
      u8"单干",
      u8"单干户",
      u8"单床",
      u8"单座",
      u8"单座式",
      u8"单开",
      u8"单式簿记",
      u8"单引发",
      u8"单引号",
      u8"单张",
      u8"单弦",
      u8"单弦儿",
      u8"单弱",
      u8"单形性腺瘤",
      u8"单形现象",
      u8"单形的面",
      u8"单循环",
      u8"单循环赛",
      u8"单忧极瘁",
      u8"单态性",
      u8"单态现象",
      u8"单性",
      u8"单性合子",
      u8"单性结实",
      u8"单性胚",
      u8"单性花",
      u8"单总线",
      u8"单恋",
      u8"单恋一枝花",
      u8"单手",
      u8"单手剑",
      u8"单手操作",
      u8"单打",
      u8"单打一",
      u8"单打独斗",
      u8"单打运动员",
      u8"单扛",
      u8"单抗",
      u8"单挂号",
      u8"单指",
      u8"单指令流多数据流",
      u8"单挑",
      u8"单据",
      u8"单排",
      u8"单摆",
      u8"单播",
      u8"单放机",
      u8"单数",
      u8"单数形",
      u8"单文孤证",
      u8"单斜",
      u8"单斜层",
      u8"单斜晶硫",
      u8"单斜晶系",
      u8"单方",
      u8"单方面",
      u8"单日",
      u8"单日份",
      u8"单是",
      u8"单显",
      u8"单晶",
      u8"单晶体",
      u8"单晶河乡",
      u8"单晶硅",
      u8"单曲",
      u8"单曲榜",
      u8"单月",
      u8"单期",
      u8"单本剧",
      u8"单机",
      u8"单机版",
      u8"单材拱",
      u8"单杠",
      u8"单板",
      u8"单板机",
      u8"单板计算机",
      u8"单极",
      u8"单极子",
      u8"单极晶体管",
      u8"单枪",
      u8"单枪匹马",
      u8"单枪独马",
      u8"单株",
      u8"单株选择",
      u8"单核",
      u8"单核心",
      u8"单核细胞",
      u8"单根独苗",
      u8"单桅船",
      u8"单槽",
      u8"单槽式",
      u8"单模",
      u8"单正",
      u8"单步",
      u8"单步梁",
      u8"单步法",
      u8"单母音",
      u8"单比",
      u8"单比例",
      u8"单淘汰制",
      u8"单演函数",
      u8"单点",
      u8"单点故障",
      u8"单点系泊",
      u8"单片",
      u8"单片微波集成放大器",
      u8"单片机",
      u8"单片系统",
      u8"单片装",
      u8"单片计算机",
      u8"单片集成电路",
      u8"单独",
      u8"单独到",
      u8"单独在",
      u8"单独地",
      u8"单独海损",
      u8"单环氧型木脂体",
      u8"单瓣",
      u8"单生花",
      u8"单用",
      u8"单用户",
      u8"单田方",
      u8"单田芳",
      u8"单瘫",
      u8"单盲",
      u8"单相",
      u8"单相思",
      u8"单相接地",
      u8"单相电",
      u8"单眼",
      u8"单眼皮",
      u8"单硝酸",
      u8"单碟",
      u8"单磷酸",
      u8"单科",
      u8"单程",
      u8"单程票",
      u8"单程距离",
      u8"单稳触发电路",
      u8"单立",
      u8"单立人",
      u8"单立文",
      u8"单端固定桥",
      u8"单端孢菌素",
      u8"单笔",
      u8"单管单元存储器",
      u8"单管系统",
      u8"单篇",
      u8"单簧管",
      u8"单粒传法",
      u8"单粒子分布函数",
      u8"单精度",
      u8"单糖",
      u8"单系",
      u8"单纯",
      u8"单纯化",
      u8"单纯型精神分裂症",
      u8"单纯形",
      u8"单纯形法",
      u8"单纯性",
      u8"单纯性甲状腺肿",
      u8"单纯性紫癜",
      u8"单纯林",
      u8"单纯词",
      u8"单线",
      u8"单线程",
      u8"单线行驶",
      u8"单线通车",
      u8"单线铁路",
      u8"单组分",
      u8"单组分系统",
      u8"单细胞",
      u8"单结晶体管",
      u8"单缝衍射",
      u8"单缸",
      u8"单翼",
      u8"单翼飞机",
      u8"单耳刀",
      u8"单耳听觉",
      u8"单耳旁",
      u8"单职",
      u8"单股",
      u8"单股聚合物",
      u8"单胞疹病毒",
      u8"单胞藻",
      u8"单胺氧化酶",
      u8"单能性",
      u8"单脉冲",
      u8"单脚",
      u8"单脚站立",
      u8"单脚跳",
      u8"单臂卡环",
      u8"单舌法撕破强力试验方法",
      u8"单色",
      u8"单色仪",
      u8"单色光",
      u8"单色光源",
      u8"单色性",
      u8"单色显示适配器",
      u8"单色画",
      u8"单色谐调",
      u8"单花粉",
      u8"单萜",
      u8"单薄",
      u8"单螺杆",
      u8"单行",
      u8"单行本",
      u8"单行法",
      u8"单行线",
      u8"单行道",
      u8"单衣",
      u8"单被",
      u8"单裤",
      u8"单褂",
      u8"单见浅闻",
      u8"单设",
      u8"单证",
      u8"单证员",
      u8"单词",
      u8"单词表",
      u8"单词通",
      u8"单说",
      u8"单调",
      u8"单调乏味",
      u8"单调作业",
      u8"单调推理",
      u8"单调收敛定理",
      u8"单调无味",
      u8"单调曲率螺线",
      u8"单调枯燥",
      u8"单谷氨酸",
      u8"单质",
      u8"单足",
      u8"单足跳",
      u8"单蹄",
      u8"单身",
      u8"单身公寓",
      u8"单身在外",
      u8"单身女人",
      u8"单身情歌",
      u8"单身户",
      u8"单身汉",
      u8"单身生活",
      u8"单身男人",
      u8"单身男女",
      u8"单身白领",
      u8"单身贵族",
      u8"单车",
      u8"单车比赛",
      u8"单车竞赛",
      u8"单轨",
      u8"单轨制",
      u8"单轨铁路",
      u8"单轨铁道",
      u8"单轴取向",
      u8"单轴晶体",
      u8"单轴绞车",
      u8"单辆",
      u8"单边",
      u8"单边制裁",
      u8"单边带调制",
      u8"单过",
      u8"单选",
      u8"单选框",
      u8"单选题",
      u8"单通道",
      u8"单道分析器",
      u8"单醣",
      u8"单铁生",
      u8"单键",
      u8"单门",
      u8"单门式",
      u8"单门独户",
      u8"单间",
      u8"单间儿",
      u8"单霁翔",
      u8"单靠",
      u8"单靠着",
      u8"单面",
      u8"单面山",
      u8"单面洞",
      u8"单音",
      u8"单音字",
      u8"单音节",
      u8"单音词",
      u8"单项",
      u8"单项奖",
      u8"单项工程",
      u8"单项式",
      u8"单项样条",
      u8"单项赛",
      u8"单顺反子",
      u8"单颌全口义齿",
      u8"单风道系统",
      u8"单飞",
      u8"单首",
      u8"单骑",
      u8"单鹄寡凫",
      u8"单齿额定升降能力",
      u8"卖不出去",
      u8"卖不掉",
      u8"卖东西",
      u8"卖主",
      u8"卖主求荣",
      u8"卖乖",
      u8"卖乖弄俏",
      u8"卖书",
      u8"卖了",
      u8"卖人情",
      u8"卖价",
      u8"卖俏",
      u8"卖俏行奸",
      u8"卖俏迎奸",
      u8"卖假",
      u8"卖儿贴妇",
      u8"卖儿鬻女",
      u8"卖光",
      u8"卖公营私",
      u8"卖关子",
      u8"卖关节",
      u8"卖出",
      u8"卖出价",
      u8"卖出去",
      u8"卖刀买犊",
      u8"卖到",
      u8"卖剑买牛",
      u8"卖剑买犊",
      u8"卖剑买琴",
      u8"卖力",
      u8"卖力气",
      u8"卖劲",
      u8"卖卖",
      u8"卖压",
      u8"卖友",
      u8"卖友求荣",
      u8"卖呆",
      u8"卖命",
      u8"卖唱",
      u8"卖嘴",
      u8"卖国",
      u8"卖国求利",
      u8"卖国求容",
      u8"卖国求荣",
      u8"卖国贼",
      u8"卖场",
      u8"卖大号",
      u8"卖头卖脚",
      u8"卖契",
      u8"卖好",
      u8"卖妻鬻子",
      u8"卖字",
      u8"卖字号",
      u8"卖完",
      u8"卖官卖爵",
      u8"卖官贩爵",
      u8"卖官鬻爵",
      u8"卖官鬻狱",
      u8"卖家",
      u8"卖富差贫",
      u8"卖履分香",
      u8"卖底",
      u8"卖座",
      u8"卖弄",
      u8"卖弄口舌",
      u8"卖弄学问",
      u8"卖弄玄虚",
      u8"卖弄风情",
      u8"卖弄风骚",
      u8"卖当劳",
      u8"卖得",
      u8"卖户",
      u8"卖房",
      u8"卖房子",
      u8"卖手",
      u8"卖报",
      u8"卖掉",
      u8"卖文",
      u8"卖文为生",
      u8"卖断",
      u8"卖方",
      u8"卖方市场",
      u8"卖春",
      u8"卖春妇",
      u8"卖本事",
      u8"卖李钻核",
      u8"卖来卖去",
      u8"卖法市恩",
      u8"卖淫",
      u8"卖淫女",
      u8"卖淫妇",
      u8"卖淫嫖娼",
      u8"卖淫案",
      u8"卖火柴",
      u8"卖炭翁",
      u8"卖点",
      u8"卖烧饼",
      u8"卖爵鬻官",
      u8"卖狗悬羊",
      u8"卖狗皮膏药",
      u8"卖狗肉",
      u8"卖男鬻女",
      u8"卖盘",
      u8"卖相",
      u8"卖着",
      u8"卖破绽",
      u8"卖票",
      u8"卖空",
      u8"卖笑",
      u8"卖给",
      u8"卖老",
      u8"卖者",
      u8"卖肉",
      u8"卖艺",
      u8"卖艺不卖身",
      u8"卖艺者",
      u8"卖花",
      u8"卖苦力",
      u8"卖茶",
      u8"卖菜",
      u8"卖货",
      u8"卖身",
      u8"卖身契",
      u8"卖身投靠",
      u8"卖过",
      u8"卖钱",
      u8"卖面子",
      u8"南一中",
      u8"南丁格尔",
      u8"南三环",
      u8"南下",
      u8"南下列车",
      u8"南丫岛",
      u8"南中",
      u8"南中国海",
      u8"南丰",
      u8"南丰县",
      u8"南丰村",
      u8"南丹",
      u8"南丹县",
      u8"南丹路",
      u8"南乐",
      u8"南乐县",
      u8"南乡子",
      u8"南二中",
      u8"南二环",
      u8"南五环",
      u8"南亚",
      u8"南亚工专",
      u8"南京",
      u8"南京东路",
      u8"南京中医药大学",
      u8"南京人",
      u8"南京军区",
      u8"南京农业",
      u8"南京城",
      u8"南京大",
      u8"南京大学",
      u8"南京大屠杀",
      u8"南京市",
      u8"南京师范大学",
      u8"南京房产",
      u8"南京旅游",
      u8"南京日报",
      u8"南京晨报",
      u8"南京理工",
      u8"南京站",
      u8"南京翻译",
      u8"南京话",
      u8"南京路",
      u8"南人",
      u8"南仁通",
      u8"南侧",
      u8"南充",
      u8"南充县",
      u8"南充市",
      u8"南六环",
      u8"南兰",
      u8"南关",
      u8"南关区",
      u8"南兴镇",
      u8"南内环",
      u8"南军",
      u8"南冠楚囚",
      u8"南凉",
      u8"南出",
      u8"南到",
      u8"南加州",
      u8"南加罗林",
      u8"南加罗林纳洲",
      u8"南势溪",
      u8"南势角",
      u8"南匈奴",
      u8"南化塘镇",
      u8"南北",
      u8"南北关系",
      u8"南北向",
      u8"南北宽",
      u8"南北战争",
      u8"南北方",
      u8"南北朝",
      u8"南北极",
      u8"南北桥",
      u8"南北湖",
      u8"南北纬",
      u8"南北议和",
      u8"南北货",
      u8"南北通衢",
      u8"南北长",
      u8"南区",
      u8"南半",
      u8"南半球",
      u8"南半部",
      u8"南华",
      u8"南华县",
      u8"南华早报",
      u8"南华西",
      u8"南南北北",
      u8"南南合作",
      u8"南博会",
      u8"南卡罗",
      u8"南卡罗来",
      u8"南卡罗来州",
      u8"南卡罗来纳州",
      u8"南去",
      u8"南去北来",
      u8"南县",
      u8"南口",
      u8"南召",
      u8"南召县",
      u8"南台",
      u8"南台工专",
      u8"南史",
      u8"南向",
      u8"南吕",
      u8"南和",
      u8"南和县",
      u8"南唐",
      u8"南四湖",
      u8"南四环",
      u8"南回",
      u8"南回归线",
      u8"南回线",
      u8"南回铁路",
      u8"南园",
      u8"南国",
      u8"南国风光",
      u8"南坪",
      u8"南坪县",
      u8"南城",
      u8"南城县",
      u8"南城门",
      u8"南塘镇",
      u8"南大街",
      u8"南大门",
      u8"南天",
      u8"南天一",
      u8"南天竹",
      u8"南天门",
      u8"南太平洋",
      u8"南太湖",
      u8"南头",
      u8"南孚",
      u8"南宁",
      u8"南宁市",
      u8"南安",
      u8"南安县",
      u8"南安市",
      u8"南安普敦",
      u8"南安普顿",
      u8"南宋",
      u8"南宋人",
      u8"南宗",
      u8"南宫",
      u8"南宫市",
      u8"南寒带",
      u8"南小街",
      u8"南少林",
      u8"南山",
      u8"南山人寿",
      u8"南山区",
      u8"南山可移",
      u8"南山寺",
      u8"南山村",
      u8"南山矿区",
      u8"南山路",
      u8"南山铁案",
      u8"南岔",
      u8"南岔区",
      u8"南岗",
      u8"南岗区",
      u8"南岚镇",
      u8"南岛",
      u8"南岭",
      u8"南岭村",
      u8"南岳",
      u8"南岳区",
      u8"南岳怀让",
      u8"南岸",
      u8"南岸区",
      u8"南嵌溪",
      u8"南川",
      u8"南川市",
      u8"南州冠冕",
      u8"南巡",
      u8"南巡讲话",
      u8"南市",
      u8"南市区",
      u8"南师",
      u8"南师大",
      u8"南希仁",
      u8"南平",
      u8"南平市",
      u8"南平镇",
      u8"南庄",
      u8"南庄镇",
      u8"南康",
      u8"南康市",
      u8"南开",
      u8"南开区",
      u8"南开大学",
      u8"南开工专",
      u8"南归",
      u8"南往",
      u8"南征",
      u8"南征北伐",
      u8"南征北战",
      u8"南征北讨",
      u8"南怀仁",
      u8"南怀瑾",
      u8"南戴河",
      u8"南户窥郎",
      u8"南投",
      u8"南投人",
      u8"南投县",
      u8"南投市",
      u8"南拳",
      u8"南振中",
      u8"南斗",
      u8"南斯剩余间隙",
      u8"南斯拉夫",
      u8"南斯拉夫联盟",
      u8"南斯拉夫联盟塞尔维亚共和国",
      u8"南新路",
      u8"南方",
      u8"南方人",
      u8"南方人才",
      u8"南方南极",
      u8"南方周末",
      u8"南方城",
      u8"南方大港",
      u8"南方日报",
      u8"南方澳",
      u8"南方电网",
      u8"南方网",
      u8"南方网讯",
      u8"南方菜豆花叶病毒组",
      u8"南方证券",
      u8"南方话",
      u8"南方都市报",
      u8"南方音",
      u8"南方高科",
      u8"南无",
      u8"南无阿弥",
      u8"南无阿弥陀佛",
      u8"南昆山",
      u8"南昆线",
      u8"南昌",
      u8"南昌县",
      u8"南昌大学",
      u8"南昌市",
      u8"南昌街",
      u8"南昌起义",
      u8"南昌铁路局",
      u8"南明",
      u8"南明区",
      u8"南星",
      u8"南普陀",
      u8"南曲",
      u8"南朝",
      u8"南朝北",
      u8"南朝梁",
      u8"南朝鲜",
      u8"南木林",
      u8"南木林县",
      u8"南村镇",
      u8"南来",
      u8"南来北往",
      u8"南极",
      u8"南极人",
      u8"南极光",
      u8"南极区",
      u8"南极圈",
      u8"南极星",
      u8"南极洲",
      u8"南极虾",
      u8"南枝北枝",
      u8"南柯一梦",
      u8"南柯梦",
      u8"南校区",
      u8"南桐",
      u8"南棹北辕",
      u8"南楼",
      u8"南横",
      u8"南横公路",
      u8"南橘北枳",
      u8"南欧",
      u8"南欧国家",
      u8"南段",
      u8"南水北调",
      u8"南水峪村",
      u8"南汇",
      u8"南汇区",
      u8"南汇县",
      u8"南汉",
      u8"南江",
      u8"南江县",
      u8"南沈灶镇",
      u8"南沙",
      u8"南沙参",
      u8"南沙群岛",
      u8"南沱镇",
      u8"南河村",
      u8"南泥湾",
      u8"南洋",
      u8"南洋国家",
      u8"南洋杉",
      u8"南洋群岛",
      u8"南流",
      u8"南浔",
      u8"南浔区",
      u8"南浔镇",
      u8"南浦",
      u8"南海",
      u8"南海区",
      u8"南海县",
      u8"南海县人",
      u8"南海子",
      u8"南海学园",
      u8"南海岸",
      u8"南海市",
      u8"南海诸岛",
      u8"南海路",
      u8"南涧",
      u8"南涧县",
      u8"南涧彝族自治县",
      u8"南温带",
      u8"南港",
      u8"南港区",
      u8"南港国中",
      u8"南港国小",
      u8"南港路",
      u8"南游",
      u8"南湖",
      u8"南湖大山",
      u8"南湖渠",
      u8"南湖路",
      u8"南湾",
      u8"南溪",
      u8"南溪县",
      u8"南漳",
      u8"南漳县",
      u8"南潮村",
      u8"南澳",
      u8"南澳县",
      u8"南澳岛",
      u8"南澳溪",
      u8"南燕",
      u8"南特",
      u8"南王",
      u8"南环路",
      u8"南珠",
      u8"南理工",
      u8"南瓜",
      u8"南瓜子",
      u8"南瓜子氨酸",
      u8"南瓜氨酸",
      u8"南瓜花叶病毒组",
      u8"南瓜饼",
      u8"南疆",
      u8"南皮",
      u8"南皮县",
      u8"南盘江",
      u8"南盟",
      u8"南相美",
      u8"南社",
      u8"南票区",
      u8"南祭",
      u8"南禅寺",
      u8"南科达",
      u8"南站",
      u8"南端",
      u8"南竹",
      u8"南箕北斗",
      u8"南管",
      u8"南簏",
      u8"南粤",
      u8"南粮北调",
      u8"南红",
      u8"南纬",
      u8"南纬度",
      u8"南线",
      u8"南缘",
      u8"南罗得西",
      u8"南罗得西亚",
      u8"南美",
      u8"南美各国",
      u8"南美国家",
      u8"南美大草原",
      u8"南美洲",
      u8"南翼",
      u8"南联盟",
      u8"南联盟共和国",
      u8"南胡",
      u8"南腔",
      u8"南腔北调",
      u8"南自",
      u8"南至",
      u8"南舣北驾",
      u8"南航",
      u8"南航北骑",
      u8"南船",
      u8"南船北车",
      u8"南船北马",
      u8"南芬区",
      u8"南苑",
      u8"南荣",
      u8"南荣工专",
      u8"南营门街",
      u8"南蛇藤果",
      u8"南蛮",
      u8"南蛮寺",
      u8"南蛮鴂舌",
      u8"南蛮鴃舌",
      u8"南蛮",
      u8"南行",
      u8"南街",
      u8"南街村",
      u8"南诏",
      u8"南谯区",
      u8"南货",
      u8"南贩北贾",
      u8"南越",
      u8"南路",
      u8"南辕北辙",
      u8"南边",
      u8"南达",
      u8"南达科他",
      u8"南达科他州",
      u8"南通",
      u8"南通县",
      u8"南通市",
      u8"南通社",
      u8"南郊",
      u8"南郊区",
      u8"南郑",
      u8"南郑县",
      u8"南郡",
      u8"南部",
      u8"南部县",
      u8"南部地区",
      u8"南部地方",
      u8"南部洛",
      u8"南部非洲",
      u8"南郭",
      u8"南郭先生",
      u8"南郭处士",
      u8"南里",
      u8"南金东箭",
      u8"南金地箭",
      u8"南针",
      u8"南钢队",
      u8"南锡",
      u8"南锡学派",
      u8"南锣鼓巷",
      u8"南长区",
      u8"南门",
      u8"南门兜",
      u8"南门国中",
      u8"南门国小",
      u8"南门市场",
      u8"南门湾",
      u8"南阮北阮",
      u8"南阳",
      u8"南阳市",
      u8"南阳村",
      u8"南阳盆地",
      u8"南阳网",
      u8"南阳街",
      u8"南阳镇",
      u8"南陵",
      u8"南陵县",
      u8"南隔堤",
      u8"南雄",
      u8"南雄县",
      u8"南雄市",
      u8"南靖",
      u8"南靖县",
      u8"南非",
      u8"南非共和国",
      u8"南非各国",
      u8"南非国家",
      u8"南非队",
      u8"南面",
      u8"南面地理专业词汇",
      u8"南面百城",
      u8"南面称孤",
      u8"南韩",
      u8"南风",
      u8"南风不竞",
      u8"南风窗",
      u8"南飞",
      u8"南鹞北鹰",
      u8"南麓",
      u8"南齐",
      u8"南齐书",
      u8"博世",
      u8"博乐",
      u8"博乐市",
      u8"博亚网",
      u8"博伟",
      u8"博关经典",
      u8"博兴",
      u8"博兴县",
      u8"博力",
      u8"博动",
      u8"博卡",
      u8"博取",
      u8"博古",
      u8"博古架",
      u8"博古通今",
      u8"博城",
      u8"博基尼",
      u8"博士",
      u8"博士买驴",
      u8"博士伦",
      u8"博士后",
      u8"博士学位",
      u8"博士德",
      u8"博士文凭",
      u8"博士点",
      u8"博士班",
      u8"博士生",
      u8"博士生导师",
      u8"博士论文",
      u8"博大",
      u8"博大生物",
      u8"博大精深",
      u8"博大胸怀",
      u8"博奕",
      u8"博学",
      u8"博学之士",
      u8"博学多才",
      u8"博学多闻",
      u8"博学洽闻",
      u8"博客",
      u8"博客园",
      u8"博客地址",
      u8"博导",
      u8"博尔塔拉",
      u8"博尔塔拉蒙古自治州",
      u8"博尔德",
      u8"博尔忽",
      u8"博尔术",
      u8"博尔顿",
      u8"博局",
      u8"博山区",
      u8"博川区",
      u8"博弈",
      u8"博弈树搜索",
      u8"博弈犹贤",
      u8"博弈者",
      u8"博弈论",
      u8"博引",
      u8"博彩",
      u8"博彩业",
      u8"博彩税",
      u8"博得",
      u8"博德曼",
      u8"博拉",
      u8"博文约礼",
      u8"博斗",
      u8"博斯克",
      u8"博斯普鲁",
      u8"博斯普鲁斯海峡",
      u8"博斯腾湖",
      u8"博斯蒂克反演",
      u8"博施济众",
      u8"博时基金",
      u8"博望坡",
      u8"博望镇",
      u8"博来霉素",
      u8"博格坎普",
      u8"博格达",
      u8"博治多闻",
      u8"博洛尼",
      u8"博洛尼亚",
      u8"博洽",
      u8"博洽多闻",
      u8"博浪鼓",
      u8"博涛",
      u8"博湖",
      u8"博湖县",
      u8"博瀚",
      u8"博燃网",
      u8"博爱",
      u8"博爱医院",
      u8"博爱县",
      u8"博爱路",
      u8"博物",
      u8"博物多闻",
      u8"博物学家",
      u8"博物洽闻",
      u8"博物通达",
      u8"博物院",
      u8"博物馆",
      u8"博球网",
      u8"博瑞祥",
      u8"博甘斯",
      u8"博白",
      u8"博白县",
      u8"博硕肥腯",
      u8"博罗",
      u8"博罗县",
      u8"博美犬",
      u8"博而不精",
      u8"博而寡要",
      u8"博茨瓦纳",
      u8"博览",
      u8"博览五车",
      u8"博览会",
      u8"博览古今",
      u8"博览园",
      u8"博览群书",
      u8"博览群籍",
      u8"博览群集",
      u8"博讯",
      u8"博识",
      u8"博识多通",
      u8"博识洽闻",
      u8"博达",
      u8"博通经籍",
      u8"博采",
      u8"博采众家之长",
      u8"博采众议",
      u8"博采众长",
      u8"博采各家之长",
      u8"博野",
      u8"博野县",
      u8"博闻",
      u8"博闻多识",
      u8"博闻强志",
      u8"博闻强记",
      u8"博闻强识",
      u8"博闻辩言",
      u8"博雅",
      u8"博鳌",
      u8"卜卜",
      u8"卜卦",
      u8"卜卦家",
      u8"卜垣",
      u8"卜夜卜昼",
      u8"卜学亮",
      u8"卜守",
      u8"卜居",
      u8"卜昼卜夜",
      u8"卜沉",
      u8"卜泰",
      u8"卜祥志",
      u8"卜筮",
      u8"卜筮官",
      u8"卜算",
      u8"卜算子",
      u8"卜辞",
      u8"卜骨",
      u8"卞之琳",
      u8"卞急",
      u8"卞梁",
      u8"卞涛",
      u8"卟吩",
      u8"卟啉",
      u8"卟啉原",
      u8"占上风",
      u8"占下",
      u8"占个",
      u8"占为",
      u8"占为己有",
      u8"占主导地位",
      u8"占了",
      u8"占人口总数",
      u8"占优",
      u8"占优势",
      u8"占位",
      u8"占位性",
      u8"占住",
      u8"占便宜",
      u8"占先",
      u8"占光",
      u8"占公家便宜",
      u8"占到",
      u8"占卜",
      u8"占卜师",
      u8"占卜术",
      u8"占卜者",
      u8"占占",
      u8"占卦",
      u8"占压",
      u8"占去",
      u8"占取",
      u8"占在",
      u8"占地",
      u8"占地方",
      u8"占地约",
      u8"占地近",
      u8"占地面积",
      u8"占城",
      u8"占多数",
      u8"占好",
      u8"占尽",
      u8"占居",
      u8"占山为王",
      u8"占得",
      u8"占心术",
      u8"占据",
      u8"占据主动",
      u8"占掉",
      u8"占星",
      u8"占星学",
      u8"占星家",
      u8"占星师",
      u8"占星术",
      u8"占有",
      u8"占有一席之地",
      u8"占有优势",
      u8"占有权",
      u8"占有欲",
      u8"占有物",
      u8"占有率",
      u8"占有量",
      u8"占梦",
      u8"占治",
      u8"占满",
      u8"占理",
      u8"占用",
      u8"占用率",
      u8"占着",
      u8"占着茅坑不拉屎",
      u8"占空比",
      u8"占筮",
      u8"占线",
      u8"占股",
      u8"占课",
      u8"占起",
      u8"占起来",
      u8"占过",
      u8"占过去",
      u8"占过来",
      u8"占领",
      u8"占领军",
      u8"占领区",
      u8"占领地",
      u8"占领市场",
      u8"占领者",
      u8"占风使帆",
      u8"占风望气",
      u8"卡丁车",
      u8"卡丽来",
      u8"卡介伦",
      u8"卡介苗",
      u8"卡他",
      u8"卡伦津",
      u8"卡位",
      u8"卡住",
      u8"卡佩罗",
      u8"卡其",
      u8"卡其布",
      u8"卡其色",
      u8"卡其裤",
      u8"卡具",
      u8"卡内基",
      u8"卡农",
      u8"卡利",
      u8"卡利玛",
      u8"卡到",
      u8"卡制卡",
      u8"卡努里",
      u8"卡口",
      u8"卡号",
      u8"卡吉耶除子",
      u8"卡哇伊",
      u8"卡哇依",
      u8"卡啦",
      u8"卡嗒声",
      u8"卡嚓",
      u8"卡圈",
      u8"卡在",
      u8"卡地亚",
      u8"卡塔尔",
      u8"卡塔尼亚",
      u8"卡塞尔",
      u8"卡塞尔斯配对",
      u8"卡塞格伦反射面天线",
      u8"卡壳",
      u8"卡夫",
      u8"卡夫卡",
      u8"卡子",
      u8"卡宴",
      u8"卡宾体",
      u8"卡宾枪",
      u8"卡尔",
      u8"卡尔奥尔夫",
      u8"卡尔文",
      u8"卡尔文循环",
      u8"卡尔斯",
      u8"卡尔斯鲁厄",
      u8"卡尔松测度",
      u8"卡尔森",
      u8"卡尔维诺",
      u8"卡尔顿",
      u8"卡尺",
      u8"卡尼萨雷斯",
      u8"卡巴",
      u8"卡巴列夫斯基",
      u8"卡巴胂",
      u8"卡希尔",
      u8"卡带",
      u8"卡带机",
      u8"卡带柜",
      u8"卡带盒",
      u8"卡带箱",
      u8"卡座",
      u8"卡式",
      u8"卡式炉",
      u8"卡得",
      u8"卡恩",
      u8"卡托普利",
      u8"卡拉",
      u8"卡拉奇",
      u8"卡拉斯",
      u8"卡拉泰奥多里测度",
      u8"卡拉泽",
      u8"卡拉胶",
      u8"卡搭声",
      u8"卡斯",
      u8"卡斯塔",
      u8"卡斯尔",
      u8"卡斯特",
      u8"卡斯特尔维屈罗",
      u8"卡斯特罗",
      u8"卡斯特里",
      u8"卡斯蒂",
      u8"卡普兰",
      u8"卡普契尔里",
      u8"卡普拉",
      u8"卡曼奇",
      u8"卡机",
      u8"卡梅隆",
      u8"卡死",
      u8"卡比尔",
      u8"卡波管",
      u8"卡波西肉瘤",
      u8"卡洛变换",
      u8"卡洛尔",
      u8"卡洛斯",
      u8"卡洛里",
      u8"卡片",
      u8"卡片式",
      u8"卡片机",
      u8"卡片柜",
      u8"卡片盒",
      u8"卡片目录",
      u8"卡片目录柜",
      u8"卡片穿孔机",
      u8"卡片箱",
      u8"卡片纸",
      u8"卡片读入机",
      u8"卡片阅读机",
      u8"卡特",
      u8"卡特尔",
      u8"卡特里",
      u8"卡特里娜",
      u8"卡玛",
      u8"卡环",
      u8"卡环体",
      u8"卡环固位",
      u8"卡环臂",
      u8"卡百利",
      u8"卡盒",
      u8"卡盘",
      u8"卡福",
      u8"卡秀",
      u8"卡簧",
      u8"卡米尔",
      u8"卡米翁",
      u8"卡纳克",
      u8"卡纳斯",
      u8"卡纳维拉尔角",
      u8"卡纸",
      u8"卡罗",
      u8"卡罗尔",
      u8"卡罗斯",
      u8"卡罗林吉斯赫尔姆",
      u8"卡罗琳",
      u8"卡翁达",
      u8"卡耐基",
      u8"卡耐基救济金",
      u8"卡脖子",
      u8"卡芬雅克",
      u8"卡莱尔",
      u8"卡萨布兰",
      u8"卡萨布兰加",
      u8"卡萨布兰卡",
      u8"卡蜜儿",
      u8"卡西亚",
      u8"卡西尔",
      u8"卡西尼",
      u8"卡西尼重力公式",
      u8"卡西欧",
      u8"卡规",
      u8"卡诺",
      u8"卡诺定理",
      u8"卡诺循环",
      u8"卡路里",
      u8"卡车",
      u8"卡车司机",
      u8"卡车工",
      u8"卡轨",
      u8"卡轨器",
      u8"卡迪亚",
      u8"卡迪尔",
      u8"卡迪拉克",
      u8"卡迪琳娜",
      u8"卡通",
      u8"卡通世界",
      u8"卡通人物",
      u8"卡通动漫",
      u8"卡通动画",
      u8"卡通吧",
      u8"卡通图",
      u8"卡通图片",
      u8"卡通城",
      u8"卡通影片",
      u8"卡通漫画",
      u8"卡通片",
      u8"卡通版",
      u8"卡通电影",
      u8"卡通画",
      u8"卡通美女",
      u8"卡那霉素",
      u8"卡里",
      u8"卡里姆",
      u8"卡里尼",
      u8"卡里米",
      u8"卡钳",
      u8"卡门",
      u8"卡隆载体",
      u8"卡雷拉",
      u8"卡雷拉斯",
      u8"卡面",
      u8"卡马乔",
      u8"卡马拉",
      u8"卡鲁斯",
      u8"卡鲁索",
      u8"卢一峰",
      u8"卢克俭",
      u8"卢克索",
      u8"卢克莱修",
      u8"卢冠廷",
      u8"卢功勋",
      u8"卢卡契",
      u8"卢卡斯",
      u8"卢奇",
      u8"卢宁军",
      u8"卢尔",
      u8"卢展工",
      u8"卢巧音",
      u8"卢巴",
      u8"卢布",
      u8"卢布尔雅那",
      u8"卢希亚",
      u8"卢庆辉",
      u8"卢庚戌",
      u8"卢惠光",
      u8"卢旺达",
      u8"卢枢不蠹",
      u8"卢梭",
      u8"卢森堡",
      u8"卢森堡人",
      u8"卢武铉",
      u8"卢比",
      u8"卢氏",
      u8"卢氏县",
      u8"卢汉",
      u8"卢江",
      u8"卢沟桥",
      u8"卢洁云",
      u8"卢浔",
      u8"卢浮宫",
      u8"卢海潮",
      u8"卢海鹏",
      u8"卢淑仪",
      u8"卢湾",
      u8"卢湾区",
      u8"卢瑞华",
      u8"卢瑟福",
      u8"卢瑟福背散射谱学",
      u8"卢萨卡",
      u8"卢那察尔斯基",
      u8"卢龙",
      u8"卢龙县",
      u8"卤仿反应",
      u8"卤制",
      u8"卤化",
      u8"卤化烃喷嘴",
      u8"卤化烃瓶",
      u8"卤化烃释放报警铃",
      u8"卤化物",
      u8"卤味",
      u8"卤族",
      u8"卤水",
      u8"卤汁",
      u8"卤湖",
      u8"卤碱",
      u8"卤簿",
      u8"卤素",
      u8"卤素灯",
      u8"卤肉",
      u8"卤肉饭",
      u8"卤莽",
      u8"卤莽灭裂",
      u8"卤菜",
      u8"卤虾",
      u8"卤蛋",
      u8"卤质",
      u8"卤钝",
      u8"卤钨灯",
      u8"卤面",
      u8"卤鸡",
      u8"卤鸡肉",
      u8"卤鸭",
      u8"卦上",
      u8"卦书",
      u8"卦千纸",
      u8"卦意",
      u8"卦爻",
      u8"卦象",
      u8"卦辞",
      u8"卧下",
      u8"卧下去",
      u8"卧下来",
      u8"卧不安席",
      u8"卧不安枕",
      u8"卧倒",
      u8"卧倒在地",
      u8"卧具",
      u8"卧在",
      u8"卧城",
      u8"卧姿",
      u8"卧室",
      u8"卧室家具",
      u8"卧射",
      u8"卧床",
      u8"卧床不起",
      u8"卧底",
      u8"卧式",
      u8"卧得",
      u8"卧房",
      u8"卧旗息鼓",
      u8"卧柜",
      u8"卧榻",
      u8"卧榻之上",
      u8"卧榻之上岂容他人鼾睡",
      u8"卧榻之旁岂容他人鼾睡",
      u8"卧榻鼾睡",
      u8"卧槽",
      u8"卧槽马",
      u8"卧游",
      u8"卧病",
      u8"卧病在床",
      u8"卧着",
      u8"卧舱",
      u8"卧薪嚐胆",
      u8"卧薪尝胆",
      u8"卧虎居",
      u8"卧虎山",
      u8"卧虎藏龙",
      u8"卧谈",
      u8"卧车",
      u8"卧轨",
      u8"卧轨自杀",
      u8"卧铺",
      u8"卧铺票",
      u8"卧铺车",
      u8"卧雪眠霜",
      u8"卧龙",
      u8"卧龙区",
      u8"卧龙岗",
      u8"卧龙生",
      u8"卫东区",
      u8"卫从",
      u8"卫兵",
      u8"卫冕",
      u8"卫冕冠军",
      u8"卫冕赛",
      u8"卫勤",
      u8"卫周祚",
      u8"卫四娘",
      u8"卫国",
      u8"卫国保家",
      u8"卫国先锋连",
      u8"卫国干城",
      u8"卫国战争",
      u8"卫士",
      u8"卫天望",
      u8"卫子夫",
      u8"卫慧",
      u8"卫戊部队",
      u8"卫戌",
      u8"卫戍",
      u8"卫戍区",
      u8"卫戍司令",
      u8"卫戍部队",
      u8"卫所",
      u8"卫护",
      u8"卫教",
      u8"卫教系",
      u8"卫斯理",
      u8"卫斯里",
      u8"卫星",
      u8"卫星侦察",
      u8"卫星国",
      u8"卫星地面战",
      u8"卫星地面站",
      u8"卫星城",
      u8"卫星城镇",
      u8"卫星天线",
      u8"卫星工业",
      u8"卫星平台",
      u8"卫星广播",
      u8"卫星影象",
      u8"卫星电视",
      u8"卫星电话",
      u8"卫星网络",
      u8"卫星舱",
      u8"卫星象片",
      u8"卫星转播",
      u8"卫星通信",
      u8"卫星通信地面站",
      u8"卫星遥感接收站",
      u8"卫星频道",
      u8"卫春华",
      u8"卫校",
      u8"卫浴",
      u8"卫浴设备",
      u8"卫浴间",
      u8"卫滨区",
      u8"卫理",
      u8"卫璧",
      u8"卫生",
      u8"卫生丸",
      u8"卫生习惯",
      u8"卫生事业",
      u8"卫生事件",
      u8"卫生保健",
      u8"卫生动员",
      u8"卫生勤务",
      u8"卫生厅",
      u8"卫生司",
      u8"卫生员",
      u8"卫生城",
      u8"卫生城市",
      u8"卫生处",
      u8"卫生大队",
      u8"卫生学",
      u8"卫生学家",
      u8"卫生学校",
      u8"卫生室",
      u8"卫生局",
      u8"卫生工作者",
      u8"卫生巾",
      u8"卫生带",
      u8"卫生性",
      u8"卫生所",
      u8"卫生指标",
      u8"卫生日",
      u8"卫生机关",
      u8"卫生机构",
      u8"卫生条件",
      u8"卫生标准",
      u8"卫生桥",
      u8"卫生桥体",
      u8"卫生棉",
      u8"卫生死角",
      u8"卫生法",
      u8"卫生洁具",
      u8"卫生状况",
      u8"卫生球",
      u8"卫生用品",
      u8"卫生科",
      u8"卫生站",
      u8"卫生系统",
      u8"卫生纸",
      u8"卫生组织",
      u8"卫生统计",
      u8"卫生网",
      u8"卫生署",
      u8"卫生衣",
      u8"卫生裤",
      u8"卫生设备",
      u8"卫生设施",
      u8"卫生费",
      u8"卫生部",
      u8"卫生部部长",
      u8"卫生部长",
      u8"卫生部门",
      u8"卫生镇",
      u8"卫生间",
      u8"卫生队",
      u8"卫生防护",
      u8"卫生防疫",
      u8"卫生院",
      u8"卫生陶瓷",
      u8"卫生领域",
      u8"卫生香",
      u8"卫留成",
      u8"卫矛",
      u8"卫立煌",
      u8"卫紫衣",
      u8"卫视",
      u8"卫辉",
      u8"卫辉市",
      u8"卫道",
      u8"卫道之士",
      u8"卫道士",
      u8"卫队",
      u8"卫队长",
      u8"卫青",
      u8"卬头阔步",
      u8"卬首信眉",
      u8"卯上",
      u8"卯兔",
      u8"卯时",
      u8"卯是卯",
      u8"卯榫",
      u8"卯眼",
      u8"卯起",
      u8"卯起来",
      u8"卯足",
      u8"卯足了劲",
      u8"印上",
      u8"印上去",
      u8"印上来",
      u8"印下",
      u8"印下去",
      u8"印下来",
      u8"印不出",
      u8"印不到",
      u8"印业",
      u8"印书",
      u8"印书馆",
      u8"印人",
      u8"印作",
      u8"印信",
      u8"印像",
      u8"印像坊",
      u8"印共",
      u8"印写机",
      u8"印出",
      u8"印出去",
      u8"印出来",
      u8"印到",
      u8"印制",
      u8"印制板",
      u8"印制法",
      u8"印制电路",
      u8"印刷",
      u8"印刷业",
      u8"印刷业者",
      u8"印刷人",
      u8"印刷体",
      u8"印刷厂",
      u8"印刷品",
      u8"印刷工",
      u8"印刷所",
      u8"印刷技术",
      u8"印刷术",
      u8"印刷机",
      u8"印刷版",
      u8"印刷电路",
      u8"印刷纸",
      u8"印刷网",
      u8"印刷错误",
      u8"印加",
      u8"印加帝国",
      u8"印务",
      u8"印卡机",
      u8"印印",
      u8"印压",
      u8"印发",
      u8"印台",
      u8"印台区",
      u8"印售",
      u8"印地安",
      u8"印地安人",
      u8"印地安纳",
      u8"印地安纳大学",
      u8"印地安纳州",
      u8"印地安话",
      u8"印堂",
      u8"印堂发黑",
      u8"印墨",
      u8"印好",
      u8"印子",
      u8"印子钱",
      u8"印字",
      u8"印字机",
      u8"印尼",
      u8"印尼人",
      u8"印尼盾",
      u8"印尼队",
      u8"印度",
      u8"印度人",
      u8"印度半岛",
      u8"印度大平",
      u8"印度大平原",
      u8"印度尼西亚",
      u8"印度尼西亚盾",
      u8"印度支那",
      u8"印度教",
      u8"印度斯坦",
      u8"印度洋",
      u8"印度谷螟",
      u8"印度象",
      u8"印度豹",
      u8"印度鳄",
      u8"印张",
      u8"印影件",
      u8"印得",
      u8"印成",
      u8"印把子",
      u8"印支",
      u8"印数",
      u8"印方",
      u8"印有",
      u8"印本",
      u8"印机",
      u8"印来印去",
      u8"印染",
      u8"印染助剂",
      u8"印染厂",
      u8"印染布",
      u8"印染机械",
      u8"印模",
      u8"印模托盘",
      u8"印模材料",
      u8"印模石膏",
      u8"印模糊剂",
      u8"印模膏",
      u8"印模面",
      u8"印次",
      u8"印欧",
      u8"印欧语",
      u8"印江",
      u8"印江土家族苗族自治县",
      u8"印油",
      u8"印泥",
      u8"印满",
      u8"印版",
      u8"印玺",
      u8"印痕",
      u8"印盒",
      u8"印相纸",
      u8"印着",
      u8"印章",
      u8"印章学",
      u8"印章机",
      u8"印第安",
      u8"印第安人",
      u8"印第安纳",
      u8"印第安纳州",
      u8"印累绶若",
      u8"印累绶苦",
      u8"印纸",
      u8"印纹",
      u8"印纽",
      u8"印经院",
      u8"印绶",
      u8"印色",
      u8"印花",
      u8"印花厂",
      u8"印花布",
      u8"印花机",
      u8"印花税",
      u8"印花纸",
      u8"印行",
      u8"印表",
      u8"印表机",
      u8"印记",
      u8"印证",
      u8"印谱",
      u8"印象",
      u8"印象中",
      u8"印象主义",
      u8"印象形成",
      u8"印象法",
      u8"印象派",
      u8"印质明",
      u8"印起",
      u8"印起来",
      u8"印过",
      u8"印过去",
      u8"印过来",
      u8"印迹",
      u8"印迹杂交",
      u8"印鉴",
      u8"印钞机",
      u8"印错",
      u8"印防已毒素",
      u8"印顺",
      u8"印鼻",
      u8"危乎",
      u8"危于累卵",
      u8"危亡",
      u8"危亡之秋",
      u8"危亡之际",
      u8"危厄",
      u8"危及",
      u8"危在旦夕",
      u8"危地马拉",
      u8"危城",
      u8"危境",
      u8"危墙",
      u8"危壁",
      u8"危如",
      u8"危如朝露",
      u8"危如累卵",
      u8"危室",
      u8"危害",
      u8"危害不大",
      u8"危害别人",
      u8"危害到",
      u8"危害国家安全罪",
      u8"危害性",
      u8"危害社会治安",
      u8"危害程度预测",
      u8"危害面",
      u8"危局",
      u8"危崖",
      u8"危急",
      u8"危急关头",
      u8"危急存亡",
      u8"危急存亡之秋",
      u8"危急性",
      u8"危急情况",
      u8"危惧",
      u8"危懿",
      u8"危房",
      u8"危房改造",
      u8"危改",
      u8"危旧房",
      u8"危旧房屋",
      u8"危机",
      u8"危机四伏",
      u8"危机意识",
      u8"危机感",
      u8"危机重重",
      u8"危楼",
      u8"危殆",
      u8"危疑",
      u8"危禁品",
      u8"危笃",
      u8"危而不持",
      u8"危若",
      u8"危若朝露",
      u8"危若累卵",
      u8"危言",
      u8"危言危行",
      u8"危言核论",
      u8"危言正色",
      u8"危言竦论",
      u8"危言耸听",
      u8"危言覈论",
      u8"危言逆耳",
      u8"危言高论",
      u8"危语",
      u8"危象",
      u8"危辞耸听",
      u8"危迫利诱",
      u8"危途",
      u8"危重",
      u8"危重病",
      u8"危重症",
      u8"危陋平房",
      u8"危险",
      u8"危险区",
      u8"危险区划分",
      u8"危险品",
      u8"危险地",
      u8"危险废物",
      u8"危险性",
      u8"危险期",
      u8"危险源",
      u8"危险点",
      u8"危险物",
      u8"危险物品",
      u8"危难",
      u8"危难见真情",
      u8"即为",
      u8"即事穷理",
      u8"即今",
      u8"即从",
      u8"即令",
      u8"即令是",
      u8"即以其人之道",
      u8"即以其人之道还治其人之身",
      u8"即位",
      u8"即使",
      u8"即使如此",
      u8"即使是",
      u8"即便",
      u8"即便如此",
      u8"即便是",
      u8"即候",
      u8"即兴",
      u8"即兴之作",
      u8"即兴曲",
      u8"即兴诗",
      u8"即刻",
      u8"即刻义齿",
      u8"即刻起",
      u8"即化",
      u8"即可",
      u8"即可以",
      u8"即告",
      u8"即在",
      u8"即墨",
      u8"即墨县",
      u8"即墨市",
      u8"即夜",
      u8"即好",
      u8"即如",
      u8"即对",
      u8"即将",
      u8"即将来临",
      u8"即小见大",
      u8"即属",
      u8"即已",
      u8"即席",
      u8"即席演讲",
      u8"即席讲演",
      u8"即度",
      u8"即成",
      u8"即或",
      u8"即打即现",
      u8"即把",
      u8"即指",
      u8"即按",
      u8"即插即用",
      u8"即日",
      u8"即日起",
      u8"即早",
      u8"即时",
      u8"即时战略",
      u8"即时新闻",
      u8"即时比分",
      u8"即时消息",
      u8"即时清结",
      u8"即时联想",
      u8"即时贴",
      u8"即时运算",
      u8"即时通",
      u8"即时通讯",
      u8"即是",
      u8"即是色",
      u8"即景",
      u8"即景生情",
      u8"即有",
      u8"即期",
      u8"即期支票",
      u8"即欧",
      u8"即死",
      u8"即温听厉",
      u8"即物穷理",
      u8"即用",
      u8"即由",
      u8"即纳",
      u8"即能",
      u8"即若",
      u8"即行",
      u8"即被",
      u8"即要",
      u8"即达",
      u8"即逝",
      u8"即速",
      u8"即那",
      u8"即食",
      u8"即鹿无虞",
      u8"却不",
      u8"却不会",
      u8"却不是",
      u8"却不曾",
      u8"却不知",
      u8"却不能",
      u8"却与",
      u8"却为",
      u8"却之不恭",
      u8"却也",
      u8"却从",
      u8"却会",
      u8"却像",
      u8"却再",
      u8"却又",
      u8"却只",
      u8"却可",
      u8"却向",
      u8"却回去",
      u8"却回来",
      u8"却因",
      u8"却在",
      u8"却对",
      u8"却已",
      u8"却很",
      u8"却把",
      u8"却敌",
      u8"却是",
      u8"却更",
      u8"却有",
      u8"却步",
      u8"却没",
      u8"却没有",
      u8"却没能",
      u8"却由",
      u8"却病延年",
      u8"却给",
      u8"却老还童",
      u8"却能",
      u8"却行求前",
      u8"却被",
      u8"却要",
      u8"却见",
      u8"却让",
      u8"却说",
      u8"却道",
      u8"却都",
      u8"却金暮夜",
      u8"卵与石斗",
      u8"卵原细胞",
      u8"卵圆孔注射法",
      u8"卵圆形",
      u8"卵块",
      u8"卵块发育",
      u8"卵壳",
      u8"卵壳蛋白",
      u8"卵子",
      u8"卵孢子",
      u8"卵寄生物",
      u8"卵巢",
      u8"卵巢功能",
      u8"卵巢囊肿",
      u8"卵巢癌",
      u8"卵式生殖",
      u8"卵形",
      u8"卵形瓶",
      u8"卵形面",
      u8"卵核",
      u8"卵核分裂",
      u8"卵母细胞",
      u8"卵泡",
      u8"卵生",
      u8"卵用鸡",
      u8"卵白",
      u8"卵石",
      u8"卵石不敌",
      u8"卵磷脂",
      u8"卵管",
      u8"卵类粘蛋白",
      u8"卵粘蛋白",
      u8"卵细胞",
      u8"卵翼",
      u8"卵翼之下",
      u8"卵胎生",
      u8"卵膜",
      u8"卵蛋",
      u8"卵裂",
      u8"卵覆鸟飞",
      u8"卵质",
      u8"卵配子",
      u8"卵鞘蛋白",
      u8"卵黄",
      u8"卵黄生成",
      u8"卵黄生成素",
      u8"卵黄磷肽",
      u8"卵黄磷蛋白",
      u8"卵黄类粘蛋白",
      u8"卵黄脂磷蛋白",
      u8"卵黄蛋白",
      u8"卵黄高磷蛋白",
      u8"卷丹",
      u8"卷云",
      u8"卷住",
      u8"卷儿",
      u8"卷入",
      u8"卷入漩涡",
      u8"卷入纠纷",
      u8"卷内",
      u8"卷册",
      u8"卷动",
      u8"卷动门",
      u8"卷去",
      u8"卷发",
      u8"卷发器",
      u8"卷发夹",
      u8"卷取",
      u8"卷叶虫",
      u8"卷叶蛾",
      u8"卷商",
      u8"卷回恢复",
      u8"卷图",
      u8"卷土重来",
      u8"卷士重来",
      u8"卷大",
      u8"卷子",
      u8"卷子本",
      u8"卷宗",
      u8"卷尺",
      u8"卷尾猴",
      u8"卷层云",
      u8"卷帘",
      u8"卷帘格",
      u8"卷帘门",
      u8"卷帙",
      u8"卷帙浩繁",
      u8"卷席而居",
      u8"卷席而葬",
      u8"卷库",
      u8"卷心菜",
      u8"卷成",
      u8"卷扬",
      u8"卷扬机",
      u8"卷收",
      u8"卷族",
      u8"卷旗息鼓",
      u8"卷曲",
      u8"卷曲度",
      u8"卷曲螺旋",
      u8"卷曲霉素",
      u8"卷杀",
      u8"卷材",
      u8"卷来",
      u8"卷来卷去",
      u8"卷板机",
      u8"卷柏",
      u8"卷染",
      u8"卷款逃走",
      u8"卷毛",
      u8"卷烟",
      u8"卷烟厂",
      u8"卷烟机",
      u8"卷烟盒",
      u8"卷烟纸",
      u8"卷甲倍道",
      u8"卷甲束兵",
      u8"卷甲衔枚",
      u8"卷甲韬戈",
      u8"卷积",
      u8"卷积下确界",
      u8"卷积云",
      u8"卷积定理",
      u8"卷积码",
      u8"卷笔刀",
      u8"卷筒",
      u8"卷筒纸",
      u8"卷紧",
      u8"卷纬",
      u8"卷纸",
      u8"卷绕",
      u8"卷缠",
      u8"卷缩",
      u8"卷缩发",
      u8"卷舌",
      u8"卷舌元音",
      u8"卷舌音",
      u8"卷舒",
      u8"卷菸",
      u8"卷袖",
      u8"卷装",
      u8"卷走",
      u8"卷起",
      u8"卷起来",
      u8"卷轴",
      u8"卷轴式",
      u8"卷轴架",
      u8"卷轴装",
      u8"卷过",
      u8"卷进",
      u8"卷逃",
      u8"卷铺盖",
      u8"卷闸门",
      u8"卷面",
      u8"卷须",
      u8"卷领",
      u8"卷风",
      u8"卷首语",
      u8"卸下",
      u8"卸下去",
      u8"卸下来",
      u8"卸了",
      u8"卸任",
      u8"卸入",
      u8"卸到",
      u8"卸包狱",
      u8"卸包袱",
      u8"卸去",
      u8"卸在",
      u8"卸好",
      u8"卸妆",
      u8"卸妆乳",
      u8"卸妆品",
      u8"卸妆水",
      u8"卸妆油",
      u8"卸妆液",
      u8"卸完",
      u8"卸得",
      u8"卸成",
      u8"卸掉",
      u8"卸料",
      u8"卸法",
      u8"卸甲",
      u8"卸甲庄",
      u8"卸甲归田",
      u8"卸磨杀驴",
      u8"卸职",
      u8"卸肩",
      u8"卸船",
      u8"卸荷",
      u8"卸装",
      u8"卸装法",
      u8"卸责",
      u8"卸责任",
      u8"卸货",
      u8"卸货口岸",
      u8"卸货机",
      u8"卸货间",
      u8"卸车",
      u8"卸载",
      u8"卸载掉",
      u8"卸过",
      u8"卸过去",
      u8"卸过来",
      u8"卸进",
      u8"卸进去",
      u8"卸进来",
      u8"卸除",
      u8"卸除负荷",
      u8"卸鞍",
      u8"卿卿",
      u8"卿卿我我",
      u8"卿士",
      u8"卿大夫",
      u8"卿家",
      u8"卿本佳人",
      u8"卿相",
      u8"厂主",
      u8"厂休",
      u8"厂内",
      u8"厂办",
      u8"厂务",
      u8"厂区",
      u8"厂医",
      u8"厂史",
      u8"厂名",
      u8"厂商",
      u8"厂商稿",
      u8"厂地",
      u8"厂场",
      u8"厂址",
      u8"厂外",
      u8"厂子",
      u8"厂家",
      u8"厂家直销",
      u8"厂庆",
      u8"厂房",
      u8"厂房信息",
      u8"厂房设备",
      u8"厂方",
      u8"厂方直销",
      u8"厂校挂钩",
      u8"厂桥",
      u8"厂棚",
      u8"厂牌",
      u8"厂用电",
      u8"厂甸",
      u8"厂矿",
      u8"厂矿企业",
      u8"厂税",
      u8"厂籍",
      u8"厂级",
      u8"厂纪",
      u8"厂规",
      u8"厂部",
      u8"厂里",
      u8"厂长",
      u8"厂长负责",
      u8"厂长负责制",
      u8"厄境",
      u8"厄尔尼诺",
      u8"厄特沃什效应",
      u8"厄瓜多尔",
      u8"厄立特里亚",
      u8"厄米算符",
      u8"厄运",
      u8"厄难",
      u8"厅事",
      u8"厅堂",
      u8"厅子",
      u8"厅局",
      u8"厅局级",
      u8"厅局长",
      u8"厅属",
      u8"厅房",
      u8"厅级",
      u8"厅舍",
      u8"厅里",
      u8"厅长",
      u8"历下区",
      u8"历世摩钝",
      u8"历世磨钝",
      u8"历久",
      u8"历久不衰",
      u8"历久常新",
      u8"历久弥坚",
      u8"历久弥新",
      u8"历书",
      u8"历井扪天",
      u8"历代",
      u8"历代先皇",
      u8"历代帝王",
      u8"历代祖先",
      u8"历代记",
      u8"历任",
      u8"历兵秣马",
      u8"历兵粟马",
      u8"历劫",
      u8"历劫归来",
      u8"历历",
      u8"历历可数",
      u8"历历可考",
      u8"历历可见",
      u8"历历可辨",
      u8"历历在目",
      u8"历历在耳",
      u8"历历如画",
      u8"历史",
      u8"历史上",
      u8"历史主义",
      u8"历史书",
      u8"历史书籍",
      u8"历史事件",
      u8"历史事实",
      u8"历史人文地理",
      u8"历史人物",
      u8"历史作用",
      u8"历史使命",
      u8"历史使命感",
      u8"历史关头",
      u8"历史剧",
      u8"历史博物馆",
      u8"历史古迹区",
      u8"历史名人",
      u8"历史唯心主义",
      u8"历史唯物主义",
      u8"历史地",
      u8"历史地图集",
      u8"历史地理学",
      u8"历史学",
      u8"历史学家",
      u8"历史学者",
      u8"历史小说",
      u8"历史建筑",
      u8"历史性",
      u8"历史悠久",
      u8"历史意义",
      u8"历史感",
      u8"历史拟合",
      u8"历史教案",
      u8"历史教训",
      u8"历史数据",
      u8"历史文化",
      u8"历史文化背景",
      u8"历史文物",
      u8"历史文献",
      u8"历史文章",
      u8"历史时期",
      u8"历史最高水平",
      u8"历史条件",
      u8"历史档案",
      u8"历史气候",
      u8"历史沿革",
      u8"历史渊源",
      u8"历史潮流",
      u8"历史状况",
      u8"历史瞬间",
      u8"历史知识",
      u8"历史研究",
      u8"历史系",
      u8"历史纪录",
      u8"历史经验",
      u8"历史背景",
      u8"历史自然地理",
      u8"历史舞台",
      u8"历史观",
      u8"历史记录",
      u8"历史论文",
      u8"历史试题",
      u8"历史课",
      u8"历史责任",
      u8"历史进程",
      u8"历史长河",
      u8"历史问题",
      u8"历史阶段",
      u8"历史风云",
      u8"历史风貌",
      u8"历城区",
      u8"历声",
      u8"历害",
      u8"历尽",
      u8"历尽沧桑",
      u8"历尽磨难",
      u8"历尽艰辛",
      u8"历尽艰难",
      u8"历届",
      u8"历山",
      u8"历年",
      u8"历年来",
      u8"历年试题",
      u8"历扼",
      u8"历数",
      u8"历日旷久",
      u8"历时",
      u8"历月",
      u8"历朝",
      u8"历朝历代",
      u8"历本",
      u8"历来",
      u8"历来如此",
      u8"历次",
      u8"历法",
      u8"历程",
      u8"历算论点",
      u8"历精为治",
      u8"历精图治",
      u8"历精更始",
      u8"历练",
      u8"历练老成",
      u8"历经",
      u8"历经沧桑",
      u8"历览",
      u8"历访",
      u8"历陈",
      u8"历险",
      u8"历险地",
      u8"历险归来",
      u8"历险记",
      u8"厉世摩钝",
      u8"厉兑",
      u8"厉兵秣马",
      u8"厉兵粟马",
      u8"厉声",
      u8"厉声厉色",
      u8"厉声叱斥",
      u8"厉害",
      u8"厉庄镇",
      u8"厉建中",
      u8"厉禁",
      u8"厉精图治",
      u8"厉精更始",
      u8"厉色",
      u8"厉行",
      u8"厉行改革",
      u8"厉行节俭",
      u8"厉行节约",
      u8"厉阶",
      u8"厉鬼",
      u8"压下",
      u8"压下去",
      u8"压下来",
      u8"压下量",
      u8"压不住",
      u8"压不碎",
      u8"压井液",
      u8"压井阀",
      u8"压仰",
      u8"压价",
      u8"压低",
      u8"压住",
      u8"压倒",
      u8"压倒一切",
      u8"压倒优势",
      u8"压倒元白",
      u8"压倒多数",
      u8"压倒性",
      u8"压倒性多数",
      u8"压倒群雄",
      u8"压光",
      u8"压光机",
      u8"压克力",
      u8"压克力板",
      u8"压出",
      u8"压出去",
      u8"压出来",
      u8"压分",
      u8"压到",
      u8"压制",
      u8"压制住",
      u8"压制性",
      u8"压制版",
      u8"压制群众",
      u8"压力",
      u8"压力仪表",
      u8"压力传感器",
      u8"压力变送器",
      u8"压力壳",
      u8"压力大",
      u8"压力容器",
      u8"压力强度",
      u8"压力感",
      u8"压力机",
      u8"压力梯度",
      u8"压力表",
      u8"压力计",
      u8"压力跃变",
      u8"压力锅",
      u8"压力降",
      u8"压力降落法试井",
      u8"压匀",
      u8"压印",
      u8"压卷",
      u8"压卷之作",
      u8"压压",
      u8"压台",
      u8"压台戏",
      u8"压回",
      u8"压回去",
      u8"压回来",
      u8"压圈",
      u8"压土机",
      u8"压在",
      u8"压在心底",
      u8"压场",
      u8"压场戏",
      u8"压坏",
      u8"压型制品",
      u8"压型板",
      u8"压垮",
      u8"压境",
      u8"压够",
      u8"压头",
      u8"压好",
      u8"压完",
      u8"压宝",
      u8"压实校正",
      u8"压寨",
      u8"压寨夫人",
      u8"压岁",
      u8"压岁钱",
      u8"压带",
      u8"压平",
      u8"压库",
      u8"压底",
      u8"压延",
      u8"压延性",
      u8"压延机",
      u8"压弯",
      u8"压强",
      u8"压强计",
      u8"压得",
      u8"压惊",
      u8"压扁",
      u8"压扭作用",
      u8"压抑",
      u8"压抑感",
      u8"压抑着",
      u8"压担子",
      u8"压挤",
      u8"压控振荡器",
      u8"压敏电阻",
      u8"压敏粘合",
      u8"压敏胶",
      u8"压服",
      u8"压机",
      u8"压条",
      u8"压条法",
      u8"压条繁殖",
      u8"压板",
      u8"压枝",
      u8"压根",
      u8"压根儿",
      u8"压案不查",
      u8"压榨",
      u8"压榨器",
      u8"压榨机",
      u8"压气",
      u8"压港",
      u8"压滤",
      u8"压滤机",
      u8"压片",
      u8"压片机",
      u8"压电",
      u8"压电体",
      u8"压电式",
      u8"压电性",
      u8"压电效应",
      u8"压痕",
      u8"压痕机",
      u8"压痕硬度",
      u8"压痛",
      u8"压盖",
      u8"压盘石",
      u8"压直",
      u8"压着",
      u8"压砖机",
      u8"压破",
      u8"压碎",
      u8"压碟",
      u8"压秤",
      u8"压箱底",
      u8"压簧",
      u8"压紧",
      u8"压线",
      u8"压缩",
      u8"压缩冲量",
      u8"压缩力",
      u8"压缩功",
      u8"压缩包",
      u8"压缩卡",
      u8"压缩器",
      u8"压缩因子图",
      u8"压缩工具",
      u8"压缩性",
      u8"压缩成",
      u8"压缩文件",
      u8"压缩机",
      u8"压缩比",
      u8"压缩氧",
      u8"压缩版",
      u8"压缩率",
      u8"压缩盘",
      u8"压缩空气",
      u8"压缩系数",
      u8"压缩软件",
      u8"压缩饼干",
      u8"压群芳",
      u8"压而不服",
      u8"压肩叠背",
      u8"压肩迭背",
      u8"压脚",
      u8"压腿",
      u8"压舌板",
      u8"压舱物",
      u8"压船",
      u8"压良为贱",
      u8"压花",
      u8"压花机",
      u8"压花玻璃",
      u8"压藤",
      u8"压裂液利用效率",
      u8"压裂液滤失性",
      u8"压裂液降滤失剂",
      u8"压裂混砂机",
      u8"压裂管柱",
      u8"压裂车",
      u8"压觉适应",
      u8"压账",
      u8"压货",
      u8"压起",
      u8"压起来",
      u8"压路",
      u8"压路机",
      u8"压轴",
      u8"压轴好戏",
      u8"压轴子",
      u8"压轴戏",
      u8"压边",
      u8"压过",
      u8"压近",
      u8"压进",
      u8"压进去",
      u8"压进来",
      u8"压迫",
      u8"压迫感",
      u8"压迫者",
      u8"压逼",
      u8"压铸",
      u8"压铸件",
      u8"压铸厂",
      u8"压铸机",
      u8"压铸模",
      u8"压锭",
      u8"压阑石",
      u8"压队",
      u8"压阵",
      u8"压雪求油",
      u8"压韵",
      u8"压顶",
      u8"压题",
      u8"压马路",
      u8"压齐",
      u8"厌世",
      u8"厌倦",
      u8"厌倦感",
      u8"厌厌",
      u8"厌吃",
      u8"厌学",
      u8"厌弃",
      u8"厌恨",
      u8"厌恶",
      u8"厌恶感",
      u8"厌恶疗法",
      u8"厌憎",
      u8"厌战",
      u8"厌战心理",
      u8"厌战情绪",
      u8"厌故喜新",
      u8"厌旧喜新",
      u8"厌氧发酵",
      u8"厌氧微生物",
      u8"厌氧胶",
      u8"厌氧菌",
      u8"厌烦",
      u8"厌物病",
      u8"厌腻",
      u8"厌足",
      u8"厌闻饫听",
      u8"厌难折冲",
      u8"厌食",
      u8"厌食症",
      u8"厕坑",
      u8"厕所",
      u8"厕所间",
      u8"厕足其间",
      u8"厕身",
      u8"厕身其间",
      u8"厘出",
      u8"厘升",
      u8"厘定",
      u8"厘摩",
      u8"厘正",
      u8"厘清",
      u8"厘米",
      u8"厘米波",
      u8"厘订",
      u8"厘金",
      u8"厚人薄己",
      u8"厚今薄古",
      u8"厚利",
      u8"厚到",
      u8"厚厚",
      u8"厚厚的",
      u8"厚古薄今",
      u8"厚味",
      u8"厚味腊毒",
      u8"厚嘴唇",
      u8"厚墩墩",
      u8"厚壁孢子",
      u8"厚壁组织",
      u8"厚大",
      u8"厚实",
      u8"厚实实",
      u8"厚层压板",
      u8"厚己薄人",
      u8"厚度",
      u8"厚彼薄此",
      u8"厚往薄来",
      u8"厚待",
      u8"厚得",
      u8"厚德",
      u8"厚德国小",
      u8"厚德载物",
      u8"厚德载福",
      u8"厚恩",
      u8"厚意",
      u8"厚望",
      u8"厚朴",
      u8"厚朴花",
      u8"厚板",
      u8"厚植国力",
      u8"厚此薄彼",
      u8"厚泽",
      u8"厚漆",
      u8"厚点",
      u8"厚爱",
      u8"厚片",
      u8"厚生",
      u8"厚生利用",
      u8"厚用",
      u8"厚电",
      u8"厚着",
      u8"厚着脸皮",
      u8"厚礼",
      u8"厚禄",
      u8"厚禄高官",
      u8"厚福",
      u8"厚积薄发",
      u8"厚粉",
      u8"厚纸",
      u8"厚纸板",
      u8"厚脸",
      u8"厚脸皮",
      u8"厚腻",
      u8"厚茧",
      u8"厚茸茸",
      u8"厚葬",
      u8"厚薄",
      u8"厚薄规",
      u8"厚薪",
      u8"厚街镇",
      u8"厚角组织",
      u8"厚谊",
      u8"厚谢",
      u8"厚貌深情",
      u8"厚貌深文",
      u8"厚貌深辞",
      u8"厚赐",
      u8"厚起来",
      u8"厚软",
      u8"厚透镜",
      u8"厚遇",
      u8"厚道",
      u8"厚重",
      u8"厚重感",
      u8"厚非",
      u8"厚颜",
      u8"厚颜无耻",
      u8"厚黑学",
      u8"厝火燎原",
      u8"厝火积薪",
      u8"原为",
      u8"原主",
      u8"原义",
      u8"原书名",
      u8"原于",
      u8"原交",
      u8"原产",
      u8"原产地",
      u8"原产物",
      u8"原人",
      u8"原从",
      u8"原代",
      u8"原代码",
      u8"原以",
      u8"原以为",
      u8"原件",
      u8"原价",
      u8"原任",
      u8"原位",
      u8"原位分子杂交",
      u8"原位杂交",
      u8"原位预处理",
      u8"原住民",
      u8"原体",
      u8"原作",
      u8"原作者",
      u8"原值",
      u8"原先",
      u8"原先是",
      u8"原函数",
      u8"原则",
      u8"原则上",
      u8"原则同意",
      u8"原则性",
      u8"原则立场",
      u8"原则通过",
      u8"原则问题",
      u8"原创",
      u8"原初",
      u8"原判",
      u8"原动力",
      u8"原动机",
      u8"原华",
      u8"原单位",
      u8"原原委委",
      u8"原原本本",
      u8"原发性",
      u8"原发性牙本质",
      u8"原史奈",
      u8"原叶体",
      u8"原名",
      u8"原告",
      u8"原告人",
      u8"原告席",
      u8"原告方",
      u8"原唱",
      u8"原唱者",
      u8"原因",
      u8"原因无他",
      u8"原因是",
      u8"原图",
      u8"原图片",
      u8"原在",
      u8"原地",
      u8"原地不动",
      u8"原地保存",
      u8"原地区",
      u8"原地待命",
      u8"原地成酸体系",
      u8"原地打转",
      u8"原地踏步",
      u8"原址",
      u8"原型",
      u8"原型工业化",
      u8"原型机",
      u8"原型滤波器",
      u8"原型说",
      u8"原型车",
      u8"原基",
      u8"原声",
      u8"原声带",
      u8"原声集",
      u8"原处",
      u8"原大",
      u8"原始",
      u8"原始人",
      u8"原始公社",
      u8"原始公社制度",
      u8"原始农业",
      u8"原始凭证",
      u8"原始动物",
      u8"原始反终",
      u8"原始大洋裂谷盆地",
      u8"原始思维",
      u8"原始数据",
      u8"原始时代",
      u8"原始林",
      u8"原始森林",
      u8"原始环境系统",
      u8"原始社会",
      u8"原始积累",
      u8"原始群",
      u8"原始股",
      u8"原始舞",
      u8"原始要终",
      u8"原始见终",
      u8"原始规",
      u8"原始记录",
      u8"原始递归式",
      u8"原始部落",
      u8"原委",
      u8"原子",
      u8"原子事件",
      u8"原子价",
      u8"原子光谱",
      u8"原子化效率",
      u8"原子反应",
      u8"原子反应堆",
      u8"原子团",
      u8"原子学",
      u8"原子尘",
      u8"原子序",
      u8"原子序数",
      u8"原子弹",
      u8"原子数",
      u8"原子时代",
      u8"原子束",
      u8"原子极化率",
      u8"原子核",
      u8"原子核反",
      u8"原子核反应堆",
      u8"原子格",
      u8"原子武器",
      u8"原子灰",
      u8"原子炉",
      u8"原子炸弹",
      u8"原子物理",
      u8"原子理论",
      u8"原子笔",
      u8"原子结构",
      u8"原子能",
      u8"原子能反应堆",
      u8"原子能发电",
      u8"原子能委",
      u8"原子能委员会",
      u8"原子能学",
      u8"原子能辐射",
      u8"原子芯",
      u8"原子荧光",
      u8"原子角分布函数",
      u8"原子论",
      u8"原子说",
      u8"原子质量",
      u8"原子轨道",
      u8"原子量",
      u8"原子鏸",
      u8"原子钟",
      u8"原子锅",
      u8"原子频标",
      u8"原定",
      u8"原宜",
      u8"原审",
      u8"原宥",
      u8"原封",
      u8"原封不动",
      u8"原封未动",
      u8"原属",
      u8"原岗",
      u8"原峰村",
      u8"原州区",
      u8"原帖",
      u8"原平",
      u8"原平县",
      u8"原平市",
      u8"原式",
      u8"原形",
      u8"原形毕露",
      u8"原形败露",
      u8"原形质",
      u8"原心定罪",
      u8"原性",
      u8"原意",
      u8"原指",
      u8"原振侠",
      u8"原故",
      u8"原教旨主义",
      u8"原文",
      u8"原文书",
      u8"原文件",
      u8"原料",
      u8"原料及主",
      u8"原料及主要材料",
      u8"原料库",
      u8"原料林",
      u8"原料气压缩机",
      u8"原料油",
      u8"原料药",
      u8"原无",
      u8"原旧",
      u8"原昭",
      u8"原是",
      u8"原曲",
      u8"原有",
      u8"原木",
      u8"原木色",
      u8"原本",
      u8"原本会",
      u8"原本在",
      u8"原本是",
      u8"原本穷末",
      u8"原机",
      u8"原材料",
      u8"原来",
      u8"原来地",
      u8"原来如此",
      u8"原来市场",
      u8"原来是",
      u8"原来爱",
      u8"原样",
      u8"原核细胞",
      u8"原案",
      u8"原棉",
      u8"原款",
      u8"原毛",
      u8"原水",
      u8"原汁",
      u8"原汁原味",
      u8"原油",
      u8"原油乳化降粘剂",
      u8"原油价格",
      u8"原油分析",
      u8"原油地质储量",
      u8"原油抑泡剂",
      u8"原油期货",
      u8"原浆",
      u8"原液",
      u8"原点",
      u8"原煤",
      u8"原版",
      u8"原版书",
      u8"原物",
      u8"原状",
      u8"原班",
      u8"原班人马",
      u8"原球茎",
      u8"原理",
      u8"原理图",
      u8"原理篇",
      u8"原璧归赵",
      u8"原生",
      u8"原生动物",
      u8"原生孔隙",
      u8"原生态",
      u8"原生悬浮物",
      u8"原生晕",
      u8"原生植物",
      u8"原生油气藏",
      u8"原生矿物",
      u8"原生质",
      u8"原用",
      u8"原田",
      u8"原由",
      u8"原由子",
      u8"原电池",
      u8"原画",
      u8"原画集",
      u8"原癌基因",
      u8"原盐",
      u8"原盘",
      u8"原着",
      u8"原着者",
      u8"原知",
      u8"原矿",
      u8"原码",
      u8"原碟",
      u8"原种",
      u8"原种场",
      u8"原程序",
      u8"原税",
      u8"原稿",
      u8"原稿纸",
      u8"原穴",
      u8"原籍",
      u8"原粮",
      u8"原糖",
      u8"原素",
      u8"原纳",
      u8"原线圈",
      u8"原络配穴",
      u8"原罪",
      u8"原职",
      u8"原肠胚",
      u8"原自",
      u8"原色",
      u8"原苏联",
      u8"原著",
      u8"原虫",
      u8"原装",
      u8"原装机",
      u8"原装电话",
      u8"原装货",
      u8"原计划",
      u8"原订",
      u8"原设",
      u8"原证",
      u8"原诉",
      u8"原词",
      u8"原诗",
      u8"原话",
      u8"原语",
      u8"原说话",
      u8"原谅",
      u8"原貌",
      u8"原质",
      u8"原路",
      u8"原载",
      u8"原辅料",
      u8"原配",
      u8"原酒",
      u8"原野",
      u8"原野奇侠",
      u8"原野游侠",
      u8"原队",
      u8"原队人马",
      u8"原阳",
      u8"原阳县",
      u8"原需",
      u8"原音",
      u8"原须",
      u8"原鸽",
      u8"厢式车",
      u8"厢房",
      u8"厢拱",
      u8"厢橱",
      u8"厢间",
      u8"厥为",
      u8"厥功甚伟",
      u8"厥脱",
      u8"厥证",
      u8"厥阴",
      u8"厥阴俞",
      u8"厦中",
      u8"厦华",
      u8"厦华公司",
      u8"厦华过剩",
      u8"厦南",
      u8"厦新",
      u8"厦禾路",
      u8"厦门",
      u8"厦门人",
      u8"厦门大学",
      u8"厦门岛",
      u8"厦门市",
      u8"厦门房产",
      u8"厦门日报",
      u8"厦门航空",
      u8"厨具",
      u8"厨具全",
      u8"厨刀",
      u8"厨园",
      u8"厨娘",
      u8"厨子",
      u8"厨师",
      u8"厨师长",
      u8"厨房",
      u8"厨房家具",
      u8"厨房排烟机",
      u8"厨房用具",
      u8"厨房用品",
      u8"厨房电器",
      u8"厨房设备",
      u8"厨房设施",
      u8"厨房门",
      u8"厨手",
      u8"厨柜",
      u8"厨灶",
      u8"厨神",
      u8"厨艺",
      u8"厩肥",
      u8"厮守",
      u8"厮打",
      u8"厮杀",
      u8"厮混",
      u8"去一趟",
      u8"去不去",
      u8"去不得",
      u8"去不成",
      u8"去世",
      u8"去也",
      u8"去买烟",
      u8"去了",
      u8"去事",
      u8"去交混回响",
      u8"去任",
      u8"去伪存真",
      u8"去住",
      u8"去住两难",
      u8"去信",
      u8"去借",
      u8"去做",
      u8"去偷",
      u8"去冠器",
      u8"去冬",
      u8"去函",
      u8"去到",
      u8"去势",
      u8"去危就安",
      u8"去去",
      u8"去去就来",
      u8"去取",
      u8"去吃",
      u8"去同步化波",
      u8"去向",
      u8"去向不明",
      u8"去吧",
      u8"去吸",
      u8"去呢",
      u8"去国",
      u8"去垢",
      u8"去垢剂",
      u8"去声",
      u8"去壳",
      u8"去处",
      u8"去夏",
      u8"去天尺五",
      u8"去太去甚",
      u8"去头",
      u8"去头去尾",
      u8"去学",
      u8"去官",
      u8"去就",
      u8"去就之分",
      u8"去尾",
      u8"去岁",
      u8"去年",
      u8"去年今天",
      u8"去年初",
      u8"去年同期",
      u8"去年底",
      u8"去年度",
      u8"去年末",
      u8"去年此时",
      u8"去得",
      u8"去思",
      u8"去恶从善",
      u8"去想",
      u8"去意",
      u8"去打",
      u8"去找",
      u8"去拿",
      u8"去拿礼乐",
      u8"去掉",
      u8"去接",
      u8"去故就新",
      u8"去故纳新",
      u8"去救",
      u8"去日",
      u8"去暑",
      u8"去暗投明",
      u8"去末归本",
      u8"去本就末",
      u8"去本趋末",
      u8"去杀胜残",
      u8"去杂去劣",
      u8"去极化",
      u8"去模糊",
      u8"去死",
      u8"去死吧",
      u8"去死皮",
      u8"去汙粉",
      u8"去污",
      u8"去污剂",
      u8"去污力",
      u8"去污粉",
      u8"去污系数",
      u8"去泰去甚",
      u8"去洗",
      u8"去浄",
      u8"去湿机",
      u8"去火",
      u8"去煮",
      u8"去玩",
      u8"去甚去泰",
      u8"去甲肾上腺素",
      u8"去留",
      u8"去病",
      u8"去痛",
      u8"去皮",
      u8"去看",
      u8"去看房",
      u8"去睡",
      u8"去磁",
      u8"去离子作用",
      u8"去离子水",
      u8"去离子甲酰胺",
      u8"去秋",
      u8"去管",
      u8"去粗取精",
      u8"去耦滤波器",
      u8"去职",
      u8"去胶",
      u8"去腥",
      u8"去芜存菁",
      u8"去蔽",
      u8"去蜡",
      u8"去见",
      u8"去角",
      u8"去角质",
      u8"去调节",
      u8"去路",
      u8"去过",
      u8"去远",
      u8"去逛",
      u8"去逝",
      u8"去邪归正",
      u8"去问",
      u8"去闯",
      u8"去除",
      u8"去雄",
      u8"去食存信",
      u8"去骑",
      u8"去鳞",
      u8"县一中",
      u8"县上",
      u8"县乡",
      u8"县乡镇",
      u8"县人大",
      u8"县人委",
      u8"县令",
      u8"县份",
      u8"县公安局",
      u8"县内",
      u8"县办",
      u8"县区",
      u8"县县",
      u8"县名",
      u8"县后",
      u8"县吏",
      u8"县团级",
      u8"县城",
      u8"县域",
      u8"县境",
      u8"县处级",
      u8"县外",
      u8"县太爷",
      u8"县委",
      u8"县委书记",
      u8"县委会",
      u8"县委组织部",
      u8"县学",
      u8"县官",
      u8"县尉",
      u8"县局",
      u8"县属",
      u8"县差",
      u8"县市",
      u8"县市政府",
      u8"县府",
      u8"县志",
      u8"县总工会",
      u8"县情",
      u8"县惑",
      u8"县政",
      u8"县政协",
      u8"县政府",
      u8"县检察院",
      u8"县民",
      u8"县治",
      u8"县法院",
      u8"县狱",
      u8"县界",
      u8"县监狱",
      u8"县直",
      u8"县直机关",
      u8"县知事",
      u8"县立",
      u8"县级",
      u8"县级市",
      u8"县老爷",
      u8"县衙",
      u8"县衙门",
      u8"县议会",
      u8"县议员",
      u8"县辖市",
      u8"县运会",
      u8"县里",
      u8"县镇",
      u8"县长",
      u8"县院",
      u8"参上",
      u8"参不透",
      u8"参与",
      u8"参与制",
      u8"参与感",
      u8"参与者",
      u8"参事",
      u8"参伍错纵",
      u8"参伍错综",
      u8"参众两院",
      u8"参会",
      u8"参会者",
      u8"参佐",
      u8"参军",
      u8"参军入伍",
      u8"参前倚衡",
      u8"参加",
      u8"参加人",
      u8"参加会议",
      u8"参加劳动",
      u8"参加国",
      u8"参加工作",
      u8"参加考试",
      u8"参加者",
      u8"参加锻炼",
      u8"参加革命",
      u8"参加骚动",
      u8"参劾",
      u8"参半",
      u8"参变量",
      u8"参合",
      u8"参商",
      u8"参商之虞",
      u8"参回斗转",
      u8"参堂",
      u8"参天",
      u8"参天两地",
      u8"参天大树",
      u8"参天贰地",
      u8"参奏",
      u8"参将",
      u8"参展",
      u8"参展商",
      u8"参差",
      u8"参差不一",
      u8"参差不齐",
      u8"参差错落",
      u8"参建",
      u8"参悟",
      u8"参战",
      u8"参战国",
      u8"参拜",
      u8"参政",
      u8"参政党",
      u8"参政权",
      u8"参政议政",
      u8"参数",
      u8"参数井",
      u8"参数估计",
      u8"参数块",
      u8"参数检验",
      u8"参数簇",
      u8"参数表",
      u8"参数设置",
      u8"参数集总",
      u8"参杂",
      u8"参校",
      u8"参横斗转",
      u8"参比电极",
      u8"参演",
      u8"参照",
      u8"参照卡",
      u8"参照实行",
      u8"参照物",
      u8"参照系",
      u8"参看",
      u8"参禅",
      u8"参考",
      u8"参考书",
      u8"参考书目",
      u8"参考人",
      u8"参考价",
      u8"参考价值",
      u8"参考价格",
      u8"参考值",
      u8"参考图书馆馆长",
      u8"参考圆",
      u8"参考字",
      u8"参考室",
      u8"参考性",
      u8"参考手册",
      u8"参考报",
      u8"参考文献",
      u8"参考法",
      u8"参考消息",
      u8"参考特藏",
      u8"参考答案",
      u8"参考系",
      u8"参考资料",
      u8"参股",
      u8"参茸",
      u8"参见",
      u8"参见互照",
      u8"参见注",
      u8"参观",
      u8"参观券",
      u8"参观团",
      u8"参观团体",
      u8"参观指导",
      u8"参观票",
      u8"参观者",
      u8"参观记",
      u8"参议",
      u8"参议会",
      u8"参议员",
      u8"参议院",
      u8"参访",
      u8"参评",
      u8"参详",
      u8"参谋",
      u8"参谋军士",
      u8"参谋总部",
      u8"参谋总长",
      u8"参谋部",
      u8"参谋长",
      u8"参谒",
      u8"参赛",
      u8"参赛权",
      u8"参赛者",
      u8"参赛选手",
      u8"参赛队",
      u8"参赞",
      u8"参赞处",
      u8"参辰卯酉",
      u8"参辰日月",
      u8"参选",
      u8"参选人",
      u8"参透",
      u8"参透机关",
      u8"参道",
      u8"参酌",
      u8"参量",
      u8"参量放大器",
      u8"参量混频器",
      u8"参错",
      u8"参阅",
      u8"参院",
      u8"参预",
      u8"又一",
      u8"又一个",
      u8"又一次",
      u8"又上",
      u8"又不",
      u8"又不是",
      u8"又不能",
      u8"又与",
      u8"又为",
      u8"又于",
      u8"又从",
      u8"又以",
      u8"又会",
      u8"又会到",
      u8"又会在",
      u8"又会有",
      u8"又作别论",
      u8"又使",
      u8"又像",
      u8"又再",
      u8"又出",
      u8"又分",
      u8"又创",
      u8"又创新高",
      u8"又到",
      u8"又去",
      u8"又及",
      u8"又叫",
      u8"又可",
      u8"又名",
      u8"又名为",
      u8"又向",
      u8"又吹",
      u8"又和",
      u8"又哭又笑",
      u8"又哭又闹",
      u8"又因",
      u8"又在",
      u8"又坏了",
      u8"又复归于",
      u8"又多",
      u8"又大",
      u8"又如",
      u8"又对",
      u8"又将",
      u8"又岂在朝朝暮暮",
      u8"又带",
      u8"又弱一个",
      u8"又当别论",
      u8"又得",
      u8"又得浮生半日闲",
      u8"又快又好",
      u8"又惊又喜",
      u8"又想",
      u8"又想做婊子",
      u8"又想立牌坊",
      u8"又成",
      u8"又成画饼",
      u8"又打",
      u8"又打又骂",
      u8"又把",
      u8"又拉",
      u8"又按",
      u8"又搞",
      u8"又摇又摆",
      u8"又放",
      u8"又是",
      u8"又曰",
      u8"又有",
      u8"又有何难",
      u8"又来",
      u8"又比",
      u8"又没",
      u8"又没有",
      u8"又爱又怕",
      u8"又生",
      u8"又生一秦",
      u8"又用",
      u8"又称",
      u8"又红又专",
      u8"又经",
      u8"又给",
      u8"又能",
      u8"又能够",
      u8"又臭又长",
      u8"又药",
      u8"又被",
      u8"又要",
      u8"又见",
      u8"又讯",
      u8"又该",
      u8"又说",
      u8"又贵",
      u8"又贵又不饱",
      u8"又走",
      u8"又进",
      u8"又进去",
      u8"又进来",
      u8"又道",
      u8"又都",
      u8"又靠",
      u8"又饥又渴",
      u8"又高又大",
      u8"又黄又瘦",
      u8"叉住",
      u8"叉叉",
      u8"叉号",
      u8"叉子",
      u8"叉形",
      u8"叉手",
      u8"叉架",
      u8"叉烧",
      u8"叉烧包",
      u8"叉烧饭",
      u8"叉腰",
      u8"叉路",
      u8"叉车",
      u8"叉车配件",
      u8"叉齿",
      u8"及于",
      u8"及人",
      u8"及其",
      u8"及冠",
      u8"及宾有鱼",
      u8"及早",
      u8"及早准备",
      u8"及时",
      u8"及时努力",
      u8"及时单纯集",
      u8"及时发现",
      u8"及时处理",
      u8"及时性",
      u8"及时行乐",
      u8"及时雨",
      u8"及期",
      u8"及格",
      u8"及格率",
      u8"及格线",
      u8"及格者",
      u8"及格赛",
      u8"及格边缘",
      u8"及溺呼船",
      u8"及物",
      u8"及物动词",
      u8"及瓜而代",
      u8"及笄",
      u8"及笄年华",
      u8"及第",
      u8"及第成名",
      u8"及耳",
      u8"及至",
      u8"及锋而试",
      u8"及门",
      u8"友人",
      u8"友人网",
      u8"友党",
      u8"友军",
      u8"友协",
      u8"友台",
      u8"友善",
      u8"友坂理惠",
      u8"友好",
      u8"友好人士",
      u8"友好代表",
      u8"友好代表团",
      u8"友好使者",
      u8"友好关系",
      u8"友好区",
      u8"友好合作",
      u8"友好周",
      u8"友好国家",
      u8"友好城市",
      u8"友好度",
      u8"友好往来",
      u8"友好月",
      u8"友好条件",
      u8"友好条约",
      u8"友好用户",
      u8"友好相处",
      u8"友好襄助",
      u8"友好访问",
      u8"友好邻邦",
      u8"友情",
      u8"友情网",
      u8"友情链接",
      u8"友方",
      u8"友朋",
      u8"友机",
      u8"友爱",
      u8"友爱新党",
      u8"友生",
      u8"友矩阵",
      u8"友社区",
      u8"友舰",
      u8"友谊",
      u8"友谊县",
      u8"友谊大学",
      u8"友谊座",
      u8"友谊比赛",
      u8"友谊赛",
      u8"友谊路",
      u8"友邦",
      u8"友邦保险",
      u8"友邻",
      u8"友队",
      u8"友阪理惠",
      u8"友风子雨",
      u8"双三次插值",
      u8"双下巴",
      u8"双下肢",
      u8"双丝弓矫治器",
      u8"双丰",
      u8"双丰收",
      u8"双乳",
      u8"双乳头瓣",
      u8"双二倍体",
      u8"双亡",
      u8"双亲",
      u8"双人",
      u8"双人床",
      u8"双人房",
      u8"双人滑",
      u8"双人舞",
      u8"双人跳",
      u8"双人近景",
      u8"双人间",
      u8"双代会",
      u8"双份",
      u8"双休",
      u8"双休日",
      u8"双优",
      u8"双位数",
      u8"双低型",
      u8"双体船",
      u8"双作用式水力活塞泵",
      u8"双作用抽油泵",
      u8"双作稻",
      u8"双侧平衡",
      u8"双侧约束",
      u8"双保险",
      u8"双修",
      u8"双倍",
      u8"双儿",
      u8"双元",
      u8"双光束",
      u8"双光束分光光度计",
      u8"双全",
      u8"双关",
      u8"双关语",
      u8"双内核",
      u8"双冠王",
      u8"双凤",
      u8"双凫一雁",
      u8"双击",
      u8"双击鼠标",
      u8"双刀",
      u8"双刃",
      u8"双刃剑",
      u8"双分子亲核取代",
      u8"双分子亲电取代",
      u8"双分子还原",
      u8"双分子酸催化烷氧断裂",
      u8"双分子酸催化酰氧断裂",
      u8"双列",
      u8"双列杂交",
      u8"双列直插式封装",
      u8"双制",
      u8"双制式",
      u8"双动",
      u8"双动道岔",
      u8"双包",
      u8"双十",
      u8"双十佳",
      u8"双十协议",
      u8"双十国庆",
      u8"双十节",
      u8"双十革命",
      u8"双千兆",
      u8"双升",
      u8"双博士",
      u8"双卡通",
      u8"双卫",
      u8"双原子分子",
      u8"双双",
      u8"双双对对",
      u8"双可测变换",
      u8"双台子区",
      u8"双叶",
      u8"双叶状种植体",
      u8"双号",
      u8"双号座号",
      u8"双合盛",
      u8"双后腰",
      u8"双向",
      u8"双向二极管",
      u8"双向交流",
      u8"双向交通",
      u8"双向性",
      u8"双向打印",
      u8"双向收费",
      u8"双向晶闸管",
      u8"双向电泳",
      u8"双向选择",
      u8"双向通信",
      u8"双听技术",
      u8"双启动",
      u8"双周",
      u8"双周刊",
      u8"双响",
      u8"双响炮",
      u8"双唇",
      u8"双唇症",
      u8"双唇音",
      u8"双喜",
      u8"双喜临门",
      u8"双回路",
      u8"双园",
      u8"双园区",
      u8"双垂尾",
      u8"双城",
      u8"双城县",
      u8"双城市",
      u8"双城记",
      u8"双城镇",
      u8"双基",
      u8"双基色",
      u8"双塔",
      u8"双塔区",
      u8"双塔奇谋",
      u8"双增双节",
      u8"双增长",
      u8"双声",
      u8"双声带",
      u8"双声道",
      u8"双外廊布局",
      u8"双多向",
      u8"双头肌",
      u8"双头蛇",
      u8"双女户",
      u8"双姓",
      u8"双娇",
      u8"双子",
      u8"双子叶",
      u8"双子叶植物",
      u8"双子塔",
      u8"双子宫",
      u8"双子座",
      u8"双子星",
      u8"双子楼",
      u8"双字",
      u8"双孢菇",
      u8"双季",
      u8"双季稻",
      u8"双学",
      u8"双学位",
      u8"双学双比",
      u8"双学士",
      u8"双安",
      u8"双官能基单体",
      u8"双宾语",
      u8"双宿双栖",
      u8"双宿双飞",
      u8"双层",
      u8"双层公车",
      u8"双层取心筒",
      u8"双层床",
      u8"双层经营",
      u8"双层结构",
      u8"双屏",
      u8"双屏双显",
      u8"双屏幕",
      u8"双岭村",
      u8"双峰",
      u8"双峰分布",
      u8"双峰县",
      u8"双峰驼",
      u8"双峰骆驼",
      u8"双工",
      u8"双工器",
      u8"双差生",
      u8"双带",
      u8"双幅",
      u8"双年展",
      u8"双床间",
      u8"双座",
      u8"双座脚踏车",
      u8"双开",
      u8"双开门",
      u8"双引号",
      u8"双彩屏",
      u8"双循环",
      u8"双性人",
      u8"双性恋",
      u8"双截棍",
      u8"双截龙",
      u8"双扇门",
      u8"双手",
      u8"双手万能",
      u8"双手柄",
      u8"双手赞成",
      u8"双打",
      u8"双打比赛",
      u8"双打赛",
      u8"双扩散",
      u8"双找工",
      u8"双折射",
      u8"双抢",
      u8"双拐",
      u8"双拥",
      u8"双拥办",
      u8"双拳",
      u8"双拳难敌四手",
      u8"双拼",
      u8"双拼加加",
      u8"双挂号",
      u8"双排扣外衣",
      u8"双排扣长礼服",
      u8"双摺",
      u8"双敏",
      u8"双敏电子",
      u8"双数",
      u8"双数据速率",
      u8"双文",
      u8"双文对校",
      u8"双文明",
      u8"双料",
      u8"双料冠军",
      u8"双斧伐孤树",
      u8"双方",
      u8"双方同意",
      u8"双方面",
      u8"双日",
      u8"双星",
      u8"双晶",
      u8"双曲抛物面",
      u8"双曲环体自同构",
      u8"双曲线",
      u8"双曲线方式",
      u8"双曲螺线",
      u8"双曲面",
      u8"双月",
      u8"双月刊",
      u8"双有理态射",
      u8"双机",
      u8"双杂交",
      u8"双束质谱仪",
      u8"双杠",
      u8"双杠体操",
      u8"双极型集成电路",
      u8"双极存储器",
      u8"双极晶体管",
      u8"双林寺",
      u8"双林路",
      u8"双柏",
      u8"双柏县",
      u8"双柑斗酒",
      u8"双柳河",
      u8"双栅场效晶体管",
      u8"双栅极",
      u8"双栈机",
      u8"双栖",
      u8"双栖双宿",
      u8"双核心",
      u8"双根",
      u8"双格",
      u8"双桂联芳",
      u8"双桅",
      u8"双桅帆船",
      u8"双桅船",
      u8"双桥区",
      u8"双桥沟",
      u8"双棒儿",
      u8"双榆树",
      u8"双模",
      u8"双模卡",
      u8"双模式",
      u8"双橡园",
      u8"双气囊",
      u8"双氟",
      u8"双氧",
      u8"双氧水",
      u8"双水模型",
      u8"双汇",
      u8"双江",
      u8"双江拉祜族佤族布朗傣族自治县",
      u8"双沟",
      u8"双油管采油井口",
      u8"双泪",
      u8"双泾",
      u8"双泾村",
      u8"双流",
      u8"双流县",
      u8"双涡轮",
      u8"双液法调剖剂",
      u8"双清区",
      u8"双港镇",
      u8"双湖",
      u8"双溪",
      u8"双溪公园",
      u8"双满意",
      u8"双滦区",
      u8"双烯",
      u8"双燃料",
      u8"双片",
      u8"双牌",
      u8"双牌县",
      u8"双特班",
      u8"双特生",
      u8"双玻璃窗",
      u8"双球菌",
      u8"双生",
      u8"双生儿",
      u8"双生女",
      u8"双生子",
      u8"双生牙",
      u8"双电源",
      u8"双百",
      u8"双百方针",
      u8"双皮奶",
      u8"双盘浮船",
      u8"双目",
      u8"双目失明",
      u8"双目成像",
      u8"双盲",
      u8"双盲实验",
      u8"双相",
      u8"双眸",
      u8"双眼",
      u8"双眼皮",
      u8"双眼线索",
      u8"双眼视差",
      u8"双眼视象融合",
      u8"双瞳",
      u8"双瞳剪水",
      u8"双矿物模型",
      u8"双硕",
      u8"双硕士",
      u8"双硬盘",
      u8"双碟",
      u8"双程",
      u8"双稳态",
      u8"双稳触发电路",
      u8"双立人",
      u8"双端固定桥",
      u8"双笔",
      u8"双等离子体离子源",
      u8"双筒",
      u8"双筒井",
      u8"双筒望远镜",
      u8"双管",
      u8"双管齐下",
      u8"双簧",
      u8"双簧管",
      u8"双簧箫",
      u8"双类",
      u8"双糖",
      u8"双系统",
      u8"双线",
      u8"双线性",
      u8"双线性系统",
      u8"双线控制井下安全阀",
      u8"双组分",
      u8"双绞线",
      u8"双缆单源法",
      u8"双缝衍射",
      u8"双缸",
      u8"双网卡",
      u8"双翅",
      u8"双翼",
      u8"双翼控制头",
      u8"双翼飞机",
      u8"双考",
      u8"双耳",
      u8"双耳时差",
      u8"双耳瓶",
      u8"双职工",
      u8"双聚焦质谱仪",
      u8"双股",
      u8"双股螺旋",
      u8"双肩",
      u8"双肩包",
      u8"双肩挑",
      u8"双胞",
      u8"双胞胎",
      u8"双胶纸",
      u8"双脚",
      u8"双腿",
      u8"双臂",
      u8"双臂卡环",
      u8"双自同态环",
      u8"双至强",
      u8"双良",
      u8"双色球",
      u8"双节棍",
      u8"双蒸水",
      u8"双薪",
      u8"双蛇",
      u8"双螺旋",
      u8"双螺杆",
      u8"双螺杆挤出机",
      u8"双行",
      u8"双行线",
      u8"双衰变",
      u8"双规",
      u8"双解",
      u8"双语",
      u8"双语学校",
      u8"双语版",
      u8"双调和",
      u8"双象",
      u8"双赢",
      u8"双走道布局",
      u8"双足重茧",
      u8"双蹦灯",
      u8"双身子",
      u8"双轨",
      u8"双轨制",
      u8"双轨铁路",
      u8"双轮",
      u8"双轴晶体",
      u8"双轴球面函数",
      u8"双边",
      u8"双边会谈",
      u8"双边关系",
      u8"双边协定",
      u8"双边协议",
      u8"双边合作",
      u8"双边和多边经济合作",
      u8"双边带调制",
      u8"双边条约",
      u8"双边离开排列",
      u8"双边贸易",
      u8"双辽",
      u8"双辽县",
      u8"双辽市",
      u8"双连",
      u8"双连通度",
      u8"双选会",
      u8"双通道",
      u8"双遣",
      u8"双遮",
      u8"双重",
      u8"双重人格",
      u8"双重函数",
      u8"双重分离",
      u8"双重国籍",
      u8"双重性",
      u8"双重性格",
      u8"双重数据加密标准",
      u8"双重标准",
      u8"双重牙列",
      u8"双重编码说",
      u8"双重身份",
      u8"双重身分",
      u8"双重领导",
      u8"双金属",
      u8"双金属片",
      u8"双金属电极",
      u8"双金属缸套",
      u8"双金属重整催化剂",
      u8"双钢轮",
      u8"双钥密码系统",
      u8"双钩",
      u8"双铧犁",
      u8"双锥天线",
      u8"双键",
      u8"双闸板防喷器",
      u8"双阳",
      u8"双阳区",
      u8"双阳县",
      u8"双阳台",
      u8"双阳极",
      u8"双陪集",
      u8"双雄",
      u8"双雄会",
      u8"双面",
      u8"双面书架",
      u8"双面娇娃",
      u8"双面板",
      u8"双面研磨",
      u8"双面绒",
      u8"双面胶",
      u8"双面谍",
      u8"双靥",
      u8"双音",
      u8"双音频",
      u8"双颊",
      u8"双颌前突",
      u8"双颌式功能矫正器",
      u8"双颌截骨术",
      u8"双频",
      u8"双飞",
      u8"双飞燕",
      u8"双飞翼",
      u8"双饷",
      u8"双馨",
      u8"双马",
      u8"双骰",
      u8"双高型",
      u8"双鬓",
      u8"双鱼",
      u8"双鱼座",
      u8"双鱼牌",
      u8"双鲤",
      u8"双鸭山",
      u8"双鸭山市",
      u8"双鹿",
      u8"双黄",
      u8"双黄线",
      u8"双黄连",
      u8"双龙传",
      u8"双龙洞",
      u8"反不正当竞争法",
      u8"反世贸",
      u8"反个",
      u8"反中子",
      u8"反串",
      u8"反为",
      u8"反主为客",
      u8"反义",
      u8"反义基因",
      u8"反义字",
      u8"反义词",
      u8"反之",
      u8"反之亦是",
      u8"反之亦然",
      u8"反了",
      u8"反于",
      u8"反交",
      u8"反交换",
      u8"反代型",
      u8"反传网络",
      u8"反作弊",
      u8"反作用",
      u8"反作用力",
      u8"反例",
      u8"反侧",
      u8"反侵略",
      u8"反侵略战",
      u8"反侵略战争",
      u8"反修",
      u8"反倒",
      u8"反倒是",
      u8"反倾销",
      u8"反光",
      u8"反光性",
      u8"反光板",
      u8"反光灯",
      u8"反光膜",
      u8"反光镜",
      u8"反党",
      u8"反党集团",
      u8"反共",
      u8"反共宣传",
      u8"反共抗俄",
      u8"反其道",
      u8"反其道而行",
      u8"反其道而行之",
      u8"反写",
      u8"反军购",
      u8"反冲",
      u8"反冲力",
      u8"反击",
      u8"反击式",
      u8"反击战",
      u8"反函数",
      u8"反分裂",
      u8"反分裂国家法",
      u8"反分裂法",
      u8"反切",
      u8"反刍",
      u8"反刍动物",
      u8"反到",
      u8"反制",
      u8"反剪",
      u8"反力",
      u8"反动",
      u8"反动份子",
      u8"反动分子",
      u8"反动势力",
      u8"反动派",
      u8"反动透顶",
      u8"反动集团",
      u8"反劫",
      u8"反劫机",
      u8"反劳为逸",
      u8"反千组",
      u8"反华",
      u8"反反",
      u8"反反复复",
      u8"反叛",
      u8"反叛党",
      u8"反叛军",
      u8"反叛者",
      u8"反叠构象",
      u8"反口",
      u8"反台独",
      u8"反右",
      u8"反右派斗",
      u8"反右派斗争",
      u8"反向",
      u8"反向二极管",
      u8"反向击穿电压",
      u8"反向地",
      u8"反向局域网信道",
      u8"反向恢复",
      u8"反向混合",
      u8"反向移情",
      u8"反向而行",
      u8"反向转运",
      u8"反向运动",
      u8"反听内视",
      u8"反听收视",
      u8"反吹",
      u8"反告",
      u8"反咬",
      u8"反咬一口",
      u8"反响",
      u8"反响强烈",
      u8"反哺",
      u8"反哺为恩",
      u8"反哺之恩",
      u8"反哺之情",
      u8"反哺之私",
      u8"反唇相稽",
      u8"反唇相讥",
      u8"反唱",
      u8"反噬",
      u8"反回力卡环",
      u8"反回头",
      u8"反坐",
      u8"反坦克",
      u8"反坦克炮",
      u8"反坦克雷",
      u8"反垃圾",
      u8"反垄断",
      u8"反垄断法",
      u8"反基因组",
      u8"反复",
      u8"反复强调",
      u8"反复性",
      u8"反复推敲",
      u8"反复无常",
      u8"反复研究",
      u8"反复证明",
      u8"反季节",
      u8"反守为攻",
      u8"反安装",
      u8"反定理",
      u8"反客为主",
      u8"反宾为主",
      u8"反对",
      u8"反对党",
      u8"反对关系",
      u8"反对声",
      u8"反对易关系",
      u8"反对派",
      u8"反对票",
      u8"反对称性",
      u8"反对者",
      u8"反导",
      u8"反导向飞",
      u8"反导向飞弹",
      u8"反导弹",
      u8"反封建",
      u8"反射",
      u8"反射亢进",
      u8"反射体",
      u8"反射光",
      u8"反射光栅",
      u8"反射动作",
      u8"反射器",
      u8"反射壁",
      u8"反射学",
      u8"反射定律",
      u8"反射层",
      u8"反射式",
      u8"反射弧",
      u8"反射强度",
      u8"反射炉",
      u8"反射率",
      u8"反射系数",
      u8"反射线",
      u8"反射角",
      u8"反射镜",
      u8"反射面",
      u8"反射高能电子衍射",
      u8"反将",
      u8"反差",
      u8"反差调整",
      u8"反帝",
      u8"反帝反封建",
      u8"反常",
      u8"反常吸收",
      u8"反常对策",
      u8"反常情况",
      u8"反常散射",
      u8"反常混晶",
      u8"反常现象",
      u8"反干扰",
      u8"反序",
      u8"反应",
      u8"反应临界能",
      u8"反应出",
      u8"反应变量",
      u8"反应器",
      u8"反应堆",
      u8"反应堆心",
      u8"反应堆活性区",
      u8"反应塔",
      u8"反应式",
      u8"反应性精神病",
      u8"反应截面",
      u8"反应方程",
      u8"反应时",
      u8"反应时间",
      u8"反应溅射",
      u8"反应溅射刻蚀",
      u8"反应炉",
      u8"反应热",
      u8"反应物",
      u8"反应离子刻蚀",
      u8"反应类型",
      u8"反应罐",
      u8"反应蒸发",
      u8"反应进度",
      u8"反应迟钝",
      u8"反应速度",
      u8"反应釜",
      u8"反应锅",
      u8"反式",
      u8"反式切割",
      u8"反式剪接",
      u8"反式加成",
      u8"反式异构体",
      u8"反式构象",
      u8"反式消除",
      u8"反式灭活",
      u8"反式衣壳化",
      u8"反式调节蛋白",
      u8"反式阻抑",
      u8"反式阻抑蛋白",
      u8"反弹",
      u8"反弹力",
      u8"反弹球",
      u8"反得",
      u8"反循环",
      u8"反循环打捞篮",
      u8"反德",
      u8"反思",
      u8"反恐",
      u8"反恐怖",
      u8"反恐精英",
      u8"反悔",
      u8"反情报",
      u8"反意",
      u8"反感",
      u8"反戈",
      u8"反戈一击",
      u8"反戈相向",
      u8"反成",
      u8"反战",
      u8"反战份子",
      u8"反手",
      u8"反手可得",
      u8"反扑",
      u8"反扒",
      u8"反托拉斯",
      u8"反托拉斯法",
      u8"反把",
      u8"反投影",
      u8"反抗",
      u8"反抗军",
      u8"反抗性",
      u8"反抗者",
      u8"反折射",
      u8"反担保",
      u8"反拍",
      u8"反持",
      u8"反排",
      u8"反接",
      u8"反推",
      u8"反推力",
      u8"反提",
      u8"反撞力",
      u8"反攻",
      u8"反攻为守",
      u8"反攻倒算",
      u8"反攻复国",
      u8"反攻复国大业",
      u8"反攻大陆",
      u8"反政府",
      u8"反政府武装",
      u8"反文儿",
      u8"反文旁",
      u8"反斗",
      u8"反方",
      u8"反旋",
      u8"反无",
      u8"反日",
      u8"反时钟方向",
      u8"反映",
      u8"反映出",
      u8"反映情况",
      u8"反映论",
      u8"反是",
      u8"反木马",
      u8"反本",
      u8"反札依采夫定向",
      u8"反朴归真",
      u8"反朴还淳",
      u8"反杜林论",
      u8"反来",
      u8"反查",
      u8"反正",
      u8"反正拨乱",
      u8"反正还淳",
      u8"反殖",
      u8"反毒",
      u8"反毒害",
      u8"反比",
      u8"反比例",
      u8"反民主",
      u8"反气旋",
      u8"反水",
      u8"反水不收",
      u8"反求诸己",
      u8"反汇编",
      u8"反治其身",
      u8"反法",
      u8"反法西斯",
      u8"反洗",
      u8"反洗钱",
      u8"反洗钱法",
      u8"反派",
      u8"反派人物",
      u8"反流色谱法",
      u8"反浪费",
      u8"反清",
      u8"反清复明",
      u8"反渗透",
      u8"反渗透膜",
      u8"反演",
      u8"反演中心",
      u8"反潜",
      u8"反潜机",
      u8"反潜艇",
      u8"反潮流",
      u8"反火力",
      u8"反烟",
      u8"反烟运动",
      u8"反照",
      u8"反照率",
      u8"反照镜",
      u8"反物质",
      u8"反犬旁",
      u8"反犬旁儿",
      u8"反犯罪",
      u8"反犹太",
      u8"反理性主义",
      u8"反璞归真",
      u8"反生",
      u8"反电动势",
      u8"反町隆史",
      u8"反病毒",
      u8"反病毒软件",
      u8"反白",
      u8"反白字",
      u8"反盗版",
      u8"反目",
      u8"反目为仇",
      u8"反目成仇",
      u8"反目无情",
      u8"反相",
      u8"反相分配色谱法",
      u8"反相器",
      u8"反省",
      u8"反省起来",
      u8"反看",
      u8"反眼不识",
      u8"反码",
      u8"反社会",
      u8"反社会主义",
      u8"反社会人格",
      u8"反离子",
      u8"反种族隔离",
      u8"反称双线性型",
      u8"反穿",
      u8"反窃听",
      u8"反竞争抑制",
      u8"反符合电路",
      u8"反类质同晶",
      u8"反粒子",
      u8"反经",
      u8"反经合义",
      u8"反经合道",
      u8"反经行权",
      u8"反绑",
      u8"反给",
      u8"反编码链",
      u8"反编译",
      u8"反编译器",
      u8"反编译程序",
      u8"反置双聚焦质谱计",
      u8"反美",
      u8"反老还童",
      u8"反而",
      u8"反而会",
      u8"反而在",
      u8"反而是",
      u8"反而酣畅淋漓伴侣月比",
      u8"反聘",
      u8"反胃",
      u8"反能",
      u8"反脸无情",
      u8"反腐",
      u8"反腐倡廉",
      u8"反腐败",
      u8"反腐败斗争",
      u8"反自同构",
      u8"反舰导弹",
      u8"反英",
      u8"反补贴",
      u8"反衬",
      u8"反衬度",
      u8"反被",
      u8"反装甲",
      u8"反裘伤皮",
      u8"反裘负刍",
      u8"反裘负薪",
      u8"反褶积",
      u8"反要",
      u8"反覆",
      u8"反覆思量",
      u8"反覆无常",
      u8"反观",
      u8"反角",
      u8"反论",
      u8"反讽",
      u8"反证",
      u8"反证法",
      u8"反诉",
      u8"反诘",
      u8"反话",
      u8"反诬",
      u8"反语",
      u8"反读",
      u8"反调",
      u8"反责",
      u8"反败为胜",
      u8"反质子",
      u8"反贪",
      u8"反贪动态",
      u8"反贪局",
      u8"反贪工作",
      u8"反贪污",
      u8"反贪污贿赂局",
      u8"反贪科",
      u8"反走私",
      u8"反踢",
      u8"反身",
      u8"反身代词",
      u8"反身自问",
      u8"反躬自省",
      u8"反躬自责",
      u8"反躬自问",
      u8"反转",
      u8"反转凝析现象",
      u8"反转剧",
      u8"反转来",
      u8"反转温度",
      u8"反转片",
      u8"反辱相稽",
      u8"反过",
      u8"反过来",
      u8"反过来说",
      u8"反退",
      u8"反遭",
      u8"反遭毒手",
      u8"反避税",
      u8"反邪归正",
      u8"反邪教",
      u8"反酸",
      u8"反醒",
      u8"反钓鱼",
      u8"反铐",
      u8"反锁",
      u8"反错构象",
      u8"反键",
      u8"反锯齿",
      u8"反问",
      u8"反间",
      u8"反间之计",
      u8"反间计",
      u8"反间谍",
      u8"反霸",
      u8"反面",
      u8"反面人物",
      u8"反面典型",
      u8"反面反应",
      u8"反面教员",
      u8"反面教材",
      u8"反面文章",
      u8"反面无情",
      u8"反面材料",
      u8"反面角色",
      u8"反面设计",
      u8"反革命",
      u8"反革命分子",
      u8"反革命暴乱",
      u8"反革命集团",
      u8"反顾",
      u8"反题",
      u8"反颜相向",
      u8"反颠覆",
      u8"反风灭火",
      u8"反馈",
      u8"反馈作用",
      u8"反馈系统",
      u8"反馈边集合",
      u8"反驳",
      u8"反驳者",
      u8"反骄破满",
      u8"反魂乏术",
      u8"发一分光",
      u8"发一组",
      u8"发上",
      u8"发上冲冠",
      u8"发上去",
      u8"发上指冠",
      u8"发上来",
      u8"发下",
      u8"发下去",
      u8"发下来",
      u8"发不",
      u8"发不出",
      u8"发不到",
      u8"发不起",
      u8"发丝",
      u8"发两张",
      u8"发丧",
      u8"发个",
      u8"发个贴",
      u8"发为",
      u8"发乎",
      u8"发乎情",
      u8"发书",
      u8"发乳",
      u8"发乾",
      u8"发了",
      u8"发予",
      u8"发于",
      u8"发些",
      u8"发交",
      u8"发亮",
      u8"发人",
      u8"发人深思",
      u8"发人深省",
      u8"发付",
      u8"发令",
      u8"发令员",
      u8"发令枪",
      u8"发件",
      u8"发件人",
      u8"发件箱",
      u8"发价",
      u8"发传单",
      u8"发传真",
      u8"发低工资",
      u8"发低烧",
      u8"发作",
      u8"发作性睡病",
      u8"发信",
      u8"发信人",
      u8"发信号",
      u8"发信息",
      u8"发信站",
      u8"发债",
      u8"发傻",
      u8"发像管",
      u8"发光",
      u8"发光二极管",
      u8"发光体",
      u8"发光字",
      u8"发光度",
      u8"发光强度",
      u8"发光棒",
      u8"发光片",
      u8"发光物",
      u8"发光管",
      u8"发光粉",
      u8"发光闪烁",
      u8"发兵",
      u8"发冷",
      u8"发凉",
      u8"发几张",
      u8"发凡",
      u8"发凡起例",
      u8"发出",
      u8"发出去",
      u8"发出和",
      u8"发出回声",
      u8"发出声音",
      u8"发出撞击声",
      u8"发出来",
      u8"发出臭味",
      u8"发出通知",
      u8"发函",
      u8"发刊",
      u8"发刊词",
      u8"发到",
      u8"发制品",
      u8"发刷",
      u8"发务成业",
      u8"发动",
      u8"发动战争",
      u8"发动机",
      u8"发动机停转",
      u8"发动机盖",
      u8"发动机短",
      u8"发动机短舱",
      u8"发动机舱",
      u8"发动群众",
      u8"发动蛋白",
      u8"发动革命",
      u8"发包",
      u8"发包人",
      u8"发包方",
      u8"发单",
      u8"发卖",
      u8"发卡",
      u8"发卡人",
      u8"发卡行",
      u8"发卡量",
      u8"发卷",
      u8"发去",
      u8"发叶",
      u8"发号施令",
      u8"发向",
      u8"发呆",
      u8"发呆地",
      u8"发呕",
      u8"发咒",
      u8"发响",
      u8"发哑",
      u8"发哥",
      u8"发售",
      u8"发售日",
      u8"发售日期",
      u8"发售量",
      u8"发喘",
      u8"发嗲",
      u8"发回",
      u8"发回去",
      u8"发回来",
      u8"发回重审",
      u8"发困",
      u8"发国难财",
      u8"发图片",
      u8"发在",
      u8"发场光大",
      u8"发坏",
      u8"发型",
      u8"发型屋",
      u8"发型师",
      u8"发型秀",
      u8"发型设计",
      u8"发堵",
      u8"发声",
      u8"发声器",
      u8"发声器官",
      u8"发声明",
      u8"发声法",
      u8"发大水",
      u8"发大财",
      u8"发夹",
      u8"发夹环",
      u8"发夹结构",
      u8"发奋",
      u8"发奋图强",
      u8"发奖",
      u8"发奖仪式",
      u8"发套",
      u8"发奸擿伏",
      u8"发好",
      u8"发妻",
      u8"发姐",
      u8"发威",
      u8"发威动怒",
      u8"发完",
      u8"发审委",
      u8"发宪布令",
      u8"发家",
      u8"发家史",
      u8"发家致富",
      u8"发射",
      u8"发射乐团",
      u8"发射光谱",
      u8"发射光谱分析",
      u8"发射区",
      u8"发射区陷落效应",
      u8"发射卫星",
      u8"发射台",
      u8"发射器",
      u8"发射场",
      u8"发射塔",
      u8"发射成功",
      u8"发射机",
      u8"发射极",
      u8"发射极耦合逻辑",
      u8"发射架",
      u8"发射点",
      u8"发射物",
      u8"发射率",
      u8"发射结",
      u8"发射臂",
      u8"发屋",
      u8"发屋求狸",
      u8"发展",
      u8"发展下去",
      u8"发展不平衡",
      u8"发展中",
      u8"发展中国家",
      u8"发展为",
      u8"发展党员",
      u8"发展农业",
      u8"发展出来",
      u8"发展到",
      u8"发展前景",
      u8"发展前途",
      u8"发展势头",
      u8"发展区",
      u8"发展友好合作关系",
      u8"发展变化",
      u8"发展史",
      u8"发展商",
      u8"发展地理学",
      u8"发展壮大",
      u8"发展对象",
      u8"发展局",
      u8"发展心理",
      u8"发展心理学",
      u8"发展性",
      u8"发展战略",
      u8"发展方向",
      u8"发展是硬道理",
      u8"发展有限公司",
      u8"发展期",
      u8"发展机会",
      u8"发展民族经济",
      u8"发展水平",
      u8"发展潜力",
      u8"发展生产",
      u8"发展研究中心",
      u8"发展社会学",
      u8"发展科学技术",
      u8"发展经济",
      u8"发展缓慢",
      u8"发展署",
      u8"发展观",
      u8"发展规划",
      u8"发展规律",
      u8"发展计划",
      u8"发展计划委员会",
      u8"发展起来",
      u8"发展趋势",
      u8"发展趋向",
      u8"发展辉煌",
      u8"发展迅速",
      u8"发展过程",
      u8"发展速度",
      u8"发展部",
      u8"发展银行",
      u8"发展阶段",
      u8"发展需要",
      u8"发工资",
      u8"发市",
      u8"发布",
      u8"发布人",
      u8"发布会",
      u8"发布公告",
      u8"发布区",
      u8"发布命令",
      u8"发布新闻",
      u8"发布者",
      u8"发布量",
      u8"发布页",
      u8"发布页面",
      u8"发帖",
      u8"发帖人",
      u8"发帖子",
      u8"发帖数",
      u8"发帖榜",
      u8"发帖量",
      u8"发带",
      u8"发廊",
      u8"发廊女",
      u8"发廊妹",
      u8"发式",
      u8"发引",
      u8"发引千钧",
      u8"发彩信",
      u8"发往",
      u8"发得",
      u8"发怒",
      u8"发怒冲冠",
      u8"发怒穿冠",
      u8"发怔",
      u8"发急",
      u8"发性",
      u8"发怨言",
      u8"发怵",
      u8"发恼",
      u8"发悸",
      u8"发情",
      u8"发情周期",
      u8"发情探测",
      u8"发情期",
      u8"发愁",
      u8"发愣",
      u8"发愤",
      u8"发愤图强",
      u8"发愤忘食",
      u8"发愿",
      u8"发慈悲",
      u8"发慌",
      u8"发憷",
      u8"发懒",
      u8"发成",
      u8"发手机",
      u8"发扬",
      u8"发扬光大",
      u8"发扬成绩",
      u8"发扬民主",
      u8"发扬踔厉",
      u8"发扬蹈厉",
      u8"发抒",
      u8"发抒心志",
      u8"发抖",
      u8"发护发",
      u8"发报",
      u8"发报人",
      u8"发报员",
      u8"发报器",
      u8"发报机",
      u8"发指",
      u8"发指眦裂",
      u8"发挥",
      u8"发挥优势",
      u8"发挥余热",
      u8"发挥作用",
      u8"发挥出",
      u8"发挥出来",
      u8"发挥到",
      u8"发挥性",
      u8"发挥所长",
      u8"发挥特长",
      u8"发掉",
      u8"发排",
      u8"发掘",
      u8"发掘出",
      u8"发掘出来",
      u8"发掘到",
      u8"发收",
      u8"发改委",
      u8"发放",
      u8"发放贷款",
      u8"发政施仁",
      u8"发散",
      u8"发散透镜",
      u8"发文",
      u8"发文件",
      u8"发文者",
      u8"发料",
      u8"发新帖",
      u8"发旧",
      u8"发明",
      u8"发明专利",
      u8"发明人",
      u8"发明创造",
      u8"发明地",
      u8"发明奖",
      u8"发明家",
      u8"发明家分会",
      u8"发明权",
      u8"发明者",
      u8"发昏",
      u8"发昏章第十一",
      u8"发春",
      u8"发晕",
      u8"发暗",
      u8"发有",
      u8"发木",
      u8"发条",
      u8"发条橙",
      u8"发来",
      u8"发来发去",
      u8"发标",
      u8"发标人",
      u8"发根",
      u8"发案",
      u8"发案单位",
      u8"发案地",
      u8"发案率",
      u8"发梢",
      u8"发棠之请",
      u8"发植穿冠",
      u8"发楞",
      u8"发榜",
      u8"发横",
      u8"发横财",
      u8"发款",
      u8"发毛",
      u8"发气",
      u8"发水",
      u8"发汗",
      u8"发汗剂",
      u8"发汗药",
      u8"发油",
      u8"发泄",
      u8"发泡",
      u8"发泡剂",
      u8"发泡机",
      u8"发泡胶",
      u8"发洋财",
      u8"发派",
      u8"发浊音",
      u8"发消息",
      u8"发源",
      u8"发源地",
      u8"发潮",
      u8"发火",
      u8"发火器",
      u8"发火点",
      u8"发炎",
      u8"发炎性",
      u8"发炮",
      u8"发点",
      u8"发烟",
      u8"发烧",
      u8"发烧友",
      u8"发烧时",
      u8"发烧极",
      u8"发烧站",
      u8"发烧级",
      u8"发烧音响",
      u8"发热",
      u8"发热器",
      u8"发热时",
      u8"发热管",
      u8"发热量",
      u8"发片",
      u8"发牌",
      u8"发牢骚",
      u8"发物",
      u8"发状",
      u8"发狂",
      u8"发狂地",
      u8"发狠",
      u8"发獃",
      u8"发现",
      u8"发现了",
      u8"发现出",
      u8"发现到",
      u8"发现号",
      u8"发现异常",
      u8"发现情况",
      u8"发现控制",
      u8"发现有",
      u8"发现物",
      u8"发现矛盾",
      u8"发现者",
      u8"发现该",
      u8"发现问题",
      u8"发球",
      u8"发球员",
      u8"发球局",
      u8"发球权",
      u8"发生",
      u8"发生争执",
      u8"发生关系",
      u8"发生冲突",
      u8"发生变化",
      u8"发生后",
      u8"发生响声",
      u8"发生器",
      u8"发生地",
      u8"发生巨变",
      u8"发生影响",
      u8"发生心理学",
      u8"发生意外",
      u8"发生时间",
      u8"发生期预测",
      u8"发生炉煤",
      u8"发生炉煤气",
      u8"发生爆炸",
      u8"发生率",
      u8"发电",
      u8"发电厂",
      u8"发电所",
      u8"发电报",
      u8"发电机",
      u8"发电机组",
      u8"发电站",
      u8"发电能力",
      u8"发电量",
      u8"发留言",
      u8"发疯",
      u8"发疹",
      u8"发疹子",
      u8"发病",
      u8"发病指数",
      u8"发病率",
      u8"发痒",
      u8"发痛",
      u8"发痧",
      u8"发痴",
      u8"发癣",
      u8"发白",
      u8"发白时",
      u8"发皇",
      u8"发直",
      u8"发着",
      u8"发矢",
      u8"发短信",
      u8"发短心长",
      u8"发硎新试",
      u8"发硬",
      u8"发硬时",
      u8"发神经",
      u8"发神经病",
      u8"发祥",
      u8"发祥之地",
      u8"发祥地",
      u8"发票",
      u8"发福",
      u8"发秃齿豁",
      u8"发科打诨",
      u8"发稿",
      u8"发窘",
      u8"发端",
      u8"发端词",
      u8"发笑",
      u8"发笔",
      u8"发策决科",
      u8"发簪",
      u8"发粉",
      u8"发糕",
      u8"发紧",
      u8"发紫",
      u8"发红",
      u8"发红包",
      u8"发纵指使",
      u8"发纵指示",
      u8"发结",
      u8"发给",
      u8"发给你",
      u8"发给您",
      u8"发综指示",
      u8"发绿",
      u8"发网",
      u8"发聋振聩",
      u8"发肤",
      u8"发育",
      u8"发育不全",
      u8"发育不良",
      u8"发育成",
      u8"发育期",
      u8"发育条件",
      u8"发育沟",
      u8"发育畸形",
      u8"发育节律",
      u8"发育调节",
      u8"发育遗传学",
      u8"发育阶段",
      u8"发肿",
      u8"发胀",
      u8"发胀感",
      u8"发胖",
      u8"发胶",
      u8"发脾气",
      u8"发自",
      u8"发自体内",
      u8"发自内心",
      u8"发自肺腑",
      u8"发臭",
      u8"发至",
      u8"发船",
      u8"发花",
      u8"发芽",
      u8"发芽势",
      u8"发芽率",
      u8"发芽生殖",
      u8"发芽试验",
      u8"发菜",
      u8"发落",
      u8"发蒙",
      u8"发蒙振聩",
      u8"发蒙振落",
      u8"发蒙解惑",
      u8"发蒙解缚",
      u8"发蓝",
      u8"发蔫",
      u8"发薪",
      u8"发薪日",
      u8"发薪水",
      u8"发虚",
      u8"发蜡",
      u8"发蜡条",
      u8"发行",
      u8"发行人",
      u8"发行价",
      u8"发行体",
      u8"发行史",
      u8"发行员",
      u8"发行商",
      u8"发行所",
      u8"发行版",
      u8"发行网",
      u8"发行者",
      u8"发行股票",
      u8"发行部",
      u8"发行量",
      u8"发表",
      u8"发表于",
      u8"发表以下代理意见",
      u8"发表会",
      u8"发表出来",
      u8"发表声明",
      u8"发表意见",
      u8"发表文章",
      u8"发表新",
      u8"发表演说",
      u8"发表议论",
      u8"发表谈话",
      u8"发见",
      u8"发觉",
      u8"发觉出",
      u8"发觉到",
      u8"发言",
      u8"发言人",
      u8"发言权",
      u8"发言条",
      u8"发言盈庭",
      u8"发言稿",
      u8"发言者",
      u8"发誓",
      u8"发议论",
      u8"发证",
      u8"发话",
      u8"发话器",
      u8"发语词",
      u8"发财",
      u8"发财树",
      u8"发财梦",
      u8"发财致富",
      u8"发财路",
      u8"发货",
      u8"发货单",
      u8"发货地",
      u8"发货票",
      u8"发贴",
      u8"发贴人",
      u8"发贴子",
      u8"发贴数",
      u8"发起",
      u8"发起人",
      u8"发起来",
      u8"发起烧来",
      u8"发起者",
      u8"发踊冲冠",
      u8"发踪指使",
      u8"发踪指示",
      u8"发车",
      u8"发车场",
      u8"发轫",
      u8"发软",
      u8"发辫",
      u8"发达",
      u8"发达为",
      u8"发达到",
      u8"发达县",
      u8"发达国家",
      u8"发达地区",
      u8"发达起来",
      u8"发过",
      u8"发过去",
      u8"发过来",
      u8"发运",
      u8"发运人",
      u8"发还",
      u8"发进",
      u8"发进去",
      u8"发进来",
      u8"发迹",
      u8"发迹史",
      u8"发送",
      u8"发送到",
      u8"发送器",
      u8"发送机",
      u8"发送站",
      u8"发送给",
      u8"发送者",
      u8"发送至",
      u8"发送量",
      u8"发邮件",
      u8"发配",
      u8"发酒疯",
      u8"发酵",
      u8"发酵出来",
      u8"发酵剂",
      u8"发酵单胞菌属",
      u8"发酵图谱",
      u8"发酵奶制品",
      u8"发酵粉",
      u8"发酵罐",
      u8"发酵饲料",
      u8"发酸",
      u8"发野",
      u8"发针",
      u8"发钞",
      u8"发钱",
      u8"发错",
      u8"发长",
      u8"发问",
      u8"发问者",
      u8"发闷",
      u8"发际",
      u8"发隐擿伏",
      u8"发难",
      u8"发霉",
      u8"发霜",
      u8"发青",
      u8"发面",
      u8"发面饼",
      u8"发音",
      u8"发音器",
      u8"发音器官",
      u8"发音学",
      u8"发音版",
      u8"发颤",
      u8"发飘",
      u8"发飙",
      u8"发饷",
      u8"发香味",
      u8"发高烧",
      u8"发高热",
      u8"发髻",
      u8"发鬓",
      u8"发麻",
      u8"发黄",
      u8"发黏",
      u8"发黑",
      u8"叔伯",
      u8"叔伯弟兄",
      u8"叔侄",
      u8"叔公",
      u8"叔叔",
      u8"叔婆",
      u8"叔婶",
      u8"叔嫂",
      u8"叔子",
      u8"叔孙通",
      u8"叔岳",
      u8"叔度陂湖",
      u8"叔本华",
      u8"叔母",
      u8"叔父",
      u8"叔祖",
      u8"叔祖母",
      u8"叔舅",
      u8"取下",
      u8"取义",
      u8"取义成仁",
      u8"取之",
      u8"取之不尽",
      u8"取之不尽用之不竭",
      u8"取之不竭",
      u8"取之于",
      u8"取之于民",
      u8"取之有道",
      u8"取乐",
      u8"取乱侮亡",
      u8"取乱存亡",
      u8"取了",
      u8"取予有节",
      u8"取代",
      u8"取代拼音",
      u8"取代法",
      u8"取保",
      u8"取保候审",
      u8"取信",
      u8"取信于",
      u8"取信于人",
      u8"取信于民",
      u8"取值",
      u8"取其",
      u8"取其精华",
      u8"取决",
      u8"取决于",
      u8"取出",
      u8"取出来",
      u8"取到",
      u8"取去",
      u8"取反",
      u8"取名",
      u8"取名为",
      u8"取名字",
      u8"取向",
      u8"取向极化",
      u8"取回",
      u8"取回去",
      u8"取回来",
      u8"取大优先",
      u8"取如拾遗",
      u8"取字",
      u8"取尽",
      u8"取巧",
      u8"取巧图便",
      u8"取平",
      u8"取开",
      u8"取得",
      u8"取得了",
      u8"取得实效",
      u8"取得成功",
      u8"取得成效",
      u8"取得联系",
      u8"取得胜利",
      u8"取心钻压",
      u8"取快一时",
      u8"取息",
      u8"取悦",
      u8"取悦于",
      u8"取悦于人",
      u8"取悦于民",
      u8"取报",
      u8"取掉",
      u8"取数时间",
      u8"取景",
      u8"取景器",
      u8"取景框",
      u8"取暖",
      u8"取暖器",
      u8"取暖油",
      u8"取暖法",
      u8"取暖炉",
      u8"取暖费",
      u8"取材",
      u8"取材于",
      u8"取材自",
      u8"取来",
      u8"取样",
      u8"取样器",
      u8"取样率",
      u8"取款",
      u8"取款单",
      u8"取款机",
      u8"取水",
      u8"取水口",
      u8"取水量",
      u8"取法",
      u8"取法乎上",
      u8"取法乎上仅得乎中",
      u8"取法于",
      u8"取消",
      u8"取消后",
      u8"取消资格",
      u8"取火",
      u8"取用",
      u8"取码",
      u8"取笑",
      u8"取精用宏",
      u8"取精用弘",
      u8"取经",
      u8"取给",
      u8"取缔",
      u8"取缔法",
      u8"取而代之",
      u8"取胜",
      u8"取自",
      u8"取舍",
      u8"取舍不定",
      u8"取舍之间",
      u8"取舍难定",
      u8"取色",
      u8"取药",
      u8"取证",
      u8"取证难",
      u8"取词",
      u8"取诸宫中",
      u8"取货",
      u8"取费",
      u8"取走",
      u8"取辖投井",
      u8"取送",
      u8"取适量",
      u8"取道",
      u8"取钱",
      u8"取长弃短",
      u8"取长补短",
      u8"取闹",
      u8"取阅",
      u8"取青妃白",
      u8"取青媲白",
      u8"取青配白",
      u8"取静集",
      u8"取食刺激剂",
      u8"取齐",
      u8"受不乐",
      u8"受不了",
      u8"受不得",
      u8"受业",
      u8"受之无愧",
      u8"受之有愧",
      u8"受了",
      u8"受了伤",
      u8"受事",
      u8"受人",
      u8"受人之托",
      u8"受人牵制",
      u8"受众",
      u8"受众面",
      u8"受伤",
      u8"受伤害",
      u8"受伤者",
      u8"受体",
      u8"受俘",
      u8"受保人",
      u8"受俸",
      u8"受冷",
      u8"受冻",
      u8"受凉",
      u8"受刑",
      u8"受刑人",
      u8"受刑者",
      u8"受到",
      u8"受到了",
      u8"受到冲击",
      u8"受到好评",
      u8"受到影响",
      u8"受到感染",
      u8"受到牵连",
      u8"受到破坏",
      u8"受到谴责",
      u8"受到重视",
      u8"受到限制",
      u8"受制",
      u8"受制于人",
      u8"受刺激",
      u8"受力",
      u8"受力钢筋",
      u8"受动",
      u8"受助生",
      u8"受压",
      u8"受压迫",
      u8"受受",
      u8"受后付款",
      u8"受听",
      u8"受命",
      u8"受够",
      u8"受够了",
      u8"受奖",
      u8"受委屈",
      u8"受委托人",
      u8"受孕",
      u8"受孕率",
      u8"受完",
      u8"受宠",
      u8"受宠若惊",
      u8"受审",
      u8"受害",
      u8"受害人",
      u8"受害国",
      u8"受害者",
      u8"受寒",
      u8"受尽",
      u8"受尽压迫",
      u8"受尽折磨",
      u8"受屈",
      u8"受影响",
      u8"受得了",
      u8"受得住",
      u8"受恩深重宜先退",
      u8"受惊",
      u8"受惊吓",
      u8"受惠",
      u8"受惠无穷",
      u8"受惩",
      u8"受戒",
      u8"受托",
      u8"受托人",
      u8"受托承销",
      u8"受托承销品",
      u8"受折磨",
      u8"受持",
      u8"受挤",
      u8"受挫",
      u8"受损",
      u8"受损害",
      u8"受损率",
      u8"受控",
      u8"受援",
      u8"受敌",
      u8"受教",
      u8"受教育",
      u8"受文者",
      u8"受旱",
      u8"受暑",
      u8"受有",
      u8"受权",
      u8"受案",
      u8"受案率",
      u8"受检",
      u8"受欢迎",
      u8"受欺侮",
      u8"受款",
      u8"受此",
      u8"受气",
      u8"受气包",
      u8"受法律保护",
      u8"受洗",
      u8"受潮",
      u8"受激发射",
      u8"受激拉曼散射",
      u8"受灾",
      u8"受灾人口",
      u8"受灾县",
      u8"受灾国",
      u8"受灾地区",
      u8"受灾户",
      u8"受灾面",
      u8"受灾面积",
      u8"受点",
      u8"受热",
      u8"受热捧",
      u8"受理",
      u8"受理费",
      u8"受用",
      u8"受用不尽",
      u8"受用无穷",
      u8"受用终身",
      u8"受田",
      u8"受电",
      u8"受电架",
      u8"受病",
      u8"受益",
      u8"受益不浅",
      u8"受益人",
      u8"受益匪浅",
      u8"受益者",
      u8"受益费",
      u8"受益非浅",
      u8"受看",
      u8"受着",
      u8"受礼",
      u8"受礼人",
      u8"受礼者",
      u8"受穷",
      u8"受窘",
      u8"受粉",
      u8"受精",
      u8"受精卵",
      u8"受精率",
      u8"受累",
      u8"受约人",
      u8"受约束",
      u8"受罚",
      u8"受罪",
      u8"受聘",
      u8"受胎",
      u8"受胎率",
      u8"受自",
      u8"受苦",
      u8"受苦受累",
      u8"受苦受难",
      u8"受落",
      u8"受虐",
      u8"受虐狂",
      u8"受表彰",
      u8"受让",
      u8"受让人",
      u8"受让方",
      u8"受训",
      u8"受训人",
      u8"受训练人",
      u8"受训者",
      u8"受讯",
      u8"受记",
      u8"受访者",
      u8"受诉",
      u8"受词",
      u8"受试者",
      u8"受话人",
      u8"受话器",
      u8"受话机",
      u8"受贿",
      u8"受贿案",
      u8"受贿罪",
      u8"受赏",
      u8"受赐良多",
      u8"受赠人",
      u8"受距",
      u8"受身",
      u8"受辱",
      u8"受过",
      u8"受过伤",
      u8"受迫对流",
      u8"受迫振动",
      u8"受邀",
      u8"受邀者",
      u8"受错",
      u8"受阻",
      u8"受阻于",
      u8"受降",
      u8"受降仪式",
      u8"受降典礼",
      u8"受限",
      u8"受限于",
      u8"受限制",
      u8"受难",
      u8"受难日",
      u8"受难者",
      u8"受难记",
      u8"受雇",
      u8"受领",
      u8"受领支票",
      u8"受饿",
      u8"受骗",
      u8"受骗上当",
      u8"变上",
      u8"变上去",
      u8"变上来",
      u8"变下",
      u8"变下去",
      u8"变下来",
      u8"变个",
      u8"变为",
      u8"变乱",
      u8"变了",
      u8"变了又变",
      u8"变了样",
      u8"变些",
      u8"变产",
      u8"变亮",
      u8"变价",
      u8"变位",
      u8"变低",
      u8"变体",
      u8"变体字",
      u8"变作",
      u8"变俗易教",
      u8"变修",
      u8"变做",
      u8"变农为商",
      u8"变冷",
      u8"变凉",
      u8"变凤凰",
      u8"变出",
      u8"变出来",
      u8"变分不等式",
      u8"变分法",
      u8"变则通",
      u8"变到",
      u8"变动",
      u8"变动不居",
      u8"变动水位式",
      u8"变动表",
      u8"变化",
      u8"变化不测",
      u8"变化不穷",
      u8"变化器",
      u8"变化图",
      u8"变化多端",
      u8"变化如神",
      u8"变化成",
      u8"变化无常",
      u8"变化无穷",
      u8"变化检测",
      u8"变化球",
      u8"变化系",
      u8"变化莫测",
      u8"变卖",
      u8"变卖家产",
      u8"变卦",
      u8"变危为安",
      u8"变压",
      u8"变压器",
      u8"变压器厂",
      u8"变压器耦合放大器",
      u8"变厚",
      u8"变去",
      u8"变反",
      u8"变变",
      u8"变变看",
      u8"变古乱常",
      u8"变古易俗",
      u8"变古易常",
      u8"变名易姓",
      u8"变向",
      u8"变向器",
      u8"变味",
      u8"变咸",
      u8"变回",
      u8"变回去",
      u8"变回来",
      u8"变因",
      u8"变圆",
      u8"变在",
      u8"变址",
      u8"变坏",
      u8"变坏事为好事",
      u8"变型",
      u8"变声",
      u8"变声期",
      u8"变复如是",
      u8"变多",
      u8"变大",
      u8"变天",
      u8"变天账",
      u8"变奏",
      u8"变奏曲",
      u8"变奏曲式",
      u8"变好",
      u8"变子",
      u8"变容二极管",
      u8"变宽",
      u8"变小",
      u8"变少",
      u8"变局",
      u8"变差",
      u8"变平",
      u8"变幻",
      u8"变幻不测",
      u8"变幻无常",
      u8"变幻无穷",
      u8"变幻莫测",
      u8"变应原",
      u8"变应性疾病",
      u8"变废为宝",
      u8"变异",
      u8"变异中心",
      u8"变异性",
      u8"变异系数",
      u8"变弄",
      u8"变弱",
      u8"变强",
      u8"变形",
      u8"变形书名检索",
      u8"变形体",
      u8"变形杆菌",
      u8"变形杆菌属",
      u8"变形牛顿法",
      u8"变形缝",
      u8"变形虫",
      u8"变形记",
      u8"变形运动",
      u8"变形金刚",
      u8"变形镜头式宽银幕电影",
      u8"变形马蒂厄方程",
      u8"变影",
      u8"变得",
      u8"变得丰美",
      u8"变得坚韧",
      u8"变得复杂",
      u8"变得宽容",
      u8"变得残忍",
      u8"变心",
      u8"变心易虑",
      u8"变快",
      u8"变态",
      u8"变态传奇",
      u8"变态反应",
      u8"变态心理",
      u8"变态性",
      u8"变态版",
      u8"变态狂",
      u8"变态男",
      u8"变态百出",
      u8"变性",
      u8"变性人",
      u8"变性凝胶",
      u8"变性凝胶电泳",
      u8"变性剂",
      u8"变性型涎腺肿大症",
      u8"变性手术",
      u8"变性聚丙烯",
      u8"变性蛋白",
      u8"变性酒精",
      u8"变感器",
      u8"变慢",
      u8"变戏法",
      u8"变戏法者",
      u8"变成",
      u8"变成流了",
      u8"变成菜色",
      u8"变扁",
      u8"变换",
      u8"变换位置",
      u8"变换分析",
      u8"变换器",
      u8"变换语义",
      u8"变故",
      u8"变故易常",
      u8"变数",
      u8"变新",
      u8"变旋",
      u8"变旋酶",
      u8"变易",
      u8"变星",
      u8"变晴",
      u8"变暖",
      u8"变暗",
      u8"变更",
      u8"变更为",
      u8"变更转储",
      u8"变更通告单",
      u8"变服诡行",
      u8"变本",
      u8"变本加厉",
      u8"变来",
      u8"变来变去",
      u8"变松",
      u8"变构",
      u8"变样",
      u8"变格",
      u8"变法",
      u8"变法儿",
      u8"变法维新",
      u8"变法运动",
      u8"变流器",
      u8"变浅",
      u8"变浓",
      u8"变淡",
      u8"变清",
      u8"变清蛋白",
      u8"变温动物",
      u8"变温层",
      u8"变湿",
      u8"变灭",
      u8"变炫无穷",
      u8"变热",
      u8"变焦",
      u8"变焦镜头",
      u8"变狭",
      u8"变率",
      u8"变现",
      u8"变甜",
      u8"变生不测",
      u8"变生肘腋",
      u8"变电",
      u8"变电器",
      u8"变电所",
      u8"变电站",
      u8"变白",
      u8"变白蛋白",
      u8"变相",
      u8"变相剥削",
      u8"变相加价",
      u8"变相处理",
      u8"变相涨价",
      u8"变相肘腋",
      u8"变着",
      u8"变着法儿",
      u8"变矩器",
      u8"变短",
      u8"变硬",
      u8"变种",
      u8"变空",
      u8"变粗",
      u8"变紧",
      u8"变红",
      u8"变线",
      u8"变细",
      u8"变给",
      u8"变绿",
      u8"变翘",
      u8"变胞藻黄素",
      u8"变胺蓝",
      u8"变脏",
      u8"变脸",
      u8"变脸变色",
      u8"变脸王",
      u8"变色",
      u8"变色之言",
      u8"变色易容",
      u8"变色机能",
      u8"变色杯",
      u8"变色牙",
      u8"变色笔",
      u8"变色蜴",
      u8"变色镜",
      u8"变色龙",
      u8"变节",
      u8"变节分子",
      u8"变节者",
      u8"变节自首",
      u8"变薄",
      u8"变蛋",
      u8"变被动为主动",
      u8"变视紫质",
      u8"变调",
      u8"变质",
      u8"变质处理",
      u8"变质岩",
      u8"变质石",
      u8"变质量系",
      u8"变贪厉薄",
      u8"变走",
      u8"变起",
      u8"变起来",
      u8"变跛",
      u8"变距阵",
      u8"变身",
      u8"变躬迁席",
      u8"变软",
      u8"变轻",
      u8"变迁",
      u8"变迁兴衰",
      u8"变过",
      u8"变过去",
      u8"变过来",
      u8"变迟",
      u8"变送器",
      u8"变通",
      u8"变通之计",
      u8"变通办法",
      u8"变通处理",
      u8"变通方法",
      u8"变通法",
      u8"变通途",
      u8"变速",
      u8"变速器",
      u8"变速机",
      u8"变速杆",
      u8"变速箱",
      u8"变速精灵",
      u8"变速装置",
      u8"变速运动",
      u8"变速齿轮",
      u8"变造",
      u8"变造出",
      u8"变配电",
      u8"变酸",
      u8"变醨养瘠",
      u8"变重",
      u8"变量",
      u8"变量值",
      u8"变量名",
      u8"变错",
      u8"变长",
      u8"变阵",
      u8"变阻器",
      u8"变青",
      u8"变青蛙",
      u8"变革",
      u8"变革时代",
      u8"变音",
      u8"变音器",
      u8"变音期",
      u8"变频",
      u8"变频器",
      u8"变频空调",
      u8"变频管",
      u8"变颜变色",
      u8"变风改俗",
      u8"变风易俗",
      u8"变风量",
      u8"变风量系统",
      u8"变魔术",
      u8"变黄金",
      u8"变黏",
      u8"变黑",
      u8"叙事",
      u8"叙事体",
      u8"叙事性",
      u8"叙事文",
      u8"叙事曲",
      u8"叙事歌曲",
      u8"叙事诗",
      u8"叙写",
      u8"叙利亚",
      u8"叙利亚人",
      u8"叙别",
      u8"叙功",
      u8"叙及",
      u8"叙叙",
      u8"叙叙旧",
      u8"叙家常",
      u8"叙情",
      u8"叙文",
      u8"叙旧",
      u8"叙永",
      u8"叙永县",
      u8"叙浦",
      u8"叙浦县",
      u8"叙言",
      u8"叙话",
      u8"叙说",
      u8"叙说着",
      u8"叙谈",
      u8"叙述",
      u8"叙述体",
      u8"叙述出来",
      u8"叙述性",
      u8"叙述法",
      u8"叙述着",
      u8"叙述者",
      u8"叛乱",
      u8"叛乱份子",
      u8"叛乱分子",
      u8"叛乱者",
      u8"叛党",
      u8"叛党叛国",
      u8"叛兵",
      u8"叛军",
      u8"叛匪",
      u8"叛卖",
      u8"叛变",
      u8"叛国",
      u8"叛国罪",
      u8"叛将",
      u8"叛徒",
      u8"叛敌",
      u8"叛离",
      u8"叛离正轨",
      u8"叛贼",
      u8"叛逃",
      u8"叛逆",
      u8"叛逆者",
      u8"叛逆行为",
      u8"叠了",
      u8"叠出",
      u8"叠出去",
      u8"叠出来",
      u8"叠前偏移",
      u8"叠加",
      u8"叠加定律",
      u8"叠加定理",
      u8"叠加速度",
      u8"叠印",
      u8"叠叠",
      u8"叠叠看",
      u8"叠句",
      u8"叠合",
      u8"叠在",
      u8"叠好",
      u8"叠字",
      u8"叠小",
      u8"叠嶂",
      u8"叠嶂层峦",
      u8"叠席",
      u8"叠平",
      u8"叠床",
      u8"叠床架屋",
      u8"叠彩区",
      u8"叠彩山",
      u8"叠成",
      u8"叠接",
      u8"叠来叠去",
      u8"叠氮",
      u8"叠氮化物",
      u8"叠氮吖啶",
      u8"叠氮钠",
      u8"叠片式磁头",
      u8"叠瓦状结构",
      u8"叠盖",
      u8"叠盖线",
      u8"叠矩重规",
      u8"叠石",
      u8"叠石为山",
      u8"叠罗汉",
      u8"叠置",
      u8"叠翠",
      u8"叠词",
      u8"叠起",
      u8"叠起来",
      u8"叠韵",
      u8"口上",
      u8"口下留情",
      u8"口不二价",
      u8"口不应心",
      u8"口不择言",
      u8"口中",
      u8"口中蚤虱",
      u8"口中雌黄",
      u8"口乾",
      u8"口乾舌燥",
      u8"口交",
      u8"口令",
      u8"口令句",
      u8"口伐",
      u8"口传",
      u8"口传心授",
      u8"口似悬河",
      u8"口供",
      u8"口信",
      u8"口儿",
      u8"口内",
      u8"口内描记器",
      u8"口内支抗",
      u8"口出",
      u8"口出不逊",
      u8"口出大言",
      u8"口出狂言",
      u8"口出秽言",
      u8"口到",
      u8"口北",
      u8"口印",
      u8"口口",
      u8"口口声声",
      u8"口口相传",
      u8"口号",
      u8"口吃",
      u8"口吃者",
      u8"口吐",
      u8"口吐珠玑",
      u8"口吐白沫",
      u8"口含天宪",
      u8"口吻",
      u8"口吻生花",
      u8"口呆目瞪",
      u8"口呆目钝",
      u8"口味",
      u8"口味淡",
      u8"口味重",
      u8"口呼",
      u8"口哨",
      u8"口哨儿",
      u8"口哨声",
      u8"口唇",
      u8"口喊",
      u8"口喊着",
      u8"口喻",
      u8"口器",
      u8"口坠天花",
      u8"口型",
      u8"口壅若川",
      u8"口外",
      u8"口外描记器",
      u8"口外支抗",
      u8"口多食寡",
      u8"口头",
      u8"口头上",
      u8"口头地",
      u8"口头报告",
      u8"口头文学",
      u8"口头禅",
      u8"口头语",
      u8"口如悬河",
      u8"口子",
      u8"口实",
      u8"口密腹剑",
      u8"口密腹箭",
      u8"口尚乳臭",
      u8"口岸",
      u8"口干",
      u8"口干燥症",
      u8"口干舌焦",
      u8"口干舌燥",
      u8"口形",
      u8"口径",
      u8"口德",
      u8"口快",
      u8"口快心直",
      u8"口惠",
      u8"口惠而实不至",
      u8"口感",
      u8"口才",
      u8"口才好",
      u8"口技",
      u8"口拙",
      u8"口授",
      u8"口授法",
      u8"口无择言",
      u8"口无遮拦",
      u8"口是心苗",
      u8"口是心非",
      u8"口服",
      u8"口服心不服",
      u8"口服心服",
      u8"口服液",
      u8"口服药",
      u8"口服避孕药",
      u8"口条",
      u8"口杯",
      u8"口气",
      u8"口水",
      u8"口水仗",
      u8"口水战",
      u8"口水直流",
      u8"口水鸡",
      u8"口沫",
      u8"口沫横飞",
      u8"口沸目赤",
      u8"口渴",
      u8"口渴难忍",
      u8"口湖",
      u8"口炎",
      u8"口燥唇干",
      u8"口燥脣乾",
      u8"口琴",
      u8"口生莲花",
      u8"口疮",
      u8"口盖",
      u8"口直心快",
      u8"口眼歪斜",
      u8"口碑",
      u8"口碑网",
      u8"口碑载道",
      u8"口碱",
      u8"口福",
      u8"口福不浅",
      u8"口禾",
      u8"口禾髎",
      u8"口称",
      u8"口算",
      u8"口粗",
      u8"口粮",
      u8"口紧",
      u8"口红",
      u8"口约",
      u8"口绝行语",
      u8"口缘",
      u8"口罩",
      u8"口耳",
      u8"口耳之学",
      u8"口耳并重",
      u8"口耳相传",
      u8"口耳相承",
      u8"口脣",
      u8"口腔",
      u8"口腔上颌窦瘘",
      u8"口腔伦理学",
      u8"口腔体腔摄影机",
      u8"口腔修复学",
      u8"口腔公共卫生",
      u8"口腔内科学",
      u8"口腔前庭",
      u8"口腔医学",
      u8"口腔医院",
      u8"口腔卫生",
      u8"口腔外科学",
      u8"口腔学",
      u8"口腔康复",
      u8"口腔急诊学",
      u8"口腔技工学",
      u8"口腔放射学",
      u8"口腔材料学",
      u8"口腔正畸学",
      u8"口腔正畸点焊机",
      u8"口腔法医学",
      u8"口腔淋巴上皮囊肿",
      u8"口腔溃疡",
      u8"口腔炎",
      u8"口腔生理学",
      u8"口腔疾病",
      u8"口腔病灶",
      u8"口腔病灶感染",
      u8"口腔病理学",
      u8"口腔癌",
      u8"口腔白斑症",
      u8"口腔种植学",
      u8"口腔科",
      u8"口腔粘膜",
      u8"口腔粘膜下纤维化",
      u8"口腔红斑",
      u8"口腔组织学",
      u8"口腔美容学",
      u8"口腔胚胎学",
      u8"口腔褥疮",
      u8"口腔诊所",
      u8"口腔诊断学",
      u8"口腔颌面外科学",
      u8"口腔颌面解剖学",
      u8"口腔麻醉学",
      u8"口腔黑斑症",
      u8"口腹",
      u8"口腹之欲",
      u8"口腹之累",
      u8"口臭",
      u8"口臭病",
      u8"口舌",
      u8"口舌之争",
      u8"口舌之利",
      u8"口若悬河",
      u8"口蘑",
      u8"口蜜腹剑",
      u8"口血未干",
      u8"口衔天宪",
      u8"口袋",
      u8"口袋书",
      u8"口袋吧",
      u8"口袋妖怪",
      u8"口角",
      u8"口角唇炎",
      u8"口角春风",
      u8"口角流涎",
      u8"口角炎",
      u8"口角生风",
      u8"口角线",
      u8"口角锋芒",
      u8"口角风情",
      u8"口讲指画",
      u8"口诀",
      u8"口词",
      u8"口译",
      u8"口译员",
      u8"口试",
      u8"口诛笔伐",
      u8"口语",
      u8"口语体",
      u8"口语化",
      u8"口语程度",
      u8"口语翻译",
      u8"口语记录",
      u8"口误",
      u8"口说",
      u8"口说无凭",
      u8"口诵",
      u8"口诵心惟",
      u8"口诵心维",
      u8"口请",
      u8"口谈",
      u8"口谐辞给",
      u8"口谕",
      u8"口蹄疫",
      u8"口蹄疫病毒",
      u8"口轻",
      u8"口轻舌薄",
      u8"口边",
      u8"口述",
      u8"口述出来",
      u8"口述法",
      u8"口部",
      u8"口里",
      u8"口重",
      u8"口镜",
      u8"口阝可",
      u8"口阿",
      u8"口难开",
      u8"口音",
      u8"口颌系统",
      u8"口风",
      u8"口香",
      u8"口香糖",
      u8"口鼻长",
      u8"口齿",
      u8"口齿不清",
      u8"口齿伶俐",
      u8"口齿清晰",
      u8"口齿清楚",
      u8"口齿生香",
      u8"古丈",
      u8"古丈县",
      u8"古为今用",
      u8"古乐",
      u8"古书",
      u8"古书屋",
      u8"古书店",
      u8"古云",
      u8"古井",
      u8"古井不波",
      u8"古井无波",
      u8"古交",
      u8"古交区",
      u8"古交市",
      u8"古亭",
      u8"古亭区",
      u8"古亭国中",
      u8"古亭国小",
      u8"古人",
      u8"古人云",
      u8"古人类",
      u8"古人类学",
      u8"古今",
      u8"古今中外",
      u8"古今有之",
      u8"古他",
      u8"古代",
      u8"古代人",
      u8"古代史",
      u8"古代性",
      u8"古代文学",
      u8"古代文明",
      u8"古代汉语",
      u8"古代社会",
      u8"古代篇",
      u8"古体",
      u8"古体文",
      u8"古体诗",
      u8"古佛",
      u8"古兰经",
      u8"古典",
      u8"古典主义",
      u8"古典作品",
      u8"古典名著",
      u8"古典学派",
      u8"古典家具",
      u8"古典小说",
      u8"古典建筑",
      u8"古典式",
      u8"古典式摔跤",
      u8"古典文学",
      u8"古典派",
      u8"古典舞",
      u8"古典艺术",
      u8"古典音乐",
      u8"古典风格",
      u8"古冶区",
      u8"古利特",
      u8"古刹",
      u8"古力特",
      u8"古北口",
      u8"古北新区",
      u8"古北界",
      u8"古卦",
      u8"古印度",
      u8"古历",
      u8"古厝",
      u8"古县",
      u8"古古怪怪",
      u8"古史",
      u8"古号",
      u8"古吉拉特",
      u8"古名",
      u8"古吴轩",
      u8"古国",
      u8"古土壤",
      u8"古圣先贤",
      u8"古地图",
      u8"古地理学",
      u8"古地磁地层学",
      u8"古坟",
      u8"古埃及",
      u8"古埃及建筑",
      u8"古城",
      u8"古城区",
      u8"古城墙",
      u8"古城热线",
      u8"古埙",
      u8"古堡",
      u8"古塔",
      u8"古塔区",
      u8"古墓",
      u8"古墓俪影",
      u8"古墓派",
      u8"古墓群",
      u8"古墓葬",
      u8"古天乐",
      u8"古奥",
      u8"古妆",
      u8"古字",
      u8"古宅",
      u8"古家具",
      u8"古寺",
      u8"古尔邦节",
      u8"古尸",
      u8"古屋",
      u8"古屋传奇",
      u8"古山",
      u8"古山龙",
      u8"古川",
      u8"古巨基",
      u8"古已有之",
      u8"古巴",
      u8"古巴人",
      u8"古巴共和国",
      u8"古巴战士",
      u8"古巴比伦",
      u8"古巴队",
      u8"古希腊",
      u8"古希腊建筑",
      u8"古庙",
      u8"古建",
      u8"古建筑",
      u8"古建筑群",
      u8"古往今来",
      u8"古径",
      u8"古德曼",
      u8"古德里安",
      u8"古怪",
      u8"古怪地",
      u8"古惑",
      u8"古惑仔",
      u8"古惑狼",
      u8"古意",
      u8"古意盎然",
      u8"古战场",
      u8"古拙",
      u8"古文",
      u8"古文体",
      u8"古文化",
      u8"古文字",
      u8"古文字学",
      u8"古文学",
      u8"古文明",
      u8"古文献",
      u8"古文观止",
      u8"古斯",
      u8"古斯塔",
      u8"古方",
      u8"古旧",
      u8"古旧书",
      u8"古时",
      u8"古时候",
      u8"古明华",
      u8"古昔",
      u8"古是今非",
      u8"古晋",
      u8"古曲",
      u8"古月",
      u8"古有名训",
      u8"古木",
      u8"古木参天",
      u8"古本",
      u8"古朴",
      u8"古村落",
      u8"古来",
      u8"古来有之",
      u8"古松",
      u8"古板",
      u8"古板板",
      u8"古柏",
      u8"古柯",
      u8"古柯硷",
      u8"古根汉姆",
      u8"古桥",
      u8"古植物鉴定",
      u8"古楼",
      u8"古槐",
      u8"古武术",
      u8"古比斯",
      u8"古民居",
      u8"古气候",
      u8"古水文学",
      u8"古汉",
      u8"古汉语",
      u8"古法",
      u8"古泽",
      u8"古浪",
      u8"古浪县",
      u8"古滨",
      u8"古灵精怪",
      u8"古物",
      u8"古猿",
      u8"古玉器",
      u8"古玩",
      u8"古玩城",
      u8"古玩店",
      u8"古琴",
      u8"古琴台",
      u8"古琴曲",
      u8"古生代",
      u8"古生物",
      u8"古生物学",
      u8"古生物学家",
      u8"古生物学界",
      u8"古生物鉴定",
      u8"古田",
      u8"古田县",
      u8"古画",
      u8"古皓",
      u8"古神",
      u8"古神庙",
      u8"古稀",
      u8"古稀之年",
      u8"古笃诚",
      u8"古筝",
      u8"古筝曲",
      u8"古籍",
      u8"古籍出版社",
      u8"古籍整理",
      u8"古紫色",
      u8"古细菌",
      u8"古罗马",
      u8"古老",
      u8"古老古朴",
      u8"古肥今瘠",
      u8"古色古香",
      u8"古若般",
      u8"古董",
      u8"古董商",
      u8"古董店",
      u8"古董表",
      u8"古董车",
      u8"古董铺",
      u8"古蔡试验",
      u8"古蔺",
      u8"古蔺县",
      u8"古蜥蜴",
      u8"古街",
      u8"古装",
      u8"古装剧",
      u8"古装戏",
      u8"古装片",
      u8"古训",
      u8"古诗",
      u8"古诗文",
      u8"古诗词",
      u8"古话",
      u8"古语",
      u8"古语云",
      u8"古语词",
      u8"古调不弹",
      u8"古调单弹",
      u8"古调独弹",
      u8"古谚",
      u8"古貌古心",
      u8"古贺",
      u8"古运河",
      u8"古远",
      u8"古迹",
      u8"古道",
      u8"古道循肠",
      u8"古道热肠",
      u8"古都",
      u8"古里古怪",
      u8"古钟",
      u8"古钢琴",
      u8"古钱",
      u8"古钱币",
      u8"古铜",
      u8"古铜色",
      u8"古镇",
      u8"古镇村",
      u8"古隆中",
      u8"古雅",
      u8"古音",
      u8"古韵",
      u8"古风",
      u8"古香古色",
      u8"古马乡",
      u8"古鸡",
      u8"古龙",
      u8"古龙水",
      u8"句中",
      u8"句句",
      u8"句句实话",
      u8"句号",
      u8"句型",
      u8"句型分析",
      u8"句型练习",
      u8"句子",
      u8"句子成分",
      u8"句子歧义消除",
      u8"句容",
      u8"句容县",
      u8"句容市",
      u8"句式",
      u8"句数",
      u8"句斟字酌",
      u8"句末",
      u8"句柄",
      u8"句栉字比",
      u8"句比字栉",
      u8"句法",
      u8"句法分析",
      u8"句法树",
      u8"句点",
      u8"句词",
      u8"句话",
      u8"句读",
      u8"句调",
      u8"句首",
      u8"另一",
      u8"另一个",
      u8"另一人",
      u8"另一位",
      u8"另一侧",
      u8"另一则",
      u8"另一半",
      u8"另一只",
      u8"另一台",
      u8"另一名",
      u8"另一回",
      u8"另一回事",
      u8"另一头",
      u8"另一家",
      u8"另一封",
      u8"另一帖",
      u8"另一手",
      u8"另一方",
      u8"另一方面",
      u8"另一样",
      u8"另一次",
      u8"另一版",
      u8"另一番",
      u8"另一种",
      u8"另一端",
      u8"另一类",
      u8"另一组",
      u8"另一边",
      u8"另一面",
      u8"另与",
      u8"另为",
      u8"另于",
      u8"另付",
      u8"另件",
      u8"另作",
      u8"另借",
      u8"另具",
      u8"另册",
      u8"另再",
      u8"另加",
      u8"另取",
      u8"另另外",
      u8"另向",
      u8"另听",
      u8"另告",
      u8"另唱",
      u8"另在",
      u8"另外",
      u8"另外用",
      u8"另存",
      u8"另存为",
      u8"另定",
      u8"另寄",
      u8"另寻",
      u8"另将",
      u8"另建",
      u8"另开",
      u8"另开一张",
      u8"另开生面",
      u8"另当别论",
      u8"另征",
      u8"另想办法",
      u8"另成",
      u8"另成一家",
      u8"另打",
      u8"另打主意",
      u8"另找",
      u8"另报",
      u8"另担",
      u8"另按",
      u8"另换",
      u8"另据",
      u8"另据报道",
      u8"另接",
      u8"另搞",
      u8"另搞一套",
      u8"另攀高枝",
      u8"另收",
      u8"另方面",
      u8"另日",
      u8"另有",
      u8"另有企图",
      u8"另有其",
      u8"另有所指",
      u8"另有打算",
      u8"另有新欢",
      u8"另有洞天",
      u8"另有隐情",
      u8"另有高就",
      u8"另样",
      u8"另案",
      u8"另案处理",
      u8"另楚寒巫",
      u8"另用",
      u8"另眼",
      u8"另眼相待",
      u8"另眼相看",
      u8"另眼看待",
      u8"另眼看戏",
      u8"另立",
      u8"另签",
      u8"另算",
      u8"另类",
      u8"另类版",
      u8"另纳",
      u8"另结新欢",
      u8"另给",
      u8"另缴",
      u8"另置",
      u8"另行",
      u8"另行安排",
      u8"另行规定",
      u8"另行通知",
      u8"另行高就",
      u8"另装",
      u8"另见",
      u8"另觅新欢",
      u8"另计",
      u8"另订",
      u8"另议",
      u8"另记",
      u8"另许",
      u8"另设",
      u8"另请",
      u8"另请高明",
      u8"另谋",
      u8"另谋出路",
      u8"另谋高就",
      u8"另购",
      u8"另起",
      u8"另起炉灶",
      u8"另辟",
      u8"另辟蹊径",
      u8"另述",
      u8"另选",
      u8"另通",
      u8"另配",
      u8"另附",
      u8"叨光",
      u8"叨叨",
      u8"叨咕",
      u8"叨唠",
      u8"叨在知己",
      u8"叨念",
      u8"叨扰",
      u8"叨教",
      u8"叨陪末座",
      u8"叩关",
      u8"叩出",
      u8"叩击",
      u8"叩击者",
      u8"叩响",
      u8"叩头",
      u8"叩头虫",
      u8"叩开",
      u8"叩得",
      u8"叩心泣血",
      u8"叩打",
      u8"叩拜",
      u8"叩来叩去",
      u8"叩源推委",
      u8"叩石垦壤",
      u8"叩见",
      u8"叩诊",
      u8"叩谢",
      u8"叩门",
      u8"叩门求见",
      u8"叩问",
      u8"叩阍",
      u8"叩阍无路",
      u8"叩首",
      u8"叩马而谏",
      u8"叩齿",
      u8"只不过",
      u8"只为",
      u8"只乐乡",
      u8"只争旦夕",
      u8"只争朝夕",
      u8"只代表",
      u8"只会",
      u8"只作",
      u8"只信",
      u8"只借不还",
      u8"只允许",
      u8"只准",
      u8"只凭",
      u8"只剩下",
      u8"只可以",
      u8"只可会意",
      u8"只可惜",
      u8"只可意会",
      u8"只可意会不可言传",
      u8"只可意会，不可言传",
      u8"只听楼梯响",
      u8"只听楼梯响不见人下来",
      u8"只听见",
      u8"只因",
      u8"只在乎",
      u8"只多不少",
      u8"只够",
      u8"只好",
      u8"只好去",
      u8"只好在",
      u8"只好来",
      u8"只字",
      u8"只字不提",
      u8"只字片纸",
      u8"只字片语",
      u8"只学",
      u8"只学会",
      u8"只学到",
      u8"只守",
      u8"只守不攻",
      u8"只守到",
      u8"只定",
      u8"只害",
      u8"只对",
      u8"只封",
      u8"只射",
      u8"只射到",
      u8"只将",
      u8"只就",
      u8"只尽",
      u8"只尽到",
      u8"只差",
      u8"只带",
      u8"只帮",
      u8"只帮忙",
      u8"只应",
      u8"只延",
      u8"只开",
      u8"只开出",
      u8"只开到",
      u8"只开去",
      u8"只开回",
      u8"只开来",
      u8"只当",
      u8"只录",
      u8"只录到",
      u8"只影",
      u8"只征",
      u8"只待",
      u8"只得",
      u8"只得到",
      u8"只忍",
      u8"只怕",
      u8"只怕会",
      u8"只怕是",
      u8"只怕有心人",
      u8"只思淫欲",
      u8"只怪",
      u8"只恐",
      u8"只想",
      u8"只想出",
      u8"只想到",
      u8"只想去",
      u8"只想哭",
      u8"只想来",
      u8"只愿",
      u8"只愿君心似我心",
      u8"只愿意",
      u8"只懂",
      u8"只懂得",
      u8"只成",
      u8"只戴",
      u8"只手遮天",
      u8"只提供",
      u8"只敢",
      u8"只是",
      u8"只是在",
      u8"只显示",
      u8"只有",
      u8"只有天",
      u8"只欠东风",
      u8"只此",
      u8"只此一家",
      u8"只此一家别无分店",
      u8"只求",
      u8"只求无过",
      u8"只求自保",
      u8"只爱",
      u8"只生一个好",
      u8"只用",
      u8"只用了",
      u8"只留下",
      u8"只知其一",
      u8"只知其一不知其二",
      u8"只知其一未知其二",
      u8"只知道",
      u8"只租不买",
      u8"只租不卖",
      u8"只管",
      u8"只缘身在此山中",
      u8"只羡鸳鸯不羡仙",
      u8"只肯",
      u8"只能",
      u8"只能靠",
      u8"只要",
      u8"只要功夫深",
      u8"只要功夫深铁杵磨成针",
      u8"只见",
      u8"只见树木",
      u8"只见树木不见森林",
      u8"只言",
      u8"只言片语",
      u8"只订",
      u8"只许",
      u8"只许州官放火",
      u8"只许州官放火不许百姓点灯",
      u8"只许成功",
      u8"只说不做",
      u8"只读",
      u8"只读光盘",
      u8"只读存储器",
      u8"只身",
      u8"只身一人",
      u8"只身孤影",
      u8"只轮不反",
      u8"只轮不返",
      u8"只轮无反",
      u8"只配",
      u8"只重衣衫不重人",
      u8"只闻其声",
      u8"只限",
      u8"只需",
      u8"只需要",
      u8"只顾",
      u8"只骑不反",
      u8"只鳞片爪",
      u8"只鳞片甲",
      u8"只鸡斗酒",
      u8"只鸡樽酒",
      u8"只鸡絮酒",
      u8"叫上",
      u8"叫上去",
      u8"叫上来",
      u8"叫下",
      u8"叫下去",
      u8"叫下来",
      u8"叫个",
      u8"叫个不停",
      u8"叫为",
      u8"叫买",
      u8"叫了",
      u8"叫些",
      u8"叫人",
      u8"叫什么",
      u8"叫他",
      u8"叫价",
      u8"叫住",
      u8"叫作",
      u8"叫你",
      u8"叫做",
      u8"叫停",
      u8"叫冤",
      u8"叫出",
      u8"叫出去",
      u8"叫出来",
      u8"叫到",
      u8"叫动",
      u8"叫劲",
      u8"叫化",
      u8"叫化子",
      u8"叫卖",
      u8"叫卖声",
      u8"叫卖网",
      u8"叫去",
      u8"叫叫",
      u8"叫号",
      u8"叫名",
      u8"叫吠",
      u8"叫唆",
      u8"叫唤",
      u8"叫唤声",
      u8"叫啸",
      u8"叫喊",
      u8"叫喊声",
      u8"叫嚣",
      u8"叫嚷",
      u8"叫嚷声",
      u8"叫回",
      u8"叫回去",
      u8"叫回来",
      u8"叫声",
      u8"叫外卖",
      u8"叫她",
      u8"叫好",
      u8"叫好不叫座",
      u8"叫好又叫座",
      u8"叫好声",
      u8"叫完",
      u8"叫对",
      u8"叫屈",
      u8"叫床",
      u8"叫床声",
      u8"叫座",
      u8"叫座不叫好",
      u8"叫座又叫好",
      u8"叫得",
      u8"叫急",
      u8"叫惯",
      u8"叫我",
      u8"叫春",
      u8"叫来",
      u8"叫板",
      u8"叫比",
      u8"叫法",
      u8"叫渴",
      u8"叫点",
      u8"叫牌",
      u8"叫真儿",
      u8"叫着",
      u8"叫给",
      u8"叫绝",
      u8"叫花子",
      u8"叫苦",
      u8"叫苦不迭",
      u8"叫苦叫累",
      u8"叫苦连天",
      u8"叫菜",
      u8"叫起",
      u8"叫起来",
      u8"叫车",
      u8"叫过",
      u8"叫过去",
      u8"叫过来",
      u8"叫进去",
      u8"叫进来",
      u8"叫醒",
      u8"叫错",
      u8"叫门",
      u8"叫门声",
      u8"叫阵",
      u8"叫驴",
      u8"叫骂",
      u8"叫骂声",
      u8"叫鬼",
      u8"叫魂",
      u8"叫鸡",
      u8"召之即来",
      u8"召之即来挥之即去",
      u8"召人",
      u8"召募",
      u8"召唤",
      u8"召唤兽",
      u8"召唤师",
      u8"召唤术",
      u8"召回",
      u8"召回公文",
      u8"召安",
      u8"召开",
      u8"召开会议",
      u8"召开大会",
      u8"召引",
      u8"召来",
      u8"召祸",
      u8"召租",
      u8"召见",
      u8"召请",
      u8"召集",
      u8"召集人",
      u8"召集令",
      u8"召集帖",
      u8"召集贴",
      u8"叭儿狗",
      u8"叭叭",
      u8"叭嗒",
      u8"叮人",
      u8"叮人战术",
      u8"叮叮",
      u8"叮叮噹噹",
      u8"叮叮当当",
      u8"叮呤当啷",
      u8"叮咚",
      u8"叮咛",
      u8"叮咬",
      u8"叮嘱",
      u8"叮噹",
      u8"叮噹响",
      u8"叮噹声",
      u8"叮当",
      u8"叮当作响",
      u8"叮当响",
      u8"叮当声",
      u8"叮当猫",
      u8"叮问",
      u8"可丁可卯",
      u8"可上",
      u8"可上去",
      u8"可上来",
      u8"可上演",
      u8"可下",
      u8"可下去",
      u8"可下来",
      u8"可不",
      u8"可不会",
      u8"可不可",
      u8"可不可以",
      u8"可不可能",
      u8"可不填",
      u8"可不是",
      u8"可不能",
      u8"可不行",
      u8"可为",
      u8"可乐",
      u8"可乐吧",
      u8"可乘",
      u8"可乘之机",
      u8"可乘之隙",
      u8"可也",
      u8"可也没",
      u8"可也没有",
      u8"可予",
      u8"可争议",
      u8"可于",
      u8"可交换",
      u8"可交谈",
      u8"可享受",
      u8"可亲",
      u8"可亲可敬",
      u8"可亲可近",
      u8"可人",
      u8"可从",
      u8"可仑坡",
      u8"可他",
      u8"可以",
      u8"可以信赖",
      u8"可以吗",
      u8"可以用",
      u8"可以获得",
      u8"可以说",
      u8"可以说是",
      u8"可任意",
      u8"可会",
      u8"可传",
      u8"可传播",
      u8"可伦坡",
      u8"可估价",
      u8"可体",
      u8"可作",
      u8"可佩",
      u8"可使",
      u8"可供",
      u8"可供使用",
      u8"可供参考",
      u8"可供执行",
      u8"可依",
      u8"可保存",
      u8"可信",
      u8"可信任",
      u8"可信度",
      u8"可信度函数",
      u8"可信性",
      u8"可信计算",
      u8"可信赖",
      u8"可修改性",
      u8"可修理",
      u8"可假定",
      u8"可做饭",
      u8"可停",
      u8"可偿还",
      u8"可储存",
      u8"可充电",
      u8"可先",
      u8"可先去",
      u8"可先来",
      u8"可免",
      u8"可免于",
      u8"可兑换",
      u8"可兑换性",
      u8"可公度子群",
      u8"可兰经",
      u8"可再生",
      u8"可再生能源",
      u8"可再生资源",
      u8"可写",
      u8"可决定",
      u8"可减轻",
      u8"可凭",
      u8"可出",
      u8"可出租",
      u8"可分",
      u8"可分为",
      u8"可分元",
      u8"可分张量",
      u8"可分析",
      u8"可分离",
      u8"可分离性",
      u8"可分类",
      u8"可分解",
      u8"可分页区域",
      u8"可切除",
      u8"可列举",
      u8"可判",
      u8"可判定性",
      u8"可利用",
      u8"可别",
      u8"可到",
      u8"可加",
      u8"可加可减",
      u8"可加工",
      u8"可动性",
      u8"可动摇",
      u8"可动油图",
      u8"可动牙科治疗台",
      u8"可医好",
      u8"可卑",
      u8"可占",
      u8"可卡因",
      u8"可卡犬",
      u8"可印刷",
      u8"可压",
      u8"可压榨",
      u8"可压缩",
      u8"可压缩性",
      u8"可厌",
      u8"可去",
      u8"可反对",
      u8"可发",
      u8"可发一噱",
      u8"可发表",
      u8"可取",
      u8"可取之处",
      u8"可取消",
      u8"可受",
      u8"可变",
      u8"可变参数模型",
      u8"可变形体",
      u8"可变性",
      u8"可变电容",
      u8"可变电容器",
      u8"可变电阻",
      u8"可变码率",
      u8"可变聚腺苷酸化",
      u8"可变资本",
      u8"可变转录",
      u8"可变阈逻辑",
      u8"可口",
      u8"可口可乐",
      u8"可可",
      u8"可可亚",
      u8"可可儿的",
      u8"可可托海",
      u8"可可树",
      u8"可可油",
      u8"可可粉",
      u8"可可茶",
      u8"可可西",
      u8"可可西里",
      u8"可可西里山",
      u8"可可豆",
      u8"可叹",
      u8"可向",
      u8"可否",
      u8"可听",
      u8"可听度曲线",
      u8"可听性",
      u8"可吸入",
      u8"可吸入颗粒物",
      u8"可吸收",
      u8"可和解",
      u8"可哀",
      u8"可品尝",
      u8"可哦就",
      u8"可售性",
      u8"可唱",
      u8"可喜",
      u8"可喜可贺",
      u8"可喜局面",
      u8"可喜成果",
      u8"可喜成绩",
      u8"可喜进步",
      u8"可嘉",
      u8"可回复",
      u8"可回忆",
      u8"可回收",
      u8"可因",
      u8"可园",
      u8"可圈可点",
      u8"可在",
      u8"可坐",
      u8"可塑",
      u8"可塑性",
      u8"可增加",
      u8"可复用构件",
      u8"可多",
      u8"可多可少",
      u8"可大",
      u8"可大可小",
      u8"可好",
      u8"可好了",
      u8"可存取性",
      u8"可学",
      u8"可守可攻",
      u8"可安装性",
      u8"可定义",
      u8"可定义性",
      u8"可容",
      u8"可容忍",
      u8"可宽恕",
      u8"可宽恕性",
      u8"可察觉",
      u8"可对",
      u8"可将",
      u8"可尊敬",
      u8"可小可大",
      u8"可少不了",
      u8"可少可多",
      u8"可就",
      u8"可居住",
      u8"可居住性",
      u8"可展性",
      u8"可巧",
      u8"可广泛",
      u8"可应用",
      u8"可度量化",
      u8"可延",
      u8"可延续性",
      u8"可延长",
      u8"可建性",
      u8"可引用",
      u8"可引用性",
      u8"可归约性",
      u8"可归罪",
      u8"可归还",
      u8"可当",
      u8"可录音",
      u8"可往",
      u8"可征服",
      u8"可征税",
      u8"可待因",
      u8"可得",
      u8"可得到",
      u8"可循",
      u8"可心",
      u8"可心如意",
      u8"可忍受",
      u8"可怕",
      u8"可怕地",
      u8"可怖",
      u8"可怜",
      u8"可怜可悯",
      u8"可怜夜半虚前席",
      u8"可怜天下父母心",
      u8"可怜巴巴",
      u8"可怜相",
      u8"可怜虫",
      u8"可恢复",
      u8"可恨",
      u8"可恶",
      u8"可恼",
      u8"可悲",
      u8"可悲可叹",
      u8"可惊可叹",
      u8"可惜",
      u8"可想",
      u8"可想到",
      u8"可想而知",
      u8"可意",
      u8"可愿",
      u8"可愿意",
      u8"可慢可快",
      u8"可憎",
      u8"可成形",
      u8"可我",
      u8"可执行",
      u8"可执行文件",
      u8"可扩充性",
      u8"可扩展置标语言",
      u8"可扩缩一致性接口",
      u8"可把",
      u8"可抑制",
      u8"可投",
      u8"可折叠",
      u8"可折式衣架",
      u8"可抢救",
      u8"可抹掉",
      u8"可抽吸",
      u8"可拆卸",
      u8"可拆式隔断",
      u8"可拉",
      u8"可拉明",
      u8"可拍照",
      u8"可拒绝",
      u8"可拔",
      u8"可拜访",
      u8"可拨打",
      u8"可持续发展",
      u8"可持续性",
      u8"可按",
      u8"可挖苦",
      u8"可挡",
      u8"可挽回",
      u8"可捐",
      u8"可接受",
      u8"可接受性",
      u8"可接近",
      u8"可控",
      u8"可控因素",
      u8"可控孔度",
      u8"可控性",
      u8"可控源声频大地电磁法",
      u8"可控硅",
      u8"可控硅整流器",
      u8"可控硅整流直流电驱动钻机",
      u8"可控表面",
      u8"可控表面多孔",
      u8"可控表面孔度",
      u8"可控表面孔度支持体",
      u8"可控规范形",
      u8"可控震源法",
      u8"可推断",
      u8"可提供",
      u8"可摇",
      u8"可摘义齿修复学",
      u8"可摘局部义齿",
      u8"可摘局部义齿修复学",
      u8"可摘矫治器",
      u8"可撤回",
      u8"可撤消信用证",
      u8"可播放",
      u8"可操作",
      u8"可操作性",
      u8"可操左券",
      u8"可操纵",
      u8"可擦写光盘",
      u8"可擦可编程只读存储器",
      u8"可擦掉",
      u8"可擦编程只读存储器",
      u8"可攀登",
      u8"可支配",
      u8"可支配收入",
      u8"可收",
      u8"可收回",
      u8"可改正",
      u8"可攻",
      u8"可攻克",
      u8"可攻可守",
      u8"可放",
      u8"可救",
      u8"可教",
      u8"可敬",
      u8"可敬可佩",
      u8"可数",
      u8"可数名词",
      u8"可无",
      u8"可是",
      u8"可是会",
      u8"可是她",
      u8"可是有",
      u8"可是要",
      u8"可是那",
      u8"可更改",
      u8"可更新",
      u8"可曾",
      u8"可有",
      u8"可有可无",
      u8"可望",
      u8"可望不可即",
      u8"可望在",
      u8"可望而不可即",
      u8"可望而不可及",
      u8"可期",
      u8"可构成性",
      u8"可染",
      u8"可染性",
      u8"可查",
      u8"可根据",
      u8"可模仿",
      u8"可欺",
      u8"可歇可泣",
      u8"可歌可泣",
      u8"可比",
      u8"可比价格",
      u8"可比克",
      u8"可比性",
      u8"可气",
      u8"可气化",
      u8"可氧化",
      u8"可求",
      u8"可汗",
      u8"可汽化",
      u8"可没",
      u8"可没收",
      u8"可没有",
      u8"可治疗",
      u8"可沿",
      u8"可泣可歌",
      u8"可测量",
      u8"可测集值函数",
      u8"可消化",
      u8"可液化",
      u8"可渗基区晶体管",
      u8"可渗透",
      u8"可湿",
      u8"可湿性",
      u8"可湿性粉剂",
      u8"可溶",
      u8"可溶性",
      u8"可溶解",
      u8"可演",
      u8"可点",
      u8"可然律",
      u8"可然性",
      u8"可熄灭",
      u8"可燃",
      u8"可燃冰",
      u8"可燃度极限",
      u8"可燃性",
      u8"可燃有机岩",
      u8"可燃气体探测器",
      u8"可燃气探测系统",
      u8"可燃物",
      u8"可燃物质",
      u8"可爬",
      u8"可爱",
      u8"可爱多",
      u8"可爱女生",
      u8"可爱淘",
      u8"可牺牲",
      u8"可玩性",
      u8"可理解",
      u8"可生产",
      u8"可用",
      u8"可用内存",
      u8"可用到",
      u8"可用在",
      u8"可用性",
      u8"可用资产",
      u8"可由",
      u8"可申请",
      u8"可畏",
      u8"可疑",
      u8"可疑人物",
      u8"可疑分子",
      u8"可疑地",
      u8"可登记",
      u8"可的松",
      u8"可直接",
      u8"可看",
      u8"可看性",
      u8"可真会",
      u8"可真是",
      u8"可真有",
      u8"可真能",
      u8"可真要",
      u8"可知",
      u8"可知性",
      u8"可研磨性",
      u8"可种植",
      u8"可租",
      u8"可积微分方程组",
      u8"可称",
      u8"可移式底座",
      u8"可移植性",
      u8"可穿",
      u8"可穿戴计算机",
      u8"可穿著",
      u8"可穿透",
      u8"可笑",
      u8"可笑不自量",
      u8"可简化",
      u8"可算",
      u8"可算是",
      u8"可管理性",
      u8"可米",
      u8"可米小子",
      u8"可紧可松",
      u8"可纠正",
      u8"可约表示",
      u8"可纺性",
      u8"可组",
      u8"可组合",
      u8"可组织",
      u8"可结晶段",
      u8"可统一",
      u8"可继承",
      u8"可维护性",
      u8"可维持",
      u8"可缓和",
      u8"可编",
      u8"可编程",
      u8"可编程只读存储器",
      u8"可编程控制器",
      u8"可编程横向滤波器",
      u8"可编程逻辑器件",
      u8"可编程逻辑阵列",
      u8"可考",
      u8"可耕地",
      u8"可耻",
      u8"可耻下场",
      u8"可背",
      u8"可能",
      u8"可能会",
      u8"可能再",
      u8"可能发生",
      u8"可能在",
      u8"可能性",
      u8"可能是",
      u8"可能有",
      u8"可能要",
      u8"可自由兑换货币",
      u8"可苏醒",
      u8"可获",
      u8"可获得",
      u8"可藏",
      u8"可虑",
      u8"可行",
      u8"可行之道",
      u8"可行性",
      u8"可行性研究",
      u8"可行方向",
      u8"可表明",
      u8"可表示",
      u8"可被",
      u8"可被粉碎",
      u8"可裂变核素",
      u8"可裂短正合序列",
      u8"可要",
      u8"可覆盖图",
      u8"可见",
      u8"可见一斑",
      u8"可见光",
      u8"可见度",
      u8"可见得",
      u8"可观",
      u8"可观上",
      u8"可观察量",
      u8"可观规律",
      u8"可视",
      u8"可视化",
      u8"可视区",
      u8"可视性",
      u8"可视电话",
      u8"可视编程语言",
      u8"可解决",
      u8"可解脱式系泊系统",
      u8"可解释",
      u8"可言",
      u8"可计数",
      u8"可计算",
      u8"可计算函数",
      u8"可让",
      u8"可议之处",
      u8"可设",
      u8"可证实",
      u8"可诉",
      u8"可诉讼",
      u8"可说",
      u8"可说是",
      u8"可说服",
      u8"可读",
      u8"可读性",
      u8"可调",
      u8"可调整",
      u8"可谓",
      u8"可责备",
      u8"可贵",
      u8"可贵地",
      u8"可贵性",
      u8"可贵精神",
      u8"可贺",
      u8"可资利用",
      u8"可赔",
      u8"可赛",
      u8"可起来",
      u8"可身",
      u8"可转债",
      u8"可转换元素",
      u8"可辨",
      u8"可辨认",
      u8"可辩护",
      u8"可辩论",
      u8"可达",
      u8"可达性",
      u8"可达标识图",
      u8"可达标识集",
      u8"可过",
      u8"可过去",
      u8"可过来",
      u8"可运",
      u8"可运到",
      u8"可这",
      u8"可进",
      u8"可进去",
      u8"可进口",
      u8"可进可退",
      u8"可进来",
      u8"可追求",
      u8"可追溯",
      u8"可追踪",
      u8"可退回",
      u8"可适当",
      u8"可逆",
      u8"可逆反应",
      u8"可逆性",
      u8"可逆电极电势",
      u8"可逆过程",
      u8"可选",
      u8"可选择",
      u8"可选项",
      u8"可递降",
      u8"可通过",
      u8"可造之才",
      u8"可逼近性",
      u8"可遇不可求",
      u8"可遇而不可求",
      u8"可遗坐标",
      u8"可邀",
      u8"可都",
      u8"可都是",
      u8"可鄙",
      u8"可配",
      u8"可采用",
      u8"可重获",
      u8"可锻铸铁",
      u8"可长可短",
      u8"可问",
      u8"可闻",
      u8"可防",
      u8"可防御",
      u8"可防止",
      u8"可降解",
      u8"可限",
      u8"可限制",
      u8"可陪",
      u8"可随",
      u8"可随着",
      u8"可靠",
      u8"可靠人士",
      u8"可靠保证",
      u8"可靠地",
      u8"可靠性",
      u8"可靠性分析",
      u8"可靠性工程",
      u8"可靠性数据",
      u8"可靠性理论",
      u8"可靠性统计",
      u8"可靠消息",
      u8"可预付",
      u8"可预见到",
      u8"可预言",
      u8"可风",
      u8"可食用",
      u8"可食用性",
      u8"可饮用",
      u8"可饱和",
      u8"可驯养",
      u8"可驳斥",
      u8"可验证",
      u8"可骑",
      u8"台上",
      u8"台上台下",
      u8"台下",
      u8"台下十年功",
      u8"台下盆",
      u8"台东",
      u8"台东人",
      u8"台东县",
      u8"台东市",
      u8"台东师范",
      u8"台东师范学院",
      u8"台中",
      u8"台中人",
      u8"台中县",
      u8"台中合资",
      u8"台中商专",
      u8"台中市",
      u8"台中师范",
      u8"台中师范学院",
      u8"台中港",
      u8"台中盆地",
      u8"台位",
      u8"台儿庄",
      u8"台儿庄区",
      u8"台军方",
      u8"台凤",
      u8"台凤公司",
      u8"台制",
      u8"台制品",
      u8"台前",
      u8"台前县",
      u8"台前台后",
      u8"台前幕后",
      u8"台剧",
      u8"台办",
      u8"台北",
      u8"台北人",
      u8"台北体专",
      u8"台北区",
      u8"台北医学",
      u8"台北医学院",
      u8"台北县",
      u8"台北商专",
      u8"台北工专",
      u8"台北工业",
      u8"台北工业专科学校",
      u8"台北市",
      u8"台北市立",
      u8"台北市立师范学校",
      u8"台北师范",
      u8"台北师范学院",
      u8"台北师院",
      u8"台北护专",
      u8"台北护理",
      u8"台北护理专科学校",
      u8"台北桥",
      u8"台北盆地",
      u8"台北讯",
      u8"台北路",
      u8"台北队",
      u8"台南",
      u8"台南人",
      u8"台南县",
      u8"台南家专",
      u8"台南市",
      u8"台南师范",
      u8"台南师范学院",
      u8"台卡仪",
      u8"台历",
      u8"台后",
      u8"台启",
      u8"台唇",
      u8"台商",
      u8"台地",
      u8"台地前缘斜坡相",
      u8"台基",
      u8"台塑",
      u8"台大",
      u8"台大医院",
      u8"台大学生",
      u8"台子",
      u8"台安",
      u8"台安县",
      u8"台尺",
      u8"台属",
      u8"台山",
      u8"台山县",
      u8"台山市",
      u8"台岛",
      u8"台州",
      u8"台州市",
      u8"台币",
      u8"台布",
      u8"台座",
      u8"台式",
      u8"台式机",
      u8"台当局",
      u8"台怀镇",
      u8"台扇",
      u8"台拉维夫",
      u8"台数",
      u8"台斤",
      u8"台服",
      u8"台本",
      u8"台机",
      u8"台架",
      u8"台柱",
      u8"台柱子",
      u8"台标",
      u8"台榭",
      u8"台次",
      u8"台步",
      u8"台毯",
      u8"台江",
      u8"台江区",
      u8"台江县",
      u8"台汽",
      u8"台汽客运",
      u8"台海",
      u8"台海两岸",
      u8"台港",
      u8"台港澳",
      u8"台湾",
      u8"台湾事务办公室",
      u8"台湾事务管理局",
      u8"台湾人",
      u8"台湾光复",
      u8"台湾光复节",
      u8"台湾区",
      u8"台湾同胞",
      u8"台湾同胞联谊会",
      u8"台湾地区",
      u8"台湾大学",
      u8"台湾大学附属医学院",
      u8"台湾岛",
      u8"台湾工业",
      u8"台湾工业技术学院",
      u8"台湾师范",
      u8"台湾师范大学",
      u8"台湾当局",
      u8"台湾成人",
      u8"台湾教育",
      u8"台湾教育学院",
      u8"台湾日报",
      u8"台湾歌手",
      u8"台湾民主自治同盟",
      u8"台湾水果",
      u8"台湾汽车",
      u8"台湾汽车客运公司",
      u8"台湾海峡",
      u8"台湾海洋",
      u8"台湾海洋学院",
      u8"台湾版",
      u8"台湾独立",
      u8"台湾玉",
      u8"台湾电力",
      u8"台湾电力公司",
      u8"台湾电视",
      u8"台湾电视公司",
      u8"台湾疗养",
      u8"台湾疗养院",
      u8"台湾省",
      u8"台湾省政",
      u8"台湾省政府",
      u8"台湾省立",
      u8"台湾神学",
      u8"台湾神学院",
      u8"台湾糖业",
      u8"台湾糖业公司",
      u8"台湾网",
      u8"台湾肥料",
      u8"台湾肥料公司",
      u8"台湾航业",
      u8"台湾航业公司",
      u8"台湾艺术",
      u8"台湾艺术专科学校",
      u8"台湾铝业",
      u8"台湾铝业公司",
      u8"台湾银行",
      u8"台湾问题",
      u8"台湾队",
      u8"台澎",
      u8"台澎金马",
      u8"台灯",
      u8"台照",
      u8"台独",
      u8"台独分子",
      u8"台独运动",
      u8"台玻",
      u8"台球",
      u8"台球厅",
      u8"台球城",
      u8"台球室",
      u8"台球桌",
      u8"台甫",
      u8"台电",
      u8"台电公司",
      u8"台盟",
      u8"台省",
      u8"台秤",
      u8"台端",
      u8"台笔",
      u8"台糖",
      u8"台糖公司",
      u8"台网",
      u8"台联",
      u8"台联党",
      u8"台肥",
      u8"台背斜",
      u8"台胞",
      u8"台胞证",
      u8"台航",
      u8"台菜",
      u8"台菜餐厅",
      u8"台衔",
      u8"台装",
      u8"台装货",
      u8"台西",
      u8"台视",
      u8"台视公司",
      u8"台词",
      u8"台语",
      u8"台语歌",
      u8"台账",
      u8"台资",
      u8"台路沟乡",
      u8"台车",
      u8"台轮",
      u8"台金",
      u8"台鉴",
      u8"台钟",
      u8"台钳",
      u8"台钻",
      u8"台铝",
      u8"台银",
      u8"台镜",
      u8"台长",
      u8"台阁",
      u8"台阁生风",
      u8"台阶",
      u8"台阶色谱法",
      u8"台阶覆盖",
      u8"台面",
      u8"台面晶体管",
      u8"台风",
      u8"台风稳健",
      u8"台驾",
      u8"叱吒",
      u8"叱吒风云",
      u8"叱咤",
      u8"叱咤风云",
      u8"叱喝",
      u8"叱嗟风云",
      u8"叱诧风云",
      u8"叱责",
      u8"叱问",
      u8"叱骂",
      u8"史上",
      u8"史不绝书",
      u8"史丹佛大",
      u8"史丹佛大学",
      u8"史丹利",
      u8"史书",
      u8"史事",
      u8"史仲俊",
      u8"史仲猛",
      u8"史传",
      u8"史传小说",
      u8"史伯威",
      u8"史兰芽",
      u8"史册",
      u8"史前",
      u8"史前时代",
      u8"史努比",
      u8"史叔刚",
      u8"史可",
      u8"史可夫",
      u8"史地",
      u8"史奴比",
      u8"史孟龙",
      u8"史季强",
      u8"史学",
      u8"史学史",
      u8"史学家",
      u8"史学方法",
      u8"史学界",
      u8"史官",
      u8"史实",
      u8"史家",
      u8"史家庄",
      u8"史密斯",
      u8"史密斯圆图",
      u8"史小翠",
      u8"史展",
      u8"史崇仁",
      u8"史志",
      u8"史忠萍",
      u8"史抄",
      u8"史文彬",
      u8"史料",
      u8"史料选编",
      u8"史无前例",
      u8"史松",
      u8"史正阳",
      u8"史河",
      u8"史火龙",
      u8"史特劳斯",
      u8"史瑞克",
      u8"史瓦西",
      u8"史略",
      u8"史登达",
      u8"史研究",
      u8"史秉光",
      u8"史秉文",
      u8"史称",
      u8"史稿",
      u8"史籍",
      u8"史红石",
      u8"史纲",
      u8"史良",
      u8"史莱克",
      u8"史莱姆",
      u8"史蒂夫",
      u8"史蒂文斯",
      u8"史蒂文森",
      u8"史蒂芬",
      u8"史观",
      u8"史记",
      u8"史记卷",
      u8"史论",
      u8"史论家",
      u8"史评",
      u8"史诗",
      u8"史诗作者",
      u8"史诗性",
      u8"史诗片",
      u8"史话",
      u8"史语所",
      u8"史载",
      u8"史达林",
      u8"史迪威",
      u8"史迹",
      u8"史酷比",
      u8"史鑫",
      u8"史铁生",
      u8"史镖头",
      u8"史馆",
      u8"右上",
      u8"右上方",
      u8"右上角",
      u8"右下",
      u8"右下方",
      u8"右下角",
      u8"右中前卫",
      u8"右中后卫",
      u8"右乘环",
      u8"右书僮",
      u8"右乳",
      u8"右云",
      u8"右云县",
      u8"右传之八章",
      u8"右侍郎",
      u8"右侧",
      u8"右倾",
      u8"右倾分子",
      u8"右倾机会",
      u8"右倾机会主义",
      u8"右军",
      u8"右军习气",
      u8"右击",
      u8"右列环",
      u8"右券",
      u8"右前",
      u8"右前卫",
      u8"右前方",
      u8"右前锋",
      u8"右半",
      u8"右半块",
      u8"右半球",
      u8"右半部",
      u8"右卫",
      u8"右后",
      u8"右后卫",
      u8"右后方",
      u8"右声道",
      u8"右安门",
      u8"右对齐",
      u8"右导数",
      u8"右小腿",
      u8"右幺元",
      u8"右序模",
      u8"右心室",
      u8"右心房",
      u8"右手",
      u8"右手定则",
      u8"右手掌",
      u8"右手画圆",
      u8"右手画圆左手画方",
      u8"右手边",
      u8"右拳",
      u8"右摇杆",
      u8"右方",
      u8"右旋",
      u8"右旋晶体",
      u8"右旋糖酐",
      u8"右旗",
      u8"右江",
      u8"右江区",
      u8"右派",
      u8"右派分子",
      u8"右玉",
      u8"右玉县",
      u8"右白虎",
      u8"右眉",
      u8"右眼",
      u8"右矢",
      u8"右移",
      u8"右端",
      u8"右端参数问题",
      u8"右线性文法",
      u8"右翦左屠",
      u8"右翼",
      u8"右翼中旗",
      u8"右翼前旗",
      u8"右翼后旗",
      u8"右耳",
      u8"右肋",
      u8"右肩",
      u8"右肺",
      u8"右肾",
      u8"右脑",
      u8"右脚",
      u8"右腿",
      u8"右腿骨",
      u8"右膝",
      u8"右膝盖",
      u8"右臂",
      u8"右舷",
      u8"右行",
      u8"右角",
      u8"右诺特环",
      u8"右路",
      u8"右转",
      u8"右边",
      u8"右边前卫",
      u8"右边后卫",
      u8"右边锋",
      u8"右钩拳",
      u8"右锋",
      u8"右键",
      u8"右阿廷环",
      u8"右零因子",
      u8"右面",
      u8"右顷",
      u8"右颊",
      u8"右首",
      u8"叵测",
      u8"叵测之心",
      u8"叶世荣",
      u8"叶丛",
      u8"叶丽仪",
      u8"叶二娘",
      u8"叶佩雯",
      u8"叶倩文",
      u8"叶倾城",
      u8"叶全真",
      u8"叶公好龙",
      u8"叶公超",
      u8"叶兰",
      u8"叶利钦",
      u8"叶剑英",
      u8"叶卡捷琳堡",
      u8"叶县",
      u8"叶叶",
      u8"叶圣陶",
      u8"叶城",
      u8"叶城县",
      u8"叶天龙",
      u8"叶子",
      u8"叶子奇",
      u8"叶子媚",
      u8"叶子楣",
      u8"叶子烟",
      u8"叶子花",
      u8"叶宗留",
      u8"叶对生",
      u8"叶小文",
      u8"叶尖",
      u8"叶尼基河",
      u8"叶尼塞河",
      u8"叶序",
      u8"叶开道",
      u8"叶德娴",
      u8"叶惠美",
      u8"叶惠贤",
      u8"叶挺",
      u8"叶挻",
      u8"叶文辉",
      u8"叶斑",
      u8"叶斑病",
      u8"叶昊天",
      u8"叶星雨",
      u8"叶晨",
      u8"叶朗",
      u8"叶枝",
      u8"叶柄",
      u8"叶树",
      u8"叶树茵",
      u8"叶梗",
      u8"叶永烈",
      u8"叶浅予",
      u8"叶片",
      u8"叶片式混砂器",
      u8"叶片泵",
      u8"叶状",
      u8"叶状乳头炎",
      u8"叶猴",
      u8"叶玉卿",
      u8"叶璇",
      u8"叶甜菜",
      u8"叶甫盖尼奥涅金",
      u8"叶瘦花残",
      u8"叶窗",
      u8"叶童",
      u8"叶笃正",
      u8"叶红素",
      u8"叶绿体",
      u8"叶绿素",
      u8"叶翠翠",
      u8"叶耳",
      u8"叶肉",
      u8"叶脉",
      u8"叶脤",
      u8"叶腋",
      u8"叶舌",
      u8"叶芝",
      u8"叶芽",
      u8"叶芽儿",
      u8"叶茂",
      u8"叶茂中",
      u8"叶茎",
      u8"叶菜类蔬菜",
      u8"叶落归根",
      u8"叶落知秋",
      u8"叶蓓",
      u8"叶蕴仪",
      u8"叶蜂",
      u8"叶赫那拉",
      u8"叶轮",
      u8"叶选平",
      u8"叶酸",
      u8"叶酸片",
      u8"叶针",
      u8"叶钊颖",
      u8"叶锈病",
      u8"叶长青",
      u8"叶门",
      u8"叶面",
      u8"叶面施肥",
      u8"叶面积",
      u8"叶面肥",
      u8"叶鞘",
      u8"叶韵",
      u8"叶飞",
      u8"叶黄杨",
      u8"叶黄素",
      u8"号丧",
      u8"号为",
      u8"号令",
      u8"号令如山",
      u8"号兵",
      u8"号叫",
      u8"号召",
      u8"号召书",
      u8"号召力",
      u8"号咷大哭",
      u8"号哭",
      u8"号啕",
      u8"号啕大哭",
      u8"号型",
      u8"号声",
      u8"号外",
      u8"号天扣地",
      u8"号头",
      u8"号子",
      u8"号子声",
      u8"号寒啼讥",
      u8"号寒啼饥",
      u8"号徽",
      u8"号志",
      u8"号志灯",
      u8"号房",
      u8"号手",
      u8"号数",
      u8"号旗",
      u8"号淘大哭",
      u8"号源",
      u8"号灯",
      u8"号炮",
      u8"号牌",
      u8"号码",
      u8"号码机",
      u8"号码灯",
      u8"号码牌",
      u8"号称",
      u8"号笛",
      u8"号筒",
      u8"号脉",
      u8"号衣",
      u8"号角",
      u8"号角声",
      u8"号音",
      u8"司业",
      u8"司乘人员",
      u8"司书",
      u8"司令",
      u8"司令台",
      u8"司令员",
      u8"司令官",
      u8"司令部",
      u8"司仪",
      u8"司农仰屋",
      u8"司农司",
      u8"司务",
      u8"司务长",
      u8"司南",
      u8"司号",
      u8"司号员",
      u8"司各脱",
      u8"司命",
      u8"司售",
      u8"司售人员",
      u8"司塔斯弗",
      u8"司寇",
      u8"司寨村",
      u8"司局",
      u8"司局级",
      u8"司库",
      u8"司徒",
      u8"司徒伯雷",
      u8"司徒千钟",
      u8"司徒横",
      u8"司徒雷",
      u8"司徒鹤",
      u8"司政",
      u8"司晨",
      u8"司机",
      u8"司机员",
      u8"司汤达",
      u8"司法",
      u8"司法上",
      u8"司法人员",
      u8"司法会计",
      u8"司法公正",
      u8"司法制度",
      u8"司法厅",
      u8"司法员",
      u8"司法官",
      u8"司法宫",
      u8"司法局",
      u8"司法所",
      u8"司法机关",
      u8"司法权",
      u8"司法案例",
      u8"司法独立",
      u8"司法界",
      u8"司法程序",
      u8"司法考试",
      u8"司法腐败",
      u8"司法解释",
      u8"司法警察",
      u8"司法部",
      u8"司法部部长",
      u8"司法部长",
      u8"司法部门",
      u8"司法鉴定",
      u8"司法院",
      u8"司法院长",
      u8"司炉",
      u8"司炉工",
      u8"司空",
      u8"司空玄",
      u8"司空见惯",
      u8"司线员",
      u8"司考",
      u8"司药",
      u8"司钻房",
      u8"司钻控制台",
      u8"司铎",
      u8"司长",
      u8"司长级",
      u8"司门前镇",
      u8"司马",
      u8"司马义",
      u8"司马光",
      u8"司马南",
      u8"司马台",
      u8"司马大",
      u8"司马懿",
      u8"司马昭",
      u8"司马昭之心",
      u8"司马昭之心路人皆知",
      u8"司马林",
      u8"司马炎",
      u8"司马牛之叹",
      u8"司马相如",
      u8"司马称好",
      u8"司马迁",
      u8"司马青衫",
      u8"叹一口气",
      u8"叹为观止",
      u8"叹了",
      u8"叹了一口气",
      u8"叹伤",
      u8"叹口气",
      u8"叹号",
      u8"叹喟",
      u8"叹声",
      u8"叹息",
      u8"叹息声",
      u8"叹惋",
      u8"叹惜",
      u8"叹服",
      u8"叹气",
      u8"叹绝",
      u8"叹羡",
      u8"叹老嗟卑",
      u8"叹观止矣",
      u8"叹词",
      u8"叹赏",
      u8"叹道",
      u8"叼上",
      u8"叼烟",
      u8"叼着",
      u8"叼肉",
      u8"叼走",
      u8"叼鱼",
      u8"叽叽",
      u8"叽叽咕咕",
      u8"叽叽唧唧",
      u8"叽叽喳喳",
      u8"叽叽嘎嘎",
      u8"叽咕",
      u8"叽哩咕噜",
      u8"叽喳不断",
      u8"叽里呱啦",
      u8"叽里咕噜",
      u8"叽驾",
      u8"吁叹",
      u8"吁吁",
      u8"吁咈都俞",
      u8"吁天呼地",
      u8"吁气",
      u8"吁求",
      u8"吁请",
      u8"吃一堑",
      u8"吃一堑长一智",
      u8"吃上",
      u8"吃上官司",
      u8"吃下",
      u8"吃下去",
      u8"吃下来",
      u8"吃不上",
      u8"吃不下",
      u8"吃不了",
      u8"吃不了兜着走",
      u8"吃不了兜着走成",
      u8"吃不住",
      u8"吃不准",
      u8"吃不出",
      u8"吃不出来",
      u8"吃不到",
      u8"吃不到葡萄说葡萄酸",
      u8"吃不完",
      u8"吃不开",
      u8"吃不服",
      u8"吃不来",
      u8"吃不消",
      u8"吃不胖",
      u8"吃不透",
      u8"吃不饱",
      u8"吃不香",
      u8"吃东西",
      u8"吃个",
      u8"吃了",
      u8"吃了上顿没下顿",
      u8"吃了亏",
      u8"吃了原告吃被告",
      u8"吃了豹子胆",
      u8"吃了饭",
      u8"吃亏",
      u8"吃亏就是占便宜",
      u8"吃人",
      u8"吃人不吐骨头",
      u8"吃人口软",
      u8"吃人肉",
      u8"吃什么",
      u8"吃住",
      u8"吃你",
      u8"吃偏食",
      u8"吃偏饭",
      u8"吃光",
      u8"吃公攒私",
      u8"吃准",
      u8"吃出",
      u8"吃到",
      u8"吃剩",
      u8"吃力",
      u8"吃力不讨好",
      u8"吃劲",
      u8"吃劳保",
      u8"吃卡",
      u8"吃去",
      u8"吃吃",
      u8"吃吃喝喝",
      u8"吃后悔药",
      u8"吃哑巴亏",
      u8"吃喜糖",
      u8"吃喝",
      u8"吃喝嫖赌",
      u8"吃喝拉撒",
      u8"吃喝玩乐",
      u8"吃喝风",
      u8"吃嘴",
      u8"吃回扣",
      u8"吃多",
      u8"吃大亏",
      u8"吃大便",
      u8"吃大户",
      u8"吃大锅饭",
      u8"吃奶",
      u8"吃好",
      u8"吃好饭",
      u8"吃子",
      u8"吃完",
      u8"吃完饭",
      u8"吃官司",
      u8"吃定",
      u8"吃客",
      u8"吃宵夜",
      u8"吃小灶",
      u8"吃尽",
      u8"吃尽苦头",
      u8"吃屎",
      u8"吃幅千里",
      u8"吃得",
      u8"吃得下",
      u8"吃得了",
      u8"吃得住",
      u8"吃得出",
      u8"吃得出来",
      u8"吃得到",
      u8"吃得完",
      u8"吃得开",
      u8"吃得来",
      u8"吃得消",
      u8"吃得苦中苦",
      u8"吃得起",
      u8"吃得饱",
      u8"吃快餐",
      u8"吃惊",
      u8"吃惊受怕",
      u8"吃成",
      u8"吃拿卡要",
      u8"吃掉",
      u8"吃斋",
      u8"吃斋唸佛",
      u8"吃斋念佛",
      u8"吃晚饭",
      u8"吃本",
      u8"吃来",
      u8"吃来吃去",
      u8"吃水",
      u8"吃水不忘挖井人",
      u8"吃水果",
      u8"吃水标尺",
      u8"吃水线",
      u8"吃水量",
      u8"吃水难",
      u8"吃油",
      u8"吃法",
      u8"吃法呢",
      u8"吃派饭",
      u8"吃海鲜",
      u8"吃火锅",
      u8"吃点",
      u8"吃独食",
      u8"吃玩",
      u8"吃现成饭",
      u8"吃瓦片儿",
      u8"吃白食",
      u8"吃白饭",
      u8"吃皇粮",
      u8"吃盐",
      u8"吃相",
      u8"吃眼前亏",
      u8"吃着",
      u8"吃着不尽",
      u8"吃着碗里瞧着锅里",
      u8"吃硬",
      u8"吃硬不吃软",
      u8"吃碗面翻碗底",
      u8"吃空额",
      u8"吃穿",
      u8"吃穿用度",
      u8"吃粉笔灰",
      u8"吃粮",
      u8"吃粮不管事",
      u8"吃糖",
      u8"吃糠咽菜",
      u8"吃素",
      u8"吃紧",
      u8"吃罪",
      u8"吃罪不起",
      u8"吃老本",
      u8"吃肉",
      u8"吃腻",
      u8"吃苦",
      u8"吃苦在前",
      u8"吃苦头",
      u8"吃苦耐劳",
      u8"吃茶",
      u8"吃草",
      u8"吃荤",
      u8"吃药",
      u8"吃药前",
      u8"吃药后",
      u8"吃药时",
      u8"吃菜",
      u8"吃螃蟹",
      u8"吃血",
      u8"吃衣著饭",
      u8"吃角子老虎",
      u8"吃请",
      u8"吃豆乾",
      u8"吃豆腐",
      u8"吃豆豆",
      u8"吃败仗",
      u8"吃起",
      u8"吃起来",
      u8"吃起饭来",
      u8"吃软",
      u8"吃软不吃",
      u8"吃软不吃硬",
      u8"吃软饭",
      u8"吃过",
      u8"吃过饭",
      u8"吃进",
      u8"吃透",
      u8"吃酒",
      u8"吃醋",
      u8"吃里扒外",
      u8"吃里爬外",
      u8"吃重",
      u8"吃钱",
      u8"吃锅",
      u8"吃错",
      u8"吃错药",
      u8"吃闭门羹",
      u8"吃闲饭",
      u8"吃零嘴",
      u8"吃零食",
      u8"吃面",
      u8"吃食",
      u8"吃饭",
      u8"吃饭时",
      u8"吃饭时间",
      u8"吃饭问题",
      u8"吃饭防噎",
      u8"吃饱",
      u8"吃饱喝足",
      u8"吃饱没事干",
      u8"吃饱穿暖",
      u8"吃饺子",
      u8"吃馆子",
      u8"吃香",
      u8"吃香喝辣",
      u8"吃鱼",
      u8"吃鸭蛋",
      u8"各上",
      u8"各上去",
      u8"各上来",
      u8"各下",
      u8"各不",
      u8"各不同",
      u8"各不相同",
      u8"各不相让",
      u8"各不相谋",
      u8"各业",
      u8"各个",
      u8"各个击破",
      u8"各个单位",
      u8"各个国家",
      u8"各个地区",
      u8"各个地区之间",
      u8"各个地方",
      u8"各个方面",
      u8"各个环节",
      u8"各个系统",
      u8"各个部门",
      u8"各个部门之间",
      u8"各个领域",
      u8"各为",
      u8"各为其主",
      u8"各举",
      u8"各乡",
      u8"各乡镇",
      u8"各享",
      u8"各人",
      u8"各人所得税",
      u8"各人民团体",
      u8"各人自扫门前雪",
      u8"各人自扫门前雪莫管他人瓦上霜",
      u8"各人自扫门前雪莫管他家瓦上霜",
      u8"各从其志",
      u8"各从其类",
      u8"各从其走",
      u8"各位",
      u8"各位朋友",
      u8"各作",
      u8"各使",
      u8"各例",
      u8"各供",
      u8"各依",
      u8"各借",
      u8"各做",
      u8"各党",
      u8"各党派",
      u8"各公司",
      u8"各兵种",
      u8"各具",
      u8"各具特色",
      u8"各养",
      u8"各兼",
      u8"各军兵种",
      u8"各军区",
      u8"各减",
      u8"各凭",
      u8"各凭本事",
      u8"各出",
      u8"各分",
      u8"各分部",
      u8"各创",
      u8"各创一格",
      u8"各别",
      u8"各到",
      u8"各削",
      u8"各剩",
      u8"各剪",
      u8"各办",
      u8"各加",
      u8"各包",
      u8"各区",
      u8"各区域",
      u8"各升",
      u8"各半",
      u8"各单位",
      u8"各单项",
      u8"各占",
      u8"各印",
      u8"各卷",
      u8"各厂",
      u8"各厅",
      u8"各厢",
      u8"各去",
      u8"各县",
      u8"各县区",
      u8"各县市",
      u8"各发",
      u8"各取",
      u8"各取所长",
      u8"各取所需",
      u8"各口岸",
      u8"各号",
      u8"各司其事",
      u8"各司其职",
      u8"各吃",
      u8"各各",
      u8"各吊",
      u8"各向",
      u8"各向同性",
      u8"各向同性刻蚀",
      u8"各向同性媒质",
      u8"各向同性辐射器",
      u8"各向异性",
      u8"各向异性介质",
      u8"各向异性刻蚀",
      u8"各向异性媒质",
      u8"各向异性温度因子",
      u8"各向异性系数",
      u8"各听",
      u8"各吸",
      u8"各唱",
      u8"各唸",
      u8"各喝",
      u8"各器官",
      u8"各回",
      u8"各回合",
      u8"各因",
      u8"各团",
      u8"各团体",
      u8"各园",
      u8"各国",
      u8"各国人民",
      u8"各在",
      u8"各地",
      u8"各地党委",
      u8"各地区",
      u8"各地方",
      u8"各地风俗",
      u8"各场",
      u8"各型",
      u8"各型各式",
      u8"各城",
      u8"各城市",
      u8"各填",
      u8"各处",
      u8"各处室",
      u8"各大",
      u8"各大军区",
      u8"各大报",
      u8"各头",
      u8"各奏",
      u8"各奔",
      u8"各奔东西",
      u8"各奔前程",
      u8"各如",
      u8"各如其人",
      u8"各如其面",
      u8"各委办",
      u8"各委员会",
      u8"各季",
      u8"各学",
      u8"各学科",
      u8"各安生业",
      u8"各安职守",
      u8"各室",
      u8"各家",
      u8"各家各户",
      u8"各寄",
      u8"各对",
      u8"各射",
      u8"各就",
      u8"各就各位",
      u8"各尽",
      u8"各尽其",
      u8"各尽其妙",
      u8"各尽所能",
      u8"各局",
      u8"各层",
      u8"各层次",
      u8"各属",
      u8"各岛",
      u8"各岛屿",
      u8"各州",
      u8"各工种",
      u8"各巷",
      u8"各币种",
      u8"各市",
      u8"各市区",
      u8"各市县",
      u8"各市地",
      u8"各带",
      u8"各帮",
      u8"各帮派",
      u8"各年",
      u8"各年次",
      u8"各年级",
      u8"各庄镇",
      u8"各床",
      u8"各延",
      u8"各建",
      u8"各开",
      u8"各异",
      u8"各式",
      u8"各式各样",
      u8"各弹",
      u8"各当",
      u8"各形",
      u8"各形各色",
      u8"各往",
      u8"各得",
      u8"各得其宜",
      u8"各得其所",
      u8"各忙",
      u8"各忙各",
      u8"各念",
      u8"各怀鬼胎",
      u8"各总部",
      u8"各想",
      u8"各截",
      u8"各戴",
      u8"各户",
      u8"各所",
      u8"各打",
      u8"各打二十大板",
      u8"各执一词",
      u8"各执己见",
      u8"各批",
      u8"各抒",
      u8"各抒己见",
      u8"各抒已见",
      u8"各抒所见",
      u8"各投",
      u8"各投其好",
      u8"各报",
      u8"各拍",
      u8"各拨",
      u8"各持己见",
      u8"各指",
      u8"各挤",
      u8"各捡",
      u8"各排",
      u8"各接",
      u8"各揍",
      u8"各提",
      u8"各搞",
      u8"各搬",
      u8"各搭",
      u8"各携",
      u8"各摇",
      u8"各摊",
      u8"各播",
      u8"各擅胜场",
      u8"各支部",
      u8"各攻",
      u8"各政党",
      u8"各救",
      u8"各数",
      u8"各敷",
      u8"各方",
      u8"各方对",
      u8"各方瞩目",
      u8"各方面",
      u8"各施",
      u8"各族",
      u8"各族人民",
      u8"各族群众",
      u8"各显其能",
      u8"各显神通",
      u8"各显身手",
      u8"各替",
      u8"各有",
      u8"各有不同",
      u8"各有利弊",
      u8"各有千秋",
      u8"各有巧妙不同",
      u8"各有所好",
      u8"各有所得",
      u8"各有所爱",
      u8"各有所短",
      u8"各有所职",
      u8"各有所见",
      u8"各有所长",
      u8"各有特点",
      u8"各有特色",
      u8"各有胜负",
      u8"各有输赢",
      u8"各服",
      u8"各期",
      u8"各期刊",
      u8"各机",
      u8"各杀",
      u8"各村",
      u8"各条",
      u8"各条战线",
      u8"各来",
      u8"各架",
      u8"各栏",
      u8"各校",
      u8"各样",
      u8"各梳",
      u8"各棒",
      u8"各楼层",
      u8"各榜",
      u8"各次",
      u8"各款",
      u8"各段",
      u8"各段落",
      u8"各比",
      u8"各民主党派",
      u8"各民族",
      u8"各河",
      u8"各河流",
      u8"各沿",
      u8"各泼",
      u8"各洗",
      u8"各派",
      u8"各添",
      u8"各湖",
      u8"各湖泊",
      u8"各演",
      u8"各版",
      u8"各版面",
      u8"各牵",
      u8"各献其能",
      u8"各玩",
      u8"各班",
      u8"各班次",
      u8"各班级",
      u8"各理",
      u8"各生",
      u8"各用",
      u8"各界",
      u8"各界人士",
      u8"各盒",
      u8"各盟",
      u8"各盟邦",
      u8"各直属",
      u8"各省",
      u8"各省县",
      u8"各省市",
      u8"各省市自治区",
      u8"各睡",
      u8"各矿",
      u8"各社",
      u8"各种",
      u8"各种不同类型",
      u8"各种事",
      u8"各种事情",
      u8"各种人",
      u8"各种各样",
      u8"各种因素",
      u8"各种形式",
      u8"各种情况",
      u8"各种方式",
      u8"各种活动",
      u8"各种渠道",
      u8"各种类型",
      u8"各种规格",
      u8"各科",
      u8"各科室局队",
      u8"各立",
      u8"各立门户",
      u8"各章",
      u8"各端",
      u8"各笑",
      u8"各答",
      u8"各签",
      u8"各箱",
      u8"各类",
      u8"各粒",
      u8"各系",
      u8"各系所",
      u8"各级",
      u8"各级人民政府",
      u8"各级党委",
      u8"各级党委和政府",
      u8"各级党组织",
      u8"各级地方政府",
      u8"各级干部",
      u8"各级政府",
      u8"各级组织",
      u8"各级领导",
      u8"各级领导干部",
      u8"各线",
      u8"各线路",
      u8"各组",
      u8"各给",
      u8"各罚",
      u8"各考点",
      u8"各背",
      u8"各胜",
      u8"各自",
      u8"各自为战",
      u8"各自为政",
      u8"各色",
      u8"各色人等",
      u8"各色各样",
      u8"各色名样",
      u8"各节",
      u8"各行",
      u8"各行业",
      u8"各行其事",
      u8"各行其志",
      u8"各行其是",
      u8"各行其道",
      u8"各行各业",
      u8"各街",
      u8"各街道",
      u8"各表",
      u8"各被",
      u8"各装",
      u8"各要",
      u8"各记",
      u8"各讲",
      u8"各设",
      u8"各试",
      u8"各说",
      u8"各说各话",
      u8"各课",
      u8"各调",
      u8"各谈",
      u8"各谋",
      u8"各谋出路",
      u8"各谋生路",
      u8"各负其责",
      u8"各赏",
      u8"各赛区",
      u8"各走",
      u8"各路",
      u8"各路人马",
      u8"各踢",
      u8"各车",
      u8"各车厢",
      u8"各车次",
      u8"各车辆",
      u8"各辑",
      u8"各输",
      u8"各过",
      u8"各进",
      u8"各送",
      u8"各道",
      u8"各道路",
      u8"各邀",
      u8"各部",
      u8"各部会",
      u8"各部分",
      u8"各部委",
      u8"各部长",
      u8"各部门",
      u8"各里",
      u8"各钓",
      u8"各铺",
      u8"各键",
      u8"各门",
      u8"各门派",
      u8"各闯",
      u8"各间",
      u8"各队",
      u8"各队伍",
      u8"各阶",
      u8"各阶层",
      u8"各附",
      u8"各降",
      u8"各院",
      u8"各院校",
      u8"各院系",
      u8"各随其好",
      u8"各集",
      u8"各需",
      u8"各音",
      u8"各项",
      u8"各项事业",
      u8"各项任务",
      u8"各项工作",
      u8"各项措施",
      u8"各项改革",
      u8"各项政策",
      u8"各项目",
      u8"各项规定",
      u8"各须",
      u8"各颁",
      u8"各领",
      u8"各领风骚",
      u8"各领风骚数百年",
      u8"各题",
      u8"各餐",
      u8"各骑",
      u8"吆五喝六",
      u8"吆呼",
      u8"吆喊",
      u8"吆喝",
      u8"吆喝声",
      u8"合一",
      u8"合一部件",
      u8"合上",
      u8"合不拢嘴",
      u8"合不来",
      u8"合不着",
      u8"合两为一",
      u8"合丰",
      u8"合为",
      u8"合为一体",
      u8"合久必分",
      u8"合乎",
      u8"合乎情理",
      u8"合乎规律",
      u8"合乎逻辑",
      u8"合二为一",
      u8"合二而一",
      u8"合于",
      u8"合从连衡",
      u8"合付",
      u8"合众",
      u8"合众国",
      u8"合众国际社",
      u8"合众社",
      u8"合伙",
      u8"合伙人",
      u8"合伙制",
      u8"合会",
      u8"合住",
      u8"合体",
      u8"合体技",
      u8"合作",
      u8"合作主义",
      u8"合作企业",
      u8"合作伙伴",
      u8"合作关系",
      u8"合作制",
      u8"合作化",
      u8"合作医疗",
      u8"合作单位",
      u8"合作商店",
      u8"合作学",
      u8"合作市",
      u8"合作开发",
      u8"合作愉快",
      u8"合作意向",
      u8"合作所",
      u8"合作方",
      u8"合作无间",
      u8"合作现象",
      u8"合作社",
      u8"合作经营",
      u8"合作网",
      u8"合作者",
      u8"合作金库",
      u8"合作项目",
      u8"合借",
      u8"合做",
      u8"合共",
      u8"合养",
      u8"合写",
      u8"合冲",
      u8"合出",
      u8"合击",
      u8"合刊",
      u8"合则两利",
      u8"合到",
      u8"合剂",
      u8"合力",
      u8"合力偶",
      u8"合办",
      u8"合十",
      u8"合卺",
      u8"合发",
      u8"合取",
      u8"合取范式",
      u8"合口",
      u8"合口味",
      u8"合叶",
      u8"合吃",
      u8"合合",
      u8"合同",
      u8"合同书",
      u8"合同制",
      u8"合同制工人",
      u8"合同工",
      u8"合同文书",
      u8"合同文本",
      u8"合同期",
      u8"合同条款",
      u8"合同法",
      u8"合同纠纷",
      u8"合同范本",
      u8"合同规定",
      u8"合同诈骗",
      u8"合同诈骗罪",
      u8"合同额",
      u8"合唱",
      u8"合唱团",
      u8"合唱曲",
      u8"合唱组",
      u8"合唱节",
      u8"合唱队",
      u8"合围",
      u8"合在",
      u8"合在一起",
      u8"合壁",
      u8"合声",
      u8"合夥",
      u8"合夥人",
      u8"合奏",
      u8"合奏曲",
      u8"合好",
      u8"合婚",
      u8"合子",
      u8"合子期",
      u8"合定",
      u8"合宜",
      u8"合家",
      u8"合家幸福",
      u8"合家欢",
      u8"合家欢乐",
      u8"合山",
      u8"合山市",
      u8"合川",
      u8"合川市",
      u8"合工大",
      u8"合并",
      u8"合并债务",
      u8"合并在",
      u8"合并式",
      u8"合并症",
      u8"合并者",
      u8"合府",
      u8"合度",
      u8"合建",
      u8"合式",
      u8"合弹",
      u8"合归",
      u8"合影",
      u8"合影留念",
      u8"合得",
      u8"合得来",
      u8"合心",
      u8"合情",
      u8"合情合法",
      u8"合情合理",
      u8"合情理",
      u8"合意",
      u8"合成",
      u8"合成体",
      u8"合成作用",
      u8"合成列",
      u8"合成器",
      u8"合成图",
      u8"合成地图",
      u8"合成塔",
      u8"合成孔径",
      u8"合成孔径雷达",
      u8"合成岩石",
      u8"合成机",
      u8"合成染料",
      u8"合成树脂",
      u8"合成树脂溶液系涂料",
      u8"合成橡胶",
      u8"合成橡胶印模材料",
      u8"合成橡胶系胶结剂",
      u8"合成气",
      u8"合成氨",
      u8"合成洗涤",
      u8"合成洗涤剂",
      u8"合成液压液",
      u8"合成照",
      u8"合成物",
      u8"合成石油",
      u8"合成纤维",
      u8"合成纸",
      u8"合成聚合物",
      u8"合成表面活性剂",
      u8"合成视频",
      u8"合成词",
      u8"合成酶",
      u8"合成革",
      u8"合战",
      u8"合报",
      u8"合抱",
      u8"合抱之木",
      u8"合拍",
      u8"合拍片",
      u8"合拢",
      u8"合掌",
      u8"合数",
      u8"合时",
      u8"合板",
      u8"合校",
      u8"合格",
      u8"合格品",
      u8"合格率",
      u8"合格者",
      u8"合格证",
      u8"合格证书",
      u8"合欢",
      u8"合欢山",
      u8"合欢树",
      u8"合欢椅",
      u8"合欢皮",
      u8"合欢花",
      u8"合每股",
      u8"合气道",
      u8"合水县",
      u8"合江",
      u8"合江县",
      u8"合江省",
      u8"合法",
      u8"合法利益",
      u8"合法化",
      u8"合法婚姻",
      u8"合法席位",
      u8"合法性",
      u8"合法收入",
      u8"合法政府",
      u8"合法斗争",
      u8"合法权利",
      u8"合法权益",
      u8"合法经营",
      u8"合法财产",
      u8"合注井",
      u8"合洗",
      u8"合派",
      u8"合流",
      u8"合流制",
      u8"合流处",
      u8"合济",
      u8"合浦县",
      u8"合浦珠还",
      u8"合浦还珠",
      u8"合演",
      u8"合点受精",
      u8"合照",
      u8"合照留念",
      u8"合牵",
      u8"合班",
      u8"合理",
      u8"合理冲撞",
      u8"合理化",
      u8"合理化作用",
      u8"合理化建议",
      u8"合理合情",
      u8"合理合法",
      u8"合理地",
      u8"合理安排",
      u8"合理密植",
      u8"合理布局",
      u8"合理性",
      u8"合理情绪疗法",
      u8"合理收入",
      u8"合理收费",
      u8"合理流动",
      u8"合理要求",
      u8"合理负担",
      u8"合璧",
      u8"合瓣",
      u8"合瓣花冠",
      u8"合生元",
      u8"合用",
      u8"合盖",
      u8"合眼",
      u8"合眼摸象",
      u8"合着",
      u8"合租",
      u8"合租房",
      u8"合租者",
      u8"合称",
      u8"合站",
      u8"合签",
      u8"合算",
      u8"合约",
      u8"合纵",
      u8"合纵连横",
      u8"合线期",
      u8"合组",
      u8"合编",
      u8"合缝",
      u8"合署",
      u8"合群",
      u8"合群性",
      u8"合而为一",
      u8"合股",
      u8"合肥",
      u8"合肥人",
      u8"合肥工业大学",
      u8"合肥市",
      u8"合肥市人民政府",
      u8"合肥市教委",
      u8"合肥市教育委员会",
      u8"合肥市职业教育中心",
      u8"合肥市联合大学",
      u8"合肥广播电台",
      u8"合肥晚报",
      u8"合肥炮兵学院",
      u8"合肥职教中心",
      u8"合肥联大",
      u8"合胃口",
      u8"合胆同心",
      u8"合脚",
      u8"合舟共济",
      u8"合营",
      u8"合营企业",
      u8"合营者",
      u8"合著",
      u8"合葬",
      u8"合蕊柱",
      u8"合补",
      u8"合规律",
      u8"合规律性",
      u8"合计",
      u8"合订本",
      u8"合议",
      u8"合议制",
      u8"合议庭",
      u8"合该",
      u8"合请",
      u8"合读",
      u8"合调",
      u8"合谋",
      u8"合谐",
      u8"合谷",
      u8"合购",
      u8"合资",
      u8"合资企业",
      u8"合资经营",
      u8"合起",
      u8"合起来",
      u8"合踢",
      u8"合身",
      u8"合辙",
      u8"合辙押韵",
      u8"合运动",
      u8"合适",
      u8"合通",
      u8"合速度",
      u8"合金",
      u8"合金丝",
      u8"合金二极管",
      u8"合金刀具",
      u8"合金分离过程",
      u8"合金制品",
      u8"合金弹头",
      u8"合金战甲",
      u8"合金晶体管",
      u8"合金材料",
      u8"合金管",
      u8"合金粉",
      u8"合金结",
      u8"合金装备",
      u8"合金钢",
      u8"合钓",
      u8"合铸",
      u8"合锯",
      u8"合闸",
      u8"合阳",
      u8"合阳县",
      u8"合集",
      u8"合霉素",
      u8"合音",
      u8"合页",
      u8"合领",
      u8"合题",
      u8"合骑",
      u8"合龙",
      u8"吉东明",
      u8"吉事多",
      u8"吉事达",
      u8"吉人",
      u8"吉人天相",
      u8"吉人自有天相",
      u8"吉人通",
      u8"吉他",
      u8"吉他手",
      u8"吉他曲",
      u8"吉他社",
      u8"吉他网",
      u8"吉他谱",
      u8"吉伯",
      u8"吉信",
      u8"吉兆",
      u8"吉光凤羽",
      u8"吉光片羽",
      u8"吉光片翼",
      u8"吉光片裘",
      u8"吉兰",
      u8"吉军",
      u8"吉凶",
      u8"吉凶未卜",
      u8"吉凶祸福",
      u8"吉凶难卜",
      u8"吉凶难料",
      u8"吉列",
      u8"吉利",
      u8"吉利区",
      u8"吉利果",
      u8"吉利话",
      u8"吉利车",
      u8"吉剧",
      u8"吉化",
      u8"吉卜赛",
      u8"吉卜赛人",
      u8"吉县",
      u8"吉合",
      u8"吉妮",
      u8"吉姆",
      u8"吉姆萨带",
      u8"吉姆萨染液",
      u8"吉娃娃",
      u8"吉它",
      u8"吉它曲",
      u8"吉它谱",
      u8"吉安",
      u8"吉安县",
      u8"吉安市",
      u8"吉尔",
      u8"吉尔吉斯",
      u8"吉尔吉斯斯坦",
      u8"吉尔菲艾斯",
      u8"吉尔达",
      u8"吉尼斯",
      u8"吉尼斯世界纪录",
      u8"吉尼斯纪录",
      u8"吉尼斯记录",
      u8"吉川",
      u8"吉州区",
      u8"吉布提",
      u8"吉布斯佯谬",
      u8"吉布斯现象",
      u8"吉布斯相律",
      u8"吉布斯自由能",
      u8"吉布森",
      u8"吉庆",
      u8"吉庆街",
      u8"吉房",
      u8"吉拉德",
      u8"吉拉迪诺",
      u8"吉斯",
      u8"吉斯尼",
      u8"吉日",
      u8"吉日良时",
      u8"吉日良辰",
      u8"吉时",
      u8"吉星",
      u8"吉星高照",
      u8"吉普",
      u8"吉普赛",
      u8"吉普赛人",
      u8"吉普车",
      u8"吉期",
      u8"吉木乃",
      u8"吉木乃县",
      u8"吉木萨尔",
      u8"吉木萨尔县",
      u8"吉林",
      u8"吉林中医学院",
      u8"吉林人",
      u8"吉林大学",
      u8"吉林市",
      u8"吉林省",
      u8"吉林路",
      u8"吉林长春",
      u8"吉林队",
      u8"吉格斯",
      u8"吉水",
      u8"吉水县",
      u8"吉永小百合",
      u8"吉泊村",
      u8"吉田",
      u8"吉百利",
      u8"吉祥",
      u8"吉祥图案",
      u8"吉祥天",
      u8"吉祥如意",
      u8"吉祥寺",
      u8"吉祥村",
      u8"吉祥止止",
      u8"吉祥物",
      u8"吉祥算",
      u8"吉祥路",
      u8"吉网罗钳",
      u8"吉羊",
      u8"吉良吉影",
      u8"吉萨",
      u8"吉萨省",
      u8"吉蔑族",
      u8"吉西切道描记器",
      u8"吉言",
      u8"吉诃德",
      u8"吉贝",
      u8"吉赛尔",
      u8"吉达",
      u8"吉通",
      u8"吉野家",
      u8"吉隆",
      u8"吉隆县",
      u8"吉隆坡",
      u8"吉隆波",
      u8"吉首",
      u8"吉首市",
      u8"吉马良斯",
      u8"吉鸿昌",
      u8"吊上",
      u8"吊上去",
      u8"吊上来",
      u8"吊下",
      u8"吊下去",
      u8"吊下来",
      u8"吊丧",
      u8"吊个",
      u8"吊了",
      u8"吊儿郎当",
      u8"吊兰",
      u8"吊到",
      u8"吊卷",
      u8"吊去",
      u8"吊取",
      u8"吊古",
      u8"吊古伤今",
      u8"吊古寻幽",
      u8"吊吊",
      u8"吊唁",
      u8"吊嗓",
      u8"吊嗓子",
      u8"吊塔",
      u8"吊好",
      u8"吊子",
      u8"吊孝",
      u8"吊客",
      u8"吊尔郎当",
      u8"吊带",
      u8"吊带衫",
      u8"吊带袜",
      u8"吊带装",
      u8"吊带裙",
      u8"吊带裤",
      u8"吊床",
      u8"吊形吊影",
      u8"吊得",
      u8"吊慰",
      u8"吊扇",
      u8"吊打",
      u8"吊扣",
      u8"吊挂",
      u8"吊挂在",
      u8"吊挂着",
      u8"吊提",
      u8"吊放",
      u8"吊文",
      u8"吊斗",
      u8"吊杆",
      u8"吊来吊去",
      u8"吊架",
      u8"吊柜",
      u8"吊桥",
      u8"吊桶",
      u8"吊梯",
      u8"吊楼",
      u8"吊死",
      u8"吊死扶伤",
      u8"吊死问疾",
      u8"吊死鬼",
      u8"吊民伐罪",
      u8"吊滞",
      u8"吊灯",
      u8"吊环",
      u8"吊瓶",
      u8"吊白块",
      u8"吊盘",
      u8"吊眼皮",
      u8"吊着",
      u8"吊祭",
      u8"吊空",
      u8"吊窗",
      u8"吊竹梅",
      u8"吊篮",
      u8"吊索",
      u8"吊索具",
      u8"吊线",
      u8"吊绳",
      u8"吊耳",
      u8"吊胃口",
      u8"吊胆惊心",
      u8"吊胆提心",
      u8"吊脚",
      u8"吊脚楼",
      u8"吊膀",
      u8"吊臂",
      u8"吊袜",
      u8"吊袜带",
      u8"吊袜腰带",
      u8"吊装",
      u8"吊装带",
      u8"吊装绳",
      u8"吊裤",
      u8"吊裤带",
      u8"吊角楼",
      u8"吊誉沽名",
      u8"吊走",
      u8"吊起",
      u8"吊起来",
      u8"吊车",
      u8"吊针",
      u8"吊钟",
      u8"吊钢丝",
      u8"吊钩",
      u8"吊铺",
      u8"吊链",
      u8"吊销",
      u8"吊销其",
      u8"吊销执照",
      u8"吊锚柱",
      u8"吊门",
      u8"吊顶",
      u8"吊顶龙骨",
      u8"同一",
      u8"同一个",
      u8"同一天",
      u8"同一律",
      u8"同一性",
      u8"同一时间",
      u8"同一种",
      u8"同一首歌",
      u8"同上",
      u8"同下",
      u8"同业",
      u8"同业公会",
      u8"同业工会",
      u8"同业相仇",
      u8"同中心",
      u8"同中有异",
      u8"同为",
      u8"同义",
      u8"同义字",
      u8"同义词",
      u8"同义语",
      u8"同乐",
      u8"同乐会",
      u8"同乡",
      u8"同乡会",
      u8"同事",
      u8"同于",
      u8"同产",
      u8"同享",
      u8"同人",
      u8"同人图",
      u8"同人小说",
      u8"同人志",
      u8"同仁",
      u8"同仁医院",
      u8"同仁县",
      u8"同仁堂",
      u8"同仇敌忾",
      u8"同仇敌慨",
      u8"同他",
      u8"同付",
      u8"同价",
      u8"同价位",
      u8"同休共戚",
      u8"同休等戚",
      u8"同伙",
      u8"同伦类",
      u8"同伦群",
      u8"同伦逆",
      u8"同伴",
      u8"同位",
      u8"同位素",
      u8"同位素交换",
      u8"同位素化学",
      u8"同位素地球化学",
      u8"同位素富集",
      u8"同位素富集度",
      u8"同位素标记",
      u8"同位素移位",
      u8"同位素药盒",
      u8"同位素量",
      u8"同位角",
      u8"同位语",
      u8"同住",
      u8"同住者",
      u8"同体",
      u8"同余可换代数",
      u8"同余式",
      u8"同侪",
      u8"同促效应",
      u8"同倍体",
      u8"同做",
      u8"同僚",
      u8"同党",
      u8"同减",
      u8"同出",
      u8"同出一辙",
      u8"同出同进",
      u8"同分",
      u8"同分异构",
      u8"同分异物现象",
      u8"同分数",
      u8"同创",
      u8"同创大业",
      u8"同创集团",
      u8"同利相死",
      u8"同到",
      u8"同前",
      u8"同功一体",
      u8"同功器官",
      u8"同勉",
      u8"同化",
      u8"同化作用",
      u8"同化力",
      u8"同化商",
      u8"同化政策",
      u8"同化组织",
      u8"同区",
      u8"同升",
      u8"同去",
      u8"同县",
      u8"同参数",
      u8"同发",
      u8"同口径",
      u8"同台",
      u8"同右",
      u8"同号",
      u8"同吃",
      u8"同吃同住",
      u8"同合子",
      u8"同名",
      u8"同名同姓",
      u8"同名数",
      u8"同向",
      u8"同向重复",
      u8"同告",
      u8"同呼吸",
      u8"同呼吸共命运",
      u8"同命",
      u8"同命相连",
      u8"同命运",
      u8"同唱",
      u8"同喜",
      u8"同嗜性抗体",
      u8"同嗜性粘着",
      u8"同国",
      u8"同在",
      u8"同地",
      u8"同坐",
      u8"同垂不朽",
      u8"同型",
      u8"同型共聚物",
      u8"同型发酵",
      u8"同型配子",
      u8"同埋",
      u8"同城",
      u8"同堂",
      u8"同堂兄弟",
      u8"同增",
      u8"同声",
      u8"同声一辞",
      u8"同声传",
      u8"同声传译控制室",
      u8"同声共气",
      u8"同声同气",
      u8"同声相应",
      u8"同声相应同气相求",
      u8"同声相求",
      u8"同声翻译",
      u8"同声附和",
      u8"同多碱",
      u8"同多糖",
      u8"同多酸",
      u8"同夥",
      u8"同好",
      u8"同姓",
      u8"同姓同名",
      u8"同学",
      u8"同学们",
      u8"同学会",
      u8"同学录",
      u8"同学聚会",
      u8"同安",
      u8"同安区",
      u8"同安县",
      u8"同宗",
      u8"同宗配合",
      u8"同宗配合酵母",
      u8"同定",
      u8"同室",
      u8"同室操戈",
      u8"同寝室",
      u8"同对",
      u8"同尘合污",
      u8"同尾酶",
      u8"同层人",
      u8"同居",
      u8"同居一室",
      u8"同居人",
      u8"同屋",
      u8"同属",
      u8"同岁",
      u8"同工",
      u8"同工不同酬",
      u8"同工凝集素",
      u8"同工同酬",
      u8"同工异曲",
      u8"同工激素",
      u8"同工蛋白质",
      u8"同工酶",
      u8"同左",
      u8"同年",
      u8"同年代",
      u8"同年同月",
      u8"同年同月同日",
      u8"同年级",
      u8"同年而语",
      u8"同年龄",
      u8"同年龄组",
      u8"同庆",
      u8"同床",
      u8"同床共枕",
      u8"同床各梦",
      u8"同床异梦",
      u8"同庚",
      u8"同度",
      u8"同座",
      u8"同张",
      u8"同归",
      u8"同归于尽",
      u8"同归殊涂",
      u8"同归殊途",
      u8"同当",
      u8"同形",
      u8"同形体",
      u8"同形词",
      u8"同往",
      u8"同往常一样",
      u8"同德",
      u8"同德一心",
      u8"同德协力",
      u8"同德县",
      u8"同德同心",
      u8"同心",
      u8"同心一力",
      u8"同心一德",
      u8"同心僇力",
      u8"同心共济",
      u8"同心共胆",
      u8"同心协力",
      u8"同心协德",
      u8"同心协济",
      u8"同心县",
      u8"同心叶力",
      u8"同心合力",
      u8"同心合德",
      u8"同心合意",
      u8"同心合胆",
      u8"同心同德",
      u8"同心圆",
      u8"同心圆地带论",
      u8"同心圆观测",
      u8"同心戮力",
      u8"同心断金",
      u8"同心柱粘度计",
      u8"同心毕力",
      u8"同心盟",
      u8"同心结",
      u8"同志",
      u8"同志们",
      u8"同志图片",
      u8"同志小说",
      u8"同志文学",
      u8"同志电影",
      u8"同志网",
      u8"同忧相救",
      u8"同态",
      u8"同态复仇",
      u8"同态滤波",
      u8"同性",
      u8"同性恋",
      u8"同性恋者",
      u8"同性爱",
      u8"同性相斥",
      u8"同恶共济",
      u8"同恶相党",
      u8"同恶相助",
      u8"同恶相恤",
      u8"同恶相求",
      u8"同恶相济",
      u8"同悲",
      u8"同情",
      u8"同情心",
      u8"同情者",
      u8"同意",
      u8"同意书",
      u8"同意权",
      u8"同感",
      u8"同房",
      u8"同房兄弟",
      u8"同打",
      u8"同指",
      u8"同排",
      u8"同支",
      u8"同收",
      u8"同改",
      u8"同敝相济",
      u8"同文",
      u8"同文共规",
      u8"同文共轨",
      u8"同文同种",
      u8"同方",
      u8"同方向",
      u8"同旁内角",
      u8"同族",
      u8"同族凝集反应",
      u8"同族凝集素",
      u8"同日",
      u8"同日生",
      u8"同日而言",
      u8"同日而论",
      u8"同日而语",
      u8"同时",
      u8"同时代",
      u8"同时候",
      u8"同时发生",
      u8"同时在线",
      u8"同时对比",
      u8"同时并举",
      u8"同时性",
      u8"同时效度",
      u8"同时期",
      u8"同时间",
      u8"同明相照",
      u8"同昨",
      u8"同是",
      u8"同月",
      u8"同月同日",
      u8"同有",
      u8"同期",
      u8"同期相比",
      u8"同期运移",
      u8"同机",
      u8"同村",
      u8"同条共贯",
      u8"同来",
      u8"同来同往",
      u8"同构",
      u8"同枕共眠",
      u8"同校",
      u8"同样",
      u8"同样会",
      u8"同样在",
      u8"同样地",
      u8"同样是",
      u8"同核体",
      u8"同格",
      u8"同案",
      u8"同案犯",
      u8"同桌",
      u8"同桌后生",
      u8"同档",
      u8"同梯",
      u8"同楼",
      u8"同欢",
      u8"同正",
      u8"同此",
      u8"同步",
      u8"同步加速器",
      u8"同步化",
      u8"同步卫星",
      u8"同步器",
      u8"同步回旋加速器",
      u8"同步增长",
      u8"同步带",
      u8"同步序列",
      u8"同步总线",
      u8"同步操作",
      u8"同步机",
      u8"同步检波器",
      u8"同步率",
      u8"同步电动",
      u8"同步电动机",
      u8"同步电机",
      u8"同步网",
      u8"同步进行",
      u8"同母",
      u8"同母兄弟",
      u8"同母异父",
      u8"同比",
      u8"同比增加",
      u8"同气",
      u8"同气相求",
      u8"同气连枝",
      u8"同江",
      u8"同江县",
      u8"同江市",
      u8"同治",
      u8"同派",
      u8"同流合",
      u8"同流合汙",
      u8"同流合污",
      u8"同济",
      u8"同济医科大学",
      u8"同济大学",
      u8"同浴讥裸",
      u8"同渡",
      u8"同温",
      u8"同温同压",
      u8"同温层",
      u8"同游",
      u8"同源",
      u8"同源共流",
      u8"同源多倍体",
      u8"同源异派",
      u8"同源异流",
      u8"同源异源多倍体",
      u8"同源性",
      u8"同源性突触抑制",
      u8"同源配对",
      u8"同点",
      u8"同点等位基因",
      u8"同然一辞",
      u8"同父",
      u8"同父异母",
      u8"同犯",
      u8"同玩",
      u8"同现",
      u8"同班",
      u8"同班同学",
      u8"同理",
      u8"同理可知",
      u8"同理可证",
      u8"同甘共苦",
      u8"同生",
      u8"同生作用",
      u8"同生共死",
      u8"同生日",
      u8"同生死",
      u8"同生死共存亡",
      u8"同用",
      u8"同病相怜",
      u8"同盖",
      u8"同盘而食",
      u8"同盟",
      u8"同盟会",
      u8"同盟军",
      u8"同盟国",
      u8"同盟条约",
      u8"同盟网",
      u8"同盟罢工",
      u8"同盟者",
      u8"同相",
      u8"同相轴",
      u8"同相轴合并",
      u8"同省",
      u8"同知",
      u8"同离子",
      u8"同离子效应",
      u8"同种",
      u8"同种位",
      u8"同种型",
      u8"同种牙移植术",
      u8"同种移植",
      u8"同科",
      u8"同租",
      u8"同程网",
      u8"同突触",
      u8"同窗",
      u8"同窗好友",
      u8"同窗学友",
      u8"同站",
      u8"同章",
      u8"同符合契",
      u8"同等",
      u8"同等位基因",
      u8"同等学力",
      u8"同等学历",
      u8"同等对待",
      u8"同等待遇",
      u8"同等条件",
      u8"同篇",
      u8"同类",
      u8"同类产品",
      u8"同类品系",
      u8"同类相从",
      u8"同类相残",
      u8"同类相求",
      u8"同类系",
      u8"同类经营",
      u8"同类群",
      u8"同类项",
      u8"同类题材",
      u8"同系",
      u8"同系物",
      u8"同系移植物",
      u8"同素",
      u8"同素异形",
      u8"同素异形体",
      u8"同素异性",
      u8"同素异性体",
      u8"同约",
      u8"同级",
      u8"同级生",
      u8"同线",
      u8"同线型",
      u8"同组",
      u8"同网",
      u8"同罪",
      u8"同美相妒",
      u8"同职",
      u8"同联",
      u8"同聚",
      u8"同聚多肽",
      u8"同聚物",
      u8"同聚物加尾",
      u8"同胞",
      u8"同胞们",
      u8"同胞兄弟",
      u8"同胞共气",
      u8"同胞对照法",
      u8"同胞爱",
      u8"同舟共命",
      u8"同舟共济",
      u8"同舟敌国",
      u8"同舟遇风",
      u8"同船",
      u8"同船合命",
      u8"同色异谱匹配",
      u8"同色相",
      u8"同色系",
      u8"同花顺",
      u8"同苦共乐",
      u8"同行",
      u8"同行业",
      u8"同行同业",
      u8"同行是冤家",
      u8"同袍",
      u8"同袍同泽",
      u8"同被",
      u8"同裂酶",
      u8"同订",
      u8"同论",
      u8"同调",
      u8"同调代数",
      u8"同调群",
      u8"同谋",
      u8"同谋犯",
      u8"同谋者",
      u8"同质",
      u8"同质多晶",
      u8"同质异能素",
      u8"同质性",
      u8"同贺",
      u8"同走",
      u8"同赴",
      u8"同趣",
      u8"同跑",
      u8"同路",
      u8"同路人",
      u8"同身寸",
      u8"同车",
      u8"同轴",
      u8"同轴天线",
      u8"同轴开关",
      u8"同轴电缆",
      u8"同轴线",
      u8"同辈",
      u8"同辙",
      u8"同边",
      u8"同达",
      u8"同过",
      u8"同进",
      u8"同进同出",
      u8"同进士",
      u8"同道",
      u8"同道中人",
      u8"同配性别",
      u8"同配生殖",
      u8"同酬",
      u8"同里镇",
      u8"同重",
      u8"同量",
      u8"同量异位素",
      u8"同长",
      u8"同门",
      u8"同门异户",
      u8"同队",
      u8"同集路",
      u8"同音",
      u8"同音共律",
      u8"同音字",
      u8"同音词",
      u8"同项",
      u8"同题",
      u8"同饮",
      u8"同高",
      u8"同龄",
      u8"同龄人",
      u8"同龄林",
      u8"名下",
      u8"名下无虚",
      u8"名不副实",
      u8"名不正则言不顺",
      u8"名不正言不顺",
      u8"名不符实",
      u8"名不虚传",
      u8"名不虚得",
      u8"名不虚立",
      u8"名不见经传",
      u8"名专栏",
      u8"名为",
      u8"名为集体",
      u8"名主",
      u8"名义",
      u8"名义上",
      u8"名义工资",
      u8"名书",
      u8"名产",
      u8"名人",
      u8"名人传",
      u8"名人名言",
      u8"名人坊",
      u8"名人堂",
      u8"名人字画",
      u8"名人录",
      u8"名人战",
      u8"名人效应",
      u8"名人荟萃",
      u8"名人赛",
      u8"名人轶事",
      u8"名从主人",
      u8"名仓",
      u8"名份",
      u8"名优",
      u8"名优产品",
      u8"名优新",
      u8"名优新产品",
      u8"名优特",
      u8"名优特新",
      u8"名优特新产品",
      u8"名优茶",
      u8"名传千古",
      u8"名伶",
      u8"名位",
      u8"名作",
      u8"名信片",
      u8"名儒",
      u8"名儿",
      u8"名公巨人",
      u8"名公巨卿",
      u8"名公钜人",
      u8"名公钜卿",
      u8"名典",
      u8"名册",
      u8"名分",
      u8"名列",
      u8"名列前矛",
      u8"名列前茅",
      u8"名列前茅者",
      u8"名列榜首",
      u8"名列第一",
      u8"名列首位",
      u8"名利",
      u8"名利双收",
      u8"名利场",
      u8"名利客",
      u8"名利思想",
      u8"名刹",
      u8"名剑",
      u8"名剧",
      u8"名副其实",
      u8"名匠",
      u8"名医",
      u8"名医堂",
      u8"名医药",
      u8"名单",
      u8"名卿钜公",
      u8"名厨",
      u8"名古",
      u8"名古屋",
      u8"名古屋人",
      u8"名句",
      u8"名叫",
      u8"名号",
      u8"名吃",
      u8"名同实异",
      u8"名品",
      u8"名品店",
      u8"名品服饰",
      u8"名唤",
      u8"名嘴",
      u8"名器",
      u8"名噪",
      u8"名噪一时",
      u8"名团",
      u8"名园",
      u8"名园古刹",
      u8"名地",
      u8"名垂万古",
      u8"名垂不朽",
      u8"名垂千古",
      u8"名垂后世",
      u8"名垂竹帛",
      u8"名垂青史",
      u8"名城",
      u8"名堂",
      u8"名士",
      u8"名士风流",
      u8"名声",
      u8"名声不好",
      u8"名声在外",
      u8"名声大噪",
      u8"名声大振",
      u8"名声籍甚",
      u8"名声过实",
      u8"名声远播",
      u8"名声鹊起",
      u8"名头",
      u8"名女人",
      u8"名如其人",
      u8"名妓",
      u8"名媛",
      u8"名子",
      u8"名字",
      u8"名字叫",
      u8"名存实亡",
      u8"名学",
      u8"名实",
      u8"名实相副",
      u8"名实相符",
      u8"名实难副",
      u8"名家",
      u8"名家书画",
      u8"名宿",
      u8"名寺",
      u8"名将",
      u8"名山",
      u8"名山事业",
      u8"名山县",
      u8"名山大川",
      u8"名山胜川",
      u8"名山胜水",
      u8"名师",
      u8"名师出高徒",
      u8"名帖",
      u8"名店街",
      u8"名录",
      u8"名德重望",
      u8"名我固当",
      u8"名手",
      u8"名扬",
      u8"名扬中外",
      u8"名扬四海",
      u8"名扬天下",
      u8"名护",
      u8"名教",
      u8"名数",
      u8"名旦",
      u8"名星",
      u8"名曰",
      u8"名曲",
      u8"名望",
      u8"名权位",
      u8"名条",
      u8"名来利往",
      u8"名标青史",
      u8"名校",
      u8"名模",
      u8"名次",
      u8"名次表",
      u8"名款",
      u8"名歌",
      u8"名歌手",
      u8"名歌星",
      u8"名正理顺",
      u8"名正言顺",
      u8"名氏",
      u8"名气",
      u8"名流",
      u8"名流巨子",
      u8"名满",
      u8"名满天下",
      u8"名演员",
      u8"名烟",
      u8"名片",
      u8"名片册",
      u8"名片夹",
      u8"名片机",
      u8"名片盒",
      u8"名片纸",
      u8"名片设计",
      u8"名牌",
      u8"名牌产品",
      u8"名牌商品",
      u8"名牌商标",
      u8"名牌大学",
      u8"名牌战略",
      u8"名牌服装",
      u8"名牌服饰",
      u8"名牌货",
      u8"名物",
      u8"名特产",
      u8"名特优",
      u8"名特优产品",
      u8"名特优新",
      u8"名特新优精",
      u8"名犬",
      u8"名状",
      u8"名狗",
      u8"名理",
      u8"名琴",
      u8"名画",
      u8"名画家",
      u8"名留青史",
      u8"名盘",
      u8"名目",
      u8"名目繁多",
      u8"名相",
      u8"名着",
      u8"名碟",
      u8"名称",
      u8"名称权",
      u8"名称栏",
      u8"名窑",
      u8"名章",
      u8"名笔",
      u8"名符其实",
      u8"名篇",
      u8"名簿",
      u8"名系",
      u8"名编辑",
      u8"名缰利锁",
      u8"名耆",
      u8"名胜",
      u8"名胜区",
      u8"名胜古迹",
      u8"名胜地",
      u8"名脚儿",
      u8"名色",
      u8"名节",
      u8"名花",
      u8"名花异草",
      u8"名花有主",
      u8"名茶",
      u8"名药",
      u8"名菜",
      u8"名落孙山",
      u8"名著",
      u8"名表",
      u8"名角",
      u8"名角儿",
      u8"名言",
      u8"名言录",
      u8"名誉",
      u8"名誉主席",
      u8"名誉会员",
      u8"名誉会长",
      u8"名誉博士",
      u8"名誉扫地",
      u8"名誉教授",
      u8"名誉权",
      u8"名誉职",
      u8"名记者",
      u8"名讳",
      u8"名词",
      u8"名词委",
      u8"名词术语",
      u8"名词解释",
      u8"名诗",
      u8"名贯",
      u8"名贵",
      u8"名贵物品",
      u8"名贵药材",
      u8"名贸实易",
      u8"名车",
      u8"名辩",
      u8"名过其实",
      u8"名酒",
      u8"名重一时",
      u8"名门",
      u8"名门世家",
      u8"名门世族",
      u8"名门望族",
      u8"名门贵族",
      u8"名门闺秀",
      u8"名间",
      u8"名间乡",
      u8"名闻中外",
      u8"名闻于世",
      u8"名闻遐迩",
      u8"名难副实",
      u8"名震一时",
      u8"名震中外",
      u8"名鞿利鞚",
      u8"名额",
      u8"名额有限",
      u8"名食",
      u8"名马",
      u8"名驹",
      u8"名高天下",
      u8"名高难副",
      u8"名鸟",
      u8"后一段",
      u8"后上",
      u8"后上去",
      u8"后上来",
      u8"后下",
      u8"后下去",
      u8"后下来",
      u8"后不巴店",
      u8"后不着店",
      u8"后世",
      u8"后为",
      u8"后主",
      u8"后习俗道德",
      u8"后事",
      u8"后事之师",
      u8"后于",
      u8"后人",
      u8"后人乘凉",
      u8"后人把滑",
      u8"后付费",
      u8"后代",
      u8"后代子孙",
      u8"后仰",
      u8"后件",
      u8"后任",
      u8"后会",
      u8"后会无期",
      u8"后会有期",
      u8"后传",
      u8"后作",
      u8"后作物",
      u8"后偏",
      u8"后军",
      u8"后冠",
      u8"后冷器",
      u8"后凉",
      u8"后几",
      u8"后分",
      u8"后刘乡",
      u8"后到",
      u8"后力不继",
      u8"后加安全",
      u8"后劲",
      u8"后劲不足",
      u8"后劲后来",
      u8"后势",
      u8"后勤",
      u8"后勤人员",
      u8"后勤保障",
      u8"后勤区",
      u8"后勤局",
      u8"后勤工作",
      u8"后勤机关",
      u8"后勤部",
      u8"后勤部长",
      u8"后勤部门",
      u8"后勤部队",
      u8"后区",
      u8"后半",
      u8"后半场",
      u8"后半夜",
      u8"后半天",
      u8"后半季",
      u8"后半拍",
      u8"后半晌",
      u8"后半期",
      u8"后半段",
      u8"后半生",
      u8"后半辈子",
      u8"后半部",
      u8"后卫",
      u8"后去",
      u8"后又",
      u8"后发制人",
      u8"后台",
      u8"后台任务",
      u8"后台程序",
      u8"后台老板",
      u8"后叶",
      u8"后同步码",
      u8"后向",
      u8"后含物",
      u8"后周",
      u8"后唐",
      u8"后嗣",
      u8"后园",
      u8"后图",
      u8"后土",
      u8"后场",
      u8"后坐",
      u8"后坐力",
      u8"后埔",
      u8"后基因组",
      u8"后堂",
      u8"后墙",
      u8"后墙纵帆",
      u8"后壁",
      u8"后壁乡",
      u8"后处理",
      u8"后备",
      u8"后备军",
      u8"后备军人",
      u8"后备军官",
      u8"后备力量",
      u8"后备干部",
      u8"后备式",
      u8"后备支撑",
      u8"后备箱",
      u8"后备软盘",
      u8"后天",
      u8"后天下之乐而乐",
      u8"后天免疫",
      u8"后天性",
      u8"后头",
      u8"后奏",
      u8"后奏曲",
      u8"后妃",
      u8"后妈",
      u8"后妻",
      u8"后娘",
      u8"后学",
      u8"后室",
      u8"后宫",
      u8"后宰门",
      u8"后尘",
      u8"后尾",
      u8"后屋",
      u8"后山",
      u8"后峰",
      u8"后工业化文明",
      u8"后工业社会",
      u8"后巷",
      u8"后市",
      u8"后帐",
      u8"后年",
      u8"后序",
      u8"后座",
      u8"后座力",
      u8"后庭",
      u8"后庭花",
      u8"后影",
      u8"后心",
      u8"后怕",
      u8"后怕虎",
      u8"后悔",
      u8"后悔不及",
      u8"后悔不已",
      u8"后悔无及",
      u8"后悔痛苦",
      u8"后悔药",
      u8"后悔莫及",
      u8"后患",
      u8"后患无穷",
      u8"后成论",
      u8"后房",
      u8"后手",
      u8"后手不接",
      u8"后拥前呼",
      u8"后掌",
      u8"后排",
      u8"后掠角",
      u8"后接",
      u8"后推术",
      u8"后援",
      u8"后援会",
      u8"后援军",
      u8"后援团",
      u8"后撤",
      u8"后攻",
      u8"后放",
      u8"后效",
      u8"后文",
      u8"后方",
      u8"后方区",
      u8"后方城市",
      u8"后旗",
      u8"后无来者",
      u8"后日",
      u8"后昆",
      u8"后晋",
      u8"后晌",
      u8"后晚",
      u8"后景",
      u8"后有",
      u8"后望镜",
      u8"后期",
      u8"后期制作",
      u8"后期合成",
      u8"后期后勤",
      u8"后来",
      u8"后来之秀",
      u8"后来人",
      u8"后来居上",
      u8"后来居上者",
      u8"后来者",
      u8"后来者居上",
      u8"后果",
      u8"后果不堪设想",
      u8"后果严重",
      u8"后果堪忧",
      u8"后果堪虑",
      u8"后果自负",
      u8"后架",
      u8"后桅",
      u8"后桥",
      u8"后梁",
      u8"后梁太祖",
      u8"后椅",
      u8"后步",
      u8"后殖民",
      u8"后殖民主义",
      u8"后段",
      u8"后殿",
      u8"后母",
      u8"后汉",
      u8"后汉书",
      u8"后河乡",
      u8"后派",
      u8"后浪",
      u8"后浪催前浪",
      u8"后浪推前浪",
      u8"后海",
      u8"后海先河",
      u8"后港",
      u8"后溪",
      u8"后溪自然村",
      u8"后灯",
      u8"后点",
      u8"后烘",
      u8"后燕",
      u8"后父",
      u8"后爹",
      u8"后牙",
      u8"后牵索",
      u8"后现代",
      u8"后现代主义",
      u8"后生",
      u8"后生可畏",
      u8"后生小子",
      u8"后生晚学",
      u8"后用",
      u8"后由",
      u8"后甲板",
      u8"后白蛋白",
      u8"后盖",
      u8"后盖板",
      u8"后盾",
      u8"后知",
      u8"后知后觉",
      u8"后福",
      u8"后福无量",
      u8"后秃",
      u8"后秦",
      u8"后移",
      u8"后稷",
      u8"后空翻",
      u8"后窗",
      u8"后窗玻璃",
      u8"后站",
      u8"后端",
      u8"后端网",
      u8"后竹围",
      u8"后篇",
      u8"后绘图",
      u8"后继",
      u8"后继乏人",
      u8"后继无人",
      u8"后继无力",
      u8"后继有人",
      u8"后续",
      u8"后续力",
      u8"后缀",
      u8"后缀名",
      u8"后缀装土机",
      u8"后缘",
      u8"后置",
      u8"后置词",
      u8"后羿",
      u8"后翼",
      u8"后者",
      u8"后肢",
      u8"后背",
      u8"后脑",
      u8"后脑勺",
      u8"后脑勺子",
      u8"后脑杓",
      u8"后脚",
      u8"后脸儿",
      u8"后腰",
      u8"后腿",
      u8"后膛",
      u8"后舱",
      u8"后节",
      u8"后花园",
      u8"后菜园",
      u8"后营村",
      u8"后藏",
      u8"后藤久美子",
      u8"后行",
      u8"后街",
      u8"后补",
      u8"后裔",
      u8"后襟",
      u8"后襬",
      u8"后视图",
      u8"后视镜",
      u8"后计",
      u8"后记",
      u8"后设",
      u8"后话",
      u8"后语",
      u8"后读",
      u8"后负荷",
      u8"后账",
      u8"后走",
      u8"后赵",
      u8"后起",
      u8"后起之秀",
      u8"后足",
      u8"后跟",
      u8"后路",
      u8"后踝",
      u8"后踱",
      u8"后身",
      u8"后车",
      u8"后车之戒",
      u8"后车之鉴",
      u8"后车站",
      u8"后转",
      u8"后轮",
      u8"后轴",
      u8"后辈",
      u8"后辈小子",
      u8"后辍",
      u8"后辙",
      u8"后边",
      u8"后过",
      u8"后过渡期",
      u8"后进",
      u8"后进之秀",
      u8"后进先出",
      u8"后进村",
      u8"后进生",
      u8"后进领袖",
      u8"后述",
      u8"后退",
      u8"后退接触位",
      u8"后送",
      u8"后遗",
      u8"后遗症",
      u8"后部",
      u8"后里",
      u8"后金",
      u8"后镜",
      u8"后门",
      u8"后门进狼",
      u8"后门进虎",
      u8"后闸",
      u8"后防",
      u8"后防线",
      u8"后院",
      u8"后院子",
      u8"后院起火",
      u8"后隋村",
      u8"后随链",
      u8"后集",
      u8"后面",
      u8"后顶",
      u8"后项",
      u8"后顾",
      u8"后顾之忧",
      u8"后颈",
      u8"后首",
      u8"后魏",
      u8"后龙",
      u8"后龙溪",
      u8"吏官",
      u8"吏治",
      u8"吏部",
      u8"吐下",
      u8"吐下去",
      u8"吐下来",
      u8"吐丝",
      u8"吐丝自缚",
      u8"吐了",
      u8"吐出",
      u8"吐出来",
      u8"吐刚茹柔",
      u8"吐到",
      u8"吐口",
      u8"吐司",
      u8"吐司面包",
      u8"吐吐",
      u8"吐吐气",
      u8"吐哈",
      u8"吐哺",
      u8"吐哺捉发",
      u8"吐哺握发",
      u8"吐哺辍洗",
      u8"吐在",
      u8"吐好",
      u8"吐字",
      u8"吐实",
      u8"吐属",
      u8"吐弃",
      u8"吐得",
      u8"吐心吐胆",
      u8"吐成",
      u8"吐掉",
      u8"吐故纳新",
      u8"吐来吐去",
      u8"吐根",
      u8"吐根素",
      u8"吐气",
      u8"吐气扬眉",
      u8"吐气若兰",
      u8"吐沫",
      u8"吐泡",
      u8"吐泻",
      u8"吐番",
      u8"吐痰",
      u8"吐真言",
      u8"吐着",
      u8"吐穗",
      u8"吐絮",
      u8"吐纳",
      u8"吐绶鸡",
      u8"吐翠",
      u8"吐肝露胆",
      u8"吐胆倾心",
      u8"吐舌",
      u8"吐舌习惯",
      u8"吐舌头",
      u8"吐艳",
      u8"吐苦水",
      u8"吐蕃",
      u8"吐蕊",
      u8"吐藩",
      u8"吐血",
      u8"吐诉",
      u8"吐话",
      u8"吐谷浑",
      u8"吐过",
      u8"吐过去",
      u8"吐过来",
      u8"吐酸",
      u8"吐露",
      u8"吐露出",
      u8"吐露真情",
      u8"吐音",
      u8"吐食握发",
      u8"吐骨头",
      u8"吐鲁番",
      u8"吐鲁番地区",
      u8"吐鲁番市",
      u8"向上",
      u8"向上一路",
      u8"向上伸延",
      u8"向上倾斜",
      u8"向上扔",
      u8"向下",
      u8"向下倾斜",
      u8"向下兼容",
      u8"向东",
      u8"向东看",
      u8"向东走",
      u8"向人",
      u8"向人民负责",
      u8"向他",
      u8"向你",
      u8"向使",
      u8"向例",
      u8"向侧面",
      u8"向光",
      u8"向光性",
      u8"向内",
      u8"向内地",
      u8"向内走",
      u8"向前",
      u8"向前可达性",
      u8"向前看",
      u8"向前看齐",
      u8"向前行驶",
      u8"向前走",
      u8"向前进",
      u8"向北",
      u8"向北看",
      u8"向北走",
      u8"向华强",
      u8"向南",
      u8"向南方",
      u8"向南看",
      u8"向南走",
      u8"向右",
      u8"向右爱",
      u8"向右看",
      u8"向右看齐",
      u8"向右走",
      u8"向右转",
      u8"向右转走",
      u8"向后",
      u8"向后散射",
      u8"向后看",
      u8"向后走",
      u8"向后转",
      u8"向后转走",
      u8"向善",
      u8"向地",
      u8"向地性",
      u8"向壁虚构",
      u8"向壁虚造",
      u8"向声背实",
      u8"向外",
      u8"向外看",
      u8"向外走",
      u8"向大年",
      u8"向天",
      u8"向天歌",
      u8"向天盏",
      u8"向天笑",
      u8"向天而唾",
      u8"向太空",
      u8"向她",
      u8"向学",
      u8"向导",
      u8"向导公司",
      u8"向导员",
      u8"向山",
      u8"向左",
      u8"向左爱",
      u8"向左看",
      u8"向左看齐",
      u8"向左走",
      u8"向左转",
      u8"向左转走",
      u8"向巴平措",
      u8"向平之原",
      u8"向平之愿",
      u8"向应",
      u8"向度",
      u8"向往",
      u8"向往已久",
      u8"向心",
      u8"向心力",
      u8"向心加速度",
      u8"向心法则",
      u8"向性",
      u8"向慕",
      u8"向戌",
      u8"向我",
      u8"向斜",
      u8"向斜层",
      u8"向无此例",
      u8"向日",
      u8"向日性",
      u8"向日葵",
      u8"向明",
      u8"向晚",
      u8"向束",
      u8"向来",
      u8"向来如此",
      u8"向来是",
      u8"向来都是",
      u8"向梅",
      u8"向海",
      u8"向海岚",
      u8"向火",
      u8"向火乞儿",
      u8"向珠",
      u8"向用",
      u8"向着",
      u8"向社会开放",
      u8"向秀",
      u8"向秀丽",
      u8"向红基",
      u8"向纵深发展",
      u8"向背",
      u8"向舷外",
      u8"向若而叹",
      u8"向西",
      u8"向西南方",
      u8"向触",
      u8"向谁",
      u8"向迩",
      u8"向里",
      u8"向量",
      u8"向量丛",
      u8"向量分析",
      u8"向量地图",
      u8"向量场",
      u8"向量循环方法",
      u8"向量心理学",
      u8"向量指令",
      u8"向量蒙特卡罗方法",
      u8"向量量化",
      u8"向钱看",
      u8"向问天",
      u8"向阳",
      u8"向阳区",
      u8"向阳历法点",
      u8"向阳大道",
      u8"向阳花",
      u8"向阳花木早逢春",
      u8"向阳路",
      u8"向阳镇",
      u8"向隅",
      u8"向隅而泣",
      u8"向风慕义",
      u8"向风针",
      u8"吓一跳",
      u8"吓不了",
      u8"吓不倒",
      u8"吓了",
      u8"吓了一跳",
      u8"吓人",
      u8"吓住",
      u8"吓倒",
      u8"吓傻",
      u8"吓出",
      u8"吓出病来",
      u8"吓到",
      u8"吓呆",
      u8"吓呆了",
      u8"吓哭",
      u8"吓唬",
      u8"吓唬人",
      u8"吓唬吓唬",
      u8"吓坏",
      u8"吓得",
      u8"吓怕",
      u8"吓成",
      u8"吓昏",
      u8"吓来吓去",
      u8"吓死",
      u8"吓死人",
      u8"吓死你",
      u8"吓瘫",
      u8"吓着",
      u8"吓破",
      u8"吓破胆",
      u8"吓老",
      u8"吓走",
      u8"吓跑",
      u8"吓过",
      u8"吓退",
      u8"吓阻",
      u8"吓阻力量",
      u8"吕七",
      u8"吕不韦",
      u8"吕丽萍",
      u8"吕传赞",
      u8"吕凉",
      u8"吕剧",
      u8"吕勒奥",
      u8"吕后",
      u8"吕国蔚",
      u8"吕安题凤",
      u8"吕宋",
      u8"吕宋岛",
      u8"吕宋烟",
      u8"吕小品",
      u8"吕小妹",
      u8"吕布",
      u8"吕文德",
      u8"吕方",
      u8"吕日周",
      u8"吕景亚",
      u8"吕有慧",
      u8"吕梁",
      u8"吕梁山",
      u8"吕梁市",
      u8"吕正平",
      u8"吕正操",
      u8"吕武操莽",
      u8"吕毅",
      u8"吕毅中",
      u8"吕氏",
      u8"吕氏春秋",
      u8"吕洞宾",
      u8"吕澄",
      u8"吕燕",
      u8"吕班",
      u8"吕留良",
      u8"吕祖善",
      u8"吕秀莲",
      u8"吕秀菱",
      u8"吕端大事不糊涂",
      u8"吕良伟",
      u8"吕葆中",
      u8"吕达嵘",
      u8"吕颂贤",
      u8"吕齐",
      u8"吖啶",
      u8"吖啶橙",
      u8"吖啶黄",
      u8"吖啶黄素",
      u8"吖嗪",
      u8"吗啡",
      u8"吗啡中毒",
      u8"吗啡烷",
      u8"君不见",
      u8"君临",
      u8"君临天下",
      u8"君主",
      u8"君主专制",
      u8"君主专制制",
      u8"君主专政",
      u8"君主主义",
      u8"君主制",
      u8"君主国",
      u8"君主政体",
      u8"君主政治",
      u8"君主权",
      u8"君主立宪",
      u8"君主立宪制",
      u8"君主队",
      u8"君之高论不敢苟同",
      u8"君命无二",
      u8"君唱臣和",
      u8"君圣臣贤",
      u8"君士坦丁",
      u8"君士坦丁堡",
      u8"君子",
      u8"君子一言",
      u8"君子一言快马一鞭",
      u8"君子三戒",
      u8"君子之交",
      u8"君子之交淡如水",
      u8"君子兰",
      u8"君子动口不动手",
      u8"君子协定",
      u8"君子和而不同",
      u8"君子固穷",
      u8"君子国",
      u8"君子坦荡荡",
      u8"君子好逑",
      u8"君子报仇十年不晚",
      u8"君子爱财",
      u8"君安",
      u8"君山",
      u8"君山区",
      u8"君暗臣蔽",
      u8"君权",
      u8"君权神授",
      u8"君王",
      u8"君臣",
      u8"君臣佐使",
      u8"君臣父子",
      u8"君辱臣死",
      u8"吝啬",
      u8"吝啬鬼",
      u8"吝惜",
      u8"吝舍",
      u8"吞下",
      u8"吞下去",
      u8"吞下来",
      u8"吞了",
      u8"吞了下去",
      u8"吞云吐雾",
      u8"吞刀刮肠",
      u8"吞刀吐火",
      u8"吞到",
      u8"吞剑者",
      u8"吞剥",
      u8"吞占",
      u8"吞口水",
      u8"吞吐",
      u8"吞吐能力",
      u8"吞吐量",
      u8"吞吞",
      u8"吞吞吐吐",
      u8"吞咽",
      u8"吞咽困难",
      u8"吞噬",
      u8"吞噬作用",
      u8"吞噬细胞",
      u8"吞声",
      u8"吞声忍气",
      u8"吞声忍泪",
      u8"吞声饮恨",
      u8"吞声饮气",
      u8"吞声饮泣",
      u8"吞并",
      u8"吞恨",
      u8"吞掉",
      u8"吞服",
      u8"吞没",
      u8"吞涎症",
      u8"吞火者",
      u8"吞灭",
      u8"吞炭漆身",
      u8"吞符翕景",
      u8"吞纸抱犬",
      u8"吞舟之鱼",
      u8"吞舟是漏",
      u8"吞舟漏网",
      u8"吞言咽理",
      u8"吞进",
      u8"吞进去",
      u8"吞金",
      u8"吞风饮雨",
      u8"吞食",
      u8"吞食天地",
      u8"吞食鱼",
      u8"吟味",
      u8"吟咏",
      u8"吟哦",
      u8"吟唱",
      u8"吟游",
      u8"吟花咏柳",
      u8"吟诗",
      u8"吟诗作对",
      u8"吟诵",
      u8"吟风咏月",
      u8"吟风弄月",
      u8"吠叫",
      u8"吠声",
      u8"吠声吠影",
      u8"吠形吠声",
      u8"吠影吠声",
      u8"吠陀",
      u8"吠非其主",
      u8"吡咯",
      u8"吡咯啉",
      u8"吡咯烷",
      u8"吡咯烷酮",
      u8"吡哆胺",
      u8"吡哆醇",
      u8"吡哆醛",
      u8"吡唑",
      u8"吡唑呋喃菌素",
      u8"吡啶",
      u8"吡啶啉",
      u8"吡啶基",
      u8"吡啶甲酸",
      u8"吡喃糖",
      u8"否决",
      u8"否决制",
      u8"否决权",
      u8"否决票",
      u8"否决者",
      u8"否则",
      u8"否则请",
      u8"否去泰来",
      u8"否定",
      u8"否定一切",
      u8"否定之否定",
      u8"否定句",
      u8"否定性",
      u8"否定词",
      u8"否往泰来",
      u8"否极泰回",
      u8"否极泰来",
      u8"否极阳回",
      u8"否终则泰",
      u8"否终复泰",
      u8"否认",
      u8"否诀",
      u8"吧主",
      u8"吧台",
      u8"吧哒",
      u8"吧唧",
      u8"吧嗒",
      u8"吧女",
      u8"吨位",
      u8"吨公里",
      u8"吨数",
      u8"吨粮",
      u8"吨粮县",
      u8"吨粮田",
      u8"吨重",
      u8"吩咐",
      u8"吩嗪",
      u8"含上",
      u8"含下",
      u8"含义",
      u8"含义丰富",
      u8"含了",
      u8"含仁怀义",
      u8"含住",
      u8"含入",
      u8"含入口中",
      u8"含入口内",
      u8"含冤",
      u8"含冤九泉",
      u8"含冤受屈",
      u8"含冤而死",
      u8"含冤而终",
      u8"含冤莫白",
      u8"含冤负屈",
      u8"含冰茹檗",
      u8"含冰量",
      u8"含凝胶",
      u8"含到",
      u8"含含糊糊",
      u8"含哺鼓腹",
      u8"含商咀征",
      u8"含商咀徵",
      u8"含在",
      u8"含在口中",
      u8"含在口内",
      u8"含垢包羞",
      u8"含垢匿瑕",
      u8"含垢弃瑕",
      u8"含垢忍污",
      u8"含垢忍耻",
      u8"含垢忍辱",
      u8"含垢纳污",
      u8"含垢藏瑕",
      u8"含垢藏疾",
      u8"含宫咀征",
      u8"含宫咀徵",
      u8"含山",
      u8"含山县",
      u8"含得",
      u8"含怒",
      u8"含怨",
      u8"含怨而死",
      u8"含怨而终",
      u8"含恨",
      u8"含恨在心",
      u8"含恨而死",
      u8"含恨而终",
      u8"含悲",
      u8"含情",
      u8"含情脉脉",
      u8"含意",
      u8"含愤",
      u8"含愧",
      u8"含时微扰",
      u8"含时薛定谔方程",
      u8"含明隐迹",
      u8"含有",
      u8"含毫砚墨",
      u8"含气边界",
      u8"含气面积",
      u8"含氚化合物",
      u8"含氟磨光糊剂",
      u8"含氢",
      u8"含氢指数",
      u8"含氧",
      u8"含氧酸",
      u8"含氧量",
      u8"含氮化合物",
      u8"含氯氟烃",
      u8"含氰苷",
      u8"含水",
      u8"含水分",
      u8"含水层",
      u8"含水率",
      u8"含水率仪",
      u8"含水量",
      u8"含污忍垢",
      u8"含沙",
      u8"含沙射影",
      u8"含沙影射",
      u8"含沙量",
      u8"含油",
      u8"含油层",
      u8"含油气大区",
      u8"含油污水处理设施",
      u8"含油污水舱",
      u8"含油率",
      u8"含油量",
      u8"含泪",
      u8"含淀粉",
      u8"含混",
      u8"含混不清",
      u8"含漱剂",
      u8"含片",
      u8"含牙囊肿",
      u8"含牙带角",
      u8"含牙戴角",
      u8"含猪油",
      u8"含瑕积垢",
      u8"含疚",
      u8"含盐",
      u8"含着",
      u8"含着泪",
      u8"含着骨头露着肉",
      u8"含硫分",
      u8"含硼",
      u8"含章天挺",
      u8"含章挺生",
      u8"含笑",
      u8"含笑九泉",
      u8"含笑入地",
      u8"含笑而死",
      u8"含笑而终",
      u8"含答案",
      u8"含糊",
      u8"含糊不明",
      u8"含糊不清",
      u8"含糊其词",
      u8"含糊其辞",
      u8"含糊地",
      u8"含糖",
      u8"含糖量",
      u8"含羞",
      u8"含羞草",
      u8"含而不发",
      u8"含而不露",
      u8"含肥泥炭盆",
      u8"含胡",
      u8"含致癌",
      u8"含苞",
      u8"含苞待放",
      u8"含苞欲放",
      u8"含英咀华",
      u8"含菁咀华",
      u8"含菌细胞",
      u8"含蓄",
      u8"含蓄地",
      u8"含蓼问疾",
      u8"含蕴",
      u8"含蜡",
      u8"含血",
      u8"含血喷人",
      u8"含血噀人",
      u8"含血潠人",
      u8"含起",
      u8"含起来",
      u8"含辛忍苦",
      u8"含辛茹若",
      u8"含辛茹苦",
      u8"含过",
      u8"含酒精",
      u8"含酸",
      u8"含量",
      u8"含金量",
      u8"含钙",
      u8"含钙量",
      u8"含铅量",
      u8"含锌",
      u8"含锌量",
      u8"含镁",
      u8"含霜履雪",
      u8"含饴弃孙",
      u8"含饴弄孙",
      u8"含齿戴发",
      u8"听上",
      u8"听下去",
      u8"听不出",
      u8"听不出来",
      u8"听不到",
      u8"听不得",
      u8"听不懂",
      u8"听不清",
      u8"听不见",
      u8"听不进",
      u8"听不进去",
      u8"听之",
      u8"听之任之",
      u8"听之藐藐",
      u8"听书",
      u8"听书网",
      u8"听了",
      u8"听事",
      u8"听人",
      u8"听人摆布",
      u8"听人穿鼻",
      u8"听从",
      u8"听从命令",
      u8"听从指挥",
      u8"听他",
      u8"听任",
      u8"听众",
      u8"听会",
      u8"听作",
      u8"听作是",
      u8"听你",
      u8"听便",
      u8"听信",
      u8"听候",
      u8"听候处理",
      u8"听候通知",
      u8"听做",
      u8"听其自流",
      u8"听其自然",
      u8"听其言",
      u8"听其言而观其行",
      u8"听写",
      u8"听写测验",
      u8"听决",
      u8"听凭",
      u8"听凭处置",
      u8"听出",
      u8"听出来",
      u8"听到",
      u8"听力",
      u8"听力测验",
      u8"听力计",
      u8"听厌",
      u8"听取",
      u8"听取意见",
      u8"听取批评",
      u8"听取报告",
      u8"听取汇报",
      u8"听后",
      u8"听后感",
      u8"听君一席话",
      u8"听听",
      u8"听听看",
      u8"听命",
      u8"听命于",
      u8"听声",
      u8"听声辨位",
      u8"听天由命",
      u8"听头",
      u8"听她",
      u8"听好",
      u8"听子",
      u8"听完",
      u8"听审",
      u8"听宫",
      u8"听小骨",
      u8"听差",
      u8"听得",
      u8"听得出",
      u8"听得出来",
      u8"听得到",
      u8"听得懂",
      u8"听得见",
      u8"听惯",
      u8"听想",
      u8"听懂",
      u8"听戏",
      u8"听成",
      u8"听我",
      u8"听打",
      u8"听政",
      u8"听日",
      u8"听来",
      u8"听来听去",
      u8"听歌",
      u8"听歌曲",
      u8"听歌网",
      u8"听清",
      u8"听由",
      u8"听的歌",
      u8"听相声",
      u8"听着",
      u8"听碟",
      u8"听神经",
      u8"听神经副核",
      u8"听筒",
      u8"听管",
      u8"听者",
      u8"听者有心",
      u8"听者藐藐",
      u8"听而不闻",
      u8"听腻",
      u8"听装",
      u8"听见",
      u8"听见了",
      u8"听见风就是雨",
      u8"听觉",
      u8"听觉位置说",
      u8"听觉区",
      u8"听觉反射",
      u8"听觉定位",
      u8"听觉掩蔽",
      u8"听觉敏度",
      u8"听觉理论",
      u8"听觉疲劳",
      u8"听觉登记",
      u8"听觉编码",
      u8"听觉范围",
      u8"听训",
      u8"听讲",
      u8"听讼",
      u8"听证",
      u8"听证会",
      u8"听诊",
      u8"听诊器",
      u8"听译",
      u8"听话",
      u8"听话儿",
      u8"听说",
      u8"听说会",
      u8"听说在",
      u8"听说是",
      u8"听说有",
      u8"听说能",
      u8"听说读写",
      u8"听说过",
      u8"听课",
      u8"听课证",
      u8"听谁",
      u8"听起",
      u8"听起来",
      u8"听过",
      u8"听过去",
      u8"听过来",
      u8"听进",
      u8"听道",
      u8"听错",
      u8"听闻",
      u8"听阈",
      u8"听雨轩",
      u8"听音",
      u8"听音乐",
      u8"听风听水",
      u8"听风是雨",
      u8"听骨",
      u8"吭哧",
      u8"吭声",
      u8"吭气",
      u8"吮乳",
      u8"吮促",
      u8"吮吸",
      u8"吮吸反射",
      u8"吮墨",
      u8"吮疽舐痔",
      u8"吮痈舐痔",
      u8"启东",
      u8"启东县",
      u8"启东市",
      u8"启事",
      u8"启动",
      u8"启动器",
      u8"启动子",
      u8"启动市场",
      u8"启动时",
      u8"启动易",
      u8"启动盘",
      u8"启动装置",
      u8"启动资金",
      u8"启动项",
      u8"启发",
      u8"启发式",
      u8"启发式布线",
      u8"启发式教育",
      u8"启发性",
      u8"启发法",
      u8"启发者",
      u8"启口",
      u8"启奏",
      u8"启始",
      u8"启子",
      u8"启宠纳侮",
      u8"启封",
      u8"启幕",
      u8"启开",
      u8"启德",
      u8"启德机场",
      u8"启明",
      u8"启明学校",
      u8"启明星",
      u8"启智班",
      u8"启殿",
      u8"启瓶器",
      u8"启用",
      u8"启瞶振聋",
      u8"启示",
      u8"启示录",
      u8"启禀",
      u8"启程",
      u8"启聪",
      u8"启聪学校",
      u8"启航",
      u8"启蒙",
      u8"启蒙教育",
      u8"启蒙者",
      u8"启蒙运动",
      u8"启行",
      u8"启衡",
      u8"启辉器",
      u8"启运",
      u8"启迪",
      u8"启锚",
      u8"启门",
      u8"启闭",
      u8"启闭机",
      u8"启齿",
      u8"吱吱",
      u8"吱吱作响",
      u8"吱吱叫",
      u8"吱吱响",
      u8"吱吱响声",
      u8"吱吱喳喳",
      u8"吱吱嘎嘎",
      u8"吱吱悠悠",
      u8"吱吾",
      u8"吱呀",
      u8"吱哩哇啦",
      u8"吱唔",
      u8"吱喳",
      u8"吱声",
      u8"吲哚",
      u8"吲哚霉素",
      u8"吴三桂",
      u8"吴下阿蒙",
      u8"吴世道",
      u8"吴中",
      u8"吴中区",
      u8"吴中路",
      u8"吴之荣",
      u8"吴京",
      u8"吴京安",
      u8"吴仁宝",
      u8"吴仪",
      u8"吴伯萧",
      u8"吴伯雄",
      u8"吴佩孚",
      u8"吴佩文",
      u8"吴倩莲",
      u8"吴健豪",
      u8"吴健雄",
      u8"吴元德",
      u8"吴光胜",
      u8"吴克群",
      u8"吴六奇",
      u8"吴六破",
      u8"吴兴",
      u8"吴兴区",
      u8"吴兴国",
      u8"吴冀南",
      u8"吴冕",
      u8"吴军",
      u8"吴凤",
      u8"吴凤工专",
      u8"吴凤庙",
      u8"吴刚",
      u8"吴刚伐桂",
      u8"吴劲草",
      u8"吴卫东",
      u8"吴县",
      u8"吴县市",
      u8"吴君如",
      u8"吴启华",
      u8"吴启迪",
      u8"吴哥窟",
      u8"吴嘉丽",
      u8"吴国",
      u8"吴国敬",
      u8"吴国栋",
      u8"吴坎",
      u8"吴基传",
      u8"吴堡",
      u8"吴堡县",
      u8"吴大维",
      u8"吴大鹏",
      u8"吴天德",
      u8"吴头楚尾",
      u8"吴奇民",
      u8"吴奇隆",
      u8"吴娃",
      u8"吴孟超",
      u8"吴孟达",
      u8"吴宇森",
      u8"吴安年",
      u8"吴宏达",
      u8"吴宓",
      u8"吴宗宪",
      u8"吴官正",
      u8"吴定富",
      u8"吴宝宇",
      u8"吴宫花草埋幽径",
      u8"吴家丽",
      u8"吴家乐",
      u8"吴家包村",
      u8"吴家山",
      u8"吴家骧",
      u8"吴小平",
      u8"吴岱融",
      u8"吴川",
      u8"吴川县",
      u8"吴川市",
      u8"吴市之箫",
      u8"吴市吹箫",
      u8"吴带当风",
      u8"吴平",
      u8"吴广",
      u8"吴广林",
      u8"吴应熊",
      u8"吴庭艳",
      u8"吴建屏",
      u8"吴建平",
      u8"吴建民",
      u8"吴建豪",
      u8"吴彦祖",
      u8"吴志强",
      u8"吴忠",
      u8"吴忠市",
      u8"吴思远",
      u8"吴恩琪",
      u8"吴承恩",
      u8"吴承瑛",
      u8"吴敬梓",
      u8"吴旗",
      u8"吴旗县",
      u8"吴昌硕",
      u8"吴晓",
      u8"吴晓敏",
      u8"吴晗",
      u8"吴晶晶",
      u8"吴智节",
      u8"吴柏英",
      u8"吴桥",
      u8"吴桥县",
      u8"吴梅",
      u8"吴楚",
      u8"吴毅将",
      u8"吴江",
      u8"吴江县",
      u8"吴江市",
      u8"吴法宪",
      u8"吴海燕",
      u8"吴涛",
      u8"吴淑珍",
      u8"吴淞",
      u8"吴淞口",
      u8"吴淞江",
      u8"吴淡如",
      u8"吴爱英",
      u8"吴牛喘月",
      u8"吴玉华",
      u8"吴玉芳",
      u8"吴王",
      u8"吴用",
      u8"吴祯",
      u8"吴禄贞",
      u8"吴窑村",
      u8"吴立身",
      u8"吴竞",
      u8"吴绮莉",
      u8"吴美枝",
      u8"吴美珩",
      u8"吴耀汉",
      u8"吴良",
      u8"吴若权",
      u8"吴若甫",
      u8"吴茱萸",
      u8"吴茵",
      u8"吴菌",
      u8"吴营",
      u8"吴语",
      u8"吴貞婉",
      u8"吴起",
      u8"吴越",
      u8"吴越同舟",
      u8"吴辰君",
      u8"吴道子",
      u8"吴道通",
      u8"吴邦国",
      u8"吴郡",
      u8"吴郭鱼",
      u8"吴金贵",
      u8"吴钊燮",
      u8"吴镇宇",
      u8"吴长风",
      u8"吴阶平",
      u8"吴雪",
      u8"吴青烈",
      u8"吴静",
      u8"吴静娴",
      u8"吴音",
      u8"吴领军",
      u8"吵上",
      u8"吵人",
      u8"吵到",
      u8"吵吵",
      u8"吵吵嚷嚷",
      u8"吵吵闹闹",
      u8"吵嘴",
      u8"吵嚷",
      u8"吵扰",
      u8"吵杂",
      u8"吵来吵去",
      u8"吵架",
      u8"吵着",
      u8"吵起",
      u8"吵起来",
      u8"吵过",
      u8"吵过去",
      u8"吵过来",
      u8"吵醒",
      u8"吵闹",
      u8"吵骂",
      u8"吸上",
      u8"吸上去",
      u8"吸上来",
      u8"吸下",
      u8"吸下去",
      u8"吸下来",
      u8"吸了",
      u8"吸住",
      u8"吸储",
      u8"吸允",
      u8"吸光",
      u8"吸光性",
      u8"吸入",
      u8"吸入压力",
      u8"吸入口滤器",
      u8"吸入式",
      u8"吸入性",
      u8"吸出",
      u8"吸出去",
      u8"吸出来",
      u8"吸到",
      u8"吸力",
      u8"吸去",
      u8"吸反",
      u8"吸取",
      u8"吸取教训",
      u8"吸取经验",
      u8"吸吮",
      u8"吸吸",
      u8"吸咽者",
      u8"吸嗅",
      u8"吸回",
      u8"吸回去",
      u8"吸回来",
      u8"吸地",
      u8"吸地板",
      u8"吸地毯",
      u8"吸塑机",
      u8"吸墨",
      u8"吸墨纸",
      u8"吸声",
      u8"吸声材料",
      u8"吸声板",
      u8"吸头",
      u8"吸奶器",
      u8"吸好",
      u8"吸完",
      u8"吸小",
      u8"吸尘",
      u8"吸尘器",
      u8"吸尘机",
      u8"吸尘系统",
      u8"吸干",
      u8"吸引",
      u8"吸引人",
      u8"吸引住",
      u8"吸引力",
      u8"吸引区",
      u8"吸引圈",
      u8"吸引外资",
      u8"吸得",
      u8"吸成",
      u8"吸掉",
      u8"吸收",
      u8"吸收体",
      u8"吸收光谱",
      u8"吸收光谱电化学",
      u8"吸收剂",
      u8"吸收剂量",
      u8"吸收力",
      u8"吸收器",
      u8"吸收塔",
      u8"吸收外资",
      u8"吸收性",
      u8"吸收截面",
      u8"吸收率",
      u8"吸收玻璃",
      u8"吸收系数",
      u8"吸收能力",
      u8"吸收谱带",
      u8"吸收边界条件",
      u8"吸断",
      u8"吸新吐故",
      u8"吸杂",
      u8"吸来",
      u8"吸来吸去",
      u8"吸棉",
      u8"吸毒",
      u8"吸毒上瘾",
      u8"吸毒者",
      u8"吸毒贩毒",
      u8"吸气",
      u8"吸氧",
      u8"吸水",
      u8"吸水势",
      u8"吸水层段",
      u8"吸水性",
      u8"吸水指数",
      u8"吸水机",
      u8"吸水水池",
      u8"吸水率",
      u8"吸水纸",
      u8"吸水能力",
      u8"吸汗",
      u8"吸汗带",
      u8"吸汗性",
      u8"吸汲",
      u8"吸油烟机",
      u8"吸油纸",
      u8"吸法",
      u8"吸浆虫",
      u8"吸涎器",
      u8"吸液管",
      u8"吸湿",
      u8"吸湿性",
      u8"吸烟",
      u8"吸烟客",
      u8"吸烟室",
      u8"吸烟性黑斑症",
      u8"吸烟者",
      u8"吸热",
      u8"吸热反应",
      u8"吸牢",
      u8"吸盘",
      u8"吸盘式",
      u8"吸着",
      u8"吸着剂",
      u8"吸着烟",
      u8"吸着物",
      u8"吸管",
      u8"吸管虫",
      u8"吸纳",
      u8"吸绵",
      u8"吸者",
      u8"吸虫",
      u8"吸血",
      u8"吸血虫",
      u8"吸血鬼",
      u8"吸走",
      u8"吸起",
      u8"吸起来",
      u8"吸跑",
      u8"吸过",
      u8"吸过去",
      u8"吸过来",
      u8"吸进",
      u8"吸进去",
      u8"吸进来",
      u8"吸透",
      u8"吸遍",
      u8"吸量管",
      u8"吸金",
      u8"吸铁",
      u8"吸铁石",
      u8"吸附",
      u8"吸附催化",
      u8"吸附剂",
      u8"吸附力",
      u8"吸附器",
      u8"吸附平衡",
      u8"吸附式净化",
      u8"吸附性",
      u8"吸附气泡分离法",
      u8"吸附水",
      u8"吸附滞后",
      u8"吸音",
      u8"吸音板",
      u8"吸音棉",
      u8"吸顶灯",
      u8"吸风饮露",
      u8"吸食",
      u8"吸食毒品",
      u8"吸饱",
      u8"吹上",
      u8"吹上去",
      u8"吹上来",
      u8"吹下",
      u8"吹下去",
      u8"吹下来",
      u8"吹乐",
      u8"吹乱",
      u8"吹乾",
      u8"吹了",
      u8"吹倒",
      u8"吹入",
      u8"吹入器",
      u8"吹冷气",
      u8"吹冷风",
      u8"吹出",
      u8"吹出去",
      u8"吹出来",
      u8"吹到",
      u8"吹动",
      u8"吹去",
      u8"吹发",
      u8"吹口哨",
      u8"吹台",
      u8"吹叶嚼蕊",
      u8"吹号",
      u8"吹向",
      u8"吹吹打打",
      u8"吹吹拍拍",
      u8"吹哨",
      u8"吹哨声",
      u8"吹哨子",
      u8"吹唇唱吼",
      u8"吹喇叭",
      u8"吹嘘",
      u8"吹嘘大王",
      u8"吹在",
      u8"吹垢索瘢",
      u8"吹塑",
      u8"吹塑机",
      u8"吹大牛",
      u8"吹头",
      u8"吹头发",
      u8"吹奏",
      u8"吹奏乐",
      u8"吹奏乐器",
      u8"吹奏者",
      u8"吹干",
      u8"吹开",
      u8"吹弹",
      u8"吹弹得破",
      u8"吹弹歌舞",
      u8"吹影镂尘",
      u8"吹得",
      u8"吹得天花乱坠",
      u8"吹成",
      u8"吹打",
      u8"吹拂",
      u8"吹拉弹唱",
      u8"吹拍",
      u8"吹捧",
      u8"吹掉",
      u8"吹揍",
      u8"吹擂",
      u8"吹散",
      u8"吹来",
      u8"吹来吹去",
      u8"吹棒",
      u8"吹毛利刃",
      u8"吹毛数睫",
      u8"吹毛求瑕",
      u8"吹毛求疵",
      u8"吹毛洗垢",
      u8"吹毛索垢",
      u8"吹毛索疵",
      u8"吹毛索瘢",
      u8"吹气",
      u8"吹气如兰",
      u8"吹气胜兰",
      u8"吹氧管",
      u8"吹水",
      u8"吹沙",
      u8"吹法",
      u8"吹法螺",
      u8"吹泡泡",
      u8"吹火",
      u8"吹灭",
      u8"吹灯",
      u8"吹灯拔蜡",
      u8"吹灰",
      u8"吹灰之力",
      u8"吹炼",
      u8"吹熄",
      u8"吹牛",
      u8"吹牛大王",
      u8"吹牛拍马",
      u8"吹牛皮",
      u8"吹瓶",
      u8"吹瓶机",
      u8"吹皱一池",
      u8"吹皱一池春水",
      u8"吹直",
      u8"吹眠曲",
      u8"吹着",
      u8"吹破",
      u8"吹竹弹丝",
      u8"吹笙",
      u8"吹笛",
      u8"吹管",
      u8"吹箫",
      u8"吹箫乞食",
      u8"吹箭",
      u8"吹篪乞食",
      u8"吹糠见米",
      u8"吹网欲满",
      u8"吹耳边风",
      u8"吹胡子瞪眼",
      u8"吹腔",
      u8"吹膜机",
      u8"吹花嚼蕊",
      u8"吹萧",
      u8"吹蚀",
      u8"吹袭",
      u8"吹角连营",
      u8"吹走",
      u8"吹起",
      u8"吹起来",
      u8"吹过",
      u8"吹过来",
      u8"吹进",
      u8"吹进去",
      u8"吹进来",
      u8"吹送",
      u8"吹遍",
      u8"吹雪",
      u8"吹风",
      u8"吹风会",
      u8"吹风机",
      u8"吹飞",
      u8"吹鼓",
      u8"吹鼓手",
      u8"吻上了",
      u8"吻下去",
      u8"吻你",
      u8"吻别",
      u8"吻别时",
      u8"吻合",
      u8"吻合器",
      u8"吻合效应",
      u8"吻合术",
      u8"吻吻",
      u8"吻抱",
      u8"吻痕",
      u8"吻遍",
      u8"吻颈",
      u8"吼出",
      u8"吼到",
      u8"吼叫",
      u8"吼叫声",
      u8"吼吼",
      u8"吼声",
      u8"吼着",
      u8"吼起来",
      u8"吼道",
      u8"吼鸣",
      u8"吾主",
      u8"吾人",
      u8"吾令",
      u8"吾侪",
      u8"吾兄",
      u8"吾国",
      u8"吾子",
      u8"吾家千里驹",
      u8"吾师",
      u8"吾日三省吾身",
      u8"吾民",
      u8"吾爱",
      u8"吾王",
      u8"吾等",
      u8"吾膝如铁",
      u8"吾自有处",
      u8"吾谁与归",
      u8"吾辈",
      u8"呀儿哟",
      u8"呀呀",
      u8"呀呀学语",
      u8"呂方",
      u8"呃逆",
      u8"呆了",
      u8"呆人",
      u8"呆似木鸡",
      u8"呆住",
      u8"呆傻",
      u8"呆到",
      u8"呆呆",
      u8"呆呆傻傻",
      u8"呆呆挣挣",
      u8"呆呆笨笨",
      u8"呆在",
      u8"呆坏账",
      u8"呆头",
      u8"呆头呆脑",
      u8"呆头鹅",
      u8"呆如木鸡",
      u8"呆子",
      u8"呆宝静",
      u8"呆小症",
      u8"呆帐",
      u8"呆帐损失",
      u8"呆想",
      u8"呆愣愣",
      u8"呆料",
      u8"呆板",
      u8"呆楞楞",
      u8"呆气",
      u8"呆滞",
      u8"呆滞无神",
      u8"呆着",
      u8"呆笑",
      u8"呆笨",
      u8"呆若",
      u8"呆若木鸡",
      u8"呆账",
      u8"呆里呆气",
      u8"呆里撒奸",
      u8"呈上",
      u8"呈上升",
      u8"呈上升趋势",
      u8"呈交",
      u8"呈几何",
      u8"呈圆形",
      u8"呈子",
      u8"呈报",
      u8"呈拱形",
      u8"呈文",
      u8"呈正",
      u8"呈献",
      u8"呈献给",
      u8"呈现",
      u8"呈现出",
      u8"呈示",
      u8"呈示部",
      u8"呈给",
      u8"呈缴本",
      u8"呈网状",
      u8"呈脉络状",
      u8"呈色反应",
      u8"呈览",
      u8"呈请",
      u8"呈贡",
      u8"呈贡县",
      u8"呈送",
      u8"呈递",
      u8"呈酸性",
      u8"呈阅",
      u8"呈露",
      u8"呈验",
      u8"告一段落",
      u8"告了",
      u8"告人",
      u8"告便",
      u8"告倒",
      u8"告借",
      u8"告假",
      u8"告假还乡",
      u8"告别",
      u8"告别仪式",
      u8"告别式",
      u8"告别赛",
      u8"告劳",
      u8"告发",
      u8"告吹",
      u8"告嘱",
      u8"告官",
      u8"告密",
      u8"告密者",
      u8"告往知来",
      u8"告急",
      u8"告慰",
      u8"告成",
      u8"告戒",
      u8"告扰",
      u8"告捷",
      u8"告朔",
      u8"告朔饩羊",
      u8"告枕头状",
      u8"告特",
      u8"告特叶",
      u8"告状",
      u8"告申庭",
      u8"告病",
      u8"告白",
      u8"告知",
      u8"告破",
      u8"告示",
      u8"告示板",
      u8"告示版",
      u8"告示牌",
      u8"告竣",
      u8"告终",
      u8"告绝",
      u8"告罄",
      u8"告罪",
      u8"告老",
      u8"告老在家",
      u8"告老还乡",
      u8"告老还家",
      u8"告警",
      u8"告警信号",
      u8"告诉",
      u8"告诉乃论",
      u8"告诉她",
      u8"告诉您",
      u8"告诉我",
      u8"告诫",
      u8"告语",
      u8"告谢",
      u8"告负",
      u8"告贷",
      u8"告贷无门",
      u8"告辞",
      u8"告退",
      u8"告送",
      u8"告饶",
      u8"呋喃",
      u8"呋喃半乳糖",
      u8"呋喃半乳糖苷",
      u8"呋喃半乳糖苷酶",
      u8"呋喃果糖苷",
      u8"呋喃果糖苷酶",
      u8"呋喃果聚糖",
      u8"呋喃树脂",
      u8"呋喃糖",
      u8"呋喃西林",
      u8"呋喃霉素",
      u8"呐喊",
      u8"呐喊助威",
      u8"呐喊助阵",
      u8"呒啥",
      u8"呓语",
      u8"呕出",
      u8"呕吐",
      u8"呕吐时",
      u8"呕吐物",
      u8"呕吐者",
      u8"呕哑",
      u8"呕心",
      u8"呕心抽肠",
      u8"呕心沥血",
      u8"呕心沥血之作",
      u8"呕心滴血",
      u8"呕心镂骨",
      u8"呕气",
      u8"呕血",
      u8"呕血时",
      u8"呖呖",
      u8"员司",
      u8"员外",
      u8"员外郎",
      u8"员大将",
      u8"员山",
      u8"员工",
      u8"员工工资",
      u8"员工福利",
      u8"员工素质",
      u8"员林",
      u8"员林市",
      u8"员警",
      u8"员额",
      u8"呛了",
      u8"呛人",
      u8"呛伤",
      u8"呛到",
      u8"呛咳",
      u8"呛喉",
      u8"呛得",
      u8"呛水",
      u8"呛熏",
      u8"呛着",
      u8"呛起来",
      u8"呛鼻",
      u8"呛鼻子",
      u8"呜乎哀哉",
      u8"呜儿呜儿",
      u8"呜呜",
      u8"呜呜咽咽",
      u8"呜呜声",
      u8"呜呼",
      u8"呜呼哀哉",
      u8"呜呼噫嘻",
      u8"呜咽",
      u8"呜唈",
      u8"呜啦",
      u8"呜枪",
      u8"呜禽",
      u8"呜钟",
      u8"呢个",
      u8"呢喃",
      u8"呢喃细语",
      u8"呢子",
      u8"呢子大衣",
      u8"呢帽",
      u8"呢料",
      u8"呢称",
      u8"呢绒",
      u8"呤呤",
      u8"呦呦",
      u8"周一",
      u8"周一围",
      u8"周三",
      u8"周专",
      u8"周丽淇",
      u8"周书",
      u8"周二",
      u8"周云阳",
      u8"周五",
      u8"周五输",
      u8"周人",
      u8"周代",
      u8"周仲英",
      u8"周会",
      u8"周传雄",
      u8"周伯华",
      u8"周伯通",
      u8"周作人",
      u8"周俊",
      u8"周俊伟",
      u8"周兆年",
      u8"周光召",
      u8"周全",
      u8"周公",
      u8"周公之礼",
      u8"周公子",
      u8"周公庙",
      u8"周六",
      u8"周六日",
      u8"周冰倩",
      u8"周刊",
      u8"周到",
      u8"周勃",
      u8"周匝",
      u8"周华健",
      u8"周占顺",
      u8"周口",
      u8"周口市",
      u8"周口店",
      u8"周启生",
      u8"周告",
      u8"周嘉玲",
      u8"周四",
      u8"周围",
      u8"周围世界",
      u8"周围环境",
      u8"周围神经",
      u8"周围神经系统",
      u8"周国平",
      u8"周圻",
      u8"周城镇",
      u8"周大奶奶",
      u8"周大福",
      u8"周天",
      u8"周妻何肉",
      u8"周威信",
      u8"周媛媛",
      u8"周子寒",
      u8"周子玉",
      u8"周孤桐",
      u8"周宁",
      u8"周宁县",
      u8"周宪",
      u8"周家",
      u8"周家玲",
      u8"周密",
      u8"周密安排",
      u8"周密计划",
      u8"周密调查",
      u8"周小川",
      u8"周小燕",
      u8"周岁",
      u8"周巍峙",
      u8"周年",
      u8"周年纪念",
      u8"周年纪念日",
      u8"周庄",
      u8"周庄镇",
      u8"周延",
      u8"周建安",
      u8"周建新",
      u8"周强",
      u8"周德东",
      u8"周志农",
      u8"周志华",
      u8"周志平",
      u8"周思源",
      u8"周急",
      u8"周总理",
      u8"周恤",
      u8"周恩来",
      u8"周情孔思",
      u8"周慧敏",
      u8"周成王",
      u8"周折",
      u8"周报",
      u8"周报制",
      u8"周敦颐",
      u8"周数",
      u8"周文",
      u8"周文健",
      u8"周文王",
      u8"周文重",
      u8"周旋",
      u8"周旋到底",
      u8"周日",
      u8"周易",
      u8"周星弛",
      u8"周星星",
      u8"周星驰",
      u8"周景扬",
      u8"周有光",
      u8"周朝",
      u8"周期",
      u8"周期共聚物",
      u8"周期函数",
      u8"周期律",
      u8"周期性",
      u8"周期性地",
      u8"周期性症状",
      u8"周期性蛋白",
      u8"周期时间",
      u8"周期短",
      u8"周期窃取",
      u8"周期素",
      u8"周期群",
      u8"周期表",
      u8"周期长",
      u8"周木杨",
      u8"周末",
      u8"周末好",
      u8"周末风",
      u8"周村区",
      u8"周来祥",
      u8"周杰",
      u8"周杰伦",
      u8"周树人",
      u8"周树基",
      u8"周梅森",
      u8"周樱",
      u8"周正",
      u8"周正毅",
      u8"周武王",
      u8"周比利",
      u8"周永康",
      u8"周永恒",
      u8"周永香",
      u8"周汝昌",
      u8"周汶锜",
      u8"周治平",
      u8"周波",
      u8"周洁",
      u8"周济",
      u8"周海媚",
      u8"周润发",
      u8"周渝民",
      u8"周游",
      u8"周游世界",
      u8"周游列国",
      u8"周牧",
      u8"周率",
      u8"周瑜",
      u8"周璇",
      u8"周璐",
      u8"周生生",
      u8"周生贤",
      u8"周界",
      u8"周目",
      u8"周相",
      u8"周睿羊",
      u8"周知",
      u8"周礼",
      u8"周穷恤匮",
      u8"周章",
      u8"周绮",
      u8"周缘",
      u8"周罗",
      u8"周而不比",
      u8"周而复始",
      u8"周至",
      u8"周至县",
      u8"周艳泓",
      u8"周芷若",
      u8"周英杰",
      u8"周荣",
      u8"周莉",
      u8"周蕙",
      u8"周薪",
      u8"周被",
      u8"周规折矩",
      u8"周角",
      u8"周详",
      u8"周质体",
      u8"周贫济老",
      u8"周身",
      u8"周转",
      u8"周转不灵",
      u8"周转基金",
      u8"周转天",
      u8"周转性基金",
      u8"周转期",
      u8"周转率",
      u8"周转箱",
      u8"周转粮",
      u8"周转资金",
      u8"周转量",
      u8"周转金",
      u8"周边",
      u8"周边产品",
      u8"周边国家",
      u8"周边地区",
      u8"周边城市",
      u8"周边店",
      u8"周边式",
      u8"周边旅游",
      u8"周边游",
      u8"周边环境",
      u8"周边视觉",
      u8"周边设备",
      u8"周迅",
      u8"周逸平",
      u8"周遍",
      u8"周道",
      u8"周遭",
      u8"周遭事物",
      u8"周邦彥",
      u8"周邦彦",
      u8"周郎",
      u8"周郎顾曲",
      u8"周里京",
      u8"周铁农",
      u8"周铁鹤",
      u8"周长",
      u8"周长福",
      u8"周阿三",
      u8"周隆",
      u8"周颠",
      u8"呱呱",
      u8"呱呱叫",
      u8"呱呱坠地",
      u8"呱呱堕地",
      u8"呱唧",
      u8"呱嗒",
      u8"呱嗒板",
      u8"呱嗒板儿",
      u8"呲牙",
      u8"味之素",
      u8"味儿",
      u8"味全",
      u8"味十足",
      u8"味同嚼蜡",
      u8"味如嚼蜡",
      u8"味如鸡肋",
      u8"味尘",
      u8"味精",
      u8"味精厂",
      u8"味素",
      u8"味素包",
      u8"味苦",
      u8"味蕾",
      u8"味觉",
      u8"味觉区",
      u8"味觉器",
      u8"味觉四面体",
      u8"味觉性出汗综合征",
      u8"味觉敏度",
      u8"味觉混合",
      u8"味觉绝对阈限",
      u8"味道",
      u8"味道不好",
      u8"味道鲜美",
      u8"呴湿濡沫",
      u8"呵令",
      u8"呵佛骂祖",
      u8"呵冻",
      u8"呵叱",
      u8"呵呵",
      u8"呵呵哈",
      u8"呵呵大笑",
      u8"呵喝",
      u8"呵壁问天",
      u8"呵护",
      u8"呵斥",
      u8"呵欠",
      u8"呵欠连天",
      u8"呵气",
      u8"呵痒",
      u8"呵责",
      u8"呶呶",
      u8"呶呶不休",
      u8"呶嘴",
      u8"呷呷",
      u8"呷醋节帅",
      u8"呻吟",
      u8"呻吟声",
      u8"呻喻",
      u8"呼不给吸",
      u8"呼么喝六",
      u8"呼之",
      u8"呼之不来",
      u8"呼之即来",
      u8"呼之即来挥之即去",
      u8"呼之欲出",
      u8"呼之欲跃",
      u8"呼伦贝尔",
      u8"呼伦贝尔市",
      u8"呼伦贝尔盟",
      u8"呼入",
      u8"呼兰",
      u8"呼兰县",
      u8"呼兰河流",
      u8"呼兰河流域",
      u8"呼出",
      u8"呼出来",
      u8"呼卢喝雉",
      u8"呼口号",
      u8"呼叫",
      u8"呼叫器",
      u8"呼叫指令",
      u8"呼叫者",
      u8"呼叫转移",
      u8"呼叫进行信号",
      u8"呼号",
      u8"呼吁",
      u8"呼吁书",
      u8"呼吸",
      u8"呼吸与共",
      u8"呼吸之间",
      u8"呼吸作用",
      u8"呼吸器",
      u8"呼吸器官",
      u8"呼吸困难",
      u8"呼吸声",
      u8"呼吸机",
      u8"呼吸活化肽",
      u8"呼吸相通",
      u8"呼吸系数",
      u8"呼吸系统",
      u8"呼吸衰竭",
      u8"呼吸计",
      u8"呼吸调整中枢",
      u8"呼吸跃变",
      u8"呼吸道",
      u8"呼吸阀",
      u8"呼呼",
      u8"呼呼大睡",
      u8"呼和浩特",
      u8"呼和浩特市",
      u8"呼和浩特铁路局",
      u8"呼哧",
      u8"呼哧呼哧",
      u8"呼哨",
      u8"呼唤",
      u8"呼啦",
      u8"呼啦啦",
      u8"呼啦圈",
      u8"呼啸",
      u8"呼啸声",
      u8"呼啸山庄",
      u8"呼啸而过",
      u8"呼喊",
      u8"呼喊声",
      u8"呼喝",
      u8"呼嗒",
      u8"呼噜",
      u8"呼噜声",
      u8"呼噪",
      u8"呼图克图",
      u8"呼图壁",
      u8"呼图壁县",
      u8"呼声",
      u8"呼声最高",
      u8"呼声甚高",
      u8"呼天叩地",
      u8"呼天叫地",
      u8"呼天号地",
      u8"呼天吁地",
      u8"呼天唤地",
      u8"呼天抢地",
      u8"呼天钥地",
      u8"呼家楼",
      u8"呼局",
      u8"呼巴音",
      u8"呼市",
      u8"呼幺喝六",
      u8"呼应",
      u8"呼应声",
      u8"呼庚呼癸",
      u8"呼延",
      u8"呼延万善",
      u8"呼扇",
      u8"呼拉圈",
      u8"呼救",
      u8"呼救信号",
      u8"呼救声",
      u8"呼朋唤友",
      u8"呼朋引类",
      u8"呼机",
      u8"呼来唤去",
      u8"呼来喝去",
      u8"呼来挥去",
      u8"呼死你",
      u8"呼气",
      u8"呼牛作马",
      u8"呼牛呼马",
      u8"呼玄喝六",
      u8"呼玛",
      u8"呼玛县",
      u8"呼盟",
      u8"呼群结党",
      u8"呼肠",
      u8"呼衰",
      u8"呼语",
      u8"呼起",
      u8"呼起来",
      u8"呼转",
      u8"呼音克",
      u8"呼风唤雨",
      u8"呼风换雨",
      u8"呼饥号寒",
      u8"命不由人",
      u8"命不由己",
      u8"命不该绝",
      u8"命世之才",
      u8"命丧",
      u8"命丧九泉",
      u8"命中",
      u8"命中注定",
      u8"命中率",
      u8"命为",
      u8"命乖运蹇",
      u8"命令",
      u8"命令与征服",
      u8"命令主义",
      u8"命令句",
      u8"命令名",
      u8"命令字",
      u8"命令控制块",
      u8"命令控制系统",
      u8"命令提示符",
      u8"命令状",
      u8"命令缓冲区",
      u8"命令行",
      u8"命令语气",
      u8"命令集",
      u8"命作",
      u8"命俦啸侣",
      u8"命名",
      u8"命名为",
      u8"命名大会",
      u8"命名性失语症",
      u8"命在",
      u8"命在旦夕",
      u8"命大",
      u8"命官",
      u8"命定",
      u8"命宫",
      u8"命意",
      u8"命数",
      u8"命根",
      u8"命根子",
      u8"命案",
      u8"命比纸薄",
      u8"命理网",
      u8"命相",
      u8"命相学",
      u8"命相家",
      u8"命相馆",
      u8"命笔",
      u8"命脉",
      u8"命若悬丝",
      u8"命苦",
      u8"命薄",
      u8"命薄相穷",
      u8"命薄缘悭",
      u8"命词遣意",
      u8"命该",
      u8"命该如此",
      u8"命赴黄泉",
      u8"命蹇时乖",
      u8"命辞遣意",
      u8"命运",
      u8"命运中",
      u8"命运之神",
      u8"命运多舛",
      u8"命运攸关",
      u8"命途",
      u8"命途多舛",
      u8"命里无时莫强求",
      u8"命里注定",
      u8"命门",
      u8"命题",
      u8"命题作文",
      u8"命题演算",
      u8"命题表征",
      u8"命题逻辑",
      u8"命馆",
      u8"咀咒",
      u8"咀嚼",
      u8"咀嚼出",
      u8"咀嚼型",
      u8"咀嚼循环",
      u8"咀嚼效能",
      u8"咀嚼片",
      u8"咀嚼生理学",
      u8"咀嚼粘膜",
      u8"咀嚼系统",
      u8"咀嚼英华",
      u8"咀嚼运动",
      u8"咀巧",
      u8"咂嘴",
      u8"咂嘴咂舌",
      u8"咂嘴弄唇",
      u8"咂嘴弄舌",
      u8"咂嘴舔唇",
      u8"咂摸",
      u8"咄咄",
      u8"咄咄书空",
      u8"咄咄怪事",
      u8"咄咄逼人",
      u8"咄嗟",
      u8"咄嗟之间",
      u8"咄嗟便办",
      u8"咄嗟叱咤",
      u8"咄嗟立办",
      u8"咆哮",
      u8"咆哮地",
      u8"咆哮声",
      u8"咆哮如雷",
      u8"咆哮山庄",
      u8"咆哮起来",
      u8"咆啸",
      u8"咋个",
      u8"咋办",
      u8"咋呼",
      u8"咋咋呼呼",
      u8"咋啦",
      u8"咋回事",
      u8"咋搞",
      u8"咋样",
      u8"咋玩",
      u8"咋舌",
      u8"和不同尘",
      u8"和丰",
      u8"和为贵",
      u8"和久井映见",
      u8"和乐",
      u8"和乐且孺",
      u8"和书",
      u8"和买",
      u8"和了",
      u8"和事佬",
      u8"和事老",
      u8"和亲",
      u8"和亲政策",
      u8"和他",
      u8"和会",
      u8"和你",
      u8"和你在一起",
      u8"和光同尘",
      u8"和刻本",
      u8"和剂局方",
      u8"和加",
      u8"和协",
      u8"和协调",
      u8"和南",
      u8"和县",
      u8"和合",
      u8"和合学",
      u8"和合雅俗",
      u8"和和",
      u8"和和气气",
      u8"和善",
      u8"和在",
      u8"和坤",
      u8"和声",
      u8"和头",
      u8"和她",
      u8"和好",
      u8"和好友",
      u8"和好如初",
      u8"和好相处",
      u8"和如琴瑟",
      u8"和婉",
      u8"和它",
      u8"和家人",
      u8"和容悦色",
      u8"和尔大",
      u8"和尚",
      u8"和尚头",
      u8"和局",
      u8"和岳父",
      u8"和州",
      u8"和布克赛尔古自治县",
      u8"和布克赛尔蒙古自治县",
      u8"和帝",
      u8"和平",
      u8"和平东路",
      u8"和平为处",
      u8"和平为处世之本",
      u8"和平主义",
      u8"和平乡",
      u8"和平共处",
      u8"和平共处五项原则",
      u8"和平共存",
      u8"和平利用",
      u8"和平力量",
      u8"和平区",
      u8"和平医院",
      u8"和平县",
      u8"和平友好",
      u8"和平口号",
      u8"和平号",
      u8"和平号空间站",
      u8"和平国中",
      u8"和平国小",
      u8"和平地",
      u8"和平外交政策",
      u8"和平奖",
      u8"和平岛",
      u8"和平建议",
      u8"和平攻势",
      u8"和平新党",
      u8"和平时期",
      u8"和平棋",
      u8"和平溪",
      u8"和平演变",
      u8"和平相处",
      u8"和平统一",
      u8"和平统一祖国",
      u8"和平街",
      u8"和平西路",
      u8"和平解决",
      u8"和平谈判",
      u8"和平路",
      u8"和平过渡",
      u8"和平部队",
      u8"和平里",
      u8"和平门",
      u8"和平队",
      u8"和平鸽",
      u8"和弄",
      u8"和式",
      u8"和弦",
      u8"和弦铃声",
      u8"和弦铃音",
      u8"和弦音",
      u8"和悦",
      u8"和您",
      u8"和成熟",
      u8"和我",
      u8"和政",
      u8"和政县",
      u8"和政策",
      u8"和数",
      u8"和文",
      u8"和斗",
      u8"和易",
      u8"和易近人",
      u8"和春",
      u8"和暖",
      u8"和曲",
      u8"和服",
      u8"和服务",
      u8"和村",
      u8"和林格尔",
      u8"和林格尔县",
      u8"和校验",
      u8"和棋",
      u8"和氏璧",
      u8"和气",
      u8"和气生财",
      u8"和气致祥",
      u8"和气请问",
      u8"和波束",
      u8"和泥",
      u8"和洽",
      u8"和浦珠还",
      u8"和煦",
      u8"和熙",
      u8"和牌",
      u8"和玺彩画",
      u8"和珅",
      u8"和璧隋珠",
      u8"和田",
      u8"和田县",
      u8"和田地区",
      u8"和田市",
      u8"和田玉",
      u8"和畅",
      u8"和盘",
      u8"和盘托出",
      u8"和着",
      u8"和睦",
      u8"和睦家",
      u8"和睦相处",
      u8"和硕",
      u8"和硕县",
      u8"和祥",
      u8"和稀泥",
      u8"和穆",
      u8"和空姐",
      u8"和絃",
      u8"和约",
      u8"和纵连横",
      u8"和缓",
      u8"和缓地",
      u8"和美",
      u8"和而不同",
      u8"和而不唱",
      u8"和胃健脾",
      u8"和英字典",
      u8"和英词典",
      u8"和蔼",
      u8"和蔼可亲",
      u8"和蔼近人",
      u8"和衣",
      u8"和衣而卧",
      u8"和衣而睡",
      u8"和衷",
      u8"和衷共济",
      u8"和裁会",
      u8"和角",
      u8"和解",
      u8"和解书",
      u8"和解少阳",
      u8"和解提议",
      u8"和议",
      u8"和讯",
      u8"和讯网",
      u8"和诗",
      u8"和谁",
      u8"和谈",
      u8"和谐",
      u8"和谐一致",
      u8"和谐无间",
      u8"和谐社会",
      u8"和谐社区",
      u8"和路雪",
      u8"和那",
      u8"和里布",
      u8"和金",
      u8"和隋之珍",
      u8"和静",
      u8"和静县",
      u8"和面",
      u8"和面机",
      u8"和顺",
      u8"和顺县",
      u8"和颜悦色",
      u8"和颜说色",
      u8"和风",
      u8"和风丽日",
      u8"和风徐徐",
      u8"和风拂面",
      u8"和风细雨",
      u8"和鸣",
      u8"和龙",
      u8"和龙县",
      u8"和龙市",
      u8"咎有应得",
      u8"咎由应得",
      u8"咎由自取",
      u8"咏史",
      u8"咏叹",
      u8"咏叹调",
      u8"咏唱",
      u8"咏嘲风月",
      u8"咏志",
      u8"咏怀",
      u8"咏春",
      u8"咏春拳",
      u8"咏月嘲风",
      u8"咏柳",
      u8"咏桑寓柳",
      u8"咏梅",
      u8"咏歌",
      u8"咏物",
      u8"咏物诗",
      u8"咏经",
      u8"咏诗",
      u8"咏赞",
      u8"咏雪",
      u8"咏雪之慧",
      u8"咒天骂地",
      u8"咒心",
      u8"咒怨",
      u8"咒文",
      u8"咒符",
      u8"咒诅",
      u8"咒词",
      u8"咒语",
      u8"咒骂",
      u8"咔叽",
      u8"咔唑",
      u8"咔啉",
      u8"咔喳",
      u8"咔嗒",
      u8"咔嚓",
      u8"咕叨",
      u8"咕咕",
      u8"咕咚",
      u8"咕咚一声",
      u8"咕咚咕咚",
      u8"咕咾肉",
      u8"咕哝",
      u8"咕哩美",
      u8"咕唧",
      u8"咕啉",
      u8"咕喨",
      u8"咕嘟",
      u8"咕嘟嘟",
      u8"咕噜",
      u8"咕噜一声",
      u8"咕噜咕噜",
      u8"咕噜噜",
      u8"咕隆",
      u8"咖哩",
      u8"咖哩汁",
      u8"咖哩粉",
      u8"咖哩饭",
      u8"咖哩鸡",
      u8"咖啡",
      u8"咖啡具",
      u8"咖啡厅",
      u8"咖啡吧",
      u8"咖啡因",
      u8"咖啡园",
      u8"咖啡壶",
      u8"咖啡室",
      u8"咖啡屋",
      u8"咖啡师",
      u8"咖啡店",
      u8"咖啡机",
      u8"咖啡杯",
      u8"咖啡果小蠹",
      u8"咖啡猫",
      u8"咖啡碱",
      u8"咖啡色",
      u8"咖啡节",
      u8"咖啡节哀世界经济",
      u8"咖啡茶",
      u8"咖啡虎天牛",
      u8"咖啡豆",
      u8"咖啡豆象",
      u8"咖啡馆",
      u8"咖喱",
      u8"咖喱粉",
      u8"咖喱饭",
      u8"咖喱鸡",
      u8"咚咚",
      u8"咚咚声",
      u8"咝儿",
      u8"咝咝",
      u8"咣当",
      u8"咧咧",
      u8"咧嘴",
      u8"咧嘴一笑",
      u8"咧嘴大笑",
      u8"咧开",
      u8"咧开嘴笑",
      u8"咧着",
      u8"咨师访友",
      u8"咨文",
      u8"咨议",
      u8"咨讯网",
      u8"咨询",
      u8"咨询业",
      u8"咨询中心",
      u8"咨询会",
      u8"咨询台",
      u8"咨询员",
      u8"咨询团",
      u8"咨询委员会",
      u8"咨询师",
      u8"咨询摊",
      u8"咨询服务",
      u8"咨询服务系统",
      u8"咨询机构",
      u8"咨询点",
      u8"咨询电话",
      u8"咨询者",
      u8"咩咩",
      u8"咩咩叫",
      u8"咪咪",
      u8"咪咪叫",
      u8"咪唑",
      u8"咪表",
      u8"咫尺",
      u8"咫尺万里",
      u8"咫尺之书",
      u8"咫尺之功",
      u8"咫尺千里",
      u8"咫尺天涯",
      u8"咫尺天颜",
      u8"咫尺威颜",
      u8"咬一口",
      u8"咬上",
      u8"咬下",
      u8"咬了",
      u8"咬了一口",
      u8"咬人",
      u8"咬人狗儿不露齿",
      u8"咬伤",
      u8"咬住",
      u8"咬住不放",
      u8"咬入",
      u8"咬到",
      u8"咬去",
      u8"咬合",
      u8"咬合纸",
      u8"咬咬",
      u8"咬咬牙",
      u8"咬唇症",
      u8"咬啮",
      u8"咬嘴",
      u8"咬噬",
      u8"咬嚼",
      u8"咬好",
      u8"咬姜呷醋",
      u8"咬字",
      u8"咬字儿",
      u8"咬字清晰",
      u8"咬字清楚",
      u8"咬字眼",
      u8"咬字眼儿",
      u8"咬定",
      u8"咬定牙关",
      u8"咬定牙根",
      u8"咬得",
      u8"咬得菜根",
      u8"咬我",
      u8"咬掉",
      u8"咬文啮字",
      u8"咬文嚼字",
      u8"咬文齧字",
      u8"咬断",
      u8"咬点",
      u8"咬烂",
      u8"咬牙",
      u8"咬牙切齿",
      u8"咬牙恨齿",
      u8"咬牙根",
      u8"咬牙齿",
      u8"咬着",
      u8"咬着不放",
      u8"咬着唇",
      u8"咬着牙",
      u8"咬破",
      u8"咬碎",
      u8"咬磨",
      u8"咬紧",
      u8"咬紧牙",
      u8"咬紧牙关",
      u8"咬紧牙根",
      u8"咬群",
      u8"咬耳朵",
      u8"咬舌",
      u8"咬舌儿",
      u8"咬菜根",
      u8"咬血为盟",
      u8"咬起",
      u8"咬起来",
      u8"咬过",
      u8"咬钉",
      u8"咬钉嚼铁",
      u8"咬音咂字",
      u8"咬颊症",
      u8"咭吱咯吱",
      u8"咯吱",
      u8"咯吱吱",
      u8"咯吱咯吱",
      u8"咯咯",
      u8"咯咯叫",
      u8"咯咯吱吱",
      u8"咯咯声",
      u8"咯咯笑",
      u8"咯噔",
      u8"咯既然",
      u8"咯痰",
      u8"咯血",
      u8"咱们",
      u8"咱俩",
      u8"咱娃",
      u8"咱家",
      u8"咱就",
      u8"咱得",
      u8"咱村",
      u8"咱校",
      u8"咱爷",
      u8"咱班",
      u8"咱这",
      u8"咱队",
      u8"咳唾凝珠",
      u8"咳唾成珠",
      u8"咳喘",
      u8"咳嗽",
      u8"咳嗽声",
      u8"咳嗽病",
      u8"咳嗽药",
      u8"咳声",
      u8"咳声叹气",
      u8"咳得",
      u8"咳珠唾玉",
      u8"咳痰",
      u8"咳血",
      u8"咸与惟新",
      u8"咸与维新",
      u8"咸丰",
      u8"咸丰县",
      u8"咸丰帝",
      u8"咸乎乎",
      u8"咸五登三",
      u8"咸亨",
      u8"咸信",
      u8"咸兴",
      u8"咸兴市",
      u8"咸卤",
      u8"咸吃萝卜淡操心",
      u8"咸味",
      u8"咸嘴淡舌",
      u8"咸嘴谈舌",
      u8"咸土",
      u8"咸宁",
      u8"咸宁公安局",
      u8"咸宁市",
      u8"咸安区",
      u8"咸宜",
      u8"咸度",
      u8"咸得",
      u8"咸性",
      u8"咸水",
      u8"咸水湖",
      u8"咸水鱼",
      u8"咸汤",
      u8"咸津津",
      u8"咸海",
      u8"咸淡",
      u8"咸淡适中",
      u8"咸湖",
      u8"咸湿",
      u8"咸猪肉",
      u8"咸盐",
      u8"咸类",
      u8"咸肉",
      u8"咸菜",
      u8"咸菜乾",
      u8"咸蛋",
      u8"咸认为",
      u8"咸豊",
      u8"咸镜南道",
      u8"咸阳",
      u8"咸阳一炬",
      u8"咸阳市",
      u8"咸风蛋雨",
      u8"咸鱼",
      u8"咸鱼翻身",
      u8"咸鸭蛋",
      u8"咽下",
      u8"咽下去",
      u8"咽不下",
      u8"咽不下这口气",
      u8"咽了",
      u8"咽住",
      u8"咽后壁瓣",
      u8"咽哽",
      u8"咽喉",
      u8"咽喉炎",
      u8"咽喉部",
      u8"咽头",
      u8"咽头炎",
      u8"咽峡炎",
      u8"咽旁间隙",
      u8"咽气",
      u8"咽炎",
      u8"咽苦吐甘",
      u8"咽苦吞甘",
      u8"咽镜",
      u8"咽鼓管",
      u8"咿呀",
      u8"咿咿呀呀",
      u8"咿咿唔唔",
      u8"咿哑",
      u8"咿哑学语",
      u8"咿唷",
      u8"哀丝豪竹",
      u8"哀乐",
      u8"哀伤",
      u8"哀兵必胜",
      u8"哀叫",
      u8"哀史",
      u8"哀号",
      u8"哀号不已",
      u8"哀叹",
      u8"哀吊",
      u8"哀启",
      u8"哀告",
      u8"哀告宾服",
      u8"哀呼",
      u8"哀咽",
      u8"哀哀",
      u8"哀哀切切",
      u8"哀哀欲绝",
      u8"哀哀父母",
      u8"哀哉",
      u8"哀哭",
      u8"哀唤",
      u8"哀啼",
      u8"哀嚎",
      u8"哀声叹气",
      u8"哀天叫地",
      u8"哀婉",
      u8"哀子",
      u8"哀家",
      u8"哀帝",
      u8"哀怒",
      u8"哀怜",
      u8"哀思",
      u8"哀思如潮",
      u8"哀怨",
      u8"哀恳",
      u8"哀恸",
      u8"哀恸不已",
      u8"哀悯",
      u8"哀悼",
      u8"哀悼之意",
      u8"哀悼者",
      u8"哀惜",
      u8"哀愁",
      u8"哀愍",
      u8"哀意",
      u8"哀感",
      u8"哀感中年",
      u8"哀感天地",
      u8"哀感顽艳",
      u8"哀戚",
      u8"哀梨蒸食",
      u8"哀歌",
      u8"哀毁瘠立",
      u8"哀毁骨立",
      u8"哀求",
      u8"哀求不已",
      u8"哀求地",
      u8"哀泣",
      u8"哀痛",
      u8"哀痛不已",
      u8"哀痛欲绝",
      u8"哀矜",
      u8"哀祭",
      u8"哀穷悼屈",
      u8"哀而不伤",
      u8"哀肠寸断",
      u8"哀艳",
      u8"哀苦",
      u8"哀荣",
      u8"哀莫大于心死",
      u8"哀诉",
      u8"哀辞",
      u8"哀鸣",
      u8"哀鸣不已",
      u8"哀鸿",
      u8"哀鸿遍地",
      u8"哀鸿遍野",
      u8"品位",
      u8"品冠",
      u8"品出",
      u8"品名",
      u8"品味",
      u8"品嚐",
      u8"品头论足",
      u8"品头评足",
      u8"品头题足",
      u8"品学",
      u8"品学兼优",
      u8"品尝",
      u8"品尼高",
      u8"品德",
      u8"品德好",
      u8"品德心理结构",
      u8"品德教育",
      u8"品德课",
      u8"品德高尚",
      u8"品性",
      u8"品性不好",
      u8"品性好",
      u8"品数",
      u8"品族",
      u8"品月",
      u8"品格",
      u8"品格高尚",
      u8"品检",
      u8"品流",
      u8"品牌",
      u8"品牌价值",
      u8"品牌优势",
      u8"品牌女装",
      u8"品牌形象",
      u8"品牌意识",
      u8"品牌战略",
      u8"品牌手机",
      u8"品牌效应",
      u8"品牌服装",
      u8"品牌服饰",
      u8"品牌机",
      u8"品牌童装",
      u8"品牌策略",
      u8"品牌网",
      u8"品牌设计",
      u8"品牌鞋",
      u8"品玉",
      u8"品目",
      u8"品相",
      u8"品种",
      u8"品种区域化",
      u8"品种改良",
      u8"品种登记",
      u8"品种繁多",
      u8"品种纯度",
      u8"品种鉴定",
      u8"品种间杂交",
      u8"品种间杂种",
      u8"品种齐全",
      u8"品竹弹丝",
      u8"品竹调丝",
      u8"品竹调弦",
      u8"品第",
      u8"品管",
      u8"品管圈",
      u8"品管部",
      u8"品箫",
      u8"品类",
      u8"品类繁多",
      u8"品系",
      u8"品红",
      u8"品红色",
      u8"品级",
      u8"品绩",
      u8"品绿",
      u8"品而第之",
      u8"品脱",
      u8"品色堂",
      u8"品节",
      u8"品花宝鉴",
      u8"品茗",
      u8"品茶",
      u8"品蓝",
      u8"品行",
      u8"品行不端",
      u8"品行不良",
      u8"品行优良",
      u8"品行好",
      u8"品行端正",
      u8"品议",
      u8"品论",
      u8"品评",
      u8"品读",
      u8"品貌",
      u8"品貌出众",
      u8"品貌双全",
      u8"品貌非凡",
      u8"品质",
      u8"品质因数",
      u8"品质恶劣",
      u8"品质管制",
      u8"品质育种",
      u8"品质超群",
      u8"品质音乐",
      u8"品过",
      u8"品酒",
      u8"品鉴",
      u8"品题",
      u8"哂然",
      u8"哂笑",
      u8"哂纳",
      u8"哄乱",
      u8"哄了",
      u8"哄人",
      u8"哄传",
      u8"哄到",
      u8"哄劝",
      u8"哄动",
      u8"哄动一时",
      u8"哄哄",
      u8"哄堂",
      u8"哄堂大笑",
      u8"哄弄",
      u8"哄得",
      u8"哄抢",
      u8"哄抬",
      u8"哄抬物价",
      u8"哄来哄去",
      u8"哄然",
      u8"哄然大笑",
      u8"哄笑",
      u8"哄话",
      u8"哄诱",
      u8"哄走",
      u8"哄起来",
      u8"哄过",
      u8"哄过去",
      u8"哄过来",
      u8"哄逗",
      u8"哄闹",
      u8"哄骗",
      u8"哆哆嗦嗦",
      u8"哆啰哆嗦",
      u8"哆嗦",
      u8"哆罗罗",
      u8"哆里哆嗦",
      u8"哇呀",
      u8"哇呀呀",
      u8"哇咔咔",
      u8"哇哇",
      u8"哇哇叫",
      u8"哇哇地",
      u8"哇哇声",
      u8"哇哇大叫",
      u8"哇哇大哭",
      u8"哇啦",
      u8"哇啦哇啦",
      u8"哇嘎画",
      u8"哇噻",
      u8"哇塞",
      u8"哇巴因",
      u8"哇靠",
      u8"哈代",
      u8"哈伟",
      u8"哈伯德",
      u8"哈佛",
      u8"哈佛大学",
      u8"哈克",
      u8"哈克曼",
      u8"哈军工",
      u8"哈利",
      u8"哈利勒",
      u8"哈利法",
      u8"哈利波特与火焰杯",
      u8"哈勃",
      u8"哈医大",
      u8"哈博罗内",
      u8"哈叭狗",
      u8"哈合台",
      u8"哈吉",
      u8"哈吧狗",
      u8"哈哈",
      u8"哈哈和",
      u8"哈哈哈",
      u8"哈哈哈哈",
      u8"哈哈地笑",
      u8"哈哈大笑",
      u8"哈哈笑",
      u8"哈哈网",
      u8"哈哈镜",
      u8"哈啰",
      u8"哈喇",
      u8"哈喇子",
      u8"哈坎苏克",
      u8"哈基姆",
      u8"哈基宁",
      u8"哈塞尔",
      u8"哈士奇",
      u8"哈大霸",
      u8"哈奈特",
      u8"哈好颇多",
      u8"哈姆雷特",
      u8"哈姆雷特式",
      u8"哈密",
      u8"哈密地区",
      u8"哈密尔顿",
      u8"哈密市",
      u8"哈密瓜",
      u8"哈密网",
      u8"哈密路",
      u8"哈密顿",
      u8"哈密顿函数",
      u8"哈密顿原理",
      u8"哈密顿回路",
      u8"哈密顿回路问题",
      u8"哈密顿圈",
      u8"哈密顿算符",
      u8"哈密顿量",
      u8"哈尔滨",
      u8"哈尔滨市",
      u8"哈尔滨港",
      u8"哈尔滨铁路局",
      u8"哈尼",
      u8"哈尼人",
      u8"哈尼族",
      u8"哈局",
      u8"哈工大",
      u8"哈巴河",
      u8"哈巴河县",
      u8"哈巴烈那",
      u8"哈巴狗",
      u8"哈市",
      u8"哈师大",
      u8"哈希",
      u8"哈德斯",
      u8"哈德森",
      u8"哈德门",
      u8"哈总管",
      u8"哈扎拉",
      u8"哈拉海湾村",
      u8"哈拉雷",
      u8"哈斯勒",
      u8"哈斯效应",
      u8"哈斯高娃",
      u8"哈日",
      u8"哈日族",
      u8"哈林顿",
      u8"哈柏",
      u8"哈根达斯",
      u8"哈桑",
      u8"哈桑区",
      u8"哈桑萨斯",
      u8"哈欠",
      u8"哈比人",
      u8"哈氏网",
      u8"哈气",
      u8"哈洽会",
      u8"哈灵顿",
      u8"哈特",
      u8"哈特曼",
      u8"哈狗帮",
      u8"哈瑙咬合关系组合图",
      u8"哈瓦那",
      u8"哈立德",
      u8"哈站",
      u8"哈米德",
      u8"哈米特酸度函数",
      u8"哈纳斯",
      u8"哈维",
      u8"哈维尔",
      u8"哈罗",
      u8"哈罗德",
      u8"哈耶克",
      u8"哈腰",
      u8"哈苏",
      u8"哈萨克",
      u8"哈萨克人",
      u8"哈萨克斯坦",
      u8"哈萨克斯坦共和国",
      u8"哈萨克族",
      u8"哈蒙德假说",
      u8"哈蜜瓜",
      u8"哈蟆",
      u8"哈蟆镜",
      u8"哈贝马斯",
      u8"哈赤大师",
      u8"哈达",
      u8"哈达威",
      u8"哈迪伦",
      u8"哈迪斯",
      u8"哈里发",
      u8"哈里森",
      u8"哈里波特",
      u8"哈金斯公式",
      u8"哈钦森牙",
      u8"哈雷",
      u8"哈雷彗星",
      u8"哈韩",
      u8"哈韩族",
      u8"哈马斯",
      u8"哈龙",
      u8"哌啶",
      u8"哌嗪",
      u8"哌嗪二酮",
      u8"响了",
      u8"响亮",
      u8"响动",
      u8"响叮当",
      u8"响和景从",
      u8"响器",
      u8"响地",
      u8"响声",
      u8"响头",
      u8"响尾蛇",
      u8"响应",
      u8"响应值",
      u8"响应函数",
      u8"响应分析",
      u8"响应号召",
      u8"响应窗口",
      u8"响应速度",
      u8"响度",
      u8"响当当",
      u8"响彻",
      u8"响彻云表",
      u8"响彻云际",
      u8"响彻云霄",
      u8"响成",
      u8"响指",
      u8"响晴",
      u8"响杨",
      u8"响板",
      u8"响水",
      u8"响水县",
      u8"响炮",
      u8"响着",
      u8"响答影随",
      u8"响箭",
      u8"响起",
      u8"响起来",
      u8"响过",
      u8"响遍",
      u8"响遏云行",
      u8"响遏行云",
      u8"响铃",
      u8"响铃钟",
      u8"响铛铛",
      u8"响雷",
      u8"响鞭",
      u8"响音",
      u8"响马",
      u8"响马党羽",
      u8"响鼻",
      u8"哎呀",
      u8"哎哟",
      u8"哎唷",
      u8"哐啷",
      u8"哐当",
      u8"哑剧",
      u8"哑口",
      u8"哑口无声",
      u8"哑口无言",
      u8"哑吧",
      u8"哑哑",
      u8"哑嗓",
      u8"哑场",
      u8"哑婆婆",
      u8"哑子",
      u8"哑子做梦",
      u8"哑子吃黄连",
      u8"哑子寻梦",
      u8"哑子得梦",
      u8"哑子托梦",
      u8"哑巴",
      u8"哑巴亏",
      u8"哑巴吃",
      u8"哑巴吃饺子",
      u8"哑巴吃黄",
      u8"哑巴吃黄莲",
      u8"哑巴吃黄连",
      u8"哑巴吃黄连，有苦说不出",
      u8"哑弹",
      u8"哑梢公",
      u8"哑火",
      u8"哑炮",
      u8"哑然",
      u8"哑然失笑",
      u8"哑言失笑",
      u8"哑语",
      u8"哑调",
      u8"哑谜",
      u8"哑迷",
      u8"哑铃",
      u8"哑门",
      u8"哑音",
      u8"哑默悄声",
      u8"哒哒",
      u8"哓哓",
      u8"哓哓不休",
      u8"哓音瘏口",
      u8"哔叽",
      u8"哔哔声",
      u8"哔哩啪啦",
      u8"哗世动俗",
      u8"哗世取名",
      u8"哗世取宠",
      u8"哗众",
      u8"哗众取宠",
      u8"哗变",
      u8"哗哗",
      u8"哗哗哗",
      u8"哗哗啦",
      u8"哗哗啦啦",
      u8"哗啦",
      u8"哗啦一声",
      u8"哗啦哗啦",
      u8"哗啦啦",
      u8"哗啦声",
      u8"哗喇",
      u8"哗喇喇",
      u8"哗然",
      u8"哗笑",
      u8"哜哜嘈嘈",
      u8"哝哝",
      u8"哞哞",
      u8"哟大过年",
      u8"哟希",
      u8"哟西",
      u8"哥们",
      u8"哥们义气",
      u8"哥们儿",
      u8"哥伦布",
      u8"哥伦比亚",
      u8"哥俩",
      u8"哥儿",
      u8"哥儿义气",
      u8"哥儿们",
      u8"哥儿俩",
      u8"哥哥",
      u8"哥哥妹妹",
      u8"哥嫂",
      u8"哥德",
      u8"哥德人",
      u8"哥德尔",
      u8"哥德尔配数",
      u8"哥德尔配数法",
      u8"哥德巴赫",
      u8"哥德式",
      u8"哥德曼",
      u8"哥斯拉",
      u8"哥斯达尼加",
      u8"哥斯达黎加",
      u8"哥本哈根",
      u8"哥特式",
      u8"哥特式建筑",
      u8"哥特式弓描记器",
      u8"哥登堡",
      u8"哥白尼",
      u8"哥窑",
      u8"哥罗芳",
      u8"哥老会",
      u8"哥萨克",
      u8"哥萨克人",
      u8"哥达",
      u8"哥达纲领",
      u8"哥达纲领批判",
      u8"哥里",
      u8"哦呵",
      u8"哦哟",
      u8"哦哦哦",
      u8"哦唷",
      u8"哦开机可",
      u8"哧哧",
      u8"哧溜",
      u8"哨位",
      u8"哨兵",
      u8"哨卡",
      u8"哨口",
      u8"哨塔",
      u8"哨声",
      u8"哨声波",
      u8"哨子",
      u8"哨岗",
      u8"哨房",
      u8"哨所",
      u8"哨棒",
      u8"哨音",
      u8"哨音响",
      u8"哨音声",
      u8"哩哩啦啦",
      u8"哩哩啰啰",
      u8"哩哩罗罗",
      u8"哩噜",
      u8"哩溜歪斜",
      u8"哪一",
      u8"哪一个",
      u8"哪一些",
      u8"哪一位",
      u8"哪一刻",
      u8"哪一只",
      u8"哪一块",
      u8"哪一天",
      u8"哪一年",
      u8"哪一方面",
      u8"哪一条",
      u8"哪一次",
      u8"哪一点",
      u8"哪一种",
      u8"哪一篇",
      u8"哪一部",
      u8"哪一首",
      u8"哪个",
      u8"哪么多",
      u8"哪些",
      u8"哪些人",
      u8"哪些因素",
      u8"哪些地方",
      u8"哪些方面",
      u8"哪些项目",
      u8"哪份",
      u8"哪会",
      u8"哪会儿",
      u8"哪会子",
      u8"哪位",
      u8"哪像",
      u8"哪儿",
      u8"哪几",
      u8"哪几个",
      u8"哪几天",
      u8"哪几种",
      u8"哪去",
      u8"哪句",
      u8"哪只",
      u8"哪吒",
      u8"哪吒闹海",
      u8"哪国",
      u8"哪够",
      u8"哪天",
      u8"哪家",
      u8"哪年哪月",
      u8"哪怕",
      u8"哪怕是",
      u8"哪敢",
      u8"哪方面",
      u8"哪有",
      u8"哪有什么",
      u8"哪有卖",
      u8"哪条",
      u8"哪来",
      u8"哪样",
      u8"哪次",
      u8"哪知",
      u8"哪知道",
      u8"哪种",
      u8"哪篇",
      u8"哪能",
      u8"哪行",
      u8"哪边",
      u8"哪还",
      u8"哪部",
      u8"哪里",
      u8"哪里也",
      u8"哪里人",
      u8"哪里去",
      u8"哪里找",
      u8"哪里每",
      u8"哪里话",
      u8"哪门子",
      u8"哪集",
      u8"哪项",
      u8"哭上",
      u8"哭上去",
      u8"哭上来",
      u8"哭丧",
      u8"哭丧棒",
      u8"哭丧着脸",
      u8"哭丧脸",
      u8"哭个",
      u8"哭个够",
      u8"哭个痛快",
      u8"哭了",
      u8"哭于斯",
      u8"哭出",
      u8"哭出来",
      u8"哭去",
      u8"哭叫",
      u8"哭号",
      u8"哭吧",
      u8"哭哭",
      u8"哭哭啼啼",
      u8"哭哭笑笑",
      u8"哭啼",
      u8"哭喊",
      u8"哭坟",
      u8"哭墓",
      u8"哭声",
      u8"哭天喊地",
      u8"哭天嚎地",
      u8"哭天抹泪",
      u8"哭尽",
      u8"哭得",
      u8"哭成",
      u8"哭成一团",
      u8"哭无泪",
      u8"哭来",
      u8"哭来哭去",
      u8"哭死了",
      u8"哭求",
      u8"哭泣",
      u8"哭泣声",
      u8"哭泪",
      u8"哭灵",
      u8"哭着",
      u8"哭穷",
      u8"哭笑不得",
      u8"哭笑俱齐",
      u8"哭肿",
      u8"哭脏",
      u8"哭脸",
      u8"哭腔",
      u8"哭诉",
      u8"哭调",
      u8"哭起",
      u8"哭起来",
      u8"哭过",
      u8"哭醒",
      u8"哭闹",
      u8"哭骂",
      u8"哭鼻子",
      u8"哮喘",
      u8"哮喘病",
      u8"哮证",
      u8"哲人",
      u8"哲人其萎",
      u8"哲嗣",
      u8"哲学",
      u8"哲学体系",
      u8"哲学博士",
      u8"哲学原理",
      u8"哲学史",
      u8"哲学学派",
      u8"哲学家",
      u8"哲学应用",
      u8"哲学思想",
      u8"哲学思潮",
      u8"哲学方法论",
      u8"哲学流派",
      u8"哲学理论",
      u8"哲学研究对象",
      u8"哲学笔记",
      u8"哲学系",
      u8"哲学范畴",
      u8"哲学著作",
      u8"哲学评论",
      u8"哲学领域",
      u8"哲思",
      u8"哲理",
      u8"哲理性",
      u8"哲罗星",
      u8"哲蚌寺",
      u8"哲言",
      u8"哲里木盟",
      u8"哺乳",
      u8"哺乳动物",
      u8"哺乳室",
      u8"哺乳期",
      u8"哺乳类",
      u8"哺养",
      u8"哺糟啜醨",
      u8"哺糟歠醨",
      u8"哺育",
      u8"哺育之恩",
      u8"哼上",
      u8"哼个",
      u8"哼出",
      u8"哼到",
      u8"哼哈二将",
      u8"哼哧",
      u8"哼哼",
      u8"哼哼哈哈",
      u8"哼哼唧唧",
      u8"哼唧",
      u8"哼唱",
      u8"哼唷",
      u8"哼声",
      u8"哼得",
      u8"哼歌",
      u8"哼着",
      u8"哼着唱",
      u8"哼腰",
      u8"哼起",
      u8"哼起来",
      u8"哽住",
      u8"哽咽",
      u8"哽哽咽咽",
      u8"哽噎",
      u8"哽在",
      u8"哽塞",
      u8"哽着",
      u8"唁函",
      u8"唁电",
      u8"唆使",
      u8"唆使者",
      u8"唇不离腮",
      u8"唇亡齿寒",
      u8"唇侧翼缘",
      u8"唇向错位",
      u8"唇吻",
      u8"唇尖舌利",
      u8"唇干口燥",
      u8"唇弓",
      u8"唇形",
      u8"唇彩",
      u8"唇挡",
      u8"唇揭齿寒",
      u8"唇敝舌腐",
      u8"唇杆",
      u8"唇枪舌剑",
      u8"唇枪舌战",
      u8"唇沟板",
      u8"唇炎",
      u8"唇焦口燥",
      u8"唇焦舌敝",
      u8"唇牵开器",
      u8"唇瓣",
      u8"唇疤疹",
      u8"唇疱疹",
      u8"唇竭齿寒",
      u8"唇系带",
      u8"唇红",
      u8"唇红缘",
      u8"唇红齿白",
      u8"唇缘",
      u8"唇腐齿落",
      u8"唇腭裂",
      u8"唇腺",
      u8"唇膏",
      u8"唇舌",
      u8"唇舌之争",
      u8"唇舌弓矫治器",
      u8"唇色",
      u8"唇裂",
      u8"唇裂修复术",
      u8"唇角",
      u8"唇辅相连",
      u8"唇部",
      u8"唇面",
      u8"唇音",
      u8"唇颈嵴",
      u8"唇齿",
      u8"唇齿之邦",
      u8"唇齿相依",
      u8"唇齿相须",
      u8"唇齿音",
      u8"唉叹",
      u8"唉呀",
      u8"唉哟",
      u8"唉唉",
      u8"唉唉叫",
      u8"唉声叹气",
      u8"唏嗒唏嗒",
      u8"唏嘘",
      u8"唐三彩",
      u8"唐三藏",
      u8"唐上",
      u8"唐中",
      u8"唐临晋帖",
      u8"唐五代",
      u8"唐人",
      u8"唐人街",
      u8"唐代",
      u8"唐代人",
      u8"唐伯虎",
      u8"唐伯虎点秋香",
      u8"唐僧",
      u8"唐僧肉",
      u8"唐光雄",
      u8"唐六爷",
      u8"唐兵",
      u8"唐努乌梁",
      u8"唐努乌梁海",
      u8"唐努山",
      u8"唐卡画",
      u8"唐县",
      u8"唐古拉山",
      u8"唐吉柯德",
      u8"唐吉诃德",
      u8"唐哉皇哉",
      u8"唐国强",
      u8"唐太宗",
      u8"唐宁街",
      u8"唐宋",
      u8"唐宋八大",
      u8"唐宋八大家",
      u8"唐家会村",
      u8"唐家庄",
      u8"唐家湾",
      u8"唐家璇",
      u8"唐寅",
      u8"唐小英",
      u8"唐尼",
      u8"唐山",
      u8"唐山地矿局",
      u8"唐山大",
      u8"唐山大兄",
      u8"唐山市",
      u8"唐师曾",
      u8"唐庄乡",
      u8"唐庄镇",
      u8"唐开元",
      u8"唐律",
      u8"唐志中",
      u8"唐才常",
      u8"唐文亮",
      u8"唐文龙",
      u8"唐明皇",
      u8"唐晓军",
      u8"唐朝",
      u8"唐朝人",
      u8"唐汤民",
      u8"唐河",
      u8"唐河县",
      u8"唐治平",
      u8"唐泽寿明",
      u8"唐洋",
      u8"唐海",
      u8"唐海县",
      u8"唐牛",
      u8"唐玄奘",
      u8"唐玄宗",
      u8"唐王",
      u8"唐甄",
      u8"唐突",
      u8"唐突西子",
      u8"唐突西施",
      u8"唐纪琛",
      u8"唐纳德",
      u8"唐纳森",
      u8"唐绍仪",
      u8"唐继尧",
      u8"唐老鸦",
      u8"唐老鸭",
      u8"唐花",
      u8"唐菖蒲",
      u8"唐虞",
      u8"唐虞之治",
      u8"唐装",
      u8"唐诗",
      u8"唐诗三百",
      u8"唐诗三百首",
      u8"唐诗咏",
      u8"唐诗宋词",
      u8"唐贞观",
      u8"唐赛儿",
      u8"唐锦",
      u8"唐镇",
      u8"唐镇商业公司",
      u8"唐门",
      u8"唐韵",
      u8"唐高祖",
      u8"唐高齐",
      u8"唐龙",
      u8"唔好",
      u8"唔妥",
      u8"唔知",
      u8"唔识",
      u8"唔该",
      u8"唔该晒",
      u8"唛头",
      u8"唠叨",
      u8"唠唠叨叨",
      u8"唠嗑",
      u8"唠扯",
      u8"唢呐",
      u8"唤作",
      u8"唤出",
      u8"唤名",
      u8"唤呼",
      u8"唤回",
      u8"唤头",
      u8"唤来",
      u8"唤来唤去",
      u8"唤起",
      u8"唤起民众",
      u8"唤醒",
      u8"唧咕",
      u8"唧哝",
      u8"唧唧",
      u8"唧唧咕咕",
      u8"唧唧喳喳",
      u8"唧唧嘎嘎",
      u8"唧啾",
      u8"唧拉喳拉",
      u8"唧筒",
      u8"唪经",
      u8"唬人",
      u8"唬住",
      u8"唬吓",
      u8"唬得",
      u8"唬来唬去",
      u8"售与",
      u8"售书",
      u8"售价",
      u8"售假",
      u8"售出",
      u8"售前",
      u8"售卖",
      u8"售卖机",
      u8"售后",
      u8"售后服务",
      u8"售完",
      u8"售房",
      u8"售房方",
      u8"售房款",
      u8"售报亭",
      u8"售楼",
      u8"售楼员",
      u8"售楼处",
      u8"售楼盘",
      u8"售楼部",
      u8"售油立管",
      u8"售电量",
      u8"售票",
      u8"售票亭",
      u8"售票厅",
      u8"售票口",
      u8"售票员",
      u8"售票处",
      u8"售票机",
      u8"售票点",
      u8"售禁令",
      u8"售粮",
      u8"售给",
      u8"售罄",
      u8"售解禁",
      u8"售让",
      u8"售货",
      u8"售货亭",
      u8"售货区",
      u8"售货员",
      u8"售货摊",
      u8"售货机",
      u8"售货棚",
      u8"售车",
      u8"售饭机",
      u8"唯一",
      u8"唯一一",
      u8"唯一可译码",
      u8"唯一合法政府",
      u8"唯一因子分解整环",
      u8"唯一性",
      u8"唯一性集",
      u8"唯一无二",
      u8"唯一标准",
      u8"唯你",
      u8"唯你是问",
      u8"唯其",
      u8"唯其如此",
      u8"唯利是从",
      u8"唯利是图",
      u8"唯利是求",
      u8"唯利是视",
      u8"唯力是视",
      u8"唯名论",
      u8"唯吾独尊",
      u8"唯命是从",
      u8"唯命是听",
      u8"唯唯",
      u8"唯唯否否",
      u8"唯唯喏喏",
      u8"唯唯诺诺",
      u8"唯唯连声",
      u8"唯妙",
      u8"唯妙唯肖",
      u8"唯实",
      u8"唯实论",
      u8"唯心",
      u8"唯心主义",
      u8"唯心主义者",
      u8"唯心史观",
      u8"唯心论",
      u8"唯恐",
      u8"唯恐天下",
      u8"唯恐天下不乱",
      u8"唯我",
      u8"唯我主义",
      u8"唯我独尊",
      u8"唯我论",
      u8"唯我论者",
      u8"唯所欲为",
      u8"唯才是举",
      u8"唯有",
      u8"唯有手中笔如枪",
      u8"唯有读书",
      u8"唯有读书高",
      u8"唯灵论",
      u8"唯物",
      u8"唯物主义",
      u8"唯物主义者",
      u8"唯物史观",
      u8"唯物论",
      u8"唯物辨证",
      u8"唯物辨证法",
      u8"唯物辩证",
      u8"唯物辩证法",
      u8"唯独",
      u8"唯理论",
      u8"唯生产力",
      u8"唯生产力论",
      u8"唯美",
      u8"唯美主义",
      u8"唯美图",
      u8"唯美派",
      u8"唯肖",
      u8"唯识",
      u8"唯象理论",
      u8"唯邻是卜",
      u8"唯金牌论",
      u8"唱下",
      u8"唱个",
      u8"唱主角",
      u8"唱了",
      u8"唱付",
      u8"唱出",
      u8"唱出来",
      u8"唱到",
      u8"唱功",
      u8"唱友",
      u8"唱双簧",
      u8"唱反",
      u8"唱反调",
      u8"唱名",
      u8"唱和",
      u8"唱响",
      u8"唱唱",
      u8"唱回",
      u8"唱回去",
      u8"唱回来",
      u8"唱国歌",
      u8"唱声",
      u8"唱大戏",
      u8"唱头",
      u8"唱对",
      u8"唱对台戏",
      u8"唱山歌",
      u8"唱工",
      u8"唱录机",
      u8"唱得",
      u8"唱念",
      u8"唱戏",
      u8"唱收",
      u8"唱曲",
      u8"唱本",
      u8"唱机",
      u8"唱来唱去",
      u8"唱歌",
      u8"唱歌曲",
      u8"唱歌跳舞",
      u8"唱段",
      u8"唱沙作米",
      u8"唱法",
      u8"唱游",
      u8"唱点",
      u8"唱片",
      u8"唱片业",
      u8"唱片名",
      u8"唱片目录",
      u8"唱片集",
      u8"唱独脚戏",
      u8"唱独角戏",
      u8"唱的歌",
      u8"唱盘",
      u8"唱着",
      u8"唱着歌",
      u8"唱破",
      u8"唱碟",
      u8"唱票",
      u8"唱票人",
      u8"唱票员",
      u8"唱筹量沙",
      u8"唱红脸",
      u8"唱腔",
      u8"唱词",
      u8"唱诗",
      u8"唱诗班",
      u8"唱赞歌",
      u8"唱起",
      u8"唱起来",
      u8"唱起歌",
      u8"唱道",
      u8"唱酬",
      u8"唱针",
      u8"唱首歌",
      u8"唱高",
      u8"唱高调",
      u8"唸一唸",
      u8"唸下去",
      u8"唸书",
      u8"唸书下去",
      u8"唸了",
      u8"唸佛",
      u8"唸作",
      u8"唸到",
      u8"唸咒",
      u8"唸唸",
      u8"唸唸有词",
      u8"唸好",
      u8"唸完",
      u8"唸得",
      u8"唸成",
      u8"唸来唸去",
      u8"唸法",
      u8"唸点",
      u8"唸着",
      u8"唸经",
      u8"唸给",
      u8"唸起来",
      u8"唸过",
      u8"唸错",
      u8"唼眼",
      u8"唾余",
      u8"唾吐",
      u8"唾地成文",
      u8"唾壶击碎",
      u8"唾壶击缺",
      u8"唾壶敲缺",
      u8"唾弃",
      u8"唾手可取",
      u8"唾手可得",
      u8"唾沫",
      u8"唾液",
      u8"唾液学",
      u8"唾液淀粉酶",
      u8"唾液腺",
      u8"唾液薄膜",
      u8"唾液诊断学",
      u8"唾液酸",
      u8"唾液酸寡糖",
      u8"唾液酸粘附素",
      u8"唾液酸糖缀合物",
      u8"唾液酸糖肽",
      u8"唾液酸糖蛋白",
      u8"唾液酸转移酶",
      u8"唾液酸酶",
      u8"唾腺",
      u8"唾面自乾",
      u8"唾面自干",
      u8"唾骂",
      u8"唿哨",
      u8"唿扇",
      u8"啁哳",
      u8"啁啾",
      u8"啃上",
      u8"啃下",
      u8"啃书",
      u8"啃书本",
      u8"啃书虫",
      u8"啃出",
      u8"啃到",
      u8"啃去",
      u8"啃噬",
      u8"啃得",
      u8"啃掉",
      u8"啃来啃去",
      u8"啃着",
      u8"啃老族",
      u8"啃蚀",
      u8"啃起",
      u8"啃起来",
      u8"啃过",
      u8"啃过去",
      u8"啃过来",
      u8"啃进",
      u8"啃青",
      u8"啃食",
      u8"啃骨头",
      u8"啄伤",
      u8"啄取",
      u8"啄木",
      u8"啄木鸟",
      u8"啄痕",
      u8"啄穿",
      u8"啄米",
      u8"啄虫",
      u8"啄起",
      u8"啄食",
      u8"商专",
      u8"商丘",
      u8"商丘县",
      u8"商丘市",
      u8"商丘站",
      u8"商业",
      u8"商业专科",
      u8"商业专科学校",
      u8"商业中心",
      u8"商业价值",
      u8"商业企业",
      u8"商业伙伴",
      u8"商业保险",
      u8"商业信息",
      u8"商业信用证",
      u8"商业公司",
      u8"商业利润",
      u8"商业利益",
      u8"商业化",
      u8"商业区",
      u8"商业发票",
      u8"商业地产",
      u8"商业地理学",
      u8"商业城",
      u8"商业城市",
      u8"商业学校",
      u8"商业局",
      u8"商业广告",
      u8"商业广场",
      u8"商业心理学",
      u8"商业性",
      u8"商业机会",
      u8"商业机构",
      u8"商业来往",
      u8"商业楼",
      u8"商业模式",
      u8"商业法",
      u8"商业活动",
      u8"商业渠道",
      u8"商业港",
      u8"商业点",
      u8"商业版",
      u8"商业理论",
      u8"商业用途",
      u8"商业界",
      u8"商业登记",
      u8"商业秘密",
      u8"商业移民",
      u8"商业空间",
      u8"商业系统",
      u8"商业经济",
      u8"商业网",
      u8"商业网布局",
      u8"商业网站",
      u8"商业职业",
      u8"商业职业学校",
      u8"商业职工",
      u8"商业行为",
      u8"商业街",
      u8"商业贷款",
      u8"商业贸易",
      u8"商业资本",
      u8"商业资讯",
      u8"商业软件",
      u8"商业道德",
      u8"商业部",
      u8"商业部门",
      u8"商业银行",
      u8"商业间谍",
      u8"商事",
      u8"商事法",
      u8"商亭",
      u8"商人",
      u8"商人资本",
      u8"商代",
      u8"商令",
      u8"商会",
      u8"商会会长",
      u8"商住",
      u8"商住楼",
      u8"商兑",
      u8"商函",
      u8"商办",
      u8"商务",
      u8"商务中心",
      u8"商务人士",
      u8"商务代表",
      u8"商务会议",
      u8"商务信息",
      u8"商务办事",
      u8"商务办事处",
      u8"商务办公区",
      u8"商务印书",
      u8"商务印书馆",
      u8"商务厅",
      u8"商务处",
      u8"商务大厦",
      u8"商务局",
      u8"商务师",
      u8"商务平台",
      u8"商务快车",
      u8"商务旅行",
      u8"商务机型",
      u8"商务楼",
      u8"商务活动",
      u8"商务洽谈",
      u8"商务电话",
      u8"商务礼仪",
      u8"商务礼品",
      u8"商务签证",
      u8"商务网",
      u8"商务考察",
      u8"商务考察团",
      u8"商务英语",
      u8"商务论坛",
      u8"商务调查",
      u8"商务谈判",
      u8"商务车",
      u8"商务通",
      u8"商务部",
      u8"商务部长",
      u8"商务酒店",
      u8"商务院",
      u8"商南",
      u8"商南县",
      u8"商厦",
      u8"商号",
      u8"商同",
      u8"商君",
      u8"商君书",
      u8"商周",
      u8"商品",
      u8"商品交换",
      u8"商品交易",
      u8"商品交易会",
      u8"商品交易所",
      u8"商品价格",
      u8"商品住宅",
      u8"商品信息",
      u8"商品化",
      u8"商品名",
      u8"商品名称",
      u8"商品型号",
      u8"商品城",
      u8"商品学",
      u8"商品展览",
      u8"商品展览会",
      u8"商品市场",
      u8"商品形象",
      u8"商品性",
      u8"商品性农业",
      u8"商品性生产基地",
      u8"商品房",
      u8"商品标示",
      u8"商品检验",
      u8"商品棉",
      u8"商品流转",
      u8"商品流通",
      u8"商品流通费",
      u8"商品猪",
      u8"商品率",
      u8"商品生产",
      u8"商品盘损",
      u8"商品盘盈",
      u8"商品目录",
      u8"商品种类",
      u8"商品税",
      u8"商品粮",
      u8"商品粮棉",
      u8"商品经济",
      u8"商品编号",
      u8"商品质量",
      u8"商品资本",
      u8"商品资金",
      u8"商品输出",
      u8"商品销售",
      u8"商团",
      u8"商图",
      u8"商图国事",
      u8"商圈",
      u8"商场",
      u8"商场如战场",
      u8"商城",
      u8"商城价",
      u8"商城县",
      u8"商埠",
      u8"商天娥",
      u8"商女不知亡国恨",
      u8"商妥",
      u8"商委",
      u8"商嫂",
      u8"商学",
      u8"商学系",
      u8"商学院",
      u8"商定",
      u8"商宝震",
      u8"商客",
      u8"商客居",
      u8"商家",
      u8"商对策",
      u8"商对象",
      u8"商展",
      u8"商州",
      u8"商州区",
      u8"商州市",
      u8"商工",
      u8"商工职业",
      u8"商工职业学校",
      u8"商店",
      u8"商彝周鼎",
      u8"商彝夏鼎",
      u8"商得",
      u8"商德",
      u8"商情",
      u8"商情报",
      u8"商情网",
      u8"商战",
      u8"商户",
      u8"商报",
      u8"商报讯",
      u8"商报路",
      u8"商拟",
      u8"商数",
      u8"商旅",
      u8"商旅网",
      u8"商易网",
      u8"商映射",
      u8"商曲",
      u8"商朝",
      u8"商朝人",
      u8"商机",
      u8"商权",
      u8"商标",
      u8"商标代理",
      u8"商标名",
      u8"商标局",
      u8"商标持有人",
      u8"商标权",
      u8"商标法",
      u8"商标注册",
      u8"商标纸",
      u8"商标网",
      u8"商标设计",
      u8"商桥",
      u8"商检",
      u8"商检单",
      u8"商检单证",
      u8"商检局",
      u8"商检工作",
      u8"商检机构",
      u8"商检章",
      u8"商检部门",
      u8"商榷",
      u8"商水",
      u8"商水县",
      u8"商汤",
      u8"商河",
      u8"商河县",
      u8"商法",
      u8"商法典",
      u8"商泛代数",
      u8"商洛",
      u8"商洛地区",
      u8"商洛市",
      u8"商洲",
      u8"商洽",
      u8"商流",
      u8"商海",
      u8"商海博杀",
      u8"商涵",
      u8"商港",
      u8"商王",
      u8"商用",
      u8"商用品",
      u8"商用机",
      u8"商用车",
      u8"商界",
      u8"商百富",
      u8"商社",
      u8"商祺",
      u8"商科",
      u8"商税",
      u8"商纣",
      u8"商约",
      u8"商约翰马加瑟",
      u8"商群",
      u8"商老太",
      u8"商而优则仕",
      u8"商职",
      u8"商船",
      u8"商船海事",
      u8"商船海事职业学校",
      u8"商船队",
      u8"商董",
      u8"商行",
      u8"商誉",
      u8"商计",
      u8"商订",
      u8"商讨",
      u8"商讨对策",
      u8"商讨问题",
      u8"商议",
      u8"商讯网",
      u8"商请",
      u8"商调",
      u8"商谈",
      u8"商谈对策",
      u8"商谜",
      u8"商贩",
      u8"商贸",
      u8"商贸城",
      u8"商贸点",
      u8"商贸网",
      u8"商贸通",
      u8"商贾",
      u8"商路",
      u8"商轮",
      u8"商都",
      u8"商都县",
      u8"商都网",
      u8"商酌",
      u8"商量",
      u8"商量一下",
      u8"商量余地",
      u8"商量对策",
      u8"商量研究",
      u8"商银",
      u8"商铺",
      u8"商队",
      u8"商阳",
      u8"商陆",
      u8"商鞅",
      u8"啊呀",
      u8"啊呀呀",
      u8"啊哈",
      u8"啊哟",
      u8"啊唷",
      u8"啊啊",
      u8"啊啊啊",
      u8"啖以重利",
      u8"啛啛喳喳",
      u8"啜泣",
      u8"啜英咀华",
      u8"啜菽饮水",
      u8"啜食吐哺",
      u8"啜饮",
      u8"啡厅",
      u8"啤酒",
      u8"啤酒业",
      u8"啤酒厂",
      u8"啤酒大麦",
      u8"啤酒屋",
      u8"啤酒杯",
      u8"啤酒沫",
      u8"啤酒瓶",
      u8"啤酒罐",
      u8"啤酒节",
      u8"啤酒花",
      u8"啤酒花浸膏",
      u8"啤酒设备",
      u8"啤酒酵母",
      u8"啤酒馆",
      u8"啥事",
      u8"啥人",
      u8"啥子",
      u8"啥意思",
      u8"啥时候",
      u8"啥样子",
      u8"啥病",
      u8"啦啦队",
      u8"啦啦队员",
      u8"啦啦队长",
      u8"啦瘌",
      u8"啦行",
      u8"啧啧",
      u8"啧啧声",
      u8"啧啧称奇",
      u8"啧啧称羡",
      u8"啧啧称赞",
      u8"啧有烦言",
      u8"啪哒啪哒",
      u8"啪哒声",
      u8"啪唧",
      u8"啪啦",
      u8"啪啪",
      u8"啪嗒",
      u8"啪嚓",
      u8"啪达",
      u8"啫哩",
      u8"啫喱",
      u8"啬己奉公",
      u8"啭声",
      u8"啮合",
      u8"啮合角",
      u8"啮噬",
      u8"啮檗吞针",
      u8"啮臂之好",
      u8"啮血为盟",
      u8"啮血沁骨",
      u8"啮雪吞毡",
      u8"啮雪餐毡",
      u8"啮齿",
      u8"啮齿类",
      u8"啰哩啰唆",
      u8"啰唆",
      u8"啰啰唆唆",
      u8"啰啰嗦嗦",
      u8"啰喽",
      u8"啰嗦",
      u8"啷铛",
      u8"啸侣命俦",
      u8"啸傲",
      u8"啸傲湖山",
      u8"啸傲风月",
      u8"啸叫",
      u8"啸吒风云",
      u8"啸咏",
      u8"啸咤风云",
      u8"啸声",
      u8"啸聚",
      u8"啸聚山林",
      u8"啸闹",
      u8"啸鸣",
      u8"啼乌",
      u8"啼叫",
      u8"啼呜",
      u8"啼哭",
      u8"啼啼哭哭",
      u8"啼声",
      u8"啼天哭地",
      u8"啼明",
      u8"啼泣",
      u8"啼猿",
      u8"啼笑",
      u8"啼笑皆非",
      u8"啼莺",
      u8"啼血",
      u8"啼饥号寒",
      u8"啼鸣",
      u8"啾叫",
      u8"啾唧",
      u8"啾啾",
      u8"啾嗽",
      u8"喀丝丽",
      u8"喀什",
      u8"喀什地区",
      u8"喀什市",
      u8"喀什米尔",
      u8"喀吧",
      u8"喀喇沁左翼",
      u8"喀喇沁左翼蒙古族自治县",
      u8"喀喇沁旗",
      u8"喀嚓",
      u8"喀嚓一声",
      u8"喀土穆",
      u8"喀城",
      u8"喀尔喀蒙古",
      u8"喀山",
      u8"喀布尔",
      u8"喀拉氏定理",
      u8"喀拉蚩",
      u8"喀斯特",
      u8"喀斯特化",
      u8"喀斯特地貌",
      u8"喀斯特地貌学",
      u8"喀斯特平原",
      u8"喀斯特景观",
      u8"喀斯特水",
      u8"喀琅施塔",
      u8"喀琅施塔得",
      u8"喀秋莎",
      u8"喀纳斯",
      u8"喀纳斯湖",
      u8"喀麦隆",
      u8"喀麦隆队",
      u8"喁喁",
      u8"喂乳",
      u8"喂了",
      u8"喂你",
      u8"喂养",
      u8"喂喂",
      u8"喂奶",
      u8"喂奶时",
      u8"喂得",
      u8"喂料",
      u8"喂料机",
      u8"喂母乳",
      u8"喂狗",
      u8"喂猪",
      u8"喂着",
      u8"喂给",
      u8"喂羊",
      u8"喂草",
      u8"喂药",
      u8"喂过",
      u8"喂食",
      u8"喂饭",
      u8"喂饱",
      u8"喂鱼",
      u8"喂鸡",
      u8"喂鸭",
      u8"喂鹅",
      u8"喃喃",
      u8"喃喃地",
      u8"喃喃细语",
      u8"喃喃自语",
      u8"喃嗟班",
      u8"喃语",
      u8"善与人交",
      u8"善为",
      u8"善为保管",
      u8"善为说辞",
      u8"善举",
      u8"善书",
      u8"善事",
      u8"善于",
      u8"善于引导",
      u8"善于词令",
      u8"善于辞令",
      u8"善人",
      u8"善价而估",
      u8"善体",
      u8"善体人意",
      u8"善刀而藏",
      u8"善加",
      u8"善加利用",
      u8"善化",
      u8"善变",
      u8"善后",
      u8"善后事宜",
      u8"善后处理",
      u8"善后工作",
      u8"善哉",
      u8"善善从长",
      u8"善善恶恶",
      u8"善堂",
      u8"善士",
      u8"善处",
      u8"善始令终",
      u8"善始善终",
      u8"善导寺",
      u8"善小而",
      u8"善待",
      u8"善御",
      u8"善心",
      u8"善心人士",
      u8"善忘",
      u8"善思",
      u8"善性",
      u8"善恶",
      u8"善恶不分",
      u8"善恶不变",
      u8"善恶不辨",
      u8"善恶值",
      u8"善恶到头终有报",
      u8"善意",
      u8"善意回应",
      u8"善感",
      u8"善战",
      u8"善才",
      u8"善报",
      u8"善文",
      u8"善文能武",
      u8"善有善报",
      u8"善有善报恶有恶报",
      u8"善本",
      u8"善本书",
      u8"善根",
      u8"善气迎人",
      u8"善游者溺",
      u8"善用",
      u8"善男信女",
      u8"善眉善眼",
      u8"善睐",
      u8"善策",
      u8"善类",
      u8"善纳忠言",
      u8"善终",
      u8"善罢干休",
      u8"善罢甘休",
      u8"善自为谋",
      u8"善自保重",
      u8"善良",
      u8"善莫大",
      u8"善行",
      u8"善解",
      u8"善解人意",
      u8"善言",
      u8"善财难舍",
      u8"善贾而沽",
      u8"善辩",
      u8"善辩者",
      u8"善门难开",
      u8"善颂善祷",
      u8"善马熟人",
      u8"善骑者堕",
      u8"喇叭",
      u8"喇叭反射天线",
      u8"喇叭口",
      u8"喇叭口短节",
      u8"喇叭声",
      u8"喇叭天线",
      u8"喇叭手",
      u8"喇叭筒",
      u8"喇叭管",
      u8"喇叭线",
      u8"喇叭花",
      u8"喇叭裤",
      u8"喇嘛",
      u8"喇嘛寺",
      u8"喇嘛寺院",
      u8"喇嘛庙",
      u8"喇嘛教",
      u8"喇嘛教徒",
      u8"喇蛄",
      u8"喉切开术",
      u8"喉咙",
      u8"喉咙干",
      u8"喉咙痛",
      u8"喉塞音",
      u8"喉头",
      u8"喉头炎",
      u8"喉宝",
      u8"喉擦音",
      u8"喉清暗雅",
      u8"喉炎",
      u8"喉片",
      u8"喉癌",
      u8"喉科",
      u8"喉科学",
      u8"喉管",
      u8"喉结",
      u8"喉舌",
      u8"喉道",
      u8"喉部",
      u8"喉镜",
      u8"喉长气短",
      u8"喉音",
      u8"喉风",
      u8"喉骨",
      u8"喊一声",
      u8"喊上",
      u8"喊上去",
      u8"喊上来",
      u8"喊下",
      u8"喊下去",
      u8"喊下来",
      u8"喊了",
      u8"喊人",
      u8"喊他",
      u8"喊价",
      u8"喊住",
      u8"喊停",
      u8"喊冤",
      u8"喊冤叫屈",
      u8"喊出",
      u8"喊出去",
      u8"喊出来",
      u8"喊到",
      u8"喊叫",
      u8"喊叫声",
      u8"喊嗓子",
      u8"喊嚷",
      u8"喊回",
      u8"喊回去",
      u8"喊回来",
      u8"喊堂威",
      u8"喊声",
      u8"喊她",
      u8"喊好",
      u8"喊得",
      u8"喊成",
      u8"喊救",
      u8"喊救命",
      u8"喊来",
      u8"喊来喊去",
      u8"喊着",
      u8"喊破",
      u8"喊穷",
      u8"喊话",
      u8"喊起",
      u8"喊起来",
      u8"喊过",
      u8"喊进",
      u8"喊进去",
      u8"喊进来",
      u8"喊醒",
      u8"喋喋",
      u8"喋喋不休",
      u8"喋血",
      u8"喋血记",
      u8"喏喏连声",
      u8"喑了",
      u8"喑哑",
      u8"喑噁叱咤",
      u8"喔唷",
      u8"喔啊声",
      u8"喔喔",
      u8"喔喔叫",
      u8"喔嚄",
      u8"喔龊",
      u8"喘不过气来",
      u8"喘出",
      u8"喘吁吁",
      u8"喘喘",
      u8"喘喘气",
      u8"喘嘘嘘",
      u8"喘息",
      u8"喘息之间",
      u8"喘息声",
      u8"喘息未定",
      u8"喘月吴牛",
      u8"喘气",
      u8"喘气声",
      u8"喘证",
      u8"喙突",
      u8"喙突后注射法",
      u8"喙长三尺",
      u8"喜上加",
      u8"喜上加喜",
      u8"喜上眉梢",
      u8"喜不自禁",
      u8"喜不自胜",
      u8"喜丧",
      u8"喜临门",
      u8"喜之郎",
      u8"喜乐",
      u8"喜乐蒂",
      u8"喜事",
      u8"喜人",
      u8"喜从何来",
      u8"喜从天降",
      u8"喜信",
      u8"喜兴",
      u8"喜冲冲",
      u8"喜出望外",
      u8"喜刷刷",
      u8"喜剧",
      u8"喜剧之王",
      u8"喜剧效果",
      u8"喜剧演员",
      u8"喜剧片",
      u8"喜剧电影",
      u8"喜剧类",
      u8"喜剧色彩",
      u8"喜剧路线",
      u8"喜力",
      u8"喜功",
      u8"喜唰唰",
      u8"喜唱乐听",
      u8"喜地欢天",
      u8"喜多郎",
      u8"喜好",
      u8"喜娘",
      u8"喜子",
      u8"喜孜孜",
      u8"喜宴",
      u8"喜容",
      u8"喜封",
      u8"喜帐",
      u8"喜帖",
      u8"喜幛",
      u8"喜幸",
      u8"喜庆",
      u8"喜庆宴会",
      u8"喜形于色",
      u8"喜得",
      u8"喜德",
      u8"喜德县",
      u8"喜忧参半",
      u8"喜怒",
      u8"喜怒不形",
      u8"喜怒不形于色",
      u8"喜怒哀乐",
      u8"喜怒哀愁",
      u8"喜怒无常",
      u8"喜性",
      u8"喜恶",
      u8"喜悦",
      u8"喜悦之情",
      u8"喜意",
      u8"喜感",
      u8"喜报",
      u8"喜按",
      u8"喜新厌故",
      u8"喜新厌旧",
      u8"喜来登",
      u8"喜极而泣",
      u8"喜果",
      u8"喜树",
      u8"喜树碱",
      u8"喜欢",
      u8"喜欢吃",
      u8"喜欢我",
      u8"喜欢着",
      u8"喜歌剧",
      u8"喜气",
      u8"喜气洋洋",
      u8"喜泪",
      u8"喜洋",
      u8"喜洋洋",
      u8"喜溢眉宇",
      u8"喜溢眉梢",
      u8"喜滋滋",
      u8"喜满你",
      u8"喜爱",
      u8"喜爱着",
      u8"喜玛拉雅",
      u8"喜玛拉雅山",
      u8"喜盈盈",
      u8"喜盈门",
      u8"喜相逢",
      u8"喜眉笑眼",
      u8"喜看",
      u8"喜笑频开",
      u8"喜笑颜开",
      u8"喜筵",
      u8"喜糖",
      u8"喜结良缘",
      u8"喜结连理",
      u8"喜联",
      u8"喜脉",
      u8"喜色",
      u8"喜芙浓",
      u8"喜获",
      u8"喜获丰收",
      u8"喜蛋",
      u8"喜行于色",
      u8"喜见于色",
      u8"喜讯",
      u8"喜讯传来",
      u8"喜跃",
      u8"喜跃抃舞",
      u8"喜车",
      u8"喜迁",
      u8"喜迁新居",
      u8"喜迎",
      u8"喜迎春",
      u8"喜逐颜开",
      u8"喜逢",
      u8"喜酒",
      u8"喜钱",
      u8"喜闻",
      u8"喜闻乐见",
      u8"喜雀",
      u8"喜雨",
      u8"喜饼",
      u8"喜马拉",
      u8"喜马拉雅",
      u8"喜马拉雅山",
      u8"喜马拉雅山脉",
      u8"喜鹊",
      u8"喝一杯",
      u8"喝上",
      u8"喝下",
      u8"喝下去",
      u8"喝个",
      u8"喝了",
      u8"喝了酒",
      u8"喝令",
      u8"喝住",
      u8"喝倒彩",
      u8"喝光",
      u8"喝入",
      u8"喝出",
      u8"喝到",
      u8"喝口",
      u8"喝口水",
      u8"喝叱",
      u8"喝咖啡",
      u8"喝啤酒",
      u8"喝喝",
      u8"喝墨水",
      u8"喝多",
      u8"喝够",
      u8"喝好"