/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.json.JSONObject;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="kraGetTransportCert", urlPatterns={"/admin/kra/getTransportCert"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="ID", value="kraGetTransportCert"), @WebInitParam(name="AuthMgr", value="TokenAuth"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="resourceID", value="certServer.kra.getTransportCert")})
public class GetTransportCert
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetTransportCert.class);
    private static final long serialVersionUID = 2495152202191979339L;
    private static final String SUCCESS = "0";
    private static final String AUTH_FAILURE = "2";

    public void init(ServletConfig sc) throws ServletException {
        logger.debug("GetTransportCert: initializing...");
        super.init(sc);
        logger.debug("GetTransportCert: done initializing...");
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("UpdateUpdater: processing...");
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = null;
        try {
            authToken = this.authenticate(cmsReq);
            logger.debug("GetTransportCert authentication successful.");
        }
        catch (Exception e) {
            logger.error("GetTransportCert: authentication failed: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{"", e.toString()}));
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        if (authToken == null) {
            logger.error("GetTransportCert: authentication failed.");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
            logger.debug("GetTransportCert authorization successful.");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        KRAEngine engine = KRAEngine.getInstance();
        KeyRecoveryAuthority kra = engine.getKRA();
        TransportKeyUnit tu = kra.getTransportKeyUnit();
        X509Certificate transportCert = tu.getCertificate();
        String mime64 = "";
        try {
            mime64 = Utils.base64encode((byte[])transportCert.getEncoded(), (boolean)true);
            mime64 = Cert.normalizeCertStrAndReq((String)mime64);
        }
        catch (CertificateEncodingException eee) {
            logger.warn("GetTransportCert: Failed to encode certificate: " + eee.getMessage(), (Throwable)eee);
        }
        try {
            logger.debug("GetTransportCert: Sending response " + mime64);
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("Status", SUCCESS);
            responseNode.put("TransportCert", mime64);
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("GetTransportCert: Failed to send the output " + e.getMessage(), (Throwable)e);
        }
    }

    protected void setDefaultTemplates(ServletConfig sc) {
    }

    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }
}

