/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.key.KeyRecordParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrchKeyForRecovery
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(SrchKeyForRecovery.class);
    private static final long serialVersionUID = 5426987963811540460L;
    private static final String TPL_FILE = "srchKeyForRecovery.template";
    private static final String INFO = "srchKey";
    private static final String PROP_MAX_SEARCH_RETURNS = "maxSearchReturns";
    private static final String IN_MAXCOUNT = "maxCount";
    private static final String IN_FILTER = "queryFilter";
    private static final String IN_SENTINEL = "querySentinel";
    private static final String REALM = "realm";
    private static final String OUT_FILTER = "queryFilter";
    private static final String OUT_MAXCOUNT = "maxCount";
    private static final String OUT_SENTINEL = "querySentinel";
    private static final String OUT_OP = "op";
    private static final String OUT_ARCHIVER = "archiverName";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_TOTAL_COUNT = "totalRecordCount";
    private static final String OUT_TEMPLATE = "templateName";
    private KeyRepository mKeyDB;
    private X500Name mAuthName = null;
    private String mFormPath = null;
    private int mMaxReturns = 100;
    private int mTimeLimits = 30;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/kra/srchKeyForRecovery.template";
        try {
            String tmp = sc.getInitParameter(PROP_MAX_SEARCH_RETURNS);
            this.mMaxReturns = tmp == null ? 100 : Integer.parseInt(tmp);
        }
        catch (Exception tmp) {
            // empty catch block
        }
        KRAEngine engine = KRAEngine.getInstance();
        KeyRecoveryAuthority kra = engine.getKRA();
        this.mKeyDB = kra.getKeyRepository();
        this.mAuthName = kra.getX500Name();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String realm = req.getParameter(REALM);
        try {
            this.mAuthz.checkRealm(realm, authToken, null, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied | EAuthzUnknownRealm e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), e);
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            cmsReq.setStatus(CMSRequest.EXCEPTION);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        EBaseException error = null;
        int maxCount = -1;
        int sentinel = 0;
        int maxResults = -1;
        int timeLimit = -1;
        try {
            String timeLimitStr;
            String maxResultsStr;
            if (req.getParameter("maxCount") != null) {
                maxCount = Integer.parseInt(req.getParameter("maxCount"));
            }
            if (req.getParameter("querySentinel") != null) {
                sentinel = Integer.parseInt(req.getParameter("querySentinel"));
            }
            if ((maxResultsStr = req.getParameter("maxResults")) != null && maxResultsStr.length() > 0) {
                maxResults = Integer.parseInt(maxResultsStr);
            }
            if ((timeLimitStr = req.getParameter("timeLimit")) != null && timeLimitStr.length() > 0) {
                timeLimit = Integer.parseInt(timeLimitStr);
            }
            this.process(argSet, header, ctx, maxCount, maxResults, timeLimit, sentinel, req.getParameter("publicKeyData"), req.getParameter("queryFilter"), req, resp, locale[0], realm);
        }
        catch (NumberFormatException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        try {
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    ServletOutputStream out = resp.getOutputStream();
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, ArgBlock ctx, int maxCount, int maxResults, int timeLimit, int sentinel, String publicKeyData, String filter, HttpServletRequest req, HttpServletResponse resp, Locale locale, String realm) throws EBaseException {
        try {
            if (((String)filter).contains("(realm=")) {
                throw new EBaseException("Query filter cannot contain realm");
            }
            filter = realm != null ? "(&" + (String)filter + "(realm=" + LDAPUtil.escapeFilter((Object)realm) + "))" : "(&" + (String)filter + "(!(realm=*)))";
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue(OUT_ARCHIVER, this.mAuthName.toString());
            header.addStringValue(OUT_SERVICE_URL, "/kra?");
            header.addStringValue(OUT_TEMPLATE, TPL_FILE);
            header.addStringValue("queryFilter", (String)filter);
            if (publicKeyData != null) {
                header.addStringValue("publicKeyData", publicKeyData);
            }
            if (timeLimit == -1 || timeLimit > this.mTimeLimits) {
                logger.debug("Resetting timelimit from " + timeLimit + " to " + this.mTimeLimits);
                timeLimit = this.mTimeLimits;
            }
            logger.debug("Start searching ... timelimit=" + timeLimit);
            Enumeration<KeyRecord> e = this.mKeyDB.searchKeys((String)filter, maxResults, timeLimit);
            int count = 0;
            if (e == null) {
                header.addStringValue("querySentinel", null);
            } else {
                while (e.hasMoreElements()) {
                    KeyRecord rec = e.nextElement();
                    if (rec == null) continue;
                    ArgBlock rarg = new ArgBlock();
                    KeyRecordParser.fillRecordIntoArg((KeyRecord)rec, (ArgBlock)rarg);
                    argSet.addRepeatRecord(rarg);
                    ++count;
                }
            }
            header.addIntegerValue("maxSize", this.mMaxReturns);
            header.addIntegerValue(OUT_TOTAL_COUNT, count);
            ctx.addIntegerValue("maxCount", maxCount);
        }
        catch (EBaseException e) {
            logger.error("SrchKeyForRecovery: " + e);
            throw e;
        }
    }
}

