/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.Arrays;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;
import netscape.ldap.util.DN;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityMonitor
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(AuthorityMonitor.class);
    private boolean running = true;

    @Override
    public void run() {
        int op = 15;
        LDAPPersistSearchControl persistCtrl = new LDAPPersistSearchControl(op, false, true, true);
        CAEngine engine = CAEngine.getInstance();
        String lwcaContainerDNString = engine.getAuthorityBaseDN();
        DN lwcaContainerDN = new DN(lwcaContainerDNString);
        logger.debug("AuthorityMonitor: Starting authority monitor");
        while (this.running) {
            LDAPConnection conn = null;
            try {
                conn = engine.getConnectionFactory().getConn();
                LDAPSearchConstraints cons = conn.getSearchConstraints();
                cons.setServerControls((LDAPControl)persistCtrl);
                cons.setBatchSize(1);
                cons.setServerTimeLimit(0);
                String[] attrs = new String[]{"*", "entryUSN", "nsUniqueId", "numSubordinates"};
                LDAPSearchResults results = conn.search(lwcaContainerDNString, 2, "(objectclass=*)", attrs, false, cons);
                engine.getLoader().startLoading();
                while (this.running && results.hasMoreElements()) {
                    LDAPEntry entry = results.next();
                    DN entryDN = new DN(entry.getDN());
                    if (entryDN.countRDNs() == lwcaContainerDN.countRDNs()) {
                        engine.getLoader().setNumItems(Integer.valueOf(entry.getAttribute("numSubordinates").getStringValueArray()[0]));
                        continue;
                    }
                    if (entryDN.countRDNs() > lwcaContainerDN.countRDNs() + 1) continue;
                    String[] objectClasses = entry.getAttribute("objectClass").getStringValueArray();
                    if (!Arrays.asList(objectClasses).contains("authority")) {
                        engine.getLoader().increment();
                        continue;
                    }
                    LDAPEntryChangeControl changeControl = (LDAPEntryChangeControl)LDAPUtil.getControl(LDAPEntryChangeControl.class, (LDAPControl[])results.getResponseControls());
                    logger.debug("AuthorityMonitor: Processed change controls.");
                    if (changeControl != null) {
                        int changeType = changeControl.getChangeType();
                        switch (changeType) {
                            case 1: {
                                logger.debug("AuthorityMonitor: ADD");
                                engine.readAuthority(entry);
                                break;
                            }
                            case 2: {
                                logger.debug("AuthorityMonitor: DELETE");
                                this.handleDELETE(entry);
                                break;
                            }
                            case 4: {
                                logger.debug("AuthorityMonitor: MODIFY");
                                engine.readAuthority(entry);
                                break;
                            }
                            case 8: {
                                logger.debug("AuthorityMonitor: MODDN");
                                this.handleMODDN(new DN(changeControl.getPreviousDN()), entry);
                                break;
                            }
                            default: {
                                logger.debug("AuthorityMonitor: unknown change type: " + changeType);
                                break;
                            }
                        }
                        continue;
                    }
                    logger.debug("AuthorityMonitor: immediate result");
                    engine.readAuthority(entry);
                    engine.getLoader().increment();
                }
            }
            catch (ELdapException e) {
                logger.warn("AuthorityMonitor: Failed to get LDAPConnection: " + e.getMessage(), (Throwable)e);
                logger.warn("AuthorityMonitor: Retrying in 1 second.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (LDAPException e) {
                if (this.running) {
                    logger.warn("AuthorityMonitor: Failed to execute LDAP search for lightweight CAs: " + e, (Throwable)e);
                    continue;
                }
                logger.info("AuthorityMonitor: Shutting down: " + e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    engine.getConnectionFactory().returnConn(conn);
                }
                catch (Exception e) {
                    logger.warn("AuthorityMonitor: Error releasing the LDAPConnection" + e.getMessage(), (Throwable)e);
                }
            }
        }
        logger.debug("AuthorityMonitor: stopping.");
    }

    private synchronized void handleMODDN(DN oldDN, LDAPEntry entry) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        DN authorityBase = new DN(engine.getAuthorityBaseDN());
        boolean wasMonitored = oldDN.isDescendantOf(authorityBase);
        boolean isMonitored = new DN(entry.getDN()).isDescendantOf(authorityBase);
        if (wasMonitored && !isMonitored) {
            LDAPAttribute attr = entry.getAttribute("authorityID");
            if (attr != null) {
                AuthorityID aid = new AuthorityID(attr.getStringValueArray()[0]);
                engine.removeCA(aid);
            }
        } else if (!wasMonitored && isMonitored) {
            engine.readAuthority(entry);
        }
    }

    private synchronized void handleDELETE(LDAPEntry entry) {
        LDAPAttribute attr = entry.getAttribute("nsUniqueId");
        String nsUniqueId = null;
        if (attr != null) {
            nsUniqueId = attr.getStringValueArray()[0];
        }
        if (CAEngine.deletedNsUniqueIds.remove(nsUniqueId)) {
            logger.debug("handleDELETE: delete was already effected");
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        AuthorityID aid = null;
        attr = entry.getAttribute("authorityID");
        if (attr != null) {
            aid = new AuthorityID(attr.getStringValueArray()[0]);
            CertificateAuthority ca = engine.getCA(aid);
            if (ca == null) {
                return;
            }
            try {
                ca.deleteAuthorityNSSDB();
            }
            catch (ECAException e) {
                logger.warn("Caught exception attempting to delete NSSDB material for authority '" + aid + "': " + e.getMessage(), (Throwable)e);
            }
            engine.removeCA(aid);
        }
    }

    public void shutdown() {
        this.running = false;
    }
}

