/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.FreshestCRLExtension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSFreshestCRLExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static final Logger logger = LoggerFactory.getLogger(CMSFreshestCRLExtension.class);
    public static final String PROP_NUM_POINTS = "numPoints";
    public static final String PROP_POINTTYPE = "pointType";
    public static final String PROP_POINTNAME = "pointName";
    public static final String PROP_DIRNAME = "DirectoryName";
    public static final String PROP_URINAME = "URI";

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        FreshestCRLExtension freshestCRLExt = (FreshestCRLExtension)ext;
        freshestCRLExt.setCritical(critical);
        return freshestCRLExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        FreshestCRLExtension freshestCRLExt = null;
        int numPoints = 0;
        try {
            numPoints = config.getInteger(PROP_NUM_POINTS, 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_INVALID_NUM_NAMES", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (numPoints > 0) {
            for (int i = 0; i < numPoints; ++i) {
                CRLDistributionPoint crlDP = new CRLDistributionPoint();
                GeneralNames names = new GeneralNames();
                String pointType = null;
                try {
                    pointType = config.getString(PROP_POINTTYPE + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (pointType != null) {
                    String pointName = null;
                    try {
                        pointName = config.getString(PROP_POINTNAME + i);
                    }
                    catch (EPropertyNotFound e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    catch (EBaseException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    if (pointName != null && pointName.length() > 0) {
                        if (pointType.equalsIgnoreCase(PROP_DIRNAME)) {
                            try {
                                X500Name dirName = new X500Name(pointName);
                                names.addElement((Object)dirName);
                            }
                            catch (IOException e) {
                                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_500NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                            }
                        } else if (pointType.equalsIgnoreCase(PROP_URINAME)) {
                            URIName uriName = new URIName(pointName);
                            names.addElement((Object)uriName);
                        } else {
                            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_POTINT_TYPE", (Object[])new Object[]{pointType}));
                        }
                    }
                }
                if (names.size() > 0) {
                    try {
                        crlDP.setFullName(names);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CANNOT_SET_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    catch (GeneralNamesException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CANNOT_SET_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
                if (i > 0) {
                    freshestCRLExt.addPoint(crlDP);
                    continue;
                }
                freshestCRLExt = new FreshestCRLExtension(crlDP);
            }
        }
        return freshestCRLExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.FreshestCRL_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        int numPoints = 0;
        try {
            numPoints = config.getInteger(PROP_NUM_POINTS, 0);
        }
        catch (EBaseException e) {
            logger.warn("Invalid numPoints property for CRL Freshest CRL extension: " + e.getMessage(), (Throwable)e);
        }
        nvp.put((Object)PROP_NUM_POINTS, (Object)String.valueOf(numPoints));
        for (int i = 0; i < numPoints; ++i) {
            String pointType = null;
            try {
                pointType = config.getString(PROP_POINTTYPE + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (pointType != null && pointType.length() > 0) {
                nvp.put((Object)(PROP_POINTTYPE + i), (Object)pointType);
            } else {
                nvp.put((Object)(PROP_POINTTYPE + i), (Object)"");
            }
            String pointName = null;
            try {
                pointName = config.getString(PROP_POINTNAME + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (pointName != null && pointName.length() > 0) {
                nvp.put((Object)(PROP_POINTNAME + i), (Object)pointName);
                continue;
            }
            nvp.put((Object)(PROP_POINTNAME + i), (Object)"");
        }
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Freshest CRL extension.", "critical;boolean;Set criticality for Freshest CRL extension.", "numPoints;number;Set number of CRL distribution points.", "pointType0;choice(DirectoryName,URI);Select CRL distribution point name type.", "pointName0;string;Enter CRL distribution point name corresponding to the selected point type.", "HELP_TOKEN;configuration-ca-edit-crlextension-issuingdistributionpoint", "pointType1;choice(DirectoryName,URI);Select CRL distribution point name type.", "pointName1;string;Enter CRL distribution point name corresponding to the selected point type.", "HELP_TOKEN;configuration-ca-edit-crlextension-issuingdistributionpoint", "pointType2;choice(DirectoryName,URI);Select CRL distribution point name type.", "pointName2;string;Enter CRL distribution point name corresponding to the selected point type.", "HELP_TOKEN;configuration-ca-edit-crlextension-issuingdistributionpoint", "HELP_TEXT;The Freshest CRL is a non critical CRL extension that identifies the delta CRL distribution points for a particular CRL."};
        return params;
    }
}

