/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.AttributeConfig;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectDirAttributesExtension;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDirAttributesExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectDirAttributesExtDefault.class);
    public static final String CONFIG_CRITICAL = "subjDirAttrsCritical";
    public static final String CONFIG_NUM_ATTRS = "subjDirAttrsNum";
    public static final String CONFIG_ATTR_NAME = "subjDirAttrName_";
    public static final String CONFIG_PATTERN = "subjDirAttrPattern_";
    public static final String CONFIG_ENABLE = "subjDirAttrEnable_";
    public static final String VAL_CRITICAL = "subjDirAttrCritical";
    public static final String VAL_ATTR = "subjDirAttrValue";
    private static final int DEF_NUM_ATTRS = 1;
    private static final int MAX_NUM_ATTRS = 100;
    private static final String ENABLE = "Enable";
    private static final String ATTR_NAME = "Attribute Name";
    private static final String ATTR_VALUE = "Attribute Value";

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    protected int getNumAttrs() {
        int num = 1;
        String val = this.getConfig(CONFIG_NUM_ATTRS);
        if (val != null) {
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(1)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_ATTRS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_ATTRS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName(VAL_CRITICAL);
        this.addValueName(VAL_ATTR);
        this.addConfigName(CONFIG_CRITICAL);
        int num = this.getNumAttrs();
        this.addConfigName(CONFIG_NUM_ATTRS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_ATTR_NAME + i);
            this.addConfigName(CONFIG_PATTERN + i);
            this.addConfigName(CONFIG_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ATTR_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_ATTRS", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ATTR_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ATTR_NAME", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ATTR_VALUE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ENABLE)) {
            return new Descriptor("boolean", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_ATTRS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_ATTRS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_CRITICAL)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_ATTR)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJDIR_ATTRS", (String[])new String[0]));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            SubjectDirAttributesExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
            if (name.equals(VAL_CRITICAL)) {
                ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else {
                if (!name.equals(VAL_ATTR)) throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Vector<NameValuePairs> v = this.parseRecords(value);
                int size = v.size();
                boolean critical = ext.isCritical();
                Vector<Attribute> attrV = new Vector<Attribute>();
                for (int i = 0; i < size; ++i) {
                    NameValuePairs nvps = v.elementAt(i);
                    String attrName = null;
                    String attrValue = null;
                    String enable = "false";
                    for (String name1 : nvps.keySet()) {
                        if (name1.equals(ATTR_NAME)) {
                            attrName = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(ATTR_VALUE)) {
                            attrValue = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (!name1.equals(ENABLE)) continue;
                        enable = (String)nvps.get((Object)name1);
                    }
                    if (!enable.equals("true")) continue;
                    AttributeConfig attributeConfig = new AttributeConfig(attrName, attrValue);
                    Attribute attr = attributeConfig.mAttribute;
                    if (attr == null) continue;
                    attrV.addElement(attr);
                }
                if (attrV.size() <= 0) return;
                Object[] attrList = new Attribute[attrV.size()];
                attrV.copyInto(attrList);
                ext = new SubjectDirAttributesExtension((Attribute[])attrList, critical);
            }
            this.replaceExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), (Extension)ext, info);
            return;
        }
        catch (EProfileException e) {
            logger.error("SubjectDirAttributesExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("SubjectDirAttributesExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        SubjectDirAttributesExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
        if (name.equals(VAL_CRITICAL)) {
            ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_ATTR)) {
            NameValuePairs pairs;
            ext = (SubjectDirAttributesExtension)this.getExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            X500NameAttrMap map = X500NameAttrMap.getDefault();
            Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
            int num = this.getNumAttrs();
            Enumeration e = ext.getAttributesList();
            logger.debug("SubjectDirAttributesExtDefault: getValue: attributesList=" + e);
            int i = 0;
            while (e.hasMoreElements()) {
                pairs = new NameValuePairs();
                pairs.put((Object)ENABLE, (Object)"true");
                Attribute attr = (Attribute)e.nextElement();
                logger.debug("SubjectDirAttributesExtDefault: getValue: attribute=" + attr);
                ObjectIdentifier oid = attr.getOid();
                logger.debug("SubjectDirAttributesExtDefault: getValue: oid=" + oid);
                String vv = map.getName(oid);
                if (vv != null) {
                    pairs.put((Object)ATTR_NAME, (Object)vv);
                } else {
                    pairs.put((Object)ATTR_NAME, (Object)oid.toString());
                }
                Enumeration v = attr.getValues();
                StringBuffer ss = new StringBuffer();
                while (v.hasMoreElements()) {
                    if (ss.length() == 0) {
                        ss.append((String)v.nextElement());
                        continue;
                    }
                    ss.append(",");
                    ss.append((String)v.nextElement());
                }
                pairs.put((Object)ATTR_VALUE, (Object)ss.toString());
                recs.addElement(pairs);
                ++i;
            }
            while (i < num) {
                pairs = new NameValuePairs();
                pairs.put((Object)ENABLE, (Object)"false");
                pairs.put((Object)ATTR_NAME, (Object)"GENERATIONQUALIFIER");
                pairs.put((Object)ATTR_VALUE, (Object)"");
                recs.addElement(pairs);
                ++i;
            }
            return SubjectDirAttributesExtDefault.buildRecords(recs);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumAttrs();
        for (int i = 0; i < num; ++i) {
            sb.append("Record #");
            sb.append(i);
            sb.append("{");
            sb.append("Attribute Name:");
            sb.append(this.getConfig(CONFIG_ATTR_NAME + i));
            sb.append(",");
            sb.append("Attribute Value:");
            sb.append(this.getConfig(CONFIG_PATTERN + i));
            sb.append(",");
            sb.append("Enable:");
            sb.append(this.getConfig(CONFIG_ENABLE + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SUBJECT_DIR_ATTR_EXT", (String[])new String[]{this.getConfig(CONFIG_CRITICAL), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        SubjectDirAttributesExtension ext = this.createExtension(request);
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.SubjectDirectoryAttributes_Id.toString(), (Extension)ext, info);
    }

    public SubjectDirAttributesExtension createExtension(Request request) throws EProfileException {
        SubjectDirAttributesExtension ext = null;
        int num = 0;
        boolean critical = this.getConfigBoolean(CONFIG_CRITICAL);
        num = this.getNumAttrs();
        AttributeConfig attributeConfig = null;
        Vector<Attribute> attrs = new Vector<Attribute>();
        for (int i = 0; i < num; ++i) {
            String enable = this.getConfig(CONFIG_ENABLE + i);
            if (enable == null || !enable.equals("true")) continue;
            String attrName = this.getConfig(CONFIG_ATTR_NAME + i);
            String pattern = this.getConfig(CONFIG_PATTERN + i);
            if (pattern == null || pattern.equals("")) {
                pattern = " ";
            }
            int startpos = pattern.indexOf("$");
            int lastpos = pattern.lastIndexOf("$");
            String attrValue = pattern;
            if (!pattern.equals("") && startpos != -1 && startpos == 0 && lastpos != -1 && lastpos == pattern.length() - 1 && request != null) {
                try {
                    attrValue = this.mapPattern(request, pattern);
                }
                catch (IOException e) {
                    throw new EProfileException(e.toString());
                }
            }
            try {
                attributeConfig = new AttributeConfig(attrName, attrValue);
            }
            catch (EPropertyException e) {
                throw new EProfileException(e.toString());
            }
            Attribute attr = attributeConfig.mAttribute;
            if (attr == null) continue;
            attrs.addElement(attr);
        }
        if (attrs.size() > 0) {
            Object[] attrList = new Attribute[attrs.size()];
            attrs.copyInto(attrList);
            try {
                ext = new SubjectDirAttributesExtension((Attribute[])attrList, critical);
            }
            catch (IOException e) {
                throw new EProfileException(e.toString());
            }
        }
        return ext;
    }
}

