/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.request.CertReqParser;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.extensions.PresenceServerExtension;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProcessCertReq", urlPatterns={"/agent/ca/processCertReq"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caProcessCertReq"), @WebInitParam(name="resourceID", value="param-name"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr")})
public class ProcessCertReq
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ProcessCertReq.class);
    private static final long serialVersionUID = 812464895240811318L;
    private static final String SEQNUM = "seqNum";
    private static final String TPL_FILE = "processCertReq.template";
    private RequestQueue mQueue;
    private String mFormPath = null;
    private ReqParser mParser;
    private CAPublisherProcessor mPublisherProcessor;
    private boolean mExtraAgentParams = false;
    private static final String REQ_COMPLETED_TEMPLATE = "ra/RequestCompleted.template";
    private static final String PROP_REQ_COMPLETED_TEMPLATE = "requestCompletedTemplate";
    private static final String PROP_EXTRA_AGENT_PARAMS = "extraAgentParams";
    private String mReqCompletedTemplate = null;
    private String auditServiceID = "$Unidentified$";
    private static final String AGENT_CA_CLONE_ENROLLMENT_SERVLET = "caProcessCertReq";
    private static final String AGENT_RA_CLONE_ENROLLMENT_SERVLET = "raProcessCertReq";
    private static final String SIGNED_AUDIT_ACCEPTANCE = "accept";
    private static final String SIGNED_AUDIT_CANCELLATION = "cancel";
    private static final String SIGNED_AUDIT_CLONING = "clone";
    private static final String SIGNED_AUDIT_REJECTION = "reject";
    private static final String[] SIGNED_AUDIT_MANUAL_CANCELLATION_REASON = new String[]{"manual non-profile cert request cancellation:  request cannot be processed due to an authorization failure", "manual non-profile cert request cancellation:  no reason has been given for cancelling this cert request", "manual non-profile cert request cancellation:  indeterminate reason for inability to process cert request due to an EBaseException", "manual non-profile cert request cancellation:  indeterminate reason for inability to process cert request due to an IOException", "manual non-profile cert request cancellation:  indeterminate reason for inability to process cert request due to a CertificateException", "manual non-profile cert request cancellation:  indeterminate reason for inability to process cert request due to a NoSuchAlgorithmException"};
    private static final String[] SIGNED_AUDIT_MANUAL_REJECTION_REASON = new String[]{"manual non-profile cert request rejection:  request cannot be processed due to an authorization failure", "manual non-profile cert request rejection:  no reason has been given for rejecting this cert request", "manual non-profile cert request rejection:  indeterminate reason for inability to process cert request due to an EBaseException", "manual non-profile cert request rejection:  indeterminate reason for inability to process cert request due to an IOException", "manual non-profile cert request rejection:  indeterminate reason for inability to process cert request due to a CertificateException", "manual non-profile cert request rejection:  indeterminate reason for inability to process cert request due to a NoSuchAlgorithmException"};
    protected static final String GRANT_ERROR = "grantError";
    public static final String GRANT_TRUSTEDMGR_PRIVILEGE = "grantTrustedManagerPrivilege";
    public static final String GRANT_CMAGENT_PRIVILEGE = "grantCMAgentPrivilege";
    public static final String GRANT_RMAGENT_PRIVILEGE = "grantRMAgentPrivilege";
    public static final String GRANT_DRMAGENT_PRIVILEGE = "grantDRMAgentPrivilege";
    public static final String GRANT_UID = "grantUID";
    public static final String GRANT_PRIVILEGE = "grantPrivilege";

    public void init(ServletConfig sc) throws ServletException {
        block7: {
            super.init(sc);
            CAEngine engine = CAEngine.getInstance();
            String id = sc.getInitParameter("ID");
            if (id != null) {
                this.auditServiceID = !this.auditServiceID.equals(AGENT_CA_CLONE_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(AGENT_RA_CLONE_ENROLLMENT_SERVLET) ? "$Unidentified$" : id.trim();
            }
            this.mQueue = engine.getRequestQueue();
            this.mPublisherProcessor = engine.getPublisherProcessor();
            this.mFormPath = "/ca/processCertReq.template";
            this.mParser = CertReqParser.DETAIL_PARSER;
            this.mTemplates.remove(CMSRequest.SUCCESS);
            try {
                String tmp;
                this.mReqCompletedTemplate = sc.getInitParameter(PROP_REQ_COMPLETED_TEMPLATE);
                if (this.mReqCompletedTemplate == null) {
                    this.mReqCompletedTemplate = REQ_COMPLETED_TEMPLATE;
                }
                if ((tmp = sc.getInitParameter(PROP_EXTRA_AGENT_PARAMS)) != null && tmp.trim().equalsIgnoreCase("true")) {
                    this.mExtraAgentParams = true;
                    break block7;
                }
                this.mExtraAgentParams = false;
            }
            catch (Exception exception) {}
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        long startTime = new Date().getTime();
        String toDo = null;
        String subject = null;
        String signatureAlgorithm = null;
        long notValidBefore = 0L;
        long notValidAfter = 0L;
        BigInteger seqNum = BigInteger.ONE.negate();
        Throwable error = null;
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            String notValidAfterStr;
            String notValidBeforeStr;
            if (req.getParameter(SEQNUM) != null) {
                logger.debug("ProcessCertReq: parameter seqNum " + req.getParameter(SEQNUM));
                seqNum = new BigInteger(req.getParameter(SEQNUM));
            }
            if ((notValidBeforeStr = req.getParameter("notValidBefore")) != null && notValidBeforeStr.length() > 0) {
                notValidBefore = Long.parseLong(notValidBeforeStr);
                notValidBefore *= 1000L;
            }
            if ((notValidAfterStr = req.getParameter("notValidAfter")) != null && notValidAfterStr.length() > 0) {
                notValidAfter = Long.parseLong(notValidAfterStr);
                notValidAfter *= 1000L;
            }
            toDo = req.getParameter("toDo");
            subject = req.getParameter("subject");
            signatureAlgorithm = req.getParameter("signatureAlgorithm");
            Request r = null;
            if (seqNum.compareTo(BigInteger.ONE.negate()) > 0) {
                r = this.requestRepository.readRequest(new RequestId(seqNum));
            }
            if (seqNum.compareTo(BigInteger.ONE.negate()) > 0 && r != null) {
                this.processX509(cmsReq, argSet, header, seqNum, req, resp, toDo, signatureAlgorithm, subject, notValidBefore, notValidAfter, locale[0], startTime);
            } else {
                logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_REQUEST_ID_1", (Object[])new Object[]{seqNum.toString()}));
                error = new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_REQUEST_ID", (String[])new String[]{seqNum.toString()}));
            }
        }
        catch (EBaseException e) {
            error = e;
        }
        catch (NumberFormatException e) {
            logger.error("ProcessCertReq: " + e.getMessage(), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError((EBaseException)error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void processX509(CMSRequest cmsReq, CMSTemplateParams argSet, ArgBlock header, BigInteger seqNum, HttpServletRequest req, HttpServletResponse resp, String toDo, String signatureAlgorithm, String subject, long notValidBefore, long notValidAfter, Locale locale, long startTime) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = "$Unidentified$";
        String auditCertificateSubjectName = subject;
        String auditInfoName = this.auditInfoName(toDo);
        String id = null;
        auditCertificateSubjectName = auditCertificateSubjectName != null ? auditCertificateSubjectName.trim() : "<null>";
        try {
            Request r = this.requestRepository.readRequest(new RequestId(seqNum));
            if (r != null && (id = r.getRequestId().toString()) != null) {
                auditRequesterID = id.trim();
            }
            header.addStringValue("authorityid", "ca");
            if (toDo != null) {
                AuthToken authToken = this.authenticate(cmsReq);
                AuthzToken authzToken = null;
                try {
                    authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "execute");
                }
                catch (EAuthzAccessDenied e) {
                    logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (Exception e) {
                    logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (authzToken == null) {
                    cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                    if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                        auditor.log(auditMessage);
                    } else if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                    } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[0]));
                    } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[0]));
                    }
                    return;
                }
                String authMgr = "noAuthManager";
                if (authToken != null) {
                    authMgr = authToken.getInString("authMgrInstName");
                }
                String agentID = authToken.getInString("userid");
                String initiative = "fromAgent agentID: " + agentID;
                X509CertInfo[] certInfo = r.getExtDataInCertInfoArray("CERT_INFO");
                header.addStringValue("toDo", toDo);
                if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                    if (certInfo != null) {
                        int alterationCounter = 0;
                        for (int i = 0; i < certInfo.length; ++i) {
                            Date notBefore;
                            CertificateAlgorithmId certAlgId = (CertificateAlgorithmId)certInfo[i].get("algorithmID");
                            AlgorithmId algId = (AlgorithmId)certAlgId.get("algorithm");
                            if (!algId.getName().equals(signatureAlgorithm)) {
                                ++alterationCounter;
                                AlgorithmId newAlgId = AlgorithmId.get((String)signatureAlgorithm);
                                certInfo[i].set("algorithmID", (Object)new CertificateAlgorithmId(newAlgId));
                            }
                            CertificateSubjectName certSubject = (CertificateSubjectName)certInfo[i].get("subject");
                            if (subject != null && !certSubject.toString().equals(subject)) {
                                ++alterationCounter;
                                certInfo[i].set("subject", (Object)new CertificateSubjectName(new X500Name(subject)));
                            }
                            CertificateValidity certValidity = (CertificateValidity)certInfo[i].get("validity");
                            Date currentTime = new Date();
                            boolean validityChanged = false;
                            if (notValidBefore > 0L && ((notBefore = (Date)certValidity.get("notBefore")).getTime() == 0L || notBefore.getTime() != notValidBefore)) {
                                Date validFrom = new Date(notValidBefore);
                                notBefore = notValidBefore == 0L ? currentTime : validFrom;
                                certValidity.set("notBefore", (Object)notBefore);
                                validityChanged = true;
                            }
                            if (notValidAfter > 0L) {
                                Date validTo = new Date(notValidAfter);
                                Date notAfter = (Date)certValidity.get("notAfter");
                                if (notAfter.getTime() == 0L || notAfter.getTime() != notValidAfter) {
                                    notAfter = currentTime;
                                    notAfter = notValidAfter == 0L ? currentTime : validTo;
                                    certValidity.set("notAfter", (Object)notAfter);
                                    validityChanged = true;
                                }
                            }
                            if (validityChanged) {
                                certInfo[i].set("validity", (Object)certValidity);
                            }
                            if (certInfo[i].get("version") == null) {
                                certInfo[i].set("version", (Object)new CertificateVersion(2));
                            }
                            CertificateExtensions extensions = null;
                            try {
                                extensions = (CertificateExtensions)certInfo[i].get("extensions");
                            }
                            catch (Exception e) {
                                logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_PARSING_EXTENS", (Object[])new Object[]{e.toString()}), (Throwable)e);
                            }
                            String addExts = req.getParameter("addExts");
                            if (addExts != null && !addExts.trim().equals("")) {
                                Extension de;
                                Vector<Extension> extsToBeAdded = new Vector<Extension>();
                                byte[] b = Utils.base64decode((String)addExts);
                                try {
                                    DerValue b_der = new DerValue(b);
                                    while (b_der.data.available() != 0) {
                                        de = new Extension(b_der.data.getDerValue());
                                        extsToBeAdded.addElement(de);
                                    }
                                }
                                catch (IOException e) {
                                    de = new Extension(new DerValue(b));
                                    extsToBeAdded.addElement(de);
                                }
                                if (extsToBeAdded.size() > 0) {
                                    if (extensions == null) {
                                        extensions = new CertificateExtensions();
                                        certInfo[i].set("extensions", (Object)extensions);
                                    }
                                    for (int j = 0; j < extsToBeAdded.size(); ++j) {
                                        Extension theExt = (Extension)extsToBeAdded.elementAt(j);
                                        extensions.set(theExt.getExtensionId().toString(), (Object)theExt);
                                    }
                                }
                            }
                            if (extensions != null) {
                                String PSE_Enable;
                                try {
                                    NSCertTypeExtension nsExtensions = (NSCertTypeExtension)extensions.get("NSCertType");
                                    if (nsExtensions != null) {
                                        this.updateNSExtension(req, nsExtensions);
                                    }
                                }
                                catch (IOException e) {
                                    logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_PROCESS_NETSCAPE_EXTENSION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                }
                                String pathLength = req.getParameter("pathLenConstraint");
                                if (pathLength != null) {
                                    try {
                                        int pathLen = Integer.parseInt(pathLength);
                                        BasicConstraintsExtension bcExt = (BasicConstraintsExtension)extensions.get("BasicConstraints");
                                        if (bcExt != null) {
                                            Integer bcPathLen = (Integer)bcExt.get("path_len");
                                            Boolean isCA = (Boolean)bcExt.get("is_ca");
                                            if (bcPathLen != null && bcPathLen != pathLen && isCA != null) {
                                                BasicConstraintsExtension bcExt0 = new BasicConstraintsExtension(isCA.booleanValue(), pathLen);
                                                extensions.delete("BasicConstraints");
                                                extensions.set("BasicConstraints", (Object)bcExt0);
                                                ++alterationCounter;
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_PROCESS_CONSTRAINTS_EXTENSION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                    }
                                    catch (NumberFormatException e) {
                                        logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_PROCESS_CONSTRAINTS_EXTENSION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                    }
                                }
                                if ((PSE_Enable = req.getParameter("PSE_Enable")) != null) {
                                    String HostName;
                                    String IMID;
                                    String RFC822Name2;
                                    String TelephoneNumber;
                                    boolean Critical = req.getParameter("PSE_Critical") != null;
                                    int Version = 0;
                                    try {
                                        Version = Integer.parseInt(req.getParameter("PSE_Version"));
                                    }
                                    catch (Exception isCA) {
                                        // empty catch block
                                    }
                                    String StreetAddress = req.getParameter("PSE_StreetAddress");
                                    if (StreetAddress == null) {
                                        StreetAddress = "";
                                    }
                                    if ((TelephoneNumber = req.getParameter("PSE_TelephoneNumber")) == null) {
                                        TelephoneNumber = "";
                                    }
                                    if ((RFC822Name2 = req.getParameter("PSE_RFC822Name")) == null) {
                                        RFC822Name2 = "";
                                    }
                                    if ((IMID = req.getParameter("PSE_IMID")) == null) {
                                        IMID = "";
                                    }
                                    if ((HostName = req.getParameter("PSE_HostName")) == null) {
                                        HostName = "";
                                    }
                                    int PortNumber = 0;
                                    try {
                                        PortNumber = Integer.parseInt(req.getParameter("PSE_PortNumber"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    int MaxUsers = 0;
                                    try {
                                        MaxUsers = Integer.parseInt(req.getParameter("PSE_MaxUsers"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    int ServiceLevel = 0;
                                    try {
                                        ServiceLevel = Integer.parseInt(req.getParameter("PSE_ServiceLevel"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    PresenceServerExtension pseExt = new PresenceServerExtension(Critical, Version, StreetAddress, TelephoneNumber, RFC822Name2, IMID, HostName, PortNumber, MaxUsers, ServiceLevel);
                                    extensions.set(pseExt.getExtensionId().toString(), (Object)pseExt);
                                }
                                if (this.mExtraAgentParams) {
                                    Enumeration extraparams = req.getParameterNames();
                                    int l = "AGENT_PARAMS".length() + 1;
                                    int ap_counter = 0;
                                    Hashtable<String, String> agentparamsargblock = new Hashtable<String, String>();
                                    if (extraparams != null) {
                                        while (extraparams.hasMoreElements()) {
                                            String param_value;
                                            String s = (String)extraparams.nextElement();
                                            if (!s.startsWith("AGENT_PARAMS") || (param_value = req.getParameter(s)) == null) continue;
                                            String new_name = s.substring(l);
                                            agentparamsargblock.put(new_name, param_value);
                                            ++ap_counter;
                                        }
                                    }
                                    if (ap_counter > 0) {
                                        r.setExtData("AGENT_PARAMS", agentparamsargblock);
                                        ++alterationCounter;
                                    }
                                }
                                certInfo[i].set("extensions", (Object)extensions);
                            }
                            alterationCounter += this.updateExtensionsInRequest(req, r);
                        }
                        if (alterationCounter > 0) {
                            this.requestRepository.updateRequest(r);
                        }
                    }
                    this.mQueue.approveRequest(r);
                    if (r.getRequestStatus().equals((Object)RequestStatus.PENDING)) {
                        cmsReq.setResult((Object)r);
                        cmsReq.setStatus(CMSRequest.PENDING);
                        if (certInfo != null) {
                            for (i = 0; i < certInfo.length; ++i) {
                                logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "pending", certInfo[i].get("subject"), ""});
                            }
                        } else if (subject != null) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "pending", subject, ""});
                        } else {
                            logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "pending"});
                        }
                    } else if (r.getRequestStatus().equals((Object)RequestStatus.APPROVED) || r.getRequestStatus().equals((Object)RequestStatus.SVC_PENDING)) {
                        cmsReq.setResult((Object)r);
                        cmsReq.setStatus(CMSRequest.SVC_PENDING);
                        if (certInfo != null) {
                            for (i = 0; i < certInfo.length; ++i) {
                                logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, r.getRequestStatus(), certInfo[i].get("subject"), ""});
                            }
                        } else if (subject != null) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, r.getRequestStatus(), subject, ""});
                        } else {
                            logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, r.getRequestStatus()});
                        }
                    } else if (r.getRequestStatus().equals((Object)RequestStatus.COMPLETE)) {
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                        X509CertImpl[] issuedCerts = r.getExtDataInCertArray("issuedCerts");
                        if (issuedCerts != null) {
                            long endTime = new Date().getTime();
                            StringBuffer sbuf = new StringBuffer();
                            for (int i = 0; i < issuedCerts.length; ++i) {
                                if (i != 0) {
                                    sbuf.append(", ");
                                }
                                sbuf.append("0x" + issuedCerts[i].getSerialNumber().toString(16));
                                logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "completed", issuedCerts[i].getSubjectName(), "cert issued serial number: 0x" + issuedCerts[i].getSerialNumber().toString(16) + " time: " + (endTime - startTime)});
                                auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (X509CertImpl)issuedCerts[i]));
                            }
                            header.addStringValue("serialNumber", sbuf.toString());
                        } else {
                            if (subject != null) {
                                logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "completed", subject, ""});
                            } else {
                                logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "completed"});
                            }
                            auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                        }
                        try {
                            int res = this.grant_privileges(cmsReq, r, (X509Certificate[])issuedCerts, header);
                            if (res != 0) {
                                header.addStringValue(GRANT_ERROR, "SUCCESS");
                            }
                        }
                        catch (EBaseException e) {
                            header.addStringValue(GRANT_ERROR, e.toString());
                        }
                        cmsReq.setResult((Object)r);
                        String scheme = req.getScheme();
                        if (scheme.equals("http") && ProcessCertReq.connectionIsSSL((HttpServletRequest)req)) {
                            scheme = "https";
                        }
                        if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                            header.addStringValue("dirEnabled", "yes");
                            Integer[] ldapPublishStatus = r.getExtDataInIntegerArray("ldapPublishStatus");
                            int certsUpdated = 0;
                            if (ldapPublishStatus != null) {
                                for (int i = 0; i < ldapPublishStatus.length; ++i) {
                                    if (ldapPublishStatus[i] != Request.RES_SUCCESS) continue;
                                    ++certsUpdated;
                                }
                            }
                            header.addIntegerValue("certsUpdated", certsUpdated);
                        } else {
                            header.addStringValue("dirEnabled", "no");
                        }
                    }
                } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                    this.mQueue.rejectRequest(r);
                    if (certInfo != null) {
                        for (int i = 0; i < certInfo.length; ++i) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "rejected", certInfo[i].get("subject"), ""});
                        }
                    } else if (subject != null) {
                        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "rejected", subject, ""});
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "rejected"});
                    }
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[1]));
                } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                    this.mQueue.cancelRequest(r);
                    if (certInfo != null) {
                        for (int i = 0; i < certInfo.length; ++i) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "canceled", certInfo[i].get("subject"), ""});
                        }
                    } else if (subject != null) {
                        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "canceled", subject, ""});
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "canceled"});
                    }
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[1]));
                } else if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                    Request clonedRequest = this.mQueue.cloneAndMarkPending(r);
                    header.addStringValue("clonedRequestId", clonedRequest.getRequestId().toString());
                    if (certInfo != null) {
                        for (int i = 0; i < certInfo.length; ++i) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "cloned to reqID: " + clonedRequest.getRequestId().toString(), certInfo[i].get("subject"), ""});
                        }
                    } else if (subject != null) {
                        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "cloned to reqID: " + clonedRequest.getRequestId().toString(), subject, ""});
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{r.getRequestType(), r.getRequestId(), initiative, authMgr, "cloned to reqID: " + clonedRequest.getRequestId().toString()});
                    }
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Success", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                    auditor.log(auditMessage);
                }
            }
            if (engine.getSubsystem("ca") != null) {
                header.addStringValue("localca", "yes");
            }
            header.addBigIntegerValue(SEQNUM, seqNum, 10);
            this.mParser.fillRequestIntoArg(locale, r, argSet, header);
            String rid = r.getExtDataInString("remoteReqID");
            if (rid != null) {
                header.addStringValue("remoteReqID", rid);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_IO_ERROR_REMOTE_REQUEST", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (toDo != null) {
                if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                    auditor.log(auditMessage);
                } else if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[2]));
                } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[2]));
                }
            }
            throw e;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_IO_ERROR_REMOTE_REQUEST", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (toDo != null) {
                if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                    auditor.log(auditMessage);
                } else if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[3]));
                } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[3]));
                }
            }
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCODING_ISSUED_CERT_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_IO_ERROR_REMOTE_REQUEST", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (toDo != null) {
                if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                    auditor.log(auditMessage);
                } else if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[4]));
                } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[4]));
                }
            }
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCODING_ISSUED_CERT_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_IO_ERROR_REMOTE_REQUEST", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (toDo != null) {
                if (toDo.equals(SIGNED_AUDIT_CLONING)) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                    auditor.log(auditMessage);
                } else if (toDo.equals(SIGNED_AUDIT_ACCEPTANCE)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)"<null>"));
                } else if (toDo.equals(SIGNED_AUDIT_CANCELLATION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_CANCELLATION_REASON[5]));
                } else if (toDo.equals(SIGNED_AUDIT_REJECTION)) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)auditInfoName, (String)SIGNED_AUDIT_MANUAL_REJECTION_REASON[5]));
                }
            }
            throw new EBaseException(CMS.getUserMessage((Locale)locale, (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    private void updateNSExtension(HttpServletRequest req, NSCertTypeExtension ext) throws IOException {
        try {
            if (req.getParameter("certTypeSSLServer") == null) {
                ext.set("ssl_server", (Object)false);
            } else {
                ext.set("ssl_server", (Object)true);
            }
            if (req.getParameter("certTypeSSLClient") == null) {
                ext.set("ssl_client", (Object)false);
            } else {
                ext.set("ssl_client", (Object)true);
            }
            if (req.getParameter("certTypeEmail") == null) {
                ext.set("email", (Object)false);
            } else {
                ext.set("email", (Object)true);
            }
            if (req.getParameter("certTypeObjSigning") == null) {
                ext.set("object_signing", (Object)false);
            } else {
                ext.set("object_signing", (Object)true);
            }
            if (req.getParameter("certTypeEmailCA") == null) {
                ext.set("email_ca", (Object)false);
            } else {
                ext.set("email_ca", (Object)true);
            }
            if (req.getParameter("certTypeSSLCA") == null) {
                ext.set("ssl_ca", (Object)false);
            } else {
                ext.set("ssl_ca", (Object)true);
            }
            if (req.getParameter("certTypeObjSigningCA") == null) {
                ext.set("object_signing_ca", (Object)false);
            } else {
                ext.set("object_signing_ca", (Object)true);
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    private int updateExtensionsInRequest(HttpServletRequest req, Request r) {
        int nChanges = 0;
        if (req.getParameter("certTypeSSLServer") != null) {
            r.setExtData("ssl_server", "true");
            ++nChanges;
        } else {
            r.deleteExtData("ssl_server");
            ++nChanges;
        }
        if (req.getParameter("certTypeSSLClient") != null) {
            r.setExtData("ssl_client", "true");
            ++nChanges;
        } else {
            r.deleteExtData("ssl_client");
            ++nChanges;
        }
        if (req.getParameter("certTypeEmail") != null) {
            r.setExtData("email", "true");
            ++nChanges;
        } else {
            r.deleteExtData("email");
            ++nChanges;
        }
        if (req.getParameter("certTypeObjSigning") != null) {
            r.setExtData("object_signing", "true");
            ++nChanges;
        } else {
            r.deleteExtData("object_signing");
            ++nChanges;
        }
        if (req.getParameter("certTypeEmailCA") != null) {
            r.setExtData("email_ca", "true");
            ++nChanges;
        } else {
            r.deleteExtData("email_ca");
            ++nChanges;
        }
        if (req.getParameter("certTypeSSLCA") != null) {
            r.setExtData("ssl_ca", "true");
            ++nChanges;
        } else {
            r.deleteExtData("ssl_ca");
            ++nChanges;
        }
        if (req.getParameter("certTypeObjSigningCA") != null) {
            r.setExtData("object_signing_ca", "true");
            ++nChanges;
        } else {
            r.deleteExtData("object_signing_ca");
            ++nChanges;
        }
        return nChanges;
    }

    protected int grant_privileges(CMSRequest cmsReq, Request req, X509Certificate[] certs, ArgBlock header) throws EBaseException {
        ArgBlock httpParams = cmsReq.getHttpParams();
        boolean grantTrustedMgr = httpParams.getValueAsBoolean(GRANT_TRUSTEDMGR_PRIVILEGE, false);
        boolean grantRMAgent = httpParams.getValueAsBoolean(GRANT_RMAGENT_PRIVILEGE, false);
        boolean grantCMAgent = httpParams.getValueAsBoolean(GRANT_CMAGENT_PRIVILEGE, false);
        boolean grantDRMAgent = httpParams.getValueAsBoolean(GRANT_DRMAGENT_PRIVILEGE, false);
        if (!(grantTrustedMgr || grantCMAgent || grantRMAgent || grantDRMAgent)) {
            return 0;
        }
        AuthToken authToken = this.getAuthToken(req);
        AuthzToken authzToken = null;
        String resourceName = "certServer.ca.group";
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, resourceName, "add");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            String[] obj = new String[]{grantTrustedMgr ? "Trusted Managers" : (grantRMAgent ? "Registration Manager Agents" : (grantCMAgent ? "Certificate Manager Agents" : (grantDRMAgent ? "Data Recovery Manager Agents" : "unknown group")))};
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_UNAUTHORIZED_CREATE_GROUP", (String[])new String[]{obj[0]}));
        }
        String uid = httpParams.getValueAsString(GRANT_UID, null);
        if (uid == null || uid.length() == 0) {
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_GRANT_UID", (String[])new String[0]));
        }
        header.addStringValue(GRANT_UID, uid);
        String groupname = null;
        String groupname1 = null;
        String userType = "";
        if (grantTrustedMgr) {
            groupname = "Trusted Managers";
            userType = "subsystemType";
        } else {
            if (grantCMAgent) {
                groupname = "Certificate Manager Agents";
            } else if (grantRMAgent) {
                groupname = "Registration Manager Agents";
            }
            if (grantDRMAgent) {
                if (groupname != null) {
                    groupname1 = "Data Recovery Manager Agents";
                } else {
                    groupname = "Data Recovery Manager Agents";
                }
            }
            userType = "agentType";
        }
        String privilege = groupname1 == null ? groupname : groupname + " and " + groupname1;
        header.addStringValue(GRANT_PRIVILEGE, privilege);
        CAEngine engine = CAEngine.getInstance();
        UGSubsystem ug = engine.getUGSubsystem();
        User user = ug.createUser(uid);
        user.setFullName(uid);
        user.setEmail("");
        user.setPhone("");
        user.setPassword("");
        user.setUserType(userType);
        user.setState("1");
        Group group = ug.findGroup(groupname);
        Group group1 = null;
        if (group == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_FIND_GROUP_1", (Object[])new Object[]{groupname}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_FIND_GROUP_ERROR", (String[])new String[]{groupname}));
        }
        if (groupname1 != null && (group1 = ug.findGroup(groupname1)) == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_FIND_GROUP_1", (Object[])new Object[]{groupname}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_FIND_GROUP_ERROR", (String[])new String[]{groupname1}));
        }
        try {
            ug.addUser(user);
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_ADDING_USER_1", (Object[])new Object[]{uid}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ADDING_USER_ERROR", (String[])new String[]{uid}), e);
        }
        try {
            user.setX509Certificates(certs);
            ug.addUserCert(uid, certs[0]);
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_ADDING_CERT_1", (Object[])new Object[]{uid}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ADDING_CERT_ERROR", (String[])new String[]{uid}), e);
        }
        try {
            group.addMemberName(uid);
            ug.modifyGroup(group);
            SessionContext sContext = SessionContext.getContext();
            String adminId = (String)sContext.get((Object)"userid");
            logger.info("Admin UID: {} added User UID: {} to group: {}", new Object[]{adminId, uid, groupname});
            if (group1 != null) {
                group1.addMemberName(uid);
                ug.modifyGroup(group1);
                logger.info("Admin UID: {} added User UID: {} to group: {}", new Object[]{adminId, uid, groupname1});
            }
        }
        catch (Exception e) {
            String msg = "Could not add user " + uid + " to group " + groupname;
            if (group1 != null) {
                msg = msg + " or group " + groupname1;
            }
            logger.error(msg + ": " + e.getMessage(), (Throwable)e);
            if (group1 == null) {
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ADDING_MEMBER", (String[])new String[]{uid, groupname}), e);
            }
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ADDING_MEMBER_1", (String[])new String[]{uid, groupname, groupname1}), e);
        }
        return 1;
    }

    private String auditInfoName(String type) {
        String infoName = "$Unidentified$";
        if (type != null) {
            if ((type = type.trim()).equals(SIGNED_AUDIT_ACCEPTANCE)) {
                infoName = "certificate";
            } else if (type.equals(SIGNED_AUDIT_CANCELLATION)) {
                infoName = "cancelReason";
            } else if (type.equals(SIGNED_AUDIT_REJECTION)) {
                infoName = "rejectReason";
            }
        }
        return infoName;
    }
}

