/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class ESTBackendConfig {
    private String className = null;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public Collection<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Collection<String> getParameterNames(String parent) {
        String prefix = parent + ".";
        int length = prefix.length();
        return this.parameters.keySet().stream().filter(name -> name.startsWith(prefix)).map(name -> name.substring(length)).collect(Collectors.toSet());
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public static ESTBackendConfig fromProperties(Properties props) throws Exception {
        ESTBackendConfig config = new ESTBackendConfig();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.equals("class")) {
                config.setClassName(value);
                continue;
            }
            config.setParameter(key, value);
        }
        if (config.getClassName() == null) {
            throw new RuntimeException("ESTBackendConfig: missing 'class' property");
        }
        return config;
    }
}

