/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCLI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCreateCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCreateCLI.class);
    public NSSCLI nssCLI;

    public NSSCreateCLI(NSSCLI nssCLI) {
        super("create", "Create NSS database", (CLI)nssCLI);
        this.nssCLI = nssCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        this.options.addOption(null, "force", false, "Force creation.");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified");
        }
        MainCLI mainCLI = this.nssCLI.mainCLI;
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        if (nssdb.exists()) {
            boolean force = cmd.hasOption("force");
            if (!force) {
                System.out.println("NSS database already exists in " + nssdb.getPath() + ".");
                System.out.print("Overwrite (y/N)? ");
                System.out.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String line = reader.readLine().trim();
                if (line.equals("") || !line.substring(0, 1).equalsIgnoreCase("Y")) {
                    return;
                }
            }
            nssdb.delete();
        }
        nssdb.create();
    }
}

