/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.base;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.netscape.certsrv.base.PKIExceptionDeserializer;
import com.netscape.certsrv.base.PKIExceptionSerializer;
import com.netscape.certsrv.base.RESTMessage;
import java.io.StringReader;
import java.io.StringWriter;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PKIException
extends RuntimeException {
    private static final long serialVersionUID = 6000910362260369923L;
    public int code;

    public PKIException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public PKIException(Response.Status status) {
        this(status, status.getReasonPhrase(), null);
    }

    public PKIException(String message) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message, null);
    }

    public PKIException(int code, String message) {
        this(code, message, null);
    }

    public PKIException(Response.Status status, String message) {
        this(status.getStatusCode(), message, null);
    }

    public PKIException(Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), cause.getMessage(), cause);
    }

    public PKIException(String message, Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message, cause);
    }

    public PKIException(Response.Status status, String message, Throwable cause) {
        this(status.getStatusCode(), message, cause);
    }

    public PKIException(Data data) {
        this(data.code, data.message, null);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Data getData() {
        Data data = new Data();
        data.className = this.getClass().getName();
        data.code = this.code;
        data.message = this.getMessage();
        return data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonSerialize(using=PKIExceptionSerializer.class)
    @JsonDeserialize(using=PKIExceptionDeserializer.class)
    public static class Data
    extends RESTMessage {
        public int code;
        public String message;

        @Override
        public Element toDOM(Document document) {
            Element element = document.createElement("PKIException");
            this.toDOM(document, element);
            Element codeElement = document.createElement("Code");
            codeElement.appendChild(document.createTextNode(Integer.toString(this.code)));
            element.appendChild(codeElement);
            if (this.message != null) {
                Element messageElement = document.createElement("Message");
                messageElement.appendChild(document.createTextNode(this.message));
                element.appendChild(messageElement);
            }
            return element;
        }

        public static Data fromDOM(Element element) {
            NodeList messageList;
            Data data = new Data();
            Data.fromDOM(element, data);
            NodeList codeList = element.getElementsByTagName("Code");
            if (codeList.getLength() > 0) {
                String value = codeList.item(0).getTextContent();
                data.code = Integer.parseInt(value);
            }
            if ((messageList = element.getElementsByTagName("Message")).getLength() > 0) {
                String value;
                data.message = value = messageList.item(0).getTextContent();
            }
            return data;
        }

        @Override
        public String toXML() throws Exception {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = this.toDOM(document);
            document.appendChild(element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource domSource = new DOMSource(document);
            StringWriter sw = new StringWriter();
            StreamResult streamResult = new StreamResult(sw);
            transformer.transform(domSource, streamResult);
            return sw.toString();
        }

        public static Data fromXML(String xml) throws Exception {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            Element element = document.getDocumentElement();
            return Data.fromDOM(element);
        }
    }
}

