/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.profile.ProfileOutput;
import com.netscape.certsrv.property.Descriptor;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertEnrollmentRequest
extends RESTMessage {
    private static final String PROFILE_ID = "profileId";
    private static final String RENEWAL = "renewal";
    private static final String SERIAL_NUM = "serial_num";
    private static final String SERVERSIDE_KEYGEN_P12_PASSWD = "serverSideKeygenP12Passwd";
    @JsonProperty(value="ProfileID")
    protected String profileId;
    @JsonProperty(value="ServerSideKeygenP12Passwd")
    protected String serverSideKeygenP12Passwd;
    @JsonProperty(value="Renewal")
    protected boolean renewal;
    @JsonProperty(value="SerialNumber")
    protected CertId serialNum;
    @JsonProperty(value="RemoteHost")
    protected String remoteHost;
    @JsonProperty(value="RemoteAddress")
    protected String remoteAddr;
    @JsonProperty(value="Input")
    protected Collection<ProfileInput> inputs = new ArrayList<ProfileInput>();
    @JsonProperty(value="Output")
    protected Collection<ProfileOutput> outputs = new ArrayList<ProfileOutput>();

    public CertEnrollmentRequest() {
    }

    public CertEnrollmentRequest(MultivaluedMap<String, String> form) {
        this.profileId = (String)form.getFirst((Object)PROFILE_ID);
        String renewalStr = (String)form.getFirst((Object)RENEWAL);
        this.serialNum = new CertId((String)form.getFirst((Object)SERIAL_NUM));
        this.renewal = Boolean.valueOf(renewalStr);
        this.serverSideKeygenP12Passwd = (String)form.getFirst((Object)SERVERSIDE_KEYGEN_P12_PASSWD);
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getServerSideKeygenP12Passwd() {
        return this.serverSideKeygenP12Passwd;
    }

    public void setServerSideKeygenP12Passwd(String serverSideKeygenP12Passwd) {
        this.serverSideKeygenP12Passwd = serverSideKeygenP12Passwd;
    }

    public boolean isRenewal() {
        return this.renewal;
    }

    public void setRenewal(boolean renewal) {
        this.renewal = renewal;
    }

    public void addInput(ProfileInput input) {
        ProfileInput curInput = this.getInput(input.getName());
        if (curInput != null) {
            this.inputs.remove(curInput);
        }
        this.inputs.add(input);
    }

    public void deleteInput(ProfileInput input) {
        ProfileInput curInput = this.getInput(input.getName());
        if (curInput != null) {
            this.inputs.remove(curInput);
        }
    }

    public ProfileInput createInput(String name) {
        ProfileInput oldInput = this.getInput(name);
        if (oldInput != null) {
            return oldInput;
        }
        ProfileInput newInput = new ProfileInput();
        newInput.setName(name);
        this.inputs.add(newInput);
        return newInput;
    }

    public ProfileInput getInput(String name) {
        return this.getInputByName(name);
    }

    public ProfileInput getInputByName(String name) {
        for (ProfileInput input : this.inputs) {
            if (!input.getName().equals(name)) continue;
            return input;
        }
        return null;
    }

    public ProfileInput getInputByID(String id) {
        for (ProfileInput input : this.inputs) {
            if (!input.getId().equals(id)) continue;
            return input;
        }
        return null;
    }

    public void addOutput(ProfileOutput output) {
        ProfileOutput curOutput = this.getOutput(output.getName());
        if (curOutput != null) {
            this.outputs.remove(curOutput);
        }
        this.outputs.add(output);
    }

    public void deleteOutput(ProfileOutput output) {
        ProfileOutput curOutput = this.getOutput(output.getName());
        if (curOutput != null) {
            this.outputs.remove(curOutput);
        }
    }

    public ProfileOutput getOutput(String name) {
        return this.getOutputByName(name);
    }

    public ProfileOutput getOutputByName(String name) {
        for (ProfileOutput output : this.outputs) {
            if (!output.getName().equals(name)) continue;
            return output;
        }
        return null;
    }

    public ProfileOutput getOutputByID(String id) {
        for (ProfileOutput output : this.outputs) {
            if (!output.getId().equals(id)) continue;
            return output;
        }
        return null;
    }

    public HashMap<String, String> toParams() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("isRenewal", Boolean.valueOf(this.renewal).toString());
        if (this.profileId != null) {
            ret.put(PROFILE_ID, this.profileId);
        }
        if (this.serialNum != null) {
            ret.put(SERIAL_NUM, this.serialNum.toHexString());
        }
        if (this.remoteHost != null) {
            ret.put("remoteHost", this.remoteHost);
        }
        if (this.remoteAddr != null) {
            ret.put("remoteAddr", this.remoteAddr);
        }
        if (this.serverSideKeygenP12Passwd != null) {
            ret.put(SERVERSIDE_KEYGEN_P12_PASSWD, this.serverSideKeygenP12Passwd);
        }
        for (ProfileInput input : this.inputs) {
            for (ProfileAttribute attr : input.getAttributes()) {
                ret.put(attr.getName(), attr.getValue());
            }
        }
        return ret;
    }

    public CertId getSerialNum() {
        return this.serialNum;
    }

    public void setSerialNum(CertId serialNum) {
        this.serialNum = serialNum;
    }

    public Collection<ProfileInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<ProfileInput> inputs) {
        this.inputs.clear();
        this.inputs.addAll(inputs);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public Collection<ProfileOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<ProfileOutput> outputs) {
        this.outputs.clear();
        this.outputs.addAll(outputs);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + (this.outputs == null ? 0 : this.outputs.hashCode());
        result = 31 * result + (this.profileId == null ? 0 : this.profileId.hashCode());
        result = 31 * result + (this.remoteAddr == null ? 0 : this.remoteAddr.hashCode());
        result = 31 * result + (this.remoteHost == null ? 0 : this.remoteHost.hashCode());
        result = 31 * result + (this.renewal ? 1231 : 1237);
        result = 31 * result + (this.serialNum == null ? 0 : this.serialNum.hashCode());
        result = 31 * result + (this.serverSideKeygenP12Passwd == null ? 0 : this.serverSideKeygenP12Passwd.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertEnrollmentRequest other = (CertEnrollmentRequest)obj;
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        if (this.outputs == null ? other.outputs != null : !this.outputs.equals(other.outputs)) {
            return false;
        }
        if (this.profileId == null ? other.profileId != null : !this.profileId.equals(other.profileId)) {
            return false;
        }
        if (this.remoteAddr == null ? other.remoteAddr != null : !this.remoteAddr.equals(other.remoteAddr)) {
            return false;
        }
        if (this.remoteHost == null ? other.remoteHost != null : !this.remoteHost.equals(other.remoteHost)) {
            return false;
        }
        if (this.renewal != other.renewal) {
            return false;
        }
        if (this.serialNum == null ? other.serialNum != null : !this.serialNum.equals(other.serialNum)) {
            return false;
        }
        return !(this.serverSideKeygenP12Passwd == null ? other.serverSideKeygenP12Passwd != null : !this.serverSideKeygenP12Passwd.equals(other.serverSideKeygenP12Passwd));
    }

    @Override
    public void toDOM(Document document, Element certEnrollmentRequestElement) {
        super.toDOM(document, certEnrollmentRequestElement);
        if (this.getProfileId() != null && !this.getProfileId().isEmpty()) {
            Element profileIdElement = document.createElement("ProfileID");
            profileIdElement.appendChild(document.createTextNode(this.getProfileId()));
            certEnrollmentRequestElement.appendChild(profileIdElement);
        }
        if (this.getServerSideKeygenP12Passwd() != null && !this.getServerSideKeygenP12Passwd().isEmpty()) {
            Element getServerSideKeygenP12PasswdElement = document.createElement("ServerSideKeygenP12Passwd");
            getServerSideKeygenP12PasswdElement.appendChild(document.createTextNode(this.getServerSideKeygenP12Passwd()));
            certEnrollmentRequestElement.appendChild(getServerSideKeygenP12PasswdElement);
        }
        Element renewalElement = document.createElement("Renewal");
        renewalElement.appendChild(document.createTextNode(String.valueOf(this.isRenewal())));
        certEnrollmentRequestElement.appendChild(renewalElement);
        if (this.getSerialNum() != null) {
            Element serialNumberElement = document.createElement("SerialNumber");
            serialNumberElement.appendChild(document.createTextNode(this.getSerialNum().toHexString()));
            certEnrollmentRequestElement.appendChild(serialNumberElement);
        }
        if (this.getRemoteHost() != null) {
            Element remoteHostElement = document.createElement("RemoteHost");
            remoteHostElement.appendChild(document.createTextNode(this.getRemoteHost()));
            certEnrollmentRequestElement.appendChild(remoteHostElement);
        }
        if (this.getRemoteAddr() != null) {
            Element remoteAddressElement = document.createElement("RemoteAddress");
            remoteAddressElement.appendChild(document.createTextNode(this.getRemoteAddr()));
            certEnrollmentRequestElement.appendChild(remoteAddressElement);
        }
        for (ProfileInput input : this.getInputs()) {
            certEnrollmentRequestElement.appendChild(input.toDOM(document));
        }
        for (ProfileOutput output : this.getOutputs()) {
            Element outputElement = document.createElement("Output");
            output.toDOM(document, outputElement);
            certEnrollmentRequestElement.appendChild(outputElement);
        }
    }

    @Override
    public Element toDOM(Document document) {
        Element certEnrollmentRequestElement = document.createElement("CertEnrollmentRequest");
        this.toDOM(document, certEnrollmentRequestElement);
        return certEnrollmentRequestElement;
    }

    public static void fromDOM(Element certEnrollmentRequestElement, CertEnrollmentRequest certEnrollmentRequest) {
        NodeList remoteHostAddressList;
        NodeList remoteHostList;
        NodeList serialNumberList;
        NodeList renewalList;
        NodeList serverSideKeygenP12PasswdList;
        RESTMessage.fromDOM(certEnrollmentRequestElement, certEnrollmentRequest);
        NodeList profileIdList = certEnrollmentRequestElement.getElementsByTagName("ProfileID");
        if (profileIdList.getLength() > 0) {
            String value = profileIdList.item(0).getTextContent();
            certEnrollmentRequest.setProfileId(value);
        }
        if ((serverSideKeygenP12PasswdList = certEnrollmentRequestElement.getElementsByTagName("ServerSideKeygenP12Passwd")).getLength() > 0) {
            String value = serverSideKeygenP12PasswdList.item(0).getTextContent();
            certEnrollmentRequest.setServerSideKeygenP12Passwd(value);
        }
        if ((renewalList = certEnrollmentRequestElement.getElementsByTagName("Renewal")).getLength() > 0) {
            String value = renewalList.item(0).getTextContent();
            certEnrollmentRequest.setRenewal(Boolean.valueOf(value));
        }
        if ((serialNumberList = certEnrollmentRequestElement.getElementsByTagName("SerialNumber")).getLength() > 0) {
            String value = serialNumberList.item(0).getTextContent();
            certEnrollmentRequest.setSerialNum(new CertId(value));
        }
        if ((remoteHostList = certEnrollmentRequestElement.getElementsByTagName("RemoteHost")).getLength() > 0) {
            String value = remoteHostList.item(0).getTextContent();
            certEnrollmentRequest.setRemoteHost(value);
        }
        if ((remoteHostAddressList = certEnrollmentRequestElement.getElementsByTagName("RemoteAddress")).getLength() > 0) {
            String value = remoteHostAddressList.item(0).getTextContent();
            certEnrollmentRequest.setRemoteAddr(value);
        }
        NodeList inputList = certEnrollmentRequestElement.getElementsByTagName("Input");
        for (int i = 0; i < inputList.getLength(); ++i) {
            Element inputElement = (Element)inputList.item(i);
            ProfileInput profileInput = new ProfileInput();
            NodeList nameList = inputElement.getElementsByTagName("Name");
            if (nameList.getLength() > 0) {
                String name = nameList.item(0).getTextContent();
                profileInput.setName(name);
            }
            NodeList attributeList = inputElement.getElementsByTagName("Attribute");
            for (int o = 0; o < attributeList.getLength(); ++o) {
                NodeList descriptorList;
                NodeList valueList;
                Element attributeElement = (Element)attributeList.item(o);
                ProfileAttribute profileAttribute = new ProfileAttribute();
                String attributeId = attributeElement.getAttribute("name");
                profileAttribute.setName(attributeId);
                NodeList attributeNameList = attributeElement.getElementsByTagName("Name");
                if (attributeNameList.getLength() > 0) {
                    String value = attributeNameList.item(0).getTextContent();
                    profileAttribute.setValue(value);
                }
                if ((valueList = attributeElement.getElementsByTagName("Value")).getLength() > 0) {
                    String value = valueList.item(0).getTextContent();
                    profileAttribute.setValue(value);
                }
                if ((descriptorList = attributeElement.getElementsByTagName("Descriptor")).getLength() > 0) {
                    Element descriptorElement = (Element)descriptorList.item(0);
                    Descriptor descriptor = Descriptor.fromDOM(descriptorElement);
                    profileAttribute.setDescriptor(descriptor);
                }
                profileInput.addAttribute(profileAttribute);
            }
            certEnrollmentRequest.addInput(profileInput);
        }
        NodeList outputList = certEnrollmentRequestElement.getElementsByTagName("Output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element outputElement = (Element)outputList.item(i);
            ProfileOutput output = ProfileOutput.fromDOM(outputElement);
            certEnrollmentRequest.addOutput(output);
        }
    }

    public static CertEnrollmentRequest fromDOM(Element element) {
        CertEnrollmentRequest certEnrollmentRequest = new CertEnrollmentRequest();
        CertEnrollmentRequest.fromDOM(element, certEnrollmentRequest);
        return certEnrollmentRequest;
    }

    @Override
    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CertEnrollmentRequest fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element profileElement = document.getDocumentElement();
        return CertEnrollmentRequest.fromDOM(profileElement);
    }
}

