/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileParameter;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PolicyDefault
implements JSONSerializer {
    private String name;
    private String classId;
    private String text;
    private List<ProfileAttribute> attributes = new ArrayList<ProfileAttribute>();
    private List<ProfileParameter> params = new ArrayList<ProfileParameter>();

    public void addAttribute(ProfileAttribute attr) {
        this.attributes.add(attr);
    }

    public void addParameter(ProfileParameter param) {
        this.params.add(param);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public List<ProfileAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ProfileAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<ProfileParameter> getParams() {
        return this.params;
    }

    public void setParams(List<ProfileParameter> params) {
        this.params = params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.classId == null ? 0 : this.classId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolicyDefault other = (PolicyDefault)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.classId == null ? other.classId != null : !this.classId.equals(other.classId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public Element toDOM(Document document) {
        Element valueElement;
        Element pdElement = document.createElement("policyDefault");
        pdElement.setAttribute("id", this.name);
        pdElement.setAttribute("classId", this.classId);
        if (this.text != null) {
            Element descriptionElement = document.createElement("description");
            descriptionElement.appendChild(document.createTextNode(this.text));
            pdElement.appendChild(descriptionElement);
        }
        for (ProfileAttribute attribute : this.attributes) {
            Descriptor descriptor;
            Element attributeElement = document.createElement("policyAttribute");
            if (attribute.getName() != null) {
                attributeElement.setAttribute("name", attribute.getName());
            }
            if (attribute.getValue() != null) {
                valueElement = document.createElement("Value");
                valueElement.appendChild(document.createTextNode(attribute.getValue()));
                attributeElement.appendChild(valueElement);
            }
            if ((descriptor = attribute.getDescriptor()) != null) {
                Element descriptorElement = descriptor.toDOM(document);
                attributeElement.appendChild(descriptorElement);
            }
            pdElement.appendChild(attributeElement);
        }
        for (ProfileParameter param : this.params) {
            Element parameterElement = document.createElement("params");
            if (param.getName() != null) {
                parameterElement.setAttribute("name", param.getName());
            }
            if (param.getValue() != null) {
                valueElement = document.createElement("value");
                valueElement.appendChild(document.createTextNode(param.getValue()));
                parameterElement.appendChild(valueElement);
            }
            pdElement.appendChild(parameterElement);
        }
        return pdElement;
    }

    public static PolicyDefault fromDOM(Element policyDefaultElement) {
        PolicyDefault policyDefault = new PolicyDefault();
        policyDefault.setName(policyDefaultElement.getAttribute("id"));
        policyDefault.setClassId(policyDefaultElement.getAttribute("classId"));
        NodeList descriptionList = policyDefaultElement.getElementsByTagName("description");
        if (descriptionList.getLength() > 0) {
            policyDefault.setText(descriptionList.item(0).getTextContent());
        }
        NodeList paList = policyDefaultElement.getElementsByTagName("policyAttribute");
        int paCount = paList.getLength();
        for (int i = 0; i < paCount; ++i) {
            Element paElement = (Element)paList.item(i);
            ProfileAttribute pa = ProfileAttribute.fromDOM(paElement);
            policyDefault.addAttribute(pa);
        }
        NodeList ppList = policyDefaultElement.getElementsByTagName("params");
        int ppCount = ppList.getLength();
        for (int i = 0; i < ppCount; ++i) {
            Element ppElement = (Element)ppList.item(i);
            ProfileParameter pp = ProfileParameter.fromDOM(ppElement);
            policyDefault.addParameter(pp);
        }
        return policyDefault;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element pdElement = this.toDOM(document);
        document.appendChild(pdElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static PolicyDefault fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element profileParameterElement = document.getDocumentElement();
        return PolicyDefault.fromDOM(profileParameterElement);
    }
}

