/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.system;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.certsrv.system.SecurityDomainSubsystem;
import com.netscape.certsrv.util.JSONSerializer;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DomainInfo
implements JSONSerializer {
    @JsonProperty(value="id")
    String name;
    @JsonProperty(value="subsystems")
    Map<String, SecurityDomainSubsystem> subsystems = new LinkedHashMap<String, SecurityDomainSubsystem>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, SecurityDomainSubsystem> getSubsystems() {
        return this.subsystems;
    }

    public void setSubsystems(Map<String, SecurityDomainSubsystem> subsystems) {
        this.subsystems.clear();
        this.subsystems.putAll(subsystems);
    }

    public SecurityDomainSubsystem[] getSubsystemArray() {
        return this.subsystems.values().toArray(new SecurityDomainSubsystem[this.subsystems.size()]);
    }

    public void setSubsystemArray(SecurityDomainSubsystem[] subsystems) {
        this.subsystems.clear();
        for (SecurityDomainSubsystem subsystem : subsystems) {
            this.subsystems.put(subsystem.name, subsystem);
        }
    }

    public SecurityDomainSubsystem getSubsystem(String type) {
        return this.subsystems.get(type);
    }

    public void addSubsystem(SecurityDomainSubsystem subsystem) {
        this.subsystems.put(subsystem.getName(), subsystem);
    }

    public void removeSubsystem(String type) {
        this.subsystems.remove(type);
    }

    public void addHost(String type, SecurityDomainHost host) {
        SecurityDomainSubsystem subsystem = this.getSubsystem(type);
        if (subsystem == null) {
            subsystem = new SecurityDomainSubsystem();
            subsystem.setName(type);
            this.addSubsystem(subsystem);
        }
        subsystem.addHost(host);
    }

    public void removeHost(String type, String hostId) {
        SecurityDomainSubsystem subsystem = this.getSubsystem(type);
        if (subsystem == null) {
            return;
        }
        subsystem.removeHost(hostId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.subsystems == null ? 0 : this.subsystems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainInfo other = (DomainInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.subsystems == null ? other.subsystems != null : !this.subsystems.equals(other.subsystems));
    }
}

