/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.http;

import com.netscape.cmsutil.http.HttpRequest;
import com.netscape.cmsutil.http.HttpResponse;
import com.netscape.cmsutil.net.ISocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class HttpClient {
    protected ISocketFactory mFactory = null;
    protected Socket mSocket = null;
    protected InputStream mInputStream = null;
    protected OutputStream mOutputStream = null;
    protected InputStreamReader mInputStreamReader = null;
    protected OutputStreamWriter mOutputStreamWriter = null;
    protected BufferedReader mBufferedReader = null;
    protected SSLCertificateApprovalCallback mCertApprovalCallback = null;
    protected boolean mConnected = false;
    protected String mHost;
    protected String mPort;

    public HttpClient() {
    }

    public HttpClient(ISocketFactory factory) {
        this.mFactory = factory;
    }

    public HttpClient(ISocketFactory factory, SSLCertificateApprovalCallback certApprovalCallback) {
        this.mFactory = factory;
        this.mCertApprovalCallback = certApprovalCallback;
    }

    public void connect(String host, int port, int timeout) throws IOException {
        this.mHost = host;
        this.mPort = Integer.toString(port);
        if (this.mFactory != null) {
            this.mSocket = this.mCertApprovalCallback == null ? this.mFactory.makeSocket(host, port, timeout) : this.mFactory.makeSocket(host, port, this.mCertApprovalCallback, null, timeout);
        } else {
            this.mSocket = new Socket(host, port);
            this.mSocket.setSoTimeout(timeout);
        }
        if (this.mSocket == null) {
            throw new IOException("Couldn't make connection");
        }
        this.mInputStream = this.mSocket.getInputStream();
        this.mOutputStream = this.mSocket.getOutputStream();
        this.mInputStreamReader = new InputStreamReader(this.mInputStream, "UTF8");
        this.mBufferedReader = new BufferedReader(this.mInputStreamReader);
        this.mOutputStreamWriter = new OutputStreamWriter(this.mOutputStream, "UTF8");
        this.mConnected = true;
    }

    public void connect(String host, int port) throws IOException {
        this.connect(host, port, 0);
    }

    public boolean connected() {
        return this.mConnected;
    }

    public HttpResponse send(HttpRequest request) throws IOException {
        HttpResponse resp = new HttpResponse();
        if (this.mOutputStream == null) {
            throw new IOException("Output stream not initialized");
        }
        request.write(this.mOutputStreamWriter);
        try {
            resp.parse(this.mBufferedReader);
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
        this.disconnect();
        return resp;
    }

    public void disconnect() throws IOException {
        this.mSocket.close();
        this.mInputStream = null;
        this.mOutputStream = null;
        this.mConnected = false;
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public BufferedReader getBufferedReader() {
        return this.mBufferedReader;
    }

    public InputStreamReader getInputStreamReader() {
        return this.mInputStreamReader;
    }

    public OutputStreamWriter getOutputStreamWriter() {
        return this.mOutputStreamWriter;
    }

    public Socket getSocket() {
        return this.mSocket;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPort() {
        return this.mPort;
    }

    public static void main(String[] args) throws Exception {
        HttpClient c = new HttpClient();
        HttpRequest req = new HttpRequest();
        HttpResponse resp = null;
        System.out.println("connecting to " + args[0] + " " + args[1]);
        c.connect(args[0], Integer.parseInt(args[1]));
        req.setMethod("GET");
        req.setURI(args[2]);
        if (args.length >= 4) {
            req.setHeader("Connection", args[3]);
        }
        resp = c.send(req);
        System.out.println("version " + resp.getHttpVers());
        System.out.println("status code " + resp.getStatusCode());
        System.out.println("reason " + resp.getReasonPhrase());
        System.out.println("content " + resp.getContent());
        if (args.length >= 4 && args[3].equalsIgnoreCase("keep-alive")) {
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    req.setHeader("Connection", "Close");
                }
                resp = c.send(req);
                System.out.println("version " + resp.getHttpVers());
                System.out.println("status code " + resp.getStatusCode());
                System.out.println("reason " + resp.getReasonPhrase());
                System.out.println("content " + resp.getContent());
            }
        }
    }
}

