/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.ber.stream.BERTagDecoder;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPPostReadControl
extends LDAPControl {
    private static final long serialVersionUID = -3988578305868188089L;
    public static final String OID_POSTREAD = "1.3.6.1.1.13.2";
    private LDAPEntry entry = null;

    public LDAPPostReadControl(String oid, boolean critical, byte[] value) throws LDAPException, IOException {
        super(OID_POSTREAD, critical, value);
        if (!oid.equals(OID_POSTREAD)) {
            throw new LDAPException("oid must be LDAPPostReadControl.OID_POSTREAD", 89);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(value);
        int[] numRead = new int[1];
        BERTag tag = (BERTag)BERElement.getElement((BERTagDecoder)new JDAPBERTagDecoder(), (InputStream)in, (int[])numRead);
        BERSequence seq = (BERSequence)tag.getValue();
        BEROctetString name = (BEROctetString)seq.elementAt(0);
        byte[] buf = name.getValue();
        String dn = null;
        if (buf != null) {
            dn = new String(buf, "UTF8");
        }
        BERSequence attrs = (BERSequence)seq.elementAt(1);
        LDAPAttributeSet attrSet = new LDAPAttributeSet();
        for (int i = 0; i < attrs.size(); ++i) {
            attrSet.add(new LDAPAttribute(attrs.elementAt(i)));
        }
        this.entry = new LDAPEntry(dn, attrSet);
    }

    public LDAPPostReadControl(boolean critical, String[] attrs) {
        super(OID_POSTREAD, critical, null);
        BERSequence ber_attrs = new BERSequence();
        for (int i = 0; i < attrs.length; ++i) {
            ber_attrs.addElement((BERElement)new BEROctetString(attrs[i]));
        }
        this.m_value = this.flattenBER(ber_attrs);
    }

    public LDAPEntry getEntry() {
        return this.entry;
    }

    static {
        try {
            LDAPPostReadControl.register((String)OID_POSTREAD, LDAPPostReadControl.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

