/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.nss;

import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.password.PasswordStore;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLIException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.AccessDescription;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11ECPrivateKey;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs11.PK11RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSDatabase {
    public static Logger logger = LoggerFactory.getLogger(NSSDatabase.class);
    FileAttribute<Set<PosixFilePermission>> FILE_PERMISSIONS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
    FileAttribute<Set<PosixFilePermission>> DIR_PERMISSIONS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
    Path path;
    PasswordStore passwordStore;

    public NSSDatabase() {
    }

    public NSSDatabase(Path path) {
        this.path = path;
    }

    public NSSDatabase(File directory) {
        this(directory.toPath());
    }

    public NSSDatabase(String directory) {
        this(Paths.get(directory, new String[0]));
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public File getDirectory() {
        return this.path.toFile();
    }

    public void setDirectory(File directory) {
        this.path = directory.toPath();
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setPasswordStore(PasswordStore passwordStore) {
        this.passwordStore = passwordStore;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void create() throws Exception {
        String password = this.passwordStore.getPassword("internal", 0);
        this.create(password);
    }

    public void create(String password) throws Exception {
        this.create(password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String password, boolean enableTrustPolicy) throws Exception {
        logger.debug("NSSDatabase: Creating NSS database in " + this.path);
        Files.createDirectories(this.path, new FileAttribute[0]);
        Path passwordPath = this.path.resolve("password.txt");
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("certutil");
            command.add("-N");
            command.add("-d");
            command.add(this.path.toAbsolutePath().toString());
            if (password == null) {
                command.add("--empty-password");
            } else {
                try (PrintWriter out = new PrintWriter(new FileWriter(passwordPath.toFile()));){
                    out.println(password);
                }
                command.add("-f");
                command.add(passwordPath.toAbsolutePath().toString());
            }
            this.debug(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process p = pb.start();
            int rc = p.waitFor();
            if (rc != 0) {
                throw new Exception("Command failed: rc=" + rc);
            }
        }
        finally {
            if (Files.exists(passwordPath, new LinkOption[0])) {
                Files.delete(passwordPath);
            }
        }
        if (enableTrustPolicy && !this.moduleExists("p11-kit-trust")) {
            this.addModule("p11-kit-trust", "/usr/share/pki/lib/p11-kit-trust.so");
        }
    }

    public boolean moduleExists(String name) throws Exception {
        logger.debug("NSSDatabase: Checking module " + name);
        ArrayList<String> command = new ArrayList<String>();
        command.add("modutil");
        command.add("-dbdir");
        command.add(this.path.toAbsolutePath().toString());
        command.add("-rawlist");
        this.debug(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        String pattern = " name=\"" + name + "\" ";
        try (InputStreamReader reader = new InputStreamReader(p.getInputStream());
             BufferedReader in = new BufferedReader(reader);){
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains(pattern)) continue;
                boolean bl = true;
                return bl;
            }
        }
        int rc = p.waitFor();
        if (rc != 0) {
            throw new Exception("Command failed: rc=" + rc);
        }
        return false;
    }

    public void addModule(String name, String library) throws Exception {
        logger.debug("NSSDatabase: Installing " + name + " module with " + library);
        ArrayList<String> command = new ArrayList<String>();
        command.add("modutil");
        command.add("-dbdir");
        command.add(this.path.toAbsolutePath().toString());
        command.add("-add");
        command.add(name);
        command.add("-libfile");
        command.add(library);
        command.add("-force");
        this.debug(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        try (OutputStreamWriter writer = new OutputStreamWriter(p.getOutputStream());
             PrintWriter out = new PrintWriter(writer);){
            out.println();
        }
        int rc = p.waitFor();
        if (rc != 0) {
            throw new Exception("Command failed: rc=" + rc);
        }
    }

    public X509Certificate addCertificate(java.security.cert.X509Certificate cert, String trustFlags) throws Exception {
        byte[] bytes = cert.getEncoded();
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate jssCert = manager.importCACertPackage(bytes);
        if (trustFlags != null) {
            CryptoUtil.setTrustFlags(jssCert, trustFlags);
        }
        return jssCert;
    }

    public X509Certificate addPEMCertificate(String filename, String trustFlags) throws Exception {
        String pemCert = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        byte[] bytes = Cert.parseCertificate((String)pemCert);
        X509CertImpl cert = new X509CertImpl(bytes);
        return this.addCertificate((java.security.cert.X509Certificate)cert, trustFlags);
    }

    public void addCertificate(String nickname, java.security.cert.X509Certificate cert, String trustFlags) throws Exception {
        this.addCertificate(null, nickname, cert, trustFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCertificate(String tokenName, String nickname, java.security.cert.X509Certificate cert, String trustFlags) throws Exception {
        byte[] bytes = CertUtil.toPEM(cert).getBytes();
        Path certPath = null;
        try {
            certPath = Files.createTempFile("nss-cert-", ".crt", this.FILE_PERMISSIONS);
            Files.write(certPath, bytes, new OpenOption[0]);
            this.addPEMCertificate(tokenName, nickname, certPath.toString(), trustFlags);
            if (certPath == null) return;
        }
        catch (Throwable throwable) {
            if (certPath == null) throw throwable;
            Files.delete(certPath);
            throw throwable;
        }
        Files.delete(certPath);
    }

    public void addPEMCertificate(String nickname, String filename, String trustFlags) throws Exception {
        this.addPEMCertificate(null, nickname, filename, trustFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPEMCertificate(String tokenName, String nickname, String filename, String trustFlags) throws Exception {
        Path passwordPath = null;
        if (trustFlags == null) {
            trustFlags = ",,";
        }
        try {
            Object tag;
            String password;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("certutil");
            cmd.add("-A");
            cmd.add("-d");
            cmd.add(this.path.toString());
            if (tokenName != null) {
                cmd.add("-h");
                cmd.add(tokenName);
            }
            if (this.passwordStore != null && (password = this.passwordStore.getPassword((String)(tag = tokenName == null ? "internal" : "hardware-" + tokenName), 0)) != null) {
                passwordPath = Files.createTempFile("nss-password-", ".txt", this.FILE_PERMISSIONS);
                logger.debug("NSSDatabase: Storing password into " + passwordPath);
                Files.write(passwordPath, password.getBytes(), new OpenOption[0]);
                cmd.add("-f");
                cmd.add(passwordPath.toString());
            }
            cmd.add("-a");
            cmd.add("-n");
            cmd.add(nickname);
            cmd.add("-t");
            cmd.add(trustFlags);
            cmd.add("-i");
            cmd.add(filename);
            this.debug(cmd);
            Process p = new ProcessBuilder(cmd).start();
            this.readStdout(p);
            this.readStderr(p);
            int rc = p.waitFor();
            if (rc != 0) {
                throw new CLIException("Command failed. RC: " + rc, rc);
            }
            if (passwordPath == null) return;
        }
        catch (Throwable throwable) {
            if (passwordPath == null) throw throwable;
            Files.delete(passwordPath);
            throw throwable;
        }
        Files.delete(passwordPath);
    }

    public void addBasicConstraintsExtension(List<String> cmd, PrintWriter stdin, BasicConstraintsExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding basic constraints extension:");
        cmd.add("-2");
        boolean ca = (Boolean)extension.get("is_ca");
        logger.debug("NSSDatabase: - CA: " + ca);
        if (ca) {
            stdin.print("y");
        }
        stdin.println();
        int pathLength = (Integer)extension.get("path_len");
        logger.debug("NSSDatabase: - path length: " + pathLength);
        stdin.print(pathLength);
        stdin.println();
        if (extension.isCritical()) {
            logger.debug("NSSDatabase: - critical");
            stdin.print("y");
        }
        stdin.println();
    }

    public void addAKIDExtension(List<String> cmd, PrintWriter stdin, AuthorityKeyIdentifierExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding AKID extension:");
        cmd.add("-3");
        stdin.println("y");
        KeyIdentifier keyID = (KeyIdentifier)extension.get("key_id");
        String akid = "0x" + Utils.HexEncode((byte[])keyID.getIdentifier());
        logger.debug("NSSDatabase: - AKID: " + akid);
        stdin.println(akid);
        stdin.println();
        stdin.println();
        if (extension.isCritical()) {
            stdin.print("y");
        }
        stdin.println();
    }

    public void addSKIDExtension(List<String> cmd, PrintWriter stdin, SubjectKeyIdentifierExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding SKID extension:");
        cmd.add("--extSKID");
        KeyIdentifier keyID = (KeyIdentifier)extension.get("key_id");
        String skid = "0x" + Utils.HexEncode((byte[])keyID.getIdentifier());
        logger.debug("NSSDatabase: - SKID: " + skid);
        stdin.println(skid);
        if (extension.isCritical()) {
            stdin.print("y");
        }
        stdin.println();
    }

    public void addAIAExtension(List<String> cmd, PrintWriter stdin, AuthInfoAccessExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding AIA extension:");
        cmd.add("--extAIA");
        int size = extension.numberOfAccessDescription();
        for (int i = 0; i < size; ++i) {
            byte[] bytes;
            AccessDescription ad = extension.getAccessDescription(i);
            ObjectIdentifier method = ad.getMethod();
            if (AuthInfoAccessExtension.METHOD_CA_ISSUERS.equals(method)) {
                logger.debug("NSSDatabase: - CA issuers");
                stdin.println("1");
            } else if (AuthInfoAccessExtension.METHOD_OCSP.equals(method)) {
                logger.debug("NSSDatabase: - OCSP");
                stdin.println("2");
            } else {
                throw new Exception("Unsupported AIA method: " + method);
            }
            GeneralName location = ad.getLocation();
            if (6 == location.getType()) {
                try (DerOutputStream derOS = new DerOutputStream();){
                    location.encode(derOS);
                    bytes = derOS.toByteArray();
                }
            } else {
                throw new Exception("Unsupported AIA location: " + location);
            }
            DerValue derValue = new DerValue((InputStream)new ByteArrayInputStream(bytes));
            derValue.resetTag((byte)22);
            String uri = derValue.getIA5String();
            logger.debug("NSSDatabase:   - URI: " + uri);
            stdin.println("7");
            stdin.println(uri);
            stdin.println();
            if (i < size - 1) {
                stdin.print("y");
            }
            stdin.println();
        }
        if (extension.isCritical()) {
            stdin.print("y");
        }
        stdin.println();
    }

    public void addKeyUsageExtension(List<String> cmd, KeyUsageExtension extension) throws Exception {
        Boolean crlSigning;
        Boolean certSigning;
        Boolean keyAgreement;
        Boolean dataEncipherment;
        Boolean keyEncipherment;
        Boolean nonRepudiation;
        Boolean digitalSignature;
        logger.debug("NSSDatabase: Adding key usage extension:");
        cmd.add("--keyUsage");
        ArrayList<String> options = new ArrayList<String>();
        if (extension.isCritical()) {
            logger.debug("NSSDatabase: - critical");
            options.add("critical");
        }
        if ((digitalSignature = (Boolean)extension.get("digital_signature")).booleanValue()) {
            logger.debug("NSSDatabase: - digitalSignature");
            options.add("digitalSignature");
        }
        if ((nonRepudiation = (Boolean)extension.get("non_repudiation")).booleanValue()) {
            logger.debug("NSSDatabase: - nonRepudiation");
            options.add("nonRepudiation");
        }
        if ((keyEncipherment = (Boolean)extension.get("key_encipherment")).booleanValue()) {
            logger.debug("NSSDatabase: - keyEncipherment");
            options.add("keyEncipherment");
        }
        if ((dataEncipherment = (Boolean)extension.get("data_encipherment")).booleanValue()) {
            logger.debug("NSSDatabase: - dataEncipherment");
            options.add("dataEncipherment");
        }
        if ((keyAgreement = (Boolean)extension.get("key_agreement")).booleanValue()) {
            logger.debug("NSSDatabase: - keyAgreement");
            options.add("keyAgreement");
        }
        if ((certSigning = (Boolean)extension.get("key_certsign")).booleanValue()) {
            logger.debug("NSSDatabase: - certSigning");
            options.add("certSigning");
        }
        if ((crlSigning = (Boolean)extension.get("crl_sign")).booleanValue()) {
            logger.debug("NSSDatabase: - crlSigning");
            options.add("crlSigning");
        }
        cmd.add(StringUtils.join(options, (String)","));
    }

    public void addExtendedKeyUsageExtension(List<String> cmd, ExtendedKeyUsageExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding extended key usage extension:");
        cmd.add("--extKeyUsage");
        ArrayList<String> options = new ArrayList<String>();
        if (extension.isCritical()) {
            logger.debug("NSSDatabase: - critical");
            options.add("critical");
        }
        Enumeration e = extension.getOIDs();
        while (e.hasMoreElements()) {
            ObjectIdentifier oid = (ObjectIdentifier)e.nextElement();
            if (ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.1").equals(oid)) {
                logger.debug("NSSDatabase: - serverAuth");
                options.add("serverAuth");
                continue;
            }
            if (ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.2").equals(oid)) {
                logger.debug("NSSDatabase: - clientAuth");
                options.add("clientAuth");
                continue;
            }
            if (ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.4").equals(oid)) {
                logger.debug("NSSDatabase: - emailProtection");
                options.add("emailProtection");
                continue;
            }
            if (ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.9").equals(oid)) {
                logger.debug("NSSDatabase: - OCSPSigning");
                options.add("ocspResponder");
                continue;
            }
            throw new Exception("Unsupported extended key usage: " + oid);
        }
        cmd.add(StringUtils.join(options, (String)","));
    }

    public void addCertificatePoliciesExtension(List<String> cmd, PrintWriter stdin, CertificatePoliciesExtension extension) throws Exception {
        logger.debug("NSSDatabase: Adding certificate policies extension:");
        cmd.add("--extCP");
        Vector infos = (Vector)extension.get("infos");
        for (int i = 0; i < infos.size(); ++i) {
            CertificatePolicyInfo info = (CertificatePolicyInfo)infos.get(i);
            CertificatePolicyId policyID = info.getPolicyIdentifier();
            ObjectIdentifier policyOID = policyID.getIdentifier();
            logger.debug("NSSDatabase: - " + policyOID);
            stdin.println(policyOID);
            PolicyQualifiers qualifiers = info.getPolicyQualifiers();
            if (qualifiers == null || qualifiers.size() == 0) {
                stdin.println();
            } else {
                int size = qualifiers.size();
                for (int j = 0; j < size; ++j) {
                    PolicyQualifierInfo qualifierInfo = qualifiers.getInfoAt(j);
                    ObjectIdentifier qualifierOID = qualifierInfo.getId();
                    if (PolicyQualifierInfo.QT_CPS.equals(qualifierOID)) {
                        CPSuri cpsURI = (CPSuri)qualifierInfo.getQualifier();
                        String uri = cpsURI.getURI();
                        logger.debug("NSSDatabase:   - CPS: " + uri);
                        stdin.println("1");
                        stdin.println(uri);
                        if (j < size - 1) {
                            stdin.print("y");
                        }
                    } else {
                        throw new Exception("Unsupported certificate policy qualifier: " + qualifierOID);
                    }
                    stdin.println();
                }
            }
            if (i < infos.size() - 1) {
                stdin.print("y");
            }
            stdin.println();
        }
        if (extension.isCritical()) {
            stdin.print("y");
        }
        stdin.println();
    }

    public void addOCSPNoCheckExtension(List<String> cmd, PrintWriter stdin, OCSPNoCheckExtension extension, Path tmpDir) throws Exception {
        logger.debug("NSSDatabase: Adding OCSP No Check extension:");
        cmd.add("--extGeneric");
        ObjectIdentifier oid = extension.getExtensionId();
        logger.debug("NSSDatabase: - OID: " + oid);
        boolean critical = extension.isCritical();
        logger.debug("NSSDatabase: - critical: " + critical);
        String flag = critical ? "critical" : "not-critical";
        byte[] value = extension.getExtensionValue();
        logger.debug("NSSDatabase: - value: " + (value == null ? null : Utils.base64encodeSingleLine((byte[])value)));
        Path file = tmpDir.resolve("ocsp-no-check.ext");
        Files.write(file, value, new OpenOption[0]);
        cmd.add(oid + ":" + flag + ":" + file);
    }

    public void addExtensions(List<String> cmd, StringWriter sw, Extensions extensions, Path tmpDir) throws Exception {
        PrintWriter stdin = new PrintWriter((Writer)sw, true);
        for (Extension extension : extensions) {
            if (extension instanceof BasicConstraintsExtension) {
                BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)extension;
                this.addBasicConstraintsExtension(cmd, stdin, basicConstraintsExtension);
                continue;
            }
            if (extension instanceof AuthorityKeyIdentifierExtension) {
                AuthorityKeyIdentifierExtension akidExtension = (AuthorityKeyIdentifierExtension)extension;
                this.addAKIDExtension(cmd, stdin, akidExtension);
                continue;
            }
            if (extension instanceof SubjectKeyIdentifierExtension) {
                SubjectKeyIdentifierExtension skidExtension = (SubjectKeyIdentifierExtension)extension;
                this.addSKIDExtension(cmd, stdin, skidExtension);
                continue;
            }
            if (extension instanceof AuthInfoAccessExtension) {
                AuthInfoAccessExtension aiaExtension = (AuthInfoAccessExtension)extension;
                this.addAIAExtension(cmd, stdin, aiaExtension);
                continue;
            }
            if (extension instanceof KeyUsageExtension) {
                KeyUsageExtension keyUsageExtension = (KeyUsageExtension)extension;
                this.addKeyUsageExtension(cmd, keyUsageExtension);
                continue;
            }
            if (extension instanceof ExtendedKeyUsageExtension) {
                ExtendedKeyUsageExtension extendedKeyUsageExtension = (ExtendedKeyUsageExtension)extension;
                this.addExtendedKeyUsageExtension(cmd, extendedKeyUsageExtension);
                continue;
            }
            if (extension instanceof CertificatePoliciesExtension) {
                CertificatePoliciesExtension certificatePoliciesExtension = (CertificatePoliciesExtension)extension;
                this.addCertificatePoliciesExtension(cmd, stdin, certificatePoliciesExtension);
                continue;
            }
            if (!(extension instanceof OCSPNoCheckExtension)) continue;
            OCSPNoCheckExtension ocspNoCheckExtension = (OCSPNoCheckExtension)extension;
            this.addOCSPNoCheckExtension(cmd, stdin, ocspNoCheckExtension, tmpDir);
        }
    }

    public KeyPair loadKeyPair(CryptoToken token, byte[] keyID) throws Exception {
        String hexKeyID = "0x" + Utils.HexEncode((byte[])keyID);
        logger.debug("NSSDatabase: Loading key " + hexKeyID);
        PK11PrivKey privateKey = (PK11PrivKey)CryptoUtil.findPrivateKey(token, keyID);
        if (privateKey == null) {
            throw new Exception("Private key not found: " + hexKeyID);
        }
        logger.debug("NSSDatabase: - class: " + privateKey.getClass().getName());
        logger.debug("NSSDatabase: - algorithm: " + privateKey.getAlgorithm());
        logger.debug("NSSDatabase: - format: " + privateKey.getFormat());
        PK11PubKey publicKey = privateKey.getPublicKey();
        String keyType = privateKey.getType().toString();
        logger.debug("NSSDatabase: - key type: " + keyType);
        if (privateKey instanceof PK11RSAPrivateKey) {
            logger.debug("NSSDatabase: - size: " + privateKey.getStrength());
        } else if (privateKey instanceof PK11ECPrivateKey) {
            PK11ECPrivateKey ecPrivateKey = (PK11ECPrivateKey)privateKey;
            ECParameterSpec spec = ecPrivateKey.getParams();
            logger.debug("NSSDatabase: - curve: " + spec.getCurve());
        }
        return new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey);
    }

    public KeyPair createRSAKeyPair(CryptoToken token, int keySize, Boolean temporary, Boolean sensitive, Boolean extractable, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("NSSDatabase: Creating RSA key");
        logger.debug("NSSDatabase: - size: " + keySize);
        return CryptoUtil.generateRSAKeyPair(token, keySize, temporary, sensitive, extractable, usages, usagesMask);
    }

    public KeyPair createRSAKeyPair(CryptoToken token, int keySize, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("NSSDatabase: Creating RSA key");
        logger.debug("NSSDatabase: - size: " + keySize);
        return CryptoUtil.generateRSAKeyPair(token, keySize, false, false, false, usages, usagesMask);
    }

    public KeyPair createRSAKeyPair(CryptoToken token, int keySize) throws Exception {
        logger.debug("NSSDatabase: Creating RSA key");
        logger.debug("NSSDatabase: - size: " + keySize);
        return CryptoUtil.generateRSAKeyPair(token, keySize, false, false, false, null, null);
    }

    public KeyPair createECKeyPair(CryptoToken token, String curveName, Boolean temporary, Boolean sensitive, Boolean extractable, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("NSSDatabase: Creating EC key");
        logger.debug("NSSDatabase: - curve: " + curveName);
        return CryptoUtil.generateECCKeyPair(token, curveName, temporary, sensitive, extractable, usages, usagesMask);
    }

    public KeyPair createECKeyPair(CryptoToken token, String curveName, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("NSSDatabase: Creating EC key");
        logger.debug("NSSDatabase: - curve: " + curveName);
        return CryptoUtil.generateECCKeyPair(token, curveName, null, null, null, usages, usagesMask);
    }

    public KeyPair createECKeyPair(CryptoToken token, String curveName) throws Exception {
        logger.debug("NSSDatabase: Creating EC key");
        logger.debug("NSSDatabase: - curve: " + curveName);
        return CryptoUtil.generateECCKeyPair(token, curveName, null, null, null, null, null);
    }

    public PKCS10 createPKCS10Request(KeyPair keyPair, String subject, String algorithm, Extensions extensions) throws Exception {
        logger.debug("NSSDatabase: Creating PKCS #10 request");
        logger.debug("NSSDatabase: - subjecct: " + subject);
        logger.debug("NSSDatabase: - algorithm: " + algorithm);
        return CryptoUtil.createCertificationRequest(subject, keyPair, algorithm, extensions);
    }

    public java.security.cert.X509Certificate createCertificate(X509Certificate issuer, PKCS10 pkcs10, Integer monthsValid, String hash, Extensions extensions) throws Exception {
        return this.createCertificate(issuer, pkcs10, null, monthsValid, hash, extensions);
    }

    public java.security.cert.X509Certificate createCertificate(X509Certificate issuer, PKCS10 pkcs10, String serialNumber, Integer monthsValid, String hash, Extensions extensions) throws Exception {
        return this.createCertificate(null, issuer, pkcs10, serialNumber, monthsValid, hash, extensions);
    }

    public java.security.cert.X509Certificate createCertificate(String tokenName, X509Certificate issuer, PKCS10 pkcs10, String serialNumber, Integer monthsValid, String hash, Extensions extensions) throws Exception {
        BigInteger serialNo;
        X500Name subjectName = pkcs10.getSubjectName();
        logger.debug("NSSDatabase: Issuing cert for " + subjectName);
        if (tokenName != null) {
            logger.debug("NSSDatabase: - token: " + tokenName);
        }
        CryptoToken token = CryptoUtil.getKeyStorageToken(tokenName);
        X500Name issuerName = issuer == null ? subjectName : new X500Name(issuer.getSubjectDN().toString());
        CertificateIssuerName certIssuerName = new CertificateIssuerName(issuerName);
        logger.debug("NSSDatabase: - issuer: " + certIssuerName);
        X509Key x509Key = pkcs10.getSubjectPublicKeyInfo();
        logger.debug("NSSDatabase: - public key algorithm: " + x509Key.getAlgorithm());
        if (serialNumber == null) {
            byte[] bytes = new byte[16];
            SecureRandom random = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            random.nextBytes(bytes);
            serialNo = new BigInteger(1, bytes);
        } else {
            serialNo = new BigInteger(serialNumber);
        }
        logger.debug("NSSDatabase: - serial number: 0x" + Utils.HexEncode((byte[])serialNo.toByteArray()));
        Calendar calendar = Calendar.getInstance();
        Date notBeforeDate = calendar.getTime();
        logger.debug("NSSDatabase: - not before: " + notBeforeDate);
        calendar.add(2, monthsValid);
        Date notAfterDate = calendar.getTime();
        logger.debug("NSSDatabase: - not after: " + notAfterDate);
        if (hash == null) {
            hash = "SHA256";
        }
        logger.debug("NSSDatabase: - hash algorithm: " + hash);
        String keyAlgorithm = hash + "with" + x509Key.getAlgorithm();
        logger.debug("NSSDatabase: - key algorithm: " + keyAlgorithm);
        CertificateExtensions certExts = new CertificateExtensions();
        if (extensions != null) {
            Enumeration names = extensions.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Extension extension = (Extension)extensions.get(name);
                certExts.set(name, (Object)extension);
            }
        }
        X509CertInfo info = CryptoUtil.createX509CertInfo(x509Key, serialNo, certIssuerName, subjectName, notBeforeDate, notAfterDate, keyAlgorithm, certExts);
        org.mozilla.jss.crypto.PrivateKey privateKey = null;
        if (issuer == null) {
            logger.debug("NSSDatabase: Finding request private key");
            byte[] requestPublicKey = x509Key.getEncoded();
            CryptoStore store = token.getCryptoStore();
            for (org.mozilla.jss.crypto.PrivateKey privKey : store.getPrivateKeys()) {
                PK11PrivKey pk11PrivKey = (PK11PrivKey)privKey;
                logger.debug("NSSDatabase: - private key: 0x" + Utils.HexEncode((byte[])privKey.getUniqueID()));
                PK11PubKey pk11PubKey = pk11PrivKey.getPublicKey();
                byte[] publicKey = pk11PubKey.getEncoded();
                if (!Arrays.equals(requestPublicKey, publicKey)) continue;
                privateKey = privKey;
                break;
            }
            if (privateKey == null) {
                throw new Exception("Unable to find request private key");
            }
        } else {
            logger.debug("NSSDatabase: Finding issuer private key");
            CryptoManager cm = CryptoManager.getInstance();
            privateKey = cm.findPrivKeyByCert(issuer);
            logger.debug("NSSDatabase: - private key: " + Utils.HexEncode((byte[])privateKey.getUniqueID()));
        }
        logger.debug("NSSDatabase: Private key algorithm: " + privateKey.getAlgorithm());
        String signingAlgorithm = hash + "with" + privateKey.getAlgorithm();
        logger.debug("NSSDatabase: Signing algorithm: " + signingAlgorithm);
        return CryptoUtil.signCert((PrivateKey)privateKey, info, signingAlgorithm);
    }

    public void delete() throws Exception {
        FileUtils.deleteDirectory((File)this.path.toFile());
    }

    public void debug(Collection<String> command) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Command:");
            for (String c : command) {
                boolean quote = c.contains(" ");
                sb.append(' ');
                if (quote) {
                    sb.append('\"');
                }
                sb.append(c);
                if (!quote) continue;
                sb.append('\"');
            }
            logger.debug("NSSDatabase: " + sb);
        }
    }

    public void readStdout(final Process process) {
        new Thread(){

            @Override
            public void run() {
                try (InputStream is = process.getInputStream();
                     InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader in = new BufferedReader(isr);){
                    String line;
                    while ((line = in.readLine()) != null) {
                        logger.debug("NSSDatabase: " + line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    public void readStderr(final Process process) {
        new Thread(){

            @Override
            public void run() {
                try (InputStream is = process.getErrorStream();
                     InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader in = new BufferedReader(isr);){
                    String line;
                    while ((line = in.readLine()) != null) {
                        logger.warn("NSSDatabase: " + line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    public void writeStdin(Process process, String input) throws Exception {
        try (OutputStream os = process.getOutputStream();
             PrintWriter out = new PrintWriter(os);){
            out.print(input);
        }
    }
}

