/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.authentication.DirBasedAuthentication;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPwdDirAuthentication
extends DirBasedAuthentication {
    public static Logger logger = LoggerFactory.getLogger(UserPwdDirAuthentication.class);
    public static final String CRED_UID = "uid";
    public static final String CRED_PWD = "pwd";
    public String mAttr = "uid";
    protected String[] mRequiredCreds = new String[]{this.mAttr, "pwd"};
    protected String mAttrName = null;
    protected String mAttrDesc = null;
    protected String mMemberAttrName = null;
    protected String mMemberAttrValue = null;
    protected String mInternalGroup = null;
    protected boolean mInternalUserRequired = false;
    protected UGSubsystem mUGS = null;
    protected String[] mAttrs = null;
    protected static String[] mConfigParams = new String[]{"dnpattern", "ldapStringAttributes", "ldapByteAttributes", "ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.basedn", "ldap.attrName", "ldap.attrDesc", "ldap.memberAttrName", "ldap.memberAttrValue", "ldap.internalUserRequired", "ldap.internalGroup", "ldap.minConns", "ldap.maxConns"};

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        super.init(authenticationConfig, name, implName, config);
        logger.debug("UserPwdDirAuthentication init");
        this.mAttrName = this.mLdapConfig.getString("attrName", null);
        if (this.mAttrName == null || this.mAttrName.trim().length() == 0) {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", "attrName"));
        }
        this.mAttrName = this.mAttrName.trim();
        this.mAttrDesc = this.mLdapConfig.getString("attrDesc", null);
        if (this.mAttrDesc == null || this.mAttrDesc.trim().length() == 0) {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", "attrDesc"));
        }
        this.mAttrDesc = this.mAttrDesc.trim();
        if (this.mAttrName != null && this.mAttrName.length() > 0) {
            this.mAttr = this.mAttrName;
        }
        logger.debug("UserPwdDirAuthentication init  mAttr=" + this.mAttr + "  mAttrName=" + this.mAttrName + "  mAttrDesc=" + this.mAttrDesc);
        this.mMemberAttrName = this.mLdapConfig.getString("memberAttrName", null);
        String string = this.mMemberAttrName = this.mMemberAttrName != null ? this.mMemberAttrName.trim() : this.mMemberAttrName;
        if (this.mMemberAttrName != null && this.mMemberAttrName.length() > 0) {
            this.mMemberAttrValue = this.mLdapConfig.getString("memberAttrValue", null);
            this.mMemberAttrValue = this.mMemberAttrValue != null ? this.mMemberAttrValue.trim() : this.mMemberAttrValue;
            logger.debug("UserPwdDirAuthentication init  mMemberAttrName=" + this.mMemberAttrName + "  mMemberAttrValue=" + this.mMemberAttrValue);
        }
        this.mInternalUserRequired = this.mLdapConfig.getBoolean("internalUserRequired", false);
        logger.debug("UserPwdDirAuthentication init  mInternalUserRequired=" + this.mInternalUserRequired);
        this.mInternalGroup = this.mLdapConfig.getString("internalGroup", null);
        String string2 = this.mInternalGroup = this.mInternalGroup != null ? this.mInternalGroup.trim() : this.mInternalGroup;
        if (this.mInternalGroup != null && this.mInternalGroup.length() > 0) {
            this.mInternalUserRequired = true;
            logger.debug("UserPwdDirAuthentication init  mInternalGroup=" + this.mInternalGroup);
        }
        if (this.mInternalUserRequired) {
            this.mUGS = this.engine.getUGSubsystem();
        }
        ArrayList<String> attrList = new ArrayList<String>();
        if (this.mInternalUserRequired) {
            attrList.add(CRED_UID);
        }
        if (this.mMemberAttrName != null && this.mMemberAttrName.length() > 0 && !this.mMemberAttrName.equalsIgnoreCase(CRED_UID)) {
            attrList.add(this.mMemberAttrName);
        }
        this.mAttrs = attrList.toArray(new String[attrList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String authenticate(LDAPConnection conn, AuthCredentials authCreds, AuthToken token) throws EBaseException {
        String attr;
        String userdn;
        block29: {
            boolean verified;
            block30: {
                String[] values;
                block31: {
                    userdn = null;
                    attr = null;
                    try {
                        String userAttr;
                        LDAPSearchResults results;
                        attr = (String)authCreds.get(this.mAttr);
                        logger.debug("Authenticating " + this.mAttr + "=" + attr);
                        if (attr == null) {
                            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", this.mAttr));
                        }
                        String pwd = (String)authCreds.get(CRED_PWD);
                        if (pwd == null) {
                            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_PWD));
                        }
                        if (pwd.equals("")) {
                            logger.error("UserPwdDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_EMPTY_PASSWORD", attr));
                            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                        }
                        userdn = this.mAttr + "=" + attr + "," + this.mBaseDN;
                        logger.debug("Authenticating: userdn=" + userdn);
                        conn.authenticate(userdn, pwd);
                        logger.debug("Authenticated: userdn=" + userdn);
                        LDAPEntry entry = null;
                        HashMap<String, String[]> entryAttributes = new HashMap<String, String[]>();
                        if (this.mAttrs != null && this.mAttrs.length > 0 && (results = conn.search(userdn, 0, null, this.mAttrs, false)) != null && results.hasMoreElements() && (entry = results.next()) != null) {
                            logger.debug("Reviewing entry: " + entry.getDN());
                            for (int i = 0; i < this.mAttrs.length; ++i) {
                                String[] values2;
                                LDAPAttribute memberAttribute = entry.getAttribute(this.mAttrs[i]);
                                if (memberAttribute == null || (values2 = memberAttribute.getStringValueArray()) == null || values2.length <= 0) continue;
                                entryAttributes.put(this.mAttrs[i], values2);
                            }
                        }
                        if (this.mAttrs != null && this.mAttrs.length > 0 && (entry == null || entryAttributes.size() == 0)) {
                            logger.debug("Failed to obtain data required for verification.");
                            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                        }
                        if (this.mMemberAttrName != null && this.mMemberAttrName.length() > 0) {
                            logger.debug("Authenticating: memberAttribute=" + this.mMemberAttrName);
                            values = (String[])entryAttributes.get(this.mMemberAttrName);
                            verified = false;
                            if (values != null && values.length > 0) {
                                if (this.mMemberAttrValue != null && this.mMemberAttrValue.length() > 0) {
                                    for (int i = 0; i < values.length; ++i) {
                                        if (!this.mMemberAttrValue.equalsIgnoreCase(values[i])) continue;
                                        verified = true;
                                    }
                                } else {
                                    verified = true;
                                }
                            }
                            if (!verified) {
                                logger.debug("Failed to verify memberAttribute");
                                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                            }
                            if (!this.mInternalUserRequired) break block29;
                            values = (String[])entryAttributes.get(CRED_UID);
                            verified = false;
                            if (values == null || values.length <= 0) break block30;
                            break block31;
                        }
                        if (!this.mInternalUserRequired) break block29;
                        String string = userAttr = this.mAttr.equalsIgnoreCase(CRED_UID) ? attr : ((String[])entryAttributes.get(CRED_UID))[0];
                        if (userAttr != null && userAttr.length() > 0) {
                            logger.debug("Authenticating: InternalUser: 'uid=" + userAttr + "'");
                            User user = this.mUGS.getUser(userAttr);
                            if (user == null) {
                                logger.debug("Missing InternalUser='" + userAttr + "'");
                                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                            }
                            if (this.mInternalGroup != null && this.mInternalGroup.length() > 0) {
                                if (!this.mUGS.isMemberOf(userAttr, this.mInternalGroup)) {
                                    logger.debug("Authenticated: user='" + user.getUserDN() + "' is NOT member of '" + this.mInternalGroup + "'");
                                    throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                                }
                                logger.debug("Authenticated: user='" + user.getUserDN() + "' is member of '" + this.mInternalGroup + "'");
                                break block29;
                            } else {
                                logger.debug("Authenticated: user='" + user.getUserDN() + "'");
                            }
                            break block29;
                        }
                        logger.debug("Incorrect attribute requested: '" + this.mAttr + "' instead of 'uid'");
                        throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                    }
                    catch (LDAPException e) {
                        logger.error("Authenticating: closing bad connection: " + e.getMessage(), (Throwable)e);
                        try {
                            conn.disconnect();
                        }
                        catch (Exception f) {
                            logger.warn("Authenticating: conn.disconnect() exception: " + f.getMessage(), (Throwable)f);
                        }
                        switch (e.getLDAPResultCode()) {
                            case 9: 
                            case 32: {
                                logger.error("UserPwdDirAuthentication: " + CMS.getLogMessage("USER_NOT_EXIST", attr));
                                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                            }
                            case 49: {
                                logger.error("UserPwdDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_BAD_PASSWORD", attr));
                                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                            }
                            case 81: {
                                logger.error("UserPwdDirAuthentication: " + CMS.getLogMessage("LDAP_SERVER_DOWN", new Object[0]));
                                throw new ELdapException(CMS.getUserMessage("CMS_LDAP_SERVER_UNAVAILABLE", conn.getHost(), "" + conn.getPort()));
                            }
                        }
                        logger.error("UserPwdDirAuthentication: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()));
                        throw new ELdapException(CMS.getUserMessage("CMS_LDAP_OTHER_LDAP_EXCEPTION", e.errorCodeToString()));
                    }
                }
                for (int i = 0; i < values.length; ++i) {
                    User user = this.mUGS.getUser(values[i]);
                    if (user == null) continue;
                    if (this.mInternalGroup != null && this.mInternalGroup.length() > 0) {
                        if (!this.mUGS.isMemberOf(values[i], this.mInternalGroup)) continue;
                        verified = true;
                        logger.debug("Authenticated: user='" + user.getUserDN() + "' is member of '" + this.mInternalGroup + "'");
                        continue;
                    }
                    verified = true;
                    logger.debug("Authenticated: user='" + user.getUserDN() + "'");
                }
            }
            if (!verified) {
                logger.debug("Failed to verify userAttribute");
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
        }
        token.set(this.mAttr, attr);
        return userdn;
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }

    @Override
    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement(this.mAttr);
        v.addElement(CRED_PWD);
        return v.elements();
    }

    @Override
    public boolean isValueWriteable(String name) {
        if (name.equals(this.mAttr)) {
            return true;
        }
        if (name.equals(CRED_PWD)) {
            return false;
        }
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(this.mAttr)) {
            return new Descriptor("string", null, null, this.mAttrDesc != null && this.mAttrDesc.length() > 0 ? this.mAttrDesc : CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID", new String[0]));
        }
        if (name.equals(CRED_PWD)) {
            return new Descriptor("password", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_PWD", new String[0]));
        }
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
        request.setExtData("authenticatedName", token.getInString("userDN"));
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    static {
        mExtendedPluginInfo.add("ldap.attrName;string,required;Attribute name like 'cn' or 'uid' allowing to build user's DN by combining user name with base DN for  example  'cn=jsmith, o=company'.");
        mExtendedPluginInfo.add("ldap.attrDesc;string,required;Attribute description like 'LDAP User CN' or 'LDAP User UID' presented on enrollment page.");
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the username and password provided by the user against an LDAP directory. Works with the Dir Based Enrollment HTML form");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authrules-uidpwddirauth");
    }
}

