/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.jobs;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.jobs.Job;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestQueue;
import java.text.DateFormat;
import java.util.Date;

public class RequestInQueueJob
extends Job
implements IExtendedPluginInfo {
    protected static final String PROP_SUBSYSTEM_ID = "subsystemId";
    IAuthority mSub = null;
    RequestQueue mReqQ;
    private boolean mSummary = false;
    protected static String[] mConfigParams = new String[]{"enabled", "cron", "subsystemId", "summary.enabled", "summary.emailSubject", "summary.emailTemplate", "summary.senderEmail", "summary.recipientEmail"};

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"HELP_TEXT; A job that checks for enrollment requests in the queue, and reports to recipientEmail", "cron;string;Format: minute hour dayOfMonth month dayOfWeek. Use '*' for 'every'. For dayOfWeek, 0 is Sunday", "summary.senderEmail;string;Specify the address to be used as the email's 'sender'. Bounces go to this address.", "summary.recipientEmail;string;Who should receive summaries", "enabled;boolean;Enable this plugin", "summary.enabled;boolean;Enable the summary. You must enabled this for the job to work.", "summary.emailSubject;string;Subject of summary email", "summary.emailTemplate;string;Fully qualified pathname of template file of email to be sent", "subsystemId;choice(ca,ra);The type of subsystem this job is for", "HELP_TOKEN;configuration-jobrules-requestinqueuejob"};
        return s;
    }

    @Override
    public void init(JobsScheduler scheduler, String id, String implName, JobConfig config) throws EBaseException {
        super.init(scheduler, id, implName, config);
        String sub = this.mConfig.getString(PROP_SUBSYSTEM_ID);
        this.mSub = (IAuthority)((Object)this.engine.getSubsystem(sub));
        if (this.mSub == null) {
            this.mSummary = false;
            return;
        }
        this.mReqQ = this.engine.getRequestQueue();
        ConfigStore sc = this.mConfig.getSubStore("summary", ConfigStore.class);
        boolean enabled = sc.getBoolean("enabled", false);
        logger.info("RequestInQueueJob: - enabled: " + enabled);
        if (enabled) {
            this.mSummary = true;
            this.mSummaryMailSubject = sc.getString("emailSubject");
            logger.info("RequestInQueueJob: - subject: " + this.mSummaryMailSubject);
            this.mMailForm = sc.getString("emailTemplate");
            logger.info("RequestInQueueJob: - mail template: " + this.mMailForm);
            this.mSummarySenderEmail = sc.getString("senderEmail");
            logger.info("RequestInQueueJob: - sender email: " + this.mSummarySenderEmail);
            this.mSummaryReceiverEmail = sc.getString("recipientEmail");
            logger.info("RequestInQueueJob: - receiver email: " + this.mSummaryReceiverEmail);
        } else {
            this.mSummary = false;
        }
    }

    @Override
    public void run() {
        logger.info("RequestInQueueJob: Running job " + this.mId);
        if (!this.mSummary) {
            return;
        }
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        String nowString = dateFormat.format(date);
        logger.info("RequestInQueueJob: Searching for pending requests");
        int count = 0;
        RequestList list = this.mReqQ.listRequestsByStatus(RequestStatus.PENDING);
        while (list != null && list.hasMoreElements()) {
            RequestId requestID = list.nextRequestId();
            logger.info("RequestInQueueJob: - " + requestID.toHexString());
            ++count;
        }
        String contentForm = null;
        contentForm = this.getTemplateContent(this.mMailForm);
        this.buildContentParams("InstanceID", this.mId);
        this.buildContentParams("SummaryTotalNum", String.valueOf(count));
        this.buildContentParams("ExecutionTime", nowString);
        EmailFormProcessor emailFormProcessor = new EmailFormProcessor();
        String mailContent = emailFormProcessor.getEmailContent(contentForm, this.mContentParams);
        this.mailSummary(mailContent);
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }
}

