/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.EDBNotAvailException;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.Modification;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.LDAPVirtualList;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPPersistSearchControl;
import netscape.ldap.controls.LDAPSortControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPSession
extends DBSSession {
    public static final Logger logger = LoggerFactory.getLogger(LDAPSession.class);
    private DBSubsystem dbSubsystem;
    private LDAPConnection mConn = null;

    public LDAPSession(DBSubsystem dbSubsystem, LDAPConnection c) throws EDBException {
        this.dbSubsystem = dbSubsystem;
        this.mConn = c;
        try {
            this.mConn.setOption(3, (Object)0);
        }
        catch (LDAPException e) {
            throw new EDBException("Unable to create LDAP session: " + e.getMessage(), (Throwable)e);
        }
    }

    public LDAPConnection getConnection() {
        return this.mConn;
    }

    @Override
    public void close() throws EDBException {
        this.dbSubsystem.returnConn(this.mConn);
    }

    @Override
    public void add(String name, IDBObj obj) throws EBaseException {
        logger.info("LDAPSession: Adding " + name);
        try {
            LDAPAttributeSet attrs = this.dbSubsystem.getRegistry().createLDAPAttributeSet(obj);
            Enumeration e = attrs.getAttributes();
            while (e.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                String[] values = attr.getStringValueArray();
                if (values == null) continue;
                logger.debug("LDAPSession: - " + attr.getName());
            }
            e = new LDAPEntry(name, attrs);
            this.mConn.add((LDAPEntry)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]), (Throwable)e);
            }
            throw new EDBException("Unable to add LDAP entry: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IDBObj read(String name) throws EBaseException {
        return this.read(name, null);
    }

    @Override
    public IDBObj read(String name, String[] attrs) throws EBaseException {
        try {
            String[] ldapattrs = null;
            if (attrs != null) {
                ldapattrs = this.dbSubsystem.getRegistry().getLDAPAttributes(attrs);
            }
            logger.info("LDAPSession: Retrieving " + name);
            LDAPSearchResults res = this.mConn.search(name, 0, "(objectclass=*)", ldapattrs, false);
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            LDAPAttributeSet attrSet = entry.getAttributeSet();
            Enumeration e = attrSet.getAttributes();
            while (e.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                String[] values = attr.getStringValueArray();
                if (values == null) continue;
                logger.debug("LDAPSession: - " + attr.getName());
            }
            return this.dbSubsystem.getRegistry().createObject(attrSet);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]), (Throwable)e);
            }
            if (e.getLDAPResultCode() == 32) {
                throw new EDBRecordNotFoundException(CMS.getUserMessage("CMS_DBS_RECORD_NOT_FOUND", new String[0]), (Throwable)e);
            }
            throw new EDBException("Unable to read LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void delete(String name) throws EBaseException {
        logger.info("LDAPSession: Deleting " + name);
        try {
            this.mConn.delete(name);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to delete LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void modify(String name, ModificationSet mods) throws EBaseException {
        logger.info("LDAPSession: Modifying " + name);
        try {
            LDAPModificationSet ldapMods = new LDAPModificationSet();
            Enumeration e = mods.getModifications();
            while (e.hasMoreElements()) {
                Modification mod = (Modification)e.nextElement();
                LDAPAttributeSet attrs = new LDAPAttributeSet();
                this.dbSubsystem.getRegistry().mapObject(null, mod.getName(), mod.getValue(), attrs);
                Enumeration e0 = attrs.getAttributes();
                while (e0.hasMoreElements()) {
                    int op = this.toLdapModOp(mod.getOp());
                    LDAPAttribute attr = (LDAPAttribute)e0.nextElement();
                    switch (op) {
                        case 0: {
                            logger.debug("LDAPSession: - add: " + attr.getName());
                            break;
                        }
                        case 1: {
                            logger.debug("LDAPSession: - delete: " + attr.getName());
                            break;
                        }
                        case 2: {
                            logger.debug("LDAPSession: - replace: " + attr.getName());
                        }
                    }
                    ldapMods.add(op, attr);
                }
            }
            this.mConn.modify(name, ldapMods);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            if (e.getLDAPResultCode() == 32) {
                throw new EDBRecordNotFoundException(CMS.getUserMessage("CMS_DBS_RECORD_NOT_FOUND", new String[0]));
            }
            throw new EDBException("Unable to modify LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    private int toLdapModOp(int modOp) throws EBaseException {
        switch (modOp) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new EBaseException(CMS.getUserMessage("CMS_DBS_LDAP_OP_FAILURE", Integer.toString(modOp)));
    }

    @Override
    public DBSearchResults search(String base, String filter) throws EBaseException {
        return this.search(base, filter, null);
    }

    @Override
    public DBSearchResults search(String base, String filter, int maxSize) throws EBaseException {
        try {
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(maxSize);
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return new DBSearchResults(this.dbSubsystem.getRegistry(), (Enumeration<Object>)res);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DBSearchResults search(String base, String filter, int maxSize, String sortAttribute) throws EBaseException {
        try {
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(maxSize);
            if (sortAttribute != null) {
                LDAPSortKey sortOrder = new LDAPSortKey(sortAttribute);
                LDAPSortControl sortCtrl = new LDAPSortControl(sortOrder, true);
                cons.setServerControls((LDAPControl)sortCtrl);
            }
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return new DBSearchResults(this.dbSubsystem.getRegistry(), (Enumeration<Object>)res);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DBSearchResults search(String base, String filter, int maxSize, int timeLimit) throws EBaseException {
        try {
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(maxSize);
            cons.setServerTimeLimit(timeLimit);
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return new DBSearchResults(this.dbSubsystem.getRegistry(), (Enumeration<Object>)res);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DBSearchResults search(String base, String filter, int maxSize, int timeLimit, String sortAttribute) throws EBaseException {
        try {
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(maxSize);
            cons.setServerTimeLimit(timeLimit);
            if (sortAttribute != null) {
                LDAPSortKey sortOrder = new LDAPSortKey(sortAttribute);
                LDAPSortControl sortCtrl = new LDAPSortControl(sortOrder, true);
                cons.setServerControls((LDAPControl)sortCtrl);
            }
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return new DBSearchResults(this.dbSubsystem.getRegistry(), (Enumeration<Object>)res);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DBSearchResults search(String base, String filter, String[] attrs) throws EBaseException {
        try {
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            if (attrs != null) {
                ldapattrs = this.dbSubsystem.getRegistry().getLDAPAttributes(attrs);
            }
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(0);
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return new DBSearchResults(this.dbSubsystem.getRegistry(), (Enumeration<Object>)res);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LDAPSearchResults persistentSearch(String base, String filter, String[] attrs) throws EBaseException {
        try {
            Integer version;
            String ldapfilter = this.dbSubsystem.getRegistry().getFilter(filter);
            logger.info("LDAPSession: Searching " + base + " for " + ldapfilter);
            String[] ldapattrs = null;
            if (attrs != null) {
                ldapattrs = this.dbSubsystem.getRegistry().getLDAPAttributes(attrs);
            }
            if ((version = (Integer)this.mConn.getOption(17)) == 2) {
                this.mConn.setOption(17, (Object)3);
            }
            int op = 4;
            boolean changesOnly = true;
            boolean returnControls = true;
            boolean isCritical = true;
            LDAPPersistSearchControl persistCtrl = new LDAPPersistSearchControl(op, changesOnly, returnControls, isCritical);
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setBatchSize(0);
            cons.setServerControls((LDAPControl)persistCtrl);
            LDAPSearchResults res = this.mConn.search(base, 1, ldapfilter, ldapattrs, false, cons);
            return res;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to search LDAP record: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void abandon(LDAPSearchResults results) throws EBaseException {
        logger.debug("LDAPSession: abandon()");
        try {
            this.mConn.abandon(results);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            throw new EDBException("Unable to abandon LDAP search result: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs);
    }

    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs, String[] sortKey) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs, sortKey);
    }

    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs, String sortKey) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs, sortKey);
    }

    @Override
    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs, String[] sortKey, int pageSize) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs, sortKey, pageSize);
    }

    @Override
    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs, String sortKey, int pageSize) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs, sortKey, pageSize);
    }

    @Override
    public <T extends IDBObj> DBVirtualList<T> createVirtualList(String base, String filter, String[] attrs, String startFrom, String sortKey, int pageSize) throws EBaseException {
        logger.debug("LDAPSession: createVirtualList(" + base + ", " + filter + ")");
        return new LDAPVirtualList(this.dbSubsystem.getRegistry(), this.mConn, base, filter, attrs, startFrom, sortKey, pageSize);
    }

    public void release(Object obj) {
    }
}

