/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.session;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.SecurityDomainSessionTable;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPSecurityDomainSessionTable
extends SecurityDomainSessionTable {
    public static Logger logger = LoggerFactory.getLogger(LDAPSecurityDomainSessionTable.class);
    protected CMSEngine engine;
    private LdapBoundConnFactory mLdapConnFactory;

    public LDAPSecurityDomainSessionTable(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() throws ELdapException, EBaseException {
        EngineConfig cs = this.engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LDAPConfig internaldb = cs.getInternalDBConfig();
        this.mLdapConnFactory = new LdapBoundConnFactory("LDAPSecurityDomainSessionTable");
        this.mLdapConnFactory.setCMSEngine(this.engine);
        this.mLdapConnFactory.init(socketConfig, internaldb, this.engine.getPasswordStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String sessionId, String ip, String uid, String group) throws Exception {
        EngineConfig cs = this.engine.getConfig();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        LDAPConnection conn = null;
        String basedn = ldapConfig.getBaseDN();
        String sessionsdn = "ou=sessions,ou=Security Domain," + basedn;
        try {
            LDAPEntry entry;
            LDAPAttributeSet attrs;
            block9: {
                conn = this.mLdapConnFactory.getConn();
                attrs = new LDAPAttributeSet();
                attrs.add(new LDAPAttribute("objectclass", "top"));
                attrs.add(new LDAPAttribute("objectclass", "organizationalUnit"));
                attrs.add(new LDAPAttribute("ou", "sessions"));
                entry = new LDAPEntry(sessionsdn, attrs);
                try {
                    conn.add(entry);
                }
                catch (LDAPException e) {
                    if (e.getLDAPResultCode() == 68) break block9;
                    logger.error("SecurityDomainSessionTable: Unable to create ou=sessions: " + e.getMessage(), (Throwable)e);
                    throw new PKIException("Unable to create ou=sessions: " + e.getMessage(), (Throwable)e);
                }
            }
            String entrydn = "cn=" + sessionId + "," + sessionsdn;
            attrs = new LDAPAttributeSet();
            attrs.add(new LDAPAttribute("objectclass", "top"));
            attrs.add(new LDAPAttribute("objectclass", "securityDomainSessionEntry"));
            attrs.add(new LDAPAttribute("cn", sessionId));
            attrs.add(new LDAPAttribute("host", ip));
            attrs.add(new LDAPAttribute("uid", uid));
            attrs.add(new LDAPAttribute("cmsUserGroup", group));
            attrs.add(new LDAPAttribute("dateOfCreate", Long.toString(new Date().getTime())));
            entry = new LDAPEntry(entrydn, attrs);
            conn.add(entry);
            logger.info("SecurityDomainSessionTable: added session entry " + sessionId);
        }
        finally {
            try {
                this.mLdapConnFactory.returnConn(conn);
            }
            catch (Exception e) {
                logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeEntry(String sessionId) throws Exception {
        block11: {
            EngineConfig cs = this.engine.getConfig();
            LDAPConfig ldapConfig = cs.getInternalDBConfig();
            LDAPConnection conn = null;
            String basedn = ldapConfig.getBaseDN();
            String dn = "cn=" + sessionId + ",ou=sessions,ou=Security Domain," + basedn;
            conn = this.mLdapConnFactory.getConn();
            conn.delete(dn);
            try {
                this.mLdapConnFactory.returnConn(conn);
            }
            catch (Exception e) {
                logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
            }
            break block11;
            catch (LDAPException e) {
                block10: {
                    try {
                        if (e.getLDAPResultCode() == 32) break block10;
                        logger.error("SecurityDomainSessionTable: unable to delete session " + sessionId + ": " + e.getMessage(), (Throwable)e);
                        throw new PKIException("Unable to delete session: " + sessionId + ": " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.mLdapConnFactory.returnConn(conn);
                        }
                        catch (Exception e2) {
                            logger.warn("Unable to return LDAP connection: " + e2.getMessage(), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.mLdapConnFactory.returnConn(conn);
                }
                catch (Exception e3) {
                    logger.warn("Unable to return LDAP connection: " + e3.getMessage(), (Throwable)e3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sessionExists(String sessionId) throws Exception {
        boolean ret;
        LDAPConnection conn;
        block6: {
            EngineConfig cs = this.engine.getConfig();
            LDAPConfig ldapConfig = cs.getInternalDBConfig();
            conn = null;
            ret = false;
            try {
                String basedn = ldapConfig.getBaseDN();
                String sessionsdn = "ou=sessions,ou=Security Domain," + basedn;
                String filter = "(cn=" + sessionId + ")";
                String[] attrs = new String[]{"cn"};
                conn = this.mLdapConnFactory.getConn();
                LDAPSearchResults res = conn.search(sessionsdn, 2, filter, attrs, false);
                if (res.getCount() <= 0) break block6;
                ret = true;
            }
            catch (Throwable throwable) {
                try {
                    this.mLdapConnFactory.returnConn(conn);
                }
                catch (Exception e) {
                    logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            this.mLdapConnFactory.returnConn(conn);
        }
        catch (Exception e) {
            logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration<String> getSessionIDs() throws Exception {
        logger.debug("LDAPSecurityDomainSessionTable: getSessionIds() ");
        EngineConfig cs = this.engine.getConfig();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        LDAPConnection conn = null;
        Vector<String> ret = new Vector<String>();
        String basedn = ldapConfig.getBaseDN();
        String sessionsdn = "ou=sessions,ou=Security Domain," + basedn;
        String filter = "(objectclass=securityDomainSessionEntry)";
        String[] attrs = new String[]{"cn"};
        logger.debug("LDAPSecurityDomainSessionTable: searching " + sessionsdn);
        conn = this.mLdapConnFactory.getConn();
        LDAPSearchResults res = conn.search(sessionsdn, 2, filter, attrs, false);
        while (res.hasMoreElements()) {
            LDAPEntry entry = res.next();
            LDAPAttribute sid = entry.getAttribute("cn");
            if (sid == null) {
                logger.error("LDAPSecurityDomainSessionTable: Missing session ID: " + entry.getDN());
                throw new Exception("Missing session ID: " + entry.getDN());
            }
            ret.add(sid.getStringValueArray()[0]);
        }
        this.mLdapConnFactory.returnConn(conn);
        return ret.elements();
        catch (Exception e) {
            logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
        }
        return ret.elements();
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 32: {
                    logger.debug("SecurityDomainSessionTable: no active sessions, ignore");
                    return ret.elements();
                }
                default: {
                    logger.error("SecurityDomainSessionTable: RC: " + e.getLDAPResultCode());
                    throw e;
                }
            }
        }
        finally {
            try {
                this.mLdapConnFactory.returnConn(conn);
            }
            catch (Exception e) {
                logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValue(String sessionId, String attr) throws Exception {
        String ret;
        LDAPConnection conn;
        block7: {
            EngineConfig cs = this.engine.getConfig();
            LDAPConfig ldapConfig = cs.getInternalDBConfig();
            conn = null;
            ret = null;
            try {
                String basedn = ldapConfig.getBaseDN();
                String sessionsdn = "ou=sessions,ou=Security Domain," + basedn;
                String filter = "(cn=" + sessionId + ")";
                String[] attrs = new String[]{attr};
                conn = this.mLdapConnFactory.getConn();
                LDAPSearchResults res = conn.search(sessionsdn, 2, filter, attrs, false);
                if (res.getCount() <= 0) break block7;
                LDAPEntry entry = res.next();
                LDAPAttribute searchAttribute = entry.getAttribute(attr);
                if (searchAttribute == null) {
                    throw new Exception("No Attribute " + attr + " for this session in LDAPEntry " + entry.getDN());
                }
                ret = searchAttribute.getStringValueArray()[0];
            }
            catch (Throwable throwable) {
                try {
                    this.mLdapConnFactory.returnConn(conn);
                }
                catch (Exception e) {
                    logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            this.mLdapConnFactory.returnConn(conn);
        }
        catch (Exception e) {
            logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public String getIP(String sessionId) throws Exception {
        return this.getStringValue(sessionId, "host");
    }

    public String getUID(String sessionId) throws Exception {
        return this.getStringValue(sessionId, "uid");
    }

    public String getGroup(String sessionId) throws Exception {
        return this.getStringValue(sessionId, "cmsUserGroup");
    }

    public long getBeginTime(String sessionId) throws Exception {
        String beginStr = this.getStringValue(sessionId, "dateOfCreate");
        if (beginStr != null) {
            return Long.parseLong(beginStr);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws Exception {
        EngineConfig cs = this.engine.getConfig();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        LDAPConnection conn = null;
        int ret = 0;
        try {
            String basedn = ldapConfig.getBaseDN();
            String sessionsdn = "ou=sessions,ou=Security Domain," + basedn;
            String filter = "(objectclass=securityDomainSessionEntry)";
            String[] attrs = new String[]{"cn"};
            conn = this.mLdapConnFactory.getConn();
            LDAPSearchResults res = conn.search(sessionsdn, 2, filter, attrs, false);
            ret = res.getCount();
        }
        catch (Throwable throwable) {
            try {
                this.mLdapConnFactory.returnConn(conn);
            }
            catch (Exception e) {
                logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.mLdapConnFactory.returnConn(conn);
        }
        catch (Exception e) {
            logger.warn("Unable to return LDAP connection: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public void shutdown() {
        try {
            this.mLdapConnFactory.reset();
        }
        catch (ELdapException e) {
            logger.warn("Unable to reset connection factory");
        }
    }
}

