/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAsString {
    public static Logger logger = LoggerFactory.getLogger(FileAsString.class);
    protected String mFilename;
    protected long mLastRead = 0L;
    private String fileContents = null;
    private Object userObject = null;

    public FileAsString(String filename) throws IOException {
        this.mFilename = filename;
        this.readFile();
    }

    public boolean fileHasChanged() throws IOException {
        File file = new File(this.mFilename);
        long lastmodified = file.lastModified();
        return lastmodified != this.mLastRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() throws IOException {
        BufferedReader br = this.createBufferedReader(this.mFilename);
        StringBuffer buf = new StringBuffer();
        int bytesread = 0;
        try {
            do {
                char[] cbuf;
                if ((bytesread = br.read(cbuf = new char[16], 0, cbuf.length)) <= 0) continue;
                buf.append(cbuf, 0, bytesread);
            } while (bytesread != -1);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        this.fileContents = new String(buf);
    }

    private BufferedReader createBufferedReader(String filename) throws IOException {
        logger.trace("createBufferedReader(filename=" + filename + ")");
        BufferedReader br = null;
        FileReader fr = null;
        File file = new File(filename);
        this.mLastRead = file.lastModified();
        fr = new FileReader(file);
        br = new BufferedReader(fr);
        this.mFilename = filename;
        return br;
    }

    public String getAsString() throws IOException {
        if (this.fileHasChanged()) {
            this.readFile();
        }
        return this.fileContents;
    }

    public Object getUserObject() {
        try {
            if (this.fileHasChanged()) {
                this.userObject = null;
            }
        }
        catch (Exception e) {
            this.userObject = null;
        }
        return this.userObject;
    }

    public void setUserObject(Object x) {
        this.userObject = x;
    }

    public String getFilename() {
        return this.mFilename;
    }
}

