/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedDeleteRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedDeleteResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedDeleteOperation
extends InterceptedOperation
implements InMemoryInterceptedDeleteRequest,
InMemoryInterceptedDeleteResult {
    @NotNull
    private DeleteRequest deleteRequest;
    @Nullable
    private LDAPResult deleteResult;

    InterceptedDeleteOperation(@NotNull LDAPListenerClientConnection clientConnection, int messageID, @NotNull DeleteRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.deleteRequest = requestOp.toDeleteRequest(requestControls);
        this.deleteResult = null;
    }

    @Override
    @NotNull
    public ReadOnlyDeleteRequest getRequest() {
        return this.deleteRequest;
    }

    @Override
    public void setRequest(@NotNull DeleteRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    @Override
    @Nullable
    public LDAPResult getResult() {
        return this.deleteResult;
    }

    @Override
    public void setResult(@NotNull LDAPResult deleteResult) {
        this.deleteResult = deleteResult;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedDeleteOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.deleteRequest);
        buffer.append(", result=");
        buffer.append(this.deleteResult);
        buffer.append(')');
    }
}

