/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.net.InetAddress;
import org.apache.lucene.util.FutureArrays;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.network.InetAddresses;

public class CIDRUtils {
    static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};

    private CIDRUtils() {
    }

    public static boolean isInRange(String address, String ... cidrAddresses) {
        byte[] addr = InetAddresses.forString(address).getAddress();
        if (cidrAddresses == null || cidrAddresses.length == 0) {
            return false;
        }
        for (String cidrAddress : cidrAddresses) {
            byte[] upper;
            byte[] lower;
            if (cidrAddress == null) continue;
            if (cidrAddress.contains("/")) {
                Tuple<byte[], byte[]> range = CIDRUtils.getLowerUpper(InetAddresses.parseCidr(cidrAddress));
                lower = range.v1();
                upper = range.v2();
            } else {
                upper = lower = InetAddresses.forString(cidrAddress).getAddress();
            }
            if (!CIDRUtils.isBetween(addr, lower, upper)) continue;
            return true;
        }
        return false;
    }

    private static Tuple<byte[], byte[]> getLowerUpper(Tuple<InetAddress, Integer> cidr) {
        InetAddress value = cidr.v1();
        Integer prefixLength = cidr.v2();
        if (prefixLength < 0 || prefixLength > 8 * value.getAddress().length) {
            throw new IllegalArgumentException("illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
        }
        byte[] lower = value.getAddress();
        byte[] upper = value.getAddress();
        for (int i = prefixLength.intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        return new Tuple<byte[], byte[]>(lower, upper);
    }

    private static boolean isBetween(byte[] addr, byte[] lower, byte[] upper) {
        if (addr.length != lower.length) {
            addr = CIDRUtils.encode(addr);
            lower = CIDRUtils.encode(lower);
            upper = CIDRUtils.encode(upper);
        }
        return FutureArrays.compareUnsigned(lower, 0, lower.length, addr, 0, addr.length) <= 0 && FutureArrays.compareUnsigned(upper, 0, upper.length, addr, 0, addr.length) >= 0;
    }

    private static byte[] encode(byte[] address) {
        if (address.length == 4) {
            byte[] mapped = new byte[16];
            System.arraycopy(IPV4_PREFIX, 0, mapped, 0, IPV4_PREFIX.length);
            System.arraycopy(address, 0, mapped, IPV4_PREFIX.length, address.length);
            address = mapped;
        } else if (address.length != 16) {
            throw new UnsupportedOperationException("Only IPv4 and IPv6 addresses are supported");
        }
        return address;
    }
}

