/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.BooleanScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.BooleanScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.BooleanScriptFieldTermQuery;

public final class BooleanScriptFieldType
extends AbstractScriptFieldType<BooleanFieldScript.LeafFactory> {
    private static final BooleanFieldScript.Factory PARSE_FROM_SOURCE = (field, params, lookup) -> ctx -> new BooleanFieldScript(field, params, lookup, ctx){

        @Override
        public void execute() {
            for (Object v : this.extractFromSource(field)) {
                if (v instanceof Boolean) {
                    this.emit((Boolean)v);
                    continue;
                }
                if (!(v instanceof String)) continue;
                try {
                    this.emit(Booleans.parseBoolean((String)v));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    };
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<BooleanFieldScript.Factory>(name, BooleanFieldScript.CONTEXT, PARSE_FROM_SOURCE){

        @Override
        RuntimeField newRuntimeField(BooleanFieldScript.Factory scriptFactory) {
            return new BooleanScriptFieldType(this.name, scriptFactory, this.getScript(), this.meta(), (ToXContent)this);
        }
    });

    public BooleanScriptFieldType(String name) {
        this(name, PARSE_FROM_SOURCE, null, Collections.emptyMap(), (XContentBuilder builder, ToXContent.Params params) -> builder);
    }

    BooleanScriptFieldType(String name, BooleanFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, ToXContent toXContent) {
        super(name, (SearchLookup searchLookup) -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup), script, meta, toXContent);
    }

    @Override
    public String typeName() {
        return "boolean";
    }

    @Override
    public Object valueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        switch (value.toString()) {
            case "F": {
                return false;
            }
            case "T": {
                return true;
            }
        }
        throw new IllegalArgumentException("Expected [T] or [F] but got [" + value + "]");
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        return DocValueFormat.BOOLEAN;
    }

    @Override
    public BooleanScriptFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return new BooleanScriptFieldData.Builder(this.name(), (BooleanFieldScript.LeafFactory)this.leafFactory(searchLookup.get()));
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new BooleanScriptFieldExistsQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        boolean falseAllowed;
        boolean trueAllowed;
        if (BooleanScriptFieldType.toBoolean(lowerTerm)) {
            if (includeLower) {
                trueAllowed = true;
                falseAllowed = false;
            } else {
                trueAllowed = false;
                falseAllowed = false;
            }
        } else if (includeLower) {
            trueAllowed = true;
            falseAllowed = true;
        } else {
            trueAllowed = true;
            falseAllowed = false;
        }
        if (BooleanScriptFieldType.toBoolean(upperTerm)) {
            if (includeUpper) {
                trueAllowed &= true;
                falseAllowed &= true;
            } else {
                trueAllowed &= false;
                falseAllowed &= true;
            }
        } else if (includeUpper) {
            trueAllowed &= false;
            falseAllowed &= true;
        } else {
            trueAllowed &= false;
            falseAllowed &= false;
        }
        return this.termsQuery(trueAllowed, falseAllowed, context);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context.lookup()), this.name(), BooleanScriptFieldType.toBoolean(value, true));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), BooleanScriptFieldType.toBoolean(value, false));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.newMatchNoDocsQuery("Empty terms query");
        }
        boolean trueAllowed = false;
        boolean falseAllowed = false;
        for (Object value : values) {
            if (BooleanScriptFieldType.toBoolean(value, false)) {
                trueAllowed = true;
                continue;
            }
            falseAllowed = true;
        }
        return this.termsQuery(trueAllowed, falseAllowed, context);
    }

    private Query termsQuery(boolean trueAllowed, boolean falseAllowed, SearchExecutionContext context) {
        if (trueAllowed) {
            if (falseAllowed) {
                return this.existsQuery(context);
            }
            this.checkAllowExpensiveQueries(context);
            return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), true);
        }
        if (falseAllowed) {
            this.checkAllowExpensiveQueries(context);
            return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), false);
        }
        return new MatchNoDocsQuery("neither true nor false allowed");
    }

    private static boolean toBoolean(Object value) {
        return BooleanScriptFieldType.toBoolean(value, false);
    }

    private static boolean toBoolean(Object value, boolean caseInsensitive) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
        if (caseInsensitive) {
            sValue = Strings.toLowercaseAscii(sValue);
        }
        return Booleans.parseBoolean(sValue);
    }
}

