/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;

public interface RuntimeField
extends ToXContentFragment {
    @Override
    default public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name());
        builder.field("type", this.typeName());
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public String name();

    public String typeName();

    public MappedFieldType asMappedFieldType();

    public static Map<String, RuntimeField> parseRuntimeFields(Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext, boolean supportsRemoval) {
        HashMap<String, RuntimeField> runtimeFields = new HashMap<String, RuntimeField>();
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            if (entry.getValue() == null) {
                if (supportsRemoval) {
                    runtimeFields.put(fieldName, null);
                    continue;
                }
                throw new MapperParsingException("Runtime field [" + fieldName + "] was set to null but its removal is not supported in this context");
            }
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> propNode = new HashMap<String, Object>((Map)entry.getValue());
                Object typeNode = propNode.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("No type specified for runtime field [" + fieldName + "]");
                }
                String type = typeNode.toString();
                Parser typeParser = parserContext.runtimeFieldParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on runtime field [" + fieldName + "]");
                }
                runtimeFields.put(fieldName, typeParser.parse(fieldName, propNode, parserContext));
                propNode.remove("type");
                MappingParser.checkNoRemainingFields(fieldName, propNode);
                iterator.remove();
                continue;
            }
            throw new MapperParsingException("Expected map for runtime field [" + fieldName + "] definition but got a " + entry.getValue().getClass().getName());
        }
        return Collections.unmodifiableMap(runtimeFields);
    }

    public static final class Parser {
        private final Function<String, Builder> builderFunction;

        public Parser(Function<String, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        RuntimeField parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name);
            builder.parse(name, parserContext, node);
            builder.validate();
            return builder.createRuntimeField(parserContext);
        }
    }

    public static abstract class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        protected Builder(String name) {
            super(name);
        }

        public Map<String, String> meta() {
            return this.meta.getValue();
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.meta);
        }

        @Override
        public FieldMapper.Builder init(FieldMapper initializer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FieldMapper build(ContentPath context) {
            throw new UnsupportedOperationException();
        }

        protected abstract RuntimeField createRuntimeField(Mapper.TypeParser.ParserContext var1);

        private void validate() {
            ContentPath contentPath = Builder.parentPath(this.name());
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build(this, contentPath);
            if (multiFields.iterator().hasNext()) {
                throw new IllegalArgumentException("runtime field [" + this.name + "] does not support [fields]");
            }
            FieldMapper.CopyTo copyTo = this.copyTo.build();
            if (!copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("runtime field [" + this.name + "] does not support [copy_to]");
            }
        }
    }
}

