/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptCache;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class AbstractFieldScript {
    public static final int MAX_VALUES = 100;
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.common.collect.Map.of("_source", value -> ((SourceLookup)value).source());
    protected final String fieldName;
    private final Map<String, Object> params;
    protected final LeafSearchLookup leafSearchLookup;

    static <F> ScriptContext<F> newContext(String name, Class<F> factoryClass) {
        return new ScriptContext<F>(name, factoryClass, 100, TimeValue.timeValueMillis(0L), ScriptCache.UNLIMITED_COMPILATION_RATE.asTuple(), false);
    }

    public AbstractFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        this.fieldName = fieldName;
        this.leafSearchLookup = searchLookup.getLeafSearchLookup(ctx);
        params = new HashMap<String, Object>(params);
        params.put("_source", this.leafSearchLookup.source());
        params.put("_fields", this.leafSearchLookup.fields());
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
    }

    public final void setDocument(int docId) {
        this.leafSearchLookup.setDocument(docId);
    }

    public final Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafSearchLookup.doc();
    }

    protected final List<Object> extractFromSource(String path) {
        return XContentMapValues.extractRawValues(path, this.leafSearchLookup.source().source());
    }

    protected final void checkMaxSize(int currentSize) {
        if (currentSize >= 100) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Runtime field [%s] is emitting [%s] values while the maximum number of values allowed is [%s]", this.fieldName, currentSize + 1, 100));
        }
    }

    public abstract void execute();
}

