/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.function.DoubleConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class DoubleFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = DoubleFieldScript.newContext("double_field", Factory.class);
    public static final String[] PARAMETERS = new String[0];
    private double[] values = new double[1];
    private int count;

    public DoubleFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public final void runForDoc(int docId) {
        this.count = 0;
        this.setDocument(docId);
        this.execute();
    }

    public final void runForDoc(int docId, DoubleConsumer consumer) {
        this.runForDoc(docId);
        for (int i = 0; i < this.count; ++i) {
            consumer.accept(this.values[i]);
        }
    }

    public final double[] values() {
        return this.values;
    }

    public final int count() {
        return this.count;
    }

    public final void emit(double v) {
        this.checkMaxSize(this.count);
        if (this.values.length < this.count + 1) {
            this.values = ArrayUtil.grow(this.values, this.count + 1);
        }
        this.values[this.count++] = v;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static class Emit {
        private final DoubleFieldScript script;

        public Emit(DoubleFieldScript script) {
            this.script = script;
        }

        public void emit(double v) {
            this.script.emit(v);
        }
    }

    public static interface LeafFactory {
        public DoubleFieldScript newInstance(LeafReaderContext var1);
    }
}

