/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class GeoPointFieldScript
extends AbstractLongFieldScript {
    public static final ScriptContext<Factory> CONTEXT = GeoPointFieldScript.newContext("geo_point_field", Factory.class);
    public static final String[] PARAMETERS = new String[0];

    public GeoPointFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public void runGeoPointForDoc(int doc, Consumer<GeoPoint> consumer) {
        this.runForDoc(doc);
        GeoPoint point = new GeoPoint();
        for (int i = 0; i < this.count(); ++i) {
            int lat = (int)(this.values()[i] >>> 32);
            int lon = (int)(this.values()[i] & 0xFFFFFFFFFFFFFFFFL);
            point.reset(GeoEncodingUtils.decodeLatitude(lat), GeoEncodingUtils.decodeLongitude(lon));
            consumer.accept(point);
        }
    }

    protected void emit(double lat, double lon) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(lat);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(lon);
        this.emit((long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static class Emit {
        private final GeoPointFieldScript script;

        public Emit(GeoPointFieldScript script) {
            this.script = script;
        }

        public void emit(double lat, double lon) {
            this.script.emit(lat, lon);
        }
    }

    public static interface LeafFactory {
        public GeoPointFieldScript newInstance(LeafReaderContext var1);
    }
}

