/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S2278")
public class AvoidDESCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("javax.crypto.Cipher").names("getInstance").withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArg);
        if (defaultPropertyValue == null) {
            defaultPropertyValue = firstArg;
        }
        defaultPropertyValue.asConstant(String.class).ifPresent(defaultProperty -> this.checkIssue(firstArg, (String)defaultProperty));
    }

    private void checkIssue(ExpressionTree argumentForReport, String argument) {
        String[] transformationElements = argument.split("/");
        if (transformationElements.length > 0 && AvoidDESCheck.isExcludedAlgorithm(transformationElements[0])) {
            this.reportIssue(argumentForReport, "Use the recommended AES (Advanced Encryption Standard) instead.");
        }
    }

    private static boolean isExcludedAlgorithm(String algorithm) {
        return "DES".equals(algorithm) || "DESede".equals(algorithm) || "RC2".equals(algorithm);
    }
}

