/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2097")
public class EqualsArgumentTypeCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("*").build();
    private static final MethodMatchers GETCLASS_MATCHER = MethodMatchers.create().ofAnyType().names("getClass").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        Symbol parameterSymbol;
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() != null && "equals".equals(methodTree.symbol().name()) && methodTree.parameters().size() == 1 && (parameterSymbol = methodTree.parameters().get(0).symbol()).type().is("java.lang.Object")) {
            CastVisitor castVisitor = new CastVisitor(parameterSymbol);
            methodTree.accept(castVisitor);
            if (castVisitor.hasUncheckedCast) {
                this.reportIssue(methodTree.simpleName(), "Add a type test to this method.");
            }
        }
    }

    private static boolean isArgument(ExpressionTree tree, Symbol parameterSymbol) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses(tree);
        return expressionTree.is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)expressionTree).symbol().equals(parameterSymbol);
    }

    private static class ExpressionVisitor
    extends BaseTreeVisitor {
        private final Symbol parameterSymbol;
        private boolean typeChecked;

        ExpressionVisitor(Symbol parameterSymbol) {
            this.parameterSymbol = parameterSymbol;
        }

        @Override
        public void visitInstanceOf(InstanceOfTree tree) {
            if (EqualsArgumentTypeCheck.isArgument(tree.expression(), this.parameterSymbol)) {
                this.typeChecked = true;
            }
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO) && (this.isGetClassOnArgument(tree.leftOperand()) || this.isGetClassOnArgument(tree.rightOperand()))) {
                this.typeChecked = true;
            } else {
                super.visitBinaryExpression(tree);
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            ExpressionTree methodSelect;
            if (EQUALS_MATCHER.matches(tree) && ((methodSelect = tree.methodSelect()).is(Tree.Kind.MEMBER_SELECT) && this.isGetClassOnArgument(((MemberSelectExpressionTree)methodSelect).expression()) || this.isGetClassOnArgument((ExpressionTree)tree.arguments().get(0)))) {
                this.typeChecked = true;
                return;
            }
            for (ExpressionTree argument : tree.arguments()) {
                if (!EqualsArgumentTypeCheck.isArgument(argument, this.parameterSymbol)) continue;
                this.typeChecked = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isGetClassOnArgument(ExpressionTree tree) {
            ExpressionTree expressionTree = ExpressionUtils.skipParentheses(tree);
            return expressionTree.is(Tree.Kind.METHOD_INVOCATION) && GETCLASS_MATCHER.matches((MethodInvocationTree)expressionTree) && this.isInvocationOnArgument((MethodInvocationTree)expressionTree);
        }

        private boolean isInvocationOnArgument(MethodInvocationTree tree) {
            return tree.methodSelect().is(Tree.Kind.MEMBER_SELECT) && EqualsArgumentTypeCheck.isArgument(((MemberSelectExpressionTree)tree.methodSelect()).expression(), this.parameterSymbol);
        }
    }

    private static class CastVisitor
    extends BaseTreeVisitor {
        private final Symbol parameterSymbol;
        boolean typeChecked = false;
        boolean hasUncheckedCast = false;

        public CastVisitor(Symbol parameterSymbol) {
            this.parameterSymbol = parameterSymbol;
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(Tree.Kind.CONDITIONAL_AND)) {
                ExpressionVisitor expressionVisitor = new ExpressionVisitor(this.parameterSymbol);
                tree.leftOperand().accept(expressionVisitor);
                if (expressionVisitor.typeChecked) {
                    this.typeChecked = true;
                    return;
                }
                this.scan(tree.rightOperand());
            } else {
                super.visitBinaryExpression(tree);
            }
        }

        @Override
        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            ExpressionVisitor expressionVisitor = new ExpressionVisitor(this.parameterSymbol);
            tree.condition().accept(expressionVisitor);
            if (expressionVisitor.typeChecked) {
                this.typeChecked = true;
                return;
            }
            this.scan(tree.trueExpression());
            this.scan(tree.falseExpression());
        }

        @Override
        public void visitIfStatement(IfStatementTree tree) {
            ExpressionVisitor expressionVisitor = new ExpressionVisitor(this.parameterSymbol);
            tree.condition().accept(expressionVisitor);
            if (expressionVisitor.typeChecked) {
                this.typeChecked = true;
                return;
            }
            this.scan(tree.thenStatement());
            this.scan(tree.elseStatement());
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            if (EqualsArgumentTypeCheck.isArgument(tree.expression(), this.parameterSymbol) && !this.typeChecked) {
                this.hasUncheckedCast = true;
            } else {
                super.visitTypeCast(tree);
            }
        }
    }
}

