/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1145")
public class IfConditionAlwaysTrueOrFalseCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree condition = ((IfStatementTree)tree).condition();
        if (condition.is(Tree.Kind.BOOLEAN_LITERAL)) {
            this.reportIssue(condition, "Remove this if statement.");
        }
    }
}

