/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ObjectFinalizeOverridenCheck", repositoryKey="squid")
@Rule(key="S1113")
public class ObjectFinalizeOverridenCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverridenCheck.isFinalize(methodTree)) {
            this.reportIssue(methodTree.simpleName(), "Do not override the Object.finalize() method.");
        }
    }

    private static boolean isFinalize(MethodTree methodTree) {
        TypeTree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && (returnType = methodTree.returnType()) != null && returnType.is(Tree.Kind.PRIMITIVE_TYPE)) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

