/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2675")
public class ReadObjectSynchronizedCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (ReadObjectSynchronizedCheck.implementsSerializable(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(Tree.Kind.METHOD)) continue;
                this.checkMember((MethodTree)member);
            }
        }
    }

    private void checkMember(MethodTree member) {
        ModifierKeywordTree modifier;
        if (ReadObjectSynchronizedCheck.isReadObject(member) && (modifier = ModifiersUtils.getModifier(member.modifiers(), Modifier.SYNCHRONIZED)) != null) {
            this.reportIssue(modifier.keyword(), "Remove the \"synchronized\" keyword from this method.");
        }
    }

    private static boolean implementsSerializable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean isReadObject(MethodTree methodTree) {
        return "readObject".equals(methodTree.simpleName().name()) && methodTree.parameters().size() == 1 && methodTree.parameters().get(0).type().symbolType().is("java.io.ObjectInputStream");
    }
}

