/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4065")
public class ThreadLocalWithInitialCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final MethodMatchers THREADLOCAL_CONSTRUCTOR = MethodMatchers.create().ofTypes("java.lang.ThreadLocal").constructor().addWithoutParametersMatcher().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return THREADLOCAL_CONSTRUCTOR;
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        ClassTree classTree = newClassTree.classBody();
        if (classTree == null) {
            return;
        }
        List<Tree> members = classTree.members();
        if (members.size() != 1) {
            return;
        }
        members.stream().filter(tree -> tree.is(Tree.Kind.METHOD)).map(MethodTree.class::cast).filter(t -> "initialValue".equals(t.simpleName().name())).filter(t -> t.parameters().isEmpty()).findFirst().ifPresent(t -> this.reportIssue(newClassTree.identifier(), "Replace this anonymous class with a call to \"ThreadLocal.withInitial\"." + this.context.getJavaVersion().java8CompatibilityMessage()));
    }

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }
}

