/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1700")
public class FieldNameMatchingTypeNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private String currentClassName;
    private final Set<Tree> fields = new HashSet<Tree>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.currentClassName = "";
        this.fields.clear();
        if (context.getSemanticModel() != null) {
            this.scan(context.getTree());
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            Symbol.TypeSymbol classSymbol = tree.symbol();
            Collection<Symbol> members = classSymbol.memberSymbols();
            for (Symbol sym : members) {
                if (!sym.isVariableSymbol() || FieldNameMatchingTypeNameCheck.staticFieldSameType(classSymbol, sym)) continue;
                this.fields.add(((Symbol.VariableSymbol)sym).declaration());
            }
            this.currentClassName = simpleName.name();
        }
        super.visitClass(tree);
        this.currentClassName = "";
        this.fields.clear();
    }

    private static boolean staticFieldSameType(Symbol classSymbol, Symbol sym) {
        return sym.type().equals(classSymbol.type()) && sym.isStatic();
    }

    @Override
    public void visitVariable(VariableTree tree) {
        String name = tree.simpleName().name();
        if (this.fields.contains(tree) && this.currentClassName.equalsIgnoreCase(name)) {
            this.context.reportIssue(this, tree.simpleName(), "Rename field \"" + name + "\"");
        }
        super.visitVariable(tree);
    }
}

