/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheckTrackingMatchers;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5860")
public class UnusedGroupNamesCheck
extends AbstractRegexCheckTrackingMatchers {
    private static final String ISSUE_NO_GROUP_WITH_SUCH_NAME = "There is no group named '%s' in the regular expression.";
    private static final String ISSUE_USE_NAME_INSTEAD_OF_NUMBER = "Directly use '%s' instead of its group number.";
    private static final String ISSUE_USE_GROUPS_OR_REMOVE = "Use the named groups of this regex or remove the names.";
    private static final String JAVA_UTIL_REGEX_MATCHER = "java.util.regex.Matcher";
    private static final Pattern GROUP_NUMBER_REPLACEMENT_REGEX = Pattern.compile("(?<!\\\\)\\$(?<number>\\d++)");
    private static final Pattern GROUP_NAME_REPLACEMENT_REGEX = Pattern.compile("(?<!\\\\)\\$\\{(?<name>[A-Za-z][0-9A-Za-z]*+)\\}");
    private static final MethodMatchers MATCHER_GROUP = MethodMatchers.or(MethodMatchers.create().ofTypes("java.util.regex.Matcher").names("group").addParametersMatcher("java.lang.String").addParametersMatcher("int").build(), MethodMatchers.create().ofTypes("java.util.regex.Matcher").names("appendReplacement").addParametersMatcher("*", "*").build(), MethodMatchers.create().ofTypes("java.util.regex.Matcher").names("replaceAll", "replaceFirst").addParametersMatcher("*").build());

    @Override
    protected MethodMatchers trackedMethodMatchers() {
        return MATCHER_GROUP;
    }

    @Override
    protected void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation, List<MethodInvocationTree> trackedMethodsCalled, boolean didEscape) {
        KnownGroupsCollector knownGroups = UnusedGroupNamesCheck.collectGroups(regexForLiterals);
        ArrayList namedGroups = new ArrayList(knownGroups.groupsByName.values());
        if (trackedMethodsCalled.isEmpty() && !didEscape && !namedGroups.isEmpty() && !knownGroups.usesBackReferences) {
            List<RegexCheck.RegexIssueLocation> secondaries = namedGroups.stream().map(group -> UnusedGroupNamesCheck.toLocation(group, "Named group '%s'", g -> g.getName().get())).collect(Collectors.toList());
            this.reportIssue((RegexSyntaxElement)namedGroups.get(0), ISSUE_USE_GROUPS_OR_REMOVE, null, secondaries);
        }
        for (MethodInvocationTree groupInvocation : trackedMethodsCalled) {
            this.checkGroupUsage(groupInvocation, knownGroups);
        }
    }

    private void checkGroupUsage(MethodInvocationTree mit, KnownGroupsCollector knownGroups) {
        String methodName = ExpressionUtils.methodName(mit).name();
        if ("group".equals(methodName)) {
            ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
            if (arg0.symbolType().is("int")) {
                arg0.asConstant(Integer.class).ifPresent(index -> this.checkUsingNumberInsteadOfName(knownGroups, arg0, (int)index, false));
            } else {
                arg0.asConstant(String.class).ifPresent(name -> this.checkNoSuchName(knownGroups, arg0, (String)name));
            }
        } else {
            int argIndex = "appendReplacement".equals(methodName) ? 1 : 0;
            ExpressionTree arg = (ExpressionTree)mit.arguments().get(argIndex);
            arg.asConstant(String.class).ifPresent(replacement -> this.checkUsingReplacementString(knownGroups, arg, (String)replacement));
        }
    }

    private void checkUsingReplacementString(KnownGroupsCollector knownGroups, ExpressionTree arg, String replacement) {
        Matcher indexMatcher = GROUP_NUMBER_REPLACEMENT_REGEX.matcher(replacement);
        while (indexMatcher.find()) {
            int groupNumber = Integer.parseInt(indexMatcher.group("number"));
            this.checkUsingNumberInsteadOfName(knownGroups, arg, groupNumber, true);
        }
        Matcher nameMatcher = GROUP_NAME_REPLACEMENT_REGEX.matcher(replacement);
        while (nameMatcher.find()) {
            this.checkNoSuchName(knownGroups, arg, nameMatcher.group("name"));
        }
    }

    private void checkUsingNumberInsteadOfName(KnownGroupsCollector knownGroups, ExpressionTree arg0, int groupNumber, boolean dollarReference) {
        CapturingGroupTree capturingGroupTree = (CapturingGroupTree)knownGroups.groupsByNumber.get(groupNumber);
        if (capturingGroupTree == null) {
            return;
        }
        String groupName = capturingGroupTree.getName().map(name -> dollarReference ? "${" + name + "}" : name).orElse("?");
        String message = String.format(ISSUE_USE_NAME_INSTEAD_OF_NUMBER, groupName);
        RegexCheck.RegexIssueLocation secondary = UnusedGroupNamesCheck.toLocation(capturingGroupTree, "Group %d", g -> groupNumber);
        this.reportIssue((Tree)arg0, message, null, Collections.singletonList(secondary));
    }

    private void checkNoSuchName(KnownGroupsCollector knownGroups, ExpressionTree arg0, String groupName) {
        if (!knownGroups.groupsByName.containsKey(groupName)) {
            String message = String.format(ISSUE_NO_GROUP_WITH_SUCH_NAME, groupName);
            List<RegexCheck.RegexIssueLocation> secondaries = knownGroups.groupsByName.values().stream().map(group -> UnusedGroupNamesCheck.toLocation(group, "Named group '%s'", g -> g.getName().get())).collect(Collectors.toList());
            this.reportIssue((Tree)arg0, message, null, secondaries);
        }
    }

    private static RegexCheck.RegexIssueLocation toLocation(CapturingGroupTree group, String message, Function<CapturingGroupTree, Object> arg) {
        return new RegexCheck.RegexIssueLocation(group, String.format(message, arg.apply(group)));
    }

    private static KnownGroupsCollector collectGroups(RegexParseResult regex) {
        KnownGroupsCollector visitor = new KnownGroupsCollector();
        visitor.visit(regex);
        return visitor;
    }

    private static class KnownGroupsCollector
    extends RegexBaseVisitor {
        private final Map<String, CapturingGroupTree> groupsByName = new HashMap<String, CapturingGroupTree>();
        private final Map<Integer, CapturingGroupTree> groupsByNumber = new HashMap<Integer, CapturingGroupTree>();
        private boolean usesBackReferences = false;

        private KnownGroupsCollector() {
        }

        @Override
        public void visitCapturingGroup(CapturingGroupTree tree) {
            tree.getName().ifPresent(name -> {
                this.groupsByName.put((String)name, tree);
                this.groupsByNumber.put(tree.getGroupNumber(), tree);
            });
            super.visitCapturingGroup(tree);
        }

        @Override
        public void visitBackReference(BackReferenceTree tree) {
            this.usesBackReferences = true;
            super.visitBackReference(tree);
        }
    }
}

