/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class PackageUtils {
    private PackageUtils() {
    }

    public static String packageName(@Nullable PackageDeclarationTree packageDeclarationTree, String separator) {
        if (packageDeclarationTree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = packageDeclarationTree.packageName();
        while (expr.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(separator);
            expr = mse.expression();
        }
        if (expr.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

