/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api.semantic;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public interface Symbol {
    public String name();

    @Nullable
    public Symbol owner();

    public Type type();

    public boolean isVariableSymbol();

    public boolean isTypeSymbol();

    public boolean isMethodSymbol();

    public boolean isPackageSymbol();

    public boolean isStatic();

    public boolean isFinal();

    public boolean isEnum();

    public boolean isInterface();

    public boolean isAbstract();

    public boolean isPublic();

    public boolean isPrivate();

    public boolean isProtected();

    public boolean isPackageVisibility();

    public boolean isDeprecated();

    public boolean isVolatile();

    public boolean isUnknown();

    public SymbolMetadata metadata();

    @Nullable
    public TypeSymbol enclosingClass();

    public List<IdentifierTree> usages();

    @Nullable
    public Tree declaration();

    public static interface LabelSymbol {
        public String name();

        public List<IdentifierTree> usages();

        public LabeledStatementTree declaration();
    }

    public static interface MethodSymbol
    extends Symbol {
        public List<Type> parameterTypes();

        public TypeSymbol returnType();

        public List<Type> thrownTypes();

        @Nullable
        @Deprecated
        public MethodSymbol overriddenSymbol();

        public List<MethodSymbol> overriddenSymbols();

        @Override
        @Nullable
        public MethodTree declaration();

        public String signature();
    }

    public static interface VariableSymbol
    extends Symbol {
        @Override
        @Nullable
        public VariableTree declaration();
    }

    public static interface TypeSymbol
    extends Symbol {
        @CheckForNull
        public Type superClass();

        public List<Type> interfaces();

        public Collection<Symbol> memberSymbols();

        public Collection<Symbol> lookupSymbols(String var1);

        @Override
        @Nullable
        public ClassTree declaration();
    }
}

