/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class BackReferenceTree
extends RegexTree {
    private final String groupName;
    @Nullable
    private final SourceCharacter key;
    @Nullable
    private CapturingGroupTree group;

    public BackReferenceTree(RegexSource source, SourceCharacter backslash, @Nullable SourceCharacter key, SourceCharacter start, SourceCharacter end, FlagSet activeFlags) {
        super(source, backslash.getRange().merge(end.getRange()), activeFlags);
        this.key = key;
        this.groupName = start.getCharacter() != '<' ? source.substringAt(start.getRange().merge(end.getRange())) : source.substringAt(new IndexRange(start.getRange().getBeginningOffset() + 1, end.getRange().getBeginningOffset()));
    }

    public void setGroup(@Nullable CapturingGroupTree group) {
        this.group = group;
    }

    @Nullable
    public CapturingGroupTree group() {
        return this.group;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitBackReference(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.BACK_REFERENCE;
    }

    public boolean isNamedGroup() {
        return this.key != null;
    }

    public boolean isNumerical() {
        return this.key == null;
    }

    public String groupName() {
        return this.groupName;
    }

    public int groupNumber() {
        if (!this.isNumerical()) {
            return -1;
        }
        return Integer.parseInt(this.groupName);
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.BACK_REFERENCE;
    }
}

