/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexCommentAnalyser;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

@Rule(key="CommentedCode")
public class CommentedCodeCheck
extends FlexCheck {
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, new FlexRecognizer());
    private final Pattern regexpToDivideStringByLine = Pattern.compile("(\r?\n)|(\r)");

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitToken(Token token) {
        block0: for (Trivia trivia : token.getTrivia()) {
            String[] lines = this.regexpToDivideStringByLine.split(FlexCommentAnalyser.getContents(trivia.getToken().getOriginalValue()));
            for (int lineOffset = 0; lineOffset < lines.length; ++lineOffset) {
                if (!this.codeRecognizer.isLineOfCode(lines[lineOffset])) continue;
                this.addIssueAtLine("Sections of code should not be \"commented out\".", trivia.getToken().getLine() + lineOffset);
                continue block0;
            }
        }
    }

    private static class FlexRecognizer
    implements LanguageFootprint {
        private FlexRecognizer() {
        }

        @Override
        public Set<Detector> getDetectors() {
            return ImmutableSet.of(new EndWithDetector(0.95, '}', ';', '{'), new KeywordsDetector(0.3, FlexKeyword.keywordValues()), new ContainsDetector(0.95, "++", "--"), new ContainsDetector(0.95, "*=", "/=", "%=", "+=", "-=", "<<=", ">>=", ">>>=", "&=", "^=", "|="), new ContainsDetector(0.95, "==", "!=", "===", "!=="));
        }
    }
}

